/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.DataInputStream;
import java.io.StringBufferInputStream;
import org.jmol.jvxl.readers.MapFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.BinaryDocument;
import org.jmol.util.Logger;

class Dsn6BinaryReader
extends MapFileReader {
    private float byteFactor;
    private int xyCount;
    private int nBrickX;
    private int nBrickY;
    private int brickLayerVoxelCount;
    private int brickLayerByteCount;
    private int brickRowByteCount;
    private byte[] brickLayer;
    private int pt;

    Dsn6BinaryReader(SurfaceGenerator surfaceGenerator, String string, String string2, boolean bl) {
        super(surfaceGenerator, null);
        this.binarydoc = new BinaryDocument();
        if (string2 == null) {
            this.binarydoc.setStream(surfaceGenerator.getAtomDataServer().getBufferedInputStream(string), bl);
        } else {
            this.binarydoc.setStream(new DataInputStream(new StringBufferInputStream(string2)));
        }
        if (this.params.thePlane == null) {
            this.params.insideOut = !this.params.insideOut;
        }
        this.nSurfaces = 1;
    }

    protected void readParameters() throws Exception {
        this.nxyzStart[0] = this.binarydoc.readShort();
        this.nxyzStart[1] = this.binarydoc.readShort();
        this.nxyzStart[2] = this.binarydoc.readShort();
        this.nx = this.binarydoc.readShort();
        this.ny = this.binarydoc.readShort();
        this.nz = this.binarydoc.readShort();
        this.na = this.binarydoc.readShort();
        this.nb = this.binarydoc.readShort();
        this.nc = this.binarydoc.readShort();
        this.a = this.binarydoc.readShort();
        this.b = this.binarydoc.readShort();
        this.c = this.binarydoc.readShort();
        this.alpha = this.binarydoc.readShort();
        this.beta = this.binarydoc.readShort();
        this.gamma = this.binarydoc.readShort();
        this.maps = 3;
        this.mapr = 2;
        this.mapc = 1;
        float f = this.binarydoc.readShort();
        float f2 = this.binarydoc.readShort();
        float f3 = this.binarydoc.readShort();
        float f4 = this.binarydoc.readShort();
        this.dmin = (0.0f - f2) * f4 / f;
        this.dmax = (255.0f - f2) * f4 / f;
        this.drange = this.dmax - this.dmin;
        this.byteFactor = this.drange / 255.0f;
        float f5 = (0.0f - f2 - 0.5f) * f4 / (f - 0.5f);
        float f6 = (0.0f - f2 + 0.5f) * f4 / (f + 0.5f);
        float f7 = (255.0f - f2 - 0.5f) * f4 / (f - 0.5f);
        float f8 = (255.0f - f2 + 0.5f) * f4 / (f + 0.5f);
        float f9 = (float)((int)((f6 - f5) / 0.002f)) * 0.001f;
        float f10 = (float)((int)((f8 - f7) / 0.002f)) * 0.001f;
        Logger.info("DNS6 dmin,dmax = " + this.dmin + "+/-" + f9 + "," + this.dmax + "+/-" + f10);
        this.a /= f3;
        this.b /= f3;
        this.c /= f3;
        this.alpha /= f3;
        this.beta /= f3;
        this.gamma /= f3;
        this.binarydoc.seek(512L);
        this.getVectorsAndOrigin();
        this.setCutoffAutomatic();
        this.xyCount = this.nx * this.ny;
        this.brickLayerVoxelCount = this.xyCount * 8;
        this.nBrickX = (this.nx + 7) / 8;
        this.nBrickY = (this.ny + 7) / 8;
        this.brickRowByteCount = this.nBrickX * 512;
        this.brickLayerByteCount = this.brickRowByteCount * this.nBrickY;
        this.brickLayer = new byte[this.brickLayerByteCount];
        this.jvxlFileHeaderBuffer = new StringBuffer();
        this.jvxlFileHeaderBuffer.append("DNS6/O progressive brick data reader\n");
        this.jvxlFileHeaderBuffer.append("see http://www.uoxray.uoregon.edu/tnt/manual/node104.html\n");
    }

    private void readBrickLayer() throws Exception {
        this.binarydoc.readByteArray(this.brickLayer);
        this.pt = 0;
        this.nBytes = this.binarydoc.getPosition();
    }

    private float getBrickValue(int n) {
        int n2 = n / this.nx % this.ny;
        int n3 = n2 / 8;
        int n4 = n % this.nx;
        int n5 = n4 / 8;
        int n6 = n / this.xyCount;
        int n7 = n6 % 8;
        int n8 = n2 % 8;
        int n9 = n4 % 8;
        int n10 = n3 * 512 * this.nBrickX + n5 * 512 + n7 * 64 + n8 * 8 + n9;
        n10 = n10 % 2 == 0 ? ++n10 : --n10;
        float f = (this.brickLayer[n10] + 256) % 256;
        return this.dmin + f * this.byteFactor;
    }

    protected float nextVoxel() throws Exception {
        if (this.pt % this.brickLayerVoxelCount == 0) {
            this.readBrickLayer();
        }
        return this.getBrickValue(this.pt++);
    }

    protected void skipData(int n) throws Exception {
        for (int i = 0; i < n; ++i) {
            this.binarydoc.readByte();
        }
    }
}

