// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_ZIP2_2D_TRACE_AARCH64_H_
#define VIXL_SIM_ZIP2_2D_TRACE_AARCH64_H_

const uint64_t kExpected_NEON_zip2_2D[] = {
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000000, 0x0000000000000040,
  0x0000000000000000, 0x000000000000007d,
  0x0000000000000000, 0x000000000000007e,
  0x0000000000000000, 0x000000000000007f,
  0x0000000000000000, 0x0000000000007ffd,
  0x0000000000000000, 0x0000000000007ffe,
  0x0000000000000000, 0x0000000000007fff,
  0x0000000000000000, 0x000000007ffffffd,
  0x0000000000000000, 0x000000007ffffffe,
  0x0000000000000000, 0x000000007fffffff,
  0x0000000000000000, 0x3333333333333333,
  0x0000000000000000, 0x5555555555555555,
  0x0000000000000000, 0x7ffffffffffffffd,
  0x0000000000000000, 0x7ffffffffffffffe,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000001,
  0x0000000000000000, 0x8000000000000002,
  0x0000000000000000, 0x8000000000000003,
  0x0000000000000000, 0xaaaaaaaaaaaaaaaa,
  0x0000000000000000, 0xcccccccccccccccc,
  0x0000000000000000, 0xffffffff80000000,
  0x0000000000000000, 0xffffffff80000001,
  0x0000000000000000, 0xffffffff80000002,
  0x0000000000000000, 0xffffffff80000003,
  0x0000000000000000, 0xffffffffffff8000,
  0x0000000000000000, 0xffffffffffff8001,
  0x0000000000000000, 0xffffffffffff8002,
  0x0000000000000000, 0xffffffffffff8003,
  0x0000000000000000, 0xffffffffffffff80,
  0x0000000000000000, 0xffffffffffffff81,
  0x0000000000000000, 0xffffffffffffff82,
  0x0000000000000000, 0xffffffffffffff83,
  0x0000000000000000, 0xffffffffffffffc0,
  0x0000000000000000, 0xfffffffffffffffd,
  0x0000000000000000, 0xfffffffffffffffe,
  0x0000000000000000, 0xffffffffffffffff,
  0x0000000000000001, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000001, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000040,
  0x0000000000000001, 0x000000000000007d,
  0x0000000000000001, 0x000000000000007e,
  0x0000000000000001, 0x000000000000007f,
  0x0000000000000001, 0x0000000000007ffd,
  0x0000000000000001, 0x0000000000007ffe,
  0x0000000000000001, 0x0000000000007fff,
  0x0000000000000001, 0x000000007ffffffd,
  0x0000000000000001, 0x000000007ffffffe,
  0x0000000000000001, 0x000000007fffffff,
  0x0000000000000001, 0x3333333333333333,
  0x0000000000000001, 0x5555555555555555,
  0x0000000000000001, 0x7ffffffffffffffd,
  0x0000000000000001, 0x7ffffffffffffffe,
  0x0000000000000001, 0x7fffffffffffffff,
  0x0000000000000001, 0x8000000000000000,
  0x0000000000000001, 0x8000000000000001,
  0x0000000000000001, 0x8000000000000002,
  0x0000000000000001, 0x8000000000000003,
  0x0000000000000001, 0xaaaaaaaaaaaaaaaa,
  0x0000000000000001, 0xcccccccccccccccc,
  0x0000000000000001, 0xffffffff80000000,
  0x0000000000000001, 0xffffffff80000001,
  0x0000000000000001, 0xffffffff80000002,
  0x0000000000000001, 0xffffffff80000003,
  0x0000000000000001, 0xffffffffffff8000,
  0x0000000000000001, 0xffffffffffff8001,
  0x0000000000000001, 0xffffffffffff8002,
  0x0000000000000001, 0xffffffffffff8003,
  0x0000000000000001, 0xffffffffffffff80,
  0x0000000000000001, 0xffffffffffffff81,
  0x0000000000000001, 0xffffffffffffff82,
  0x0000000000000001, 0xffffffffffffff83,
  0x0000000000000001, 0xffffffffffffffc0,
  0x0000000000000001, 0xfffffffffffffffd,
  0x0000000000000001, 0xfffffffffffffffe,
  0x0000000000000001, 0xffffffffffffffff,
  0x0000000000000002, 0x0000000000000000,
  0x0000000000000002, 0x0000000000000001,
  0x0000000000000002, 0x0000000000000002,
  0x0000000000000002, 0x0000000000000040,
  0x0000000000000002, 0x000000000000007d,
  0x0000000000000002, 0x000000000000007e,
  0x0000000000000002, 0x000000000000007f,
  0x0000000000000002, 0x0000000000007ffd,
  0x0000000000000002, 0x0000000000007ffe,
  0x0000000000000002, 0x0000000000007fff,
  0x0000000000000002, 0x000000007ffffffd,
  0x0000000000000002, 0x000000007ffffffe,
  0x0000000000000002, 0x000000007fffffff,
  0x0000000000000002, 0x3333333333333333,
  0x0000000000000002, 0x5555555555555555,
  0x0000000000000002, 0x7ffffffffffffffd,
  0x0000000000000002, 0x7ffffffffffffffe,
  0x0000000000000002, 0x7fffffffffffffff,
  0x0000000000000002, 0x8000000000000000,
  0x0000000000000002, 0x8000000000000001,
  0x0000000000000002, 0x8000000000000002,
  0x0000000000000002, 0x8000000000000003,
  0x0000000000000002, 0xaaaaaaaaaaaaaaaa,
  0x0000000000000002, 0xcccccccccccccccc,
  0x0000000000000002, 0xffffffff80000000,
  0x0000000000000002, 0xffffffff80000001,
  0x0000000000000002, 0xffffffff80000002,
  0x0000000000000002, 0xffffffff80000003,
  0x0000000000000002, 0xffffffffffff8000,
  0x0000000000000002, 0xffffffffffff8001,
  0x0000000000000002, 0xffffffffffff8002,
  0x0000000000000002, 0xffffffffffff8003,
  0x0000000000000002, 0xffffffffffffff80,
  0x0000000000000002, 0xffffffffffffff81,
  0x0000000000000002, 0xffffffffffffff82,
  0x0000000000000002, 0xffffffffffffff83,
  0x0000000000000002, 0xffffffffffffffc0,
  0x0000000000000002, 0xfffffffffffffffd,
  0x0000000000000002, 0xfffffffffffffffe,
  0x0000000000000002, 0xffffffffffffffff,
  0x0000000000000040, 0x0000000000000000,
  0x0000000000000040, 0x0000000000000001,
  0x0000000000000040, 0x0000000000000002,
  0x0000000000000040, 0x0000000000000040,
  0x0000000000000040, 0x000000000000007d,
  0x0000000000000040, 0x000000000000007e,
  0x0000000000000040, 0x000000000000007f,
  0x0000000000000040, 0x0000000000007ffd,
  0x0000000000000040, 0x0000000000007ffe,
  0x0000000000000040, 0x0000000000007fff,
  0x0000000000000040, 0x000000007ffffffd,
  0x0000000000000040, 0x000000007ffffffe,
  0x0000000000000040, 0x000000007fffffff,
  0x0000000000000040, 0x3333333333333333,
  0x0000000000000040, 0x5555555555555555,
  0x0000000000000040, 0x7ffffffffffffffd,
  0x0000000000000040, 0x7ffffffffffffffe,
  0x0000000000000040, 0x7fffffffffffffff,
  0x0000000000000040, 0x8000000000000000,
  0x0000000000000040, 0x8000000000000001,
  0x0000000000000040, 0x8000000000000002,
  0x0000000000000040, 0x8000000000000003,
  0x0000000000000040, 0xaaaaaaaaaaaaaaaa,
  0x0000000000000040, 0xcccccccccccccccc,
  0x0000000000000040, 0xffffffff80000000,
  0x0000000000000040, 0xffffffff80000001,
  0x0000000000000040, 0xffffffff80000002,
  0x0000000000000040, 0xffffffff80000003,
  0x0000000000000040, 0xffffffffffff8000,
  0x0000000000000040, 0xffffffffffff8001,
  0x0000000000000040, 0xffffffffffff8002,
  0x0000000000000040, 0xffffffffffff8003,
  0x0000000000000040, 0xffffffffffffff80,
  0x0000000000000040, 0xffffffffffffff81,
  0x0000000000000040, 0xffffffffffffff82,
  0x0000000000000040, 0xffffffffffffff83,
  0x0000000000000040, 0xffffffffffffffc0,
  0x0000000000000040, 0xfffffffffffffffd,
  0x0000000000000040, 0xfffffffffffffffe,
  0x0000000000000040, 0xffffffffffffffff,
  0x000000000000007d, 0x0000000000000000,
  0x000000000000007d, 0x0000000000000001,
  0x000000000000007d, 0x0000000000000002,
  0x000000000000007d, 0x0000000000000040,
  0x000000000000007d, 0x000000000000007d,
  0x000000000000007d, 0x000000000000007e,
  0x000000000000007d, 0x000000000000007f,
  0x000000000000007d, 0x0000000000007ffd,
  0x000000000000007d, 0x0000000000007ffe,
  0x000000000000007d, 0x0000000000007fff,
  0x000000000000007d, 0x000000007ffffffd,
  0x000000000000007d, 0x000000007ffffffe,
  0x000000000000007d, 0x000000007fffffff,
  0x000000000000007d, 0x3333333333333333,
  0x000000000000007d, 0x5555555555555555,
  0x000000000000007d, 0x7ffffffffffffffd,
  0x000000000000007d, 0x7ffffffffffffffe,
  0x000000000000007d, 0x7fffffffffffffff,
  0x000000000000007d, 0x8000000000000000,
  0x000000000000007d, 0x8000000000000001,
  0x000000000000007d, 0x8000000000000002,
  0x000000000000007d, 0x8000000000000003,
  0x000000000000007d, 0xaaaaaaaaaaaaaaaa,
  0x000000000000007d, 0xcccccccccccccccc,
  0x000000000000007d, 0xffffffff80000000,
  0x000000000000007d, 0xffffffff80000001,
  0x000000000000007d, 0xffffffff80000002,
  0x000000000000007d, 0xffffffff80000003,
  0x000000000000007d, 0xffffffffffff8000,
  0x000000000000007d, 0xffffffffffff8001,
  0x000000000000007d, 0xffffffffffff8002,
  0x000000000000007d, 0xffffffffffff8003,
  0x000000000000007d, 0xffffffffffffff80,
  0x000000000000007d, 0xffffffffffffff81,
  0x000000000000007d, 0xffffffffffffff82,
  0x000000000000007d, 0xffffffffffffff83,
  0x000000000000007d, 0xffffffffffffffc0,
  0x000000000000007d, 0xfffffffffffffffd,
  0x000000000000007d, 0xfffffffffffffffe,
  0x000000000000007d, 0xffffffffffffffff,
  0x000000000000007e, 0x0000000000000000,
  0x000000000000007e, 0x0000000000000001,
  0x000000000000007e, 0x0000000000000002,
  0x000000000000007e, 0x0000000000000040,
  0x000000000000007e, 0x000000000000007d,
  0x000000000000007e, 0x000000000000007e,
  0x000000000000007e, 0x000000000000007f,
  0x000000000000007e, 0x0000000000007ffd,
  0x000000000000007e, 0x0000000000007ffe,
  0x000000000000007e, 0x0000000000007fff,
  0x000000000000007e, 0x000000007ffffffd,
  0x000000000000007e, 0x000000007ffffffe,
  0x000000000000007e, 0x000000007fffffff,
  0x000000000000007e, 0x3333333333333333,
  0x000000000000007e, 0x5555555555555555,
  0x000000000000007e, 0x7ffffffffffffffd,
  0x000000000000007e, 0x7ffffffffffffffe,
  0x000000000000007e, 0x7fffffffffffffff,
  0x000000000000007e, 0x8000000000000000,
  0x000000000000007e, 0x8000000000000001,
  0x000000000000007e, 0x8000000000000002,
  0x000000000000007e, 0x8000000000000003,
  0x000000000000007e, 0xaaaaaaaaaaaaaaaa,
  0x000000000000007e, 0xcccccccccccccccc,
  0x000000000000007e, 0xffffffff80000000,
  0x000000000000007e, 0xffffffff80000001,
  0x000000000000007e, 0xffffffff80000002,
  0x000000000000007e, 0xffffffff80000003,
  0x000000000000007e, 0xffffffffffff8000,
  0x000000000000007e, 0xffffffffffff8001,
  0x000000000000007e, 0xffffffffffff8002,
  0x000000000000007e, 0xffffffffffff8003,
  0x000000000000007e, 0xffffffffffffff80,
  0x000000000000007e, 0xffffffffffffff81,
  0x000000000000007e, 0xffffffffffffff82,
  0x000000000000007e, 0xffffffffffffff83,
  0x000000000000007e, 0xffffffffffffffc0,
  0x000000000000007e, 0xfffffffffffffffd,
  0x000000000000007e, 0xfffffffffffffffe,
  0x000000000000007e, 0xffffffffffffffff,
  0x000000000000007f, 0x0000000000000000,
  0x000000000000007f, 0x0000000000000001,
  0x000000000000007f, 0x0000000000000002,
  0x000000000000007f, 0x0000000000000040,
  0x000000000000007f, 0x000000000000007d,
  0x000000000000007f, 0x000000000000007e,
  0x000000000000007f, 0x000000000000007f,
  0x000000000000007f, 0x0000000000007ffd,
  0x000000000000007f, 0x0000000000007ffe,
  0x000000000000007f, 0x0000000000007fff,
  0x000000000000007f, 0x000000007ffffffd,
  0x000000000000007f, 0x000000007ffffffe,
  0x000000000000007f, 0x000000007fffffff,
  0x000000000000007f, 0x3333333333333333,
  0x000000000000007f, 0x5555555555555555,
  0x000000000000007f, 0x7ffffffffffffffd,
  0x000000000000007f, 0x7ffffffffffffffe,
  0x000000000000007f, 0x7fffffffffffffff,
  0x000000000000007f, 0x8000000000000000,
  0x000000000000007f, 0x8000000000000001,
  0x000000000000007f, 0x8000000000000002,
  0x000000000000007f, 0x8000000000000003,
  0x000000000000007f, 0xaaaaaaaaaaaaaaaa,
  0x000000000000007f, 0xcccccccccccccccc,
  0x000000000000007f, 0xffffffff80000000,
  0x000000000000007f, 0xffffffff80000001,
  0x000000000000007f, 0xffffffff80000002,
  0x000000000000007f, 0xffffffff80000003,
  0x000000000000007f, 0xffffffffffff8000,
  0x000000000000007f, 0xffffffffffff8001,
  0x000000000000007f, 0xffffffffffff8002,
  0x000000000000007f, 0xffffffffffff8003,
  0x000000000000007f, 0xffffffffffffff80,
  0x000000000000007f, 0xffffffffffffff81,
  0x000000000000007f, 0xffffffffffffff82,
  0x000000000000007f, 0xffffffffffffff83,
  0x000000000000007f, 0xffffffffffffffc0,
  0x000000000000007f, 0xfffffffffffffffd,
  0x000000000000007f, 0xfffffffffffffffe,
  0x000000000000007f, 0xffffffffffffffff,
  0x0000000000007ffd, 0x0000000000000000,
  0x0000000000007ffd, 0x0000000000000001,
  0x0000000000007ffd, 0x0000000000000002,
  0x0000000000007ffd, 0x0000000000000040,
  0x0000000000007ffd, 0x000000000000007d,
  0x0000000000007ffd, 0x000000000000007e,
  0x0000000000007ffd, 0x000000000000007f,
  0x0000000000007ffd, 0x0000000000007ffd,
  0x0000000000007ffd, 0x0000000000007ffe,
  0x0000000000007ffd, 0x0000000000007fff,
  0x0000000000007ffd, 0x000000007ffffffd,
  0x0000000000007ffd, 0x000000007ffffffe,
  0x0000000000007ffd, 0x000000007fffffff,
  0x0000000000007ffd, 0x3333333333333333,
  0x0000000000007ffd, 0x5555555555555555,
  0x0000000000007ffd, 0x7ffffffffffffffd,
  0x0000000000007ffd, 0x7ffffffffffffffe,
  0x0000000000007ffd, 0x7fffffffffffffff,
  0x0000000000007ffd, 0x8000000000000000,
  0x0000000000007ffd, 0x8000000000000001,
  0x0000000000007ffd, 0x8000000000000002,
  0x0000000000007ffd, 0x8000000000000003,
  0x0000000000007ffd, 0xaaaaaaaaaaaaaaaa,
  0x0000000000007ffd, 0xcccccccccccccccc,
  0x0000000000007ffd, 0xffffffff80000000,
  0x0000000000007ffd, 0xffffffff80000001,
  0x0000000000007ffd, 0xffffffff80000002,
  0x0000000000007ffd, 0xffffffff80000003,
  0x0000000000007ffd, 0xffffffffffff8000,
  0x0000000000007ffd, 0xffffffffffff8001,
  0x0000000000007ffd, 0xffffffffffff8002,
  0x0000000000007ffd, 0xffffffffffff8003,
  0x0000000000007ffd, 0xffffffffffffff80,
  0x0000000000007ffd, 0xffffffffffffff81,
  0x0000000000007ffd, 0xffffffffffffff82,
  0x0000000000007ffd, 0xffffffffffffff83,
  0x0000000000007ffd, 0xffffffffffffffc0,
  0x0000000000007ffd, 0xfffffffffffffffd,
  0x0000000000007ffd, 0xfffffffffffffffe,
  0x0000000000007ffd, 0xffffffffffffffff,
  0x0000000000007ffe, 0x0000000000000000,
  0x0000000000007ffe, 0x0000000000000001,
  0x0000000000007ffe, 0x0000000000000002,
  0x0000000000007ffe, 0x0000000000000040,
  0x0000000000007ffe, 0x000000000000007d,
  0x0000000000007ffe, 0x000000000000007e,
  0x0000000000007ffe, 0x000000000000007f,
  0x0000000000007ffe, 0x0000000000007ffd,
  0x0000000000007ffe, 0x0000000000007ffe,
  0x0000000000007ffe, 0x0000000000007fff,
  0x0000000000007ffe, 0x000000007ffffffd,
  0x0000000000007ffe, 0x000000007ffffffe,
  0x0000000000007ffe, 0x000000007fffffff,
  0x0000000000007ffe, 0x3333333333333333,
  0x0000000000007ffe, 0x5555555555555555,
  0x0000000000007ffe, 0x7ffffffffffffffd,
  0x0000000000007ffe, 0x7ffffffffffffffe,
  0x0000000000007ffe, 0x7fffffffffffffff,
  0x0000000000007ffe, 0x8000000000000000,
  0x0000000000007ffe, 0x8000000000000001,
  0x0000000000007ffe, 0x8000000000000002,
  0x0000000000007ffe, 0x8000000000000003,
  0x0000000000007ffe, 0xaaaaaaaaaaaaaaaa,
  0x0000000000007ffe, 0xcccccccccccccccc,
  0x0000000000007ffe, 0xffffffff80000000,
  0x0000000000007ffe, 0xffffffff80000001,
  0x0000000000007ffe, 0xffffffff80000002,
  0x0000000000007ffe, 0xffffffff80000003,
  0x0000000000007ffe, 0xffffffffffff8000,
  0x0000000000007ffe, 0xffffffffffff8001,
  0x0000000000007ffe, 0xffffffffffff8002,
  0x0000000000007ffe, 0xffffffffffff8003,
  0x0000000000007ffe, 0xffffffffffffff80,
  0x0000000000007ffe, 0xffffffffffffff81,
  0x0000000000007ffe, 0xffffffffffffff82,
  0x0000000000007ffe, 0xffffffffffffff83,
  0x0000000000007ffe, 0xffffffffffffffc0,
  0x0000000000007ffe, 0xfffffffffffffffd,
  0x0000000000007ffe, 0xfffffffffffffffe,
  0x0000000000007ffe, 0xffffffffffffffff,
  0x0000000000007fff, 0x0000000000000000,
  0x0000000000007fff, 0x0000000000000001,
  0x0000000000007fff, 0x0000000000000002,
  0x0000000000007fff, 0x0000000000000040,
  0x0000000000007fff, 0x000000000000007d,
  0x0000000000007fff, 0x000000000000007e,
  0x0000000000007fff, 0x000000000000007f,
  0x0000000000007fff, 0x0000000000007ffd,
  0x0000000000007fff, 0x0000000000007ffe,
  0x0000000000007fff, 0x0000000000007fff,
  0x0000000000007fff, 0x000000007ffffffd,
  0x0000000000007fff, 0x000000007ffffffe,
  0x0000000000007fff, 0x000000007fffffff,
  0x0000000000007fff, 0x3333333333333333,
  0x0000000000007fff, 0x5555555555555555,
  0x0000000000007fff, 0x7ffffffffffffffd,
  0x0000000000007fff, 0x7ffffffffffffffe,
  0x0000000000007fff, 0x7fffffffffffffff,
  0x0000000000007fff, 0x8000000000000000,
  0x0000000000007fff, 0x8000000000000001,
  0x0000000000007fff, 0x8000000000000002,
  0x0000000000007fff, 0x8000000000000003,
  0x0000000000007fff, 0xaaaaaaaaaaaaaaaa,
  0x0000000000007fff, 0xcccccccccccccccc,
  0x0000000000007fff, 0xffffffff80000000,
  0x0000000000007fff, 0xffffffff80000001,
  0x0000000000007fff, 0xffffffff80000002,
  0x0000000000007fff, 0xffffffff80000003,
  0x0000000000007fff, 0xffffffffffff8000,
  0x0000000000007fff, 0xffffffffffff8001,
  0x0000000000007fff, 0xffffffffffff8002,
  0x0000000000007fff, 0xffffffffffff8003,
  0x0000000000007fff, 0xffffffffffffff80,
  0x0000000000007fff, 0xffffffffffffff81,
  0x0000000000007fff, 0xffffffffffffff82,
  0x0000000000007fff, 0xffffffffffffff83,
  0x0000000000007fff, 0xffffffffffffffc0,
  0x0000000000007fff, 0xfffffffffffffffd,
  0x0000000000007fff, 0xfffffffffffffffe,
  0x0000000000007fff, 0xffffffffffffffff,
  0x000000007ffffffd, 0x0000000000000000,
  0x000000007ffffffd, 0x0000000000000001,
  0x000000007ffffffd, 0x0000000000000002,
  0x000000007ffffffd, 0x0000000000000040,
  0x000000007ffffffd, 0x000000000000007d,
  0x000000007ffffffd, 0x000000000000007e,
  0x000000007ffffffd, 0x000000000000007f,
  0x000000007ffffffd, 0x0000000000007ffd,
  0x000000007ffffffd, 0x0000000000007ffe,
  0x000000007ffffffd, 0x0000000000007fff,
  0x000000007ffffffd, 0x000000007ffffffd,
  0x000000007ffffffd, 0x000000007ffffffe,
  0x000000007ffffffd, 0x000000007fffffff,
  0x000000007ffffffd, 0x3333333333333333,
  0x000000007ffffffd, 0x5555555555555555,
  0x000000007ffffffd, 0x7ffffffffffffffd,
  0x000000007ffffffd, 0x7ffffffffffffffe,
  0x000000007ffffffd, 0x7fffffffffffffff,
  0x000000007ffffffd, 0x8000000000000000,
  0x000000007ffffffd, 0x8000000000000001,
  0x000000007ffffffd, 0x8000000000000002,
  0x000000007ffffffd, 0x8000000000000003,
  0x000000007ffffffd, 0xaaaaaaaaaaaaaaaa,
  0x000000007ffffffd, 0xcccccccccccccccc,
  0x000000007ffffffd, 0xffffffff80000000,
  0x000000007ffffffd, 0xffffffff80000001,
  0x000000007ffffffd, 0xffffffff80000002,
  0x000000007ffffffd, 0xffffffff80000003,
  0x000000007ffffffd, 0xffffffffffff8000,
  0x000000007ffffffd, 0xffffffffffff8001,
  0x000000007ffffffd, 0xffffffffffff8002,
  0x000000007ffffffd, 0xffffffffffff8003,
  0x000000007ffffffd, 0xffffffffffffff80,
  0x000000007ffffffd, 0xffffffffffffff81,
  0x000000007ffffffd, 0xffffffffffffff82,
  0x000000007ffffffd, 0xffffffffffffff83,
  0x000000007ffffffd, 0xffffffffffffffc0,
  0x000000007ffffffd, 0xfffffffffffffffd,
  0x000000007ffffffd, 0xfffffffffffffffe,
  0x000000007ffffffd, 0xffffffffffffffff,
  0x000000007ffffffe, 0x0000000000000000,
  0x000000007ffffffe, 0x0000000000000001,
  0x000000007ffffffe, 0x0000000000000002,
  0x000000007ffffffe, 0x0000000000000040,
  0x000000007ffffffe, 0x000000000000007d,
  0x000000007ffffffe, 0x000000000000007e,
  0x000000007ffffffe, 0x000000000000007f,
  0x000000007ffffffe, 0x0000000000007ffd,
  0x000000007ffffffe, 0x0000000000007ffe,
  0x000000007ffffffe, 0x0000000000007fff,
  0x000000007ffffffe, 0x000000007ffffffd,
  0x000000007ffffffe, 0x000000007ffffffe,
  0x000000007ffffffe, 0x000000007fffffff,
  0x000000007ffffffe, 0x3333333333333333,
  0x000000007ffffffe, 0x5555555555555555,
  0x000000007ffffffe, 0x7ffffffffffffffd,
  0x000000007ffffffe, 0x7ffffffffffffffe,
  0x000000007ffffffe, 0x7fffffffffffffff,
  0x000000007ffffffe, 0x8000000000000000,
  0x000000007ffffffe, 0x8000000000000001,
  0x000000007ffffffe, 0x8000000000000002,
  0x000000007ffffffe, 0x8000000000000003,
  0x000000007ffffffe, 0xaaaaaaaaaaaaaaaa,
  0x000000007ffffffe, 0xcccccccccccccccc,
  0x000000007ffffffe, 0xffffffff80000000,
  0x000000007ffffffe, 0xffffffff80000001,
  0x000000007ffffffe, 0xffffffff80000002,
  0x000000007ffffffe, 0xffffffff80000003,
  0x000000007ffffffe, 0xffffffffffff8000,
  0x000000007ffffffe, 0xffffffffffff8001,
  0x000000007ffffffe, 0xffffffffffff8002,
  0x000000007ffffffe, 0xffffffffffff8003,
  0x000000007ffffffe, 0xffffffffffffff80,
  0x000000007ffffffe, 0xffffffffffffff81,
  0x000000007ffffffe, 0xffffffffffffff82,
  0x000000007ffffffe, 0xffffffffffffff83,
  0x000000007ffffffe, 0xffffffffffffffc0,
  0x000000007ffffffe, 0xfffffffffffffffd,
  0x000000007ffffffe, 0xfffffffffffffffe,
  0x000000007ffffffe, 0xffffffffffffffff,
  0x000000007fffffff, 0x0000000000000000,
  0x000000007fffffff, 0x0000000000000001,
  0x000000007fffffff, 0x0000000000000002,
  0x000000007fffffff, 0x0000000000000040,
  0x000000007fffffff, 0x000000000000007d,
  0x000000007fffffff, 0x000000000000007e,
  0x000000007fffffff, 0x000000000000007f,
  0x000000007fffffff, 0x0000000000007ffd,
  0x000000007fffffff, 0x0000000000007ffe,
  0x000000007fffffff, 0x0000000000007fff,
  0x000000007fffffff, 0x000000007ffffffd,
  0x000000007fffffff, 0x000000007ffffffe,
  0x000000007fffffff, 0x000000007fffffff,
  0x000000007fffffff, 0x3333333333333333,
  0x000000007fffffff, 0x5555555555555555,
  0x000000007fffffff, 0x7ffffffffffffffd,
  0x000000007fffffff, 0x7ffffffffffffffe,
  0x000000007fffffff, 0x7fffffffffffffff,
  0x000000007fffffff, 0x8000000000000000,
  0x000000007fffffff, 0x8000000000000001,
  0x000000007fffffff, 0x8000000000000002,
  0x000000007fffffff, 0x8000000000000003,
  0x000000007fffffff, 0xaaaaaaaaaaaaaaaa,
  0x000000007fffffff, 0xcccccccccccccccc,
  0x000000007fffffff, 0xffffffff80000000,
  0x000000007fffffff, 0xffffffff80000001,
  0x000000007fffffff, 0xffffffff80000002,
  0x000000007fffffff, 0xffffffff80000003,
  0x000000007fffffff, 0xffffffffffff8000,
  0x000000007fffffff, 0xffffffffffff8001,
  0x000000007fffffff, 0xffffffffffff8002,
  0x000000007fffffff, 0xffffffffffff8003,
  0x000000007fffffff, 0xffffffffffffff80,
  0x000000007fffffff, 0xffffffffffffff81,
  0x000000007fffffff, 0xffffffffffffff82,
  0x000000007fffffff, 0xffffffffffffff83,
  0x000000007fffffff, 0xffffffffffffffc0,
  0x000000007fffffff, 0xfffffffffffffffd,
  0x000000007fffffff, 0xfffffffffffffffe,
  0x000000007fffffff, 0xffffffffffffffff,
  0x3333333333333333, 0x0000000000000000,
  0x3333333333333333, 0x0000000000000001,
  0x3333333333333333, 0x0000000000000002,
  0x3333333333333333, 0x0000000000000040,
  0x3333333333333333, 0x000000000000007d,
  0x3333333333333333, 0x000000000000007e,
  0x3333333333333333, 0x000000000000007f,
  0x3333333333333333, 0x0000000000007ffd,
  0x3333333333333333, 0x0000000000007ffe,
  0x3333333333333333, 0x0000000000007fff,
  0x3333333333333333, 0x000000007ffffffd,
  0x3333333333333333, 0x000000007ffffffe,
  0x3333333333333333, 0x000000007fffffff,
  0x3333333333333333, 0x3333333333333333,
  0x3333333333333333, 0x5555555555555555,
  0x3333333333333333, 0x7ffffffffffffffd,
  0x3333333333333333, 0x7ffffffffffffffe,
  0x3333333333333333, 0x7fffffffffffffff,
  0x3333333333333333, 0x8000000000000000,
  0x3333333333333333, 0x8000000000000001,
  0x3333333333333333, 0x8000000000000002,
  0x3333333333333333, 0x8000000000000003,
  0x3333333333333333, 0xaaaaaaaaaaaaaaaa,
  0x3333333333333333, 0xcccccccccccccccc,
  0x3333333333333333, 0xffffffff80000000,
  0x3333333333333333, 0xffffffff80000001,
  0x3333333333333333, 0xffffffff80000002,
  0x3333333333333333, 0xffffffff80000003,
  0x3333333333333333, 0xffffffffffff8000,
  0x3333333333333333, 0xffffffffffff8001,
  0x3333333333333333, 0xffffffffffff8002,
  0x3333333333333333, 0xffffffffffff8003,
  0x3333333333333333, 0xffffffffffffff80,
  0x3333333333333333, 0xffffffffffffff81,
  0x3333333333333333, 0xffffffffffffff82,
  0x3333333333333333, 0xffffffffffffff83,
  0x3333333333333333, 0xffffffffffffffc0,
  0x3333333333333333, 0xfffffffffffffffd,
  0x3333333333333333, 0xfffffffffffffffe,
  0x3333333333333333, 0xffffffffffffffff,
  0x5555555555555555, 0x0000000000000000,
  0x5555555555555555, 0x0000000000000001,
  0x5555555555555555, 0x0000000000000002,
  0x5555555555555555, 0x0000000000000040,
  0x5555555555555555, 0x000000000000007d,
  0x5555555555555555, 0x000000000000007e,
  0x5555555555555555, 0x000000000000007f,
  0x5555555555555555, 0x0000000000007ffd,
  0x5555555555555555, 0x0000000000007ffe,
  0x5555555555555555, 0x0000000000007fff,
  0x5555555555555555, 0x000000007ffffffd,
  0x5555555555555555, 0x000000007ffffffe,
  0x5555555555555555, 0x000000007fffffff,
  0x5555555555555555, 0x3333333333333333,
  0x5555555555555555, 0x5555555555555555,
  0x5555555555555555, 0x7ffffffffffffffd,
  0x5555555555555555, 0x7ffffffffffffffe,
  0x5555555555555555, 0x7fffffffffffffff,
  0x5555555555555555, 0x8000000000000000,
  0x5555555555555555, 0x8000000000000001,
  0x5555555555555555, 0x8000000000000002,
  0x5555555555555555, 0x8000000000000003,
  0x5555555555555555, 0xaaaaaaaaaaaaaaaa,
  0x5555555555555555, 0xcccccccccccccccc,
  0x5555555555555555, 0xffffffff80000000,
  0x5555555555555555, 0xffffffff80000001,
  0x5555555555555555, 0xffffffff80000002,
  0x5555555555555555, 0xffffffff80000003,
  0x5555555555555555, 0xffffffffffff8000,
  0x5555555555555555, 0xffffffffffff8001,
  0x5555555555555555, 0xffffffffffff8002,
  0x5555555555555555, 0xffffffffffff8003,
  0x5555555555555555, 0xffffffffffffff80,
  0x5555555555555555, 0xffffffffffffff81,
  0x5555555555555555, 0xffffffffffffff82,
  0x5555555555555555, 0xffffffffffffff83,
  0x5555555555555555, 0xffffffffffffffc0,
  0x5555555555555555, 0xfffffffffffffffd,
  0x5555555555555555, 0xfffffffffffffffe,
  0x5555555555555555, 0xffffffffffffffff,
  0x7ffffffffffffffd, 0x0000000000000000,
  0x7ffffffffffffffd, 0x0000000000000001,
  0x7ffffffffffffffd, 0x0000000000000002,
  0x7ffffffffffffffd, 0x0000000000000040,
  0x7ffffffffffffffd, 0x000000000000007d,
  0x7ffffffffffffffd, 0x000000000000007e,
  0x7ffffffffffffffd, 0x000000000000007f,
  0x7ffffffffffffffd, 0x0000000000007ffd,
  0x7ffffffffffffffd, 0x0000000000007ffe,
  0x7ffffffffffffffd, 0x0000000000007fff,
  0x7ffffffffffffffd, 0x000000007ffffffd,
  0x7ffffffffffffffd, 0x000000007ffffffe,
  0x7ffffffffffffffd, 0x000000007fffffff,
  0x7ffffffffffffffd, 0x3333333333333333,
  0x7ffffffffffffffd, 0x5555555555555555,
  0x7ffffffffffffffd, 0x7ffffffffffffffd,
  0x7ffffffffffffffd, 0x7ffffffffffffffe,
  0x7ffffffffffffffd, 0x7fffffffffffffff,
  0x7ffffffffffffffd, 0x8000000000000000,
  0x7ffffffffffffffd, 0x8000000000000001,
  0x7ffffffffffffffd, 0x8000000000000002,
  0x7ffffffffffffffd, 0x8000000000000003,
  0x7ffffffffffffffd, 0xaaaaaaaaaaaaaaaa,
  0x7ffffffffffffffd, 0xcccccccccccccccc,
  0x7ffffffffffffffd, 0xffffffff80000000,
  0x7ffffffffffffffd, 0xffffffff80000001,
  0x7ffffffffffffffd, 0xffffffff80000002,
  0x7ffffffffffffffd, 0xffffffff80000003,
  0x7ffffffffffffffd, 0xffffffffffff8000,
  0x7ffffffffffffffd, 0xffffffffffff8001,
  0x7ffffffffffffffd, 0xffffffffffff8002,
  0x7ffffffffffffffd, 0xffffffffffff8003,
  0x7ffffffffffffffd, 0xffffffffffffff80,
  0x7ffffffffffffffd, 0xffffffffffffff81,
  0x7ffffffffffffffd, 0xffffffffffffff82,
  0x7ffffffffffffffd, 0xffffffffffffff83,
  0x7ffffffffffffffd, 0xffffffffffffffc0,
  0x7ffffffffffffffd, 0xfffffffffffffffd,
  0x7ffffffffffffffd, 0xfffffffffffffffe,
  0x7ffffffffffffffd, 0xffffffffffffffff,
  0x7ffffffffffffffe, 0x0000000000000000,
  0x7ffffffffffffffe, 0x0000000000000001,
  0x7ffffffffffffffe, 0x0000000000000002,
  0x7ffffffffffffffe, 0x0000000000000040,
  0x7ffffffffffffffe, 0x000000000000007d,
  0x7ffffffffffffffe, 0x000000000000007e,
  0x7ffffffffffffffe, 0x000000000000007f,
  0x7ffffffffffffffe, 0x0000000000007ffd,
  0x7ffffffffffffffe, 0x0000000000007ffe,
  0x7ffffffffffffffe, 0x0000000000007fff,
  0x7ffffffffffffffe, 0x000000007ffffffd,
  0x7ffffffffffffffe, 0x000000007ffffffe,
  0x7ffffffffffffffe, 0x000000007fffffff,
  0x7ffffffffffffffe, 0x3333333333333333,
  0x7ffffffffffffffe, 0x5555555555555555,
  0x7ffffffffffffffe, 0x7ffffffffffffffd,
  0x7ffffffffffffffe, 0x7ffffffffffffffe,
  0x7ffffffffffffffe, 0x7fffffffffffffff,
  0x7ffffffffffffffe, 0x8000000000000000,
  0x7ffffffffffffffe, 0x8000000000000001,
  0x7ffffffffffffffe, 0x8000000000000002,
  0x7ffffffffffffffe, 0x8000000000000003,
  0x7ffffffffffffffe, 0xaaaaaaaaaaaaaaaa,
  0x7ffffffffffffffe, 0xcccccccccccccccc,
  0x7ffffffffffffffe, 0xffffffff80000000,
  0x7ffffffffffffffe, 0xffffffff80000001,
  0x7ffffffffffffffe, 0xffffffff80000002,
  0x7ffffffffffffffe, 0xffffffff80000003,
  0x7ffffffffffffffe, 0xffffffffffff8000,
  0x7ffffffffffffffe, 0xffffffffffff8001,
  0x7ffffffffffffffe, 0xffffffffffff8002,
  0x7ffffffffffffffe, 0xffffffffffff8003,
  0x7ffffffffffffffe, 0xffffffffffffff80,
  0x7ffffffffffffffe, 0xffffffffffffff81,
  0x7ffffffffffffffe, 0xffffffffffffff82,
  0x7ffffffffffffffe, 0xffffffffffffff83,
  0x7ffffffffffffffe, 0xffffffffffffffc0,
  0x7ffffffffffffffe, 0xfffffffffffffffd,
  0x7ffffffffffffffe, 0xfffffffffffffffe,
  0x7ffffffffffffffe, 0xffffffffffffffff,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000001,
  0x7fffffffffffffff, 0x0000000000000002,
  0x7fffffffffffffff, 0x0000000000000040,
  0x7fffffffffffffff, 0x000000000000007d,
  0x7fffffffffffffff, 0x000000000000007e,
  0x7fffffffffffffff, 0x000000000000007f,
  0x7fffffffffffffff, 0x0000000000007ffd,
  0x7fffffffffffffff, 0x0000000000007ffe,
  0x7fffffffffffffff, 0x0000000000007fff,
  0x7fffffffffffffff, 0x000000007ffffffd,
  0x7fffffffffffffff, 0x000000007ffffffe,
  0x7fffffffffffffff, 0x000000007fffffff,
  0x7fffffffffffffff, 0x3333333333333333,
  0x7fffffffffffffff, 0x5555555555555555,
  0x7fffffffffffffff, 0x7ffffffffffffffd,
  0x7fffffffffffffff, 0x7ffffffffffffffe,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000001,
  0x7fffffffffffffff, 0x8000000000000002,
  0x7fffffffffffffff, 0x8000000000000003,
  0x7fffffffffffffff, 0xaaaaaaaaaaaaaaaa,
  0x7fffffffffffffff, 0xcccccccccccccccc,
  0x7fffffffffffffff, 0xffffffff80000000,
  0x7fffffffffffffff, 0xffffffff80000001,
  0x7fffffffffffffff, 0xffffffff80000002,
  0x7fffffffffffffff, 0xffffffff80000003,
  0x7fffffffffffffff, 0xffffffffffff8000,
  0x7fffffffffffffff, 0xffffffffffff8001,
  0x7fffffffffffffff, 0xffffffffffff8002,
  0x7fffffffffffffff, 0xffffffffffff8003,
  0x7fffffffffffffff, 0xffffffffffffff80,
  0x7fffffffffffffff, 0xffffffffffffff81,
  0x7fffffffffffffff, 0xffffffffffffff82,
  0x7fffffffffffffff, 0xffffffffffffff83,
  0x7fffffffffffffff, 0xffffffffffffffc0,
  0x7fffffffffffffff, 0xfffffffffffffffd,
  0x7fffffffffffffff, 0xfffffffffffffffe,
  0x7fffffffffffffff, 0xffffffffffffffff,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000001,
  0x8000000000000000, 0x0000000000000002,
  0x8000000000000000, 0x0000000000000040,
  0x8000000000000000, 0x000000000000007d,
  0x8000000000000000, 0x000000000000007e,
  0x8000000000000000, 0x000000000000007f,
  0x8000000000000000, 0x0000000000007ffd,
  0x8000000000000000, 0x0000000000007ffe,
  0x8000000000000000, 0x0000000000007fff,
  0x8000000000000000, 0x000000007ffffffd,
  0x8000000000000000, 0x000000007ffffffe,
  0x8000000000000000, 0x000000007fffffff,
  0x8000000000000000, 0x3333333333333333,
  0x8000000000000000, 0x5555555555555555,
  0x8000000000000000, 0x7ffffffffffffffd,
  0x8000000000000000, 0x7ffffffffffffffe,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000001,
  0x8000000000000000, 0x8000000000000002,
  0x8000000000000000, 0x8000000000000003,
  0x8000000000000000, 0xaaaaaaaaaaaaaaaa,
  0x8000000000000000, 0xcccccccccccccccc,
  0x8000000000000000, 0xffffffff80000000,
  0x8000000000000000, 0xffffffff80000001,
  0x8000000000000000, 0xffffffff80000002,
  0x8000000000000000, 0xffffffff80000003,
  0x8000000000000000, 0xffffffffffff8000,
  0x8000000000000000, 0xffffffffffff8001,
  0x8000000000000000, 0xffffffffffff8002,
  0x8000000000000000, 0xffffffffffff8003,
  0x8000000000000000, 0xffffffffffffff80,
  0x8000000000000000, 0xffffffffffffff81,
  0x8000000000000000, 0xffffffffffffff82,
  0x8000000000000000, 0xffffffffffffff83,
  0x8000000000000000, 0xffffffffffffffc0,
  0x8000000000000000, 0xfffffffffffffffd,
  0x8000000000000000, 0xfffffffffffffffe,
  0x8000000000000000, 0xffffffffffffffff,
  0x8000000000000001, 0x0000000000000000,
  0x8000000000000001, 0x0000000000000001,
  0x8000000000000001, 0x0000000000000002,
  0x8000000000000001, 0x0000000000000040,
  0x8000000000000001, 0x000000000000007d,
  0x8000000000000001, 0x000000000000007e,
  0x8000000000000001, 0x000000000000007f,
  0x8000000000000001, 0x0000000000007ffd,
  0x8000000000000001, 0x0000000000007ffe,
  0x8000000000000001, 0x0000000000007fff,
  0x8000000000000001, 0x000000007ffffffd,
  0x8000000000000001, 0x000000007ffffffe,
  0x8000000000000001, 0x000000007fffffff,
  0x8000000000000001, 0x3333333333333333,
  0x8000000000000001, 0x5555555555555555,
  0x8000000000000001, 0x7ffffffffffffffd,
  0x8000000000000001, 0x7ffffffffffffffe,
  0x8000000000000001, 0x7fffffffffffffff,
  0x8000000000000001, 0x8000000000000000,
  0x8000000000000001, 0x8000000000000001,
  0x8000000000000001, 0x8000000000000002,
  0x8000000000000001, 0x8000000000000003,
  0x8000000000000001, 0xaaaaaaaaaaaaaaaa,
  0x8000000000000001, 0xcccccccccccccccc,
  0x8000000000000001, 0xffffffff80000000,
  0x8000000000000001, 0xffffffff80000001,
  0x8000000000000001, 0xffffffff80000002,
  0x8000000000000001, 0xffffffff80000003,
  0x8000000000000001, 0xffffffffffff8000,
  0x8000000000000001, 0xffffffffffff8001,
  0x8000000000000001, 0xffffffffffff8002,
  0x8000000000000001, 0xffffffffffff8003,
  0x8000000000000001, 0xffffffffffffff80,
  0x8000000000000001, 0xffffffffffffff81,
  0x8000000000000001, 0xffffffffffffff82,
  0x8000000000000001, 0xffffffffffffff83,
  0x8000000000000001, 0xffffffffffffffc0,
  0x8000000000000001, 0xfffffffffffffffd,
  0x8000000000000001, 0xfffffffffffffffe,
  0x8000000000000001, 0xffffffffffffffff,
  0x8000000000000002, 0x0000000000000000,
  0x8000000000000002, 0x0000000000000001,
  0x8000000000000002, 0x0000000000000002,
  0x8000000000000002, 0x0000000000000040,
  0x8000000000000002, 0x000000000000007d,
  0x8000000000000002, 0x000000000000007e,
  0x8000000000000002, 0x000000000000007f,
  0x8000000000000002, 0x0000000000007ffd,
  0x8000000000000002, 0x0000000000007ffe,
  0x8000000000000002, 0x0000000000007fff,
  0x8000000000000002, 0x000000007ffffffd,
  0x8000000000000002, 0x000000007ffffffe,
  0x8000000000000002, 0x000000007fffffff,
  0x8000000000000002, 0x3333333333333333,
  0x8000000000000002, 0x5555555555555555,
  0x8000000000000002, 0x7ffffffffffffffd,
  0x8000000000000002, 0x7ffffffffffffffe,
  0x8000000000000002, 0x7fffffffffffffff,
  0x8000000000000002, 0x8000000000000000,
  0x8000000000000002, 0x8000000000000001,
  0x8000000000000002, 0x8000000000000002,
  0x8000000000000002, 0x8000000000000003,
  0x8000000000000002, 0xaaaaaaaaaaaaaaaa,
  0x8000000000000002, 0xcccccccccccccccc,
  0x8000000000000002, 0xffffffff80000000,
  0x8000000000000002, 0xffffffff80000001,
  0x8000000000000002, 0xffffffff80000002,
  0x8000000000000002, 0xffffffff80000003,
  0x8000000000000002, 0xffffffffffff8000,
  0x8000000000000002, 0xffffffffffff8001,
  0x8000000000000002, 0xffffffffffff8002,
  0x8000000000000002, 0xffffffffffff8003,
  0x8000000000000002, 0xffffffffffffff80,
  0x8000000000000002, 0xffffffffffffff81,
  0x8000000000000002, 0xffffffffffffff82,
  0x8000000000000002, 0xffffffffffffff83,
  0x8000000000000002, 0xffffffffffffffc0,
  0x8000000000000002, 0xfffffffffffffffd,
  0x8000000000000002, 0xfffffffffffffffe,
  0x8000000000000002, 0xffffffffffffffff,
  0x8000000000000003, 0x0000000000000000,
  0x8000000000000003, 0x0000000000000001,
  0x8000000000000003, 0x0000000000000002,
  0x8000000000000003, 0x0000000000000040,
  0x8000000000000003, 0x000000000000007d,
  0x8000000000000003, 0x000000000000007e,
  0x8000000000000003, 0x000000000000007f,
  0x8000000000000003, 0x0000000000007ffd,
  0x8000000000000003, 0x0000000000007ffe,
  0x8000000000000003, 0x0000000000007fff,
  0x8000000000000003, 0x000000007ffffffd,
  0x8000000000000003, 0x000000007ffffffe,
  0x8000000000000003, 0x000000007fffffff,
  0x8000000000000003, 0x3333333333333333,
  0x8000000000000003, 0x5555555555555555,
  0x8000000000000003, 0x7ffffffffffffffd,
  0x8000000000000003, 0x7ffffffffffffffe,
  0x8000000000000003, 0x7fffffffffffffff,
  0x8000000000000003, 0x8000000000000000,
  0x8000000000000003, 0x8000000000000001,
  0x8000000000000003, 0x8000000000000002,
  0x8000000000000003, 0x8000000000000003,
  0x8000000000000003, 0xaaaaaaaaaaaaaaaa,
  0x8000000000000003, 0xcccccccccccccccc,
  0x8000000000000003, 0xffffffff80000000,
  0x8000000000000003, 0xffffffff80000001,
  0x8000000000000003, 0xffffffff80000002,
  0x8000000000000003, 0xffffffff80000003,
  0x8000000000000003, 0xffffffffffff8000,
  0x8000000000000003, 0xffffffffffff8001,
  0x8000000000000003, 0xffffffffffff8002,
  0x8000000000000003, 0xffffffffffff8003,
  0x8000000000000003, 0xffffffffffffff80,
  0x8000000000000003, 0xffffffffffffff81,
  0x8000000000000003, 0xffffffffffffff82,
  0x8000000000000003, 0xffffffffffffff83,
  0x8000000000000003, 0xffffffffffffffc0,
  0x8000000000000003, 0xfffffffffffffffd,
  0x8000000000000003, 0xfffffffffffffffe,
  0x8000000000000003, 0xffffffffffffffff,
  0xaaaaaaaaaaaaaaaa, 0x0000000000000000,
  0xaaaaaaaaaaaaaaaa, 0x0000000000000001,
  0xaaaaaaaaaaaaaaaa, 0x0000000000000002,
  0xaaaaaaaaaaaaaaaa, 0x0000000000000040,
  0xaaaaaaaaaaaaaaaa, 0x000000000000007d,
  0xaaaaaaaaaaaaaaaa, 0x000000000000007e,
  0xaaaaaaaaaaaaaaaa, 0x000000000000007f,
  0xaaaaaaaaaaaaaaaa, 0x0000000000007ffd,
  0xaaaaaaaaaaaaaaaa, 0x0000000000007ffe,
  0xaaaaaaaaaaaaaaaa, 0x0000000000007fff,
  0xaaaaaaaaaaaaaaaa, 0x000000007ffffffd,
  0xaaaaaaaaaaaaaaaa, 0x000000007ffffffe,
  0xaaaaaaaaaaaaaaaa, 0x000000007fffffff,
  0xaaaaaaaaaaaaaaaa, 0x3333333333333333,
  0xaaaaaaaaaaaaaaaa, 0x5555555555555555,
  0xaaaaaaaaaaaaaaaa, 0x7ffffffffffffffd,
  0xaaaaaaaaaaaaaaaa, 0x7ffffffffffffffe,
  0xaaaaaaaaaaaaaaaa, 0x7fffffffffffffff,
  0xaaaaaaaaaaaaaaaa, 0x8000000000000000,
  0xaaaaaaaaaaaaaaaa, 0x8000000000000001,
  0xaaaaaaaaaaaaaaaa, 0x8000000000000002,
  0xaaaaaaaaaaaaaaaa, 0x8000000000000003,
  0xaaaaaaaaaaaaaaaa, 0xaaaaaaaaaaaaaaaa,
  0xaaaaaaaaaaaaaaaa, 0xcccccccccccccccc,
  0xaaaaaaaaaaaaaaaa, 0xffffffff80000000,
  0xaaaaaaaaaaaaaaaa, 0xffffffff80000001,
  0xaaaaaaaaaaaaaaaa, 0xffffffff80000002,
  0xaaaaaaaaaaaaaaaa, 0xffffffff80000003,
  0xaaaaaaaaaaaaaaaa, 0xffffffffffff8000,
  0xaaaaaaaaaaaaaaaa, 0xffffffffffff8001,
  0xaaaaaaaaaaaaaaaa, 0xffffffffffff8002,
  0xaaaaaaaaaaaaaaaa, 0xffffffffffff8003,
  0xaaaaaaaaaaaaaaaa, 0xffffffffffffff80,
  0xaaaaaaaaaaaaaaaa, 0xffffffffffffff81,
  0xaaaaaaaaaaaaaaaa, 0xffffffffffffff82,
  0xaaaaaaaaaaaaaaaa, 0xffffffffffffff83,
  0xaaaaaaaaaaaaaaaa, 0xffffffffffffffc0,
  0xaaaaaaaaaaaaaaaa, 0xfffffffffffffffd,
  0xaaaaaaaaaaaaaaaa, 0xfffffffffffffffe,
  0xaaaaaaaaaaaaaaaa, 0xffffffffffffffff,
  0xcccccccccccccccc, 0x0000000000000000,
  0xcccccccccccccccc, 0x0000000000000001,
  0xcccccccccccccccc, 0x0000000000000002,
  0xcccccccccccccccc, 0x0000000000000040,
  0xcccccccccccccccc, 0x000000000000007d,
  0xcccccccccccccccc, 0x000000000000007e,
  0xcccccccccccccccc, 0x000000000000007f,
  0xcccccccccccccccc, 0x0000000000007ffd,
  0xcccccccccccccccc, 0x0000000000007ffe,
  0xcccccccccccccccc, 0x0000000000007fff,
  0xcccccccccccccccc, 0x000000007ffffffd,
  0xcccccccccccccccc, 0x000000007ffffffe,
  0xcccccccccccccccc, 0x000000007fffffff,
  0xcccccccccccccccc, 0x3333333333333333,
  0xcccccccccccccccc, 0x5555555555555555,
  0xcccccccccccccccc, 0x7ffffffffffffffd,
  0xcccccccccccccccc, 0x7ffffffffffffffe,
  0xcccccccccccccccc, 0x7fffffffffffffff,
  0xcccccccccccccccc, 0x8000000000000000,
  0xcccccccccccccccc, 0x8000000000000001,
  0xcccccccccccccccc, 0x8000000000000002,
  0xcccccccccccccccc, 0x8000000000000003,
  0xcccccccccccccccc, 0xaaaaaaaaaaaaaaaa,
  0xcccccccccccccccc, 0xcccccccccccccccc,
  0xcccccccccccccccc, 0xffffffff80000000,
  0xcccccccccccccccc, 0xffffffff80000001,
  0xcccccccccccccccc, 0xffffffff80000002,
  0xcccccccccccccccc, 0xffffffff80000003,
  0xcccccccccccccccc, 0xffffffffffff8000,
  0xcccccccccccccccc, 0xffffffffffff8001,
  0xcccccccccccccccc, 0xffffffffffff8002,
  0xcccccccccccccccc, 0xffffffffffff8003,
  0xcccccccccccccccc, 0xffffffffffffff80,
  0xcccccccccccccccc, 0xffffffffffffff81,
  0xcccccccccccccccc, 0xffffffffffffff82,
  0xcccccccccccccccc, 0xffffffffffffff83,
  0xcccccccccccccccc, 0xffffffffffffffc0,
  0xcccccccccccccccc, 0xfffffffffffffffd,
  0xcccccccccccccccc, 0xfffffffffffffffe,
  0xcccccccccccccccc, 0xffffffffffffffff,
  0xffffffff80000000, 0x0000000000000000,
  0xffffffff80000000, 0x0000000000000001,
  0xffffffff80000000, 0x0000000000000002,
  0xffffffff80000000, 0x0000000000000040,
  0xffffffff80000000, 0x000000000000007d,
  0xffffffff80000000, 0x000000000000007e,
  0xffffffff80000000, 0x000000000000007f,
  0xffffffff80000000, 0x0000000000007ffd,
  0xffffffff80000000, 0x0000000000007ffe,
  0xffffffff80000000, 0x0000000000007fff,
  0xffffffff80000000, 0x000000007ffffffd,
  0xffffffff80000000, 0x000000007ffffffe,
  0xffffffff80000000, 0x000000007fffffff,
  0xffffffff80000000, 0x3333333333333333,
  0xffffffff80000000, 0x5555555555555555,
  0xffffffff80000000, 0x7ffffffffffffffd,
  0xffffffff80000000, 0x7ffffffffffffffe,
  0xffffffff80000000, 0x7fffffffffffffff,
  0xffffffff80000000, 0x8000000000000000,
  0xffffffff80000000, 0x8000000000000001,
  0xffffffff80000000, 0x8000000000000002,
  0xffffffff80000000, 0x8000000000000003,
  0xffffffff80000000, 0xaaaaaaaaaaaaaaaa,
  0xffffffff80000000, 0xcccccccccccccccc,
  0xffffffff80000000, 0xffffffff80000000,
  0xffffffff80000000, 0xffffffff80000001,
  0xffffffff80000000, 0xffffffff80000002,
  0xffffffff80000000, 0xffffffff80000003,
  0xffffffff80000000, 0xffffffffffff8000,
  0xffffffff80000000, 0xffffffffffff8001,
  0xffffffff80000000, 0xffffffffffff8002,
  0xffffffff80000000, 0xffffffffffff8003,
  0xffffffff80000000, 0xffffffffffffff80,
  0xffffffff80000000, 0xffffffffffffff81,
  0xffffffff80000000, 0xffffffffffffff82,
  0xffffffff80000000, 0xffffffffffffff83,
  0xffffffff80000000, 0xffffffffffffffc0,
  0xffffffff80000000, 0xfffffffffffffffd,
  0xffffffff80000000, 0xfffffffffffffffe,
  0xffffffff80000000, 0xffffffffffffffff,
  0xffffffff80000001, 0x0000000000000000,
  0xffffffff80000001, 0x0000000000000001,
  0xffffffff80000001, 0x0000000000000002,
  0xffffffff80000001, 0x0000000000000040,
  0xffffffff80000001, 0x000000000000007d,
  0xffffffff80000001, 0x000000000000007e,
  0xffffffff80000001, 0x000000000000007f,
  0xffffffff80000001, 0x0000000000007ffd,
  0xffffffff80000001, 0x0000000000007ffe,
  0xffffffff80000001, 0x0000000000007fff,
  0xffffffff80000001, 0x000000007ffffffd,
  0xffffffff80000001, 0x000000007ffffffe,
  0xffffffff80000001, 0x000000007fffffff,
  0xffffffff80000001, 0x3333333333333333,
  0xffffffff80000001, 0x5555555555555555,
  0xffffffff80000001, 0x7ffffffffffffffd,
  0xffffffff80000001, 0x7ffffffffffffffe,
  0xffffffff80000001, 0x7fffffffffffffff,
  0xffffffff80000001, 0x8000000000000000,
  0xffffffff80000001, 0x8000000000000001,
  0xffffffff80000001, 0x8000000000000002,
  0xffffffff80000001, 0x8000000000000003,
  0xffffffff80000001, 0xaaaaaaaaaaaaaaaa,
  0xffffffff80000001, 0xcccccccccccccccc,
  0xffffffff80000001, 0xffffffff80000000,
  0xffffffff80000001, 0xffffffff80000001,
  0xffffffff80000001, 0xffffffff80000002,
  0xffffffff80000001, 0xffffffff80000003,
  0xffffffff80000001, 0xffffffffffff8000,
  0xffffffff80000001, 0xffffffffffff8001,
  0xffffffff80000001, 0xffffffffffff8002,
  0xffffffff80000001, 0xffffffffffff8003,
  0xffffffff80000001, 0xffffffffffffff80,
  0xffffffff80000001, 0xffffffffffffff81,
  0xffffffff80000001, 0xffffffffffffff82,
  0xffffffff80000001, 0xffffffffffffff83,
  0xffffffff80000001, 0xffffffffffffffc0,
  0xffffffff80000001, 0xfffffffffffffffd,
  0xffffffff80000001, 0xfffffffffffffffe,
  0xffffffff80000001, 0xffffffffffffffff,
  0xffffffff80000002, 0x0000000000000000,
  0xffffffff80000002, 0x0000000000000001,
  0xffffffff80000002, 0x0000000000000002,
  0xffffffff80000002, 0x0000000000000040,
  0xffffffff80000002, 0x000000000000007d,
  0xffffffff80000002, 0x000000000000007e,
  0xffffffff80000002, 0x000000000000007f,
  0xffffffff80000002, 0x0000000000007ffd,
  0xffffffff80000002, 0x0000000000007ffe,
  0xffffffff80000002, 0x0000000000007fff,
  0xffffffff80000002, 0x000000007ffffffd,
  0xffffffff80000002, 0x000000007ffffffe,
  0xffffffff80000002, 0x000000007fffffff,
  0xffffffff80000002, 0x3333333333333333,
  0xffffffff80000002, 0x5555555555555555,
  0xffffffff80000002, 0x7ffffffffffffffd,
  0xffffffff80000002, 0x7ffffffffffffffe,
  0xffffffff80000002, 0x7fffffffffffffff,
  0xffffffff80000002, 0x8000000000000000,
  0xffffffff80000002, 0x8000000000000001,
  0xffffffff80000002, 0x8000000000000002,
  0xffffffff80000002, 0x8000000000000003,
  0xffffffff80000002, 0xaaaaaaaaaaaaaaaa,
  0xffffffff80000002, 0xcccccccccccccccc,
  0xffffffff80000002, 0xffffffff80000000,
  0xffffffff80000002, 0xffffffff80000001,
  0xffffffff80000002, 0xffffffff80000002,
  0xffffffff80000002, 0xffffffff80000003,
  0xffffffff80000002, 0xffffffffffff8000,
  0xffffffff80000002, 0xffffffffffff8001,
  0xffffffff80000002, 0xffffffffffff8002,
  0xffffffff80000002, 0xffffffffffff8003,
  0xffffffff80000002, 0xffffffffffffff80,
  0xffffffff80000002, 0xffffffffffffff81,
  0xffffffff80000002, 0xffffffffffffff82,
  0xffffffff80000002, 0xffffffffffffff83,
  0xffffffff80000002, 0xffffffffffffffc0,
  0xffffffff80000002, 0xfffffffffffffffd,
  0xffffffff80000002, 0xfffffffffffffffe,
  0xffffffff80000002, 0xffffffffffffffff,
  0xffffffff80000003, 0x0000000000000000,
  0xffffffff80000003, 0x0000000000000001,
  0xffffffff80000003, 0x0000000000000002,
  0xffffffff80000003, 0x0000000000000040,
  0xffffffff80000003, 0x000000000000007d,
  0xffffffff80000003, 0x000000000000007e,
  0xffffffff80000003, 0x000000000000007f,
  0xffffffff80000003, 0x0000000000007ffd,
  0xffffffff80000003, 0x0000000000007ffe,
  0xffffffff80000003, 0x0000000000007fff,
  0xffffffff80000003, 0x000000007ffffffd,
  0xffffffff80000003, 0x000000007ffffffe,
  0xffffffff80000003, 0x000000007fffffff,
  0xffffffff80000003, 0x3333333333333333,
  0xffffffff80000003, 0x5555555555555555,
  0xffffffff80000003, 0x7ffffffffffffffd,
  0xffffffff80000003, 0x7ffffffffffffffe,
  0xffffffff80000003, 0x7fffffffffffffff,
  0xffffffff80000003, 0x8000000000000000,
  0xffffffff80000003, 0x8000000000000001,
  0xffffffff80000003, 0x8000000000000002,
  0xffffffff80000003, 0x8000000000000003,
  0xffffffff80000003, 0xaaaaaaaaaaaaaaaa,
  0xffffffff80000003, 0xcccccccccccccccc,
  0xffffffff80000003, 0xffffffff80000000,
  0xffffffff80000003, 0xffffffff80000001,
  0xffffffff80000003, 0xffffffff80000002,
  0xffffffff80000003, 0xffffffff80000003,
  0xffffffff80000003, 0xffffffffffff8000,
  0xffffffff80000003, 0xffffffffffff8001,
  0xffffffff80000003, 0xffffffffffff8002,
  0xffffffff80000003, 0xffffffffffff8003,
  0xffffffff80000003, 0xffffffffffffff80,
  0xffffffff80000003, 0xffffffffffffff81,
  0xffffffff80000003, 0xffffffffffffff82,
  0xffffffff80000003, 0xffffffffffffff83,
  0xffffffff80000003, 0xffffffffffffffc0,
  0xffffffff80000003, 0xfffffffffffffffd,
  0xffffffff80000003, 0xfffffffffffffffe,
  0xffffffff80000003, 0xffffffffffffffff,
  0xffffffffffff8000, 0x0000000000000000,
  0xffffffffffff8000, 0x0000000000000001,
  0xffffffffffff8000, 0x0000000000000002,
  0xffffffffffff8000, 0x0000000000000040,
  0xffffffffffff8000, 0x000000000000007d,
  0xffffffffffff8000, 0x000000000000007e,
  0xffffffffffff8000, 0x000000000000007f,
  0xffffffffffff8000, 0x0000000000007ffd,
  0xffffffffffff8000, 0x0000000000007ffe,
  0xffffffffffff8000, 0x0000000000007fff,
  0xffffffffffff8000, 0x000000007ffffffd,
  0xffffffffffff8000, 0x000000007ffffffe,
  0xffffffffffff8000, 0x000000007fffffff,
  0xffffffffffff8000, 0x3333333333333333,
  0xffffffffffff8000, 0x5555555555555555,
  0xffffffffffff8000, 0x7ffffffffffffffd,
  0xffffffffffff8000, 0x7ffffffffffffffe,
  0xffffffffffff8000, 0x7fffffffffffffff,
  0xffffffffffff8000, 0x8000000000000000,
  0xffffffffffff8000, 0x8000000000000001,
  0xffffffffffff8000, 0x8000000000000002,
  0xffffffffffff8000, 0x8000000000000003,
  0xffffffffffff8000, 0xaaaaaaaaaaaaaaaa,
  0xffffffffffff8000, 0xcccccccccccccccc,
  0xffffffffffff8000, 0xffffffff80000000,
  0xffffffffffff8000, 0xffffffff80000001,
  0xffffffffffff8000, 0xffffffff80000002,
  0xffffffffffff8000, 0xffffffff80000003,
  0xffffffffffff8000, 0xffffffffffff8000,
  0xffffffffffff8000, 0xffffffffffff8001,
  0xffffffffffff8000, 0xffffffffffff8002,
  0xffffffffffff8000, 0xffffffffffff8003,
  0xffffffffffff8000, 0xffffffffffffff80,
  0xffffffffffff8000, 0xffffffffffffff81,
  0xffffffffffff8000, 0xffffffffffffff82,
  0xffffffffffff8000, 0xffffffffffffff83,
  0xffffffffffff8000, 0xffffffffffffffc0,
  0xffffffffffff8000, 0xfffffffffffffffd,
  0xffffffffffff8000, 0xfffffffffffffffe,
  0xffffffffffff8000, 0xffffffffffffffff,
  0xffffffffffff8001, 0x0000000000000000,
  0xffffffffffff8001, 0x0000000000000001,
  0xffffffffffff8001, 0x0000000000000002,
  0xffffffffffff8001, 0x0000000000000040,
  0xffffffffffff8001, 0x000000000000007d,
  0xffffffffffff8001, 0x000000000000007e,
  0xffffffffffff8001, 0x000000000000007f,
  0xffffffffffff8001, 0x0000000000007ffd,
  0xffffffffffff8001, 0x0000000000007ffe,
  0xffffffffffff8001, 0x0000000000007fff,
  0xffffffffffff8001, 0x000000007ffffffd,
  0xffffffffffff8001, 0x000000007ffffffe,
  0xffffffffffff8001, 0x000000007fffffff,
  0xffffffffffff8001, 0x3333333333333333,
  0xffffffffffff8001, 0x5555555555555555,
  0xffffffffffff8001, 0x7ffffffffffffffd,
  0xffffffffffff8001, 0x7ffffffffffffffe,
  0xffffffffffff8001, 0x7fffffffffffffff,
  0xffffffffffff8001, 0x8000000000000000,
  0xffffffffffff8001, 0x8000000000000001,
  0xffffffffffff8001, 0x8000000000000002,
  0xffffffffffff8001, 0x8000000000000003,
  0xffffffffffff8001, 0xaaaaaaaaaaaaaaaa,
  0xffffffffffff8001, 0xcccccccccccccccc,
  0xffffffffffff8001, 0xffffffff80000000,
  0xffffffffffff8001, 0xffffffff80000001,
  0xffffffffffff8001, 0xffffffff80000002,
  0xffffffffffff8001, 0xffffffff80000003,
  0xffffffffffff8001, 0xffffffffffff8000,
  0xffffffffffff8001, 0xffffffffffff8001,
  0xffffffffffff8001, 0xffffffffffff8002,
  0xffffffffffff8001, 0xffffffffffff8003,
  0xffffffffffff8001, 0xffffffffffffff80,
  0xffffffffffff8001, 0xffffffffffffff81,
  0xffffffffffff8001, 0xffffffffffffff82,
  0xffffffffffff8001, 0xffffffffffffff83,
  0xffffffffffff8001, 0xffffffffffffffc0,
  0xffffffffffff8001, 0xfffffffffffffffd,
  0xffffffffffff8001, 0xfffffffffffffffe,
  0xffffffffffff8001, 0xffffffffffffffff,
  0xffffffffffff8002, 0x0000000000000000,
  0xffffffffffff8002, 0x0000000000000001,
  0xffffffffffff8002, 0x0000000000000002,
  0xffffffffffff8002, 0x0000000000000040,
  0xffffffffffff8002, 0x000000000000007d,
  0xffffffffffff8002, 0x000000000000007e,
  0xffffffffffff8002, 0x000000000000007f,
  0xffffffffffff8002, 0x0000000000007ffd,
  0xffffffffffff8002, 0x0000000000007ffe,
  0xffffffffffff8002, 0x0000000000007fff,
  0xffffffffffff8002, 0x000000007ffffffd,
  0xffffffffffff8002, 0x000000007ffffffe,
  0xffffffffffff8002, 0x000000007fffffff,
  0xffffffffffff8002, 0x3333333333333333,
  0xffffffffffff8002, 0x5555555555555555,
  0xffffffffffff8002, 0x7ffffffffffffffd,
  0xffffffffffff8002, 0x7ffffffffffffffe,
  0xffffffffffff8002, 0x7fffffffffffffff,
  0xffffffffffff8002, 0x8000000000000000,
  0xffffffffffff8002, 0x8000000000000001,
  0xffffffffffff8002, 0x8000000000000002,
  0xffffffffffff8002, 0x8000000000000003,
  0xffffffffffff8002, 0xaaaaaaaaaaaaaaaa,
  0xffffffffffff8002, 0xcccccccccccccccc,
  0xffffffffffff8002, 0xffffffff80000000,
  0xffffffffffff8002, 0xffffffff80000001,
  0xffffffffffff8002, 0xffffffff80000002,
  0xffffffffffff8002, 0xffffffff80000003,
  0xffffffffffff8002, 0xffffffffffff8000,
  0xffffffffffff8002, 0xffffffffffff8001,
  0xffffffffffff8002, 0xffffffffffff8002,
  0xffffffffffff8002, 0xffffffffffff8003,
  0xffffffffffff8002, 0xffffffffffffff80,
  0xffffffffffff8002, 0xffffffffffffff81,
  0xffffffffffff8002, 0xffffffffffffff82,
  0xffffffffffff8002, 0xffffffffffffff83,
  0xffffffffffff8002, 0xffffffffffffffc0,
  0xffffffffffff8002, 0xfffffffffffffffd,
  0xffffffffffff8002, 0xfffffffffffffffe,
  0xffffffffffff8002, 0xffffffffffffffff,
  0xffffffffffff8003, 0x0000000000000000,
  0xffffffffffff8003, 0x0000000000000001,
  0xffffffffffff8003, 0x0000000000000002,
  0xffffffffffff8003, 0x0000000000000040,
  0xffffffffffff8003, 0x000000000000007d,
  0xffffffffffff8003, 0x000000000000007e,
  0xffffffffffff8003, 0x000000000000007f,
  0xffffffffffff8003, 0x0000000000007ffd,
  0xffffffffffff8003, 0x0000000000007ffe,
  0xffffffffffff8003, 0x0000000000007fff,
  0xffffffffffff8003, 0x000000007ffffffd,
  0xffffffffffff8003, 0x000000007ffffffe,
  0xffffffffffff8003, 0x000000007fffffff,
  0xffffffffffff8003, 0x3333333333333333,
  0xffffffffffff8003, 0x5555555555555555,
  0xffffffffffff8003, 0x7ffffffffffffffd,
  0xffffffffffff8003, 0x7ffffffffffffffe,
  0xffffffffffff8003, 0x7fffffffffffffff,
  0xffffffffffff8003, 0x8000000000000000,
  0xffffffffffff8003, 0x8000000000000001,
  0xffffffffffff8003, 0x8000000000000002,
  0xffffffffffff8003, 0x8000000000000003,
  0xffffffffffff8003, 0xaaaaaaaaaaaaaaaa,
  0xffffffffffff8003, 0xcccccccccccccccc,
  0xffffffffffff8003, 0xffffffff80000000,
  0xffffffffffff8003, 0xffffffff80000001,
  0xffffffffffff8003, 0xffffffff80000002,
  0xffffffffffff8003, 0xffffffff80000003,
  0xffffffffffff8003, 0xffffffffffff8000,
  0xffffffffffff8003, 0xffffffffffff8001,
  0xffffffffffff8003, 0xffffffffffff8002,
  0xffffffffffff8003, 0xffffffffffff8003,
  0xffffffffffff8003, 0xffffffffffffff80,
  0xffffffffffff8003, 0xffffffffffffff81,
  0xffffffffffff8003, 0xffffffffffffff82,
  0xffffffffffff8003, 0xffffffffffffff83,
  0xffffffffffff8003, 0xffffffffffffffc0,
  0xffffffffffff8003, 0xfffffffffffffffd,
  0xffffffffffff8003, 0xfffffffffffffffe,
  0xffffffffffff8003, 0xffffffffffffffff,
  0xffffffffffffff80, 0x0000000000000000,
  0xffffffffffffff80, 0x0000000000000001,
  0xffffffffffffff80, 0x0000000000000002,
  0xffffffffffffff80, 0x0000000000000040,
  0xffffffffffffff80, 0x000000000000007d,
  0xffffffffffffff80, 0x000000000000007e,
  0xffffffffffffff80, 0x000000000000007f,
  0xffffffffffffff80, 0x0000000000007ffd,
  0xffffffffffffff80, 0x0000000000007ffe,
  0xffffffffffffff80, 0x0000000000007fff,
  0xffffffffffffff80, 0x000000007ffffffd,
  0xffffffffffffff80, 0x000000007ffffffe,
  0xffffffffffffff80, 0x000000007fffffff,
  0xffffffffffffff80, 0x3333333333333333,
  0xffffffffffffff80, 0x5555555555555555,
  0xffffffffffffff80, 0x7ffffffffffffffd,
  0xffffffffffffff80, 0x7ffffffffffffffe,
  0xffffffffffffff80, 0x7fffffffffffffff,
  0xffffffffffffff80, 0x8000000000000000,
  0xffffffffffffff80, 0x8000000000000001,
  0xffffffffffffff80, 0x8000000000000002,
  0xffffffffffffff80, 0x8000000000000003,
  0xffffffffffffff80, 0xaaaaaaaaaaaaaaaa,
  0xffffffffffffff80, 0xcccccccccccccccc,
  0xffffffffffffff80, 0xffffffff80000000,
  0xffffffffffffff80, 0xffffffff80000001,
  0xffffffffffffff80, 0xffffffff80000002,
  0xffffffffffffff80, 0xffffffff80000003,
  0xffffffffffffff80, 0xffffffffffff8000,
  0xffffffffffffff80, 0xffffffffffff8001,
  0xffffffffffffff80, 0xffffffffffff8002,
  0xffffffffffffff80, 0xffffffffffff8003,
  0xffffffffffffff80, 0xffffffffffffff80,
  0xffffffffffffff80, 0xffffffffffffff81,
  0xffffffffffffff80, 0xffffffffffffff82,
  0xffffffffffffff80, 0xffffffffffffff83,
  0xffffffffffffff80, 0xffffffffffffffc0,
  0xffffffffffffff80, 0xfffffffffffffffd,
  0xffffffffffffff80, 0xfffffffffffffffe,
  0xffffffffffffff80, 0xffffffffffffffff,
  0xffffffffffffff81, 0x0000000000000000,
  0xffffffffffffff81, 0x0000000000000001,
  0xffffffffffffff81, 0x0000000000000002,
  0xffffffffffffff81, 0x0000000000000040,
  0xffffffffffffff81, 0x000000000000007d,
  0xffffffffffffff81, 0x000000000000007e,
  0xffffffffffffff81, 0x000000000000007f,
  0xffffffffffffff81, 0x0000000000007ffd,
  0xffffffffffffff81, 0x0000000000007ffe,
  0xffffffffffffff81, 0x0000000000007fff,
  0xffffffffffffff81, 0x000000007ffffffd,
  0xffffffffffffff81, 0x000000007ffffffe,
  0xffffffffffffff81, 0x000000007fffffff,
  0xffffffffffffff81, 0x3333333333333333,
  0xffffffffffffff81, 0x5555555555555555,
  0xffffffffffffff81, 0x7ffffffffffffffd,
  0xffffffffffffff81, 0x7ffffffffffffffe,
  0xffffffffffffff81, 0x7fffffffffffffff,
  0xffffffffffffff81, 0x8000000000000000,
  0xffffffffffffff81, 0x8000000000000001,
  0xffffffffffffff81, 0x8000000000000002,
  0xffffffffffffff81, 0x8000000000000003,
  0xffffffffffffff81, 0xaaaaaaaaaaaaaaaa,
  0xffffffffffffff81, 0xcccccccccccccccc,
  0xffffffffffffff81, 0xffffffff80000000,
  0xffffffffffffff81, 0xffffffff80000001,
  0xffffffffffffff81, 0xffffffff80000002,
  0xffffffffffffff81, 0xffffffff80000003,
  0xffffffffffffff81, 0xffffffffffff8000,
  0xffffffffffffff81, 0xffffffffffff8001,
  0xffffffffffffff81, 0xffffffffffff8002,
  0xffffffffffffff81, 0xffffffffffff8003,
  0xffffffffffffff81, 0xffffffffffffff80,
  0xffffffffffffff81, 0xffffffffffffff81,
  0xffffffffffffff81, 0xffffffffffffff82,
  0xffffffffffffff81, 0xffffffffffffff83,
  0xffffffffffffff81, 0xffffffffffffffc0,
  0xffffffffffffff81, 0xfffffffffffffffd,
  0xffffffffffffff81, 0xfffffffffffffffe,
  0xffffffffffffff81, 0xffffffffffffffff,
  0xffffffffffffff82, 0x0000000000000000,
  0xffffffffffffff82, 0x0000000000000001,
  0xffffffffffffff82, 0x0000000000000002,
  0xffffffffffffff82, 0x0000000000000040,
  0xffffffffffffff82, 0x000000000000007d,
  0xffffffffffffff82, 0x000000000000007e,
  0xffffffffffffff82, 0x000000000000007f,
  0xffffffffffffff82, 0x0000000000007ffd,
  0xffffffffffffff82, 0x0000000000007ffe,
  0xffffffffffffff82, 0x0000000000007fff,
  0xffffffffffffff82, 0x000000007ffffffd,
  0xffffffffffffff82, 0x000000007ffffffe,
  0xffffffffffffff82, 0x000000007fffffff,
  0xffffffffffffff82, 0x3333333333333333,
  0xffffffffffffff82, 0x5555555555555555,
  0xffffffffffffff82, 0x7ffffffffffffffd,
  0xffffffffffffff82, 0x7ffffffffffffffe,
  0xffffffffffffff82, 0x7fffffffffffffff,
  0xffffffffffffff82, 0x8000000000000000,
  0xffffffffffffff82, 0x8000000000000001,
  0xffffffffffffff82, 0x8000000000000002,
  0xffffffffffffff82, 0x8000000000000003,
  0xffffffffffffff82, 0xaaaaaaaaaaaaaaaa,
  0xffffffffffffff82, 0xcccccccccccccccc,
  0xffffffffffffff82, 0xffffffff80000000,
  0xffffffffffffff82, 0xffffffff80000001,
  0xffffffffffffff82, 0xffffffff80000002,
  0xffffffffffffff82, 0xffffffff80000003,
  0xffffffffffffff82, 0xffffffffffff8000,
  0xffffffffffffff82, 0xffffffffffff8001,
  0xffffffffffffff82, 0xffffffffffff8002,
  0xffffffffffffff82, 0xffffffffffff8003,
  0xffffffffffffff82, 0xffffffffffffff80,
  0xffffffffffffff82, 0xffffffffffffff81,
  0xffffffffffffff82, 0xffffffffffffff82,
  0xffffffffffffff82, 0xffffffffffffff83,
  0xffffffffffffff82, 0xffffffffffffffc0,
  0xffffffffffffff82, 0xfffffffffffffffd,
  0xffffffffffffff82, 0xfffffffffffffffe,
  0xffffffffffffff82, 0xffffffffffffffff,
  0xffffffffffffff83, 0x0000000000000000,
  0xffffffffffffff83, 0x0000000000000001,
  0xffffffffffffff83, 0x0000000000000002,
  0xffffffffffffff83, 0x0000000000000040,
  0xffffffffffffff83, 0x000000000000007d,
  0xffffffffffffff83, 0x000000000000007e,
  0xffffffffffffff83, 0x000000000000007f,
  0xffffffffffffff83, 0x0000000000007ffd,
  0xffffffffffffff83, 0x0000000000007ffe,
  0xffffffffffffff83, 0x0000000000007fff,
  0xffffffffffffff83, 0x000000007ffffffd,
  0xffffffffffffff83, 0x000000007ffffffe,
  0xffffffffffffff83, 0x000000007fffffff,
  0xffffffffffffff83, 0x3333333333333333,
  0xffffffffffffff83, 0x5555555555555555,
  0xffffffffffffff83, 0x7ffffffffffffffd,
  0xffffffffffffff83, 0x7ffffffffffffffe,
  0xffffffffffffff83, 0x7fffffffffffffff,
  0xffffffffffffff83, 0x8000000000000000,
  0xffffffffffffff83, 0x8000000000000001,
  0xffffffffffffff83, 0x8000000000000002,
  0xffffffffffffff83, 0x8000000000000003,
  0xffffffffffffff83, 0xaaaaaaaaaaaaaaaa,
  0xffffffffffffff83, 0xcccccccccccccccc,
  0xffffffffffffff83, 0xffffffff80000000,
  0xffffffffffffff83, 0xffffffff80000001,
  0xffffffffffffff83, 0xffffffff80000002,
  0xffffffffffffff83, 0xffffffff80000003,
  0xffffffffffffff83, 0xffffffffffff8000,
  0xffffffffffffff83, 0xffffffffffff8001,
  0xffffffffffffff83, 0xffffffffffff8002,
  0xffffffffffffff83, 0xffffffffffff8003,
  0xffffffffffffff83, 0xffffffffffffff80,
  0xffffffffffffff83, 0xffffffffffffff81,
  0xffffffffffffff83, 0xffffffffffffff82,
  0xffffffffffffff83, 0xffffffffffffff83,
  0xffffffffffffff83, 0xffffffffffffffc0,
  0xffffffffffffff83, 0xfffffffffffffffd,
  0xffffffffffffff83, 0xfffffffffffffffe,
  0xffffffffffffff83, 0xffffffffffffffff,
  0xffffffffffffffc0, 0x0000000000000000,
  0xffffffffffffffc0, 0x0000000000000001,
  0xffffffffffffffc0, 0x0000000000000002,
  0xffffffffffffffc0, 0x0000000000000040,
  0xffffffffffffffc0, 0x000000000000007d,
  0xffffffffffffffc0, 0x000000000000007e,
  0xffffffffffffffc0, 0x000000000000007f,
  0xffffffffffffffc0, 0x0000000000007ffd,
  0xffffffffffffffc0, 0x0000000000007ffe,
  0xffffffffffffffc0, 0x0000000000007fff,
  0xffffffffffffffc0, 0x000000007ffffffd,
  0xffffffffffffffc0, 0x000000007ffffffe,
  0xffffffffffffffc0, 0x000000007fffffff,
  0xffffffffffffffc0, 0x3333333333333333,
  0xffffffffffffffc0, 0x5555555555555555,
  0xffffffffffffffc0, 0x7ffffffffffffffd,
  0xffffffffffffffc0, 0x7ffffffffffffffe,
  0xffffffffffffffc0, 0x7fffffffffffffff,
  0xffffffffffffffc0, 0x8000000000000000,
  0xffffffffffffffc0, 0x8000000000000001,
  0xffffffffffffffc0, 0x8000000000000002,
  0xffffffffffffffc0, 0x8000000000000003,
  0xffffffffffffffc0, 0xaaaaaaaaaaaaaaaa,
  0xffffffffffffffc0, 0xcccccccccccccccc,
  0xffffffffffffffc0, 0xffffffff80000000,
  0xffffffffffffffc0, 0xffffffff80000001,
  0xffffffffffffffc0, 0xffffffff80000002,
  0xffffffffffffffc0, 0xffffffff80000003,
  0xffffffffffffffc0, 0xffffffffffff8000,
  0xffffffffffffffc0, 0xffffffffffff8001,
  0xffffffffffffffc0, 0xffffffffffff8002,
  0xffffffffffffffc0, 0xffffffffffff8003,
  0xffffffffffffffc0, 0xffffffffffffff80,
  0xffffffffffffffc0, 0xffffffffffffff81,
  0xffffffffffffffc0, 0xffffffffffffff82,
  0xffffffffffffffc0, 0xffffffffffffff83,
  0xffffffffffffffc0, 0xffffffffffffffc0,
  0xffffffffffffffc0, 0xfffffffffffffffd,
  0xffffffffffffffc0, 0xfffffffffffffffe,
  0xffffffffffffffc0, 0xffffffffffffffff,
  0xfffffffffffffffd, 0x0000000000000000,
  0xfffffffffffffffd, 0x0000000000000001,
  0xfffffffffffffffd, 0x0000000000000002,
  0xfffffffffffffffd, 0x0000000000000040,
  0xfffffffffffffffd, 0x000000000000007d,
  0xfffffffffffffffd, 0x000000000000007e,
  0xfffffffffffffffd, 0x000000000000007f,
  0xfffffffffffffffd, 0x0000000000007ffd,
  0xfffffffffffffffd, 0x0000000000007ffe,
  0xfffffffffffffffd, 0x0000000000007fff,
  0xfffffffffffffffd, 0x000000007ffffffd,
  0xfffffffffffffffd, 0x000000007ffffffe,
  0xfffffffffffffffd, 0x000000007fffffff,
  0xfffffffffffffffd, 0x3333333333333333,
  0xfffffffffffffffd, 0x5555555555555555,
  0xfffffffffffffffd, 0x7ffffffffffffffd,
  0xfffffffffffffffd, 0x7ffffffffffffffe,
  0xfffffffffffffffd, 0x7fffffffffffffff,
  0xfffffffffffffffd, 0x8000000000000000,
  0xfffffffffffffffd, 0x8000000000000001,
  0xfffffffffffffffd, 0x8000000000000002,
  0xfffffffffffffffd, 0x8000000000000003,
  0xfffffffffffffffd, 0xaaaaaaaaaaaaaaaa,
  0xfffffffffffffffd, 0xcccccccccccccccc,
  0xfffffffffffffffd, 0xffffffff80000000,
  0xfffffffffffffffd, 0xffffffff80000001,
  0xfffffffffffffffd, 0xffffffff80000002,
  0xfffffffffffffffd, 0xffffffff80000003,
  0xfffffffffffffffd, 0xffffffffffff8000,
  0xfffffffffffffffd, 0xffffffffffff8001,
  0xfffffffffffffffd, 0xffffffffffff8002,
  0xfffffffffffffffd, 0xffffffffffff8003,
  0xfffffffffffffffd, 0xffffffffffffff80,
  0xfffffffffffffffd, 0xffffffffffffff81,
  0xfffffffffffffffd, 0xffffffffffffff82,
  0xfffffffffffffffd, 0xffffffffffffff83,
  0xfffffffffffffffd, 0xffffffffffffffc0,
  0xfffffffffffffffd, 0xfffffffffffffffd,
  0xfffffffffffffffd, 0xfffffffffffffffe,
  0xfffffffffffffffd, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000001,
  0xfffffffffffffffe, 0x0000000000000002,
  0xfffffffffffffffe, 0x0000000000000040,
  0xfffffffffffffffe, 0x000000000000007d,
  0xfffffffffffffffe, 0x000000000000007e,
  0xfffffffffffffffe, 0x000000000000007f,
  0xfffffffffffffffe, 0x0000000000007ffd,
  0xfffffffffffffffe, 0x0000000000007ffe,
  0xfffffffffffffffe, 0x0000000000007fff,
  0xfffffffffffffffe, 0x000000007ffffffd,
  0xfffffffffffffffe, 0x000000007ffffffe,
  0xfffffffffffffffe, 0x000000007fffffff,
  0xfffffffffffffffe, 0x3333333333333333,
  0xfffffffffffffffe, 0x5555555555555555,
  0xfffffffffffffffe, 0x7ffffffffffffffd,
  0xfffffffffffffffe, 0x7ffffffffffffffe,
  0xfffffffffffffffe, 0x7fffffffffffffff,
  0xfffffffffffffffe, 0x8000000000000000,
  0xfffffffffffffffe, 0x8000000000000001,
  0xfffffffffffffffe, 0x8000000000000002,
  0xfffffffffffffffe, 0x8000000000000003,
  0xfffffffffffffffe, 0xaaaaaaaaaaaaaaaa,
  0xfffffffffffffffe, 0xcccccccccccccccc,
  0xfffffffffffffffe, 0xffffffff80000000,
  0xfffffffffffffffe, 0xffffffff80000001,
  0xfffffffffffffffe, 0xffffffff80000002,
  0xfffffffffffffffe, 0xffffffff80000003,
  0xfffffffffffffffe, 0xffffffffffff8000,
  0xfffffffffffffffe, 0xffffffffffff8001,
  0xfffffffffffffffe, 0xffffffffffff8002,
  0xfffffffffffffffe, 0xffffffffffff8003,
  0xfffffffffffffffe, 0xffffffffffffff80,
  0xfffffffffffffffe, 0xffffffffffffff81,
  0xfffffffffffffffe, 0xffffffffffffff82,
  0xfffffffffffffffe, 0xffffffffffffff83,
  0xfffffffffffffffe, 0xffffffffffffffc0,
  0xfffffffffffffffe, 0xfffffffffffffffd,
  0xfffffffffffffffe, 0xfffffffffffffffe,
  0xfffffffffffffffe, 0xffffffffffffffff,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000001,
  0xffffffffffffffff, 0x0000000000000002,
  0xffffffffffffffff, 0x0000000000000040,
  0xffffffffffffffff, 0x000000000000007d,
  0xffffffffffffffff, 0x000000000000007e,
  0xffffffffffffffff, 0x000000000000007f,
  0xffffffffffffffff, 0x0000000000007ffd,
  0xffffffffffffffff, 0x0000000000007ffe,
  0xffffffffffffffff, 0x0000000000007fff,
  0xffffffffffffffff, 0x000000007ffffffd,
  0xffffffffffffffff, 0x000000007ffffffe,
  0xffffffffffffffff, 0x000000007fffffff,
  0xffffffffffffffff, 0x3333333333333333,
  0xffffffffffffffff, 0x5555555555555555,
  0xffffffffffffffff, 0x7ffffffffffffffd,
  0xffffffffffffffff, 0x7ffffffffffffffe,
  0xffffffffffffffff, 0x7fffffffffffffff,
  0xffffffffffffffff, 0x8000000000000000,
  0xffffffffffffffff, 0x8000000000000001,
  0xffffffffffffffff, 0x8000000000000002,
  0xffffffffffffffff, 0x8000000000000003,
  0xffffffffffffffff, 0xaaaaaaaaaaaaaaaa,
  0xffffffffffffffff, 0xcccccccccccccccc,
  0xffffffffffffffff, 0xffffffff80000000,
  0xffffffffffffffff, 0xffffffff80000001,
  0xffffffffffffffff, 0xffffffff80000002,
  0xffffffffffffffff, 0xffffffff80000003,
  0xffffffffffffffff, 0xffffffffffff8000,
  0xffffffffffffffff, 0xffffffffffff8001,
  0xffffffffffffffff, 0xffffffffffff8002,
  0xffffffffffffffff, 0xffffffffffff8003,
  0xffffffffffffffff, 0xffffffffffffff80,
  0xffffffffffffffff, 0xffffffffffffff81,
  0xffffffffffffffff, 0xffffffffffffff82,
  0xffffffffffffffff, 0xffffffffffffff83,
  0xffffffffffffffff, 0xffffffffffffffc0,
  0xffffffffffffffff, 0xfffffffffffffffd,
  0xffffffffffffffff, 0xfffffffffffffffe,
  0xffffffffffffffff, 0xffffffffffffffff,
};
const unsigned kExpectedCount_NEON_zip2_2D = 1600;

#endif  // VIXL_SIM_ZIP2_2D_TRACE_AARCH64_H_
