
2021-05-11 Triage Log

Not much change overall - both regressions and improvements were all minor, apart from the 2x compile-time improvement for libcore from PR [#83278](https://github.com/rust-lang/rust/issues/83278).

We did see a pretty clear 2% improvement in memory usage ([max-rss](https://perf.rust-lang.org/?start=7a0f1781d04662041db5deaef89598a8edd53717&end=382f748f23979e37e3e012b090e5a0313463f182&absolute=false&stat=max-rss)), and that was again due to PR [#83278](https://github.com/rust-lang/rust/issues/83278).

Triage done by **@pnkfelix**.
Revision range: [7a0f1781d04662041db5deaef89598a8edd53717..382f748f23979e37e3e012b090e5a0313463f182](https://perf.rust-lang.org/?start=7a0f1781d04662041db5deaef89598a8edd53717&end=382f748f23979e37e3e012b090e5a0313463f182&absolute=false&stat=instructions%3Au)

2 Regressions, 3 Improvements, 0 Mixed
0 of them in rollups

#### Regressions

Integrate attributes as part of the crate hash [#83901](https://github.com/rust-lang/rust/issues/83901)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=770792ff8d1ec542e78e77876ac936f43ffb8e05&end=467253ff6a2aecd008d273286315ac14ff8ad937&stat=instructions:u) (up to 1.6% on `full` builds of `externs-check`)
- There was a regression, seems roughly consistent with the results that we got from the perf run on the PR, so this regression was expected outcome.

Bump stdarch submodule [#83278](https://github.com/rust-lang/rust/issues/83278)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=ff34b919075f35a1787659e9c448a34b06bab8de&end=881c1ac408d93bb7adaa3a51dabab9266e82eee8&stat=instructions:u) (up to 3.3% on `full` builds of `keccak-debug`)
- There are regressions, but as noted in [PR comments](https://github.com/rust-lang/rust/pull/83278#issuecomment-835570336), they were not as bad as anticipated. And also, we did continue to see the 2x win on compile-time for libcore.

#### Improvements

Retain data in vectorized registers for longer [#84915](https://github.com/rust-lang/rust/issues/84915)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=ae8b84bf04cddda2379b36c45a575132e6a44fb0&end=45ccf910703fe7afee30cf223ed046ed2d2afb91&stat=instructions:u) (up to -1.3% on `full` builds of `keccak-debug`)
- (Slight improvement, as expected from perf run on the PR itself.)

lazify backtrace formatting for delayed diagnostics [#84965](https://github.com/rust-lang/rust/issues/84965)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=1d99508b52499c9efd213738e71927458c1d394e&end=109248a4eb99bc83684c94ca4ef36f2fadc17e2a&stat=instructions:u) (up to -2.2% on `incr-unchanged` builds of `cranelift-codegen-check`)
- (Slight improvement, though PR itself is focused on a narrower case of interest, namely the time to run the ui test suite with debuginfo turned on. In *that* context, its a huge win, going from 42s to 34s according to the PR author.)

Optimize BufWriter [#79930](https://github.com/rust-lang/rust/issues/79930)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=377d1a984cd2a53327092b90aa1d8b7e22d1e347&end=676ee14729462585b969bbc52f32c307403f4126&stat=instructions:u) (up to -1.8% on `incr-unchanged` builds of `encoding-check`)
- (Slight improvement, with some very minor regressions/noise mixed in. But we would not expect `BufWriter` activity to be on the hot-path of rustc itself, so its not surprising that the optimization here would have little effect on the perf.rlo benchmark suite.)

#### Mixed



#### Nags requiring follow up

No new nags this week, and none leftover from last week.
