% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logmap.R
\name{as.matrix.LogMap}
\alias{as.matrix.LogMap}
\title{Coerce Logical Maps to Matrices}
\usage{
\method{as.matrix}{LogMap}(x, ...)
}
\arguments{
\item{x}{A \code{\link{LogMap}} object}

\item{...}{Ignored}
}
\value{
A base-R matrix created from \code{x}
}
\description{
Coerce a logical map to a matrix; this removes all
\link[=LogMap]{logical map} class capabilities from
the object and returns a base-R matrix object
}
\examples{
map <- LogMap(letters[1:10])
map[['obs']] <- c(1, 3, 7)
mat <- as.matrix(map)
mat
class(mat)

}
\seealso{
Logical map objects, validity, and interaction methods:
\code{\link{LogMap}},
\code{\link{LogMap-validity}},
\code{\link{droplevels.LogMap}()},
\code{\link{intersect.LogMap}()},
\code{\link{labels.LogMap}()}
}
\concept{logmap}
