% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_survfit.R
\name{plot.survfit.stanjm}
\alias{plot.survfit.stanjm}
\alias{plot_stack_jm}
\title{Plot the estimated subject-specific or marginal survival function}
\usage{
\method{plot}{survfit.stanjm}(
  x,
  ids = NULL,
  limits = c("ci", "none"),
  xlab = NULL,
  ylab = NULL,
  facet_scales = "free",
  ci_geom_args = NULL,
  ...
)

plot_stack_jm(yplot, survplot)
}
\arguments{
\item{x}{A data frame and object of class \code{survfit.stanjm}
returned by a call to the function \code{\link{posterior_survfit}}.
The object contains point estimates and uncertainty interval limits
for estimated values of the survival function.}

\item{ids}{An optional vector providing a subset of subject IDs for whom 
the predicted curves should be plotted.}

\item{limits}{A quoted character string specifying the type of limits to
include in the plot. Can be one of: \code{"ci"} for the Bayesian
posterior uncertainty interval for the estimated survival probability
(often known as a credible interval); or \code{"none"} for no interval 
limits.}

\item{xlab, ylab}{An optional axis label passed to 
\code{\link[ggplot2]{labs}}.}

\item{facet_scales}{A character string passed to the \code{scales}
argument of \code{\link[ggplot2]{facet_wrap}} when plotting the 
longitudinal trajectory for more than one individual.}

\item{ci_geom_args}{Optional arguments passed to 
\code{\link[ggplot2]{geom_ribbon}} and used to control features
of the plotted interval limits. They should be supplied as a named list.}

\item{...}{Optional arguments passed to 
\code{\link[ggplot2:geom_path]{geom_line}} and used to control features
of the plotted survival function.}

\item{yplot}{An object of class \code{plot.predict.stanjm}, returned by a 
call to the generic \code{\link[=plot.predict.stanjm]{plot}} method for 
objects of class \code{predict.stanjm}. If there is more than one 
longitudinal outcome, then a list of such objects can be provided.}

\item{survplot}{An object of class \code{plot.survfit.stanjm}, returned by a 
call to the generic \code{\link[=plot.survfit.stanjm]{plot}} method for 
objects of class \code{survfit.stanjm}.}
}
\value{
The plot method returns a \code{ggplot} object, also of class
  \code{plot.survfit.stanjm}. This object can be further customised using the
  \pkg{ggplot2} package. It can also be passed to the function
  \code{plot_stack_jm}.

\code{plot_stack_jm} returns an object of class
  \code{\link[bayesplot]{bayesplot_grid}} that includes plots of the
  estimated subject-specific longitudinal trajectories stacked on top of the 
  associated subject-specific survival curve.
}
\description{
This generic \code{plot} method for \code{survfit.stanjm} objects will
plot the estimated subject-specific or marginal survival function
using the data frame returned by a call to \code{\link{posterior_survfit}}.
The call to \code{posterior_survfit} should ideally have included an
"extrapolation" of the survival function, obtained by setting the 
\code{extrapolate} argument to \code{TRUE}.

The \code{plot_stack_jm} function takes arguments containing the plots of the estimated  
subject-specific longitudinal trajectory (or trajectories if a multivariate  
joint model was estimated) and the plot of the estimated subject-specific 
survival function and combines them into a single figure. This is most
easily understood by running the \strong{Examples} below.
}
\examples{
if (.Platform$OS.type != "windows" || .Platform$r_arch != "i386") {
\donttest{
  # Run example model if not already loaded
  if (!exists("example_jm")) example(example_jm)
  
  # Obtain subject-specific conditional survival probabilities
  # for all individuals in the estimation dataset.
  ps1 <- posterior_survfit(example_jm, extrapolate = TRUE)
  
  # We then plot the conditional survival probabilities for
  # a subset of individuals
  plot(ps1, ids = c(7,13,15))
  # We can change or add attributes to the plot
  plot(ps1, ids = c(7,13,15), limits = "none")
  plot(ps1, ids = c(7,13,15), xlab = "Follow up time")
  plot(ps1, ids = c(7,13,15), ci_geom_args = list(fill = "red"),
       color = "blue", linetype = 2)
  plot(ps1, ids = c(7,13,15), facet_scales = "fixed")
  
  # Since the returned plot is also a ggplot object, we can
  # modify some of its attributes after it has been returned
  plot1 <- plot(ps1, ids = c(7,13,15))
  plot1 + 
    ggplot2::theme(strip.background = ggplot2::element_blank()) +
    ggplot2::coord_cartesian(xlim = c(0, 15)) +
    ggplot2::labs(title = "Some plotted survival functions")
    
  # We can also combine the plot(s) of the estimated 
  # subject-specific survival functions, with plot(s) 
  # of the estimated longitudinal trajectories for the
  # same individuals
  ps1 <- posterior_survfit(example_jm, ids = c(7,13,15))
  pt1 <- posterior_traj(example_jm, , ids = c(7,13,15))
  plot_surv <- plot(ps1) 
  plot_traj <- plot(pt1, vline = TRUE, plot_observed = TRUE)
  plot_stack_jm(plot_traj, plot_surv)
   
  # Lastly, let us plot the standardised survival function
  # based on all individuals in our estimation dataset
  ps2 <- posterior_survfit(example_jm, standardise = TRUE, times = 0,
                          control = list(epoints = 20))
  plot(ps2)   
}
}
if (.Platform$OS.type != "windows" || .Platform$r_arch != "i386") {
\donttest{
  if (!exists("example_jm")) example(example_jm)
  ps1 <- posterior_survfit(example_jm, ids = c(7,13,15))
  pt1 <- posterior_traj(example_jm, ids = c(7,13,15), extrapolate = TRUE)
  plot_surv <- plot(ps1) 
  plot_traj <- plot(pt1, vline = TRUE, plot_observed = TRUE)
  plot_stack_jm(plot_traj, plot_surv)
}
}
}
\seealso{
\code{\link{posterior_survfit}}, \code{\link{plot_stack_jm}},
  \code{\link{posterior_traj}}, \code{\link{plot.predict.stanjm}}

\code{\link{plot.predict.stanjm}}, \code{\link{plot.survfit.stanjm}},
  \code{\link{posterior_predict}}, \code{\link{posterior_survfit}}
}
