% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_traj.R
\name{plot.predict.stanjm}
\alias{plot.predict.stanjm}
\title{Plot the estimated subject-specific or marginal longitudinal trajectory}
\usage{
\method{plot}{predict.stanjm}(
  x,
  ids = NULL,
  limits = c("ci", "pi", "none"),
  xlab = NULL,
  ylab = NULL,
  vline = FALSE,
  plot_observed = FALSE,
  facet_scales = "free_x",
  ci_geom_args = NULL,
  grp_overlay = FALSE,
  ...
)
}
\arguments{
\item{x}{A data frame and object of class \code{predict.stanjm}
returned by a call to the function \code{\link{posterior_traj}}.
The object contains point estimates and uncertainty interval limits
for the fitted values of the longitudinal response.}

\item{ids}{An optional vector providing a subset of subject IDs for whom 
the predicted curves should be plotted.}

\item{limits}{A quoted character string specifying the type of limits to
include in the plot. Can be one of: \code{"ci"} for the Bayesian
posterior uncertainty interval for the estimated mean longitudinal
response (often known as a credible interval);
\code{"pi"} for the prediction interval for the estimated (raw)
longitudinal response; or \code{"none"} for no interval limits.}

\item{xlab, ylab}{An optional axis label passed to 
\code{\link[ggplot2]{labs}}.}

\item{vline}{A logical. If \code{TRUE} then a vertical dashed line
is added to the plot indicating the event or censoring time for
the individual. Can only be used if each plot within the figure
is for a single individual.}

\item{plot_observed}{A logical. If \code{TRUE} then the observed
longitudinal measurements are overlaid on the plot.}

\item{facet_scales}{A character string passed to the \code{scales}
argument of \code{\link[ggplot2]{facet_wrap}} when plotting the 
longitudinal trajectory for more than one individual.}

\item{ci_geom_args}{Optional arguments passed to 
\code{\link[ggplot2]{geom_ribbon}} and used to control features
of the plotted interval limits. They should be supplied as a named list.}

\item{grp_overlay}{Only relevant if the model had lower level units 
clustered within an individual. If \code{TRUE}, then the fitted trajectories 
for the lower level units will be overlaid in the same plot region (that 
is, all lower level units for a single individual will be shown within a 
single facet). If \code{FALSE}, then the fitted trajectories for each lower
level unit will be shown in a separate facet.}

\item{...}{Optional arguments passed to 
\code{\link[ggplot2]{geom_smooth}} and used to control features
of the plotted longitudinal trajectory.}
}
\value{
A \code{ggplot} object, also of class \code{plot.predict.stanjm}.
  This object can be further customised using the \pkg{ggplot2} package.
  It can also be passed to the function \code{\link{plot_stack_jm}}.
}
\description{
This generic \code{plot} method for \code{predict.stanjm} objects will
plot the estimated subject-specific or marginal longitudinal trajectory
using the data frame returned by a call to \code{\link{posterior_traj}}.
To ensure that enough data points are available to plot the longitudinal
trajectory, it is assumed that the call to \code{\link{posterior_traj}}
would have used the default \code{interpolate = TRUE}, and perhaps also 
\code{extrapolate = TRUE} (the latter being optional, depending on 
whether or not the user wants to see extrapolation of the longitudinal 
trajectory beyond the last observation time).
}
\examples{
if (.Platform$OS.type != "windows" || .Platform$r_arch != "i386") {
\donttest{
  # Run example model if not already loaded
  if (!exists("example_jm")) example(example_jm)
  
  # For a subset of individuals in the estimation dataset we will
  # obtain subject-specific predictions for the longitudinal submodel 
  # at evenly spaced times between 0 and their event or censoring time.
  pt1 <- posterior_traj(example_jm, ids = c(7,13,15), interpolate = TRUE)
  plot(pt1)                  # credible interval for mean response
  plot(pt1, limits = "pi")   # prediction interval for raw response
  plot(pt1, limits = "none") # no uncertainty interval
  
  # We can also extrapolate the longitudinal trajectories.
  pt2 <- posterior_traj(example_jm, ids = c(7,13,15), interpolate = TRUE,
                        extrapolate = TRUE)
  plot(pt2)
  plot(pt2, vline = TRUE)    # add line indicating event or censoring time
  plot(pt2, vline = TRUE, plot_observed = TRUE)  # overlay observed longitudinal data
 
  # We can change or add attributes to the plot
  plot1 <- plot(pt2, ids = c(7,13,15), xlab = "Follow up time",
                     vline = TRUE, plot_observed = TRUE, 
                     facet_scales = "fixed", color = "blue", linetype = 2,
                     ci_geom_args = list(fill = "red"))
  plot1
       
  # Since the returned plot is also a ggplot object, we can
  # modify some of its attributes after it has been returned
  plot1 + 
    ggplot2::theme(strip.background = ggplot2::element_blank()) +
    ggplot2::labs(title = "Some plotted longitudinal trajectories")
}
}
}
\seealso{
\code{\link{posterior_traj}}, \code{\link{plot_stack_jm}},
  \code{\link{posterior_survfit}}, \code{\link{plot.survfit.stanjm}}
}
