% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqrt.R
\name{step_sqrt}
\alias{step_sqrt}
\title{Square root transformation}
\usage{
step_sqrt(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  columns = NULL,
  skip = FALSE,
  id = rand_id("sqrt")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables
for this step. See \code{\link[=selections]{selections()}} for more details.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{columns}{A character string of the selected variable names. This field
is a placeholder and will be populated once \code{\link[=prep]{prep()}} is used.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake]{bake()}}? While all operations are baked
when \code{\link[=prep]{prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of any existing operations.
}
\description{
\code{step_sqrt()} creates a \emph{specification} of a recipe step that will apply
square root transform to the variables.
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble is returned with
columns \code{terms} and \code{id}:

\describe{
\item{terms}{character, the selectors or variables selected}
\item{id}{character, id of this step}
}
}

\section{Case weights}{


The underlying operation does not allow for case weights.
}

\examples{
set.seed(313)
examples <- matrix(rnorm(40)^2, ncol = 2)
examples <- as.data.frame(examples)

rec <- recipe(~ V1 + V2, data = examples)

sqrt_trans <- rec \%>\%
  step_sqrt(all_numeric_predictors())

sqrt_obj <- prep(sqrt_trans, training = examples)

transformed_te <- bake(sqrt_obj, examples)
plot(examples$V1, transformed_te$V1)

tidy(sqrt_trans, number = 1)
tidy(sqrt_obj, number = 1)
}
\seealso{
Other individual transformation steps: 
\code{\link{step_BoxCox}()},
\code{\link{step_YeoJohnson}()},
\code{\link{step_bs}()},
\code{\link{step_harmonic}()},
\code{\link{step_hyperbolic}()},
\code{\link{step_inverse}()},
\code{\link{step_invlogit}()},
\code{\link{step_log}()},
\code{\link{step_logit}()},
\code{\link{step_mutate}()},
\code{\link{step_ns}()},
\code{\link{step_percentile}()},
\code{\link{step_poly}()},
\code{\link{step_relu}()}
}
\concept{individual transformation steps}
