% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/publish.MIresult.R
\name{publish.MIresult}
\alias{publish.MIresult}
\title{Present logistic regression and Cox regression  obtained with mitools::MIcombine based on smcfcs::smcfcs multiple imputation analysis}
\usage{
\method{publish}{MIresult}(
  object,
  confint.method,
  pvalue.method,
  digits = c(2, 4),
  print = TRUE,
  factor.reference = "extraline",
  intercept,
  units = NULL,
  fit,
  data,
  ...
)
}
\arguments{
\item{object}{Object obtained with mitools::MIcombine based on smcfcs::smcfcs multiple imputation analysis}

\item{confint.method}{No options here. Only Wald type confidence
intervals.}

\item{pvalue.method}{No options here. Only Wald type tests.}

\item{digits}{Rounding digits for all numbers but the p-values.}

\item{print}{If \code{FALSE} suppress printing of the results}

\item{factor.reference}{Style for showing results for
categorical. See \code{regressionTable}.}

\item{intercept}{See \code{regressionTable}.}

\item{units}{See \code{regressionTable}.}

\item{fit}{One fitted model using the same formula as
\code{object}. This can be the fit to the complete case data or
the fit to one of the completed data. It is used to get
xlevels, formula and terms. For usage see examples.  is used to
fit}

\item{data}{Original data set which includes the missing values}

\item{...}{passed to summary.regressionTable, labelUnits and publish.default.}
}
\description{
Regression tables after multiple imputations
}
\details{
Show results of smcfcs based multiple imputations of missing covariates in publishable format
}
\examples{

\dontrun{
if (requireNamespace("riskRegression",quietly=TRUE)
  & requireNamespace("mitools",quietly=TRUE)
  & requireNamespace("smcfcs",quietly=TRUE)){
library(riskRegression)
library(mitools)
library(smcfcs)
## continuous outcome: linear regression
# lava some data with missing values
set.seed(7)
d=sampleData(78)
## generate missing values
d[X1==1,X6:=NA] 
d[X2==1,X3:=NA]
d=d[,.(X8,X4,X3,X6,X7)]
sapply(d,function(x)sum(is.na(x)))

# multiple imputation (should set m to a large value)

set.seed(17)
f= smcfcs(d,smtype="lm",
           smformula=X8~X4+X3+X6+X7,
           method=c("","","logreg","norm",""),m=3)
ccfit=lm(X8~X4+X3+X6+X7,data=d)
mifit=MIcombine(with(imputationList(f$impDatasets),
                lm(X8~X4+X3+X6+X7)))
publish(mifit,fit=ccfit,data=d)
publish(ccfit)

## binary outcome
# lava some data with missing values
set.seed(7)
db=sampleData(78,outcome="binary")
## generate missing values
db[X1==1,X6:=NA] 
db[X2==1,X3:=NA]
db=db[,.(Y,X4,X3,X6,X7)]
sapply(db,function(x)sum(is.na(x)))

# multiple imputation (should set m to a large value)
set.seed(17)
fb= smcfcs(db,smtype="logistic",
           smformula=Y~X4+X3+X6+X7,
           method=c("","","logreg","norm",""),m=2)
ccfit=glm(Y~X4+X3+X6+X7,family="binomial",data=db)
mifit=MIcombine(with(imputationList(fb$impDatasets),
                glm(Y~X4+X3+X6+X7,family="binomial")))
publish(mifit,fit=ccfit)
publish(ccfit)

## survival: Cox regression
library(survival)
# lava some data with missing values
set.seed(7)
ds=sampleData(78,outcome="survival")
## generate missing values
ds[X5==1,X6:=NA] 
ds[X2==1,X3:=NA]
ds=ds[,.(time,event,X4,X3,X6,X7)]
sapply(ds,function(x)sum(is.na(x)))

set.seed(17)
fs= smcfcs(ds,smtype="coxph",
           smformula="Surv(time,event)~X4+X3+X6+X7",
           method=c("","","","logreg","norm",""),m=2)
ccfit=coxph(Surv(time,event)~X4+X3+X6+X7,data=ds)
mifit=MIcombine(with(imputationList(fs$impDatasets),
                coxph(Surv(time,event)~X4+X3+X6+X7)))
publish(mifit,fit=ccfit,data=ds)
publish(ccfit)

## competing risks: Cause-specific Cox regression 
library(survival)
# lava some data with missing values
set.seed(7)
dcr=sampleData(78,outcome="competing.risks")
## generate missing values
dcr[X5==1,X6:=NA] 
dcr[X2==1,X3:=NA]
dcr=dcr[,.(time,event,X4,X3,X6,X7)]
sapply(dcr,function(x)sum(is.na(x)))

set.seed(17)
fcr= smcfcs(dcr,smtype="compet",
           smformula=c("Surv(time,event==1)~X4+X3+X6+X7",
                       "Surv(time,event==2)~X4+X3+X6+X7"),
           method=c("","","","logreg","norm",""),m=2)
## cause 2 
ccfit2=coxph(Surv(time,event==2)~X4+X3+X6+X7,data=dcr)
mifit2=MIcombine(with(imputationList(fcr$impDatasets),
                coxph(Surv(time,event==2)~X4+X3+X6+X7)))
publish(mifit2,fit=ccfit2,data=dcr)
publish(ccfit2)
}
} 

}
\author{
Thomas A. Gerds <tag@biostat.ku.dk>
}
