% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binregTSR.R
\name{binregTSR}
\alias{binregTSR}
\title{2 Stage Randomization for Survival Data or competing Risks Data}
\usage{
binregTSR(
  formula,
  data,
  cause = 1,
  time = NULL,
  cens.code = 0,
  response.code = NULL,
  augmentR0 = NULL,
  treat.model0 = ~+1,
  augmentR1 = NULL,
  treat.model1 = ~+1,
  augmentC = NULL,
  cens.model = ~+1,
  estpr = c(1, 1),
  response.name = NULL,
  offset = NULL,
  weights = NULL,
  cens.weights = NULL,
  beta = NULL,
  kaplan.meier = TRUE,
  no.opt = FALSE,
  method = "nr",
  augmentation = NULL,
  outcome = c("cif", "rmst", "rmst-cause"),
  model = "exp",
  Ydirect = NULL,
  return.dataw = 0,
  pi0 = 0.5,
  pi1 = 0.5,
  cens.time.fixed = 1,
  outcome.iid = 1,
  meanCs = 0,
  ...
)
}
\arguments{
\item{formula}{formula with outcome (see \code{coxph})}

\item{data}{data frame}

\item{cause}{cause of interest}

\item{time}{time of interest}

\item{cens.code}{gives censoring code}

\item{response.code}{code of status of survival data that indicates a response at which 2nd randomization is performed}

\item{augmentR0}{augmentation model for  1st randomization}

\item{treat.model0}{logistic treatment model for 1st randomization}

\item{augmentR1}{augmentation model for  2nd randomization}

\item{treat.model1}{logistic treatment model for 2ndrandomization}

\item{augmentC}{augmentation model for censoring}

\item{cens.model}{stratification for censoring model based on observed covariates}

\item{estpr}{estimate randomization probabilities using model}

\item{response.name}{can give name of response variable, otherwise reads this as first variable of treat.model1}

\item{offset}{not implemented}

\item{weights}{not implemented}

\item{cens.weights}{can be given}

\item{beta}{starting values}

\item{kaplan.meier}{for censoring weights, rather than exp cumulative hazard}

\item{no.opt}{not implemented}

\item{method}{not implemented}

\item{augmentation}{not implemented}

\item{outcome}{can be c("cif","rmst","rmst-cause")}

\item{model}{not implemented, uses linear regression for augmentation}

\item{Ydirect}{use this Y instead of outcome constructed inside the program (e.g. I(T< t, epsilon=1)), see binreg for more on this}

\item{return.dataw}{to return weighted data for all treatment regimes}

\item{pi0}{set up known randomization probabilities}

\item{pi1}{set up known randomization probabilities}

\item{cens.time.fixed}{to use time-dependent weights for censoring estimation using weights}

\item{outcome.iid}{to get iid contribution from outcome model (here linear regression working models).}

\item{meanCs}{(0) indicates that censoring augmentation is centered by CensAugment.times/n}

\item{...}{Additional arguments to lower level funtions}
}
\description{
Under two-stage randomization we can estimate the average treatment effect E(Y(i,j)) of treatment regime (i,j). 
The estimator can be agumented in different ways: using the two randomizations and the dynamic censoring augmetatation.
The treatment's must be given as factors.
}
\details{
The solved estimating eqution is 
\deqn{  (  I(min(T_i,t) < G_i)/G_c(min(T_i ,t)) I(T \leq t, \epsilon=1 ) - AUG_0 - AUG_1 + AUG_C  -  p(i,j)) = 0 }
where  using the covariates from augmentR0
\deqn{ AUG_0 = \frac{A_0(i) - \pi_0(i)}{ \pi_0(i)} X_0 \gamma_0}
and  using the covariates from augmentR1
\deqn{ AUG_1 = \frac{A_0(i)}{\pi_0(i)} \frac{A_1(j) - \pi_1(j)}{ \pi_1(j)} X_1 \gamma_1}
and   the censoring augmentation is 
\deqn{  AUG_C =  \int_0^t \gamma_c(s)^T (e(s) - \bar e(s))  \frac{1}{G_c(s) } dM_c(s) }
where 
\deqn{ \gamma_c(s)} is chosen to minimize the variance given the dynamic  covariates specified by augmentC.

In the observational case, we can use propensity score modelling and outcome modelling (using linear regression).

Standard errors are estimated using the influence function  of all estimators and tests of differences can therefore be computed
subsequently.
}
\examples{

ddf <- mets:::gsim(200,covs=1,null=0,cens=1,ce=2)

bb <- binregTSR(Event(entry,time,status)~+1+cluster(id),ddf$datat,time=2,cause=c(1),
        cens.code=0,treat.model0=A0.f~+1,treat.model1=A1.f~A0.f,
        augmentR1=~X11+X12+TR,augmentR0=~X01+X02,
        augmentC=~A01+A02+X01+X02+A11t+A12t+X11+X12+TR,
        response.code=2)
summary(bb) 
}
\author{
Thomas Scheike
}
