% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{methods}
\name{fixef}
\alias{fixef}
\alias{fixef.glmmTMB}
\title{Extract fixed-effects estimates}
\usage{
\method{fixef}{glmmTMB}(object, ...)
}
\arguments{
\item{object}{any fitted model object from which fixed effects estimates can
be extracted.}

\item{\dots}{optional additional arguments. Currently none are used in any
methods.}
}
\value{
an object of class \code{fixef.glmmTMB} comprising a list of components (\code{cond}, \code{zi}, \code{disp}), each containing a (possibly zero-length) numeric vector of coefficients
}
\description{
Extract Fixed Effects
}
\details{
Extract fixed effects from a fitted \code{glmmTMB} model.

The print method for \code{fixef.glmmTMB} object \emph{only displays non-trivial components}: in particular, the dispersion parameter estimate is not printed for models with a single (intercept) dispersion parameter (see examples)
}
\examples{
data(sleepstudy, package = "lme4")
fm1 <- glmmTMB(Reaction ~ Days, sleepstudy)
(f1 <- fixef(fm1))
f1$cond
## show full coefficients, including empty z-i model and
## constant dispersion parameter
print(f1, print_trivials = TRUE)
}
\keyword{models}
