% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggcascade.R
\name{ggcascade}
\alias{ggcascade}
\alias{compute_cascade}
\alias{plot_cascade}
\title{Cascade plot}
\usage{
ggcascade(
  .data,
  ...,
  .weights = NULL,
  .by = NULL,
  .nrow = NULL,
  .ncol = NULL,
  .add_n = TRUE,
  .text_size = 4,
  .arrows = TRUE
)

compute_cascade(.data, ..., .weights = NULL, .by = NULL)

plot_cascade(
  .data,
  .by = NULL,
  .nrow = NULL,
  .ncol = NULL,
  .add_n = TRUE,
  .text_size = 4,
  .arrows = TRUE
)
}
\arguments{
\item{.data}{A data frame, or data frame extension (e.g. a tibble). For
\code{plot_cascade()}, the variable displayed on the x-axis should be named
\code{"x"} and the number of observations should be named \code{"n"}, like the
tibble returned by \code{compute_cascade()}.}

\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}> Name-value pairs of
conditions defining the different statuses to be plotted (see examples).}

\item{.weights}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Optional weights.
Should select only one variable.}

\item{.by}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> A variable or a set
of variables to group by the computation of the cascade, and to generate
facets. To select several variables, use \code{\link[dplyr:pick]{dplyr::pick()}} (see examples).}

\item{.nrow, .ncol}{Number of rows and columns, for faceted plots.}

\item{.add_n}{Display the number of observations?}

\item{.text_size}{Size of the labels, passed to \code{\link[ggplot2:geom_text]{ggplot2::geom_text()}}.}

\item{.arrows}{Display arrows between statuses?}
}
\value{
A \code{ggplot2} plot or a \code{tibble}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\details{
\code{ggcascade()} calls \code{compute_cascade()} to generate a data set passed
to \code{plot_cascade()}. Use \code{compute_cascade()} and \code{plot_cascade()} for
more controls.
}
\examples{
ggplot2::diamonds |>
  ggcascade(
    all = TRUE,
    big = carat > .5,
    "big & ideal" = carat > .5 & cut == "Ideal"
  )

ggplot2::mpg |>
  ggcascade(
    all = TRUE,
    recent = year > 2000,
    "recent & economic" = year > 2000 & displ < 3,
    .by = cyl,
    .ncol = 3,
    .arrows = FALSE,
    .text_size = 3
  )

ggplot2::mpg |>
  ggcascade(
    all = TRUE,
    recent = year > 2000,
    "recent & economic" = year > 2000 & displ < 3,
    .by = pick(cyl, drv),
    .add_n = FALSE,
    .text_size = 2
  )
}
