% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{lsmeans}
\alias{lsmeans}
\alias{wrappers}
\alias{lstrends}
\alias{lsmip}
\alias{lsm}
\alias{lsmobj}
\alias{lsm.options}
\alias{get.lsm.option}
\title{Wrappers for alternative naming of EMMs}
\usage{
lsmeans(...)

lstrends(...)

lsmip(...)

lsm(...)

lsmobj(...)

lsm.options(...)

get.lsm.option(x, default = emm_defaults[[x]])
}
\arguments{
\item{...}{Arguments passed to the corresponding \code{em}\emph{xxxx} function}

\item{x}{Character name of desired option}

\item{default}{default value to return if \code{x} not found}
}
\value{
The result of the call to \code{em}\emph{xxxx}, suitably modified.

\code{get.lsm.option} and \code{lsm.options} remap options from
  and to corresponding options in the \pkg{emmeans} options system.
}
\description{
These are wrappers for \code{\link{emmeans}} and related functions to provide
backward compatibility, or for users who may prefer to
use other terminology than \dQuote{estimated marginal means} -- namely 
\dQuote{least-squares means}. These functions also provide the functionality
formerly provided by the \pkg{lsmeans} package, which is now just a front-end
for \pkg{emmeans}.
}
\details{
For each function with \code{ls}\emph{xxxx} in its name,
the same function named \code{em}\emph{xxxx} is called. Any estimator names or 
list items beginning with \dQuote{em} are replaced with \dQuote{ls} 
before the results are returned
}
\examples{
pigs.lm <- lm(log(conc) ~ source + factor(percent), data = pigs)
lsmeans(pigs.lm, "source")
}
\seealso{
\code{\link{emmeans}}, \code{\link{emtrends}}, \code{\link{emmip}},
         \code{\link{emm}}, \code{\link{emmobj}}, \code{\link{emm_options}},
         \code{\link{get_emm_option}}
}
