% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cli.R
\name{cli_code}
\alias{cli_code}
\title{A block of code}
\usage{
cli_code(
  lines = NULL,
  ...,
  language = "R",
  .auto_close = TRUE,
  .envir = environment()
)
}
\arguments{
\item{lines}{Character vector, each line will be a line of code, and
newline characters also create new lines. Note that \emph{no} glue
substitution is performed on the code.}

\item{...}{More character vectors, they are appended to \code{lines}.}

\item{language}{Programming language. This is also added as a class,
in addition to \code{code}.}

\item{.auto_close}{Passed to \code{cli_div()} when creating the container of
the code. By default the code container is closed after emitting
\code{lines} and \code{...} via \code{cli_verbatim()}. You can keep that container
open with \code{.auto_close} and/or \code{.envir}, and then calling
\code{cli_verbatim()} to add (more) code. Note that the code will be
formatted and syntax highlighted separately for each \code{cli_verbatim()}
call.}

\item{.envir}{Passed to \code{cli_div()} when creating the container of the
code.}
}
\value{
The id of the container that contains the code.
}
\description{
A helper function that creates a \code{div} with class \code{code} and then calls
\code{cli_verbatim()} to output code lines. The builtin theme formats these
containers specially. In particular, it adds syntax highlighting to
valid R code.
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{myfun <- function() \{
  message("Just an example function")
  graphics::pairs(iris, col = 1:4)
\}
cli_code(format(myfun))
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="color: #DC322F;">function</span> <span style="color: #B58900;">()</span>                                                                     
#> <span style="color: #B58900;">\{</span>                                                                               
#>     <span style="color: #2AA198;">message</span><span style="color: #268BD2;">(</span><span style="color: #B58900;">"Just an example function"</span><span style="color: #268BD2;">)</span>                                         
#>     graphics::<span style="color: #2AA198;">pairs</span><span style="color: #268BD2;">(</span>iris, col = <span style="color: #268BD2;">1</span><span style="color: #859900;">:</span><span style="color: #268BD2;">4)</span>                                            
#> <span style="color: #B58900;">\}</span>                                                                               
</pre></div>
}}
}
