% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-logical.R
\name{chk_logical}
\alias{chk_logical}
\alias{vld_logical}
\title{Check Logical}
\usage{
chk_logical(x, x_name = NULL)

vld_logical(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if logical using

\code{is.logical(x)}

If you want to check if it is a scalar,
meaning that in addition to being of logical type,
it has \code{length(x) == 1}, you should use \code{\link[=chk_lgl]{chk_lgl()}}
}
\section{Functions}{
\itemize{
\item \code{vld_logical()}: Validate Logical

}}
\examples{
# chk_logical
chk_logical(TRUE)
try(chk_logical(1))
# vld_logical
vld_logical(TRUE)
vld_logical(matrix(TRUE))
vld_logical(logical(0))
vld_logical(NA)
vld_logical(1)
vld_logical("TRUE")
}
\seealso{
\code{\link[=is.logical]{is.logical()}}

For more details about the use of this function,
please read the article
\code{vignette("chk-families")}.

Other logical_checkers: 
\code{\link{chk_false}()},
\code{\link{chk_flag}()},
\code{\link{chk_lgl}()},
\code{\link{chk_true}()}

Other data_type_checkers: 
\code{\link{chk_character}()},
\code{\link{chk_character_or_factor}()},
\code{\link{chk_complex}()},
\code{\link{chk_double}()},
\code{\link{chk_environment}()},
\code{\link{chk_integer}()},
\code{\link{chk_numeric}()},
\code{\link{chk_raw}()}
}
\concept{data_type_checkers}
\concept{logical_checkers}
