% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{prior_summary.brmsfit}
\alias{prior_summary.brmsfit}
\alias{prior_summary}
\title{Priors of \code{brms} models}
\usage{
\method{prior_summary}{brmsfit}(object, all = TRUE, ...)
}
\arguments{
\item{object}{An object of class \code{brmsfit}.}

\item{all}{Logical; Show all parameters in the model which may have
priors (\code{TRUE}) or only those with proper priors (\code{FALSE})?}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
An \code{brmsprior} object.
}
\description{
Extract priors of models fitted with \pkg{brms}.
}
\examples{
\dontrun{
fit <- brm(
  count ~ zAge + zBase * Trt + (1|patient) + (1|obs),
  data = epilepsy, family = poisson(),
  prior = prior(student_t(5,0,10), class = b) +
    prior(cauchy(0,2), class = sd)
)

prior_summary(fit)
prior_summary(fit, all = FALSE)
print(prior_summary(fit, all = FALSE), show_df = FALSE)
}

}
