% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/protgenerics.R
\name{backendInitialize}
\alias{backendInitialize}
\alias{isReadOnly}
\alias{setBackend}
\alias{backendMerge}
\alias{backendBpparam}
\alias{backendParallelFactor}
\alias{supportsSetBackend}
\title{General backend methods}
\usage{
backendInitialize(object, ...)

isReadOnly(object)

setBackend(object, backend, ...)

backendMerge(object, ...)

backendBpparam(object, ...)

backendParallelFactor(object, ...)

supportsSetBackend(object, ...)
}
\arguments{
\item{object}{The \emph{backend} object.}

\item{...}{Optional parameters.}

\item{backend}{A \emph{backend} object.}
}
\description{
These methods are used for implementations of \emph{backends} e.g. for \code{Spectra}
or \code{Chromatograms} object to initialize the backend, merge backends or
extract specific information from them.
See the respective help pages (e.g. in the \code{Spectra} or \code{Chromatograms}
packages) for information on the actual implementations of these methods.
}
