% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchMetadata.R
\name{searchMetadata}
\alias{searchMetadata}
\alias{gypsum.search.clause}
\alias{Ops.gypsum.search.clause}
\alias{searchMetadataText}
\alias{defineTextQuery}
\alias{searchMetadataTextFilter}
\alias{gsc}
\alias{searchMetadataFilter}
\title{Search the metadata database}
\usage{
searchMetadata(path, query, latest = TRUE, include.metadata = TRUE)

gsc(
  text = NULL,
  project = NULL,
  asset = NULL,
  version = NULL,
  path = NULL,
  user = NULL,
  time = NULL,
  field = NULL,
  partial = FALSE,
  after = TRUE
)

searchMetadataFilter(
  query,
  pid.name = "paths.pid",
  project.name = "versions.project",
  asset.name = "versions.asset",
  version.name = "versions.version",
  path.name = "paths.path",
  user.name = "versions.user",
  time.name = "versions.time"
)
}
\arguments{
\item{path}{For \code{searchMetadata}, a string containing a path to a SQLite file, usually obtained via \code{\link{fetchMetadataDatabase}}.

For \code{gsc}, the suffix of the object key of the metadata document, 
i.e., the relative \dQuote{path} to the metadata file inside the version's \dQuote{directory}.
This may be missing as long as other arguments are supplied to \code{gsc}.}

\item{query}{A gypsum.search.clause object, typically produced by \code{gsc} or \code{\link{translateTextQuery}}.}

\item{latest}{Logical scalar indicating whether to only search for matches within the latest version of each asset.}

\item{include.metadata}{Logical scalar indicating whether metadata should be returned.}

\item{text}{String containing the text to query on.
This will be automatically tokenized, see Details.
This may be missing as long as other arguments are supplied to \code{gsc}.}

\item{project}{String containing the name of the project.
This may be missing as long as other arguments are supplied to \code{gsc}.}

\item{asset}{String containing the name of the asset.
This may be missing as long as other arguments are supplied to \code{gsc}.}

\item{version}{String containing the name of the version.
This may be missing as long as other arguments are supplied to \code{gsc}.}

\item{user}{String containing the user ID of the uploader.
This may be missing as long as other arguments are supplied to \code{gsc}.}

\item{time}{Number specifying the Unix timestamp (in seconds) at which the upload was finished.
This may be missing as long as other arguments are supplied to \code{gsc}.}

\item{field}{String specifying the name of the metadata field in which to search for \code{text}.
If \code{NULL}, the search is performed on all available metadata fields.}

\item{partial}{For \code{gsc}, a logical scalar indicating whether \code{text}, \code{project}, \code{asset}, \code{version}, \code{path} or \code{user} 
contains SQLite wildcards (\code{\%}, \code{_}) for a partial search.
For \code{text}, setting \code{partial=TRUE} also ensures that the wildcards are preserved during tokenization.}

\item{after}{Logical scalar indicating whether to search for documents that were uploaded after \code{time}.
If \code{FALSE}, the search will instead consider documents that were uploaded at or before \code{time}.}

\item{pid.name}{String containing the name/alias of the column of the \code{paths} table that contains the path ID.}

\item{project.name}{String containing the name/alias of the column of the \code{versions} table that contains the project name.}

\item{asset.name}{String containing the name/alias of the column of the \code{versions} table that contains the asset name.}

\item{version.name}{String containing the name/alias of the column of the \code{versions} table that contains the version name.}

\item{path.name}{String containing the name/alias of the column of the \code{paths} table that contains the path name.}

\item{user.name}{String containing the name/alias of the column of the \code{versions} table that contains the user ID of the uploader.}

\item{time.name}{String containing the name/alias of the column of the \code{versions} table that contains the upload time.}
}
\value{
For \code{searchMetadata}, a data frame specifying the contaning the search results.
\itemize{
\item The \code{project}, \code{asset} and \code{version} columns specify the version of the project asset with matching metadata.
\item The \code{path} column contains the suffix of the object key of the metadata document,
i.e., the relative \dQuote{path} within the version's \dQuote{directory} to the metadata document.
The full object key of the document inside the bucket is defined as \code{{project}/{asset}/{version}/{path}}.
\item The \code{user} column contains the identity of the uploading user.
\item The \code{time} column contains the time of the upload.
\item If \code{include.metadata=TRUE}, a \code{metadata} column is present with the nested metadata for each match.
\item If \code{latest=TRUE}, a \code{latest} column is present indicating whether the matching version is the latest for its asset.
Otherwise, only the latest version is returned.
}

For \code{searchMetadataFilter}, a list containing \code{where}, a string can be directly used as a WHERE filter condition in a SQL SELECT statement;
and \code{parameters}, the parameter bindings to be used in \code{where}.
The return value may also be \code{NULL} if the query has no well-defined filter.

For \code{gsc}, a gypsum.search.clause object that can be used in \code{|}, \code{&} and \code{!} to create more complex queries involving multiple clauses.
}
\description{
Search a SQLite database containing metadata from the gypsum backend.
This is based on a precomputed tokenization of all string properties in each metadata document;
see \url{https://github.com/ArtifactDB/bioconductor-metadata-index} for details.
}
\details{
Each query string is tokenized by converting it to lower case and splitting it on characters that are not Unicode letters/numbers or a dash.
We currently do not remove diacritics so these will need to be converted to ASCII by the user. 
If a text query involves only non-letter/number/dash characters, the filter will not be well-defined and will be ignored when constructing SQL statements.
The metadata document/field is only considered to match the query string if all of the tokens can be found in that document/field (in any order).
}
\examples{
path <- fetchMetadataDatabase()
searchMetadata(path, gsc("mouse brain"), include.metadata=FALSE)

# Now for a slightly more complex query:
query <- (gsc("brain") | gsc("pancreas")) & gsc("10090", field="taxonomy_id")
searchMetadata(path, query, include.metadata=FALSE)

# Throwing in some wildcards.
has.neuro <- gsc("Neuro\%", partial=TRUE)
searchMetadata(path, has.neuro, include.metadata=FALSE)

# We can also query other properties.
datasets <- gsc(project="scRNAseq") & gsc(asset="l\%", partial=TRUE)
searchMetadata(path, datasets, include.metadata=FALSE)

}
\seealso{
\code{\link{fetchMetadataDatabase}}, to download and cache the database files.

\url{https://github.com/ArtifactDB/bioconductor-metadata-index}, for details on the SQLite file contents and table structure.

\code{\link{translateTextQuery}}, to create a gypsum.search.clause from human-friendly syntax.
}
\author{
Aaron Lun
}
