# -*- coding: utf-8 -*-
# File generated from our OpenAPI spec
from stripe._request_options import RequestOptions
from typing import Dict, List, Union
from typing_extensions import Literal, NotRequired, TypedDict


class ProductCreateParams(RequestOptions):
    active: NotRequired[bool]
    """
    Whether the product is currently available for purchase. Defaults to `true`.
    """
    default_price_data: NotRequired["ProductCreateParamsDefaultPriceData"]
    """
    Data used to generate a new [Price](https://stripe.com/docs/api/prices) object. This Price will be set as the default price for this product.
    """
    description: NotRequired[str]
    """
    The product's description, meant to be displayable to the customer. Use this field to optionally store a long form explanation of the product being sold for your own rendering purposes.
    """
    expand: NotRequired[List[str]]
    """
    Specifies which fields in the response should be expanded.
    """
    id: NotRequired[str]
    """
    An identifier will be randomly generated by Stripe. You can optionally override this ID, but the ID must be unique across all products in your Stripe account.
    """
    images: NotRequired[List[str]]
    """
    A list of up to 8 URLs of images for this product, meant to be displayable to the customer.
    """
    marketing_features: NotRequired[
        List["ProductCreateParamsMarketingFeature"]
    ]
    """
    A list of up to 15 marketing features for this product. These are displayed in [pricing tables](https://stripe.com/docs/payments/checkout/pricing-table).
    """
    metadata: NotRequired[Dict[str, str]]
    """
    Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format. Individual keys can be unset by posting an empty value to them. All keys can be unset by posting an empty value to `metadata`.
    """
    name: str
    """
    The product's name, meant to be displayable to the customer.
    """
    package_dimensions: NotRequired["ProductCreateParamsPackageDimensions"]
    """
    The dimensions of this product for shipping purposes.
    """
    shippable: NotRequired[bool]
    """
    Whether this product is shipped (i.e., physical goods).
    """
    statement_descriptor: NotRequired[str]
    """
    An arbitrary string to be displayed on your customer's credit card or bank statement. While most banks display this information consistently, some may display it incorrectly or not at all.

    This may be up to 22 characters. The statement description may not include `<`, `>`, `\\`, `"`, `'` characters, and will appear on your customer's statement in capital letters. Non-ASCII characters are automatically stripped.
     It must contain at least one letter. Only used for subscription payments.
    """
    tax_code: NotRequired[str]
    """
    A [tax code](https://stripe.com/docs/tax/tax-categories) ID.
    """
    type: NotRequired[Literal["good", "service"]]
    """
    The type of the product. Defaults to `service` if not explicitly specified, enabling use of this product with Subscriptions and Plans. Set this parameter to `good` to use this product with Orders and SKUs. On API versions before `2018-02-05`, this field defaults to `good` for compatibility reasons.
    """
    unit_label: NotRequired[str]
    """
    A label that represents units of this product. When set, this will be included in customers' receipts, invoices, Checkout, and the customer portal.
    """
    url: NotRequired[str]
    """
    A URL of a publicly-accessible webpage for this product.
    """


class ProductCreateParamsDefaultPriceData(TypedDict):
    currency: str
    """
    Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
    """
    currency_options: NotRequired[
        Dict[str, "ProductCreateParamsDefaultPriceDataCurrencyOptions"]
    ]
    """
    Prices defined in each available currency option. Each key must be a three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html) and a [supported currency](https://stripe.com/docs/currencies).
    """
    custom_unit_amount: NotRequired[
        "ProductCreateParamsDefaultPriceDataCustomUnitAmount"
    ]
    """
    When set, provides configuration for the amount to be adjusted by the customer during Checkout Sessions and Payment Links.
    """
    metadata: NotRequired[Dict[str, str]]
    """
    Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format. Individual keys can be unset by posting an empty value to them. All keys can be unset by posting an empty value to `metadata`.
    """
    recurring: NotRequired["ProductCreateParamsDefaultPriceDataRecurring"]
    """
    The recurring components of a price such as `interval` and `interval_count`.
    """
    tax_behavior: NotRequired[Literal["exclusive", "inclusive", "unspecified"]]
    """
    Only required if a [default tax behavior](https://stripe.com/docs/tax/products-prices-tax-categories-tax-behavior#setting-a-default-tax-behavior-(recommended)) was not provided in the Stripe Tax settings. Specifies whether the price is considered inclusive of taxes or exclusive of taxes. One of `inclusive`, `exclusive`, or `unspecified`. Once specified as either `inclusive` or `exclusive`, it cannot be changed.
    """
    unit_amount: NotRequired[int]
    """
    A positive integer in cents (or local equivalent) (or 0 for a free price) representing how much to charge. One of `unit_amount`, `unit_amount_decimal`, or `custom_unit_amount` is required.
    """
    unit_amount_decimal: NotRequired[str]
    """
    Same as `unit_amount`, but accepts a decimal value in cents (or local equivalent) with at most 12 decimal places. Only one of `unit_amount` and `unit_amount_decimal` can be set.
    """


class ProductCreateParamsDefaultPriceDataCurrencyOptions(TypedDict):
    custom_unit_amount: NotRequired[
        "ProductCreateParamsDefaultPriceDataCurrencyOptionsCustomUnitAmount"
    ]
    """
    When set, provides configuration for the amount to be adjusted by the customer during Checkout Sessions and Payment Links.
    """
    tax_behavior: NotRequired[Literal["exclusive", "inclusive", "unspecified"]]
    """
    Only required if a [default tax behavior](https://stripe.com/docs/tax/products-prices-tax-categories-tax-behavior#setting-a-default-tax-behavior-(recommended)) was not provided in the Stripe Tax settings. Specifies whether the price is considered inclusive of taxes or exclusive of taxes. One of `inclusive`, `exclusive`, or `unspecified`. Once specified as either `inclusive` or `exclusive`, it cannot be changed.
    """
    tiers: NotRequired[
        List["ProductCreateParamsDefaultPriceDataCurrencyOptionsTier"]
    ]
    """
    Each element represents a pricing tier. This parameter requires `billing_scheme` to be set to `tiered`. See also the documentation for `billing_scheme`.
    """
    unit_amount: NotRequired[int]
    """
    A positive integer in cents (or local equivalent) (or 0 for a free price) representing how much to charge.
    """
    unit_amount_decimal: NotRequired[str]
    """
    Same as `unit_amount`, but accepts a decimal value in cents (or local equivalent) with at most 12 decimal places. Only one of `unit_amount` and `unit_amount_decimal` can be set.
    """


class ProductCreateParamsDefaultPriceDataCurrencyOptionsCustomUnitAmount(
    TypedDict,
):
    enabled: bool
    """
    Pass in `true` to enable `custom_unit_amount`, otherwise omit `custom_unit_amount`.
    """
    maximum: NotRequired[int]
    """
    The maximum unit amount the customer can specify for this item.
    """
    minimum: NotRequired[int]
    """
    The minimum unit amount the customer can specify for this item. Must be at least the minimum charge amount.
    """
    preset: NotRequired[int]
    """
    The starting unit amount which can be updated by the customer.
    """


class ProductCreateParamsDefaultPriceDataCurrencyOptionsTier(TypedDict):
    flat_amount: NotRequired[int]
    """
    The flat billing amount for an entire tier, regardless of the number of units in the tier.
    """
    flat_amount_decimal: NotRequired[str]
    """
    Same as `flat_amount`, but accepts a decimal value representing an integer in the minor units of the currency. Only one of `flat_amount` and `flat_amount_decimal` can be set.
    """
    unit_amount: NotRequired[int]
    """
    The per unit billing amount for each individual unit for which this tier applies.
    """
    unit_amount_decimal: NotRequired[str]
    """
    Same as `unit_amount`, but accepts a decimal value in cents (or local equivalent) with at most 12 decimal places. Only one of `unit_amount` and `unit_amount_decimal` can be set.
    """
    up_to: Union[Literal["inf"], int]
    """
    Specifies the upper bound of this tier. The lower bound of a tier is the upper bound of the previous tier adding one. Use `inf` to define a fallback tier.
    """


class ProductCreateParamsDefaultPriceDataCustomUnitAmount(TypedDict):
    enabled: bool
    """
    Pass in `true` to enable `custom_unit_amount`, otherwise omit `custom_unit_amount`.
    """
    maximum: NotRequired[int]
    """
    The maximum unit amount the customer can specify for this item.
    """
    minimum: NotRequired[int]
    """
    The minimum unit amount the customer can specify for this item. Must be at least the minimum charge amount.
    """
    preset: NotRequired[int]
    """
    The starting unit amount which can be updated by the customer.
    """


class ProductCreateParamsDefaultPriceDataRecurring(TypedDict):
    interval: Literal["day", "month", "week", "year"]
    """
    Specifies billing frequency. Either `day`, `week`, `month` or `year`.
    """
    interval_count: NotRequired[int]
    """
    The number of intervals between subscription billings. For example, `interval=month` and `interval_count=3` bills every 3 months. Maximum of three years interval allowed (3 years, 36 months, or 156 weeks).
    """


class ProductCreateParamsMarketingFeature(TypedDict):
    name: str
    """
    The marketing feature name. Up to 80 characters long.
    """


class ProductCreateParamsPackageDimensions(TypedDict):
    height: float
    """
    Height, in inches. Maximum precision is 2 decimal places.
    """
    length: float
    """
    Length, in inches. Maximum precision is 2 decimal places.
    """
    weight: float
    """
    Weight, in ounces. Maximum precision is 2 decimal places.
    """
    width: float
    """
    Width, in inches. Maximum precision is 2 decimal places.
    """
