
// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;


// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <ShapeProcess_Operator.hxx>
#include <ShapeProcess_Context.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Resource_Manager.hxx>
#include <Message_Messenger.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Message_ProgressRange.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <ShapeProcess_ShapeContext.hxx>
#include <BRepTools_Modification.hxx>
#include <ShapeExtend_MsgRegistrator.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <ShapeProcess_Context.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <ShapeExtend_MsgRegistrator.hxx>
#include <ShapeBuild_ReShape.hxx>
#include <BRepTools_Modifier.hxx>
#include <Message_Msg.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <ShapeProcess.hxx>
#include <ShapeProcess_Context.hxx>
#include <ShapeProcess_Operator.hxx>
#include <ShapeProcess_OperFunc.hxx>
#include <ShapeProcess_OperLibrary.hxx>
#include <ShapeProcess_ShapeContext.hxx>
#include <ShapeProcess_UOperator.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_ShapeProcess_enums(py::module &main_module) {


py::module m = main_module.def_submodule("ShapeProcess", R"#()#");

// user-defined inclusion per module in the body

// enums

//Python trampoline classes
    class Py_ShapeProcess_Operator : public ShapeProcess_Operator{
    public:
        using ShapeProcess_Operator::ShapeProcess_Operator;


        // public pure virtual
        Standard_Boolean Perform(const opencascade::handle<ShapeProcess_Context> & context,const Message_ProgressRange & theProgress) override { PYBIND11_OVERLOAD_PURE(Standard_Boolean,ShapeProcess_Operator,Perform,context,theProgress) };


        // protected pure virtual


        // private pure virtual

    };

// pre-register typdefs+classes (topologically sorted)
    py::class_<ShapeProcess , shared_ptr<ShapeProcess>  >(m,"ShapeProcess",R"#(Shape Processing module allows to define and apply general Shape Processing as a customizable sequence of Shape Healing operators. The customization is implemented via user-editable resource file which defines sequence of operators to be executed and their parameters.)#");
    py::class_<ShapeProcess_OperLibrary , shared_ptr<ShapeProcess_OperLibrary>  >(m,"ShapeProcess_OperLibrary",R"#(Provides a set of following operators)#");
    py::class_<ShapeProcess_Context ,opencascade::handle<ShapeProcess_Context>  , Standard_Transient >(m,"ShapeProcess_Context",R"#(Provides convenient interface to resource file Allows to load resource file and get values of attributes starting from some scope, for example if scope is defined as "ToV4" and requested parameter is "exec.op", value of "ToV4.exec.op" parameter from the resource file will be returnedProvides convenient interface to resource file Allows to load resource file and get values of attributes starting from some scope, for example if scope is defined as "ToV4" and requested parameter is "exec.op", value of "ToV4.exec.op" parameter from the resource file will be returnedProvides convenient interface to resource file Allows to load resource file and get values of attributes starting from some scope, for example if scope is defined as "ToV4" and requested parameter is "exec.op", value of "ToV4.exec.op" parameter from the resource file will be returned)#");
    py::class_<ShapeProcess_Operator ,opencascade::handle<ShapeProcess_Operator> ,Py_ShapeProcess_Operator , Standard_Transient >(m,"ShapeProcess_Operator",R"#(Abstract Operator class providing a tool to perform an operation on ContextAbstract Operator class providing a tool to perform an operation on ContextAbstract Operator class providing a tool to perform an operation on Context)#");
    py::class_<ShapeProcess_ShapeContext ,opencascade::handle<ShapeProcess_ShapeContext>  , ShapeProcess_Context >(m,"ShapeProcess_ShapeContext",R"#(Extends Context to handle shapes Contains map of shape-shape, and messages attached to shapesExtends Context to handle shapes Contains map of shape-shape, and messages attached to shapesExtends Context to handle shapes Contains map of shape-shape, and messages attached to shapes)#");
    py::class_<ShapeProcess_UOperator ,opencascade::handle<ShapeProcess_UOperator>  , ShapeProcess_Operator >(m,"ShapeProcess_UOperator",R"#(Defines operator as container for static function OperFunc. This allows user to create new operators without creation of new classesDefines operator as container for static function OperFunc. This allows user to create new operators without creation of new classesDefines operator as container for static function OperFunc. This allows user to create new operators without creation of new classes)#");

};

// user-defined post-inclusion per module

// user-defined post
