import OCP.AIS
from typing import *
from typing import Iterable as iterable
from typing import Iterator as iterator
from numpy import float64
_Shape = Tuple[int, ...]
import OCP.TopLoc
import OCP.SelectMgr
import OCP.Geom
import OCP.NCollection
import OCP.TopAbs
import OCP.TColgp
import OCP.V3d
import OCP.Font
import OCP.PrsMgr
import OCP.Prs3d
import OCP.Quantity
import OCP.Graphic3d
import OCP.Select3D
import OCP.SelectBasics
import OCP.Poly
import OCP.TColStd
import OCP.Standard
import OCP.gp
import OCP.Image
import OCP.Aspect
import OCP.TopoDS
import io
import OCP.Bnd
import OCP.TCollection
import OCP.GeomAbs
__all__  = [
"AIS",
"AIS_Animation",
"AIS_BaseAnimationObject",
"AIS_AnimationCamera",
"AIS_AnimationObject",
"AIS_AnimationProgress",
"AIS_AttributeFilter",
"AIS_InteractiveObject",
"AIS_BadEdgeFilter",
"AIS_AnimationAxisRotation",
"AIS_C0RegularityFilter",
"AIS_CameraFrustum",
"AIS_Circle",
"AIS_ColorScale",
"AIS_ColoredDrawer",
"AIS_Shape",
"AIS_ConnectedInteractive",
"AIS_DisplayMode",
"AIS_DragAction",
"AIS_ExclusionFilter",
"AIS_GlobalStatus",
"AIS_GraphicTool",
"AIS_InteractiveContext",
"AIS_Axis",
"AIS_KindOfInteractive",
"AIS_LightSource",
"AIS_LightSourceOwner",
"AIS_Line",
"AIS_ListOfInteractive",
"AIS_Manipulator",
"AIS_ManipulatorMode",
"AIS_ManipulatorObjectSequence",
"AIS_ManipulatorOwner",
"AIS_Manipulator_OptionsForAttach",
"AIS_MediaPlayer",
"AIS_MouseGesture",
"AIS_MouseGestureMap",
"AIS_MouseSelectionSchemeMap",
"AIS_MultipleConnectedInteractive",
"AIS_NArray1OfEntityOwner",
"AIS_NListOfEntityOwner",
"AIS_NavigationMode",
"AIS_Plane",
"AIS_PlaneTrihedron",
"AIS_Point",
"AIS_PointCloud",
"AIS_PointCloudOwner",
"AIS_RotationMode",
"AIS_RubberBand",
"AIS_SelectStatus",
"AIS_Selection",
"AIS_SelectionModesConcurrency",
"AIS_SelectionScheme",
"AIS_ColoredShape",
"AIS_TypeFilter",
"AIS_StatusOfDetection",
"AIS_StatusOfPick",
"AIS_TextLabel",
"AIS_TexturedShape",
"AIS_Triangulation",
"AIS_Trihedron",
"AIS_TrihedronOwner",
"AIS_TrihedronSelectionMode",
"AIS_SignatureFilter",
"AIS_TypeOfAttribute",
"AIS_TypeOfAxis",
"AIS_TypeOfIso",
"AIS_TypeOfPlane",
"AIS_ViewController",
"AIS_ViewCube",
"AIS_ViewCubeOwner",
"AIS_ViewCubeSensitive",
"AIS_ViewInputBuffer",
"AIS_ViewInputBufferType",
"AIS_ViewSelectionTool",
"AIS_WalkDelta",
"AIS_WalkPart",
"AIS_WalkRotation",
"AIS_WalkTranslation",
"AIS_XRTrackedDevice",
"AIS_DragAction_Abort",
"AIS_DragAction_Confirmed",
"AIS_DragAction_Start",
"AIS_DragAction_Stop",
"AIS_DragAction_Update",
"AIS_KOI_Datum",
"AIS_KOI_Dimension",
"AIS_KOI_None",
"AIS_KOI_Object",
"AIS_KOI_Relation",
"AIS_KOI_Shape",
"AIS_KindOfInteractive_Datum",
"AIS_KindOfInteractive_Dimension",
"AIS_KindOfInteractive_LightSource",
"AIS_KindOfInteractive_None",
"AIS_KindOfInteractive_Object",
"AIS_KindOfInteractive_Relation",
"AIS_KindOfInteractive_Shape",
"AIS_MM_None",
"AIS_MM_Rotation",
"AIS_MM_Scaling",
"AIS_MM_Translation",
"AIS_MM_TranslationPlane",
"AIS_MouseGesture_Drag",
"AIS_MouseGesture_NONE",
"AIS_MouseGesture_Pan",
"AIS_MouseGesture_RotateOrbit",
"AIS_MouseGesture_RotateView",
"AIS_MouseGesture_SelectLasso",
"AIS_MouseGesture_SelectRectangle",
"AIS_MouseGesture_Zoom",
"AIS_MouseGesture_ZoomWindow",
"AIS_NavigationMode_FirstPersonFlight",
"AIS_NavigationMode_FirstPersonWalk",
"AIS_NavigationMode_LOWER",
"AIS_NavigationMode_Orbit",
"AIS_NavigationMode_UPPER",
"AIS_RotationMode_BndBoxActive",
"AIS_RotationMode_BndBoxScene",
"AIS_RotationMode_CameraAt",
"AIS_RotationMode_LOWER",
"AIS_RotationMode_PickCenter",
"AIS_RotationMode_PickLast",
"AIS_RotationMode_UPPER",
"AIS_SOD_AllBad",
"AIS_SOD_Error",
"AIS_SOD_Nothing",
"AIS_SOD_OnlyOneDetected",
"AIS_SOD_OnlyOneGood",
"AIS_SOD_Selected",
"AIS_SOD_SeveralGood",
"AIS_SOP_Error",
"AIS_SOP_NothingSelected",
"AIS_SOP_OneSelected",
"AIS_SOP_Removed",
"AIS_SOP_SeveralSelected",
"AIS_SS_Added",
"AIS_SS_NotDone",
"AIS_SS_Removed",
"AIS_SelectionModesConcurrency_GlobalOrLocal",
"AIS_SelectionModesConcurrency_Multiple",
"AIS_SelectionModesConcurrency_Single",
"AIS_SelectionScheme_Add",
"AIS_SelectionScheme_Clear",
"AIS_SelectionScheme_Remove",
"AIS_SelectionScheme_Replace",
"AIS_SelectionScheme_ReplaceExtra",
"AIS_SelectionScheme_UNKNOWN",
"AIS_SelectionScheme_XOR",
"AIS_Shaded",
"AIS_TOAX_Unknown",
"AIS_TOAX_XAxis",
"AIS_TOAX_YAxis",
"AIS_TOAX_ZAxis",
"AIS_TOA_Dimension",
"AIS_TOA_FaceBoundary",
"AIS_TOA_FirstAxis",
"AIS_TOA_Free",
"AIS_TOA_Hidden",
"AIS_TOA_Line",
"AIS_TOA_Plane",
"AIS_TOA_SecondAxis",
"AIS_TOA_Section",
"AIS_TOA_Seen",
"AIS_TOA_ThirdAxis",
"AIS_TOA_UIso",
"AIS_TOA_UnFree",
"AIS_TOA_VIso",
"AIS_TOA_Vector",
"AIS_TOA_Wire",
"AIS_TOI_Both",
"AIS_TOI_IsoU",
"AIS_TOI_IsoV",
"AIS_TOPL_Unknown",
"AIS_TOPL_XYPlane",
"AIS_TOPL_XZPlane",
"AIS_TOPL_YZPlane",
"AIS_TrihedronSelectionMode_Axes",
"AIS_TrihedronSelectionMode_EntireObject",
"AIS_TrihedronSelectionMode_MainPlanes",
"AIS_TrihedronSelectionMode_Origin",
"AIS_ViewInputBufferType_GL",
"AIS_ViewInputBufferType_UI",
"AIS_ViewSelectionTool_Picking",
"AIS_ViewSelectionTool_Polygon",
"AIS_ViewSelectionTool_RubberBand",
"AIS_ViewSelectionTool_ZoomWindow",
"AIS_WalkRotation_Pitch",
"AIS_WalkRotation_Roll",
"AIS_WalkRotation_Yaw",
"AIS_WalkTranslation_Forward",
"AIS_WalkTranslation_Side",
"AIS_WalkTranslation_Up",
"AIS_WireFrame"
]
class AIS():
    """
    Application Interactive Services provide the means to create links between an application GUI viewer and the packages which are used to manage selection and presentation. The tools AIS defined in order to do this include different sorts of entities: both the selectable viewable objects themselves and the context and attribute managers to define their selection and display. To orient the user as he works in a modeling environment, views and selections must be comprehensible. There must be several different sorts of selectable and viewable object defined. These must also be interactive, that is, connecting graphic representation and the underlying reference geometry. These entities are called Interactive Objects, and are divided into four types: - the Datum - the Relation - the Object - None. The Datum groups together the construction elements such as lines, circles, points, trihedra, plane trihedra, planes and axes. The Relation is made up of constraints on one or more interactive shapes and the corresponding reference geometry. For example, you might want to constrain two edges in a parallel relation. This contraint is considered as an object in its own right, and is shown as a sensitive primitive. This takes the graphic form of a perpendicular arrow marked with the || symbol and lying between the two edges. The Object type includes topological shapes, and connections between shapes. None, in order not to eliminate the object, tells the application to look further until it finds an object definition in its generation which is accepted. Inside these categories, you have the possibility of an additional characterization by means of a signature. The signature provides an index to the further characterization. By default, the Interactive Object has a None type and a signature of 0 (equivalent to None.) If you want to give a particular type and signature to your interactive object, you must redefine the two virtual methods: Type and Signature. In the C++ inheritance structure of the package, each class representing a specific Interactive Object inherits AIS_InteractiveObject. Among these inheriting classes, AIS_Relation functions as the abstract mother class for tinheriting classes defining display of specific relational constraints and types of dimension. Some of these include: - display of constraints based on relations of symmetry, tangency, parallelism and concentricity - display of dimensions for angles, offsets, diameters, radii and chamfers. No viewer can show everything at once with any coherence or clarity. Views must be managed carefully both sequentially and at any given instant. Another function of the view is that of a context to carry out design in. The design changes are applied to the objects in the view and then extended to the underlying reference geometry by a solver. To make sense of this complicated visual data, several display and selection tools are required. To facilitate management, each object and each construction element has a selection priority. There are also means to modify the default priority. To define an environment of dynamic detection, you can use standard filter classes or create your own. A filter questions the owner of the sensitive primitive to determine if it has the desired qualities. If it answers positively, it is kept. If not, it is rejected. The standard filters supplied in AIS include: - AIS_AttributeFilter - AIS_SignatureFilter - AIS_TypeFilter. A set of functions allows you to choose the interactive objects which you want to act on, the selection modes which you want to activate. An interactive object can have a certain number of graphic attributes which are specific to it, such as visualization mode, color, and material. By the same token, the interactive context has a set of graphic attributes, the Drawer which is valid by default for the objects it controls. When an interactive object is visualized, the required graphic attributes are first taken from the object's own Drawer if one exists, or from the context drawer for the others.
    """
    def __init__(self) -> None: ...
    pass
class AIS_Animation(OCP.Standard.Standard_Transient):
    """
    Class represents a basic animation class. AIS_Animation can be used as:Class represents a basic animation class. AIS_Animation can be used as:
    """
    def Add(self,theAnimation : AIS_Animation) -> None: 
        """
        Add single animation to the timeline.
        """
    def Children(self) -> Any: 
        """
        Return sequence of child animations.
        """
    def Clear(self) -> None: 
        """
        Clear animation timeline - remove all animations from it.
        """
    def CopyFrom(self,theOther : AIS_Animation) -> None: 
        """
        Clears own children and then copy child animations from another object. Copy also Start Time and Duration values.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def Duration(self) -> float: 
        """
        Returns duration of the animation in the timeline
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def ElapsedTime(self) -> float: 
        """
        Return elapsed time.
        """
    def Find(self,theAnimationName : OCP.TCollection.TCollection_AsciiString) -> AIS_Animation: 
        """
        Return the child animation with the given name.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasOwnDuration(self) -> bool: 
        """
        Return true if duration is defined.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def IsStopped(self) -> bool: 
        """
        Check if animation is to be performed in the animation timeline.
        """
    def Name(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Animation name.
        """
    def OwnDuration(self) -> float: 
        """
        Returns own duration of the animation in the timeline
        """
    def Pause(self) -> None: 
        """
        Pause the process timeline.
        """
    def Remove(self,theAnimation : AIS_Animation) -> bool: 
        """
        Remove the child animation.
        """
    def Replace(self,theAnimationOld : AIS_Animation,theAnimationNew : AIS_Animation) -> bool: 
        """
        Replace the child animation.
        """
    def SetOwnDuration(self,theDuration : float) -> None: 
        """
        Defines duration of the animation.
        """
    def SetStartPts(self,thePtsStart : float) -> None: 
        """
        Sets time limits for animation in the animation timeline
        """
    def SetTimer(self,theTimer : Media_Timer) -> None: 
        """
        Set playback timer.
        """
    def Start(self,theToUpdate : bool) -> None: 
        """
        Start animation. This method changes status of the animation to Started. This status defines whether animation is to be performed in the timeline or not.
        """
    def StartPts(self) -> float: 
        """
        Returns start time of the animation in the timeline
        """
    def StartTimer(self,theStartPts : float,thePlaySpeed : float,theToUpdate : bool,theToStopTimer : bool=False) -> None: 
        """
        Start animation with internally defined timer instance. Calls ::Start() internally.
        """
    def Stop(self) -> None: 
        """
        Stop animation. This method changed status of the animation to Stopped. This status shows that animation will not be performed in the timeline or it is finished.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Timer(self) -> Media_Timer: 
        """
        Return playback timer.
        """
    def Update(self,thePts : float) -> bool: 
        """
        Update single frame of animation, update timer state
        """
    def UpdateTimer(self) -> float: 
        """
        Update single frame of animation, update timer state
        """
    def UpdateTotalDuration(self) -> None: 
        """
        Update total duration considering all animations on timeline.
        """
    def __init__(self,theAnimationName : OCP.TCollection.TCollection_AsciiString) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class AIS_BaseAnimationObject(AIS_Animation, OCP.Standard.Standard_Transient):
    """
    Animation defining object transformation.
    """
    def Add(self,theAnimation : AIS_Animation) -> None: 
        """
        Add single animation to the timeline.
        """
    def Children(self) -> Any: 
        """
        Return sequence of child animations.
        """
    def Clear(self) -> None: 
        """
        Clear animation timeline - remove all animations from it.
        """
    def CopyFrom(self,theOther : AIS_Animation) -> None: 
        """
        Clears own children and then copy child animations from another object. Copy also Start Time and Duration values.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def Duration(self) -> float: 
        """
        Returns duration of the animation in the timeline
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def ElapsedTime(self) -> float: 
        """
        Return elapsed time.
        """
    def Find(self,theAnimationName : OCP.TCollection.TCollection_AsciiString) -> AIS_Animation: 
        """
        Return the child animation with the given name.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasOwnDuration(self) -> bool: 
        """
        Return true if duration is defined.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def IsStopped(self) -> bool: 
        """
        Check if animation is to be performed in the animation timeline.
        """
    def Name(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Animation name.
        """
    def OwnDuration(self) -> float: 
        """
        Returns own duration of the animation in the timeline
        """
    def Pause(self) -> None: 
        """
        Pause the process timeline.
        """
    def Remove(self,theAnimation : AIS_Animation) -> bool: 
        """
        Remove the child animation.
        """
    def Replace(self,theAnimationOld : AIS_Animation,theAnimationNew : AIS_Animation) -> bool: 
        """
        Replace the child animation.
        """
    def SetOwnDuration(self,theDuration : float) -> None: 
        """
        Defines duration of the animation.
        """
    def SetStartPts(self,thePtsStart : float) -> None: 
        """
        Sets time limits for animation in the animation timeline
        """
    def SetTimer(self,theTimer : Media_Timer) -> None: 
        """
        Set playback timer.
        """
    def Start(self,theToUpdate : bool) -> None: 
        """
        Start animation. This method changes status of the animation to Started. This status defines whether animation is to be performed in the timeline or not.
        """
    def StartPts(self) -> float: 
        """
        Returns start time of the animation in the timeline
        """
    def StartTimer(self,theStartPts : float,thePlaySpeed : float,theToUpdate : bool,theToStopTimer : bool=False) -> None: 
        """
        Start animation with internally defined timer instance. Calls ::Start() internally.
        """
    def Stop(self) -> None: 
        """
        Stop animation. This method changed status of the animation to Stopped. This status shows that animation will not be performed in the timeline or it is finished.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Timer(self) -> Media_Timer: 
        """
        Return playback timer.
        """
    def Update(self,thePts : float) -> bool: 
        """
        Update single frame of animation, update timer state
        """
    def UpdateTimer(self) -> float: 
        """
        Update single frame of animation, update timer state
        """
    def UpdateTotalDuration(self) -> None: 
        """
        Update total duration considering all animations on timeline.
        """
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class AIS_AnimationCamera(AIS_Animation, OCP.Standard.Standard_Transient):
    """
    Camera animation.Camera animation.
    """
    def Add(self,theAnimation : AIS_Animation) -> None: 
        """
        Add single animation to the timeline.
        """
    def CameraEnd(self) -> OCP.Graphic3d.Graphic3d_Camera: 
        """
        Return camera end position.
        """
    def CameraStart(self) -> OCP.Graphic3d.Graphic3d_Camera: 
        """
        Return camera start position.
        """
    def Children(self) -> Any: 
        """
        Return sequence of child animations.
        """
    def Clear(self) -> None: 
        """
        Clear animation timeline - remove all animations from it.
        """
    def CopyFrom(self,theOther : AIS_Animation) -> None: 
        """
        Clears own children and then copy child animations from another object. Copy also Start Time and Duration values.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def Duration(self) -> float: 
        """
        Returns duration of the animation in the timeline
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def ElapsedTime(self) -> float: 
        """
        Return elapsed time.
        """
    def Find(self,theAnimationName : OCP.TCollection.TCollection_AsciiString) -> AIS_Animation: 
        """
        Return the child animation with the given name.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasOwnDuration(self) -> bool: 
        """
        Return true if duration is defined.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def IsStopped(self) -> bool: 
        """
        Check if animation is to be performed in the animation timeline.
        """
    def Name(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Animation name.
        """
    def OwnDuration(self) -> float: 
        """
        Returns own duration of the animation in the timeline
        """
    def Pause(self) -> None: 
        """
        Pause the process timeline.
        """
    def Remove(self,theAnimation : AIS_Animation) -> bool: 
        """
        Remove the child animation.
        """
    def Replace(self,theAnimationOld : AIS_Animation,theAnimationNew : AIS_Animation) -> bool: 
        """
        Replace the child animation.
        """
    def SetCameraEnd(self,theCameraEnd : OCP.Graphic3d.Graphic3d_Camera) -> None: 
        """
        Define camera end position.
        """
    def SetCameraStart(self,theCameraStart : OCP.Graphic3d.Graphic3d_Camera) -> None: 
        """
        Define camera start position.
        """
    def SetOwnDuration(self,theDuration : float) -> None: 
        """
        Defines duration of the animation.
        """
    def SetStartPts(self,thePtsStart : float) -> None: 
        """
        Sets time limits for animation in the animation timeline
        """
    def SetTimer(self,theTimer : Media_Timer) -> None: 
        """
        Set playback timer.
        """
    def SetView(self,theView : OCP.V3d.V3d_View) -> None: 
        """
        Set target view.
        """
    def Start(self,theToUpdate : bool) -> None: 
        """
        Start animation. This method changes status of the animation to Started. This status defines whether animation is to be performed in the timeline or not.
        """
    def StartPts(self) -> float: 
        """
        Returns start time of the animation in the timeline
        """
    def StartTimer(self,theStartPts : float,thePlaySpeed : float,theToUpdate : bool,theToStopTimer : bool=False) -> None: 
        """
        Start animation with internally defined timer instance. Calls ::Start() internally.
        """
    def Stop(self) -> None: 
        """
        Stop animation. This method changed status of the animation to Stopped. This status shows that animation will not be performed in the timeline or it is finished.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Timer(self) -> Media_Timer: 
        """
        Return playback timer.
        """
    def Update(self,thePts : float) -> bool: 
        """
        Update single frame of animation, update timer state
        """
    def UpdateTimer(self) -> float: 
        """
        Update single frame of animation, update timer state
        """
    def UpdateTotalDuration(self) -> None: 
        """
        Update total duration considering all animations on timeline.
        """
    def View(self) -> OCP.V3d.V3d_View: 
        """
        Return the target view.
        """
    def __init__(self,theAnimationName : OCP.TCollection.TCollection_AsciiString,theView : OCP.V3d.V3d_View) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class AIS_AnimationObject(AIS_BaseAnimationObject, AIS_Animation, OCP.Standard.Standard_Transient):
    """
    Animation defining object transformation.
    """
    def Add(self,theAnimation : AIS_Animation) -> None: 
        """
        Add single animation to the timeline.
        """
    def Children(self) -> Any: 
        """
        Return sequence of child animations.
        """
    def Clear(self) -> None: 
        """
        Clear animation timeline - remove all animations from it.
        """
    def CopyFrom(self,theOther : AIS_Animation) -> None: 
        """
        Clears own children and then copy child animations from another object. Copy also Start Time and Duration values.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def Duration(self) -> float: 
        """
        Returns duration of the animation in the timeline
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def ElapsedTime(self) -> float: 
        """
        Return elapsed time.
        """
    def Find(self,theAnimationName : OCP.TCollection.TCollection_AsciiString) -> AIS_Animation: 
        """
        Return the child animation with the given name.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasOwnDuration(self) -> bool: 
        """
        Return true if duration is defined.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def IsStopped(self) -> bool: 
        """
        Check if animation is to be performed in the animation timeline.
        """
    def Name(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Animation name.
        """
    def OwnDuration(self) -> float: 
        """
        Returns own duration of the animation in the timeline
        """
    def Pause(self) -> None: 
        """
        Pause the process timeline.
        """
    def Remove(self,theAnimation : AIS_Animation) -> bool: 
        """
        Remove the child animation.
        """
    def Replace(self,theAnimationOld : AIS_Animation,theAnimationNew : AIS_Animation) -> bool: 
        """
        Replace the child animation.
        """
    def SetOwnDuration(self,theDuration : float) -> None: 
        """
        Defines duration of the animation.
        """
    def SetStartPts(self,thePtsStart : float) -> None: 
        """
        Sets time limits for animation in the animation timeline
        """
    def SetTimer(self,theTimer : Media_Timer) -> None: 
        """
        Set playback timer.
        """
    def Start(self,theToUpdate : bool) -> None: 
        """
        Start animation. This method changes status of the animation to Started. This status defines whether animation is to be performed in the timeline or not.
        """
    def StartPts(self) -> float: 
        """
        Returns start time of the animation in the timeline
        """
    def StartTimer(self,theStartPts : float,thePlaySpeed : float,theToUpdate : bool,theToStopTimer : bool=False) -> None: 
        """
        Start animation with internally defined timer instance. Calls ::Start() internally.
        """
    def Stop(self) -> None: 
        """
        Stop animation. This method changed status of the animation to Stopped. This status shows that animation will not be performed in the timeline or it is finished.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Timer(self) -> Media_Timer: 
        """
        Return playback timer.
        """
    def Update(self,thePts : float) -> bool: 
        """
        Update single frame of animation, update timer state
        """
    def UpdateTimer(self) -> float: 
        """
        Update single frame of animation, update timer state
        """
    def UpdateTotalDuration(self) -> None: 
        """
        Update total duration considering all animations on timeline.
        """
    def __init__(self,theAnimationName : OCP.TCollection.TCollection_AsciiString,theContext : AIS_InteractiveContext,theObject : AIS_InteractiveObject,theTrsfStart : OCP.gp.gp_Trsf,theTrsfEnd : OCP.gp.gp_Trsf) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class AIS_AnimationProgress():
    """
    Structure defining current animation progress.
    """
    def __init__(self) -> None: ...
    @property
    def LocalNormalized(self) -> float:
        """
        :type: float
        """
    @LocalNormalized.setter
    def LocalNormalized(self, arg0: float) -> None:
        pass
    @property
    def LocalPts(self) -> float:
        """
        :type: float
        """
    @LocalPts.setter
    def LocalPts(self, arg0: float) -> None:
        pass
    @property
    def Pts(self) -> float:
        """
        :type: float
        """
    @Pts.setter
    def Pts(self, arg0: float) -> None:
        pass
    pass
class AIS_AttributeFilter(OCP.SelectMgr.SelectMgr_Filter, OCP.Standard.Standard_Transient):
    """
    Selects Interactive Objects, which have the desired width or color. The filter questions each Interactive Object in local context to determine whether it has an non-null owner, and if so, whether it has the required color and width attributes. If the object returns true in each case, it is kept. If not, it is rejected. This filter is used only in an open local context. In the Collector viewer, you can only locate Interactive Objects, which answer positively to the filters, which are in position when a local context is open.Selects Interactive Objects, which have the desired width or color. The filter questions each Interactive Object in local context to determine whether it has an non-null owner, and if so, whether it has the required color and width attributes. If the object returns true in each case, it is kept. If not, it is rejected. This filter is used only in an open local context. In the Collector viewer, you can only locate Interactive Objects, which answer positively to the filters, which are in position when a local context is open.Selects Interactive Objects, which have the desired width or color. The filter questions each Interactive Object in local context to determine whether it has an non-null owner, and if so, whether it has the required color and width attributes. If the object returns true in each case, it is kept. If not, it is rejected. This filter is used only in an open local context. In the Collector viewer, you can only locate Interactive Objects, which answer positively to the filters, which are in position when a local context is open.
    """
    def ActsOn(self,aStandardMode : OCP.TopAbs.TopAbs_ShapeEnum) -> bool: 
        """
        Returns true in an AIS local context, if this filter operates on a type of subshape defined in a filter class inheriting this framework. This function completes IsOk in an AIS local context.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasColor(self) -> bool: 
        """
        Indicates that the Interactive Object has the color setting specified by the argument aCol at construction time.
        """
    def HasWidth(self) -> bool: 
        """
        Indicates that the Interactive Object has the width setting specified by the argument aWidth at construction time.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def IsOk(self,anObj : OCP.SelectMgr.SelectMgr_EntityOwner) -> bool: 
        """
        Indicates that the selected Interactive Object passes the filter. The owner, anObj, can be either direct or user. A direct owner is the corresponding construction element, whereas a user is the compound shape of which the entity forms a part. If the Interactive Object returns Standard_True when detected by the Local Context selector through the mouse, the object is kept; if not, it is rejected.
        """
    def SetColor(self,theCol : OCP.Quantity.Quantity_NameOfColor) -> None: 
        """
        Sets the color.
        """
    def SetWidth(self,theWidth : float) -> None: 
        """
        Sets the line width.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def UnsetColor(self) -> None: 
        """
        Removes the setting for color from the filter.
        """
    def UnsetWidth(self) -> None: 
        """
        Removes the setting for width from the filter.
        """
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,aWidth : float) -> None: ...
    @overload
    def __init__(self,aCol : OCP.Quantity.Quantity_NameOfColor) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class AIS_InteractiveObject(OCP.SelectMgr.SelectMgr_SelectableObject, OCP.PrsMgr.PrsMgr_PresentableObject, OCP.Standard.Standard_Transient):
    """
    Defines a class of objects with display and selection services. Entities which are visualized and selected are Interactive Objects. Specific attributes of entities such as arrow aspect for dimensions must be loaded in a Prs3d_Drawer.Defines a class of objects with display and selection services. Entities which are visualized and selected are Interactive Objects. Specific attributes of entities such as arrow aspect for dimensions must be loaded in a Prs3d_Drawer.
    """
    def AcceptDisplayMode(self,theMode : int) -> bool: 
        """
        Returns true if the class of objects accepts specified display mode index. The interactive context can have a default mode of representation for the set of Interactive Objects. This mode may not be accepted by a given class of objects. Consequently, this virtual method allowing us to get information about the class in question must be implemented. At least one display mode index should be accepted by this method. Although subclass can leave default implementation, it is highly desired defining exact list of supported modes instead, which is usually an enumeration for one object or objects class sharing similar list of display modes.
        """
    def AcceptShapeDecomposition(self) -> bool: 
        """
        Informs the graphic context that the interactive Object may be decomposed into sub-shapes for dynamic selection. The most used Interactive Object is AIS_Shape.
        """
    def AddChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy.
        """
    def AddChildWithCurrentTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy with keeping the current global transformation So the object keeps the same position/orientation in the global CS.
        """
    def AddClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Adds clip plane for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def AddSelection(self,aSelection : OCP.SelectMgr.SelectMgr_Selection,aMode : int) -> None: 
        """
        Adds the selection aSelection with the selection mode index aMode to this framework.
        """
    def Attributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the attributes settings.
        """
    def BndBoxOfSelected(self,theOwners : Any) -> OCP.Bnd.Bnd_Box: 
        """
        Returns a bounding box of sensitive entities with the owners given if they are a part of activated selection
        """
    def BoundingBox(self,theBndBox : OCP.Bnd.Bnd_Box) -> None: 
        """
        Returns bounding box of object correspondingly to its current display mode. This method requires presentation to be already computed, since it relies on bounding box of presentation structures, which are supposed to be same/close amongst different display modes of this object.
        """
    def Children(self) -> OCP.PrsMgr.PrsMgr_ListOfPresentableObjects: 
        """
        Returns children of the current object.
        """
    def ClearDynamicHighlight(self,theMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> None: 
        """
        Method that needs to be implemented when the object manages selection and dynamic highlighting on its own. Clears or invalidates dynamic highlight presentation. By default it clears immediate draw of given presentation manager.
        """
    def ClearOwner(self) -> None: 
        """
        Each Interactive Object has methods which allow us to attribute an Owner to it in the form of a Transient. This method removes the owner from the graphic entity.
        """
    def ClearSelected(self) -> None: 
        """
        Method which clear all selected owners belonging to this selectable object ( for fast presentation draw )
        """
    def ClearSelections(self,update : bool=False) -> None: 
        """
        Empties all the selections in the SelectableObject <update> parameter defines whether all object's selections should be flagged for further update or not. This improved method can be used to recompute an object's selection (without redisplaying the object completely) when some selection mode is activated not for the first time.
        """
    def ClipPlanes(self) -> OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane: 
        """
        Get clip planes.
        """
    def Color(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Returns the color setting of the Interactive Object.
        """
    def CombinedParentTransformation(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return combined parent transformation.
        """
    def ComputeSelection(self,theSelection : OCP.SelectMgr.SelectMgr_Selection,theMode : int) -> None: 
        """
        Computes sensitive primitives for the given selection mode - key interface method of Selectable Object.
        """
    def CurrentFacingModel(self) -> OCP.Aspect.Aspect_TypeOfFacingModel: 
        """
        Returns the current facing model which is in effect.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def DefaultDisplayMode(self) -> int: 
        """
        Returns the default display mode.
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DisplayMode(self) -> int: 
        """
        Returns the display mode setting of the Interactive Object. The range of supported display mode indexes should be specified within object definition and filtered by AccepDisplayMode().
        """
    def DisplayStatus(self) -> OCP.PrsMgr.PrsMgr_DisplayStatus: 
        """
        Return presentation display status; PrsMgr_DisplayStatus_None by default.
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicHilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalDynamic and Prs3d_TypeOfHighlight_Dynamic defined within AIS_InteractiveContext::HighlightStyle().
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def ErasePresentations(self,theToRemove : bool) -> None: 
        """
        Removes presentations returned by GetHilightPresentation() and GetSelectPresentation().
        """
    def GetAssemblyOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns common entity owner if the object is an assembly
        """
    def GetContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def GetHilightPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting detected object.
        """
    def GetOwner(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns the owner of the Interactive Object. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient. There are two types of owners: - Direct owners, decomposition shapes such as edges, wires, and faces. - Users, presentable objects connecting to sensitive primitives, or a shape which has been decomposed.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def GetSelectPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting selected object.
        """
    def GlobalSelOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns the owner of mode for selection of object as a whole
        """
    def GlobalSelectionMode(self) -> int: 
        """
        Returns the mode for selection of object as a whole; 0 by default.
        """
    def HasColor(self) -> bool: 
        """
        Returns true if the Interactive Object has color.
        """
    def HasDisplayMode(self) -> bool: 
        """
        Returns true if the Interactive Object has display mode setting overriding global setting (within Interactive Context).
        """
    def HasHilightMode(self) -> bool: 
        """
        Returns true if the Interactive Object is in highlight mode.
        """
    def HasInteractiveContext(self) -> bool: 
        """
        Indicates whether the Interactive Object has a pointer to an interactive context.
        """
    def HasMaterial(self) -> bool: 
        """
        Returns true if the Interactive Object has a setting for material.
        """
    def HasOwnPresentations(self) -> bool: 
        """
        Returns true if object should have own presentations.
        """
    def HasOwner(self) -> bool: 
        """
        Returns true if the object has an owner attributed to it. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient.
        """
    def HasPolygonOffsets(self) -> bool: 
        """
        Returns Standard_True if <myDrawer> has non-null shading aspect
        """
    def HasPresentation(self) -> bool: 
        """
        Returns TRUE when this object has a presentation in the current DisplayMode()
        """
    def HasSelection(self,theMode : int) -> bool: 
        """
        Returns true if a selection corresponding to the selection mode theMode was computed for this object.
        """
    def HasTransformation(self) -> bool: 
        """
        Returns true if object has a transformation that is different from the identity.
        """
    def HasWidth(self) -> bool: 
        """
        Returns true if the Interactive Object has width.
        """
    def HilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalSelected and Prs3d_TypeOfHighlight_Selected defined within AIS_InteractiveContext::HighlightStyle().
        """
    def HilightMode(self) -> int: 
        """
        Returns highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def HilightOwnerWithColor(self,thePM : OCP.PrsMgr.PrsMgr_PresentationManager,theStyle : OCP.Prs3d.Prs3d_Drawer,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner) -> None: 
        """
        Method which hilight an owner belonging to this selectable object ( for fast presentation draw )
        """
    def HilightSelected(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager,theSeq : OCP.SelectMgr.SelectMgr_SequenceOfOwner) -> None: 
        """
        Method which draws selected owners ( for fast presentation draw )
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def InteractiveContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def InversedTransformation(self) -> OCP.gp.gp_GTrsf: 
        """
        Return inversed transformation.
        """
    def IsAutoHilight(self) -> bool: 
        """
        If returns True, the old mechanism for highlighting selected objects is used (HilightSelected Method may be empty). If returns False, the HilightSelected method will be fully responsible for highlighting selected entity owners belonging to this selectable object.
        """
    def IsInfinite(self) -> bool: 
        """
        Returns true if the interactive object is infinite; FALSE by default. This flag affects various operations operating on bounding box of graphic presentations of this object. For instance, infinite objects are not taken in account for View FitAll. This does not necessarily means that object is actually infinite, auxiliary objects might be also marked with this flag to achieve desired behavior.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def IsMutable(self) -> bool: 
        """
        Returns true if object has mutable nature (content or location are be changed regularly). Mutable object will be managed in different way than static onces (another optimizations).
        """
    def IsTransparent(self) -> bool: 
        """
        Returns true if there is a transparency setting.
        """
    def LocalTransformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def LocalTransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def Material(self) -> OCP.Graphic3d.Graphic3d_NameOfMaterial: 
        """
        Returns the current material setting as enumeration value.
        """
    def Parent(self) -> OCP.PrsMgr.PrsMgr_PresentableObject: 
        """
        Returns parent of current object in scene hierarchy.
        """
    def PolygonOffsets(self,aFactor : float,aUnits : float) -> tuple[int]: 
        """
        Retrieves current polygon offsets settings from <myDrawer>.
        """
    def Presentation(self) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Returns the current presentation of this object according to the current DisplayMode()
        """
    def Presentations(self) -> OCP.PrsMgr.PrsMgr_Presentations: 
        """
        Return presentations.
        """
    def ProcessDragging(self,theCtx : AIS_InteractiveContext,theView : OCP.V3d.V3d_View,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theDragFrom : OCP.Graphic3d.Graphic3d_Vec2i,theDragTo : OCP.Graphic3d.Graphic3d_Vec2i,theAction : AIS_DragAction) -> bool: 
        """
        Drag object in the viewer.
        """
    @overload
    def RecomputePrimitives(self) -> None: 
        """
        Re-computes the sensitive primitives for all modes. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.

        Re-computes the sensitive primitives which correspond to the <theMode>th selection mode. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.
        """
    @overload
    def RecomputePrimitives(self,theMode : int) -> None: ...
    def Redisplay(self,AllModes : bool=False) -> None: 
        """
        Updates the active presentation; if <AllModes> = Standard_True all the presentations inside are recomputed. IMPORTANT: It is preferable to call Redisplay method of corresponding AIS_InteractiveContext instance for cases when it is accessible. This method just redirects call to myCTXPtr, so this class field must be up to date for proper result.
        """
    def RemoveChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy.
        """
    def RemoveChildWithRestoreTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy with keeping the current global transformation. So the object keeps the same position/orientation in the global CS.
        """
    def RemoveClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Removes previously added clip plane.
        """
    def ResetTransformation(self) -> None: 
        """
        None
        """
    def Selection(self,theMode : int) -> OCP.SelectMgr.SelectMgr_Selection: 
        """
        Returns the selection having specified selection mode or NULL.
        """
    def Selections(self) -> OCP.SelectMgr.SelectMgr_SequenceOfSelection: 
        """
        Return the sequence of selections.
        """
    def SetAspect(self,anAspect : OCP.Prs3d.Prs3d_BasicAspect) -> None: 
        """
        Sets the graphic basic aspect to the current presentation.
        """
    def SetAssemblyOwner(self,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theMode : int=-1) -> None: 
        """
        Sets common entity owner for assembly sensitive object entities
        """
    def SetAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the drawing tool theDrawer.
        """
    def SetAutoHilight(self,theAutoHilight : bool) -> None: 
        """
        Set AutoHilight property to true or false.
        """
    def SetClipPlanes(self,thePlanes : OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane) -> None: 
        """
        Set clip planes for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def SetColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Only the interactive object knowns which Drawer attribute is affected by the color, if any (ex: for a wire,it's the wireaspect field of the drawer, but for a vertex, only the point aspect field is affected by the color). WARNING : Do not forget to set the corresponding fields here (hasOwnColor and myDrawer->SetColor())
        """
    def SetContext(self,aCtx : AIS_InteractiveContext) -> None: 
        """
        Sets the interactive context aCtx and provides a link to the default drawing tool or "Drawer" if there is none.
        """
    def SetCurrentFacingModel(self,theModel : OCP.Aspect.Aspect_TypeOfFacingModel=Aspect_TypeOfFacingModel.Aspect_TOFM_BOTH_SIDE) -> None: 
        """
        change the current facing model apply on polygons for SetColor(), SetTransparency(), SetMaterial() methods default facing model is Aspect_TOFM_TWO_SIDE. This mean that attributes is applying both on the front and back face.
        """
    def SetDisplayMode(self,theMode : int) -> None: 
        """
        Sets the display mode for the interactive object. An object can have its own temporary display mode, which is different from that proposed by the interactive context.
        """
    def SetDynamicHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the dynamic hilight drawing tool.
        """
    def SetHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the hilight drawing tool theDrawer.
        """
    def SetHilightMode(self,theMode : int) -> None: 
        """
        Sets highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def SetInfiniteState(self,theFlag : bool=True) -> None: 
        """
        Sets if object should be considered as infinite.
        """
    def SetIsoOnTriangulation(self,theIsEnabled : bool) -> None: 
        """
        Enables or disables on-triangulation build of isolines according to the flag given.
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.gp.gp_Trsf) -> None: 
        """
        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.

        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.TopLoc.TopLoc_Datum3D) -> None: ...
    def SetMaterial(self,aName : OCP.Graphic3d.Graphic3d_MaterialAspect) -> None: 
        """
        Sets the material aMat defining this display attribute for the interactive object. Material aspect determines shading aspect, color and transparency of visible entities.
        """
    def SetMutable(self,theIsMutable : bool) -> None: 
        """
        Sets if the object has mutable nature (content or location will be changed regularly). This method should be called before object displaying to take effect.
        """
    def SetOwner(self,theApplicativeEntity : OCP.Standard.Standard_Transient) -> None: 
        """
        Allows you to attribute the owner theApplicativeEntity to an Interactive Object. This can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of. The owner takes the form of a transient.
        """
    def SetPolygonOffsets(self,aMode : int,aFactor : float=1.0,aUnits : float=0.0) -> None: 
        """
        Sets up polygon offsets for this object.
        """
    def SetPropagateVisualState(self,theFlag : bool) -> None: 
        """
        Change the value of the flag "propagate visual state"
        """
    @overload
    def SetToUpdate(self) -> None: 
        """
        Flags presentation to be updated; UpdatePresentations() will recompute these presentations.

        flags all the Presentations to be Updated.
        """
    @overload
    def SetToUpdate(self,theMode : int) -> None: ...
    def SetTransformPersistence(self,theTrsfPers : OCP.Graphic3d.Graphic3d_TransformPers) -> None: 
        """
        Sets up Transform Persistence defining a special Local Coordinate system where this object should be located. Note that management of Transform Persistence object is more expensive than of the normal one, because it requires its position being recomputed basing on camera position within each draw call / traverse.
        """
    def SetTransparency(self,aValue : float=0.6) -> None: 
        """
        Attributes a setting aValue for transparency. The transparency value should be between 0.0 and 1.0. At 0.0 an object will be totally opaque, and at 1.0, fully transparent. Warning At a value of 1.0, there may be nothing visible.
        """
    def SetTypeOfPresentation(self,theType : OCP.PrsMgr.PrsMgr_TypeOfPresentation3d) -> None: 
        """
        Set type of presentation.
        """
    def SetWidth(self,theWidth : float) -> None: 
        """
        Allows you to provide the setting aValue for width. Only the Interactive Object knows which Drawer attribute is affected by the width setting.
        """
    def SetZLayer(self,theLayerId : int) -> None: 
        """
        Set Z layer ID and update all presentations of the selectable object. The layers mechanism allows drawing objects in higher layers in overlay of objects in lower layers.
        """
    def Signature(self) -> int: 
        """
        Specifies additional characteristics of Interactive Object of Type(); -1 by default. Among the datums, this signature is attributed to the shape. The remaining datums have the following default signatures: - Point signature 1 - Axis signature 2 - Trihedron signature 3 - PlaneTrihedron signature 4 - Line signature 5 - Circle signature 6 - Plane signature 7.
        """
    def SynchronizeAspects(self) -> None: 
        """
        Synchronize presentation aspects after their modification.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    @overload
    def ToBeUpdated(self,ListOfMode : OCP.TColStd.TColStd_ListOfInteger) -> None: 
        """
        Returns TRUE if any active presentation has invalidation flag.

        gives the list of modes which are flagged "to be updated".
        """
    @overload
    def ToBeUpdated(self,theToIncludeHidden : bool=False) -> bool: ...
    def ToPropagateVisualState(self) -> bool: 
        """
        Get value of the flag "propagate visual state" It means that the display/erase/color visual state is propagated automatically to all children; by default, the flag is true
        """
    def TransformPersistence(self) -> OCP.Graphic3d.Graphic3d_TransformPers: 
        """
        Returns Transformation Persistence defining a special Local Coordinate system where this presentable object is located or NULL handle if not defined. Position of the object having Transformation Persistence is mutable and depends on camera position. The same applies to a bounding box of the object.
        """
    def Transformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def TransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def Transparency(self) -> float: 
        """
        Returns the transparency setting. This will be between 0.0 and 1.0. At 0.0 an object will be totally opaque, and at 1.0, fully transparent.
        """
    def Type(self) -> AIS_KindOfInteractive: 
        """
        Returns the kind of Interactive Object; AIS_KindOfInteractive_None by default.
        """
    def TypeOfPresentation3d(self) -> OCP.PrsMgr.PrsMgr_TypeOfPresentation3d: 
        """
        Returns information on whether the object accepts display in HLR mode or not.
        """
    def UnsetAttributes(self) -> None: 
        """
        Clears settings provided by the drawing tool aDrawer.
        """
    def UnsetColor(self) -> None: 
        """
        Removes color settings. Only the Interactive Object knows which Drawer attribute is affected by the color setting. For a wire, for example, wire aspect is the attribute affected. For a vertex, however, only point aspect is affected by the color setting.
        """
    def UnsetDisplayMode(self) -> None: 
        """
        Removes display mode settings from the interactive object.
        """
    def UnsetHilightAttributes(self) -> None: 
        """
        Clears settings provided by the hilight drawing tool theDrawer.
        """
    def UnsetHilightMode(self) -> None: 
        """
        Unsets highlight display mode.
        """
    def UnsetMaterial(self) -> None: 
        """
        Removes the setting for material.
        """
    def UnsetTransparency(self) -> None: 
        """
        Removes the transparency setting. The object is opaque by default.
        """
    def UnsetWidth(self) -> None: 
        """
        Reset width to default value.
        """
    def UpdateSelection(self,theMode : int=-1) -> None: 
        """
        Sets update status FULL to selections of the object. Must be used as the only method of UpdateSelection from outer classes to prevent BVH structures from being outdated.
        """
    def UpdateTransformation(self) -> None: 
        """
        Recomputes the location of the selection aSelection.
        """
    def UpdateTransformations(self,aSelection : OCP.SelectMgr.SelectMgr_Selection) -> None: 
        """
        Updates locations in all sensitive entities from <aSelection> and in corresponding entity owners.
        """
    def ViewAffinity(self) -> OCP.Graphic3d.Graphic3d_ViewAffinity: 
        """
        Return view affinity mask.
        """
    def Width(self) -> float: 
        """
        Returns the width setting of the Interactive Object.
        """
    def ZLayer(self) -> int: 
        """
        Get ID of Z layer for main presentation.
        """
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class AIS_BadEdgeFilter(OCP.SelectMgr.SelectMgr_Filter, OCP.Standard.Standard_Transient):
    """
    A ClassA ClassA Class
    """
    def ActsOn(self,aType : OCP.TopAbs.TopAbs_ShapeEnum) -> bool: 
        """
        None
        """
    def AddEdge(self,anEdge : OCP.TopoDS.TopoDS_Edge,Index : int) -> None: 
        """
        Adds an edge to the list of non-selectionnable edges.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def IsOk(self,EO : OCP.SelectMgr.SelectMgr_EntityOwner) -> bool: 
        """
        None
        """
    def RemoveEdges(self,Index : int) -> None: 
        """
        removes from the list of non-selectionnable edges all edges in the contour <Index>.
        """
    def SetContour(self,Index : int) -> None: 
        """
        sets <myContour> with current contour. used by IsOk.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class AIS_AnimationAxisRotation(AIS_BaseAnimationObject, AIS_Animation, OCP.Standard.Standard_Transient):
    """
    Animation defining object transformation.
    """
    def Add(self,theAnimation : AIS_Animation) -> None: 
        """
        Add single animation to the timeline.
        """
    def Children(self) -> Any: 
        """
        Return sequence of child animations.
        """
    def Clear(self) -> None: 
        """
        Clear animation timeline - remove all animations from it.
        """
    def CopyFrom(self,theOther : AIS_Animation) -> None: 
        """
        Clears own children and then copy child animations from another object. Copy also Start Time and Duration values.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def Duration(self) -> float: 
        """
        Returns duration of the animation in the timeline
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def ElapsedTime(self) -> float: 
        """
        Return elapsed time.
        """
    def Find(self,theAnimationName : OCP.TCollection.TCollection_AsciiString) -> AIS_Animation: 
        """
        Return the child animation with the given name.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasOwnDuration(self) -> bool: 
        """
        Return true if duration is defined.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def IsStopped(self) -> bool: 
        """
        Check if animation is to be performed in the animation timeline.
        """
    def Name(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Animation name.
        """
    def OwnDuration(self) -> float: 
        """
        Returns own duration of the animation in the timeline
        """
    def Pause(self) -> None: 
        """
        Pause the process timeline.
        """
    def Remove(self,theAnimation : AIS_Animation) -> bool: 
        """
        Remove the child animation.
        """
    def Replace(self,theAnimationOld : AIS_Animation,theAnimationNew : AIS_Animation) -> bool: 
        """
        Replace the child animation.
        """
    def SetOwnDuration(self,theDuration : float) -> None: 
        """
        Defines duration of the animation.
        """
    def SetStartPts(self,thePtsStart : float) -> None: 
        """
        Sets time limits for animation in the animation timeline
        """
    def SetTimer(self,theTimer : Media_Timer) -> None: 
        """
        Set playback timer.
        """
    def Start(self,theToUpdate : bool) -> None: 
        """
        Start animation. This method changes status of the animation to Started. This status defines whether animation is to be performed in the timeline or not.
        """
    def StartPts(self) -> float: 
        """
        Returns start time of the animation in the timeline
        """
    def StartTimer(self,theStartPts : float,thePlaySpeed : float,theToUpdate : bool,theToStopTimer : bool=False) -> None: 
        """
        Start animation with internally defined timer instance. Calls ::Start() internally.
        """
    def Stop(self) -> None: 
        """
        Stop animation. This method changed status of the animation to Stopped. This status shows that animation will not be performed in the timeline or it is finished.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Timer(self) -> Media_Timer: 
        """
        Return playback timer.
        """
    def Update(self,thePts : float) -> bool: 
        """
        Update single frame of animation, update timer state
        """
    def UpdateTimer(self) -> float: 
        """
        Update single frame of animation, update timer state
        """
    def UpdateTotalDuration(self) -> None: 
        """
        Update total duration considering all animations on timeline.
        """
    def __init__(self,theAnimationName : OCP.TCollection.TCollection_AsciiString,theContext : AIS_InteractiveContext,theObject : AIS_InteractiveObject,theAxis : OCP.gp.gp_Ax1,theAngleStart : float,theAngleEnd : float) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class AIS_C0RegularityFilter(OCP.SelectMgr.SelectMgr_Filter, OCP.Standard.Standard_Transient):
    def ActsOn(self,aType : OCP.TopAbs.TopAbs_ShapeEnum) -> bool: 
        """
        None
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def IsOk(self,EO : OCP.SelectMgr.SelectMgr_EntityOwner) -> bool: 
        """
        None
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self,aShape : OCP.TopoDS.TopoDS_Shape) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class AIS_CameraFrustum(AIS_InteractiveObject, OCP.SelectMgr.SelectMgr_SelectableObject, OCP.PrsMgr.PrsMgr_PresentableObject, OCP.Standard.Standard_Transient):
    """
    Presentation for drawing camera frustum. Default configuration is built with filling and some transparency.
    """
    class SelectionMode_e():
        """
        Selection modes supported by this object

        Members:

          SelectionMode_Edges

          SelectionMode_Volume
        """
        def __eq__(self,other : object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __init__(self,value : int) -> None: ...
        def __int__(self) -> int: ...
        def __ne__(self,other : object) -> bool: ...
        def __repr__(self) -> str: ...
        def __setstate__(self,state : int) -> None: ...
        def __str__(self) -> str: ...
        @property
        def name(self) -> None:
            """
            :type: None
            """
        @property
        def value(self) -> int:
            """
            :type: int
            """
        SelectionMode_Edges: OCP.AIS.SelectionMode_e # value = <SelectionMode_e.SelectionMode_Edges: 0>
        SelectionMode_Volume: OCP.AIS.SelectionMode_e # value = <SelectionMode_e.SelectionMode_Volume: 1>
        __entries: dict # value = {'SelectionMode_Edges': (<SelectionMode_e.SelectionMode_Edges: 0>, None), 'SelectionMode_Volume': (<SelectionMode_e.SelectionMode_Volume: 1>, None)}
        __members__: dict # value = {'SelectionMode_Edges': <SelectionMode_e.SelectionMode_Edges: 0>, 'SelectionMode_Volume': <SelectionMode_e.SelectionMode_Volume: 1>}
        pass
    def AcceptDisplayMode(self,theMode : int) -> bool: 
        """
        Return true if specified display mode is supported.
        """
    def AcceptShapeDecomposition(self) -> bool: 
        """
        Informs the graphic context that the interactive Object may be decomposed into sub-shapes for dynamic selection. The most used Interactive Object is AIS_Shape.
        """
    def AddChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy.
        """
    def AddChildWithCurrentTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy with keeping the current global transformation So the object keeps the same position/orientation in the global CS.
        """
    def AddClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Adds clip plane for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def AddSelection(self,aSelection : OCP.SelectMgr.SelectMgr_Selection,aMode : int) -> None: 
        """
        Adds the selection aSelection with the selection mode index aMode to this framework.
        """
    def Attributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the attributes settings.
        """
    def BndBoxOfSelected(self,theOwners : Any) -> OCP.Bnd.Bnd_Box: 
        """
        Returns a bounding box of sensitive entities with the owners given if they are a part of activated selection
        """
    def BoundingBox(self,theBndBox : OCP.Bnd.Bnd_Box) -> None: 
        """
        Returns bounding box of object correspondingly to its current display mode. This method requires presentation to be already computed, since it relies on bounding box of presentation structures, which are supposed to be same/close amongst different display modes of this object.
        """
    def Children(self) -> OCP.PrsMgr.PrsMgr_ListOfPresentableObjects: 
        """
        Returns children of the current object.
        """
    def ClearDynamicHighlight(self,theMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> None: 
        """
        Method that needs to be implemented when the object manages selection and dynamic highlighting on its own. Clears or invalidates dynamic highlight presentation. By default it clears immediate draw of given presentation manager.
        """
    def ClearOwner(self) -> None: 
        """
        Each Interactive Object has methods which allow us to attribute an Owner to it in the form of a Transient. This method removes the owner from the graphic entity.
        """
    def ClearSelected(self) -> None: 
        """
        Method which clear all selected owners belonging to this selectable object ( for fast presentation draw )
        """
    def ClearSelections(self,update : bool=False) -> None: 
        """
        Empties all the selections in the SelectableObject <update> parameter defines whether all object's selections should be flagged for further update or not. This improved method can be used to recompute an object's selection (without redisplaying the object completely) when some selection mode is activated not for the first time.
        """
    def ClipPlanes(self) -> OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane: 
        """
        Get clip planes.
        """
    def Color(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Returns the color setting of the Interactive Object.
        """
    def CombinedParentTransformation(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return combined parent transformation.
        """
    def ComputeSelection(self,theSelection : OCP.SelectMgr.SelectMgr_Selection,theMode : int) -> None: 
        """
        Computes sensitive primitives for the given selection mode - key interface method of Selectable Object.
        """
    def CurrentFacingModel(self) -> OCP.Aspect.Aspect_TypeOfFacingModel: 
        """
        Returns the current facing model which is in effect.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def DefaultDisplayMode(self) -> int: 
        """
        Returns the default display mode.
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DisplayMode(self) -> int: 
        """
        Returns the display mode setting of the Interactive Object. The range of supported display mode indexes should be specified within object definition and filtered by AccepDisplayMode().
        """
    def DisplayStatus(self) -> OCP.PrsMgr.PrsMgr_DisplayStatus: 
        """
        Return presentation display status; PrsMgr_DisplayStatus_None by default.
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicHilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalDynamic and Prs3d_TypeOfHighlight_Dynamic defined within AIS_InteractiveContext::HighlightStyle().
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def ErasePresentations(self,theToRemove : bool) -> None: 
        """
        Removes presentations returned by GetHilightPresentation() and GetSelectPresentation().
        """
    def GetAssemblyOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns common entity owner if the object is an assembly
        """
    def GetContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def GetHilightPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting detected object.
        """
    def GetOwner(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns the owner of the Interactive Object. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient. There are two types of owners: - Direct owners, decomposition shapes such as edges, wires, and faces. - Users, presentable objects connecting to sensitive primitives, or a shape which has been decomposed.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def GetSelectPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting selected object.
        """
    def GlobalSelOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns the owner of mode for selection of object as a whole
        """
    def GlobalSelectionMode(self) -> int: 
        """
        Returns the mode for selection of object as a whole; 0 by default.
        """
    def HasColor(self) -> bool: 
        """
        Returns true if the Interactive Object has color.
        """
    def HasDisplayMode(self) -> bool: 
        """
        Returns true if the Interactive Object has display mode setting overriding global setting (within Interactive Context).
        """
    def HasHilightMode(self) -> bool: 
        """
        Returns true if the Interactive Object is in highlight mode.
        """
    def HasInteractiveContext(self) -> bool: 
        """
        Indicates whether the Interactive Object has a pointer to an interactive context.
        """
    def HasMaterial(self) -> bool: 
        """
        Returns true if the Interactive Object has a setting for material.
        """
    def HasOwnPresentations(self) -> bool: 
        """
        Returns true if object should have own presentations.
        """
    def HasOwner(self) -> bool: 
        """
        Returns true if the object has an owner attributed to it. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient.
        """
    def HasPolygonOffsets(self) -> bool: 
        """
        Returns Standard_True if <myDrawer> has non-null shading aspect
        """
    def HasPresentation(self) -> bool: 
        """
        Returns TRUE when this object has a presentation in the current DisplayMode()
        """
    def HasSelection(self,theMode : int) -> bool: 
        """
        Returns true if a selection corresponding to the selection mode theMode was computed for this object.
        """
    def HasTransformation(self) -> bool: 
        """
        Returns true if object has a transformation that is different from the identity.
        """
    def HasWidth(self) -> bool: 
        """
        Returns true if the Interactive Object has width.
        """
    def HilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalSelected and Prs3d_TypeOfHighlight_Selected defined within AIS_InteractiveContext::HighlightStyle().
        """
    def HilightMode(self) -> int: 
        """
        Returns highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def HilightOwnerWithColor(self,thePM : OCP.PrsMgr.PrsMgr_PresentationManager,theStyle : OCP.Prs3d.Prs3d_Drawer,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner) -> None: 
        """
        Method which hilight an owner belonging to this selectable object ( for fast presentation draw )
        """
    def HilightSelected(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager,theSeq : OCP.SelectMgr.SelectMgr_SequenceOfOwner) -> None: 
        """
        Method which draws selected owners ( for fast presentation draw )
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def InteractiveContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def InversedTransformation(self) -> OCP.gp.gp_GTrsf: 
        """
        Return inversed transformation.
        """
    def IsAutoHilight(self) -> bool: 
        """
        If returns True, the old mechanism for highlighting selected objects is used (HilightSelected Method may be empty). If returns False, the HilightSelected method will be fully responsible for highlighting selected entity owners belonging to this selectable object.
        """
    def IsInfinite(self) -> bool: 
        """
        Returns true if the interactive object is infinite; FALSE by default. This flag affects various operations operating on bounding box of graphic presentations of this object. For instance, infinite objects are not taken in account for View FitAll. This does not necessarily means that object is actually infinite, auxiliary objects might be also marked with this flag to achieve desired behavior.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def IsMutable(self) -> bool: 
        """
        Returns true if object has mutable nature (content or location are be changed regularly). Mutable object will be managed in different way than static onces (another optimizations).
        """
    def IsTransparent(self) -> bool: 
        """
        Returns true if there is a transparency setting.
        """
    def LocalTransformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def LocalTransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def Material(self) -> OCP.Graphic3d.Graphic3d_NameOfMaterial: 
        """
        Returns the current material setting as enumeration value.
        """
    def Parent(self) -> OCP.PrsMgr.PrsMgr_PresentableObject: 
        """
        Returns parent of current object in scene hierarchy.
        """
    def PolygonOffsets(self,aFactor : float,aUnits : float) -> tuple[int]: 
        """
        Retrieves current polygon offsets settings from <myDrawer>.
        """
    def Presentation(self) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Returns the current presentation of this object according to the current DisplayMode()
        """
    def Presentations(self) -> OCP.PrsMgr.PrsMgr_Presentations: 
        """
        Return presentations.
        """
    def ProcessDragging(self,theCtx : AIS_InteractiveContext,theView : OCP.V3d.V3d_View,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theDragFrom : OCP.Graphic3d.Graphic3d_Vec2i,theDragTo : OCP.Graphic3d.Graphic3d_Vec2i,theAction : AIS_DragAction) -> bool: 
        """
        Drag object in the viewer.
        """
    @overload
    def RecomputePrimitives(self) -> None: 
        """
        Re-computes the sensitive primitives for all modes. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.

        Re-computes the sensitive primitives which correspond to the <theMode>th selection mode. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.
        """
    @overload
    def RecomputePrimitives(self,theMode : int) -> None: ...
    def Redisplay(self,AllModes : bool=False) -> None: 
        """
        Updates the active presentation; if <AllModes> = Standard_True all the presentations inside are recomputed. IMPORTANT: It is preferable to call Redisplay method of corresponding AIS_InteractiveContext instance for cases when it is accessible. This method just redirects call to myCTXPtr, so this class field must be up to date for proper result.
        """
    def RemoveChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy.
        """
    def RemoveChildWithRestoreTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy with keeping the current global transformation. So the object keeps the same position/orientation in the global CS.
        """
    def RemoveClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Removes previously added clip plane.
        """
    def ResetTransformation(self) -> None: 
        """
        None
        """
    def Selection(self,theMode : int) -> OCP.SelectMgr.SelectMgr_Selection: 
        """
        Returns the selection having specified selection mode or NULL.
        """
    def Selections(self) -> OCP.SelectMgr.SelectMgr_SequenceOfSelection: 
        """
        Return the sequence of selections.
        """
    def SetAspect(self,anAspect : OCP.Prs3d.Prs3d_BasicAspect) -> None: 
        """
        Sets the graphic basic aspect to the current presentation.
        """
    def SetAssemblyOwner(self,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theMode : int=-1) -> None: 
        """
        Sets common entity owner for assembly sensitive object entities
        """
    def SetAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the drawing tool theDrawer.
        """
    def SetAutoHilight(self,theAutoHilight : bool) -> None: 
        """
        Set AutoHilight property to true or false.
        """
    def SetCameraFrustum(self,theCamera : OCP.Graphic3d.Graphic3d_Camera) -> None: 
        """
        Sets camera frustum.
        """
    def SetClipPlanes(self,thePlanes : OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane) -> None: 
        """
        Set clip planes for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def SetColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Setup custom color.
        """
    def SetContext(self,aCtx : AIS_InteractiveContext) -> None: 
        """
        Sets the interactive context aCtx and provides a link to the default drawing tool or "Drawer" if there is none.
        """
    def SetCurrentFacingModel(self,theModel : OCP.Aspect.Aspect_TypeOfFacingModel=Aspect_TypeOfFacingModel.Aspect_TOFM_BOTH_SIDE) -> None: 
        """
        change the current facing model apply on polygons for SetColor(), SetTransparency(), SetMaterial() methods default facing model is Aspect_TOFM_TWO_SIDE. This mean that attributes is applying both on the front and back face.
        """
    def SetDisplayMode(self,theMode : int) -> None: 
        """
        Sets the display mode for the interactive object. An object can have its own temporary display mode, which is different from that proposed by the interactive context.
        """
    def SetDynamicHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the dynamic hilight drawing tool.
        """
    def SetHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the hilight drawing tool theDrawer.
        """
    def SetHilightMode(self,theMode : int) -> None: 
        """
        Sets highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def SetInfiniteState(self,theFlag : bool=True) -> None: 
        """
        Sets if object should be considered as infinite.
        """
    def SetIsoOnTriangulation(self,theIsEnabled : bool) -> None: 
        """
        Enables or disables on-triangulation build of isolines according to the flag given.
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.gp.gp_Trsf) -> None: 
        """
        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.

        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.TopLoc.TopLoc_Datum3D) -> None: ...
    def SetMaterial(self,aName : OCP.Graphic3d.Graphic3d_MaterialAspect) -> None: 
        """
        Sets the material aMat defining this display attribute for the interactive object. Material aspect determines shading aspect, color and transparency of visible entities.
        """
    def SetMutable(self,theIsMutable : bool) -> None: 
        """
        Sets if the object has mutable nature (content or location will be changed regularly). This method should be called before object displaying to take effect.
        """
    def SetOwner(self,theApplicativeEntity : OCP.Standard.Standard_Transient) -> None: 
        """
        Allows you to attribute the owner theApplicativeEntity to an Interactive Object. This can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of. The owner takes the form of a transient.
        """
    def SetPolygonOffsets(self,aMode : int,aFactor : float=1.0,aUnits : float=0.0) -> None: 
        """
        Sets up polygon offsets for this object.
        """
    def SetPropagateVisualState(self,theFlag : bool) -> None: 
        """
        Change the value of the flag "propagate visual state"
        """
    @overload
    def SetToUpdate(self) -> None: 
        """
        Flags presentation to be updated; UpdatePresentations() will recompute these presentations.

        flags all the Presentations to be Updated.
        """
    @overload
    def SetToUpdate(self,theMode : int) -> None: ...
    def SetTransformPersistence(self,theTrsfPers : OCP.Graphic3d.Graphic3d_TransformPers) -> None: 
        """
        Sets up Transform Persistence defining a special Local Coordinate system where this object should be located. Note that management of Transform Persistence object is more expensive than of the normal one, because it requires its position being recomputed basing on camera position within each draw call / traverse.
        """
    def SetTransparency(self,aValue : float=0.6) -> None: 
        """
        Attributes a setting aValue for transparency. The transparency value should be between 0.0 and 1.0. At 0.0 an object will be totally opaque, and at 1.0, fully transparent. Warning At a value of 1.0, there may be nothing visible.
        """
    def SetTypeOfPresentation(self,theType : OCP.PrsMgr.PrsMgr_TypeOfPresentation3d) -> None: 
        """
        Set type of presentation.
        """
    def SetWidth(self,theWidth : float) -> None: 
        """
        Allows you to provide the setting aValue for width. Only the Interactive Object knows which Drawer attribute is affected by the width setting.
        """
    def SetZLayer(self,theLayerId : int) -> None: 
        """
        Set Z layer ID and update all presentations of the selectable object. The layers mechanism allows drawing objects in higher layers in overlay of objects in lower layers.
        """
    def Signature(self) -> int: 
        """
        Specifies additional characteristics of Interactive Object of Type(); -1 by default. Among the datums, this signature is attributed to the shape. The remaining datums have the following default signatures: - Point signature 1 - Axis signature 2 - Trihedron signature 3 - PlaneTrihedron signature 4 - Line signature 5 - Circle signature 6 - Plane signature 7.
        """
    def SynchronizeAspects(self) -> None: 
        """
        Synchronize presentation aspects after their modification.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    @overload
    def ToBeUpdated(self,ListOfMode : OCP.TColStd.TColStd_ListOfInteger) -> None: 
        """
        Returns TRUE if any active presentation has invalidation flag.

        gives the list of modes which are flagged "to be updated".
        """
    @overload
    def ToBeUpdated(self,theToIncludeHidden : bool=False) -> bool: ...
    def ToPropagateVisualState(self) -> bool: 
        """
        Get value of the flag "propagate visual state" It means that the display/erase/color visual state is propagated automatically to all children; by default, the flag is true
        """
    def TransformPersistence(self) -> OCP.Graphic3d.Graphic3d_TransformPers: 
        """
        Returns Transformation Persistence defining a special Local Coordinate system where this presentable object is located or NULL handle if not defined. Position of the object having Transformation Persistence is mutable and depends on camera position. The same applies to a bounding box of the object.
        """
    def Transformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def TransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def Transparency(self) -> float: 
        """
        Returns the transparency setting. This will be between 0.0 and 1.0. At 0.0 an object will be totally opaque, and at 1.0, fully transparent.
        """
    def Type(self) -> AIS_KindOfInteractive: 
        """
        Returns the kind of Interactive Object; AIS_KindOfInteractive_None by default.
        """
    def TypeOfPresentation3d(self) -> OCP.PrsMgr.PrsMgr_TypeOfPresentation3d: 
        """
        Returns information on whether the object accepts display in HLR mode or not.
        """
    def UnsetAttributes(self) -> None: 
        """
        Clears settings provided by the drawing tool aDrawer.
        """
    def UnsetColor(self) -> None: 
        """
        Restore default color.
        """
    def UnsetDisplayMode(self) -> None: 
        """
        Removes display mode settings from the interactive object.
        """
    def UnsetHilightAttributes(self) -> None: 
        """
        Clears settings provided by the hilight drawing tool theDrawer.
        """
    def UnsetHilightMode(self) -> None: 
        """
        Unsets highlight display mode.
        """
    def UnsetMaterial(self) -> None: 
        """
        Removes the setting for material.
        """
    def UnsetTransparency(self) -> None: 
        """
        Restore transparency setting.
        """
    def UnsetWidth(self) -> None: 
        """
        Reset width to default value.
        """
    def UpdateSelection(self,theMode : int=-1) -> None: 
        """
        Sets update status FULL to selections of the object. Must be used as the only method of UpdateSelection from outer classes to prevent BVH structures from being outdated.
        """
    def UpdateTransformation(self) -> None: 
        """
        Recomputes the location of the selection aSelection.
        """
    def UpdateTransformations(self,aSelection : OCP.SelectMgr.SelectMgr_Selection) -> None: 
        """
        Updates locations in all sensitive entities from <aSelection> and in corresponding entity owners.
        """
    def ViewAffinity(self) -> OCP.Graphic3d.Graphic3d_ViewAffinity: 
        """
        Return view affinity mask.
        """
    def Width(self) -> float: 
        """
        Returns the width setting of the Interactive Object.
        """
    def ZLayer(self) -> int: 
        """
        Get ID of Z layer for main presentation.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    SelectionMode_Edges: OCP.AIS.SelectionMode_e # value = <SelectionMode_e.SelectionMode_Edges: 0>
    SelectionMode_Volume: OCP.AIS.SelectionMode_e # value = <SelectionMode_e.SelectionMode_Volume: 1>
    pass
class AIS_Circle(AIS_InteractiveObject, OCP.SelectMgr.SelectMgr_SelectableObject, OCP.PrsMgr.PrsMgr_PresentableObject, OCP.Standard.Standard_Transient):
    """
    Constructs circle datums to be used in construction of composite shapes.Constructs circle datums to be used in construction of composite shapes.
    """
    def AcceptDisplayMode(self,theMode : int) -> bool: 
        """
        Returns true if the class of objects accepts specified display mode index. The interactive context can have a default mode of representation for the set of Interactive Objects. This mode may not be accepted by a given class of objects. Consequently, this virtual method allowing us to get information about the class in question must be implemented. At least one display mode index should be accepted by this method. Although subclass can leave default implementation, it is highly desired defining exact list of supported modes instead, which is usually an enumeration for one object or objects class sharing similar list of display modes.
        """
    def AcceptShapeDecomposition(self) -> bool: 
        """
        Informs the graphic context that the interactive Object may be decomposed into sub-shapes for dynamic selection. The most used Interactive Object is AIS_Shape.
        """
    def AddChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy.
        """
    def AddChildWithCurrentTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy with keeping the current global transformation So the object keeps the same position/orientation in the global CS.
        """
    def AddClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Adds clip plane for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def AddSelection(self,aSelection : OCP.SelectMgr.SelectMgr_Selection,aMode : int) -> None: 
        """
        Adds the selection aSelection with the selection mode index aMode to this framework.
        """
    def Attributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the attributes settings.
        """
    def BndBoxOfSelected(self,theOwners : Any) -> OCP.Bnd.Bnd_Box: 
        """
        Returns a bounding box of sensitive entities with the owners given if they are a part of activated selection
        """
    def BoundingBox(self,theBndBox : OCP.Bnd.Bnd_Box) -> None: 
        """
        Returns bounding box of object correspondingly to its current display mode. This method requires presentation to be already computed, since it relies on bounding box of presentation structures, which are supposed to be same/close amongst different display modes of this object.
        """
    def Children(self) -> OCP.PrsMgr.PrsMgr_ListOfPresentableObjects: 
        """
        Returns children of the current object.
        """
    def Circle(self) -> OCP.Geom.Geom_Circle: 
        """
        Returns the circle component defined in SetCircle.
        """
    def ClearDynamicHighlight(self,theMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> None: 
        """
        Method that needs to be implemented when the object manages selection and dynamic highlighting on its own. Clears or invalidates dynamic highlight presentation. By default it clears immediate draw of given presentation manager.
        """
    def ClearOwner(self) -> None: 
        """
        Each Interactive Object has methods which allow us to attribute an Owner to it in the form of a Transient. This method removes the owner from the graphic entity.
        """
    def ClearSelected(self) -> None: 
        """
        Method which clear all selected owners belonging to this selectable object ( for fast presentation draw )
        """
    def ClearSelections(self,update : bool=False) -> None: 
        """
        Empties all the selections in the SelectableObject <update> parameter defines whether all object's selections should be flagged for further update or not. This improved method can be used to recompute an object's selection (without redisplaying the object completely) when some selection mode is activated not for the first time.
        """
    def ClipPlanes(self) -> OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane: 
        """
        Get clip planes.
        """
    def Color(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Returns the color setting of the Interactive Object.
        """
    def CombinedParentTransformation(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return combined parent transformation.
        """
    def ComputeSelection(self,theSelection : OCP.SelectMgr.SelectMgr_Selection,theMode : int) -> None: 
        """
        Computes sensitive primitives for the given selection mode - key interface method of Selectable Object.
        """
    def CurrentFacingModel(self) -> OCP.Aspect.Aspect_TypeOfFacingModel: 
        """
        Returns the current facing model which is in effect.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def DefaultDisplayMode(self) -> int: 
        """
        Returns the default display mode.
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DisplayMode(self) -> int: 
        """
        Returns the display mode setting of the Interactive Object. The range of supported display mode indexes should be specified within object definition and filtered by AccepDisplayMode().
        """
    def DisplayStatus(self) -> OCP.PrsMgr.PrsMgr_DisplayStatus: 
        """
        Return presentation display status; PrsMgr_DisplayStatus_None by default.
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicHilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalDynamic and Prs3d_TypeOfHighlight_Dynamic defined within AIS_InteractiveContext::HighlightStyle().
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def ErasePresentations(self,theToRemove : bool) -> None: 
        """
        Removes presentations returned by GetHilightPresentation() and GetSelectPresentation().
        """
    def GetAssemblyOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns common entity owner if the object is an assembly
        """
    def GetContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def GetHilightPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting detected object.
        """
    def GetOwner(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns the owner of the Interactive Object. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient. There are two types of owners: - Direct owners, decomposition shapes such as edges, wires, and faces. - Users, presentable objects connecting to sensitive primitives, or a shape which has been decomposed.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def GetSelectPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting selected object.
        """
    def GlobalSelOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns the owner of mode for selection of object as a whole
        """
    def GlobalSelectionMode(self) -> int: 
        """
        Returns the mode for selection of object as a whole; 0 by default.
        """
    def HasColor(self) -> bool: 
        """
        Returns true if the Interactive Object has color.
        """
    def HasDisplayMode(self) -> bool: 
        """
        Returns true if the Interactive Object has display mode setting overriding global setting (within Interactive Context).
        """
    def HasHilightMode(self) -> bool: 
        """
        Returns true if the Interactive Object is in highlight mode.
        """
    def HasInteractiveContext(self) -> bool: 
        """
        Indicates whether the Interactive Object has a pointer to an interactive context.
        """
    def HasMaterial(self) -> bool: 
        """
        Returns true if the Interactive Object has a setting for material.
        """
    def HasOwnPresentations(self) -> bool: 
        """
        Returns true if object should have own presentations.
        """
    def HasOwner(self) -> bool: 
        """
        Returns true if the object has an owner attributed to it. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient.
        """
    def HasPolygonOffsets(self) -> bool: 
        """
        Returns Standard_True if <myDrawer> has non-null shading aspect
        """
    def HasPresentation(self) -> bool: 
        """
        Returns TRUE when this object has a presentation in the current DisplayMode()
        """
    def HasSelection(self,theMode : int) -> bool: 
        """
        Returns true if a selection corresponding to the selection mode theMode was computed for this object.
        """
    def HasTransformation(self) -> bool: 
        """
        Returns true if object has a transformation that is different from the identity.
        """
    def HasWidth(self) -> bool: 
        """
        Returns true if the Interactive Object has width.
        """
    def HilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalSelected and Prs3d_TypeOfHighlight_Selected defined within AIS_InteractiveContext::HighlightStyle().
        """
    def HilightMode(self) -> int: 
        """
        Returns highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def HilightOwnerWithColor(self,thePM : OCP.PrsMgr.PrsMgr_PresentationManager,theStyle : OCP.Prs3d.Prs3d_Drawer,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner) -> None: 
        """
        Method which hilight an owner belonging to this selectable object ( for fast presentation draw )
        """
    def HilightSelected(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager,theSeq : OCP.SelectMgr.SelectMgr_SequenceOfOwner) -> None: 
        """
        Method which draws selected owners ( for fast presentation draw )
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def InteractiveContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def InversedTransformation(self) -> OCP.gp.gp_GTrsf: 
        """
        Return inversed transformation.
        """
    def IsAutoHilight(self) -> bool: 
        """
        If returns True, the old mechanism for highlighting selected objects is used (HilightSelected Method may be empty). If returns False, the HilightSelected method will be fully responsible for highlighting selected entity owners belonging to this selectable object.
        """
    def IsFilledCircleSens(self) -> bool: 
        """
        Returns the type of sensitivity for the circle;
        """
    def IsInfinite(self) -> bool: 
        """
        Returns true if the interactive object is infinite; FALSE by default. This flag affects various operations operating on bounding box of graphic presentations of this object. For instance, infinite objects are not taken in account for View FitAll. This does not necessarily means that object is actually infinite, auxiliary objects might be also marked with this flag to achieve desired behavior.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def IsMutable(self) -> bool: 
        """
        Returns true if object has mutable nature (content or location are be changed regularly). Mutable object will be managed in different way than static onces (another optimizations).
        """
    def IsTransparent(self) -> bool: 
        """
        Returns true if there is a transparency setting.
        """
    def LocalTransformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def LocalTransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def Material(self) -> OCP.Graphic3d.Graphic3d_NameOfMaterial: 
        """
        Returns the current material setting as enumeration value.
        """
    def Parameters(self) -> tuple[float, float]: 
        """
        Constructs instances of the starting point and the end point parameters, theU1 and theU2.
        """
    def Parent(self) -> OCP.PrsMgr.PrsMgr_PresentableObject: 
        """
        Returns parent of current object in scene hierarchy.
        """
    def PolygonOffsets(self,aFactor : float,aUnits : float) -> tuple[int]: 
        """
        Retrieves current polygon offsets settings from <myDrawer>.
        """
    def Presentation(self) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Returns the current presentation of this object according to the current DisplayMode()
        """
    def Presentations(self) -> OCP.PrsMgr.PrsMgr_Presentations: 
        """
        Return presentations.
        """
    def ProcessDragging(self,theCtx : AIS_InteractiveContext,theView : OCP.V3d.V3d_View,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theDragFrom : OCP.Graphic3d.Graphic3d_Vec2i,theDragTo : OCP.Graphic3d.Graphic3d_Vec2i,theAction : AIS_DragAction) -> bool: 
        """
        Drag object in the viewer.
        """
    @overload
    def RecomputePrimitives(self) -> None: 
        """
        Re-computes the sensitive primitives for all modes. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.

        Re-computes the sensitive primitives which correspond to the <theMode>th selection mode. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.
        """
    @overload
    def RecomputePrimitives(self,theMode : int) -> None: ...
    def Redisplay(self,AllModes : bool=False) -> None: 
        """
        Updates the active presentation; if <AllModes> = Standard_True all the presentations inside are recomputed. IMPORTANT: It is preferable to call Redisplay method of corresponding AIS_InteractiveContext instance for cases when it is accessible. This method just redirects call to myCTXPtr, so this class field must be up to date for proper result.
        """
    def RemoveChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy.
        """
    def RemoveChildWithRestoreTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy with keeping the current global transformation. So the object keeps the same position/orientation in the global CS.
        """
    def RemoveClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Removes previously added clip plane.
        """
    def ResetTransformation(self) -> None: 
        """
        None
        """
    def Selection(self,theMode : int) -> OCP.SelectMgr.SelectMgr_Selection: 
        """
        Returns the selection having specified selection mode or NULL.
        """
    def Selections(self) -> OCP.SelectMgr.SelectMgr_SequenceOfSelection: 
        """
        Return the sequence of selections.
        """
    def SetAspect(self,anAspect : OCP.Prs3d.Prs3d_BasicAspect) -> None: 
        """
        Sets the graphic basic aspect to the current presentation.
        """
    def SetAssemblyOwner(self,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theMode : int=-1) -> None: 
        """
        Sets common entity owner for assembly sensitive object entities
        """
    def SetAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the drawing tool theDrawer.
        """
    def SetAutoHilight(self,theAutoHilight : bool) -> None: 
        """
        Set AutoHilight property to true or false.
        """
    def SetCircle(self,theCircle : OCP.Geom.Geom_Circle) -> None: 
        """
        Allows you to provide settings for the circle datum aCircle.
        """
    def SetClipPlanes(self,thePlanes : OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane) -> None: 
        """
        Set clip planes for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def SetColor(self,aColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        None
        """
    def SetContext(self,aCtx : AIS_InteractiveContext) -> None: 
        """
        Sets the interactive context aCtx and provides a link to the default drawing tool or "Drawer" if there is none.
        """
    def SetCurrentFacingModel(self,theModel : OCP.Aspect.Aspect_TypeOfFacingModel=Aspect_TypeOfFacingModel.Aspect_TOFM_BOTH_SIDE) -> None: 
        """
        change the current facing model apply on polygons for SetColor(), SetTransparency(), SetMaterial() methods default facing model is Aspect_TOFM_TWO_SIDE. This mean that attributes is applying both on the front and back face.
        """
    def SetDisplayMode(self,theMode : int) -> None: 
        """
        Sets the display mode for the interactive object. An object can have its own temporary display mode, which is different from that proposed by the interactive context.
        """
    def SetDynamicHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the dynamic hilight drawing tool.
        """
    def SetFilledCircleSens(self,theIsFilledCircleSens : bool) -> None: 
        """
        Sets the type of sensitivity for the circle. If theIsFilledCircleSens set to Standard_True then the whole circle will be detectable, otherwise only the boundary of the circle.
        """
    def SetFirstParam(self,theU : float) -> None: 
        """
        Allows you to set the parameter theU for the starting point of an arc.
        """
    def SetHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the hilight drawing tool theDrawer.
        """
    def SetHilightMode(self,theMode : int) -> None: 
        """
        Sets highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def SetInfiniteState(self,theFlag : bool=True) -> None: 
        """
        Sets if object should be considered as infinite.
        """
    def SetIsoOnTriangulation(self,theIsEnabled : bool) -> None: 
        """
        Enables or disables on-triangulation build of isolines according to the flag given.
        """
    def SetLastParam(self,theU : float) -> None: 
        """
        Allows you to provide the parameter theU for the end point of an arc.
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.gp.gp_Trsf) -> None: 
        """
        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.

        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.TopLoc.TopLoc_Datum3D) -> None: ...
    def SetMaterial(self,aName : OCP.Graphic3d.Graphic3d_MaterialAspect) -> None: 
        """
        Sets the material aMat defining this display attribute for the interactive object. Material aspect determines shading aspect, color and transparency of visible entities.
        """
    def SetMutable(self,theIsMutable : bool) -> None: 
        """
        Sets if the object has mutable nature (content or location will be changed regularly). This method should be called before object displaying to take effect.
        """
    def SetOwner(self,theApplicativeEntity : OCP.Standard.Standard_Transient) -> None: 
        """
        Allows you to attribute the owner theApplicativeEntity to an Interactive Object. This can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of. The owner takes the form of a transient.
        """
    def SetPolygonOffsets(self,aMode : int,aFactor : float=1.0,aUnits : float=0.0) -> None: 
        """
        Sets up polygon offsets for this object.
        """
    def SetPropagateVisualState(self,theFlag : bool) -> None: 
        """
        Change the value of the flag "propagate visual state"
        """
    @overload
    def SetToUpdate(self) -> None: 
        """
        Flags presentation to be updated; UpdatePresentations() will recompute these presentations.

        flags all the Presentations to be Updated.
        """
    @overload
    def SetToUpdate(self,theMode : int) -> None: ...
    def SetTransformPersistence(self,theTrsfPers : OCP.Graphic3d.Graphic3d_TransformPers) -> None: 
        """
        Sets up Transform Persistence defining a special Local Coordinate system where this object should be located. Note that management of Transform Persistence object is more expensive than of the normal one, because it requires its position being recomputed basing on camera position within each draw call / traverse.
        """
    def SetTransparency(self,aValue : float=0.6) -> None: 
        """
        Attributes a setting aValue for transparency. The transparency value should be between 0.0 and 1.0. At 0.0 an object will be totally opaque, and at 1.0, fully transparent. Warning At a value of 1.0, there may be nothing visible.
        """
    def SetTypeOfPresentation(self,theType : OCP.PrsMgr.PrsMgr_TypeOfPresentation3d) -> None: 
        """
        Set type of presentation.
        """
    def SetWidth(self,aValue : float) -> None: 
        """
        Assigns the width aValue to the solid line boundary of the circle datum.
        """
    def SetZLayer(self,theLayerId : int) -> None: 
        """
        Set Z layer ID and update all presentations of the selectable object. The layers mechanism allows drawing objects in higher layers in overlay of objects in lower layers.
        """
    def Signature(self) -> int: 
        """
        Returns index 6 by default.
        """
    def SynchronizeAspects(self) -> None: 
        """
        Synchronize presentation aspects after their modification.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    @overload
    def ToBeUpdated(self,ListOfMode : OCP.TColStd.TColStd_ListOfInteger) -> None: 
        """
        Returns TRUE if any active presentation has invalidation flag.

        gives the list of modes which are flagged "to be updated".
        """
    @overload
    def ToBeUpdated(self,theToIncludeHidden : bool=False) -> bool: ...
    def ToPropagateVisualState(self) -> bool: 
        """
        Get value of the flag "propagate visual state" It means that the display/erase/color visual state is propagated automatically to all children; by default, the flag is true
        """
    def TransformPersistence(self) -> OCP.Graphic3d.Graphic3d_TransformPers: 
        """
        Returns Transformation Persistence defining a special Local Coordinate system where this presentable object is located or NULL handle if not defined. Position of the object having Transformation Persistence is mutable and depends on camera position. The same applies to a bounding box of the object.
        """
    def Transformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def TransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def Transparency(self) -> float: 
        """
        Returns the transparency setting. This will be between 0.0 and 1.0. At 0.0 an object will be totally opaque, and at 1.0, fully transparent.
        """
    def Type(self) -> AIS_KindOfInteractive: 
        """
        Indicates that the type of Interactive Object is a datum.
        """
    def TypeOfPresentation3d(self) -> OCP.PrsMgr.PrsMgr_TypeOfPresentation3d: 
        """
        Returns information on whether the object accepts display in HLR mode or not.
        """
    def UnsetAttributes(self) -> None: 
        """
        Clears settings provided by the drawing tool aDrawer.
        """
    def UnsetColor(self) -> None: 
        """
        Removes color from the solid line boundary of the circle datum.
        """
    def UnsetDisplayMode(self) -> None: 
        """
        Removes display mode settings from the interactive object.
        """
    def UnsetHilightAttributes(self) -> None: 
        """
        Clears settings provided by the hilight drawing tool theDrawer.
        """
    def UnsetHilightMode(self) -> None: 
        """
        Unsets highlight display mode.
        """
    def UnsetMaterial(self) -> None: 
        """
        Removes the setting for material.
        """
    def UnsetTransparency(self) -> None: 
        """
        Removes the transparency setting. The object is opaque by default.
        """
    def UnsetWidth(self) -> None: 
        """
        Removes width settings from the solid line boundary of the circle datum.
        """
    def UpdateSelection(self,theMode : int=-1) -> None: 
        """
        Sets update status FULL to selections of the object. Must be used as the only method of UpdateSelection from outer classes to prevent BVH structures from being outdated.
        """
    def UpdateTransformation(self) -> None: 
        """
        Recomputes the location of the selection aSelection.
        """
    def UpdateTransformations(self,aSelection : OCP.SelectMgr.SelectMgr_Selection) -> None: 
        """
        Updates locations in all sensitive entities from <aSelection> and in corresponding entity owners.
        """
    def ViewAffinity(self) -> OCP.Graphic3d.Graphic3d_ViewAffinity: 
        """
        Return view affinity mask.
        """
    def Width(self) -> float: 
        """
        Returns the width setting of the Interactive Object.
        """
    def ZLayer(self) -> int: 
        """
        Get ID of Z layer for main presentation.
        """
    @overload
    def __init__(self,aCircle : OCP.Geom.Geom_Circle) -> None: ...
    @overload
    def __init__(self,theCircle : OCP.Geom.Geom_Circle,theUStart : float,theUEnd : float,theIsFilledCircleSens : bool=False) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class AIS_ColorScale(AIS_InteractiveObject, OCP.SelectMgr.SelectMgr_SelectableObject, OCP.PrsMgr.PrsMgr_PresentableObject, OCP.Standard.Standard_Transient):
    """
    Class for drawing a custom color scale.Class for drawing a custom color scale.Class for drawing a custom color scale.
    """
    def AcceptDisplayMode(self,theMode : int) -> bool: 
        """
        Return true if specified display mode is supported.
        """
    def AcceptShapeDecomposition(self) -> bool: 
        """
        Informs the graphic context that the interactive Object may be decomposed into sub-shapes for dynamic selection. The most used Interactive Object is AIS_Shape.
        """
    def AddChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy.
        """
    def AddChildWithCurrentTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy with keeping the current global transformation So the object keeps the same position/orientation in the global CS.
        """
    def AddClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Adds clip plane for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def AddSelection(self,aSelection : OCP.SelectMgr.SelectMgr_Selection,aMode : int) -> None: 
        """
        Adds the selection aSelection with the selection mode index aMode to this framework.
        """
    def Attributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the attributes settings.
        """
    def BndBoxOfSelected(self,theOwners : Any) -> OCP.Bnd.Bnd_Box: 
        """
        Returns a bounding box of sensitive entities with the owners given if they are a part of activated selection
        """
    def BoundingBox(self,theBndBox : OCP.Bnd.Bnd_Box) -> None: 
        """
        Returns bounding box of object correspondingly to its current display mode. This method requires presentation to be already computed, since it relies on bounding box of presentation structures, which are supposed to be same/close amongst different display modes of this object.
        """
    def Children(self) -> OCP.PrsMgr.PrsMgr_ListOfPresentableObjects: 
        """
        Returns children of the current object.
        """
    def ClearDynamicHighlight(self,theMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> None: 
        """
        Method that needs to be implemented when the object manages selection and dynamic highlighting on its own. Clears or invalidates dynamic highlight presentation. By default it clears immediate draw of given presentation manager.
        """
    def ClearOwner(self) -> None: 
        """
        Each Interactive Object has methods which allow us to attribute an Owner to it in the form of a Transient. This method removes the owner from the graphic entity.
        """
    def ClearSelected(self) -> None: 
        """
        Method which clear all selected owners belonging to this selectable object ( for fast presentation draw )
        """
    def ClearSelections(self,update : bool=False) -> None: 
        """
        Empties all the selections in the SelectableObject <update> parameter defines whether all object's selections should be flagged for further update or not. This improved method can be used to recompute an object's selection (without redisplaying the object completely) when some selection mode is activated not for the first time.
        """
    def ClipPlanes(self) -> OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane: 
        """
        Get clip planes.
        """
    def Color(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Returns the color setting of the Interactive Object.
        """
    def ColorRange(self,theMinColor : OCP.Quantity.Quantity_Color,theMaxColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Returns color range corresponding to minimum and maximum values, blue to red by default.
        """
    def CombinedParentTransformation(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return combined parent transformation.
        """
    def Compute(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager,thePresentation : OCP.Graphic3d.Graphic3d_Structure,theMode : int) -> None: 
        """
        Compute presentation.
        """
    def ComputeSelection(self,arg1 : OCP.SelectMgr.SelectMgr_Selection,arg2 : int) -> None: 
        """
        Compute selection - not implemented for color scale.
        """
    def CurrentFacingModel(self) -> OCP.Aspect.Aspect_TypeOfFacingModel: 
        """
        Returns the current facing model which is in effect.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def DefaultDisplayMode(self) -> int: 
        """
        Returns the default display mode.
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DisplayMode(self) -> int: 
        """
        Returns the display mode setting of the Interactive Object. The range of supported display mode indexes should be specified within object definition and filtered by AccepDisplayMode().
        """
    def DisplayStatus(self) -> OCP.PrsMgr.PrsMgr_DisplayStatus: 
        """
        Return presentation display status; PrsMgr_DisplayStatus_None by default.
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicHilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalDynamic and Prs3d_TypeOfHighlight_Dynamic defined within AIS_InteractiveContext::HighlightStyle().
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def ErasePresentations(self,theToRemove : bool) -> None: 
        """
        Removes presentations returned by GetHilightPresentation() and GetSelectPresentation().
        """
    def FindColor(self,theValue : float,theColor : OCP.Quantity.Quantity_Color) -> bool: 
        """
        Calculate color according passed value; returns true if value is in range or false, if isn't
        """
    @staticmethod
    @overload
    def FindColor_s(theValue : float,theMin : float,theMax : float,theColorsCount : int,theColorHlsMin : OCP.SelectMgr.SelectMgr_Vec3,theColorHlsMax : OCP.SelectMgr.SelectMgr_Vec3,theColor : OCP.Quantity.Quantity_Color) -> bool: 
        """
        Calculate color according passed value; returns true if value is in range or false, if isn't

        Calculate color according passed value; returns true if value is in range or false, if isn't
        """
    @staticmethod
    @overload
    def FindColor_s(theValue : float,theMin : float,theMax : float,theColorsCount : int,theColor : OCP.Quantity.Quantity_Color) -> bool: ...
    def Format(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Returns the format of text.
        """
    def GetAssemblyOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns common entity owner if the object is an assembly
        """
    def GetBreadth(self) -> int: 
        """
        Returns the breadth of color bar, 0 by default (e.g. should be set by user explicitly before displaying).
        """
    def GetColorType(self) -> OCP.Aspect.Aspect_TypeOfColorScaleData: 
        """
        Returns the type of colors, Aspect_TOCSD_AUTO by default. Aspect_TOCSD_AUTO - value between Red and Blue Aspect_TOCSD_USER - user specified color from color map
        """
    @overload
    def GetColors(self) -> OCP.Aspect.Aspect_SequenceOfColor: 
        """
        Returns the user specified colors.

        Returns the user specified colors.
        """
    @overload
    def GetColors(self,theColors : OCP.Aspect.Aspect_SequenceOfColor) -> None: ...
    def GetContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def GetFormat(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Returns the format for numbers, "%.4g" by default. The same like format for function printf(). Used if GetLabelType() is TOCSD_AUTO;
        """
    def GetHeight(self) -> int: 
        """
        Returns the height of color bar, 0 by default (e.g. should be set by user explicitly before displaying).
        """
    def GetHilightPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting detected object.
        """
    def GetIntervalColor(self,theIndex : int) -> OCP.Quantity.Quantity_Color: 
        """
        Returns the user specified color from color map with index (starts at 1). Returns default color if index is out of range in color map.
        """
    def GetLabel(self,theIndex : int) -> OCP.TCollection.TCollection_ExtendedString: 
        """
        Returns the user specified label with index theIndex. Index is in range from 1 to GetNumberOfIntervals() or to GetNumberOfIntervals() + 1 if IsLabelAtBorder() is true. Returns empty string if label not defined.
        """
    def GetLabelPosition(self) -> OCP.Aspect.Aspect_TypeOfColorScalePosition: 
        """
        Returns the position of labels concerning color filled rectangles, Aspect_TOCSP_RIGHT by default.
        """
    def GetLabelType(self) -> OCP.Aspect.Aspect_TypeOfColorScaleData: 
        """
        Returns the type of labels, Aspect_TOCSD_AUTO by default. Aspect_TOCSD_AUTO - labels as boundary values for intervals Aspect_TOCSD_USER - user specified label is used
        """
    def GetLabels(self,theLabels : OCP.TColStd.TColStd_SequenceOfExtendedString) -> None: 
        """
        Returns the user specified labels.
        """
    def GetMax(self) -> float: 
        """
        Returns maximal value of color scale, 1.0 by default.
        """
    def GetMin(self) -> float: 
        """
        Returns minimal value of color scale, 0.0 by default.
        """
    def GetNumberOfIntervals(self) -> int: 
        """
        Returns the number of color scale intervals, 10 by default.
        """
    def GetOwner(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns the owner of the Interactive Object. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient. There are two types of owners: - Direct owners, decomposition shapes such as edges, wires, and faces. - Users, presentable objects connecting to sensitive primitives, or a shape which has been decomposed.
        """
    def GetPosition(self) -> tuple[float, float]: 
        """
        Returns the bottom-left position of color scale, 0x0 by default.
        """
    def GetRange(self) -> tuple[float, float]: 
        """
        Returns minimal and maximal values of color scale, 0.0 to 1.0 by default.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def GetSelectPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting selected object.
        """
    def GetSize(self) -> tuple[int, int]: 
        """
        Returns the size of color bar, 0 and 0 by default (e.g. should be set by user explicitly before displaying).
        """
    def GetTextHeight(self) -> int: 
        """
        Returns the font height of text labels, 20 by default.
        """
    def GetTitle(self) -> OCP.TCollection.TCollection_ExtendedString: 
        """
        Returns the color scale title string, empty string by default.
        """
    def GetTitlePosition(self) -> OCP.Aspect.Aspect_TypeOfColorScalePosition: 
        """
        Returns the position of color scale title, Aspect_TOCSP_LEFT by default.
        """
    def GetXPosition(self) -> int: 
        """
        Returns the left position of color scale, 0 by default.
        """
    def GetYPosition(self) -> int: 
        """
        Returns the bottom position of color scale, 0 by default.
        """
    def GlobalSelOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns the owner of mode for selection of object as a whole
        """
    def GlobalSelectionMode(self) -> int: 
        """
        Returns the mode for selection of object as a whole; 0 by default.
        """
    def HasColor(self) -> bool: 
        """
        Returns true if the Interactive Object has color.
        """
    def HasDisplayMode(self) -> bool: 
        """
        Returns true if the Interactive Object has display mode setting overriding global setting (within Interactive Context).
        """
    def HasHilightMode(self) -> bool: 
        """
        Returns true if the Interactive Object is in highlight mode.
        """
    def HasInteractiveContext(self) -> bool: 
        """
        Indicates whether the Interactive Object has a pointer to an interactive context.
        """
    def HasMaterial(self) -> bool: 
        """
        Returns true if the Interactive Object has a setting for material.
        """
    def HasOwnPresentations(self) -> bool: 
        """
        Returns true if object should have own presentations.
        """
    def HasOwner(self) -> bool: 
        """
        Returns true if the object has an owner attributed to it. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient.
        """
    def HasPolygonOffsets(self) -> bool: 
        """
        Returns Standard_True if <myDrawer> has non-null shading aspect
        """
    def HasPresentation(self) -> bool: 
        """
        Returns TRUE when this object has a presentation in the current DisplayMode()
        """
    def HasSelection(self,theMode : int) -> bool: 
        """
        Returns true if a selection corresponding to the selection mode theMode was computed for this object.
        """
    def HasTransformation(self) -> bool: 
        """
        Returns true if object has a transformation that is different from the identity.
        """
    def HasWidth(self) -> bool: 
        """
        Returns true if the Interactive Object has width.
        """
    def HilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalSelected and Prs3d_TypeOfHighlight_Selected defined within AIS_InteractiveContext::HighlightStyle().
        """
    def HilightMode(self) -> int: 
        """
        Returns highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def HilightOwnerWithColor(self,thePM : OCP.PrsMgr.PrsMgr_PresentationManager,theStyle : OCP.Prs3d.Prs3d_Drawer,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner) -> None: 
        """
        Method which hilight an owner belonging to this selectable object ( for fast presentation draw )
        """
    def HilightSelected(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager,theSeq : OCP.SelectMgr.SelectMgr_SequenceOfOwner) -> None: 
        """
        Method which draws selected owners ( for fast presentation draw )
        """
    def HueMax(self) -> float: 
        """
        Returns the hue angle corresponding to maximum value, 0 by default (red).
        """
    def HueMin(self) -> float: 
        """
        Returns the hue angle corresponding to minimum value, 230 by default (blue).
        """
    def HueRange(self) -> tuple[float, float]: 
        """
        Returns the hue angle range corresponding to minimum and maximum values, 230 to 0 by default (blue to red).
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def InteractiveContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def InversedTransformation(self) -> OCP.gp.gp_GTrsf: 
        """
        Return inversed transformation.
        """
    def IsAutoHilight(self) -> bool: 
        """
        If returns True, the old mechanism for highlighting selected objects is used (HilightSelected Method may be empty). If returns False, the HilightSelected method will be fully responsible for highlighting selected entity owners belonging to this selectable object.
        """
    def IsInfinite(self) -> bool: 
        """
        Returns true if the interactive object is infinite; FALSE by default. This flag affects various operations operating on bounding box of graphic presentations of this object. For instance, infinite objects are not taken in account for View FitAll. This does not necessarily means that object is actually infinite, auxiliary objects might be also marked with this flag to achieve desired behavior.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def IsLabelAtBorder(self) -> bool: 
        """
        Returns TRUE if the labels are placed at border of color intervals, TRUE by default. The automatically generated label will show value exactly on the current position: - value connecting two neighbor intervals (TRUE) - value in the middle of interval (FALSE)
        """
    def IsLogarithmic(self) -> bool: 
        """
        Returns TRUE if the color scale has logarithmic intervals, FALSE by default.
        """
    def IsMutable(self) -> bool: 
        """
        Returns true if object has mutable nature (content or location are be changed regularly). Mutable object will be managed in different way than static onces (another optimizations).
        """
    def IsReversed(self) -> bool: 
        """
        Returns TRUE if the labels and colors used in reversed order, FALSE by default. - Normal, bottom-up order with Minimal value on the Bottom and Maximum value on Top. - Reversed, top-down order with Maximum value on the Bottom and Minimum value on Top.
        """
    def IsSmoothTransition(self) -> bool: 
        """
        Return TRUE if color transition between neighbor intervals should be linearly interpolated, FALSE by default.
        """
    def IsTransparent(self) -> bool: 
        """
        Returns true if there is a transparency setting.
        """
    def Labels(self) -> OCP.TColStd.TColStd_SequenceOfExtendedString: 
        """
        Returns the user specified labels.
        """
    def LocalTransformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def LocalTransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    @staticmethod
    def MakeUniformColors_s(theNbColors : int,theLightness : float,theHueFrom : float,theHueTo : float) -> OCP.Aspect.Aspect_SequenceOfColor: 
        """
        Generates sequence of colors of the same lightness value in CIE Lch color space (see #Quantity_TOC_CIELch), with hue values in the specified range. The colors are distributed across the range such as to have perceptually same difference between neighbour colors. For each color, maximal chroma value fitting in sRGB gamut is used.
        """
    def Material(self) -> OCP.Graphic3d.Graphic3d_NameOfMaterial: 
        """
        Returns the current material setting as enumeration value.
        """
    def Parent(self) -> OCP.PrsMgr.PrsMgr_PresentableObject: 
        """
        Returns parent of current object in scene hierarchy.
        """
    def PolygonOffsets(self,aFactor : float,aUnits : float) -> tuple[int]: 
        """
        Retrieves current polygon offsets settings from <myDrawer>.
        """
    def Presentation(self) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Returns the current presentation of this object according to the current DisplayMode()
        """
    def Presentations(self) -> OCP.PrsMgr.PrsMgr_Presentations: 
        """
        Return presentations.
        """
    def ProcessDragging(self,theCtx : AIS_InteractiveContext,theView : OCP.V3d.V3d_View,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theDragFrom : OCP.Graphic3d.Graphic3d_Vec2i,theDragTo : OCP.Graphic3d.Graphic3d_Vec2i,theAction : AIS_DragAction) -> bool: 
        """
        Drag object in the viewer.
        """
    @overload
    def RecomputePrimitives(self) -> None: 
        """
        Re-computes the sensitive primitives for all modes. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.

        Re-computes the sensitive primitives which correspond to the <theMode>th selection mode. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.
        """
    @overload
    def RecomputePrimitives(self,theMode : int) -> None: ...
    def Redisplay(self,AllModes : bool=False) -> None: 
        """
        Updates the active presentation; if <AllModes> = Standard_True all the presentations inside are recomputed. IMPORTANT: It is preferable to call Redisplay method of corresponding AIS_InteractiveContext instance for cases when it is accessible. This method just redirects call to myCTXPtr, so this class field must be up to date for proper result.
        """
    def RemoveChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy.
        """
    def RemoveChildWithRestoreTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy with keeping the current global transformation. So the object keeps the same position/orientation in the global CS.
        """
    def RemoveClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Removes previously added clip plane.
        """
    def ResetTransformation(self) -> None: 
        """
        None
        """
    def Selection(self,theMode : int) -> OCP.SelectMgr.SelectMgr_Selection: 
        """
        Returns the selection having specified selection mode or NULL.
        """
    def Selections(self) -> OCP.SelectMgr.SelectMgr_SequenceOfSelection: 
        """
        Return the sequence of selections.
        """
    def SetAspect(self,anAspect : OCP.Prs3d.Prs3d_BasicAspect) -> None: 
        """
        Sets the graphic basic aspect to the current presentation.
        """
    def SetAssemblyOwner(self,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theMode : int=-1) -> None: 
        """
        Sets common entity owner for assembly sensitive object entities
        """
    def SetAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the drawing tool theDrawer.
        """
    def SetAutoHilight(self,theAutoHilight : bool) -> None: 
        """
        Set AutoHilight property to true or false.
        """
    def SetBreadth(self,theBreadth : int) -> None: 
        """
        Sets the width of color bar.
        """
    def SetClipPlanes(self,thePlanes : OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane) -> None: 
        """
        Set clip planes for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def SetColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Only the interactive object knowns which Drawer attribute is affected by the color, if any (ex: for a wire,it's the wireaspect field of the drawer, but for a vertex, only the point aspect field is affected by the color). WARNING : Do not forget to set the corresponding fields here (hasOwnColor and myDrawer->SetColor())
        """
    def SetColorRange(self,theMinColor : OCP.Quantity.Quantity_Color,theMaxColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Sets color range corresponding to minimum and maximum values.
        """
    def SetColorType(self,theType : OCP.Aspect.Aspect_TypeOfColorScaleData) -> None: 
        """
        Sets the type of colors. Aspect_TOCSD_AUTO - value between Red and Blue Aspect_TOCSD_USER - user specified color from color map
        """
    def SetColors(self,theSeq : OCP.Aspect.Aspect_SequenceOfColor) -> None: 
        """
        Sets the color scale colors. The length of the sequence should be equal to GetNumberOfIntervals().
        """
    def SetContext(self,aCtx : AIS_InteractiveContext) -> None: 
        """
        Sets the interactive context aCtx and provides a link to the default drawing tool or "Drawer" if there is none.
        """
    def SetCurrentFacingModel(self,theModel : OCP.Aspect.Aspect_TypeOfFacingModel=Aspect_TypeOfFacingModel.Aspect_TOFM_BOTH_SIDE) -> None: 
        """
        change the current facing model apply on polygons for SetColor(), SetTransparency(), SetMaterial() methods default facing model is Aspect_TOFM_TWO_SIDE. This mean that attributes is applying both on the front and back face.
        """
    def SetDisplayMode(self,theMode : int) -> None: 
        """
        Sets the display mode for the interactive object. An object can have its own temporary display mode, which is different from that proposed by the interactive context.
        """
    def SetDynamicHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the dynamic hilight drawing tool.
        """
    def SetFormat(self,theFormat : OCP.TCollection.TCollection_AsciiString) -> None: 
        """
        Sets the color scale auto label format specification.
        """
    def SetHeight(self,theHeight : int) -> None: 
        """
        Sets the height of color bar.
        """
    def SetHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the hilight drawing tool theDrawer.
        """
    def SetHilightMode(self,theMode : int) -> None: 
        """
        Sets highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def SetHueRange(self,theMinAngle : float,theMaxAngle : float) -> None: 
        """
        Sets hue angle range corresponding to minimum and maximum values. The valid angle range is [0, 360], see Quantity_Color and Quantity_TOC_HLS for more details.
        """
    def SetInfiniteState(self,theFlag : bool=True) -> None: 
        """
        Sets if object should be considered as infinite.
        """
    def SetIntervalColor(self,theColor : OCP.Quantity.Quantity_Color,theIndex : int) -> None: 
        """
        Sets the color of the specified interval. Note that list is automatically resized to include specified index.
        """
    def SetIsoOnTriangulation(self,theIsEnabled : bool) -> None: 
        """
        Enables or disables on-triangulation build of isolines according to the flag given.
        """
    def SetLabel(self,theLabel : OCP.TCollection.TCollection_ExtendedString,theIndex : int) -> None: 
        """
        Sets the color scale label at index. Note that list is automatically resized to include specified index.
        """
    def SetLabelAtBorder(self,theOn : bool) -> None: 
        """
        Sets true if the labels are placed at border of color intervals (TRUE by default). If set to False, labels will be drawn at color intervals rather than at borders.
        """
    def SetLabelPosition(self,thePos : OCP.Aspect.Aspect_TypeOfColorScalePosition) -> None: 
        """
        Sets the color scale labels position relative to color bar.
        """
    def SetLabelType(self,theType : OCP.Aspect.Aspect_TypeOfColorScaleData) -> None: 
        """
        Sets the type of labels. Aspect_TOCSD_AUTO - labels as boundary values for intervals Aspect_TOCSD_USER - user specified label is used
        """
    def SetLabels(self,theSeq : OCP.TColStd.TColStd_SequenceOfExtendedString) -> None: 
        """
        Sets the color scale labels. The length of the sequence should be equal to GetNumberOfIntervals() or to GetNumberOfIntervals() + 1 if IsLabelAtBorder() is true. If length of the sequence does not much the number of intervals, then these labels will be considered as "free" and will be located at the virtual intervals corresponding to the number of labels (with flag IsLabelAtBorder() having the same effect as in normal case).
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.gp.gp_Trsf) -> None: 
        """
        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.

        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.TopLoc.TopLoc_Datum3D) -> None: ...
    def SetLogarithmic(self,isLogarithmic : bool) -> None: 
        """
        Sets true if the color scale has logarithmic intervals.
        """
    def SetMaterial(self,aName : OCP.Graphic3d.Graphic3d_MaterialAspect) -> None: 
        """
        Sets the material aMat defining this display attribute for the interactive object. Material aspect determines shading aspect, color and transparency of visible entities.
        """
    def SetMax(self,theMax : float) -> None: 
        """
        Sets the maximal value of color scale.
        """
    def SetMin(self,theMin : float) -> None: 
        """
        Sets the minimal value of color scale.
        """
    def SetMutable(self,theIsMutable : bool) -> None: 
        """
        Sets if the object has mutable nature (content or location will be changed regularly). This method should be called before object displaying to take effect.
        """
    def SetNumberOfIntervals(self,theNum : int) -> None: 
        """
        Sets the number of color scale intervals.
        """
    def SetOwner(self,theApplicativeEntity : OCP.Standard.Standard_Transient) -> None: 
        """
        Allows you to attribute the owner theApplicativeEntity to an Interactive Object. This can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of. The owner takes the form of a transient.
        """
    def SetPolygonOffsets(self,aMode : int,aFactor : float=1.0,aUnits : float=0.0) -> None: 
        """
        Sets up polygon offsets for this object.
        """
    def SetPosition(self,theX : int,theY : int) -> None: 
        """
        Sets the position of color scale.
        """
    def SetPropagateVisualState(self,theFlag : bool) -> None: 
        """
        Change the value of the flag "propagate visual state"
        """
    def SetRange(self,theMin : float,theMax : float) -> None: 
        """
        Sets the minimal and maximal value of color scale. Note that values order will be ignored - the minimum and maximum values will be swapped if needed. ::SetReversed() should be called to swap displaying order.
        """
    def SetReversed(self,theReverse : bool) -> None: 
        """
        Sets true if the labels and colors used in reversed order.
        """
    def SetSize(self,theBreadth : int,theHeight : int) -> None: 
        """
        Sets the size of color bar.
        """
    def SetSmoothTransition(self,theIsSmooth : bool) -> None: 
        """
        Setup smooth color transition.
        """
    def SetTextHeight(self,theHeight : int) -> None: 
        """
        Sets the height of text of color scale.
        """
    def SetTitle(self,theTitle : OCP.TCollection.TCollection_ExtendedString) -> None: 
        """
        Sets the color scale title string.
        """
    def SetTitlePosition(self,thePos : OCP.Aspect.Aspect_TypeOfColorScalePosition) -> None: 
        """
        Sets the color scale title position.
        """
    @overload
    def SetToUpdate(self) -> None: 
        """
        Flags presentation to be updated; UpdatePresentations() will recompute these presentations.

        flags all the Presentations to be Updated.
        """
    @overload
    def SetToUpdate(self,theMode : int) -> None: ...
    def SetTransformPersistence(self,theTrsfPers : OCP.Graphic3d.Graphic3d_TransformPers) -> None: 
        """
        Sets up Transform Persistence defining a special Local Coordinate system where this object should be located. Note that management of Transform Persistence object is more expensive than of the normal one, because it requires its position being recomputed basing on camera position within each draw call / traverse.
        """
    def SetTransparency(self,aValue : float=0.6) -> None: 
        """
        Attributes a setting aValue for transparency. The transparency value should be between 0.0 and 1.0. At 0.0 an object will be totally opaque, and at 1.0, fully transparent. Warning At a value of 1.0, there may be nothing visible.
        """
    def SetTypeOfPresentation(self,theType : OCP.PrsMgr.PrsMgr_TypeOfPresentation3d) -> None: 
        """
        Set type of presentation.
        """
    def SetUniformColors(self,theLightness : float,theHueFrom : float,theHueTo : float) -> None: 
        """
        Populates colors scale by colors of the same lightness value in CIE Lch color space, distributed by hue, with perceptually uniform differences between consequent colors. See MakeUniformColors() for description of parameters.
        """
    def SetWidth(self,theWidth : float) -> None: 
        """
        Allows you to provide the setting aValue for width. Only the Interactive Object knows which Drawer attribute is affected by the width setting.
        """
    def SetXPosition(self,theX : int) -> None: 
        """
        Sets the left position of color scale.
        """
    def SetYPosition(self,theY : int) -> None: 
        """
        Sets the bottom position of color scale.
        """
    def SetZLayer(self,theLayerId : int) -> None: 
        """
        Set Z layer ID and update all presentations of the selectable object. The layers mechanism allows drawing objects in higher layers in overlay of objects in lower layers.
        """
    def Signature(self) -> int: 
        """
        Specifies additional characteristics of Interactive Object of Type(); -1 by default. Among the datums, this signature is attributed to the shape. The remaining datums have the following default signatures: - Point signature 1 - Axis signature 2 - Trihedron signature 3 - PlaneTrihedron signature 4 - Line signature 5 - Circle signature 6 - Plane signature 7.
        """
    def SynchronizeAspects(self) -> None: 
        """
        Synchronize presentation aspects after their modification.
        """
    def TextHeight(self,theText : OCP.TCollection.TCollection_ExtendedString) -> int: 
        """
        Returns the height of text.
        """
    def TextSize(self,theText : OCP.TCollection.TCollection_ExtendedString,theHeight : int) -> tuple[int, int, int]: 
        """
        None
        """
    def TextWidth(self,theText : OCP.TCollection.TCollection_ExtendedString) -> int: 
        """
        Returns the width of text.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    @overload
    def ToBeUpdated(self,ListOfMode : OCP.TColStd.TColStd_ListOfInteger) -> None: 
        """
        Returns TRUE if any active presentation has invalidation flag.

        gives the list of modes which are flagged "to be updated".
        """
    @overload
    def ToBeUpdated(self,theToIncludeHidden : bool=False) -> bool: ...
    def ToPropagateVisualState(self) -> bool: 
        """
        Get value of the flag "propagate visual state" It means that the display/erase/color visual state is propagated automatically to all children; by default, the flag is true
        """
    def TransformPersistence(self) -> OCP.Graphic3d.Graphic3d_TransformPers: 
        """
        Returns Transformation Persistence defining a special Local Coordinate system where this presentable object is located or NULL handle if not defined. Position of the object having Transformation Persistence is mutable and depends on camera position. The same applies to a bounding box of the object.
        """
    def Transformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def TransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def Transparency(self) -> float: 
        """
        Returns the transparency setting. This will be between 0.0 and 1.0. At 0.0 an object will be totally opaque, and at 1.0, fully transparent.
        """
    def Type(self) -> AIS_KindOfInteractive: 
        """
        Returns the kind of Interactive Object; AIS_KindOfInteractive_None by default.
        """
    def TypeOfPresentation3d(self) -> OCP.PrsMgr.PrsMgr_TypeOfPresentation3d: 
        """
        Returns information on whether the object accepts display in HLR mode or not.
        """
    def UnsetAttributes(self) -> None: 
        """
        Clears settings provided by the drawing tool aDrawer.
        """
    def UnsetColor(self) -> None: 
        """
        Removes color settings. Only the Interactive Object knows which Drawer attribute is affected by the color setting. For a wire, for example, wire aspect is the attribute affected. For a vertex, however, only point aspect is affected by the color setting.
        """
    def UnsetDisplayMode(self) -> None: 
        """
        Removes display mode settings from the interactive object.
        """
    def UnsetHilightAttributes(self) -> None: 
        """
        Clears settings provided by the hilight drawing tool theDrawer.
        """
    def UnsetHilightMode(self) -> None: 
        """
        Unsets highlight display mode.
        """
    def UnsetMaterial(self) -> None: 
        """
        Removes the setting for material.
        """
    def UnsetTransparency(self) -> None: 
        """
        Removes the transparency setting. The object is opaque by default.
        """
    def UnsetWidth(self) -> None: 
        """
        Reset width to default value.
        """
    def UpdateSelection(self,theMode : int=-1) -> None: 
        """
        Sets update status FULL to selections of the object. Must be used as the only method of UpdateSelection from outer classes to prevent BVH structures from being outdated.
        """
    def UpdateTransformation(self) -> None: 
        """
        Recomputes the location of the selection aSelection.
        """
    def UpdateTransformations(self,aSelection : OCP.SelectMgr.SelectMgr_Selection) -> None: 
        """
        Updates locations in all sensitive entities from <aSelection> and in corresponding entity owners.
        """
    def ViewAffinity(self) -> OCP.Graphic3d.Graphic3d_ViewAffinity: 
        """
        Return view affinity mask.
        """
    def Width(self) -> float: 
        """
        Returns the width setting of the Interactive Object.
        """
    def ZLayer(self) -> int: 
        """
        Get ID of Z layer for main presentation.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    @staticmethod
    def hueToValidRange_s(theHue : float) -> float: 
        """
        Shift hue into valid range. Lightness and Saturation should be specified in valid range [0.0, 1.0], however Hue might be given out of Quantity_Color range to specify desired range for interpolation.
        """
    pass
class AIS_ColoredDrawer(OCP.Prs3d.Prs3d_Drawer, OCP.Graphic3d.Graphic3d_PresentationAttributes, OCP.Standard.Standard_Transient):
    """
    Customizable properties.Customizable properties.
    """
    def ArrowAspect(self) -> OCP.Prs3d.Prs3d_ArrowAspect: 
        """
        Returns own attributes for display of arrows, settings from linked Drawer or NULL if neither was set.
        """
    def BasicFillAreaAspect(self) -> OCP.Graphic3d.Graphic3d_AspectFillArea3d: 
        """
        Return basic presentation fill area aspect, NULL by default. When set, might be used instead of Color() property.
        """
    def ClearLocalAttributes(self) -> None: 
        """
        Removes local attributes.
        """
    def Color(self) -> OCP.Quantity.Quantity_Color: 
        """
        Returns basic presentation color, Quantity_NOC_WHITE by default.
        """
    def ColorRGBA(self) -> OCP.Quantity.Quantity_ColorRGBA: 
        """
        Returns basic presentation color (including alpha channel).
        """
    def DatumAspect(self) -> OCP.Prs3d.Prs3d_DatumAspect: 
        """
        Returns own settings for the appearance of datums, settings from linked Drawer or NULL if neither was set.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DeviationAngle(self) -> float: 
        """
        Returns the value for deviation angle in radians, 20 * M_PI / 180 by default.
        """
    def DeviationCoefficient(self) -> float: 
        """
        Returns the deviation coefficient. Drawings of curves or patches are made with respect to a maximal chordal deviation. A Deviation coefficient is used in the shading display mode. The shape is seen decomposed into triangles. These are used to calculate reflection of light from the surface of the object. The triangles are formed from chords of the curves in the shape. The deviation coefficient gives the highest value of the angle with which a chord can deviate from a tangent to a curve. If this limit is reached, a new triangle is begun. This deviation is absolute and is set through the method: SetMaximalChordialDeviation. The default value is 0.001. In drawing shapes, however, you are allowed to ask for a relative deviation. This deviation will be: SizeOfObject * DeviationCoefficient.
        """
    def DimAngleDisplayUnits(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Returns angle units in which dimension presentation is displayed.
        """
    def DimAngleModelUnits(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Returns angle model units for the dimension presentation.
        """
    def DimLengthDisplayUnits(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Returns length units in which dimension presentation is displayed.
        """
    def DimLengthModelUnits(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Returns length model units for the dimension presentation.
        """
    def DimensionAspect(self) -> OCP.Prs3d.Prs3d_DimensionAspect: 
        """
        Returns own settings for the appearance of dimensions, settings from linked Drawer or NULL if neither was set.
        """
    def DisableDrawHiddenLine(self) -> None: 
        """
        Disables the DrawHiddenLine function.
        """
    def Discretisation(self) -> int: 
        """
        Returns the discretisation setting.
        """
    def DisplayMode(self) -> int: 
        """
        Returns display mode, 0 by default. -1 means undefined (main display mode of presentation to be used).
        """
    def DrawHiddenLine(self) -> bool: 
        """
        Returns Standard_True if the hidden lines are to be drawn. By default the hidden lines are not drawn.
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def EnableDrawHiddenLine(self) -> None: 
        """
        Enables the DrawHiddenLine function.
        """
    def FaceBoundaryAspect(self) -> OCP.Prs3d.Prs3d_LineAspect: 
        """
        Returns own line aspect of face boundaries, settings from linked Drawer or NULL if neither was set.
        """
    def FaceBoundaryDraw(self) -> bool: 
        """
        Checks whether the face boundary drawing is enabled or not.
        """
    def FaceBoundaryUpperContinuity(self) -> OCP.GeomAbs.GeomAbs_Shape: 
        """
        Get the most edge continuity class; GeomAbs_CN by default (all edges).
        """
    def FreeBoundaryAspect(self) -> OCP.Prs3d.Prs3d_LineAspect: 
        """
        Returns own settings for presentation of free boundaries, settings from linked Drawer or NULL if neither was set. In other words, this settings affect boundaries which are not shared. These attributes are used by the algorithm Prs3d_WFShape
        """
    def FreeBoundaryDraw(self) -> bool: 
        """
        Returns True if the drawing of the free boundaries is enabled True is the default setting.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HLRAngle(self) -> float: 
        """
        None
        """
    def HasLink(self) -> bool: 
        """
        Returns true if the current object has a link on the other drawer.
        """
    def HasOwnArrowAspect(self) -> bool: 
        """
        Returns true if the drawer has its own attribute for arrow aspect that overrides the one in the link.
        """
    def HasOwnColor(self) -> bool: 
        """
        None
        """
    def HasOwnDatumAspect(self) -> bool: 
        """
        Returns true if the drawer has its own attribute for datum aspect that overrides the one in the link.
        """
    def HasOwnDeviationAngle(self) -> bool: 
        """
        Returns true if there is a local setting for deviation angle in this framework for a specific interactive object.
        """
    def HasOwnDeviationCoefficient(self) -> bool: 
        """
        Returns true if there is a local setting for deviation coefficient in this framework for a specific interactive object.
        """
    def HasOwnDimAngleDisplayUnits(self) -> bool: 
        """
        Returns true if the drawer has its own attribute for angle units in which dimension presentation is displayed that overrides the one in the link.
        """
    def HasOwnDimAngleModelUnits(self) -> bool: 
        """
        Returns true if the drawer has its own attribute for dimension angle model units that overrides the one in the link.
        """
    def HasOwnDimLengthDisplayUnits(self) -> bool: 
        """
        Returns true if the drawer has its own attribute for length units in which dimension presentation is displayed that overrides the one in the link.
        """
    def HasOwnDimLengthModelUnits(self) -> bool: 
        """
        Returns true if the drawer has its own attribute for dimension length model units that overrides the one in the link.
        """
    def HasOwnDimensionAspect(self) -> bool: 
        """
        Returns true if the drawer has its own attribute for the appearance of dimensions that overrides the one in the link.
        """
    def HasOwnDiscretisation(self) -> bool: 
        """
        Returns true if the drawer has discretisation setting active.
        """
    def HasOwnDrawHiddenLine(self) -> bool: 
        """
        Returns true if the drawer has its own attribute for "draw hidden lines" flag that overrides the one in the link.
        """
    def HasOwnFaceBoundaryAspect(self) -> bool: 
        """
        Returns true if the drawer has its own attribute for face boundaries aspect that overrides the one in the link.
        """
    def HasOwnFaceBoundaryDraw(self) -> bool: 
        """
        Returns true if the drawer has its own attribute for "draw face boundaries" flag that overrides the one in the link.
        """
    def HasOwnFaceBoundaryUpperContinuity(self) -> bool: 
        """
        Returns true if the drawer has its own attribute for face boundaries upper edge continuity class that overrides the one in the link.
        """
    def HasOwnFreeBoundaryAspect(self) -> bool: 
        """
        Returns true if the drawer has its own attribute for free boundaries aspect that overrides the one in the link.
        """
    def HasOwnFreeBoundaryDraw(self) -> bool: 
        """
        Returns true if the drawer has its own attribute for "draw free boundaries" flag that overrides the one in the link.
        """
    def HasOwnHLRDeviationAngle(self) -> bool: 
        """
        None
        """
    def HasOwnHiddenLineAspect(self) -> bool: 
        """
        Returns true if the drawer has its own attribute for hidden lines aspect that overrides the one in the link.
        """
    def HasOwnIsAutoTriangulation(self) -> bool: 
        """
        Returns true if the drawer has IsoOnPlane setting active.
        """
    def HasOwnIsoOnPlane(self) -> bool: 
        """
        Returns true if the drawer has IsoOnPlane setting active.
        """
    def HasOwnIsoOnTriangulation(self) -> bool: 
        """
        Returns true if the drawer has IsoOnTriangulation setting active.
        """
    def HasOwnLineArrowDraw(self) -> bool: 
        """
        Returns true if the drawer has its own attribute for "draw arrow" flag that overrides the one in the link.
        """
    def HasOwnLineAspect(self) -> bool: 
        """
        Returns true if the drawer has its own attribute for line aspect that overrides the one in the link.
        """
    def HasOwnMaterial(self) -> bool: 
        """
        None
        """
    def HasOwnMaximalChordialDeviation(self) -> bool: 
        """
        Returns true if the drawer has a maximal chordial deviation setting active.
        """
    def HasOwnMaximalParameterValue(self) -> bool: 
        """
        Returns true if the drawer has a maximum value allowed for the first and last parameters of an infinite curve setting active.
        """
    def HasOwnPlaneAspect(self) -> bool: 
        """
        Returns true if the drawer has its own attribute for plane aspect that overrides the one in the link.
        """
    def HasOwnPointAspect(self) -> bool: 
        """
        Returns true if the drawer has its own attribute for point aspect that overrides the one in the link.
        """
    def HasOwnSectionAspect(self) -> bool: 
        """
        Returns true if the drawer has its own attribute for section aspect that overrides the one in the link.
        """
    def HasOwnSeenLineAspect(self) -> bool: 
        """
        Returns true if the drawer has its own attribute for seen line aspect that overrides the one in the link.
        """
    def HasOwnShadingAspect(self) -> bool: 
        """
        Returns true if the drawer has its own attribute for shading aspect that overrides the one in the link.
        """
    def HasOwnTextAspect(self) -> bool: 
        """
        Returns true if the drawer has its own attribute for text aspect that overrides the one in the link.
        """
    def HasOwnTransparency(self) -> bool: 
        """
        None
        """
    def HasOwnTypeOfDeflection(self) -> bool: 
        """
        Returns true if the drawer has a type of deflection setting active.
        """
    def HasOwnTypeOfHLR(self) -> bool: 
        """
        Returns true if the type of HLR is not equal to Prs3d_TOH_NotSet.
        """
    def HasOwnUIsoAspect(self) -> bool: 
        """
        Returns true if the drawer has its own attribute for UIso aspect that overrides the one in the link.
        """
    def HasOwnUnFreeBoundaryAspect(self) -> bool: 
        """
        Returns true if the drawer has its own attribute for unfree boundaries aspect that overrides the one in the link.
        """
    def HasOwnUnFreeBoundaryDraw(self) -> bool: 
        """
        Returns true if the drawer has its own attribute for "draw shared boundaries" flag that overrides the one in the link.
        """
    def HasOwnVIsoAspect(self) -> bool: 
        """
        Returns true if the drawer has its own attribute for VIso aspect that overrides the one in the link.
        """
    def HasOwnVectorAspect(self) -> bool: 
        """
        Returns true if the drawer has its own attribute for vector aspect that overrides the one in the link.
        """
    def HasOwnVertexDrawMode(self) -> bool: 
        """
        Returns true if the vertex draw mode is not equal to Prs3d_VDM_Inherited. This means that individual vertex draw mode value (i.e. not inherited from the global drawer) is used for a specific interactive object.
        """
    def HasOwnWidth(self) -> bool: 
        """
        None
        """
    def HasOwnWireAspect(self) -> bool: 
        """
        Returns true if the drawer has its own attribute for wire aspect that overrides the one in the link.
        """
    def HasOwnWireDraw(self) -> bool: 
        """
        Returns true if the drawer has its own attribute for "draw wires" flag that overrides the one in the link.
        """
    def HiddenLineAspect(self) -> OCP.Prs3d.Prs3d_LineAspect: 
        """
        Returns own settings for hidden line aspects, settings from linked Drawer or NULL if neither was set.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def IsAutoTriangulation(self) -> bool: 
        """
        Returns True if automatic triangulation is enabled.
        """
    def IsHidden(self) -> bool: 
        """
        None
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def IsoOnPlane(self) -> bool: 
        """
        Returns True if the drawing of isos on planes is enabled.
        """
    def IsoOnTriangulation(self) -> bool: 
        """
        Returns True if the drawing of isos on triangulation is enabled.
        """
    def LineArrowDraw(self) -> bool: 
        """
        Returns True if drawing an arrow at the end of each edge is enabled and False otherwise (the default).
        """
    def LineAspect(self) -> OCP.Prs3d.Prs3d_LineAspect: 
        """
        Returns own settings for line aspects, settings from linked Drawer or NULL if neither was set. These attributes are used by the following algorithms: Prs3d_Curve Prs3d_Line Prs3d_HLRShape
        """
    @overload
    def Link(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Sets theDrawer as a link to which the current object references.

        Returns the drawer to which the current object references.
        """
    @overload
    def Link(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: ...
    def MaximalChordialDeviation(self) -> float: 
        """
        Returns the maximal chordal deviation. The default value is 0.0001. Drawings of curves or patches are made with respect to an absolute maximal chordal deviation.
        """
    def MaximalParameterValue(self) -> float: 
        """
        Sets the maximum value allowed for the first and last parameters of an infinite curve. By default, this value is 500000.
        """
    def Method(self) -> OCP.Aspect.Aspect_TypeOfHighlightMethod: 
        """
        Returns highlight method, Aspect_TOHM_COLOR by default.
        """
    def PlaneAspect(self) -> OCP.Prs3d.Prs3d_PlaneAspect: 
        """
        Returns own settings for the appearance of planes, settings from linked Drawer or NULL if neither was set.
        """
    def PointAspect(self) -> OCP.Prs3d.Prs3d_PointAspect: 
        """
        Returns own point aspect setting, settings from linked Drawer or NULL if neither was set. These attributes are used by the algorithms Prs3d_Point.
        """
    def PreviousDeviationAngle(self) -> float: 
        """
        Returns the previous deviation angle
        """
    def PreviousDeviationCoefficient(self) -> float: 
        """
        Saves the previous value used for the chordal deviation coefficient.
        """
    def PreviousHLRDeviationAngle(self) -> float: 
        """
        None
        """
    def SectionAspect(self) -> OCP.Prs3d.Prs3d_LineAspect: 
        """
        Returns own LineAspect for section wire, settings from linked Drawer or NULL if neither was set. These attributes are used by the algorithm Prs3d_WFShape.
        """
    def SeenLineAspect(self) -> OCP.Prs3d.Prs3d_LineAspect: 
        """
        Returns own settings for seen line aspects, settings of linked Drawer or NULL if neither was set.
        """
    def SetArrowAspect(self,theAspect : OCP.Prs3d.Prs3d_ArrowAspect) -> None: 
        """
        Sets the parameter theAspect for display attributes of arrows.
        """
    def SetAutoTriangulation(self,theIsEnabled : bool) -> None: 
        """
        Sets IsAutoTriangulated on or off by setting the parameter theIsEnabled to true or false. If this flag is True automatic re-triangulation with deflection-check logic will be applied. Else this feature will be disable and triangulation is expected to be computed by application itself and no shading presentation at all if unavailable.
        """
    def SetBasicFillAreaAspect(self,theAspect : OCP.Graphic3d.Graphic3d_AspectFillArea3d) -> None: 
        """
        Sets basic presentation fill area aspect.
        """
    def SetColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Sets basic presentation color (RGB components, does not modifies transparency).
        """
    def SetDatumAspect(self,theAspect : OCP.Prs3d.Prs3d_DatumAspect) -> None: 
        """
        Sets the modality theAspect for the display of datums.
        """
    @overload
    def SetDeviationAngle(self,theAngle : float) -> None: 
        """
        Sets the deviation angle theAngle. Also sets the hasOwnDeviationAngle flag to Standard_True, and myPreviousDeviationAngle.

        Resets HasOwnDeviationAngle() flag, e.g. undoes previous SetDeviationAngle().
        """
    @overload
    def SetDeviationAngle(self) -> None: ...
    @overload
    def SetDeviationCoefficient(self) -> None: 
        """
        Sets the deviation coefficient theCoefficient. Also sets the hasOwnDeviationCoefficient flag to Standard_True and myPreviousDeviationCoefficient

        Resets HasOwnDeviationCoefficient() flag, e.g. undoes previous SetDeviationCoefficient().
        """
    @overload
    def SetDeviationCoefficient(self,theCoefficient : float) -> None: ...
    def SetDimAngleDisplayUnits(self,theUnits : OCP.TCollection.TCollection_AsciiString) -> None: 
        """
        Sets angle units in which value for dimension presentation is displayed. The method sets value owned by the drawer that will be used during visualization instead of the one set in link.
        """
    def SetDimAngleModelUnits(self,theUnits : OCP.TCollection.TCollection_AsciiString) -> None: 
        """
        Sets dimension angle model units for computing of dimension presentation. The method sets value owned by the drawer that will be used during visualization instead of the one set in link.
        """
    def SetDimLengthDisplayUnits(self,theUnits : OCP.TCollection.TCollection_AsciiString) -> None: 
        """
        Sets length units in which value for dimension presentation is displayed. The method sets value owned by the drawer that will be used during visualization instead of the one set in link.
        """
    def SetDimLengthModelUnits(self,theUnits : OCP.TCollection.TCollection_AsciiString) -> None: 
        """
        Sets dimension length model units for computing of dimension presentation. The method sets value owned by the drawer that will be used during visualization instead of the one set in link.
        """
    def SetDimensionAspect(self,theAspect : OCP.Prs3d.Prs3d_DimensionAspect) -> None: 
        """
        Sets the settings for the appearance of dimensions. The method sets aspect owned by the drawer that will be used during visualization instead of the one set in link.
        """
    def SetDiscretisation(self,theValue : int) -> None: 
        """
        Sets the discretisation parameter theValue.
        """
    def SetDisplayMode(self,theMode : int) -> None: 
        """
        Sets display mode.
        """
    def SetFaceBoundaryAspect(self,theAspect : OCP.Prs3d.Prs3d_LineAspect) -> None: 
        """
        Sets line aspect for face boundaries. The method sets line aspect owned by the drawer that will be used during visualization instead of the one set in link. theAspect is the line aspect that determines the look of the face boundaries.
        """
    def SetFaceBoundaryDraw(self,theIsEnabled : bool) -> None: 
        """
        Enables or disables face boundary drawing for shading presentations. The method sets drawing flag owned by the drawer that will be used during visualization instead of the one set in link. theIsEnabled is a boolean flag indicating whether the face boundaries should be drawn or not.
        """
    def SetFaceBoundaryUpperContinuity(self,theMostAllowedEdgeClass : OCP.GeomAbs.GeomAbs_Shape) -> None: 
        """
        Set the most edge continuity class for face boundaries.
        """
    def SetFreeBoundaryAspect(self,theAspect : OCP.Prs3d.Prs3d_LineAspect) -> None: 
        """
        Sets the parameter theAspect for the display of free boundaries. The method sets aspect owned by the drawer that will be used during visualization instead of the one set in link.
        """
    def SetFreeBoundaryDraw(self,theIsEnabled : bool) -> None: 
        """
        Enables or disables drawing of free boundaries for shading presentations. The method sets drawing flag owned by the drawer that will be used during visualization instead of the one set in link. theIsEnabled is a boolean flag indicating whether the free boundaries should be drawn or not.
        """
    @overload
    def SetHLRAngle(self,theAngle : float) -> None: 
        """
        None
        """
    @overload
    def SetHLRAngle(self) -> None: ...
    def SetHidden(self,theToHide : bool) -> None: 
        """
        None
        """
    def SetHiddenLineAspect(self,theAspect : OCP.Prs3d.Prs3d_LineAspect) -> None: 
        """
        Sets the parameter theAspect for the display of hidden lines in hidden line removal mode.
        """
    def SetIsoOnPlane(self,theIsEnabled : bool) -> None: 
        """
        Sets IsoOnPlane on or off by setting the parameter theIsEnabled to true or false.
        """
    def SetIsoOnTriangulation(self,theToEnable : bool) -> None: 
        """
        Enables or disables isolines on triangulation by setting the parameter theIsEnabled to true or false.
        """
    def SetLineArrowDraw(self,theIsEnabled : bool) -> None: 
        """
        Enables the drawing of an arrow at the end of each line. By default the arrows are not drawn.
        """
    def SetLineAspect(self,theAspect : OCP.Prs3d.Prs3d_LineAspect) -> None: 
        """
        Sets the parameter theAspect for display attributes of lines.
        """
    def SetLink(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Sets theDrawer as a link to which the current object references.
        """
    def SetMaximalChordialDeviation(self,theChordialDeviation : float) -> None: 
        """
        Defines the maximal chordial deviation when drawing any curve. Even if the type of deviation is set to TOD_Relative, this value is used by: Prs3d_DeflectionCurve Prs3d_WFDeflectionSurface Prs3d_WFDeflectionRestrictedFace
        """
    def SetMaximalParameterValue(self,theValue : float) -> None: 
        """
        Defines the maximum value allowed for the first and last parameters of an infinite curve.
        """
    def SetMethod(self,theMethod : OCP.Aspect.Aspect_TypeOfHighlightMethod) -> None: 
        """
        Changes highlight method to the given one.
        """
    def SetOwnColor(self,arg1 : OCP.Quantity.Quantity_Color) -> None: 
        """
        None
        """
    def SetOwnDatumAspects(self,theDefaults : OCP.Prs3d.Prs3d_Drawer=None) -> bool: 
        """
        Sets own line aspects for datums. Returns FALSE if own line for datums are already set.
        """
    def SetOwnLineAspects(self,theDefaults : OCP.Prs3d.Prs3d_Drawer=None) -> bool: 
        """
        Sets own line aspects, which are single U and single V gray75 solid isolines (::UIsoAspect(), ::VIsoAspect()), red wire (::WireAspect()), yellow line (::LineAspect()), yellow seen line (::SeenLineAspect()), dashed yellow hidden line (::HiddenLineAspect()), green free boundary (::FreeBoundaryAspect()), yellow unfree boundary (::UnFreeBoundaryAspect()). Returns FALSE if own line aspect are already set.
        """
    def SetOwnMaterial(self) -> None: 
        """
        None
        """
    def SetOwnTransparency(self,arg1 : float) -> None: 
        """
        None
        """
    def SetOwnWidth(self,arg1 : float) -> None: 
        """
        None
        """
    def SetPlaneAspect(self,theAspect : OCP.Prs3d.Prs3d_PlaneAspect) -> None: 
        """
        Sets the parameter theAspect for the display of planes.
        """
    def SetPointAspect(self,theAspect : OCP.Prs3d.Prs3d_PointAspect) -> None: 
        """
        Sets the parameter theAspect for display attributes of points
        """
    def SetSectionAspect(self,theAspect : OCP.Prs3d.Prs3d_LineAspect) -> None: 
        """
        Sets the parameter theAspect for display attributes of sections.
        """
    def SetSeenLineAspect(self,theAspect : OCP.Prs3d.Prs3d_LineAspect) -> None: 
        """
        Sets the parameter theAspect for the display of seen lines in hidden line removal mode.
        """
    def SetShaderProgram(self,theProgram : OCP.Graphic3d.Graphic3d_ShaderProgram,theAspect : OCP.Graphic3d.Graphic3d_GroupAspect,theToOverrideDefaults : bool=False) -> bool: 
        """
        Assign shader program for specified type of primitives.
        """
    def SetShadingAspect(self,theAspect : OCP.Prs3d.Prs3d_ShadingAspect) -> None: 
        """
        Sets the parameter theAspect for display attributes of shading.
        """
    def SetShadingModel(self,theModel : OCP.Graphic3d.Graphic3d_TypeOfShadingModel,theToOverrideDefaults : bool=False) -> bool: 
        """
        Sets Shading Model type for the shading aspect.
        """
    def SetTextAspect(self,theAspect : OCP.Prs3d.Prs3d_TextAspect) -> None: 
        """
        Sets the parameter theAspect for display attributes of text.
        """
    def SetTransparency(self,theTranspCoef : float) -> None: 
        """
        Sets basic presentation transparency (0 - opaque, 1 - fully transparent).
        """
    def SetTypeOfDeflection(self,theTypeOfDeflection : OCP.Aspect.Aspect_TypeOfDeflection) -> None: 
        """
        Sets the type of chordal deflection. This indicates whether the deflection value is absolute or relative to the size of the object.
        """
    def SetTypeOfHLR(self,theTypeOfHLR : OCP.Prs3d.Prs3d_TypeOfHLR) -> None: 
        """
        Sets the type of HLR algorithm used by drawer's interactive objects
        """
    def SetUIsoAspect(self,theAspect : OCP.Prs3d.Prs3d_IsoAspect) -> None: 
        """
        None
        """
    def SetUnFreeBoundaryAspect(self,theAspect : OCP.Prs3d.Prs3d_LineAspect) -> None: 
        """
        Sets the parameter theAspect for the display of shared boundaries. The method sets aspect owned by the drawer that will be used during visualization instead of the one set in link.
        """
    def SetUnFreeBoundaryDraw(self,theIsEnabled : bool) -> None: 
        """
        Enables or disables drawing of shared boundaries for shading presentations. The method sets drawing flag owned by the drawer that will be used during visualization instead of the one set in link. theIsEnabled is a boolean flag indicating whether the shared boundaries should be drawn or not.
        """
    def SetVIsoAspect(self,theAspect : OCP.Prs3d.Prs3d_IsoAspect) -> None: 
        """
        Sets the appearance of V isoparameters - theAspect.
        """
    def SetVectorAspect(self,theAspect : OCP.Prs3d.Prs3d_LineAspect) -> None: 
        """
        Sets the modality theAspect for the display of vectors.
        """
    def SetVertexDrawMode(self,theMode : OCP.Prs3d.Prs3d_VertexDrawMode) -> None: 
        """
        Sets the mode of visualization of vertices of a TopoDS_Shape instance. By default, only stand-alone vertices (not belonging topologically to an edge) are drawn, that corresponds to Prs3d_VDM_Standalone mode. Switching to Prs3d_VDM_Standalone mode makes all shape's vertices visible. To inherit this parameter from the global drawer instance ("the link") when it is present, Prs3d_VDM_Inherited value should be used.
        """
    def SetWireAspect(self,theAspect : OCP.Prs3d.Prs3d_LineAspect) -> None: 
        """
        Sets the parameter theAspect for display of wires.
        """
    def SetWireDraw(self,theIsEnabled : bool) -> None: 
        """
        Sets WireDraw on or off by setting the parameter theIsEnabled to true or false.
        """
    def SetZLayer(self,theLayer : int) -> None: 
        """
        Sets presentation Zlayer.
        """
    def SetupOwnDefaults(self) -> None: 
        """
        Setup all own aspects with default values.
        """
    def SetupOwnFaceBoundaryAspect(self,theDefaults : OCP.Prs3d.Prs3d_Drawer=None) -> bool: 
        """
        Sets own face boundary aspect, which is a black solid line by default. Returns FALSE if the drawer already has its own attribute for face boundary aspect.
        """
    def SetupOwnPointAspect(self,theDefaults : OCP.Prs3d.Prs3d_Drawer=None) -> bool: 
        """
        Sets own point aspect, which is a yellow Aspect_TOM_PLUS marker by default. Returns FALSE if the drawer already has its own attribute for point aspect.
        """
    def SetupOwnShadingAspect(self,theDefaults : OCP.Prs3d.Prs3d_Drawer=None) -> bool: 
        """
        Sets own shading aspect, which is Graphic3d_NameOfMaterial_Brass material by default. Returns FALSE if the drawer already has its own attribute for shading aspect.
        """
    def ShadingAspect(self) -> OCP.Prs3d.Prs3d_ShadingAspect: 
        """
        Returns own settings for shading aspects, settings from linked Drawer or NULL if neither was set.
        """
    def TextAspect(self) -> OCP.Prs3d.Prs3d_TextAspect: 
        """
        Returns own settings for text aspect, settings from linked Drawer or NULL if neither was set.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Transparency(self) -> float: 
        """
        Returns basic presentation transparency (0 - opaque, 1 - fully transparent), 0 by default (opaque).
        """
    def TypeOfDeflection(self) -> OCP.Aspect.Aspect_TypeOfDeflection: 
        """
        Returns the type of chordal deflection. This indicates whether the deflection value is absolute or relative to the size of the object.
        """
    def TypeOfHLR(self) -> OCP.Prs3d.Prs3d_TypeOfHLR: 
        """
        Returns the type of HLR algorithm currently in use.
        """
    def UIsoAspect(self) -> OCP.Prs3d.Prs3d_IsoAspect: 
        """
        Defines own attributes for drawing an U isoparametric curve of a face, settings from linked Drawer or NULL if neither was set.
        """
    def UnFreeBoundaryAspect(self) -> OCP.Prs3d.Prs3d_LineAspect: 
        """
        Returns own settings for shared boundary line aspects, settings from linked Drawer or NULL if neither was set. These attributes are used by the algorithm Prs3d_WFShape
        """
    def UnFreeBoundaryDraw(self) -> bool: 
        """
        Returns True if the drawing of the shared boundaries is enabled. True is the default setting.
        """
    def UnsetFaceBoundaryUpperContinuity(self) -> None: 
        """
        Unset the most edge continuity class for face boundaries.
        """
    def UnsetOwnColor(self) -> None: 
        """
        None
        """
    def UnsetOwnDimAngleDisplayUnits(self) -> None: 
        """
        Resets HasOwnDimAngleDisplayUnits() flag, e.g. undoes SetDimLengthDisplayUnits().
        """
    def UnsetOwnDimAngleModelUnits(self) -> None: 
        """
        Resets HasOwnDimAngleModelUnits() flag, e.g. undoes SetDimAngleModelUnits().
        """
    def UnsetOwnDimLengthDisplayUnits(self) -> None: 
        """
        Resets HasOwnDimLengthModelUnits() flag, e.g. undoes SetDimLengthDisplayUnits().
        """
    def UnsetOwnDimLengthModelUnits(self) -> None: 
        """
        Resets HasOwnDimLengthModelUnits() flag, e.g. undoes SetDimLengthModelUnits().
        """
    def UnsetOwnDiscretisation(self) -> None: 
        """
        Resets HasOwnDiscretisation() flag, e.g. undoes SetDiscretisation().
        """
    def UnsetOwnDrawHiddenLine(self) -> None: 
        """
        Resets HasOwnDrawHiddenLine() flag, e.g. unsets EnableDrawHiddenLine()/DisableDrawHiddenLine().
        """
    def UnsetOwnFaceBoundaryDraw(self) -> None: 
        """
        Resets HasOwnFaceBoundaryDraw() flag, e.g. undoes SetFaceBoundaryDraw().
        """
    def UnsetOwnFreeBoundaryDraw(self) -> None: 
        """
        Resets HasOwnFreeBoundaryDraw() flag, e.g. undoes SetFreeBoundaryDraw().
        """
    def UnsetOwnIsAutoTriangulation(self) -> None: 
        """
        Resets HasOwnIsAutoTriangulation() flag, e.g. undoes SetAutoTriangulation().
        """
    def UnsetOwnIsoOnPlane(self) -> None: 
        """
        Resets HasOwnIsoOnPlane() flag, e.g. undoes SetIsoOnPlane().
        """
    def UnsetOwnIsoOnTriangulation(self) -> None: 
        """
        Resets HasOwnIsoOnTriangulation() flag, e.g. undoes SetIsoOnTriangulation().
        """
    def UnsetOwnLineArrowDraw(self) -> None: 
        """
        Reset HasOwnLineArrowDraw() flag, e.g. undoes SetLineArrowDraw().
        """
    def UnsetOwnMaterial(self) -> None: 
        """
        None
        """
    def UnsetOwnMaximalChordialDeviation(self) -> None: 
        """
        Resets HasOwnMaximalChordialDeviation() flag, e.g. undoes SetMaximalChordialDeviation().
        """
    def UnsetOwnMaximalParameterValue(self) -> None: 
        """
        Resets HasOwnMaximalParameterValue() flag, e.g. undoes SetMaximalParameterValue().
        """
    def UnsetOwnTransparency(self) -> None: 
        """
        None
        """
    def UnsetOwnTypeOfDeflection(self) -> None: 
        """
        Resets HasOwnTypeOfDeflection() flag, e.g. undoes SetTypeOfDeflection().
        """
    def UnsetOwnUnFreeBoundaryDraw(self) -> None: 
        """
        Resets HasOwnUnFreeBoundaryDraw() flag, e.g. undoes SetUnFreeBoundaryDraw().
        """
    def UnsetOwnWidth(self) -> None: 
        """
        None
        """
    def UnsetOwnWireDraw(self) -> None: 
        """
        Resets HasOwnWireDraw() flag, e.g. undoes SetWireDraw().
        """
    def UpdatePreviousDeviationAngle(self) -> None: 
        """
        Updates the previous deviation angle to the current value
        """
    def UpdatePreviousDeviationCoefficient(self) -> None: 
        """
        Updates the previous value used for the chordal deviation coefficient to the current state.
        """
    def VIsoAspect(self) -> OCP.Prs3d.Prs3d_IsoAspect: 
        """
        Defines own attributes for drawing an V isoparametric curve of a face, settings from linked Drawer or NULL if neither was set.
        """
    def VectorAspect(self) -> OCP.Prs3d.Prs3d_LineAspect: 
        """
        Returns own settings for the appearance of vectors, settings from linked Drawer or NULL if neither was set.
        """
    def VertexDrawMode(self) -> OCP.Prs3d.Prs3d_VertexDrawMode: 
        """
        Returns the current mode of visualization of vertices of a TopoDS_Shape instance.
        """
    def WireAspect(self) -> OCP.Prs3d.Prs3d_LineAspect: 
        """
        Returns own wire aspect settings, settings from linked Drawer or NULL if neither was set. These attributes are used by the algorithm Prs3d_WFShape.
        """
    def WireDraw(self) -> bool: 
        """
        Returns True if the drawing of the wire is enabled.
        """
    def ZLayer(self) -> int: 
        """
        Returns presentation Zlayer, Graphic3d_ZLayerId_Default by default. Graphic3d_ZLayerId_UNKNOWN means undefined (a layer of main presentation to be used).
        """
    def __init__(self,theLink : OCP.Prs3d.Prs3d_Drawer) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class AIS_Shape(AIS_InteractiveObject, OCP.SelectMgr.SelectMgr_SelectableObject, OCP.PrsMgr.PrsMgr_PresentableObject, OCP.Standard.Standard_Transient):
    """
    A framework to manage presentation and selection of shapes. AIS_Shape is the interactive object which is used the most by applications. There are standard functions available which allow you to prepare selection operations on the constituent elements of shapes - vertices, edges, faces etc - in an open local context. The selection modes specific to "Shape" type objects are referred to as Standard Activation Mode. These modes are only taken into account in open local context and only act on Interactive Objects which have redefined the virtual method AcceptShapeDecomposition so that it returns true. Several advanced functions are also available. These include functions to manage deviation angle and deviation coefficient - both HLR and non-HLR - of an inheriting shape class. These services allow you to select one type of shape interactive object for higher precision drawing. When you do this, the Prs3d_Drawer::IsOwn... functions corresponding to the above deviation angle and coefficient functions return true indicating that there is a local setting available for the specific object.A framework to manage presentation and selection of shapes. AIS_Shape is the interactive object which is used the most by applications. There are standard functions available which allow you to prepare selection operations on the constituent elements of shapes - vertices, edges, faces etc - in an open local context. The selection modes specific to "Shape" type objects are referred to as Standard Activation Mode. These modes are only taken into account in open local context and only act on Interactive Objects which have redefined the virtual method AcceptShapeDecomposition so that it returns true. Several advanced functions are also available. These include functions to manage deviation angle and deviation coefficient - both HLR and non-HLR - of an inheriting shape class. These services allow you to select one type of shape interactive object for higher precision drawing. When you do this, the Prs3d_Drawer::IsOwn... functions corresponding to the above deviation angle and coefficient functions return true indicating that there is a local setting available for the specific object.
    """
    def AcceptDisplayMode(self,theMode : int) -> bool: 
        """
        Return true if specified display mode is supported.
        """
    def AcceptShapeDecomposition(self) -> bool: 
        """
        Returns true if the Interactive Object accepts shape decomposition.
        """
    def AddChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy.
        """
    def AddChildWithCurrentTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy with keeping the current global transformation So the object keeps the same position/orientation in the global CS.
        """
    def AddClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Adds clip plane for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def AddSelection(self,aSelection : OCP.SelectMgr.SelectMgr_Selection,aMode : int) -> None: 
        """
        Adds the selection aSelection with the selection mode index aMode to this framework.
        """
    def Attributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the attributes settings.
        """
    def BndBoxOfSelected(self,theOwners : Any) -> OCP.Bnd.Bnd_Box: 
        """
        Returns a bounding box of sensitive entities with the owners given if they are a part of activated selection
        """
    def BoundingBox(self) -> OCP.Bnd.Bnd_Box: 
        """
        Constructs a bounding box with which to reconstruct compound topological shapes for presentation.
        """
    def Children(self) -> OCP.PrsMgr.PrsMgr_ListOfPresentableObjects: 
        """
        Returns children of the current object.
        """
    def ClearDynamicHighlight(self,theMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> None: 
        """
        Method that needs to be implemented when the object manages selection and dynamic highlighting on its own. Clears or invalidates dynamic highlight presentation. By default it clears immediate draw of given presentation manager.
        """
    def ClearOwner(self) -> None: 
        """
        Each Interactive Object has methods which allow us to attribute an Owner to it in the form of a Transient. This method removes the owner from the graphic entity.
        """
    def ClearSelected(self) -> None: 
        """
        Method which clear all selected owners belonging to this selectable object ( for fast presentation draw )
        """
    def ClearSelections(self,update : bool=False) -> None: 
        """
        Empties all the selections in the SelectableObject <update> parameter defines whether all object's selections should be flagged for further update or not. This improved method can be used to recompute an object's selection (without redisplaying the object completely) when some selection mode is activated not for the first time.
        """
    def ClipPlanes(self) -> OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane: 
        """
        Get clip planes.
        """
    def Color(self,aColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Returns the Color attributes of the shape accordingly to the current facing model;
        """
    def CombinedParentTransformation(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return combined parent transformation.
        """
    def ComputeSelection(self,theSelection : OCP.SelectMgr.SelectMgr_Selection,theMode : int) -> None: 
        """
        Computes sensitive primitives for the given selection mode - key interface method of Selectable Object.
        """
    def CurrentFacingModel(self) -> OCP.Aspect.Aspect_TypeOfFacingModel: 
        """
        Returns the current facing model which is in effect.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def DefaultDisplayMode(self) -> int: 
        """
        Returns the default display mode.
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DisplayMode(self) -> int: 
        """
        Returns the display mode setting of the Interactive Object. The range of supported display mode indexes should be specified within object definition and filtered by AccepDisplayMode().
        """
    def DisplayStatus(self) -> OCP.PrsMgr.PrsMgr_DisplayStatus: 
        """
        Return presentation display status; PrsMgr_DisplayStatus_None by default.
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicHilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalDynamic and Prs3d_TypeOfHighlight_Dynamic defined within AIS_InteractiveContext::HighlightStyle().
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def ErasePresentations(self,theToRemove : bool) -> None: 
        """
        Removes presentations returned by GetHilightPresentation() and GetSelectPresentation().
        """
    def GetAssemblyOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns common entity owner if the object is an assembly
        """
    def GetContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def GetHilightPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting detected object.
        """
    def GetOwner(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns the owner of the Interactive Object. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient. There are two types of owners: - Direct owners, decomposition shapes such as edges, wires, and faces. - Users, presentable objects connecting to sensitive primitives, or a shape which has been decomposed.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def GetSelectPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting selected object.
        """
    def GlobalSelOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns the owner of mode for selection of object as a whole
        """
    def GlobalSelectionMode(self) -> int: 
        """
        Returns the mode for selection of object as a whole; 0 by default.
        """
    def HasColor(self) -> bool: 
        """
        Returns true if the Interactive Object has color.
        """
    def HasDisplayMode(self) -> bool: 
        """
        Returns true if the Interactive Object has display mode setting overriding global setting (within Interactive Context).
        """
    def HasHilightMode(self) -> bool: 
        """
        Returns true if the Interactive Object is in highlight mode.
        """
    def HasInteractiveContext(self) -> bool: 
        """
        Indicates whether the Interactive Object has a pointer to an interactive context.
        """
    def HasMaterial(self) -> bool: 
        """
        Returns true if the Interactive Object has a setting for material.
        """
    def HasOwnPresentations(self) -> bool: 
        """
        Returns true if object should have own presentations.
        """
    def HasOwner(self) -> bool: 
        """
        Returns true if the object has an owner attributed to it. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient.
        """
    def HasPolygonOffsets(self) -> bool: 
        """
        Returns Standard_True if <myDrawer> has non-null shading aspect
        """
    def HasPresentation(self) -> bool: 
        """
        Returns TRUE when this object has a presentation in the current DisplayMode()
        """
    def HasSelection(self,theMode : int) -> bool: 
        """
        Returns true if a selection corresponding to the selection mode theMode was computed for this object.
        """
    def HasTransformation(self) -> bool: 
        """
        Returns true if object has a transformation that is different from the identity.
        """
    def HasWidth(self) -> bool: 
        """
        Returns true if the Interactive Object has width.
        """
    def HilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalSelected and Prs3d_TypeOfHighlight_Selected defined within AIS_InteractiveContext::HighlightStyle().
        """
    def HilightMode(self) -> int: 
        """
        Returns highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def HilightOwnerWithColor(self,thePM : OCP.PrsMgr.PrsMgr_PresentationManager,theStyle : OCP.Prs3d.Prs3d_Drawer,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner) -> None: 
        """
        Method which hilight an owner belonging to this selectable object ( for fast presentation draw )
        """
    def HilightSelected(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager,theSeq : OCP.SelectMgr.SelectMgr_SequenceOfOwner) -> None: 
        """
        Method which draws selected owners ( for fast presentation draw )
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def InteractiveContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def InversedTransformation(self) -> OCP.gp.gp_GTrsf: 
        """
        Return inversed transformation.
        """
    def IsAutoHilight(self) -> bool: 
        """
        If returns True, the old mechanism for highlighting selected objects is used (HilightSelected Method may be empty). If returns False, the HilightSelected method will be fully responsible for highlighting selected entity owners belonging to this selectable object.
        """
    def IsInfinite(self) -> bool: 
        """
        Returns true if the interactive object is infinite; FALSE by default. This flag affects various operations operating on bounding box of graphic presentations of this object. For instance, infinite objects are not taken in account for View FitAll. This does not necessarily means that object is actually infinite, auxiliary objects might be also marked with this flag to achieve desired behavior.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def IsMutable(self) -> bool: 
        """
        Returns true if object has mutable nature (content or location are be changed regularly). Mutable object will be managed in different way than static onces (another optimizations).
        """
    def IsTransparent(self) -> bool: 
        """
        Returns true if there is a transparency setting.
        """
    def LocalTransformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def LocalTransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def Material(self) -> OCP.Graphic3d.Graphic3d_NameOfMaterial: 
        """
        Returns the NameOfMaterial attributes of the shape accordingly to the current facing model;
        """
    def OwnDeviationAngle(self,anAngle : float,aPreviousAngle : float) -> bool: 
        """
        Returns true and the values of the deviation angle anAngle and the previous deviation angle aPreviousAngle. If these values are not already set, false is returned.
        """
    def OwnDeviationCoefficient(self,aCoefficient : float,aPreviousCoefficient : float) -> bool: 
        """
        Returns true and the values of the deviation coefficient aCoefficient and the previous deviation coefficient aPreviousCoefficient. If these values are not already set, false is returned.
        """
    def Parent(self) -> OCP.PrsMgr.PrsMgr_PresentableObject: 
        """
        Returns parent of current object in scene hierarchy.
        """
    def PolygonOffsets(self,aFactor : float,aUnits : float) -> tuple[int]: 
        """
        Retrieves current polygon offsets settings from <myDrawer>.
        """
    def Presentation(self) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Returns the current presentation of this object according to the current DisplayMode()
        """
    def Presentations(self) -> OCP.PrsMgr.PrsMgr_Presentations: 
        """
        Return presentations.
        """
    def ProcessDragging(self,theCtx : AIS_InteractiveContext,theView : OCP.V3d.V3d_View,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theDragFrom : OCP.Graphic3d.Graphic3d_Vec2i,theDragTo : OCP.Graphic3d.Graphic3d_Vec2i,theAction : AIS_DragAction) -> bool: 
        """
        Drag object in the viewer.
        """
    @overload
    def RecomputePrimitives(self) -> None: 
        """
        Re-computes the sensitive primitives for all modes. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.

        Re-computes the sensitive primitives which correspond to the <theMode>th selection mode. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.
        """
    @overload
    def RecomputePrimitives(self,theMode : int) -> None: ...
    def Redisplay(self,AllModes : bool=False) -> None: 
        """
        Updates the active presentation; if <AllModes> = Standard_True all the presentations inside are recomputed. IMPORTANT: It is preferable to call Redisplay method of corresponding AIS_InteractiveContext instance for cases when it is accessible. This method just redirects call to myCTXPtr, so this class field must be up to date for proper result.
        """
    def RemoveChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy.
        """
    def RemoveChildWithRestoreTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy with keeping the current global transformation. So the object keeps the same position/orientation in the global CS.
        """
    def RemoveClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Removes previously added clip plane.
        """
    def ResetTransformation(self) -> None: 
        """
        None
        """
    def Selection(self,theMode : int) -> OCP.SelectMgr.SelectMgr_Selection: 
        """
        Returns the selection having specified selection mode or NULL.
        """
    @staticmethod
    def SelectionMode_s(theShapeType : OCP.TopAbs.TopAbs_ShapeEnum) -> int: 
        """
        Return selection mode for specified shape type.
        """
    @staticmethod
    def SelectionType_s(theSelMode : int) -> OCP.TopAbs.TopAbs_ShapeEnum: 
        """
        Return shape type for specified selection mode.
        """
    def Selections(self) -> OCP.SelectMgr.SelectMgr_SequenceOfSelection: 
        """
        Return the sequence of selections.
        """
    def Set(self,theShape : OCP.TopoDS.TopoDS_Shape) -> None: 
        """
        Alias for ::SetShape().
        """
    def SetAngleAndDeviation(self,anAngle : float) -> None: 
        """
        this compute a new angle and Deviation from the value anAngle and set the values stored in myDrawer with these that become local to the shape
        """
    def SetAspect(self,anAspect : OCP.Prs3d.Prs3d_BasicAspect) -> None: 
        """
        Sets the graphic basic aspect to the current presentation.
        """
    def SetAssemblyOwner(self,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theMode : int=-1) -> None: 
        """
        Sets common entity owner for assembly sensitive object entities
        """
    def SetAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the drawing tool theDrawer.
        """
    def SetAutoHilight(self,theAutoHilight : bool) -> None: 
        """
        Set AutoHilight property to true or false.
        """
    def SetClipPlanes(self,thePlanes : OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane) -> None: 
        """
        Set clip planes for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def SetColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Sets the color aColor in the reconstructed compound shape. Acts via the Drawer methods below on the appearance of: - free boundaries: Prs3d_Drawer_FreeBoundaryAspect, - isos: Prs3d_Drawer_UIsoAspect, Prs3dDrawer_VIsoAspect, - shared boundaries: Prs3d_Drawer_UnFreeBoundaryAspect, - shading: Prs3d_Drawer_ShadingAspect, - visible line color in hidden line mode: Prs3d_Drawer_SeenLineAspect - hidden line color in hidden line mode: Prs3d_Drawer_HiddenLineAspect.
        """
    def SetContext(self,aCtx : AIS_InteractiveContext) -> None: 
        """
        Sets the interactive context aCtx and provides a link to the default drawing tool or "Drawer" if there is none.
        """
    def SetCurrentFacingModel(self,theModel : OCP.Aspect.Aspect_TypeOfFacingModel=Aspect_TypeOfFacingModel.Aspect_TOFM_BOTH_SIDE) -> None: 
        """
        change the current facing model apply on polygons for SetColor(), SetTransparency(), SetMaterial() methods default facing model is Aspect_TOFM_TWO_SIDE. This mean that attributes is applying both on the front and back face.
        """
    def SetDisplayMode(self,theMode : int) -> None: 
        """
        Sets the display mode for the interactive object. An object can have its own temporary display mode, which is different from that proposed by the interactive context.
        """
    def SetDynamicHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the dynamic hilight drawing tool.
        """
    def SetHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the hilight drawing tool theDrawer.
        """
    def SetHilightMode(self,theMode : int) -> None: 
        """
        Sets highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def SetInfiniteState(self,theFlag : bool=True) -> None: 
        """
        Sets if object should be considered as infinite.
        """
    def SetIsoOnTriangulation(self,theIsEnabled : bool) -> None: 
        """
        Enables or disables on-triangulation build of isolines according to the flag given.
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.gp.gp_Trsf) -> None: 
        """
        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.

        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.TopLoc.TopLoc_Datum3D) -> None: ...
    def SetMaterial(self,aName : OCP.Graphic3d.Graphic3d_MaterialAspect) -> None: 
        """
        Allows you to provide settings for the material aName in the reconstructed compound shape.
        """
    def SetMutable(self,theIsMutable : bool) -> None: 
        """
        Sets if the object has mutable nature (content or location will be changed regularly). This method should be called before object displaying to take effect.
        """
    @overload
    def SetOwnDeviationAngle(self,anAngle : float) -> None: 
        """
        Sets a local value for deviation angle for this specific shape.

        sets myOwnDeviationAngle field in Prs3d_Drawer & recomputes presentation
        """
    @overload
    def SetOwnDeviationAngle(self) -> bool: ...
    @overload
    def SetOwnDeviationCoefficient(self,aCoefficient : float) -> None: 
        """
        Sets a local value for deviation coefficient for this specific shape.

        Sets a local value for deviation coefficient for this specific shape.
        """
    @overload
    def SetOwnDeviationCoefficient(self) -> bool: ...
    def SetOwner(self,theApplicativeEntity : OCP.Standard.Standard_Transient) -> None: 
        """
        Allows you to attribute the owner theApplicativeEntity to an Interactive Object. This can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of. The owner takes the form of a transient.
        """
    def SetPolygonOffsets(self,aMode : int,aFactor : float=1.0,aUnits : float=0.0) -> None: 
        """
        Sets up polygon offsets for this object.
        """
    def SetPropagateVisualState(self,theFlag : bool) -> None: 
        """
        Change the value of the flag "propagate visual state"
        """
    def SetShape(self,theShape : OCP.TopoDS.TopoDS_Shape) -> None: 
        """
        Constructs an instance of the shape object theShape.
        """
    def SetTextureOriginUV(self,theOriginUV : OCP.gp.gp_Pnt2d) -> None: 
        """
        Use this method to change the origin of the texture. The texel (0,0) will be mapped to the surface (myUVOrigin.X(), myUVOrigin.Y()).
        """
    def SetTextureRepeatUV(self,theRepeatUV : OCP.gp.gp_Pnt2d) -> None: 
        """
        Sets the number of occurrences of the texture on each face. The texture itself is parameterized in (0,1) by (0,1). Each face of the shape to be textured is parameterized in UV space (Umin,Umax) by (Vmin,Vmax).
        """
    def SetTextureScaleUV(self,theScaleUV : OCP.gp.gp_Pnt2d) -> None: 
        """
        Use this method to scale the texture (percent of the face). You can specify a scale factor for both U and V. Example: if you set ScaleU and ScaleV to 0.5 and you enable texture repeat, the texture will appear twice on the face in each direction.
        """
    @overload
    def SetToUpdate(self) -> None: 
        """
        Flags presentation to be updated; UpdatePresentations() will recompute these presentations.

        flags all the Presentations to be Updated.
        """
    @overload
    def SetToUpdate(self,theMode : int) -> None: ...
    def SetTransformPersistence(self,theTrsfPers : OCP.Graphic3d.Graphic3d_TransformPers) -> None: 
        """
        Sets up Transform Persistence defining a special Local Coordinate system where this object should be located. Note that management of Transform Persistence object is more expensive than of the normal one, because it requires its position being recomputed basing on camera position within each draw call / traverse.
        """
    def SetTransparency(self,aValue : float=0.6) -> None: 
        """
        Sets the value aValue for transparency in the reconstructed compound shape.
        """
    def SetTypeOfHLR(self,theTypeOfHLR : OCP.Prs3d.Prs3d_TypeOfHLR) -> None: 
        """
        Sets the type of HLR algorithm used by the shape
        """
    def SetTypeOfPresentation(self,theType : OCP.PrsMgr.PrsMgr_TypeOfPresentation3d) -> None: 
        """
        Set type of presentation.
        """
    def SetWidth(self,aValue : float) -> None: 
        """
        Sets the value aValue for line width in the reconstructed compound shape. Changes line aspects for lines presentation.
        """
    def SetZLayer(self,theLayerId : int) -> None: 
        """
        Set Z layer ID and update all presentations of the selectable object. The layers mechanism allows drawing objects in higher layers in overlay of objects in lower layers.
        """
    def Shape(self) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Returns this shape object.
        """
    def Signature(self) -> int: 
        """
        Returns index 0. This value refers to SHAPE from TopAbs_ShapeEnum
        """
    def SynchronizeAspects(self) -> None: 
        """
        Synchronize presentation aspects after their modification.
        """
    def TextureOriginUV(self) -> OCP.gp.gp_Pnt2d: 
        """
        Return texture origin UV position; (0, 0) by default.
        """
    def TextureRepeatUV(self) -> OCP.gp.gp_Pnt2d: 
        """
        Return texture repeat UV values; (1, 1) by default.
        """
    def TextureScaleUV(self) -> OCP.gp.gp_Pnt2d: 
        """
        Return scale factor for UV coordinates; (1, 1) by default.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    @overload
    def ToBeUpdated(self,ListOfMode : OCP.TColStd.TColStd_ListOfInteger) -> None: 
        """
        Returns TRUE if any active presentation has invalidation flag.

        gives the list of modes which are flagged "to be updated".
        """
    @overload
    def ToBeUpdated(self,theToIncludeHidden : bool=False) -> bool: ...
    def ToPropagateVisualState(self) -> bool: 
        """
        Get value of the flag "propagate visual state" It means that the display/erase/color visual state is propagated automatically to all children; by default, the flag is true
        """
    def TransformPersistence(self) -> OCP.Graphic3d.Graphic3d_TransformPers: 
        """
        Returns Transformation Persistence defining a special Local Coordinate system where this presentable object is located or NULL handle if not defined. Position of the object having Transformation Persistence is mutable and depends on camera position. The same applies to a bounding box of the object.
        """
    def Transformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def TransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def Transparency(self) -> float: 
        """
        Returns the transparency attributes of the shape accordingly to the current facing model;
        """
    def Type(self) -> AIS_KindOfInteractive: 
        """
        Returns Object as the type of Interactive Object.
        """
    def TypeOfHLR(self) -> OCP.Prs3d.Prs3d_TypeOfHLR: 
        """
        Gets the type of HLR algorithm
        """
    def TypeOfPresentation3d(self) -> OCP.PrsMgr.PrsMgr_TypeOfPresentation3d: 
        """
        Returns information on whether the object accepts display in HLR mode or not.
        """
    def UnsetAttributes(self) -> None: 
        """
        Clears settings provided by the drawing tool aDrawer.
        """
    def UnsetColor(self) -> None: 
        """
        Removes settings for color in the reconstructed compound shape.
        """
    def UnsetDisplayMode(self) -> None: 
        """
        Removes display mode settings from the interactive object.
        """
    def UnsetHilightAttributes(self) -> None: 
        """
        Clears settings provided by the hilight drawing tool theDrawer.
        """
    def UnsetHilightMode(self) -> None: 
        """
        Unsets highlight display mode.
        """
    def UnsetMaterial(self) -> None: 
        """
        Removes settings for material in the reconstructed compound shape.
        """
    def UnsetTransparency(self) -> None: 
        """
        Removes the setting for transparency in the reconstructed compound shape.
        """
    def UnsetWidth(self) -> None: 
        """
        Removes the setting for line width in the reconstructed compound shape.
        """
    def UpdateSelection(self,theMode : int=-1) -> None: 
        """
        Sets update status FULL to selections of the object. Must be used as the only method of UpdateSelection from outer classes to prevent BVH structures from being outdated.
        """
    def UpdateTransformation(self) -> None: 
        """
        Recomputes the location of the selection aSelection.
        """
    def UpdateTransformations(self,aSelection : OCP.SelectMgr.SelectMgr_Selection) -> None: 
        """
        Updates locations in all sensitive entities from <aSelection> and in corresponding entity owners.
        """
    def UserAngle(self) -> float: 
        """
        gives back the angle initial value put by the User.
        """
    def ViewAffinity(self) -> OCP.Graphic3d.Graphic3d_ViewAffinity: 
        """
        Return view affinity mask.
        """
    def Width(self) -> float: 
        """
        Returns the width setting of the Interactive Object.
        """
    def ZLayer(self) -> int: 
        """
        Get ID of Z layer for main presentation.
        """
    def __init__(self,shap : OCP.TopoDS.TopoDS_Shape) -> None: ...
    @staticmethod
    def computeHlrPresentation_s(theProjector : OCP.Graphic3d.Graphic3d_Camera,thePrs : OCP.Graphic3d.Graphic3d_Structure,theShape : OCP.TopoDS.TopoDS_Shape,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Compute HLR presentation for specified shape.
        """
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class AIS_ConnectedInteractive(AIS_InteractiveObject, OCP.SelectMgr.SelectMgr_SelectableObject, OCP.PrsMgr.PrsMgr_PresentableObject, OCP.Standard.Standard_Transient):
    """
    Creates an arbitrary located instance of another Interactive Object, which serves as a reference. This allows you to use the Connected Interactive Object without having to recalculate presentation, selection or graphic structure. These are deduced from your reference object. The relation between the connected interactive object and its source is generally one of geometric transformation. AIS_ConnectedInteractive class supports selection mode 0 for any InteractiveObject and all standard modes if its reference based on AIS_Shape. Descendants may redefine ComputeSelection() though. Also ConnectedInteractive will handle HLR if its reference based on AIS_Shape.Creates an arbitrary located instance of another Interactive Object, which serves as a reference. This allows you to use the Connected Interactive Object without having to recalculate presentation, selection or graphic structure. These are deduced from your reference object. The relation between the connected interactive object and its source is generally one of geometric transformation. AIS_ConnectedInteractive class supports selection mode 0 for any InteractiveObject and all standard modes if its reference based on AIS_Shape. Descendants may redefine ComputeSelection() though. Also ConnectedInteractive will handle HLR if its reference based on AIS_Shape.
    """
    def AcceptDisplayMode(self,theMode : int) -> bool: 
        """
        Return true if reference presentation accepts specified display mode.
        """
    def AcceptShapeDecomposition(self) -> bool: 
        """
        Informs the graphic context that the interactive Object may be decomposed into sub-shapes for dynamic selection.
        """
    def AddChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy.
        """
    def AddChildWithCurrentTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy with keeping the current global transformation So the object keeps the same position/orientation in the global CS.
        """
    def AddClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Adds clip plane for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def AddSelection(self,aSelection : OCP.SelectMgr.SelectMgr_Selection,aMode : int) -> None: 
        """
        Adds the selection aSelection with the selection mode index aMode to this framework.
        """
    def Attributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the attributes settings.
        """
    def BndBoxOfSelected(self,theOwners : Any) -> OCP.Bnd.Bnd_Box: 
        """
        Returns a bounding box of sensitive entities with the owners given if they are a part of activated selection
        """
    def BoundingBox(self,theBndBox : OCP.Bnd.Bnd_Box) -> None: 
        """
        Returns bounding box of object correspondingly to its current display mode. This method requires presentation to be already computed, since it relies on bounding box of presentation structures, which are supposed to be same/close amongst different display modes of this object.
        """
    def Children(self) -> OCP.PrsMgr.PrsMgr_ListOfPresentableObjects: 
        """
        Returns children of the current object.
        """
    def ClearDynamicHighlight(self,theMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> None: 
        """
        Method that needs to be implemented when the object manages selection and dynamic highlighting on its own. Clears or invalidates dynamic highlight presentation. By default it clears immediate draw of given presentation manager.
        """
    def ClearOwner(self) -> None: 
        """
        Each Interactive Object has methods which allow us to attribute an Owner to it in the form of a Transient. This method removes the owner from the graphic entity.
        """
    def ClearSelected(self) -> None: 
        """
        Method which clear all selected owners belonging to this selectable object ( for fast presentation draw )
        """
    def ClearSelections(self,update : bool=False) -> None: 
        """
        Empties all the selections in the SelectableObject <update> parameter defines whether all object's selections should be flagged for further update or not. This improved method can be used to recompute an object's selection (without redisplaying the object completely) when some selection mode is activated not for the first time.
        """
    def ClipPlanes(self) -> OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane: 
        """
        Get clip planes.
        """
    def Color(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Returns the color setting of the Interactive Object.
        """
    def CombinedParentTransformation(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return combined parent transformation.
        """
    def ComputeSelection(self,theSelection : OCP.SelectMgr.SelectMgr_Selection,theMode : int) -> None: 
        """
        Computes sensitive primitives for the given selection mode - key interface method of Selectable Object.
        """
    @overload
    def Connect(self,theAnotherObj : AIS_InteractiveObject,theLocation : OCP.gp.gp_Trsf) -> None: 
        """
        Establishes the connection between the Connected Interactive Object, anotherIobj, and its reference.

        Establishes the connection between the Connected Interactive Object, anotherIobj, and its reference. Locates instance in aLocation.

        Establishes the connection between the Connected Interactive Object, anotherIobj, and its reference. Locates instance in aLocation.
        """
    @overload
    def Connect(self,theAnotherObj : AIS_InteractiveObject,theLocation : OCP.TopLoc.TopLoc_Datum3D) -> None: ...
    @overload
    def Connect(self,theAnotherObj : AIS_InteractiveObject) -> None: ...
    def ConnectedTo(self) -> AIS_InteractiveObject: 
        """
        Returns the connection with the reference Interactive Object.
        """
    def CurrentFacingModel(self) -> OCP.Aspect.Aspect_TypeOfFacingModel: 
        """
        Returns the current facing model which is in effect.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def DefaultDisplayMode(self) -> int: 
        """
        Returns the default display mode.
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def Disconnect(self) -> None: 
        """
        Clears the connection with a source reference. The presentation will no longer be displayed. Warning Must be done before deleting the presentation.
        """
    def DisplayMode(self) -> int: 
        """
        Returns the display mode setting of the Interactive Object. The range of supported display mode indexes should be specified within object definition and filtered by AccepDisplayMode().
        """
    def DisplayStatus(self) -> OCP.PrsMgr.PrsMgr_DisplayStatus: 
        """
        Return presentation display status; PrsMgr_DisplayStatus_None by default.
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicHilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalDynamic and Prs3d_TypeOfHighlight_Dynamic defined within AIS_InteractiveContext::HighlightStyle().
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def ErasePresentations(self,theToRemove : bool) -> None: 
        """
        Removes presentations returned by GetHilightPresentation() and GetSelectPresentation().
        """
    def GetAssemblyOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns common entity owner if the object is an assembly
        """
    def GetContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def GetHilightPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting detected object.
        """
    def GetOwner(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns the owner of the Interactive Object. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient. There are two types of owners: - Direct owners, decomposition shapes such as edges, wires, and faces. - Users, presentable objects connecting to sensitive primitives, or a shape which has been decomposed.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def GetSelectPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting selected object.
        """
    def GlobalSelOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns the owner of mode for selection of object as a whole
        """
    def GlobalSelectionMode(self) -> int: 
        """
        Returns the mode for selection of object as a whole; 0 by default.
        """
    def HasColor(self) -> bool: 
        """
        Returns true if the Interactive Object has color.
        """
    def HasConnection(self) -> bool: 
        """
        Returns true if there is a connection established between the presentation and its source reference.
        """
    def HasDisplayMode(self) -> bool: 
        """
        Returns true if the Interactive Object has display mode setting overriding global setting (within Interactive Context).
        """
    def HasHilightMode(self) -> bool: 
        """
        Returns true if the Interactive Object is in highlight mode.
        """
    def HasInteractiveContext(self) -> bool: 
        """
        Indicates whether the Interactive Object has a pointer to an interactive context.
        """
    def HasMaterial(self) -> bool: 
        """
        Returns true if the Interactive Object has a setting for material.
        """
    def HasOwnPresentations(self) -> bool: 
        """
        Returns true if object should have own presentations.
        """
    def HasOwner(self) -> bool: 
        """
        Returns true if the object has an owner attributed to it. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient.
        """
    def HasPolygonOffsets(self) -> bool: 
        """
        Returns Standard_True if <myDrawer> has non-null shading aspect
        """
    def HasPresentation(self) -> bool: 
        """
        Returns TRUE when this object has a presentation in the current DisplayMode()
        """
    def HasSelection(self,theMode : int) -> bool: 
        """
        Returns true if a selection corresponding to the selection mode theMode was computed for this object.
        """
    def HasTransformation(self) -> bool: 
        """
        Returns true if object has a transformation that is different from the identity.
        """
    def HasWidth(self) -> bool: 
        """
        Returns true if the Interactive Object has width.
        """
    def HilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalSelected and Prs3d_TypeOfHighlight_Selected defined within AIS_InteractiveContext::HighlightStyle().
        """
    def HilightMode(self) -> int: 
        """
        Returns highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def HilightOwnerWithColor(self,thePM : OCP.PrsMgr.PrsMgr_PresentationManager,theStyle : OCP.Prs3d.Prs3d_Drawer,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner) -> None: 
        """
        Method which hilight an owner belonging to this selectable object ( for fast presentation draw )
        """
    def HilightSelected(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager,theSeq : OCP.SelectMgr.SelectMgr_SequenceOfOwner) -> None: 
        """
        Method which draws selected owners ( for fast presentation draw )
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def InteractiveContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def InversedTransformation(self) -> OCP.gp.gp_GTrsf: 
        """
        Return inversed transformation.
        """
    def IsAutoHilight(self) -> bool: 
        """
        If returns True, the old mechanism for highlighting selected objects is used (HilightSelected Method may be empty). If returns False, the HilightSelected method will be fully responsible for highlighting selected entity owners belonging to this selectable object.
        """
    def IsInfinite(self) -> bool: 
        """
        Returns true if the interactive object is infinite; FALSE by default. This flag affects various operations operating on bounding box of graphic presentations of this object. For instance, infinite objects are not taken in account for View FitAll. This does not necessarily means that object is actually infinite, auxiliary objects might be also marked with this flag to achieve desired behavior.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def IsMutable(self) -> bool: 
        """
        Returns true if object has mutable nature (content or location are be changed regularly). Mutable object will be managed in different way than static onces (another optimizations).
        """
    def IsTransparent(self) -> bool: 
        """
        Returns true if there is a transparency setting.
        """
    def LocalTransformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def LocalTransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def Material(self) -> OCP.Graphic3d.Graphic3d_NameOfMaterial: 
        """
        Returns the current material setting as enumeration value.
        """
    def Parent(self) -> OCP.PrsMgr.PrsMgr_PresentableObject: 
        """
        Returns parent of current object in scene hierarchy.
        """
    def PolygonOffsets(self,aFactor : float,aUnits : float) -> tuple[int]: 
        """
        Retrieves current polygon offsets settings from <myDrawer>.
        """
    def Presentation(self) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Returns the current presentation of this object according to the current DisplayMode()
        """
    def Presentations(self) -> OCP.PrsMgr.PrsMgr_Presentations: 
        """
        Return presentations.
        """
    def ProcessDragging(self,theCtx : AIS_InteractiveContext,theView : OCP.V3d.V3d_View,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theDragFrom : OCP.Graphic3d.Graphic3d_Vec2i,theDragTo : OCP.Graphic3d.Graphic3d_Vec2i,theAction : AIS_DragAction) -> bool: 
        """
        Drag object in the viewer.
        """
    @overload
    def RecomputePrimitives(self) -> None: 
        """
        Re-computes the sensitive primitives for all modes. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.

        Re-computes the sensitive primitives which correspond to the <theMode>th selection mode. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.
        """
    @overload
    def RecomputePrimitives(self,theMode : int) -> None: ...
    def Redisplay(self,AllModes : bool=False) -> None: 
        """
        Updates the active presentation; if <AllModes> = Standard_True all the presentations inside are recomputed. IMPORTANT: It is preferable to call Redisplay method of corresponding AIS_InteractiveContext instance for cases when it is accessible. This method just redirects call to myCTXPtr, so this class field must be up to date for proper result.
        """
    def RemoveChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy.
        """
    def RemoveChildWithRestoreTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy with keeping the current global transformation. So the object keeps the same position/orientation in the global CS.
        """
    def RemoveClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Removes previously added clip plane.
        """
    def ResetTransformation(self) -> None: 
        """
        None
        """
    def Selection(self,theMode : int) -> OCP.SelectMgr.SelectMgr_Selection: 
        """
        Returns the selection having specified selection mode or NULL.
        """
    def Selections(self) -> OCP.SelectMgr.SelectMgr_SequenceOfSelection: 
        """
        Return the sequence of selections.
        """
    def SetAspect(self,anAspect : OCP.Prs3d.Prs3d_BasicAspect) -> None: 
        """
        Sets the graphic basic aspect to the current presentation.
        """
    def SetAssemblyOwner(self,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theMode : int=-1) -> None: 
        """
        Sets common entity owner for assembly sensitive object entities
        """
    def SetAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the drawing tool theDrawer.
        """
    def SetAutoHilight(self,theAutoHilight : bool) -> None: 
        """
        Set AutoHilight property to true or false.
        """
    def SetClipPlanes(self,thePlanes : OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane) -> None: 
        """
        Set clip planes for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def SetColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Only the interactive object knowns which Drawer attribute is affected by the color, if any (ex: for a wire,it's the wireaspect field of the drawer, but for a vertex, only the point aspect field is affected by the color). WARNING : Do not forget to set the corresponding fields here (hasOwnColor and myDrawer->SetColor())
        """
    def SetContext(self,aCtx : AIS_InteractiveContext) -> None: 
        """
        Sets the interactive context aCtx and provides a link to the default drawing tool or "Drawer" if there is none.
        """
    def SetCurrentFacingModel(self,theModel : OCP.Aspect.Aspect_TypeOfFacingModel=Aspect_TypeOfFacingModel.Aspect_TOFM_BOTH_SIDE) -> None: 
        """
        change the current facing model apply on polygons for SetColor(), SetTransparency(), SetMaterial() methods default facing model is Aspect_TOFM_TWO_SIDE. This mean that attributes is applying both on the front and back face.
        """
    def SetDisplayMode(self,theMode : int) -> None: 
        """
        Sets the display mode for the interactive object. An object can have its own temporary display mode, which is different from that proposed by the interactive context.
        """
    def SetDynamicHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the dynamic hilight drawing tool.
        """
    def SetHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the hilight drawing tool theDrawer.
        """
    def SetHilightMode(self,theMode : int) -> None: 
        """
        Sets highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def SetInfiniteState(self,theFlag : bool=True) -> None: 
        """
        Sets if object should be considered as infinite.
        """
    def SetIsoOnTriangulation(self,theIsEnabled : bool) -> None: 
        """
        Enables or disables on-triangulation build of isolines according to the flag given.
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.gp.gp_Trsf) -> None: 
        """
        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.

        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.TopLoc.TopLoc_Datum3D) -> None: ...
    def SetMaterial(self,aName : OCP.Graphic3d.Graphic3d_MaterialAspect) -> None: 
        """
        Sets the material aMat defining this display attribute for the interactive object. Material aspect determines shading aspect, color and transparency of visible entities.
        """
    def SetMutable(self,theIsMutable : bool) -> None: 
        """
        Sets if the object has mutable nature (content or location will be changed regularly). This method should be called before object displaying to take effect.
        """
    def SetOwner(self,theApplicativeEntity : OCP.Standard.Standard_Transient) -> None: 
        """
        Allows you to attribute the owner theApplicativeEntity to an Interactive Object. This can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of. The owner takes the form of a transient.
        """
    def SetPolygonOffsets(self,aMode : int,aFactor : float=1.0,aUnits : float=0.0) -> None: 
        """
        Sets up polygon offsets for this object.
        """
    def SetPropagateVisualState(self,theFlag : bool) -> None: 
        """
        Change the value of the flag "propagate visual state"
        """
    @overload
    def SetToUpdate(self) -> None: 
        """
        Flags presentation to be updated; UpdatePresentations() will recompute these presentations.

        flags all the Presentations to be Updated.
        """
    @overload
    def SetToUpdate(self,theMode : int) -> None: ...
    def SetTransformPersistence(self,theTrsfPers : OCP.Graphic3d.Graphic3d_TransformPers) -> None: 
        """
        Sets up Transform Persistence defining a special Local Coordinate system where this object should be located. Note that management of Transform Persistence object is more expensive than of the normal one, because it requires its position being recomputed basing on camera position within each draw call / traverse.
        """
    def SetTransparency(self,aValue : float=0.6) -> None: 
        """
        Attributes a setting aValue for transparency. The transparency value should be between 0.0 and 1.0. At 0.0 an object will be totally opaque, and at 1.0, fully transparent. Warning At a value of 1.0, there may be nothing visible.
        """
    def SetTypeOfPresentation(self,theType : OCP.PrsMgr.PrsMgr_TypeOfPresentation3d) -> None: 
        """
        Set type of presentation.
        """
    def SetWidth(self,theWidth : float) -> None: 
        """
        Allows you to provide the setting aValue for width. Only the Interactive Object knows which Drawer attribute is affected by the width setting.
        """
    def SetZLayer(self,theLayerId : int) -> None: 
        """
        Set Z layer ID and update all presentations of the selectable object. The layers mechanism allows drawing objects in higher layers in overlay of objects in lower layers.
        """
    def Signature(self) -> int: 
        """
        Returns 0
        """
    def SynchronizeAspects(self) -> None: 
        """
        Synchronize presentation aspects after their modification.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    @overload
    def ToBeUpdated(self,ListOfMode : OCP.TColStd.TColStd_ListOfInteger) -> None: 
        """
        Returns TRUE if any active presentation has invalidation flag.

        gives the list of modes which are flagged "to be updated".
        """
    @overload
    def ToBeUpdated(self,theToIncludeHidden : bool=False) -> bool: ...
    def ToPropagateVisualState(self) -> bool: 
        """
        Get value of the flag "propagate visual state" It means that the display/erase/color visual state is propagated automatically to all children; by default, the flag is true
        """
    def TransformPersistence(self) -> OCP.Graphic3d.Graphic3d_TransformPers: 
        """
        Returns Transformation Persistence defining a special Local Coordinate system where this presentable object is located or NULL handle if not defined. Position of the object having Transformation Persistence is mutable and depends on camera position. The same applies to a bounding box of the object.
        """
    def Transformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def TransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def Transparency(self) -> float: 
        """
        Returns the transparency setting. This will be between 0.0 and 1.0. At 0.0 an object will be totally opaque, and at 1.0, fully transparent.
        """
    def Type(self) -> AIS_KindOfInteractive: 
        """
        Returns KOI_Object
        """
    def TypeOfPresentation3d(self) -> OCP.PrsMgr.PrsMgr_TypeOfPresentation3d: 
        """
        Returns information on whether the object accepts display in HLR mode or not.
        """
    def UnsetAttributes(self) -> None: 
        """
        Clears settings provided by the drawing tool aDrawer.
        """
    def UnsetColor(self) -> None: 
        """
        Removes color settings. Only the Interactive Object knows which Drawer attribute is affected by the color setting. For a wire, for example, wire aspect is the attribute affected. For a vertex, however, only point aspect is affected by the color setting.
        """
    def UnsetDisplayMode(self) -> None: 
        """
        Removes display mode settings from the interactive object.
        """
    def UnsetHilightAttributes(self) -> None: 
        """
        Clears settings provided by the hilight drawing tool theDrawer.
        """
    def UnsetHilightMode(self) -> None: 
        """
        Unsets highlight display mode.
        """
    def UnsetMaterial(self) -> None: 
        """
        Removes the setting for material.
        """
    def UnsetTransparency(self) -> None: 
        """
        Removes the transparency setting. The object is opaque by default.
        """
    def UnsetWidth(self) -> None: 
        """
        Reset width to default value.
        """
    def UpdateSelection(self,theMode : int=-1) -> None: 
        """
        Sets update status FULL to selections of the object. Must be used as the only method of UpdateSelection from outer classes to prevent BVH structures from being outdated.
        """
    def UpdateTransformation(self) -> None: 
        """
        Recomputes the location of the selection aSelection.
        """
    def UpdateTransformations(self,aSelection : OCP.SelectMgr.SelectMgr_Selection) -> None: 
        """
        Updates locations in all sensitive entities from <aSelection> and in corresponding entity owners.
        """
    def ViewAffinity(self) -> OCP.Graphic3d.Graphic3d_ViewAffinity: 
        """
        Return view affinity mask.
        """
    def Width(self) -> float: 
        """
        Returns the width setting of the Interactive Object.
        """
    def ZLayer(self) -> int: 
        """
        Get ID of Z layer for main presentation.
        """
    def __init__(self,aTypeOfPresentation3d : OCP.PrsMgr.PrsMgr_TypeOfPresentation3d=PrsMgr_TypeOfPresentation3d.PrsMgr_TOP_AllView) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class AIS_DisplayMode():
    """
    Sets display modes other than neutral point ones, for interactive objects. The possibilities include: - wireframe, - shaded,

    Members:

      AIS_WireFrame

      AIS_Shaded
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    AIS_Shaded: OCP.AIS.AIS_DisplayMode # value = <AIS_DisplayMode.AIS_Shaded: 1>
    AIS_WireFrame: OCP.AIS.AIS_DisplayMode # value = <AIS_DisplayMode.AIS_WireFrame: 0>
    __entries: dict # value = {'AIS_WireFrame': (<AIS_DisplayMode.AIS_WireFrame: 0>, None), 'AIS_Shaded': (<AIS_DisplayMode.AIS_Shaded: 1>, None)}
    __members__: dict # value = {'AIS_WireFrame': <AIS_DisplayMode.AIS_WireFrame: 0>, 'AIS_Shaded': <AIS_DisplayMode.AIS_Shaded: 1>}
    pass
class AIS_DragAction():
    """
    Dragging action.

    Members:

      AIS_DragAction_Start

      AIS_DragAction_Confirmed

      AIS_DragAction_Update

      AIS_DragAction_Stop

      AIS_DragAction_Abort
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    AIS_DragAction_Abort: OCP.AIS.AIS_DragAction # value = <AIS_DragAction.AIS_DragAction_Abort: 4>
    AIS_DragAction_Confirmed: OCP.AIS.AIS_DragAction # value = <AIS_DragAction.AIS_DragAction_Confirmed: 1>
    AIS_DragAction_Start: OCP.AIS.AIS_DragAction # value = <AIS_DragAction.AIS_DragAction_Start: 0>
    AIS_DragAction_Stop: OCP.AIS.AIS_DragAction # value = <AIS_DragAction.AIS_DragAction_Stop: 3>
    AIS_DragAction_Update: OCP.AIS.AIS_DragAction # value = <AIS_DragAction.AIS_DragAction_Update: 2>
    __entries: dict # value = {'AIS_DragAction_Start': (<AIS_DragAction.AIS_DragAction_Start: 0>, None), 'AIS_DragAction_Confirmed': (<AIS_DragAction.AIS_DragAction_Confirmed: 1>, None), 'AIS_DragAction_Update': (<AIS_DragAction.AIS_DragAction_Update: 2>, None), 'AIS_DragAction_Stop': (<AIS_DragAction.AIS_DragAction_Stop: 3>, None), 'AIS_DragAction_Abort': (<AIS_DragAction.AIS_DragAction_Abort: 4>, None)}
    __members__: dict # value = {'AIS_DragAction_Start': <AIS_DragAction.AIS_DragAction_Start: 0>, 'AIS_DragAction_Confirmed': <AIS_DragAction.AIS_DragAction_Confirmed: 1>, 'AIS_DragAction_Update': <AIS_DragAction.AIS_DragAction_Update: 2>, 'AIS_DragAction_Stop': <AIS_DragAction.AIS_DragAction_Stop: 3>, 'AIS_DragAction_Abort': <AIS_DragAction.AIS_DragAction_Abort: 4>}
    pass
class AIS_ExclusionFilter(OCP.SelectMgr.SelectMgr_Filter, OCP.Standard.Standard_Transient):
    """
    A framework to reject or to accept only objects of given types and/or signatures. Objects are stored, and the stored objects - along with the flag settings - are used to define the filter. Objects to be filtered are compared with the stored objects added to the filter, and are accepted or rejected according to the exclusion flag setting. - Exclusion flag on - the function IsOk answers true for all objects, except those of the types and signatures stored in the filter framework - Exclusion flag off - the funciton IsOk answers true for all objects which have the same type and signature as the stored ones.A framework to reject or to accept only objects of given types and/or signatures. Objects are stored, and the stored objects - along with the flag settings - are used to define the filter. Objects to be filtered are compared with the stored objects added to the filter, and are accepted or rejected according to the exclusion flag setting. - Exclusion flag on - the function IsOk answers true for all objects, except those of the types and signatures stored in the filter framework - Exclusion flag off - the funciton IsOk answers true for all objects which have the same type and signature as the stored ones.A framework to reject or to accept only objects of given types and/or signatures. Objects are stored, and the stored objects - along with the flag settings - are used to define the filter. Objects to be filtered are compared with the stored objects added to the filter, and are accepted or rejected according to the exclusion flag setting. - Exclusion flag on - the function IsOk answers true for all objects, except those of the types and signatures stored in the filter framework - Exclusion flag off - the funciton IsOk answers true for all objects which have the same type and signature as the stored ones.
    """
    def ActsOn(self,aStandardMode : OCP.TopAbs.TopAbs_ShapeEnum) -> bool: 
        """
        Returns true in an AIS local context, if this filter operates on a type of subshape defined in a filter class inheriting this framework. This function completes IsOk in an AIS local context.
        """
    @overload
    def Add(self,TypeToExclude : AIS_KindOfInteractive,SignatureInType : int) -> bool: 
        """
        Adds the type TypeToExclude to the list of types.

        None
        """
    @overload
    def Add(self,TypeToExclude : AIS_KindOfInteractive) -> bool: ...
    def Clear(self) -> None: 
        """
        None
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def IsExclusionFlagOn(self) -> bool: 
        """
        None
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def IsOk(self,anObj : OCP.SelectMgr.SelectMgr_EntityOwner) -> bool: 
        """
        None
        """
    def IsStored(self,aType : AIS_KindOfInteractive) -> bool: 
        """
        None
        """
    def ListOfSignature(self,aType : AIS_KindOfInteractive,TheStoredList : OCP.TColStd.TColStd_ListOfInteger) -> None: 
        """
        None
        """
    def ListOfStoredTypes(self,TheList : OCP.TColStd.TColStd_ListOfInteger) -> None: 
        """
        None
        """
    @overload
    def Remove(self,TypeToExclude : AIS_KindOfInteractive,SignatureInType : int) -> bool: 
        """
        None

        None
        """
    @overload
    def Remove(self,TypeToExclude : AIS_KindOfInteractive) -> bool: ...
    def SetExclusionFlag(self,theStatus : bool) -> None: 
        """
        None
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    @overload
    def __init__(self,TypeToExclude : AIS_KindOfInteractive,SignatureInType : int,ExclusionFlagOn : bool=True) -> None: ...
    @overload
    def __init__(self,ExclusionFlagOn : bool=True) -> None: ...
    @overload
    def __init__(self,TypeToExclude : AIS_KindOfInteractive,ExclusionFlagOn : bool=True) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class AIS_GlobalStatus(OCP.Standard.Standard_Transient):
    """
    Stores information about objects in graphic context:Stores information about objects in graphic context:
    """
    def AddSelectionMode(self,theMode : int) -> bool: 
        """
        Add selection mode.
        """
    def ClearSelectionModes(self) -> None: 
        """
        Remove all selection modes.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DisplayMode(self) -> int: 
        """
        Returns the display mode.
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HilightStyle(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns applied highlight style for a particular object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def IsHilighted(self) -> bool: 
        """
        Returns TRUE if object is highlighted
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def IsSModeIn(self,theMode : int) -> bool: 
        """
        Return TRUE if selection mode was registered.
        """
    def IsSubIntensityOn(self) -> bool: 
        """
        None
        """
    def RemoveSelectionMode(self,theMode : int) -> bool: 
        """
        Remove selection mode.
        """
    def SelectionModes(self) -> OCP.TColStd.TColStd_ListOfInteger: 
        """
        Returns active selection modes of the object.
        """
    def SetDisplayMode(self,theMode : int) -> None: 
        """
        Sets display mode.
        """
    def SetHilightStatus(self,theStatus : bool) -> None: 
        """
        Sets highlighted state.
        """
    def SetHilightStyle(self,theStyle : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Changes applied highlight style for a particular object
        """
    def SetSubIntensity(self,theIsOn : bool) -> None: 
        """
        None
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class AIS_GraphicTool():
    """
    None
    """
    @staticmethod
    @overload
    def GetInteriorColor_s(aDrawer : OCP.Prs3d.Prs3d_Drawer,aColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        None

        None
        """
    @staticmethod
    @overload
    def GetInteriorColor_s(aDrawer : OCP.Prs3d.Prs3d_Drawer) -> OCP.Quantity.Quantity_NameOfColor: ...
    @staticmethod
    def GetLineAtt_s(aDrawer : OCP.Prs3d.Prs3d_Drawer,TheTypeOfAttributes : AIS_TypeOfAttribute,aCol : OCP.Quantity.Quantity_NameOfColor,aTyp : OCP.Aspect.Aspect_TypeOfLine) -> tuple[float]: 
        """
        None
        """
    @staticmethod
    @overload
    def GetLineColor_s(aDrawer : OCP.Prs3d.Prs3d_Drawer,TheTypeOfAttributes : AIS_TypeOfAttribute,TheLineColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        None

        None
        """
    @staticmethod
    @overload
    def GetLineColor_s(aDrawer : OCP.Prs3d.Prs3d_Drawer,TheTypeOfAttributes : AIS_TypeOfAttribute) -> OCP.Quantity.Quantity_NameOfColor: ...
    @staticmethod
    def GetLineType_s(aDrawer : OCP.Prs3d.Prs3d_Drawer,TheTypeOfAttributes : AIS_TypeOfAttribute) -> OCP.Aspect.Aspect_TypeOfLine: 
        """
        None
        """
    @staticmethod
    def GetLineWidth_s(aDrawer : OCP.Prs3d.Prs3d_Drawer,TheTypeOfAttributes : AIS_TypeOfAttribute) -> float: 
        """
        None
        """
    @staticmethod
    def GetMaterial_s(aDrawer : OCP.Prs3d.Prs3d_Drawer) -> OCP.Graphic3d.Graphic3d_MaterialAspect: 
        """
        None
        """
    def __init__(self) -> None: ...
    pass
class AIS_InteractiveContext(OCP.Standard.Standard_Transient):
    """
    The Interactive Context allows you to manage graphic behavior and selection of Interactive Objects in one or more viewers. Class methods make this highly transparent. It is essential to remember that an Interactive Object which is already known by the Interactive Context must be modified using Context methods. You can only directly call the methods available for an Interactive Object if it has not been loaded into an Interactive Context.The Interactive Context allows you to manage graphic behavior and selection of Interactive Objects in one or more viewers. Class methods make this highly transparent. It is essential to remember that an Interactive Object which is already known by the Interactive Context must be modified using Context methods. You can only directly call the methods available for an Interactive Object if it has not been loaded into an Interactive Context.
    """
    @overload
    def Activate(self,theMode : int,theIsForce : bool=False) -> None: 
        """
        Activates the selection mode aMode whose index is given, for the given interactive entity anIobj.

        Activates the given selection mode for the all displayed objects.
        """
    @overload
    def Activate(self,theObj : AIS_InteractiveObject,theMode : int=0,theIsForce : bool=False) -> None: ...
    def ActivatedModes(self,anIobj : AIS_InteractiveObject,theList : OCP.TColStd.TColStd_ListOfInteger) -> None: 
        """
        Returns the list of activated selection modes.
        """
    def AddFilter(self,theFilter : OCP.SelectMgr.SelectMgr_Filter) -> None: 
        """
        Allows you to add the filter.
        """
    def AddOrRemoveCurrentObject(self,theObj : AIS_InteractiveObject,theIsToUpdateViewer : bool) -> None: 
        """
        Allows to add or remove the object given to the list of current and highlight/unhighlight it correspondingly. Is valid for global context only; for local context use method AddOrRemoveSelected. Since this method makes sense only for neutral point selection of a whole object, if 0 selection of the object is empty this method simply does nothing.
        """
    @overload
    def AddOrRemoveSelected(self,theObject : AIS_InteractiveObject,theToUpdateViewer : bool) -> None: 
        """
        Allows to highlight or unhighlight the owner given depending on its selection status

        Allows to highlight or unhighlight the owner given depending on its selection status
        """
    @overload
    def AddOrRemoveSelected(self,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theToUpdateViewer : bool) -> None: ...
    @overload
    def AddSelect(self,theObject : OCP.SelectMgr.SelectMgr_EntityOwner) -> AIS_StatusOfPick: 
        """
        Adds object in the selection.

        Adds object in the selection.
        """
    @overload
    def AddSelect(self,theObject : AIS_InteractiveObject) -> AIS_StatusOfPick: ...
    def Applicative(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns SelectedInteractive()->GetOwner().
        """
    def AutomaticHilight(self) -> bool: 
        """
        Returns true if the automatic highlight mode is active; TRUE by default.
        """
    def BeginImmediateDraw(self) -> bool: 
        """
        initializes the list of presentations to be displayed returns False if no local context is opened.
        """
    @overload
    def BoundingBoxOfSelection(self,theView : OCP.V3d.V3d_View) -> OCP.Bnd.Bnd_Box: 
        """
        Returns bounding box of selected objects.

        None
        """
    @overload
    def BoundingBoxOfSelection(self) -> OCP.Bnd.Bnd_Box: ...
    def ClearActiveSensitive(self,aView : OCP.V3d.V3d_View) -> None: 
        """
        Clear visualization of sensitives.
        """
    def ClearCurrents(self,theToUpdateViewer : bool) -> None: 
        """
        Empties previous current objects in order to get the current objects detected by the selector using UpdateCurrent. Objects selected when there is no open local context are called current objects; those selected in open local context, selected objects.
        """
    def ClearDetected(self,theToRedrawImmediate : bool=False) -> bool: 
        """
        Clears the list of entities detected by MoveTo() and resets dynamic highlighting.
        """
    def ClearPrs(self,theIObj : AIS_InteractiveObject,theMode : int,theToUpdateViewer : bool) -> None: 
        """
        Empties the graphic presentation of the mode indexed by aMode. Warning! Removes theIObj. theIObj is still active if it was previously activated.
        """
    def ClearSelected(self,theToUpdateViewer : bool) -> None: 
        """
        Empties previous selected objects in order to get the selected objects detected by the selector using UpdateSelected.
        """
    def Color(self,aniobj : AIS_InteractiveObject,acolor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Returns the color of the Object in the interactive context.
        """
    def Current(self) -> AIS_InteractiveObject: 
        """
        Returns the current interactive object. Objects selected when there is no open local context are called current objects; those selected in open local context, selected objects.
        """
    def CurrentViewer(self) -> OCP.V3d.V3d_Viewer: 
        """
        Returns the current viewer.
        """
    @overload
    def Deactivate(self,theMode : int) -> None: 
        """
        Deactivates all the activated selection modes of an object.

        Deactivates all the activated selection modes of the interactive object anIobj with a given selection mode aMode.

        Deactivates the given selection mode for all displayed objects.

        Deactivates all the activated selection mode at all displayed objects.
        """
    @overload
    def Deactivate(self) -> None: ...
    @overload
    def Deactivate(self,theObj : AIS_InteractiveObject,theMode : int) -> None: ...
    @overload
    def Deactivate(self,theObj : AIS_InteractiveObject) -> None: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def DefaultDrawer(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the default attribute manager. This contains all the color and line attributes which can be used by interactive objects which do not have their own attributes.
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DetectedCurrentObject(self) -> AIS_InteractiveObject: 
        """
        Returns current mouse-detected interactive object or null object, if there is no currently detected interactives DetectedCurrentOwner(), InitDetected(), MoreDetected(), NextDetected().
        """
    def DetectedCurrentOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns the owner from detected list pointed by current iterator position. WARNING! This method is irrelevant to DetectedOwner() which returns last picked Owner regardless of iterator position!
        """
    def DetectedCurrentShape(self) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Returns current mouse-detected shape or empty (null) shape, if current interactive object is not a shape (AIS_Shape) or there is no current mouse-detected interactive object at all. DetectedCurrentOwner(), InitDetected(), MoreDetected(), NextDetected().
        """
    def DetectedInteractive(self) -> AIS_InteractiveObject: 
        """
        Returns the interactive objects last detected in context. In general this is just a wrapper for Handle(AIS_InteractiveObject)::DownCast(DetectedOwner()->Selectable()).
        """
    def DetectedOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns the owner of the detected sensitive primitive which is currently dynamically highlighted. WARNING! This method is irrelevant to InitDetected()/MoreDetected()/NextDetected().
        """
    def DetectedShape(self) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Returns the shape detected in local context.
        """
    def DeviationAngle(self) -> float: 
        """
        None
        """
    def DeviationCoefficient(self) -> float: 
        """
        Returns the deviation coefficient. Drawings of curves or patches are made with respect to a maximal chordal deviation. A Deviation coefficient is used in the shading display mode. The shape is seen decomposed into triangles. These are used to calculate reflection of light from the surface of the object. The triangles are formed from chords of the curves in the shape. The deviation coefficient gives the highest value of the angle with which a chord can deviate from a tangent to a curve. If this limit is reached, a new triangle is begun. This deviation is absolute and is set through Prs3d_Drawer::SetMaximalChordialDeviation. The default value is 0.001. In drawing shapes, however, you are allowed to ask for a relative deviation. This deviation will be: SizeOfObject * DeviationCoefficient.
        """
    def DisableDrawHiddenLine(self) -> None: 
        """
        None
        """
    def Disconnect(self,theAssembly : AIS_InteractiveObject,theObjToDisconnect : AIS_InteractiveObject=None) -> None: 
        """
        Disconnects theObjToDisconnect from theAssembly and removes dependent selection structures
        """
    @overload
    def Display(self,theIObj : AIS_InteractiveObject,theDispMode : int,theSelectionMode : int,theToUpdateViewer : bool,theToAllowDecomposition : bool,theDispStatus : OCP.PrsMgr.PrsMgr_DisplayStatus=PrsMgr_DisplayStatus.PrsMgr_DisplayStatus_None) -> None: 
        """
        Displays the object in this Context using default Display Mode. This will be the object's default display mode, if there is one. Otherwise, it will be the context mode. The Interactive Object's default selection mode is activated if GetAutoActivateSelection() is TRUE. In general, this is 0.

        Sets status, display mode and selection mode for specified Object If theSelectionMode equals -1, theIObj will not be activated: it will be displayed but will not be selectable.
        """
    @overload
    def Display(self,theIObj : AIS_InteractiveObject,theDispMode : int,theSelectionMode : int,theToUpdateViewer : bool,theDispStatus : OCP.PrsMgr.PrsMgr_DisplayStatus=PrsMgr_DisplayStatus.PrsMgr_DisplayStatus_None) -> None: ...
    @overload
    def Display(self,theIObj : AIS_InteractiveObject,theToUpdateViewer : bool) -> None: ...
    @overload
    def DisplayActiveSensitive(self,anObject : AIS_InteractiveObject,aView : OCP.V3d.V3d_View) -> None: 
        """
        Visualization of sensitives - for debugging purposes!

        Visualization of sensitives - for debugging purposes!
        """
    @overload
    def DisplayActiveSensitive(self,aView : OCP.V3d.V3d_View) -> None: ...
    def DisplayAll(self,theToUpdateViewer : bool) -> None: 
        """
        Displays all hidden objects.
        """
    def DisplayMode(self) -> int: 
        """
        Returns the Display Mode setting to be used by default.
        """
    def DisplayPriority(self,theIObj : AIS_InteractiveObject) -> OCP.Graphic3d.Graphic3d_DisplayPriority: 
        """
        Returns the display priority of the Object.
        """
    def DisplaySelected(self,theToUpdateViewer : bool) -> None: 
        """
        Displays current objects.
        """
    def DisplayStatus(self,anIobj : AIS_InteractiveObject) -> OCP.PrsMgr.PrsMgr_DisplayStatus: 
        """
        Returns the display status of the entity anIobj. This will be one of the following: - AIS_DS_Displayed displayed in main viewer - AIS_DS_Erased hidden in main viewer - AIS_DS_Temporary temporarily displayed - AIS_DS_None nowhere displayed.
        """
    @overload
    def DisplayedObjects(self,theWhichKind : AIS_KindOfInteractive,theWhichSignature : int,theListOfIO : AIS_ListOfInteractive) -> None: 
        """
        Returns the list of displayed objects of a particular Type WhichKind and Signature WhichSignature. By Default, WhichSignature equals -1. This means that there is a check on type only.

        gives the list of displayed objects of a particular Type and signature. by Default, <WhichSignature> = -1 means control only on <WhichKind>.
        """
    @overload
    def DisplayedObjects(self,aListOfIO : AIS_ListOfInteractive) -> None: ...
    def DrawHiddenLine(self) -> bool: 
        """
        returns Standard_True if the hidden lines are to be drawn. By default the hidden lines are not drawn.
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def EnableDrawHiddenLine(self) -> None: 
        """
        None
        """
    @overload
    def EndImmediateDraw(self,theView : OCP.V3d.V3d_View) -> bool: 
        """
        returns True if the immediate display has been done.

        Uses the First Active View of Main Viewer! returns True if the immediate display has been done.
        """
    @overload
    def EndImmediateDraw(self) -> bool: ...
    def EntityOwners(self,theOwners : Any,theIObj : AIS_InteractiveObject,theMode : int=-1) -> Any: 
        """
        Returns a collection containing all entity owners created for the interactive object in specified selection mode (in all active modes if the Mode == -1)
        """
    def Erase(self,theIObj : AIS_InteractiveObject,theToUpdateViewer : bool) -> None: 
        """
        Hides the object. The object's presentations are simply flagged as invisible and therefore excluded from redrawing. To show hidden objects, use Display().
        """
    def EraseAll(self,theToUpdateViewer : bool) -> None: 
        """
        Hides all objects. The object's presentations are simply flagged as invisible and therefore excluded from redrawing. To show all hidden objects, use DisplayAll().
        """
    def EraseSelected(self,theToUpdateViewer : bool) -> None: 
        """
        Hides selected objects. The object's presentations are simply flagged as invisible and therefore excluded from redrawing. To show hidden objects, use Display().
        """
    @overload
    def ErasedObjects(self,theWhichKind : AIS_KindOfInteractive,theWhichSignature : int,theListOfIO : AIS_ListOfInteractive) -> None: 
        """
        Returns the list theListOfIO of erased objects (hidden objects) particular Type WhichKind and Signature WhichSignature. By Default, WhichSignature equals 1. This means that there is a check on type only.

        gives the list of erased objects (hidden objects) Type and signature by Default, <WhichSignature> = -1 means control only on <WhichKind>.
        """
    @overload
    def ErasedObjects(self,theListOfIO : AIS_ListOfInteractive) -> None: ...
    def FilterType(self) -> OCP.SelectMgr.SelectMgr_FilterType: 
        """
        Returns the context selection filter type.
        """
    def Filters(self) -> OCP.SelectMgr.SelectMgr_ListOfFilter: 
        """
        Returns the list of filters active in a local context.
        """
    def FirstSelectedObject(self) -> AIS_InteractiveObject: 
        """
        Returns the first selected object in the list of current selected.
        """
    @overload
    def FitSelected(self,theView : OCP.V3d.V3d_View) -> None: 
        """
        Fits the view correspondingly to the bounds of selected objects. Infinite objects are ignored if infinite state of AIS_InteractiveObject is set to true.

        Fits the view correspondingly to the bounds of selected objects. Infinite objects are ignored if infinite state of AIS_InteractiveObject is set to true.
        """
    @overload
    def FitSelected(self,theView : OCP.V3d.V3d_View,theMargin : float,theToUpdate : bool) -> None: ...
    def GetAutoActivateSelection(self) -> bool: 
        """
        Manages displaying the new object should also automatically activate default selection mode; TRUE by default.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def GetZLayer(self,theIObj : AIS_InteractiveObject) -> int: 
        """
        Get Z layer id set for displayed interactive object.
        """
    def GlobalFilter(self) -> OCP.SelectMgr.SelectMgr_AndOrFilter: 
        """
        Returns the context selection global context filter.
        """
    def GravityPoint(self,theView : OCP.V3d.V3d_View) -> OCP.gp.gp_Pnt: 
        """
        Return rotation gravity point.
        """
    def HasApplicative(self) -> bool: 
        """
        Returns SelectedInteractive()->HasOwner().
        """
    def HasColor(self,aniobj : AIS_InteractiveObject) -> bool: 
        """
        Returns true if a view of the Interactive Object has color.
        """
    def HasDetected(self) -> bool: 
        """
        Returns true if there is a mouse-detected entity in context.
        """
    def HasDetectedShape(self) -> bool: 
        """
        Returns true if there is a detected shape in local context.
        """
    def HasLocation(self,theObject : AIS_InteractiveObject) -> bool: 
        """
        Returns true if the Object has a location.
        """
    def HasNextDetected(self) -> bool: 
        """
        returns True if other entities were detected in the last mouse detection
        """
    def HasPolygonOffsets(self,anObj : AIS_InteractiveObject) -> bool: 
        """
        Simply calls AIS_InteractiveObject::HasPolygonOffsets().
        """
    def HasSelectedShape(self) -> bool: 
        """
        Returns TRUE if the interactive context has a shape selected.
        """
    def HiddenLineAspect(self) -> OCP.Prs3d.Prs3d_LineAspect: 
        """
        Initializes hidden line aspect in the default drawing tool, or Drawer. The default values are: Color: Quantity_NOC_YELLOW Type of line: Aspect_TOL_DASH Width: 1.
        """
    @overload
    def HighlightStyle(self,theStyleType : OCP.Prs3d.Prs3d_TypeOfHighlight) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns default highlight style settings (could be overridden by PrsMgr_PresentableObject).

        Returns highlight style of the object if it is marked as highlighted via global status

        Returns highlight style of the owner if it is selected

        Returns current dynamic highlight style settings corresponding to Prs3d_TypeOfHighlight_Dynamic. This is just a short-cut to HighlightStyle(Prs3d_TypeOfHighlight_Dynamic).
        """
    @overload
    def HighlightStyle(self) -> OCP.Prs3d.Prs3d_Drawer: ...
    @overload
    def HighlightStyle(self,theObj : AIS_InteractiveObject,theStyle : OCP.Prs3d.Prs3d_Drawer) -> bool: ...
    @overload
    def HighlightStyle(self,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theStyle : OCP.Prs3d.Prs3d_Drawer) -> bool: ...
    def Hilight(self,theObj : AIS_InteractiveObject,theIsToUpdateViewer : bool) -> None: 
        """
        Updates the display in the viewer to take dynamic detection into account. On dynamic detection by the mouse cursor, sensitive primitives are highlighted. The highlight color of entities detected by mouse movement is white by default.
        """
    def HilightCurrents(self,theToUpdateViewer : bool) -> None: 
        """
        Highlights current objects. Objects selected when there is no open local context are called current objects; those selected in open local context, selected objects.
        """
    def HilightNextDetected(self,theView : OCP.V3d.V3d_View,theToRedrawImmediate : bool=True) -> int: 
        """
        If more than 1 object is detected by the selector, only the "best" owner is hilighted at the mouse position. This Method allows the user to hilight one after another the other detected entities. If The method select is called, the selected entity will be the hilighted one! WARNING: Loop Method. When all the detected entities have been hilighted, the next call will hilight the first one again.
        """
    def HilightPreviousDetected(self,theView : OCP.V3d.V3d_View,theToRedrawImmediate : bool=True) -> int: 
        """
        Same as previous methods in reverse direction.
        """
    def HilightSelected(self,theToUpdateViewer : bool) -> None: 
        """
        Highlights selected objects.
        """
    def HilightWithColor(self,theObj : AIS_InteractiveObject,theStyle : OCP.Prs3d.Prs3d_Drawer,theToUpdateViewer : bool) -> None: 
        """
        Changes the color of all the lines of the object in view.
        """
    def ImmediateAdd(self,theObj : AIS_InteractiveObject,theMode : int=0) -> bool: 
        """
        returns True if <anIObj> has been stored in the list.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def InitCurrent(self) -> None: 
        """
        Initializes a scan of the current selected objects in Neutral Point. Objects selected when there is no open local context are called current objects; those selected in open local context, selected objects.
        """
    def InitDetected(self) -> None: 
        """
        Initialization for iteration through mouse-detected objects in interactive context or in local context if it is opened.
        """
    def InitSelected(self) -> None: 
        """
        Initializes a scan of the selected objects.
        """
    def IsCurrent(self,theObject : AIS_InteractiveObject) -> bool: 
        """
        Returns true if there is a non-null interactive object in Neutral Point. Objects selected when there is no open local context are called current objects; those selected in open local context, selected objects.
        """
    @overload
    def IsDisplayed(self,anIobj : AIS_InteractiveObject) -> bool: 
        """
        Returns true if Object is displayed in the interactive context.

        None
        """
    @overload
    def IsDisplayed(self,aniobj : AIS_InteractiveObject,aMode : int) -> bool: ...
    @overload
    def IsHilighted(self,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner) -> bool: 
        """
        Returns true if the object is marked as highlighted via its global status

        Returns true if the owner is marked as selected
        """
    @overload
    def IsHilighted(self,theObj : AIS_InteractiveObject) -> bool: ...
    def IsImmediateModeOn(self) -> bool: 
        """
        None
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    @overload
    def IsSelected(self,theObj : AIS_InteractiveObject) -> bool: 
        """
        Returns true is the owner given is selected

        Returns true is the object given is selected
        """
    @overload
    def IsSelected(self,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner) -> bool: ...
    def IsoNumber(self,WhichIsos : AIS_TypeOfIso=AIS_TypeOfIso.AIS_TOI_Both) -> int: 
        """
        Returns the number of U and V isoparameters displayed.
        """
    @overload
    def IsoOnPlane(self,theToSwitchOn : bool) -> None: 
        """
        Returns True if drawing isoparameters on planes is enabled.

        Returns True if drawing isoparameters on planes is enabled. if <forUIsos> = False,
        """
    @overload
    def IsoOnPlane(self) -> bool: ...
    @overload
    def IsoOnTriangulation(self) -> bool: 
        """
        Enables or disables on-triangulation build for isolines for a particular object. In case if on-triangulation builder is disabled, default on-plane builder will compute isolines for the object given.

        Enables or disables on-triangulation build for isolines for default drawer. In case if on-triangulation builder is disabled, default on-plane builder will compute isolines for the object given.

        Returns true if drawing isolines on triangulation algorithm is enabled.
        """
    @overload
    def IsoOnTriangulation(self,theToSwitchOn : bool) -> None: ...
    @overload
    def IsoOnTriangulation(self,theIsEnabled : bool,theObject : AIS_InteractiveObject) -> None: ...
    def LastActiveView(self) -> OCP.V3d.V3d_View: 
        """
        Returns last active View (argument of MoveTo()/Select() methods).
        """
    @overload
    def Load(self,theObj : AIS_InteractiveObject,theSelectionMode : int,arg3 : bool) -> None: 
        """
        Allows you to load the Interactive Object with a given selection mode, and/or with the desired decomposition option, whether the object is visualized or not. The loaded objects will be selectable but displayable in highlighting only when detected by the Selector.

        None
        """
    @overload
    def Load(self,theObj : AIS_InteractiveObject,theSelectionMode : int=-1) -> None: ...
    def Location(self,theObject : AIS_InteractiveObject) -> OCP.TopLoc.TopLoc_Location: 
        """
        Returns the location of the Object.
        """
    def MainPrsMgr(self) -> OCP.PrsMgr.PrsMgr_PresentationManager: 
        """
        None
        """
    def MainSelector(self) -> OCP.SelectMgr.SelectMgr_ViewerSelector: 
        """
        None
        """
    def MoreCurrent(self) -> bool: 
        """
        Returns true if there is another object found by the scan of the list of current objects. Objects selected when there is no open local context are called current objects; those selected in open local context, selected objects.
        """
    def MoreDetected(self) -> bool: 
        """
        Return TRUE if there is more mouse-detected objects after the current one during iteration through mouse-detected interactive objects.
        """
    def MoreSelected(self) -> bool: 
        """
        Returns true if there is another object found by the scan of the list of selected objects.
        """
    @overload
    def MoveTo(self,theXPix : int,theYPix : int,theView : OCP.V3d.V3d_View,theToRedrawOnUpdate : bool) -> AIS_StatusOfDetection: 
        """
        Relays mouse position in pixels theXPix and theYPix to the interactive context selectors. This is done by the view theView passing this position to the main viewer and updating it. If theToRedrawOnUpdate is set to false, callee should call RedrawImmediate() to highlight detected object.

        Relays axis theAxis to the interactive context selectors. This is done by the view theView passing this axis to the main viewer and updating it. If theToRedrawOnUpdate is set to false, callee should call RedrawImmediate() to highlight detected object.
        """
    @overload
    def MoveTo(self,theAxis : OCP.gp.gp_Ax1,theView : OCP.V3d.V3d_View,theToRedrawOnUpdate : bool) -> AIS_StatusOfDetection: ...
    def NbCurrents(self) -> int: 
        """
        None
        """
    def NbSelected(self) -> int: 
        """
        Count a number of selected entities using InitSelected()+MoreSelected()+NextSelected() iterator.
        """
    def NextCurrent(self) -> None: 
        """
        Continues the scan to the next object in the list of current objects. Objects selected when there is no open local context are called current objects; those selected in open local context, selected objects.
        """
    def NextDetected(self) -> None: 
        """
        Gets next current object during iteration through mouse-detected interactive objects.
        """
    def NextSelected(self) -> None: 
        """
        Continues the scan to the next object in the list of selected objects.
        """
    def ObjectIterator(self) -> Any: 
        """
        Create iterator through all objects registered in context.
        """
    @overload
    def ObjectsByDisplayStatus(self,WhichKind : AIS_KindOfInteractive,WhichSignature : int,theStatus : OCP.PrsMgr.PrsMgr_DisplayStatus,theListOfIO : AIS_ListOfInteractive) -> None: 
        """
        Returns the list theListOfIO of objects with indicated display status particular Type WhichKind and Signature WhichSignature. By Default, WhichSignature equals 1. This means that there is a check on type only.

        gives the list of objects with indicated display status Type and signature by Default, <WhichSignature> = -1 means control only on <WhichKind>.
        """
    @overload
    def ObjectsByDisplayStatus(self,theStatus : OCP.PrsMgr.PrsMgr_DisplayStatus,theListOfIO : AIS_ListOfInteractive) -> None: ...
    def ObjectsForView(self,theListOfIO : AIS_ListOfInteractive,theView : OCP.V3d.V3d_View,theIsVisibleInView : bool,theStatus : OCP.PrsMgr.PrsMgr_DisplayStatus=PrsMgr_DisplayStatus.PrsMgr_DisplayStatus_None) -> None: 
        """
        Query objects visible or hidden in specified view due to affinity mask.
        """
    def ObjectsInside(self,aListOfIO : AIS_ListOfInteractive,WhichKind : AIS_KindOfInteractive=AIS_KindOfInteractive.AIS_KindOfInteractive_None,WhichSignature : int=-1) -> None: 
        """
        fills <aListOfIO> with objects of a particular Type and Signature with no consideration of display status. by Default, <WhichSignature> = -1 means control only on <WhichKind>. if <WhichKind> = AIS_KindOfInteractive_None and <WhichSignature> = -1, all the objects are put into the list.
        """
    def PickingStrategy(self) -> OCP.SelectMgr.SelectMgr_PickingStrategy: 
        """
        Return picking strategy; SelectMgr_PickingStrategy_FirstAcceptable by default.
        """
    def PixelTolerance(self) -> int: 
        """
        Returns the pixel tolerance, default is 2. Pixel Tolerance extends sensitivity within MoveTo() operation (picking by point) and can be adjusted by application based on user input precision (e.g. screen pixel density, input device precision, etc.).
        """
    def PlaneSize(self,XSize : float,YSize : float) -> bool: 
        """
        Returns true if the length in the X direction XSize is the same as that in the Y direction YSize.
        """
    def PolygonOffsets(self,anObj : AIS_InteractiveObject,aFactor : float,aUnits : float) -> tuple[int]: 
        """
        Retrieves current polygon offsets settings for Object.
        """
    def RebuildSelectionStructs(self) -> None: 
        """
        Rebuilds 1st level of BVH selection forcibly
        """
    def RecomputePrsOnly(self,theIObj : AIS_InteractiveObject,theToUpdateViewer : bool,theAllModes : bool=False) -> None: 
        """
        Recomputes the displayed presentations, flags the others. Doesn't update presentations.
        """
    def RecomputeSelectionOnly(self,anIObj : AIS_InteractiveObject) -> None: 
        """
        Recomputes the active selections, flags the others. Doesn't update presentations.
        """
    @overload
    def Redisplay(self,theIObj : AIS_InteractiveObject,theToUpdateViewer : bool,theAllModes : bool=False) -> None: 
        """
        Recomputes the seen parts presentation of the Object. If theAllModes equals true, all presentations are present in the object even if unseen.

        Recomputes the Prs/Selection of displayed objects of a given type and a given signature. if signature = -1 doesn't take signature criterion.
        """
    @overload
    def Redisplay(self,theTypeOfObject : AIS_KindOfInteractive,theSignature : int,theToUpdateViewer : bool) -> None: ...
    def RedrawImmediate(self,theViewer : OCP.V3d.V3d_Viewer) -> None: 
        """
        Redraws immediate structures in all views of the viewer given taking into account its visibility.
        """
    def Remove(self,theIObj : AIS_InteractiveObject,theToUpdateViewer : bool) -> None: 
        """
        Removes Object from every viewer.
        """
    def RemoveAll(self,theToUpdateViewer : bool) -> None: 
        """
        Removes all the objects from Context.
        """
    def RemoveFilter(self,theFilter : OCP.SelectMgr.SelectMgr_Filter) -> None: 
        """
        Removes a filter from context.
        """
    def RemoveFilters(self) -> None: 
        """
        Remove all filters from context.
        """
    def ResetLocation(self,theObject : AIS_InteractiveObject) -> None: 
        """
        Puts the Object back into its initial position.
        """
    @overload
    def Select(self,thePolyline : OCP.TColgp.TColgp_Array1OfPnt2d,theView : OCP.V3d.V3d_View,theToUpdateViewer : bool) -> AIS_StatusOfPick: 
        """
        Sets list of owner selected/deselected using specified selection scheme.

        Selects everything found in the bounding rectangle defined by the pixel minima and maxima, XPMin, YPMin, XPMax, and YPMax in the view. The objects detected are passed to the main viewer, which is then updated.

        polyline selection; clears the previous picked list

        Stores and hilights the previous detected; Unhilights the previous picked.
        """
    @overload
    def Select(self,theOwners : AIS_NArray1OfEntityOwner,theSelScheme : AIS_SelectionScheme) -> AIS_StatusOfPick: ...
    @overload
    def Select(self,theXPMin : int,theYPMin : int,theXPMax : int,theYPMax : int,theView : OCP.V3d.V3d_View,theToUpdateViewer : bool) -> AIS_StatusOfPick: ...
    @overload
    def Select(self,theToUpdateViewer : bool) -> AIS_StatusOfPick: ...
    def SelectDetected(self,theSelScheme : AIS_SelectionScheme=AIS_SelectionScheme.AIS_SelectionScheme_Replace) -> AIS_StatusOfPick: 
        """
        Select and hilights the previous detected via AIS_InteractiveContext::MoveTo() method; unhilights the previous picked. Viewer should be explicitly redrawn after selection.
        """
    def SelectPoint(self,thePnt : OCP.Graphic3d.Graphic3d_Vec2i,theView : OCP.V3d.V3d_View,theSelScheme : AIS_SelectionScheme=AIS_SelectionScheme.AIS_SelectionScheme_Replace) -> AIS_StatusOfPick: 
        """
        Selects the topmost object picked by the point in the view, Viewer should be explicitly redrawn after selection.
        """
    def SelectPolygon(self,thePolyline : OCP.TColgp.TColgp_Array1OfPnt2d,theView : OCP.V3d.V3d_View,theSelScheme : AIS_SelectionScheme=AIS_SelectionScheme.AIS_SelectionScheme_Replace) -> AIS_StatusOfPick: 
        """
        Select everything found in the polygon defined by bounding polyline. Viewer should be explicitly redrawn after selection.
        """
    def SelectRectangle(self,thePntMin : OCP.Graphic3d.Graphic3d_Vec2i,thePntMax : OCP.Graphic3d.Graphic3d_Vec2i,theView : OCP.V3d.V3d_View,theSelScheme : AIS_SelectionScheme=AIS_SelectionScheme.AIS_SelectionScheme_Replace) -> AIS_StatusOfPick: 
        """
        Selects objects within the bounding rectangle. Viewer should be explicitly redrawn after selection.
        """
    def SelectedInteractive(self) -> AIS_InteractiveObject: 
        """
        Return Handle(AIS_InteractiveObject)::DownCast (SelectedOwner()->Selectable()).
        """
    def SelectedOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns the owner of the selected entity.
        """
    def SelectedShape(self) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Returns the selected shape. Basically it is just a shape returned stored by StdSelect_BRepOwner with graphic transformation being applied:
        """
    def Selection(self) -> AIS_Selection: 
        """
        Returns selection instance
        """
    def SelectionManager(self) -> OCP.SelectMgr.SelectMgr_SelectionManager: 
        """
        None
        """
    def SelectionStyle(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns current selection style settings corrsponding to Prs3d_TypeOfHighlight_Selected. This is just a short-cut to HighlightStyle(Prs3d_TypeOfHighlight_Selected).
        """
    def SetAngleAndDeviation(self,theIObj : AIS_InteractiveObject,theAngle : float,theToUpdateViewer : bool) -> None: 
        """
        Calls the AIS_Shape SetAngleAndDeviation to set both Angle and Deviation coefficients
        """
    def SetAutoActivateSelection(self,theIsAuto : bool) -> None: 
        """
        Enable or disable automatic activation of default selection mode while displaying the object.
        """
    def SetAutomaticHilight(self,theStatus : bool) -> None: 
        """
        Sets the highlighting status of detected and selected entities. This function allows you to disconnect the automatic mode.
        """
    def SetColor(self,theIObj : AIS_InteractiveObject,theColor : OCP.Quantity.Quantity_Color,theToUpdateViewer : bool) -> None: 
        """
        Sets the color of the selected entity.
        """
    def SetCurrentFacingModel(self,aniobj : AIS_InteractiveObject,aModel : OCP.Aspect.Aspect_TypeOfFacingModel=Aspect_TypeOfFacingModel.Aspect_TOFM_BOTH_SIDE) -> None: 
        """
        change the current facing model apply on polygons for SetColor(), SetTransparency(), SetMaterial() methods default facing model is Aspect_TOFM_TWO_SIDE. This mean that attributes is applying both on the front and back face.
        """
    def SetCurrentObject(self,theIObj : AIS_InteractiveObject,theToUpdateViewer : bool) -> None: 
        """
        Updates the view of the current object in open context. Objects selected when there is no open local context are called current objects; those selected in open local context, selected objects.
        """
    def SetDefaultDrawer(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Sets the default attribute manager; should be set at context creation time. Warning - this setter doesn't update links to the default drawer of already displayed objects!
        """
    @overload
    def SetDeviationAngle(self,theIObj : AIS_InteractiveObject,theAngle : float,theToUpdateViewer : bool) -> None: 
        """
        None

        default 20 degrees
        """
    @overload
    def SetDeviationAngle(self,theAngle : float) -> None: ...
    @overload
    def SetDeviationCoefficient(self,theCoefficient : float) -> None: 
        """
        Sets the deviation coefficient theCoefficient. Drawings of curves or patches are made with respect to a maximal chordal deviation. A Deviation coefficient is used in the shading display mode. The shape is seen decomposed into triangles. These are used to calculate reflection of light from the surface of the object. The triangles are formed from chords of the curves in the shape. The deviation coefficient theCoefficient gives the highest value of the angle with which a chord can deviate from a tangent to a curve. If this limit is reached, a new triangle is begun. This deviation is absolute and is set through the method: SetMaximalChordialDeviation. The default value is 0.001. In drawing shapes, however, you are allowed to ask for a relative deviation. This deviation will be: SizeOfObject * DeviationCoefficient.

        Sets the deviation coefficient theCoefficient. Drawings of curves or patches are made with respect to a maximal chordal deviation. A Deviation coefficient is used in the shading display mode. The shape is seen decomposed into triangles. These are used to calculate reflection of light from the surface of the object. The triangles are formed from chords of the curves in the shape. The deviation coefficient theCoefficient gives the highest value of the angle with which a chord can deviate from a tangent to a curve. If this limit is reached, a new triangle is begun. This deviation is absolute and is set through the method: SetMaximalChordialDeviation. The default value is 0.001. In drawing shapes, however, you are allowed to ask for a relative deviation. This deviation will be: SizeOfObject * DeviationCoefficient.
        """
    @overload
    def SetDeviationCoefficient(self,theIObj : AIS_InteractiveObject,theCoefficient : float,theToUpdateViewer : bool) -> None: ...
    @overload
    def SetDisplayMode(self,theMode : int,theToUpdateViewer : bool) -> None: 
        """
        Sets the display mode of seen Interactive Objects (which have no overridden Display Mode).

        Sets the display mode of seen Interactive Objects. theMode provides the display mode index of the entity theIObj.
        """
    @overload
    def SetDisplayMode(self,theIObj : AIS_InteractiveObject,theMode : int,theToUpdateViewer : bool) -> None: ...
    @overload
    def SetDisplayPriority(self,theIObj : AIS_InteractiveObject,thePriority : OCP.Graphic3d.Graphic3d_DisplayPriority) -> None: 
        """
        Sets the display priority of the seen parts presentation of the Object.

        None
        """
    @overload
    def SetDisplayPriority(self,theIObj : AIS_InteractiveObject,thePriority : int) -> None: ...
    def SetFilterType(self,theFilterType : OCP.SelectMgr.SelectMgr_FilterType) -> None: 
        """
        Sets the context selection filter type. SelectMgr_TypeFilter_OR selection filter is used by default.
        """
    def SetHiddenLineAspect(self,theAspect : OCP.Prs3d.Prs3d_LineAspect) -> None: 
        """
        Sets the hidden line aspect anAspect. Aspect defines display attributes for hidden lines in HLR projections.
        """
    @overload
    def SetHighlightStyle(self,theStyleType : OCP.Prs3d.Prs3d_TypeOfHighlight,theStyle : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Setup highlight style settings. Tip: it is better modifying existing style returned by method HighlightStyle() instead of creating a new Prs3d_Drawer to avoid unexpected results due misconfiguration.

        Setup the style of dynamic highlighting corrsponding to Prs3d_TypeOfHighlight_Selected. This is just a short-cut to SetHighlightStyle(Prs3d_TypeOfHighlight_Dynamic,theStyle).
        """
    @overload
    def SetHighlightStyle(self,theStyle : OCP.Prs3d.Prs3d_Drawer) -> None: ...
    def SetIsoNumber(self,NbIsos : int,WhichIsos : AIS_TypeOfIso=AIS_TypeOfIso.AIS_TOI_Both) -> None: 
        """
        Sets the number of U and V isoparameters displayed.
        """
    def SetLocalAttributes(self,theIObj : AIS_InteractiveObject,theDrawer : OCP.Prs3d.Prs3d_Drawer,theToUpdateViewer : bool) -> None: 
        """
        Sets the graphic attributes of the interactive object, such as visualization mode, color, and material.
        """
    def SetLocation(self,theObject : AIS_InteractiveObject,theLocation : OCP.TopLoc.TopLoc_Location) -> None: 
        """
        Puts the location on the initial graphic representation and the selection for the Object.
        """
    def SetMaterial(self,theIObj : AIS_InteractiveObject,theMaterial : OCP.Graphic3d.Graphic3d_MaterialAspect,theToUpdateViewer : bool) -> None: 
        """
        Provides the type of material setting for the view of the Object.
        """
    def SetPickingStrategy(self,theStrategy : OCP.SelectMgr.SelectMgr_PickingStrategy) -> None: 
        """
        Setup picking strategy - which entities detected by picking line will be accepted, considering Selection Filters. By default (SelectMgr_PickingStrategy_FirstAcceptable), Selection Filters reduce the list of entities so that the context accepts topmost in remaining.
        """
    def SetPixelTolerance(self,thePrecision : int=2) -> None: 
        """
        Setup pixel tolerance for MoveTo() operation.
        """
    @overload
    def SetPlaneSize(self,theSizeX : float,theSizeY : float,theToUpdateViewer : bool) -> None: 
        """
        Sets the plane size defined by the length in the X direction XSize and that in the Y direction YSize.

        Sets the plane size aSize.
        """
    @overload
    def SetPlaneSize(self,theSize : float,theToUpdateViewer : bool) -> None: ...
    def SetPolygonOffsets(self,theIObj : AIS_InteractiveObject,theMode : int,theFactor : float,theUnits : float,theToUpdateViewer : bool) -> None: 
        """
        Sets up polygon offsets for the given AIS_InteractiveObject. It simply calls AIS_InteractiveObject::SetPolygonOffsets().
        """
    @overload
    def SetSelected(self,theOwners : OCP.SelectMgr.SelectMgr_EntityOwner,theToUpdateViewer : bool) -> None: 
        """
        Unhighlights previously selected owners and marks them as not selected. Marks owner given as selected and highlights it. Performs selection filters check.

        Puts the interactive object aniObj in the list of selected objects. Performs selection filters check.
        """
    @overload
    def SetSelected(self,theObject : AIS_InteractiveObject,theToUpdateViewer : bool) -> None: ...
    def SetSelectedAspect(self,theAspect : OCP.Prs3d.Prs3d_BasicAspect,theToUpdateViewer : bool) -> None: 
        """
        Sets the graphic basic aspect to the current presentation of ALL selected objects.
        """
    def SetSelectedState(self,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theIsSelected : bool) -> bool: 
        """
        Updates Selected state of specified owner without calling HilightSelected(). Has no effect if Selected state is not changed, and redirects to AddOrRemoveSelected() otherwise.
        """
    def SetSelection(self,theSelection : AIS_Selection) -> None: 
        """
        Sets selection instance to manipulate a container of selected owners
        """
    def SetSelectionModeActive(self,theObj : AIS_InteractiveObject,theMode : int,theToActivate : bool,theConcurrency : AIS_SelectionModesConcurrency=AIS_SelectionModesConcurrency.AIS_SelectionModesConcurrency_Multiple,theIsForce : bool=False) -> None: 
        """
        Activates or deactivates the selection mode for specified object. Has no effect if selection mode was already active/deactivated.
        """
    def SetSelectionSensitivity(self,theObject : AIS_InteractiveObject,theMode : int,theNewSensitivity : int) -> None: 
        """
        Allows to manage sensitivity of a particular selection of interactive object theObject and changes previous sensitivity value of all sensitive entities in selection with theMode to the given theNewSensitivity.
        """
    def SetSelectionStyle(self,theStyle : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Setup the style of selection highlighting. This is just a short-cut to SetHighlightStyle(Prs3d_TypeOfHighlight_Selected,theStyle).
        """
    def SetSubIntensityColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Sub-intensity allows temporary highlighting of particular objects with specified color in a manner of selection highlight, but without actual selection (e.g., global status and owner's selection state will not be updated). The method sets up the color for such highlighting. By default, this is Quantity_NOC_GRAY40.
        """
    def SetToHilightSelected(self,toHilight : bool) -> None: 
        """
        Specify whether selected object must be hilighted when mouse cursor is moved above it (in MoveTo method). By default this value is false and selected object is not hilighted in this case.
        """
    def SetTransformPersistence(self,theObject : AIS_InteractiveObject,theTrsfPers : OCP.Graphic3d.Graphic3d_TransformPers) -> None: 
        """
        Sets transform persistence.
        """
    def SetTransparency(self,theIObj : AIS_InteractiveObject,theValue : float,theToUpdateViewer : bool) -> None: 
        """
        Provides the transparency settings for viewing the Object. The transparency value aValue may be between 0.0, opaque, and 1.0, fully transparent.
        """
    def SetTrihedronSize(self,theSize : float,theToUpdateViewer : bool) -> None: 
        """
        Sets the size aSize of the trihedron. Is used to change the default value 100 mm for display of trihedra. Use of this function in one of your own interactive objects requires a call to the Compute function of the new class. This will recalculate the presentation for every trihedron displayed.
        """
    def SetViewAffinity(self,theIObj : AIS_InteractiveObject,theView : OCP.V3d.V3d_View,theIsVisible : bool) -> None: 
        """
        Setup object visibility in specified view. Has no effect if object is not displayed in this context.
        """
    def SetWidth(self,theIObj : AIS_InteractiveObject,theValue : float,theToUpdateViewer : bool) -> None: 
        """
        Sets the width of the Object.
        """
    def SetZLayer(self,theIObj : AIS_InteractiveObject,theLayerId : int) -> None: 
        """
        Set Z layer id for interactive object. The Z layers can be used to display temporarily presentations of some object in front of the other objects in the scene. The ids for Z layers are generated by V3d_Viewer.
        """
    @overload
    def ShiftSelect(self,thePolyline : OCP.TColgp.TColgp_Array1OfPnt2d,theView : OCP.V3d.V3d_View,theToUpdateViewer : bool) -> AIS_StatusOfPick: 
        """
        Adds the last detected to the list of previous picked. If the last detected was already declared as picked, removes it from the Picked List.

        Adds the last detected to the list of previous picked. If the last detected was already declared as picked, removes it from the Picked List.

        Rectangle of selection; adds new detected entities into the picked list, removes the detected entities that were already stored.
        """
    @overload
    def ShiftSelect(self,theToUpdateViewer : bool) -> AIS_StatusOfPick: ...
    @overload
    def ShiftSelect(self,theXPMin : int,theYPMin : int,theXPMax : int,theYPMax : int,theView : OCP.V3d.V3d_View,theToUpdateViewer : bool) -> AIS_StatusOfPick: ...
    def Status(self,anObj : AIS_InteractiveObject,astatus : OCP.TCollection.TCollection_ExtendedString) -> None: 
        """
        Returns the status of the Interactive Context for the view of the Interactive Object.
        """
    def SubIntensityColor(self) -> OCP.Quantity.Quantity_Color: 
        """
        Sub-intensity allows temporary highlighting of particular objects with specified color in a manner of selection highlight, but without actual selection (e.g., global status and owner's selection state will not be updated). The method returns the color of such highlighting. By default, it is Quantity_NOC_GRAY40.
        """
    def SubIntensityOff(self,theIObj : AIS_InteractiveObject,theToUpdateViewer : bool) -> None: 
        """
        Removes the subintensity option for the entity. If a local context is open, the presentation of the Interactive Object activates the selection mode.
        """
    def SubIntensityOn(self,theIObj : AIS_InteractiveObject,theToUpdateViewer : bool) -> None: 
        """
        Highlights, and removes highlights from, the displayed object which is displayed at Neutral Point with subintensity color. Available only for active local context. There is no effect if there is no local context. If a local context is open, the presentation of the Interactive Object activates the selection mode.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def ToHilightSelected(self) -> bool: 
        """
        Return value specified whether selected object must be hilighted when mouse cursor is moved above it
        """
    def TrihedronSize(self) -> float: 
        """
        returns the current value of trihedron size.
        """
    def Unhilight(self,theIObj : AIS_InteractiveObject,theToUpdateViewer : bool) -> None: 
        """
        Removes hilighting from the Object.
        """
    def UnhilightCurrents(self,theToUpdateViewer : bool) -> None: 
        """
        Removes highlighting from current objects. Objects selected when there is no open local context are called current objects; those selected in open local context, selected objects.
        """
    def UnhilightSelected(self,theToUpdateViewer : bool) -> None: 
        """
        Removes highlighting from selected objects.
        """
    def UnsetColor(self,theIObj : AIS_InteractiveObject,theToUpdateViewer : bool) -> None: 
        """
        Removes the color selection for the selected entity.
        """
    def UnsetDisplayMode(self,theIObj : AIS_InteractiveObject,theToUpdateViewer : bool) -> None: 
        """
        Unsets the display mode of seen Interactive Objects.
        """
    def UnsetLocalAttributes(self,theIObj : AIS_InteractiveObject,theToUpdateViewer : bool) -> None: 
        """
        Removes the settings for local attributes of the Object and returns to defaults.
        """
    def UnsetMaterial(self,theIObj : AIS_InteractiveObject,theToUpdateViewer : bool) -> None: 
        """
        Removes the type of material setting for viewing the Object.
        """
    def UnsetTransparency(self,theIObj : AIS_InteractiveObject,theToUpdateViewer : bool) -> None: 
        """
        Removes the transparency settings for viewing the Object.
        """
    def UnsetWidth(self,theIObj : AIS_InteractiveObject,theToUpdateViewer : bool) -> None: 
        """
        Removes the width setting of the Object.
        """
    def Update(self,theIObj : AIS_InteractiveObject,theUpdateViewer : bool) -> None: 
        """
        Updates displayed interactive object by checking and recomputing its flagged as "to be recomputed" presentation and selection structures. This method does not force any recomputation on its own. The method recomputes selections even if they are loaded without activation in particular selector.
        """
    def UpdateCurrent(self) -> None: 
        """
        Updates the list of current objects, i.e. hilights new current objects, removes hilighting from former current objects. Objects selected when there is no open local context are called current objects; those selected in open local context, selected objects.
        """
    def UpdateCurrentViewer(self) -> None: 
        """
        Updates the current viewer.
        """
    def UpdateSelected(self,theToUpdateViewer : bool) -> None: 
        """
        Updates the list of selected objects: i.e. highlights the newly selected ones and unhighlights previously selected objects.
        """
    def Width(self,aniobj : AIS_InteractiveObject) -> float: 
        """
        Returns the width of the Interactive Object in the interactive context.
        """
    def __init__(self,MainViewer : OCP.V3d.V3d_Viewer) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class AIS_Axis(AIS_InteractiveObject, OCP.SelectMgr.SelectMgr_SelectableObject, OCP.PrsMgr.PrsMgr_PresentableObject, OCP.Standard.Standard_Transient):
    """
    Locates the x, y and z axes in an Interactive Object. These are used to orient it correctly in presentations from different viewpoints, or to construct a revolved shape, for example, from one of the axes. Conversely, an axis can be created to build a revolved shape and then situated relative to one of the axes of the view.Locates the x, y and z axes in an Interactive Object. These are used to orient it correctly in presentations from different viewpoints, or to construct a revolved shape, for example, from one of the axes. Conversely, an axis can be created to build a revolved shape and then situated relative to one of the axes of the view.
    """
    def AcceptDisplayMode(self,aMode : int) -> bool: 
        """
        Returns true if the interactive object accepts the display mode aMode.
        """
    def AcceptShapeDecomposition(self) -> bool: 
        """
        Informs the graphic context that the interactive Object may be decomposed into sub-shapes for dynamic selection. The most used Interactive Object is AIS_Shape.
        """
    def AddChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy.
        """
    def AddChildWithCurrentTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy with keeping the current global transformation So the object keeps the same position/orientation in the global CS.
        """
    def AddClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Adds clip plane for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def AddSelection(self,aSelection : OCP.SelectMgr.SelectMgr_Selection,aMode : int) -> None: 
        """
        Adds the selection aSelection with the selection mode index aMode to this framework.
        """
    def Attributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the attributes settings.
        """
    def Axis2Placement(self) -> OCP.Geom.Geom_Axis2Placement: 
        """
        Returns the position of axis2 and positions it by identifying it as the x, y, or z axis and giving its direction in 3D space. The coordinate system used is right-handed.
        """
    def BndBoxOfSelected(self,theOwners : Any) -> OCP.Bnd.Bnd_Box: 
        """
        Returns a bounding box of sensitive entities with the owners given if they are a part of activated selection
        """
    def BoundingBox(self,theBndBox : OCP.Bnd.Bnd_Box) -> None: 
        """
        Returns bounding box of object correspondingly to its current display mode. This method requires presentation to be already computed, since it relies on bounding box of presentation structures, which are supposed to be same/close amongst different display modes of this object.
        """
    def Children(self) -> OCP.PrsMgr.PrsMgr_ListOfPresentableObjects: 
        """
        Returns children of the current object.
        """
    def ClearDynamicHighlight(self,theMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> None: 
        """
        Method that needs to be implemented when the object manages selection and dynamic highlighting on its own. Clears or invalidates dynamic highlight presentation. By default it clears immediate draw of given presentation manager.
        """
    def ClearOwner(self) -> None: 
        """
        Each Interactive Object has methods which allow us to attribute an Owner to it in the form of a Transient. This method removes the owner from the graphic entity.
        """
    def ClearSelected(self) -> None: 
        """
        Method which clear all selected owners belonging to this selectable object ( for fast presentation draw )
        """
    def ClearSelections(self,update : bool=False) -> None: 
        """
        Empties all the selections in the SelectableObject <update> parameter defines whether all object's selections should be flagged for further update or not. This improved method can be used to recompute an object's selection (without redisplaying the object completely) when some selection mode is activated not for the first time.
        """
    def ClipPlanes(self) -> OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane: 
        """
        Get clip planes.
        """
    def Color(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Returns the color setting of the Interactive Object.
        """
    def CombinedParentTransformation(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return combined parent transformation.
        """
    def Component(self) -> OCP.Geom.Geom_Line: 
        """
        Returns the axis entity aComponent and identifies it as a component of a shape.
        """
    def ComputeSelection(self,theSelection : OCP.SelectMgr.SelectMgr_Selection,theMode : int) -> None: 
        """
        Computes sensitive primitives for the given selection mode - key interface method of Selectable Object.
        """
    def CurrentFacingModel(self) -> OCP.Aspect.Aspect_TypeOfFacingModel: 
        """
        Returns the current facing model which is in effect.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def DefaultDisplayMode(self) -> int: 
        """
        Returns the default display mode.
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DisplayMode(self) -> int: 
        """
        Returns the display mode setting of the Interactive Object. The range of supported display mode indexes should be specified within object definition and filtered by AccepDisplayMode().
        """
    def DisplayStatus(self) -> OCP.PrsMgr.PrsMgr_DisplayStatus: 
        """
        Return presentation display status; PrsMgr_DisplayStatus_None by default.
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicHilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalDynamic and Prs3d_TypeOfHighlight_Dynamic defined within AIS_InteractiveContext::HighlightStyle().
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def ErasePresentations(self,theToRemove : bool) -> None: 
        """
        Removes presentations returned by GetHilightPresentation() and GetSelectPresentation().
        """
    def GetAssemblyOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns common entity owner if the object is an assembly
        """
    def GetContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def GetHilightPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting detected object.
        """
    def GetOwner(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns the owner of the Interactive Object. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient. There are two types of owners: - Direct owners, decomposition shapes such as edges, wires, and faces. - Users, presentable objects connecting to sensitive primitives, or a shape which has been decomposed.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def GetSelectPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting selected object.
        """
    def GlobalSelOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns the owner of mode for selection of object as a whole
        """
    def GlobalSelectionMode(self) -> int: 
        """
        Returns the mode for selection of object as a whole; 0 by default.
        """
    def HasColor(self) -> bool: 
        """
        Returns true if the Interactive Object has color.
        """
    def HasDisplayMode(self) -> bool: 
        """
        Returns true if the Interactive Object has display mode setting overriding global setting (within Interactive Context).
        """
    def HasHilightMode(self) -> bool: 
        """
        Returns true if the Interactive Object is in highlight mode.
        """
    def HasInteractiveContext(self) -> bool: 
        """
        Indicates whether the Interactive Object has a pointer to an interactive context.
        """
    def HasMaterial(self) -> bool: 
        """
        Returns true if the Interactive Object has a setting for material.
        """
    def HasOwnPresentations(self) -> bool: 
        """
        Returns true if object should have own presentations.
        """
    def HasOwner(self) -> bool: 
        """
        Returns true if the object has an owner attributed to it. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient.
        """
    def HasPolygonOffsets(self) -> bool: 
        """
        Returns Standard_True if <myDrawer> has non-null shading aspect
        """
    def HasPresentation(self) -> bool: 
        """
        Returns TRUE when this object has a presentation in the current DisplayMode()
        """
    def HasSelection(self,theMode : int) -> bool: 
        """
        Returns true if a selection corresponding to the selection mode theMode was computed for this object.
        """
    def HasTransformation(self) -> bool: 
        """
        Returns true if object has a transformation that is different from the identity.
        """
    def HasWidth(self) -> bool: 
        """
        Returns true if the Interactive Object has width.
        """
    def HilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalSelected and Prs3d_TypeOfHighlight_Selected defined within AIS_InteractiveContext::HighlightStyle().
        """
    def HilightMode(self) -> int: 
        """
        Returns highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def HilightOwnerWithColor(self,thePM : OCP.PrsMgr.PrsMgr_PresentationManager,theStyle : OCP.Prs3d.Prs3d_Drawer,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner) -> None: 
        """
        Method which hilight an owner belonging to this selectable object ( for fast presentation draw )
        """
    def HilightSelected(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager,theSeq : OCP.SelectMgr.SelectMgr_SequenceOfOwner) -> None: 
        """
        Method which draws selected owners ( for fast presentation draw )
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def InteractiveContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def InversedTransformation(self) -> OCP.gp.gp_GTrsf: 
        """
        Return inversed transformation.
        """
    def IsAutoHilight(self) -> bool: 
        """
        If returns True, the old mechanism for highlighting selected objects is used (HilightSelected Method may be empty). If returns False, the HilightSelected method will be fully responsible for highlighting selected entity owners belonging to this selectable object.
        """
    def IsInfinite(self) -> bool: 
        """
        Returns true if the interactive object is infinite; FALSE by default. This flag affects various operations operating on bounding box of graphic presentations of this object. For instance, infinite objects are not taken in account for View FitAll. This does not necessarily means that object is actually infinite, auxiliary objects might be also marked with this flag to achieve desired behavior.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def IsMutable(self) -> bool: 
        """
        Returns true if object has mutable nature (content or location are be changed regularly). Mutable object will be managed in different way than static onces (another optimizations).
        """
    def IsTransparent(self) -> bool: 
        """
        Returns true if there is a transparency setting.
        """
    def IsXYZAxis(self) -> bool: 
        """
        Returns a signature of 2 for axis datums. When you activate mode 2 by a signature, you pick AIS objects of type AIS_Axis.
        """
    def LocalTransformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def LocalTransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def Material(self) -> OCP.Graphic3d.Graphic3d_NameOfMaterial: 
        """
        Returns the current material setting as enumeration value.
        """
    def Parent(self) -> OCP.PrsMgr.PrsMgr_PresentableObject: 
        """
        Returns parent of current object in scene hierarchy.
        """
    def PolygonOffsets(self,aFactor : float,aUnits : float) -> tuple[int]: 
        """
        Retrieves current polygon offsets settings from <myDrawer>.
        """
    def Presentation(self) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Returns the current presentation of this object according to the current DisplayMode()
        """
    def Presentations(self) -> OCP.PrsMgr.PrsMgr_Presentations: 
        """
        Return presentations.
        """
    def ProcessDragging(self,theCtx : AIS_InteractiveContext,theView : OCP.V3d.V3d_View,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theDragFrom : OCP.Graphic3d.Graphic3d_Vec2i,theDragTo : OCP.Graphic3d.Graphic3d_Vec2i,theAction : AIS_DragAction) -> bool: 
        """
        Drag object in the viewer.
        """
    @overload
    def RecomputePrimitives(self) -> None: 
        """
        Re-computes the sensitive primitives for all modes. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.

        Re-computes the sensitive primitives which correspond to the <theMode>th selection mode. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.
        """
    @overload
    def RecomputePrimitives(self,theMode : int) -> None: ...
    def Redisplay(self,AllModes : bool=False) -> None: 
        """
        Updates the active presentation; if <AllModes> = Standard_True all the presentations inside are recomputed. IMPORTANT: It is preferable to call Redisplay method of corresponding AIS_InteractiveContext instance for cases when it is accessible. This method just redirects call to myCTXPtr, so this class field must be up to date for proper result.
        """
    def RemoveChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy.
        """
    def RemoveChildWithRestoreTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy with keeping the current global transformation. So the object keeps the same position/orientation in the global CS.
        """
    def RemoveClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Removes previously added clip plane.
        """
    def ResetTransformation(self) -> None: 
        """
        None
        """
    def Selection(self,theMode : int) -> OCP.SelectMgr.SelectMgr_Selection: 
        """
        Returns the selection having specified selection mode or NULL.
        """
    def Selections(self) -> OCP.SelectMgr.SelectMgr_SequenceOfSelection: 
        """
        Return the sequence of selections.
        """
    def SetAspect(self,anAspect : OCP.Prs3d.Prs3d_BasicAspect) -> None: 
        """
        Sets the graphic basic aspect to the current presentation.
        """
    def SetAssemblyOwner(self,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theMode : int=-1) -> None: 
        """
        Sets common entity owner for assembly sensitive object entities
        """
    def SetAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the drawing tool theDrawer.
        """
    def SetAutoHilight(self,theAutoHilight : bool) -> None: 
        """
        Set AutoHilight property to true or false.
        """
    def SetAxis1Placement(self,anAxis : OCP.Geom.Geom_Axis1Placement) -> None: 
        """
        Constructs a new line to serve as the axis anAxis in 3D space.
        """
    def SetAxis2Placement(self,aComponent : OCP.Geom.Geom_Axis2Placement,anAxisType : AIS_TypeOfAxis) -> None: 
        """
        Allows you to provide settings for aComponent:the position and direction of an axis in 3D space. The coordinate system used is right-handed.
        """
    def SetClipPlanes(self,thePlanes : OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane) -> None: 
        """
        Set clip planes for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def SetColor(self,aColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        None
        """
    def SetComponent(self,aComponent : OCP.Geom.Geom_Line) -> None: 
        """
        Sets the coordinates of the lin aComponent.
        """
    def SetContext(self,aCtx : AIS_InteractiveContext) -> None: 
        """
        Sets the interactive context aCtx and provides a link to the default drawing tool or "Drawer" if there is none.
        """
    def SetCurrentFacingModel(self,theModel : OCP.Aspect.Aspect_TypeOfFacingModel=Aspect_TypeOfFacingModel.Aspect_TOFM_BOTH_SIDE) -> None: 
        """
        change the current facing model apply on polygons for SetColor(), SetTransparency(), SetMaterial() methods default facing model is Aspect_TOFM_TWO_SIDE. This mean that attributes is applying both on the front and back face.
        """
    def SetDisplayAspect(self,theNewDatumAspect : OCP.Prs3d.Prs3d_LineAspect) -> None: 
        """
        Set required visualization parameters.
        """
    def SetDisplayMode(self,theMode : int) -> None: 
        """
        Sets the display mode for the interactive object. An object can have its own temporary display mode, which is different from that proposed by the interactive context.
        """
    def SetDynamicHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the dynamic hilight drawing tool.
        """
    def SetHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the hilight drawing tool theDrawer.
        """
    def SetHilightMode(self,theMode : int) -> None: 
        """
        Sets highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def SetInfiniteState(self,theFlag : bool=True) -> None: 
        """
        Sets if object should be considered as infinite.
        """
    def SetIsoOnTriangulation(self,theIsEnabled : bool) -> None: 
        """
        Enables or disables on-triangulation build of isolines according to the flag given.
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.gp.gp_Trsf) -> None: 
        """
        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.

        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.TopLoc.TopLoc_Datum3D) -> None: ...
    def SetMaterial(self,aName : OCP.Graphic3d.Graphic3d_MaterialAspect) -> None: 
        """
        Sets the material aMat defining this display attribute for the interactive object. Material aspect determines shading aspect, color and transparency of visible entities.
        """
    def SetMutable(self,theIsMutable : bool) -> None: 
        """
        Sets if the object has mutable nature (content or location will be changed regularly). This method should be called before object displaying to take effect.
        """
    def SetOwner(self,theApplicativeEntity : OCP.Standard.Standard_Transient) -> None: 
        """
        Allows you to attribute the owner theApplicativeEntity to an Interactive Object. This can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of. The owner takes the form of a transient.
        """
    def SetPolygonOffsets(self,aMode : int,aFactor : float=1.0,aUnits : float=0.0) -> None: 
        """
        Sets up polygon offsets for this object.
        """
    def SetPropagateVisualState(self,theFlag : bool) -> None: 
        """
        Change the value of the flag "propagate visual state"
        """
    @overload
    def SetToUpdate(self) -> None: 
        """
        Flags presentation to be updated; UpdatePresentations() will recompute these presentations.

        flags all the Presentations to be Updated.
        """
    @overload
    def SetToUpdate(self,theMode : int) -> None: ...
    def SetTransformPersistence(self,theTrsfPers : OCP.Graphic3d.Graphic3d_TransformPers) -> None: 
        """
        Sets up Transform Persistence defining a special Local Coordinate system where this object should be located. Note that management of Transform Persistence object is more expensive than of the normal one, because it requires its position being recomputed basing on camera position within each draw call / traverse.
        """
    def SetTransparency(self,aValue : float=0.6) -> None: 
        """
        Attributes a setting aValue for transparency. The transparency value should be between 0.0 and 1.0. At 0.0 an object will be totally opaque, and at 1.0, fully transparent. Warning At a value of 1.0, there may be nothing visible.
        """
    def SetTypeOfAxis(self,theTypeAxis : AIS_TypeOfAxis) -> None: 
        """
        Constructs the entity theTypeAxis to stock information concerning type of axis.
        """
    def SetTypeOfPresentation(self,theType : OCP.PrsMgr.PrsMgr_TypeOfPresentation3d) -> None: 
        """
        Set type of presentation.
        """
    def SetWidth(self,aValue : float) -> None: 
        """
        None
        """
    def SetZLayer(self,theLayerId : int) -> None: 
        """
        Set Z layer ID and update all presentations of the selectable object. The layers mechanism allows drawing objects in higher layers in overlay of objects in lower layers.
        """
    def Signature(self) -> int: 
        """
        None
        """
    def SynchronizeAspects(self) -> None: 
        """
        Synchronize presentation aspects after their modification.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    @overload
    def ToBeUpdated(self,ListOfMode : OCP.TColStd.TColStd_ListOfInteger) -> None: 
        """
        Returns TRUE if any active presentation has invalidation flag.

        gives the list of modes which are flagged "to be updated".
        """
    @overload
    def ToBeUpdated(self,theToIncludeHidden : bool=False) -> bool: ...
    def ToPropagateVisualState(self) -> bool: 
        """
        Get value of the flag "propagate visual state" It means that the display/erase/color visual state is propagated automatically to all children; by default, the flag is true
        """
    def TransformPersistence(self) -> OCP.Graphic3d.Graphic3d_TransformPers: 
        """
        Returns Transformation Persistence defining a special Local Coordinate system where this presentable object is located or NULL handle if not defined. Position of the object having Transformation Persistence is mutable and depends on camera position. The same applies to a bounding box of the object.
        """
    def Transformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def TransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def Transparency(self) -> float: 
        """
        Returns the transparency setting. This will be between 0.0 and 1.0. At 0.0 an object will be totally opaque, and at 1.0, fully transparent.
        """
    def Type(self) -> AIS_KindOfInteractive: 
        """
        None
        """
    def TypeOfAxis(self) -> AIS_TypeOfAxis: 
        """
        Returns the type of axis.
        """
    def TypeOfPresentation3d(self) -> OCP.PrsMgr.PrsMgr_TypeOfPresentation3d: 
        """
        Returns information on whether the object accepts display in HLR mode or not.
        """
    def UnsetAttributes(self) -> None: 
        """
        Clears settings provided by the drawing tool aDrawer.
        """
    def UnsetColor(self) -> None: 
        """
        None
        """
    def UnsetDisplayMode(self) -> None: 
        """
        Removes display mode settings from the interactive object.
        """
    def UnsetHilightAttributes(self) -> None: 
        """
        Clears settings provided by the hilight drawing tool theDrawer.
        """
    def UnsetHilightMode(self) -> None: 
        """
        Unsets highlight display mode.
        """
    def UnsetMaterial(self) -> None: 
        """
        Removes the setting for material.
        """
    def UnsetTransparency(self) -> None: 
        """
        Removes the transparency setting. The object is opaque by default.
        """
    def UnsetWidth(self) -> None: 
        """
        None
        """
    def UpdateSelection(self,theMode : int=-1) -> None: 
        """
        Sets update status FULL to selections of the object. Must be used as the only method of UpdateSelection from outer classes to prevent BVH structures from being outdated.
        """
    def UpdateTransformation(self) -> None: 
        """
        Recomputes the location of the selection aSelection.
        """
    def UpdateTransformations(self,aSelection : OCP.SelectMgr.SelectMgr_Selection) -> None: 
        """
        Updates locations in all sensitive entities from <aSelection> and in corresponding entity owners.
        """
    def ViewAffinity(self) -> OCP.Graphic3d.Graphic3d_ViewAffinity: 
        """
        Return view affinity mask.
        """
    def Width(self) -> float: 
        """
        Returns the width setting of the Interactive Object.
        """
    def ZLayer(self) -> int: 
        """
        Get ID of Z layer for main presentation.
        """
    @overload
    def __init__(self,aComponent : OCP.Geom.Geom_Axis2Placement,anAxisType : AIS_TypeOfAxis) -> None: ...
    @overload
    def __init__(self,aComponent : OCP.Geom.Geom_Line) -> None: ...
    @overload
    def __init__(self,anAxis : OCP.Geom.Geom_Axis1Placement) -> None: ...
    @overload
    def __init__(self,theAxis : OCP.gp.gp_Ax1,theLength : float=-1.0) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class AIS_KindOfInteractive():
    """
    Declares the type of Interactive Object. This type can be used for fast pre-filtering of objects of specific group.

    Members:

      AIS_KindOfInteractive_None

      AIS_KindOfInteractive_Datum

      AIS_KindOfInteractive_Shape

      AIS_KindOfInteractive_Object

      AIS_KindOfInteractive_Relation

      AIS_KindOfInteractive_Dimension

      AIS_KindOfInteractive_LightSource

      AIS_KOI_None

      AIS_KOI_Datum

      AIS_KOI_Shape

      AIS_KOI_Object

      AIS_KOI_Relation

      AIS_KOI_Dimension
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    AIS_KOI_Datum: OCP.AIS.AIS_KindOfInteractive # value = <AIS_KindOfInteractive.AIS_KindOfInteractive_Datum: 1>
    AIS_KOI_Dimension: OCP.AIS.AIS_KindOfInteractive # value = <AIS_KindOfInteractive.AIS_KindOfInteractive_Dimension: 5>
    AIS_KOI_None: OCP.AIS.AIS_KindOfInteractive # value = <AIS_KindOfInteractive.AIS_KindOfInteractive_None: 0>
    AIS_KOI_Object: OCP.AIS.AIS_KindOfInteractive # value = <AIS_KindOfInteractive.AIS_KindOfInteractive_Object: 3>
    AIS_KOI_Relation: OCP.AIS.AIS_KindOfInteractive # value = <AIS_KindOfInteractive.AIS_KindOfInteractive_Relation: 4>
    AIS_KOI_Shape: OCP.AIS.AIS_KindOfInteractive # value = <AIS_KindOfInteractive.AIS_KindOfInteractive_Shape: 2>
    AIS_KindOfInteractive_Datum: OCP.AIS.AIS_KindOfInteractive # value = <AIS_KindOfInteractive.AIS_KindOfInteractive_Datum: 1>
    AIS_KindOfInteractive_Dimension: OCP.AIS.AIS_KindOfInteractive # value = <AIS_KindOfInteractive.AIS_KindOfInteractive_Dimension: 5>
    AIS_KindOfInteractive_LightSource: OCP.AIS.AIS_KindOfInteractive # value = <AIS_KindOfInteractive.AIS_KindOfInteractive_LightSource: 6>
    AIS_KindOfInteractive_None: OCP.AIS.AIS_KindOfInteractive # value = <AIS_KindOfInteractive.AIS_KindOfInteractive_None: 0>
    AIS_KindOfInteractive_Object: OCP.AIS.AIS_KindOfInteractive # value = <AIS_KindOfInteractive.AIS_KindOfInteractive_Object: 3>
    AIS_KindOfInteractive_Relation: OCP.AIS.AIS_KindOfInteractive # value = <AIS_KindOfInteractive.AIS_KindOfInteractive_Relation: 4>
    AIS_KindOfInteractive_Shape: OCP.AIS.AIS_KindOfInteractive # value = <AIS_KindOfInteractive.AIS_KindOfInteractive_Shape: 2>
    __entries: dict # value = {'AIS_KindOfInteractive_None': (<AIS_KindOfInteractive.AIS_KindOfInteractive_None: 0>, None), 'AIS_KindOfInteractive_Datum': (<AIS_KindOfInteractive.AIS_KindOfInteractive_Datum: 1>, None), 'AIS_KindOfInteractive_Shape': (<AIS_KindOfInteractive.AIS_KindOfInteractive_Shape: 2>, None), 'AIS_KindOfInteractive_Object': (<AIS_KindOfInteractive.AIS_KindOfInteractive_Object: 3>, None), 'AIS_KindOfInteractive_Relation': (<AIS_KindOfInteractive.AIS_KindOfInteractive_Relation: 4>, None), 'AIS_KindOfInteractive_Dimension': (<AIS_KindOfInteractive.AIS_KindOfInteractive_Dimension: 5>, None), 'AIS_KindOfInteractive_LightSource': (<AIS_KindOfInteractive.AIS_KindOfInteractive_LightSource: 6>, None), 'AIS_KOI_None': (<AIS_KindOfInteractive.AIS_KindOfInteractive_None: 0>, None), 'AIS_KOI_Datum': (<AIS_KindOfInteractive.AIS_KindOfInteractive_Datum: 1>, None), 'AIS_KOI_Shape': (<AIS_KindOfInteractive.AIS_KindOfInteractive_Shape: 2>, None), 'AIS_KOI_Object': (<AIS_KindOfInteractive.AIS_KindOfInteractive_Object: 3>, None), 'AIS_KOI_Relation': (<AIS_KindOfInteractive.AIS_KindOfInteractive_Relation: 4>, None), 'AIS_KOI_Dimension': (<AIS_KindOfInteractive.AIS_KindOfInteractive_Dimension: 5>, None)}
    __members__: dict # value = {'AIS_KindOfInteractive_None': <AIS_KindOfInteractive.AIS_KindOfInteractive_None: 0>, 'AIS_KindOfInteractive_Datum': <AIS_KindOfInteractive.AIS_KindOfInteractive_Datum: 1>, 'AIS_KindOfInteractive_Shape': <AIS_KindOfInteractive.AIS_KindOfInteractive_Shape: 2>, 'AIS_KindOfInteractive_Object': <AIS_KindOfInteractive.AIS_KindOfInteractive_Object: 3>, 'AIS_KindOfInteractive_Relation': <AIS_KindOfInteractive.AIS_KindOfInteractive_Relation: 4>, 'AIS_KindOfInteractive_Dimension': <AIS_KindOfInteractive.AIS_KindOfInteractive_Dimension: 5>, 'AIS_KindOfInteractive_LightSource': <AIS_KindOfInteractive.AIS_KindOfInteractive_LightSource: 6>, 'AIS_KOI_None': <AIS_KindOfInteractive.AIS_KindOfInteractive_None: 0>, 'AIS_KOI_Datum': <AIS_KindOfInteractive.AIS_KindOfInteractive_Datum: 1>, 'AIS_KOI_Shape': <AIS_KindOfInteractive.AIS_KindOfInteractive_Shape: 2>, 'AIS_KOI_Object': <AIS_KindOfInteractive.AIS_KindOfInteractive_Object: 3>, 'AIS_KOI_Relation': <AIS_KindOfInteractive.AIS_KindOfInteractive_Relation: 4>, 'AIS_KOI_Dimension': <AIS_KindOfInteractive.AIS_KindOfInteractive_Dimension: 5>}
    pass
class AIS_LightSource(AIS_InteractiveObject, OCP.SelectMgr.SelectMgr_SelectableObject, OCP.PrsMgr.PrsMgr_PresentableObject, OCP.Standard.Standard_Transient):
    """
    Interactive object for a light source. Each type of light source has it's own presentation: - Ambient light is displayed as a sphere at view corner; - Positional light is represented by a sphere or marker; - Spot light is represented by a cone; - Directional light is represented by a set of arrows at the corner of view. In addition, light source name could be displayed, and clicking on presentation will enable/disable light.
    """
    def AcceptDisplayMode(self,theMode : int) -> bool: 
        """
        Returns true if the class of objects accepts specified display mode index. The interactive context can have a default mode of representation for the set of Interactive Objects. This mode may not be accepted by a given class of objects. Consequently, this virtual method allowing us to get information about the class in question must be implemented. At least one display mode index should be accepted by this method. Although subclass can leave default implementation, it is highly desired defining exact list of supported modes instead, which is usually an enumeration for one object or objects class sharing similar list of display modes.
        """
    def AcceptShapeDecomposition(self) -> bool: 
        """
        Informs the graphic context that the interactive Object may be decomposed into sub-shapes for dynamic selection. The most used Interactive Object is AIS_Shape.
        """
    def AddChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy.
        """
    def AddChildWithCurrentTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy with keeping the current global transformation So the object keeps the same position/orientation in the global CS.
        """
    def AddClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Adds clip plane for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def AddSelection(self,aSelection : OCP.SelectMgr.SelectMgr_Selection,aMode : int) -> None: 
        """
        Adds the selection aSelection with the selection mode index aMode to this framework.
        """
    def ArcSize(self) -> int: 
        """
        Returns Sensitive sphere arc size in pixels; 20 by default.
        """
    def Attributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the attributes settings.
        """
    def BndBoxOfSelected(self,theOwners : Any) -> OCP.Bnd.Bnd_Box: 
        """
        Returns a bounding box of sensitive entities with the owners given if they are a part of activated selection
        """
    def BoundingBox(self,theBndBox : OCP.Bnd.Bnd_Box) -> None: 
        """
        Returns bounding box of object correspondingly to its current display mode. This method requires presentation to be already computed, since it relies on bounding box of presentation structures, which are supposed to be same/close amongst different display modes of this object.
        """
    def Children(self) -> OCP.PrsMgr.PrsMgr_ListOfPresentableObjects: 
        """
        Returns children of the current object.
        """
    def ClearDynamicHighlight(self,theMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> None: 
        """
        Method that needs to be implemented when the object manages selection and dynamic highlighting on its own. Clears or invalidates dynamic highlight presentation. By default it clears immediate draw of given presentation manager.
        """
    def ClearOwner(self) -> None: 
        """
        Each Interactive Object has methods which allow us to attribute an Owner to it in the form of a Transient. This method removes the owner from the graphic entity.
        """
    def ClearSelected(self) -> None: 
        """
        Method which clear all selected owners belonging to this selectable object ( for fast presentation draw )
        """
    def ClearSelections(self,update : bool=False) -> None: 
        """
        Empties all the selections in the SelectableObject <update> parameter defines whether all object's selections should be flagged for further update or not. This improved method can be used to recompute an object's selection (without redisplaying the object completely) when some selection mode is activated not for the first time.
        """
    def ClipPlanes(self) -> OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane: 
        """
        Get clip planes.
        """
    def Color(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Returns the color setting of the Interactive Object.
        """
    def CombinedParentTransformation(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return combined parent transformation.
        """
    def ComputeSelection(self,theSelection : OCP.SelectMgr.SelectMgr_Selection,theMode : int) -> None: 
        """
        Computes sensitive primitives for the given selection mode - key interface method of Selectable Object.
        """
    def CurrentFacingModel(self) -> OCP.Aspect.Aspect_TypeOfFacingModel: 
        """
        Returns the current facing model which is in effect.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def DefaultDisplayMode(self) -> int: 
        """
        Returns the default display mode.
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DisplayMode(self) -> int: 
        """
        Returns the display mode setting of the Interactive Object. The range of supported display mode indexes should be specified within object definition and filtered by AccepDisplayMode().
        """
    def DisplayStatus(self) -> OCP.PrsMgr.PrsMgr_DisplayStatus: 
        """
        Return presentation display status; PrsMgr_DisplayStatus_None by default.
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicHilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalDynamic and Prs3d_TypeOfHighlight_Dynamic defined within AIS_InteractiveContext::HighlightStyle().
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def ErasePresentations(self,theToRemove : bool) -> None: 
        """
        Removes presentations returned by GetHilightPresentation() and GetSelectPresentation().
        """
    def GetAssemblyOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns common entity owner if the object is an assembly
        """
    def GetContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def GetHilightPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting detected object.
        """
    def GetOwner(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns the owner of the Interactive Object. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient. There are two types of owners: - Direct owners, decomposition shapes such as edges, wires, and faces. - Users, presentable objects connecting to sensitive primitives, or a shape which has been decomposed.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def GetSelectPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting selected object.
        """
    def GlobalSelOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns the owner of mode for selection of object as a whole
        """
    def GlobalSelectionMode(self) -> int: 
        """
        Returns the mode for selection of object as a whole; 0 by default.
        """
    def HasColor(self) -> bool: 
        """
        Returns true if the Interactive Object has color.
        """
    def HasDisplayMode(self) -> bool: 
        """
        Returns true if the Interactive Object has display mode setting overriding global setting (within Interactive Context).
        """
    def HasHilightMode(self) -> bool: 
        """
        Returns true if the Interactive Object is in highlight mode.
        """
    def HasInteractiveContext(self) -> bool: 
        """
        Indicates whether the Interactive Object has a pointer to an interactive context.
        """
    def HasMaterial(self) -> bool: 
        """
        Returns true if the Interactive Object has a setting for material.
        """
    def HasOwnPresentations(self) -> bool: 
        """
        Returns true if object should have own presentations.
        """
    def HasOwner(self) -> bool: 
        """
        Returns true if the object has an owner attributed to it. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient.
        """
    def HasPolygonOffsets(self) -> bool: 
        """
        Returns Standard_True if <myDrawer> has non-null shading aspect
        """
    def HasPresentation(self) -> bool: 
        """
        Returns TRUE when this object has a presentation in the current DisplayMode()
        """
    def HasSelection(self,theMode : int) -> bool: 
        """
        Returns true if a selection corresponding to the selection mode theMode was computed for this object.
        """
    def HasTransformation(self) -> bool: 
        """
        Returns true if object has a transformation that is different from the identity.
        """
    def HasWidth(self) -> bool: 
        """
        Returns true if the Interactive Object has width.
        """
    def HilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalSelected and Prs3d_TypeOfHighlight_Selected defined within AIS_InteractiveContext::HighlightStyle().
        """
    def HilightMode(self) -> int: 
        """
        Returns highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def HilightOwnerWithColor(self,thePM : OCP.PrsMgr.PrsMgr_PresentationManager,theStyle : OCP.Prs3d.Prs3d_Drawer,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner) -> None: 
        """
        Method which hilight an owner belonging to this selectable object ( for fast presentation draw )
        """
    def HilightSelected(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager,theSeq : OCP.SelectMgr.SelectMgr_SequenceOfOwner) -> None: 
        """
        Method which draws selected owners ( for fast presentation draw )
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def InteractiveContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def InversedTransformation(self) -> OCP.gp.gp_GTrsf: 
        """
        Return inversed transformation.
        """
    def IsAutoHilight(self) -> bool: 
        """
        If returns True, the old mechanism for highlighting selected objects is used (HilightSelected Method may be empty). If returns False, the HilightSelected method will be fully responsible for highlighting selected entity owners belonging to this selectable object.
        """
    def IsInfinite(self) -> bool: 
        """
        Returns true if the interactive object is infinite; FALSE by default. This flag affects various operations operating on bounding box of graphic presentations of this object. For instance, infinite objects are not taken in account for View FitAll. This does not necessarily means that object is actually infinite, auxiliary objects might be also marked with this flag to achieve desired behavior.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def IsMutable(self) -> bool: 
        """
        Returns true if object has mutable nature (content or location are be changed regularly). Mutable object will be managed in different way than static onces (another optimizations).
        """
    def IsTransparent(self) -> bool: 
        """
        Returns true if there is a transparency setting.
        """
    def IsZoomable(self) -> bool: 
        """
        Returns TRUE if transform-persistence is allowed; TRUE by default for Ambient and Directional lights and FALSE by default for Positional and Spot lights.
        """
    def Light(self) -> OCP.Graphic3d.Graphic3d_CLight: 
        """
        Returns the light.
        """
    def LocalTransformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def LocalTransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def MarkerImage(self,theIsEnabled : bool) -> OCP.Graphic3d.Graphic3d_MarkerImage: 
        """
        Returns light source icon.
        """
    def MarkerType(self,theIsEnabled : bool) -> OCP.Aspect.Aspect_TypeOfMarker: 
        """
        Returns light source icon.
        """
    def Material(self) -> OCP.Graphic3d.Graphic3d_NameOfMaterial: 
        """
        Returns the current material setting as enumeration value.
        """
    def NbArrows(self) -> int: 
        """
        Returns a number of directional light arrows to display; 5 by default.
        """
    def NbSplitsArrow(self) -> int: 
        """
        Returns tessellation level for arrows; 20 by default.
        """
    def NbSplitsQuadric(self) -> int: 
        """
        Returns tessellation level for quadric surfaces; 30 by default.
        """
    def Parent(self) -> OCP.PrsMgr.PrsMgr_PresentableObject: 
        """
        Returns parent of current object in scene hierarchy.
        """
    def PolygonOffsets(self,aFactor : float,aUnits : float) -> tuple[int]: 
        """
        Retrieves current polygon offsets settings from <myDrawer>.
        """
    def Presentation(self) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Returns the current presentation of this object according to the current DisplayMode()
        """
    def Presentations(self) -> OCP.PrsMgr.PrsMgr_Presentations: 
        """
        Return presentations.
        """
    def ProcessDragging(self,theCtx : AIS_InteractiveContext,theView : OCP.V3d.V3d_View,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theDragFrom : OCP.Graphic3d.Graphic3d_Vec2i,theDragTo : OCP.Graphic3d.Graphic3d_Vec2i,theAction : AIS_DragAction) -> bool: 
        """
        Drag object in the viewer.
        """
    @overload
    def RecomputePrimitives(self) -> None: 
        """
        Re-computes the sensitive primitives for all modes. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.

        Re-computes the sensitive primitives which correspond to the <theMode>th selection mode. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.
        """
    @overload
    def RecomputePrimitives(self,theMode : int) -> None: ...
    def Redisplay(self,AllModes : bool=False) -> None: 
        """
        Updates the active presentation; if <AllModes> = Standard_True all the presentations inside are recomputed. IMPORTANT: It is preferable to call Redisplay method of corresponding AIS_InteractiveContext instance for cases when it is accessible. This method just redirects call to myCTXPtr, so this class field must be up to date for proper result.
        """
    def RemoveChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy.
        """
    def RemoveChildWithRestoreTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy with keeping the current global transformation. So the object keeps the same position/orientation in the global CS.
        """
    def RemoveClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Removes previously added clip plane.
        """
    def ResetTransformation(self) -> None: 
        """
        None
        """
    def Selection(self,theMode : int) -> OCP.SelectMgr.SelectMgr_Selection: 
        """
        Returns the selection having specified selection mode or NULL.
        """
    def Selections(self) -> OCP.SelectMgr.SelectMgr_SequenceOfSelection: 
        """
        Return the sequence of selections.
        """
    def SetArcSize(self,theSize : int) -> None: 
        """
        Sets the size of sensitive sphere arc.
        """
    def SetAspect(self,anAspect : OCP.Prs3d.Prs3d_BasicAspect) -> None: 
        """
        Sets the graphic basic aspect to the current presentation.
        """
    def SetAssemblyOwner(self,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theMode : int=-1) -> None: 
        """
        Sets common entity owner for assembly sensitive object entities
        """
    def SetAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the drawing tool theDrawer.
        """
    def SetAutoHilight(self,theAutoHilight : bool) -> None: 
        """
        Set AutoHilight property to true or false.
        """
    def SetClipPlanes(self,thePlanes : OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane) -> None: 
        """
        Set clip planes for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def SetColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Only the interactive object knowns which Drawer attribute is affected by the color, if any (ex: for a wire,it's the wireaspect field of the drawer, but for a vertex, only the point aspect field is affected by the color). WARNING : Do not forget to set the corresponding fields here (hasOwnColor and myDrawer->SetColor())
        """
    def SetContext(self,aCtx : AIS_InteractiveContext) -> None: 
        """
        Sets the interactive context aCtx and provides a link to the default drawing tool or "Drawer" if there is none.
        """
    def SetCurrentFacingModel(self,theModel : OCP.Aspect.Aspect_TypeOfFacingModel=Aspect_TypeOfFacingModel.Aspect_TOFM_BOTH_SIDE) -> None: 
        """
        change the current facing model apply on polygons for SetColor(), SetTransparency(), SetMaterial() methods default facing model is Aspect_TOFM_TWO_SIDE. This mean that attributes is applying both on the front and back face.
        """
    def SetDisplayMode(self,theMode : int) -> None: 
        """
        Sets the display mode for the interactive object. An object can have its own temporary display mode, which is different from that proposed by the interactive context.
        """
    def SetDisplayName(self,theToDisplay : bool) -> None: 
        """
        Show/hide light source name.
        """
    def SetDisplayRange(self,theToDisplay : bool) -> None: 
        """
        Show/hide light source range shaded presentation.
        """
    def SetDraggable(self,theIsDraggable : bool) -> None: 
        """
        Sets if dragging is allowed.
        """
    def SetDynamicHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the dynamic hilight drawing tool.
        """
    def SetHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the hilight drawing tool theDrawer.
        """
    def SetHilightMode(self,theMode : int) -> None: 
        """
        Sets highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def SetInfiniteState(self,theFlag : bool=True) -> None: 
        """
        Sets if object should be considered as infinite.
        """
    def SetIsoOnTriangulation(self,theIsEnabled : bool) -> None: 
        """
        Enables or disables on-triangulation build of isolines according to the flag given.
        """
    def SetLight(self,theLight : OCP.Graphic3d.Graphic3d_CLight) -> None: 
        """
        Set the light.
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.gp.gp_Trsf) -> None: 
        """
        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.

        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.TopLoc.TopLoc_Datum3D) -> None: ...
    def SetMarkerImage(self,theImage : OCP.Graphic3d.Graphic3d_MarkerImage,theIsEnabled : bool) -> None: 
        """
        Sets custom icon to light source.
        """
    def SetMarkerType(self,theType : OCP.Aspect.Aspect_TypeOfMarker,theIsEnabled : bool) -> None: 
        """
        Sets standard icon to light source.
        """
    def SetMaterial(self,aName : OCP.Graphic3d.Graphic3d_MaterialAspect) -> None: 
        """
        Sets the material aMat defining this display attribute for the interactive object. Material aspect determines shading aspect, color and transparency of visible entities.
        """
    def SetMutable(self,theIsMutable : bool) -> None: 
        """
        Sets if the object has mutable nature (content or location will be changed regularly). This method should be called before object displaying to take effect.
        """
    def SetNbArrows(self,theNbArrows : int) -> None: 
        """
        Returns a number of directional light arrows to display (supported values: 1, 3, 5, 9).
        """
    def SetNbSplitsArrow(self,theNbSplits : int) -> None: 
        """
        Sets tessellation level for arrows.
        """
    def SetNbSplitsQuadric(self,theNbSplits : int) -> None: 
        """
        Sets tessellation level for quadric surfaces.
        """
    def SetOwner(self,theApplicativeEntity : OCP.Standard.Standard_Transient) -> None: 
        """
        Allows you to attribute the owner theApplicativeEntity to an Interactive Object. This can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of. The owner takes the form of a transient.
        """
    def SetPolygonOffsets(self,aMode : int,aFactor : float=1.0,aUnits : float=0.0) -> None: 
        """
        Sets up polygon offsets for this object.
        """
    def SetPropagateVisualState(self,theFlag : bool) -> None: 
        """
        Change the value of the flag "propagate visual state"
        """
    def SetSize(self,theSize : float) -> None: 
        """
        Sets the size of presentation.
        """
    def SetSwitchOnClick(self,theToHandle : bool) -> None: 
        """
        Sets if mouse click should turn light on/off.
        """
    @overload
    def SetToUpdate(self) -> None: 
        """
        Flags presentation to be updated; UpdatePresentations() will recompute these presentations.

        flags all the Presentations to be Updated.
        """
    @overload
    def SetToUpdate(self,theMode : int) -> None: ...
    def SetTransformPersistence(self,theTrsfPers : OCP.Graphic3d.Graphic3d_TransformPers) -> None: 
        """
        Sets up Transform Persistence defining a special Local Coordinate system where this object should be located. Note that management of Transform Persistence object is more expensive than of the normal one, because it requires its position being recomputed basing on camera position within each draw call / traverse.
        """
    def SetTransparency(self,aValue : float=0.6) -> None: 
        """
        Attributes a setting aValue for transparency. The transparency value should be between 0.0 and 1.0. At 0.0 an object will be totally opaque, and at 1.0, fully transparent. Warning At a value of 1.0, there may be nothing visible.
        """
    def SetTypeOfPresentation(self,theType : OCP.PrsMgr.PrsMgr_TypeOfPresentation3d) -> None: 
        """
        Set type of presentation.
        """
    def SetWidth(self,theWidth : float) -> None: 
        """
        Allows you to provide the setting aValue for width. Only the Interactive Object knows which Drawer attribute is affected by the width setting.
        """
    def SetZLayer(self,theLayerId : int) -> None: 
        """
        Set Z layer ID and update all presentations of the selectable object. The layers mechanism allows drawing objects in higher layers in overlay of objects in lower layers.
        """
    def SetZoomable(self,theIsZoomable : bool) -> None: 
        """
        Sets if transform-persistence is allowed.
        """
    def Signature(self) -> int: 
        """
        Specifies additional characteristics of Interactive Object of Type(); -1 by default. Among the datums, this signature is attributed to the shape. The remaining datums have the following default signatures: - Point signature 1 - Axis signature 2 - Trihedron signature 3 - PlaneTrihedron signature 4 - Line signature 5 - Circle signature 6 - Plane signature 7.
        """
    def Size(self) -> float: 
        """
        Returns the size of presentation; 50 by default.
        """
    def SynchronizeAspects(self) -> None: 
        """
        Synchronize presentation aspects after their modification.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    @overload
    def ToBeUpdated(self,ListOfMode : OCP.TColStd.TColStd_ListOfInteger) -> None: 
        """
        Returns TRUE if any active presentation has invalidation flag.

        gives the list of modes which are flagged "to be updated".
        """
    @overload
    def ToBeUpdated(self,theToIncludeHidden : bool=False) -> bool: ...
    def ToDisplayName(self) -> bool: 
        """
        Returns TRUE if the light source name should be displayed; TRUE by default.
        """
    def ToDisplayRange(self) -> bool: 
        """
        Returns TRUE to display light source range as sphere (positional light) or cone (spot light); TRUE by default. Has no effect for non-zoomable presentation.
        """
    def ToPropagateVisualState(self) -> bool: 
        """
        Get value of the flag "propagate visual state" It means that the display/erase/color visual state is propagated automatically to all children; by default, the flag is true
        """
    def ToSwitchOnClick(self) -> bool: 
        """
        Returns TRUE if mouse click will turn light on/off; TRUE by default.
        """
    def TransformPersistence(self) -> OCP.Graphic3d.Graphic3d_TransformPers: 
        """
        Returns Transformation Persistence defining a special Local Coordinate system where this presentable object is located or NULL handle if not defined. Position of the object having Transformation Persistence is mutable and depends on camera position. The same applies to a bounding box of the object.
        """
    def Transformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def TransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def Transparency(self) -> float: 
        """
        Returns the transparency setting. This will be between 0.0 and 1.0. At 0.0 an object will be totally opaque, and at 1.0, fully transparent.
        """
    def Type(self) -> AIS_KindOfInteractive: 
        """
        Returns kind of the object.
        """
    def TypeOfPresentation3d(self) -> OCP.PrsMgr.PrsMgr_TypeOfPresentation3d: 
        """
        Returns information on whether the object accepts display in HLR mode or not.
        """
    def UnsetAttributes(self) -> None: 
        """
        Clears settings provided by the drawing tool aDrawer.
        """
    def UnsetColor(self) -> None: 
        """
        Removes color settings. Only the Interactive Object knows which Drawer attribute is affected by the color setting. For a wire, for example, wire aspect is the attribute affected. For a vertex, however, only point aspect is affected by the color setting.
        """
    def UnsetDisplayMode(self) -> None: 
        """
        Removes display mode settings from the interactive object.
        """
    def UnsetHilightAttributes(self) -> None: 
        """
        Clears settings provided by the hilight drawing tool theDrawer.
        """
    def UnsetHilightMode(self) -> None: 
        """
        Unsets highlight display mode.
        """
    def UnsetMaterial(self) -> None: 
        """
        Removes the setting for material.
        """
    def UnsetTransparency(self) -> None: 
        """
        Removes the transparency setting. The object is opaque by default.
        """
    def UnsetWidth(self) -> None: 
        """
        Reset width to default value.
        """
    def UpdateSelection(self,theMode : int=-1) -> None: 
        """
        Sets update status FULL to selections of the object. Must be used as the only method of UpdateSelection from outer classes to prevent BVH structures from being outdated.
        """
    def UpdateTransformation(self) -> None: 
        """
        Recomputes the location of the selection aSelection.
        """
    def UpdateTransformations(self,aSelection : OCP.SelectMgr.SelectMgr_Selection) -> None: 
        """
        Updates locations in all sensitive entities from <aSelection> and in corresponding entity owners.
        """
    def ViewAffinity(self) -> OCP.Graphic3d.Graphic3d_ViewAffinity: 
        """
        Return view affinity mask.
        """
    def Width(self) -> float: 
        """
        Returns the width setting of the Interactive Object.
        """
    def ZLayer(self) -> int: 
        """
        Get ID of Z layer for main presentation.
        """
    def __init__(self,theLightSource : OCP.Graphic3d.Graphic3d_CLight) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class AIS_LightSourceOwner(OCP.SelectMgr.SelectMgr_EntityOwner, OCP.Standard.Standard_Transient):
    """
    Owner of AIS_LightSource presentation.
    """
    def Clear(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager,theMode : int=0) -> None: 
        """
        Clears the owners matching the value of the selection mode aMode from the presentation manager object aPM.
        """
    def ComesFromDecomposition(self) -> bool: 
        """
        Returns TRUE if this owner points to a part of object and FALSE for entire object.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HandleMouseClick(self,thePoint : OCP.Graphic3d.Graphic3d_Vec2i,theButton : int,theModifiers : int,theIsDoubleClick : bool) -> bool: 
        """
        Handle mouse button click event.
        """
    def HasLocation(self) -> bool: 
        """
        Returns TRUE if selectable has transformation.
        """
    def HasSelectable(self) -> bool: 
        """
        Returns true if there is a selectable object to serve as an owner.
        """
    def HilightWithColor(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager,theStyle : OCP.Prs3d.Prs3d_Drawer,theMode : int) -> None: 
        """
        Highlights selectable object's presentation with display mode in presentation manager with given highlight style. Also a check for auto-highlight is performed - if selectable object manages highlighting on its own, execution will be passed to SelectMgr_SelectableObject::HilightOwnerWithColor method.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def IsAutoHilight(self) -> bool: 
        """
        if owner is not auto hilighted, for group contains many such owners will be called one method HilightSelected of SelectableObject
        """
    def IsForcedHilight(self) -> bool: 
        """
        Always update dynamic highlighting.
        """
    def IsHilighted(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager,theMode : int=0) -> bool: 
        """
        Returns true if the presentation manager highlights selections corresponding to the selection mode.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def IsSameSelectable(self,theOther : OCP.SelectMgr.SelectMgr_SelectableObject) -> bool: 
        """
        Returns true if pointer to selectable object of this owner is equal to the given one
        """
    def IsSelected(self) -> bool: 
        """
        Returns Standard_True if the owner is selected.
        """
    def Location(self) -> OCP.TopLoc.TopLoc_Location: 
        """
        Returns transformation of selectable.
        """
    def Priority(self) -> int: 
        """
        Return selection priority (within range [0-9]) for results with the same depth; 0 by default. Example - selection of shapes: the owners are selectable objects (presentations) a user can give vertex priority [3], edges [2] faces [1] shape [0], so that if during selection one vertex one edge and one face are simultaneously detected, the vertex will only be hilighted.
        """
    def Select(self,theSelScheme : AIS_SelectionScheme,theIsDetected : bool) -> bool: 
        """
        If the object needs to be selected, it returns true.
        """
    def Selectable(self) -> OCP.SelectMgr.SelectMgr_SelectableObject: 
        """
        Returns a selectable object detected in the working context.
        """
    @overload
    def Set(self,theSelObj : OCP.SelectMgr.SelectMgr_SelectableObject) -> None: 
        """
        Sets the selectable object.

        sets the selectable priority of the owner
        """
    @overload
    def Set(self,thePriority : int) -> None: ...
    def SetComesFromDecomposition(self,theIsFromDecomposition : bool) -> None: 
        """
        Sets flag indicating this owner points to a part of object (TRUE) or to entire object (FALSE).
        """
    def SetLocation(self,theLocation : OCP.TopLoc.TopLoc_Location) -> None: 
        """
        Change owner location (callback for handling change of location of selectable object).
        """
    def SetPriority(self,thePriority : int) -> None: 
        """
        Sets the selectable priority of the owner within range [0-9].
        """
    def SetSelectable(self,theSelObj : OCP.SelectMgr.SelectMgr_SelectableObject) -> None: 
        """
        Sets the selectable object.
        """
    def SetSelected(self,theIsSelected : bool) -> None: 
        """
        Set the state of the owner.
        """
    def SetZLayer(self,theLayerId : int) -> None: 
        """
        Set Z layer ID and update all presentations.
        """
    @overload
    def State(self) -> int: 
        """
        Returns selection state.

        Set the state of the owner. The method is deprecated. Use SetSelected() instead.
        """
    @overload
    def State(self,theStatus : int) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Unhilight(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager,theMode : int=0) -> None: 
        """
        Removes highlighting from the owner of a detected selectable object in the presentation manager. This object could be the owner of a sensitive primitive.
        """
    def UpdateHighlightTrsf(self,theViewer : OCP.V3d.V3d_Viewer,theManager : OCP.PrsMgr.PrsMgr_PresentationManager,theDispMode : int) -> None: 
        """
        Implements immediate application of location transformation of parent object to dynamic highlight structure
        """
    def __init__(self,theObject : AIS_LightSource,thePriority : int=5) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class AIS_Line(AIS_InteractiveObject, OCP.SelectMgr.SelectMgr_SelectableObject, OCP.PrsMgr.PrsMgr_PresentableObject, OCP.Standard.Standard_Transient):
    """
    Constructs line datums to be used in construction of composite shapes.Constructs line datums to be used in construction of composite shapes.
    """
    def AcceptDisplayMode(self,theMode : int) -> bool: 
        """
        Returns true if the class of objects accepts specified display mode index. The interactive context can have a default mode of representation for the set of Interactive Objects. This mode may not be accepted by a given class of objects. Consequently, this virtual method allowing us to get information about the class in question must be implemented. At least one display mode index should be accepted by this method. Although subclass can leave default implementation, it is highly desired defining exact list of supported modes instead, which is usually an enumeration for one object or objects class sharing similar list of display modes.
        """
    def AcceptShapeDecomposition(self) -> bool: 
        """
        Informs the graphic context that the interactive Object may be decomposed into sub-shapes for dynamic selection. The most used Interactive Object is AIS_Shape.
        """
    def AddChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy.
        """
    def AddChildWithCurrentTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy with keeping the current global transformation So the object keeps the same position/orientation in the global CS.
        """
    def AddClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Adds clip plane for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def AddSelection(self,aSelection : OCP.SelectMgr.SelectMgr_Selection,aMode : int) -> None: 
        """
        Adds the selection aSelection with the selection mode index aMode to this framework.
        """
    def Attributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the attributes settings.
        """
    def BndBoxOfSelected(self,theOwners : Any) -> OCP.Bnd.Bnd_Box: 
        """
        Returns a bounding box of sensitive entities with the owners given if they are a part of activated selection
        """
    def BoundingBox(self,theBndBox : OCP.Bnd.Bnd_Box) -> None: 
        """
        Returns bounding box of object correspondingly to its current display mode. This method requires presentation to be already computed, since it relies on bounding box of presentation structures, which are supposed to be same/close amongst different display modes of this object.
        """
    def Children(self) -> OCP.PrsMgr.PrsMgr_ListOfPresentableObjects: 
        """
        Returns children of the current object.
        """
    def ClearDynamicHighlight(self,theMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> None: 
        """
        Method that needs to be implemented when the object manages selection and dynamic highlighting on its own. Clears or invalidates dynamic highlight presentation. By default it clears immediate draw of given presentation manager.
        """
    def ClearOwner(self) -> None: 
        """
        Each Interactive Object has methods which allow us to attribute an Owner to it in the form of a Transient. This method removes the owner from the graphic entity.
        """
    def ClearSelected(self) -> None: 
        """
        Method which clear all selected owners belonging to this selectable object ( for fast presentation draw )
        """
    def ClearSelections(self,update : bool=False) -> None: 
        """
        Empties all the selections in the SelectableObject <update> parameter defines whether all object's selections should be flagged for further update or not. This improved method can be used to recompute an object's selection (without redisplaying the object completely) when some selection mode is activated not for the first time.
        """
    def ClipPlanes(self) -> OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane: 
        """
        Get clip planes.
        """
    def Color(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Returns the color setting of the Interactive Object.
        """
    def CombinedParentTransformation(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return combined parent transformation.
        """
    def ComputeSelection(self,theSelection : OCP.SelectMgr.SelectMgr_Selection,theMode : int) -> None: 
        """
        Computes sensitive primitives for the given selection mode - key interface method of Selectable Object.
        """
    def CurrentFacingModel(self) -> OCP.Aspect.Aspect_TypeOfFacingModel: 
        """
        Returns the current facing model which is in effect.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def DefaultDisplayMode(self) -> int: 
        """
        Returns the default display mode.
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DisplayMode(self) -> int: 
        """
        Returns the display mode setting of the Interactive Object. The range of supported display mode indexes should be specified within object definition and filtered by AccepDisplayMode().
        """
    def DisplayStatus(self) -> OCP.PrsMgr.PrsMgr_DisplayStatus: 
        """
        Return presentation display status; PrsMgr_DisplayStatus_None by default.
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicHilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalDynamic and Prs3d_TypeOfHighlight_Dynamic defined within AIS_InteractiveContext::HighlightStyle().
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def ErasePresentations(self,theToRemove : bool) -> None: 
        """
        Removes presentations returned by GetHilightPresentation() and GetSelectPresentation().
        """
    def GetAssemblyOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns common entity owner if the object is an assembly
        """
    def GetContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def GetHilightPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting detected object.
        """
    def GetOwner(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns the owner of the Interactive Object. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient. There are two types of owners: - Direct owners, decomposition shapes such as edges, wires, and faces. - Users, presentable objects connecting to sensitive primitives, or a shape which has been decomposed.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def GetSelectPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting selected object.
        """
    def GlobalSelOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns the owner of mode for selection of object as a whole
        """
    def GlobalSelectionMode(self) -> int: 
        """
        Returns the mode for selection of object as a whole; 0 by default.
        """
    def HasColor(self) -> bool: 
        """
        Returns true if the Interactive Object has color.
        """
    def HasDisplayMode(self) -> bool: 
        """
        Returns true if the Interactive Object has display mode setting overriding global setting (within Interactive Context).
        """
    def HasHilightMode(self) -> bool: 
        """
        Returns true if the Interactive Object is in highlight mode.
        """
    def HasInteractiveContext(self) -> bool: 
        """
        Indicates whether the Interactive Object has a pointer to an interactive context.
        """
    def HasMaterial(self) -> bool: 
        """
        Returns true if the Interactive Object has a setting for material.
        """
    def HasOwnPresentations(self) -> bool: 
        """
        Returns true if object should have own presentations.
        """
    def HasOwner(self) -> bool: 
        """
        Returns true if the object has an owner attributed to it. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient.
        """
    def HasPolygonOffsets(self) -> bool: 
        """
        Returns Standard_True if <myDrawer> has non-null shading aspect
        """
    def HasPresentation(self) -> bool: 
        """
        Returns TRUE when this object has a presentation in the current DisplayMode()
        """
    def HasSelection(self,theMode : int) -> bool: 
        """
        Returns true if a selection corresponding to the selection mode theMode was computed for this object.
        """
    def HasTransformation(self) -> bool: 
        """
        Returns true if object has a transformation that is different from the identity.
        """
    def HasWidth(self) -> bool: 
        """
        Returns true if the Interactive Object has width.
        """
    def HilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalSelected and Prs3d_TypeOfHighlight_Selected defined within AIS_InteractiveContext::HighlightStyle().
        """
    def HilightMode(self) -> int: 
        """
        Returns highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def HilightOwnerWithColor(self,thePM : OCP.PrsMgr.PrsMgr_PresentationManager,theStyle : OCP.Prs3d.Prs3d_Drawer,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner) -> None: 
        """
        Method which hilight an owner belonging to this selectable object ( for fast presentation draw )
        """
    def HilightSelected(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager,theSeq : OCP.SelectMgr.SelectMgr_SequenceOfOwner) -> None: 
        """
        Method which draws selected owners ( for fast presentation draw )
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def InteractiveContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def InversedTransformation(self) -> OCP.gp.gp_GTrsf: 
        """
        Return inversed transformation.
        """
    def IsAutoHilight(self) -> bool: 
        """
        If returns True, the old mechanism for highlighting selected objects is used (HilightSelected Method may be empty). If returns False, the HilightSelected method will be fully responsible for highlighting selected entity owners belonging to this selectable object.
        """
    def IsInfinite(self) -> bool: 
        """
        Returns true if the interactive object is infinite; FALSE by default. This flag affects various operations operating on bounding box of graphic presentations of this object. For instance, infinite objects are not taken in account for View FitAll. This does not necessarily means that object is actually infinite, auxiliary objects might be also marked with this flag to achieve desired behavior.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def IsMutable(self) -> bool: 
        """
        Returns true if object has mutable nature (content or location are be changed regularly). Mutable object will be managed in different way than static onces (another optimizations).
        """
    def IsTransparent(self) -> bool: 
        """
        Returns true if there is a transparency setting.
        """
    def Line(self) -> OCP.Geom.Geom_Line: 
        """
        Constructs an infinite line.
        """
    def LocalTransformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def LocalTransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def Material(self) -> OCP.Graphic3d.Graphic3d_NameOfMaterial: 
        """
        Returns the current material setting as enumeration value.
        """
    def Parent(self) -> OCP.PrsMgr.PrsMgr_PresentableObject: 
        """
        Returns parent of current object in scene hierarchy.
        """
    def Points(self,thePStart : OCP.Geom.Geom_Point,thePEnd : OCP.Geom.Geom_Point) -> Any: 
        """
        Returns the starting point thePStart and the end point thePEnd of the line set by SetPoints.
        """
    def PolygonOffsets(self,aFactor : float,aUnits : float) -> tuple[int]: 
        """
        Retrieves current polygon offsets settings from <myDrawer>.
        """
    def Presentation(self) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Returns the current presentation of this object according to the current DisplayMode()
        """
    def Presentations(self) -> OCP.PrsMgr.PrsMgr_Presentations: 
        """
        Return presentations.
        """
    def ProcessDragging(self,theCtx : AIS_InteractiveContext,theView : OCP.V3d.V3d_View,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theDragFrom : OCP.Graphic3d.Graphic3d_Vec2i,theDragTo : OCP.Graphic3d.Graphic3d_Vec2i,theAction : AIS_DragAction) -> bool: 
        """
        Drag object in the viewer.
        """
    @overload
    def RecomputePrimitives(self) -> None: 
        """
        Re-computes the sensitive primitives for all modes. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.

        Re-computes the sensitive primitives which correspond to the <theMode>th selection mode. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.
        """
    @overload
    def RecomputePrimitives(self,theMode : int) -> None: ...
    def Redisplay(self,AllModes : bool=False) -> None: 
        """
        Updates the active presentation; if <AllModes> = Standard_True all the presentations inside are recomputed. IMPORTANT: It is preferable to call Redisplay method of corresponding AIS_InteractiveContext instance for cases when it is accessible. This method just redirects call to myCTXPtr, so this class field must be up to date for proper result.
        """
    def RemoveChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy.
        """
    def RemoveChildWithRestoreTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy with keeping the current global transformation. So the object keeps the same position/orientation in the global CS.
        """
    def RemoveClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Removes previously added clip plane.
        """
    def ResetTransformation(self) -> None: 
        """
        None
        """
    def Selection(self,theMode : int) -> OCP.SelectMgr.SelectMgr_Selection: 
        """
        Returns the selection having specified selection mode or NULL.
        """
    def Selections(self) -> OCP.SelectMgr.SelectMgr_SequenceOfSelection: 
        """
        Return the sequence of selections.
        """
    def SetAspect(self,anAspect : OCP.Prs3d.Prs3d_BasicAspect) -> None: 
        """
        Sets the graphic basic aspect to the current presentation.
        """
    def SetAssemblyOwner(self,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theMode : int=-1) -> None: 
        """
        Sets common entity owner for assembly sensitive object entities
        """
    def SetAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the drawing tool theDrawer.
        """
    def SetAutoHilight(self,theAutoHilight : bool) -> None: 
        """
        Set AutoHilight property to true or false.
        """
    def SetClipPlanes(self,thePlanes : OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane) -> None: 
        """
        Set clip planes for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def SetColor(self,aColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Provides a new color setting aColor for the line in the drawing tool, or "Drawer".
        """
    def SetContext(self,aCtx : AIS_InteractiveContext) -> None: 
        """
        Sets the interactive context aCtx and provides a link to the default drawing tool or "Drawer" if there is none.
        """
    def SetCurrentFacingModel(self,theModel : OCP.Aspect.Aspect_TypeOfFacingModel=Aspect_TypeOfFacingModel.Aspect_TOFM_BOTH_SIDE) -> None: 
        """
        change the current facing model apply on polygons for SetColor(), SetTransparency(), SetMaterial() methods default facing model is Aspect_TOFM_TWO_SIDE. This mean that attributes is applying both on the front and back face.
        """
    def SetDisplayMode(self,theMode : int) -> None: 
        """
        Sets the display mode for the interactive object. An object can have its own temporary display mode, which is different from that proposed by the interactive context.
        """
    def SetDynamicHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the dynamic hilight drawing tool.
        """
    def SetHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the hilight drawing tool theDrawer.
        """
    def SetHilightMode(self,theMode : int) -> None: 
        """
        Sets highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def SetInfiniteState(self,theFlag : bool=True) -> None: 
        """
        Sets if object should be considered as infinite.
        """
    def SetIsoOnTriangulation(self,theIsEnabled : bool) -> None: 
        """
        Enables or disables on-triangulation build of isolines according to the flag given.
        """
    def SetLine(self,theLine : OCP.Geom.Geom_Line) -> None: 
        """
        instantiates an infinite line.
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.gp.gp_Trsf) -> None: 
        """
        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.

        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.TopLoc.TopLoc_Datum3D) -> None: ...
    def SetMaterial(self,aName : OCP.Graphic3d.Graphic3d_MaterialAspect) -> None: 
        """
        Sets the material aMat defining this display attribute for the interactive object. Material aspect determines shading aspect, color and transparency of visible entities.
        """
    def SetMutable(self,theIsMutable : bool) -> None: 
        """
        Sets if the object has mutable nature (content or location will be changed regularly). This method should be called before object displaying to take effect.
        """
    def SetOwner(self,theApplicativeEntity : OCP.Standard.Standard_Transient) -> None: 
        """
        Allows you to attribute the owner theApplicativeEntity to an Interactive Object. This can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of. The owner takes the form of a transient.
        """
    def SetPoints(self,thePStart : OCP.Geom.Geom_Point,thePEnd : OCP.Geom.Geom_Point) -> None: 
        """
        Sets the starting point thePStart and ending point thePEnd of the infinite line to create a finite line segment.
        """
    def SetPolygonOffsets(self,aMode : int,aFactor : float=1.0,aUnits : float=0.0) -> None: 
        """
        Sets up polygon offsets for this object.
        """
    def SetPropagateVisualState(self,theFlag : bool) -> None: 
        """
        Change the value of the flag "propagate visual state"
        """
    @overload
    def SetToUpdate(self) -> None: 
        """
        Flags presentation to be updated; UpdatePresentations() will recompute these presentations.

        flags all the Presentations to be Updated.
        """
    @overload
    def SetToUpdate(self,theMode : int) -> None: ...
    def SetTransformPersistence(self,theTrsfPers : OCP.Graphic3d.Graphic3d_TransformPers) -> None: 
        """
        Sets up Transform Persistence defining a special Local Coordinate system where this object should be located. Note that management of Transform Persistence object is more expensive than of the normal one, because it requires its position being recomputed basing on camera position within each draw call / traverse.
        """
    def SetTransparency(self,aValue : float=0.6) -> None: 
        """
        Attributes a setting aValue for transparency. The transparency value should be between 0.0 and 1.0. At 0.0 an object will be totally opaque, and at 1.0, fully transparent. Warning At a value of 1.0, there may be nothing visible.
        """
    def SetTypeOfPresentation(self,theType : OCP.PrsMgr.PrsMgr_TypeOfPresentation3d) -> None: 
        """
        Set type of presentation.
        """
    def SetWidth(self,aValue : float) -> None: 
        """
        Provides the new width setting aValue for the line in the drawing tool, or "Drawer".
        """
    def SetZLayer(self,theLayerId : int) -> None: 
        """
        Set Z layer ID and update all presentations of the selectable object. The layers mechanism allows drawing objects in higher layers in overlay of objects in lower layers.
        """
    def Signature(self) -> int: 
        """
        Returns the signature 5.
        """
    def SynchronizeAspects(self) -> None: 
        """
        Synchronize presentation aspects after their modification.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    @overload
    def ToBeUpdated(self,ListOfMode : OCP.TColStd.TColStd_ListOfInteger) -> None: 
        """
        Returns TRUE if any active presentation has invalidation flag.

        gives the list of modes which are flagged "to be updated".
        """
    @overload
    def ToBeUpdated(self,theToIncludeHidden : bool=False) -> bool: ...
    def ToPropagateVisualState(self) -> bool: 
        """
        Get value of the flag "propagate visual state" It means that the display/erase/color visual state is propagated automatically to all children; by default, the flag is true
        """
    def TransformPersistence(self) -> OCP.Graphic3d.Graphic3d_TransformPers: 
        """
        Returns Transformation Persistence defining a special Local Coordinate system where this presentable object is located or NULL handle if not defined. Position of the object having Transformation Persistence is mutable and depends on camera position. The same applies to a bounding box of the object.
        """
    def Transformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def TransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def Transparency(self) -> float: 
        """
        Returns the transparency setting. This will be between 0.0 and 1.0. At 0.0 an object will be totally opaque, and at 1.0, fully transparent.
        """
    def Type(self) -> AIS_KindOfInteractive: 
        """
        Returns the type Datum.
        """
    def TypeOfPresentation3d(self) -> OCP.PrsMgr.PrsMgr_TypeOfPresentation3d: 
        """
        Returns information on whether the object accepts display in HLR mode or not.
        """
    def UnsetAttributes(self) -> None: 
        """
        Clears settings provided by the drawing tool aDrawer.
        """
    def UnsetColor(self) -> None: 
        """
        Removes the color setting and returns the original color.
        """
    def UnsetDisplayMode(self) -> None: 
        """
        Removes display mode settings from the interactive object.
        """
    def UnsetHilightAttributes(self) -> None: 
        """
        Clears settings provided by the hilight drawing tool theDrawer.
        """
    def UnsetHilightMode(self) -> None: 
        """
        Unsets highlight display mode.
        """
    def UnsetMaterial(self) -> None: 
        """
        Removes the setting for material.
        """
    def UnsetTransparency(self) -> None: 
        """
        Removes the transparency setting. The object is opaque by default.
        """
    def UnsetWidth(self) -> None: 
        """
        Removes the width setting and returns the original width.
        """
    def UpdateSelection(self,theMode : int=-1) -> None: 
        """
        Sets update status FULL to selections of the object. Must be used as the only method of UpdateSelection from outer classes to prevent BVH structures from being outdated.
        """
    def UpdateTransformation(self) -> None: 
        """
        Recomputes the location of the selection aSelection.
        """
    def UpdateTransformations(self,aSelection : OCP.SelectMgr.SelectMgr_Selection) -> None: 
        """
        Updates locations in all sensitive entities from <aSelection> and in corresponding entity owners.
        """
    def ViewAffinity(self) -> OCP.Graphic3d.Graphic3d_ViewAffinity: 
        """
        Return view affinity mask.
        """
    def Width(self) -> float: 
        """
        Returns the width setting of the Interactive Object.
        """
    def ZLayer(self) -> int: 
        """
        Get ID of Z layer for main presentation.
        """
    @overload
    def __init__(self,aStartPoint : OCP.Geom.Geom_Point,aEndPoint : OCP.Geom.Geom_Point) -> None: ...
    @overload
    def __init__(self,aLine : OCP.Geom.Geom_Line) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class AIS_ListOfInteractive(OCP.NCollection.NCollection_BaseList):
    """
    Purpose: Simple list to link items together keeping the first and the last one. Inherits BaseList, adding the data item to each node.
    """
    def Allocator(self) -> OCP.NCollection.NCollection_BaseAllocator: 
        """
        Returns attached allocator
        """
    @overload
    def Append(self,theItem : AIS_InteractiveObject) -> AIS_InteractiveObject: 
        """
        Append one item at the end

        Append one item at the end and output iterator pointing at the appended item

        Append another list at the end. After this operation, theOther list will be cleared.
        """
    @overload
    def Append(self,theOther : AIS_ListOfInteractive) -> None: ...
    @overload
    def Append(self,theItem : AIS_InteractiveObject,theIter : Any) -> None: ...
    def Assign(self,theOther : AIS_ListOfInteractive) -> AIS_ListOfInteractive: 
        """
        Replace this list by the items of another list (theOther parameter). This method does not change the internal allocator.
        """
    def Clear(self,theAllocator : OCP.NCollection.NCollection_BaseAllocator=None) -> None: 
        """
        Clear this list
        """
    def Extent(self) -> int: 
        """
        None
        """
    def First(self) -> AIS_InteractiveObject: 
        """
        First item

        First item (non-const)
        """
    @overload
    def InsertAfter(self,theItem : AIS_InteractiveObject,theIter : Any) -> AIS_InteractiveObject: 
        """
        InsertAfter

        InsertAfter
        """
    @overload
    def InsertAfter(self,theOther : AIS_ListOfInteractive,theIter : Any) -> None: ...
    @overload
    def InsertBefore(self,theOther : AIS_ListOfInteractive,theIter : Any) -> None: 
        """
        InsertBefore

        InsertBefore
        """
    @overload
    def InsertBefore(self,theItem : AIS_InteractiveObject,theIter : Any) -> AIS_InteractiveObject: ...
    def IsEmpty(self) -> bool: 
        """
        None
        """
    def Last(self) -> AIS_InteractiveObject: 
        """
        Last item

        Last item (non-const)
        """
    @overload
    def Prepend(self,theItem : AIS_InteractiveObject) -> AIS_InteractiveObject: 
        """
        Prepend one item at the beginning

        Prepend another list at the beginning
        """
    @overload
    def Prepend(self,theOther : AIS_ListOfInteractive) -> None: ...
    def Remove(self,theIter : Any) -> None: 
        """
        Remove item pointed by iterator theIter; theIter is then set to the next item
        """
    def RemoveFirst(self) -> None: 
        """
        RemoveFirst item
        """
    def Reverse(self) -> None: 
        """
        Reverse the list
        """
    def Size(self) -> int: 
        """
        Size - Number of items
        """
    @overload
    def __init__(self,theAllocator : OCP.NCollection.NCollection_BaseAllocator) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theOther : AIS_ListOfInteractive) -> None: ...
    def __iter__(self) -> Iterator[AIS_InteractiveObject]: ...
    def __len__(self) -> int: ...
    pass
class AIS_Manipulator(AIS_InteractiveObject, OCP.SelectMgr.SelectMgr_SelectableObject, OCP.PrsMgr.PrsMgr_PresentableObject, OCP.Standard.Standard_Transient):
    """
    Interactive object class to manipulate local transformation of another interactive object or a group of objects via mouse. It manages three types of manipulations in 3D space: - translation through axis - scaling within axis - rotation around axis To enable one of this modes, selection mode (from 1 to 3) is to be activated. There are three orthogonal transformation axes defined by position property of the manipulator. Particular transformation mode can be disabled for each of the axes or all of them. Furthermore each of the axes can be hidden or made visible. The following steps demonstrate how to attach, configure and use manipulator for an interactive object: Step 1. Create manipulator object and adjust it appearance: Note that you can enable only one manipulation mode but have all visual parts displayed. This code allows you to view manipulator and select its manipulation parts. Note that manipulator activates mode on part selection. If this mode is activated, no selection will be performed for manipulator. It can be activated with highlighting. To enable this: Step 2. To perform transformation of object use next code in your event processing chain: Step 3. To deactivate current manipulation mode use: Step 4. To detach manipulator from object use: The last method erases manipulator object.Interactive object class to manipulate local transformation of another interactive object or a group of objects via mouse. It manages three types of manipulations in 3D space: - translation through axis - scaling within axis - rotation around axis To enable one of this modes, selection mode (from 1 to 3) is to be activated. There are three orthogonal transformation axes defined by position property of the manipulator. Particular transformation mode can be disabled for each of the axes or all of them. Furthermore each of the axes can be hidden or made visible. The following steps demonstrate how to attach, configure and use manipulator for an interactive object: Step 1. Create manipulator object and adjust it appearance: Note that you can enable only one manipulation mode but have all visual parts displayed. This code allows you to view manipulator and select its manipulation parts. Note that manipulator activates mode on part selection. If this mode is activated, no selection will be performed for manipulator. It can be activated with highlighting. To enable this: Step 2. To perform transformation of object use next code in your event processing chain: Step 3. To deactivate current manipulation mode use: Step 4. To detach manipulator from object use: The last method erases manipulator object.
    """
    def AcceptDisplayMode(self,theMode : int) -> bool: 
        """
        Returns true if the class of objects accepts specified display mode index. The interactive context can have a default mode of representation for the set of Interactive Objects. This mode may not be accepted by a given class of objects. Consequently, this virtual method allowing us to get information about the class in question must be implemented. At least one display mode index should be accepted by this method. Although subclass can leave default implementation, it is highly desired defining exact list of supported modes instead, which is usually an enumeration for one object or objects class sharing similar list of display modes.
        """
    def AcceptShapeDecomposition(self) -> bool: 
        """
        Informs the graphic context that the interactive Object may be decomposed into sub-shapes for dynamic selection. The most used Interactive Object is AIS_Shape.
        """
    def ActiveAxisIndex(self) -> int: 
        """
        None
        """
    def ActiveMode(self) -> AIS_ManipulatorMode: ...
    def AddChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy.
        """
    def AddChildWithCurrentTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy with keeping the current global transformation So the object keeps the same position/orientation in the global CS.
        """
    def AddClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Adds clip plane for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def AddSelection(self,aSelection : OCP.SelectMgr.SelectMgr_Selection,aMode : int) -> None: 
        """
        Adds the selection aSelection with the selection mode index aMode to this framework.
        """
    @overload
    def Attach(self,theObject : AIS_ManipulatorObjectSequence,theOptions : AIS_Manipulator_OptionsForAttach=AIS_Manipulator_OptionsForAttach) -> None: 
        """
        Attaches himself to the input interactive object and become displayed in the same context. It is placed in the center of object bounding box, and its size is adjusted to the object bounding box.

        Attaches himself to the input interactive object group and become displayed in the same context. It become attached to the first object, baut manage manipulation of the whole group. It is placed in the center of object bounding box, and its size is adjusted to the object bounding box.
        """
    @overload
    def Attach(self,theObject : AIS_InteractiveObject,theOptions : AIS_Manipulator_OptionsForAttach=AIS_Manipulator_OptionsForAttach) -> None: ...
    def Attributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the attributes settings.
        """
    def BndBoxOfSelected(self,theOwners : Any) -> OCP.Bnd.Bnd_Box: 
        """
        Returns a bounding box of sensitive entities with the owners given if they are a part of activated selection
        """
    def BoundingBox(self,theBndBox : OCP.Bnd.Bnd_Box) -> None: 
        """
        Returns bounding box of object correspondingly to its current display mode. This method requires presentation to be already computed, since it relies on bounding box of presentation structures, which are supposed to be same/close amongst different display modes of this object.
        """
    def ChangeTransformBehavior(self) -> Any: 
        """
        Returns behavior settings for transformation action of the manipulator.
        """
    def Children(self) -> OCP.PrsMgr.PrsMgr_ListOfPresentableObjects: 
        """
        Returns children of the current object.
        """
    def ClearDynamicHighlight(self,theMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> None: 
        """
        Method that needs to be implemented when the object manages selection and dynamic highlighting on its own. Clears or invalidates dynamic highlight presentation. By default it clears immediate draw of given presentation manager.
        """
    def ClearOwner(self) -> None: 
        """
        Each Interactive Object has methods which allow us to attribute an Owner to it in the form of a Transient. This method removes the owner from the graphic entity.
        """
    def ClearSelected(self) -> None: 
        """
        Method which clear all selected owners belonging to this selectable object ( for fast presentation draw ).
        """
    def ClearSelections(self,update : bool=False) -> None: 
        """
        Empties all the selections in the SelectableObject <update> parameter defines whether all object's selections should be flagged for further update or not. This improved method can be used to recompute an object's selection (without redisplaying the object completely) when some selection mode is activated not for the first time.
        """
    def ClipPlanes(self) -> OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane: 
        """
        Get clip planes.
        """
    def Color(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Returns the color setting of the Interactive Object.
        """
    def CombinedParentTransformation(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return combined parent transformation.
        """
    def Compute(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager,thePrs : OCP.Graphic3d.Graphic3d_Structure,theMode : int=0) -> None: 
        """
        Fills presentation.
        """
    def ComputeSelection(self,theSelection : OCP.SelectMgr.SelectMgr_Selection,theMode : int) -> None: 
        """
        Computes selection sensitive zones (triangulation) for manipulator.
        """
    def CurrentFacingModel(self) -> OCP.Aspect.Aspect_TypeOfFacingModel: 
        """
        Returns the current facing model which is in effect.
        """
    def DeactivateCurrentMode(self) -> None: 
        """
        Make inactive the current selected manipulator part and reset current axis index and current mode. After its call HasActiveMode() returns false.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def DefaultDisplayMode(self) -> int: 
        """
        Returns the default display mode.
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def Detach(self) -> None: 
        """
        Detaches himself from the owner object, and removes itself from context.
        """
    def DisplayMode(self) -> int: 
        """
        Returns the display mode setting of the Interactive Object. The range of supported display mode indexes should be specified within object definition and filtered by AccepDisplayMode().
        """
    def DisplayStatus(self) -> OCP.PrsMgr.PrsMgr_DisplayStatus: 
        """
        Return presentation display status; PrsMgr_DisplayStatus_None by default.
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicHilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalDynamic and Prs3d_TypeOfHighlight_Dynamic defined within AIS_InteractiveContext::HighlightStyle().
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def EnableMode(self,theMode : AIS_ManipulatorMode) -> None: 
        """
        Enable manipualtion mode.
        """
    def ErasePresentations(self,theToRemove : bool) -> None: 
        """
        Removes presentations returned by GetHilightPresentation() and GetSelectPresentation().
        """
    def GetAssemblyOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns common entity owner if the object is an assembly
        """
    def GetContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def GetHilightPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting detected object.
        """
    def GetOwner(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns the owner of the Interactive Object. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient. There are two types of owners: - Direct owners, decomposition shapes such as edges, wires, and faces. - Users, presentable objects connecting to sensitive primitives, or a shape which has been decomposed.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def GetSelectPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting selected object.
        """
    def GlobalSelOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns the owner of mode for selection of object as a whole
        """
    def GlobalSelectionMode(self) -> int: 
        """
        Returns the mode for selection of object as a whole; 0 by default.
        """
    def HasActiveMode(self) -> bool: 
        """
        Returns true if some part of manipulator is selected (transformation mode is active, and owning object can be transformed).
        """
    def HasActiveTransformation(self) -> bool: 
        """
        None
        """
    def HasColor(self) -> bool: 
        """
        Returns true if the Interactive Object has color.
        """
    def HasDisplayMode(self) -> bool: 
        """
        Returns true if the Interactive Object has display mode setting overriding global setting (within Interactive Context).
        """
    def HasHilightMode(self) -> bool: 
        """
        Returns true if the Interactive Object is in highlight mode.
        """
    def HasInteractiveContext(self) -> bool: 
        """
        Indicates whether the Interactive Object has a pointer to an interactive context.
        """
    def HasMaterial(self) -> bool: 
        """
        Returns true if the Interactive Object has a setting for material.
        """
    def HasOwnPresentations(self) -> bool: 
        """
        Returns true if object should have own presentations.
        """
    def HasOwner(self) -> bool: 
        """
        Returns true if the object has an owner attributed to it. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient.
        """
    def HasPolygonOffsets(self) -> bool: 
        """
        Returns Standard_True if <myDrawer> has non-null shading aspect
        """
    def HasPresentation(self) -> bool: 
        """
        Returns TRUE when this object has a presentation in the current DisplayMode()
        """
    def HasSelection(self,theMode : int) -> bool: 
        """
        Returns true if a selection corresponding to the selection mode theMode was computed for this object.
        """
    def HasTransformation(self) -> bool: 
        """
        Returns true if object has a transformation that is different from the identity.
        """
    def HasWidth(self) -> bool: 
        """
        Returns true if the Interactive Object has width.
        """
    def HilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalSelected and Prs3d_TypeOfHighlight_Selected defined within AIS_InteractiveContext::HighlightStyle().
        """
    def HilightMode(self) -> int: 
        """
        Returns highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def HilightOwnerWithColor(self,thePM : OCP.PrsMgr.PrsMgr_PresentationManager,theStyle : OCP.Prs3d.Prs3d_Drawer,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner) -> None: 
        """
        Method which hilight an owner belonging to this selectable object ( for fast presentation draw ).
        """
    def HilightSelected(self,thePM : OCP.PrsMgr.PrsMgr_PresentationManager,theSeq : OCP.SelectMgr.SelectMgr_SequenceOfOwner) -> None: 
        """
        Method which draws selected owners ( for fast presentation draw ).
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def InteractiveContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def InversedTransformation(self) -> OCP.gp.gp_GTrsf: 
        """
        Return inversed transformation.
        """
    def IsAttached(self) -> bool: 
        """
        Returns true if manipulator is attached to some interactive object (has owning object).
        """
    def IsAutoHilight(self) -> bool: 
        """
        Disables auto highlighting to use HilightSelected() and HilightOwnerWithColor() overridden methods.
        """
    def IsInfinite(self) -> bool: 
        """
        Returns true if the interactive object is infinite; FALSE by default. This flag affects various operations operating on bounding box of graphic presentations of this object. For instance, infinite objects are not taken in account for View FitAll. This does not necessarily means that object is actually infinite, auxiliary objects might be also marked with this flag to achieve desired behavior.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def IsModeActivationOnDetection(self) -> bool: 
        """
        Returns true if manual mode activation is enabled.
        """
    def IsMutable(self) -> bool: 
        """
        Returns true if object has mutable nature (content or location are be changed regularly). Mutable object will be managed in different way than static onces (another optimizations).
        """
    def IsTransparent(self) -> bool: 
        """
        Returns true if there is a transparency setting.
        """
    def LocalTransformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def LocalTransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def Material(self) -> OCP.Graphic3d.Graphic3d_NameOfMaterial: 
        """
        Returns the current material setting as enumeration value.
        """
    @overload
    def Object(self,theIndex : int) -> AIS_InteractiveObject: 
        """
        Returns the first (leading) object of the owning objects.

        Returns one of the owning objects. raises program error if theIndex is more than owning objects count or less than 1.
        """
    @overload
    def Object(self) -> AIS_InteractiveObject: ...
    def ObjectTransformation(self,theX : int,theY : int,theView : OCP.V3d.V3d_View,theTrsf : OCP.gp.gp_Trsf) -> bool: 
        """
        Computes transformation of parent object according to the active mode and input motion vector. You can use this method to get object transformation according to current mode or use own algorithm to implement any other transformation for modes.
        """
    def Objects(self) -> AIS_ManipulatorObjectSequence: 
        """
        Returns all owning objects.
        """
    def Parent(self) -> OCP.PrsMgr.PrsMgr_PresentableObject: 
        """
        Returns parent of current object in scene hierarchy.
        """
    def PolygonOffsets(self,aFactor : float,aUnits : float) -> tuple[int]: 
        """
        Retrieves current polygon offsets settings from <myDrawer>.
        """
    def Position(self) -> OCP.gp.gp_Ax2: 
        """
        Returns poition of manipulator interactive object.
        """
    def Presentation(self) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Returns the current presentation of this object according to the current DisplayMode()
        """
    def Presentations(self) -> OCP.PrsMgr.PrsMgr_Presentations: 
        """
        Return presentations.
        """
    def ProcessDragging(self,theCtx : AIS_InteractiveContext,theView : OCP.V3d.V3d_View,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theDragFrom : OCP.Graphic3d.Graphic3d_Vec2i,theDragTo : OCP.Graphic3d.Graphic3d_Vec2i,theAction : AIS_DragAction) -> bool: 
        """
        Drag object in the viewer.
        """
    @overload
    def RecomputePrimitives(self) -> None: 
        """
        Re-computes the sensitive primitives for all modes. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.

        Re-computes the sensitive primitives which correspond to the <theMode>th selection mode. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.
        """
    @overload
    def RecomputePrimitives(self,theMode : int) -> None: ...
    def Redisplay(self,AllModes : bool=False) -> None: 
        """
        Updates the active presentation; if <AllModes> = Standard_True all the presentations inside are recomputed. IMPORTANT: It is preferable to call Redisplay method of corresponding AIS_InteractiveContext instance for cases when it is accessible. This method just redirects call to myCTXPtr, so this class field must be up to date for proper result.
        """
    def RemoveChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy.
        """
    def RemoveChildWithRestoreTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy with keeping the current global transformation. So the object keeps the same position/orientation in the global CS.
        """
    def RemoveClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Removes previously added clip plane.
        """
    def ResetTransformation(self) -> None: 
        """
        None
        """
    def Selection(self,theMode : int) -> OCP.SelectMgr.SelectMgr_Selection: 
        """
        Returns the selection having specified selection mode or NULL.
        """
    def Selections(self) -> OCP.SelectMgr.SelectMgr_SequenceOfSelection: 
        """
        Return the sequence of selections.
        """
    def SetAspect(self,anAspect : OCP.Prs3d.Prs3d_BasicAspect) -> None: 
        """
        Sets the graphic basic aspect to the current presentation.
        """
    def SetAssemblyOwner(self,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theMode : int=-1) -> None: 
        """
        Sets common entity owner for assembly sensitive object entities
        """
    def SetAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the drawing tool theDrawer.
        """
    def SetAutoHilight(self,theAutoHilight : bool) -> None: 
        """
        Set AutoHilight property to true or false.
        """
    def SetClipPlanes(self,thePlanes : OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane) -> None: 
        """
        Set clip planes for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def SetColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Only the interactive object knowns which Drawer attribute is affected by the color, if any (ex: for a wire,it's the wireaspect field of the drawer, but for a vertex, only the point aspect field is affected by the color). WARNING : Do not forget to set the corresponding fields here (hasOwnColor and myDrawer->SetColor())
        """
    def SetContext(self,aCtx : AIS_InteractiveContext) -> None: 
        """
        Sets the interactive context aCtx and provides a link to the default drawing tool or "Drawer" if there is none.
        """
    def SetCurrentFacingModel(self,theModel : OCP.Aspect.Aspect_TypeOfFacingModel=Aspect_TypeOfFacingModel.Aspect_TOFM_BOTH_SIDE) -> None: 
        """
        change the current facing model apply on polygons for SetColor(), SetTransparency(), SetMaterial() methods default facing model is Aspect_TOFM_TWO_SIDE. This mean that attributes is applying both on the front and back face.
        """
    def SetDisplayMode(self,theMode : int) -> None: 
        """
        Sets the display mode for the interactive object. An object can have its own temporary display mode, which is different from that proposed by the interactive context.
        """
    def SetDynamicHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the dynamic hilight drawing tool.
        """
    def SetGap(self,theValue : float) -> None: 
        """
        Sets gaps between translator, scaler and rotator sub-presentations.
        """
    def SetHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the hilight drawing tool theDrawer.
        """
    def SetHilightMode(self,theMode : int) -> None: 
        """
        Sets highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def SetInfiniteState(self,theFlag : bool=True) -> None: 
        """
        Sets if object should be considered as infinite.
        """
    def SetIsoOnTriangulation(self,theIsEnabled : bool) -> None: 
        """
        Enables or disables on-triangulation build of isolines according to the flag given.
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.gp.gp_Trsf) -> None: 
        """
        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.

        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.TopLoc.TopLoc_Datum3D) -> None: ...
    def SetMaterial(self,aName : OCP.Graphic3d.Graphic3d_MaterialAspect) -> None: 
        """
        Sets the material aMat defining this display attribute for the interactive object. Material aspect determines shading aspect, color and transparency of visible entities.
        """
    def SetModeActivationOnDetection(self,theToEnable : bool) -> None: 
        """
        Enables mode activation on detection (highlighting). By default, mode is activated on selection of manipulator part.
        """
    def SetMutable(self,theIsMutable : bool) -> None: 
        """
        Sets if the object has mutable nature (content or location will be changed regularly). This method should be called before object displaying to take effect.
        """
    def SetOwner(self,theApplicativeEntity : OCP.Standard.Standard_Transient) -> None: 
        """
        Allows you to attribute the owner theApplicativeEntity to an Interactive Object. This can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of. The owner takes the form of a transient.
        """
    @overload
    def SetPart(self,theAxisIndex : int,theMode : AIS_ManipulatorMode,theIsEnabled : bool) -> None: 
        """
        Disable or enable visual parts for translation, rotation or scaling for some axis. By default all parts are enabled (will be displayed).

        Disable or enable visual parts for translation, rotation or scaling for ALL axes. By default all parts are enabled (will be displayed).
        """
    @overload
    def SetPart(self,theMode : AIS_ManipulatorMode,theIsEnabled : bool) -> None: ...
    def SetPolygonOffsets(self,aMode : int,aFactor : float=1.0,aUnits : float=0.0) -> None: 
        """
        Sets up polygon offsets for this object.
        """
    def SetPosition(self,thePosition : OCP.gp.gp_Ax2) -> None: 
        """
        Sets position of the manipulator object.
        """
    def SetPropagateVisualState(self,theFlag : bool) -> None: 
        """
        Change the value of the flag "propagate visual state"
        """
    def SetSize(self,theSideLength : float) -> None: 
        """
        Sets size (length of side of the manipulator cubic bounding box.
        """
    @overload
    def SetToUpdate(self) -> None: 
        """
        Flags presentation to be updated; UpdatePresentations() will recompute these presentations.

        flags all the Presentations to be Updated.
        """
    @overload
    def SetToUpdate(self,theMode : int) -> None: ...
    def SetTransformBehavior(self,theSettings : Any) -> None: 
        """
        Sets behavior settings for transformation action carried on the manipulator, whether it translates, rotates together with the transformed object or not.
        """
    def SetTransformPersistence(self,theTrsfPers : OCP.Graphic3d.Graphic3d_TransformPers) -> None: 
        """
        Redefines transform persistence management to setup transformation for sub-presentation of axes.
        """
    def SetTransparency(self,aValue : float=0.6) -> None: 
        """
        Attributes a setting aValue for transparency. The transparency value should be between 0.0 and 1.0. At 0.0 an object will be totally opaque, and at 1.0, fully transparent. Warning At a value of 1.0, there may be nothing visible.
        """
    def SetTypeOfPresentation(self,theType : OCP.PrsMgr.PrsMgr_TypeOfPresentation3d) -> None: 
        """
        Set type of presentation.
        """
    def SetWidth(self,theWidth : float) -> None: 
        """
        Allows you to provide the setting aValue for width. Only the Interactive Object knows which Drawer attribute is affected by the width setting.
        """
    def SetZLayer(self,theLayerId : int) -> None: 
        """
        Set Z layer ID and update all presentations of the selectable object. The layers mechanism allows drawing objects in higher layers in overlay of objects in lower layers.
        """
    def SetZoomPersistence(self,theToEnable : bool) -> None: 
        """
        Enable or disable zoom persistence mode for the manipulator. With this mode turned on the presentation will keep fixed screen size.
        """
    def Signature(self) -> int: 
        """
        Specifies additional characteristics of Interactive Object of Type(); -1 by default. Among the datums, this signature is attributed to the shape. The remaining datums have the following default signatures: - Point signature 1 - Axis signature 2 - Trihedron signature 3 - PlaneTrihedron signature 4 - Line signature 5 - Circle signature 6 - Plane signature 7.
        """
    def Size(self) -> float: 
        """
        None
        """
    def StartTransform(self,theX : int,theY : int,theView : OCP.V3d.V3d_View) -> None: 
        """
        Init start (reference) transformation.
        """
    @overload
    def StartTransformation(self,theIndex : int) -> OCP.gp.gp_Trsf: 
        """
        None

        None
        """
    @overload
    def StartTransformation(self) -> OCP.gp.gp_Trsf: ...
    def StopTransform(self,theToApply : bool=True) -> None: 
        """
        Reset start (reference) transformation.
        """
    def SynchronizeAspects(self) -> None: 
        """
        Synchronize presentation aspects after their modification.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    @overload
    def ToBeUpdated(self,ListOfMode : OCP.TColStd.TColStd_ListOfInteger) -> None: 
        """
        Returns TRUE if any active presentation has invalidation flag.

        gives the list of modes which are flagged "to be updated".
        """
    @overload
    def ToBeUpdated(self,theToIncludeHidden : bool=False) -> bool: ...
    def ToPropagateVisualState(self) -> bool: 
        """
        Get value of the flag "propagate visual state" It means that the display/erase/color visual state is propagated automatically to all children; by default, the flag is true
        """
    @overload
    def Transform(self,aTrsf : OCP.gp.gp_Trsf) -> None: 
        """
        Apply to the owning objects the input transformation.

        Apply transformation made from mouse moving from start position (save on the first Transform() call and reset on DeactivateCurrentMode() call.) to the in/out mouse position (theX, theY)
        """
    @overload
    def Transform(self,theX : int,theY : int,theView : OCP.V3d.V3d_View) -> OCP.gp.gp_Trsf: ...
    def TransformBehavior(self) -> Any: 
        """
        Returns behavior settings for transformation action of the manipulator.
        """
    def TransformPersistence(self) -> OCP.Graphic3d.Graphic3d_TransformPers: 
        """
        Returns Transformation Persistence defining a special Local Coordinate system where this presentable object is located or NULL handle if not defined. Position of the object having Transformation Persistence is mutable and depends on camera position. The same applies to a bounding box of the object.
        """
    def Transformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def TransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def Transparency(self) -> float: 
        """
        Returns the transparency setting. This will be between 0.0 and 1.0. At 0.0 an object will be totally opaque, and at 1.0, fully transparent.
        """
    def Type(self) -> AIS_KindOfInteractive: 
        """
        Returns the kind of Interactive Object; AIS_KindOfInteractive_None by default.
        """
    def TypeOfPresentation3d(self) -> OCP.PrsMgr.PrsMgr_TypeOfPresentation3d: 
        """
        Returns information on whether the object accepts display in HLR mode or not.
        """
    def UnsetAttributes(self) -> None: 
        """
        Clears settings provided by the drawing tool aDrawer.
        """
    def UnsetColor(self) -> None: 
        """
        Removes color settings. Only the Interactive Object knows which Drawer attribute is affected by the color setting. For a wire, for example, wire aspect is the attribute affected. For a vertex, however, only point aspect is affected by the color setting.
        """
    def UnsetDisplayMode(self) -> None: 
        """
        Removes display mode settings from the interactive object.
        """
    def UnsetHilightAttributes(self) -> None: 
        """
        Clears settings provided by the hilight drawing tool theDrawer.
        """
    def UnsetHilightMode(self) -> None: 
        """
        Unsets highlight display mode.
        """
    def UnsetMaterial(self) -> None: 
        """
        Removes the setting for material.
        """
    def UnsetTransparency(self) -> None: 
        """
        Removes the transparency setting. The object is opaque by default.
        """
    def UnsetWidth(self) -> None: 
        """
        Reset width to default value.
        """
    def UpdateSelection(self,theMode : int=-1) -> None: 
        """
        Sets update status FULL to selections of the object. Must be used as the only method of UpdateSelection from outer classes to prevent BVH structures from being outdated.
        """
    def UpdateTransformation(self) -> None: 
        """
        Recomputes the location of the selection aSelection.
        """
    def UpdateTransformations(self,aSelection : OCP.SelectMgr.SelectMgr_Selection) -> None: 
        """
        Updates locations in all sensitive entities from <aSelection> and in corresponding entity owners.
        """
    def ViewAffinity(self) -> OCP.Graphic3d.Graphic3d_ViewAffinity: 
        """
        Return view affinity mask.
        """
    def Width(self) -> float: 
        """
        Returns the width setting of the Interactive Object.
        """
    def ZLayer(self) -> int: 
        """
        Get ID of Z layer for main presentation.
        """
    def ZoomPersistence(self) -> bool: 
        """
        Returns state of zoom persistence mode, whether it turned on or off.
        """
    @overload
    def __init__(self,thePosition : OCP.gp.gp_Ax2) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class AIS_ManipulatorMode():
    """
    Mode to make definite kind of transformations with AIS_Manipulator object.

    Members:

      AIS_MM_None

      AIS_MM_Translation

      AIS_MM_Rotation

      AIS_MM_Scaling

      AIS_MM_TranslationPlane
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    AIS_MM_None: OCP.AIS.AIS_ManipulatorMode # value = <AIS_ManipulatorMode.AIS_MM_None: 0>
    AIS_MM_Rotation: OCP.AIS.AIS_ManipulatorMode # value = <AIS_ManipulatorMode.AIS_MM_Rotation: 2>
    AIS_MM_Scaling: OCP.AIS.AIS_ManipulatorMode # value = <AIS_ManipulatorMode.AIS_MM_Scaling: 3>
    AIS_MM_Translation: OCP.AIS.AIS_ManipulatorMode # value = <AIS_ManipulatorMode.AIS_MM_Translation: 1>
    AIS_MM_TranslationPlane: OCP.AIS.AIS_ManipulatorMode # value = <AIS_ManipulatorMode.AIS_MM_TranslationPlane: 4>
    __entries: dict # value = {'AIS_MM_None': (<AIS_ManipulatorMode.AIS_MM_None: 0>, None), 'AIS_MM_Translation': (<AIS_ManipulatorMode.AIS_MM_Translation: 1>, None), 'AIS_MM_Rotation': (<AIS_ManipulatorMode.AIS_MM_Rotation: 2>, None), 'AIS_MM_Scaling': (<AIS_ManipulatorMode.AIS_MM_Scaling: 3>, None), 'AIS_MM_TranslationPlane': (<AIS_ManipulatorMode.AIS_MM_TranslationPlane: 4>, None)}
    __members__: dict # value = {'AIS_MM_None': <AIS_ManipulatorMode.AIS_MM_None: 0>, 'AIS_MM_Translation': <AIS_ManipulatorMode.AIS_MM_Translation: 1>, 'AIS_MM_Rotation': <AIS_ManipulatorMode.AIS_MM_Rotation: 2>, 'AIS_MM_Scaling': <AIS_ManipulatorMode.AIS_MM_Scaling: 3>, 'AIS_MM_TranslationPlane': <AIS_ManipulatorMode.AIS_MM_TranslationPlane: 4>}
    pass
class AIS_ManipulatorObjectSequence(OCP.Standard.Standard_Transient):
    @overload
    def Append(self,theSequence : Any) -> None: 
        """
        None

        None
        """
    @overload
    def Append(self,theItem : AIS_InteractiveObject) -> None: ...
    def ChangeSequence(self) -> Any: 
        """
        None
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def Sequence(self) -> Any: 
        """
        None
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    @overload
    def __init__(self,theOther : Any) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class AIS_ManipulatorOwner(OCP.SelectMgr.SelectMgr_EntityOwner, OCP.Standard.Standard_Transient):
    """
    Entity owner for selection management of AIS_Manipulator object.Entity owner for selection management of AIS_Manipulator object.
    """
    def Clear(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager,theMode : int=0) -> None: 
        """
        Clears the owners matching the value of the selection mode aMode from the presentation manager object aPM.
        """
    def ComesFromDecomposition(self) -> bool: 
        """
        Returns TRUE if this owner points to a part of object and FALSE for entire object.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HandleMouseClick(self,thePoint : OCP.Graphic3d.Graphic3d_Vec2i,theButton : int,theModifiers : int,theIsDoubleClick : bool) -> bool: 
        """
        Handle mouse button click event. Does nothing by default and returns FALSE.
        """
    def HasLocation(self) -> bool: 
        """
        Returns TRUE if selectable has transformation.
        """
    def HasSelectable(self) -> bool: 
        """
        Returns true if there is a selectable object to serve as an owner.
        """
    def HilightWithColor(self,thePM : OCP.PrsMgr.PrsMgr_PresentationManager,theStyle : OCP.Prs3d.Prs3d_Drawer,theMode : int) -> None: 
        """
        None
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Index(self) -> int: 
        """
        Returns index of manipulator axis.
        """
    def IsAutoHilight(self) -> bool: 
        """
        if owner is not auto hilighted, for group contains many such owners will be called one method HilightSelected of SelectableObject
        """
    def IsForcedHilight(self) -> bool: 
        """
        if this method returns TRUE the owner will always call method Hilight for SelectableObject when the owner is detected. By default it always return FALSE.
        """
    def IsHilighted(self,thePM : OCP.PrsMgr.PrsMgr_PresentationManager,theMode : int) -> bool: 
        """
        None
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def IsSameSelectable(self,theOther : OCP.SelectMgr.SelectMgr_SelectableObject) -> bool: 
        """
        Returns true if pointer to selectable object of this owner is equal to the given one
        """
    def IsSelected(self) -> bool: 
        """
        Returns Standard_True if the owner is selected.
        """
    def Location(self) -> OCP.TopLoc.TopLoc_Location: 
        """
        Returns transformation of selectable.
        """
    def Mode(self) -> AIS_ManipulatorMode: 
        """
        None
        """
    def Priority(self) -> int: 
        """
        Return selection priority (within range [0-9]) for results with the same depth; 0 by default. Example - selection of shapes: the owners are selectable objects (presentations) a user can give vertex priority [3], edges [2] faces [1] shape [0], so that if during selection one vertex one edge and one face are simultaneously detected, the vertex will only be hilighted.
        """
    def Select(self,theSelScheme : AIS_SelectionScheme,theIsDetected : bool) -> bool: 
        """
        If the object needs to be selected, it returns true.
        """
    def Selectable(self) -> OCP.SelectMgr.SelectMgr_SelectableObject: 
        """
        Returns a selectable object detected in the working context.
        """
    @overload
    def Set(self,theSelObj : OCP.SelectMgr.SelectMgr_SelectableObject) -> None: 
        """
        Sets the selectable object.

        sets the selectable priority of the owner
        """
    @overload
    def Set(self,thePriority : int) -> None: ...
    def SetComesFromDecomposition(self,theIsFromDecomposition : bool) -> None: 
        """
        Sets flag indicating this owner points to a part of object (TRUE) or to entire object (FALSE).
        """
    def SetLocation(self,theLocation : OCP.TopLoc.TopLoc_Location) -> None: 
        """
        Change owner location (callback for handling change of location of selectable object).
        """
    def SetPriority(self,thePriority : int) -> None: 
        """
        Sets the selectable priority of the owner within range [0-9].
        """
    def SetSelectable(self,theSelObj : OCP.SelectMgr.SelectMgr_SelectableObject) -> None: 
        """
        Sets the selectable object.
        """
    def SetSelected(self,theIsSelected : bool) -> None: 
        """
        Set the state of the owner.
        """
    def SetZLayer(self,theLayerId : int) -> None: 
        """
        Set Z layer ID and update all presentations.
        """
    @overload
    def State(self) -> int: 
        """
        Returns selection state.

        Set the state of the owner. The method is deprecated. Use SetSelected() instead.
        """
    @overload
    def State(self,theStatus : int) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Unhilight(self,thePM : OCP.PrsMgr.PrsMgr_PresentationManager,theMode : int) -> None: 
        """
        None
        """
    def UpdateHighlightTrsf(self,theViewer : OCP.V3d.V3d_Viewer,theManager : OCP.PrsMgr.PrsMgr_PresentationManager,theDispMode : int) -> None: 
        """
        Implements immediate application of location transformation of parent object to dynamic highlight structure
        """
    def __init__(self,theSelObject : OCP.SelectMgr.SelectMgr_SelectableObject,theIndex : int,theMode : AIS_ManipulatorMode,thePriority : int=0) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class AIS_Manipulator_OptionsForAttach():
    pass
class AIS_MediaPlayer(AIS_InteractiveObject, OCP.SelectMgr.SelectMgr_SelectableObject, OCP.PrsMgr.PrsMgr_PresentableObject, OCP.Standard.Standard_Transient):
    """
    Presentation for video playback.
    """
    def AcceptDisplayMode(self,theMode : int) -> bool: 
        """
        Returns true if the class of objects accepts specified display mode index. The interactive context can have a default mode of representation for the set of Interactive Objects. This mode may not be accepted by a given class of objects. Consequently, this virtual method allowing us to get information about the class in question must be implemented. At least one display mode index should be accepted by this method. Although subclass can leave default implementation, it is highly desired defining exact list of supported modes instead, which is usually an enumeration for one object or objects class sharing similar list of display modes.
        """
    def AcceptShapeDecomposition(self) -> bool: 
        """
        Informs the graphic context that the interactive Object may be decomposed into sub-shapes for dynamic selection. The most used Interactive Object is AIS_Shape.
        """
    def AddChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy.
        """
    def AddChildWithCurrentTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy with keeping the current global transformation So the object keeps the same position/orientation in the global CS.
        """
    def AddClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Adds clip plane for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def AddSelection(self,aSelection : OCP.SelectMgr.SelectMgr_Selection,aMode : int) -> None: 
        """
        Adds the selection aSelection with the selection mode index aMode to this framework.
        """
    def Attributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the attributes settings.
        """
    def BndBoxOfSelected(self,theOwners : Any) -> OCP.Bnd.Bnd_Box: 
        """
        Returns a bounding box of sensitive entities with the owners given if they are a part of activated selection
        """
    def BoundingBox(self,theBndBox : OCP.Bnd.Bnd_Box) -> None: 
        """
        Returns bounding box of object correspondingly to its current display mode. This method requires presentation to be already computed, since it relies on bounding box of presentation structures, which are supposed to be same/close amongst different display modes of this object.
        """
    def Children(self) -> OCP.PrsMgr.PrsMgr_ListOfPresentableObjects: 
        """
        Returns children of the current object.
        """
    def ClearDynamicHighlight(self,theMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> None: 
        """
        Method that needs to be implemented when the object manages selection and dynamic highlighting on its own. Clears or invalidates dynamic highlight presentation. By default it clears immediate draw of given presentation manager.
        """
    def ClearOwner(self) -> None: 
        """
        Each Interactive Object has methods which allow us to attribute an Owner to it in the form of a Transient. This method removes the owner from the graphic entity.
        """
    def ClearSelected(self) -> None: 
        """
        Method which clear all selected owners belonging to this selectable object ( for fast presentation draw )
        """
    def ClearSelections(self,update : bool=False) -> None: 
        """
        Empties all the selections in the SelectableObject <update> parameter defines whether all object's selections should be flagged for further update or not. This improved method can be used to recompute an object's selection (without redisplaying the object completely) when some selection mode is activated not for the first time.
        """
    def ClipPlanes(self) -> OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane: 
        """
        Get clip planes.
        """
    def Color(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Returns the color setting of the Interactive Object.
        """
    def CombinedParentTransformation(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return combined parent transformation.
        """
    def ComputeSelection(self,theSelection : OCP.SelectMgr.SelectMgr_Selection,theMode : int) -> None: 
        """
        Computes sensitive primitives for the given selection mode - key interface method of Selectable Object.
        """
    def CurrentFacingModel(self) -> OCP.Aspect.Aspect_TypeOfFacingModel: 
        """
        Returns the current facing model which is in effect.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def DefaultDisplayMode(self) -> int: 
        """
        Returns the default display mode.
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DisplayMode(self) -> int: 
        """
        Returns the display mode setting of the Interactive Object. The range of supported display mode indexes should be specified within object definition and filtered by AccepDisplayMode().
        """
    def DisplayStatus(self) -> OCP.PrsMgr.PrsMgr_DisplayStatus: 
        """
        Return presentation display status; PrsMgr_DisplayStatus_None by default.
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def Duration(self) -> float: 
        """
        Return duration.
        """
    def DynamicHilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalDynamic and Prs3d_TypeOfHighlight_Dynamic defined within AIS_InteractiveContext::HighlightStyle().
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def ErasePresentations(self,theToRemove : bool) -> None: 
        """
        Removes presentations returned by GetHilightPresentation() and GetSelectPresentation().
        """
    def GetAssemblyOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns common entity owner if the object is an assembly
        """
    def GetContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def GetHilightPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting detected object.
        """
    def GetOwner(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns the owner of the Interactive Object. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient. There are two types of owners: - Direct owners, decomposition shapes such as edges, wires, and faces. - Users, presentable objects connecting to sensitive primitives, or a shape which has been decomposed.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def GetSelectPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting selected object.
        """
    def GlobalSelOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns the owner of mode for selection of object as a whole
        """
    def GlobalSelectionMode(self) -> int: 
        """
        Returns the mode for selection of object as a whole; 0 by default.
        """
    def HasColor(self) -> bool: 
        """
        Returns true if the Interactive Object has color.
        """
    def HasDisplayMode(self) -> bool: 
        """
        Returns true if the Interactive Object has display mode setting overriding global setting (within Interactive Context).
        """
    def HasHilightMode(self) -> bool: 
        """
        Returns true if the Interactive Object is in highlight mode.
        """
    def HasInteractiveContext(self) -> bool: 
        """
        Indicates whether the Interactive Object has a pointer to an interactive context.
        """
    def HasMaterial(self) -> bool: 
        """
        Returns true if the Interactive Object has a setting for material.
        """
    def HasOwnPresentations(self) -> bool: 
        """
        Returns true if object should have own presentations.
        """
    def HasOwner(self) -> bool: 
        """
        Returns true if the object has an owner attributed to it. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient.
        """
    def HasPolygonOffsets(self) -> bool: 
        """
        Returns Standard_True if <myDrawer> has non-null shading aspect
        """
    def HasPresentation(self) -> bool: 
        """
        Returns TRUE when this object has a presentation in the current DisplayMode()
        """
    def HasSelection(self,theMode : int) -> bool: 
        """
        Returns true if a selection corresponding to the selection mode theMode was computed for this object.
        """
    def HasTransformation(self) -> bool: 
        """
        Returns true if object has a transformation that is different from the identity.
        """
    def HasWidth(self) -> bool: 
        """
        Returns true if the Interactive Object has width.
        """
    def HilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalSelected and Prs3d_TypeOfHighlight_Selected defined within AIS_InteractiveContext::HighlightStyle().
        """
    def HilightMode(self) -> int: 
        """
        Returns highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def HilightOwnerWithColor(self,thePM : OCP.PrsMgr.PrsMgr_PresentationManager,theStyle : OCP.Prs3d.Prs3d_Drawer,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner) -> None: 
        """
        Method which hilight an owner belonging to this selectable object ( for fast presentation draw )
        """
    def HilightSelected(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager,theSeq : OCP.SelectMgr.SelectMgr_SequenceOfOwner) -> None: 
        """
        Method which draws selected owners ( for fast presentation draw )
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def InteractiveContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def InversedTransformation(self) -> OCP.gp.gp_GTrsf: 
        """
        Return inversed transformation.
        """
    def IsAutoHilight(self) -> bool: 
        """
        If returns True, the old mechanism for highlighting selected objects is used (HilightSelected Method may be empty). If returns False, the HilightSelected method will be fully responsible for highlighting selected entity owners belonging to this selectable object.
        """
    def IsInfinite(self) -> bool: 
        """
        Returns true if the interactive object is infinite; FALSE by default. This flag affects various operations operating on bounding box of graphic presentations of this object. For instance, infinite objects are not taken in account for View FitAll. This does not necessarily means that object is actually infinite, auxiliary objects might be also marked with this flag to achieve desired behavior.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def IsMutable(self) -> bool: 
        """
        Returns true if object has mutable nature (content or location are be changed regularly). Mutable object will be managed in different way than static onces (another optimizations).
        """
    def IsTransparent(self) -> bool: 
        """
        Returns true if there is a transparency setting.
        """
    def LocalTransformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def LocalTransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def Material(self) -> OCP.Graphic3d.Graphic3d_NameOfMaterial: 
        """
        Returns the current material setting as enumeration value.
        """
    def OpenInput(self,thePath : OCP.TCollection.TCollection_AsciiString,theToWait : bool) -> None: 
        """
        Open specified file.
        """
    def Parent(self) -> OCP.PrsMgr.PrsMgr_PresentableObject: 
        """
        Returns parent of current object in scene hierarchy.
        """
    def PlayPause(self) -> None: 
        """
        Switch playback state.
        """
    def PlayerContext(self) -> Media_PlayerContext: 
        """
        Return player context.
        """
    def PolygonOffsets(self,aFactor : float,aUnits : float) -> tuple[int]: 
        """
        Retrieves current polygon offsets settings from <myDrawer>.
        """
    def PresentFrame(self,theLeftCorner : OCP.Graphic3d.Graphic3d_Vec2i,theMaxSize : OCP.Graphic3d.Graphic3d_Vec2i) -> bool: 
        """
        Display new frame.
        """
    def Presentation(self) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Returns the current presentation of this object according to the current DisplayMode()
        """
    def Presentations(self) -> OCP.PrsMgr.PrsMgr_Presentations: 
        """
        Return presentations.
        """
    def ProcessDragging(self,theCtx : AIS_InteractiveContext,theView : OCP.V3d.V3d_View,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theDragFrom : OCP.Graphic3d.Graphic3d_Vec2i,theDragTo : OCP.Graphic3d.Graphic3d_Vec2i,theAction : AIS_DragAction) -> bool: 
        """
        Drag object in the viewer.
        """
    @overload
    def RecomputePrimitives(self) -> None: 
        """
        Re-computes the sensitive primitives for all modes. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.

        Re-computes the sensitive primitives which correspond to the <theMode>th selection mode. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.
        """
    @overload
    def RecomputePrimitives(self,theMode : int) -> None: ...
    def Redisplay(self,AllModes : bool=False) -> None: 
        """
        Updates the active presentation; if <AllModes> = Standard_True all the presentations inside are recomputed. IMPORTANT: It is preferable to call Redisplay method of corresponding AIS_InteractiveContext instance for cases when it is accessible. This method just redirects call to myCTXPtr, so this class field must be up to date for proper result.
        """
    def RemoveChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy.
        """
    def RemoveChildWithRestoreTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy with keeping the current global transformation. So the object keeps the same position/orientation in the global CS.
        """
    def RemoveClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Removes previously added clip plane.
        """
    def ResetTransformation(self) -> None: 
        """
        None
        """
    def Selection(self,theMode : int) -> OCP.SelectMgr.SelectMgr_Selection: 
        """
        Returns the selection having specified selection mode or NULL.
        """
    def Selections(self) -> OCP.SelectMgr.SelectMgr_SequenceOfSelection: 
        """
        Return the sequence of selections.
        """
    def SetAspect(self,anAspect : OCP.Prs3d.Prs3d_BasicAspect) -> None: 
        """
        Sets the graphic basic aspect to the current presentation.
        """
    def SetAssemblyOwner(self,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theMode : int=-1) -> None: 
        """
        Sets common entity owner for assembly sensitive object entities
        """
    def SetAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the drawing tool theDrawer.
        """
    def SetAutoHilight(self,theAutoHilight : bool) -> None: 
        """
        Set AutoHilight property to true or false.
        """
    def SetCallback(self,theCallbackFunction : Any,theCallbackUserPtr : capsule) -> None: 
        """
        SetCallback(self: OCP.AIS.AIS_MediaPlayer, theCallbackFunction: void (void*), theCallbackUserPtr: capsule) -> None

        Setup callback to be called on queue progress (e.g. when new frame should be displayed).
        """
    def SetClipPlanes(self,thePlanes : OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane) -> None: 
        """
        Set clip planes for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def SetClosePlayer(self) -> None: 
        """
        Schedule player to be closed.
        """
    def SetColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Only the interactive object knowns which Drawer attribute is affected by the color, if any (ex: for a wire,it's the wireaspect field of the drawer, but for a vertex, only the point aspect field is affected by the color). WARNING : Do not forget to set the corresponding fields here (hasOwnColor and myDrawer->SetColor())
        """
    def SetContext(self,aCtx : AIS_InteractiveContext) -> None: 
        """
        Sets the interactive context aCtx and provides a link to the default drawing tool or "Drawer" if there is none.
        """
    def SetCurrentFacingModel(self,theModel : OCP.Aspect.Aspect_TypeOfFacingModel=Aspect_TypeOfFacingModel.Aspect_TOFM_BOTH_SIDE) -> None: 
        """
        change the current facing model apply on polygons for SetColor(), SetTransparency(), SetMaterial() methods default facing model is Aspect_TOFM_TWO_SIDE. This mean that attributes is applying both on the front and back face.
        """
    def SetDisplayMode(self,theMode : int) -> None: 
        """
        Sets the display mode for the interactive object. An object can have its own temporary display mode, which is different from that proposed by the interactive context.
        """
    def SetDynamicHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the dynamic hilight drawing tool.
        """
    def SetHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the hilight drawing tool theDrawer.
        """
    def SetHilightMode(self,theMode : int) -> None: 
        """
        Sets highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def SetInfiniteState(self,theFlag : bool=True) -> None: 
        """
        Sets if object should be considered as infinite.
        """
    def SetIsoOnTriangulation(self,theIsEnabled : bool) -> None: 
        """
        Enables or disables on-triangulation build of isolines according to the flag given.
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.gp.gp_Trsf) -> None: 
        """
        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.

        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.TopLoc.TopLoc_Datum3D) -> None: ...
    def SetMaterial(self,aName : OCP.Graphic3d.Graphic3d_MaterialAspect) -> None: 
        """
        Sets the material aMat defining this display attribute for the interactive object. Material aspect determines shading aspect, color and transparency of visible entities.
        """
    def SetMutable(self,theIsMutable : bool) -> None: 
        """
        Sets if the object has mutable nature (content or location will be changed regularly). This method should be called before object displaying to take effect.
        """
    def SetOwner(self,theApplicativeEntity : OCP.Standard.Standard_Transient) -> None: 
        """
        Allows you to attribute the owner theApplicativeEntity to an Interactive Object. This can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of. The owner takes the form of a transient.
        """
    def SetPolygonOffsets(self,aMode : int,aFactor : float=1.0,aUnits : float=0.0) -> None: 
        """
        Sets up polygon offsets for this object.
        """
    def SetPropagateVisualState(self,theFlag : bool) -> None: 
        """
        Change the value of the flag "propagate visual state"
        """
    @overload
    def SetToUpdate(self) -> None: 
        """
        Flags presentation to be updated; UpdatePresentations() will recompute these presentations.

        flags all the Presentations to be Updated.
        """
    @overload
    def SetToUpdate(self,theMode : int) -> None: ...
    def SetTransformPersistence(self,theTrsfPers : OCP.Graphic3d.Graphic3d_TransformPers) -> None: 
        """
        Sets up Transform Persistence defining a special Local Coordinate system where this object should be located. Note that management of Transform Persistence object is more expensive than of the normal one, because it requires its position being recomputed basing on camera position within each draw call / traverse.
        """
    def SetTransparency(self,aValue : float=0.6) -> None: 
        """
        Attributes a setting aValue for transparency. The transparency value should be between 0.0 and 1.0. At 0.0 an object will be totally opaque, and at 1.0, fully transparent. Warning At a value of 1.0, there may be nothing visible.
        """
    def SetTypeOfPresentation(self,theType : OCP.PrsMgr.PrsMgr_TypeOfPresentation3d) -> None: 
        """
        Set type of presentation.
        """
    def SetWidth(self,theWidth : float) -> None: 
        """
        Allows you to provide the setting aValue for width. Only the Interactive Object knows which Drawer attribute is affected by the width setting.
        """
    def SetZLayer(self,theLayerId : int) -> None: 
        """
        Set Z layer ID and update all presentations of the selectable object. The layers mechanism allows drawing objects in higher layers in overlay of objects in lower layers.
        """
    def Signature(self) -> int: 
        """
        Specifies additional characteristics of Interactive Object of Type(); -1 by default. Among the datums, this signature is attributed to the shape. The remaining datums have the following default signatures: - Point signature 1 - Axis signature 2 - Trihedron signature 3 - PlaneTrihedron signature 4 - Line signature 5 - Circle signature 6 - Plane signature 7.
        """
    def SynchronizeAspects(self) -> None: 
        """
        Synchronize presentation aspects after their modification.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    @overload
    def ToBeUpdated(self,ListOfMode : OCP.TColStd.TColStd_ListOfInteger) -> None: 
        """
        Returns TRUE if any active presentation has invalidation flag.

        gives the list of modes which are flagged "to be updated".
        """
    @overload
    def ToBeUpdated(self,theToIncludeHidden : bool=False) -> bool: ...
    def ToPropagateVisualState(self) -> bool: 
        """
        Get value of the flag "propagate visual state" It means that the display/erase/color visual state is propagated automatically to all children; by default, the flag is true
        """
    def TransformPersistence(self) -> OCP.Graphic3d.Graphic3d_TransformPers: 
        """
        Returns Transformation Persistence defining a special Local Coordinate system where this presentable object is located or NULL handle if not defined. Position of the object having Transformation Persistence is mutable and depends on camera position. The same applies to a bounding box of the object.
        """
    def Transformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def TransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def Transparency(self) -> float: 
        """
        Returns the transparency setting. This will be between 0.0 and 1.0. At 0.0 an object will be totally opaque, and at 1.0, fully transparent.
        """
    def Type(self) -> AIS_KindOfInteractive: 
        """
        Returns the kind of Interactive Object; AIS_KindOfInteractive_None by default.
        """
    def TypeOfPresentation3d(self) -> OCP.PrsMgr.PrsMgr_TypeOfPresentation3d: 
        """
        Returns information on whether the object accepts display in HLR mode or not.
        """
    def UnsetAttributes(self) -> None: 
        """
        Clears settings provided by the drawing tool aDrawer.
        """
    def UnsetColor(self) -> None: 
        """
        Removes color settings. Only the Interactive Object knows which Drawer attribute is affected by the color setting. For a wire, for example, wire aspect is the attribute affected. For a vertex, however, only point aspect is affected by the color setting.
        """
    def UnsetDisplayMode(self) -> None: 
        """
        Removes display mode settings from the interactive object.
        """
    def UnsetHilightAttributes(self) -> None: 
        """
        Clears settings provided by the hilight drawing tool theDrawer.
        """
    def UnsetHilightMode(self) -> None: 
        """
        Unsets highlight display mode.
        """
    def UnsetMaterial(self) -> None: 
        """
        Removes the setting for material.
        """
    def UnsetTransparency(self) -> None: 
        """
        Removes the transparency setting. The object is opaque by default.
        """
    def UnsetWidth(self) -> None: 
        """
        Reset width to default value.
        """
    def UpdateSelection(self,theMode : int=-1) -> None: 
        """
        Sets update status FULL to selections of the object. Must be used as the only method of UpdateSelection from outer classes to prevent BVH structures from being outdated.
        """
    def UpdateTransformation(self) -> None: 
        """
        Recomputes the location of the selection aSelection.
        """
    def UpdateTransformations(self,aSelection : OCP.SelectMgr.SelectMgr_Selection) -> None: 
        """
        Updates locations in all sensitive entities from <aSelection> and in corresponding entity owners.
        """
    def ViewAffinity(self) -> OCP.Graphic3d.Graphic3d_ViewAffinity: 
        """
        Return view affinity mask.
        """
    def Width(self) -> float: 
        """
        Returns the width setting of the Interactive Object.
        """
    def ZLayer(self) -> int: 
        """
        Get ID of Z layer for main presentation.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class AIS_MouseGesture():
    """
    Mouse gesture - only one can be active at one moment.

    Members:

      AIS_MouseGesture_NONE

      AIS_MouseGesture_SelectRectangle

      AIS_MouseGesture_SelectLasso

      AIS_MouseGesture_Zoom

      AIS_MouseGesture_ZoomWindow

      AIS_MouseGesture_Pan

      AIS_MouseGesture_RotateOrbit

      AIS_MouseGesture_RotateView

      AIS_MouseGesture_Drag
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    AIS_MouseGesture_Drag: OCP.AIS.AIS_MouseGesture # value = <AIS_MouseGesture.AIS_MouseGesture_Drag: 8>
    AIS_MouseGesture_NONE: OCP.AIS.AIS_MouseGesture # value = <AIS_MouseGesture.AIS_MouseGesture_NONE: 0>
    AIS_MouseGesture_Pan: OCP.AIS.AIS_MouseGesture # value = <AIS_MouseGesture.AIS_MouseGesture_Pan: 5>
    AIS_MouseGesture_RotateOrbit: OCP.AIS.AIS_MouseGesture # value = <AIS_MouseGesture.AIS_MouseGesture_RotateOrbit: 6>
    AIS_MouseGesture_RotateView: OCP.AIS.AIS_MouseGesture # value = <AIS_MouseGesture.AIS_MouseGesture_RotateView: 7>
    AIS_MouseGesture_SelectLasso: OCP.AIS.AIS_MouseGesture # value = <AIS_MouseGesture.AIS_MouseGesture_SelectLasso: 2>
    AIS_MouseGesture_SelectRectangle: OCP.AIS.AIS_MouseGesture # value = <AIS_MouseGesture.AIS_MouseGesture_SelectRectangle: 1>
    AIS_MouseGesture_Zoom: OCP.AIS.AIS_MouseGesture # value = <AIS_MouseGesture.AIS_MouseGesture_Zoom: 3>
    AIS_MouseGesture_ZoomWindow: OCP.AIS.AIS_MouseGesture # value = <AIS_MouseGesture.AIS_MouseGesture_ZoomWindow: 4>
    __entries: dict # value = {'AIS_MouseGesture_NONE': (<AIS_MouseGesture.AIS_MouseGesture_NONE: 0>, None), 'AIS_MouseGesture_SelectRectangle': (<AIS_MouseGesture.AIS_MouseGesture_SelectRectangle: 1>, None), 'AIS_MouseGesture_SelectLasso': (<AIS_MouseGesture.AIS_MouseGesture_SelectLasso: 2>, None), 'AIS_MouseGesture_Zoom': (<AIS_MouseGesture.AIS_MouseGesture_Zoom: 3>, None), 'AIS_MouseGesture_ZoomWindow': (<AIS_MouseGesture.AIS_MouseGesture_ZoomWindow: 4>, None), 'AIS_MouseGesture_Pan': (<AIS_MouseGesture.AIS_MouseGesture_Pan: 5>, None), 'AIS_MouseGesture_RotateOrbit': (<AIS_MouseGesture.AIS_MouseGesture_RotateOrbit: 6>, None), 'AIS_MouseGesture_RotateView': (<AIS_MouseGesture.AIS_MouseGesture_RotateView: 7>, None), 'AIS_MouseGesture_Drag': (<AIS_MouseGesture.AIS_MouseGesture_Drag: 8>, None)}
    __members__: dict # value = {'AIS_MouseGesture_NONE': <AIS_MouseGesture.AIS_MouseGesture_NONE: 0>, 'AIS_MouseGesture_SelectRectangle': <AIS_MouseGesture.AIS_MouseGesture_SelectRectangle: 1>, 'AIS_MouseGesture_SelectLasso': <AIS_MouseGesture.AIS_MouseGesture_SelectLasso: 2>, 'AIS_MouseGesture_Zoom': <AIS_MouseGesture.AIS_MouseGesture_Zoom: 3>, 'AIS_MouseGesture_ZoomWindow': <AIS_MouseGesture.AIS_MouseGesture_ZoomWindow: 4>, 'AIS_MouseGesture_Pan': <AIS_MouseGesture.AIS_MouseGesture_Pan: 5>, 'AIS_MouseGesture_RotateOrbit': <AIS_MouseGesture.AIS_MouseGesture_RotateOrbit: 6>, 'AIS_MouseGesture_RotateView': <AIS_MouseGesture.AIS_MouseGesture_RotateView: 7>, 'AIS_MouseGesture_Drag': <AIS_MouseGesture.AIS_MouseGesture_Drag: 8>}
    pass
class AIS_MouseGestureMap(OCP.NCollection.NCollection_BaseMap):
    """
    Purpose: The DataMap is a Map to store keys with associated Items. See Map from NCollection for a discussion about the number of buckets.
    """
    def Allocator(self) -> OCP.NCollection.NCollection_BaseAllocator: 
        """
        Returns attached allocator
        """
    def Assign(self,theOther : AIS_MouseGestureMap) -> AIS_MouseGestureMap: 
        """
        Assignment. This method does not change the internal allocator.
        """
    def Bind(self,theKey : int,theItem : AIS_MouseGesture) -> bool: 
        """
        Bind binds Item to Key in map.
        """
    def Bound(self,theKey : int,theItem : AIS_MouseGesture) -> AIS_MouseGesture: 
        """
        Bound binds Item to Key in map.
        """
    def ChangeFind(self,theKey : int) -> AIS_MouseGesture: 
        """
        ChangeFind returns mofifiable Item by Key. Raises if Key was not bound
        """
    def ChangeSeek(self,theKey : int) -> AIS_MouseGesture: 
        """
        ChangeSeek returns modifiable pointer to Item by Key. Returns NULL is Key was not bound.
        """
    @overload
    def Clear(self,doReleaseMemory : bool=False) -> None: 
        """
        Clear data. If doReleaseMemory is false then the table of buckets is not released and will be reused.

        Clear data and reset allocator
        """
    @overload
    def Clear(self,theAllocator : OCP.NCollection.NCollection_BaseAllocator) -> None: ...
    def Exchange(self,theOther : AIS_MouseGestureMap) -> None: 
        """
        Exchange the content of two maps without re-allocations. Notice that allocators will be swapped as well!
        """
    def Extent(self) -> int: 
        """
        Extent
        """
    @overload
    def Find(self,theKey : int,theValue : AIS_MouseGesture) -> bool: 
        """
        Find returns the Item for Key. Raises if Key was not bound

        Find Item for key with copying.
        """
    @overload
    def Find(self,theKey : int) -> AIS_MouseGesture: ...
    def IsBound(self,theKey : int) -> bool: 
        """
        IsBound
        """
    def IsEmpty(self) -> bool: 
        """
        IsEmpty
        """
    def NbBuckets(self) -> int: 
        """
        NbBuckets
        """
    def ReSize(self,N : int) -> None: 
        """
        ReSize
        """
    def Seek(self,theKey : int) -> AIS_MouseGesture: 
        """
        Seek returns pointer to Item by Key. Returns NULL is Key was not bound.
        """
    def Size(self) -> int: 
        """
        Size
        """
    def Statistics(self,S : io.BytesIO) -> None: 
        """
        Statistics
        """
    def UnBind(self,theKey : int) -> bool: 
        """
        UnBind removes Item Key pair from map
        """
    def __call__(self,theKey : int) -> AIS_MouseGesture: ...
    @overload
    def __init__(self,theOther : AIS_MouseGestureMap) -> None: ...
    @overload
    def __init__(self,theNbBuckets : int,theAllocator : OCP.NCollection.NCollection_BaseAllocator=None) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def __iter__(self) -> Iterator[AIS_MouseGesture]: ...
    def __len__(self) -> int: ...
    pass
class AIS_MouseSelectionSchemeMap(OCP.NCollection.NCollection_BaseMap):
    """
    Purpose: The DataMap is a Map to store keys with associated Items. See Map from NCollection for a discussion about the number of buckets.
    """
    def Allocator(self) -> OCP.NCollection.NCollection_BaseAllocator: 
        """
        Returns attached allocator
        """
    def Assign(self,theOther : AIS_MouseSelectionSchemeMap) -> AIS_MouseSelectionSchemeMap: 
        """
        Assignment. This method does not change the internal allocator.
        """
    def Bind(self,theKey : int,theItem : AIS_SelectionScheme) -> bool: 
        """
        Bind binds Item to Key in map.
        """
    def Bound(self,theKey : int,theItem : AIS_SelectionScheme) -> AIS_SelectionScheme: 
        """
        Bound binds Item to Key in map.
        """
    def ChangeFind(self,theKey : int) -> AIS_SelectionScheme: 
        """
        ChangeFind returns mofifiable Item by Key. Raises if Key was not bound
        """
    def ChangeSeek(self,theKey : int) -> AIS_SelectionScheme: 
        """
        ChangeSeek returns modifiable pointer to Item by Key. Returns NULL is Key was not bound.
        """
    @overload
    def Clear(self,doReleaseMemory : bool=False) -> None: 
        """
        Clear data. If doReleaseMemory is false then the table of buckets is not released and will be reused.

        Clear data and reset allocator
        """
    @overload
    def Clear(self,theAllocator : OCP.NCollection.NCollection_BaseAllocator) -> None: ...
    def Exchange(self,theOther : AIS_MouseSelectionSchemeMap) -> None: 
        """
        Exchange the content of two maps without re-allocations. Notice that allocators will be swapped as well!
        """
    def Extent(self) -> int: 
        """
        Extent
        """
    @overload
    def Find(self,theKey : int,theValue : AIS_SelectionScheme) -> bool: 
        """
        Find returns the Item for Key. Raises if Key was not bound

        Find Item for key with copying.
        """
    @overload
    def Find(self,theKey : int) -> AIS_SelectionScheme: ...
    def IsBound(self,theKey : int) -> bool: 
        """
        IsBound
        """
    def IsEmpty(self) -> bool: 
        """
        IsEmpty
        """
    def NbBuckets(self) -> int: 
        """
        NbBuckets
        """
    def ReSize(self,N : int) -> None: 
        """
        ReSize
        """
    def Seek(self,theKey : int) -> AIS_SelectionScheme: 
        """
        Seek returns pointer to Item by Key. Returns NULL is Key was not bound.
        """
    def Size(self) -> int: 
        """
        Size
        """
    def Statistics(self,S : io.BytesIO) -> None: 
        """
        Statistics
        """
    def UnBind(self,theKey : int) -> bool: 
        """
        UnBind removes Item Key pair from map
        """
    def __call__(self,theKey : int) -> AIS_SelectionScheme: ...
    @overload
    def __init__(self,theOther : AIS_MouseSelectionSchemeMap) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theNbBuckets : int,theAllocator : OCP.NCollection.NCollection_BaseAllocator=None) -> None: ...
    def __iter__(self) -> Iterator[AIS_SelectionScheme]: ...
    def __len__(self) -> int: ...
    pass
class AIS_MultipleConnectedInteractive(AIS_InteractiveObject, OCP.SelectMgr.SelectMgr_SelectableObject, OCP.PrsMgr.PrsMgr_PresentableObject, OCP.Standard.Standard_Transient):
    """
    Defines an Interactive Object by gathering together several object presentations. This is done through a list of interactive objects. These can also be Connected objects. That way memory-costly calculations of presentation are avoided.Defines an Interactive Object by gathering together several object presentations. This is done through a list of interactive objects. These can also be Connected objects. That way memory-costly calculations of presentation are avoided.
    """
    def AcceptDisplayMode(self,theMode : int) -> bool: 
        """
        Returns true if the class of objects accepts specified display mode index. The interactive context can have a default mode of representation for the set of Interactive Objects. This mode may not be accepted by a given class of objects. Consequently, this virtual method allowing us to get information about the class in question must be implemented. At least one display mode index should be accepted by this method. Although subclass can leave default implementation, it is highly desired defining exact list of supported modes instead, which is usually an enumeration for one object or objects class sharing similar list of display modes.
        """
    def AcceptShapeDecomposition(self) -> bool: 
        """
        Informs the graphic context that the interactive Object may be decomposed into sub-shapes for dynamic selection.
        """
    def AddChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy.
        """
    def AddChildWithCurrentTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy with keeping the current global transformation So the object keeps the same position/orientation in the global CS.
        """
    def AddClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Adds clip plane for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def AddSelection(self,aSelection : OCP.SelectMgr.SelectMgr_Selection,aMode : int) -> None: 
        """
        Adds the selection aSelection with the selection mode index aMode to this framework.
        """
    def Attributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the attributes settings.
        """
    def BndBoxOfSelected(self,theOwners : Any) -> OCP.Bnd.Bnd_Box: 
        """
        Returns a bounding box of sensitive entities with the owners given if they are a part of activated selection
        """
    def BoundingBox(self,theBndBox : OCP.Bnd.Bnd_Box) -> None: 
        """
        Returns bounding box of object correspondingly to its current display mode. This method requires presentation to be already computed, since it relies on bounding box of presentation structures, which are supposed to be same/close amongst different display modes of this object.
        """
    def Children(self) -> OCP.PrsMgr.PrsMgr_ListOfPresentableObjects: 
        """
        Returns children of the current object.
        """
    def ClearDynamicHighlight(self,theMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> None: 
        """
        Method that needs to be implemented when the object manages selection and dynamic highlighting on its own. Clears or invalidates dynamic highlight presentation. By default it clears immediate draw of given presentation manager.
        """
    def ClearOwner(self) -> None: 
        """
        Each Interactive Object has methods which allow us to attribute an Owner to it in the form of a Transient. This method removes the owner from the graphic entity.
        """
    def ClearSelected(self) -> None: 
        """
        Method which clear all selected owners belonging to this selectable object ( for fast presentation draw )
        """
    def ClearSelections(self,update : bool=False) -> None: 
        """
        Empties all the selections in the SelectableObject <update> parameter defines whether all object's selections should be flagged for further update or not. This improved method can be used to recompute an object's selection (without redisplaying the object completely) when some selection mode is activated not for the first time.
        """
    def ClipPlanes(self) -> OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane: 
        """
        Get clip planes.
        """
    def Color(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Returns the color setting of the Interactive Object.
        """
    def CombinedParentTransformation(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return combined parent transformation.
        """
    def ComputeSelection(self,theSelection : OCP.SelectMgr.SelectMgr_Selection,theMode : int) -> None: 
        """
        Computes sensitive primitives for the given selection mode - key interface method of Selectable Object.
        """
    @overload
    def Connect(self,theAnotherObj : AIS_InteractiveObject,theLocation : OCP.gp.gp_Trsf) -> AIS_InteractiveObject: 
        """
        Establishes the connection between the Connected Interactive Object, theInteractive, and its reference. Locates instance in theLocation and applies specified transformation persistence mode.

        Establishes the connection between the Connected Interactive Object, theInteractive, and its reference. Copies local transformation and transformation persistence mode from theInteractive.

        Establishes the connection between the Connected Interactive Object, theInteractive, and its reference. Locates instance in theLocation and copies transformation persistence mode from theInteractive.

        Establishes the connection between the Connected Interactive Object, theInteractive, and its reference. Locates instance in theLocation and applies specified transformation persistence mode.
        """
    @overload
    def Connect(self,theAnotherObj : AIS_InteractiveObject,theLocation : OCP.gp.gp_Trsf,theTrsfPers : OCP.Graphic3d.Graphic3d_TransformPers) -> AIS_InteractiveObject: ...
    @overload
    def Connect(self,theAnotherObj : AIS_InteractiveObject,theLocation : OCP.TopLoc.TopLoc_Datum3D,theTrsfPers : OCP.Graphic3d.Graphic3d_TransformPers) -> AIS_InteractiveObject: ...
    @overload
    def Connect(self,theAnotherObj : AIS_InteractiveObject) -> AIS_InteractiveObject: ...
    def CurrentFacingModel(self) -> OCP.Aspect.Aspect_TypeOfFacingModel: 
        """
        Returns the current facing model which is in effect.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def DefaultDisplayMode(self) -> int: 
        """
        Returns the default display mode.
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def Disconnect(self,theInteractive : AIS_InteractiveObject) -> None: 
        """
        Removes the connection with theInteractive.
        """
    def DisconnectAll(self) -> None: 
        """
        Clears all the connections to objects.
        """
    def DisplayMode(self) -> int: 
        """
        Returns the display mode setting of the Interactive Object. The range of supported display mode indexes should be specified within object definition and filtered by AccepDisplayMode().
        """
    def DisplayStatus(self) -> OCP.PrsMgr.PrsMgr_DisplayStatus: 
        """
        Return presentation display status; PrsMgr_DisplayStatus_None by default.
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicHilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalDynamic and Prs3d_TypeOfHighlight_Dynamic defined within AIS_InteractiveContext::HighlightStyle().
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def ErasePresentations(self,theToRemove : bool) -> None: 
        """
        Removes presentations returned by GetHilightPresentation() and GetSelectPresentation().
        """
    def GetAssemblyOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns common entity owner if the object is an assembly
        """
    def GetContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def GetHilightPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting detected object.
        """
    def GetOwner(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns the owner of the Interactive Object. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient. There are two types of owners: - Direct owners, decomposition shapes such as edges, wires, and faces. - Users, presentable objects connecting to sensitive primitives, or a shape which has been decomposed.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def GetSelectPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting selected object.
        """
    def GlobalSelOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns the owner of mode for selection of object as a whole
        """
    def GlobalSelectionMode(self) -> int: 
        """
        Returns the mode for selection of object as a whole; 0 by default.
        """
    def HasColor(self) -> bool: 
        """
        Returns true if the Interactive Object has color.
        """
    def HasConnection(self) -> bool: 
        """
        Returns true if the object is connected to others.
        """
    def HasDisplayMode(self) -> bool: 
        """
        Returns true if the Interactive Object has display mode setting overriding global setting (within Interactive Context).
        """
    def HasHilightMode(self) -> bool: 
        """
        Returns true if the Interactive Object is in highlight mode.
        """
    def HasInteractiveContext(self) -> bool: 
        """
        Indicates whether the Interactive Object has a pointer to an interactive context.
        """
    def HasMaterial(self) -> bool: 
        """
        Returns true if the Interactive Object has a setting for material.
        """
    def HasOwnPresentations(self) -> bool: 
        """
        Returns true if object should have own presentations.
        """
    def HasOwner(self) -> bool: 
        """
        Returns true if the object has an owner attributed to it. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient.
        """
    def HasPolygonOffsets(self) -> bool: 
        """
        Returns Standard_True if <myDrawer> has non-null shading aspect
        """
    def HasPresentation(self) -> bool: 
        """
        Returns TRUE when this object has a presentation in the current DisplayMode()
        """
    def HasSelection(self,theMode : int) -> bool: 
        """
        Returns true if a selection corresponding to the selection mode theMode was computed for this object.
        """
    def HasTransformation(self) -> bool: 
        """
        Returns true if object has a transformation that is different from the identity.
        """
    def HasWidth(self) -> bool: 
        """
        Returns true if the Interactive Object has width.
        """
    def HilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalSelected and Prs3d_TypeOfHighlight_Selected defined within AIS_InteractiveContext::HighlightStyle().
        """
    def HilightMode(self) -> int: 
        """
        Returns highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def HilightOwnerWithColor(self,thePM : OCP.PrsMgr.PrsMgr_PresentationManager,theStyle : OCP.Prs3d.Prs3d_Drawer,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner) -> None: 
        """
        Method which hilight an owner belonging to this selectable object ( for fast presentation draw )
        """
    def HilightSelected(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager,theSeq : OCP.SelectMgr.SelectMgr_SequenceOfOwner) -> None: 
        """
        Method which draws selected owners ( for fast presentation draw )
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def InteractiveContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def InversedTransformation(self) -> OCP.gp.gp_GTrsf: 
        """
        Return inversed transformation.
        """
    def IsAutoHilight(self) -> bool: 
        """
        If returns True, the old mechanism for highlighting selected objects is used (HilightSelected Method may be empty). If returns False, the HilightSelected method will be fully responsible for highlighting selected entity owners belonging to this selectable object.
        """
    def IsInfinite(self) -> bool: 
        """
        Returns true if the interactive object is infinite; FALSE by default. This flag affects various operations operating on bounding box of graphic presentations of this object. For instance, infinite objects are not taken in account for View FitAll. This does not necessarily means that object is actually infinite, auxiliary objects might be also marked with this flag to achieve desired behavior.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def IsMutable(self) -> bool: 
        """
        Returns true if object has mutable nature (content or location are be changed regularly). Mutable object will be managed in different way than static onces (another optimizations).
        """
    def IsTransparent(self) -> bool: 
        """
        Returns true if there is a transparency setting.
        """
    def LocalTransformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def LocalTransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def Material(self) -> OCP.Graphic3d.Graphic3d_NameOfMaterial: 
        """
        Returns the current material setting as enumeration value.
        """
    def Parent(self) -> OCP.PrsMgr.PrsMgr_PresentableObject: 
        """
        Returns parent of current object in scene hierarchy.
        """
    def PolygonOffsets(self,aFactor : float,aUnits : float) -> tuple[int]: 
        """
        Retrieves current polygon offsets settings from <myDrawer>.
        """
    def Presentation(self) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Returns the current presentation of this object according to the current DisplayMode()
        """
    def Presentations(self) -> OCP.PrsMgr.PrsMgr_Presentations: 
        """
        Return presentations.
        """
    def ProcessDragging(self,theCtx : AIS_InteractiveContext,theView : OCP.V3d.V3d_View,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theDragFrom : OCP.Graphic3d.Graphic3d_Vec2i,theDragTo : OCP.Graphic3d.Graphic3d_Vec2i,theAction : AIS_DragAction) -> bool: 
        """
        Drag object in the viewer.
        """
    @overload
    def RecomputePrimitives(self) -> None: 
        """
        Re-computes the sensitive primitives for all modes. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.

        Re-computes the sensitive primitives which correspond to the <theMode>th selection mode. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.
        """
    @overload
    def RecomputePrimitives(self,theMode : int) -> None: ...
    def Redisplay(self,AllModes : bool=False) -> None: 
        """
        Updates the active presentation; if <AllModes> = Standard_True all the presentations inside are recomputed. IMPORTANT: It is preferable to call Redisplay method of corresponding AIS_InteractiveContext instance for cases when it is accessible. This method just redirects call to myCTXPtr, so this class field must be up to date for proper result.
        """
    def RemoveChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy.
        """
    def RemoveChildWithRestoreTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy with keeping the current global transformation. So the object keeps the same position/orientation in the global CS.
        """
    def RemoveClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Removes previously added clip plane.
        """
    def ResetTransformation(self) -> None: 
        """
        None
        """
    def Selection(self,theMode : int) -> OCP.SelectMgr.SelectMgr_Selection: 
        """
        Returns the selection having specified selection mode or NULL.
        """
    def Selections(self) -> OCP.SelectMgr.SelectMgr_SequenceOfSelection: 
        """
        Return the sequence of selections.
        """
    def SetAspect(self,anAspect : OCP.Prs3d.Prs3d_BasicAspect) -> None: 
        """
        Sets the graphic basic aspect to the current presentation.
        """
    def SetAssemblyOwner(self,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theMode : int=-1) -> None: 
        """
        Sets common entity owner for assembly sensitive object entities
        """
    def SetAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the drawing tool theDrawer.
        """
    def SetAutoHilight(self,theAutoHilight : bool) -> None: 
        """
        Set AutoHilight property to true or false.
        """
    def SetClipPlanes(self,thePlanes : OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane) -> None: 
        """
        Set clip planes for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def SetColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Only the interactive object knowns which Drawer attribute is affected by the color, if any (ex: for a wire,it's the wireaspect field of the drawer, but for a vertex, only the point aspect field is affected by the color). WARNING : Do not forget to set the corresponding fields here (hasOwnColor and myDrawer->SetColor())
        """
    def SetContext(self,theCtx : AIS_InteractiveContext) -> None: 
        """
        Assigns interactive context.
        """
    def SetCurrentFacingModel(self,theModel : OCP.Aspect.Aspect_TypeOfFacingModel=Aspect_TypeOfFacingModel.Aspect_TOFM_BOTH_SIDE) -> None: 
        """
        change the current facing model apply on polygons for SetColor(), SetTransparency(), SetMaterial() methods default facing model is Aspect_TOFM_TWO_SIDE. This mean that attributes is applying both on the front and back face.
        """
    def SetDisplayMode(self,theMode : int) -> None: 
        """
        Sets the display mode for the interactive object. An object can have its own temporary display mode, which is different from that proposed by the interactive context.
        """
    def SetDynamicHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the dynamic hilight drawing tool.
        """
    def SetHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the hilight drawing tool theDrawer.
        """
    def SetHilightMode(self,theMode : int) -> None: 
        """
        Sets highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def SetInfiniteState(self,theFlag : bool=True) -> None: 
        """
        Sets if object should be considered as infinite.
        """
    def SetIsoOnTriangulation(self,theIsEnabled : bool) -> None: 
        """
        Enables or disables on-triangulation build of isolines according to the flag given.
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.gp.gp_Trsf) -> None: 
        """
        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.

        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.TopLoc.TopLoc_Datum3D) -> None: ...
    def SetMaterial(self,aName : OCP.Graphic3d.Graphic3d_MaterialAspect) -> None: 
        """
        Sets the material aMat defining this display attribute for the interactive object. Material aspect determines shading aspect, color and transparency of visible entities.
        """
    def SetMutable(self,theIsMutable : bool) -> None: 
        """
        Sets if the object has mutable nature (content or location will be changed regularly). This method should be called before object displaying to take effect.
        """
    def SetOwner(self,theApplicativeEntity : OCP.Standard.Standard_Transient) -> None: 
        """
        Allows you to attribute the owner theApplicativeEntity to an Interactive Object. This can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of. The owner takes the form of a transient.
        """
    def SetPolygonOffsets(self,aMode : int,aFactor : float=1.0,aUnits : float=0.0) -> None: 
        """
        Sets up polygon offsets for this object.
        """
    def SetPropagateVisualState(self,theFlag : bool) -> None: 
        """
        Change the value of the flag "propagate visual state"
        """
    @overload
    def SetToUpdate(self) -> None: 
        """
        Flags presentation to be updated; UpdatePresentations() will recompute these presentations.

        flags all the Presentations to be Updated.
        """
    @overload
    def SetToUpdate(self,theMode : int) -> None: ...
    def SetTransformPersistence(self,theTrsfPers : OCP.Graphic3d.Graphic3d_TransformPers) -> None: 
        """
        Sets up Transform Persistence defining a special Local Coordinate system where this object should be located. Note that management of Transform Persistence object is more expensive than of the normal one, because it requires its position being recomputed basing on camera position within each draw call / traverse.
        """
    def SetTransparency(self,aValue : float=0.6) -> None: 
        """
        Attributes a setting aValue for transparency. The transparency value should be between 0.0 and 1.0. At 0.0 an object will be totally opaque, and at 1.0, fully transparent. Warning At a value of 1.0, there may be nothing visible.
        """
    def SetTypeOfPresentation(self,theType : OCP.PrsMgr.PrsMgr_TypeOfPresentation3d) -> None: 
        """
        Set type of presentation.
        """
    def SetWidth(self,theWidth : float) -> None: 
        """
        Allows you to provide the setting aValue for width. Only the Interactive Object knows which Drawer attribute is affected by the width setting.
        """
    def SetZLayer(self,theLayerId : int) -> None: 
        """
        Set Z layer ID and update all presentations of the selectable object. The layers mechanism allows drawing objects in higher layers in overlay of objects in lower layers.
        """
    def Signature(self) -> int: 
        """
        None
        """
    def SynchronizeAspects(self) -> None: 
        """
        Synchronize presentation aspects after their modification.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    @overload
    def ToBeUpdated(self,ListOfMode : OCP.TColStd.TColStd_ListOfInteger) -> None: 
        """
        Returns TRUE if any active presentation has invalidation flag.

        gives the list of modes which are flagged "to be updated".
        """
    @overload
    def ToBeUpdated(self,theToIncludeHidden : bool=False) -> bool: ...
    def ToPropagateVisualState(self) -> bool: 
        """
        Get value of the flag "propagate visual state" It means that the display/erase/color visual state is propagated automatically to all children; by default, the flag is true
        """
    def TransformPersistence(self) -> OCP.Graphic3d.Graphic3d_TransformPers: 
        """
        Returns Transformation Persistence defining a special Local Coordinate system where this presentable object is located or NULL handle if not defined. Position of the object having Transformation Persistence is mutable and depends on camera position. The same applies to a bounding box of the object.
        """
    def Transformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def TransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def Transparency(self) -> float: 
        """
        Returns the transparency setting. This will be between 0.0 and 1.0. At 0.0 an object will be totally opaque, and at 1.0, fully transparent.
        """
    def Type(self) -> AIS_KindOfInteractive: 
        """
        None
        """
    def TypeOfPresentation3d(self) -> OCP.PrsMgr.PrsMgr_TypeOfPresentation3d: 
        """
        Returns information on whether the object accepts display in HLR mode or not.
        """
    def UnsetAttributes(self) -> None: 
        """
        Clears settings provided by the drawing tool aDrawer.
        """
    def UnsetColor(self) -> None: 
        """
        Removes color settings. Only the Interactive Object knows which Drawer attribute is affected by the color setting. For a wire, for example, wire aspect is the attribute affected. For a vertex, however, only point aspect is affected by the color setting.
        """
    def UnsetDisplayMode(self) -> None: 
        """
        Removes display mode settings from the interactive object.
        """
    def UnsetHilightAttributes(self) -> None: 
        """
        Clears settings provided by the hilight drawing tool theDrawer.
        """
    def UnsetHilightMode(self) -> None: 
        """
        Unsets highlight display mode.
        """
    def UnsetMaterial(self) -> None: 
        """
        Removes the setting for material.
        """
    def UnsetTransparency(self) -> None: 
        """
        Removes the transparency setting. The object is opaque by default.
        """
    def UnsetWidth(self) -> None: 
        """
        Reset width to default value.
        """
    def UpdateSelection(self,theMode : int=-1) -> None: 
        """
        Sets update status FULL to selections of the object. Must be used as the only method of UpdateSelection from outer classes to prevent BVH structures from being outdated.
        """
    def UpdateTransformation(self) -> None: 
        """
        Recomputes the location of the selection aSelection.
        """
    def UpdateTransformations(self,aSelection : OCP.SelectMgr.SelectMgr_Selection) -> None: 
        """
        Updates locations in all sensitive entities from <aSelection> and in corresponding entity owners.
        """
    def ViewAffinity(self) -> OCP.Graphic3d.Graphic3d_ViewAffinity: 
        """
        Return view affinity mask.
        """
    def Width(self) -> float: 
        """
        Returns the width setting of the Interactive Object.
        """
    def ZLayer(self) -> int: 
        """
        Get ID of Z layer for main presentation.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class AIS_NArray1OfEntityOwner():
    """
    The class NCollection_Array1 represents unidimensional arrays of fixed size known at run time. The range of the index is user defined. An array1 can be constructed with a "C array". This functionality is useful to call methods expecting an Array1. It allows to carry the bounds inside the arrays.
    """
    def Assign(self,theOther : AIS_NArray1OfEntityOwner) -> AIS_NArray1OfEntityOwner: 
        """
        Copies data of theOther array to this. This array should be pre-allocated and have the same length as theOther; otherwise exception Standard_DimensionMismatch is thrown.
        """
    def Init(self,theValue : OCP.SelectMgr.SelectMgr_EntityOwner) -> None: 
        """
        Initialise the items with theValue
        """
    def IsDeletable(self) -> bool: 
        """
        None
        """
    def IsEmpty(self) -> bool: 
        """
        Return TRUE if array has zero length.
        """
    def Length(self) -> int: 
        """
        Length query (the same)
        """
    def Lower(self) -> int: 
        """
        Lower bound
        """
    def Move(self,theOther : AIS_NArray1OfEntityOwner) -> AIS_NArray1OfEntityOwner: 
        """
        None
        """
    def Resize(self,theLower : int,theUpper : int,theToCopyData : bool) -> None: 
        """
        Resizes the array to specified bounds. No re-allocation will be done if length of array does not change, but existing values will not be discarded if theToCopyData set to FALSE.
        """
    def SetValue(self,theIndex : int,theItem : OCP.SelectMgr.SelectMgr_EntityOwner) -> None: 
        """
        Set value
        """
    def Size(self) -> int: 
        """
        Size query
        """
    def UpdateLowerBound(self,theLower : int) -> None: 
        """
        Changes the lowest bound. Do not move data
        """
    def UpdateUpperBound(self,theUpper : int) -> None: 
        """
        Changes the upper bound. Do not move data
        """
    def Upper(self) -> int: 
        """
        Upper bound
        """
    def __bool__(self) -> bool: ...
    def __call__(self,theIndex : int) -> OCP.SelectMgr.SelectMgr_EntityOwner: ...
    @overload
    def __init__(self,theAlloc : Any,theLower : int,theUpper : int) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theLower : int,theUpper : int) -> None: ...
    @overload
    def __init__(self,theOther : AIS_NArray1OfEntityOwner) -> None: ...
    def __iter__(self) -> Iterator[OCP.SelectMgr.SelectMgr_EntityOwner]: ...
    def __len__(self) -> int: ...
    pass
class AIS_NListOfEntityOwner(OCP.NCollection.NCollection_BaseList):
    """
    Purpose: Simple list to link items together keeping the first and the last one. Inherits BaseList, adding the data item to each node.
    """
    def Allocator(self) -> OCP.NCollection.NCollection_BaseAllocator: 
        """
        Returns attached allocator
        """
    @overload
    def Append(self,theItem : OCP.SelectMgr.SelectMgr_EntityOwner,theIter : Any) -> None: 
        """
        Append one item at the end

        Append one item at the end and output iterator pointing at the appended item

        Append another list at the end. After this operation, theOther list will be cleared.
        """
    @overload
    def Append(self,theOther : AIS_NListOfEntityOwner) -> None: ...
    @overload
    def Append(self,theItem : OCP.SelectMgr.SelectMgr_EntityOwner) -> OCP.SelectMgr.SelectMgr_EntityOwner: ...
    def Assign(self,theOther : AIS_NListOfEntityOwner) -> AIS_NListOfEntityOwner: 
        """
        Replace this list by the items of another list (theOther parameter). This method does not change the internal allocator.
        """
    def Clear(self,theAllocator : OCP.NCollection.NCollection_BaseAllocator=None) -> None: 
        """
        Clear this list
        """
    def Extent(self) -> int: 
        """
        None
        """
    def First(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        First item

        First item (non-const)
        """
    @overload
    def InsertAfter(self,theItem : OCP.SelectMgr.SelectMgr_EntityOwner,theIter : Any) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        InsertAfter

        InsertAfter
        """
    @overload
    def InsertAfter(self,theOther : AIS_NListOfEntityOwner,theIter : Any) -> None: ...
    @overload
    def InsertBefore(self,theOther : AIS_NListOfEntityOwner,theIter : Any) -> None: 
        """
        InsertBefore

        InsertBefore
        """
    @overload
    def InsertBefore(self,theItem : OCP.SelectMgr.SelectMgr_EntityOwner,theIter : Any) -> OCP.SelectMgr.SelectMgr_EntityOwner: ...
    def IsEmpty(self) -> bool: 
        """
        None
        """
    def Last(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Last item

        Last item (non-const)
        """
    @overload
    def Prepend(self,theItem : OCP.SelectMgr.SelectMgr_EntityOwner) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Prepend one item at the beginning

        Prepend another list at the beginning
        """
    @overload
    def Prepend(self,theOther : AIS_NListOfEntityOwner) -> None: ...
    def Remove(self,theIter : Any) -> None: 
        """
        Remove item pointed by iterator theIter; theIter is then set to the next item
        """
    def RemoveFirst(self) -> None: 
        """
        RemoveFirst item
        """
    def Reverse(self) -> None: 
        """
        Reverse the list
        """
    def Size(self) -> int: 
        """
        Size - Number of items
        """
    @overload
    def __init__(self,theAllocator : OCP.NCollection.NCollection_BaseAllocator) -> None: ...
    @overload
    def __init__(self,theOther : AIS_NListOfEntityOwner) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def __iter__(self) -> Iterator[OCP.SelectMgr.SelectMgr_EntityOwner]: ...
    def __len__(self) -> int: ...
    pass
class AIS_NavigationMode():
    """
    Camera navigation mode.

    Members:

      AIS_NavigationMode_Orbit

      AIS_NavigationMode_FirstPersonFlight

      AIS_NavigationMode_FirstPersonWalk
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    AIS_NavigationMode_FirstPersonFlight: OCP.AIS.AIS_NavigationMode # value = <AIS_NavigationMode.AIS_NavigationMode_FirstPersonFlight: 1>
    AIS_NavigationMode_FirstPersonWalk: OCP.AIS.AIS_NavigationMode # value = <AIS_NavigationMode.AIS_NavigationMode_FirstPersonWalk: 2>
    AIS_NavigationMode_Orbit: OCP.AIS.AIS_NavigationMode # value = <AIS_NavigationMode.AIS_NavigationMode_Orbit: 0>
    __entries: dict # value = {'AIS_NavigationMode_Orbit': (<AIS_NavigationMode.AIS_NavigationMode_Orbit: 0>, None), 'AIS_NavigationMode_FirstPersonFlight': (<AIS_NavigationMode.AIS_NavigationMode_FirstPersonFlight: 1>, None), 'AIS_NavigationMode_FirstPersonWalk': (<AIS_NavigationMode.AIS_NavigationMode_FirstPersonWalk: 2>, None)}
    __members__: dict # value = {'AIS_NavigationMode_Orbit': <AIS_NavigationMode.AIS_NavigationMode_Orbit: 0>, 'AIS_NavigationMode_FirstPersonFlight': <AIS_NavigationMode.AIS_NavigationMode_FirstPersonFlight: 1>, 'AIS_NavigationMode_FirstPersonWalk': <AIS_NavigationMode.AIS_NavigationMode_FirstPersonWalk: 2>}
    pass
class AIS_Plane(AIS_InteractiveObject, OCP.SelectMgr.SelectMgr_SelectableObject, OCP.PrsMgr.PrsMgr_PresentableObject, OCP.Standard.Standard_Transient):
    """
    Constructs plane datums to be used in construction of composite shapes.Constructs plane datums to be used in construction of composite shapes.
    """
    def AcceptDisplayMode(self,aMode : int) -> bool: 
        """
        Returns true if the display mode selected, aMode, is valid for planes.
        """
    def AcceptShapeDecomposition(self) -> bool: 
        """
        Informs the graphic context that the interactive Object may be decomposed into sub-shapes for dynamic selection. The most used Interactive Object is AIS_Shape.
        """
    def AddChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy.
        """
    def AddChildWithCurrentTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy with keeping the current global transformation So the object keeps the same position/orientation in the global CS.
        """
    def AddClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Adds clip plane for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def AddSelection(self,aSelection : OCP.SelectMgr.SelectMgr_Selection,aMode : int) -> None: 
        """
        Adds the selection aSelection with the selection mode index aMode to this framework.
        """
    def Attributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the attributes settings.
        """
    def Axis2Placement(self) -> OCP.Geom.Geom_Axis2Placement: 
        """
        Returns the position of the plane's axis2 system identifying the x, y, or z axis and giving the plane a direction in 3D space. An axis2 system is a right-handed coordinate system.
        """
    def BndBoxOfSelected(self,theOwners : Any) -> OCP.Bnd.Bnd_Box: 
        """
        Returns a bounding box of sensitive entities with the owners given if they are a part of activated selection
        """
    def BoundingBox(self,theBndBox : OCP.Bnd.Bnd_Box) -> None: 
        """
        Returns bounding box of object correspondingly to its current display mode. This method requires presentation to be already computed, since it relies on bounding box of presentation structures, which are supposed to be same/close amongst different display modes of this object.
        """
    def Center(self) -> OCP.gp.gp_Pnt: 
        """
        Returns the coordinates of the center point.
        """
    def Children(self) -> OCP.PrsMgr.PrsMgr_ListOfPresentableObjects: 
        """
        Returns children of the current object.
        """
    def ClearDynamicHighlight(self,theMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> None: 
        """
        Method that needs to be implemented when the object manages selection and dynamic highlighting on its own. Clears or invalidates dynamic highlight presentation. By default it clears immediate draw of given presentation manager.
        """
    def ClearOwner(self) -> None: 
        """
        Each Interactive Object has methods which allow us to attribute an Owner to it in the form of a Transient. This method removes the owner from the graphic entity.
        """
    def ClearSelected(self) -> None: 
        """
        Method which clear all selected owners belonging to this selectable object ( for fast presentation draw )
        """
    def ClearSelections(self,update : bool=False) -> None: 
        """
        Empties all the selections in the SelectableObject <update> parameter defines whether all object's selections should be flagged for further update or not. This improved method can be used to recompute an object's selection (without redisplaying the object completely) when some selection mode is activated not for the first time.
        """
    def ClipPlanes(self) -> OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane: 
        """
        Get clip planes.
        """
    def Color(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Returns the color setting of the Interactive Object.
        """
    def CombinedParentTransformation(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return combined parent transformation.
        """
    def Component(self) -> OCP.Geom.Geom_Plane: 
        """
        Returns the component specified in SetComponent.
        """
    def ComputeSelection(self,theSelection : OCP.SelectMgr.SelectMgr_Selection,theMode : int) -> None: 
        """
        None
        """
    def CurrentFacingModel(self) -> OCP.Aspect.Aspect_TypeOfFacingModel: 
        """
        Returns the current facing model which is in effect.
        """
    def CurrentMode(self) -> bool: 
        """
        Returns the non-default current display mode set by SetCurrentMode.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def DefaultDisplayMode(self) -> int: 
        """
        Returns the default display mode.
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DisplayMode(self) -> int: 
        """
        Returns the display mode setting of the Interactive Object. The range of supported display mode indexes should be specified within object definition and filtered by AccepDisplayMode().
        """
    def DisplayStatus(self) -> OCP.PrsMgr.PrsMgr_DisplayStatus: 
        """
        Return presentation display status; PrsMgr_DisplayStatus_None by default.
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicHilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalDynamic and Prs3d_TypeOfHighlight_Dynamic defined within AIS_InteractiveContext::HighlightStyle().
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def ErasePresentations(self,theToRemove : bool) -> None: 
        """
        Removes presentations returned by GetHilightPresentation() and GetSelectPresentation().
        """
    def GetAssemblyOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns common entity owner if the object is an assembly
        """
    def GetContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def GetHilightPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting detected object.
        """
    def GetOwner(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns the owner of the Interactive Object. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient. There are two types of owners: - Direct owners, decomposition shapes such as edges, wires, and faces. - Users, presentable objects connecting to sensitive primitives, or a shape which has been decomposed.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def GetSelectPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting selected object.
        """
    def GlobalSelOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns the owner of mode for selection of object as a whole
        """
    def GlobalSelectionMode(self) -> int: 
        """
        Returns the mode for selection of object as a whole; 0 by default.
        """
    def HasColor(self) -> bool: 
        """
        Returns true if the Interactive Object has color.
        """
    def HasDisplayMode(self) -> bool: 
        """
        Returns true if the Interactive Object has display mode setting overriding global setting (within Interactive Context).
        """
    def HasHilightMode(self) -> bool: 
        """
        Returns true if the Interactive Object is in highlight mode.
        """
    def HasInteractiveContext(self) -> bool: 
        """
        Indicates whether the Interactive Object has a pointer to an interactive context.
        """
    def HasMaterial(self) -> bool: 
        """
        Returns true if the Interactive Object has a setting for material.
        """
    def HasMinimumSize(self) -> bool: 
        """
        Returns true if transform persistence for zoom is set
        """
    def HasOwnPresentations(self) -> bool: 
        """
        Returns true if object should have own presentations.
        """
    def HasOwnSize(self) -> bool: 
        """
        None
        """
    def HasOwner(self) -> bool: 
        """
        Returns true if the object has an owner attributed to it. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient.
        """
    def HasPolygonOffsets(self) -> bool: 
        """
        Returns Standard_True if <myDrawer> has non-null shading aspect
        """
    def HasPresentation(self) -> bool: 
        """
        Returns TRUE when this object has a presentation in the current DisplayMode()
        """
    def HasSelection(self,theMode : int) -> bool: 
        """
        Returns true if a selection corresponding to the selection mode theMode was computed for this object.
        """
    def HasTransformation(self) -> bool: 
        """
        Returns true if object has a transformation that is different from the identity.
        """
    def HasWidth(self) -> bool: 
        """
        Returns true if the Interactive Object has width.
        """
    def HilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalSelected and Prs3d_TypeOfHighlight_Selected defined within AIS_InteractiveContext::HighlightStyle().
        """
    def HilightMode(self) -> int: 
        """
        Returns highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def HilightOwnerWithColor(self,thePM : OCP.PrsMgr.PrsMgr_PresentationManager,theStyle : OCP.Prs3d.Prs3d_Drawer,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner) -> None: 
        """
        Method which hilight an owner belonging to this selectable object ( for fast presentation draw )
        """
    def HilightSelected(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager,theSeq : OCP.SelectMgr.SelectMgr_SequenceOfOwner) -> None: 
        """
        Method which draws selected owners ( for fast presentation draw )
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def InteractiveContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def InversedTransformation(self) -> OCP.gp.gp_GTrsf: 
        """
        Return inversed transformation.
        """
    def IsAutoHilight(self) -> bool: 
        """
        If returns True, the old mechanism for highlighting selected objects is used (HilightSelected Method may be empty). If returns False, the HilightSelected method will be fully responsible for highlighting selected entity owners belonging to this selectable object.
        """
    def IsInfinite(self) -> bool: 
        """
        Returns true if the interactive object is infinite; FALSE by default. This flag affects various operations operating on bounding box of graphic presentations of this object. For instance, infinite objects are not taken in account for View FitAll. This does not necessarily means that object is actually infinite, auxiliary objects might be also marked with this flag to achieve desired behavior.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def IsMutable(self) -> bool: 
        """
        Returns true if object has mutable nature (content or location are be changed regularly). Mutable object will be managed in different way than static onces (another optimizations).
        """
    def IsTransparent(self) -> bool: 
        """
        Returns true if there is a transparency setting.
        """
    def IsXYZPlane(self) -> bool: 
        """
        Returns the type of plane - xy, yz, or xz.
        """
    def LocalTransformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def LocalTransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def Material(self) -> OCP.Graphic3d.Graphic3d_NameOfMaterial: 
        """
        Returns the current material setting as enumeration value.
        """
    def Parent(self) -> OCP.PrsMgr.PrsMgr_PresentableObject: 
        """
        Returns parent of current object in scene hierarchy.
        """
    def PlaneAttributes(self,aComponent : OCP.Geom.Geom_Plane,aCenter : OCP.gp.gp_Pnt,aPmin : OCP.gp.gp_Pnt,aPmax : OCP.gp.gp_Pnt) -> bool: 
        """
        Returns the settings for the selected plane aComponent, provided in SetPlaneAttributes. These include the points aCenter, aPmin, and aPmax
        """
    def PolygonOffsets(self,aFactor : float,aUnits : float) -> tuple[int]: 
        """
        Retrieves current polygon offsets settings from <myDrawer>.
        """
    def Presentation(self) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Returns the current presentation of this object according to the current DisplayMode()
        """
    def Presentations(self) -> OCP.PrsMgr.PrsMgr_Presentations: 
        """
        Return presentations.
        """
    def ProcessDragging(self,theCtx : AIS_InteractiveContext,theView : OCP.V3d.V3d_View,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theDragFrom : OCP.Graphic3d.Graphic3d_Vec2i,theDragTo : OCP.Graphic3d.Graphic3d_Vec2i,theAction : AIS_DragAction) -> bool: 
        """
        Drag object in the viewer.
        """
    @overload
    def RecomputePrimitives(self) -> None: 
        """
        Re-computes the sensitive primitives for all modes. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.

        Re-computes the sensitive primitives which correspond to the <theMode>th selection mode. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.
        """
    @overload
    def RecomputePrimitives(self,theMode : int) -> None: ...
    def Redisplay(self,AllModes : bool=False) -> None: 
        """
        Updates the active presentation; if <AllModes> = Standard_True all the presentations inside are recomputed. IMPORTANT: It is preferable to call Redisplay method of corresponding AIS_InteractiveContext instance for cases when it is accessible. This method just redirects call to myCTXPtr, so this class field must be up to date for proper result.
        """
    def RemoveChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy.
        """
    def RemoveChildWithRestoreTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy with keeping the current global transformation. So the object keeps the same position/orientation in the global CS.
        """
    def RemoveClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Removes previously added clip plane.
        """
    def ResetTransformation(self) -> None: 
        """
        None
        """
    def Selection(self,theMode : int) -> OCP.SelectMgr.SelectMgr_Selection: 
        """
        Returns the selection having specified selection mode or NULL.
        """
    def Selections(self) -> OCP.SelectMgr.SelectMgr_SequenceOfSelection: 
        """
        Return the sequence of selections.
        """
    def SetAspect(self,anAspect : OCP.Prs3d.Prs3d_BasicAspect) -> None: 
        """
        Sets the graphic basic aspect to the current presentation.
        """
    def SetAssemblyOwner(self,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theMode : int=-1) -> None: 
        """
        Sets common entity owner for assembly sensitive object entities
        """
    def SetAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the drawing tool theDrawer.
        """
    def SetAutoHilight(self,theAutoHilight : bool) -> None: 
        """
        Set AutoHilight property to true or false.
        """
    def SetAxis2Placement(self,aComponent : OCP.Geom.Geom_Axis2Placement,aPlaneType : AIS_TypeOfPlane) -> None: 
        """
        Allows you to provide settings for the position and direction of one of the plane's axes, aComponent, in 3D space. The coordinate system used is right-handed, and the type of plane aPlaneType is one of: - AIS_ TOPL_Unknown - AIS_ TOPL_XYPlane - AIS_ TOPL_XZPlane - AIS_ TOPL_YZPlane}.
        """
    def SetCenter(self,theCenter : OCP.gp.gp_Pnt) -> None: 
        """
        Provides settings for the center theCenter other than (0, 0, 0).
        """
    def SetClipPlanes(self,thePlanes : OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane) -> None: 
        """
        Set clip planes for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def SetColor(self,aColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        None
        """
    def SetComponent(self,aComponent : OCP.Geom.Geom_Plane) -> None: 
        """
        Creates an instance of the plane aComponent.
        """
    def SetContext(self,aCtx : AIS_InteractiveContext) -> None: 
        """
        connection to <aCtx> default drawer implies a recomputation of Frame values.
        """
    def SetCurrentFacingModel(self,theModel : OCP.Aspect.Aspect_TypeOfFacingModel=Aspect_TypeOfFacingModel.Aspect_TOFM_BOTH_SIDE) -> None: 
        """
        change the current facing model apply on polygons for SetColor(), SetTransparency(), SetMaterial() methods default facing model is Aspect_TOFM_TWO_SIDE. This mean that attributes is applying both on the front and back face.
        """
    def SetCurrentMode(self,theCurrentMode : bool) -> None: 
        """
        Allows you to provide settings for a non-default current display mode.
        """
    def SetDisplayMode(self,theMode : int) -> None: 
        """
        Sets the display mode for the interactive object. An object can have its own temporary display mode, which is different from that proposed by the interactive context.
        """
    def SetDynamicHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the dynamic hilight drawing tool.
        """
    def SetHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the hilight drawing tool theDrawer.
        """
    def SetHilightMode(self,theMode : int) -> None: 
        """
        Sets highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def SetInfiniteState(self,theFlag : bool=True) -> None: 
        """
        Sets if object should be considered as infinite.
        """
    def SetIsoOnTriangulation(self,theIsEnabled : bool) -> None: 
        """
        Enables or disables on-triangulation build of isolines according to the flag given.
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.gp.gp_Trsf) -> None: 
        """
        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.

        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.TopLoc.TopLoc_Datum3D) -> None: ...
    def SetMaterial(self,aName : OCP.Graphic3d.Graphic3d_MaterialAspect) -> None: 
        """
        Sets the material aMat defining this display attribute for the interactive object. Material aspect determines shading aspect, color and transparency of visible entities.
        """
    def SetMinimumSize(self,theValue : float) -> None: 
        """
        Sets transform persistence for zoom with value of minimum size
        """
    def SetMutable(self,theIsMutable : bool) -> None: 
        """
        Sets if the object has mutable nature (content or location will be changed regularly). This method should be called before object displaying to take effect.
        """
    def SetOwner(self,theApplicativeEntity : OCP.Standard.Standard_Transient) -> None: 
        """
        Allows you to attribute the owner theApplicativeEntity to an Interactive Object. This can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of. The owner takes the form of a transient.
        """
    def SetPlaneAttributes(self,aComponent : OCP.Geom.Geom_Plane,aCenter : OCP.gp.gp_Pnt,aPmin : OCP.gp.gp_Pnt,aPmax : OCP.gp.gp_Pnt) -> None: 
        """
        Allows you to provide settings other than default ones for the selected plane. These include: center point aCenter, maximum aPmax and minimum aPmin.
        """
    def SetPolygonOffsets(self,aMode : int,aFactor : float=1.0,aUnits : float=0.0) -> None: 
        """
        Sets up polygon offsets for this object.
        """
    def SetPropagateVisualState(self,theFlag : bool) -> None: 
        """
        Change the value of the flag "propagate visual state"
        """
    @overload
    def SetSize(self,Xval : float,YVal : float) -> None: 
        """
        Same value for x and y directions

        Sets the size defined by the length along the X axis XVal and the length along the Y axis YVal.
        """
    @overload
    def SetSize(self,aValue : float) -> None: ...
    @overload
    def SetToUpdate(self) -> None: 
        """
        Flags presentation to be updated; UpdatePresentations() will recompute these presentations.

        flags all the Presentations to be Updated.
        """
    @overload
    def SetToUpdate(self,theMode : int) -> None: ...
    def SetTransformPersistence(self,theTrsfPers : OCP.Graphic3d.Graphic3d_TransformPers) -> None: 
        """
        Sets up Transform Persistence defining a special Local Coordinate system where this object should be located. Note that management of Transform Persistence object is more expensive than of the normal one, because it requires its position being recomputed basing on camera position within each draw call / traverse.
        """
    def SetTransparency(self,aValue : float=0.6) -> None: 
        """
        Attributes a setting aValue for transparency. The transparency value should be between 0.0 and 1.0. At 0.0 an object will be totally opaque, and at 1.0, fully transparent. Warning At a value of 1.0, there may be nothing visible.
        """
    def SetTypeOfPresentation(self,theType : OCP.PrsMgr.PrsMgr_TypeOfPresentation3d) -> None: 
        """
        Set type of presentation.
        """
    def SetTypeOfSensitivity(self,theTypeOfSensitivity : OCP.Select3D.Select3D_TypeOfSensitivity) -> None: 
        """
        Sets the type of sensitivity for the plane.
        """
    def SetWidth(self,theWidth : float) -> None: 
        """
        Allows you to provide the setting aValue for width. Only the Interactive Object knows which Drawer attribute is affected by the width setting.
        """
    def SetZLayer(self,theLayerId : int) -> None: 
        """
        Set Z layer ID and update all presentations of the selectable object. The layers mechanism allows drawing objects in higher layers in overlay of objects in lower layers.
        """
    def Signature(self) -> int: 
        """
        None
        """
    def Size(self,X : float,Y : float) -> bool: 
        """
        None
        """
    def SynchronizeAspects(self) -> None: 
        """
        Synchronize presentation aspects after their modification.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    @overload
    def ToBeUpdated(self,ListOfMode : OCP.TColStd.TColStd_ListOfInteger) -> None: 
        """
        Returns TRUE if any active presentation has invalidation flag.

        gives the list of modes which are flagged "to be updated".
        """
    @overload
    def ToBeUpdated(self,theToIncludeHidden : bool=False) -> bool: ...
    def ToPropagateVisualState(self) -> bool: 
        """
        Get value of the flag "propagate visual state" It means that the display/erase/color visual state is propagated automatically to all children; by default, the flag is true
        """
    def TransformPersistence(self) -> OCP.Graphic3d.Graphic3d_TransformPers: 
        """
        Returns Transformation Persistence defining a special Local Coordinate system where this presentable object is located or NULL handle if not defined. Position of the object having Transformation Persistence is mutable and depends on camera position. The same applies to a bounding box of the object.
        """
    def Transformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def TransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def Transparency(self) -> float: 
        """
        Returns the transparency setting. This will be between 0.0 and 1.0. At 0.0 an object will be totally opaque, and at 1.0, fully transparent.
        """
    def Type(self) -> AIS_KindOfInteractive: 
        """
        None
        """
    def TypeOfPlane(self) -> AIS_TypeOfPlane: 
        """
        Returns the type of plane - xy, yz, xz or unknown.
        """
    def TypeOfPresentation3d(self) -> OCP.PrsMgr.PrsMgr_TypeOfPresentation3d: 
        """
        Returns information on whether the object accepts display in HLR mode or not.
        """
    def TypeOfSensitivity(self) -> OCP.Select3D.Select3D_TypeOfSensitivity: 
        """
        Returns the type of sensitivity for the plane;
        """
    def UnsetAttributes(self) -> None: 
        """
        Clears settings provided by the drawing tool aDrawer.
        """
    def UnsetColor(self) -> None: 
        """
        None
        """
    def UnsetDisplayMode(self) -> None: 
        """
        Removes display mode settings from the interactive object.
        """
    def UnsetHilightAttributes(self) -> None: 
        """
        Clears settings provided by the hilight drawing tool theDrawer.
        """
    def UnsetHilightMode(self) -> None: 
        """
        Unsets highlight display mode.
        """
    def UnsetMaterial(self) -> None: 
        """
        Removes the setting for material.
        """
    def UnsetMinimumSize(self) -> None: 
        """
        Unsets transform persistence zoom
        """
    def UnsetSize(self) -> None: 
        """
        None
        """
    def UnsetTransparency(self) -> None: 
        """
        Removes the transparency setting. The object is opaque by default.
        """
    def UnsetWidth(self) -> None: 
        """
        Reset width to default value.
        """
    def UpdateSelection(self,theMode : int=-1) -> None: 
        """
        Sets update status FULL to selections of the object. Must be used as the only method of UpdateSelection from outer classes to prevent BVH structures from being outdated.
        """
    def UpdateTransformation(self) -> None: 
        """
        Recomputes the location of the selection aSelection.
        """
    def UpdateTransformations(self,aSelection : OCP.SelectMgr.SelectMgr_Selection) -> None: 
        """
        Updates locations in all sensitive entities from <aSelection> and in corresponding entity owners.
        """
    def ViewAffinity(self) -> OCP.Graphic3d.Graphic3d_ViewAffinity: 
        """
        Return view affinity mask.
        """
    def Width(self) -> float: 
        """
        Returns the width setting of the Interactive Object.
        """
    def ZLayer(self) -> int: 
        """
        Get ID of Z layer for main presentation.
        """
    @overload
    def __init__(self,aComponent : OCP.Geom.Geom_Axis2Placement,aPlaneType : AIS_TypeOfPlane,aCurrentMode : bool=False) -> None: ...
    @overload
    def __init__(self,aComponent : OCP.Geom.Geom_Plane,aCenter : OCP.gp.gp_Pnt,aPmin : OCP.gp.gp_Pnt,aPmax : OCP.gp.gp_Pnt,aCurrentMode : bool=False) -> None: ...
    @overload
    def __init__(self,aComponent : OCP.Geom.Geom_Plane,aCurrentMode : bool=False) -> None: ...
    @overload
    def __init__(self,aComponent : OCP.Geom.Geom_Plane,aCenter : OCP.gp.gp_Pnt,aCurrentMode : bool=False) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class AIS_PlaneTrihedron(AIS_InteractiveObject, OCP.SelectMgr.SelectMgr_SelectableObject, OCP.PrsMgr.PrsMgr_PresentableObject, OCP.Standard.Standard_Transient):
    """
    To construct a selectable 2d axis system in a 3d drawing. This can be placed anywhere in the 3d system, and provides a coordinate system for drawing curves and shapes in a plane. There are 3 selection modes: - mode 0 selection of the whole plane "trihedron" - mode 1 selection of the origin of the plane "trihedron" - mode 2 selection of the axes. Warning For the presentation of planes and trihedra, the millimetre is default unit of length, and 100 the default value for the representation of the axes. If you modify these dimensions, you must temporarily recover the Drawer object. From inside it, take the Aspects in which the values for length are stocked, for example, PlaneAspect for planes and LineAspect for trihedra. Change these values and recalculate the presentation.To construct a selectable 2d axis system in a 3d drawing. This can be placed anywhere in the 3d system, and provides a coordinate system for drawing curves and shapes in a plane. There are 3 selection modes: - mode 0 selection of the whole plane "trihedron" - mode 1 selection of the origin of the plane "trihedron" - mode 2 selection of the axes. Warning For the presentation of planes and trihedra, the millimetre is default unit of length, and 100 the default value for the representation of the axes. If you modify these dimensions, you must temporarily recover the Drawer object. From inside it, take the Aspects in which the values for length are stocked, for example, PlaneAspect for planes and LineAspect for trihedra. Change these values and recalculate the presentation.
    """
    def AcceptDisplayMode(self,aMode : int) -> bool: 
        """
        Returns true if the display mode selected, aMode, is valid.
        """
    def AcceptShapeDecomposition(self) -> bool: 
        """
        Informs the graphic context that the interactive Object may be decomposed into sub-shapes for dynamic selection. The most used Interactive Object is AIS_Shape.
        """
    def AddChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy.
        """
    def AddChildWithCurrentTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy with keeping the current global transformation So the object keeps the same position/orientation in the global CS.
        """
    def AddClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Adds clip plane for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def AddSelection(self,aSelection : OCP.SelectMgr.SelectMgr_Selection,aMode : int) -> None: 
        """
        Adds the selection aSelection with the selection mode index aMode to this framework.
        """
    def Attributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the attributes settings.
        """
    def BndBoxOfSelected(self,theOwners : Any) -> OCP.Bnd.Bnd_Box: 
        """
        Returns a bounding box of sensitive entities with the owners given if they are a part of activated selection
        """
    def BoundingBox(self,theBndBox : OCP.Bnd.Bnd_Box) -> None: 
        """
        Returns bounding box of object correspondingly to its current display mode. This method requires presentation to be already computed, since it relies on bounding box of presentation structures, which are supposed to be same/close amongst different display modes of this object.
        """
    def Children(self) -> OCP.PrsMgr.PrsMgr_ListOfPresentableObjects: 
        """
        Returns children of the current object.
        """
    def ClearDynamicHighlight(self,theMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> None: 
        """
        Method that needs to be implemented when the object manages selection and dynamic highlighting on its own. Clears or invalidates dynamic highlight presentation. By default it clears immediate draw of given presentation manager.
        """
    def ClearOwner(self) -> None: 
        """
        Each Interactive Object has methods which allow us to attribute an Owner to it in the form of a Transient. This method removes the owner from the graphic entity.
        """
    def ClearSelected(self) -> None: 
        """
        Method which clear all selected owners belonging to this selectable object ( for fast presentation draw )
        """
    def ClearSelections(self,update : bool=False) -> None: 
        """
        Empties all the selections in the SelectableObject <update> parameter defines whether all object's selections should be flagged for further update or not. This improved method can be used to recompute an object's selection (without redisplaying the object completely) when some selection mode is activated not for the first time.
        """
    def ClipPlanes(self) -> OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane: 
        """
        Get clip planes.
        """
    def Color(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Returns the color setting of the Interactive Object.
        """
    def CombinedParentTransformation(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return combined parent transformation.
        """
    def Component(self) -> OCP.Geom.Geom_Plane: 
        """
        Returns the component specified in SetComponent.
        """
    def ComputeSelection(self,theSelection : OCP.SelectMgr.SelectMgr_Selection,theMode : int) -> None: 
        """
        Computes sensitive primitives for the given selection mode - key interface method of Selectable Object.
        """
    def CurrentFacingModel(self) -> OCP.Aspect.Aspect_TypeOfFacingModel: 
        """
        Returns the current facing model which is in effect.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def DefaultDisplayMode(self) -> int: 
        """
        Returns the default display mode.
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DisplayMode(self) -> int: 
        """
        Returns the display mode setting of the Interactive Object. The range of supported display mode indexes should be specified within object definition and filtered by AccepDisplayMode().
        """
    def DisplayStatus(self) -> OCP.PrsMgr.PrsMgr_DisplayStatus: 
        """
        Return presentation display status; PrsMgr_DisplayStatus_None by default.
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicHilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalDynamic and Prs3d_TypeOfHighlight_Dynamic defined within AIS_InteractiveContext::HighlightStyle().
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def ErasePresentations(self,theToRemove : bool) -> None: 
        """
        Removes presentations returned by GetHilightPresentation() and GetSelectPresentation().
        """
    def GetAssemblyOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns common entity owner if the object is an assembly
        """
    def GetContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def GetHilightPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting detected object.
        """
    def GetLength(self) -> float: 
        """
        Returns the length of X and Y axes.
        """
    def GetOwner(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns the owner of the Interactive Object. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient. There are two types of owners: - Direct owners, decomposition shapes such as edges, wires, and faces. - Users, presentable objects connecting to sensitive primitives, or a shape which has been decomposed.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def GetSelectPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting selected object.
        """
    def GlobalSelOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns the owner of mode for selection of object as a whole
        """
    def GlobalSelectionMode(self) -> int: 
        """
        Returns the mode for selection of object as a whole; 0 by default.
        """
    def HasColor(self) -> bool: 
        """
        Returns true if the Interactive Object has color.
        """
    def HasDisplayMode(self) -> bool: 
        """
        Returns true if the Interactive Object has display mode setting overriding global setting (within Interactive Context).
        """
    def HasHilightMode(self) -> bool: 
        """
        Returns true if the Interactive Object is in highlight mode.
        """
    def HasInteractiveContext(self) -> bool: 
        """
        Indicates whether the Interactive Object has a pointer to an interactive context.
        """
    def HasMaterial(self) -> bool: 
        """
        Returns true if the Interactive Object has a setting for material.
        """
    def HasOwnPresentations(self) -> bool: 
        """
        Returns true if object should have own presentations.
        """
    def HasOwner(self) -> bool: 
        """
        Returns true if the object has an owner attributed to it. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient.
        """
    def HasPolygonOffsets(self) -> bool: 
        """
        Returns Standard_True if <myDrawer> has non-null shading aspect
        """
    def HasPresentation(self) -> bool: 
        """
        Returns TRUE when this object has a presentation in the current DisplayMode()
        """
    def HasSelection(self,theMode : int) -> bool: 
        """
        Returns true if a selection corresponding to the selection mode theMode was computed for this object.
        """
    def HasTransformation(self) -> bool: 
        """
        Returns true if object has a transformation that is different from the identity.
        """
    def HasWidth(self) -> bool: 
        """
        Returns true if the Interactive Object has width.
        """
    def HilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalSelected and Prs3d_TypeOfHighlight_Selected defined within AIS_InteractiveContext::HighlightStyle().
        """
    def HilightMode(self) -> int: 
        """
        Returns highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def HilightOwnerWithColor(self,thePM : OCP.PrsMgr.PrsMgr_PresentationManager,theStyle : OCP.Prs3d.Prs3d_Drawer,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner) -> None: 
        """
        Method which hilight an owner belonging to this selectable object ( for fast presentation draw )
        """
    def HilightSelected(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager,theSeq : OCP.SelectMgr.SelectMgr_SequenceOfOwner) -> None: 
        """
        Method which draws selected owners ( for fast presentation draw )
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def InteractiveContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def InversedTransformation(self) -> OCP.gp.gp_GTrsf: 
        """
        Return inversed transformation.
        """
    def IsAutoHilight(self) -> bool: 
        """
        If returns True, the old mechanism for highlighting selected objects is used (HilightSelected Method may be empty). If returns False, the HilightSelected method will be fully responsible for highlighting selected entity owners belonging to this selectable object.
        """
    def IsInfinite(self) -> bool: 
        """
        Returns true if the interactive object is infinite; FALSE by default. This flag affects various operations operating on bounding box of graphic presentations of this object. For instance, infinite objects are not taken in account for View FitAll. This does not necessarily means that object is actually infinite, auxiliary objects might be also marked with this flag to achieve desired behavior.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def IsMutable(self) -> bool: 
        """
        Returns true if object has mutable nature (content or location are be changed regularly). Mutable object will be managed in different way than static onces (another optimizations).
        """
    def IsTransparent(self) -> bool: 
        """
        Returns true if there is a transparency setting.
        """
    def LocalTransformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def LocalTransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def Material(self) -> OCP.Graphic3d.Graphic3d_NameOfMaterial: 
        """
        Returns the current material setting as enumeration value.
        """
    def Parent(self) -> OCP.PrsMgr.PrsMgr_PresentableObject: 
        """
        Returns parent of current object in scene hierarchy.
        """
    def PolygonOffsets(self,aFactor : float,aUnits : float) -> tuple[int]: 
        """
        Retrieves current polygon offsets settings from <myDrawer>.
        """
    def Position(self) -> AIS_Point: 
        """
        Returns the point of origin of the plane trihedron.
        """
    def Presentation(self) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Returns the current presentation of this object according to the current DisplayMode()
        """
    def Presentations(self) -> OCP.PrsMgr.PrsMgr_Presentations: 
        """
        Return presentations.
        """
    def ProcessDragging(self,theCtx : AIS_InteractiveContext,theView : OCP.V3d.V3d_View,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theDragFrom : OCP.Graphic3d.Graphic3d_Vec2i,theDragTo : OCP.Graphic3d.Graphic3d_Vec2i,theAction : AIS_DragAction) -> bool: 
        """
        Drag object in the viewer.
        """
    @overload
    def RecomputePrimitives(self) -> None: 
        """
        Re-computes the sensitive primitives for all modes. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.

        Re-computes the sensitive primitives which correspond to the <theMode>th selection mode. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.
        """
    @overload
    def RecomputePrimitives(self,theMode : int) -> None: ...
    def Redisplay(self,AllModes : bool=False) -> None: 
        """
        Updates the active presentation; if <AllModes> = Standard_True all the presentations inside are recomputed. IMPORTANT: It is preferable to call Redisplay method of corresponding AIS_InteractiveContext instance for cases when it is accessible. This method just redirects call to myCTXPtr, so this class field must be up to date for proper result.
        """
    def RemoveChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy.
        """
    def RemoveChildWithRestoreTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy with keeping the current global transformation. So the object keeps the same position/orientation in the global CS.
        """
    def RemoveClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Removes previously added clip plane.
        """
    def ResetTransformation(self) -> None: 
        """
        None
        """
    def Selection(self,theMode : int) -> OCP.SelectMgr.SelectMgr_Selection: 
        """
        Returns the selection having specified selection mode or NULL.
        """
    def Selections(self) -> OCP.SelectMgr.SelectMgr_SequenceOfSelection: 
        """
        Return the sequence of selections.
        """
    def SetAspect(self,anAspect : OCP.Prs3d.Prs3d_BasicAspect) -> None: 
        """
        Sets the graphic basic aspect to the current presentation.
        """
    def SetAssemblyOwner(self,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theMode : int=-1) -> None: 
        """
        Sets common entity owner for assembly sensitive object entities
        """
    def SetAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the drawing tool theDrawer.
        """
    def SetAutoHilight(self,theAutoHilight : bool) -> None: 
        """
        Set AutoHilight property to true or false.
        """
    def SetClipPlanes(self,thePlanes : OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane) -> None: 
        """
        Set clip planes for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def SetColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Allows you to provide settings for the color aColor.
        """
    def SetComponent(self,aPlane : OCP.Geom.Geom_Plane) -> None: 
        """
        Creates an instance of the component object aPlane.
        """
    def SetContext(self,aCtx : AIS_InteractiveContext) -> None: 
        """
        Sets the interactive context aCtx and provides a link to the default drawing tool or "Drawer" if there is none.
        """
    def SetCurrentFacingModel(self,theModel : OCP.Aspect.Aspect_TypeOfFacingModel=Aspect_TypeOfFacingModel.Aspect_TOFM_BOTH_SIDE) -> None: 
        """
        change the current facing model apply on polygons for SetColor(), SetTransparency(), SetMaterial() methods default facing model is Aspect_TOFM_TWO_SIDE. This mean that attributes is applying both on the front and back face.
        """
    def SetDisplayMode(self,theMode : int) -> None: 
        """
        Sets the display mode for the interactive object. An object can have its own temporary display mode, which is different from that proposed by the interactive context.
        """
    def SetDynamicHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the dynamic hilight drawing tool.
        """
    def SetHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the hilight drawing tool theDrawer.
        """
    def SetHilightMode(self,theMode : int) -> None: 
        """
        Sets highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def SetInfiniteState(self,theFlag : bool=True) -> None: 
        """
        Sets if object should be considered as infinite.
        """
    def SetIsoOnTriangulation(self,theIsEnabled : bool) -> None: 
        """
        Enables or disables on-triangulation build of isolines according to the flag given.
        """
    def SetLength(self,theLength : float) -> None: 
        """
        Sets the length of the X and Y axes.
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.gp.gp_Trsf) -> None: 
        """
        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.

        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.TopLoc.TopLoc_Datum3D) -> None: ...
    def SetMaterial(self,aName : OCP.Graphic3d.Graphic3d_MaterialAspect) -> None: 
        """
        Sets the material aMat defining this display attribute for the interactive object. Material aspect determines shading aspect, color and transparency of visible entities.
        """
    def SetMutable(self,theIsMutable : bool) -> None: 
        """
        Sets if the object has mutable nature (content or location will be changed regularly). This method should be called before object displaying to take effect.
        """
    def SetOwner(self,theApplicativeEntity : OCP.Standard.Standard_Transient) -> None: 
        """
        Allows you to attribute the owner theApplicativeEntity to an Interactive Object. This can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of. The owner takes the form of a transient.
        """
    def SetPolygonOffsets(self,aMode : int,aFactor : float=1.0,aUnits : float=0.0) -> None: 
        """
        Sets up polygon offsets for this object.
        """
    def SetPropagateVisualState(self,theFlag : bool) -> None: 
        """
        Change the value of the flag "propagate visual state"
        """
    @overload
    def SetToUpdate(self) -> None: 
        """
        Flags presentation to be updated; UpdatePresentations() will recompute these presentations.

        flags all the Presentations to be Updated.
        """
    @overload
    def SetToUpdate(self,theMode : int) -> None: ...
    def SetTransformPersistence(self,theTrsfPers : OCP.Graphic3d.Graphic3d_TransformPers) -> None: 
        """
        Sets up Transform Persistence defining a special Local Coordinate system where this object should be located. Note that management of Transform Persistence object is more expensive than of the normal one, because it requires its position being recomputed basing on camera position within each draw call / traverse.
        """
    def SetTransparency(self,aValue : float=0.6) -> None: 
        """
        Attributes a setting aValue for transparency. The transparency value should be between 0.0 and 1.0. At 0.0 an object will be totally opaque, and at 1.0, fully transparent. Warning At a value of 1.0, there may be nothing visible.
        """
    def SetTypeOfPresentation(self,theType : OCP.PrsMgr.PrsMgr_TypeOfPresentation3d) -> None: 
        """
        Set type of presentation.
        """
    def SetWidth(self,theWidth : float) -> None: 
        """
        Allows you to provide the setting aValue for width. Only the Interactive Object knows which Drawer attribute is affected by the width setting.
        """
    def SetXLabel(self,theLabel : OCP.TCollection.TCollection_AsciiString) -> None: 
        """
        None
        """
    def SetYLabel(self,theLabel : OCP.TCollection.TCollection_AsciiString) -> None: 
        """
        None
        """
    def SetZLayer(self,theLayerId : int) -> None: 
        """
        Set Z layer ID and update all presentations of the selectable object. The layers mechanism allows drawing objects in higher layers in overlay of objects in lower layers.
        """
    def Signature(self) -> int: 
        """
        None
        """
    def SynchronizeAspects(self) -> None: 
        """
        Synchronize presentation aspects after their modification.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    @overload
    def ToBeUpdated(self,ListOfMode : OCP.TColStd.TColStd_ListOfInteger) -> None: 
        """
        Returns TRUE if any active presentation has invalidation flag.

        gives the list of modes which are flagged "to be updated".
        """
    @overload
    def ToBeUpdated(self,theToIncludeHidden : bool=False) -> bool: ...
    def ToPropagateVisualState(self) -> bool: 
        """
        Get value of the flag "propagate visual state" It means that the display/erase/color visual state is propagated automatically to all children; by default, the flag is true
        """
    def TransformPersistence(self) -> OCP.Graphic3d.Graphic3d_TransformPers: 
        """
        Returns Transformation Persistence defining a special Local Coordinate system where this presentable object is located or NULL handle if not defined. Position of the object having Transformation Persistence is mutable and depends on camera position. The same applies to a bounding box of the object.
        """
    def Transformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def TransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def Transparency(self) -> float: 
        """
        Returns the transparency setting. This will be between 0.0 and 1.0. At 0.0 an object will be totally opaque, and at 1.0, fully transparent.
        """
    def Type(self) -> AIS_KindOfInteractive: 
        """
        Returns datum as the type of Interactive Object.
        """
    def TypeOfPresentation3d(self) -> OCP.PrsMgr.PrsMgr_TypeOfPresentation3d: 
        """
        Returns information on whether the object accepts display in HLR mode or not.
        """
    def UnsetAttributes(self) -> None: 
        """
        Clears settings provided by the drawing tool aDrawer.
        """
    def UnsetColor(self) -> None: 
        """
        Removes color settings. Only the Interactive Object knows which Drawer attribute is affected by the color setting. For a wire, for example, wire aspect is the attribute affected. For a vertex, however, only point aspect is affected by the color setting.
        """
    def UnsetDisplayMode(self) -> None: 
        """
        Removes display mode settings from the interactive object.
        """
    def UnsetHilightAttributes(self) -> None: 
        """
        Clears settings provided by the hilight drawing tool theDrawer.
        """
    def UnsetHilightMode(self) -> None: 
        """
        Unsets highlight display mode.
        """
    def UnsetMaterial(self) -> None: 
        """
        Removes the setting for material.
        """
    def UnsetTransparency(self) -> None: 
        """
        Removes the transparency setting. The object is opaque by default.
        """
    def UnsetWidth(self) -> None: 
        """
        Reset width to default value.
        """
    def UpdateSelection(self,theMode : int=-1) -> None: 
        """
        Sets update status FULL to selections of the object. Must be used as the only method of UpdateSelection from outer classes to prevent BVH structures from being outdated.
        """
    def UpdateTransformation(self) -> None: 
        """
        Recomputes the location of the selection aSelection.
        """
    def UpdateTransformations(self,aSelection : OCP.SelectMgr.SelectMgr_Selection) -> None: 
        """
        Updates locations in all sensitive entities from <aSelection> and in corresponding entity owners.
        """
    def ViewAffinity(self) -> OCP.Graphic3d.Graphic3d_ViewAffinity: 
        """
        Return view affinity mask.
        """
    def Width(self) -> float: 
        """
        Returns the width setting of the Interactive Object.
        """
    def XAxis(self) -> AIS_Line: 
        """
        Returns the "XAxis".
        """
    def YAxis(self) -> AIS_Line: 
        """
        Returns the "YAxis".
        """
    def ZLayer(self) -> int: 
        """
        Get ID of Z layer for main presentation.
        """
    def __init__(self,aPlane : OCP.Geom.Geom_Plane) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class AIS_Point(AIS_InteractiveObject, OCP.SelectMgr.SelectMgr_SelectableObject, OCP.PrsMgr.PrsMgr_PresentableObject, OCP.Standard.Standard_Transient):
    """
    Constructs point datums to be used in construction of composite shapes. The datum is displayed as the plus marker +.Constructs point datums to be used in construction of composite shapes. The datum is displayed as the plus marker +.
    """
    def AcceptDisplayMode(self,aMode : int) -> bool: 
        """
        Returns true if the display mode selected is valid for point datums.
        """
    def AcceptShapeDecomposition(self) -> bool: 
        """
        Informs the graphic context that the interactive Object may be decomposed into sub-shapes for dynamic selection. The most used Interactive Object is AIS_Shape.
        """
    def AddChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy.
        """
    def AddChildWithCurrentTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy with keeping the current global transformation So the object keeps the same position/orientation in the global CS.
        """
    def AddClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Adds clip plane for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def AddSelection(self,aSelection : OCP.SelectMgr.SelectMgr_Selection,aMode : int) -> None: 
        """
        Adds the selection aSelection with the selection mode index aMode to this framework.
        """
    def Attributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the attributes settings.
        """
    def BndBoxOfSelected(self,theOwners : Any) -> OCP.Bnd.Bnd_Box: 
        """
        Returns a bounding box of sensitive entities with the owners given if they are a part of activated selection
        """
    def BoundingBox(self,theBndBox : OCP.Bnd.Bnd_Box) -> None: 
        """
        Returns bounding box of object correspondingly to its current display mode. This method requires presentation to be already computed, since it relies on bounding box of presentation structures, which are supposed to be same/close amongst different display modes of this object.
        """
    def Children(self) -> OCP.PrsMgr.PrsMgr_ListOfPresentableObjects: 
        """
        Returns children of the current object.
        """
    def ClearDynamicHighlight(self,theMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> None: 
        """
        Method that needs to be implemented when the object manages selection and dynamic highlighting on its own. Clears or invalidates dynamic highlight presentation. By default it clears immediate draw of given presentation manager.
        """
    def ClearOwner(self) -> None: 
        """
        Each Interactive Object has methods which allow us to attribute an Owner to it in the form of a Transient. This method removes the owner from the graphic entity.
        """
    def ClearSelected(self) -> None: 
        """
        Method which clear all selected owners belonging to this selectable object ( for fast presentation draw )
        """
    def ClearSelections(self,update : bool=False) -> None: 
        """
        Empties all the selections in the SelectableObject <update> parameter defines whether all object's selections should be flagged for further update or not. This improved method can be used to recompute an object's selection (without redisplaying the object completely) when some selection mode is activated not for the first time.
        """
    def ClipPlanes(self) -> OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane: 
        """
        Get clip planes.
        """
    def Color(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Returns the color setting of the Interactive Object.
        """
    def CombinedParentTransformation(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return combined parent transformation.
        """
    def Component(self) -> OCP.Geom.Geom_Point: 
        """
        Returns the component specified in SetComponent.
        """
    def ComputeSelection(self,theSelection : OCP.SelectMgr.SelectMgr_Selection,theMode : int) -> None: 
        """
        Computes sensitive primitives for the given selection mode - key interface method of Selectable Object.
        """
    def CurrentFacingModel(self) -> OCP.Aspect.Aspect_TypeOfFacingModel: 
        """
        Returns the current facing model which is in effect.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def DefaultDisplayMode(self) -> int: 
        """
        Returns the default display mode.
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DisplayMode(self) -> int: 
        """
        Returns the display mode setting of the Interactive Object. The range of supported display mode indexes should be specified within object definition and filtered by AccepDisplayMode().
        """
    def DisplayStatus(self) -> OCP.PrsMgr.PrsMgr_DisplayStatus: 
        """
        Return presentation display status; PrsMgr_DisplayStatus_None by default.
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicHilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalDynamic and Prs3d_TypeOfHighlight_Dynamic defined within AIS_InteractiveContext::HighlightStyle().
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def ErasePresentations(self,theToRemove : bool) -> None: 
        """
        Removes presentations returned by GetHilightPresentation() and GetSelectPresentation().
        """
    def GetAssemblyOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns common entity owner if the object is an assembly
        """
    def GetContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def GetHilightPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting detected object.
        """
    def GetOwner(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns the owner of the Interactive Object. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient. There are two types of owners: - Direct owners, decomposition shapes such as edges, wires, and faces. - Users, presentable objects connecting to sensitive primitives, or a shape which has been decomposed.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def GetSelectPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting selected object.
        """
    def GlobalSelOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns the owner of mode for selection of object as a whole
        """
    def GlobalSelectionMode(self) -> int: 
        """
        Returns the mode for selection of object as a whole; 0 by default.
        """
    def HasColor(self) -> bool: 
        """
        Returns true if the Interactive Object has color.
        """
    def HasDisplayMode(self) -> bool: 
        """
        Returns true if the Interactive Object has display mode setting overriding global setting (within Interactive Context).
        """
    def HasHilightMode(self) -> bool: 
        """
        Returns true if the Interactive Object is in highlight mode.
        """
    def HasInteractiveContext(self) -> bool: 
        """
        Indicates whether the Interactive Object has a pointer to an interactive context.
        """
    def HasMarker(self) -> bool: 
        """
        Returns true if the point datum has a marker.
        """
    def HasMaterial(self) -> bool: 
        """
        Returns true if the Interactive Object has a setting for material.
        """
    def HasOwnPresentations(self) -> bool: 
        """
        Returns true if object should have own presentations.
        """
    def HasOwner(self) -> bool: 
        """
        Returns true if the object has an owner attributed to it. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient.
        """
    def HasPolygonOffsets(self) -> bool: 
        """
        Returns Standard_True if <myDrawer> has non-null shading aspect
        """
    def HasPresentation(self) -> bool: 
        """
        Returns TRUE when this object has a presentation in the current DisplayMode()
        """
    def HasSelection(self,theMode : int) -> bool: 
        """
        Returns true if a selection corresponding to the selection mode theMode was computed for this object.
        """
    def HasTransformation(self) -> bool: 
        """
        Returns true if object has a transformation that is different from the identity.
        """
    def HasWidth(self) -> bool: 
        """
        Returns true if the Interactive Object has width.
        """
    def HilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalSelected and Prs3d_TypeOfHighlight_Selected defined within AIS_InteractiveContext::HighlightStyle().
        """
    def HilightMode(self) -> int: 
        """
        Returns highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def HilightOwnerWithColor(self,thePM : OCP.PrsMgr.PrsMgr_PresentationManager,theStyle : OCP.Prs3d.Prs3d_Drawer,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner) -> None: 
        """
        Method which hilight an owner belonging to this selectable object ( for fast presentation draw )
        """
    def HilightSelected(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager,theSeq : OCP.SelectMgr.SelectMgr_SequenceOfOwner) -> None: 
        """
        Method which draws selected owners ( for fast presentation draw )
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def InteractiveContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def InversedTransformation(self) -> OCP.gp.gp_GTrsf: 
        """
        Return inversed transformation.
        """
    def IsAutoHilight(self) -> bool: 
        """
        If returns True, the old mechanism for highlighting selected objects is used (HilightSelected Method may be empty). If returns False, the HilightSelected method will be fully responsible for highlighting selected entity owners belonging to this selectable object.
        """
    def IsInfinite(self) -> bool: 
        """
        Returns true if the interactive object is infinite; FALSE by default. This flag affects various operations operating on bounding box of graphic presentations of this object. For instance, infinite objects are not taken in account for View FitAll. This does not necessarily means that object is actually infinite, auxiliary objects might be also marked with this flag to achieve desired behavior.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def IsMutable(self) -> bool: 
        """
        Returns true if object has mutable nature (content or location are be changed regularly). Mutable object will be managed in different way than static onces (another optimizations).
        """
    def IsTransparent(self) -> bool: 
        """
        Returns true if there is a transparency setting.
        """
    def LocalTransformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def LocalTransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def Material(self) -> OCP.Graphic3d.Graphic3d_NameOfMaterial: 
        """
        Returns the current material setting as enumeration value.
        """
    def Parent(self) -> OCP.PrsMgr.PrsMgr_PresentableObject: 
        """
        Returns parent of current object in scene hierarchy.
        """
    def PolygonOffsets(self,aFactor : float,aUnits : float) -> tuple[int]: 
        """
        Retrieves current polygon offsets settings from <myDrawer>.
        """
    def Presentation(self) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Returns the current presentation of this object according to the current DisplayMode()
        """
    def Presentations(self) -> OCP.PrsMgr.PrsMgr_Presentations: 
        """
        Return presentations.
        """
    def ProcessDragging(self,theCtx : AIS_InteractiveContext,theView : OCP.V3d.V3d_View,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theDragFrom : OCP.Graphic3d.Graphic3d_Vec2i,theDragTo : OCP.Graphic3d.Graphic3d_Vec2i,theAction : AIS_DragAction) -> bool: 
        """
        Drag object in the viewer.
        """
    @overload
    def RecomputePrimitives(self) -> None: 
        """
        Re-computes the sensitive primitives for all modes. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.

        Re-computes the sensitive primitives which correspond to the <theMode>th selection mode. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.
        """
    @overload
    def RecomputePrimitives(self,theMode : int) -> None: ...
    def Redisplay(self,AllModes : bool=False) -> None: 
        """
        Updates the active presentation; if <AllModes> = Standard_True all the presentations inside are recomputed. IMPORTANT: It is preferable to call Redisplay method of corresponding AIS_InteractiveContext instance for cases when it is accessible. This method just redirects call to myCTXPtr, so this class field must be up to date for proper result.
        """
    def RemoveChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy.
        """
    def RemoveChildWithRestoreTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy with keeping the current global transformation. So the object keeps the same position/orientation in the global CS.
        """
    def RemoveClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Removes previously added clip plane.
        """
    def ResetTransformation(self) -> None: 
        """
        None
        """
    def Selection(self,theMode : int) -> OCP.SelectMgr.SelectMgr_Selection: 
        """
        Returns the selection having specified selection mode or NULL.
        """
    def Selections(self) -> OCP.SelectMgr.SelectMgr_SequenceOfSelection: 
        """
        Return the sequence of selections.
        """
    def SetAspect(self,anAspect : OCP.Prs3d.Prs3d_BasicAspect) -> None: 
        """
        Sets the graphic basic aspect to the current presentation.
        """
    def SetAssemblyOwner(self,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theMode : int=-1) -> None: 
        """
        Sets common entity owner for assembly sensitive object entities
        """
    def SetAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the drawing tool theDrawer.
        """
    def SetAutoHilight(self,theAutoHilight : bool) -> None: 
        """
        Set AutoHilight property to true or false.
        """
    def SetClipPlanes(self,thePlanes : OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane) -> None: 
        """
        Set clip planes for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def SetColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Allows you to provide settings for the Color.
        """
    def SetComponent(self,aComponent : OCP.Geom.Geom_Point) -> None: 
        """
        Constructs an instance of the point aComponent.
        """
    def SetContext(self,aCtx : AIS_InteractiveContext) -> None: 
        """
        Sets the interactive context aCtx and provides a link to the default drawing tool or "Drawer" if there is none.
        """
    def SetCurrentFacingModel(self,theModel : OCP.Aspect.Aspect_TypeOfFacingModel=Aspect_TypeOfFacingModel.Aspect_TOFM_BOTH_SIDE) -> None: 
        """
        change the current facing model apply on polygons for SetColor(), SetTransparency(), SetMaterial() methods default facing model is Aspect_TOFM_TWO_SIDE. This mean that attributes is applying both on the front and back face.
        """
    def SetDisplayMode(self,theMode : int) -> None: 
        """
        Sets the display mode for the interactive object. An object can have its own temporary display mode, which is different from that proposed by the interactive context.
        """
    def SetDynamicHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the dynamic hilight drawing tool.
        """
    def SetHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the hilight drawing tool theDrawer.
        """
    def SetHilightMode(self,theMode : int) -> None: 
        """
        Sets highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def SetInfiniteState(self,theFlag : bool=True) -> None: 
        """
        Sets if object should be considered as infinite.
        """
    def SetIsoOnTriangulation(self,theIsEnabled : bool) -> None: 
        """
        Enables or disables on-triangulation build of isolines according to the flag given.
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.gp.gp_Trsf) -> None: 
        """
        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.

        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.TopLoc.TopLoc_Datum3D) -> None: ...
    def SetMarker(self,aType : OCP.Aspect.Aspect_TypeOfMarker) -> None: 
        """
        Allows you to provide settings for a marker. These include - type of marker, - marker color, - scale factor.
        """
    def SetMaterial(self,aName : OCP.Graphic3d.Graphic3d_MaterialAspect) -> None: 
        """
        Sets the material aMat defining this display attribute for the interactive object. Material aspect determines shading aspect, color and transparency of visible entities.
        """
    def SetMutable(self,theIsMutable : bool) -> None: 
        """
        Sets if the object has mutable nature (content or location will be changed regularly). This method should be called before object displaying to take effect.
        """
    def SetOwner(self,theApplicativeEntity : OCP.Standard.Standard_Transient) -> None: 
        """
        Allows you to attribute the owner theApplicativeEntity to an Interactive Object. This can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of. The owner takes the form of a transient.
        """
    def SetPolygonOffsets(self,aMode : int,aFactor : float=1.0,aUnits : float=0.0) -> None: 
        """
        Sets up polygon offsets for this object.
        """
    def SetPropagateVisualState(self,theFlag : bool) -> None: 
        """
        Change the value of the flag "propagate visual state"
        """
    @overload
    def SetToUpdate(self) -> None: 
        """
        Flags presentation to be updated; UpdatePresentations() will recompute these presentations.

        flags all the Presentations to be Updated.
        """
    @overload
    def SetToUpdate(self,theMode : int) -> None: ...
    def SetTransformPersistence(self,theTrsfPers : OCP.Graphic3d.Graphic3d_TransformPers) -> None: 
        """
        Sets up Transform Persistence defining a special Local Coordinate system where this object should be located. Note that management of Transform Persistence object is more expensive than of the normal one, because it requires its position being recomputed basing on camera position within each draw call / traverse.
        """
    def SetTransparency(self,aValue : float=0.6) -> None: 
        """
        Attributes a setting aValue for transparency. The transparency value should be between 0.0 and 1.0. At 0.0 an object will be totally opaque, and at 1.0, fully transparent. Warning At a value of 1.0, there may be nothing visible.
        """
    def SetTypeOfPresentation(self,theType : OCP.PrsMgr.PrsMgr_TypeOfPresentation3d) -> None: 
        """
        Set type of presentation.
        """
    def SetWidth(self,theWidth : float) -> None: 
        """
        Allows you to provide the setting aValue for width. Only the Interactive Object knows which Drawer attribute is affected by the width setting.
        """
    def SetZLayer(self,theLayerId : int) -> None: 
        """
        Set Z layer ID and update all presentations of the selectable object. The layers mechanism allows drawing objects in higher layers in overlay of objects in lower layers.
        """
    def Signature(self) -> int: 
        """
        Returns index 1, the default index for a point.
        """
    def SynchronizeAspects(self) -> None: 
        """
        Synchronize presentation aspects after their modification.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    @overload
    def ToBeUpdated(self,ListOfMode : OCP.TColStd.TColStd_ListOfInteger) -> None: 
        """
        Returns TRUE if any active presentation has invalidation flag.

        gives the list of modes which are flagged "to be updated".
        """
    @overload
    def ToBeUpdated(self,theToIncludeHidden : bool=False) -> bool: ...
    def ToPropagateVisualState(self) -> bool: 
        """
        Get value of the flag "propagate visual state" It means that the display/erase/color visual state is propagated automatically to all children; by default, the flag is true
        """
    def TransformPersistence(self) -> OCP.Graphic3d.Graphic3d_TransformPers: 
        """
        Returns Transformation Persistence defining a special Local Coordinate system where this presentable object is located or NULL handle if not defined. Position of the object having Transformation Persistence is mutable and depends on camera position. The same applies to a bounding box of the object.
        """
    def Transformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def TransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def Transparency(self) -> float: 
        """
        Returns the transparency setting. This will be between 0.0 and 1.0. At 0.0 an object will be totally opaque, and at 1.0, fully transparent.
        """
    def Type(self) -> AIS_KindOfInteractive: 
        """
        Indicates that a point is a datum.
        """
    def TypeOfPresentation3d(self) -> OCP.PrsMgr.PrsMgr_TypeOfPresentation3d: 
        """
        Returns information on whether the object accepts display in HLR mode or not.
        """
    def UnsetAttributes(self) -> None: 
        """
        Clears settings provided by the drawing tool aDrawer.
        """
    def UnsetColor(self) -> None: 
        """
        Allows you to remove color settings.
        """
    def UnsetDisplayMode(self) -> None: 
        """
        Removes display mode settings from the interactive object.
        """
    def UnsetHilightAttributes(self) -> None: 
        """
        Clears settings provided by the hilight drawing tool theDrawer.
        """
    def UnsetHilightMode(self) -> None: 
        """
        Unsets highlight display mode.
        """
    def UnsetMarker(self) -> None: 
        """
        Removes the marker settings.
        """
    def UnsetMaterial(self) -> None: 
        """
        Removes the setting for material.
        """
    def UnsetTransparency(self) -> None: 
        """
        Removes the transparency setting. The object is opaque by default.
        """
    def UnsetWidth(self) -> None: 
        """
        Reset width to default value.
        """
    def UpdateSelection(self,theMode : int=-1) -> None: 
        """
        Sets update status FULL to selections of the object. Must be used as the only method of UpdateSelection from outer classes to prevent BVH structures from being outdated.
        """
    def UpdateTransformation(self) -> None: 
        """
        Recomputes the location of the selection aSelection.
        """
    def UpdateTransformations(self,aSelection : OCP.SelectMgr.SelectMgr_Selection) -> None: 
        """
        Updates locations in all sensitive entities from <aSelection> and in corresponding entity owners.
        """
    def Vertex(self) -> OCP.TopoDS.TopoDS_Vertex: 
        """
        Converts a point into a vertex.
        """
    def ViewAffinity(self) -> OCP.Graphic3d.Graphic3d_ViewAffinity: 
        """
        Return view affinity mask.
        """
    def Width(self) -> float: 
        """
        Returns the width setting of the Interactive Object.
        """
    def ZLayer(self) -> int: 
        """
        Get ID of Z layer for main presentation.
        """
    def __init__(self,aComponent : OCP.Geom.Geom_Point) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class AIS_PointCloud(AIS_InteractiveObject, OCP.SelectMgr.SelectMgr_SelectableObject, OCP.PrsMgr.PrsMgr_PresentableObject, OCP.Standard.Standard_Transient):
    """
    Interactive object for set of points. The presentation supports two display modes: - Points. - Bounding box for highlighting. Presentation provides selection by bounding box. Selection and consequently highlighting can disabled by setting default selection mode to -1. There will be no way to select object from interactive view. Any calls to AIS_InteractiveContext::AddOrRemoveSelected should be also prohibited, to avoid programmatic highlighting (workaround is setting non-supported hilight mode, e.g. 100);Interactive object for set of points. The presentation supports two display modes: - Points. - Bounding box for highlighting. Presentation provides selection by bounding box. Selection and consequently highlighting can disabled by setting default selection mode to -1. There will be no way to select object from interactive view. Any calls to AIS_InteractiveContext::AddOrRemoveSelected should be also prohibited, to avoid programmatic highlighting (workaround is setting non-supported hilight mode, e.g. 100);
    """
    class DisplayMode_e():
        """
        Display modes supported by this Point Cloud object

        Members:

          DM_Points

          DM_BndBox
        """
        def __eq__(self,other : object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __init__(self,value : int) -> None: ...
        def __int__(self) -> int: ...
        def __ne__(self,other : object) -> bool: ...
        def __repr__(self) -> str: ...
        def __setstate__(self,state : int) -> None: ...
        def __str__(self) -> str: ...
        @property
        def name(self) -> None:
            """
            :type: None
            """
        @property
        def value(self) -> int:
            """
            :type: int
            """
        DM_BndBox: OCP.AIS.DisplayMode_e # value = <DisplayMode_e.DM_BndBox: 2>
        DM_Points: OCP.AIS.DisplayMode_e # value = <DisplayMode_e.DM_Points: 0>
        __entries: dict # value = {'DM_Points': (<DisplayMode_e.DM_Points: 0>, None), 'DM_BndBox': (<DisplayMode_e.DM_BndBox: 2>, None)}
        __members__: dict # value = {'DM_Points': <DisplayMode_e.DM_Points: 0>, 'DM_BndBox': <DisplayMode_e.DM_BndBox: 2>}
        pass
    class SelectionMode_e():
        """
        Selection modes supported by this Point Cloud object

        Members:

          SM_Points

          SM_SubsetOfPoints

          SM_BndBox
        """
        def __eq__(self,other : object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __init__(self,value : int) -> None: ...
        def __int__(self) -> int: ...
        def __ne__(self,other : object) -> bool: ...
        def __repr__(self) -> str: ...
        def __setstate__(self,state : int) -> None: ...
        def __str__(self) -> str: ...
        @property
        def name(self) -> None:
            """
            :type: None
            """
        @property
        def value(self) -> int:
            """
            :type: int
            """
        SM_BndBox: OCP.AIS.SelectionMode_e # value = <SelectionMode_e.SM_BndBox: 2>
        SM_Points: OCP.AIS.SelectionMode_e # value = <SelectionMode_e.SM_Points: 0>
        SM_SubsetOfPoints: OCP.AIS.SelectionMode_e # value = <SelectionMode_e.SM_SubsetOfPoints: 1>
        __entries: dict # value = {'SM_Points': (<SelectionMode_e.SM_Points: 0>, None), 'SM_SubsetOfPoints': (<SelectionMode_e.SM_SubsetOfPoints: 1>, None), 'SM_BndBox': (<SelectionMode_e.SM_BndBox: 2>, None)}
        __members__: dict # value = {'SM_Points': <SelectionMode_e.SM_Points: 0>, 'SM_SubsetOfPoints': <SelectionMode_e.SM_SubsetOfPoints: 1>, 'SM_BndBox': <SelectionMode_e.SM_BndBox: 2>}
        pass
    def AcceptDisplayMode(self,theMode : int) -> bool: 
        """
        Returns true if the class of objects accepts specified display mode index. The interactive context can have a default mode of representation for the set of Interactive Objects. This mode may not be accepted by a given class of objects. Consequently, this virtual method allowing us to get information about the class in question must be implemented. At least one display mode index should be accepted by this method. Although subclass can leave default implementation, it is highly desired defining exact list of supported modes instead, which is usually an enumeration for one object or objects class sharing similar list of display modes.
        """
    def AcceptShapeDecomposition(self) -> bool: 
        """
        Informs the graphic context that the interactive Object may be decomposed into sub-shapes for dynamic selection. The most used Interactive Object is AIS_Shape.
        """
    def AddChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy.
        """
    def AddChildWithCurrentTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy with keeping the current global transformation So the object keeps the same position/orientation in the global CS.
        """
    def AddClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Adds clip plane for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def AddSelection(self,aSelection : OCP.SelectMgr.SelectMgr_Selection,aMode : int) -> None: 
        """
        Adds the selection aSelection with the selection mode index aMode to this framework.
        """
    def Attributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the attributes settings.
        """
    def BndBoxOfSelected(self,theOwners : Any) -> OCP.Bnd.Bnd_Box: 
        """
        Returns a bounding box of sensitive entities with the owners given if they are a part of activated selection
        """
    def BoundingBox(self,theBndBox : OCP.Bnd.Bnd_Box) -> None: 
        """
        Returns bounding box of object correspondingly to its current display mode. This method requires presentation to be already computed, since it relies on bounding box of presentation structures, which are supposed to be same/close amongst different display modes of this object.
        """
    def Children(self) -> OCP.PrsMgr.PrsMgr_ListOfPresentableObjects: 
        """
        Returns children of the current object.
        """
    def ClearDynamicHighlight(self,theMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> None: 
        """
        Method that needs to be implemented when the object manages selection and dynamic highlighting on its own. Clears or invalidates dynamic highlight presentation. By default it clears immediate draw of given presentation manager.
        """
    def ClearOwner(self) -> None: 
        """
        Each Interactive Object has methods which allow us to attribute an Owner to it in the form of a Transient. This method removes the owner from the graphic entity.
        """
    def ClearSelected(self) -> None: 
        """
        Method which clear all selected owners belonging to this selectable object ( for fast presentation draw )
        """
    def ClearSelections(self,update : bool=False) -> None: 
        """
        Empties all the selections in the SelectableObject <update> parameter defines whether all object's selections should be flagged for further update or not. This improved method can be used to recompute an object's selection (without redisplaying the object completely) when some selection mode is activated not for the first time.
        """
    def ClipPlanes(self) -> OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane: 
        """
        Get clip planes.
        """
    def Color(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Returns the color setting of the Interactive Object.
        """
    def CombinedParentTransformation(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return combined parent transformation.
        """
    def ComputeSelection(self,theSelection : OCP.SelectMgr.SelectMgr_Selection,theMode : int) -> None: 
        """
        Computes sensitive primitives for the given selection mode - key interface method of Selectable Object.
        """
    def CurrentFacingModel(self) -> OCP.Aspect.Aspect_TypeOfFacingModel: 
        """
        Returns the current facing model which is in effect.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def DefaultDisplayMode(self) -> int: 
        """
        Returns the default display mode.
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DisplayMode(self) -> int: 
        """
        Returns the display mode setting of the Interactive Object. The range of supported display mode indexes should be specified within object definition and filtered by AccepDisplayMode().
        """
    def DisplayStatus(self) -> OCP.PrsMgr.PrsMgr_DisplayStatus: 
        """
        Return presentation display status; PrsMgr_DisplayStatus_None by default.
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicHilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalDynamic and Prs3d_TypeOfHighlight_Dynamic defined within AIS_InteractiveContext::HighlightStyle().
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def ErasePresentations(self,theToRemove : bool) -> None: 
        """
        Removes presentations returned by GetHilightPresentation() and GetSelectPresentation().
        """
    def GetAssemblyOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns common entity owner if the object is an assembly
        """
    def GetBoundingBox(self) -> OCP.Bnd.Bnd_Box: 
        """
        Get bounding box for presentation.
        """
    def GetContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def GetHilightPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting detected object.
        """
    def GetOwner(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns the owner of the Interactive Object. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient. There are two types of owners: - Direct owners, decomposition shapes such as edges, wires, and faces. - Users, presentable objects connecting to sensitive primitives, or a shape which has been decomposed.
        """
    def GetPoints(self) -> OCP.Graphic3d.Graphic3d_ArrayOfPoints: 
        """
        Get the points array. Method might be overridden to fill in points array dynamically from application data structures.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def GetSelectPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting selected object.
        """
    def GlobalSelOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns the owner of mode for selection of object as a whole
        """
    def GlobalSelectionMode(self) -> int: 
        """
        Returns the mode for selection of object as a whole; 0 by default.
        """
    def HasColor(self) -> bool: 
        """
        Returns true if the Interactive Object has color.
        """
    def HasDisplayMode(self) -> bool: 
        """
        Returns true if the Interactive Object has display mode setting overriding global setting (within Interactive Context).
        """
    def HasHilightMode(self) -> bool: 
        """
        Returns true if the Interactive Object is in highlight mode.
        """
    def HasInteractiveContext(self) -> bool: 
        """
        Indicates whether the Interactive Object has a pointer to an interactive context.
        """
    def HasMaterial(self) -> bool: 
        """
        Returns true if the Interactive Object has a setting for material.
        """
    def HasOwnPresentations(self) -> bool: 
        """
        Returns true if object should have own presentations.
        """
    def HasOwner(self) -> bool: 
        """
        Returns true if the object has an owner attributed to it. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient.
        """
    def HasPolygonOffsets(self) -> bool: 
        """
        Returns Standard_True if <myDrawer> has non-null shading aspect
        """
    def HasPresentation(self) -> bool: 
        """
        Returns TRUE when this object has a presentation in the current DisplayMode()
        """
    def HasSelection(self,theMode : int) -> bool: 
        """
        Returns true if a selection corresponding to the selection mode theMode was computed for this object.
        """
    def HasTransformation(self) -> bool: 
        """
        Returns true if object has a transformation that is different from the identity.
        """
    def HasWidth(self) -> bool: 
        """
        Returns true if the Interactive Object has width.
        """
    def HilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalSelected and Prs3d_TypeOfHighlight_Selected defined within AIS_InteractiveContext::HighlightStyle().
        """
    def HilightMode(self) -> int: 
        """
        Returns highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def HilightOwnerWithColor(self,thePM : OCP.PrsMgr.PrsMgr_PresentationManager,theStyle : OCP.Prs3d.Prs3d_Drawer,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner) -> None: 
        """
        Method which hilight an owner belonging to this selectable object ( for fast presentation draw )
        """
    def HilightSelected(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager,theSeq : OCP.SelectMgr.SelectMgr_SequenceOfOwner) -> None: 
        """
        Method which draws selected owners ( for fast presentation draw )
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def InteractiveContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def InversedTransformation(self) -> OCP.gp.gp_GTrsf: 
        """
        Return inversed transformation.
        """
    def IsAutoHilight(self) -> bool: 
        """
        If returns True, the old mechanism for highlighting selected objects is used (HilightSelected Method may be empty). If returns False, the HilightSelected method will be fully responsible for highlighting selected entity owners belonging to this selectable object.
        """
    def IsInfinite(self) -> bool: 
        """
        Returns true if the interactive object is infinite; FALSE by default. This flag affects various operations operating on bounding box of graphic presentations of this object. For instance, infinite objects are not taken in account for View FitAll. This does not necessarily means that object is actually infinite, auxiliary objects might be also marked with this flag to achieve desired behavior.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def IsMutable(self) -> bool: 
        """
        Returns true if object has mutable nature (content or location are be changed regularly). Mutable object will be managed in different way than static onces (another optimizations).
        """
    def IsTransparent(self) -> bool: 
        """
        Returns true if there is a transparency setting.
        """
    def LocalTransformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def LocalTransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def Material(self) -> OCP.Graphic3d.Graphic3d_NameOfMaterial: 
        """
        Returns the current material setting as enumeration value.
        """
    def Parent(self) -> OCP.PrsMgr.PrsMgr_PresentableObject: 
        """
        Returns parent of current object in scene hierarchy.
        """
    def PolygonOffsets(self,aFactor : float,aUnits : float) -> tuple[int]: 
        """
        Retrieves current polygon offsets settings from <myDrawer>.
        """
    def Presentation(self) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Returns the current presentation of this object according to the current DisplayMode()
        """
    def Presentations(self) -> OCP.PrsMgr.PrsMgr_Presentations: 
        """
        Return presentations.
        """
    def ProcessDragging(self,theCtx : AIS_InteractiveContext,theView : OCP.V3d.V3d_View,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theDragFrom : OCP.Graphic3d.Graphic3d_Vec2i,theDragTo : OCP.Graphic3d.Graphic3d_Vec2i,theAction : AIS_DragAction) -> bool: 
        """
        Drag object in the viewer.
        """
    @overload
    def RecomputePrimitives(self) -> None: 
        """
        Re-computes the sensitive primitives for all modes. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.

        Re-computes the sensitive primitives which correspond to the <theMode>th selection mode. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.
        """
    @overload
    def RecomputePrimitives(self,theMode : int) -> None: ...
    def Redisplay(self,AllModes : bool=False) -> None: 
        """
        Updates the active presentation; if <AllModes> = Standard_True all the presentations inside are recomputed. IMPORTANT: It is preferable to call Redisplay method of corresponding AIS_InteractiveContext instance for cases when it is accessible. This method just redirects call to myCTXPtr, so this class field must be up to date for proper result.
        """
    def RemoveChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy.
        """
    def RemoveChildWithRestoreTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy with keeping the current global transformation. So the object keeps the same position/orientation in the global CS.
        """
    def RemoveClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Removes previously added clip plane.
        """
    def ResetTransformation(self) -> None: 
        """
        None
        """
    def Selection(self,theMode : int) -> OCP.SelectMgr.SelectMgr_Selection: 
        """
        Returns the selection having specified selection mode or NULL.
        """
    def Selections(self) -> OCP.SelectMgr.SelectMgr_SequenceOfSelection: 
        """
        Return the sequence of selections.
        """
    def SetAspect(self,anAspect : OCP.Prs3d.Prs3d_BasicAspect) -> None: 
        """
        Sets the graphic basic aspect to the current presentation.
        """
    def SetAssemblyOwner(self,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theMode : int=-1) -> None: 
        """
        Sets common entity owner for assembly sensitive object entities
        """
    def SetAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the drawing tool theDrawer.
        """
    def SetAutoHilight(self,theAutoHilight : bool) -> None: 
        """
        Set AutoHilight property to true or false.
        """
    def SetClipPlanes(self,thePlanes : OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane) -> None: 
        """
        Set clip planes for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def SetColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Setup custom color. Affects presentation only when no per-point color attribute has been assigned.
        """
    def SetContext(self,aCtx : AIS_InteractiveContext) -> None: 
        """
        Sets the interactive context aCtx and provides a link to the default drawing tool or "Drawer" if there is none.
        """
    def SetCurrentFacingModel(self,theModel : OCP.Aspect.Aspect_TypeOfFacingModel=Aspect_TypeOfFacingModel.Aspect_TOFM_BOTH_SIDE) -> None: 
        """
        change the current facing model apply on polygons for SetColor(), SetTransparency(), SetMaterial() methods default facing model is Aspect_TOFM_TWO_SIDE. This mean that attributes is applying both on the front and back face.
        """
    def SetDisplayMode(self,theMode : int) -> None: 
        """
        Sets the display mode for the interactive object. An object can have its own temporary display mode, which is different from that proposed by the interactive context.
        """
    def SetDynamicHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the dynamic hilight drawing tool.
        """
    def SetHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the hilight drawing tool theDrawer.
        """
    def SetHilightMode(self,theMode : int) -> None: 
        """
        Sets highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def SetInfiniteState(self,theFlag : bool=True) -> None: 
        """
        Sets if object should be considered as infinite.
        """
    def SetIsoOnTriangulation(self,theIsEnabled : bool) -> None: 
        """
        Enables or disables on-triangulation build of isolines according to the flag given.
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.gp.gp_Trsf) -> None: 
        """
        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.

        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.TopLoc.TopLoc_Datum3D) -> None: ...
    def SetMaterial(self,theMat : OCP.Graphic3d.Graphic3d_MaterialAspect) -> None: 
        """
        Setup custom material. Affects presentation only when normals are defined.
        """
    def SetMutable(self,theIsMutable : bool) -> None: 
        """
        Sets if the object has mutable nature (content or location will be changed regularly). This method should be called before object displaying to take effect.
        """
    def SetOwner(self,theApplicativeEntity : OCP.Standard.Standard_Transient) -> None: 
        """
        Allows you to attribute the owner theApplicativeEntity to an Interactive Object. This can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of. The owner takes the form of a transient.
        """
    @overload
    def SetPoints(self,thePoints : OCP.Graphic3d.Graphic3d_ArrayOfPoints) -> None: 
        """
        Sets the points from array of points. Method will not copy the input data - array will be stored as handle.

        Sets the points with optional colors. The input data will be copied into internal buffer. The input arrays should have equal length, otherwise the presentation will not be computed and displayed.
        """
    @overload
    def SetPoints(self,theCoords : OCP.TColgp.TColgp_HArray1OfPnt,theColors : OCP.Quantity.Quantity_HArray1OfColor=None,theNormals : OCP.TColgp.TColgp_HArray1OfDir=None) -> None: ...
    def SetPolygonOffsets(self,aMode : int,aFactor : float=1.0,aUnits : float=0.0) -> None: 
        """
        Sets up polygon offsets for this object.
        """
    def SetPropagateVisualState(self,theFlag : bool) -> None: 
        """
        Change the value of the flag "propagate visual state"
        """
    @overload
    def SetToUpdate(self) -> None: 
        """
        Flags presentation to be updated; UpdatePresentations() will recompute these presentations.

        flags all the Presentations to be Updated.
        """
    @overload
    def SetToUpdate(self,theMode : int) -> None: ...
    def SetTransformPersistence(self,theTrsfPers : OCP.Graphic3d.Graphic3d_TransformPers) -> None: 
        """
        Sets up Transform Persistence defining a special Local Coordinate system where this object should be located. Note that management of Transform Persistence object is more expensive than of the normal one, because it requires its position being recomputed basing on camera position within each draw call / traverse.
        """
    def SetTransparency(self,aValue : float=0.6) -> None: 
        """
        Attributes a setting aValue for transparency. The transparency value should be between 0.0 and 1.0. At 0.0 an object will be totally opaque, and at 1.0, fully transparent. Warning At a value of 1.0, there may be nothing visible.
        """
    def SetTypeOfPresentation(self,theType : OCP.PrsMgr.PrsMgr_TypeOfPresentation3d) -> None: 
        """
        Set type of presentation.
        """
    def SetWidth(self,theWidth : float) -> None: 
        """
        Allows you to provide the setting aValue for width. Only the Interactive Object knows which Drawer attribute is affected by the width setting.
        """
    def SetZLayer(self,theLayerId : int) -> None: 
        """
        Set Z layer ID and update all presentations of the selectable object. The layers mechanism allows drawing objects in higher layers in overlay of objects in lower layers.
        """
    def Signature(self) -> int: 
        """
        Specifies additional characteristics of Interactive Object of Type(); -1 by default. Among the datums, this signature is attributed to the shape. The remaining datums have the following default signatures: - Point signature 1 - Axis signature 2 - Trihedron signature 3 - PlaneTrihedron signature 4 - Line signature 5 - Circle signature 6 - Plane signature 7.
        """
    def SynchronizeAspects(self) -> None: 
        """
        Synchronize presentation aspects after their modification.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    @overload
    def ToBeUpdated(self,ListOfMode : OCP.TColStd.TColStd_ListOfInteger) -> None: 
        """
        Returns TRUE if any active presentation has invalidation flag.

        gives the list of modes which are flagged "to be updated".
        """
    @overload
    def ToBeUpdated(self,theToIncludeHidden : bool=False) -> bool: ...
    def ToPropagateVisualState(self) -> bool: 
        """
        Get value of the flag "propagate visual state" It means that the display/erase/color visual state is propagated automatically to all children; by default, the flag is true
        """
    def TransformPersistence(self) -> OCP.Graphic3d.Graphic3d_TransformPers: 
        """
        Returns Transformation Persistence defining a special Local Coordinate system where this presentable object is located or NULL handle if not defined. Position of the object having Transformation Persistence is mutable and depends on camera position. The same applies to a bounding box of the object.
        """
    def Transformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def TransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def Transparency(self) -> float: 
        """
        Returns the transparency setting. This will be between 0.0 and 1.0. At 0.0 an object will be totally opaque, and at 1.0, fully transparent.
        """
    def Type(self) -> AIS_KindOfInteractive: 
        """
        Returns the kind of Interactive Object; AIS_KindOfInteractive_None by default.
        """
    def TypeOfPresentation3d(self) -> OCP.PrsMgr.PrsMgr_TypeOfPresentation3d: 
        """
        Returns information on whether the object accepts display in HLR mode or not.
        """
    def UnsetAttributes(self) -> None: 
        """
        Clears settings provided by the drawing tool aDrawer.
        """
    def UnsetColor(self) -> None: 
        """
        Restore default color.
        """
    def UnsetDisplayMode(self) -> None: 
        """
        Removes display mode settings from the interactive object.
        """
    def UnsetHilightAttributes(self) -> None: 
        """
        Clears settings provided by the hilight drawing tool theDrawer.
        """
    def UnsetHilightMode(self) -> None: 
        """
        Unsets highlight display mode.
        """
    def UnsetMaterial(self) -> None: 
        """
        Restore default material.
        """
    def UnsetTransparency(self) -> None: 
        """
        Removes the transparency setting. The object is opaque by default.
        """
    def UnsetWidth(self) -> None: 
        """
        Reset width to default value.
        """
    def UpdateSelection(self,theMode : int=-1) -> None: 
        """
        Sets update status FULL to selections of the object. Must be used as the only method of UpdateSelection from outer classes to prevent BVH structures from being outdated.
        """
    def UpdateTransformation(self) -> None: 
        """
        Recomputes the location of the selection aSelection.
        """
    def UpdateTransformations(self,aSelection : OCP.SelectMgr.SelectMgr_Selection) -> None: 
        """
        Updates locations in all sensitive entities from <aSelection> and in corresponding entity owners.
        """
    def ViewAffinity(self) -> OCP.Graphic3d.Graphic3d_ViewAffinity: 
        """
        Return view affinity mask.
        """
    def Width(self) -> float: 
        """
        Returns the width setting of the Interactive Object.
        """
    def ZLayer(self) -> int: 
        """
        Get ID of Z layer for main presentation.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    DM_BndBox: OCP.AIS.DisplayMode_e # value = <DisplayMode_e.DM_BndBox: 2>
    DM_Points: OCP.AIS.DisplayMode_e # value = <DisplayMode_e.DM_Points: 0>
    SM_BndBox: OCP.AIS.SelectionMode_e # value = <SelectionMode_e.SM_BndBox: 2>
    SM_Points: OCP.AIS.SelectionMode_e # value = <SelectionMode_e.SM_Points: 0>
    SM_SubsetOfPoints: OCP.AIS.SelectionMode_e # value = <SelectionMode_e.SM_SubsetOfPoints: 1>
    pass
class AIS_PointCloudOwner(OCP.SelectMgr.SelectMgr_EntityOwner, OCP.Standard.Standard_Transient):
    """
    Custom owner for highlighting selected points.
    """
    def Clear(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager,theMode : int) -> None: 
        """
        Clears presentation.
        """
    def ComesFromDecomposition(self) -> bool: 
        """
        Returns TRUE if this owner points to a part of object and FALSE for entire object.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DetectedPoints(self) -> OCP.TColStd.TColStd_HPackedMapOfInteger: 
        """
        Return last detected points. WARNING! Indexation starts with 0 (shifted by -1 comparing to Graphic3d_ArrayOfPoints::Vertice()).
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HandleMouseClick(self,thePoint : OCP.Graphic3d.Graphic3d_Vec2i,theButton : int,theModifiers : int,theIsDoubleClick : bool) -> bool: 
        """
        Handle mouse button click event. Does nothing by default and returns FALSE.
        """
    def HasLocation(self) -> bool: 
        """
        Returns TRUE if selectable has transformation.
        """
    def HasSelectable(self) -> bool: 
        """
        Returns true if there is a selectable object to serve as an owner.
        """
    def HilightWithColor(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager,theStyle : OCP.Prs3d.Prs3d_Drawer,theMode : int) -> None: 
        """
        Handle dynamic highlighting.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def IsAutoHilight(self) -> bool: 
        """
        if owner is not auto hilighted, for group contains many such owners will be called one method HilightSelected of SelectableObject
        """
    def IsForcedHilight(self) -> bool: 
        """
        Always update dynamic highlighting.
        """
    def IsHilighted(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager,theMode : int=0) -> bool: 
        """
        Returns true if the presentation manager highlights selections corresponding to the selection mode.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def IsSameSelectable(self,theOther : OCP.SelectMgr.SelectMgr_SelectableObject) -> bool: 
        """
        Returns true if pointer to selectable object of this owner is equal to the given one
        """
    def IsSelected(self) -> bool: 
        """
        Returns Standard_True if the owner is selected.
        """
    def Location(self) -> OCP.TopLoc.TopLoc_Location: 
        """
        Returns transformation of selectable.
        """
    def Priority(self) -> int: 
        """
        Return selection priority (within range [0-9]) for results with the same depth; 0 by default. Example - selection of shapes: the owners are selectable objects (presentations) a user can give vertex priority [3], edges [2] faces [1] shape [0], so that if during selection one vertex one edge and one face are simultaneously detected, the vertex will only be hilighted.
        """
    def Select(self,theSelScheme : AIS_SelectionScheme,theIsDetected : bool) -> bool: 
        """
        If the object needs to be selected, it returns true.
        """
    def Selectable(self) -> OCP.SelectMgr.SelectMgr_SelectableObject: 
        """
        Returns a selectable object detected in the working context.
        """
    def SelectedPoints(self) -> OCP.TColStd.TColStd_HPackedMapOfInteger: 
        """
        Return selected points. WARNING! Indexation starts with 0 (shifted by -1 comparing to Graphic3d_ArrayOfPoints::Vertice()).
        """
    @overload
    def Set(self,theSelObj : OCP.SelectMgr.SelectMgr_SelectableObject) -> None: 
        """
        Sets the selectable object.

        sets the selectable priority of the owner
        """
    @overload
    def Set(self,thePriority : int) -> None: ...
    def SetComesFromDecomposition(self,theIsFromDecomposition : bool) -> None: 
        """
        Sets flag indicating this owner points to a part of object (TRUE) or to entire object (FALSE).
        """
    def SetLocation(self,theLocation : OCP.TopLoc.TopLoc_Location) -> None: 
        """
        Change owner location (callback for handling change of location of selectable object).
        """
    def SetPriority(self,thePriority : int) -> None: 
        """
        Sets the selectable priority of the owner within range [0-9].
        """
    def SetSelectable(self,theSelObj : OCP.SelectMgr.SelectMgr_SelectableObject) -> None: 
        """
        Sets the selectable object.
        """
    def SetSelected(self,theIsSelected : bool) -> None: 
        """
        Set the state of the owner.
        """
    def SetZLayer(self,theLayerId : int) -> None: 
        """
        Set Z layer ID and update all presentations.
        """
    @overload
    def State(self) -> int: 
        """
        Returns selection state.

        Set the state of the owner. The method is deprecated. Use SetSelected() instead.
        """
    @overload
    def State(self,theStatus : int) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Unhilight(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager,theMode : int) -> None: 
        """
        Removes highlighting.
        """
    def UpdateHighlightTrsf(self,theViewer : OCP.V3d.V3d_Viewer,theManager : OCP.PrsMgr.PrsMgr_PresentationManager,theDispMode : int) -> None: 
        """
        Implements immediate application of location transformation of parent object to dynamic highlight structure
        """
    def __init__(self,theOrigin : AIS_PointCloud) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class AIS_RotationMode():
    """
    Camera rotation mode.

    Members:

      AIS_RotationMode_BndBoxActive

      AIS_RotationMode_PickLast

      AIS_RotationMode_PickCenter

      AIS_RotationMode_CameraAt

      AIS_RotationMode_BndBoxScene
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    AIS_RotationMode_BndBoxActive: OCP.AIS.AIS_RotationMode # value = <AIS_RotationMode.AIS_RotationMode_BndBoxActive: 0>
    AIS_RotationMode_BndBoxScene: OCP.AIS.AIS_RotationMode # value = <AIS_RotationMode.AIS_RotationMode_BndBoxScene: 4>
    AIS_RotationMode_CameraAt: OCP.AIS.AIS_RotationMode # value = <AIS_RotationMode.AIS_RotationMode_CameraAt: 3>
    AIS_RotationMode_PickCenter: OCP.AIS.AIS_RotationMode # value = <AIS_RotationMode.AIS_RotationMode_PickCenter: 2>
    AIS_RotationMode_PickLast: OCP.AIS.AIS_RotationMode # value = <AIS_RotationMode.AIS_RotationMode_PickLast: 1>
    __entries: dict # value = {'AIS_RotationMode_BndBoxActive': (<AIS_RotationMode.AIS_RotationMode_BndBoxActive: 0>, None), 'AIS_RotationMode_PickLast': (<AIS_RotationMode.AIS_RotationMode_PickLast: 1>, None), 'AIS_RotationMode_PickCenter': (<AIS_RotationMode.AIS_RotationMode_PickCenter: 2>, None), 'AIS_RotationMode_CameraAt': (<AIS_RotationMode.AIS_RotationMode_CameraAt: 3>, None), 'AIS_RotationMode_BndBoxScene': (<AIS_RotationMode.AIS_RotationMode_BndBoxScene: 4>, None)}
    __members__: dict # value = {'AIS_RotationMode_BndBoxActive': <AIS_RotationMode.AIS_RotationMode_BndBoxActive: 0>, 'AIS_RotationMode_PickLast': <AIS_RotationMode.AIS_RotationMode_PickLast: 1>, 'AIS_RotationMode_PickCenter': <AIS_RotationMode.AIS_RotationMode_PickCenter: 2>, 'AIS_RotationMode_CameraAt': <AIS_RotationMode.AIS_RotationMode_CameraAt: 3>, 'AIS_RotationMode_BndBoxScene': <AIS_RotationMode.AIS_RotationMode_BndBoxScene: 4>}
    pass
class AIS_RubberBand(AIS_InteractiveObject, OCP.SelectMgr.SelectMgr_SelectableObject, OCP.PrsMgr.PrsMgr_PresentableObject, OCP.Standard.Standard_Transient):
    """
    Presentation for drawing rubber band selection. It supports rectangle and polygonal selection. It is constructed in 2d overlay. Default configuration is built without filling. For rectangle selection use SetRectangle() method. For polygonal selection use AddPoint() and GetPoints() methods.Presentation for drawing rubber band selection. It supports rectangle and polygonal selection. It is constructed in 2d overlay. Default configuration is built without filling. For rectangle selection use SetRectangle() method. For polygonal selection use AddPoint() and GetPoints() methods.
    """
    def AcceptDisplayMode(self,theMode : int) -> bool: 
        """
        Returns true if the class of objects accepts specified display mode index. The interactive context can have a default mode of representation for the set of Interactive Objects. This mode may not be accepted by a given class of objects. Consequently, this virtual method allowing us to get information about the class in question must be implemented. At least one display mode index should be accepted by this method. Although subclass can leave default implementation, it is highly desired defining exact list of supported modes instead, which is usually an enumeration for one object or objects class sharing similar list of display modes.
        """
    def AcceptShapeDecomposition(self) -> bool: 
        """
        Informs the graphic context that the interactive Object may be decomposed into sub-shapes for dynamic selection. The most used Interactive Object is AIS_Shape.
        """
    def AddChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy.
        """
    def AddChildWithCurrentTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy with keeping the current global transformation So the object keeps the same position/orientation in the global CS.
        """
    def AddClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Adds clip plane for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def AddPoint(self,thePoint : OCP.Graphic3d.Graphic3d_Vec2i) -> None: 
        """
        Adds last point to the list of points. They are used to build polygon for rubber band.
        """
    def AddSelection(self,aSelection : OCP.SelectMgr.SelectMgr_Selection,aMode : int) -> None: 
        """
        Adds the selection aSelection with the selection mode index aMode to this framework.
        """
    def Attributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the attributes settings.
        """
    def BndBoxOfSelected(self,theOwners : Any) -> OCP.Bnd.Bnd_Box: 
        """
        Returns a bounding box of sensitive entities with the owners given if they are a part of activated selection
        """
    def BoundingBox(self,theBndBox : OCP.Bnd.Bnd_Box) -> None: 
        """
        Returns bounding box of object correspondingly to its current display mode. This method requires presentation to be already computed, since it relies on bounding box of presentation structures, which are supposed to be same/close amongst different display modes of this object.
        """
    def Children(self) -> OCP.PrsMgr.PrsMgr_ListOfPresentableObjects: 
        """
        Returns children of the current object.
        """
    def ClearDynamicHighlight(self,theMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> None: 
        """
        Method that needs to be implemented when the object manages selection and dynamic highlighting on its own. Clears or invalidates dynamic highlight presentation. By default it clears immediate draw of given presentation manager.
        """
    def ClearOwner(self) -> None: 
        """
        Each Interactive Object has methods which allow us to attribute an Owner to it in the form of a Transient. This method removes the owner from the graphic entity.
        """
    def ClearPoints(self) -> None: 
        """
        Remove all points for the rubber band polygon.
        """
    def ClearSelected(self) -> None: 
        """
        Method which clear all selected owners belonging to this selectable object ( for fast presentation draw )
        """
    def ClearSelections(self,update : bool=False) -> None: 
        """
        Empties all the selections in the SelectableObject <update> parameter defines whether all object's selections should be flagged for further update or not. This improved method can be used to recompute an object's selection (without redisplaying the object completely) when some selection mode is activated not for the first time.
        """
    def ClipPlanes(self) -> OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane: 
        """
        Get clip planes.
        """
    def Color(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Returns the color setting of the Interactive Object.
        """
    def CombinedParentTransformation(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return combined parent transformation.
        """
    def ComputeSelection(self,theSelection : OCP.SelectMgr.SelectMgr_Selection,theMode : int) -> None: 
        """
        Computes sensitive primitives for the given selection mode - key interface method of Selectable Object.
        """
    def CurrentFacingModel(self) -> OCP.Aspect.Aspect_TypeOfFacingModel: 
        """
        Returns the current facing model which is in effect.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def DefaultDisplayMode(self) -> int: 
        """
        Returns the default display mode.
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DisplayMode(self) -> int: 
        """
        Returns the display mode setting of the Interactive Object. The range of supported display mode indexes should be specified within object definition and filtered by AccepDisplayMode().
        """
    def DisplayStatus(self) -> OCP.PrsMgr.PrsMgr_DisplayStatus: 
        """
        Return presentation display status; PrsMgr_DisplayStatus_None by default.
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicHilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalDynamic and Prs3d_TypeOfHighlight_Dynamic defined within AIS_InteractiveContext::HighlightStyle().
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def ErasePresentations(self,theToRemove : bool) -> None: 
        """
        Removes presentations returned by GetHilightPresentation() and GetSelectPresentation().
        """
    def FillColor(self) -> OCP.Quantity.Quantity_Color: 
        """
        Returns the color of rubber band filling.
        """
    def FillTransparency(self) -> float: 
        """
        Returns fill transparency.
        """
    def GetAssemblyOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns common entity owner if the object is an assembly
        """
    def GetContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def GetHilightPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting detected object.
        """
    def GetOwner(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns the owner of the Interactive Object. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient. There are two types of owners: - Direct owners, decomposition shapes such as edges, wires, and faces. - Users, presentable objects connecting to sensitive primitives, or a shape which has been decomposed.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def GetSelectPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting selected object.
        """
    def GlobalSelOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns the owner of mode for selection of object as a whole
        """
    def GlobalSelectionMode(self) -> int: 
        """
        Returns the mode for selection of object as a whole; 0 by default.
        """
    def HasColor(self) -> bool: 
        """
        Returns true if the Interactive Object has color.
        """
    def HasDisplayMode(self) -> bool: 
        """
        Returns true if the Interactive Object has display mode setting overriding global setting (within Interactive Context).
        """
    def HasHilightMode(self) -> bool: 
        """
        Returns true if the Interactive Object is in highlight mode.
        """
    def HasInteractiveContext(self) -> bool: 
        """
        Indicates whether the Interactive Object has a pointer to an interactive context.
        """
    def HasMaterial(self) -> bool: 
        """
        Returns true if the Interactive Object has a setting for material.
        """
    def HasOwnPresentations(self) -> bool: 
        """
        Returns true if object should have own presentations.
        """
    def HasOwner(self) -> bool: 
        """
        Returns true if the object has an owner attributed to it. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient.
        """
    def HasPolygonOffsets(self) -> bool: 
        """
        Returns Standard_True if <myDrawer> has non-null shading aspect
        """
    def HasPresentation(self) -> bool: 
        """
        Returns TRUE when this object has a presentation in the current DisplayMode()
        """
    def HasSelection(self,theMode : int) -> bool: 
        """
        Returns true if a selection corresponding to the selection mode theMode was computed for this object.
        """
    def HasTransformation(self) -> bool: 
        """
        Returns true if object has a transformation that is different from the identity.
        """
    def HasWidth(self) -> bool: 
        """
        Returns true if the Interactive Object has width.
        """
    def HilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalSelected and Prs3d_TypeOfHighlight_Selected defined within AIS_InteractiveContext::HighlightStyle().
        """
    def HilightMode(self) -> int: 
        """
        Returns highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def HilightOwnerWithColor(self,thePM : OCP.PrsMgr.PrsMgr_PresentationManager,theStyle : OCP.Prs3d.Prs3d_Drawer,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner) -> None: 
        """
        Method which hilight an owner belonging to this selectable object ( for fast presentation draw )
        """
    def HilightSelected(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager,theSeq : OCP.SelectMgr.SelectMgr_SequenceOfOwner) -> None: 
        """
        Method which draws selected owners ( for fast presentation draw )
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def InteractiveContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def InversedTransformation(self) -> OCP.gp.gp_GTrsf: 
        """
        Return inversed transformation.
        """
    def IsAutoHilight(self) -> bool: 
        """
        If returns True, the old mechanism for highlighting selected objects is used (HilightSelected Method may be empty). If returns False, the HilightSelected method will be fully responsible for highlighting selected entity owners belonging to this selectable object.
        """
    def IsFilling(self) -> bool: 
        """
        Returns true if filling of rubber band is enabled.
        """
    def IsInfinite(self) -> bool: 
        """
        Returns true if the interactive object is infinite; FALSE by default. This flag affects various operations operating on bounding box of graphic presentations of this object. For instance, infinite objects are not taken in account for View FitAll. This does not necessarily means that object is actually infinite, auxiliary objects might be also marked with this flag to achieve desired behavior.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def IsMutable(self) -> bool: 
        """
        Returns true if object has mutable nature (content or location are be changed regularly). Mutable object will be managed in different way than static onces (another optimizations).
        """
    def IsPolygonClosed(self) -> bool: 
        """
        Returns true if automatic closing of rubber band is enabled.
        """
    def IsTransparent(self) -> bool: 
        """
        Returns true if there is a transparency setting.
        """
    def LineColor(self) -> OCP.Quantity.Quantity_Color: 
        """
        Returns the Color attributes.
        """
    def LineType(self) -> OCP.Aspect.Aspect_TypeOfLine: 
        """
        Returns type of lines.
        """
    def LineWidth(self) -> float: 
        """
        Returns width of lines.
        """
    def LocalTransformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def LocalTransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def Material(self) -> OCP.Graphic3d.Graphic3d_NameOfMaterial: 
        """
        Returns the current material setting as enumeration value.
        """
    def Parent(self) -> OCP.PrsMgr.PrsMgr_PresentableObject: 
        """
        Returns parent of current object in scene hierarchy.
        """
    def Points(self) -> Any: 
        """
        Returns points for the rubber band polygon.
        """
    def PolygonOffsets(self,aFactor : float,aUnits : float) -> tuple[int]: 
        """
        Retrieves current polygon offsets settings from <myDrawer>.
        """
    def Presentation(self) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Returns the current presentation of this object according to the current DisplayMode()
        """
    def Presentations(self) -> OCP.PrsMgr.PrsMgr_Presentations: 
        """
        Return presentations.
        """
    def ProcessDragging(self,theCtx : AIS_InteractiveContext,theView : OCP.V3d.V3d_View,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theDragFrom : OCP.Graphic3d.Graphic3d_Vec2i,theDragTo : OCP.Graphic3d.Graphic3d_Vec2i,theAction : AIS_DragAction) -> bool: 
        """
        Drag object in the viewer.
        """
    @overload
    def RecomputePrimitives(self) -> None: 
        """
        Re-computes the sensitive primitives for all modes. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.

        Re-computes the sensitive primitives which correspond to the <theMode>th selection mode. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.
        """
    @overload
    def RecomputePrimitives(self,theMode : int) -> None: ...
    def Redisplay(self,AllModes : bool=False) -> None: 
        """
        Updates the active presentation; if <AllModes> = Standard_True all the presentations inside are recomputed. IMPORTANT: It is preferable to call Redisplay method of corresponding AIS_InteractiveContext instance for cases when it is accessible. This method just redirects call to myCTXPtr, so this class field must be up to date for proper result.
        """
    def RemoveChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy.
        """
    def RemoveChildWithRestoreTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy with keeping the current global transformation. So the object keeps the same position/orientation in the global CS.
        """
    def RemoveClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Removes previously added clip plane.
        """
    def RemoveLastPoint(self) -> None: 
        """
        Remove last point from the list of points for the rubber band polygon.
        """
    def ResetTransformation(self) -> None: 
        """
        None
        """
    def Selection(self,theMode : int) -> OCP.SelectMgr.SelectMgr_Selection: 
        """
        Returns the selection having specified selection mode or NULL.
        """
    def Selections(self) -> OCP.SelectMgr.SelectMgr_SequenceOfSelection: 
        """
        Return the sequence of selections.
        """
    def SetAspect(self,anAspect : OCP.Prs3d.Prs3d_BasicAspect) -> None: 
        """
        Sets the graphic basic aspect to the current presentation.
        """
    def SetAssemblyOwner(self,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theMode : int=-1) -> None: 
        """
        Sets common entity owner for assembly sensitive object entities
        """
    def SetAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the drawing tool theDrawer.
        """
    def SetAutoHilight(self,theAutoHilight : bool) -> None: 
        """
        Set AutoHilight property to true or false.
        """
    def SetClipPlanes(self,thePlanes : OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane) -> None: 
        """
        Set clip planes for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def SetColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Only the interactive object knowns which Drawer attribute is affected by the color, if any (ex: for a wire,it's the wireaspect field of the drawer, but for a vertex, only the point aspect field is affected by the color). WARNING : Do not forget to set the corresponding fields here (hasOwnColor and myDrawer->SetColor())
        """
    def SetContext(self,aCtx : AIS_InteractiveContext) -> None: 
        """
        Sets the interactive context aCtx and provides a link to the default drawing tool or "Drawer" if there is none.
        """
    def SetCurrentFacingModel(self,theModel : OCP.Aspect.Aspect_TypeOfFacingModel=Aspect_TypeOfFacingModel.Aspect_TOFM_BOTH_SIDE) -> None: 
        """
        change the current facing model apply on polygons for SetColor(), SetTransparency(), SetMaterial() methods default facing model is Aspect_TOFM_TWO_SIDE. This mean that attributes is applying both on the front and back face.
        """
    def SetDisplayMode(self,theMode : int) -> None: 
        """
        Sets the display mode for the interactive object. An object can have its own temporary display mode, which is different from that proposed by the interactive context.
        """
    def SetDynamicHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the dynamic hilight drawing tool.
        """
    def SetFillColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Sets color of rubber band filling.
        """
    def SetFillTransparency(self,theValue : float) -> None: 
        """
        Sets fill transparency.
        """
    @overload
    def SetFilling(self,theIsFilling : bool) -> None: 
        """
        Enable or disable filling of rubber band.

        Enable filling of rubber band with defined parameters.
        """
    @overload
    def SetFilling(self,theColor : OCP.Quantity.Quantity_Color,theTransparency : float) -> None: ...
    def SetHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the hilight drawing tool theDrawer.
        """
    def SetHilightMode(self,theMode : int) -> None: 
        """
        Sets highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def SetInfiniteState(self,theFlag : bool=True) -> None: 
        """
        Sets if object should be considered as infinite.
        """
    def SetIsoOnTriangulation(self,theIsEnabled : bool) -> None: 
        """
        Enables or disables on-triangulation build of isolines according to the flag given.
        """
    def SetLineColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Sets color of lines for rubber band presentation.
        """
    def SetLineType(self,theType : OCP.Aspect.Aspect_TypeOfLine) -> None: 
        """
        Sets type of line for rubber band presentation.
        """
    def SetLineWidth(self,theWidth : float) -> None: 
        """
        Sets width of line for rubber band presentation.
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.gp.gp_Trsf) -> None: 
        """
        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.

        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.TopLoc.TopLoc_Datum3D) -> None: ...
    def SetMaterial(self,aName : OCP.Graphic3d.Graphic3d_MaterialAspect) -> None: 
        """
        Sets the material aMat defining this display attribute for the interactive object. Material aspect determines shading aspect, color and transparency of visible entities.
        """
    def SetMutable(self,theIsMutable : bool) -> None: 
        """
        Sets if the object has mutable nature (content or location will be changed regularly). This method should be called before object displaying to take effect.
        """
    def SetOwner(self,theApplicativeEntity : OCP.Standard.Standard_Transient) -> None: 
        """
        Allows you to attribute the owner theApplicativeEntity to an Interactive Object. This can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of. The owner takes the form of a transient.
        """
    def SetPolygonClosed(self,theIsPolygonClosed : bool) -> None: 
        """
        Automatically create an additional line connecting the first and the last screen points to close the boundary polyline
        """
    def SetPolygonOffsets(self,aMode : int,aFactor : float=1.0,aUnits : float=0.0) -> None: 
        """
        Sets up polygon offsets for this object.
        """
    def SetPropagateVisualState(self,theFlag : bool) -> None: 
        """
        Change the value of the flag "propagate visual state"
        """
    def SetRectangle(self,theMinX : int,theMinY : int,theMaxX : int,theMaxY : int) -> None: 
        """
        Sets rectangle bounds.
        """
    @overload
    def SetToUpdate(self) -> None: 
        """
        Flags presentation to be updated; UpdatePresentations() will recompute these presentations.

        flags all the Presentations to be Updated.
        """
    @overload
    def SetToUpdate(self,theMode : int) -> None: ...
    def SetTransformPersistence(self,theTrsfPers : OCP.Graphic3d.Graphic3d_TransformPers) -> None: 
        """
        Sets up Transform Persistence defining a special Local Coordinate system where this object should be located. Note that management of Transform Persistence object is more expensive than of the normal one, because it requires its position being recomputed basing on camera position within each draw call / traverse.
        """
    def SetTransparency(self,aValue : float=0.6) -> None: 
        """
        Attributes a setting aValue for transparency. The transparency value should be between 0.0 and 1.0. At 0.0 an object will be totally opaque, and at 1.0, fully transparent. Warning At a value of 1.0, there may be nothing visible.
        """
    def SetTypeOfPresentation(self,theType : OCP.PrsMgr.PrsMgr_TypeOfPresentation3d) -> None: 
        """
        Set type of presentation.
        """
    def SetWidth(self,theWidth : float) -> None: 
        """
        Allows you to provide the setting aValue for width. Only the Interactive Object knows which Drawer attribute is affected by the width setting.
        """
    def SetZLayer(self,theLayerId : int) -> None: 
        """
        Set Z layer ID and update all presentations of the selectable object. The layers mechanism allows drawing objects in higher layers in overlay of objects in lower layers.
        """
    def Signature(self) -> int: 
        """
        Specifies additional characteristics of Interactive Object of Type(); -1 by default. Among the datums, this signature is attributed to the shape. The remaining datums have the following default signatures: - Point signature 1 - Axis signature 2 - Trihedron signature 3 - PlaneTrihedron signature 4 - Line signature 5 - Circle signature 6 - Plane signature 7.
        """
    def SynchronizeAspects(self) -> None: 
        """
        Synchronize presentation aspects after their modification.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    @overload
    def ToBeUpdated(self,ListOfMode : OCP.TColStd.TColStd_ListOfInteger) -> None: 
        """
        Returns TRUE if any active presentation has invalidation flag.

        gives the list of modes which are flagged "to be updated".
        """
    @overload
    def ToBeUpdated(self,theToIncludeHidden : bool=False) -> bool: ...
    def ToPropagateVisualState(self) -> bool: 
        """
        Get value of the flag "propagate visual state" It means that the display/erase/color visual state is propagated automatically to all children; by default, the flag is true
        """
    def TransformPersistence(self) -> OCP.Graphic3d.Graphic3d_TransformPers: 
        """
        Returns Transformation Persistence defining a special Local Coordinate system where this presentable object is located or NULL handle if not defined. Position of the object having Transformation Persistence is mutable and depends on camera position. The same applies to a bounding box of the object.
        """
    def Transformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def TransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def Transparency(self) -> float: 
        """
        Returns the transparency setting. This will be between 0.0 and 1.0. At 0.0 an object will be totally opaque, and at 1.0, fully transparent.
        """
    def Type(self) -> AIS_KindOfInteractive: 
        """
        Returns the kind of Interactive Object; AIS_KindOfInteractive_None by default.
        """
    def TypeOfPresentation3d(self) -> OCP.PrsMgr.PrsMgr_TypeOfPresentation3d: 
        """
        Returns information on whether the object accepts display in HLR mode or not.
        """
    def UnsetAttributes(self) -> None: 
        """
        Clears settings provided by the drawing tool aDrawer.
        """
    def UnsetColor(self) -> None: 
        """
        Removes color settings. Only the Interactive Object knows which Drawer attribute is affected by the color setting. For a wire, for example, wire aspect is the attribute affected. For a vertex, however, only point aspect is affected by the color setting.
        """
    def UnsetDisplayMode(self) -> None: 
        """
        Removes display mode settings from the interactive object.
        """
    def UnsetHilightAttributes(self) -> None: 
        """
        Clears settings provided by the hilight drawing tool theDrawer.
        """
    def UnsetHilightMode(self) -> None: 
        """
        Unsets highlight display mode.
        """
    def UnsetMaterial(self) -> None: 
        """
        Removes the setting for material.
        """
    def UnsetTransparency(self) -> None: 
        """
        Removes the transparency setting. The object is opaque by default.
        """
    def UnsetWidth(self) -> None: 
        """
        Reset width to default value.
        """
    def UpdateSelection(self,theMode : int=-1) -> None: 
        """
        Sets update status FULL to selections of the object. Must be used as the only method of UpdateSelection from outer classes to prevent BVH structures from being outdated.
        """
    def UpdateTransformation(self) -> None: 
        """
        Recomputes the location of the selection aSelection.
        """
    def UpdateTransformations(self,aSelection : OCP.SelectMgr.SelectMgr_Selection) -> None: 
        """
        Updates locations in all sensitive entities from <aSelection> and in corresponding entity owners.
        """
    def ViewAffinity(self) -> OCP.Graphic3d.Graphic3d_ViewAffinity: 
        """
        Return view affinity mask.
        """
    def Width(self) -> float: 
        """
        Returns the width setting of the Interactive Object.
        """
    def ZLayer(self) -> int: 
        """
        Get ID of Z layer for main presentation.
        """
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theLineColor : OCP.Quantity.Quantity_Color,theType : OCP.Aspect.Aspect_TypeOfLine,theLineWidth : float=1.0,theIsPolygonClosed : bool=True) -> None: ...
    @overload
    def __init__(self,theLineColor : OCP.Quantity.Quantity_Color,theType : OCP.Aspect.Aspect_TypeOfLine,theFillColor : OCP.Quantity.Quantity_Color,theTransparency : float=1.0,theLineWidth : float=1.0,theIsPolygonClosed : bool=True) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class AIS_SelectStatus():
    """
    None

    Members:

      AIS_SS_Added

      AIS_SS_Removed

      AIS_SS_NotDone
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    AIS_SS_Added: OCP.AIS.AIS_SelectStatus # value = <AIS_SelectStatus.AIS_SS_Added: 0>
    AIS_SS_NotDone: OCP.AIS.AIS_SelectStatus # value = <AIS_SelectStatus.AIS_SS_NotDone: 2>
    AIS_SS_Removed: OCP.AIS.AIS_SelectStatus # value = <AIS_SelectStatus.AIS_SS_Removed: 1>
    __entries: dict # value = {'AIS_SS_Added': (<AIS_SelectStatus.AIS_SS_Added: 0>, None), 'AIS_SS_Removed': (<AIS_SelectStatus.AIS_SS_Removed: 1>, None), 'AIS_SS_NotDone': (<AIS_SelectStatus.AIS_SS_NotDone: 2>, None)}
    __members__: dict # value = {'AIS_SS_Added': <AIS_SelectStatus.AIS_SS_Added: 0>, 'AIS_SS_Removed': <AIS_SelectStatus.AIS_SS_Removed: 1>, 'AIS_SS_NotDone': <AIS_SelectStatus.AIS_SS_NotDone: 2>}
    pass
class AIS_Selection(OCP.Standard.Standard_Transient):
    """
    Class holding the list of selected owners.Class holding the list of selected owners.
    """
    def AddSelect(self,theObject : OCP.SelectMgr.SelectMgr_EntityOwner) -> AIS_SelectStatus: 
        """
        the object is always add int the selection. faster when the number of objects selected is great.
        """
    def Clear(self) -> None: 
        """
        removes all the object of the selection.
        """
    def ClearAndSelect(self,theObject : OCP.SelectMgr.SelectMgr_EntityOwner,theFilter : OCP.SelectMgr.SelectMgr_Filter,theIsDetected : bool) -> None: 
        """
        clears the selection and adds the object in the selection.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def Extent(self) -> int: 
        """
        Return the number of selected objects.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def Init(self) -> None: 
        """
        Start iteration through selected objects.
        """
    def IsEmpty(self) -> bool: 
        """
        Return true if list of selected objects is empty.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def IsSelected(self,theObject : OCP.SelectMgr.SelectMgr_EntityOwner) -> bool: 
        """
        checks if the object is in the selection.
        """
    def More(self) -> bool: 
        """
        Return true if iterator points to selected object.
        """
    def Next(self) -> None: 
        """
        Continue iteration through selected objects.
        """
    def Objects(self) -> AIS_NListOfEntityOwner: 
        """
        Return the list of selected objects.
        """
    def Select(self,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theFilter : OCP.SelectMgr.SelectMgr_Filter,theSelScheme : AIS_SelectionScheme,theIsDetected : bool) -> AIS_SelectStatus: 
        """
        if the object is not yet in the selection, it will be added. if the object is already in the selection, it will be removed.
        """
    def SelectOwners(self,thePickedOwners : AIS_NArray1OfEntityOwner,theSelScheme : AIS_SelectionScheme,theToAllowSelOverlap : bool,theFilter : OCP.SelectMgr.SelectMgr_Filter) -> None: 
        """
        Select or deselect owners depending on the selection scheme.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Value(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Return selected object at iterator position.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class AIS_SelectionModesConcurrency():
    """
    The mode specifying how multiple active Selection Modes should be treated during activation of new one.

    Members:

      AIS_SelectionModesConcurrency_Single

      AIS_SelectionModesConcurrency_GlobalOrLocal

      AIS_SelectionModesConcurrency_Multiple
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    AIS_SelectionModesConcurrency_GlobalOrLocal: OCP.AIS.AIS_SelectionModesConcurrency # value = <AIS_SelectionModesConcurrency.AIS_SelectionModesConcurrency_GlobalOrLocal: 1>
    AIS_SelectionModesConcurrency_Multiple: OCP.AIS.AIS_SelectionModesConcurrency # value = <AIS_SelectionModesConcurrency.AIS_SelectionModesConcurrency_Multiple: 2>
    AIS_SelectionModesConcurrency_Single: OCP.AIS.AIS_SelectionModesConcurrency # value = <AIS_SelectionModesConcurrency.AIS_SelectionModesConcurrency_Single: 0>
    __entries: dict # value = {'AIS_SelectionModesConcurrency_Single': (<AIS_SelectionModesConcurrency.AIS_SelectionModesConcurrency_Single: 0>, None), 'AIS_SelectionModesConcurrency_GlobalOrLocal': (<AIS_SelectionModesConcurrency.AIS_SelectionModesConcurrency_GlobalOrLocal: 1>, None), 'AIS_SelectionModesConcurrency_Multiple': (<AIS_SelectionModesConcurrency.AIS_SelectionModesConcurrency_Multiple: 2>, None)}
    __members__: dict # value = {'AIS_SelectionModesConcurrency_Single': <AIS_SelectionModesConcurrency.AIS_SelectionModesConcurrency_Single: 0>, 'AIS_SelectionModesConcurrency_GlobalOrLocal': <AIS_SelectionModesConcurrency.AIS_SelectionModesConcurrency_GlobalOrLocal: 1>, 'AIS_SelectionModesConcurrency_Multiple': <AIS_SelectionModesConcurrency.AIS_SelectionModesConcurrency_Multiple: 2>}
    pass
class AIS_SelectionScheme():
    """
    Sets selection schemes for interactive contexts.

    Members:

      AIS_SelectionScheme_UNKNOWN

      AIS_SelectionScheme_Replace

      AIS_SelectionScheme_Add

      AIS_SelectionScheme_Remove

      AIS_SelectionScheme_XOR

      AIS_SelectionScheme_Clear

      AIS_SelectionScheme_ReplaceExtra
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    AIS_SelectionScheme_Add: OCP.AIS.AIS_SelectionScheme # value = <AIS_SelectionScheme.AIS_SelectionScheme_Add: 1>
    AIS_SelectionScheme_Clear: OCP.AIS.AIS_SelectionScheme # value = <AIS_SelectionScheme.AIS_SelectionScheme_Clear: 4>
    AIS_SelectionScheme_Remove: OCP.AIS.AIS_SelectionScheme # value = <AIS_SelectionScheme.AIS_SelectionScheme_Remove: 2>
    AIS_SelectionScheme_Replace: OCP.AIS.AIS_SelectionScheme # value = <AIS_SelectionScheme.AIS_SelectionScheme_Replace: 0>
    AIS_SelectionScheme_ReplaceExtra: OCP.AIS.AIS_SelectionScheme # value = <AIS_SelectionScheme.AIS_SelectionScheme_ReplaceExtra: 5>
    AIS_SelectionScheme_UNKNOWN: OCP.AIS.AIS_SelectionScheme # value = <AIS_SelectionScheme.AIS_SelectionScheme_UNKNOWN: -1>
    AIS_SelectionScheme_XOR: OCP.AIS.AIS_SelectionScheme # value = <AIS_SelectionScheme.AIS_SelectionScheme_XOR: 3>
    __entries: dict # value = {'AIS_SelectionScheme_UNKNOWN': (<AIS_SelectionScheme.AIS_SelectionScheme_UNKNOWN: -1>, None), 'AIS_SelectionScheme_Replace': (<AIS_SelectionScheme.AIS_SelectionScheme_Replace: 0>, None), 'AIS_SelectionScheme_Add': (<AIS_SelectionScheme.AIS_SelectionScheme_Add: 1>, None), 'AIS_SelectionScheme_Remove': (<AIS_SelectionScheme.AIS_SelectionScheme_Remove: 2>, None), 'AIS_SelectionScheme_XOR': (<AIS_SelectionScheme.AIS_SelectionScheme_XOR: 3>, None), 'AIS_SelectionScheme_Clear': (<AIS_SelectionScheme.AIS_SelectionScheme_Clear: 4>, None), 'AIS_SelectionScheme_ReplaceExtra': (<AIS_SelectionScheme.AIS_SelectionScheme_ReplaceExtra: 5>, None)}
    __members__: dict # value = {'AIS_SelectionScheme_UNKNOWN': <AIS_SelectionScheme.AIS_SelectionScheme_UNKNOWN: -1>, 'AIS_SelectionScheme_Replace': <AIS_SelectionScheme.AIS_SelectionScheme_Replace: 0>, 'AIS_SelectionScheme_Add': <AIS_SelectionScheme.AIS_SelectionScheme_Add: 1>, 'AIS_SelectionScheme_Remove': <AIS_SelectionScheme.AIS_SelectionScheme_Remove: 2>, 'AIS_SelectionScheme_XOR': <AIS_SelectionScheme.AIS_SelectionScheme_XOR: 3>, 'AIS_SelectionScheme_Clear': <AIS_SelectionScheme.AIS_SelectionScheme_Clear: 4>, 'AIS_SelectionScheme_ReplaceExtra': <AIS_SelectionScheme.AIS_SelectionScheme_ReplaceExtra: 5>}
    pass
class AIS_ColoredShape(AIS_Shape, AIS_InteractiveObject, OCP.SelectMgr.SelectMgr_SelectableObject, OCP.PrsMgr.PrsMgr_PresentableObject, OCP.Standard.Standard_Transient):
    """
    Presentation of the shape with customizable sub-shapes properties.Presentation of the shape with customizable sub-shapes properties.
    """
    def AcceptDisplayMode(self,theMode : int) -> bool: 
        """
        Return true if specified display mode is supported.
        """
    def AcceptShapeDecomposition(self) -> bool: 
        """
        Returns true if the Interactive Object accepts shape decomposition.
        """
    def AddChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy.
        """
    def AddChildWithCurrentTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy with keeping the current global transformation So the object keeps the same position/orientation in the global CS.
        """
    def AddClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Adds clip plane for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def AddSelection(self,aSelection : OCP.SelectMgr.SelectMgr_Selection,aMode : int) -> None: 
        """
        Adds the selection aSelection with the selection mode index aMode to this framework.
        """
    def Attributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the attributes settings.
        """
    def BndBoxOfSelected(self,theOwners : Any) -> OCP.Bnd.Bnd_Box: 
        """
        Returns a bounding box of sensitive entities with the owners given if they are a part of activated selection
        """
    def BoundingBox(self) -> OCP.Bnd.Bnd_Box: 
        """
        Constructs a bounding box with which to reconstruct compound topological shapes for presentation.
        """
    def ChangeCustomAspectsMap(self) -> Any: 
        """
        Return the map of custom aspects.
        """
    def Children(self) -> OCP.PrsMgr.PrsMgr_ListOfPresentableObjects: 
        """
        Returns children of the current object.
        """
    def ClearCustomAspects(self) -> None: 
        """
        Reset the map of custom sub-shape aspects.
        """
    def ClearDynamicHighlight(self,theMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> None: 
        """
        Method that needs to be implemented when the object manages selection and dynamic highlighting on its own. Clears or invalidates dynamic highlight presentation. By default it clears immediate draw of given presentation manager.
        """
    def ClearOwner(self) -> None: 
        """
        Each Interactive Object has methods which allow us to attribute an Owner to it in the form of a Transient. This method removes the owner from the graphic entity.
        """
    def ClearSelected(self) -> None: 
        """
        Method which clear all selected owners belonging to this selectable object ( for fast presentation draw )
        """
    def ClearSelections(self,update : bool=False) -> None: 
        """
        Empties all the selections in the SelectableObject <update> parameter defines whether all object's selections should be flagged for further update or not. This improved method can be used to recompute an object's selection (without redisplaying the object completely) when some selection mode is activated not for the first time.
        """
    def ClipPlanes(self) -> OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane: 
        """
        Get clip planes.
        """
    def Color(self,aColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Returns the Color attributes of the shape accordingly to the current facing model;
        """
    def CombinedParentTransformation(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return combined parent transformation.
        """
    def ComputeSelection(self,theSelection : OCP.SelectMgr.SelectMgr_Selection,theMode : int) -> None: 
        """
        Computes sensitive primitives for the given selection mode - key interface method of Selectable Object.
        """
    def CurrentFacingModel(self) -> OCP.Aspect.Aspect_TypeOfFacingModel: 
        """
        Returns the current facing model which is in effect.
        """
    def CustomAspects(self,theShape : OCP.TopoDS.TopoDS_Shape) -> AIS_ColoredDrawer: 
        """
        Customize properties of specified sub-shape. The shape will be stored in the map but ignored, if it is not sub-shape of main Shape! This method can be used to mark sub-shapes with customizable properties.
        """
    def CustomAspectsMap(self) -> Any: 
        """
        Return the map of custom aspects.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def DefaultDisplayMode(self) -> int: 
        """
        Returns the default display mode.
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DisplayMode(self) -> int: 
        """
        Returns the display mode setting of the Interactive Object. The range of supported display mode indexes should be specified within object definition and filtered by AccepDisplayMode().
        """
    def DisplayStatus(self) -> OCP.PrsMgr.PrsMgr_DisplayStatus: 
        """
        Return presentation display status; PrsMgr_DisplayStatus_None by default.
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicHilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalDynamic and Prs3d_TypeOfHighlight_Dynamic defined within AIS_InteractiveContext::HighlightStyle().
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def ErasePresentations(self,theToRemove : bool) -> None: 
        """
        Removes presentations returned by GetHilightPresentation() and GetSelectPresentation().
        """
    def GetAssemblyOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns common entity owner if the object is an assembly
        """
    def GetContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def GetHilightPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting detected object.
        """
    def GetOwner(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns the owner of the Interactive Object. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient. There are two types of owners: - Direct owners, decomposition shapes such as edges, wires, and faces. - Users, presentable objects connecting to sensitive primitives, or a shape which has been decomposed.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def GetSelectPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting selected object.
        """
    def GlobalSelOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns the owner of mode for selection of object as a whole
        """
    def GlobalSelectionMode(self) -> int: 
        """
        Returns the mode for selection of object as a whole; 0 by default.
        """
    def HasColor(self) -> bool: 
        """
        Returns true if the Interactive Object has color.
        """
    def HasDisplayMode(self) -> bool: 
        """
        Returns true if the Interactive Object has display mode setting overriding global setting (within Interactive Context).
        """
    def HasHilightMode(self) -> bool: 
        """
        Returns true if the Interactive Object is in highlight mode.
        """
    def HasInteractiveContext(self) -> bool: 
        """
        Indicates whether the Interactive Object has a pointer to an interactive context.
        """
    def HasMaterial(self) -> bool: 
        """
        Returns true if the Interactive Object has a setting for material.
        """
    def HasOwnPresentations(self) -> bool: 
        """
        Returns true if object should have own presentations.
        """
    def HasOwner(self) -> bool: 
        """
        Returns true if the object has an owner attributed to it. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient.
        """
    def HasPolygonOffsets(self) -> bool: 
        """
        Returns Standard_True if <myDrawer> has non-null shading aspect
        """
    def HasPresentation(self) -> bool: 
        """
        Returns TRUE when this object has a presentation in the current DisplayMode()
        """
    def HasSelection(self,theMode : int) -> bool: 
        """
        Returns true if a selection corresponding to the selection mode theMode was computed for this object.
        """
    def HasTransformation(self) -> bool: 
        """
        Returns true if object has a transformation that is different from the identity.
        """
    def HasWidth(self) -> bool: 
        """
        Returns true if the Interactive Object has width.
        """
    def HilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalSelected and Prs3d_TypeOfHighlight_Selected defined within AIS_InteractiveContext::HighlightStyle().
        """
    def HilightMode(self) -> int: 
        """
        Returns highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def HilightOwnerWithColor(self,thePM : OCP.PrsMgr.PrsMgr_PresentationManager,theStyle : OCP.Prs3d.Prs3d_Drawer,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner) -> None: 
        """
        Method which hilight an owner belonging to this selectable object ( for fast presentation draw )
        """
    def HilightSelected(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager,theSeq : OCP.SelectMgr.SelectMgr_SequenceOfOwner) -> None: 
        """
        Method which draws selected owners ( for fast presentation draw )
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def InteractiveContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def InversedTransformation(self) -> OCP.gp.gp_GTrsf: 
        """
        Return inversed transformation.
        """
    def IsAutoHilight(self) -> bool: 
        """
        If returns True, the old mechanism for highlighting selected objects is used (HilightSelected Method may be empty). If returns False, the HilightSelected method will be fully responsible for highlighting selected entity owners belonging to this selectable object.
        """
    def IsInfinite(self) -> bool: 
        """
        Returns true if the interactive object is infinite; FALSE by default. This flag affects various operations operating on bounding box of graphic presentations of this object. For instance, infinite objects are not taken in account for View FitAll. This does not necessarily means that object is actually infinite, auxiliary objects might be also marked with this flag to achieve desired behavior.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def IsMutable(self) -> bool: 
        """
        Returns true if object has mutable nature (content or location are be changed regularly). Mutable object will be managed in different way than static onces (another optimizations).
        """
    def IsTransparent(self) -> bool: 
        """
        Returns true if there is a transparency setting.
        """
    def LocalTransformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def LocalTransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def Material(self) -> OCP.Graphic3d.Graphic3d_NameOfMaterial: 
        """
        Returns the NameOfMaterial attributes of the shape accordingly to the current facing model;
        """
    def OwnDeviationAngle(self,anAngle : float,aPreviousAngle : float) -> bool: 
        """
        Returns true and the values of the deviation angle anAngle and the previous deviation angle aPreviousAngle. If these values are not already set, false is returned.
        """
    def OwnDeviationCoefficient(self,aCoefficient : float,aPreviousCoefficient : float) -> bool: 
        """
        Returns true and the values of the deviation coefficient aCoefficient and the previous deviation coefficient aPreviousCoefficient. If these values are not already set, false is returned.
        """
    def Parent(self) -> OCP.PrsMgr.PrsMgr_PresentableObject: 
        """
        Returns parent of current object in scene hierarchy.
        """
    def PolygonOffsets(self,aFactor : float,aUnits : float) -> tuple[int]: 
        """
        Retrieves current polygon offsets settings from <myDrawer>.
        """
    def Presentation(self) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Returns the current presentation of this object according to the current DisplayMode()
        """
    def Presentations(self) -> OCP.PrsMgr.PrsMgr_Presentations: 
        """
        Return presentations.
        """
    def ProcessDragging(self,theCtx : AIS_InteractiveContext,theView : OCP.V3d.V3d_View,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theDragFrom : OCP.Graphic3d.Graphic3d_Vec2i,theDragTo : OCP.Graphic3d.Graphic3d_Vec2i,theAction : AIS_DragAction) -> bool: 
        """
        Drag object in the viewer.
        """
    @overload
    def RecomputePrimitives(self) -> None: 
        """
        Re-computes the sensitive primitives for all modes. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.

        Re-computes the sensitive primitives which correspond to the <theMode>th selection mode. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.
        """
    @overload
    def RecomputePrimitives(self,theMode : int) -> None: ...
    def Redisplay(self,AllModes : bool=False) -> None: 
        """
        Updates the active presentation; if <AllModes> = Standard_True all the presentations inside are recomputed. IMPORTANT: It is preferable to call Redisplay method of corresponding AIS_InteractiveContext instance for cases when it is accessible. This method just redirects call to myCTXPtr, so this class field must be up to date for proper result.
        """
    def RemoveChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy.
        """
    def RemoveChildWithRestoreTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy with keeping the current global transformation. So the object keeps the same position/orientation in the global CS.
        """
    def RemoveClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Removes previously added clip plane.
        """
    def ResetTransformation(self) -> None: 
        """
        None
        """
    def Selection(self,theMode : int) -> OCP.SelectMgr.SelectMgr_Selection: 
        """
        Returns the selection having specified selection mode or NULL.
        """
    @staticmethod
    def SelectionMode_s(theShapeType : OCP.TopAbs.TopAbs_ShapeEnum) -> int: 
        """
        Return selection mode for specified shape type.
        """
    @staticmethod
    def SelectionType_s(theSelMode : int) -> OCP.TopAbs.TopAbs_ShapeEnum: 
        """
        Return shape type for specified selection mode.
        """
    def Selections(self) -> OCP.SelectMgr.SelectMgr_SequenceOfSelection: 
        """
        Return the sequence of selections.
        """
    def Set(self,theShape : OCP.TopoDS.TopoDS_Shape) -> None: 
        """
        Alias for ::SetShape().
        """
    def SetAngleAndDeviation(self,anAngle : float) -> None: 
        """
        this compute a new angle and Deviation from the value anAngle and set the values stored in myDrawer with these that become local to the shape
        """
    def SetAspect(self,anAspect : OCP.Prs3d.Prs3d_BasicAspect) -> None: 
        """
        Sets the graphic basic aspect to the current presentation.
        """
    def SetAssemblyOwner(self,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theMode : int=-1) -> None: 
        """
        Sets common entity owner for assembly sensitive object entities
        """
    def SetAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the drawing tool theDrawer.
        """
    def SetAutoHilight(self,theAutoHilight : bool) -> None: 
        """
        Set AutoHilight property to true or false.
        """
    def SetClipPlanes(self,thePlanes : OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane) -> None: 
        """
        Set clip planes for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def SetColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Setup color of entire shape.
        """
    def SetContext(self,aCtx : AIS_InteractiveContext) -> None: 
        """
        Sets the interactive context aCtx and provides a link to the default drawing tool or "Drawer" if there is none.
        """
    def SetCurrentFacingModel(self,theModel : OCP.Aspect.Aspect_TypeOfFacingModel=Aspect_TypeOfFacingModel.Aspect_TOFM_BOTH_SIDE) -> None: 
        """
        change the current facing model apply on polygons for SetColor(), SetTransparency(), SetMaterial() methods default facing model is Aspect_TOFM_TWO_SIDE. This mean that attributes is applying both on the front and back face.
        """
    def SetCustomColor(self,theShape : OCP.TopoDS.TopoDS_Shape,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Customize color of specified sub-shape
        """
    def SetCustomTransparency(self,theShape : OCP.TopoDS.TopoDS_Shape,theTransparency : float) -> None: 
        """
        Customize transparency of specified sub-shape
        """
    def SetCustomWidth(self,theShape : OCP.TopoDS.TopoDS_Shape,theLineWidth : float) -> None: 
        """
        Customize line width of specified sub-shape
        """
    def SetDisplayMode(self,theMode : int) -> None: 
        """
        Sets the display mode for the interactive object. An object can have its own temporary display mode, which is different from that proposed by the interactive context.
        """
    def SetDynamicHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the dynamic hilight drawing tool.
        """
    def SetHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the hilight drawing tool theDrawer.
        """
    def SetHilightMode(self,theMode : int) -> None: 
        """
        Sets highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def SetInfiniteState(self,theFlag : bool=True) -> None: 
        """
        Sets if object should be considered as infinite.
        """
    def SetIsoOnTriangulation(self,theIsEnabled : bool) -> None: 
        """
        Enables or disables on-triangulation build of isolines according to the flag given.
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.gp.gp_Trsf) -> None: 
        """
        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.

        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.TopLoc.TopLoc_Datum3D) -> None: ...
    def SetMaterial(self,theAspect : OCP.Graphic3d.Graphic3d_MaterialAspect) -> None: 
        """
        Sets the material aspect.
        """
    def SetMutable(self,theIsMutable : bool) -> None: 
        """
        Sets if the object has mutable nature (content or location will be changed regularly). This method should be called before object displaying to take effect.
        """
    @overload
    def SetOwnDeviationAngle(self,anAngle : float) -> None: 
        """
        Sets a local value for deviation angle for this specific shape.

        sets myOwnDeviationAngle field in Prs3d_Drawer & recomputes presentation
        """
    @overload
    def SetOwnDeviationAngle(self) -> bool: ...
    @overload
    def SetOwnDeviationCoefficient(self,aCoefficient : float) -> None: 
        """
        Sets a local value for deviation coefficient for this specific shape.

        Sets a local value for deviation coefficient for this specific shape.
        """
    @overload
    def SetOwnDeviationCoefficient(self) -> bool: ...
    def SetOwner(self,theApplicativeEntity : OCP.Standard.Standard_Transient) -> None: 
        """
        Allows you to attribute the owner theApplicativeEntity to an Interactive Object. This can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of. The owner takes the form of a transient.
        """
    def SetPolygonOffsets(self,aMode : int,aFactor : float=1.0,aUnits : float=0.0) -> None: 
        """
        Sets up polygon offsets for this object.
        """
    def SetPropagateVisualState(self,theFlag : bool) -> None: 
        """
        Change the value of the flag "propagate visual state"
        """
    def SetShape(self,theShape : OCP.TopoDS.TopoDS_Shape) -> None: 
        """
        Constructs an instance of the shape object theShape.
        """
    def SetTextureOriginUV(self,theOriginUV : OCP.gp.gp_Pnt2d) -> None: 
        """
        Use this method to change the origin of the texture. The texel (0,0) will be mapped to the surface (myUVOrigin.X(), myUVOrigin.Y()).
        """
    def SetTextureRepeatUV(self,theRepeatUV : OCP.gp.gp_Pnt2d) -> None: 
        """
        Sets the number of occurrences of the texture on each face. The texture itself is parameterized in (0,1) by (0,1). Each face of the shape to be textured is parameterized in UV space (Umin,Umax) by (Vmin,Vmax).
        """
    def SetTextureScaleUV(self,theScaleUV : OCP.gp.gp_Pnt2d) -> None: 
        """
        Use this method to scale the texture (percent of the face). You can specify a scale factor for both U and V. Example: if you set ScaleU and ScaleV to 0.5 and you enable texture repeat, the texture will appear twice on the face in each direction.
        """
    @overload
    def SetToUpdate(self) -> None: 
        """
        Flags presentation to be updated; UpdatePresentations() will recompute these presentations.

        flags all the Presentations to be Updated.
        """
    @overload
    def SetToUpdate(self,theMode : int) -> None: ...
    def SetTransformPersistence(self,theTrsfPers : OCP.Graphic3d.Graphic3d_TransformPers) -> None: 
        """
        Sets up Transform Persistence defining a special Local Coordinate system where this object should be located. Note that management of Transform Persistence object is more expensive than of the normal one, because it requires its position being recomputed basing on camera position within each draw call / traverse.
        """
    def SetTransparency(self,theValue : float) -> None: 
        """
        Sets transparency value.
        """
    def SetTypeOfHLR(self,theTypeOfHLR : OCP.Prs3d.Prs3d_TypeOfHLR) -> None: 
        """
        Sets the type of HLR algorithm used by the shape
        """
    def SetTypeOfPresentation(self,theType : OCP.PrsMgr.PrsMgr_TypeOfPresentation3d) -> None: 
        """
        Set type of presentation.
        """
    def SetWidth(self,theLineWidth : float) -> None: 
        """
        Setup line width of entire shape.
        """
    def SetZLayer(self,theLayerId : int) -> None: 
        """
        Set Z layer ID and update all presentations of the selectable object. The layers mechanism allows drawing objects in higher layers in overlay of objects in lower layers.
        """
    def Shape(self) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Returns this shape object.
        """
    def Signature(self) -> int: 
        """
        Returns index 0. This value refers to SHAPE from TopAbs_ShapeEnum
        """
    def SynchronizeAspects(self) -> None: 
        """
        Synchronize presentation aspects after their modification.
        """
    def TextureOriginUV(self) -> OCP.gp.gp_Pnt2d: 
        """
        Return texture origin UV position; (0, 0) by default.
        """
    def TextureRepeatUV(self) -> OCP.gp.gp_Pnt2d: 
        """
        Return texture repeat UV values; (1, 1) by default.
        """
    def TextureScaleUV(self) -> OCP.gp.gp_Pnt2d: 
        """
        Return scale factor for UV coordinates; (1, 1) by default.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    @overload
    def ToBeUpdated(self,ListOfMode : OCP.TColStd.TColStd_ListOfInteger) -> None: 
        """
        Returns TRUE if any active presentation has invalidation flag.

        gives the list of modes which are flagged "to be updated".
        """
    @overload
    def ToBeUpdated(self,theToIncludeHidden : bool=False) -> bool: ...
    def ToPropagateVisualState(self) -> bool: 
        """
        Get value of the flag "propagate visual state" It means that the display/erase/color visual state is propagated automatically to all children; by default, the flag is true
        """
    def TransformPersistence(self) -> OCP.Graphic3d.Graphic3d_TransformPers: 
        """
        Returns Transformation Persistence defining a special Local Coordinate system where this presentable object is located or NULL handle if not defined. Position of the object having Transformation Persistence is mutable and depends on camera position. The same applies to a bounding box of the object.
        """
    def Transformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def TransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def Transparency(self) -> float: 
        """
        Returns the transparency attributes of the shape accordingly to the current facing model;
        """
    def Type(self) -> AIS_KindOfInteractive: 
        """
        Returns Object as the type of Interactive Object.
        """
    def TypeOfHLR(self) -> OCP.Prs3d.Prs3d_TypeOfHLR: 
        """
        Gets the type of HLR algorithm
        """
    def TypeOfPresentation3d(self) -> OCP.PrsMgr.PrsMgr_TypeOfPresentation3d: 
        """
        Returns information on whether the object accepts display in HLR mode or not.
        """
    def UnsetAttributes(self) -> None: 
        """
        Clears settings provided by the drawing tool aDrawer.
        """
    def UnsetColor(self) -> None: 
        """
        Removes settings for color in the reconstructed compound shape.
        """
    def UnsetCustomAspects(self,theShape : OCP.TopoDS.TopoDS_Shape,theToUnregister : bool=False) -> None: 
        """
        Reset custom properties of specified sub-shape.
        """
    def UnsetDisplayMode(self) -> None: 
        """
        Removes display mode settings from the interactive object.
        """
    def UnsetHilightAttributes(self) -> None: 
        """
        Clears settings provided by the hilight drawing tool theDrawer.
        """
    def UnsetHilightMode(self) -> None: 
        """
        Unsets highlight display mode.
        """
    def UnsetMaterial(self) -> None: 
        """
        Removes settings for material in the reconstructed compound shape.
        """
    def UnsetTransparency(self) -> None: 
        """
        Removes the setting for transparency in the reconstructed compound shape.
        """
    def UnsetWidth(self) -> None: 
        """
        Setup line width of entire shape.
        """
    def UpdateSelection(self,theMode : int=-1) -> None: 
        """
        Sets update status FULL to selections of the object. Must be used as the only method of UpdateSelection from outer classes to prevent BVH structures from being outdated.
        """
    def UpdateTransformation(self) -> None: 
        """
        Recomputes the location of the selection aSelection.
        """
    def UpdateTransformations(self,aSelection : OCP.SelectMgr.SelectMgr_Selection) -> None: 
        """
        Updates locations in all sensitive entities from <aSelection> and in corresponding entity owners.
        """
    def UserAngle(self) -> float: 
        """
        gives back the angle initial value put by the User.
        """
    def ViewAffinity(self) -> OCP.Graphic3d.Graphic3d_ViewAffinity: 
        """
        Return view affinity mask.
        """
    def Width(self) -> float: 
        """
        Returns the width setting of the Interactive Object.
        """
    def ZLayer(self) -> int: 
        """
        Get ID of Z layer for main presentation.
        """
    @overload
    def __init__(self,theShape : OCP.TopoDS.TopoDS_Shape) -> None: ...
    @overload
    def __init__(self,theShape : AIS_Shape) -> None: ...
    @staticmethod
    def computeHlrPresentation_s(theProjector : OCP.Graphic3d.Graphic3d_Camera,thePrs : OCP.Graphic3d.Graphic3d_Structure,theShape : OCP.TopoDS.TopoDS_Shape,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Compute HLR presentation for specified shape.
        """
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class AIS_TypeFilter(OCP.SelectMgr.SelectMgr_Filter, OCP.Standard.Standard_Transient):
    """
    Selects Interactive Objects through their types. The filter questions each Interactive Object in local context to determine whether it has an non-null owner, and if so, whether it is of the desired type. If the object returns true in each case, it is kept. If not, it is rejected. By default, the interactive object has a None type and a signature of 0. A filter for type specifies a choice of type out of a range at any level enumerated for type or kind. The choice could be for kind of interactive object, of dimension, of unit, or type of axis, plane or attribute. If you want to give a particular type and signature to your Interactive Object, you must redefine two virtual methods: Type and Signature. This filter is used in both Neutral Point and open local contexts. In the Collector viewer, you can only locate Interactive Objects which answer positively to the positioned filters when a local context is open. Warning When you close a local context, all temporary interactive objects are deleted, all selection modes concerning the context are cancelled, and all content filters are emptied.Selects Interactive Objects through their types. The filter questions each Interactive Object in local context to determine whether it has an non-null owner, and if so, whether it is of the desired type. If the object returns true in each case, it is kept. If not, it is rejected. By default, the interactive object has a None type and a signature of 0. A filter for type specifies a choice of type out of a range at any level enumerated for type or kind. The choice could be for kind of interactive object, of dimension, of unit, or type of axis, plane or attribute. If you want to give a particular type and signature to your Interactive Object, you must redefine two virtual methods: Type and Signature. This filter is used in both Neutral Point and open local contexts. In the Collector viewer, you can only locate Interactive Objects which answer positively to the positioned filters when a local context is open. Warning When you close a local context, all temporary interactive objects are deleted, all selection modes concerning the context are cancelled, and all content filters are emptied.Selects Interactive Objects through their types. The filter questions each Interactive Object in local context to determine whether it has an non-null owner, and if so, whether it is of the desired type. If the object returns true in each case, it is kept. If not, it is rejected. By default, the interactive object has a None type and a signature of 0. A filter for type specifies a choice of type out of a range at any level enumerated for type or kind. The choice could be for kind of interactive object, of dimension, of unit, or type of axis, plane or attribute. If you want to give a particular type and signature to your Interactive Object, you must redefine two virtual methods: Type and Signature. This filter is used in both Neutral Point and open local contexts. In the Collector viewer, you can only locate Interactive Objects which answer positively to the positioned filters when a local context is open. Warning When you close a local context, all temporary interactive objects are deleted, all selection modes concerning the context are cancelled, and all content filters are emptied.
    """
    def ActsOn(self,aStandardMode : OCP.TopAbs.TopAbs_ShapeEnum) -> bool: 
        """
        Returns true in an AIS local context, if this filter operates on a type of subshape defined in a filter class inheriting this framework. This function completes IsOk in an AIS local context.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def IsOk(self,anobj : OCP.SelectMgr.SelectMgr_EntityOwner) -> bool: 
        """
        Returns False if the transient is not an Interactive Object, or if the type of the Interactive Object is not the same as that stored in the filter.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self,aGivenKind : AIS_KindOfInteractive) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class AIS_StatusOfDetection():
    """
    None

    Members:

      AIS_SOD_Error

      AIS_SOD_Nothing

      AIS_SOD_AllBad

      AIS_SOD_Selected

      AIS_SOD_OnlyOneDetected

      AIS_SOD_OnlyOneGood

      AIS_SOD_SeveralGood
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    AIS_SOD_AllBad: OCP.AIS.AIS_StatusOfDetection # value = <AIS_StatusOfDetection.AIS_SOD_AllBad: 2>
    AIS_SOD_Error: OCP.AIS.AIS_StatusOfDetection # value = <AIS_StatusOfDetection.AIS_SOD_Error: 0>
    AIS_SOD_Nothing: OCP.AIS.AIS_StatusOfDetection # value = <AIS_StatusOfDetection.AIS_SOD_Nothing: 1>
    AIS_SOD_OnlyOneDetected: OCP.AIS.AIS_StatusOfDetection # value = <AIS_StatusOfDetection.AIS_SOD_OnlyOneDetected: 4>
    AIS_SOD_OnlyOneGood: OCP.AIS.AIS_StatusOfDetection # value = <AIS_StatusOfDetection.AIS_SOD_OnlyOneGood: 5>
    AIS_SOD_Selected: OCP.AIS.AIS_StatusOfDetection # value = <AIS_StatusOfDetection.AIS_SOD_Selected: 3>
    AIS_SOD_SeveralGood: OCP.AIS.AIS_StatusOfDetection # value = <AIS_StatusOfDetection.AIS_SOD_SeveralGood: 6>
    __entries: dict # value = {'AIS_SOD_Error': (<AIS_StatusOfDetection.AIS_SOD_Error: 0>, None), 'AIS_SOD_Nothing': (<AIS_StatusOfDetection.AIS_SOD_Nothing: 1>, None), 'AIS_SOD_AllBad': (<AIS_StatusOfDetection.AIS_SOD_AllBad: 2>, None), 'AIS_SOD_Selected': (<AIS_StatusOfDetection.AIS_SOD_Selected: 3>, None), 'AIS_SOD_OnlyOneDetected': (<AIS_StatusOfDetection.AIS_SOD_OnlyOneDetected: 4>, None), 'AIS_SOD_OnlyOneGood': (<AIS_StatusOfDetection.AIS_SOD_OnlyOneGood: 5>, None), 'AIS_SOD_SeveralGood': (<AIS_StatusOfDetection.AIS_SOD_SeveralGood: 6>, None)}
    __members__: dict # value = {'AIS_SOD_Error': <AIS_StatusOfDetection.AIS_SOD_Error: 0>, 'AIS_SOD_Nothing': <AIS_StatusOfDetection.AIS_SOD_Nothing: 1>, 'AIS_SOD_AllBad': <AIS_StatusOfDetection.AIS_SOD_AllBad: 2>, 'AIS_SOD_Selected': <AIS_StatusOfDetection.AIS_SOD_Selected: 3>, 'AIS_SOD_OnlyOneDetected': <AIS_StatusOfDetection.AIS_SOD_OnlyOneDetected: 4>, 'AIS_SOD_OnlyOneGood': <AIS_StatusOfDetection.AIS_SOD_OnlyOneGood: 5>, 'AIS_SOD_SeveralGood': <AIS_StatusOfDetection.AIS_SOD_SeveralGood: 6>}
    pass
class AIS_StatusOfPick():
    """
    None

    Members:

      AIS_SOP_Error

      AIS_SOP_NothingSelected

      AIS_SOP_Removed

      AIS_SOP_OneSelected

      AIS_SOP_SeveralSelected
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    AIS_SOP_Error: OCP.AIS.AIS_StatusOfPick # value = <AIS_StatusOfPick.AIS_SOP_Error: 0>
    AIS_SOP_NothingSelected: OCP.AIS.AIS_StatusOfPick # value = <AIS_StatusOfPick.AIS_SOP_NothingSelected: 1>
    AIS_SOP_OneSelected: OCP.AIS.AIS_StatusOfPick # value = <AIS_StatusOfPick.AIS_SOP_OneSelected: 3>
    AIS_SOP_Removed: OCP.AIS.AIS_StatusOfPick # value = <AIS_StatusOfPick.AIS_SOP_Removed: 2>
    AIS_SOP_SeveralSelected: OCP.AIS.AIS_StatusOfPick # value = <AIS_StatusOfPick.AIS_SOP_SeveralSelected: 4>
    __entries: dict # value = {'AIS_SOP_Error': (<AIS_StatusOfPick.AIS_SOP_Error: 0>, None), 'AIS_SOP_NothingSelected': (<AIS_StatusOfPick.AIS_SOP_NothingSelected: 1>, None), 'AIS_SOP_Removed': (<AIS_StatusOfPick.AIS_SOP_Removed: 2>, None), 'AIS_SOP_OneSelected': (<AIS_StatusOfPick.AIS_SOP_OneSelected: 3>, None), 'AIS_SOP_SeveralSelected': (<AIS_StatusOfPick.AIS_SOP_SeveralSelected: 4>, None)}
    __members__: dict # value = {'AIS_SOP_Error': <AIS_StatusOfPick.AIS_SOP_Error: 0>, 'AIS_SOP_NothingSelected': <AIS_StatusOfPick.AIS_SOP_NothingSelected: 1>, 'AIS_SOP_Removed': <AIS_StatusOfPick.AIS_SOP_Removed: 2>, 'AIS_SOP_OneSelected': <AIS_StatusOfPick.AIS_SOP_OneSelected: 3>, 'AIS_SOP_SeveralSelected': <AIS_StatusOfPick.AIS_SOP_SeveralSelected: 4>}
    pass
class AIS_TextLabel(AIS_InteractiveObject, OCP.SelectMgr.SelectMgr_SelectableObject, OCP.PrsMgr.PrsMgr_PresentableObject, OCP.Standard.Standard_Transient):
    """
    Presentation of the text.Presentation of the text.
    """
    def AcceptDisplayMode(self,theMode : int) -> bool: 
        """
        Return TRUE for supported display mode.
        """
    def AcceptShapeDecomposition(self) -> bool: 
        """
        Informs the graphic context that the interactive Object may be decomposed into sub-shapes for dynamic selection. The most used Interactive Object is AIS_Shape.
        """
    def AddChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy.
        """
    def AddChildWithCurrentTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy with keeping the current global transformation So the object keeps the same position/orientation in the global CS.
        """
    def AddClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Adds clip plane for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def AddSelection(self,aSelection : OCP.SelectMgr.SelectMgr_Selection,aMode : int) -> None: 
        """
        Adds the selection aSelection with the selection mode index aMode to this framework.
        """
    def Attributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the attributes settings.
        """
    def BndBoxOfSelected(self,theOwners : Any) -> OCP.Bnd.Bnd_Box: 
        """
        Returns a bounding box of sensitive entities with the owners given if they are a part of activated selection
        """
    def BoundingBox(self,theBndBox : OCP.Bnd.Bnd_Box) -> None: 
        """
        Returns bounding box of object correspondingly to its current display mode. This method requires presentation to be already computed, since it relies on bounding box of presentation structures, which are supposed to be same/close amongst different display modes of this object.
        """
    def Children(self) -> OCP.PrsMgr.PrsMgr_ListOfPresentableObjects: 
        """
        Returns children of the current object.
        """
    def ClearDynamicHighlight(self,theMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> None: 
        """
        Method that needs to be implemented when the object manages selection and dynamic highlighting on its own. Clears or invalidates dynamic highlight presentation. By default it clears immediate draw of given presentation manager.
        """
    def ClearOwner(self) -> None: 
        """
        Each Interactive Object has methods which allow us to attribute an Owner to it in the form of a Transient. This method removes the owner from the graphic entity.
        """
    def ClearSelected(self) -> None: 
        """
        Method which clear all selected owners belonging to this selectable object ( for fast presentation draw )
        """
    def ClearSelections(self,update : bool=False) -> None: 
        """
        Empties all the selections in the SelectableObject <update> parameter defines whether all object's selections should be flagged for further update or not. This improved method can be used to recompute an object's selection (without redisplaying the object completely) when some selection mode is activated not for the first time.
        """
    def ClipPlanes(self) -> OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane: 
        """
        Get clip planes.
        """
    def Color(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Returns the color setting of the Interactive Object.
        """
    def CombinedParentTransformation(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return combined parent transformation.
        """
    def ComputeSelection(self,theSelection : OCP.SelectMgr.SelectMgr_Selection,theMode : int) -> None: 
        """
        Computes sensitive primitives for the given selection mode - key interface method of Selectable Object.
        """
    def CurrentFacingModel(self) -> OCP.Aspect.Aspect_TypeOfFacingModel: 
        """
        Returns the current facing model which is in effect.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def DefaultDisplayMode(self) -> int: 
        """
        Returns the default display mode.
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DisplayMode(self) -> int: 
        """
        Returns the display mode setting of the Interactive Object. The range of supported display mode indexes should be specified within object definition and filtered by AccepDisplayMode().
        """
    def DisplayStatus(self) -> OCP.PrsMgr.PrsMgr_DisplayStatus: 
        """
        Return presentation display status; PrsMgr_DisplayStatus_None by default.
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicHilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalDynamic and Prs3d_TypeOfHighlight_Dynamic defined within AIS_InteractiveContext::HighlightStyle().
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def ErasePresentations(self,theToRemove : bool) -> None: 
        """
        Removes presentations returned by GetHilightPresentation() and GetSelectPresentation().
        """
    def FontAspect(self) -> OCP.Font.Font_FontAspect: 
        """
        Returns the font aspect of the label text.
        """
    def FontName(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Returns the font of the label text.
        """
    def GetAssemblyOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns common entity owner if the object is an assembly
        """
    def GetContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def GetHilightPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting detected object.
        """
    def GetOwner(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns the owner of the Interactive Object. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient. There are two types of owners: - Direct owners, decomposition shapes such as edges, wires, and faces. - Users, presentable objects connecting to sensitive primitives, or a shape which has been decomposed.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def GetSelectPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting selected object.
        """
    def GlobalSelOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns the owner of mode for selection of object as a whole
        """
    def GlobalSelectionMode(self) -> int: 
        """
        Returns the mode for selection of object as a whole; 0 by default.
        """
    def HasColor(self) -> bool: 
        """
        Returns true if the Interactive Object has color.
        """
    def HasDisplayMode(self) -> bool: 
        """
        Returns true if the Interactive Object has display mode setting overriding global setting (within Interactive Context).
        """
    def HasFlipping(self) -> bool: 
        """
        None
        """
    def HasHilightMode(self) -> bool: 
        """
        Returns true if the Interactive Object is in highlight mode.
        """
    def HasInteractiveContext(self) -> bool: 
        """
        Indicates whether the Interactive Object has a pointer to an interactive context.
        """
    def HasMaterial(self) -> bool: 
        """
        Returns true if the Interactive Object has a setting for material.
        """
    def HasOrientation3D(self) -> bool: 
        """
        Returns true if the current text placement mode uses text orientation in the model 3D space.
        """
    def HasOwnAnchorPoint(self) -> bool: 
        """
        Returns flag if text uses position as point of attach
        """
    def HasOwnPresentations(self) -> bool: 
        """
        Returns true if object should have own presentations.
        """
    def HasOwner(self) -> bool: 
        """
        Returns true if the object has an owner attributed to it. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient.
        """
    def HasPolygonOffsets(self) -> bool: 
        """
        Returns Standard_True if <myDrawer> has non-null shading aspect
        """
    def HasPresentation(self) -> bool: 
        """
        Returns TRUE when this object has a presentation in the current DisplayMode()
        """
    def HasSelection(self,theMode : int) -> bool: 
        """
        Returns true if a selection corresponding to the selection mode theMode was computed for this object.
        """
    def HasTransformation(self) -> bool: 
        """
        Returns true if object has a transformation that is different from the identity.
        """
    def HasWidth(self) -> bool: 
        """
        Returns true if the Interactive Object has width.
        """
    def HilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalSelected and Prs3d_TypeOfHighlight_Selected defined within AIS_InteractiveContext::HighlightStyle().
        """
    def HilightMode(self) -> int: 
        """
        Returns highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def HilightOwnerWithColor(self,thePM : OCP.PrsMgr.PrsMgr_PresentationManager,theStyle : OCP.Prs3d.Prs3d_Drawer,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner) -> None: 
        """
        Method which hilight an owner belonging to this selectable object ( for fast presentation draw )
        """
    def HilightSelected(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager,theSeq : OCP.SelectMgr.SelectMgr_SequenceOfOwner) -> None: 
        """
        Method which draws selected owners ( for fast presentation draw )
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def InteractiveContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def InversedTransformation(self) -> OCP.gp.gp_GTrsf: 
        """
        Return inversed transformation.
        """
    def IsAutoHilight(self) -> bool: 
        """
        If returns True, the old mechanism for highlighting selected objects is used (HilightSelected Method may be empty). If returns False, the HilightSelected method will be fully responsible for highlighting selected entity owners belonging to this selectable object.
        """
    def IsInfinite(self) -> bool: 
        """
        Returns true if the interactive object is infinite; FALSE by default. This flag affects various operations operating on bounding box of graphic presentations of this object. For instance, infinite objects are not taken in account for View FitAll. This does not necessarily means that object is actually infinite, auxiliary objects might be also marked with this flag to achieve desired behavior.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def IsMutable(self) -> bool: 
        """
        Returns true if object has mutable nature (content or location are be changed regularly). Mutable object will be managed in different way than static onces (another optimizations).
        """
    def IsTransparent(self) -> bool: 
        """
        Returns true if there is a transparency setting.
        """
    def LocalTransformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def LocalTransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def Material(self) -> OCP.Graphic3d.Graphic3d_NameOfMaterial: 
        """
        Returns the current material setting as enumeration value.
        """
    def Orientation3D(self) -> OCP.gp.gp_Ax2: 
        """
        Returns label orientation in the model 3D space.
        """
    def Parent(self) -> OCP.PrsMgr.PrsMgr_PresentableObject: 
        """
        Returns parent of current object in scene hierarchy.
        """
    def PolygonOffsets(self,aFactor : float,aUnits : float) -> tuple[int]: 
        """
        Retrieves current polygon offsets settings from <myDrawer>.
        """
    def Position(self) -> OCP.gp.gp_Pnt: 
        """
        Returns position.
        """
    def Presentation(self) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Returns the current presentation of this object according to the current DisplayMode()
        """
    def Presentations(self) -> OCP.PrsMgr.PrsMgr_Presentations: 
        """
        Return presentations.
        """
    def ProcessDragging(self,theCtx : AIS_InteractiveContext,theView : OCP.V3d.V3d_View,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theDragFrom : OCP.Graphic3d.Graphic3d_Vec2i,theDragTo : OCP.Graphic3d.Graphic3d_Vec2i,theAction : AIS_DragAction) -> bool: 
        """
        Drag object in the viewer.
        """
    @overload
    def RecomputePrimitives(self) -> None: 
        """
        Re-computes the sensitive primitives for all modes. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.

        Re-computes the sensitive primitives which correspond to the <theMode>th selection mode. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.
        """
    @overload
    def RecomputePrimitives(self,theMode : int) -> None: ...
    def Redisplay(self,AllModes : bool=False) -> None: 
        """
        Updates the active presentation; if <AllModes> = Standard_True all the presentations inside are recomputed. IMPORTANT: It is preferable to call Redisplay method of corresponding AIS_InteractiveContext instance for cases when it is accessible. This method just redirects call to myCTXPtr, so this class field must be up to date for proper result.
        """
    def RemoveChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy.
        """
    def RemoveChildWithRestoreTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy with keeping the current global transformation. So the object keeps the same position/orientation in the global CS.
        """
    def RemoveClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Removes previously added clip plane.
        """
    def ResetTransformation(self) -> None: 
        """
        None
        """
    def Selection(self,theMode : int) -> OCP.SelectMgr.SelectMgr_Selection: 
        """
        Returns the selection having specified selection mode or NULL.
        """
    def Selections(self) -> OCP.SelectMgr.SelectMgr_SequenceOfSelection: 
        """
        Return the sequence of selections.
        """
    def SetAngle(self,theAngle : float) -> None: 
        """
        Setup angle.
        """
    def SetAspect(self,anAspect : OCP.Prs3d.Prs3d_BasicAspect) -> None: 
        """
        Sets the graphic basic aspect to the current presentation.
        """
    def SetAssemblyOwner(self,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theMode : int=-1) -> None: 
        """
        Sets common entity owner for assembly sensitive object entities
        """
    def SetAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the drawing tool theDrawer.
        """
    def SetAutoHilight(self,theAutoHilight : bool) -> None: 
        """
        Set AutoHilight property to true or false.
        """
    def SetClipPlanes(self,thePlanes : OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane) -> None: 
        """
        Set clip planes for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def SetColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Setup color of entire text.
        """
    def SetColorSubTitle(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Modifies the colour of the subtitle for the TODT_SUBTITLE TextDisplayType and the colour of backgroubd for the TODT_DEKALE TextDisplayType.
        """
    def SetContext(self,aCtx : AIS_InteractiveContext) -> None: 
        """
        Sets the interactive context aCtx and provides a link to the default drawing tool or "Drawer" if there is none.
        """
    def SetCurrentFacingModel(self,theModel : OCP.Aspect.Aspect_TypeOfFacingModel=Aspect_TypeOfFacingModel.Aspect_TOFM_BOTH_SIDE) -> None: 
        """
        change the current facing model apply on polygons for SetColor(), SetTransparency(), SetMaterial() methods default facing model is Aspect_TOFM_TWO_SIDE. This mean that attributes is applying both on the front and back face.
        """
    def SetDisplayMode(self,theMode : int) -> None: 
        """
        Sets the display mode for the interactive object. An object can have its own temporary display mode, which is different from that proposed by the interactive context.
        """
    def SetDisplayType(self,theDisplayType : OCP.Aspect.Aspect_TypeOfDisplayText) -> None: 
        """
        Define the display type of the text.
        """
    def SetDynamicHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the dynamic hilight drawing tool.
        """
    def SetFlipping(self,theIsFlipping : bool) -> None: 
        """
        None
        """
    def SetFont(self,theFont : str) -> None: 
        """
        Setup font.
        """
    def SetFontAspect(self,theFontAspect : OCP.Font.Font_FontAspect) -> None: 
        """
        Setup font aspect.
        """
    def SetHJustification(self,theHJust : OCP.Graphic3d.Graphic3d_HorizontalTextAlignment) -> None: 
        """
        Setup horizontal justification.
        """
    def SetHeight(self,theHeight : float) -> None: 
        """
        Setup height.
        """
    def SetHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the hilight drawing tool theDrawer.
        """
    def SetHilightMode(self,theMode : int) -> None: 
        """
        Sets highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def SetInfiniteState(self,theFlag : bool=True) -> None: 
        """
        Sets if object should be considered as infinite.
        """
    def SetIsoOnTriangulation(self,theIsEnabled : bool) -> None: 
        """
        Enables or disables on-triangulation build of isolines according to the flag given.
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.gp.gp_Trsf) -> None: 
        """
        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.

        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.TopLoc.TopLoc_Datum3D) -> None: ...
    def SetMaterial(self,arg1 : OCP.Graphic3d.Graphic3d_MaterialAspect) -> None: 
        """
        Material has no effect for text label.
        """
    def SetMutable(self,theIsMutable : bool) -> None: 
        """
        Sets if the object has mutable nature (content or location will be changed regularly). This method should be called before object displaying to take effect.
        """
    def SetOrientation3D(self,theOrientation : OCP.gp.gp_Ax2) -> None: 
        """
        Setup label orientation in the model 3D space.
        """
    def SetOwnAnchorPoint(self,theOwnAnchorPoint : bool) -> None: 
        """
        Set flag if text uses position as point of attach
        """
    def SetOwner(self,theApplicativeEntity : OCP.Standard.Standard_Transient) -> None: 
        """
        Allows you to attribute the owner theApplicativeEntity to an Interactive Object. This can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of. The owner takes the form of a transient.
        """
    def SetPolygonOffsets(self,aMode : int,aFactor : float=1.0,aUnits : float=0.0) -> None: 
        """
        Sets up polygon offsets for this object.
        """
    def SetPosition(self,thePosition : OCP.gp.gp_Pnt) -> None: 
        """
        Setup position.
        """
    def SetPropagateVisualState(self,theFlag : bool) -> None: 
        """
        Change the value of the flag "propagate visual state"
        """
    def SetText(self,theText : OCP.TCollection.TCollection_ExtendedString) -> None: 
        """
        Setup text.
        """
    def SetTextFormatter(self,theFormatter : OCP.Font.Font_TextFormatter) -> None: 
        """
        Setup text formatter for presentation. It's empty by default.
        """
    @overload
    def SetToUpdate(self) -> None: 
        """
        Flags presentation to be updated; UpdatePresentations() will recompute these presentations.

        flags all the Presentations to be Updated.
        """
    @overload
    def SetToUpdate(self,theMode : int) -> None: ...
    def SetTransformPersistence(self,theTrsfPers : OCP.Graphic3d.Graphic3d_TransformPers) -> None: 
        """
        Sets up Transform Persistence defining a special Local Coordinate system where this object should be located. Note that management of Transform Persistence object is more expensive than of the normal one, because it requires its position being recomputed basing on camera position within each draw call / traverse.
        """
    def SetTransparency(self,theValue : float) -> None: 
        """
        Setup transparency within [0, 1] range.
        """
    def SetTypeOfPresentation(self,theType : OCP.PrsMgr.PrsMgr_TypeOfPresentation3d) -> None: 
        """
        Set type of presentation.
        """
    def SetVJustification(self,theVJust : OCP.Graphic3d.Graphic3d_VerticalTextAlignment) -> None: 
        """
        Setup vertical justification.
        """
    def SetWidth(self,theWidth : float) -> None: 
        """
        Allows you to provide the setting aValue for width. Only the Interactive Object knows which Drawer attribute is affected by the width setting.
        """
    def SetZLayer(self,theLayerId : int) -> None: 
        """
        Set Z layer ID and update all presentations of the selectable object. The layers mechanism allows drawing objects in higher layers in overlay of objects in lower layers.
        """
    def SetZoomable(self,theIsZoomable : bool) -> None: 
        """
        Setup zoomable property.
        """
    def Signature(self) -> int: 
        """
        Specifies additional characteristics of Interactive Object of Type(); -1 by default. Among the datums, this signature is attributed to the shape. The remaining datums have the following default signatures: - Point signature 1 - Axis signature 2 - Trihedron signature 3 - PlaneTrihedron signature 4 - Line signature 5 - Circle signature 6 - Plane signature 7.
        """
    def SynchronizeAspects(self) -> None: 
        """
        Synchronize presentation aspects after their modification.
        """
    def Text(self) -> OCP.TCollection.TCollection_ExtendedString: 
        """
        Returns the label text.
        """
    def TextFormatter(self) -> OCP.Font.Font_TextFormatter: 
        """
        Returns text presentation formatter; NULL by default, which means standard text formatter will be used.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    @overload
    def ToBeUpdated(self,ListOfMode : OCP.TColStd.TColStd_ListOfInteger) -> None: 
        """
        Returns TRUE if any active presentation has invalidation flag.

        gives the list of modes which are flagged "to be updated".
        """
    @overload
    def ToBeUpdated(self,theToIncludeHidden : bool=False) -> bool: ...
    def ToPropagateVisualState(self) -> bool: 
        """
        Get value of the flag "propagate visual state" It means that the display/erase/color visual state is propagated automatically to all children; by default, the flag is true
        """
    def TransformPersistence(self) -> OCP.Graphic3d.Graphic3d_TransformPers: 
        """
        Returns Transformation Persistence defining a special Local Coordinate system where this presentable object is located or NULL handle if not defined. Position of the object having Transformation Persistence is mutable and depends on camera position. The same applies to a bounding box of the object.
        """
    def Transformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def TransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def Transparency(self) -> float: 
        """
        Returns the transparency setting. This will be between 0.0 and 1.0. At 0.0 an object will be totally opaque, and at 1.0, fully transparent.
        """
    def Type(self) -> AIS_KindOfInteractive: 
        """
        Returns the kind of Interactive Object; AIS_KindOfInteractive_None by default.
        """
    def TypeOfPresentation3d(self) -> OCP.PrsMgr.PrsMgr_TypeOfPresentation3d: 
        """
        Returns information on whether the object accepts display in HLR mode or not.
        """
    def UnsetAttributes(self) -> None: 
        """
        Clears settings provided by the drawing tool aDrawer.
        """
    def UnsetColor(self) -> None: 
        """
        Removes color settings. Only the Interactive Object knows which Drawer attribute is affected by the color setting. For a wire, for example, wire aspect is the attribute affected. For a vertex, however, only point aspect is affected by the color setting.
        """
    def UnsetDisplayMode(self) -> None: 
        """
        Removes display mode settings from the interactive object.
        """
    def UnsetHilightAttributes(self) -> None: 
        """
        Clears settings provided by the hilight drawing tool theDrawer.
        """
    def UnsetHilightMode(self) -> None: 
        """
        Unsets highlight display mode.
        """
    def UnsetMaterial(self) -> None: 
        """
        Removes the setting for material.
        """
    def UnsetOrientation3D(self) -> None: 
        """
        Reset label orientation in the model 3D space.
        """
    def UnsetTransparency(self) -> None: 
        """
        Removes the transparency setting.
        """
    def UnsetWidth(self) -> None: 
        """
        Reset width to default value.
        """
    def UpdateSelection(self,theMode : int=-1) -> None: 
        """
        Sets update status FULL to selections of the object. Must be used as the only method of UpdateSelection from outer classes to prevent BVH structures from being outdated.
        """
    def UpdateTransformation(self) -> None: 
        """
        Recomputes the location of the selection aSelection.
        """
    def UpdateTransformations(self,aSelection : OCP.SelectMgr.SelectMgr_Selection) -> None: 
        """
        Updates locations in all sensitive entities from <aSelection> and in corresponding entity owners.
        """
    def ViewAffinity(self) -> OCP.Graphic3d.Graphic3d_ViewAffinity: 
        """
        Return view affinity mask.
        """
    def Width(self) -> float: 
        """
        Returns the width setting of the Interactive Object.
        """
    def ZLayer(self) -> int: 
        """
        Get ID of Z layer for main presentation.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class AIS_TexturedShape(AIS_Shape, AIS_InteractiveObject, OCP.SelectMgr.SelectMgr_SelectableObject, OCP.PrsMgr.PrsMgr_PresentableObject, OCP.Standard.Standard_Transient):
    """
    This class allows to map textures on shapes. Presentations modes AIS_WireFrame (0) and AIS_Shaded (1) behave in the same manner as in AIS_Shape, whilst new modes 2 (bounding box) and 3 (texture mapping) extends it functionality.This class allows to map textures on shapes. Presentations modes AIS_WireFrame (0) and AIS_Shaded (1) behave in the same manner as in AIS_Shape, whilst new modes 2 (bounding box) and 3 (texture mapping) extends it functionality.
    """
    def AcceptDisplayMode(self,theMode : int) -> bool: 
        """
        Return true if specified display mode is supported (extends AIS_Shape with Display Mode 3).
        """
    def AcceptShapeDecomposition(self) -> bool: 
        """
        Returns true if the Interactive Object accepts shape decomposition.
        """
    def AddChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy.
        """
    def AddChildWithCurrentTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy with keeping the current global transformation So the object keeps the same position/orientation in the global CS.
        """
    def AddClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Adds clip plane for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def AddSelection(self,aSelection : OCP.SelectMgr.SelectMgr_Selection,aMode : int) -> None: 
        """
        Adds the selection aSelection with the selection mode index aMode to this framework.
        """
    def Attributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the attributes settings.
        """
    def BndBoxOfSelected(self,theOwners : Any) -> OCP.Bnd.Bnd_Box: 
        """
        Returns a bounding box of sensitive entities with the owners given if they are a part of activated selection
        """
    def BoundingBox(self) -> OCP.Bnd.Bnd_Box: 
        """
        Constructs a bounding box with which to reconstruct compound topological shapes for presentation.
        """
    def Children(self) -> OCP.PrsMgr.PrsMgr_ListOfPresentableObjects: 
        """
        Returns children of the current object.
        """
    def ClearDynamicHighlight(self,theMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> None: 
        """
        Method that needs to be implemented when the object manages selection and dynamic highlighting on its own. Clears or invalidates dynamic highlight presentation. By default it clears immediate draw of given presentation manager.
        """
    def ClearOwner(self) -> None: 
        """
        Each Interactive Object has methods which allow us to attribute an Owner to it in the form of a Transient. This method removes the owner from the graphic entity.
        """
    def ClearSelected(self) -> None: 
        """
        Method which clear all selected owners belonging to this selectable object ( for fast presentation draw )
        """
    def ClearSelections(self,update : bool=False) -> None: 
        """
        Empties all the selections in the SelectableObject <update> parameter defines whether all object's selections should be flagged for further update or not. This improved method can be used to recompute an object's selection (without redisplaying the object completely) when some selection mode is activated not for the first time.
        """
    def ClipPlanes(self) -> OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane: 
        """
        Get clip planes.
        """
    def Color(self,aColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Returns the Color attributes of the shape accordingly to the current facing model;
        """
    def CombinedParentTransformation(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return combined parent transformation.
        """
    def ComputeSelection(self,theSelection : OCP.SelectMgr.SelectMgr_Selection,theMode : int) -> None: 
        """
        Computes sensitive primitives for the given selection mode - key interface method of Selectable Object.
        """
    def CurrentFacingModel(self) -> OCP.Aspect.Aspect_TypeOfFacingModel: 
        """
        Returns the current facing model which is in effect.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def DefaultDisplayMode(self) -> int: 
        """
        Returns the default display mode.
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DisableTextureModulate(self) -> None: 
        """
        Disables texture modulation
        """
    def DisplayMode(self) -> int: 
        """
        Returns the display mode setting of the Interactive Object. The range of supported display mode indexes should be specified within object definition and filtered by AccepDisplayMode().
        """
    def DisplayStatus(self) -> OCP.PrsMgr.PrsMgr_DisplayStatus: 
        """
        Return presentation display status; PrsMgr_DisplayStatus_None by default.
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicHilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalDynamic and Prs3d_TypeOfHighlight_Dynamic defined within AIS_InteractiveContext::HighlightStyle().
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def EnableTextureModulate(self) -> None: 
        """
        Enables texture modulation
        """
    def ErasePresentations(self,theToRemove : bool) -> None: 
        """
        Removes presentations returned by GetHilightPresentation() and GetSelectPresentation().
        """
    def GetAssemblyOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns common entity owner if the object is an assembly
        """
    def GetContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def GetHilightPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting detected object.
        """
    def GetOwner(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns the owner of the Interactive Object. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient. There are two types of owners: - Direct owners, decomposition shapes such as edges, wires, and faces. - Users, presentable objects connecting to sensitive primitives, or a shape which has been decomposed.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def GetSelectPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting selected object.
        """
    def GlobalSelOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns the owner of mode for selection of object as a whole
        """
    def GlobalSelectionMode(self) -> int: 
        """
        Returns the mode for selection of object as a whole; 0 by default.
        """
    def HasColor(self) -> bool: 
        """
        Returns true if the Interactive Object has color.
        """
    def HasDisplayMode(self) -> bool: 
        """
        Returns true if the Interactive Object has display mode setting overriding global setting (within Interactive Context).
        """
    def HasHilightMode(self) -> bool: 
        """
        Returns true if the Interactive Object is in highlight mode.
        """
    def HasInteractiveContext(self) -> bool: 
        """
        Indicates whether the Interactive Object has a pointer to an interactive context.
        """
    def HasMaterial(self) -> bool: 
        """
        Returns true if the Interactive Object has a setting for material.
        """
    def HasOwnPresentations(self) -> bool: 
        """
        Returns true if object should have own presentations.
        """
    def HasOwner(self) -> bool: 
        """
        Returns true if the object has an owner attributed to it. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient.
        """
    def HasPolygonOffsets(self) -> bool: 
        """
        Returns Standard_True if <myDrawer> has non-null shading aspect
        """
    def HasPresentation(self) -> bool: 
        """
        Returns TRUE when this object has a presentation in the current DisplayMode()
        """
    def HasSelection(self,theMode : int) -> bool: 
        """
        Returns true if a selection corresponding to the selection mode theMode was computed for this object.
        """
    def HasTransformation(self) -> bool: 
        """
        Returns true if object has a transformation that is different from the identity.
        """
    def HasWidth(self) -> bool: 
        """
        Returns true if the Interactive Object has width.
        """
    def HilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalSelected and Prs3d_TypeOfHighlight_Selected defined within AIS_InteractiveContext::HighlightStyle().
        """
    def HilightMode(self) -> int: 
        """
        Returns highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def HilightOwnerWithColor(self,thePM : OCP.PrsMgr.PrsMgr_PresentationManager,theStyle : OCP.Prs3d.Prs3d_Drawer,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner) -> None: 
        """
        Method which hilight an owner belonging to this selectable object ( for fast presentation draw )
        """
    def HilightSelected(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager,theSeq : OCP.SelectMgr.SelectMgr_SequenceOfOwner) -> None: 
        """
        Method which draws selected owners ( for fast presentation draw )
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def InteractiveContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def InversedTransformation(self) -> OCP.gp.gp_GTrsf: 
        """
        Return inversed transformation.
        """
    def IsAutoHilight(self) -> bool: 
        """
        If returns True, the old mechanism for highlighting selected objects is used (HilightSelected Method may be empty). If returns False, the HilightSelected method will be fully responsible for highlighting selected entity owners belonging to this selectable object.
        """
    def IsInfinite(self) -> bool: 
        """
        Returns true if the interactive object is infinite; FALSE by default. This flag affects various operations operating on bounding box of graphic presentations of this object. For instance, infinite objects are not taken in account for View FitAll. This does not necessarily means that object is actually infinite, auxiliary objects might be also marked with this flag to achieve desired behavior.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def IsMutable(self) -> bool: 
        """
        Returns true if object has mutable nature (content or location are be changed regularly). Mutable object will be managed in different way than static onces (another optimizations).
        """
    def IsTransparent(self) -> bool: 
        """
        Returns true if there is a transparency setting.
        """
    def LocalTransformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def LocalTransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def Material(self) -> OCP.Graphic3d.Graphic3d_NameOfMaterial: 
        """
        Returns the NameOfMaterial attributes of the shape accordingly to the current facing model;
        """
    def OwnDeviationAngle(self,anAngle : float,aPreviousAngle : float) -> bool: 
        """
        Returns true and the values of the deviation angle anAngle and the previous deviation angle aPreviousAngle. If these values are not already set, false is returned.
        """
    def OwnDeviationCoefficient(self,aCoefficient : float,aPreviousCoefficient : float) -> bool: 
        """
        Returns true and the values of the deviation coefficient aCoefficient and the previous deviation coefficient aPreviousCoefficient. If these values are not already set, false is returned.
        """
    def Parent(self) -> OCP.PrsMgr.PrsMgr_PresentableObject: 
        """
        Returns parent of current object in scene hierarchy.
        """
    def PolygonOffsets(self,aFactor : float,aUnits : float) -> tuple[int]: 
        """
        Retrieves current polygon offsets settings from <myDrawer>.
        """
    def Presentation(self) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Returns the current presentation of this object according to the current DisplayMode()
        """
    def Presentations(self) -> OCP.PrsMgr.PrsMgr_Presentations: 
        """
        Return presentations.
        """
    def ProcessDragging(self,theCtx : AIS_InteractiveContext,theView : OCP.V3d.V3d_View,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theDragFrom : OCP.Graphic3d.Graphic3d_Vec2i,theDragTo : OCP.Graphic3d.Graphic3d_Vec2i,theAction : AIS_DragAction) -> bool: 
        """
        Drag object in the viewer.
        """
    @overload
    def RecomputePrimitives(self) -> None: 
        """
        Re-computes the sensitive primitives for all modes. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.

        Re-computes the sensitive primitives which correspond to the <theMode>th selection mode. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.
        """
    @overload
    def RecomputePrimitives(self,theMode : int) -> None: ...
    def Redisplay(self,AllModes : bool=False) -> None: 
        """
        Updates the active presentation; if <AllModes> = Standard_True all the presentations inside are recomputed. IMPORTANT: It is preferable to call Redisplay method of corresponding AIS_InteractiveContext instance for cases when it is accessible. This method just redirects call to myCTXPtr, so this class field must be up to date for proper result.
        """
    def RemoveChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy.
        """
    def RemoveChildWithRestoreTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy with keeping the current global transformation. So the object keeps the same position/orientation in the global CS.
        """
    def RemoveClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Removes previously added clip plane.
        """
    def ResetTransformation(self) -> None: 
        """
        None
        """
    def Selection(self,theMode : int) -> OCP.SelectMgr.SelectMgr_Selection: 
        """
        Returns the selection having specified selection mode or NULL.
        """
    @staticmethod
    def SelectionMode_s(theShapeType : OCP.TopAbs.TopAbs_ShapeEnum) -> int: 
        """
        Return selection mode for specified shape type.
        """
    @staticmethod
    def SelectionType_s(theSelMode : int) -> OCP.TopAbs.TopAbs_ShapeEnum: 
        """
        Return shape type for specified selection mode.
        """
    def Selections(self) -> OCP.SelectMgr.SelectMgr_SequenceOfSelection: 
        """
        Return the sequence of selections.
        """
    def Set(self,theShape : OCP.TopoDS.TopoDS_Shape) -> None: 
        """
        Alias for ::SetShape().
        """
    def SetAngleAndDeviation(self,anAngle : float) -> None: 
        """
        this compute a new angle and Deviation from the value anAngle and set the values stored in myDrawer with these that become local to the shape
        """
    def SetAspect(self,anAspect : OCP.Prs3d.Prs3d_BasicAspect) -> None: 
        """
        Sets the graphic basic aspect to the current presentation.
        """
    def SetAssemblyOwner(self,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theMode : int=-1) -> None: 
        """
        Sets common entity owner for assembly sensitive object entities
        """
    def SetAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the drawing tool theDrawer.
        """
    def SetAutoHilight(self,theAutoHilight : bool) -> None: 
        """
        Set AutoHilight property to true or false.
        """
    def SetClipPlanes(self,thePlanes : OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane) -> None: 
        """
        Set clip planes for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def SetColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Sets the color.
        """
    def SetContext(self,aCtx : AIS_InteractiveContext) -> None: 
        """
        Sets the interactive context aCtx and provides a link to the default drawing tool or "Drawer" if there is none.
        """
    def SetCurrentFacingModel(self,theModel : OCP.Aspect.Aspect_TypeOfFacingModel=Aspect_TypeOfFacingModel.Aspect_TOFM_BOTH_SIDE) -> None: 
        """
        change the current facing model apply on polygons for SetColor(), SetTransparency(), SetMaterial() methods default facing model is Aspect_TOFM_TWO_SIDE. This mean that attributes is applying both on the front and back face.
        """
    def SetDisplayMode(self,theMode : int) -> None: 
        """
        Sets the display mode for the interactive object. An object can have its own temporary display mode, which is different from that proposed by the interactive context.
        """
    def SetDynamicHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the dynamic hilight drawing tool.
        """
    def SetHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the hilight drawing tool theDrawer.
        """
    def SetHilightMode(self,theMode : int) -> None: 
        """
        Sets highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def SetInfiniteState(self,theFlag : bool=True) -> None: 
        """
        Sets if object should be considered as infinite.
        """
    def SetIsoOnTriangulation(self,theIsEnabled : bool) -> None: 
        """
        Enables or disables on-triangulation build of isolines according to the flag given.
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.gp.gp_Trsf) -> None: 
        """
        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.

        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.TopLoc.TopLoc_Datum3D) -> None: ...
    def SetMaterial(self,theAspect : OCP.Graphic3d.Graphic3d_MaterialAspect) -> None: 
        """
        Sets the material aspect.
        """
    def SetMutable(self,theIsMutable : bool) -> None: 
        """
        Sets if the object has mutable nature (content or location will be changed regularly). This method should be called before object displaying to take effect.
        """
    @overload
    def SetOwnDeviationAngle(self,anAngle : float) -> None: 
        """
        Sets a local value for deviation angle for this specific shape.

        sets myOwnDeviationAngle field in Prs3d_Drawer & recomputes presentation
        """
    @overload
    def SetOwnDeviationAngle(self) -> bool: ...
    @overload
    def SetOwnDeviationCoefficient(self,aCoefficient : float) -> None: 
        """
        Sets a local value for deviation coefficient for this specific shape.

        Sets a local value for deviation coefficient for this specific shape.
        """
    @overload
    def SetOwnDeviationCoefficient(self) -> bool: ...
    def SetOwner(self,theApplicativeEntity : OCP.Standard.Standard_Transient) -> None: 
        """
        Allows you to attribute the owner theApplicativeEntity to an Interactive Object. This can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of. The owner takes the form of a transient.
        """
    def SetPolygonOffsets(self,aMode : int,aFactor : float=1.0,aUnits : float=0.0) -> None: 
        """
        Sets up polygon offsets for this object.
        """
    def SetPropagateVisualState(self,theFlag : bool) -> None: 
        """
        Change the value of the flag "propagate visual state"
        """
    def SetShape(self,theShape : OCP.TopoDS.TopoDS_Shape) -> None: 
        """
        Constructs an instance of the shape object theShape.
        """
    def SetTextureFileName(self,theTextureFileName : OCP.TCollection.TCollection_AsciiString) -> None: 
        """
        Sets the texture source. <theTextureFileName> can specify path to texture image or one of the standard predefined textures. The accepted file types are those used in Image_AlienPixMap with extensions such as rgb, png, jpg and more. To specify the standard predefined texture, the <theTextureFileName> should contain integer - the Graphic3d_NameOfTexture2D enumeration index. Setting texture source using this method resets the source pixmap (if was set previously).
        """
    def SetTextureMapOff(self) -> None: 
        """
        Disables texture mapping
        """
    def SetTextureMapOn(self) -> None: 
        """
        Enables texture mapping
        """
    def SetTextureOrigin(self,theToSetTextureOrigin : bool,theUOrigin : float=0.0,theVOrigin : float=0.0) -> None: 
        """
        Use this method to change the origin of the texture. The texel (0,0) will be mapped to the surface (UOrigin,VOrigin)
        """
    def SetTextureOriginUV(self,theOriginUV : OCP.gp.gp_Pnt2d) -> None: 
        """
        Use this method to change the origin of the texture. The texel (0,0) will be mapped to the surface (myUVOrigin.X(), myUVOrigin.Y()).
        """
    def SetTexturePixMap(self,theTexturePixMap : OCP.Image.Image_PixMap) -> None: 
        """
        Sets the texture source. <theTexturePixMap> specifies image data. Please note that the data should be in Bottom-Up order, the flag of Image_PixMap::IsTopDown() will be ignored by graphic driver. Setting texture source using this method resets the source by filename (if was set previously).
        """
    def SetTextureRepeat(self,theToRepeat : bool,theURepeat : float=1.0,theVRepeat : float=1.0) -> None: 
        """
        Sets the number of occurrences of the texture on each face. The texture itself is parameterized in (0,1) by (0,1). Each face of the shape to be textured is parameterized in UV space (Umin,Umax) by (Vmin,Vmax). If RepeatYN is set to false, texture coordinates are clamped in the range (0,1)x(0,1) of the face.
        """
    def SetTextureRepeatUV(self,theRepeatUV : OCP.gp.gp_Pnt2d) -> None: 
        """
        Sets the number of occurrences of the texture on each face. The texture itself is parameterized in (0,1) by (0,1). Each face of the shape to be textured is parameterized in UV space (Umin,Umax) by (Vmin,Vmax).
        """
    def SetTextureScale(self,theToSetTextureScale : bool,theScaleU : float=1.0,theScaleV : float=1.0) -> None: 
        """
        Use this method to scale the texture (percent of the face). You can specify a scale factor for both U and V. Example: if you set ScaleU and ScaleV to 0.5 and you enable texture repeat, the texture will appear twice on the face in each direction.
        """
    def SetTextureScaleUV(self,theScaleUV : OCP.gp.gp_Pnt2d) -> None: 
        """
        Use this method to scale the texture (percent of the face). You can specify a scale factor for both U and V. Example: if you set ScaleU and ScaleV to 0.5 and you enable texture repeat, the texture will appear twice on the face in each direction.
        """
    @overload
    def SetToUpdate(self) -> None: 
        """
        Flags presentation to be updated; UpdatePresentations() will recompute these presentations.

        flags all the Presentations to be Updated.
        """
    @overload
    def SetToUpdate(self,theMode : int) -> None: ...
    def SetTransformPersistence(self,theTrsfPers : OCP.Graphic3d.Graphic3d_TransformPers) -> None: 
        """
        Sets up Transform Persistence defining a special Local Coordinate system where this object should be located. Note that management of Transform Persistence object is more expensive than of the normal one, because it requires its position being recomputed basing on camera position within each draw call / traverse.
        """
    def SetTransparency(self,aValue : float=0.6) -> None: 
        """
        Sets the value aValue for transparency in the reconstructed compound shape.
        """
    def SetTypeOfHLR(self,theTypeOfHLR : OCP.Prs3d.Prs3d_TypeOfHLR) -> None: 
        """
        Sets the type of HLR algorithm used by the shape
        """
    def SetTypeOfPresentation(self,theType : OCP.PrsMgr.PrsMgr_TypeOfPresentation3d) -> None: 
        """
        Set type of presentation.
        """
    def SetWidth(self,aValue : float) -> None: 
        """
        Sets the value aValue for line width in the reconstructed compound shape. Changes line aspects for lines presentation.
        """
    def SetZLayer(self,theLayerId : int) -> None: 
        """
        Set Z layer ID and update all presentations of the selectable object. The layers mechanism allows drawing objects in higher layers in overlay of objects in lower layers.
        """
    def Shape(self) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Returns this shape object.
        """
    @overload
    def ShowTriangles(self,theToShowTriangles : bool) -> None: 
        """
        Returns true if displaying of triangles is requested

        Use this method to show the triangulation of the shape (for debugging etc.).
        """
    @overload
    def ShowTriangles(self) -> bool: ...
    def Signature(self) -> int: 
        """
        Returns index 0. This value refers to SHAPE from TopAbs_ShapeEnum
        """
    def SynchronizeAspects(self) -> None: 
        """
        Synchronize presentation aspects after their modification.
        """
    def TextureFile(self) -> str: 
        """
        Returns path to the texture file
        """
    def TextureMapState(self) -> bool: 
        """
        Returns flag to control texture mapping (for presentation mode 3)
        """
    def TextureModulate(self) -> bool: 
        """
        Returns true if texture color modulation is turned on
        """
    def TextureOrigin(self) -> bool: 
        """
        Returns true if texture UV origin has been modified
        """
    def TextureOriginUV(self) -> OCP.gp.gp_Pnt2d: 
        """
        Return texture origin UV position; (0, 0) by default.
        """
    def TexturePixMap(self) -> OCP.Image.Image_PixMap: 
        """
        Returns the source pixmap for texture map
        """
    def TextureRepeat(self) -> bool: 
        """
        Returns texture repeat flag
        """
    def TextureRepeatUV(self) -> OCP.gp.gp_Pnt2d: 
        """
        Return texture repeat UV values; (1, 1) by default.
        """
    def TextureScale(self) -> bool: 
        """
        Returns true if scale factor should be applied to texture mapping
        """
    def TextureScaleU(self) -> float: 
        """
        Returns scale factor for U coordinate (1.0 by default)
        """
    def TextureScaleUV(self) -> OCP.gp.gp_Pnt2d: 
        """
        Return scale factor for UV coordinates; (1, 1) by default.
        """
    def TextureScaleV(self) -> float: 
        """
        Returns scale factor for V coordinate (1.0 by default)
        """
    def TextureUOrigin(self) -> float: 
        """
        Returns texture origin U position (0.0 by default)
        """
    def TextureVOrigin(self) -> float: 
        """
        Returns texture origin V position (0.0 by default)
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    @overload
    def ToBeUpdated(self,ListOfMode : OCP.TColStd.TColStd_ListOfInteger) -> None: 
        """
        Returns TRUE if any active presentation has invalidation flag.

        gives the list of modes which are flagged "to be updated".
        """
    @overload
    def ToBeUpdated(self,theToIncludeHidden : bool=False) -> bool: ...
    def ToPropagateVisualState(self) -> bool: 
        """
        Get value of the flag "propagate visual state" It means that the display/erase/color visual state is propagated automatically to all children; by default, the flag is true
        """
    def TransformPersistence(self) -> OCP.Graphic3d.Graphic3d_TransformPers: 
        """
        Returns Transformation Persistence defining a special Local Coordinate system where this presentable object is located or NULL handle if not defined. Position of the object having Transformation Persistence is mutable and depends on camera position. The same applies to a bounding box of the object.
        """
    def Transformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def TransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def Transparency(self) -> float: 
        """
        Returns the transparency attributes of the shape accordingly to the current facing model;
        """
    def Type(self) -> AIS_KindOfInteractive: 
        """
        Returns Object as the type of Interactive Object.
        """
    def TypeOfHLR(self) -> OCP.Prs3d.Prs3d_TypeOfHLR: 
        """
        Gets the type of HLR algorithm
        """
    def TypeOfPresentation3d(self) -> OCP.PrsMgr.PrsMgr_TypeOfPresentation3d: 
        """
        Returns information on whether the object accepts display in HLR mode or not.
        """
    def URepeat(self) -> float: 
        """
        Returns texture repeat U value
        """
    def UnsetAttributes(self) -> None: 
        """
        Clears settings provided by the drawing tool aDrawer.
        """
    def UnsetColor(self) -> None: 
        """
        Removes settings for the color.
        """
    def UnsetDisplayMode(self) -> None: 
        """
        Removes display mode settings from the interactive object.
        """
    def UnsetHilightAttributes(self) -> None: 
        """
        Clears settings provided by the hilight drawing tool theDrawer.
        """
    def UnsetHilightMode(self) -> None: 
        """
        Unsets highlight display mode.
        """
    def UnsetMaterial(self) -> None: 
        """
        Removes settings for material aspect.
        """
    def UnsetTransparency(self) -> None: 
        """
        Removes the setting for transparency in the reconstructed compound shape.
        """
    def UnsetWidth(self) -> None: 
        """
        Removes the setting for line width in the reconstructed compound shape.
        """
    def UpdateAttributes(self) -> None: 
        """
        Use this method to display the textured shape without recomputing the whole presentation. Use this method when ONLY the texture content has been changed. If other parameters (ie: scale factors, texture origin, texture repeat...) have changed, the whole presentation has to be recomputed:
        """
    def UpdateSelection(self,theMode : int=-1) -> None: 
        """
        Sets update status FULL to selections of the object. Must be used as the only method of UpdateSelection from outer classes to prevent BVH structures from being outdated.
        """
    def UpdateTransformation(self) -> None: 
        """
        Recomputes the location of the selection aSelection.
        """
    def UpdateTransformations(self,aSelection : OCP.SelectMgr.SelectMgr_Selection) -> None: 
        """
        Updates locations in all sensitive entities from <aSelection> and in corresponding entity owners.
        """
    def UserAngle(self) -> float: 
        """
        gives back the angle initial value put by the User.
        """
    def VRepeat(self) -> float: 
        """
        Returns texture repeat V value
        """
    def ViewAffinity(self) -> OCP.Graphic3d.Graphic3d_ViewAffinity: 
        """
        Return view affinity mask.
        """
    def Width(self) -> float: 
        """
        Returns the width setting of the Interactive Object.
        """
    def ZLayer(self) -> int: 
        """
        Get ID of Z layer for main presentation.
        """
    def __init__(self,theShape : OCP.TopoDS.TopoDS_Shape) -> None: ...
    @staticmethod
    def computeHlrPresentation_s(theProjector : OCP.Graphic3d.Graphic3d_Camera,thePrs : OCP.Graphic3d.Graphic3d_Structure,theShape : OCP.TopoDS.TopoDS_Shape,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Compute HLR presentation for specified shape.
        """
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class AIS_Triangulation(AIS_InteractiveObject, OCP.SelectMgr.SelectMgr_SelectableObject, OCP.PrsMgr.PrsMgr_PresentableObject, OCP.Standard.Standard_Transient):
    """
    Interactive object that draws data from Poly_Triangulation, optionally with colors associated with each triangulation vertex. For maximum efficiency colors are represented as 32-bit integers instead of classic Quantity_Color values. Interactive selection of triangles and vertices is not yet implemented.Interactive object that draws data from Poly_Triangulation, optionally with colors associated with each triangulation vertex. For maximum efficiency colors are represented as 32-bit integers instead of classic Quantity_Color values. Interactive selection of triangles and vertices is not yet implemented.
    """
    def AcceptDisplayMode(self,theMode : int) -> bool: 
        """
        Returns true if the class of objects accepts specified display mode index. The interactive context can have a default mode of representation for the set of Interactive Objects. This mode may not be accepted by a given class of objects. Consequently, this virtual method allowing us to get information about the class in question must be implemented. At least one display mode index should be accepted by this method. Although subclass can leave default implementation, it is highly desired defining exact list of supported modes instead, which is usually an enumeration for one object or objects class sharing similar list of display modes.
        """
    def AcceptShapeDecomposition(self) -> bool: 
        """
        Informs the graphic context that the interactive Object may be decomposed into sub-shapes for dynamic selection. The most used Interactive Object is AIS_Shape.
        """
    def AddChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy.
        """
    def AddChildWithCurrentTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy with keeping the current global transformation So the object keeps the same position/orientation in the global CS.
        """
    def AddClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Adds clip plane for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def AddSelection(self,aSelection : OCP.SelectMgr.SelectMgr_Selection,aMode : int) -> None: 
        """
        Adds the selection aSelection with the selection mode index aMode to this framework.
        """
    def Attributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the attributes settings.
        """
    def BndBoxOfSelected(self,theOwners : Any) -> OCP.Bnd.Bnd_Box: 
        """
        Returns a bounding box of sensitive entities with the owners given if they are a part of activated selection
        """
    def BoundingBox(self,theBndBox : OCP.Bnd.Bnd_Box) -> None: 
        """
        Returns bounding box of object correspondingly to its current display mode. This method requires presentation to be already computed, since it relies on bounding box of presentation structures, which are supposed to be same/close amongst different display modes of this object.
        """
    def Children(self) -> OCP.PrsMgr.PrsMgr_ListOfPresentableObjects: 
        """
        Returns children of the current object.
        """
    def ClearDynamicHighlight(self,theMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> None: 
        """
        Method that needs to be implemented when the object manages selection and dynamic highlighting on its own. Clears or invalidates dynamic highlight presentation. By default it clears immediate draw of given presentation manager.
        """
    def ClearOwner(self) -> None: 
        """
        Each Interactive Object has methods which allow us to attribute an Owner to it in the form of a Transient. This method removes the owner from the graphic entity.
        """
    def ClearSelected(self) -> None: 
        """
        Method which clear all selected owners belonging to this selectable object ( for fast presentation draw )
        """
    def ClearSelections(self,update : bool=False) -> None: 
        """
        Empties all the selections in the SelectableObject <update> parameter defines whether all object's selections should be flagged for further update or not. This improved method can be used to recompute an object's selection (without redisplaying the object completely) when some selection mode is activated not for the first time.
        """
    def ClipPlanes(self) -> OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane: 
        """
        Get clip planes.
        """
    def Color(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Returns the color setting of the Interactive Object.
        """
    def CombinedParentTransformation(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return combined parent transformation.
        """
    def ComputeSelection(self,theSelection : OCP.SelectMgr.SelectMgr_Selection,theMode : int) -> None: 
        """
        Computes sensitive primitives for the given selection mode - key interface method of Selectable Object.
        """
    def CurrentFacingModel(self) -> OCP.Aspect.Aspect_TypeOfFacingModel: 
        """
        Returns the current facing model which is in effect.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def DefaultDisplayMode(self) -> int: 
        """
        Returns the default display mode.
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DisplayMode(self) -> int: 
        """
        Returns the display mode setting of the Interactive Object. The range of supported display mode indexes should be specified within object definition and filtered by AccepDisplayMode().
        """
    def DisplayStatus(self) -> OCP.PrsMgr.PrsMgr_DisplayStatus: 
        """
        Return presentation display status; PrsMgr_DisplayStatus_None by default.
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicHilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalDynamic and Prs3d_TypeOfHighlight_Dynamic defined within AIS_InteractiveContext::HighlightStyle().
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def ErasePresentations(self,theToRemove : bool) -> None: 
        """
        Removes presentations returned by GetHilightPresentation() and GetSelectPresentation().
        """
    def GetAssemblyOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns common entity owner if the object is an assembly
        """
    def GetColors(self) -> OCP.TColStd.TColStd_HArray1OfInteger: 
        """
        Get the color for each node. Each 32-bit color is Alpha << 24 + Blue << 16 + Green << 8 + Red
        """
    def GetContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def GetHilightPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting detected object.
        """
    def GetOwner(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns the owner of the Interactive Object. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient. There are two types of owners: - Direct owners, decomposition shapes such as edges, wires, and faces. - Users, presentable objects connecting to sensitive primitives, or a shape which has been decomposed.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def GetSelectPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting selected object.
        """
    def GetTriangulation(self) -> OCP.Poly.Poly_Triangulation: 
        """
        Returns Poly_Triangulation .
        """
    def GlobalSelOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns the owner of mode for selection of object as a whole
        """
    def GlobalSelectionMode(self) -> int: 
        """
        Returns the mode for selection of object as a whole; 0 by default.
        """
    def HasColor(self) -> bool: 
        """
        Returns true if the Interactive Object has color.
        """
    def HasDisplayMode(self) -> bool: 
        """
        Returns true if the Interactive Object has display mode setting overriding global setting (within Interactive Context).
        """
    def HasHilightMode(self) -> bool: 
        """
        Returns true if the Interactive Object is in highlight mode.
        """
    def HasInteractiveContext(self) -> bool: 
        """
        Indicates whether the Interactive Object has a pointer to an interactive context.
        """
    def HasMaterial(self) -> bool: 
        """
        Returns true if the Interactive Object has a setting for material.
        """
    def HasOwnPresentations(self) -> bool: 
        """
        Returns true if object should have own presentations.
        """
    def HasOwner(self) -> bool: 
        """
        Returns true if the object has an owner attributed to it. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient.
        """
    def HasPolygonOffsets(self) -> bool: 
        """
        Returns Standard_True if <myDrawer> has non-null shading aspect
        """
    def HasPresentation(self) -> bool: 
        """
        Returns TRUE when this object has a presentation in the current DisplayMode()
        """
    def HasSelection(self,theMode : int) -> bool: 
        """
        Returns true if a selection corresponding to the selection mode theMode was computed for this object.
        """
    def HasTransformation(self) -> bool: 
        """
        Returns true if object has a transformation that is different from the identity.
        """
    def HasVertexColors(self) -> bool: 
        """
        Returns true if triangulation has vertex colors.
        """
    def HasWidth(self) -> bool: 
        """
        Returns true if the Interactive Object has width.
        """
    def HilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalSelected and Prs3d_TypeOfHighlight_Selected defined within AIS_InteractiveContext::HighlightStyle().
        """
    def HilightMode(self) -> int: 
        """
        Returns highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def HilightOwnerWithColor(self,thePM : OCP.PrsMgr.PrsMgr_PresentationManager,theStyle : OCP.Prs3d.Prs3d_Drawer,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner) -> None: 
        """
        Method which hilight an owner belonging to this selectable object ( for fast presentation draw )
        """
    def HilightSelected(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager,theSeq : OCP.SelectMgr.SelectMgr_SequenceOfOwner) -> None: 
        """
        Method which draws selected owners ( for fast presentation draw )
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def InteractiveContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def InversedTransformation(self) -> OCP.gp.gp_GTrsf: 
        """
        Return inversed transformation.
        """
    def IsAutoHilight(self) -> bool: 
        """
        If returns True, the old mechanism for highlighting selected objects is used (HilightSelected Method may be empty). If returns False, the HilightSelected method will be fully responsible for highlighting selected entity owners belonging to this selectable object.
        """
    def IsInfinite(self) -> bool: 
        """
        Returns true if the interactive object is infinite; FALSE by default. This flag affects various operations operating on bounding box of graphic presentations of this object. For instance, infinite objects are not taken in account for View FitAll. This does not necessarily means that object is actually infinite, auxiliary objects might be also marked with this flag to achieve desired behavior.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def IsMutable(self) -> bool: 
        """
        Returns true if object has mutable nature (content or location are be changed regularly). Mutable object will be managed in different way than static onces (another optimizations).
        """
    def IsTransparent(self) -> bool: 
        """
        Returns true if there is a transparency setting.
        """
    def LocalTransformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def LocalTransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def Material(self) -> OCP.Graphic3d.Graphic3d_NameOfMaterial: 
        """
        Returns the current material setting as enumeration value.
        """
    def Parent(self) -> OCP.PrsMgr.PrsMgr_PresentableObject: 
        """
        Returns parent of current object in scene hierarchy.
        """
    def PolygonOffsets(self,aFactor : float,aUnits : float) -> tuple[int]: 
        """
        Retrieves current polygon offsets settings from <myDrawer>.
        """
    def Presentation(self) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Returns the current presentation of this object according to the current DisplayMode()
        """
    def Presentations(self) -> OCP.PrsMgr.PrsMgr_Presentations: 
        """
        Return presentations.
        """
    def ProcessDragging(self,theCtx : AIS_InteractiveContext,theView : OCP.V3d.V3d_View,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theDragFrom : OCP.Graphic3d.Graphic3d_Vec2i,theDragTo : OCP.Graphic3d.Graphic3d_Vec2i,theAction : AIS_DragAction) -> bool: 
        """
        Drag object in the viewer.
        """
    @overload
    def RecomputePrimitives(self) -> None: 
        """
        Re-computes the sensitive primitives for all modes. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.

        Re-computes the sensitive primitives which correspond to the <theMode>th selection mode. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.
        """
    @overload
    def RecomputePrimitives(self,theMode : int) -> None: ...
    def Redisplay(self,AllModes : bool=False) -> None: 
        """
        Updates the active presentation; if <AllModes> = Standard_True all the presentations inside are recomputed. IMPORTANT: It is preferable to call Redisplay method of corresponding AIS_InteractiveContext instance for cases when it is accessible. This method just redirects call to myCTXPtr, so this class field must be up to date for proper result.
        """
    def RemoveChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy.
        """
    def RemoveChildWithRestoreTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy with keeping the current global transformation. So the object keeps the same position/orientation in the global CS.
        """
    def RemoveClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Removes previously added clip plane.
        """
    def ResetTransformation(self) -> None: 
        """
        None
        """
    def Selection(self,theMode : int) -> OCP.SelectMgr.SelectMgr_Selection: 
        """
        Returns the selection having specified selection mode or NULL.
        """
    def Selections(self) -> OCP.SelectMgr.SelectMgr_SequenceOfSelection: 
        """
        Return the sequence of selections.
        """
    def SetAspect(self,anAspect : OCP.Prs3d.Prs3d_BasicAspect) -> None: 
        """
        Sets the graphic basic aspect to the current presentation.
        """
    def SetAssemblyOwner(self,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theMode : int=-1) -> None: 
        """
        Sets common entity owner for assembly sensitive object entities
        """
    def SetAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the drawing tool theDrawer.
        """
    def SetAutoHilight(self,theAutoHilight : bool) -> None: 
        """
        Set AutoHilight property to true or false.
        """
    def SetClipPlanes(self,thePlanes : OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane) -> None: 
        """
        Set clip planes for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def SetColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Only the interactive object knowns which Drawer attribute is affected by the color, if any (ex: for a wire,it's the wireaspect field of the drawer, but for a vertex, only the point aspect field is affected by the color). WARNING : Do not forget to set the corresponding fields here (hasOwnColor and myDrawer->SetColor())
        """
    def SetColors(self,aColor : OCP.TColStd.TColStd_HArray1OfInteger) -> None: 
        """
        Set the color for each node. Each 32-bit color is Alpha << 24 + Blue << 16 + Green << 8 + Red Order of color components is essential for further usage by OpenGL
        """
    def SetContext(self,aCtx : AIS_InteractiveContext) -> None: 
        """
        Sets the interactive context aCtx and provides a link to the default drawing tool or "Drawer" if there is none.
        """
    def SetCurrentFacingModel(self,theModel : OCP.Aspect.Aspect_TypeOfFacingModel=Aspect_TypeOfFacingModel.Aspect_TOFM_BOTH_SIDE) -> None: 
        """
        change the current facing model apply on polygons for SetColor(), SetTransparency(), SetMaterial() methods default facing model is Aspect_TOFM_TWO_SIDE. This mean that attributes is applying both on the front and back face.
        """
    def SetDisplayMode(self,theMode : int) -> None: 
        """
        Sets the display mode for the interactive object. An object can have its own temporary display mode, which is different from that proposed by the interactive context.
        """
    def SetDynamicHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the dynamic hilight drawing tool.
        """
    def SetHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the hilight drawing tool theDrawer.
        """
    def SetHilightMode(self,theMode : int) -> None: 
        """
        Sets highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def SetInfiniteState(self,theFlag : bool=True) -> None: 
        """
        Sets if object should be considered as infinite.
        """
    def SetIsoOnTriangulation(self,theIsEnabled : bool) -> None: 
        """
        Enables or disables on-triangulation build of isolines according to the flag given.
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.gp.gp_Trsf) -> None: 
        """
        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.

        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.TopLoc.TopLoc_Datum3D) -> None: ...
    def SetMaterial(self,aName : OCP.Graphic3d.Graphic3d_MaterialAspect) -> None: 
        """
        Sets the material aMat defining this display attribute for the interactive object. Material aspect determines shading aspect, color and transparency of visible entities.
        """
    def SetMutable(self,theIsMutable : bool) -> None: 
        """
        Sets if the object has mutable nature (content or location will be changed regularly). This method should be called before object displaying to take effect.
        """
    def SetOwner(self,theApplicativeEntity : OCP.Standard.Standard_Transient) -> None: 
        """
        Allows you to attribute the owner theApplicativeEntity to an Interactive Object. This can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of. The owner takes the form of a transient.
        """
    def SetPolygonOffsets(self,aMode : int,aFactor : float=1.0,aUnits : float=0.0) -> None: 
        """
        Sets up polygon offsets for this object.
        """
    def SetPropagateVisualState(self,theFlag : bool) -> None: 
        """
        Change the value of the flag "propagate visual state"
        """
    @overload
    def SetToUpdate(self) -> None: 
        """
        Flags presentation to be updated; UpdatePresentations() will recompute these presentations.

        flags all the Presentations to be Updated.
        """
    @overload
    def SetToUpdate(self,theMode : int) -> None: ...
    def SetTransformPersistence(self,theTrsfPers : OCP.Graphic3d.Graphic3d_TransformPers) -> None: 
        """
        Sets up Transform Persistence defining a special Local Coordinate system where this object should be located. Note that management of Transform Persistence object is more expensive than of the normal one, because it requires its position being recomputed basing on camera position within each draw call / traverse.
        """
    def SetTransparency(self,aValue : float=0.6) -> None: 
        """
        Sets the value aValue for transparency in the reconstructed compound shape.
        """
    def SetTriangulation(self,aTriangulation : OCP.Poly.Poly_Triangulation) -> None: 
        """
        None
        """
    def SetTypeOfPresentation(self,theType : OCP.PrsMgr.PrsMgr_TypeOfPresentation3d) -> None: 
        """
        Set type of presentation.
        """
    def SetWidth(self,theWidth : float) -> None: 
        """
        Allows you to provide the setting aValue for width. Only the Interactive Object knows which Drawer attribute is affected by the width setting.
        """
    def SetZLayer(self,theLayerId : int) -> None: 
        """
        Set Z layer ID and update all presentations of the selectable object. The layers mechanism allows drawing objects in higher layers in overlay of objects in lower layers.
        """
    def Signature(self) -> int: 
        """
        Specifies additional characteristics of Interactive Object of Type(); -1 by default. Among the datums, this signature is attributed to the shape. The remaining datums have the following default signatures: - Point signature 1 - Axis signature 2 - Trihedron signature 3 - PlaneTrihedron signature 4 - Line signature 5 - Circle signature 6 - Plane signature 7.
        """
    def SynchronizeAspects(self) -> None: 
        """
        Synchronize presentation aspects after their modification.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    @overload
    def ToBeUpdated(self,ListOfMode : OCP.TColStd.TColStd_ListOfInteger) -> None: 
        """
        Returns TRUE if any active presentation has invalidation flag.

        gives the list of modes which are flagged "to be updated".
        """
    @overload
    def ToBeUpdated(self,theToIncludeHidden : bool=False) -> bool: ...
    def ToPropagateVisualState(self) -> bool: 
        """
        Get value of the flag "propagate visual state" It means that the display/erase/color visual state is propagated automatically to all children; by default, the flag is true
        """
    def TransformPersistence(self) -> OCP.Graphic3d.Graphic3d_TransformPers: 
        """
        Returns Transformation Persistence defining a special Local Coordinate system where this presentable object is located or NULL handle if not defined. Position of the object having Transformation Persistence is mutable and depends on camera position. The same applies to a bounding box of the object.
        """
    def Transformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def TransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def Transparency(self) -> float: 
        """
        Returns the transparency setting. This will be between 0.0 and 1.0. At 0.0 an object will be totally opaque, and at 1.0, fully transparent.
        """
    def Type(self) -> AIS_KindOfInteractive: 
        """
        Returns the kind of Interactive Object; AIS_KindOfInteractive_None by default.
        """
    def TypeOfPresentation3d(self) -> OCP.PrsMgr.PrsMgr_TypeOfPresentation3d: 
        """
        Returns information on whether the object accepts display in HLR mode or not.
        """
    def UnsetAttributes(self) -> None: 
        """
        Clears settings provided by the drawing tool aDrawer.
        """
    def UnsetColor(self) -> None: 
        """
        Removes color settings. Only the Interactive Object knows which Drawer attribute is affected by the color setting. For a wire, for example, wire aspect is the attribute affected. For a vertex, however, only point aspect is affected by the color setting.
        """
    def UnsetDisplayMode(self) -> None: 
        """
        Removes display mode settings from the interactive object.
        """
    def UnsetHilightAttributes(self) -> None: 
        """
        Clears settings provided by the hilight drawing tool theDrawer.
        """
    def UnsetHilightMode(self) -> None: 
        """
        Unsets highlight display mode.
        """
    def UnsetMaterial(self) -> None: 
        """
        Removes the setting for material.
        """
    def UnsetTransparency(self) -> None: 
        """
        Removes the setting for transparency in the reconstructed compound shape.
        """
    def UnsetWidth(self) -> None: 
        """
        Reset width to default value.
        """
    def UpdateSelection(self,theMode : int=-1) -> None: 
        """
        Sets update status FULL to selections of the object. Must be used as the only method of UpdateSelection from outer classes to prevent BVH structures from being outdated.
        """
    def UpdateTransformation(self) -> None: 
        """
        Recomputes the location of the selection aSelection.
        """
    def UpdateTransformations(self,aSelection : OCP.SelectMgr.SelectMgr_Selection) -> None: 
        """
        Updates locations in all sensitive entities from <aSelection> and in corresponding entity owners.
        """
    def ViewAffinity(self) -> OCP.Graphic3d.Graphic3d_ViewAffinity: 
        """
        Return view affinity mask.
        """
    def Width(self) -> float: 
        """
        Returns the width setting of the Interactive Object.
        """
    def ZLayer(self) -> int: 
        """
        Get ID of Z layer for main presentation.
        """
    def __init__(self,aTriangulation : OCP.Poly.Poly_Triangulation) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class AIS_Trihedron(AIS_InteractiveObject, OCP.SelectMgr.SelectMgr_SelectableObject, OCP.PrsMgr.PrsMgr_PresentableObject, OCP.Standard.Standard_Transient):
    """
    Create a selectable trihedron The trihedron includes 1 origin, 3 axes and 3 labels. Default text of labels are "X", "Y", "Z". Color of origin and any axis, color of arrows and labels may be changed. Visual presentation might be shown in two, shaded and wireframe modes, wireframe by default). There are 4 modes of selection: - AIS_TrihedronSelectionMode_EntireObject to select trihedron, priority = 1 - AIS_TrihedronSelectionMode_Origin to select its origin, priority = 5 - AIS_TrihedronSelectionMode_Axes to select its axis, priority = 3 - AIS_TrihedronSelectionMode_MainPlanes to select its planes, priority = 2Create a selectable trihedron The trihedron includes 1 origin, 3 axes and 3 labels. Default text of labels are "X", "Y", "Z". Color of origin and any axis, color of arrows and labels may be changed. Visual presentation might be shown in two, shaded and wireframe modes, wireframe by default). There are 4 modes of selection: - AIS_TrihedronSelectionMode_EntireObject to select trihedron, priority = 1 - AIS_TrihedronSelectionMode_Origin to select its origin, priority = 5 - AIS_TrihedronSelectionMode_Axes to select its axis, priority = 3 - AIS_TrihedronSelectionMode_MainPlanes to select its planes, priority = 2
    """
    def AcceptDisplayMode(self,theMode : int) -> bool: 
        """
        Returns true if the display mode selected, aMode, is valid for trihedron datums.
        """
    def AcceptShapeDecomposition(self) -> bool: 
        """
        Informs the graphic context that the interactive Object may be decomposed into sub-shapes for dynamic selection. The most used Interactive Object is AIS_Shape.
        """
    def AddChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy.
        """
    def AddChildWithCurrentTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Makes theObject child of current object in scene hierarchy with keeping the current global transformation So the object keeps the same position/orientation in the global CS.
        """
    def AddClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Adds clip plane for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def AddSelection(self,aSelection : OCP.SelectMgr.SelectMgr_Selection,aMode : int) -> None: 
        """
        Adds the selection aSelection with the selection mode index aMode to this framework.
        """
    def ArrowColor(self) -> OCP.Quantity.Quantity_Color: 
        """
        Returns trihedron arrow color
        """
    def Attributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the attributes settings.
        """
    def BndBoxOfSelected(self,theOwners : Any) -> OCP.Bnd.Bnd_Box: 
        """
        Returns a bounding box of sensitive entities with the owners given if they are a part of activated selection
        """
    def BoundingBox(self,theBndBox : OCP.Bnd.Bnd_Box) -> None: 
        """
        Returns bounding box of object correspondingly to its current display mode. This method requires presentation to be already computed, since it relies on bounding box of presentation structures, which are supposed to be same/close amongst different display modes of this object.
        """
    def Children(self) -> OCP.PrsMgr.PrsMgr_ListOfPresentableObjects: 
        """
        Returns children of the current object.
        """
    def ClearDynamicHighlight(self,theMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> None: 
        """
        Method that needs to be implemented when the object manages selection and dynamic highlighting on its own. Clears or invalidates dynamic highlight presentation. By default it clears immediate draw of given presentation manager.
        """
    def ClearOwner(self) -> None: 
        """
        Each Interactive Object has methods which allow us to attribute an Owner to it in the form of a Transient. This method removes the owner from the graphic entity.
        """
    def ClearSelected(self) -> None: 
        """
        Method which clear all selected owners belonging to this selectable object ( for fast presentation draw ).
        """
    def ClearSelections(self,update : bool=False) -> None: 
        """
        Empties all the selections in the SelectableObject <update> parameter defines whether all object's selections should be flagged for further update or not. This improved method can be used to recompute an object's selection (without redisplaying the object completely) when some selection mode is activated not for the first time.
        """
    def ClipPlanes(self) -> OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane: 
        """
        Get clip planes.
        """
    def Color(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Returns the color setting of the Interactive Object.
        """
    def CombinedParentTransformation(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return combined parent transformation.
        """
    def Component(self) -> OCP.Geom.Geom_Axis2Placement: 
        """
        Returns the right-handed coordinate system set in SetComponent.
        """
    def ComputeSelection(self,theSelection : OCP.SelectMgr.SelectMgr_Selection,theMode : int) -> None: 
        """
        Computes sensitive primitives for the given selection mode - key interface method of Selectable Object.
        """
    def CurrentFacingModel(self) -> OCP.Aspect.Aspect_TypeOfFacingModel: 
        """
        Returns the current facing model which is in effect.
        """
    def DatumDisplayMode(self) -> OCP.Prs3d.Prs3d_DatumMode: 
        """
        Returns datum display mode.
        """
    def DatumPartColor(self,thePart : OCP.Prs3d.Prs3d_DatumParts) -> OCP.Quantity.Quantity_Color: 
        """
        Returns color of datum part: origin or some of trihedron axes.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def DefaultDisplayMode(self) -> int: 
        """
        Returns the default display mode.
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DisplayMode(self) -> int: 
        """
        Returns the display mode setting of the Interactive Object. The range of supported display mode indexes should be specified within object definition and filtered by AccepDisplayMode().
        """
    def DisplayStatus(self) -> OCP.PrsMgr.PrsMgr_DisplayStatus: 
        """
        Return presentation display status; PrsMgr_DisplayStatus_None by default.
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicHilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalDynamic and Prs3d_TypeOfHighlight_Dynamic defined within AIS_InteractiveContext::HighlightStyle().
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def ErasePresentations(self,theToRemove : bool) -> None: 
        """
        Removes presentations returned by GetHilightPresentation() and GetSelectPresentation().
        """
    def GetAssemblyOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns common entity owner if the object is an assembly
        """
    def GetContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def GetHilightPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting detected object.
        """
    def GetOwner(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns the owner of the Interactive Object. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient. There are two types of owners: - Direct owners, decomposition shapes such as edges, wires, and faces. - Users, presentable objects connecting to sensitive primitives, or a shape which has been decomposed.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def GetSelectPresentation(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Creates or returns existing presentation for highlighting selected object.
        """
    def GlobalSelOwner(self) -> OCP.SelectMgr.SelectMgr_EntityOwner: 
        """
        Returns the owner of mode for selection of object as a whole
        """
    def GlobalSelectionMode(self) -> int: 
        """
        Returns the mode for selection of object as a whole; 0 by default.
        """
    def HasArrowColor(self) -> bool: 
        """
        Returns true if trihedron has own arrow color
        """
    def HasColor(self) -> bool: 
        """
        Returns true if the Interactive Object has color.
        """
    def HasDisplayMode(self) -> bool: 
        """
        Returns true if the Interactive Object has display mode setting overriding global setting (within Interactive Context).
        """
    def HasHilightMode(self) -> bool: 
        """
        Returns true if the Interactive Object is in highlight mode.
        """
    def HasInteractiveContext(self) -> bool: 
        """
        Indicates whether the Interactive Object has a pointer to an interactive context.
        """
    def HasMaterial(self) -> bool: 
        """
        Returns true if the Interactive Object has a setting for material.
        """
    def HasOwnPresentations(self) -> bool: 
        """
        Returns true if object should have own presentations.
        """
    def HasOwnSize(self) -> bool: 
        """
        Returns true if the trihedron object has a size other than the default size of 100 mm. along each axis.
        """
    def HasOwner(self) -> bool: 
        """
        Returns true if the object has an owner attributed to it. The owner can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of, and takes the form of a transient.
        """
    def HasPolygonOffsets(self) -> bool: 
        """
        Returns Standard_True if <myDrawer> has non-null shading aspect
        """
    def HasPresentation(self) -> bool: 
        """
        Returns TRUE when this object has a presentation in the current DisplayMode()
        """
    def HasSelection(self,theMode : int) -> bool: 
        """
        Returns true if a selection corresponding to the selection mode theMode was computed for this object.
        """
    def HasTextColor(self) -> bool: 
        """
        Returns true if trihedron has own text color
        """
    def HasTransformation(self) -> bool: 
        """
        Returns true if object has a transformation that is different from the identity.
        """
    def HasWidth(self) -> bool: 
        """
        Returns true if the Interactive Object has width.
        """
    def HilightAttributes(self) -> OCP.Prs3d.Prs3d_Drawer: 
        """
        Returns the hilight attributes settings. When not NULL, overrides both Prs3d_TypeOfHighlight_LocalSelected and Prs3d_TypeOfHighlight_Selected defined within AIS_InteractiveContext::HighlightStyle().
        """
    def HilightMode(self) -> int: 
        """
        Returns highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def HilightOwnerWithColor(self,thePM : OCP.PrsMgr.PrsMgr_PresentationManager,theStyle : OCP.Prs3d.Prs3d_Drawer,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner) -> None: 
        """
        Method which hilight an owner belonging to this selectable object ( for fast presentation draw ).
        """
    def HilightSelected(self,thePM : OCP.PrsMgr.PrsMgr_PresentationManager,theOwners : OCP.SelectMgr.SelectMgr_SequenceOfOwner) -> None: 
        """
        Method which draws selected owners ( for fast presentation draw ).
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def InteractiveContext(self) -> AIS_InteractiveContext: 
        """
        Returns the context pointer to the interactive context.
        """
    def InversedTransformation(self) -> OCP.gp.gp_GTrsf: 
        """
        Return inversed transformation.
        """
    def IsAutoHilight(self) -> bool: 
        """
        If returns True, the old mechanism for highlighting selected objects is used (HilightSelected Method may be empty). If returns False, the HilightSelected method will be fully responsible for highlighting selected entity owners belonging to this selectable object.
        """
    def IsInfinite(self) -> bool: 
        """
        Returns true if the interactive object is infinite; FALSE by default. This flag affects various operations operating on bounding box of graphic presentations of this object. For instance, infinite objects are not taken in account for View FitAll. This does not necessarily means that object is actually infinite, auxiliary objects might be also marked with this flag to achieve desired behavior.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def IsMutable(self) -> bool: 
        """
        Returns true if object has mutable nature (content or location are be changed regularly). Mutable object will be managed in different way than static onces (another optimizations).
        """
    def IsTransparent(self) -> bool: 
        """
        Returns true if there is a transparency setting.
        """
    def Label(self,thePart : OCP.Prs3d.Prs3d_DatumParts) -> OCP.TCollection.TCollection_ExtendedString: 
        """
        Returns text of axis. Parameter thePart should be XAxis, YAxis or ZAxis
        """
    def LocalTransformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def LocalTransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the local transformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def Material(self) -> OCP.Graphic3d.Graphic3d_NameOfMaterial: 
        """
        Returns the current material setting as enumeration value.
        """
    def Parent(self) -> OCP.PrsMgr.PrsMgr_PresentableObject: 
        """
        Returns parent of current object in scene hierarchy.
        """
    def PolygonOffsets(self,aFactor : float,aUnits : float) -> tuple[int]: 
        """
        Retrieves current polygon offsets settings from <myDrawer>.
        """
    def Presentation(self) -> OCP.Graphic3d.Graphic3d_Structure: 
        """
        Returns the current presentation of this object according to the current DisplayMode()
        """
    def Presentations(self) -> OCP.PrsMgr.PrsMgr_Presentations: 
        """
        Return presentations.
        """
    def ProcessDragging(self,theCtx : AIS_InteractiveContext,theView : OCP.V3d.V3d_View,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theDragFrom : OCP.Graphic3d.Graphic3d_Vec2i,theDragTo : OCP.Graphic3d.Graphic3d_Vec2i,theAction : AIS_DragAction) -> bool: 
        """
        Drag object in the viewer.
        """
    @overload
    def RecomputePrimitives(self) -> None: 
        """
        Re-computes the sensitive primitives for all modes. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.

        Re-computes the sensitive primitives which correspond to the <theMode>th selection mode. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.
        """
    @overload
    def RecomputePrimitives(self,theMode : int) -> None: ...
    def Redisplay(self,AllModes : bool=False) -> None: 
        """
        Updates the active presentation; if <AllModes> = Standard_True all the presentations inside are recomputed. IMPORTANT: It is preferable to call Redisplay method of corresponding AIS_InteractiveContext instance for cases when it is accessible. This method just redirects call to myCTXPtr, so this class field must be up to date for proper result.
        """
    def RemoveChild(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy.
        """
    def RemoveChildWithRestoreTransformation(self,theObject : OCP.PrsMgr.PrsMgr_PresentableObject) -> None: 
        """
        Removes theObject from children of current object in scene hierarchy with keeping the current global transformation. So the object keeps the same position/orientation in the global CS.
        """
    def RemoveClipPlane(self,thePlane : OCP.Graphic3d.Graphic3d_ClipPlane) -> None: 
        """
        Removes previously added clip plane.
        """
    def ResetTransformation(self) -> None: 
        """
        None
        """
    def Selection(self,theMode : int) -> OCP.SelectMgr.SelectMgr_Selection: 
        """
        Returns the selection having specified selection mode or NULL.
        """
    def SelectionPriority(self,thePart : OCP.Prs3d.Prs3d_DatumParts) -> int: 
        """
        Returns priority of selection for owner of the given type
        """
    def Selections(self) -> OCP.SelectMgr.SelectMgr_SequenceOfSelection: 
        """
        Return the sequence of selections.
        """
    @overload
    def SetArrowColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Sets color of arrow of trihedron axes.

        Sets color of arrow of trihedron axes.
        """
    @overload
    def SetArrowColor(self,thePart : OCP.Prs3d.Prs3d_DatumParts,theColor : OCP.Quantity.Quantity_Color) -> None: ...
    def SetAspect(self,anAspect : OCP.Prs3d.Prs3d_BasicAspect) -> None: 
        """
        Sets the graphic basic aspect to the current presentation.
        """
    def SetAssemblyOwner(self,theOwner : OCP.SelectMgr.SelectMgr_EntityOwner,theMode : int=-1) -> None: 
        """
        Sets common entity owner for assembly sensitive object entities
        """
    def SetAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the drawing tool theDrawer.
        """
    def SetAutoHilight(self,theAutoHilight : bool) -> None: 
        """
        Set AutoHilight property to true or false.
        """
    def SetAxisColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Sets color of z-axis. Standard_DEPRECATED("This method is deprecated - SetColor() should be called instead")
        """
    def SetClipPlanes(self,thePlanes : OCP.Graphic3d.Graphic3d_SequenceOfHClipPlane) -> None: 
        """
        Set clip planes for graphical clipping for all display mode presentations. The composition of clip planes truncates the rendering space to convex volume. Please be aware that number of supported clip plane is limited. The planes which exceed the limit are ignored. Besides of this, some planes can be already set in view where the object is shown: the number of these planes should be subtracted from limit to predict the maximum possible number of object clipping planes.
        """
    def SetColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Sets the color theColor for this trihedron object, it changes color of axes.
        """
    def SetComponent(self,theComponent : OCP.Geom.Geom_Axis2Placement) -> None: 
        """
        Constructs the right-handed coordinate system aComponent.
        """
    def SetContext(self,aCtx : AIS_InteractiveContext) -> None: 
        """
        Sets the interactive context aCtx and provides a link to the default drawing tool or "Drawer" if there is none.
        """
    def SetCurrentFacingModel(self,theModel : OCP.Aspect.Aspect_TypeOfFacingModel=Aspect_TypeOfFacingModel.Aspect_TOFM_BOTH_SIDE) -> None: 
        """
        change the current facing model apply on polygons for SetColor(), SetTransparency(), SetMaterial() methods default facing model is Aspect_TOFM_TWO_SIDE. This mean that attributes is applying both on the front and back face.
        """
    def SetDatumDisplayMode(self,theMode : OCP.Prs3d.Prs3d_DatumMode) -> None: 
        """
        Sets Shading or Wireframe display mode, triangle or segment graphic group is used relatively.
        """
    def SetDatumPartColor(self,thePart : OCP.Prs3d.Prs3d_DatumParts,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Sets color of datum part: origin or some of trihedron axes. If presentation is shading mode, this color is set for both sides of facing model
        """
    def SetDisplayMode(self,theMode : int) -> None: 
        """
        Sets the display mode for the interactive object. An object can have its own temporary display mode, which is different from that proposed by the interactive context.
        """
    def SetDrawArrows(self,theToDraw : bool) -> None: 
        """
        Sets whether to draw the arrows in visualization
        """
    def SetDynamicHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the dynamic hilight drawing tool.
        """
    def SetHilightAttributes(self,theDrawer : OCP.Prs3d.Prs3d_Drawer) -> None: 
        """
        Initializes the hilight drawing tool theDrawer.
        """
    def SetHilightMode(self,theMode : int) -> None: 
        """
        Sets highlight display mode. This is obsolete method for backward compatibility - use ::HilightAttributes() and ::DynamicHilightAttributes() instead.
        """
    def SetInfiniteState(self,theFlag : bool=True) -> None: 
        """
        Sets if object should be considered as infinite.
        """
    def SetIsoOnTriangulation(self,theIsEnabled : bool) -> None: 
        """
        Enables or disables on-triangulation build of isolines according to the flag given.
        """
    def SetLabel(self,thePart : OCP.Prs3d.Prs3d_DatumParts,theName : OCP.TCollection.TCollection_ExtendedString) -> None: 
        """
        Sets text label for trihedron axis. Parameter thePart should be XAxis, YAxis or ZAxis
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.gp.gp_Trsf) -> None: 
        """
        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.

        Sets local transformation to theTransformation. Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    @overload
    def SetLocalTransformation(self,theTrsf : OCP.TopLoc.TopLoc_Datum3D) -> None: ...
    def SetMaterial(self,aName : OCP.Graphic3d.Graphic3d_MaterialAspect) -> None: 
        """
        Sets the material aMat defining this display attribute for the interactive object. Material aspect determines shading aspect, color and transparency of visible entities.
        """
    def SetMutable(self,theIsMutable : bool) -> None: 
        """
        Sets if the object has mutable nature (content or location will be changed regularly). This method should be called before object displaying to take effect.
        """
    def SetOriginColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Sets color of origin. Standard_DEPRECATED("This method is deprecated - SetColor() should be called instead")
        """
    def SetOwner(self,theApplicativeEntity : OCP.Standard.Standard_Transient) -> None: 
        """
        Allows you to attribute the owner theApplicativeEntity to an Interactive Object. This can be a shape for a set of sub-shapes or a sub-shape for sub-shapes which it is composed of. The owner takes the form of a transient.
        """
    def SetPolygonOffsets(self,aMode : int,aFactor : float=1.0,aUnits : float=0.0) -> None: 
        """
        Sets up polygon offsets for this object.
        """
    def SetPropagateVisualState(self,theFlag : bool) -> None: 
        """
        Change the value of the flag "propagate visual state"
        """
    def SetSelectionPriority(self,thePart : OCP.Prs3d.Prs3d_DatumParts,thePriority : int) -> None: 
        """
        Sets priority of selection for owner of the given type
        """
    def SetSize(self,theValue : float) -> None: 
        """
        Sets the size of trihedron object.
        """
    @overload
    def SetTextColor(self,thePart : OCP.Prs3d.Prs3d_DatumParts,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Sets color of label of trihedron axes.

        Sets color of label of trihedron axis.
        """
    @overload
    def SetTextColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: ...
    @overload
    def SetToUpdate(self) -> None: 
        """
        Flags presentation to be updated; UpdatePresentations() will recompute these presentations.

        flags all the Presentations to be Updated.
        """
    @overload
    def SetToUpdate(self,theMode : int) -> None: ...
    def SetTransformPersistence(self,theTrsfPers : OCP.Graphic3d.Graphic3d_TransformPers) -> None: 
        """
        Sets up Transform Persistence defining a special Local Coordinate system where this object should be located. Note that management of Transform Persistence object is more expensive than of the normal one, because it requires its position being recomputed basing on camera position within each draw call / traverse.
        """
    def SetTransparency(self,aValue : float=0.6) -> None: 
        """
        Attributes a setting aValue for transparency. The transparency value should be between 0.0 and 1.0. At 0.0 an object will be totally opaque, and at 1.0, fully transparent. Warning At a value of 1.0, there may be nothing visible.
        """
    def SetTypeOfPresentation(self,theType : OCP.PrsMgr.PrsMgr_TypeOfPresentation3d) -> None: 
        """
        Set type of presentation.
        """
    def SetWidth(self,theWidth : float) -> None: 
        """
        Allows you to provide the setting aValue for width. Only the Interactive Object knows which Drawer attribute is affected by the width setting.
        """
    def SetXAxisColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Sets color of x-axis. Standard_DEPRECATED("This method is deprecated - SetColor() should be called instead")
        """
    def SetYAxisColor(self,theColor : OCP.Quantity.Quantity_Color) -> None: 
        """
        Sets color of y-axis. Standard_DEPRECATED("This method is deprecated - SetColor() should be called instead")
        """
    def SetZLayer(self,theLayerId : int) -> None: 
        """
        Set Z layer ID and update all presentations of the selectable object. The layers mechanism allows drawing objects in higher layers in overlay of objects in lower layers.
        """
    def Signature(self) -> int: 
        """
        Returns index 3, selection of the planes XOY, YOZ, XOZ.
        """
    def Size(self) -> float: 
        """
        Returns the size of trihedron object; 100.0 by DEFAULT.
        """
    def SynchronizeAspects(self) -> None: 
        """
        Synchronize presentation aspects after their modification.
        """
    def TextColor(self) -> OCP.Quantity.Quantity_Color: 
        """
        Returns trihedron text color
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    @overload
    def ToBeUpdated(self,ListOfMode : OCP.TColStd.TColStd_ListOfInteger) -> None: 
        """
        Returns TRUE if any active presentation has invalidation flag.

        gives the list of modes which are flagged "to be updated".
        """
    @overload
    def ToBeUpdated(self,theToIncludeHidden : bool=False) -> bool: ...
    def ToDrawArrows(self) -> bool: 
        """
        Returns true if arrows are to be drawn
        """
    def ToPropagateVisualState(self) -> bool: 
        """
        Get value of the flag "propagate visual state" It means that the display/erase/color visual state is propagated automatically to all children; by default, the flag is true
        """
    def TransformPersistence(self) -> OCP.Graphic3d.Graphic3d_TransformPers: 
        """
        Returns Transformation Persistence defining a special Local Coordinate system where this presentable object is located or NULL handle if not defined. Position of the object having Transformation Persistence is mutable and depends on camera position. The same applies to a bounding box of the object.
        """
    def Transformation(self) -> OCP.gp.gp_Trsf: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def TransformationGeom(self) -> OCP.TopLoc.TopLoc_Datum3D: 
        """
        Return the transformation taking into account transformation of parent object(s). Note that the local transformation of the object having Transformation Persistence is applied within Local Coordinate system defined by this Persistence.
        """
    def Transparency(self) -> float: 
        """
        Returns the transparency setting. This will be between 0.0 and 1.0. At 0.0 an object will be totally opaque, and at 1.0, fully transparent.
        """
    def Type(self) -> AIS_KindOfInteractive: 
        """
        Indicates that the type of Interactive Object is datum.
        """
    def TypeOfPresentation3d(self) -> OCP.PrsMgr.PrsMgr_TypeOfPresentation3d: 
        """
        Returns information on whether the object accepts display in HLR mode or not.
        """
    def UnsetAttributes(self) -> None: 
        """
        Clears settings provided by the drawing tool aDrawer.
        """
    def UnsetColor(self) -> None: 
        """
        Removes the settings for color.
        """
    def UnsetDisplayMode(self) -> None: 
        """
        Removes display mode settings from the interactive object.
        """
    def UnsetHilightAttributes(self) -> None: 
        """
        Clears settings provided by the hilight drawing tool theDrawer.
        """
    def UnsetHilightMode(self) -> None: 
        """
        Unsets highlight display mode.
        """
    def UnsetMaterial(self) -> None: 
        """
        Removes the setting for material.
        """
    def UnsetSize(self) -> None: 
        """
        Removes any non-default settings for size of this trihedron object. If the object has 1 color, the default size of the drawer is reproduced, otherwise DatumAspect becomes null.
        """
    def UnsetTransparency(self) -> None: 
        """
        Removes the transparency setting. The object is opaque by default.
        """
    def UnsetWidth(self) -> None: 
        """
        Reset width to default value.
        """
    def UpdateSelection(self,theMode : int=-1) -> None: 
        """
        Sets update status FULL to selections of the object. Must be used as the only method of UpdateSelection from outer classes to prevent BVH structures from being outdated.
        """
    def UpdateTransformation(self) -> None: 
        """
        Recomputes the location of the selection aSelection.
        """
    def UpdateTransformations(self,aSelection : OCP.SelectMgr.SelectMgr_Selection) -> None: 
        """
        Updates locations in all sensitive entities from <aSelection> and in corresponding entity owners.
        """
    def ViewAffinity(self) -> OCP.Graphic3d.Graphic3d_ViewAffinity: 
        """
        Return view affinity mask.
        """
    def Width(self) -> float: 
        """
        Returns the width setting of the Interactive Object.
        """
    def ZLayer(self) -> int: 
        """
        Get ID of Z layer for main presentation.
        """
    def __init__(self,theComponent : OCP.Geom.Geom_Axis2Placement) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class AIS_TrihedronOwner(OCP.SelectMgr.SelectMgr_EntityOwner, OCP.Standard.Standard_Transient):
    """
    Entity owner for selection management of AIS_Trihedron object.Entity owner for selection management of AIS_Trihedron object.
    """
    def Clear(self,thePrsMgr : OCP.PrsMgr.PrsMgr_PresentationManager,theMode : int=0) -> None: 
        """
        Clears the owners matching the value of the selection mode aMode from the presentation manager object aPM.
        """
    def ComesFromDecomposition(self) -> bool: 
        """
        Returns TRUE if this owner points to a part of object and FALSE for entire object.
        """
    def DatumPart(self) -> OCP.Prs3d.Prs3d_DatumParts: 
        """
        Returns the datum part identifier.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HandleMouseClick(self,thePoint : OCP.Graphic3d.Graphic3d_Vec2i,theButton : int,theModifiers : int,theIsDoubleClick : bool) -> bool: 
        """
        Handle mouse button click event. Does nothing by default and returns FALSE.
        """
    def HasLocation(self) -> bool: 
        """
        Returns TRUE if selectable has transformation.
        """
    def HasSelectable(self) -> bool: 
        """
        Returns true if there is a selectable object to serve as an owner.
        """
    def HilightWithColor(self,thePM : OCP.PrsMgr.PrsMgr_PresentationManager,theStyle : OCP.Prs3d.Prs3d_Drawer,theMode : int) -> None: 
        """
        Highlights selectable object's presentation.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def IsAutoHilight(self) -> bool: 
        """
        if owner is not auto hilighted, for group contains many such owners will be called one method HilightSelected of SelectableObject
        """
    def IsForcedHilight(self) -> bool: 
        """
        if this method returns TRUE the owner will always call method Hilight for SelectableObject when the owner is detected. By default it always return FALSE.
        """
    def IsHilighted(self,thePM : OCP.PrsMgr.PrsMgr_PresentationManager,theMode : int) -> bool: 
        """
        Returns true if the presentation manager thePM highlights selections corresponding to the selection mode aMode.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def IsSameSelectable(self,theOther : OCP.SelectMgr.SelectMgr_SelectableObject) -> bool: 
        """
        Returns true if pointer to selectable object of this owner is equal to the given one
        """
    def IsSelected(self) -> bool: 
        """
        Returns Standard_True if the owner is selected.
        """
    def Location(self) -> OCP.TopLoc.TopLoc_Location: 
        """
        Returns transformation of selectable.
        """
    def Priority(self) -> int: 
        """
        Return selection priority (within range [0-9]) for results with the same depth; 0 by default. Example - selection of shapes: the owners are selectable objects (presentations) a user can give vertex priority [3], edges [2] faces [1] shape [0], so that if during selection one vertex one edge and one face are simultaneously detected, the vertex will only be hilighted.
        """
    def Select(self,theSelScheme : AIS_SelectionScheme,theIsDetected : bool) -> bool: 
        """
        If the object needs to be selected, it returns true.
        """
    def Selectable(self) -> OCP.SelectMgr.SelectMgr_SelectableObject: 
        """
        Returns a selectable object detected in the working context.
        """
    @overload
    def Set(self,theSelObj : OCP.SelectMgr.SelectMgr_SelectableObject) -> None: 
        """
        Sets the selectable object.

        sets the selectable priority of the owner
        """
    @overload
    def Set(self,thePriority : int) -> None: ...
    def SetComesFromDecomposition(self,theIsFromDecomposition : bool) -> None: 
        """
        Sets flag indicating this owner points to a part of object (TRUE) or to entire object (FALSE).
        """
    def SetLocation(self,theLocation : OCP.TopLoc.TopLoc_Location) -> None: 
        """
        Change owner location (callback for handling change of location of selectable object).
        """
    def SetPriority(self,thePriority : int) -> None: 
        """
        Sets the selectable priority of the owner within range [0-9].
        """
    def SetSelectable(self,theSelObj : OCP.SelectMgr.SelectMgr_SelectableObject) -> None: 
        """
        Sets the selectable object.
        """
    def SetSelected(self,theIsSelected : bool) -> None: 
        """
        Set the state of the owner.
        """
    def SetZLayer(self,theLayerId : int) -> None: 
        """
        Set Z layer ID and update all presentations.
        """
    @overload
    def State(self) -> int: 
        """
        Returns selection state.

        Set the state of the owner. The method is deprecated. Use SetSelected() instead.
        """
    @overload
    def State(self,theStatus : int) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Unhilight(self,thePM : OCP.PrsMgr.PrsMgr_PresentationManager,theMode : int) -> None: 
        """
        Removes highlighting from the owner of a detected selectable object in the presentation manager thePM.
        """
    def UpdateHighlightTrsf(self,theViewer : OCP.V3d.V3d_Viewer,theManager : OCP.PrsMgr.PrsMgr_PresentationManager,theDispMode : int) -> None: 
        """
        Implements immediate application of location transformation of parent object to dynamic highlight structure
        """
    def __init__(self,theSelObject : OCP.SelectMgr.SelectMgr_SelectableObject,theDatumPart : OCP.Prs3d.Prs3d_DatumParts,thePriority : int) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class AIS_TrihedronSelectionMode():
    """
    Enumeration defining selection modes supported by AIS_Trihedron.

    Members:

      AIS_TrihedronSelectionMode_EntireObject

      AIS_TrihedronSelectionMode_Origin

      AIS_TrihedronSelectionMode_Axes

      AIS_TrihedronSelectionMode_MainPlanes
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    AIS_TrihedronSelectionMode_Axes: OCP.AIS.AIS_TrihedronSelectionMode # value = <AIS_TrihedronSelectionMode.AIS_TrihedronSelectionMode_Axes: 2>
    AIS_TrihedronSelectionMode_EntireObject: OCP.AIS.AIS_TrihedronSelectionMode # value = <AIS_TrihedronSelectionMode.AIS_TrihedronSelectionMode_EntireObject: 0>
    AIS_TrihedronSelectionMode_MainPlanes: OCP.AIS.AIS_TrihedronSelectionMode # value = <AIS_TrihedronSelectionMode.AIS_TrihedronSelectionMode_MainPlanes: 3>
    AIS_TrihedronSelectionMode_Origin: OCP.AIS.AIS_TrihedronSelectionMode # value = <AIS_TrihedronSelectionMode.AIS_TrihedronSelectionMode_Origin: 1>
    __entries: dict # value = {'AIS_TrihedronSelectionMode_EntireObject': (<AIS_TrihedronSelectionMode.AIS_TrihedronSelectionMode_EntireObject: 0>, None), 'AIS_TrihedronSelectionMode_Origin': (<AIS_TrihedronSelectionMode.AIS_TrihedronSelectionMode_Origin: 1>, None), 'AIS_TrihedronSelectionMode_Axes': (<AIS_TrihedronSelectionMode.AIS_TrihedronSelectionMode_Axes: 2>, None), 'AIS_TrihedronSelectionMode_MainPlanes': (<AIS_TrihedronSelectionMode.AIS_TrihedronSelectionMode_MainPlanes: 3>, None)}
    __members__: dict # value = {'AIS_TrihedronSelectionMode_EntireObject': <AIS_TrihedronSelectionMode.AIS_TrihedronSelectionMode_EntireObject: 0>, 'AIS_TrihedronSelectionMode_Origin': <AIS_TrihedronSelectionMode.AIS_TrihedronSelectionMode_Origin: 1>, 'AIS_TrihedronSelectionMode_Axes': <AIS_TrihedronSelectionMode.AIS_TrihedronSelectionMode_Axes: 2>, 'AIS_TrihedronSelectionMode_MainPlanes': <AIS_TrihedronSelectionMode.AIS_TrihedronSelectionMode_MainPlanes: 3>}
    pass
class AIS_SignatureFilter(AIS_TypeFilter, OCP.SelectMgr.SelectMgr_Filter, OCP.Standard.Standard_Transient):
    """
    Selects Interactive Objects through their signatures and types. The signature provides an additional characterization of an object's type, and takes the form of an index. The filter questions each Interactive Object in local context to determine whether it has an non-null owner, and if so, whether it has the desired signature. If the object returns true in each case, it is kept. If not, it is rejected. By default, the interactive object has a None type and a signature of 0. If you want to give a particular type and signature to your Interactive Object, you must redefine two virtual methods: Type and Signature. This filter is only used in an open local contexts. In the Collector viewer, you can only locate Interactive Objects which answer positively to the positioned filters when a local context is open. Warning Some signatures have already been used by standard objects delivered in AIS. These include: - signature 0 - Shape - signature 1 - Point - signature 2 - Axis - signature 3 - Trihedron - signature 4 - PlaneTrihedron - signature 5 - Line - signature 6 - Circle - signature 7 - PlaneSelects Interactive Objects through their signatures and types. The signature provides an additional characterization of an object's type, and takes the form of an index. The filter questions each Interactive Object in local context to determine whether it has an non-null owner, and if so, whether it has the desired signature. If the object returns true in each case, it is kept. If not, it is rejected. By default, the interactive object has a None type and a signature of 0. If you want to give a particular type and signature to your Interactive Object, you must redefine two virtual methods: Type and Signature. This filter is only used in an open local contexts. In the Collector viewer, you can only locate Interactive Objects which answer positively to the positioned filters when a local context is open. Warning Some signatures have already been used by standard objects delivered in AIS. These include: - signature 0 - Shape - signature 1 - Point - signature 2 - Axis - signature 3 - Trihedron - signature 4 - PlaneTrihedron - signature 5 - Line - signature 6 - Circle - signature 7 - PlaneSelects Interactive Objects through their signatures and types. The signature provides an additional characterization of an object's type, and takes the form of an index. The filter questions each Interactive Object in local context to determine whether it has an non-null owner, and if so, whether it has the desired signature. If the object returns true in each case, it is kept. If not, it is rejected. By default, the interactive object has a None type and a signature of 0. If you want to give a particular type and signature to your Interactive Object, you must redefine two virtual methods: Type and Signature. This filter is only used in an open local contexts. In the Collector viewer, you can only locate Interactive Objects which answer positively to the positioned filters when a local context is open. Warning Some signatures have already been used by standard objects delivered in AIS. These include: - signature 0 - Shape - signature 1 - Point - signature 2 - Axis - signature 3 - Trihedron - signature 4 - PlaneTrihedron - signature 5 - Line - signature 6 - Circle - signature 7 - Plane
    """
    def ActsOn(self,aStandardMode : OCP.TopAbs.TopAbs_ShapeEnum) -> bool: 
        """
        Returns true in an AIS local context, if this filter operates on a type of subshape defined in a filter class inheriting this framework. This function completes IsOk in an AIS local context.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: 
        """
        None
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theTypeName : str) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: ...
    def IsOk(self,anobj : OCP.SelectMgr.SelectMgr_EntityOwner) -> bool: 
        """
        Returns False if the transient is not an AIS_InteractiveObject. Returns False if the signature of InteractiveObject is not the same as the stored one in the filter...
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self,aGivenKind : AIS_KindOfInteractive,aGivenSignature : int) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: 
        """
        None
        """
    @staticmethod
    def get_type_name_s() -> str: 
        """
        None
        """
    pass
class AIS_TypeOfAttribute():
    """
    None

    Members:

      AIS_TOA_Line

      AIS_TOA_Dimension

      AIS_TOA_Wire

      AIS_TOA_Plane

      AIS_TOA_Vector

      AIS_TOA_UIso

      AIS_TOA_VIso

      AIS_TOA_Free

      AIS_TOA_UnFree

      AIS_TOA_Section

      AIS_TOA_Hidden

      AIS_TOA_Seen

      AIS_TOA_FaceBoundary

      AIS_TOA_FirstAxis

      AIS_TOA_SecondAxis

      AIS_TOA_ThirdAxis
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    AIS_TOA_Dimension: OCP.AIS.AIS_TypeOfAttribute # value = <AIS_TypeOfAttribute.AIS_TOA_Dimension: 1>
    AIS_TOA_FaceBoundary: OCP.AIS.AIS_TypeOfAttribute # value = <AIS_TypeOfAttribute.AIS_TOA_FaceBoundary: 12>
    AIS_TOA_FirstAxis: OCP.AIS.AIS_TypeOfAttribute # value = <AIS_TypeOfAttribute.AIS_TOA_FirstAxis: 13>
    AIS_TOA_Free: OCP.AIS.AIS_TypeOfAttribute # value = <AIS_TypeOfAttribute.AIS_TOA_Free: 7>
    AIS_TOA_Hidden: OCP.AIS.AIS_TypeOfAttribute # value = <AIS_TypeOfAttribute.AIS_TOA_Hidden: 10>
    AIS_TOA_Line: OCP.AIS.AIS_TypeOfAttribute # value = <AIS_TypeOfAttribute.AIS_TOA_Line: 0>
    AIS_TOA_Plane: OCP.AIS.AIS_TypeOfAttribute # value = <AIS_TypeOfAttribute.AIS_TOA_Plane: 3>
    AIS_TOA_SecondAxis: OCP.AIS.AIS_TypeOfAttribute # value = <AIS_TypeOfAttribute.AIS_TOA_SecondAxis: 14>
    AIS_TOA_Section: OCP.AIS.AIS_TypeOfAttribute # value = <AIS_TypeOfAttribute.AIS_TOA_Section: 9>
    AIS_TOA_Seen: OCP.AIS.AIS_TypeOfAttribute # value = <AIS_TypeOfAttribute.AIS_TOA_Seen: 11>
    AIS_TOA_ThirdAxis: OCP.AIS.AIS_TypeOfAttribute # value = <AIS_TypeOfAttribute.AIS_TOA_ThirdAxis: 15>
    AIS_TOA_UIso: OCP.AIS.AIS_TypeOfAttribute # value = <AIS_TypeOfAttribute.AIS_TOA_UIso: 5>
    AIS_TOA_UnFree: OCP.AIS.AIS_TypeOfAttribute # value = <AIS_TypeOfAttribute.AIS_TOA_UnFree: 8>
    AIS_TOA_VIso: OCP.AIS.AIS_TypeOfAttribute # value = <AIS_TypeOfAttribute.AIS_TOA_VIso: 6>
    AIS_TOA_Vector: OCP.AIS.AIS_TypeOfAttribute # value = <AIS_TypeOfAttribute.AIS_TOA_Vector: 4>
    AIS_TOA_Wire: OCP.AIS.AIS_TypeOfAttribute # value = <AIS_TypeOfAttribute.AIS_TOA_Wire: 2>
    __entries: dict # value = {'AIS_TOA_Line': (<AIS_TypeOfAttribute.AIS_TOA_Line: 0>, None), 'AIS_TOA_Dimension': (<AIS_TypeOfAttribute.AIS_TOA_Dimension: 1>, None), 'AIS_TOA_Wire': (<AIS_TypeOfAttribute.AIS_TOA_Wire: 2>, None), 'AIS_TOA_Plane': (<AIS_TypeOfAttribute.AIS_TOA_Plane: 3>, None), 'AIS_TOA_Vector': (<AIS_TypeOfAttribute.AIS_TOA_Vector: 4>, None), 'AIS_TOA_UIso': (<AIS_TypeOfAttribute.AIS_TOA_UIso: 5>, None), 'AIS_TOA_VIso': (<AIS_TypeOfAttribute.AIS_TOA_VIso: 6>, None), 'AIS_TOA_Free': (<AIS_TypeOfAttribute.AIS_TOA_Free: 7>, None), 'AIS_TOA_UnFree': (<AIS_TypeOfAttribute.AIS_TOA_UnFree: 8>, None), 'AIS_TOA_Section': (<AIS_TypeOfAttribute.AIS_TOA_Section: 9>, None), 'AIS_TOA_Hidden': (<AIS_TypeOfAttribute.AIS_TOA_Hidden: 10>, None), 'AIS_TOA_Seen': (<AIS_TypeOfAttribute.AIS_TOA_Seen: 11>, None), 'AIS_TOA_FaceBoundary': (<AIS_TypeOfAttribute.AIS_TOA_FaceBoundary: 12>, None), 'AIS_TOA_FirstAxis': (<AIS_TypeOfAttribute.AIS_TOA_FirstAxis: 13>, None), 'AIS_TOA_SecondAxis': (<AIS_TypeOfAttribute.AIS_TOA_SecondAxis: 14>, None), 'AIS_TOA_ThirdAxis': (<AIS_TypeOfAttribute.AIS_TOA_ThirdAxis: 15>, None)}
    __members__: dict # value = {'AIS_TOA_Line': <AIS_TypeOfAttribute.AIS_TOA_Line: 0>, 'AIS_TOA_Dimension': <AIS_TypeOfAttribute.AIS_TOA_Dimension: 1>, 'AIS_TOA_Wire': <AIS_TypeOfAttribute.AIS_TOA_Wire: 2>, 'AIS_TOA_Plane': <AIS_TypeOfAttribute.AIS_TOA_Plane: 3>, 'AIS_TOA_Vector': <AIS_TypeOfAttribute.AIS_TOA_Vector: 4>, 'AIS_TOA_UIso': <AIS_TypeOfAttribute.AIS_TOA_UIso: 5>, 'AIS_TOA_VIso': <AIS_TypeOfAttribute.AIS_TOA_VIso: 6>, 'AIS_TOA_Free': <AIS_TypeOfAttribute.AIS_TOA_Free: 7>, 'AIS_TOA_UnFree': <AIS_TypeOfAttribute.AIS_TOA_UnFree: 8>, 'AIS_TOA_Section': <AIS_TypeOfAttribute.AIS_TOA_Section: 9>, 'AIS_TOA_Hidden': <AIS_TypeOfAttribute.AIS_TOA_Hidden: 10>, 'AIS_TOA_Seen': <AIS_TypeOfAttribute.AIS_TOA_Seen: 11>, 'AIS_TOA_FaceBoundary': <AIS_TypeOfAttribute.AIS_TOA_FaceBoundary: 12>, 'AIS_TOA_FirstAxis': <AIS_TypeOfAttribute.AIS_TOA_FirstAxis: 13>, 'AIS_TOA_SecondAxis': <AIS_TypeOfAttribute.AIS_TOA_SecondAxis: 14>, 'AIS_TOA_ThirdAxis': <AIS_TypeOfAttribute.AIS_TOA_ThirdAxis: 15>}
    pass
class AIS_TypeOfAxis():
    """
    Declares the type of axis.

    Members:

      AIS_TOAX_Unknown

      AIS_TOAX_XAxis

      AIS_TOAX_YAxis

      AIS_TOAX_ZAxis
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    AIS_TOAX_Unknown: OCP.AIS.AIS_TypeOfAxis # value = <AIS_TypeOfAxis.AIS_TOAX_Unknown: 0>
    AIS_TOAX_XAxis: OCP.AIS.AIS_TypeOfAxis # value = <AIS_TypeOfAxis.AIS_TOAX_XAxis: 1>
    AIS_TOAX_YAxis: OCP.AIS.AIS_TypeOfAxis # value = <AIS_TypeOfAxis.AIS_TOAX_YAxis: 2>
    AIS_TOAX_ZAxis: OCP.AIS.AIS_TypeOfAxis # value = <AIS_TypeOfAxis.AIS_TOAX_ZAxis: 3>
    __entries: dict # value = {'AIS_TOAX_Unknown': (<AIS_TypeOfAxis.AIS_TOAX_Unknown: 0>, None), 'AIS_TOAX_XAxis': (<AIS_TypeOfAxis.AIS_TOAX_XAxis: 1>, None), 'AIS_TOAX_YAxis': (<AIS_TypeOfAxis.AIS_TOAX_YAxis: 2>, None), 'AIS_TOAX_ZAxis': (<AIS_TypeOfAxis.AIS_TOAX_ZAxis: 3>, None)}
    __members__: dict # value = {'AIS_TOAX_Unknown': <AIS_TypeOfAxis.AIS_TOAX_Unknown: 0>, 'AIS_TOAX_XAxis': <AIS_TypeOfAxis.AIS_TOAX_XAxis: 1>, 'AIS_TOAX_YAxis': <AIS_TypeOfAxis.AIS_TOAX_YAxis: 2>, 'AIS_TOAX_ZAxis': <AIS_TypeOfAxis.AIS_TOAX_ZAxis: 3>}
    pass
class AIS_TypeOfIso():
    """
    Declares the type of isoparameter displayed.

    Members:

      AIS_TOI_IsoU

      AIS_TOI_IsoV

      AIS_TOI_Both
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    AIS_TOI_Both: OCP.AIS.AIS_TypeOfIso # value = <AIS_TypeOfIso.AIS_TOI_Both: 2>
    AIS_TOI_IsoU: OCP.AIS.AIS_TypeOfIso # value = <AIS_TypeOfIso.AIS_TOI_IsoU: 0>
    AIS_TOI_IsoV: OCP.AIS.AIS_TypeOfIso # value = <AIS_TypeOfIso.AIS_TOI_IsoV: 1>
    __entries: dict # value = {'AIS_TOI_IsoU': (<AIS_TypeOfIso.AIS_TOI_IsoU: 0>, None), 'AIS_TOI_IsoV': (<AIS_TypeOfIso.AIS_TOI_IsoV: 1>, None), 'AIS_TOI_Both': (<AIS_TypeOfIso.AIS_TOI_Both: 2>, None)}
    __members__: dict # value = {'AIS_TOI_IsoU': <AIS_TypeOfIso.AIS_TOI_IsoU: 0>, 'AIS_TOI_IsoV': <AIS_TypeOfIso.AIS_TOI_IsoV: 1>, 'AIS_TOI_Both': <AIS_TypeOfIso.AIS_TOI_Both: 2>}
    pass
class AIS_TypeOfPlane():
    """
    Declares the type of plane.

    Members:

      AIS_TOPL_Unknown

      AIS_TOPL_XYPlane

      AIS_TOPL_XZPlane

      AIS_TOPL_YZPlane
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    AIS_TOPL_Unknown: OCP.AIS.AIS_TypeOfPlane # value = <AIS_TypeOfPlane.AIS_TOPL_Unknown: 0>
    AIS_TOPL_XYPlane: OCP.AIS.AIS_TypeOfPlane # value = <AIS_TypeOfPlane.AIS_TOPL_XYPlane: 1>
    AIS_TOPL_XZPlane: OCP.AIS.AIS_TypeOfPlane # value = <AIS_TypeOfPlane.AIS_TOPL_XZPlane: 2>
    AIS_TOPL_YZPlane: OCP.AIS.AIS_TypeOfPlane # value = <AIS_TypeOfPlane.AIS_TOPL_YZPlane: 3>
    __entries: dict # value = {'AIS_TOPL_Unknown': (<AIS_TypeOfPlane.AIS_TOPL_Unknown: 0>, None), 'AIS_TOPL_XYPlane': (<AIS_TypeOfPlane.AIS_TOPL_XYPlane: 1>, None), 'AIS_TOPL_XZPlane': (<AIS_TypeOfPlane.AIS_TOPL_XZPlane: 2>, None), 'AIS_TOPL_YZPlane': (<AIS_TypeOfPlane.AIS_TOPL_YZPlane: 3>, None)}
    __members__: dict # value = {'AIS_TOPL_Unknown': <AIS_TypeOfPlane.AIS_TOPL_Unknown: 0>, 'AIS_TOPL_XYPlane': <AIS_TypeOfPlane.AIS_TOPL_XYPlane: 1>, 'AIS_TOPL_XZPlane': <AIS_TypeOfPlane.AIS_TOPL_XZPlane: 2>, 'AIS_TOPL_YZPlane': <AIS_TypeOfPlane.AIS_TOPL_YZPlane: 3>}
    pass
class AIS_ViewController(OCP.Aspect.Aspect_WindowInputListener):
    """
    Auxiliary structure for handling viewer events between GUI and Rendering threads.
    """
    def AbortViewAnimation(self) -> None: 
        """
        Interrupt active view animation.
        """
    def AddTouchPoint(self,theId : int,thePnt : OCP.Graphic3d.Graphic3d_Vec2d,theClearBefore : bool=False) -> None: 
        """
        Add touch point with the given ID. This method is expected to be called from UI thread.
        """
    def Change3dMouseIsNoRotate(self) -> Any: 
        """
        Return 3d mouse rotation axes (tilt/roll/spin) ignore flag; (FALSE, FALSE, FALSE) by default.
        """
    def Change3dMouseToReverse(self) -> Any: 
        """
        Return 3d mouse rotation axes (tilt/roll/spin) reverse flag; (TRUE, FALSE, FALSE) by default.
        """
    def ChangeInputBuffer(self,theType : AIS_ViewInputBufferType) -> AIS_ViewInputBuffer: 
        """
        Return input buffer.
        """
    def ChangeKeys(self) -> Aspect_VKeySet: 
        """
        Return keyboard state.
        """
    def ChangeMouseGestureMap(self) -> AIS_MouseGestureMap: 
        """
        Return map defining mouse gestures.
        """
    def ChangeMouseSelectionSchemes(self) -> AIS_MouseSelectionSchemeMap: 
        """
        Return map defining mouse gestures.
        """
    def EventTime(self) -> float: 
        """
        Return event time (e.g. current time).
        """
    def FetchNavigationKeys(self,theCrouchRatio : float,theRunRatio : float) -> AIS_WalkDelta: 
        """
        Fetch active navigation actions.
        """
    def FitAllAuto(self,theCtx : AIS_InteractiveContext,theView : OCP.V3d.V3d_View) -> None: 
        """
        Modify view camera to fit all objects. Default implementation fits either all visible and all selected objects (swapped on each call).
        """
    def FlushViewEvents(self,theCtx : AIS_InteractiveContext,theView : OCP.V3d.V3d_View,theToHandle : bool=False) -> None: 
        """
        Update buffer for rendering thread. This method is expected to be called within synchronization barrier between GUI and Rendering threads (e.g. GUI thread should be locked beforehand to avoid data races).
        """
    def Get3dMouseIsNoRotate(self) -> Any: 
        """
        Return 3d mouse rotation axes (tilt/roll/spin) ignore flag; (FALSE, FALSE, FALSE) by default.
        """
    def Get3dMouseRotationScale(self) -> float: 
        """
        Return acceleration ratio for rotation event; 4.0 by default.
        """
    def Get3dMouseToReverse(self) -> Any: 
        """
        Return 3d mouse rotation axes (tilt/roll/spin) reverse flag; (TRUE, FALSE, FALSE) by default.
        """
    def Get3dMouseTranslationScale(self) -> float: 
        """
        Return acceleration ratio for translation event; 2.0 by default.
        """
    def GravityPoint(self,theCtx : AIS_InteractiveContext,theView : OCP.V3d.V3d_View) -> OCP.gp.gp_Pnt: 
        """
        Compute rotation gravity center point depending on rotation mode. This method is expected to be called from rendering thread.
        """
    def HandleViewEvents(self,theCtx : AIS_InteractiveContext,theView : OCP.V3d.V3d_View) -> None: 
        """
        Process events within rendering thread.
        """
    def HasPreviousMoveTo(self) -> bool: 
        """
        Return TRUE if previous position of MoveTo has been defined.
        """
    def HasTouchPoints(self) -> bool: 
        """
        Return TRUE if touches map is not empty.
        """
    def InputBuffer(self,theType : AIS_ViewInputBufferType) -> AIS_ViewInputBuffer: 
        """
        Return input buffer.
        """
    def IsContinuousRedraw(self) -> bool: 
        """
        Return TRUE if continuous redrawing is enabled; FALSE by default. This option would request a next viewer frame to be completely redrawn right after current frame is finished.
        """
    def KeyDown(self,theKey : int,theTime : float,thePressure : float=1.0) -> None: 
        """
        Press key. Default implementation updates internal cache.
        """
    def KeyFromAxis(self,theNegative : int,thePositive : int,theTime : float,thePressure : float) -> None: 
        """
        Simulate key up/down events from axis value. Default implementation updates internal cache.
        """
    def KeyUp(self