# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
from typing import Any, AsyncIterator, Callable, Dict, IO, Optional, TypeVar, Union, cast, overload
import urllib.parse

from azure.core import AsyncPipelineClient
from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    StreamClosedError,
    StreamConsumedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.async_arm_polling import AsyncARMPolling

from ... import models as _models
from ..._utils.serialization import Deserializer, Serializer
from ...operations._deployment_stacks_operations import (
    build_create_or_update_at_management_group_request,
    build_create_or_update_at_resource_group_request,
    build_create_or_update_at_subscription_request,
    build_delete_at_management_group_request,
    build_delete_at_resource_group_request,
    build_delete_at_subscription_request,
    build_export_template_at_management_group_request,
    build_export_template_at_resource_group_request,
    build_export_template_at_subscription_request,
    build_get_at_management_group_request,
    build_get_at_resource_group_request,
    build_get_at_subscription_request,
    build_list_at_management_group_request,
    build_list_at_resource_group_request,
    build_list_at_subscription_request,
    build_validate_stack_at_management_group_request,
    build_validate_stack_at_resource_group_request,
    build_validate_stack_at_subscription_request,
)
from .._configuration import DeploymentStacksClientConfiguration

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class DeploymentStacksOperations:  # pylint: disable=too-many-public-methods
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.resource.deploymentstacks.aio.DeploymentStacksClient`'s
        :attr:`deployment_stacks` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: DeploymentStacksClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list_at_resource_group(
        self, resource_group_name: str, **kwargs: Any
    ) -> AsyncItemPaged["_models.DeploymentStack"]:
        """Lists all the Deployment stacks within the specified Resource Group.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :return: An iterator like instance of either DeploymentStack or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.resource.deploymentstacks.models.DeploymentStack]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.DeploymentStackListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_at_resource_group_request(
                    resource_group_name=resource_group_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DeploymentStackListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DeploymentStacksError, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_at_subscription(self, **kwargs: Any) -> AsyncItemPaged["_models.DeploymentStack"]:
        """Lists all the Deployment stacks within the specified Subscription.

        :return: An iterator like instance of either DeploymentStack or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.resource.deploymentstacks.models.DeploymentStack]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.DeploymentStackListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_at_subscription_request(
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DeploymentStackListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DeploymentStacksError, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_at_management_group(
        self, management_group_id: str, **kwargs: Any
    ) -> AsyncItemPaged["_models.DeploymentStack"]:
        """Lists all the Deployment stacks within the specified Management Group.

        :param management_group_id: Management Group id. Required.
        :type management_group_id: str
        :return: An iterator like instance of either DeploymentStack or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.resource.deploymentstacks.models.DeploymentStack]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.DeploymentStackListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_at_management_group_request(
                    management_group_id=management_group_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DeploymentStackListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DeploymentStacksError, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    async def _create_or_update_at_resource_group_initial(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        deployment_stack_name: str,
        deployment_stack: Union[_models.DeploymentStack, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(deployment_stack, (IOBase, bytes)):
            _content = deployment_stack
        else:
            _json = self._serialize.body(deployment_stack, "DeploymentStack")

        _request = build_create_or_update_at_resource_group_request(
            resource_group_name=resource_group_name,
            deployment_stack_name=deployment_stack_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DeploymentStacksError, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_or_update_at_resource_group(
        self,
        resource_group_name: str,
        deployment_stack_name: str,
        deployment_stack: _models.DeploymentStack,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.DeploymentStack]:
        """Creates or updates a Deployment stack at Resource Group scope.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param deployment_stack_name: Name of the deployment stack. Required.
        :type deployment_stack_name: str
        :param deployment_stack: Deployment stack supplied to the operation. Required.
        :type deployment_stack: ~azure.mgmt.resource.deploymentstacks.models.DeploymentStack
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either DeploymentStack or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.resource.deploymentstacks.models.DeploymentStack]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_update_at_resource_group(
        self,
        resource_group_name: str,
        deployment_stack_name: str,
        deployment_stack: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.DeploymentStack]:
        """Creates or updates a Deployment stack at Resource Group scope.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param deployment_stack_name: Name of the deployment stack. Required.
        :type deployment_stack_name: str
        :param deployment_stack: Deployment stack supplied to the operation. Required.
        :type deployment_stack: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either DeploymentStack or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.resource.deploymentstacks.models.DeploymentStack]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_or_update_at_resource_group(
        self,
        resource_group_name: str,
        deployment_stack_name: str,
        deployment_stack: Union[_models.DeploymentStack, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.DeploymentStack]:
        """Creates or updates a Deployment stack at Resource Group scope.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param deployment_stack_name: Name of the deployment stack. Required.
        :type deployment_stack_name: str
        :param deployment_stack: Deployment stack supplied to the operation. Is either a
         DeploymentStack type or a IO[bytes] type. Required.
        :type deployment_stack: ~azure.mgmt.resource.deploymentstacks.models.DeploymentStack or
         IO[bytes]
        :return: An instance of AsyncLROPoller that returns either DeploymentStack or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.resource.deploymentstacks.models.DeploymentStack]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.DeploymentStack] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_at_resource_group_initial(
                resource_group_name=resource_group_name,
                deployment_stack_name=deployment_stack_name,
                deployment_stack=deployment_stack,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("DeploymentStack", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncARMPolling(lro_delay, lro_options={"final-state-via": "azure-async-operation"}, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.DeploymentStack].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.DeploymentStack](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace_async
    async def get_at_resource_group(
        self, resource_group_name: str, deployment_stack_name: str, **kwargs: Any
    ) -> _models.DeploymentStack:
        """Gets a Deployment stack with a given name at Resource Group scope.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param deployment_stack_name: Name of the deployment stack. Required.
        :type deployment_stack_name: str
        :return: DeploymentStack or the result of cls(response)
        :rtype: ~azure.mgmt.resource.deploymentstacks.models.DeploymentStack
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.DeploymentStack] = kwargs.pop("cls", None)

        _request = build_get_at_resource_group_request(
            resource_group_name=resource_group_name,
            deployment_stack_name=deployment_stack_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DeploymentStacksError, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DeploymentStack", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _delete_at_resource_group_initial(
        self,
        resource_group_name: str,
        deployment_stack_name: str,
        unmanage_action_resources: Optional[Union[str, _models.UnmanageActionResourceMode]] = None,
        unmanage_action_resource_groups: Optional[Union[str, _models.UnmanageActionResourceGroupMode]] = None,
        unmanage_action_management_groups: Optional[Union[str, _models.UnmanageActionManagementGroupMode]] = None,
        bypass_stack_out_of_sync_error: Optional[bool] = None,
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_delete_at_resource_group_request(
            resource_group_name=resource_group_name,
            deployment_stack_name=deployment_stack_name,
            subscription_id=self._config.subscription_id,
            unmanage_action_resources=unmanage_action_resources,
            unmanage_action_resource_groups=unmanage_action_resource_groups,
            unmanage_action_management_groups=unmanage_action_management_groups,
            bypass_stack_out_of_sync_error=bypass_stack_out_of_sync_error,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 204]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DeploymentStacksError, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_delete_at_resource_group(
        self,
        resource_group_name: str,
        deployment_stack_name: str,
        unmanage_action_resources: Optional[Union[str, _models.UnmanageActionResourceMode]] = None,
        unmanage_action_resource_groups: Optional[Union[str, _models.UnmanageActionResourceGroupMode]] = None,
        unmanage_action_management_groups: Optional[Union[str, _models.UnmanageActionManagementGroupMode]] = None,
        bypass_stack_out_of_sync_error: Optional[bool] = None,
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes a Deployment stack by name at Resource Group scope. When operation completes, status
        code 200 returned without content.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param deployment_stack_name: Name of the deployment stack. Required.
        :type deployment_stack_name: str
        :param unmanage_action_resources: Flag to indicate delete rather than detach for unmanaged
         resources. Known values are: "delete" and "detach". Default value is None.
        :type unmanage_action_resources: str or
         ~azure.mgmt.resource.deploymentstacks.models.UnmanageActionResourceMode
        :param unmanage_action_resource_groups: Flag to indicate delete rather than detach for
         unmanaged resource groups. Known values are: "delete" and "detach". Default value is None.
        :type unmanage_action_resource_groups: str or
         ~azure.mgmt.resource.deploymentstacks.models.UnmanageActionResourceGroupMode
        :param unmanage_action_management_groups: Flag to indicate delete rather than detach for
         unmanaged management groups. Known values are: "delete" and "detach". Default value is None.
        :type unmanage_action_management_groups: str or
         ~azure.mgmt.resource.deploymentstacks.models.UnmanageActionManagementGroupMode
        :param bypass_stack_out_of_sync_error: Flag to bypass service errors that indicate the stack
         resource list is not correctly synchronized. Default value is None.
        :type bypass_stack_out_of_sync_error: bool
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_at_resource_group_initial(
                resource_group_name=resource_group_name,
                deployment_stack_name=deployment_stack_name,
                unmanage_action_resources=unmanage_action_resources,
                unmanage_action_resource_groups=unmanage_action_resource_groups,
                unmanage_action_management_groups=unmanage_action_management_groups,
                bypass_stack_out_of_sync_error=bypass_stack_out_of_sync_error,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    async def _create_or_update_at_subscription_initial(  # pylint: disable=name-too-long
        self, deployment_stack_name: str, deployment_stack: Union[_models.DeploymentStack, IO[bytes]], **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(deployment_stack, (IOBase, bytes)):
            _content = deployment_stack
        else:
            _json = self._serialize.body(deployment_stack, "DeploymentStack")

        _request = build_create_or_update_at_subscription_request(
            deployment_stack_name=deployment_stack_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DeploymentStacksError, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_or_update_at_subscription(
        self,
        deployment_stack_name: str,
        deployment_stack: _models.DeploymentStack,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.DeploymentStack]:
        """Creates or updates a Deployment stack at Subscription scope.

        :param deployment_stack_name: Name of the deployment stack. Required.
        :type deployment_stack_name: str
        :param deployment_stack: Deployment stack supplied to the operation. Required.
        :type deployment_stack: ~azure.mgmt.resource.deploymentstacks.models.DeploymentStack
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either DeploymentStack or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.resource.deploymentstacks.models.DeploymentStack]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_update_at_subscription(
        self,
        deployment_stack_name: str,
        deployment_stack: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.DeploymentStack]:
        """Creates or updates a Deployment stack at Subscription scope.

        :param deployment_stack_name: Name of the deployment stack. Required.
        :type deployment_stack_name: str
        :param deployment_stack: Deployment stack supplied to the operation. Required.
        :type deployment_stack: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either DeploymentStack or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.resource.deploymentstacks.models.DeploymentStack]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_or_update_at_subscription(
        self, deployment_stack_name: str, deployment_stack: Union[_models.DeploymentStack, IO[bytes]], **kwargs: Any
    ) -> AsyncLROPoller[_models.DeploymentStack]:
        """Creates or updates a Deployment stack at Subscription scope.

        :param deployment_stack_name: Name of the deployment stack. Required.
        :type deployment_stack_name: str
        :param deployment_stack: Deployment stack supplied to the operation. Is either a
         DeploymentStack type or a IO[bytes] type. Required.
        :type deployment_stack: ~azure.mgmt.resource.deploymentstacks.models.DeploymentStack or
         IO[bytes]
        :return: An instance of AsyncLROPoller that returns either DeploymentStack or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.resource.deploymentstacks.models.DeploymentStack]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.DeploymentStack] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_at_subscription_initial(
                deployment_stack_name=deployment_stack_name,
                deployment_stack=deployment_stack,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("DeploymentStack", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncARMPolling(lro_delay, lro_options={"final-state-via": "azure-async-operation"}, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.DeploymentStack].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.DeploymentStack](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace_async
    async def get_at_subscription(self, deployment_stack_name: str, **kwargs: Any) -> _models.DeploymentStack:
        """Gets a Deployment stack with a given name at Subscription scope.

        :param deployment_stack_name: Name of the deployment stack. Required.
        :type deployment_stack_name: str
        :return: DeploymentStack or the result of cls(response)
        :rtype: ~azure.mgmt.resource.deploymentstacks.models.DeploymentStack
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.DeploymentStack] = kwargs.pop("cls", None)

        _request = build_get_at_subscription_request(
            deployment_stack_name=deployment_stack_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DeploymentStacksError, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DeploymentStack", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _delete_at_subscription_initial(
        self,
        deployment_stack_name: str,
        unmanage_action_resources: Optional[Union[str, _models.UnmanageActionResourceMode]] = None,
        unmanage_action_resource_groups: Optional[Union[str, _models.UnmanageActionResourceGroupMode]] = None,
        unmanage_action_management_groups: Optional[Union[str, _models.UnmanageActionManagementGroupMode]] = None,
        bypass_stack_out_of_sync_error: Optional[bool] = None,
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_delete_at_subscription_request(
            deployment_stack_name=deployment_stack_name,
            subscription_id=self._config.subscription_id,
            unmanage_action_resources=unmanage_action_resources,
            unmanage_action_resource_groups=unmanage_action_resource_groups,
            unmanage_action_management_groups=unmanage_action_management_groups,
            bypass_stack_out_of_sync_error=bypass_stack_out_of_sync_error,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 204]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DeploymentStacksError, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_delete_at_subscription(
        self,
        deployment_stack_name: str,
        unmanage_action_resources: Optional[Union[str, _models.UnmanageActionResourceMode]] = None,
        unmanage_action_resource_groups: Optional[Union[str, _models.UnmanageActionResourceGroupMode]] = None,
        unmanage_action_management_groups: Optional[Union[str, _models.UnmanageActionManagementGroupMode]] = None,
        bypass_stack_out_of_sync_error: Optional[bool] = None,
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes a Deployment stack by name at Subscription scope. When operation completes, status code
        200 returned without content.

        :param deployment_stack_name: Name of the deployment stack. Required.
        :type deployment_stack_name: str
        :param unmanage_action_resources: Flag to indicate delete rather than detach for unmanaged
         resources. Known values are: "delete" and "detach". Default value is None.
        :type unmanage_action_resources: str or
         ~azure.mgmt.resource.deploymentstacks.models.UnmanageActionResourceMode
        :param unmanage_action_resource_groups: Flag to indicate delete rather than detach for
         unmanaged resource groups. Known values are: "delete" and "detach". Default value is None.
        :type unmanage_action_resource_groups: str or
         ~azure.mgmt.resource.deploymentstacks.models.UnmanageActionResourceGroupMode
        :param unmanage_action_management_groups: Flag to indicate delete rather than detach for
         unmanaged management groups. Known values are: "delete" and "detach". Default value is None.
        :type unmanage_action_management_groups: str or
         ~azure.mgmt.resource.deploymentstacks.models.UnmanageActionManagementGroupMode
        :param bypass_stack_out_of_sync_error: Flag to bypass service errors that indicate the stack
         resource list is not correctly synchronized. Default value is None.
        :type bypass_stack_out_of_sync_error: bool
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_at_subscription_initial(
                deployment_stack_name=deployment_stack_name,
                unmanage_action_resources=unmanage_action_resources,
                unmanage_action_resource_groups=unmanage_action_resource_groups,
                unmanage_action_management_groups=unmanage_action_management_groups,
                bypass_stack_out_of_sync_error=bypass_stack_out_of_sync_error,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    async def _create_or_update_at_management_group_initial(  # pylint: disable=name-too-long
        self,
        management_group_id: str,
        deployment_stack_name: str,
        deployment_stack: Union[_models.DeploymentStack, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(deployment_stack, (IOBase, bytes)):
            _content = deployment_stack
        else:
            _json = self._serialize.body(deployment_stack, "DeploymentStack")

        _request = build_create_or_update_at_management_group_request(
            management_group_id=management_group_id,
            deployment_stack_name=deployment_stack_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DeploymentStacksError, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_or_update_at_management_group(  # pylint: disable=name-too-long
        self,
        management_group_id: str,
        deployment_stack_name: str,
        deployment_stack: _models.DeploymentStack,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.DeploymentStack]:
        """Creates or updates a Deployment stack at Management Group scope.

        :param management_group_id: Management Group id. Required.
        :type management_group_id: str
        :param deployment_stack_name: Name of the deployment stack. Required.
        :type deployment_stack_name: str
        :param deployment_stack: Deployment stack supplied to the operation. Required.
        :type deployment_stack: ~azure.mgmt.resource.deploymentstacks.models.DeploymentStack
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either DeploymentStack or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.resource.deploymentstacks.models.DeploymentStack]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_update_at_management_group(  # pylint: disable=name-too-long
        self,
        management_group_id: str,
        deployment_stack_name: str,
        deployment_stack: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.DeploymentStack]:
        """Creates or updates a Deployment stack at Management Group scope.

        :param management_group_id: Management Group id. Required.
        :type management_group_id: str
        :param deployment_stack_name: Name of the deployment stack. Required.
        :type deployment_stack_name: str
        :param deployment_stack: Deployment stack supplied to the operation. Required.
        :type deployment_stack: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either DeploymentStack or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.resource.deploymentstacks.models.DeploymentStack]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_or_update_at_management_group(  # pylint: disable=name-too-long
        self,
        management_group_id: str,
        deployment_stack_name: str,
        deployment_stack: Union[_models.DeploymentStack, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.DeploymentStack]:
        """Creates or updates a Deployment stack at Management Group scope.

        :param management_group_id: Management Group id. Required.
        :type management_group_id: str
        :param deployment_stack_name: Name of the deployment stack. Required.
        :type deployment_stack_name: str
        :param deployment_stack: Deployment stack supplied to the operation. Is either a
         DeploymentStack type or a IO[bytes] type. Required.
        :type deployment_stack: ~azure.mgmt.resource.deploymentstacks.models.DeploymentStack or
         IO[bytes]
        :return: An instance of AsyncLROPoller that returns either DeploymentStack or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.resource.deploymentstacks.models.DeploymentStack]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.DeploymentStack] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_at_management_group_initial(
                management_group_id=management_group_id,
                deployment_stack_name=deployment_stack_name,
                deployment_stack=deployment_stack,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("DeploymentStack", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncARMPolling(lro_delay, lro_options={"final-state-via": "azure-async-operation"}, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.DeploymentStack].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.DeploymentStack](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace_async
    async def get_at_management_group(
        self, management_group_id: str, deployment_stack_name: str, **kwargs: Any
    ) -> _models.DeploymentStack:
        """Gets a Deployment stack with a given name at Management Group scope.

        :param management_group_id: Management Group id. Required.
        :type management_group_id: str
        :param deployment_stack_name: Name of the deployment stack. Required.
        :type deployment_stack_name: str
        :return: DeploymentStack or the result of cls(response)
        :rtype: ~azure.mgmt.resource.deploymentstacks.models.DeploymentStack
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.DeploymentStack] = kwargs.pop("cls", None)

        _request = build_get_at_management_group_request(
            management_group_id=management_group_id,
            deployment_stack_name=deployment_stack_name,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DeploymentStacksError, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DeploymentStack", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _delete_at_management_group_initial(
        self,
        management_group_id: str,
        deployment_stack_name: str,
        unmanage_action_resources: Optional[Union[str, _models.UnmanageActionResourceMode]] = None,
        unmanage_action_resource_groups: Optional[Union[str, _models.UnmanageActionResourceGroupMode]] = None,
        unmanage_action_management_groups: Optional[Union[str, _models.UnmanageActionManagementGroupMode]] = None,
        bypass_stack_out_of_sync_error: Optional[bool] = None,
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_delete_at_management_group_request(
            management_group_id=management_group_id,
            deployment_stack_name=deployment_stack_name,
            unmanage_action_resources=unmanage_action_resources,
            unmanage_action_resource_groups=unmanage_action_resource_groups,
            unmanage_action_management_groups=unmanage_action_management_groups,
            bypass_stack_out_of_sync_error=bypass_stack_out_of_sync_error,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 204]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DeploymentStacksError, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_delete_at_management_group(
        self,
        management_group_id: str,
        deployment_stack_name: str,
        unmanage_action_resources: Optional[Union[str, _models.UnmanageActionResourceMode]] = None,
        unmanage_action_resource_groups: Optional[Union[str, _models.UnmanageActionResourceGroupMode]] = None,
        unmanage_action_management_groups: Optional[Union[str, _models.UnmanageActionManagementGroupMode]] = None,
        bypass_stack_out_of_sync_error: Optional[bool] = None,
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes a Deployment stack by name at Management Group scope. When operation completes, status
        code 200 returned without content.

        :param management_group_id: Management Group id. Required.
        :type management_group_id: str
        :param deployment_stack_name: Name of the deployment stack. Required.
        :type deployment_stack_name: str
        :param unmanage_action_resources: Flag to indicate delete rather than detach for unmanaged
         resources. Known values are: "delete" and "detach". Default value is None.
        :type unmanage_action_resources: str or
         ~azure.mgmt.resource.deploymentstacks.models.UnmanageActionResourceMode
        :param unmanage_action_resource_groups: Flag to indicate delete rather than detach for
         unmanaged resource groups. Known values are: "delete" and "detach". Default value is None.
        :type unmanage_action_resource_groups: str or
         ~azure.mgmt.resource.deploymentstacks.models.UnmanageActionResourceGroupMode
        :param unmanage_action_management_groups: Flag to indicate delete rather than detach for
         unmanaged management groups. Known values are: "delete" and "detach". Default value is None.
        :type unmanage_action_management_groups: str or
         ~azure.mgmt.resource.deploymentstacks.models.UnmanageActionManagementGroupMode
        :param bypass_stack_out_of_sync_error: Flag to bypass service errors that indicate the stack
         resource list is not correctly synchronized. Default value is None.
        :type bypass_stack_out_of_sync_error: bool
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_at_management_group_initial(
                management_group_id=management_group_id,
                deployment_stack_name=deployment_stack_name,
                unmanage_action_resources=unmanage_action_resources,
                unmanage_action_resource_groups=unmanage_action_resource_groups,
                unmanage_action_management_groups=unmanage_action_management_groups,
                bypass_stack_out_of_sync_error=bypass_stack_out_of_sync_error,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace_async
    async def export_template_at_resource_group(
        self, resource_group_name: str, deployment_stack_name: str, **kwargs: Any
    ) -> _models.DeploymentStackTemplateDefinition:
        """Exports the template used to create the Deployment stack at Resource Group scope.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param deployment_stack_name: Name of the deployment stack. Required.
        :type deployment_stack_name: str
        :return: DeploymentStackTemplateDefinition or the result of cls(response)
        :rtype: ~azure.mgmt.resource.deploymentstacks.models.DeploymentStackTemplateDefinition
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.DeploymentStackTemplateDefinition] = kwargs.pop("cls", None)

        _request = build_export_template_at_resource_group_request(
            resource_group_name=resource_group_name,
            deployment_stack_name=deployment_stack_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DeploymentStacksError, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DeploymentStackTemplateDefinition", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def export_template_at_subscription(
        self, deployment_stack_name: str, **kwargs: Any
    ) -> _models.DeploymentStackTemplateDefinition:
        """Exports the template used to create the Deployment stack at Subscription scope.

        :param deployment_stack_name: Name of the deployment stack. Required.
        :type deployment_stack_name: str
        :return: DeploymentStackTemplateDefinition or the result of cls(response)
        :rtype: ~azure.mgmt.resource.deploymentstacks.models.DeploymentStackTemplateDefinition
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.DeploymentStackTemplateDefinition] = kwargs.pop("cls", None)

        _request = build_export_template_at_subscription_request(
            deployment_stack_name=deployment_stack_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DeploymentStacksError, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DeploymentStackTemplateDefinition", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def export_template_at_management_group(
        self, management_group_id: str, deployment_stack_name: str, **kwargs: Any
    ) -> _models.DeploymentStackTemplateDefinition:
        """Exports the template used to create the Deployment stack at Management Group scope.

        :param management_group_id: Management Group id. Required.
        :type management_group_id: str
        :param deployment_stack_name: Name of the deployment stack. Required.
        :type deployment_stack_name: str
        :return: DeploymentStackTemplateDefinition or the result of cls(response)
        :rtype: ~azure.mgmt.resource.deploymentstacks.models.DeploymentStackTemplateDefinition
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.DeploymentStackTemplateDefinition] = kwargs.pop("cls", None)

        _request = build_export_template_at_management_group_request(
            management_group_id=management_group_id,
            deployment_stack_name=deployment_stack_name,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DeploymentStacksError, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DeploymentStackTemplateDefinition", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _validate_stack_at_resource_group_initial(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        deployment_stack_name: str,
        deployment_stack: Union[_models.DeploymentStack, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(deployment_stack, (IOBase, bytes)):
            _content = deployment_stack
        else:
            _json = self._serialize.body(deployment_stack, "DeploymentStack")

        _request = build_validate_stack_at_resource_group_request(
            resource_group_name=resource_group_name,
            deployment_stack_name=deployment_stack_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 400]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DeploymentStacksError, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Retry-After"] = self._deserialize("str", response.headers.get("Retry-After"))

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_validate_stack_at_resource_group(
        self,
        resource_group_name: str,
        deployment_stack_name: str,
        deployment_stack: _models.DeploymentStack,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.DeploymentStackValidateResult]:
        """Runs preflight validation on the Resource Group scoped Deployment stack template to verify its
        acceptance to Azure Resource Manager.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param deployment_stack_name: Name of the deployment stack. Required.
        :type deployment_stack_name: str
        :param deployment_stack: Deployment stack to validate. Required.
        :type deployment_stack: ~azure.mgmt.resource.deploymentstacks.models.DeploymentStack
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either DeploymentStackValidateResult or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.resource.deploymentstacks.models.DeploymentStackValidateResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_validate_stack_at_resource_group(
        self,
        resource_group_name: str,
        deployment_stack_name: str,
        deployment_stack: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.DeploymentStackValidateResult]:
        """Runs preflight validation on the Resource Group scoped Deployment stack template to verify its
        acceptance to Azure Resource Manager.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param deployment_stack_name: Name of the deployment stack. Required.
        :type deployment_stack_name: str
        :param deployment_stack: Deployment stack to validate. Required.
        :type deployment_stack: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either DeploymentStackValidateResult or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.resource.deploymentstacks.models.DeploymentStackValidateResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_validate_stack_at_resource_group(
        self,
        resource_group_name: str,
        deployment_stack_name: str,
        deployment_stack: Union[_models.DeploymentStack, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.DeploymentStackValidateResult]:
        """Runs preflight validation on the Resource Group scoped Deployment stack template to verify its
        acceptance to Azure Resource Manager.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param deployment_stack_name: Name of the deployment stack. Required.
        :type deployment_stack_name: str
        :param deployment_stack: Deployment stack to validate. Is either a DeploymentStack type or a
         IO[bytes] type. Required.
        :type deployment_stack: ~azure.mgmt.resource.deploymentstacks.models.DeploymentStack or
         IO[bytes]
        :return: An instance of AsyncLROPoller that returns either DeploymentStackValidateResult or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.resource.deploymentstacks.models.DeploymentStackValidateResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.DeploymentStackValidateResult] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._validate_stack_at_resource_group_initial(
                resource_group_name=resource_group_name,
                deployment_stack_name=deployment_stack_name,
                deployment_stack=deployment_stack,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("DeploymentStackValidateResult", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.DeploymentStackValidateResult].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.DeploymentStackValidateResult](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _validate_stack_at_subscription_initial(
        self, deployment_stack_name: str, deployment_stack: Union[_models.DeploymentStack, IO[bytes]], **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(deployment_stack, (IOBase, bytes)):
            _content = deployment_stack
        else:
            _json = self._serialize.body(deployment_stack, "DeploymentStack")

        _request = build_validate_stack_at_subscription_request(
            deployment_stack_name=deployment_stack_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 400]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DeploymentStacksError, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Retry-After"] = self._deserialize("str", response.headers.get("Retry-After"))

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_validate_stack_at_subscription(
        self,
        deployment_stack_name: str,
        deployment_stack: _models.DeploymentStack,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.DeploymentStackValidateResult]:
        """Runs preflight validation on the Subscription scoped Deployment stack template to verify its
        acceptance to Azure Resource Manager.

        :param deployment_stack_name: Name of the deployment stack. Required.
        :type deployment_stack_name: str
        :param deployment_stack: Deployment stack to validate. Required.
        :type deployment_stack: ~azure.mgmt.resource.deploymentstacks.models.DeploymentStack
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either DeploymentStackValidateResult or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.resource.deploymentstacks.models.DeploymentStackValidateResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_validate_stack_at_subscription(
        self,
        deployment_stack_name: str,
        deployment_stack: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.DeploymentStackValidateResult]:
        """Runs preflight validation on the Subscription scoped Deployment stack template to verify its
        acceptance to Azure Resource Manager.

        :param deployment_stack_name: Name of the deployment stack. Required.
        :type deployment_stack_name: str
        :param deployment_stack: Deployment stack to validate. Required.
        :type deployment_stack: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either DeploymentStackValidateResult or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.resource.deploymentstacks.models.DeploymentStackValidateResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_validate_stack_at_subscription(
        self, deployment_stack_name: str, deployment_stack: Union[_models.DeploymentStack, IO[bytes]], **kwargs: Any
    ) -> AsyncLROPoller[_models.DeploymentStackValidateResult]:
        """Runs preflight validation on the Subscription scoped Deployment stack template to verify its
        acceptance to Azure Resource Manager.

        :param deployment_stack_name: Name of the deployment stack. Required.
        :type deployment_stack_name: str
        :param deployment_stack: Deployment stack to validate. Is either a DeploymentStack type or a
         IO[bytes] type. Required.
        :type deployment_stack: ~azure.mgmt.resource.deploymentstacks.models.DeploymentStack or
         IO[bytes]
        :return: An instance of AsyncLROPoller that returns either DeploymentStackValidateResult or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.resource.deploymentstacks.models.DeploymentStackValidateResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.DeploymentStackValidateResult] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._validate_stack_at_subscription_initial(
                deployment_stack_name=deployment_stack_name,
                deployment_stack=deployment_stack,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("DeploymentStackValidateResult", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.DeploymentStackValidateResult].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.DeploymentStackValidateResult](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _validate_stack_at_management_group_initial(  # pylint: disable=name-too-long
        self,
        management_group_id: str,
        deployment_stack_name: str,
        deployment_stack: Union[_models.DeploymentStack, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(deployment_stack, (IOBase, bytes)):
            _content = deployment_stack
        else:
            _json = self._serialize.body(deployment_stack, "DeploymentStack")

        _request = build_validate_stack_at_management_group_request(
            management_group_id=management_group_id,
            deployment_stack_name=deployment_stack_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 400]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DeploymentStacksError, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Retry-After"] = self._deserialize("str", response.headers.get("Retry-After"))

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_validate_stack_at_management_group(
        self,
        management_group_id: str,
        deployment_stack_name: str,
        deployment_stack: _models.DeploymentStack,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.DeploymentStackValidateResult]:
        """Runs preflight validation on the Management Group scoped Deployment stack template to verify
        its acceptance to Azure Resource Manager.

        :param management_group_id: Management Group id. Required.
        :type management_group_id: str
        :param deployment_stack_name: Name of the deployment stack. Required.
        :type deployment_stack_name: str
        :param deployment_stack: Deployment stack to validate. Required.
        :type deployment_stack: ~azure.mgmt.resource.deploymentstacks.models.DeploymentStack
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either DeploymentStackValidateResult or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.resource.deploymentstacks.models.DeploymentStackValidateResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_validate_stack_at_management_group(
        self,
        management_group_id: str,
        deployment_stack_name: str,
        deployment_stack: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.DeploymentStackValidateResult]:
        """Runs preflight validation on the Management Group scoped Deployment stack template to verify
        its acceptance to Azure Resource Manager.

        :param management_group_id: Management Group id. Required.
        :type management_group_id: str
        :param deployment_stack_name: Name of the deployment stack. Required.
        :type deployment_stack_name: str
        :param deployment_stack: Deployment stack to validate. Required.
        :type deployment_stack: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either DeploymentStackValidateResult or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.resource.deploymentstacks.models.DeploymentStackValidateResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_validate_stack_at_management_group(
        self,
        management_group_id: str,
        deployment_stack_name: str,
        deployment_stack: Union[_models.DeploymentStack, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.DeploymentStackValidateResult]:
        """Runs preflight validation on the Management Group scoped Deployment stack template to verify
        its acceptance to Azure Resource Manager.

        :param management_group_id: Management Group id. Required.
        :type management_group_id: str
        :param deployment_stack_name: Name of the deployment stack. Required.
        :type deployment_stack_name: str
        :param deployment_stack: Deployment stack to validate. Is either a DeploymentStack type or a
         IO[bytes] type. Required.
        :type deployment_stack: ~azure.mgmt.resource.deploymentstacks.models.DeploymentStack or
         IO[bytes]
        :return: An instance of AsyncLROPoller that returns either DeploymentStackValidateResult or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.resource.deploymentstacks.models.DeploymentStackValidateResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.DeploymentStackValidateResult] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._validate_stack_at_management_group_initial(
                management_group_id=management_group_id,
                deployment_stack_name=deployment_stack_name,
                deployment_stack=deployment_stack,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("DeploymentStackValidateResult", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.DeploymentStackValidateResult].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.DeploymentStackValidateResult](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )
