# getDirectoryToWatchFailedLookupLocation

Determines whether to watch given failed lookup location (file that didnt exist) when resolving module.
It also determines the directory to watch and whether to watch it recursively or not.

## Testing for Posix root: /

## RootDirForResolution: /

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- |
| /somefile.d.ts                                                                               |                                                                                              |           |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | true      |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2                                                                | true      |
| /users/somefile.d.ts                                                                         |                                                                                              |           |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | true      |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir                                                                          | true      |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot                                                                 | true      |
| /user/somefile.d.ts                                                                          |                                                                                              |           |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | true      |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir                                                                           | true      |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot                                                                  | true      |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | true      |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir                                                                            | true      |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot                                                                   | true      |
| /home/somefile.d.ts                                                                          |                                                                                              |           |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | true      |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir                                                                           | true      |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: /folderAtRoot

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- |
| /somefile.d.ts                                                                               |                                                                                              |           |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | true      |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2                                                                | true      |
| /users/somefile.d.ts                                                                         |                                                                                              |           |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | true      |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir                                                                          | true      |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot                                                                 | true      |
| /user/somefile.d.ts                                                                          |                                                                                              |           |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | true      |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir                                                                           | true      |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot                                                                  | true      |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | true      |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir                                                                            | true      |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot                                                                   | true      |
| /home/somefile.d.ts                                                                          |                                                                                              |           |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | true      |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir                                                                           | true      |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: /folderAtRoot/folder1

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- |
| /somefile.d.ts                                                                               |                                                                                              |           |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | true      |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2                                                                | true      |
| /users/somefile.d.ts                                                                         |                                                                                              |           |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | true      |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir                                                                          | true      |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot                                                                 | true      |
| /user/somefile.d.ts                                                                          |                                                                                              |           |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | true      |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir                                                                           | true      |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot                                                                  | true      |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | true      |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir                                                                            | true      |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot                                                                   | true      |
| /home/somefile.d.ts                                                                          |                                                                                              |           |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | true      |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir                                                                           | true      |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: /folderAtRoot/folder1/folder2

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- |
| /somefile.d.ts                                                                               |                                                                                              |           |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | true      |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | false     |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/dir                                                            | true      |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir                                                            | true      |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3                                                        | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3                                                        | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3                                                        | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3                                                        | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3                                                        | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3                                                        | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3                                                        | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3                                                        | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3                                                        | true      |
| /users/somefile.d.ts                                                                         |                                                                                              |           |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | true      |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir                                                                          | true      |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot                                                                 | true      |
| /user/somefile.d.ts                                                                          |                                                                                              |           |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | true      |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir                                                                           | true      |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot                                                                  | true      |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | true      |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir                                                                            | true      |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot                                                                   | true      |
| /home/somefile.d.ts                                                                          |                                                                                              |           |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | true      |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir                                                                           | true      |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: /folderAtRoot/folder1/folder2/folder3

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- |
| /somefile.d.ts                                                                               |                                                                                              |           |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | true      |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | false     |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/dir                                                            | true      |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir                                                            | true      |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3                                                        | false     |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/dir                                                    | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir                                                    | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |
| /users/somefile.d.ts                                                                         |                                                                                              |           |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | true      |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir                                                                          | true      |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot                                                                 | true      |
| /user/somefile.d.ts                                                                          |                                                                                              |           |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | true      |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir                                                                           | true      |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot                                                                  | true      |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | true      |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir                                                                            | true      |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot                                                                   | true      |
| /home/somefile.d.ts                                                                          |                                                                                              |           |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | true      |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir                                                                           | true      |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: /folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- |
| /somefile.d.ts                                                                               |                                                                                              |           |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | true      |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | false     |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/dir                                                            | true      |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir                                                            | true      |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3                                                        | false     |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/dir                                                    | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir                                                    | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | true      |
| /users/somefile.d.ts                                                                         |                                                                                              |           |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | true      |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir                                                                          | true      |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot                                                                 | true      |
| /user/somefile.d.ts                                                                          |                                                                                              |           |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | true      |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir                                                                           | true      |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot                                                                  | true      |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | true      |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir                                                                            | true      |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot                                                                   | true      |
| /home/somefile.d.ts                                                                          |                                                                                              |           |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | true      |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir                                                                           | true      |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: /folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- |
| /somefile.d.ts                                                                               |                                                                                              |           |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | true      |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | false     |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2/dir                                                            | true      |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2/dir                                                            | true      |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2/folder3                                                        | false     |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2/folder3/dir                                                    | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2/folder3/dir                                                    | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | true      |
| /users/somefile.d.ts                                                                         |                                                                                              |           |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | true      |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir                                                                          | true      |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot                                                                 | true      |
| /user/somefile.d.ts                                                                          |                                                                                              |           |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | true      |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir                                                                           | true      |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot                                                                  | true      |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | true      |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir                                                                            | true      |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot                                                                   | true      |
| /home/somefile.d.ts                                                                          |                                                                                              |           |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | true      |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir                                                                           | true      |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: /users

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- |
| /somefile.d.ts                                                                               |                                                                                              |           |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | true      |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2                                                                | true      |
| /users/somefile.d.ts                                                                         |                                                                                              |           |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | true      |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir                                                                          | true      |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot                                                                 | true      |
| /user/somefile.d.ts                                                                          |                                                                                              |           |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | true      |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir                                                                           | true      |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot                                                                  | true      |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | true      |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir                                                                            | true      |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot                                                                   | true      |
| /home/somefile.d.ts                                                                          |                                                                                              |           |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | true      |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir                                                                           | true      |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: /users/username

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- |
| /somefile.d.ts                                                                               |                                                                                              |           |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | true      |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2                                                                | true      |
| /users/somefile.d.ts                                                                         |                                                                                              |           |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | true      |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir                                                                          | true      |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot                                                                 | true      |
| /user/somefile.d.ts                                                                          |                                                                                              |           |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | true      |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir                                                                           | true      |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot                                                                  | true      |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | true      |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir                                                                            | true      |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot                                                                   | true      |
| /home/somefile.d.ts                                                                          |                                                                                              |           |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | true      |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir                                                                           | true      |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: /users/username/folderAtRoot

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- |
| /somefile.d.ts                                                                               |                                                                                              |           |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | true      |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2                                                                | true      |
| /users/somefile.d.ts                                                                         |                                                                                              |           |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | true      |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir                                                                          | true      |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | false     |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot/dir                                                             | true      |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir                                                             | true      |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot/folder1                                                         | true      |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1                                                         | true      |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1                                                         | true      |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot/folder1                                                         | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1                                                         | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1                                                         | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot/folder1                                                         | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1                                                         | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1                                                         | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot/folder1                                                         | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1                                                         | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1                                                         | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot/folder1                                                         | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1                                                         | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1                                                         | true      |
| /user/somefile.d.ts                                                                          |                                                                                              |           |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | true      |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir                                                                           | true      |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot                                                                  | true      |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | true      |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir                                                                            | true      |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot                                                                   | true      |
| /home/somefile.d.ts                                                                          |                                                                                              |           |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | true      |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir                                                                           | true      |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: /users/username/folderAtRoot/folder1

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- |
| /somefile.d.ts                                                                               |                                                                                              |           |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | true      |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2                                                                | true      |
| /users/somefile.d.ts                                                                         |                                                                                              |           |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | true      |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir                                                                          | true      |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | false     |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot/dir                                                             | true      |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir                                                             | true      |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot/folder1                                                         | false     |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/dir                                                     | true      |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2                                                 | true      |
| /user/somefile.d.ts                                                                          |                                                                                              |           |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | true      |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir                                                                           | true      |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot                                                                  | true      |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | true      |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir                                                                            | true      |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot                                                                   | true      |
| /home/somefile.d.ts                                                                          |                                                                                              |           |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | true      |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir                                                                           | true      |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: /users/username/folderAtRoot/folder1/folder2

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- |
| /somefile.d.ts                                                                               |                                                                                              |           |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | true      |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2                                                                | true      |
| /users/somefile.d.ts                                                                         |                                                                                              |           |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | true      |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir                                                                          | true      |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | false     |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot/dir                                                             | true      |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir                                                             | true      |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot/folder1                                                         | false     |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/dir                                                     | true      |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2                                                 | false     |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/dir                                             | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir                                             | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |
| /user/somefile.d.ts                                                                          |                                                                                              |           |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | true      |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir                                                                           | true      |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot                                                                  | true      |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | true      |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir                                                                            | true      |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot                                                                   | true      |
| /home/somefile.d.ts                                                                          |                                                                                              |           |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | true      |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir                                                                           | true      |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: /users/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- |
| /somefile.d.ts                                                                               |                                                                                              |           |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | true      |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2                                                                | true      |
| /users/somefile.d.ts                                                                         |                                                                                              |           |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | true      |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir                                                                          | true      |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | false     |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot/dir                                                             | true      |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir                                                             | true      |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot/folder1                                                         | false     |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/dir                                                     | true      |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2                                                 | false     |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/dir                                             | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir                                             | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |
| /user/somefile.d.ts                                                                          |                                                                                              |           |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | true      |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir                                                                           | true      |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot                                                                  | true      |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | true      |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir                                                                            | true      |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot                                                                   | true      |
| /home/somefile.d.ts                                                                          |                                                                                              |           |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | true      |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir                                                                           | true      |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: /users/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- |
| /somefile.d.ts                                                                               |                                                                                              |           |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | true      |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2                                                                | true      |
| /users/somefile.d.ts                                                                         |                                                                                              |           |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | true      |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir                                                                          | true      |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | false     |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot/dir                                                             | true      |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir                                                             | true      |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot/folder1                                                         | false     |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/dir                                                     | true      |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2                                                 | false     |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/dir                                             | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir                                             | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | true      |
| /user/somefile.d.ts                                                                          |                                                                                              |           |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | true      |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir                                                                           | true      |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot                                                                  | true      |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | true      |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir                                                                            | true      |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot                                                                   | true      |
| /home/somefile.d.ts                                                                          |                                                                                              |           |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | true      |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir                                                                           | true      |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- |
| /somefile.d.ts                                                                               |                                                                                              |           |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | true      |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2                                                                | true      |
| /users/somefile.d.ts                                                                         |                                                                                              |           |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | true      |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir                                                                          | true      |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | false     |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot/dir                                                             | true      |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot/dir                                                             | true      |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot/folder1                                                         | false     |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot/folder1/dir                                                     | true      |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot/folder1/dir                                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot/folder1/folder2                                                 | false     |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot/folder1/folder2/dir                                             | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot/folder1/folder2/dir                                             | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | true      |
| /user/somefile.d.ts                                                                          |                                                                                              |           |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | true      |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir                                                                           | true      |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot                                                                  | true      |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | true      |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir                                                                            | true      |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot                                                                   | true      |
| /home/somefile.d.ts                                                                          |                                                                                              |           |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | true      |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir                                                                           | true      |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: /user

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- |
| /somefile.d.ts                                                                               |                                                                                              |           |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | true      |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2                                                                | true      |
| /users/somefile.d.ts                                                                         |                                                                                              |           |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | true      |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir                                                                          | true      |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot                                                                 | true      |
| /user/somefile.d.ts                                                                          |                                                                                              |           |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | true      |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir                                                                           | true      |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot                                                                  | true      |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | true      |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir                                                                            | true      |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot                                                                   | true      |
| /home/somefile.d.ts                                                                          |                                                                                              |           |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | true      |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir                                                                           | true      |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: /user/username

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- |
| /somefile.d.ts                                                                               |                                                                                              |           |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | true      |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2                                                                | true      |
| /users/somefile.d.ts                                                                         |                                                                                              |           |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | true      |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir                                                                          | true      |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot                                                                 | true      |
| /user/somefile.d.ts                                                                          |                                                                                              |           |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | true      |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir                                                                           | true      |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot                                                                  | true      |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | true      |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir                                                                            | true      |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot                                                                   | true      |
| /home/somefile.d.ts                                                                          |                                                                                              |           |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | true      |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir                                                                           | true      |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: /user/username/folderAtRoot

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- |
| /somefile.d.ts                                                                               |                                                                                              |           |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | true      |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2                                                                | true      |
| /users/somefile.d.ts                                                                         |                                                                                              |           |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | true      |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir                                                                          | true      |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot                                                                 | true      |
| /user/somefile.d.ts                                                                          |                                                                                              |           |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | true      |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir                                                                           | true      |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | false     |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot/dir                                                              | true      |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir                                                              | true      |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot/folder1                                                          | true      |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1                                                          | true      |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1                                                          | true      |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot/folder1                                                          | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1                                                          | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1                                                          | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot/folder1                                                          | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1                                                          | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1                                                          | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot/folder1                                                          | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1                                                          | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1                                                          | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot/folder1                                                          | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1                                                          | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1                                                          | true      |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | true      |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir                                                                            | true      |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot                                                                   | true      |
| /home/somefile.d.ts                                                                          |                                                                                              |           |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | true      |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir                                                                           | true      |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: /user/username/folderAtRoot/folder1

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- |
| /somefile.d.ts                                                                               |                                                                                              |           |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | true      |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2                                                                | true      |
| /users/somefile.d.ts                                                                         |                                                                                              |           |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | true      |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir                                                                          | true      |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot                                                                 | true      |
| /user/somefile.d.ts                                                                          |                                                                                              |           |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | true      |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir                                                                           | true      |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | false     |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot/dir                                                              | true      |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir                                                              | true      |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot/folder1                                                          | false     |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/dir                                                      | true      |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2                                                  | true      |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | true      |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir                                                                            | true      |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot                                                                   | true      |
| /home/somefile.d.ts                                                                          |                                                                                              |           |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | true      |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir                                                                           | true      |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: /user/username/folderAtRoot/folder1/folder2

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- |
| /somefile.d.ts                                                                               |                                                                                              |           |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | true      |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2                                                                | true      |
| /users/somefile.d.ts                                                                         |                                                                                              |           |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | true      |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir                                                                          | true      |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot                                                                 | true      |
| /user/somefile.d.ts                                                                          |                                                                                              |           |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | true      |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir                                                                           | true      |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | false     |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot/dir                                                              | true      |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir                                                              | true      |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot/folder1                                                          | false     |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/dir                                                      | true      |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2                                                  | false     |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | true      |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir                                                                            | true      |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot                                                                   | true      |
| /home/somefile.d.ts                                                                          |                                                                                              |           |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | true      |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir                                                                           | true      |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: /user/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- |
| /somefile.d.ts                                                                               |                                                                                              |           |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | true      |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2                                                                | true      |
| /users/somefile.d.ts                                                                         |                                                                                              |           |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | true      |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir                                                                          | true      |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot                                                                 | true      |
| /user/somefile.d.ts                                                                          |                                                                                              |           |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | true      |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir                                                                           | true      |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | false     |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot/dir                                                              | true      |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir                                                              | true      |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot/folder1                                                          | false     |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/dir                                                      | true      |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2                                                  | false     |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | true      |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir                                                                            | true      |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot                                                                   | true      |
| /home/somefile.d.ts                                                                          |                                                                                              |           |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | true      |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir                                                                           | true      |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: /user/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- |
| /somefile.d.ts                                                                               |                                                                                              |           |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | true      |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2                                                                | true      |
| /users/somefile.d.ts                                                                         |                                                                                              |           |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | true      |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir                                                                          | true      |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot                                                                 | true      |
| /user/somefile.d.ts                                                                          |                                                                                              |           |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | true      |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir                                                                           | true      |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | false     |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot/dir                                                              | true      |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir                                                              | true      |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot/folder1                                                          | false     |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/dir                                                      | true      |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2                                                  | false     |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | true      |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | true      |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir                                                                            | true      |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot                                                                   | true      |
| /home/somefile.d.ts                                                                          |                                                                                              |           |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | true      |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir                                                                           | true      |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- |
| /somefile.d.ts                                                                               |                                                                                              |           |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | true      |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2                                                                | true      |
| /users/somefile.d.ts                                                                         |                                                                                              |           |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | true      |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir                                                                          | true      |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot                                                                 | true      |
| /user/somefile.d.ts                                                                          |                                                                                              |           |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | true      |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir                                                                           | true      |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | false     |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot/dir                                                              | true      |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot/dir                                                              | true      |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot/folder1                                                          | false     |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot/folder1/dir                                                      | true      |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot/folder1/dir                                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot/folder1/folder2                                                  | false     |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | true      |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | true      |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir                                                                            | true      |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot                                                                   | true      |
| /home/somefile.d.ts                                                                          |                                                                                              |           |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | true      |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir                                                                           | true      |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: /usr

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- |
| /somefile.d.ts                                                                               |                                                                                              |           |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | true      |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2                                                                | true      |
| /users/somefile.d.ts                                                                         |                                                                                              |           |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | true      |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir                                                                          | true      |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot                                                                 | true      |
| /user/somefile.d.ts                                                                          |                                                                                              |           |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | true      |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir                                                                           | true      |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot                                                                  | true      |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | true      |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir                                                                            | true      |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot                                                                   | true      |
| /home/somefile.d.ts                                                                          |                                                                                              |           |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | true      |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir                                                                           | true      |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: /usr/username

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- |
| /somefile.d.ts                                                                               |                                                                                              |           |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | true      |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2                                                                | true      |
| /users/somefile.d.ts                                                                         |                                                                                              |           |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | true      |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir                                                                          | true      |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot                                                                 | true      |
| /user/somefile.d.ts                                                                          |                                                                                              |           |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | true      |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir                                                                           | true      |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot                                                                  | true      |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | true      |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir                                                                            | true      |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot                                                                   | true      |
| /home/somefile.d.ts                                                                          |                                                                                              |           |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | true      |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir                                                                           | true      |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: /usr/username/folderAtRoot

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- |
| /somefile.d.ts                                                                               |                                                                                              |           |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | true      |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2                                                                | true      |
| /users/somefile.d.ts                                                                         |                                                                                              |           |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | true      |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir                                                                          | true      |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot                                                                 | true      |
| /user/somefile.d.ts                                                                          |                                                                                              |           |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | true      |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir                                                                           | true      |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot                                                                  | true      |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | true      |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir                                                                            | true      |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | false     |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/dir                                                               | true      |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir                                                               | true      |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1                                                           | true      |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1                                                           | true      |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1                                                           | true      |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1                                                           | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1                                                           | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1                                                           | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot/folder1                                                           | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1                                                           | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1                                                           | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot/folder1                                                           | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1                                                           | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1                                                           | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot/folder1                                                           | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1                                                           | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1                                                           | true      |
| /home/somefile.d.ts                                                                          |                                                                                              |           |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | true      |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir                                                                           | true      |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: /usr/username/folderAtRoot/folder1

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- |
| /somefile.d.ts                                                                               |                                                                                              |           |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | true      |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2                                                                | true      |
| /users/somefile.d.ts                                                                         |                                                                                              |           |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | true      |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir                                                                          | true      |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot                                                                 | true      |
| /user/somefile.d.ts                                                                          |                                                                                              |           |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | true      |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir                                                                           | true      |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot                                                                  | true      |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | true      |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir                                                                            | true      |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | false     |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/dir                                                               | true      |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir                                                               | true      |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1                                                           | false     |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/dir                                                       | true      |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| /home/somefile.d.ts                                                                          |                                                                                              |           |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | true      |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir                                                                           | true      |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: /usr/username/folderAtRoot/folder1/folder2

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- |
| /somefile.d.ts                                                                               |                                                                                              |           |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | true      |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2                                                                | true      |
| /users/somefile.d.ts                                                                         |                                                                                              |           |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | true      |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir                                                                          | true      |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot                                                                 | true      |
| /user/somefile.d.ts                                                                          |                                                                                              |           |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | true      |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir                                                                           | true      |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot                                                                  | true      |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | true      |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir                                                                            | true      |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | false     |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/dir                                                               | true      |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir                                                               | true      |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1                                                           | false     |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/dir                                                       | true      |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2                                                   | false     |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/dir                                               | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir                                               | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |
| /home/somefile.d.ts                                                                          |                                                                                              |           |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | true      |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir                                                                           | true      |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: /usr/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- |
| /somefile.d.ts                                                                               |                                                                                              |           |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | true      |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2                                                                | true      |
| /users/somefile.d.ts                                                                         |                                                                                              |           |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | true      |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir                                                                          | true      |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot                                                                 | true      |
| /user/somefile.d.ts                                                                          |                                                                                              |           |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | true      |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir                                                                           | true      |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot                                                                  | true      |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | true      |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir                                                                            | true      |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | false     |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/dir                                                               | true      |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir                                                               | true      |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1                                                           | false     |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/dir                                                       | true      |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2                                                   | false     |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/dir                                               | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir                                               | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |
| /home/somefile.d.ts                                                                          |                                                                                              |           |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | true      |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir                                                                           | true      |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: /usr/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- |
| /somefile.d.ts                                                                               |                                                                                              |           |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | true      |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2                                                                | true      |
| /users/somefile.d.ts                                                                         |                                                                                              |           |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | true      |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir                                                                          | true      |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot                                                                 | true      |
| /user/somefile.d.ts                                                                          |                                                                                              |           |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | true      |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir                                                                           | true      |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot                                                                  | true      |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | true      |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir                                                                            | true      |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | false     |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/dir                                                               | true      |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir                                                               | true      |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1                                                           | false     |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/dir                                                       | true      |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2                                                   | false     |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/dir                                               | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir                                               | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | true      |
| /home/somefile.d.ts                                                                          |                                                                                              |           |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | true      |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir                                                                           | true      |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- |
| /somefile.d.ts                                                                               |                                                                                              |           |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | true      |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2                                                                | true      |
| /users/somefile.d.ts                                                                         |                                                                                              |           |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | true      |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir                                                                          | true      |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot                                                                 | true      |
| /user/somefile.d.ts                                                                          |                                                                                              |           |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | true      |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir                                                                           | true      |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot                                                                  | true      |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | true      |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir                                                                            | true      |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | false     |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot/dir                                                               | true      |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot/dir                                                               | true      |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot/folder1                                                           | false     |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot/folder1/dir                                                       | true      |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot/folder1/dir                                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot/folder1/folder2                                                   | false     |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot/folder1/folder2/dir                                               | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot/folder1/folder2/dir                                               | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | true      |
| /home/somefile.d.ts                                                                          |                                                                                              |           |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | true      |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir                                                                           | true      |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: /home

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- |
| /somefile.d.ts                                                                               |                                                                                              |           |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | true      |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2                                                                | true      |
| /users/somefile.d.ts                                                                         |                                                                                              |           |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | true      |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir                                                                          | true      |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot                                                                 | true      |
| /user/somefile.d.ts                                                                          |                                                                                              |           |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | true      |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir                                                                           | true      |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot                                                                  | true      |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | true      |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir                                                                            | true      |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot                                                                   | true      |
| /home/somefile.d.ts                                                                          |                                                                                              |           |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | true      |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir                                                                           | true      |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: /home/username

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- |
| /somefile.d.ts                                                                               |                                                                                              |           |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | true      |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2                                                                | true      |
| /users/somefile.d.ts                                                                         |                                                                                              |           |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | true      |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir                                                                          | true      |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot                                                                 | true      |
| /user/somefile.d.ts                                                                          |                                                                                              |           |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | true      |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir                                                                           | true      |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot                                                                  | true      |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | true      |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir                                                                            | true      |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot                                                                   | true      |
| /home/somefile.d.ts                                                                          |                                                                                              |           |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | true      |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir                                                                           | true      |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot                                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: /home/username/folderAtRoot

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- |
| /somefile.d.ts                                                                               |                                                                                              |           |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | true      |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2                                                                | true      |
| /users/somefile.d.ts                                                                         |                                                                                              |           |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | true      |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir                                                                          | true      |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot                                                                 | true      |
| /user/somefile.d.ts                                                                          |                                                                                              |           |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | true      |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir                                                                           | true      |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot                                                                  | true      |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | true      |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir                                                                            | true      |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot                                                                   | true      |
| /home/somefile.d.ts                                                                          |                                                                                              |           |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | true      |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir                                                                           | true      |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | false     |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot/dir                                                              | true      |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir                                                              | true      |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot/folder1                                                          | true      |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1                                                          | true      |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1                                                          | true      |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot/folder1                                                          | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1                                                          | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1                                                          | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot/folder1                                                          | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1                                                          | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1                                                          | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot/folder1                                                          | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1                                                          | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1                                                          | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot/folder1                                                          | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1                                                          | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1                                                          | true      |

## RootDirForResolution: /home/username/folderAtRoot/folder1

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- |
| /somefile.d.ts                                                                               |                                                                                              |           |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | true      |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2                                                                | true      |
| /users/somefile.d.ts                                                                         |                                                                                              |           |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | true      |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir                                                                          | true      |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot                                                                 | true      |
| /user/somefile.d.ts                                                                          |                                                                                              |           |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | true      |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir                                                                           | true      |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot                                                                  | true      |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | true      |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir                                                                            | true      |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot                                                                   | true      |
| /home/somefile.d.ts                                                                          |                                                                                              |           |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | true      |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir                                                                           | true      |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | false     |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot/dir                                                              | true      |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir                                                              | true      |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot/folder1                                                          | false     |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/dir                                                      | true      |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir                                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2                                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2                                                  | true      |

## RootDirForResolution: /home/username/folderAtRoot/folder1/folder2

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- |
| /somefile.d.ts                                                                               |                                                                                              |           |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | true      |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2                                                                | true      |
| /users/somefile.d.ts                                                                         |                                                                                              |           |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | true      |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir                                                                          | true      |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot                                                                 | true      |
| /user/somefile.d.ts                                                                          |                                                                                              |           |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | true      |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir                                                                           | true      |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot                                                                  | true      |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | true      |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir                                                                            | true      |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot                                                                   | true      |
| /home/somefile.d.ts                                                                          |                                                                                              |           |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | true      |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir                                                                           | true      |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | false     |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot/dir                                                              | true      |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir                                                              | true      |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot/folder1                                                          | false     |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/dir                                                      | true      |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir                                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2                                                  | false     |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |

## RootDirForResolution: /home/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- |
| /somefile.d.ts                                                                               |                                                                                              |           |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | true      |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2                                                                | true      |
| /users/somefile.d.ts                                                                         |                                                                                              |           |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | true      |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir                                                                          | true      |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot                                                                 | true      |
| /user/somefile.d.ts                                                                          |                                                                                              |           |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | true      |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir                                                                           | true      |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot                                                                  | true      |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | true      |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir                                                                            | true      |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot                                                                   | true      |
| /home/somefile.d.ts                                                                          |                                                                                              |           |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | true      |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir                                                                           | true      |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | false     |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot/dir                                                              | true      |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir                                                              | true      |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot/folder1                                                          | false     |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/dir                                                      | true      |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir                                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2                                                  | false     |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |

## RootDirForResolution: /home/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- |
| /somefile.d.ts                                                                               |                                                                                              |           |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | true      |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2                                                                | true      |
| /users/somefile.d.ts                                                                         |                                                                                              |           |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | true      |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir                                                                          | true      |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot                                                                 | true      |
| /user/somefile.d.ts                                                                          |                                                                                              |           |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | true      |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir                                                                           | true      |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot                                                                  | true      |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | true      |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir                                                                            | true      |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot                                                                   | true      |
| /home/somefile.d.ts                                                                          |                                                                                              |           |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | true      |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir                                                                           | true      |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | false     |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot/dir                                                              | true      |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir                                                              | true      |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot/folder1                                                          | false     |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/dir                                                      | true      |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir                                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2                                                  | false     |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | true      |

## RootDirForResolution: /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                     | getDirectoryToWatchFailedLookupLocation                                                      | Recursive |
| -------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | --------- |
| /somefile.d.ts                                                                               |                                                                                              |           |
| /dir/somefile.d.ts                                                                           |                                                                                              |           |
| /dir/subdir/somefile.d.ts                                                                    |                                                                                              |           |
| /folderAtRoot/somefile.d.ts                                                                  |                                                                                              |           |
| /folderAtRoot/dir/somefile.d.ts                                                              |                                                                                              |           |
| /folderAtRoot/dir/subdir/somefile.d.ts                                                       | /folderAtRoot/dir/subdir                                                                     | true      |
| /folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                              |           |
| /folderAtRoot/folder1/dir/somefile.d.ts                                                      | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | /folderAtRoot/folder1/dir                                                                    | true      |
| /folderAtRoot/folder1/folder2/somefile.d.ts                                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | /folderAtRoot/folder1/folder2                                                                | true      |
| /folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | /folderAtRoot/folder1/folder2                                                                | true      |
| /users/somefile.d.ts                                                                         |                                                                                              |           |
| /users/dir/somefile.d.ts                                                                     |                                                                                              |           |
| /users/dir/subdir/somefile.d.ts                                                              | /users/dir/subdir                                                                            | true      |
| /users/username/somefile.d.ts                                                                |                                                                                              |           |
| /users/username/dir/somefile.d.ts                                                            | /users/username/dir                                                                          | true      |
| /users/username/dir/subdir/somefile.d.ts                                                     | /users/username/dir                                                                          | true      |
| /users/username/folderAtRoot/somefile.d.ts                                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/somefile.d.ts                                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/somefile.d.ts                                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | /users/username/folderAtRoot                                                                 | true      |
| /users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /users/username/folderAtRoot                                                                 | true      |
| /user/somefile.d.ts                                                                          |                                                                                              |           |
| /user/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /user/dir/subdir/somefile.d.ts                                                               | /user/dir/subdir                                                                             | true      |
| /user/username/somefile.d.ts                                                                 |                                                                                              |           |
| /user/username/dir/somefile.d.ts                                                             | /user/username/dir                                                                           | true      |
| /user/username/dir/subdir/somefile.d.ts                                                      | /user/username/dir                                                                           | true      |
| /user/username/folderAtRoot/somefile.d.ts                                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/somefile.d.ts                                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/somefile.d.ts                                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /user/username/folderAtRoot                                                                  | true      |
| /user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /user/username/folderAtRoot                                                                  | true      |
| /usr/somefile.d.ts                                                                           |                                                                                              |           |
| /usr/dir/somefile.d.ts                                                                       |                                                                                              |           |
| /usr/dir/subdir/somefile.d.ts                                                                | /usr/dir/subdir                                                                              | true      |
| /usr/username/somefile.d.ts                                                                  |                                                                                              |           |
| /usr/username/dir/somefile.d.ts                                                              | /usr/username/dir                                                                            | true      |
| /usr/username/dir/subdir/somefile.d.ts                                                       | /usr/username/dir                                                                            | true      |
| /usr/username/folderAtRoot/somefile.d.ts                                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/somefile.d.ts                                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/somefile.d.ts                                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | /usr/username/folderAtRoot                                                                   | true      |
| /usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | /usr/username/folderAtRoot                                                                   | true      |
| /home/somefile.d.ts                                                                          |                                                                                              |           |
| /home/dir/somefile.d.ts                                                                      |                                                                                              |           |
| /home/dir/subdir/somefile.d.ts                                                               | /home/dir/subdir                                                                             | true      |
| /home/username/somefile.d.ts                                                                 |                                                                                              |           |
| /home/username/dir/somefile.d.ts                                                             | /home/username/dir                                                                           | true      |
| /home/username/dir/subdir/somefile.d.ts                                                      | /home/username/dir                                                                           | true      |
| /home/username/folderAtRoot/somefile.d.ts                                                    | /home/username/folderAtRoot                                                                  | false     |
| /home/username/folderAtRoot/dir/somefile.d.ts                                                | /home/username/folderAtRoot/dir                                                              | true      |
| /home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | /home/username/folderAtRoot/dir                                                              | true      |
| /home/username/folderAtRoot/folder1/somefile.d.ts                                            | /home/username/folderAtRoot/folder1                                                          | false     |
| /home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | /home/username/folderAtRoot/folder1/dir                                                      | true      |
| /home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | /home/username/folderAtRoot/folder1/dir                                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | /home/username/folderAtRoot/folder1/folder2                                                  | false     |
| /home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | /home/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| /home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | /home/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | /home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | /home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | /home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | /home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | true      |
| /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | /home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | true      |

