/*
nitroxcalc
Copyright (C) 2015-2024 Salvo "LtWorf" Tomaselli

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as
published by the Free Software Foundation, either version 3 of the
License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.

author Salvo "LtWorf" Tomaselli <tiposchi@tiscali.it>
*/

#include "calcwrapper.h"

#include "calc.h"

QString CalcWrapper::mod(int ean) {
    if (ean < 21 || ean > 40) {
        return QString(" --- ");
    }
    return QString::number(maximum_operative_depth(ean)) + QString('m');
}

QString CalcWrapper::bod(int ean) {
    if (ean < 21 || ean > 40) {
        return QString(" --- ");
    }
    return QString::number(best_operative_depth(ean, 1)) + QString('m');
}

QString CalcWrapper::ead(int ean, int depth) {
    if (ean < 21 || ean > 40 || depth < 5) {
        return QString(" --- ");
    }

    int d = equivalent_air_depth(ean, depth);
    if (depth >= maximum_operative_depth(ean)) {
        return QString("Too deep!");
    }

    return QString::number(d) + QString('m');
}
