// Copyright 2017 The PDFium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Original code copyright 2014 Foxit Software Inc. http://www.foxitsoftware.com

#ifndef XFA_FXFA_CXFA_READYNODEITERATOR_H_
#define XFA_FXFA_CXFA_READYNODEITERATOR_H_

#include "core/fxcrt/unowned_ptr.h"
#include "v8/include/cppgc/macros.h"
#include "xfa/fxfa/parser/cxfa_traversestrategy_xfacontainernode.h"

class CXFA_Node;

class CXFA_ReadyNodeIterator {
  CPPGC_STACK_ALLOCATED();  // Allow Raw/Unowned pointers.

 public:
  explicit CXFA_ReadyNodeIterator(CXFA_Node* pTravelRoot);
  ~CXFA_ReadyNodeIterator();

  CXFA_Node* MoveToNext();
  void SkipTree();

 private:
  CXFA_ContainerIterator content_iterator_;
  UnownedPtr<CXFA_Node> cur_node_;  // Ok, stack-only.
};

#endif  // XFA_FXFA_CXFA_READYNODEITERATOR_H_
