#pragma once
/*
 *  $Id: line.h 29015 2025-12-16 18:43:48Z yeti-dn $
 *  Copyright (C) 2003-2025 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWY_LINE_H__
#define __GWY_LINE_H__

#include <libgwyddion/unit.h>
#include <libgwyddion/enums.h>
#include <libgwyddion/interpolation.h>

G_BEGIN_DECLS

#define GWY_TYPE_LINE            (gwy_line_get_type())
#define GWY_LINE(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), GWY_TYPE_LINE, GwyLine))
#define GWY_LINE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), GWY_TYPE_LINE, GwyLineClass))
#define GWY_IS_LINE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), GWY_TYPE_LINE))
#define GWY_IS_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), GWY_TYPE_LINE))
#define GWY_LINE_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), GWY_TYPE_LINE, GwyLineClass))

typedef struct _GwyLine        GwyLine;
typedef struct _GwyLineClass   GwyLineClass;
typedef struct _GwyLinePrivate GwyLinePrivate;

struct _GwyLine {
    GObject parent_instance;
    GwyLinePrivate *priv;

    gint res;
    gdouble real;
    gdouble off;
};

struct _GwyLineClass {
    GObjectClass parent_class;

    void (*data_changed)(GwyLine *line);
    /*< private >*/
    void (*reserved1)(void);
    void (*reserved2)(void);
};

GType           gwy_line_get_type          (void)                                G_GNUC_CONST;
GwyLine*        gwy_line_new               (gint res,
                                            gdouble real,
                                            gboolean nullme)                     G_GNUC_MALLOC;
GwyLine*        gwy_line_new_alike         (GwyLine *model,
                                            gboolean nullme)                     G_GNUC_MALLOC;
GwyLine*        gwy_line_copy              (GwyLine *line)                       G_GNUC_MALLOC;
void            gwy_line_assign            (GwyLine *destination,
                                            GwyLine *source);
void            gwy_line_data_changed      (GwyLine *line);
GwyLine*        gwy_line_new_resampled     (GwyLine *line,
                                            gint res,
                                            GwyInterpolationType interpolation);
void            gwy_line_resample          (GwyLine *line,
                                            gint res,
                                            GwyInterpolationType interpolation);
void            gwy_line_resize            (GwyLine *line,
                                            gint res);
void            gwy_line_crop              (GwyLine *line,
                                            gint pos,
                                            gint len);
GwyLine*        gwy_line_part_extract      (GwyLine *line,
                                            gint pos,
                                            gint len);
void            gwy_line_copy_data         (GwyLine *line,
                                            GwyLine *target);
gdouble*        gwy_line_get_data          (GwyLine *line);
const gdouble*  gwy_line_get_data_const    (GwyLine *line);
void            gwy_line_invalidate        (GwyLine *line);
gint            gwy_line_get_res           (GwyLine *line);
gdouble         gwy_line_get_real          (GwyLine *line);
void            gwy_line_set_real          (GwyLine *line,
                                            gdouble real);
gdouble         gwy_line_get_offset        (GwyLine *line);
void            gwy_line_set_offset        (GwyLine *line,
                                            gdouble offset);
gdouble         gwy_line_get_dx            (GwyLine *line);
GwyUnit*        gwy_line_get_unit_x        (GwyLine *line);
GwyUnit*        gwy_line_get_unit_y        (GwyLine *line);
GwyValueFormat* gwy_line_get_value_format_x(GwyLine *line,
                                            GwyUnitFormatStyle style,
                                            GwyValueFormat *format);
GwyValueFormat* gwy_line_get_value_format_y(GwyLine *line,
                                            GwyUnitFormatStyle style,
                                            GwyValueFormat *format);
void            gwy_line_copy_units        (GwyLine *line,
                                            GwyLine *target);
gdouble         gwy_line_itor              (GwyLine *line,
                                            gdouble pixpos);
gdouble         gwy_line_rtoi              (GwyLine *line,
                                            gdouble realpos);
gdouble         gwy_line_get_val           (GwyLine *line,
                                            gint i);
void            gwy_line_set_val           (GwyLine *line,
                                            gint i,
                                            gdouble value);
gdouble         gwy_line_get_dval          (GwyLine *line,
                                            gdouble x,
                                            GwyInterpolationType interpolation);
gdouble         gwy_line_get_dval_real     (GwyLine *line,
                                            gdouble x,
                                            GwyInterpolationType interpolation);
void            gwy_line_flip              (GwyLine *line);
void            gwy_line_invert_value      (GwyLine *line);
void            gwy_line_clear             (GwyLine *line);
void            gwy_line_fill              (GwyLine *line,
                                            gdouble value);
void            gwy_line_multiply          (GwyLine *line,
                                            gdouble value);
void            gwy_line_add               (GwyLine *line,
                                            gdouble value);
void            gwy_line_part_clear        (GwyLine *line,
                                            gint pos,
                                            gint len);
void            gwy_line_part_fill         (GwyLine *line,
                                            gint pos,
                                            gint len,
                                            gdouble value);
void            gwy_line_part_multiply     (GwyLine *line,
                                            gint pos,
                                            gint len,
                                            gdouble value);
void            gwy_line_part_add          (GwyLine *line,
                                            gint pos,
                                            gint len,
                                            gdouble value);
gint            gwy_line_threshold         (GwyLine *line,
                                            gdouble threshval,
                                            gdouble bottom,
                                            gdouble top);
gint            gwy_line_part_threshold    (GwyLine *line,
                                            gint pos,
                                            gint len,
                                            gdouble threshval,
                                            gdouble bottom,
                                            gdouble top);
gdouble         gwy_line_get_der           (GwyLine *line,
                                            gint i);
void            gwy_line_cumulate          (GwyLine *line,
                                            gboolean transform_to_cdist);
void            gwy_line_filter_slope      (GwyLine *line,
                                            GwyLine *der);
void            gwy_line_sqrt              (GwyLine *line);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
