#pragma once
/*
 *  $Id: correlation.h 28973 2025-12-10 18:45:40Z yeti-dn $
 *  Copyright (C) 2003-2025 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWY_CORRELATION_H__
#define __GWY_CORRELATION_H__

#include <libgwyddion/field.h>
#include <libgwyddion/types.h>

G_BEGIN_DECLS

typedef enum {
    GWY_CORRELATION_NORMAL  = 0,
    GWY_CORRELATION_FFT     = 1,
    GWY_CORRELATION_POC     = 2
} GwyCorrelationType;

gdouble              gwy_field_get_correlation_score         (GwyField *field,
                                                              GwyField *kernel_field,
                                                              gint col,
                                                              gint row,
                                                              gint kernel_col,
                                                              gint kernel_row,
                                                              gint kernel_width,
                                                              gint kernel_height);
gdouble              gwy_field_get_weighted_correlation_score(GwyField *field,
                                                              GwyField *kernel_field,
                                                              GwyField *weight_field,
                                                              gint col,
                                                              gint row,
                                                              gint kernel_col,
                                                              gint kernel_row,
                                                              gint kernel_width,
                                                              gint kernel_height);
void                 gwy_field_crosscorrelate                (GwyField *field1,
                                                              GwyField *field2,
                                                              GwyField *x_dist,
                                                              GwyField *y_dist,
                                                              GwyField *score,
                                                              gint search_width,
                                                              gint search_height,
                                                              gint window_width,
                                                              gint window_height);
GwyComputationState* gwy_field_crosscorrelate_init           (GwyField *field1,
                                                              GwyField *field2,
                                                              GwyField *x_dist,
                                                              GwyField *y_dist,
                                                              GwyField *score,
                                                              gint search_width,
                                                              gint search_height,
                                                              gint window_width,
                                                              gint window_height);
void                 gwy_field_crosscorrelate_set_weights    (GwyComputationState *state,
                                                              GwyWindowingType type);
void                 gwy_field_crosscorrelate_iteration      (GwyComputationState *state);
void                 gwy_field_crosscorrelate_finalize       (GwyComputationState *state);
void                 gwy_field_correlate                     (GwyField *field,
                                                              GwyField *kernel_field,
                                                              GwyField *score,
                                                              GwyCorrelationType method);
GwyComputationState* gwy_field_correlate_init                (GwyField *field,
                                                              GwyField *kernel_field,
                                                              GwyField *score);
void                 gwy_field_correlate_iteration           (GwyComputationState *state);
void                 gwy_field_correlate_finalize            (GwyComputationState *state);
void                 gwy_field_correlation_search            (GwyField *dfield,
                                                              GwyField *kernel,
                                                              GwyField *kernel_weight,
                                                              GwyField *target,
                                                              GwyCorrSearchType method,
                                                              gdouble regcoeff,
                                                              GwyExteriorType exterior,
                                                              gdouble fill_value);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
