//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/quantum/armquantum"
	"net/http"
	"net/url"
	"regexp"
)

// WorkspaceServer is a fake server for instances of the armquantum.WorkspaceClient type.
type WorkspaceServer struct {
	// CheckNameAvailability is the fake for method WorkspaceClient.CheckNameAvailability
	// HTTP status codes to indicate success: http.StatusOK
	CheckNameAvailability func(ctx context.Context, locationName string, checkNameAvailabilityParameters armquantum.CheckNameAvailabilityParameters, options *armquantum.WorkspaceClientCheckNameAvailabilityOptions) (resp azfake.Responder[armquantum.WorkspaceClientCheckNameAvailabilityResponse], errResp azfake.ErrorResponder)
}

// NewWorkspaceServerTransport creates a new instance of WorkspaceServerTransport with the provided implementation.
// The returned WorkspaceServerTransport instance is connected to an instance of armquantum.WorkspaceClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewWorkspaceServerTransport(srv *WorkspaceServer) *WorkspaceServerTransport {
	return &WorkspaceServerTransport{srv: srv}
}

// WorkspaceServerTransport connects instances of armquantum.WorkspaceClient to instances of WorkspaceServer.
// Don't use this type directly, use NewWorkspaceServerTransport instead.
type WorkspaceServerTransport struct {
	srv *WorkspaceServer
}

// Do implements the policy.Transporter interface for WorkspaceServerTransport.
func (w *WorkspaceServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "WorkspaceClient.CheckNameAvailability":
		resp, err = w.dispatchCheckNameAvailability(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (w *WorkspaceServerTransport) dispatchCheckNameAvailability(req *http.Request) (*http.Response, error) {
	if w.srv.CheckNameAvailability == nil {
		return nil, &nonRetriableError{errors.New("fake for method CheckNameAvailability not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Quantum/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/checkNameAvailability`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armquantum.CheckNameAvailabilityParameters](req)
	if err != nil {
		return nil, err
	}
	locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.CheckNameAvailability(req.Context(), locationNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CheckNameAvailabilityResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
