// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package generic

import (
	"context"

	"code.forgejo.org/f3/gof3/v3/path"
)

type WalkFunc func(context.Context, path.Path, NodeInterface)

type WalkOptions struct {
	fun WalkFunc
}

func NewWalkOptions(fun WalkFunc) *WalkOptions {
	return &WalkOptions{
		fun: fun,
	}
}

type ApplyFunc func(ctx context.Context, parentPath, path path.Path, node NodeInterface)

type ApplyWhere bool

const (
	ApplyEachNode ApplyWhere = true
	ApplyLastNode ApplyWhere = false
)

type ApplySearch bool

const (
	ApplySearchByName ApplySearch = true
	ApplySearchByID   ApplySearch = false
)

type ApplyOptions struct {
	fun    ApplyFunc
	where  ApplyWhere
	search ApplySearch
}

func NewApplyOptions(fun ApplyFunc) *ApplyOptions {
	return &ApplyOptions{
		fun:    fun,
		where:  ApplyLastNode,
		search: ApplySearchByID,
	}
}

func (o *ApplyOptions) SetWhere(where ApplyWhere) *ApplyOptions {
	o.where = where
	return o
}

func (o *ApplyOptions) SetSearch(search ApplySearch) *ApplyOptions {
	o.search = search
	return o
}
