#ifndef `TEST'
  #message Use -D TEST=XXX
  #terminate
#else
  #include `NAME_' # `TEST'
#endif
.end

*--#[ jodavies_include :

* Paste denexpand.prc

* Expand a "den" function DEN in the variable EP. This is useful in cases
* where we have isolated the dependence on the EP symbol, and cannot merge
* everything into a common PolyRatFun without exceeding MaxTermSize.

* Den is expanded, and the resulting EP-independent coefficients are merged
* into a PolyRatFun PRF as we go. This should most likely be the same name
* as an existing PolyRatFun of EP-independent variables in the input.

Symbol denexpn,denexpm,denexpo,denexpi,denexpj;
CFunction denexpnum,denexpcollect,denexpprftmp;
.sort

#procedure denexpand(DEN,EP,DEPTH,PRF)

	#message denexpand.prc: expanding `DEN' for small `EP', depth `DEPTH'

*	Make sure the sorting mode is highfirst, to work around Issue 336
*	https://github.com/vermaseren/form/issues/336
	On highfirst;

*	PolyRatFun should be disabled initially
	PolyRatFun;

*	Check for multi-argument DEN, this is not expected input
	If (Match(`DEN'(denexpn?,denexpm?)) > 0);
		Print "denexpand.prc: Error: unexpected multi-argument `DEN': %t";
		Exit;
	EndIf;

*	Check PRF doesn't contain the expansion symbol:
	Argument `PRF';
		If (Count(`EP',1) != 0);
			Print "denexpand.prc: Error: unexpected `EP' in `PRF': %t";
			Exit;
		EndIf;
	EndArgument;

*	Extract any poles in EP:
	FactArg `DEN';
	ChainOut `DEN';
	Identify `DEN'(`EP') = 1/`EP';

*	Discard terms which are already beyond DEPTH, now that we are sure DEN contains no poles in EP:
	If (Count(`EP',1) > `DEPTH') Discard;
*	Discard EP powers within DEN, if they will produce terms beyond DEPTH.
*	Account for external negative powers:
	$denexptermEPmax = - count_(`EP',1) + `DEPTH';
	Argument `DEN';
		If (Count(`EP',1) > $denexptermEPmax) Discard;
	EndArgument;

*	Bring DENs to a unique form:
	FactArg `DEN';
	ChainOut `DEN';
	Normalize,^-1 `DEN';
	Identify `DEN'(1) = 1;

*	Record the highest order EP pole
	#$denexpMinEPpole = 0;                                                  
	If (Count(`EP',1) < $denexpMinEPpole) $denexpMinEPpole = count_(`EP',1);

*	Collect together the relevant terms
	AntiBracket `DEN',`EP',`PRF';
	ModuleOption,local $denexptermEPmax;
	ModuleOption,minimum $denexpMinEPpole;
	.sort:DE prep;
*	WORKAROUND (Issue 332)
	#if {-`$denexpMinEPpole'+`DEPTH'} <= 0
		#message denexpand.prc: setting power limit denexpEP(:1);
		Symbol denexpEP(:1);
	#else
		#message denexpand.prc: setting power limit denexpEP(:{-`$denexpMinEPpole'+`DEPTH'});
		Symbol denexpEP(:{-`$denexpMinEPpole'+`DEPTH'});
	#endif


	PolyRatFun `PRF';
	Collect denexpcollect;
*	This sort is necessary to work around Issue 336 ?
	.sort:DE coll;

	#ifdef `DENEXPANDVERBOSE'
		#$term = 1;
		Print "Starting Term %$ in thread %w ...", $term;
		$term = $term + 1;
	#endif

*	Fully compute each coefficient inside a Term environment. Since we used AntiBracket
*	above, the resulting series expansion will never merge with the other terms.
	Term;
*		Open the Collect, so that the PolyRatFuns will properly merge. They do not do so,
*		if we were to attempt the expansion inside the argument of denexpcollect.
		Identify denexpcollect(denexpn?) = denexpn;

*		Convert to power-limited EP symbol for speed, but only external powers and inside
*		the function we are expanding. The symbol might appear in tags, etc.
		Identify `EP' = denexpEP;
		Identify 1/`EP' = 1/denexpEP;
		Argument `DEN';
			Multiply replace_(`EP', denexpEP);
		EndArgument;

*		Change DEN notation
		SplitArg ((denexpEP)) `DEN';
		Transform `DEN' addargs(2,last);
*		A single-argument DEN has no EP dependence and can already be merged with PRF. Typically
*		this doesn't happen, but it depends how the input was prepared.
		Identify `DEN'(denexpj?) = `PRF'(1,denexpj);


*		Loop through the powers of denexpEP which should appear in the output, and fully compute each in turn.
		#do denexpPow = `$denexpMinEPpole',`DEPTH'

			Repeat;
				If (Count(denexpEP,1) == `denexpPow');
*					Expand one DEN by one power, then simplify
					Identify,Once `DEN'(denexpn?,denexpm?) =
						`PRF'(1,denexpn) - `PRF'(1,denexpn)*denexpnum(denexpm/denexpEP)*denexpEP*`DEN'(denexpn,denexpm);

*					Now extract possible denexpEP dependence, without fully expanding denexpnum:
					Repeat;
						SplitArg ((denexpEP)) denexpnum;
						Identify denexpnum(denexpEP) = denexpEP;
						Identify denexpnum(denexpn?) = `PRF'(denexpn,1);
						Transform denexpnum addargs(2,last);
						Identify denexpnum(denexpn?,denexpm?) = `PRF'(denexpn,1) + denexpEP*denexpnum(denexpm/denexpEP);
					EndRepeat;
				EndIf;
			EndRepeat;

*			Before starting the next power, remove terms in the DEN which would produce denexpEP powers beyond DEPTH
			$denexptermEPmax = - count_(denexpEP,1) + `DEPTH'; 
			Argument `DEN';
				If (Count(denexpEP,1) > $denexptermEPmax) Discard;
			EndArgument;
			Identify `DEN'(denexpn?,0) = `PRF'(1,denexpn);

			Sort;
		#enddo

	EndTerm;


*	Replace original EP symbol
	Multiply replace_(denexpEP,`EP');
	#ifdef `DENEXPANDVERBOSE'
		ModuleOption,local $term;
	#endif
	ModuleOption,local $denexptermEPmax;
	.sort:DE exp;
	#printtimes
*	End with PolyRatFun disabled again
	PolyRatFun;

#endprocedure


* Paste coefftools.h

Symbol coefftx,coeffty;

* Convert assumed previous PolyRatFun p (PolyRatFun should now be disabled)
* into products of num and den factors n and d.

#procedure prf2numden(prf,num,den)
	#message coefftools.h: prf2numden(`prf',`num',`den')
	Identify `prf'(coefftx?,coeffty?) = `num'(coefftx)*`den'(coeffty);
	FactArg `num';
	FactArg `den';
	ChainOut `num';
	ChainOut `den';
	Identify `num'(coefftx?number_) = coefftx;
	Identify `den'(coeffty?number_) = 1/coeffty;
#endprocedure


* Convert products of num and den factors n and d into a PolyRatFun p.
* If there are many such factors it is usually faster to loop over moving
* them into the PolyRatFun one at a time.

#procedure numden2prf(num,den,prf)
	#message coefftools.h: numden2prf(`num',`den',`prf')
*	Check for functions inside num, den, which will cause a crash:
	#$termprint = 0;
	Argument `num';
		If (Match(`num'?(?a)));
			$termprint = 1;
		EndIf;
	EndArgument;
	Argument `den';
		If (Match(`num'?(?a)));
			$termprint = 1;
		EndIf;
	EndArgument;
	If ($termprint == 1);
		Print "numden2prf: found a function inside `num' or `den': %t";
		Exit;
	EndIf;
	#do coeffti = 1,1
		#$coeffti = 1;
*		#message coefftools.h: numden2prf loop...
*		Identify,once `num'(coefftx?) = `prf'(coefftx,1);
*		Identify,once `den'(coeffty?) = `prf'(1,coeffty);
		Identify `num'(coefftx?) = `prf'(coefftx,1);
		Identify `den'(coeffty?) = `prf'(1,coeffty);
		If (Count(`num',1,`den',1) > 0) $coeffti = 0;
		ModuleOption,minimum $coeffti;
		ModuleOption,local $termprint;
		.sort(PolyRatFun=`prf')
		#redefine coeffti "`$coeffti'"
		#printtimes
	#enddo
	PolyRatFun;
*	Look for bug Issue 336. It is recommended to always use highfirst sort mode to avoid this.
	If (Match(`prf'(coefftx?,0)) > 0);
		Print "coefftools.h: numden2prf(`num',`den',`prf'): error: division by zero in: %t";
		Exit;
	EndIf;
	.sort
#endprocedure


* Extract S dependence from a numerator function n, which may contain a large sum of terms.
* For eg, #call extractfromnum(ep) will convert num(1+ep*x+ep*y) into 1 + ep*num(x+y).

#procedure extractfromnum(num,S)
	#message coefftools.h: extractfromnum(`num',`S')
	Repeat;
		SplitArg ((`S')) `num';
*		issue-269 workaround, see also https://arxiv.org/abs/math-ph/0010025
		Identify `num'(`S') = `S';
		Transform `num' addargs(2,last);
		Identify `num'(coefftx?,coeffty?) = `num'(coefftx) + `S'*`num'(coeffty/`S');
		FactArg `num';
		ChainOut `num';
		Identify `num'(coefftx?number_) = coefftx;
*		For cases which contained nested num, which already factorized the coefficients of S:
		Repeat Identify `num'(`num'(coefftx?)) = `num'(coefftx);
*		The below leads to horrible performance with lots of expansion followed by re-factorization
*		in the code above. I don't remember why I introduced these lines in the first place, instead
*		to the line above.
*		Argument `num';
*			If (Count(`S',1) == 0) Repeat Identify `num'(coefftx?) = coefftx;
*		EndArgument;
	EndRepeat;
#endprocedure


* It is sometimes useful to rename denominator functions den as deniso, if they
* contain dependence on a particular symbol S.
* For eg, #call isolateden(den,ep,denep) will convert den(x+y)*den(ep*x+y) into
* den(x+y)*denep(ep*x+y).

#procedure isolateden(den,S,deniso)
	#message coefftools.h: isolateden(`den',`S',`deniso')
	FactArg `den';
	ChainOut `den';
	Identify `den'(coefftx?number_) = 1/coefftx;
	SplitArg ((`S')) `den';
	Transform `den' addargs(2,last);
	Identify `den'(`S') = 1/`S';
	Identify `den'(coefftx?,coeffty?) = `deniso'(coefftx+coeffty);
#endprocedure


* Try to factorize the specified list of variables, putting them into products of
* numerator function num. ?S may contain num itself, but should not contain den.
* Try to cancel against any existing den functions.

#procedure mergeterms(num,den,?S)
	AntiBracket `?S';
	.sort
	#message coefftools.h: mergeterms(`num',`den',`?S')
	Collect `num';
	Argument `num';
		Repeat Identify `num'(coefftx?) = coefftx;
		If (Count(`den',1) > 0);
			Print "coefftools.h: mergeterms: `num' should not contain `den' in input: %t";
		EndIf;
	EndArgument;
	FactArg `num';
	ChainOut `num';
	Identify `num'(coefftx?number_) = coefftx;
	Normalize `num';
	Normalize^-1 `den';
	Identify `num'(coefftx?)*`den'(coefftx?) = 1;
#endprocedure
*--#] jodavies_include :
*--#[ jodavies_denexpand :
#-

Off Statistics;
On Highfirst;

#include- user.frm # jodavies_include

#define NUMTESTS "28"

AutoDeclare Symbol n,m;
Symbol ep;
CFunction prf,den,denep,num,prfexpden;


#do EXPDEPTH = {-1,0,1,5}
	Drop;
	.sort

	Local test1 = prf((n0+ep*n1+ep^2*n2+ep^3*n3),(m0+ep*m1+ep^2*m2+ep^3*m3));
	Local test2 = prf((n0+ep*n1+ep^2*n2+ep^3*n3),ep*(m0+ep*m1+ep^2*m2+ep^3*m3));
	Local test3 = prf(ep*(n0+ep*n1+ep^2*n2+ep^3*n3),(m0+ep*m1+ep^2*m2+ep^3*m3));
	Local test4 = prf(ep*(n0+ep*n1+ep^2*n2+ep^3*n3),ep*(m0+ep*m1+ep^2*m2+ep^3*m3));
	Local test5 = prf((n0+ep*n1+ep^2*n2+ep^3*n3+ep^4*n4+ep^5*n5+ep^6*n6),(m0+ep*m1+ep^2*m2+ep^3*m3));
	Local test6 = prf((n0+ep*n1+ep^2*n2+ep^3*n3+ep^4*n4+ep^5*n5+ep^6*n6),ep*(m0+ep*m1+ep^2*m2+ep^3*m3));
	Local test7 = prf(ep*(n0+ep*n1+ep^2*n2+ep^3*n3+ep^4*n4+ep^5*n5+ep^6*n6),(m0+ep*m1+ep^2*m2+ep^3*m3));
	Local test8 = prf(ep*(n0+ep*n1+ep^2*n2+ep^3*n3+ep^4*n4+ep^5*n5+ep^6*n6),ep*(m0+ep*m1+ep^2*m2+ep^3*m3));
	Local test9 = prf((n0+ep*n1+ep^2*n2+ep^3*n3+ep^4*n4+ep^5*n5+ep^6*n6),(m0+ep*m1+ep^2*m2+ep^3*m3+ep^4*m4+ep^5*m5+ep^6*m6));
	Local test10 = prf((n0+ep*n1+ep^2*n2+ep^3*n3+ep^4*n4+ep^5*n5+ep^6*n6),ep*(m0+ep*m1+ep^2*m2+ep^3*m3+ep^4*m4+ep^5*m5+ep^6*m6));
	Local test11 = prf(ep*(n0+ep*n1+ep^2*n2+ep^3*n3+ep^4*n4+ep^5*n5+ep^6*n6),(m0+ep*m1+ep^2*m2+ep^3*m3+ep^4*m4+ep^5*m5+ep^6*m6));
	Local test12 = prf(ep*(n0+ep*n1+ep^2*n2+ep^3*n3+ep^4*n4+ep^5*n5+ep^6*n6),ep*(m0+ep*m1+ep^2*m2+ep^3*m3+ep^4*m4+ep^5*m5+ep^6*m6));
	Local test13 = prf((n0+ep*n1+ep^2*n2+ep^3*n3),(ep*m0+ep*m1+ep^2*m2+ep^3*m3));
	Local test14 = prf((n0+ep*n1+ep^2*n2+ep^3*n3),ep*(ep*m0+ep*m1+ep^2*m2+ep^3*m3));
	Local test15 = prf(ep*(n0+ep*n1+ep^2*n2+ep^3*n3),(ep*m0+ep*m1+ep^2*m2+ep^3*m3));
	Local test16 = prf(ep*(n0+ep*n1+ep^2*n2+ep^3*n3),ep*(ep*m0+ep*m1+ep^2*m2+ep^3*m3));
	Local test17 = prf(1,1+ep);
	Local test18 = prf(1,ep^5*(1+ep));
	Local test19 = prf(1,ep^5*(1+2*ep));
	Local test20 = prf(1,1);
	Local test21 = prf(1,1+ep)+prf(-1,1)+prf(ep,1+ep);
	Local test22 = prf(1,ep);
	Local test23 = prf(ep,ep);
	Local test24 = prf(0,ep);
	Local test25 = prf(0,1);
	Local test26 = prf(ep^6,1);
	Local test27 = prf(ep^7,ep);
*	This test breaks if the internal power limit is set to zero:
	Local test28 = prf(1,m0+m1+ep*(m0+m1));

*	Format for denexpand
	#call prf2numden(prf,num,den)
	#call extractfromnum(num,ep)
	#call isolateden(den,ep,denep)
	#call numden2prf(num,den,prf)
	.sort

	#call denexpand(denep,ep,`EXPDEPTH',prf)

	Local result1 = n0*prfexpden(m0) + ep*(-(m1*n0) + m0*n1)*prfexpden(m0)^2 + ep^2*(m1^2*n0 - m0*m2*n0 - m0*m1*n1 + m0^2*n2)*prfexpden(m0)^3 + ep^3*(-(m1^3*n0) + 2*m0*m1*m2*n0 - m0^2*m3*n0 + m0*m1^2*n1 - m0^2*m2*n1 - m0^2*m1*n2 + m0^3*n3)*prfexpden(m0)^4 + ep^4*(m1^4*n0 - 3*m0*m1^2*m2*n0 + m0^2*m2^2*n0 + 2*m0^2*m1*m3*n0 - m0*m1^3*n1 + 2*m0^2*m1*m2*n1 - m0^3*m3*n1 + m0^2*m1^2*n2 - m0^3*m2*n2 - m0^3*m1*n3)*prfexpden(m0)^5 + ep^5*(-(m1^5*n0) + 4*m0*m1^3*m2*n0 - 3*m0^2*m1*m2^2*n0 - 3*m0^2*m1^2*m3*n0 + 2*m0^3*m2*m3*n0 + m0*m1^4*n1 - 3*m0^2*m1^2*m2*n1 + m0^3*m2^2*n1 + 2*m0^3*m1*m3*n1 - m0^2*m1^3*n2 + 2*m0^3*m1*m2*n2 - m0^4*m3*n2 + m0^3*m1^2*n3 - m0^4*m2*n3)*prfexpden(m0)^6;
	Local result2 = n0*prfexpden(ep)*prfexpden(m0) + (-(m1*n0) + m0*n1)*prfexpden(m0)^2 + ep*(m1^2*n0 - m0*m2*n0 - m0*m1*n1 + m0^2*n2)*prfexpden(m0)^3 + ep^2*(n3*prfexpden(m0) - m1*n2*prfexpden(m0)^2 + (m1^2 - m0*m2)*n1*prfexpden(m0)^3 + (-m1^3 + 2*m0*m1*m2 - m0^2*m3)*n0*prfexpden(m0)^4) + ep^3*(-(m1*n3*prfexpden(m0)^2) + (m1^2 - m0*m2)*n2*prfexpden(m0)^3 + (-m1^3 + 2*m0*m1*m2 - m0^2*m3)*n1*prfexpden(m0)^4 + (m1^4 - 3*m0*m1^2*m2 + m0^2*m2^2 + 2*m0^2*m1*m3)*n0*prfexpden(m0)^5) + ep^4*((m1^2 - m0*m2)*n3*prfexpden(m0)^3 + (-m1^3 + 2*m0*m1*m2 - m0^2*m3)*n2*prfexpden(m0)^4 + (m1^4 - 3*m0*m1^2*m2 + m0^2*m2^2 + 2*m0^2*m1*m3)*n1*prfexpden(m0)^5 + (-m1^5 + 4*m0*m1^3*m2 - 3*m0^2*m1*m2^2 - 3*m0^2*m1^2*m3 + 2*m0^3*m2*m3)*n0*prfexpden(m0)^6) + ep^5*((-m1^3 + 2*m0*m1*m2 - m0^2*m3)*n3*prfexpden(m0)^4 + (m1^4 - 3*m0*m1^2*m2 + m0^2*m2^2 + 2*m0^2*m1*m3)*n2*prfexpden(m0)^5 + (-m1^5 + 4*m0*m1^3*m2 - 3*m0^2*m1*m2^2 - 3*m0^2*m1^2*m3 + 2*m0^3*m2*m3)*n1*prfexpden(m0)^6 + (m1^6 - 5*m0*m1^4*m2 + 6*m0^2*m1^2*m2^2 - m0^3*m2^3 + 4*m0^2*m1^3*m3 - 6*m0^3*m1*m2*m3 + m0^4*m3^2)*n0*prfexpden(m0)^7);
	Local result3 = ep*n0*prfexpden(m0) + ep^2*(-(m1*n0) + m0*n1)*prfexpden(m0)^2 + ep^3*(m1^2*n0 - m0*m2*n0 - m0*m1*n1 + m0^2*n2)*prfexpden(m0)^3 + ep^4*(-(m1^3*n0) + 2*m0*m1*m2*n0 - m0^2*m3*n0 + m0*m1^2*n1 - m0^2*m2*n1 - m0^2*m1*n2 + m0^3*n3)*prfexpden(m0)^4 + ep^5*(m1^4*n0 - 3*m0*m1^2*m2*n0 + m0^2*m2^2*n0 + 2*m0^2*m1*m3*n0 - m0*m1^3*n1 + 2*m0^2*m1*m2*n1 - m0^3*m3*n1 + m0^2*m1^2*n2 - m0^3*m2*n2 - m0^3*m1*n3)*prfexpden(m0)^5;
	Local result4 = n0*prfexpden(m0) + ep*(-(m1*n0) + m0*n1)*prfexpden(m0)^2 + ep^2*(m1^2*n0 - m0*m2*n0 - m0*m1*n1 + m0^2*n2)*prfexpden(m0)^3 + ep^3*(-(m1^3*n0) + 2*m0*m1*m2*n0 - m0^2*m3*n0 + m0*m1^2*n1 - m0^2*m2*n1 - m0^2*m1*n2 + m0^3*n3)*prfexpden(m0)^4 + ep^4*(m1^4*n0 - 3*m0*m1^2*m2*n0 + m0^2*m2^2*n0 + 2*m0^2*m1*m3*n0 - m0*m1^3*n1 + 2*m0^2*m1*m2*n1 - m0^3*m3*n1 + m0^2*m1^2*n2 - m0^3*m2*n2 - m0^3*m1*n3)*prfexpden(m0)^5 + ep^5*(-(m1^5*n0) + 4*m0*m1^3*m2*n0 - 3*m0^2*m1*m2^2*n0 - 3*m0^2*m1^2*m3*n0 + 2*m0^3*m2*m3*n0 + m0*m1^4*n1 - 3*m0^2*m1^2*m2*n1 + m0^3*m2^2*n1 + 2*m0^3*m1*m3*n1 - m0^2*m1^3*n2 + 2*m0^3*m1*m2*n2 - m0^4*m3*n2 + m0^3*m1^2*n3 - m0^4*m2*n3)*prfexpden(m0)^6;
	Local result5 = n0*prfexpden(m0) + ep*(-(m1*n0) + m0*n1)*prfexpden(m0)^2 + ep^2*(m1^2*n0 - m0*m2*n0 - m0*m1*n1 + m0^2*n2)*prfexpden(m0)^3 + ep^3*(-(m1^3*n0) + 2*m0*m1*m2*n0 - m0^2*m3*n0 + m0*m1^2*n1 - m0^2*m2*n1 - m0^2*m1*n2 + m0^3*n3)*prfexpden(m0)^4 + ep^4*(m1^4*n0 - 3*m0*m1^2*m2*n0 + m0^2*m2^2*n0 + 2*m0^2*m1*m3*n0 - m0*m1^3*n1 + 2*m0^2*m1*m2*n1 - m0^3*m3*n1 + m0^2*m1^2*n2 - m0^3*m2*n2 - m0^3*m1*n3 + m0^4*n4)*prfexpden(m0)^5 + ep^5*(-(m1^5*n0) + 4*m0*m1^3*m2*n0 - 3*m0^2*m1*m2^2*n0 - 3*m0^2*m1^2*m3*n0 + 2*m0^3*m2*m3*n0 + m0*m1^4*n1 - 3*m0^2*m1^2*m2*n1 + m0^3*m2^2*n1 + 2*m0^3*m1*m3*n1 - m0^2*m1^3*n2 + 2*m0^3*m1*m2*n2 - m0^4*m3*n2 + m0^3*m1^2*n3 - m0^4*m2*n3 - m0^4*m1*n4 + m0^5*n5)*prfexpden(m0)^6;
	Local result6 = n0*prfexpden(ep)*prfexpden(m0) + (-(m1*n0) + m0*n1)*prfexpden(m0)^2 + ep*(m1^2*n0 - m0*m2*n0 - m0*m1*n1 + m0^2*n2)*prfexpden(m0)^3 + ep^2*(n3*prfexpden(m0) - m1*n2*prfexpden(m0)^2 + (m1^2 - m0*m2)*n1*prfexpden(m0)^3 + (-m1^3 + 2*m0*m1*m2 - m0^2*m3)*n0*prfexpden(m0)^4) + ep^3*(n4*prfexpden(m0) - m1*n3*prfexpden(m0)^2 + (m1^2 - m0*m2)*n2*prfexpden(m0)^3 + (-m1^3 + 2*m0*m1*m2 - m0^2*m3)*n1*prfexpden(m0)^4 + (m1^4 - 3*m0*m1^2*m2 + m0^2*m2^2 + 2*m0^2*m1*m3)*n0*prfexpden(m0)^5) + ep^4*(n5*prfexpden(m0) - m1*n4*prfexpden(m0)^2 + (m1^2 - m0*m2)*n3*prfexpden(m0)^3 + (-m1^3 + 2*m0*m1*m2 - m0^2*m3)*n2*prfexpden(m0)^4 + (m1^4 - 3*m0*m1^2*m2 + m0^2*m2^2 + 2*m0^2*m1*m3)*n1*prfexpden(m0)^5 + (-m1^5 + 4*m0*m1^3*m2 - 3*m0^2*m1*m2^2 - 3*m0^2*m1^2*m3 + 2*m0^3*m2*m3)*n0*prfexpden(m0)^6) + ep^5*(n6*prfexpden(m0) - m1*n5*prfexpden(m0)^2 + (m1^2 - m0*m2)*n4*prfexpden(m0)^3 + (-m1^3 + 2*m0*m1*m2 - m0^2*m3)*n3*prfexpden(m0)^4 + (m1^4 - 3*m0*m1^2*m2 + m0^2*m2^2 + 2*m0^2*m1*m3)*n2*prfexpden(m0)^5 + (-m1^5 + 4*m0*m1^3*m2 - 3*m0^2*m1*m2^2 - 3*m0^2*m1^2*m3 + 2*m0^3*m2*m3)*n1*prfexpden(m0)^6 + (m1^6 - 5*m0*m1^4*m2 + 6*m0^2*m1^2*m2^2 - m0^3*m2^3 + 4*m0^2*m1^3*m3 - 6*m0^3*m1*m2*m3 + m0^4*m3^2)*n0*prfexpden(m0)^7);
	Local result7 = ep*n0*prfexpden(m0) + ep^2*(-(m1*n0) + m0*n1)*prfexpden(m0)^2 + ep^3*(m1^2*n0 - m0*m2*n0 - m0*m1*n1 + m0^2*n2)*prfexpden(m0)^3 + ep^4*(-(m1^3*n0) + 2*m0*m1*m2*n0 - m0^2*m3*n0 + m0*m1^2*n1 - m0^2*m2*n1 - m0^2*m1*n2 + m0^3*n3)*prfexpden(m0)^4 + ep^5*(m1^4*n0 - 3*m0*m1^2*m2*n0 + m0^2*m2^2*n0 + 2*m0^2*m1*m3*n0 - m0*m1^3*n1 + 2*m0^2*m1*m2*n1 - m0^3*m3*n1 + m0^2*m1^2*n2 - m0^3*m2*n2 - m0^3*m1*n3 + m0^4*n4)*prfexpden(m0)^5;
	Local result8 = n0*prfexpden(m0) + ep*(-(m1*n0) + m0*n1)*prfexpden(m0)^2 + ep^2*(m1^2*n0 - m0*m2*n0 - m0*m1*n1 + m0^2*n2)*prfexpden(m0)^3 + ep^3*(-(m1^3*n0) + 2*m0*m1*m2*n0 - m0^2*m3*n0 + m0*m1^2*n1 - m0^2*m2*n1 - m0^2*m1*n2 + m0^3*n3)*prfexpden(m0)^4 + ep^4*(m1^4*n0 - 3*m0*m1^2*m2*n0 + m0^2*m2^2*n0 + 2*m0^2*m1*m3*n0 - m0*m1^3*n1 + 2*m0^2*m1*m2*n1 - m0^3*m3*n1 + m0^2*m1^2*n2 - m0^3*m2*n2 - m0^3*m1*n3 + m0^4*n4)*prfexpden(m0)^5 + ep^5*(-(m1^5*n0) + 4*m0*m1^3*m2*n0 - 3*m0^2*m1*m2^2*n0 - 3*m0^2*m1^2*m3*n0 + 2*m0^3*m2*m3*n0 + m0*m1^4*n1 - 3*m0^2*m1^2*m2*n1 + m0^3*m2^2*n1 + 2*m0^3*m1*m3*n1 - m0^2*m1^3*n2 + 2*m0^3*m1*m2*n2 - m0^4*m3*n2 + m0^3*m1^2*n3 - m0^4*m2*n3 - m0^4*m1*n4 + m0^5*n5)*prfexpden(m0)^6;
	Local result9 = n0*prfexpden(m0) + ep*(-(m1*n0) + m0*n1)*prfexpden(m0)^2 + ep^2*(m1^2*n0 - m0*m2*n0 - m0*m1*n1 + m0^2*n2)*prfexpden(m0)^3 + ep^3*(n3*prfexpden(m0) - m1*n2*prfexpden(m0)^2 + (m1^2 - m0*m2)*n1*prfexpden(m0)^3 + (-m1^3 + 2*m0*m1*m2 - m0^2*m3)*n0*prfexpden(m0)^4) + ep^4*(n4*prfexpden(m0) - m1*n3*prfexpden(m0)^2 + (m1^2 - m0*m2)*n2*prfexpden(m0)^3 + (-m1^3 + 2*m0*m1*m2 - m0^2*m3)*n1*prfexpden(m0)^4 + (m1^4 - 3*m0*m1^2*m2 + m0^2*m2^2 + 2*m0^2*m1*m3 - m0^3*m4)*n0*prfexpden(m0)^5) + ep^5*(n5*prfexpden(m0) - m1*n4*prfexpden(m0)^2 + (m1^2 - m0*m2)*n3*prfexpden(m0)^3 + (-m1^3 + 2*m0*m1*m2 - m0^2*m3)*n2*prfexpden(m0)^4 + (m1^4 - 3*m0*m1^2*m2 + m0^2*m2^2 + 2*m0^2*m1*m3 - m0^3*m4)*n1*prfexpden(m0)^5 + (-m1^5 + 4*m0*m1^3*m2 - 3*m0^2*m1*m2^2 - 3*m0^2*m1^2*m3 + 2*m0^3*m2*m3 + 2*m0^3*m1*m4 - m0^4*m5)*n0*prfexpden(m0)^6);
	Local result10 = n0*prfexpden(ep)*prfexpden(m0) + (-(m1*n0) + m0*n1)*prfexpden(m0)^2 + ep*(m1^2*n0 - m0*m2*n0 - m0*m1*n1 + m0^2*n2)*prfexpden(m0)^3 + ep^2*(n3*prfexpden(m0) - m1*n2*prfexpden(m0)^2 + (m1^2 - m0*m2)*n1*prfexpden(m0)^3 + (-m1^3 + 2*m0*m1*m2 - m0^2*m3)*n0*prfexpden(m0)^4) + ep^3*(n4*prfexpden(m0) - m1*n3*prfexpden(m0)^2 + (m1^2 - m0*m2)*n2*prfexpden(m0)^3 + (-m1^3 + 2*m0*m1*m2 - m0^2*m3)*n1*prfexpden(m0)^4 + (m1^4 - 3*m0*m1^2*m2 + m0^2*m2^2 + 2*m0^2*m1*m3 - m0^3*m4)*n0*prfexpden(m0)^5) + ep^4*(n5*prfexpden(m0) - m1*n4*prfexpden(m0)^2 + (m1^2 - m0*m2)*n3*prfexpden(m0)^3 + (-m1^3 + 2*m0*m1*m2 - m0^2*m3)*n2*prfexpden(m0)^4 + (m1^4 - 3*m0*m1^2*m2 + m0^2*m2^2 + 2*m0^2*m1*m3 - m0^3*m4)*n1*prfexpden(m0)^5 + (-m1^5 + 4*m0*m1^3*m2 - 3*m0^2*m1*m2^2 - 3*m0^2*m1^2*m3 + 2*m0^3*m2*m3 + 2*m0^3*m1*m4 - m0^4*m5)*n0*prfexpden(m0)^6) + ep^5*(n6*prfexpden(m0) - m1*n5*prfexpden(m0)^2 + (m1^2 - m0*m2)*n4*prfexpden(m0)^3 + (-m1^3 + 2*m0*m1*m2 - m0^2*m3)*n3*prfexpden(m0)^4 + (m1^4 - 3*m0*m1^2*m2 + m0^2*m2^2 + 2*m0^2*m1*m3 - m0^3*m4)*n2*prfexpden(m0)^5 + (-m1^5 + 4*m0*m1^3*m2 - 3*m0^2*m1*m2^2 - 3*m0^2*m1^2*m3 + 2*m0^3*m2*m3 + 2*m0^3*m1*m4 - m0^4*m5)*n1*prfexpden(m0)^6 + (m1^6 - 5*m0*m1^4*m2 + 6*m0^2*m1^2*m2^2 - m0^3*m2^3 + 4*m0^2*m1^3*m3 - 6*m0^3*m1*m2*m3 + m0^4*m3^2 - 3*m0^3*m1^2*m4 + 2*m0^4*m2*m4 + 2*m0^4*m1*m5 - m0^5*m6)*n0*prfexpden(m0)^7);
	Local result11 = ep*n0*prfexpden(m0) + ep^2*(-(m1*n0) + m0*n1)*prfexpden(m0)^2 + ep^3*(m1^2*n0 - m0*m2*n0 - m0*m1*n1 + m0^2*n2)*prfexpden(m0)^3 + ep^4*(-(m1^3*n0) + 2*m0*m1*m2*n0 - m0^2*m3*n0 + m0*m1^2*n1 - m0^2*m2*n1 - m0^2*m1*n2 + m0^3*n3)*prfexpden(m0)^4 + ep^5*(m1^4*n0 - 3*m0*m1^2*m2*n0 + m0^2*m2^2*n0 + 2*m0^2*m1*m3*n0 - m0^3*m4*n0 - m0*m1^3*n1 + 2*m0^2*m1*m2*n1 - m0^3*m3*n1 + m0^2*m1^2*n2 - m0^3*m2*n2 - m0^3*m1*n3 + m0^4*n4)*prfexpden(m0)^5;
	Local result12 = n0*prfexpden(m0) + ep*(-(m1*n0) + m0*n1)*prfexpden(m0)^2 + ep^2*(m1^2*n0 - m0*m2*n0 - m0*m1*n1 + m0^2*n2)*prfexpden(m0)^3 + ep^3*(n3*prfexpden(m0) - m1*n2*prfexpden(m0)^2 + (m1^2 - m0*m2)*n1*prfexpden(m0)^3 + (-m1^3 + 2*m0*m1*m2 - m0^2*m3)*n0*prfexpden(m0)^4) + ep^4*(n4*prfexpden(m0) - m1*n3*prfexpden(m0)^2 + (m1^2 - m0*m2)*n2*prfexpden(m0)^3 + (-m1^3 + 2*m0*m1*m2 - m0^2*m3)*n1*prfexpden(m0)^4 + (m1^4 - 3*m0*m1^2*m2 + m0^2*m2^2 + 2*m0^2*m1*m3 - m0^3*m4)*n0*prfexpden(m0)^5) + ep^5*(n5*prfexpden(m0) - m1*n4*prfexpden(m0)^2 + (m1^2 - m0*m2)*n3*prfexpden(m0)^3 + (-m1^3 + 2*m0*m1*m2 - m0^2*m3)*n2*prfexpden(m0)^4 + (m1^4 - 3*m0*m1^2*m2 + m0^2*m2^2 + 2*m0^2*m1*m3 - m0^3*m4)*n1*prfexpden(m0)^5 + (-m1^5 + 4*m0*m1^3*m2 - 3*m0^2*m1*m2^2 - 3*m0^2*m1^2*m3 + 2*m0^3*m2*m3 + 2*m0^3*m1*m4 - m0^4*m5)*n0*prfexpden(m0)^6);
	Local result13 = n1*prfexpden(m0 + m1) + n0*prfexpden(ep)*prfexpden(m0 + m1) - m2*n0*prfexpden(m0 + m1)^2 + ep*(n2*prfexpden(m0 + m1) - m2*n1*prfexpden(m0 + m1)^2 + (m2^2 - m0*m3 - m1*m3)*n0*prfexpden(m0 + m1)^3) + ep^2*(n3*prfexpden(m0 + m1) - m2*n2*prfexpden(m0 + m1)^2 + (m2^2 - m0*m3 - m1*m3)*n1*prfexpden(m0 + m1)^3 + (-m2^3 + 2*m0*m2*m3 + 2*m1*m2*m3)*n0*prfexpden(m0 + m1)^4) + ep^3*(-(m2*n3*prfexpden(m0 + m1)^2) + (m2^2 - m0*m3 - m1*m3)*n2*prfexpden(m0 + m1)^3 + (-m2^3 + 2*m0*m2*m3 + 2*m1*m2*m3)*n1*prfexpden(m0 + m1)^4 + n0*prfexpden(m0 + m1)*(m3^2*prfexpden(m0 + m1)^2 - 3*m2^2*m3*prfexpden(m0 + m1)^3 + m2^4*prfexpden(m0 + m1)^4)) + ep^4*((m2^2 - m0*m3 - m1*m3)*n3*prfexpden(m0 + m1)^3 + (-m2^3 + 2*m0*m2*m3 + 2*m1*m2*m3)*n2*prfexpden(m0 + m1)^4 + n1*prfexpden(m0 + m1)*(m3^2*prfexpden(m0 + m1)^2 - 3*m2^2*m3*prfexpden(m0 + m1)^3 + m2^4*prfexpden(m0 + m1)^4) + n0*prfexpden(m0 + m1)*(-3*m2*m3^2*prfexpden(m0 + m1)^3 + 4*m2^3*m3*prfexpden(m0 + m1)^4 - m2^5*prfexpden(m0 + m1)^5)) + ep^5*((-m2^3 + 2*m0*m2*m3 + 2*m1*m2*m3)*n3*prfexpden(m0 + m1)^4 + n2*prfexpden(m0 + m1)*(m3^2*prfexpden(m0 + m1)^2 - 3*m2^2*m3*prfexpden(m0 + m1)^3 + m2^4*prfexpden(m0 + m1)^4) + n1*prfexpden(m0 + m1)*(-3*m2*m3^2*prfexpden(m0 + m1)^3 + 4*m2^3*m3*prfexpden(m0 + m1)^4 - m2^5*prfexpden(m0 + m1)^5) + n0*prfexpden(m0 + m1)*(-(m3^3*prfexpden(m0 + m1)^3) + 6*m2^2*m3^2*prfexpden(m0 + m1)^4 - 5*m2^4*m3*prfexpden(m0 + m1)^5 + m2^6*prfexpden(m0 + m1)^6));
	Local result14 = n2*prfexpden(m0 + m1) + n0*prfexpden(ep)^2*prfexpden(m0 + m1) - m2*n1*prfexpden(m0 + m1)^2 + (m2^2 - m0*m3 - m1*m3)*n0*prfexpden(m0 + m1)^3 + prfexpden(ep)*(n1*prfexpden(m0 + m1) - m2*n0*prfexpden(m0 + m1)^2) + ep*(n3*prfexpden(m0 + m1) - m2*n2*prfexpden(m0 + m1)^2 + (m2^2 - m0*m3 - m1*m3)*n1*prfexpden(m0 + m1)^3 + (-m2^3 + 2*m0*m2*m3 + 2*m1*m2*m3)*n0*prfexpden(m0 + m1)^4) + ep^2*(-(m2*n3*prfexpden(m0 + m1)^2) + (m2^2 - m0*m3 - m1*m3)*n2*prfexpden(m0 + m1)^3 + (-m2^3 + 2*m0*m2*m3 + 2*m1*m2*m3)*n1*prfexpden(m0 + m1)^4 + n0*prfexpden(m0 + m1)*(m3^2*prfexpden(m0 + m1)^2 - 3*m2^2*m3*prfexpden(m0 + m1)^3 + m2^4*prfexpden(m0 + m1)^4)) + ep^3*((m2^2 - m0*m3 - m1*m3)*n3*prfexpden(m0 + m1)^3 + (-m2^3 + 2*m0*m2*m3 + 2*m1*m2*m3)*n2*prfexpden(m0 + m1)^4 + n1*prfexpden(m0 + m1)*(m3^2*prfexpden(m0 + m1)^2 - 3*m2^2*m3*prfexpden(m0 + m1)^3 + m2^4*prfexpden(m0 + m1)^4) + n0*prfexpden(m0 + m1)*(-3*m2*m3^2*prfexpden(m0 + m1)^3 + 4*m2^3*m3*prfexpden(m0 + m1)^4 - m2^5*prfexpden(m0 + m1)^5)) + ep^4*((-m2^3 + 2*m0*m2*m3 + 2*m1*m2*m3)*n3*prfexpden(m0 + m1)^4 + n2*prfexpden(m0 + m1)*(m3^2*prfexpden(m0 + m1)^2 - 3*m2^2*m3*prfexpden(m0 + m1)^3 + m2^4*prfexpden(m0 + m1)^4) + n1*prfexpden(m0 + m1)*(-3*m2*m3^2*prfexpden(m0 + m1)^3 + 4*m2^3*m3*prfexpden(m0 + m1)^4 - m2^5*prfexpden(m0 + m1)^5) + n0*prfexpden(m0 + m1)*(-(m3^3*prfexpden(m0 + m1)^3) + 6*m2^2*m3^2*prfexpden(m0 + m1)^4 - 5*m2^4*m3*prfexpden(m0 + m1)^5 + m2^6*prfexpden(m0 + m1)^6)) + ep^5*(n3*prfexpden(m0 + m1)*(m3^2*prfexpden(m0 + m1)^2 - 3*m2^2*m3*prfexpden(m0 + m1)^3 + m2^4*prfexpden(m0 + m1)^4) + n2*prfexpden(m0 + m1)*(-3*m2*m3^2*prfexpden(m0 + m1)^3 + 4*m2^3*m3*prfexpden(m0 + m1)^4 - m2^5*prfexpden(m0 + m1)^5) + n1*prfexpden(m0 + m1)*(-(m3^3*prfexpden(m0 + m1)^3) + 6*m2^2*m3^2*prfexpden(m0 + m1)^4 - 5*m2^4*m3*prfexpden(m0 + m1)^5 + m2^6*prfexpden(m0 + m1)^6) + n0*prfexpden(m0 + m1)*(4*m2*m3^3*prfexpden(m0 + m1)^4 - 10*m2^3*m3^2*prfexpden(m0 + m1)^5 + 6*m2^5*m3*prfexpden(m0 + m1)^6 - m2^7*prfexpden(m0 + m1)^7));
	Local result15 = n0*prfexpden(m0 + m1) + ep*(n1*prfexpden(m0 + m1) - m2*n0*prfexpden(m0 + m1)^2) + ep^2*(n2*prfexpden(m0 + m1) - m2*n1*prfexpden(m0 + m1)^2 + (m2^2 - m0*m3 - m1*m3)*n0*prfexpden(m0 + m1)^3) + ep^3*(n3*prfexpden(m0 + m1) - m2*n2*prfexpden(m0 + m1)^2 + (m2^2 - m0*m3 - m1*m3)*n1*prfexpden(m0 + m1)^3 + (-m2^3 + 2*m0*m2*m3 + 2*m1*m2*m3)*n0*prfexpden(m0 + m1)^4) + ep^4*(-(m2*n3*prfexpden(m0 + m1)^2) + (m2^2 - m0*m3 - m1*m3)*n2*prfexpden(m0 + m1)^3 + (-m2^3 + 2*m0*m2*m3 + 2*m1*m2*m3)*n1*prfexpden(m0 + m1)^4 + n0*prfexpden(m0 + m1)*(m3^2*prfexpden(m0 + m1)^2 - 3*m2^2*m3*prfexpden(m0 + m1)^3 + m2^4*prfexpden(m0 + m1)^4)) + ep^5*((m2^2 - m0*m3 - m1*m3)*n3*prfexpden(m0 + m1)^3 + (-m2^3 + 2*m0*m2*m3 + 2*m1*m2*m3)*n2*prfexpden(m0 + m1)^4 + n1*prfexpden(m0 + m1)*(m3^2*prfexpden(m0 + m1)^2 - 3*m2^2*m3*prfexpden(m0 + m1)^3 + m2^4*prfexpden(m0 + m1)^4) + n0*prfexpden(m0 + m1)*(-3*m2*m3^2*prfexpden(m0 + m1)^3 + 4*m2^3*m3*prfexpden(m0 + m1)^4 - m2^5*prfexpden(m0 + m1)^5));
	Local result16 = n1*prfexpden(m0 + m1) + n0*prfexpden(ep)*prfexpden(m0 + m1) - m2*n0*prfexpden(m0 + m1)^2 + ep*(n2*prfexpden(m0 + m1) - m2*n1*prfexpden(m0 + m1)^2 + (m2^2 - m0*m3 - m1*m3)*n0*prfexpden(m0 + m1)^3) + ep^2*(n3*prfexpden(m0 + m1) - m2*n2*prfexpden(m0 + m1)^2 + (m2^2 - m0*m3 - m1*m3)*n1*prfexpden(m0 + m1)^3 + (-m2^3 + 2*m0*m2*m3 + 2*m1*m2*m3)*n0*prfexpden(m0 + m1)^4) + ep^3*(-(m2*n3*prfexpden(m0 + m1)^2) + (m2^2 - m0*m3 - m1*m3)*n2*prfexpden(m0 + m1)^3 + (-m2^3 + 2*m0*m2*m3 + 2*m1*m2*m3)*n1*prfexpden(m0 + m1)^4 + n0*prfexpden(m0 + m1)*(m3^2*prfexpden(m0 + m1)^2 - 3*m2^2*m3*prfexpden(m0 + m1)^3 + m2^4*prfexpden(m0 + m1)^4)) + ep^4*((m2^2 - m0*m3 - m1*m3)*n3*prfexpden(m0 + m1)^3 + (-m2^3 + 2*m0*m2*m3 + 2*m1*m2*m3)*n2*prfexpden(m0 + m1)^4 + n1*prfexpden(m0 + m1)*(m3^2*prfexpden(m0 + m1)^2 - 3*m2^2*m3*prfexpden(m0 + m1)^3 + m2^4*prfexpden(m0 + m1)^4) + n0*prfexpden(m0 + m1)*(-3*m2*m3^2*prfexpden(m0 + m1)^3 + 4*m2^3*m3*prfexpden(m0 + m1)^4 - m2^5*prfexpden(m0 + m1)^5)) + ep^5*((-m2^3 + 2*m0*m2*m3 + 2*m1*m2*m3)*n3*prfexpden(m0 + m1)^4 + n2*prfexpden(m0 + m1)*(m3^2*prfexpden(m0 + m1)^2 - 3*m2^2*m3*prfexpden(m0 + m1)^3 + m2^4*prfexpden(m0 + m1)^4) + n1*prfexpden(m0 + m1)*(-3*m2*m3^2*prfexpden(m0 + m1)^3 + 4*m2^3*m3*prfexpden(m0 + m1)^4 - m2^5*prfexpden(m0 + m1)^5) + n0*prfexpden(m0 + m1)*(-(m3^3*prfexpden(m0 + m1)^3) + 6*m2^2*m3^2*prfexpden(m0 + m1)^4 - 5*m2^4*m3*prfexpden(m0 + m1)^5 + m2^6*prfexpden(m0 + m1)^6));
	Local result17 = 1 - ep + ep^2 - ep^3 + ep^4 - ep^5;
	Local result18 = -1 + ep - ep^2 + ep^3 - ep^4 + ep^5 + prfexpden(ep) - prfexpden(ep)^2 + prfexpden(ep)^3 - prfexpden(ep)^4 + prfexpden(ep)^5;
	Local result19 = -32 + 64*ep - 128*ep^2 + 256*ep^3 - 512*ep^4 + 1024*ep^5 + 16*prfexpden(ep) - 8*prfexpden(ep)^2 + 4*prfexpden(ep)^3 - 2*prfexpden(ep)^4 + prfexpden(ep)^5;
	Local result20 = 1;
	Local result21 = 0;
	Local result22 = ep^-1;
	Local result23 = 1;
	Local result24 = 0;
	Local result25 = 0;
	Local result26 = 0;
	Local result27 = 0;
	Local result28 = prfexpden(m0 + m1) - ep*prfexpden(m0 + m1) + ep^2*prfexpden(m0 + m1) - ep^3*prfexpden(m0 + m1) + ep^4*prfexpden(m0 + m1) - ep^5*prfexpden(m0 + m1);
	.sort
	InExpression result1,...,result`NUMTESTS';
		Identify prfexpden(ep) = 1/ep;
		If (Count(ep,1) > `EXPDEPTH') Discard;
	EndInExpression;
	.sort

	PolyRatFun prf;
	Drop;
*	Compare
	#do i = 1,`NUMTESTS'
		Local diff`i' = test`i' - result`i';
	#enddo
*	Normalize notation between FORM and Mathematica results
	Identify prfexpden(n?) = prf(1,n);
	#do i = 0,10
		Identify n`i' = prf(n`i',1);
		Identify m`i' = prf(m`i',1);
	#enddo
	.sort

	#do i = 1,`NUMTESTS'
		#if `ZERO_diff`i'' == 0
			#message Error in test`i' EXPDEPTH `EXPDEPTH'
			#terminate
		#endif
	#enddo

#enddo

.end
# This causes a strange valgrind leak error, see #507
#pend_if valgrind?
assert succeeded?
*--#] jodavies_denexpand :
*--#[ jodavies_prf_1 :
#-

Off Statistics;
Off ThreadStats;

* PolyRatFun-heavy test based on mbox1l reduction from calc.

* LiteRed propagators defined as {M`j'^2-sp[p1+q1+q2], M`j'^2-sp[p1], M`j'^2-sp[p1+q2], M`j'^2-sp[p1+q1+q2+q3]},
* with SPs sp[q1,q1]=0;sp[q2,q2]=0;sp[q3,q3]=q33;sp[q1,q2]=q12;sp[q1,q3]=q13;sp[q2,q3]=q23;

* q1 --------------- q3
*        | 1   |
*       3|     |4
*        | 2   |
* q2 --------------- -q1-q2-q3


* Procedures cut from lrTopoTools.h
#procedure lrttMergeIndices(NAME)
	Repeat;
		Identify `NAME'(?a)*`NAME'(?b) = `NAME'(L,?a,L,?b);
		Repeat Identify `NAME'(?a,L,n1?,?b,L,n2?,?c) = `NAME'(?a,n1+n2,L,?b,L,?c);
		Identify `NAME'(?a,L,L) = `NAME'(?a);
	EndRepeat;
#endprocedure

#procedure lrttKin2Prf
	#do i = 1,`NUMEXTMOM'
		#do j = `i',`NUMEXTMOM'
			Identify q`i'`j'^n1? = prf(q`i'`j'^n1,1);
		#enddo
	#enddo
#endprocedure


#define j "1"
#define NUMEXTMOM "3"
* Without this mode, MaxTermSize requirement gets out of hand very quickly
#define MBOX1Lq33EQq44 "1"

Symbol L,n1,n2,n3,n4;
Symbol ep,q11,q12,q13,q22,q23,q33,M`j';
CFunction prf,tmpprf;
CFunction mbox1l,mbox1lm`j'm;

* 3,2,2,2 needs a 200K MaxTermSize. Explodes extremely quickly for any harder integrals.
Local test = mbox1l(2,1,1,1);
.sort
PolyRatFun prf;


#do red = 1,1
	#message mbox1l: reduction loop...
	Identify,ifmatch->jump mbox1l(n1?neg0_,n2?neg0_,n3?neg_,n4?{,>1}) = mbox1l(n1,-1+n2,2+n3,-1+n4)*prf(-q13^3-n3*q13^3-q13^2*q23-n3*q13^2*q23,q13^2*q33-n4*q13^2*q33+2*q13*q23*q33-2*n4*q13*q23*q33+q23^2*q33-n4*q23^2*q33-2*q12*q33^2+2*n4*q12*q33^2)+mbox1l(1+n1,n2,1+n3,-2+n4)*prf(2*M`j'^2*n1*q13+2*M`j'^2*n1*q33-2*n1*q13*q33-n1*q33^2,-2*M`j'^2*q33+2*M`j'^2*n4*q33)+mbox1l(1+n1,n2,1+n3,-1+n4)*prf(6*M`j'^2*n1*q13+4*M`j'^2*n1*q33-2*n1*q13*q33-n1*q33^2,-2*M`j'^2+2*M`j'^2*n4)+mbox1l(-1+n1,1+n2,1+n3,-1+n4)*prf(2*n2*q12*q13^2+2*n2*q13^3+2*n2*q12*q13*q23+4*n2*q13^2*q23+2*n2*q13*q23^2-2*n2*q12^2*q33-3*n2*q12*q13*q33+n2*q13^2*q33-n2*q12*q23*q33+2*n2*q13*q23*q33+n2*q23^2*q33-2*n2*q12*q33^2,q13^2*q33-n4*q13^2*q33+2*q13*q23*q33-2*n4*q13*q23*q33+q23^2*q33-n4*q23^2*q33-2*q12*q33^2+2*n4*q12*q33^2)+mbox1l(-1+n1,n2,2+n3,-1+n4)*prf(q12*q13^2+n3*q12*q13^2+2*q13^3+2*n3*q13^3+q12*q13*q23+n3*q12*q13*q23+3*q13^2*q23+3*n3*q13^2*q23+q13*q23^2+n3*q13*q23^2-3*q12*q13*q33-3*n3*q12*q13*q33+q13^2*q33+n3*q13^2*q33+q12*q23*q33+n3*q12*q23*q33+2*q13*q23*q33+2*n3*q13*q23*q33+q23^2*q33+n3*q23^2*q33-2*q12*q33^2-2*n3*q12*q33^2,q13^2*q33-n4*q13^2*q33+2*q13*q23*q33-2*n4*q13*q23*q33+q23^2*q33-n4*q23^2*q33-2*q12*q33^2+2*n4*q12*q33^2)+mbox1l(n1,1+n2,1+n3,-2+n4)*prf(-4*M`j'^2*n2*q12*q13^2-2*M`j'^2*n2*q13^3-4*M`j'^2*n2*q12*q13*q23-4*M`j'^2*n2*q13^2*q23-2*M`j'^2*n2*q13*q23^2+4*M`j'^2*n2*q12^2*q33+4*M`j'^2*n2*q12*q13*q33-2*M`j'^2*n2*q13^2*q33+2*n2*q13^3*q33-4*M`j'^2*n2*q13*q23*q33+4*n2*q13^2*q23*q33-2*M`j'^2*n2*q23^2*q33+2*n2*q13*q23^2*q33+4*M`j'^2*n2*q12*q33^2-4*n2*q12*q13*q33^2+n2*q13^2*q33^2+2*n2*q13*q23*q33^2+n2*q23^2*q33^2-2*n2*q12*q33^3,2*M`j'^2*q13^2*q33-2*M`j'^2*n4*q13^2*q33+4*M`j'^2*q13*q23*q33-4*M`j'^2*n4*q13*q23*q33+2*M`j'^2*q23^2*q33-2*M`j'^2*n4*q23^2*q33-4*M`j'^2*q12*q33^2+4*M`j'^2*n4*q12*q33^2)+mbox1l(n1,n2,2+n3,-2+n4)*prf(-2*M`j'^2*q12*q13^2-2*M`j'^2*n3*q12*q13^2-2*M`j'^2*q13^3-2*M`j'^2*n3*q13^3-2*M`j'^2*q12*q13*q23-2*M`j'^2*n3*q12*q13*q23-4*M`j'^2*q13^2*q23-4*M`j'^2*n3*q13^2*q23-2*M`j'^2*q13*q23^2-2*M`j'^2*n3*q13*q23^2+4*M`j'^2*q12*q13*q33+4*M`j'^2*n3*q12*q13*q33-2*M`j'^2*q13^2*q33-2*M`j'^2*n3*q13^2*q33+2*q13^3*q33+2*n3*q13^3*q33-4*M`j'^2*q13*q23*q33-4*M`j'^2*n3*q13*q23*q33+4*q13^2*q23*q33+4*n3*q13^2*q23*q33-2*M`j'^2*q23^2*q33-2*M`j'^2*n3*q23^2*q33+2*q13*q23^2*q33+2*n3*q13*q23^2*q33+4*M`j'^2*q12*q33^2+4*M`j'^2*n3*q12*q33^2-4*q12*q13*q33^2-4*n3*q12*q13*q33^2+q13^2*q33^2+n3*q13^2*q33^2+2*q13*q23*q33^2+2*n3*q13*q23*q33^2+q23^2*q33^2+n3*q23^2*q33^2-2*q12*q33^3-2*n3*q12*q33^3,2*M`j'^2*q13^2*q33-2*M`j'^2*n4*q13^2*q33+4*M`j'^2*q13*q23*q33-4*M`j'^2*n4*q13*q23*q33+2*M`j'^2*q23^2*q33-2*M`j'^2*n4*q23^2*q33-4*M`j'^2*q12*q33^2+4*M`j'^2*n4*q12*q33^2)+mbox1l(n1,n2,1+n3,-1+n4)*(tmpprf(ep,1)*prf(4*q13^3*q33+8*q13^2*q23*q33+4*q13*q23^2*q33-8*q12*q13*q33^2+2*q13^2*q33^2+4*q13*q23*q33^2+2*q23^2*q33^2-4*q12*q33^3,2*M`j'^2*q13^2*q33-2*M`j'^2*n4*q13^2*q33+4*M`j'^2*q13*q23*q33-4*M`j'^2*n4*q13*q23*q33+2*M`j'^2*q23^2*q33-2*M`j'^2*n4*q23^2*q33-4*M`j'^2*q12*q33^2+4*M`j'^2*n4*q12*q33^2)+prf(2*M`j'^2*n1*q13^3-2*M`j'^2*n2*q13^3+4*M`j'^2*n1*q13^2*q23-4*M`j'^2*n2*q13^2*q23+2*M`j'^2*n1*q13*q23^2-2*M`j'^2*n2*q13*q23^2+2*M`j'^2*q12*q13*q33-4*M`j'^2*n1*q12*q13*q33+2*M`j'^2*n2*q12*q13*q33+2*M`j'^2*n3*q12*q13*q33+2*M`j'^2*q13^2*q33+2*M`j'^2*n1*q13^2*q33-2*M`j'^2*n4*q13^2*q33-10*q13^3*q33+2*n1*q13^3*q33+2*n2*q13^3*q33+2*n3*q13^3*q33+4*n4*q13^3*q33-2*M`j'^2*q12*q23*q33+2*M`j'^2*n2*q12*q23*q33-2*M`j'^2*n3*q12*q23*q33+4*M`j'^2*q13*q23*q33+4*M`j'^2*n1*q13*q23*q33-4*M`j'^2*n4*q13*q23*q33-20*q13^2*q23*q33+4*n1*q13^2*q23*q33+4*n2*q13^2*q23*q33+4*n3*q13^2*q23*q33+8*n4*q13^2*q23*q33+2*M`j'^2*q23^2*q33+2*M`j'^2*n1*q23^2*q33-2*M`j'^2*n4*q23^2*q33-10*q13*q23^2*q33+2*n1*q13*q23^2*q33+2*n2*q13*q23^2*q33+2*n3*q13*q23^2*q33+4*n4*q13*q23^2*q33-4*M`j'^2*q12*q33^2-4*M`j'^2*n1*q12*q33^2+4*M`j'^2*n4*q12*q33^2+20*q12*q13*q33^2-4*n1*q12*q13*q33^2-4*n2*q12*q13*q33^2-4*n3*q12*q13*q33^2-8*n4*q12*q13*q33^2-5*q13^2*q33^2+n1*q13^2*q33^2+n2*q13^2*q33^2+n3*q13^2*q33^2+2*n4*q13^2*q33^2-10*q13*q23*q33^2+2*n1*q13*q23*q33^2+2*n2*q13*q23*q33^2+2*n3*q13*q23*q33^2+4*n4*q13*q23*q33^2-5*q23^2*q33^2+n1*q23^2*q33^2+n2*q23^2*q33^2+n3*q23^2*q33^2+2*n4*q23^2*q33^2+10*q12*q33^3-2*n1*q12*q33^3-2*n2*q12*q33^3-2*n3*q12*q33^3-4*n4*q12*q33^3,2*M`j'^2*q13^2*q33-2*M`j'^2*n4*q13^2*q33+4*M`j'^2*q13*q23*q33-4*M`j'^2*n4*q13*q23*q33+2*M`j'^2*q23^2*q33-2*M`j'^2*n4*q23^2*q33-4*M`j'^2*q12*q33^2+4*M`j'^2*n4*q12*q33^2))+mbox1l(n1,1+n2,1+n3,-1+n4)*prf(-4*M`j'^2*n2*q12*q13^3-4*M`j'^2*n2*q13^4-8*M`j'^2*n2*q12*q13^2*q23-12*M`j'^2*n2*q13^3*q23-4*M`j'^2*n2*q12*q13*q23^2-12*M`j'^2*n2*q13^2*q23^2-4*M`j'^2*n2*q13*q23^3+4*M`j'^2*n2*q12^2*q13*q33+4*M`j'^2*n2*q12*q13^2*q33-10*M`j'^2*n2*q13^3*q33+4*n2*q12*q13^3*q33+4*n2*q13^4*q33+4*M`j'^2*n2*q12^2*q23*q33+4*M`j'^2*n2*q12*q13*q23*q33-24*M`j'^2*n2*q13^2*q23*q33+8*n2*q12*q13^2*q23*q33+12*n2*q13^3*q23*q33-18*M`j'^2*n2*q13*q23^2*q33+4*n2*q12*q13*q23^2*q33+12*n2*q13^2*q23^2*q33-4*M`j'^2*n2*q23^3*q33+4*n2*q13*q23^3*q33+4*M`j'^2*n2*q12^2*q33^2+20*M`j'^2*n2*q12*q13*q33^2-8*n2*q12^2*q13*q33^2-4*M`j'^2*n2*q13^2*q33^2-6*n2*q12*q13^2*q33^2+4*n2*q13^3*q33^2+8*M`j'^2*n2*q12*q23*q33^2-8*M`j'^2*n2*q13*q23*q33^2-4*n2*q12*q13*q23*q33^2+10*n2*q13^2*q23*q33^2-4*M`j'^2*n2*q23^2*q33^2+2*n2*q12*q23^2*q33^2+8*n2*q13*q23^2*q33^2+2*n2*q23^3*q33^2+8*M`j'^2*n2*q12*q33^3-4*n2*q12^2*q33^3-8*n2*q12*q13*q33^3+n2*q13^2*q33^3-4*n2*q12*q23*q33^3+2*n2*q13*q23*q33^3+n2*q23^2*q33^3-2*n2*q12*q33^4,2*M`j'^2*q13^2*q33-2*M`j'^2*n4*q13^2*q33+4*M`j'^2*q13*q23*q33-4*M`j'^2*n4*q13*q23*q33+2*M`j'^2*q23^2*q33-2*M`j'^2*n4*q23^2*q33-4*M`j'^2*q12*q33^2+4*M`j'^2*n4*q12*q33^2)+mbox1l(n1,n2,2+n3,-1+n4)*prf(-4*M`j'^2*q12*q13^3-4*M`j'^2*n3*q12*q13^3-4*M`j'^2*q13^4-4*M`j'^2*n3*q13^4-4*M`j'^2*q12*q13^2*q23-4*M`j'^2*n3*q12*q13^2*q23-8*M`j'^2*q13^3*q23-8*M`j'^2*n3*q13^3*q23-4*M`j'^2*q13^2*q23^2-4*M`j'^2*n3*q13^2*q23^2+6*M`j'^2*q12*q13^2*q33+6*M`j'^2*n3*q12*q13^2*q33-10*M`j'^2*q13^3*q33-10*M`j'^2*n3*q13^3*q33+4*q13^4*q33+4*n3*q13^4*q33-2*M`j'^2*q12*q13*q23*q33-2*M`j'^2*n3*q12*q13*q23*q33-20*M`j'^2*q13^2*q23*q33-20*M`j'^2*n3*q13^2*q23*q33+8*q13^3*q23*q33+8*n3*q13^3*q23*q33-10*M`j'^2*q13*q23^2*q33-10*M`j'^2*n3*q13*q23^2*q33+4*q13^2*q23^2*q33+4*n3*q13^2*q23^2*q33+20*M`j'^2*q12*q13*q33^2+20*M`j'^2*n3*q12*q13*q33^2-4*M`j'^2*q13^2*q33^2-4*M`j'^2*n3*q13^2*q33^2-8*q12*q13^2*q33^2-8*n3*q12*q13^2*q33^2+4*q13^3*q33^2+4*n3*q13^3*q33^2-8*M`j'^2*q13*q23*q33^2-8*M`j'^2*n3*q13*q23*q33^2+8*q13^2*q23*q33^2+8*n3*q13^2*q23*q33^2-4*M`j'^2*q23^2*q33^2-4*M`j'^2*n3*q23^2*q33^2+4*q13*q23^2*q33^2+4*n3*q13*q23^2*q33^2+8*M`j'^2*q12*q33^3+8*M`j'^2*n3*q12*q33^3-8*q12*q13*q33^3-8*n3*q12*q13*q33^3+q13^2*q33^3+n3*q13^2*q33^3+2*q13*q23*q33^3+2*n3*q13*q23*q33^3+q23^2*q33^3+n3*q23^2*q33^3-2*q12*q33^4-2*n3*q12*q33^4,2*M`j'^2*q13^2*q33-2*M`j'^2*n4*q13^2*q33+4*M`j'^2*q13*q23*q33-4*M`j'^2*n4*q13*q23*q33+2*M`j'^2*q23^2*q33-2*M`j'^2*n4*q23^2*q33-4*M`j'^2*q12*q33^2+4*M`j'^2*n4*q12*q33^2);
	Identify,ifmatch->jump mbox1l(n1?neg0_,n2?neg_,n3?neg0_,n4?{,>1}) = mbox1l(n1,n2,1+n3,-1+n4)*prf(n3*q13,-q33+n4*q33)+mbox1l(-1+n1,2+n2,n3,-1+n4)*prf(-2*q12-2*n2*q12-2*q13-2*n2*q13-2*q23-2*n2*q23-q33-n2*q33,-q33+n4*q33)+mbox1l(-1+n1,1+n2,1+n3,-1+n4)*prf(-(n3*q12)-2*n3*q13-n3*q23-n3*q33,-q33+n4*q33)+mbox1l(1+n1,1+n2,n3,-2+n4)*prf(2*M`j'^2*n1*q13+2*M`j'^2*n1*q23+2*M`j'^2*n1*q33-2*n1*q12*q33-2*n1*q13*q33-2*n1*q23*q33-n1*q33^2,-2*M`j'^2*q33+2*M`j'^2*n4*q33)+mbox1l(1+n1,1+n2,n3,-1+n4)*prf(4*M`j'^2*n1*q12+6*M`j'^2*n1*q13+6*M`j'^2*n1*q23+4*M`j'^2*n1*q33-2*n1*q12*q33-2*n1*q13*q33-2*n1*q23*q33-n1*q33^2,-2*M`j'^2+2*M`j'^2*n4)+mbox1l(n1,2+n2,n3,-2+n4)*prf(4*M`j'^2*q12+4*M`j'^2*n2*q12+2*M`j'^2*q13+2*M`j'^2*n2*q13+2*M`j'^2*q23+2*M`j'^2*n2*q23+2*M`j'^2*q33+2*M`j'^2*n2*q33-2*q12*q33-2*n2*q12*q33-2*q13*q33-2*n2*q13*q33-2*q23*q33-2*n2*q23*q33-q33^2-n2*q33^2,-2*M`j'^2*q33+2*M`j'^2*n4*q33)+mbox1l(n1,1+n2,1+n3,-2+n4)*prf(2*M`j'^2*n3*q12+2*M`j'^2*n3*q13+2*M`j'^2*n3*q23+2*M`j'^2*n3*q33-2*n3*q12*q33-2*n3*q13*q33-2*n3*q23*q33-n3*q33^2,-2*M`j'^2*q33+2*M`j'^2*n4*q33)+mbox1l(n1,1+n2,n3,-1+n4)*(tmpprf(ep,1)*prf(-4*q12*q33-4*q13*q33-4*q23*q33-2*q33^2,-2*M`j'^2*q33+2*M`j'^2*n4*q33)+prf(2*M`j'^2*q13-2*M`j'^2*n1*q13+2*M`j'^2*n2*q13+2*M`j'^2*q23-2*M`j'^2*n1*q23+2*M`j'^2*n2*q23-2*M`j'^2*q33-2*M`j'^2*n1*q33+2*M`j'^2*n4*q33+10*q12*q33-2*n1*q12*q33-2*n2*q12*q33-2*n3*q12*q33-4*n4*q12*q33+10*q13*q33-2*n1*q13*q33-2*n2*q13*q33-2*n3*q13*q33-4*n4*q13*q33+10*q23*q33-2*n1*q23*q33-2*n2*q23*q33-2*n3*q23*q33-4*n4*q23*q33+5*q33^2-n1*q33^2-n2*q33^2-n3*q33^2-2*n4*q33^2,-2*M`j'^2*q33+2*M`j'^2*n4*q33))+mbox1l(n1,2+n2,n3,-1+n4)*prf(4*M`j'^2*q12*q13+4*M`j'^2*n2*q12*q13+4*M`j'^2*q13^2+4*M`j'^2*n2*q13^2+4*M`j'^2*q12*q23+4*M`j'^2*n2*q12*q23+8*M`j'^2*q13*q23+8*M`j'^2*n2*q13*q23+4*M`j'^2*q23^2+4*M`j'^2*n2*q23^2+8*M`j'^2*q12*q33+8*M`j'^2*n2*q12*q33-4*q12^2*q33-4*n2*q12^2*q33+10*M`j'^2*q13*q33+10*M`j'^2*n2*q13*q33-8*q12*q13*q33-8*n2*q12*q13*q33-4*q13^2*q33-4*n2*q13^2*q33+10*M`j'^2*q23*q33+10*M`j'^2*n2*q23*q33-8*q12*q23*q33-8*n2*q12*q23*q33-8*q13*q23*q33-8*n2*q13*q23*q33-4*q23^2*q33-4*n2*q23^2*q33+4*M`j'^2*q33^2+4*M`j'^2*n2*q33^2-4*q12*q33^2-4*n2*q12*q33^2-4*q13*q33^2-4*n2*q13*q33^2-4*q23*q33^2-4*n2*q23*q33^2-q33^3-n2*q33^3,-2*M`j'^2*q33+2*M`j'^2*n4*q33)+mbox1l(n1,1+n2,1+n3,-1+n4)*prf(4*M`j'^2*n3*q12*q13+4*M`j'^2*n3*q13^2+4*M`j'^2*n3*q13*q23+6*M`j'^2*n3*q12*q33+10*M`j'^2*n3*q13*q33-4*n3*q12*q13*q33-4*n3*q13^2*q33+6*M`j'^2*n3*q23*q33-4*n3*q13*q23*q33+4*M`j'^2*n3*q33^2-2*n3*q12*q33^2-4*n3*q13*q33^2-2*n3*q23*q33^2-n3*q33^3,-2*M`j'^2*q33+2*M`j'^2*n4*q33);
	Identify,ifmatch->jump mbox1l(n1?neg_,n2?neg0_,n3?neg0_,n4?{,>1}) = mbox1l(n1,1+n2,n3,-1+n4)*prf(-n2,-1+n4)+mbox1l(n1,n2,1+n3,-1+n4)*prf(-n3,-1+n4)+mbox1l(2+n1,n2,n3,-2+n4)*prf(2*M`j'^2+2*M`j'^2*n1-q33-n1*q33,-2*M`j'^2+2*M`j'^2*n4)+mbox1l(1+n1,1+n2,n3,-2+n4)*prf(2*M`j'^2*n2-n2*q33,-2*M`j'^2+2*M`j'^2*n4)+mbox1l(1+n1,n2,1+n3,-2+n4)*prf(2*M`j'^2*n3-n3*q33,-2*M`j'^2+2*M`j'^2*n4)+mbox1l(1+n1,n2,n3,-1+n4)*(tmpprf(ep,1)*prf(-q33,-M`j'^2+M`j'^2*n4)+prf(-4*M`j'^2-2*M`j'^2*n1+2*M`j'^2*n4+5*q33-n1*q33-n2*q33-n3*q33-2*n4*q33,-2*M`j'^2+2*M`j'^2*n4))+mbox1l(2+n1,n2,n3,-1+n4)*prf(4*M`j'^2*q33+4*M`j'^2*n1*q33-q33^2-n1*q33^2,-2*M`j'^2+2*M`j'^2*n4)+mbox1l(1+n1,1+n2,n3,-1+n4)*prf(4*M`j'^2*n2*q13+4*M`j'^2*n2*q23+4*M`j'^2*n2*q33-2*n2*q12*q33-2*n2*q13*q33-2*n2*q23*q33-n2*q33^2,-2*M`j'^2+2*M`j'^2*n4)+mbox1l(1+n1,n2,1+n3,-1+n4)*prf(4*M`j'^2*n3*q13+4*M`j'^2*n3*q33-2*n3*q13*q33-n3*q33^2,-2*M`j'^2+2*M`j'^2*n4);
	Identify,ifmatch->jump mbox1l(n1?neg0_,n2?neg0_,n3?neg0_,n4?{,>1}) = mbox1l(1+n1,n2,n3,-2+n4)*prf(n1,-2*M`j'^2+2*M`j'^2*n4)+mbox1l(n1,1+n2,n3,-2+n4)*prf(n2,-2*M`j'^2+2*M`j'^2*n4)+mbox1l(n1,n2,1+n3,-2+n4)*prf(n3,-2*M`j'^2+2*M`j'^2*n4)+mbox1l(n1,n2,n3,-1+n4)*(tmpprf(ep,1)*prf(1,-M`j'^2+M`j'^2*n4)+prf(-6+n1+n2+n3+2*n4,-2*M`j'^2+2*M`j'^2*n4))+mbox1l(1+n1,n2,n3,-1+n4)*prf(-2*M`j'^2*n1+n1*q33,-2*M`j'^2+2*M`j'^2*n4)+mbox1l(n1,1+n2,n3,-1+n4)*prf(-2*M`j'^2*n2+2*n2*q12+2*n2*q13+2*n2*q23+n2*q33,-2*M`j'^2+2*M`j'^2*n4)+mbox1l(n1,n2,1+n3,-1+n4)*prf(-2*M`j'^2*n3+2*n3*q13+n3*q33,-2*M`j'^2+2*M`j'^2*n4);
	Identify,ifmatch->jump mbox1l(n1?neg0_,n2?neg0_,n3?neg_,n4?pos_) = mbox1l(n1,n2,1+n3,n4)*prf(-q13,1)+mbox1l(n1,n2,1+n3,-1+n4)*prf(-q13,q33)+mbox1l(-1+n1,n2,2+n3,-1+n4)*prf(q12*q13^2+n3*q12*q13^2+q13^3+n3*q13^3+q12*q13*q23+n3*q12*q13*q23+2*q13^2*q23+2*n3*q13^2*q23+q13*q23^2+n3*q13*q23^2-q12*q13*q33-n3*q12*q13*q33,q13^2*q33-n1*q13^2*q33+2*q13*q23*q33-2*n1*q13*q23*q33+q23^2*q33-n1*q23^2*q33-2*q12*q33^2+2*n1*q12*q33^2)+mbox1l(-1+n1,-1+n2,2+n3,n4)*prf(q13^3+n3*q13^3+q13^2*q23+n3*q13^2*q23+q13^2*q33+n3*q13^2*q33,q13^2*q33-n1*q13^2*q33+2*q13*q23*q33-2*n1*q13*q23*q33+q23^2*q33-n1*q23^2*q33-2*q12*q33^2+2*n1*q12*q33^2)+mbox1l(-1+n1,1+n2,1+n3,-1+n4)*prf(2*n2*q12*q13^2+n2*q13^3+2*n2*q12*q13*q23+2*n2*q13^2*q23+n2*q13*q23^2-2*n2*q12^2*q33-n2*q12*q13*q33-n2*q12*q23*q33,q13^2*q33-n1*q13^2*q33+2*q13*q23*q33-2*n1*q13*q23*q33+q23^2*q33-n1*q23^2*q33-2*q12*q33^2+2*n1*q12*q33^2)+mbox1l(-2+n1,1+n2,1+n3,n4)*prf(-2*n2*q12*q13^2-2*n2*q13^3-2*n2*q12*q13*q23-4*n2*q13^2*q23-2*n2*q13*q23^2+2*n2*q12^2*q33+2*n2*q12*q13*q33-n2*q13^2*q33+2*n2*q12*q23*q33-n2*q13*q23*q33+n2*q12*q33^2,q13^2*q33-n1*q13^2*q33+2*q13*q23*q33-2*n1*q13*q23*q33+q23^2*q33-n1*q23^2*q33-2*q12*q33^2+2*n1*q12*q33^2)+mbox1l(-1+n1,n2,1+n3,n4)*prf(q13^3-n1*q13^3+n2*q13^3+2*q13^2*q23-2*n1*q13^2*q23+2*n2*q13^2*q23+q13*q23^2-n1*q13*q23^2+n2*q13*q23^2-3*q12*q13*q33+2*n1*q12*q13*q33-n2*q12*q13*q33-n3*q12*q13*q33+q13^2*q33-n1*q13^2*q33+n2*q13^2*q33+q12*q23*q33-n2*q12*q23*q33+n3*q12*q23*q33+3*q13*q23*q33-2*n1*q13*q23*q33+n2*q13*q23*q33+n3*q13*q23*q33+2*q23^2*q33-n1*q23^2*q33+n3*q23^2*q33-3*q12*q33^2+2*n1*q12*q33^2-n2*q12*q33^2-n3*q12*q33^2,q13^2*q33-n1*q13^2*q33+2*q13*q23*q33-2*n1*q13*q23*q33+q23^2*q33-n1*q23^2*q33-2*q12*q33^2+2*n1*q12*q33^2)+mbox1l(-2+n1,n2,2+n3,n4)*prf(-(q12*q13^2)-n3*q12*q13^2-2*q13^3-2*n3*q13^3-q12*q13*q23-n3*q12*q13*q23-3*q13^2*q23-3*n3*q13^2*q23-q13*q23^2-n3*q13*q23^2+2*q12*q13*q33+2*n3*q12*q13*q33-q13^2*q33-n3*q13^2*q33-q12*q23*q33-n3*q12*q23*q33-q13*q23*q33-n3*q13*q23*q33-q23^2*q33-n3*q23^2*q33+q12*q33^2+n3*q12*q33^2,q13^2*q33-n1*q13^2*q33+2*q13*q23*q33-2*n1*q13*q23*q33+q23^2*q33-n1*q23^2*q33-2*q12*q33^2+2*n1*q12*q33^2)+mbox1l(-1+n1,n2,2+n3,n4)*prf(2*q12*q13^3+2*n3*q12*q13^3+2*q13^4+2*n3*q13^4+2*q12*q13^2*q23+2*n3*q12*q13^2*q23+4*q13^3*q23+4*n3*q13^3*q23+2*q13^2*q23^2+2*n3*q13^2*q23^2-q12*q13^2*q33-n3*q12*q13^2*q33+q13^3*q33+n3*q13^3*q33+q12*q13*q23*q33+n3*q12*q13*q23*q33+2*q13^2*q23*q33+2*n3*q13^2*q23*q33+q13*q23^2*q33+n3*q13*q23^2*q33-q12*q13*q33^2-n3*q12*q13*q33^2,q13^2*q33-n1*q13^2*q33+2*q13*q23*q33-2*n1*q13*q23*q33+q23^2*q33-n1*q23^2*q33-2*q12*q33^2+2*n1*q12*q33^2)+mbox1l(-1+n1,1+n2,1+n3,n4)*prf(2*n2*q12*q13^3+2*n2*q13^4+4*n2*q12*q13^2*q23+6*n2*q13^3*q23+2*n2*q12*q13*q23^2+6*n2*q13^2*q23^2+2*n2*q13*q23^3-2*n2*q12^2*q13*q33-2*n2*q12*q13^2*q33+n2*q13^3*q33-2*n2*q12^2*q23*q33-4*n2*q12*q13*q23*q33+2*n2*q13^2*q23*q33-2*n2*q12*q23^2*q33+n2*q13*q23^2*q33-n2*q12*q13*q33^2-n2*q12*q23*q33^2,q13^2*q33-n1*q13^2*q33+2*q13*q23*q33-2*n1*q13*q23*q33+q23^2*q33-n1*q23^2*q33-2*q12*q33^2+2*n1*q12*q33^2);
	Identify,ifmatch->jump mbox1l(n1?neg0_,n2?neg_,n3?neg0_,n4?pos_) = mbox1l(n1,1+n2,n3,-1+n4)*prf(-q13-q23,q33)+mbox1l(n1,1+n2,n3,n4)*prf(-2*q12-q13-q23,1)+mbox1l(-1+n1,2+n2,n3,-1+n4)*prf(-2*q12-2*n2*q12-q13-n2*q13-q23-n2*q23,-q33+n1*q33)+mbox1l(-1+n1,1+n2,1+n3,-1+n4)*prf(-(n3*q12)-n3*q13-n3*q23,-q33+n1*q33)+mbox1l(-1+n1,1+n2,n3,n4)*prf(-2*q13+n1*q13-n2*q13-2*q23+n1*q23-n2*q23-2*q33+n1*q33-n2*q33,-q33+n1*q33)+mbox1l(-2+n1,2+n2,n3,n4)*prf(2*q12+2*n2*q12+2*q13+2*n2*q13+2*q23+2*n2*q23+q33+n2*q33,-q33+n1*q33)+mbox1l(-1+n1,n2,1+n3,n4)*prf(-(n3*q13)-n3*q33,-q33+n1*q33)+mbox1l(-2+n1,1+n2,1+n3,n4)*prf(n3*q12+2*n3*q13+n3*q23+n3*q33,-q33+n1*q33)+mbox1l(-1+n1,2+n2,n3,n4)*prf(-2*q12*q13-2*n2*q12*q13-2*q13^2-2*n2*q13^2-2*q12*q23-2*n2*q12*q23-4*q13*q23-4*n2*q13*q23-2*q23^2-2*n2*q23^2-q13*q33-n2*q13*q33-q23*q33-n2*q23*q33,-q33+n1*q33)+mbox1l(-1+n1,1+n2,1+n3,n4)*prf(-2*n3*q12*q13-2*n3*q13^2-2*n3*q13*q23-n3*q12*q33-n3*q13*q33-n3*q23*q33,-q33+n1*q33);
	Identify,ifmatch->jump mbox1l(n1?neg0_,n2?neg0_,n3?neg_,n4?pos_) = mbox1l(n1,-1+n2,2+n3,-1+n4)*prf(q12*q13+n3*q12*q13,-q13^2+n2*q13^2-2*q13*q23+2*n2*q13*q23-q23^2+n2*q23^2+2*q12*q33-2*n2*q12*q33)+mbox1l(n1,-2+n2,2+n3,n4)*prf(q13^2+n3*q13^2,-q13^2+n2*q13^2-2*q13*q23+2*n2*q13*q23-q23^2+n2*q23^2+2*q12*q33-2*n2*q12*q33)+mbox1l(n1,n2,1+n3,-1+n4)*prf(-(q12*q13)+q12*q23,-q13^2-2*q13*q23-q23^2+2*q12*q33)+mbox1l(-1+n1,n2,1+n3,n4)*prf(-(q12*q13)+q12*q23+q13*q23+q23^2-q12*q33,q13^2+2*q13*q23+q23^2-2*q12*q33)+mbox1l(-1+n1,-1+n2,2+n3,n4)*prf(-(q12*q13)-n3*q12*q13+q13*q23+n3*q13*q23-q12*q33-n3*q12*q33,-q13^2+n2*q13^2-2*q13*q23+2*n2*q13*q23-q23^2+n2*q23^2+2*q12*q33-2*n2*q12*q33)+mbox1l(n1,-1+n2,1+n3,n4)*prf(-2*q13^2+n2*q13^2-n3*q13^2-2*q13*q23+n2*q13*q23-n3*q13*q23+2*q12*q33-n2*q12*q33+n3*q12*q33,-q13^2+n2*q13^2-2*q13*q23+2*n2*q13*q23-q23^2+n2*q23^2+2*q12*q33-2*n2*q12*q33)+mbox1l(n1,-1+n2,2+n3,n4)*prf(2*q12*q13^2+2*n3*q12*q13^2+q12*q13*q33+n3*q12*q13*q33,-q13^2+n2*q13^2-2*q13*q23+2*n2*q13*q23-q23^2+n2*q23^2+2*q12*q33-2*n2*q12*q33)+mbox1l(n1,n2,1+n3,n4)*prf(-2*q12*q13^2-2*q12*q13*q23+2*q12^2*q33-q12*q13*q33+q12*q23*q33,-q13^2-2*q13*q23-q23^2+2*q12*q33);
	Identify,ifmatch->jump mbox1l(n1?neg_,0,0,1) = tmpprf(1,-2+2*ep+n1)*mbox1l(1+n1,0,0,0)*prf(-n1,1)+mbox1l(1+n1,0,0,1)*(tmpprf(ep,-2+2*ep+n1)*prf(-2*q33,1)+tmpprf(1,-2+2*ep+n1)*prf(q33-2*n1*q33,1))+tmpprf(1,-2+2*ep+n1)*mbox1l(2+n1,0,0,0)*prf(2*M`j'^2+2*M`j'^2*n1-q33-n1*q33,1)+tmpprf(1,-2+2*ep+n1)*mbox1l(2+n1,0,0,1)*prf(4*M`j'^2*q33+4*M`j'^2*n1*q33-q33^2-n1*q33^2,1);
	Identify,ifmatch->jump mbox1l(n1?neg0_,n2?neg_,n3?pos_,n4?{,>1}) = mbox1l(1+n1,1+n2,n3,-2+n4)*prf(-2*M`j'^2*n1*q12-2*M`j'^2*n1*q23,-8*M`j'^2*q13+8*M`j'^2*n4*q13+4*q13^2-4*n4*q13^2-4*M`j'^2*q33+4*M`j'^2*n4*q33+4*q13*q33-4*n4*q13*q33+q33^2-n4*q33^2)+mbox1l(n1,1+n2,1+n3,-2+n4)*prf(-2*M`j'^2*n3*q12-2*M`j'^2*n3*q23,-8*M`j'^2*q13+8*M`j'^2*n4*q13+4*q13^2-4*n4*q13^2-4*M`j'^2*q33+4*M`j'^2*n4*q33+4*q13*q33-4*n4*q13*q33+q33^2-n4*q33^2)+mbox1l(1+n1,1+n2,n3,-1+n4)*prf(4*M`j'^2*n1*q12*q13+4*M`j'^2*n1*q13*q23,-8*M`j'^2*q13+8*M`j'^2*n4*q13+4*q13^2-4*n4*q13^2-4*M`j'^2*q33+4*M`j'^2*n4*q33+4*q13*q33-4*n4*q13*q33+q33^2-n4*q33^2)+mbox1l(-1+n1,2+n2,n3,-1+n4)*prf(-q12^2-n2*q12^2-2*q12*q23-2*n2*q12*q23-q23^2-n2*q23^2,-2*q13^2+2*n4*q13^2-q13*q33+n4*q13*q33)+mbox1l(n1,2+n2,n3,-2+n4)*prf(-4*M`j'^2*q12^2-4*M`j'^2*n2*q12^2+2*M`j'^2*q12*q13+2*M`j'^2*n2*q12*q13+2*q12^2*q13+2*n2*q12^2*q13-4*M`j'^2*q12*q23-4*M`j'^2*n2*q12*q23+2*M`j'^2*q13*q23+2*M`j'^2*n2*q13*q23+2*q12*q13*q23+2*n2*q12*q13*q23+q12^2*q33+n2*q12^2*q33+q12*q23*q33+n2*q12*q23*q33,8*M`j'^2*q13^2-8*M`j'^2*n4*q13^2-4*q13^3+4*n4*q13^3+4*M`j'^2*q13*q33-4*M`j'^2*n4*q13*q33-4*q13^2*q33+4*n4*q13^2*q33-q13*q33^2+n4*q13*q33^2)+mbox1l(n1,1+n2,-1+n3,n4)*prf(-6*M`j'^2*q12-8*M`j'^2*q13+4*q12*q13+4*q13^2-6*M`j'^2*q23+4*q13*q23-4*M`j'^2*q33+2*q12*q33+4*q13*q33+2*q23*q33+q33^2,-8*M`j'^2*q13+4*q13^2-4*M`j'^2*q33+4*q13*q33+q33^2)+mbox1l(1+n1,1+n2,-1+n3,-1+n4)*prf(-6*M`j'^2*n1*q12*q13+4*n1*q12*q13^2+2*M`j'^2*n1*q13*q23-4*M`j'^2*n1*q12*q33+4*n1*q12*q13*q33+n1*q12*q33^2,8*M`j'^2*q13^2-8*M`j'^2*n4*q13^2-4*q13^3+4*n4*q13^3+4*M`j'^2*q13*q33-4*M`j'^2*n4*q13*q33-4*q13^2*q33+4*n4*q13^2*q33-q13*q33^2+n4*q13*q33^2)+mbox1l(n1,2+n2,-1+n3,-1+n4)*prf(6*M`j'^2*q12*q13+6*M`j'^2*n2*q12*q13-2*q12*q13^2-2*n2*q12*q13^2-4*M`j'^2*q12*q23-4*M`j'^2*n2*q12*q23-2*M`j'^2*q13*q23-2*M`j'^2*n2*q13*q23+2*q12*q13*q23+2*n2*q12*q13*q23+2*q13^2*q23+2*n2*q13^2*q23-4*M`j'^2*q23^2-4*M`j'^2*n2*q23^2+2*q13*q23^2+2*n2*q13*q23^2+4*M`j'^2*q12*q33+4*M`j'^2*n2*q12*q33-3*q12*q13*q33-3*n2*q12*q13*q33+q12*q23*q33+n2*q12*q23*q33+q13*q23*q33+n2*q13*q23*q33+q23^2*q33+n2*q23^2*q33-q12*q33^2-n2*q12*q33^2,8*M`j'^2*q13^2-8*M`j'^2*n4*q13^2-4*q13^3+4*n4*q13^3+4*M`j'^2*q13*q33-4*M`j'^2*n4*q13*q33-4*q13^2*q33+4*n4*q13^2*q33-q13*q33^2+n4*q13*q33^2)+mbox1l(n1,1+n2,n3,-1+n4)*(tmpprf(ep,1)*prf(4*q12*q13^2+4*q13^2*q23+2*q12*q13*q33+2*q13*q23*q33,8*M`j'^2*q13^2-8*M`j'^2*n4*q13^2-4*q13^3+4*n4*q13^3+4*M`j'^2*q13*q33-4*M`j'^2*n4*q13*q33-4*q13^2*q33+4*n4*q13^2*q33-q13*q33^2+n4*q13*q33^2)+prf(-14*M`j'^2*q12*q13+4*M`j'^2*n1*q12*q13-8*M`j'^2*n2*q12*q13-2*M`j'^2*n3*q12*q13+6*M`j'^2*n4*q12*q13-2*q12*q13^2+6*n2*q12*q13^2+4*n3*q12*q13^2-6*M`j'^2*q13*q23-4*M`j'^2*n1*q13*q23-2*M`j'^2*n3*q13*q23+6*M`j'^2*n4*q13*q23-6*q13^2*q23+4*n1*q13^2*q23+2*n2*q13^2*q23+4*n3*q13^2*q23-4*M`j'^2*q12*q33+4*M`j'^2*n1*q12*q33-4*M`j'^2*n2*q12*q33+q12*q13*q33-2*n1*q12*q13*q33+5*n2*q12*q13*q33+2*n3*q12*q13*q33-3*q13*q23*q33+2*n1*q13*q23*q33+n2*q13*q23*q33+2*n3*q13*q23*q33+q12*q33^2-n1*q12*q33^2+n2*q12*q33^2,8*M`j'^2*q13^2-8*M`j'^2*n4*q13^2-4*q13^3+4*n4*q13^3+4*M`j'^2*q13*q33-4*M`j'^2*n4*q13*q33-4*q13^2*q33+4*n4*q13^2*q33-q13*q33^2+n4*q13*q33^2))+mbox1l(n1,2+n2,n3,-1+n4)*prf(-4*M`j'^2*q12^2*q13-4*M`j'^2*n2*q12^2*q13+4*q12^2*q13^2+4*n2*q12^2*q13^2+4*q12*q13^2*q23+4*n2*q12*q13^2*q23+4*M`j'^2*q13*q23^2+4*M`j'^2*n2*q13*q23^2-4*M`j'^2*q12^2*q33-4*M`j'^2*n2*q12^2*q33+4*q12^2*q13*q33+4*n2*q12^2*q13*q33-4*M`j'^2*q12*q23*q33-4*M`j'^2*n2*q12*q23*q33+4*q12*q13*q23*q33+4*n2*q12*q13*q23*q33+q12^2*q33^2+n2*q12^2*q33^2+q12*q23*q33^2+n2*q12*q23*q33^2,8*M`j'^2*q13^2-8*M`j'^2*n4*q13^2-4*q13^3+4*n4*q13^3+4*M`j'^2*q13*q33-4*M`j'^2*n4*q13*q33-4*q13^2*q33+4*n4*q13^2*q33-q13*q33^2+n4*q13*q33^2);
	Identify,ifmatch->jump mbox1l(n1?neg_,n2?neg0_,n3?pos_,n4?{,>1}) = mbox1l(1+n1,n2,1+n3,-2+n4)*prf(2*M`j'^2*n3*q13,-8*M`j'^2*q13+8*M`j'^2*n4*q13+4*q13^2-4*n4*q13^2-4*M`j'^2*q33+4*M`j'^2*n4*q33+4*q13*q33-4*n4*q13*q33+q33^2-n4*q33^2)+mbox1l(2+n1,n2,-1+n3,-1+n4)*prf(2*M`j'^2*q13+2*M`j'^2*n1*q13,-8*M`j'^2*q13+8*M`j'^2*n4*q13+4*q13^2-4*n4*q13^2-4*M`j'^2*q33+4*M`j'^2*n4*q33+4*q13*q33-4*n4*q13*q33+q33^2-n4*q33^2)+mbox1l(2+n1,n2,n3,-2+n4)*prf(2*M`j'^2*q13+2*M`j'^2*n1*q13,-8*M`j'^2*q13+8*M`j'^2*n4*q13+4*q13^2-4*n4*q13^2-4*M`j'^2*q33+4*M`j'^2*n4*q33+4*q13*q33-4*n4*q13*q33+q33^2-n4*q33^2)+mbox1l(2+n1,n2,n3,-1+n4)*prf(-4*M`j'^2*q13^2-4*M`j'^2*n1*q13^2,-8*M`j'^2*q13+8*M`j'^2*n4*q13+4*q13^2-4*n4*q13^2-4*M`j'^2*q33+4*M`j'^2*n4*q33+4*q13*q33-4*n4*q13*q33+q33^2-n4*q33^2)+mbox1l(n1,1+n2,n3,-1+n4)*prf(n2*q12+n2*q23,-2*q13+2*n4*q13-q33+n4*q33)+mbox1l(1+n1,1+n2,n3,-2+n4)*prf(-4*M`j'^2*n2*q12+2*M`j'^2*n2*q13+2*n2*q12*q13+n2*q12*q33,-8*M`j'^2*q13+8*M`j'^2*n4*q13+4*q13^2-4*n4*q13^2-4*M`j'^2*q33+4*M`j'^2*n4*q33+4*q13*q33-4*n4*q13*q33+q33^2-n4*q33^2)+mbox1l(1+n1,n2,n3,-1+n4)*(tmpprf(ep,1)*prf(-4*q13^2-2*q13*q33,8*M`j'^2*q13-8*M`j'^2*n4*q13-4*q13^2+4*n4*q13^2+4*M`j'^2*q33-4*M`j'^2*n4*q33-4*q13*q33+4*n4*q13*q33-q33^2+n4*q33^2)+prf(10*M`j'^2*q13+4*M`j'^2*n1*q13+2*M`j'^2*n3*q13-6*M`j'^2*n4*q13+4*q13^2-4*n1*q13^2-2*n2*q13^2-4*n3*q13^2+2*q13*q33-2*n1*q13*q33-n2*q13*q33-2*n3*q13*q33,8*M`j'^2*q13-8*M`j'^2*n4*q13-4*q13^2+4*n4*q13^2+4*M`j'^2*q33-4*M`j'^2*n4*q33-4*q13*q33+4*n4*q13*q33-q33^2+n4*q33^2))+mbox1l(1+n1,1+n2,-1+n3,-1+n4)*prf(-2*M`j'^2*n2*q13+2*n2*q13^2-4*M`j'^2*n2*q23+2*n2*q13*q23+n2*q13*q33+n2*q23*q33,-8*M`j'^2*q13+8*M`j'^2*n4*q13+4*q13^2-4*n4*q13^2-4*M`j'^2*q33+4*M`j'^2*n4*q33+4*q13*q33-4*n4*q13*q33+q33^2-n4*q33^2)+mbox1l(1+n1,n2,-1+n3,n4)*prf(2*M`j'^2*q13+4*M`j'^2*q33-2*q13*q33-q33^2,8*M`j'^2*q13-4*q13^2+4*M`j'^2*q33-4*q13*q33-q33^2)+mbox1l(1+n1,1+n2,n3,-1+n4)*prf(-4*M`j'^2*n2*q12*q13+4*n2*q12*q13^2+4*M`j'^2*n2*q13*q23-4*M`j'^2*n2*q12*q33+4*n2*q12*q13*q33+n2*q12*q33^2,-8*M`j'^2*q13+8*M`j'^2*n4*q13+4*q13^2-4*n4*q13^2-4*M`j'^2*q33+4*M`j'^2*n4*q33+4*q13*q33-4*n4*q13*q33+q33^2-n4*q33^2);
	Identify,ifmatch->jump mbox1l(n1?neg0_,n2?neg_,n3?{,>1},n4?pos_) = mbox1l(n1,1+n2,n3,-1+n4)*prf(-2*M`j'^2*q12-2*M`j'^2*q23,8*M`j'^2*q13-4*q13^2+4*M`j'^2*q33-4*q13*q33-q33^2)+mbox1l(n1,1+n2,-2+n3,1+n4)*prf(-2*M`j'^2*n4*q12-2*M`j'^2*n4*q23,-8*M`j'^2*q13+8*M`j'^2*n3*q13+4*q13^2-4*n3*q13^2-4*M`j'^2*q33+4*M`j'^2*n3*q33+4*q13*q33-4*n3*q13*q33+q33^2-n3*q33^2)+mbox1l(-1+n1,2+n2,-1+n3,n4)*prf(-(q12^2*q13)-n2*q12^2*q13-2*q12*q13*q23-2*n2*q12*q13*q23-q13*q23^2-n2*q13*q23^2-q12^2*q33-n2*q12^2*q33-2*q12*q23*q33-2*n2*q12*q23*q33-q23^2*q33-n2*q23^2*q33,-2*q13^3+2*n3*q13^3-q13^2*q33+n3*q13^2*q33)+mbox1l(1+n1,1+n2,-1+n3,-1+n4)*prf(-6*M`j'^2*n1*q12*q13+4*n1*q12*q13^2+2*M`j'^2*n1*q13*q23-4*M`j'^2*n1*q12*q33+4*n1*q12*q13*q33+n1*q12*q33^2,8*M`j'^2*q13^2-8*M`j'^2*n3*q13^2-4*q13^3+4*n3*q13^3+4*M`j'^2*q13*q33-4*M`j'^2*n3*q13*q33-4*q13^2*q33+4*n3*q13^2*q33-q13*q33^2+n3*q13*q33^2)+mbox1l(n1,2+n2,-1+n3,-1+n4)*prf(-4*M`j'^2*q12^2*q13-4*M`j'^2*n2*q12^2*q13+2*M`j'^2*q12*q13^2+2*M`j'^2*n2*q12*q13^2+2*q12^2*q13^2+2*n2*q12^2*q13^2-4*M`j'^2*q12*q13*q23-4*M`j'^2*n2*q12*q13*q23+2*M`j'^2*q13^2*q23+2*M`j'^2*n2*q13^2*q23+2*q12*q13^2*q23+2*n2*q12*q13^2*q23-4*M`j'^2*q12^2*q33-4*M`j'^2*n2*q12^2*q33+3*q12^2*q13*q33+3*n2*q12^2*q13*q33-4*M`j'^2*q12*q23*q33-4*M`j'^2*n2*q12*q23*q33+3*q12*q13*q23*q33+3*n2*q12*q13*q23*q33+q12^2*q33^2+n2*q12^2*q33^2+q12*q23*q33^2+n2*q12*q23*q33^2,8*M`j'^2*q13^3-8*M`j'^2*n3*q13^3-4*q13^4+4*n3*q13^4+4*M`j'^2*q13^2*q33-4*M`j'^2*n3*q13^2*q33-4*q13^3*q33+4*n3*q13^3*q33-q13^2*q33^2+n3*q13^2*q33^2)+mbox1l(1+n1,1+n2,-1+n3,n4)*prf(-4*M`j'^2*n1*q12*q13^2-4*M`j'^2*n1*q13^2*q23-8*M`j'^2*n1*q12*q13*q33+4*n1*q12*q13^2*q33-4*M`j'^2*n1*q12*q33^2+4*n1*q12*q13*q33^2+n1*q12*q33^3,8*M`j'^2*q13^2-8*M`j'^2*n3*q13^2-4*q13^3+4*n3*q13^3+4*M`j'^2*q13*q33-4*M`j'^2*n3*q13*q33-4*q13^2*q33+4*n3*q13^2*q33-q13*q33^2+n3*q13*q33^2)+mbox1l(1+n1,1+n2,-2+n3,n4)*prf(2*M`j'^2*n1*q12*q13^2+2*M`j'^2*n1*q13^2*q23-4*M`j'^2*n1*q12*q13*q33+2*n1*q12*q13^2*q33+4*M`j'^2*n1*q13*q23*q33-2*n1*q13^2*q23*q33-4*M`j'^2*n1*q12*q33^2+3*n1*q12*q13*q33^2-n1*q13*q23*q33^2+n1*q12*q33^3,8*M`j'^2*q13^3-8*M`j'^2*n3*q13^3-4*q13^4+4*n3*q13^4+4*M`j'^2*q13^2*q33-4*M`j'^2*n3*q13^2*q33-4*q13^3*q33+4*n3*q13^3*q33-q13^2*q33^2+n3*q13^2*q33^2)+mbox1l(n1,2+n2,-2+n3,n4)*prf(-2*M`j'^2*q12*q13^2-2*M`j'^2*n2*q12*q13^2-8*M`j'^2*q13^3-8*M`j'^2*n2*q13^3+2*q12*q13^3+2*n2*q12*q13^3+4*q13^4+4*n2*q13^4-4*M`j'^2*q12*q13*q23-4*M`j'^2*n2*q12*q13*q23-10*M`j'^2*q13^2*q23-10*M`j'^2*n2*q13^2*q23+2*q12*q13^2*q23+2*n2*q12*q13^2*q23+6*q13^3*q23+6*n2*q13^3*q23-4*M`j'^2*q13*q23^2-4*M`j'^2*n2*q13*q23^2+2*q13^2*q23^2+2*n2*q13^2*q23^2+8*M`j'^2*q12*q13*q33+8*M`j'^2*n2*q12*q13*q33-4*M`j'^2*q13^2*q33-4*M`j'^2*n2*q13^2*q33-3*q12*q13^2*q33-3*n2*q12*q13^2*q33+4*q13^3*q33+4*n2*q13^3*q33-4*M`j'^2*q12*q23*q33-4*M`j'^2*n2*q12*q23*q33-4*M`j'^2*q13*q23*q33-4*M`j'^2*n2*q13*q23*q33+3*q12*q13*q23*q33+3*n2*q12*q13*q23*q33+5*q13^2*q23*q33+5*n2*q13^2*q23*q33-4*M`j'^2*q23^2*q33-4*M`j'^2*n2*q23^2*q33+3*q13*q23^2*q33+3*n2*q13*q23^2*q33+4*M`j'^2*q12*q33^2+4*M`j'^2*n2*q12*q33^2-4*q12*q13*q33^2-4*n2*q12*q13*q33^2+q13^2*q33^2+n2*q13^2*q33^2+q12*q23*q33^2+n2*q12*q23*q33^2+q13*q23*q33^2+n2*q13*q23*q33^2+q23^2*q33^2+n2*q23^2*q33^2-q12*q33^3-n2*q12*q33^3,8*M`j'^2*q13^3-8*M`j'^2*n3*q13^3-4*q13^4+4*n3*q13^4+4*M`j'^2*q13^2*q33-4*M`j'^2*n3*q13^2*q33-4*q13^3*q33+4*n3*q13^3*q33-q13^2*q33^2+n3*q13^2*q33^2)+mbox1l(n1,1+n2,-1+n3,n4)*(tmpprf(ep,1)*prf(4*q12*q13^3+4*q13^3*q23+2*q12*q13^2*q33+2*q13^2*q23*q33,8*M`j'^2*q13^3-8*M`j'^2*n3*q13^3-4*q13^4+4*n3*q13^4+4*M`j'^2*q13^2*q33-4*M`j'^2*n3*q13^2*q33-4*q13^3*q33+4*n3*q13^3*q33-q13^2*q33^2+n3*q13^2*q33^2)+prf(2*M`j'^2*q12*q13^2+4*M`j'^2*n1*q12*q13^2-2*M`j'^2*n3*q12*q13^2-2*M`j'^2*n4*q12*q13^2+16*M`j'^2*q13^3+8*M`j'^2*n2*q13^3-8*M`j'^2*n3*q13^3-10*q12*q13^3+2*n2*q12*q13^3+4*n3*q12*q13^3+4*n4*q12*q13^3-8*q13^4-4*n2*q13^4+4*n3*q13^4+10*M`j'^2*q13^2*q23-4*M`j'^2*n1*q13^2*q23+8*M`j'^2*n2*q13^2*q23-2*M`j'^2*n3*q13^2*q23-2*M`j'^2*n4*q13^2*q23-14*q13^3*q23+4*n1*q13^3*q23-2*n2*q13^3*q23+4*n3*q13^3*q23+4*n4*q13^3*q23-8*M`j'^2*q12*q13*q33+8*M`j'^2*n1*q12*q13*q33-8*M`j'^2*n2*q12*q13*q33+8*M`j'^2*q13^2*q33+4*M`j'^2*n2*q13^2*q33-4*M`j'^2*n3*q13^2*q33-q12*q13^2*q33-4*n1*q12*q13^2*q33+5*n2*q12*q13^2*q33+2*n3*q12*q13^2*q33+2*n4*q12*q13^2*q33-8*q13^3*q33-4*n2*q13^3*q33+4*n3*q13^3*q33+4*M`j'^2*q13*q23*q33-4*M`j'^2*n1*q13*q23*q33+4*M`j'^2*n2*q13*q23*q33-9*q13^2*q23*q33+4*n1*q13^2*q23*q33-3*n2*q13^2*q23*q33+2*n3*q13^2*q23*q33+2*n4*q13^2*q23*q33-4*M`j'^2*q12*q33^2+4*M`j'^2*n1*q12*q33^2-4*M`j'^2*n2*q12*q33^2+4*q12*q13*q33^2-4*n1*q12*q13*q33^2+4*n2*q12*q13*q33^2-2*q13^2*q33^2-n2*q13^2*q33^2+n3*q13^2*q33^2-q13*q23*q33^2+n1*q13*q23*q33^2-n2*q13*q23*q33^2+q12*q33^3-n1*q12*q33^3+n2*q12*q33^3,8*M`j'^2*q13^3-8*M`j'^2*n3*q13^3-4*q13^4+4*n3*q13^4+4*M`j'^2*q13^2*q33-4*M`j'^2*n3*q13^2*q33-4*q13^3*q33+4*n3*q13^3*q33-q13^2*q33^2+n3*q13^2*q33^2))+mbox1l(n1,2+n2,-1+n3,n4)*prf(-4*M`j'^2*q12^2*q13^2-4*M`j'^2*n2*q12^2*q13^2+4*q12^2*q13^3+4*n2*q12^2*q13^3+4*q12*q13^3*q23+4*n2*q12*q13^3*q23+4*M`j'^2*q13^2*q23^2+4*M`j'^2*n2*q13^2*q23^2-12*M`j'^2*q12^2*q13*q33-12*M`j'^2*n2*q12^2*q13*q33+8*q12^2*q13^2*q33+8*n2*q12^2*q13^2*q33-12*M`j'^2*q12*q13*q23*q33-12*M`j'^2*n2*q12*q13*q23*q33+8*q12*q13^2*q23*q33+8*n2*q12*q13^2*q23*q33-4*M`j'^2*q12^2*q33^2-4*M`j'^2*n2*q12^2*q33^2+5*q12^2*q13*q33^2+5*n2*q12^2*q13*q33^2-4*M`j'^2*q12*q23*q33^2-4*M`j'^2*n2*q12*q23*q33^2+5*q12*q13*q23*q33^2+5*n2*q12*q13*q23*q33^2+q12^2*q33^3+n2*q12^2*q33^3+q12*q23*q33^3+n2*q12*q23*q33^3,8*M`j'^2*q13^3-8*M`j'^2*n3*q13^3-4*q13^4+4*n3*q13^4+4*M`j'^2*q13^2*q33-4*M`j'^2*n3*q13^2*q33-4*q13^3*q33+4*n3*q13^3*q33-q13^2*q33^2+n3*q13^2*q33^2);
	Identify,ifmatch->jump mbox1l(n1?neg_,n2?neg0_,n3?{,>1},n4?pos_) = mbox1l(1+n1,n2,n3,-1+n4)*prf(2*M`j'^2*q13,8*M`j'^2*q13-4*q13^2+4*M`j'^2*q33-4*q13*q33-q33^2)+mbox1l(1+n1,n2,-2+n3,1+n4)*prf(2*M`j'^2*n4*q13,-8*M`j'^2*q13+8*M`j'^2*n3*q13+4*q13^2-4*n3*q13^2-4*M`j'^2*q33+4*M`j'^2*n3*q33+4*q13*q33-4*n3*q13*q33+q33^2-n3*q33^2)+mbox1l(2+n1,n2,-1+n3,-1+n4)*prf(2*M`j'^2*q13+2*M`j'^2*n1*q13,-8*M`j'^2*q13+8*M`j'^2*n3*q13+4*q13^2-4*n3*q13^2-4*M`j'^2*q33+4*M`j'^2*n3*q33+4*q13*q33-4*n3*q13*q33+q33^2-n3*q33^2)+mbox1l(2+n1,n2,-1+n3,n4)*prf(-4*M`j'^2*q13^2-4*M`j'^2*n1*q13^2,-8*M`j'^2*q13+8*M`j'^2*n3*q13+4*q13^2-4*n3*q13^2-4*M`j'^2*q33+4*M`j'^2*n3*q33+4*q13*q33-4*n3*q13*q33+q33^2-n3*q33^2)+mbox1l(n1,1+n2,-1+n3,n4)*prf(-(n2*q12)-2*n2*q13-n2*q23-n2*q33,-2*q13+2*n3*q13-q33+n3*q33)+mbox1l(1+n1,1+n2,-1+n3,-1+n4)*prf(4*M`j'^2*n2*q12+2*M`j'^2*n2*q13-2*n2*q12*q13-n2*q12*q33,-8*M`j'^2*q13+8*M`j'^2*n3*q13+4*q13^2-4*n3*q13^2-4*M`j'^2*q33+4*M`j'^2*n3*q33+4*q13*q33-4*n3*q13*q33+q33^2-n3*q33^2)+mbox1l(2+n1,n2,-2+n3,n4)*prf(2*M`j'^2*q13+2*M`j'^2*n1*q13+4*M`j'^2*q33+4*M`j'^2*n1*q33-2*q13*q33-2*n1*q13*q33-q33^2-n1*q33^2,-8*M`j'^2*q13+8*M`j'^2*n3*q13+4*q13^2-4*n3*q13^2-4*M`j'^2*q33+4*M`j'^2*n3*q33+4*q13*q33-4*n3*q13*q33+q33^2-n3*q33^2)+mbox1l(1+n1,1+n2,-2+n3,n4)*prf(6*M`j'^2*n2*q13-2*n2*q13^2+4*M`j'^2*n2*q23-2*n2*q13*q23+4*M`j'^2*n2*q33-3*n2*q13*q33-n2*q23*q33-n2*q33^2,-8*M`j'^2*q13+8*M`j'^2*n3*q13+4*q13^2-4*n3*q13^2-4*M`j'^2*q33+4*M`j'^2*n3*q33+4*q13*q33-4*n3*q13*q33+q33^2-n3*q33^2)+mbox1l(1+n1,n2,-1+n3,n4)*(tmpprf(ep,1)*prf(4*q13^2+2*q13*q33,-8*M`j'^2*q13+8*M`j'^2*n3*q13+4*q13^2-4*n3*q13^2-4*M`j'^2*q33+4*M`j'^2*n3*q33+4*q13*q33-4*n3*q13*q33+q33^2-n3*q33^2)+prf(-10*M`j'^2*q13-4*M`j'^2*n1*q13+6*M`j'^2*n3*q13-2*M`j'^2*n4*q13-4*q13^2+4*n1*q13^2+2*n2*q13^2+4*n4*q13^2-8*M`j'^2*q33-4*M`j'^2*n1*q33+4*M`j'^2*n3*q33+2*q13*q33+4*n1*q13*q33+n2*q13*q33-2*n3*q13*q33+2*n4*q13*q33+2*q33^2+n1*q33^2-n3*q33^2,-8*M`j'^2*q13+8*M`j'^2*n3*q13+4*q13^2-4*n3*q13^2-4*M`j'^2*q33+4*M`j'^2*n3*q33+4*q13*q33-4*n3*q13*q33+q33^2-n3*q33^2))+mbox1l(1+n1,1+n2,-1+n3,n4)*prf(-4*M`j'^2*n2*q12*q13+4*n2*q12*q13^2+4*M`j'^2*n2*q13*q23-4*M`j'^2*n2*q12*q33+4*n2*q12*q13*q33+n2*q12*q33^2,-8*M`j'^2*q13+8*M`j'^2*n3*q13+4*q13^2-4*n3*q13^2-4*M`j'^2*q33+4*M`j'^2*n3*q33+4*q13*q33-4*n3*q13*q33+q33^2-n3*q33^2);
	Identify,ifmatch->jump mbox1l(n1?neg0_,n2?neg0_,n3?pos_,n4?{,>1}) = mbox1l(1+n1,n2,n3,-2+n4)*prf(2*M`j'^2*n1,-8*M`j'^2*q13+8*M`j'^2*n4*q13+4*q13^2-4*n4*q13^2-4*M`j'^2*q33+4*M`j'^2*n4*q33+4*q13*q33-4*n4*q13*q33+q33^2-n4*q33^2)+mbox1l(n1,1+n2,n3,-2+n4)*prf(2*M`j'^2*n2,-8*M`j'^2*q13+8*M`j'^2*n4*q13+4*q13^2-4*n4*q13^2-4*M`j'^2*q33+4*M`j'^2*n4*q33+4*q13*q33-4*n4*q13*q33+q33^2-n4*q33^2)+mbox1l(n1,n2,1+n3,-2+n4)*prf(2*M`j'^2*n3,-8*M`j'^2*q13+8*M`j'^2*n4*q13+4*q13^2-4*n4*q13^2-4*M`j'^2*q33+4*M`j'^2*n4*q33+4*q13*q33-4*n4*q13*q33+q33^2-n4*q33^2)+mbox1l(1+n1,n2,n3,-1+n4)*prf(-4*M`j'^2*n1*q13,-8*M`j'^2*q13+8*M`j'^2*n4*q13+4*q13^2-4*n4*q13^2-4*M`j'^2*q33+4*M`j'^2*n4*q33+4*q13*q33-4*n4*q13*q33+q33^2-n4*q33^2)+mbox1l(n1,1+n2,n3,-1+n4)*prf(4*M`j'^2*n2*q12+4*M`j'^2*n2*q23,-8*M`j'^2*q13+8*M`j'^2*n4*q13+4*q13^2-4*n4*q13^2-4*M`j'^2*q33+4*M`j'^2*n4*q33+4*q13*q33-4*n4*q13*q33+q33^2-n4*q33^2)+mbox1l(n1,n2,-1+n3,n4)*prf(-2*M`j'^2+2*q13+q33,8*M`j'^2*q13-4*q13^2+4*M`j'^2*q33-4*q13*q33-q33^2)+mbox1l(1+n1,n2,-1+n3,-1+n4)*prf(-2*M`j'^2*n1+2*n1*q13+n1*q33,-8*M`j'^2*q13+8*M`j'^2*n4*q13+4*q13^2-4*n4*q13^2-4*M`j'^2*q33+4*M`j'^2*n4*q33+4*q13*q33-4*n4*q13*q33+q33^2-n4*q33^2)+mbox1l(n1,1+n2,-1+n3,-1+n4)*prf(-2*M`j'^2*n2+2*n2*q13+n2*q33,-8*M`j'^2*q13+8*M`j'^2*n4*q13+4*q13^2-4*n4*q13^2-4*M`j'^2*q33+4*M`j'^2*n4*q33+4*q13*q33-4*n4*q13*q33+q33^2-n4*q33^2)+mbox1l(n1,n2,n3,-1+n4)*(tmpprf(ep,1)*prf(4*q13+2*q33,-8*M`j'^2*q13+8*M`j'^2*n4*q13+4*q13^2-4*n4*q13^2-4*M`j'^2*q33+4*M`j'^2*n4*q33+4*q13*q33-4*n4*q13*q33+q33^2-n4*q33^2)+prf(-2*M`j'^2-2*M`j'^2*n3+2*M`j'^2*n4-10*q13+2*n1*q13+2*n2*q13+4*n3*q13+2*n4*q13-5*q33+n1*q33+n2*q33+2*n3*q33+n4*q33,-8*M`j'^2*q13+8*M`j'^2*n4*q13+4*q13^2-4*n4*q13^2-4*M`j'^2*q33+4*M`j'^2*n4*q33+4*q13*q33-4*n4*q13*q33+q33^2-n4*q33^2));
	Identify,ifmatch->jump mbox1l(n1?neg0_,n2?neg0_,n3?{,>1},n4?pos_) = mbox1l(1+n1,n2,-2+n3,n4)*prf(2*M`j'^2*n1,-8*M`j'^2*q13+8*M`j'^2*n3*q13+4*q13^2-4*n3*q13^2-4*M`j'^2*q33+4*M`j'^2*n3*q33+4*q13*q33-4*n3*q13*q33+q33^2-n3*q33^2)+mbox1l(n1,1+n2,-2+n3,n4)*prf(2*M`j'^2*n2,-8*M`j'^2*q13+8*M`j'^2*n3*q13+4*q13^2-4*n3*q13^2-4*M`j'^2*q33+4*M`j'^2*n3*q33+4*q13*q33-4*n3*q13*q33+q33^2-n3*q33^2)+mbox1l(n1,n2,-2+n3,1+n4)*prf(2*M`j'^2*n4,-8*M`j'^2*q13+8*M`j'^2*n3*q13+4*q13^2-4*n3*q13^2-4*M`j'^2*q33+4*M`j'^2*n3*q33+4*q13*q33-4*n3*q13*q33+q33^2-n3*q33^2)+mbox1l(n1,n2,n3,-1+n4)*prf(-2*M`j'^2+2*q13+q33,8*M`j'^2*q13-4*q13^2+4*M`j'^2*q33-4*q13*q33-q33^2)+mbox1l(1+n1,n2,-1+n3,-1+n4)*prf(-2*M`j'^2*n1+2*n1*q13+n1*q33,-8*M`j'^2*q13+8*M`j'^2*n3*q13+4*q13^2-4*n3*q13^2-4*M`j'^2*q33+4*M`j'^2*n3*q33+4*q13*q33-4*n3*q13*q33+q33^2-n3*q33^2)+mbox1l(n1,1+n2,-1+n3,-1+n4)*prf(-2*M`j'^2*n2+2*n2*q13+n2*q33,-8*M`j'^2*q13+8*M`j'^2*n3*q13+4*q13^2-4*n3*q13^2-4*M`j'^2*q33+4*M`j'^2*n3*q33+4*q13*q33-4*n3*q13*q33+q33^2-n3*q33^2)+mbox1l(n1,n2,-1+n3,n4)*(tmpprf(ep,1)*prf(4*q13+2*q33,-8*M`j'^2*q13+8*M`j'^2*n3*q13+4*q13^2-4*n3*q13^2-4*M`j'^2*q33+4*M`j'^2*n3*q33+4*q13*q33-4*n3*q13*q33+q33^2-n3*q33^2)+prf(-2*M`j'^2+2*M`j'^2*n3-2*M`j'^2*n4-10*q13+2*n1*q13+2*n2*q13+2*n3*q13+4*n4*q13-5*q33+n1*q33+n2*q33+n3*q33+2*n4*q33,-8*M`j'^2*q13+8*M`j'^2*n3*q13+4*q13^2-4*n3*q13^2-4*M`j'^2*q33+4*M`j'^2*n3*q33+4*q13*q33-4*n3*q13*q33+q33^2-n3*q33^2))+mbox1l(1+n1,n2,-1+n3,n4)*prf(-4*M`j'^2*n1*q13-4*M`j'^2*n1*q33+2*n1*q13*q33+n1*q33^2,-8*M`j'^2*q13+8*M`j'^2*n3*q13+4*q13^2-4*n3*q13^2-4*M`j'^2*q33+4*M`j'^2*n3*q33+4*q13*q33-4*n3*q13*q33+q33^2-n3*q33^2)+mbox1l(n1,1+n2,-1+n3,n4)*prf(-4*M`j'^2*n2*q12-8*M`j'^2*n2*q13+4*n2*q12*q13+4*n2*q13^2-4*M`j'^2*n2*q23+4*n2*q13*q23-4*M`j'^2*n2*q33+2*n2*q12*q33+4*n2*q13*q33+2*n2*q23*q33+n2*q33^2,-8*M`j'^2*q13+8*M`j'^2*n3*q13+4*q13^2-4*n3*q13^2-4*M`j'^2*q33+4*M`j'^2*n3*q33+4*q13*q33-4*n3*q13*q33+q33^2-n3*q33^2);
	Identify,ifmatch->jump mbox1l(n1?neg0_,n2?neg_,n3?pos_,n4?pos_) = mbox1l(n1,1+n2,n3,-1+n4)*prf(-q12,q13)+mbox1l(-1+n1,2+n2,n3,-1+n4)*prf(-q12^2-n2*q12^2-q12*q23-n2*q12*q23,-q13^2+n1*q13^2)+mbox1l(-2+n1,2+n2,n3,n4)*prf(q12^2+n2*q12^2+2*q12*q23+2*n2*q12*q23+q23^2+n2*q23^2,-q13^2+n1*q13^2)+mbox1l(n1,1+n2,n3,n4)*prf(-2*q12*q13-q12*q33,q13)+mbox1l(n1,1+n2,-1+n3,n4)*prf(q13^2+q13*q23-q12*q33,q13^2)+mbox1l(-1+n1,1+n2,n3,n4)*prf(-2*q12*q13+n1*q12*q13-n2*q12*q13+2*q13*q23-n1*q13*q23+n2*q13*q23-2*q12*q33+n1*q12*q33-n2*q12*q33,-q13^2+n1*q13^2)+mbox1l(-1+n1,2+n2,-1+n3,n4)*prf(q12*q13+n2*q12*q13-q12*q23-n2*q12*q23-q13*q23-n2*q13*q23-q23^2-n2*q23^2+q12*q33+n2*q12*q33,-q13^2+n1*q13^2)+mbox1l(-1+n1,2+n2,n3,n4)*prf(-2*q12^2*q13-2*n2*q12^2*q13-2*q12*q13*q23-2*n2*q12*q13*q23-q12^2*q33-n2*q12^2*q33-q12*q23*q33-n2*q12*q23*q33,-q13^2+n1*q13^2);
	Identify,ifmatch->jump mbox1l(n1?neg_,0,1,1) = tmpprf(1,-1+2*ep+n1)*mbox1l(n1,0,0,2)*prf(-2*M`j'^2,2*q13+q33)+tmpprf(1,-1+2*ep+n1)*mbox1l(1+n1,0,0,1)*prf(-2*M`j'^2*n1,2*q13+q33)+tmpprf(1,-1+2*ep+n1)*mbox1l(1+n1,0,0,2)*prf(2*M`j'^2*q13,2*q13+q33)+tmpprf(1,-1+2*ep+n1)*mbox1l(1+n1,0,2,0)*prf(2*M`j'^2*q13,2*q13+q33)+mbox1l(1+n1,0,1,1)*(tmpprf(ep,-1+2*ep+n1)*prf(2*q13,1)+tmpprf(1,-1+2*ep+n1)*prf(2*n1*q13,1))+tmpprf(1,-1+2*ep+n1)*mbox1l(2+n1,0,1,0)*prf(2*M`j'^2*q13+2*M`j'^2*n1*q13,2*q13+q33)+tmpprf(1,-1+2*ep+n1)*mbox1l(2+n1,0,1,1)*prf(-4*M`j'^2*q13^2-4*M`j'^2*n1*q13^2,2*q13+q33)+tmpprf(1,-1+2*ep+n1)*mbox1l(n1,0,2,0)*prf(2*M`j'^2-2*q13-q33,2*q13+q33)+tmpprf(1,-1+2*ep+n1)*mbox1l(1+n1,0,1,0)*prf(2*M`j'^2*n1-2*n1*q13-n1*q33,2*q13+q33)+tmpprf(1,-1+2*ep+n1)*mbox1l(2+n1,0,0,1)*prf(2*M`j'^2*q13+2*M`j'^2*n1*q13+4*M`j'^2*q33+4*M`j'^2*n1*q33-2*q13*q33-2*n1*q13*q33-q33^2-n1*q33^2,2*q13+q33);
	Identify,ifmatch->jump mbox1l(n1?neg0_,n2?pos_,n3?neg_,n4?{,>1}) = mbox1l(n1,1+n2,1+n3,-2+n4)*prf(2*M`j'^2*n2*q12+2*M`j'^2*n2*q23,-8*M`j'^2*q12+8*M`j'^2*n4*q12+4*q12^2-4*n4*q12^2-8*M`j'^2*q13+8*M`j'^2*n4*q13+8*q12*q13-8*n4*q12*q13+4*q13^2-4*n4*q13^2-8*M`j'^2*q23+8*M`j'^2*n4*q23+8*q12*q23-8*n4*q12*q23+8*q13*q23-8*n4*q13*q23+4*q23^2-4*n4*q23^2-4*M`j'^2*q33+4*M`j'^2*n4*q33+4*q12*q33-4*n4*q12*q33+4*q13*q33-4*n4*q13*q33+4*q23*q33-4*n4*q23*q33+q33^2-n4*q33^2)+mbox1l(-1+n1,n2,2+n3,-1+n4)*prf(2*q12^3+2*n3*q12^3+q12^2*q13+n3*q12^2*q13+5*q12^2*q23+5*n3*q12^2*q23+2*q12*q13*q23+2*n3*q12*q13*q23+4*q12*q23^2+4*n3*q12*q23^2+q13*q23^2+n3*q13*q23^2+q23^3+n3*q23^3,2*q12*q13^2-2*n4*q12*q13^2+2*q13^3-2*n4*q13^3+4*q12*q13*q23-4*n4*q12*q13*q23+6*q13^2*q23-6*n4*q13^2*q23+2*q12*q23^2-2*n4*q12*q23^2+6*q13*q23^2-6*n4*q13*q23^2+2*q23^3-2*n4*q23^3-4*q12^2*q33+4*n4*q12^2*q33-4*q12*q13*q33+4*n4*q12*q13*q33+q13^2*q33-n4*q13^2*q33-4*q12*q23*q33+4*n4*q12*q23*q33+2*q13*q23*q33-2*n4*q13*q23*q33+q23^2*q33-n4*q23^2*q33-2*q12*q33^2+2*n4*q12*q33^2)+mbox1l(n1,n2,2+n3,-2+n4)*prf(8*M`j'^2*q12^3+8*M`j'^2*n3*q12^3-4*q12^4-4*n3*q12^4+4*M`j'^2*q12^2*q13+4*M`j'^2*n3*q12^2*q13-6*q12^3*q13-6*n3*q12^3*q13+2*M`j'^2*q12*q13^2+2*M`j'^2*n3*q12*q13^2-2*q12^2*q13^2-2*n3*q12^2*q13^2+12*M`j'^2*q12^2*q23+12*M`j'^2*n3*q12^2*q23-10*q12^3*q23-10*n3*q12^3*q23+8*M`j'^2*q12*q13*q23+8*M`j'^2*n3*q12*q13*q23-10*q12^2*q13*q23-10*n3*q12^2*q13*q23+2*M`j'^2*q13^2*q23+2*M`j'^2*n3*q13^2*q23-2*q12*q13^2*q23-2*n3*q12*q13^2*q23+6*M`j'^2*q12*q23^2+6*M`j'^2*n3*q12*q23^2-8*q12^2*q23^2-8*n3*q12^2*q23^2+4*M`j'^2*q13*q23^2+4*M`j'^2*n3*q13*q23^2-4*q12*q13*q23^2-4*n3*q12*q13*q23^2+2*M`j'^2*q23^3+2*M`j'^2*n3*q23^3-2*q12*q23^3-2*n3*q12*q23^3-4*M`j'^2*q12^2*q33-4*M`j'^2*n3*q12^2*q33-2*q12^3*q33-2*n3*q12^3*q33-q12^2*q13*q33-n3*q12^2*q13*q33-4*M`j'^2*q12*q23*q33-4*M`j'^2*n3*q12*q23*q33-3*q12^2*q23*q33-3*n3*q12^2*q23*q33-q12*q13*q23*q33-n3*q12*q13*q23*q33-q12*q23^2*q33-n3*q12*q23^2*q33,-8*M`j'^2*q12*q13^2+8*M`j'^2*n4*q12*q13^2+4*q12^2*q13^2-4*n4*q12^2*q13^2-8*M`j'^2*q13^3+8*M`j'^2*n4*q13^3+8*q12*q13^3-8*n4*q12*q13^3+4*q13^4-4*n4*q13^4-16*M`j'^2*q12*q13*q23+16*M`j'^2*n4*q12*q13*q23+8*q12^2*q13*q23-8*n4*q12^2*q13*q23-24*M`j'^2*q13^2*q23+24*M`j'^2*n4*q13^2*q23+24*q12*q13^2*q23-24*n4*q12*q13^2*q23+16*q13^3*q23-16*n4*q13^3*q23-8*M`j'^2*q12*q23^2+8*M`j'^2*n4*q12*q23^2+4*q12^2*q23^2-4*n4*q12^2*q23^2-24*M`j'^2*q13*q23^2+24*M`j'^2*n4*q13*q23^2+24*q12*q13*q23^2-24*n4*q12*q13*q23^2+24*q13^2*q23^2-24*n4*q13^2*q23^2-8*M`j'^2*q23^3+8*M`j'^2*n4*q23^3+8*q12*q23^3-8*n4*q12*q23^3+16*q13*q23^3-16*n4*q13*q23^3+4*q23^4-4*n4*q23^4+16*M`j'^2*q12^2*q33-16*M`j'^2*n4*q12^2*q33-8*q12^3*q33+8*n4*q12^3*q33+16*M`j'^2*q12*q13*q33-16*M`j'^2*n4*q12*q13*q33-16*q12^2*q13*q33+16*n4*q12^2*q13*q33-4*M`j'^2*q13^2*q33+4*M`j'^2*n4*q13^2*q33-4*q12*q13^2*q33+4*n4*q12*q13^2*q33+4*q13^3*q33-4*n4*q13^3*q33+16*M`j'^2*q12*q23*q33-16*M`j'^2*n4*q12*q23*q33-16*q12^2*q23*q33+16*n4*q12^2*q23*q33-8*M`j'^2*q13*q23*q33+8*M`j'^2*n4*q13*q23*q33-8*q12*q13*q23*q33+8*n4*q12*q13*q23*q33+12*q13^2*q23*q33-12*n4*q13^2*q23*q33-4*M`j'^2*q23^2*q33+4*M`j'^2*n4*q23^2*q33-4*q12*q23^2*q33+4*n4*q12*q23^2*q33+12*q13*q23^2*q33-12*n4*q13*q23^2*q33+4*q23^3*q33-4*n4*q23^3*q33+8*M`j'^2*q12*q33^2-8*M`j'^2*n4*q12*q33^2-8*q12^2*q33^2+8*n4*q12^2*q33^2-8*q12*q13*q33^2+8*n4*q12*q13*q33^2+q13^2*q33^2-n4*q13^2*q33^2-8*q12*q23*q33^2+8*n4*q12*q23*q33^2+2*q13*q23*q33^2-2*n4*q13*q23*q33^2+q23^2*q33^2-n4*q23^2*q33^2-2*q12*q33^3+2*n4*q12*q33^3)+mbox1l(n1,-1+n2,1+n3,n4)*prf(-2*M`j'^2*q12-8*M`j'^2*q13+4*q12*q13+4*q13^2-2*M`j'^2*q23+4*q13*q23-4*M`j'^2*q33+2*q12*q33+4*q13*q33+2*q23*q33+q33^2,-8*M`j'^2*q12+4*q12^2-8*M`j'^2*q13+8*q12*q13+4*q13^2-8*M`j'^2*q23+8*q12*q23+8*q13*q23+4*q23^2-4*M`j'^2*q33+4*q12*q33+4*q13*q33+4*q23*q33+q33^2)+mbox1l(1+n1,n2,1+n3,-2+n4)*prf(-8*M`j'^2*n1*q12^2*q13+4*n1*q12^3*q13+2*M`j'^2*n1*q12*q13^2+4*n1*q12^2*q13^2+8*M`j'^2*n1*q12^2*q23-4*n1*q12^3*q23+12*M`j'^2*n1*q12*q13*q23-4*n1*q12^2*q13*q23+2*M`j'^2*n1*q13^2*q23-4*n1*q12*q13^2*q23+10*M`j'^2*n1*q12*q23^2-8*n1*q12^2*q23^2+4*M`j'^2*n1*q13*q23^2-8*n1*q12*q13*q23^2+2*M`j'^2*n1*q23^3-4*n1*q12*q23^3-12*M`j'^2*n1*q12^2*q33+4*n1*q12^3*q33+6*n1*q12^2*q13*q33-4*M`j'^2*n1*q12*q23*q33+2*n1*q12^2*q23*q33-2*n1*q12*q13*q23*q33-2*n1*q12*q23^2*q33+2*n1*q12^2*q33^2,-8*M`j'^2*q12*q13^2+8*M`j'^2*n4*q12*q13^2+4*q12^2*q13^2-4*n4*q12^2*q13^2-8*M`j'^2*q13^3+8*M`j'^2*n4*q13^3+8*q12*q13^3-8*n4*q12*q13^3+4*q13^4-4*n4*q13^4-16*M`j'^2*q12*q13*q23+16*M`j'^2*n4*q12*q13*q23+8*q12^2*q13*q23-8*n4*q12^2*q13*q23-24*M`j'^2*q13^2*q23+24*M`j'^2*n4*q13^2*q23+24*q12*q13^2*q23-24*n4*q12*q13^2*q23+16*q13^3*q23-16*n4*q13^3*q23-8*M`j'^2*q12*q23^2+8*M`j'^2*n4*q12*q23^2+4*q12^2*q23^2-4*n4*q12^2*q23^2-24*M`j'^2*q13*q23^2+24*M`j'^2*n4*q13*q23^2+24*q12*q13*q23^2-24*n4*q12*q13*q23^2+24*q13^2*q23^2-24*n4*q13^2*q23^2-8*M`j'^2*q23^3+8*M`j'^2*n4*q23^3+8*q12*q23^3-8*n4*q12*q23^3+16*q13*q23^3-16*n4*q13*q23^3+4*q23^4-4*n4*q23^4+16*M`j'^2*q12^2*q33-16*M`j'^2*n4*q12^2*q33-8*q12^3*q33+8*n4*q12^3*q33+16*M`j'^2*q12*q13*q33-16*M`j'^2*n4*q12*q13*q33-16*q12^2*q13*q33+16*n4*q12^2*q13*q33-4*M`j'^2*q13^2*q33+4*M`j'^2*n4*q13^2*q33-4*q12*q13^2*q33+4*n4*q12*q13^2*q33+4*q13^3*q33-4*n4*q13^3*q33+16*M`j'^2*q12*q23*q33-16*M`j'^2*n4*q12*q23*q33-16*q12^2*q23*q33+16*n4*q12^2*q23*q33-8*M`j'^2*q13*q23*q33+8*M`j'^2*n4*q13*q23*q33-8*q12*q13*q23*q33+8*n4*q12*q13*q23*q33+12*q13^2*q23*q33-12*n4*q13^2*q23*q33-4*M`j'^2*q23^2*q33+4*M`j'^2*n4*q23^2*q33-4*q12*q23^2*q33+4*n4*q12*q23^2*q33+12*q13*q23^2*q33-12*n4*q13*q23^2*q33+4*q23^3*q33-4*n4*q23^3*q33+8*M`j'^2*q12*q33^2-8*M`j'^2*n4*q12*q33^2-8*q12^2*q33^2+8*n4*q12^2*q33^2-8*q12*q13*q33^2+8*n4*q12*q13*q33^2+q13^2*q33^2-n4*q13^2*q33^2-8*q12*q23*q33^2+8*n4*q12*q23*q33^2+2*q13*q23*q33^2-2*n4*q13*q23*q33^2+q23^2*q33^2-n4*q23^2*q33^2-2*q12*q33^3+2*n4*q12*q33^3)+mbox1l(1+n1,-1+n2,1+n3,-1+n4)*prf(-6*M`j'^2*n1*q12*q13^2+4*n1*q12^2*q13^2+4*n1*q12*q13^3-4*M`j'^2*n1*q12*q13*q23+4*n1*q12^2*q13*q23+2*M`j'^2*n1*q13^2*q23+8*n1*q12*q13^2*q23+2*M`j'^2*n1*q12*q23^2+4*M`j'^2*n1*q13*q23^2+4*n1*q12*q13*q23^2+2*M`j'^2*n1*q23^3+4*M`j'^2*n1*q12^2*q33-4*n1*q12^3*q33-4*M`j'^2*n1*q12*q13*q33-2*n1*q12^2*q13*q33+4*n1*q12*q13^2*q33-6*n1*q12^2*q23*q33+2*n1*q12*q13*q23*q33-2*n1*q12*q23^2*q33-2*n1*q12^2*q33^2+n1*q12*q13*q33^2-n1*q12*q23*q33^2,-8*M`j'^2*q12*q13^2+8*M`j'^2*n4*q12*q13^2+4*q12^2*q13^2-4*n4*q12^2*q13^2-8*M`j'^2*q13^3+8*M`j'^2*n4*q13^3+8*q12*q13^3-8*n4*q12*q13^3+4*q13^4-4*n4*q13^4-16*M`j'^2*q12*q13*q23+16*M`j'^2*n4*q12*q13*q23+8*q12^2*q13*q23-8*n4*q12^2*q13*q23-24*M`j'^2*q13^2*q23+24*M`j'^2*n4*q13^2*q23+24*q12*q13^2*q23-24*n4*q12*q13^2*q23+16*q13^3*q23-16*n4*q13^3*q23-8*M`j'^2*q12*q23^2+8*M`j'^2*n4*q12*q23^2+4*q12^2*q23^2-4*n4*q12^2*q23^2-24*M`j'^2*q13*q23^2+24*M`j'^2*n4*q13*q23^2+24*q12*q13*q23^2-24*n4*q12*q13*q23^2+24*q13^2*q23^2-24*n4*q13^2*q23^2-8*M`j'^2*q23^3+8*M`j'^2*n4*q23^3+8*q12*q23^3-8*n4*q12*q23^3+16*q13*q23^3-16*n4*q13*q23^3+4*q23^4-4*n4*q23^4+16*M`j'^2*q12^2*q33-16*M`j'^2*n4*q12^2*q33-8*q12^3*q33+8*n4*q12^3*q33+16*M`j'^2*q12*q13*q33-16*M`j'^2*n4*q12*q13*q33-16*q12^2*q13*q33+16*n4*q12^2*q13*q33-4*M`j'^2*q13^2*q33+4*M`j'^2*n4*q13^2*q33-4*q12*q13^2*q33+4*n4*q12*q13^2*q33+4*q13^3*q33-4*n4*q13^3*q33+16*M`j'^2*q12*q23*q33-16*M`j'^2*n4*q12*q23*q33-16*q12^2*q23*q33+16*n4*q12^2*q23*q33-8*M`j'^2*q13*q23*q33+8*M`j'^2*n4*q13*q23*q33-8*q12*q13*q23*q33+8*n4*q12*q13*q23*q33+12*q13^2*q23*q33-12*n4*q13^2*q23*q33-4*M`j'^2*q23^2*q33+4*M`j'^2*n4*q23^2*q33-4*q12*q23^2*q33+4*n4*q12*q23^2*q33+12*q13*q23^2*q33-12*n4*q13*q23^2*q33+4*q23^3*q33-4*n4*q23^3*q33+8*M`j'^2*q12*q33^2-8*M`j'^2*n4*q12*q33^2-8*q12^2*q33^2+8*n4*q12^2*q33^2-8*q12*q13*q33^2+8*n4*q12*q13*q33^2+q13^2*q33^2-n4*q13^2*q33^2-8*q12*q23*q33^2+8*n4*q12*q23*q33^2+2*q13*q23*q33^2-2*n4*q13*q23*q33^2+q23^2*q33^2-n4*q23^2*q33^2-2*q12*q33^3+2*n4*q12*q33^3)+mbox1l(n1,n2,1+n3,-1+n4)*(tmpprf(ep,1)*prf(4*q12^2*q13^2+4*q12*q13^3+8*q12^2*q13*q23+16*q12*q13^2*q23+4*q13^3*q23+4*q12^2*q23^2+20*q12*q13*q23^2+12*q13^2*q23^2+8*q12*q23^3+12*q13*q23^3+4*q23^4-8*q12^3*q33-8*q12^2*q13*q33+2*q12*q13^2*q33-16*q12^2*q23*q33-4*q12*q13*q23*q33+2*q13^2*q23*q33-6*q12*q23^2*q33+4*q13*q23^2*q33+2*q23^3*q33-4*q12^2*q33^2-4*q12*q23*q33^2,-8*M`j'^2*q12*q13^2+8*M`j'^2*n4*q12*q13^2+4*q12^2*q13^2-4*n4*q12^2*q13^2-8*M`j'^2*q13^3+8*M`j'^2*n4*q13^3+8*q12*q13^3-8*n4*q12*q13^3+4*q13^4-4*n4*q13^4-16*M`j'^2*q12*q13*q23+16*M`j'^2*n4*q12*q13*q23+8*q12^2*q13*q23-8*n4*q12^2*q13*q23-24*M`j'^2*q13^2*q23+24*M`j'^2*n4*q13^2*q23+24*q12*q13^2*q23-24*n4*q12*q13^2*q23+16*q13^3*q23-16*n4*q13^3*q23-8*M`j'^2*q12*q23^2+8*M`j'^2*n4*q12*q23^2+4*q12^2*q23^2-4*n4*q12^2*q23^2-24*M`j'^2*q13*q23^2+24*M`j'^2*n4*q13*q23^2+24*q12*q13*q23^2-24*n4*q12*q13*q23^2+24*q13^2*q23^2-24*n4*q13^2*q23^2-8*M`j'^2*q23^3+8*M`j'^2*n4*q23^3+8*q12*q23^3-8*n4*q12*q23^3+16*q13*q23^3-16*n4*q13*q23^3+4*q23^4-4*n4*q23^4+16*M`j'^2*q12^2*q33-16*M`j'^2*n4*q12^2*q33-8*q12^3*q33+8*n4*q12^3*q33+16*M`j'^2*q12*q13*q33-16*M`j'^2*n4*q12*q13*q33-16*q12^2*q13*q33+16*n4*q12^2*q13*q33-4*M`j'^2*q13^2*q33+4*M`j'^2*n4*q13^2*q33-4*q12*q13^2*q33+4*n4*q12*q13^2*q33+4*q13^3*q33-4*n4*q13^3*q33+16*M`j'^2*q12*q23*q33-16*M`j'^2*n4*q12*q23*q33-16*q12^2*q23*q33+16*n4*q12^2*q23*q33-8*M`j'^2*q13*q23*q33+8*M`j'^2*n4*q13*q23*q33-8*q12*q13*q23*q33+8*n4*q12*q13*q23*q33+12*q13^2*q23*q33-12*n4*q13^2*q23*q33-4*M`j'^2*q23^2*q33+4*M`j'^2*n4*q23^2*q33-4*q12*q23^2*q33+4*n4*q12*q23^2*q33+12*q13*q23^2*q33-12*n4*q13*q23^2*q33+4*q23^3*q33-4*n4*q23^3*q33+8*M`j'^2*q12*q33^2-8*M`j'^2*n4*q12*q33^2-8*q12^2*q33^2+8*n4*q12^2*q33^2-8*q12*q13*q33^2+8*n4*q12*q13*q33^2+q13^2*q33^2-n4*q13^2*q33^2-8*q12*q23*q33^2+8*n4*q12*q23*q33^2+2*q13*q23*q33^2-2*n4*q13*q23*q33^2+q23^2*q33^2-n4*q23^2*q33^2-2*q12*q33^3+2*n4*q12*q33^3)+prf(-8*M`j'^2*q12^2*q13+8*M`j'^2*n1*q12^2*q13-8*M`j'^2*n3*q12^2*q13+4*q12^3*q13-4*n1*q12^3*q13+4*n3*q12^3*q13-14*M`j'^2*q12*q13^2+4*M`j'^2*n1*q12*q13^2-2*M`j'^2*n2*q12*q13^2-8*M`j'^2*n3*q12*q13^2+6*M`j'^2*n4*q12*q13^2+2*q12^2*q13^2-4*n1*q12^2*q13^2+4*n2*q12^2*q13^2+10*n3*q12^2*q13^2-2*q12*q13^3+4*n2*q12*q13^3+6*n3*q12*q13^3+8*M`j'^2*q12^2*q23-8*M`j'^2*n1*q12^2*q23+8*M`j'^2*n3*q12^2*q23-4*q12^3*q23+4*n1*q12^3*q23-4*n3*q12^3*q23-12*M`j'^2*q12*q13*q23-8*M`j'^2*n1*q12*q13*q23-4*M`j'^2*n2*q12*q13*q23+12*M`j'^2*n4*q12*q13*q23-12*q12^2*q13*q23+8*n1*q12^2*q13*q23+8*n2*q12^2*q13*q23+4*n3*q12^2*q13*q23-6*M`j'^2*q13^2*q23-4*M`j'^2*n1*q13^2*q23-2*M`j'^2*n2*q13^2*q23+6*M`j'^2*n4*q13^2*q23-20*q12*q13^2*q23+12*n1*q12*q13^2*q23+16*n2*q12*q13^2*q23+12*n3*q12*q13^2*q23-6*q13^3*q23+4*n1*q13^3*q23+4*n2*q13^3*q23+2*n3*q13^3*q23+2*M`j'^2*q12*q23^2-12*M`j'^2*n1*q12*q23^2-2*M`j'^2*n2*q12*q23^2+8*M`j'^2*n3*q12*q23^2+6*M`j'^2*n4*q12*q23^2-14*q12^2*q23^2+12*n1*q12^2*q23^2+4*n2*q12^2*q23^2-6*n3*q12^2*q23^2-12*M`j'^2*q13*q23^2-8*M`j'^2*n1*q13*q23^2-4*M`j'^2*n2*q13*q23^2+12*M`j'^2*n4*q13*q23^2-34*q12*q13*q23^2+24*n1*q12*q13*q23^2+20*n2*q12*q13*q23^2+6*n3*q12*q13*q23^2-18*q13^2*q23^2+12*n1*q13^2*q23^2+12*n2*q13^2*q23^2+6*n3*q13^2*q23^2-6*M`j'^2*q23^3-4*M`j'^2*n1*q23^3-2*M`j'^2*n2*q23^3+6*M`j'^2*n4*q23^3-16*q12*q23^3+12*n1*q12*q23^3+8*n2*q12*q23^3-18*q13*q23^3+12*n1*q13*q23^3+12*n2*q13*q23^3+6*n3*q13*q23^3-6*q23^4+4*n1*q23^4+4*n2*q23^4+2*n3*q23^4+12*M`j'^2*q12^2*q33+8*M`j'^2*n1*q12^2*q33+4*M`j'^2*n2*q12^2*q33-12*M`j'^2*n4*q12^2*q33+12*q12^3*q33-8*n1*q12^3*q33-8*n2*q12^3*q33-4*n3*q12^3*q33-4*M`j'^2*q12*q13*q33+4*M`j'^2*n1*q12*q13*q33-4*M`j'^2*n3*q12*q13*q33+16*q12^2*q13*q33-12*n1*q12^2*q13*q33-8*n2*q12^2*q13*q33+q12*q13^2*q33-2*n1*q12*q13^2*q33+2*n2*q12*q13^2*q33+5*n3*q12*q13^2*q33+16*M`j'^2*q12*q23*q33+4*M`j'^2*n1*q12*q23*q33+4*M`j'^2*n2*q12*q23*q33+4*M`j'^2*n3*q12*q23*q33-12*M`j'^2*n4*q12*q23*q33+20*q12^2*q23*q33-12*n1*q12^2*q23*q33-16*n2*q12^2*q23*q33-12*n3*q12^2*q23*q33+6*q12*q13*q23*q33-4*n1*q12*q13*q23*q33-4*n2*q12*q13*q23*q33-2*n3*q12*q13*q23*q33-3*q13^2*q23*q33+2*n1*q13^2*q23*q33+2*n2*q13^2*q23*q33+n3*q13^2*q23*q33+5*q12*q23^2*q33-2*n1*q12*q23^2*q33-6*n2*q12*q23^2*q33-7*n3*q12*q23^2*q33-6*q13*q23^2*q33+4*n1*q13*q23^2*q33+4*n2*q13*q23^2*q33+2*n3*q13*q23^2*q33-3*q23^3*q33+2*n1*q23^3*q33+2*n2*q23^3*q33+n3*q23^3*q33+6*q12^2*q33^2-4*n1*q12^2*q33^2-4*n2*q12^2*q33^2-2*n3*q12^2*q33^2+q12*q13*q33^2-n1*q12*q13*q33^2+n3*q12*q13*q33^2+5*q12*q23*q33^2-3*n1*q12*q23*q33^2-4*n2*q12*q23*q33^2-3*n3*q12*q23*q33^2,-8*M`j'^2*q12*q13^2+8*M`j'^2*n4*q12*q13^2+4*q12^2*q13^2-4*n4*q12^2*q13^2-8*M`j'^2*q13^3+8*M`j'^2*n4*q13^3+8*q12*q13^3-8*n4*q12*q13^3+4*q13^4-4*n4*q13^4-16*M`j'^2*q12*q13*q23+16*M`j'^2*n4*q12*q13*q23+8*q12^2*q13*q23-8*n4*q12^2*q13*q23-24*M`j'^2*q13^2*q23+24*M`j'^2*n4*q13^2*q23+24*q12*q13^2*q23-24*n4*q12*q13^2*q23+16*q13^3*q23-16*n4*q13^3*q23-8*M`j'^2*q12*q23^2+8*M`j'^2*n4*q12*q23^2+4*q12^2*q23^2-4*n4*q12^2*q23^2-24*M`j'^2*q13*q23^2+24*M`j'^2*n4*q13*q23^2+24*q12*q13*q23^2-24*n4*q12*q13*q23^2+24*q13^2*q23^2-24*n4*q13^2*q23^2-8*M`j'^2*q23^3+8*M`j'^2*n4*q23^3+8*q12*q23^3-8*n4*q12*q23^3+16*q13*q23^3-16*n4*q13*q23^3+4*q23^4-4*n4*q23^4+16*M`j'^2*q12^2*q33-16*M`j'^2*n4*q12^2*q33-8*q12^3*q33+8*n4*q12^3*q33+16*M`j'^2*q12*q13*q33-16*M`j'^2*n4*q12*q13*q33-16*q12^2*q13*q33+16*n4*q12^2*q13*q33-4*M`j'^2*q13^2*q33+4*M`j'^2*n4*q13^2*q33-4*q12*q13^2*q33+4*n4*q12*q13^2*q33+4*q13^3*q33-4*n4*q13^3*q33+16*M`j'^2*q12*q23*q33-16*M`j'^2*n4*q12*q23*q33-16*q12^2*q23*q33+16*n4*q12^2*q23*q33-8*M`j'^2*q13*q23*q33+8*M`j'^2*n4*q13*q23*q33-8*q12*q13*q23*q33+8*n4*q12*q13*q23*q33+12*q13^2*q23*q33-12*n4*q13^2*q23*q33-4*M`j'^2*q23^2*q33+4*M`j'^2*n4*q23^2*q33-4*q12*q23^2*q33+4*n4*q12*q23^2*q33+12*q13*q23^2*q33-12*n4*q13*q23^2*q33+4*q23^3*q33-4*n4*q23^3*q33+8*M`j'^2*q12*q33^2-8*M`j'^2*n4*q12*q33^2-8*q12^2*q33^2+8*n4*q12^2*q33^2-8*q12*q13*q33^2+8*n4*q12*q13*q33^2+q13^2*q33^2-n4*q13^2*q33^2-8*q12*q23*q33^2+8*n4*q12*q23*q33^2+2*q13*q23*q33^2-2*n4*q13*q23*q33^2+q23^2*q33^2-n4*q23^2*q33^2-2*q12*q33^3+2*n4*q12*q33^3))+mbox1l(n1,-1+n2,2+n3,-1+n4)*prf(8*M`j'^2*q12^2*q13+8*M`j'^2*n3*q12^2*q13-4*q12^3*q13-4*n3*q12^3*q13+6*M`j'^2*q12*q13^2+6*M`j'^2*n3*q12*q13^2-6*q12^2*q13^2-6*n3*q12^2*q13^2-2*q12*q13^3-2*n3*q12*q13^3-2*q12^2*q13*q23-2*n3*q12^2*q13*q23-2*M`j'^2*q13^2*q23-2*M`j'^2*n3*q13^2*q23+2*q12*q13^2*q23+2*n3*q12*q13^2*q23+2*q13^3*q23+2*n3*q13^3*q23+2*M`j'^2*q12*q23^2+2*M`j'^2*n3*q12*q23^2+4*q12*q13*q23^2+4*n3*q12*q13*q23^2+4*q13^2*q23^2+4*n3*q13^2*q23^2+2*M`j'^2*q23^3+2*M`j'^2*n3*q23^3+2*q13*q23^3+2*n3*q13*q23^3+4*M`j'^2*q12^2*q33+4*M`j'^2*n3*q12^2*q33-4*q12^3*q33-4*n3*q12^3*q33+4*M`j'^2*q12*q13*q33+4*M`j'^2*n3*q12*q13*q33-8*q12^2*q13*q33-8*n3*q12^2*q13*q33-3*q12*q13^2*q33-3*n3*q12*q13^2*q33-6*q12^2*q23*q33-6*n3*q12^2*q23*q33-3*q12*q13*q23*q33-3*n3*q12*q13*q23*q33+q13^2*q23*q33+n3*q13^2*q23*q33-2*q12*q23^2*q33-2*n3*q12*q23^2*q33+q13*q23^2*q33+n3*q13*q23^2*q33-2*q12^2*q33^2-2*n3*q12^2*q33^2-q12*q13*q33^2-n3*q12*q13*q33^2-q12*q23*q33^2-n3*q12*q23*q33^2,-8*M`j'^2*q12*q13^2+8*M`j'^2*n4*q12*q13^2+4*q12^2*q13^2-4*n4*q12^2*q13^2-8*M`j'^2*q13^3+8*M`j'^2*n4*q13^3+8*q12*q13^3-8*n4*q12*q13^3+4*q13^4-4*n4*q13^4-16*M`j'^2*q12*q13*q23+16*M`j'^2*n4*q12*q13*q23+8*q12^2*q13*q23-8*n4*q12^2*q13*q23-24*M`j'^2*q13^2*q23+24*M`j'^2*n4*q13^2*q23+24*q12*q13^2*q23-24*n4*q12*q13^2*q23+16*q13^3*q23-16*n4*q13^3*q23-8*M`j'^2*q12*q23^2+8*M`j'^2*n4*q12*q23^2+4*q12^2*q23^2-4*n4*q12^2*q23^2-24*M`j'^2*q13*q23^2+24*M`j'^2*n4*q13*q23^2+24*q12*q13*q23^2-24*n4*q12*q13*q23^2+24*q13^2*q23^2-24*n4*q13^2*q23^2-8*M`j'^2*q23^3+8*M`j'^2*n4*q23^3+8*q12*q23^3-8*n4*q12*q23^3+16*q13*q23^3-16*n4*q13*q23^3+4*q23^4-4*n4*q23^4+16*M`j'^2*q12^2*q33-16*M`j'^2*n4*q12^2*q33-8*q12^3*q33+8*n4*q12^3*q33+16*M`j'^2*q12*q13*q33-16*M`j'^2*n4*q12*q13*q33-16*q12^2*q13*q33+16*n4*q12^2*q13*q33-4*M`j'^2*q13^2*q33+4*M`j'^2*n4*q13^2*q33-4*q12*q13^2*q33+4*n4*q12*q13^2*q33+4*q13^3*q33-4*n4*q13^3*q33+16*M`j'^2*q12*q23*q33-16*M`j'^2*n4*q12*q23*q33-16*q12^2*q23*q33+16*n4*q12^2*q23*q33-8*M`j'^2*q13*q23*q33+8*M`j'^2*n4*q13*q23*q33-8*q12*q13*q23*q33+8*n4*q12*q13*q23*q33+12*q13^2*q23*q33-12*n4*q13^2*q23*q33-4*M`j'^2*q23^2*q33+4*M`j'^2*n4*q23^2*q33-4*q12*q23^2*q33+4*n4*q12*q23^2*q33+12*q13*q23^2*q33-12*n4*q13*q23^2*q33+4*q23^3*q33-4*n4*q23^3*q33+8*M`j'^2*q12*q33^2-8*M`j'^2*n4*q12*q33^2-8*q12^2*q33^2+8*n4*q12^2*q33^2-8*q12*q13*q33^2+8*n4*q12*q13*q33^2+q13^2*q33^2-n4*q13^2*q33^2-8*q12*q23*q33^2+8*n4*q12*q23*q33^2+2*q13*q23*q33^2-2*n4*q13*q23*q33^2+q23^2*q33^2-n4*q23^2*q33^2-2*q12*q33^3+2*n4*q12*q33^3)+mbox1l(n1,n2,2+n3,-1+n4)*prf(16*M`j'^2*q12^3*q13+16*M`j'^2*n3*q12^3*q13-8*q12^4*q13-8*n3*q12^4*q13+4*M`j'^2*q12^2*q13^2+4*M`j'^2*n3*q12^2*q13^2-12*q12^3*q13^2-12*n3*q12^3*q13^2-4*q12^2*q13^3-4*n3*q12^2*q13^3+16*M`j'^2*q12^2*q13*q23+16*M`j'^2*n3*q12^2*q13*q23-20*q12^3*q13*q23-20*n3*q12^3*q13*q23-20*q12^2*q13^2*q23-20*n3*q12^2*q13^2*q23-4*q12*q13^3*q23-4*n3*q12*q13^3*q23-4*M`j'^2*q12^2*q23^2-4*M`j'^2*n3*q12^2*q23^2-8*M`j'^2*q12*q13*q23^2-8*M`j'^2*n3*q12*q13*q23^2-16*q12^2*q13*q23^2-16*n3*q12^2*q13*q23^2-4*M`j'^2*q13^2*q23^2-4*M`j'^2*n3*q13^2*q23^2-8*q12*q13^2*q23^2-8*n3*q12*q13^2*q23^2-8*M`j'^2*q12*q23^3-8*M`j'^2*n3*q12*q23^3-8*M`j'^2*q13*q23^3-8*M`j'^2*n3*q13*q23^3-4*q12*q13*q23^3-4*n3*q12*q13*q23^3-4*M`j'^2*q23^4-4*M`j'^2*n3*q23^4+16*M`j'^2*q12^3*q33+16*M`j'^2*n3*q12^3*q33-4*q12^4*q33-4*n3*q12^4*q33+4*M`j'^2*q12^2*q13*q33+4*M`j'^2*n3*q12^2*q13*q33-10*q12^3*q13*q33-10*n3*q12^3*q13*q33-4*q12^2*q13^2*q33-4*n3*q12^2*q13^2*q33+28*M`j'^2*q12^2*q23*q33+28*M`j'^2*n3*q12^2*q23*q33-10*q12^3*q23*q33-10*n3*q12^3*q23*q33+4*M`j'^2*q12*q13*q23*q33+4*M`j'^2*n3*q12*q13*q23*q33-16*q12^2*q13*q23*q33-16*n3*q12^2*q13*q23*q33-4*q12*q13^2*q23*q33-4*n3*q12*q13^2*q23*q33+12*M`j'^2*q12*q23^2*q33+12*M`j'^2*n3*q12*q23^2*q33-8*q12^2*q23^2*q33-8*n3*q12^2*q23^2*q33-6*q12*q13*q23^2*q33-6*n3*q12*q13*q23^2*q33-2*q12*q23^3*q33-2*n3*q12*q23^3*q33-2*q12^3*q33^2-2*n3*q12^3*q33^2-q12^2*q13*q33^2-n3*q12^2*q13*q33^2-3*q12^2*q23*q33^2-3*n3*q12^2*q23*q33^2-q12*q13*q23*q33^2-n3*q12*q13*q23*q33^2-q12*q23^2*q33^2-n3*q12*q23^2*q33^2,-8*M`j'^2*q12*q13^2+8*M`j'^2*n4*q12*q13^2+4*q12^2*q13^2-4*n4*q12^2*q13^2-8*M`j'^2*q13^3+8*M`j'^2*n4*q13^3+8*q12*q13^3-8*n4*q12*q13^3+4*q13^4-4*n4*q13^4-16*M`j'^2*q12*q13*q23+16*M`j'^2*n4*q12*q13*q23+8*q12^2*q13*q23-8*n4*q12^2*q13*q23-24*M`j'^2*q13^2*q23+24*M`j'^2*n4*q13^2*q23+24*q12*q13^2*q23-24*n4*q12*q13^2*q23+16*q13^3*q23-16*n4*q13^3*q23-8*M`j'^2*q12*q23^2+8*M`j'^2*n4*q12*q23^2+4*q12^2*q23^2-4*n4*q12^2*q23^2-24*M`j'^2*q13*q23^2+24*M`j'^2*n4*q13*q23^2+24*q12*q13*q23^2-24*n4*q12*q13*q23^2+24*q13^2*q23^2-24*n4*q13^2*q23^2-8*M`j'^2*q23^3+8*M`j'^2*n4*q23^3+8*q12*q23^3-8*n4*q12*q23^3+16*q13*q23^3-16*n4*q13*q23^3+4*q23^4-4*n4*q23^4+16*M`j'^2*q12^2*q33-16*M`j'^2*n4*q12^2*q33-8*q12^3*q33+8*n4*q12^3*q33+16*M`j'^2*q12*q13*q33-16*M`j'^2*n4*q12*q13*q33-16*q12^2*q13*q33+16*n4*q12^2*q13*q33-4*M`j'^2*q13^2*q33+4*M`j'^2*n4*q13^2*q33-4*q12*q13^2*q33+4*n4*q12*q13^2*q33+4*q13^3*q33-4*n4*q13^3*q33+16*M`j'^2*q12*q23*q33-16*M`j'^2*n4*q12*q23*q33-16*q12^2*q23*q33+16*n4*q12^2*q23*q33-8*M`j'^2*q13*q23*q33+8*M`j'^2*n4*q13*q23*q33-8*q12*q13*q23*q33+8*n4*q12*q13*q23*q33+12*q13^2*q23*q33-12*n4*q13^2*q23*q33-4*M`j'^2*q23^2*q33+4*M`j'^2*n4*q23^2*q33-4*q12*q23^2*q33+4*n4*q12*q23^2*q33+12*q13*q23^2*q33-12*n4*q13*q23^2*q33+4*q23^3*q33-4*n4*q23^3*q33+8*M`j'^2*q12*q33^2-8*M`j'^2*n4*q12*q33^2-8*q12^2*q33^2+8*n4*q12^2*q33^2-8*q12*q13*q33^2+8*n4*q12*q13*q33^2+q13^2*q33^2-n4*q13^2*q33^2-8*q12*q23*q33^2+8*n4*q12*q23*q33^2+2*q13*q23*q33^2-2*n4*q13*q23*q33^2+q23^2*q33^2-n4*q23^2*q33^2-2*q12*q33^3+2*n4*q12*q33^3)+mbox1l(1+n1,n2,1+n3,-1+n4)*prf(-16*M`j'^2*n1*q12^2*q13^2+8*n1*q12^3*q13^2-4*M`j'^2*n1*q12*q13^3+8*n1*q12^2*q13^3-16*M`j'^2*n1*q12^2*q13*q23+8*n1*q12^3*q13*q23-12*M`j'^2*n1*q12*q13^2*q23+16*n1*q12^2*q13^2*q23-4*M`j'^2*n1*q13^3*q23-12*M`j'^2*n1*q12*q13*q23^2+8*n1*q12^2*q13*q23^2-12*M`j'^2*n1*q13^2*q23^2-4*M`j'^2*n1*q12*q23^3-12*M`j'^2*n1*q13*q23^3-4*M`j'^2*n1*q23^4+16*M`j'^2*n1*q12^3*q33-8*n1*q12^4*q33-8*M`j'^2*n1*q12^2*q13*q33+12*n1*q12^2*q13^2*q33+24*M`j'^2*n1*q12^2*q23*q33-16*n1*q12^3*q23*q33+16*M`j'^2*n1*q12*q13*q23*q33-4*n1*q12*q13^2*q23*q33+16*M`j'^2*n1*q12*q23^2*q33-12*n1*q12^2*q23^2*q33-8*n1*q12*q13*q23^2*q33-4*n1*q12*q23^3*q33-8*M`j'^2*n1*q12^2*q33^2+8*n1*q12^2*q13*q33^2-2*n1*q12*q13*q23*q33^2-2*n1*q12*q23^2*q33^2+2*n1*q12^2*q33^3,-8*M`j'^2*q12*q13^2+8*M`j'^2*n4*q12*q13^2+4*q12^2*q13^2-4*n4*q12^2*q13^2-8*M`j'^2*q13^3+8*M`j'^2*n4*q13^3+8*q12*q13^3-8*n4*q12*q13^3+4*q13^4-4*n4*q13^4-16*M`j'^2*q12*q13*q23+16*M`j'^2*n4*q12*q13*q23+8*q12^2*q13*q23-8*n4*q12^2*q13*q23-24*M`j'^2*q13^2*q23+24*M`j'^2*n4*q13^2*q23+24*q12*q13^2*q23-24*n4*q12*q13^2*q23+16*q13^3*q23-16*n4*q13^3*q23-8*M`j'^2*q12*q23^2+8*M`j'^2*n4*q12*q23^2+4*q12^2*q23^2-4*n4*q12^2*q23^2-24*M`j'^2*q13*q23^2+24*M`j'^2*n4*q13*q23^2+24*q12*q13*q23^2-24*n4*q12*q13*q23^2+24*q13^2*q23^2-24*n4*q13^2*q23^2-8*M`j'^2*q23^3+8*M`j'^2*n4*q23^3+8*q12*q23^3-8*n4*q12*q23^3+16*q13*q23^3-16*n4*q13*q23^3+4*q23^4-4*n4*q23^4+16*M`j'^2*q12^2*q33-16*M`j'^2*n4*q12^2*q33-8*q12^3*q33+8*n4*q12^3*q33+16*M`j'^2*q12*q13*q33-16*M`j'^2*n4*q12*q13*q33-16*q12^2*q13*q33+16*n4*q12^2*q13*q33-4*M`j'^2*q13^2*q33+4*M`j'^2*n4*q13^2*q33-4*q12*q13^2*q33+4*n4*q12*q13^2*q33+4*q13^3*q33-4*n4*q13^3*q33+16*M`j'^2*q12*q23*q33-16*M`j'^2*n4*q12*q23*q33-16*q12^2*q23*q33+16*n4*q12^2*q23*q33-8*M`j'^2*q13*q23*q33+8*M`j'^2*n4*q13*q23*q33-8*q12*q13*q23*q33+8*n4*q12*q13*q23*q33+12*q13^2*q23*q33-12*n4*q13^2*q23*q33-4*M`j'^2*q23^2*q33+4*M`j'^2*n4*q23^2*q33-4*q12*q23^2*q33+4*n4*q12*q23^2*q33+12*q13*q23^2*q33-12*n4*q13*q23^2*q33+4*q23^3*q33-4*n4*q23^3*q33+8*M`j'^2*q12*q33^2-8*M`j'^2*n4*q12*q33^2-8*q12^2*q33^2+8*n4*q12^2*q33^2-8*q12*q13*q33^2+8*n4*q12*q13*q33^2+q13^2*q33^2-n4*q13^2*q33^2-8*q12*q23*q33^2+8*n4*q12*q23*q33^2+2*q13*q23*q33^2-2*n4*q13*q23*q33^2+q23^2*q33^2-n4*q23^2*q33^2-2*q12*q33^3+2*n4*q12*q33^3);
	Identify,ifmatch->jump mbox1l(n1?neg_,n2?pos_,n3?neg0_,n4?{,>1}) = mbox1l(2+n1,-1+n2,n3,-1+n4)*prf(2*M`j'^2*q13+2*M`j'^2*n1*q13+2*M`j'^2*q23+2*M`j'^2*n1*q23,-8*M`j'^2*q12+8*M`j'^2*n4*q12+4*q12^2-4*n4*q12^2-8*M`j'^2*q13+8*M`j'^2*n4*q13+8*q12*q13-8*n4*q12*q13+4*q13^2-4*n4*q13^2-8*M`j'^2*q23+8*M`j'^2*n4*q23+8*q12*q23-8*n4*q12*q23+8*q13*q23-8*n4*q13*q23+4*q23^2-4*n4*q23^2-4*M`j'^2*q33+4*M`j'^2*n4*q33+4*q12*q33-4*n4*q12*q33+4*q13*q33-4*n4*q13*q33+4*q23*q33-4*n4*q23*q33+q33^2-n4*q33^2)+mbox1l(1+n1,1+n2,n3,-2+n4)*prf(2*M`j'^2*n2*q13+2*M`j'^2*n2*q23,-8*M`j'^2*q12+8*M`j'^2*n4*q12+4*q12^2-4*n4*q12^2-8*M`j'^2*q13+8*M`j'^2*n4*q13+8*q12*q13-8*n4*q12*q13+4*q13^2-4*n4*q13^2-8*M`j'^2*q23+8*M`j'^2*n4*q23+8*q12*q23-8*n4*q12*q23+8*q13*q23-8*n4*q13*q23+4*q23^2-4*n4*q23^2-4*M`j'^2*q33+4*M`j'^2*n4*q33+4*q12*q33-4*n4*q12*q33+4*q13*q33-4*n4*q13*q33+4*q23*q33-4*n4*q23*q33+q33^2-n4*q33^2)+mbox1l(n1,n2,1+n3,-1+n4)*prf(-(n3*q12)-n3*q23,-2*q12+2*n4*q12-2*q13+2*n4*q13-2*q23+2*n4*q23-q33+n4*q33)+mbox1l(2+n1,n2,n3,-2+n4)*prf(-8*M`j'^2*q12-8*M`j'^2*n1*q12+4*q12^2+4*n1*q12^2-2*M`j'^2*q13-2*M`j'^2*n1*q13+4*q12*q13+4*n1*q12*q13-2*M`j'^2*q23-2*M`j'^2*n1*q23+4*q12*q23+4*n1*q12*q23+2*q12*q33+2*n1*q12*q33,8*M`j'^2*q12-8*M`j'^2*n4*q12-4*q12^2+4*n4*q12^2+8*M`j'^2*q13-8*M`j'^2*n4*q13-8*q12*q13+8*n4*q12*q13-4*q13^2+4*n4*q13^2+8*M`j'^2*q23-8*M`j'^2*n4*q23-8*q12*q23+8*n4*q12*q23-8*q13*q23+8*n4*q13*q23-4*q23^2+4*n4*q23^2+4*M`j'^2*q33-4*M`j'^2*n4*q33-4*q12*q33+4*n4*q12*q33-4*q13*q33+4*n4*q13*q33-4*q23*q33+4*n4*q23*q33-q33^2+n4*q33^2)+mbox1l(1+n1,n2,1+n3,-2+n4)*prf(-4*M`j'^2*n3*q12+2*n3*q12^2-2*M`j'^2*n3*q13+2*n3*q12*q13-2*M`j'^2*n3*q23+2*n3*q12*q23+n3*q12*q33,8*M`j'^2*q12-8*M`j'^2*n4*q12-4*q12^2+4*n4*q12^2+8*M`j'^2*q13-8*M`j'^2*n4*q13-8*q12*q13+8*n4*q12*q13-4*q13^2+4*n4*q13^2+8*M`j'^2*q23-8*M`j'^2*n4*q23-8*q12*q23+8*n4*q12*q23-8*q13*q23+8*n4*q13*q23-4*q23^2+4*n4*q23^2+4*M`j'^2*q33-4*M`j'^2*n4*q33-4*q12*q33+4*n4*q12*q33-4*q13*q33+4*n4*q13*q33-4*q23*q33+4*n4*q23*q33-q33^2+n4*q33^2)+mbox1l(1+n1,-1+n2,1+n3,-1+n4)*prf(2*M`j'^2*n3*q13-2*n3*q12*q13-2*n3*q13^2-2*M`j'^2*n3*q23-2*n3*q13*q23-n3*q13*q33,8*M`j'^2*q12-8*M`j'^2*n4*q12-4*q12^2+4*n4*q12^2+8*M`j'^2*q13-8*M`j'^2*n4*q13-8*q12*q13+8*n4*q12*q13-4*q13^2+4*n4*q13^2+8*M`j'^2*q23-8*M`j'^2*n4*q23-8*q12*q23+8*n4*q12*q23-8*q13*q23+8*n4*q13*q23-4*q23^2+4*n4*q23^2+4*M`j'^2*q33-4*M`j'^2*n4*q33-4*q12*q33+4*n4*q12*q33-4*q13*q33+4*n4*q13*q33-4*q23*q33+4*n4*q23*q33-q33^2+n4*q33^2)+mbox1l(1+n1,n2,n3,-1+n4)*(tmpprf(ep,1)*prf(-4*q12*q13-4*q13^2-4*q12*q23-8*q13*q23-4*q23^2-2*q13*q33-2*q23*q33,8*M`j'^2*q12-8*M`j'^2*n4*q12-4*q12^2+4*n4*q12^2+8*M`j'^2*q13-8*M`j'^2*n4*q13-8*q12*q13+8*n4*q12*q13-4*q13^2+4*n4*q13^2+8*M`j'^2*q23-8*M`j'^2*n4*q23-8*q12*q23+8*n4*q12*q23-8*q13*q23+8*n4*q13*q23-4*q23^2+4*n4*q23^2+4*M`j'^2*q33-4*M`j'^2*n4*q33-4*q12*q33+4*n4*q12*q33-4*q13*q33+4*n4*q13*q33-4*q23*q33+4*n4*q23*q33-q33^2+n4*q33^2)+prf(16*M`j'^2*q12+8*M`j'^2*n1*q12-8*M`j'^2*n4*q12-8*q12^2-4*n1*q12^2+4*n4*q12^2+10*M`j'^2*q13+4*M`j'^2*n1*q13+2*M`j'^2*n2*q13-6*M`j'^2*n4*q13-4*q12*q13-8*n1*q12*q13-4*n2*q12*q13-2*n3*q12*q13+4*n4*q12*q13+4*q13^2-4*n1*q13^2-4*n2*q13^2-2*n3*q13^2+10*M`j'^2*q23+4*M`j'^2*n1*q23+2*M`j'^2*n2*q23-6*M`j'^2*n4*q23-4*q12*q23-8*n1*q12*q23-4*n2*q12*q23-2*n3*q12*q23+4*n4*q12*q23+8*q13*q23-8*n1*q13*q23-8*n2*q13*q23-4*n3*q13*q23+4*q23^2-4*n1*q23^2-4*n2*q23^2-2*n3*q23^2-4*q12*q33-2*n1*q12*q33+2*n4*q12*q33+2*q13*q33-2*n1*q13*q33-2*n2*q13*q33-n3*q13*q33+2*q23*q33-2*n1*q23*q33-2*n2*q23*q33-n3*q23*q33,8*M`j'^2*q12-8*M`j'^2*n4*q12-4*q12^2+4*n4*q12^2+8*M`j'^2*q13-8*M`j'^2*n4*q13-8*q12*q13+8*n4*q12*q13-4*q13^2+4*n4*q13^2+8*M`j'^2*q23-8*M`j'^2*n4*q23-8*q12*q23+8*n4*q12*q23-8*q13*q23+8*n4*q13*q23-4*q23^2+4*n4*q23^2+4*M`j'^2*q33-4*M`j'^2*n4*q33-4*q12*q33+4*n4*q12*q33-4*q13*q33+4*n4*q13*q33-4*q23*q33+4*n4*q23*q33-q33^2+n4*q33^2))+mbox1l(1+n1,-1+n2,n3,n4)*prf(-2*M`j'^2*q13-2*M`j'^2*q23-4*M`j'^2*q33+2*q12*q33+2*q13*q33+2*q23*q33+q33^2,-8*M`j'^2*q12+4*q12^2-8*M`j'^2*q13+8*q12*q13+4*q13^2-8*M`j'^2*q23+8*q12*q23+8*q13*q23+4*q23^2-4*M`j'^2*q33+4*q12*q33+4*q13*q33+4*q23*q33+q33^2)+mbox1l(2+n1,n2,n3,-1+n4)*prf(4*M`j'^2*q13^2+4*M`j'^2*n1*q13^2+8*M`j'^2*q13*q23+8*M`j'^2*n1*q13*q23+4*M`j'^2*q23^2+4*M`j'^2*n1*q23^2-8*M`j'^2*q12*q33-8*M`j'^2*n1*q12*q33+4*q12^2*q33+4*n1*q12^2*q33+4*q12*q13*q33+4*n1*q12*q13*q33+4*q12*q23*q33+4*n1*q12*q23*q33+2*q12*q33^2+2*n1*q12*q33^2,8*M`j'^2*q12-8*M`j'^2*n4*q12-4*q12^2+4*n4*q12^2+8*M`j'^2*q13-8*M`j'^2*n4*q13-8*q12*q13+8*n4*q12*q13-4*q13^2+4*n4*q13^2+8*M`j'^2*q23-8*M`j'^2*n4*q23-8*q12*q23+8*n4*q12*q23-8*q13*q23+8*n4*q13*q23-4*q23^2+4*n4*q23^2+4*M`j'^2*q33-4*M`j'^2*n4*q33-4*q12*q33+4*n4*q12*q33-4*q13*q33+4*n4*q13*q33-4*q23*q33+4*n4*q23*q33-q33^2+n4*q33^2)+mbox1l(1+n1,n2,1+n3,-1+n4)*prf(-4*M`j'^2*n3*q12*q13+4*n3*q12^2*q13+4*n3*q12*q13^2+4*M`j'^2*n3*q12*q23+4*M`j'^2*n3*q13*q23+4*n3*q12*q13*q23+4*M`j'^2*n3*q23^2-4*M`j'^2*n3*q12*q33+2*n3*q12^2*q33+4*n3*q12*q13*q33+2*n3*q12*q23*q33+n3*q12*q33^2,8*M`j'^2*q12-8*M`j'^2*n4*q12-4*q12^2+4*n4*q12^2+8*M`j'^2*q13-8*M`j'^2*n4*q13-8*q12*q13+8*n4*q12*q13-4*q13^2+4*n4*q13^2+8*M`j'^2*q23-8*M`j'^2*n4*q23-8*q12*q23+8*n4*q12*q23-8*q13*q23+8*n4*q13*q23-4*q23^2+4*n4*q23^2+4*M`j'^2*q33-4*M`j'^2*n4*q33-4*q12*q33+4*n4*q12*q33-4*q13*q33+4*n4*q13*q33-4*q23*q33+4*n4*q23*q33-q33^2+n4*q33^2);
	Identify,ifmatch->jump mbox1l(n1?neg0_,n2?{,>1},n3?neg_,n4?pos_) = mbox1l(n1,n2,1+n3,-1+n4)*prf(2*M`j'^2*q12+2*M`j'^2*q23,8*M`j'^2*q12-4*q12^2+8*M`j'^2*q13-8*q12*q13-4*q13^2+8*M`j'^2*q23-8*q12*q23-8*q13*q23-4*q23^2+4*M`j'^2*q33-4*q12*q33-4*q13*q33-4*q23*q33-q33^2)+mbox1l(n1,-2+n2,1+n3,1+n4)*prf(2*M`j'^2*n4*q12+2*M`j'^2*n4*q23,-8*M`j'^2*q12+8*M`j'^2*n2*q12+4*q12^2-4*n2*q12^2-8*M`j'^2*q13+8*M`j'^2*n2*q13+8*q12*q13-8*n2*q12*q13+4*q13^2-4*n2*q13^2-8*M`j'^2*q23+8*M`j'^2*n2*q23+8*q12*q23-8*n2*q12*q23+8*q13*q23-8*n2*q13*q23+4*q23^2-4*n2*q23^2-4*M`j'^2*q33+4*M`j'^2*n2*q33+4*q12*q33-4*n2*q12*q33+4*q13*q33-4*n2*q13*q33+4*q23*q33-4*n2*q23*q33+q33^2-n2*q33^2)+mbox1l(-1+n1,-1+n2,2+n3,n4)*prf(q12^2*q13+n3*q12^2*q13+q12^2*q23+n3*q12^2*q23+2*q12*q13*q23+2*n3*q12*q13*q23+2*q12*q23^2+2*n3*q12*q23^2+q13*q23^2+n3*q13*q23^2+q23^3+n3*q23^3+q12^2*q33+n3*q12^2*q33+2*q12*q23*q33+2*n3*q12*q23*q33+q23^2*q33+n3*q23^2*q33,2*q12*q13^2-2*n2*q12*q13^2+2*q13^3-2*n2*q13^3+4*q12*q13*q23-4*n2*q12*q13*q23+6*q13^2*q23-6*n2*q13^2*q23+2*q12*q23^2-2*n2*q12*q23^2+6*q13*q23^2-6*n2*q13*q23^2+2*q23^3-2*n2*q23^3-4*q12^2*q33+4*n2*q12^2*q33-4*q12*q13*q33+4*n2*q12*q13*q33+q13^2*q33-n2*q13^2*q33-4*q12*q23*q33+4*n2*q12*q23*q33+2*q13*q23*q33-2*n2*q13*q23*q33+q23^2*q33-n2*q23^2*q33-2*q12*q33^2+2*n2*q12*q33^2)+mbox1l(1+n1,-1+n2,1+n3,-1+n4)*prf(-6*M`j'^2*n1*q12*q13^2+4*n1*q12^2*q13^2+4*n1*q12*q13^3-4*M`j'^2*n1*q12*q13*q23+4*n1*q12^2*q13*q23+2*M`j'^2*n1*q13^2*q23+8*n1*q12*q13^2*q23+2*M`j'^2*n1*q12*q23^2+4*M`j'^2*n1*q13*q23^2+4*n1*q12*q13*q23^2+2*M`j'^2*n1*q23^3+4*M`j'^2*n1*q12^2*q33-4*n1*q12^3*q33-4*M`j'^2*n1*q12*q13*q33-2*n1*q12^2*q13*q33+4*n1*q12*q13^2*q33-6*n1*q12^2*q23*q33+2*n1*q12*q13*q23*q33-2*n1*q12*q23^2*q33-2*n1*q12^2*q33^2+n1*q12*q13*q33^2-n1*q12*q23*q33^2,-8*M`j'^2*q12*q13^2+8*M`j'^2*n2*q12*q13^2+4*q12^2*q13^2-4*n2*q12^2*q13^2-8*M`j'^2*q13^3+8*M`j'^2*n2*q13^3+8*q12*q13^3-8*n2*q12*q13^3+4*q13^4-4*n2*q13^4-16*M`j'^2*q12*q13*q23+16*M`j'^2*n2*q12*q13*q23+8*q12^2*q13*q23-8*n2*q12^2*q13*q23-24*M`j'^2*q13^2*q23+24*M`j'^2*n2*q13^2*q23+24*q12*q13^2*q23-24*n2*q12*q13^2*q23+16*q13^3*q23-16*n2*q13^3*q23-8*M`j'^2*q12*q23^2+8*M`j'^2*n2*q12*q23^2+4*q12^2*q23^2-4*n2*q12^2*q23^2-24*M`j'^2*q13*q23^2+24*M`j'^2*n2*q13*q23^2+24*q12*q13*q23^2-24*n2*q12*q13*q23^2+24*q13^2*q23^2-24*n2*q13^2*q23^2-8*M`j'^2*q23^3+8*M`j'^2*n2*q23^3+8*q12*q23^3-8*n2*q12*q23^3+16*q13*q23^3-16*n2*q13*q23^3+4*q23^4-4*n2*q23^4+16*M`j'^2*q12^2*q33-16*M`j'^2*n2*q12^2*q33-8*q12^3*q33+8*n2*q12^3*q33+16*M`j'^2*q12*q13*q33-16*M`j'^2*n2*q12*q13*q33-16*q12^2*q13*q33+16*n2*q12^2*q13*q33-4*M`j'^2*q13^2*q33+4*M`j'^2*n2*q13^2*q33-4*q12*q13^2*q33+4*n2*q12*q13^2*q33+4*q13^3*q33-4*n2*q13^3*q33+16*M`j'^2*q12*q23*q33-16*M`j'^2*n2*q12*q23*q33-16*q12^2*q23*q33+16*n2*q12^2*q23*q33-8*M`j'^2*q13*q23*q33+8*M`j'^2*n2*q13*q23*q33-8*q12*q13*q23*q33+8*n2*q12*q13*q23*q33+12*q13^2*q23*q33-12*n2*q13^2*q23*q33-4*M`j'^2*q23^2*q33+4*M`j'^2*n2*q23^2*q33-4*q12*q23^2*q33+4*n2*q12*q23^2*q33+12*q13*q23^2*q33-12*n2*q13*q23^2*q33+4*q23^3*q33-4*n2*q23^3*q33+8*M`j'^2*q12*q33^2-8*M`j'^2*n2*q12*q33^2-8*q12^2*q33^2+8*n2*q12^2*q33^2-8*q12*q13*q33^2+8*n2*q12*q13*q33^2+q13^2*q33^2-n2*q13^2*q33^2-8*q12*q23*q33^2+8*n2*q12*q23*q33^2+2*q13*q23*q33^2-2*n2*q13*q23*q33^2+q23^2*q33^2-n2*q23^2*q33^2-2*q12*q33^3+2*n2*q12*q33^3)+mbox1l(n1,-1+n2,2+n3,-1+n4)*prf(4*M`j'^2*q12^2*q13+4*M`j'^2*n3*q12^2*q13-2*q12^3*q13-2*n3*q12^3*q13+2*M`j'^2*q12*q13^2+2*M`j'^2*n3*q12*q13^2-2*q12^2*q13^2-2*n3*q12^2*q13^2+4*M`j'^2*q12^2*q23+4*M`j'^2*n3*q12^2*q23-2*q12^3*q23-2*n3*q12^3*q23+8*M`j'^2*q12*q13*q23+8*M`j'^2*n3*q12*q13*q23-6*q12^2*q13*q23-6*n3*q12^2*q13*q23+2*M`j'^2*q13^2*q23+2*M`j'^2*n3*q13^2*q23-2*q12*q13^2*q23-2*n3*q12*q13^2*q23+6*M`j'^2*q12*q23^2+6*M`j'^2*n3*q12*q23^2-4*q12^2*q23^2-4*n3*q12^2*q23^2+4*M`j'^2*q13*q23^2+4*M`j'^2*n3*q13*q23^2-4*q12*q13*q23^2-4*n3*q12*q13*q23^2+2*M`j'^2*q23^3+2*M`j'^2*n3*q23^3-2*q12*q23^3-2*n3*q12*q23^3-2*q12^3*q33-2*n3*q12^3*q33-3*q12^2*q13*q33-3*n3*q12^2*q13*q33-5*q12^2*q23*q33-5*n3*q12^2*q23*q33-3*q12*q13*q23*q33-3*n3*q12*q13*q23*q33-3*q12*q23^2*q33-3*n3*q12*q23^2*q33-q12^2*q33^2-n3*q12^2*q33^2-q12*q23*q33^2-n3*q12*q23*q33^2,-8*M`j'^2*q12*q13^2+8*M`j'^2*n2*q12*q13^2+4*q12^2*q13^2-4*n2*q12^2*q13^2-8*M`j'^2*q13^3+8*M`j'^2*n2*q13^3+8*q12*q13^3-8*n2*q12*q13^3+4*q13^4-4*n2*q13^4-16*M`j'^2*q12*q13*q23+16*M`j'^2*n2*q12*q13*q23+8*q12^2*q13*q23-8*n2*q12^2*q13*q23-24*M`j'^2*q13^2*q23+24*M`j'^2*n2*q13^2*q23+24*q12*q13^2*q23-24*n2*q12*q13^2*q23+16*q13^3*q23-16*n2*q13^3*q23-8*M`j'^2*q12*q23^2+8*M`j'^2*n2*q12*q23^2+4*q12^2*q23^2-4*n2*q12^2*q23^2-24*M`j'^2*q13*q23^2+24*M`j'^2*n2*q13*q23^2+24*q12*q13*q23^2-24*n2*q12*q13*q23^2+24*q13^2*q23^2-24*n2*q13^2*q23^2-8*M`j'^2*q23^3+8*M`j'^2*n2*q23^3+8*q12*q23^3-8*n2*q12*q23^3+16*q13*q23^3-16*n2*q13*q23^3+4*q23^4-4*n2*q23^4+16*M`j'^2*q12^2*q33-16*M`j'^2*n2*q12^2*q33-8*q12^3*q33+8*n2*q12^3*q33+16*M`j'^2*q12*q13*q33-16*M`j'^2*n2*q12*q13*q33-16*q12^2*q13*q33+16*n2*q12^2*q13*q33-4*M`j'^2*q13^2*q33+4*M`j'^2*n2*q13^2*q33-4*q12*q13^2*q33+4*n2*q12*q13^2*q33+4*q13^3*q33-4*n2*q13^3*q33+16*M`j'^2*q12*q23*q33-16*M`j'^2*n2*q12*q23*q33-16*q12^2*q23*q33+16*n2*q12^2*q23*q33-8*M`j'^2*q13*q23*q33+8*M`j'^2*n2*q13*q23*q33-8*q12*q13*q23*q33+8*n2*q12*q13*q23*q33+12*q13^2*q23*q33-12*n2*q13^2*q23*q33-4*M`j'^2*q23^2*q33+4*M`j'^2*n2*q23^2*q33-4*q12*q23^2*q33+4*n2*q12*q23^2*q33+12*q13*q23^2*q33-12*n2*q13*q23^2*q33+4*q23^3*q33-4*n2*q23^3*q33+8*M`j'^2*q12*q33^2-8*M`j'^2*n2*q12*q33^2-8*q12^2*q33^2+8*n2*q12^2*q33^2-8*q12*q13*q33^2+8*n2*q12*q13*q33^2+q13^2*q33^2-n2*q13^2*q33^2-8*q12*q23*q33^2+8*n2*q12*q23*q33^2+2*q13*q23*q33^2-2*n2*q13*q23*q33^2+q23^2*q33^2-n2*q23^2*q33^2-2*q12*q33^3+2*n2*q12*q33^3)+mbox1l(1+n1,-2+n2,1+n3,n4)*prf(2*M`j'^2*n1*q12*q13^2+4*M`j'^2*n1*q12*q13*q23+2*M`j'^2*n1*q13^2*q23+2*M`j'^2*n1*q12*q23^2+4*M`j'^2*n1*q13*q23^2+2*M`j'^2*n1*q23^3-4*M`j'^2*n1*q12^2*q33-4*M`j'^2*n1*q12*q13*q33+2*n1*q12^2*q13*q33+2*n1*q12*q13^2*q33-2*n1*q12^2*q23*q33+4*M`j'^2*n1*q13*q23*q33-2*n1*q12*q13*q23*q33-2*n1*q13^2*q23*q33+4*M`j'^2*n1*q23^2*q33-4*n1*q12*q23^2*q33-4*n1*q13*q23^2*q33-2*n1*q23^3*q33-4*M`j'^2*n1*q12*q33^2+2*n1*q12^2*q33^2+3*n1*q12*q13*q33^2+n1*q12*q23*q33^2-n1*q13*q23*q33^2-n1*q23^2*q33^2+n1*q12*q33^3,-8*M`j'^2*q12*q13^2+8*M`j'^2*n2*q12*q13^2+4*q12^2*q13^2-4*n2*q12^2*q13^2-8*M`j'^2*q13^3+8*M`j'^2*n2*q13^3+8*q12*q13^3-8*n2*q12*q13^3+4*q13^4-4*n2*q13^4-16*M`j'^2*q12*q13*q23+16*M`j'^2*n2*q12*q13*q23+8*q12^2*q13*q23-8*n2*q12^2*q13*q23-24*M`j'^2*q13^2*q23+24*M`j'^2*n2*q13^2*q23+24*q12*q13^2*q23-24*n2*q12*q13^2*q23+16*q13^3*q23-16*n2*q13^3*q23-8*M`j'^2*q12*q23^2+8*M`j'^2*n2*q12*q23^2+4*q12^2*q23^2-4*n2*q12^2*q23^2-24*M`j'^2*q13*q23^2+24*M`j'^2*n2*q13*q23^2+24*q12*q13*q23^2-24*n2*q12*q13*q23^2+24*q13^2*q23^2-24*n2*q13^2*q23^2-8*M`j'^2*q23^3+8*M`j'^2*n2*q23^3+8*q12*q23^3-8*n2*q12*q23^3+16*q13*q23^3-16*n2*q13*q23^3+4*q23^4-4*n2*q23^4+16*M`j'^2*q12^2*q33-16*M`j'^2*n2*q12^2*q33-8*q12^3*q33+8*n2*q12^3*q33+16*M`j'^2*q12*q13*q33-16*M`j'^2*n2*q12*q13*q33-16*q12^2*q13*q33+16*n2*q12^2*q13*q33-4*M`j'^2*q13^2*q33+4*M`j'^2*n2*q13^2*q33-4*q12*q13^2*q33+4*n2*q12*q13^2*q33+4*q13^3*q33-4*n2*q13^3*q33+16*M`j'^2*q12*q23*q33-16*M`j'^2*n2*q12*q23*q33-16*q12^2*q23*q33+16*n2*q12^2*q23*q33-8*M`j'^2*q13*q23*q33+8*M`j'^2*n2*q13*q23*q33-8*q12*q13*q23*q33+8*n2*q12*q13*q23*q33+12*q13^2*q23*q33-12*n2*q13^2*q23*q33-4*M`j'^2*q23^2*q33+4*M`j'^2*n2*q23^2*q33-4*q12*q23^2*q33+4*n2*q12*q23^2*q33+12*q13*q23^2*q33-12*n2*q13*q23^2*q33+4*q23^3*q33-4*n2*q23^3*q33+8*M`j'^2*q12*q33^2-8*M`j'^2*n2*q12*q33^2-8*q12^2*q33^2+8*n2*q12^2*q33^2-8*q12*q13*q33^2+8*n2*q12*q13*q33^2+q13^2*q33^2-n2*q13^2*q33^2-8*q12*q23*q33^2+8*n2*q12*q23*q33^2+2*q13*q23*q33^2-2*n2*q13*q23*q33^2+q23^2*q33^2-n2*q23^2*q33^2-2*q12*q33^3+2*n2*q12*q33^3)+mbox1l(n1,-1+n2,1+n3,n4)*(tmpprf(ep,1)*prf(4*q12^2*q13^2+4*q12*q13^3+8*q12^2*q13*q23+16*q12*q13^2*q23+4*q13^3*q23+4*q12^2*q23^2+20*q12*q13*q23^2+12*q13^2*q23^2+8*q12*q23^3+12*q13*q23^3+4*q23^4-8*q12^3*q33-8*q12^2*q13*q33+2*q12*q13^2*q33-16*q12^2*q23*q33-4*q12*q13*q23*q33+2*q13^2*q23*q33-6*q12*q23^2*q33+4*q13*q23^2*q33+2*q23^3*q33-4*q12^2*q33^2-4*q12*q23*q33^2,-8*M`j'^2*q12*q13^2+8*M`j'^2*n2*q12*q13^2+4*q12^2*q13^2-4*n2*q12^2*q13^2-8*M`j'^2*q13^3+8*M`j'^2*n2*q13^3+8*q12*q13^3-8*n2*q12*q13^3+4*q13^4-4*n2*q13^4-16*M`j'^2*q12*q13*q23+16*M`j'^2*n2*q12*q13*q23+8*q12^2*q13*q23-8*n2*q12^2*q13*q23-24*M`j'^2*q13^2*q23+24*M`j'^2*n2*q13^2*q23+24*q12*q13^2*q23-24*n2*q12*q13^2*q23+16*q13^3*q23-16*n2*q13^3*q23-8*M`j'^2*q12*q23^2+8*M`j'^2*n2*q12*q23^2+4*q12^2*q23^2-4*n2*q12^2*q23^2-24*M`j'^2*q13*q23^2+24*M`j'^2*n2*q13*q23^2+24*q12*q13*q23^2-24*n2*q12*q13*q23^2+24*q13^2*q23^2-24*n2*q13^2*q23^2-8*M`j'^2*q23^3+8*M`j'^2*n2*q23^3+8*q12*q23^3-8*n2*q12*q23^3+16*q13*q23^3-16*n2*q13*q23^3+4*q23^4-4*n2*q23^4+16*M`j'^2*q12^2*q33-16*M`j'^2*n2*q12^2*q33-8*q12^3*q33+8*n2*q12^3*q33+16*M`j'^2*q12*q13*q33-16*M`j'^2*n2*q12*q13*q33-16*q12^2*q13*q33+16*n2*q12^2*q13*q33-4*M`j'^2*q13^2*q33+4*M`j'^2*n2*q13^2*q33-4*q12*q13^2*q33+4*n2*q12*q13^2*q33+4*q13^3*q33-4*n2*q13^3*q33+16*M`j'^2*q12*q23*q33-16*M`j'^2*n2*q12*q23*q33-16*q12^2*q23*q33+16*n2*q12^2*q23*q33-8*M`j'^2*q13*q23*q33+8*M`j'^2*n2*q13*q23*q33-8*q12*q13*q23*q33+8*n2*q12*q13*q23*q33+12*q13^2*q23*q33-12*n2*q13^2*q23*q33-4*M`j'^2*q23^2*q33+4*M`j'^2*n2*q23^2*q33-4*q12*q23^2*q33+4*n2*q12*q23^2*q33+12*q13*q23^2*q33-12*n2*q13*q23^2*q33+4*q23^3*q33-4*n2*q23^3*q33+8*M`j'^2*q12*q33^2-8*M`j'^2*n2*q12*q33^2-8*q12^2*q33^2+8*n2*q12^2*q33^2-8*q12*q13*q33^2+8*n2*q12*q13*q33^2+q13^2*q33^2-n2*q13^2*q33^2-8*q12*q23*q33^2+8*n2*q12*q23*q33^2+2*q13*q23*q33^2-2*n2*q13*q23*q33^2+q23^2*q33^2-n2*q23^2*q33^2-2*q12*q33^3+2*n2*q12*q33^3)+prf(-14*M`j'^2*q12*q13^2+4*M`j'^2*n1*q12*q13^2+6*M`j'^2*n2*q12*q13^2-8*M`j'^2*n3*q12*q13^2-2*M`j'^2*n4*q12*q13^2-2*q12^2*q13^2+6*n3*q12^2*q13^2+4*n4*q12^2*q13^2-16*M`j'^2*q13^3+8*M`j'^2*n2*q13^3-8*M`j'^2*n3*q13^3+6*q12*q13^3-4*n2*q12*q13^3+10*n3*q12*q13^3+4*n4*q12*q13^3+8*q13^4-4*n2*q13^4+4*n3*q13^4-20*M`j'^2*q12*q13*q23+12*M`j'^2*n2*q12*q13*q23-8*M`j'^2*n3*q12*q13*q23-4*M`j'^2*n4*q12*q13*q23-8*q12^2*q13*q23+4*n1*q12^2*q13*q23+8*n3*q12^2*q13*q23+8*n4*q12^2*q13*q23-38*M`j'^2*q13^2*q23-4*M`j'^2*n1*q13^2*q23+22*M`j'^2*n2*q13^2*q23-16*M`j'^2*n3*q13^2*q23-2*M`j'^2*n4*q13^2*q23+8*n1*q12*q13^2*q23-8*n2*q12*q13^2*q23+24*n3*q12*q13^2*q23+16*n4*q12*q13^2*q23+18*q13^3*q23+4*n1*q13^3*q23-12*n2*q13^3*q23+14*n3*q13^3*q23+4*n4*q13^3*q23-6*M`j'^2*q12*q23^2-4*M`j'^2*n1*q12*q23^2+6*M`j'^2*n2*q12*q23^2-2*M`j'^2*n4*q12*q23^2-6*q12^2*q23^2+4*n1*q12^2*q23^2+2*n3*q12^2*q23^2+4*n4*q12^2*q23^2-28*M`j'^2*q13*q23^2-8*M`j'^2*n1*q13*q23^2+20*M`j'^2*n2*q13*q23^2-8*M`j'^2*n3*q13*q23^2-4*M`j'^2*n4*q13*q23^2-18*q12*q13*q23^2+16*n1*q12*q13*q23^2-4*n2*q12*q13*q23^2+18*n3*q12*q13*q23^2+20*n4*q12*q13*q23^2+6*q13^2*q23^2+12*n1*q13^2*q23^2-12*n2*q13^2*q23^2+18*n3*q13^2*q23^2+12*n4*q13^2*q23^2-6*M`j'^2*q23^3-4*M`j'^2*n1*q23^3+6*M`j'^2*n2*q23^3-2*M`j'^2*n4*q23^3-12*q12*q23^3+8*n1*q12*q23^3+4*n3*q12*q23^3+8*n4*q12*q23^3-10*q13*q23^3+12*n1*q13*q23^3-4*n2*q13*q23^3+10*n3*q13*q23^3+12*n4*q13*q23^3-6*q23^4+4*n1*q23^4+2*n3*q23^4+4*n4*q23^4+20*M`j'^2*q12^2*q33-12*M`j'^2*n2*q12^2*q33+8*M`j'^2*n3*q12^2*q33+4*M`j'^2*n4*q12^2*q33+8*q12^3*q33-4*n1*q12^3*q33-8*n3*q12^3*q33-8*n4*q12^3*q33+24*M`j'^2*q12*q13*q33+8*M`j'^2*n1*q12*q13*q33-16*M`j'^2*n2*q12*q13*q33+8*M`j'^2*n3*q12*q13*q33-4*q12^2*q13*q33-8*n1*q12^2*q13*q33+8*n2*q12^2*q13*q33-12*n3*q12^2*q13*q33-8*n4*q12^2*q13*q33-8*M`j'^2*q13^2*q33+4*M`j'^2*n2*q13^2*q33-4*M`j'^2*n3*q13^2*q33-9*q12*q13^2*q33-4*n1*q12*q13^2*q33+6*n2*q12*q13^2*q33+n3*q12*q13^2*q33+2*n4*q12*q13^2*q33+8*q13^3*q33-4*n2*q13^3*q33+4*n3*q13^3*q33+20*M`j'^2*q12*q23*q33-12*M`j'^2*n2*q12*q23*q33+8*M`j'^2*n3*q12*q23*q33+4*M`j'^2*n4*q12*q23*q33+16*q12^2*q23*q33-8*n1*q12^2*q23*q33-16*n3*q12^2*q23*q33-16*n4*q12^2*q23*q33-12*M`j'^2*q13*q23*q33-4*M`j'^2*n1*q13*q23*q33+8*M`j'^2*n2*q13*q23*q33-4*M`j'^2*n3*q13*q23*q33-2*q12*q13*q23*q33-4*n1*q12*q13*q23*q33+4*n2*q12*q13*q23*q33-6*n3*q12*q13*q23*q33-4*n4*q12*q13*q23*q33+15*q13^2*q23*q33+4*n1*q13^2*q23*q33-10*n2*q13^2*q23*q33+9*n3*q13^2*q23*q33+2*n4*q13^2*q23*q33-4*M`j'^2*q23^2*q33-4*M`j'^2*n1*q23^2*q33+4*M`j'^2*n2*q23^2*q33+7*q12*q23^2*q33-2*n2*q12*q23^2*q33-7*n3*q12*q23^2*q33-6*n4*q12*q23^2*q33+6*q13*q23^2*q33+8*n1*q13*q23^2*q33-8*n2*q13*q23^2*q33+6*n3*q13*q23^2*q33+4*n4*q13*q23^2*q33-q23^3*q33+4*n1*q23^3*q33-2*n2*q23^3*q33+n3*q23^3*q33+2*n4*q23^3*q33+12*M`j'^2*q12*q33^2+4*M`j'^2*n1*q12*q33^2-8*M`j'^2*n2*q12*q33^2+4*M`j'^2*n3*q12*q33^2-2*q12^2*q33^2-4*n1*q12^2*q33^2+4*n2*q12^2*q33^2-6*n3*q12^2*q33^2-4*n4*q12^2*q33^2-12*q12*q13*q33^2-4*n1*q12*q13*q33^2+8*n2*q12*q13*q33^2-4*n3*q12*q13*q33^2+2*q13^2*q33^2-n2*q13^2*q33^2+n3*q13^2*q33^2-2*q12*q23*q33^2-4*n1*q12*q23*q33^2+4*n2*q12*q23*q33^2-6*n3*q12*q23*q33^2-4*n4*q12*q23*q33^2+3*q13*q23*q33^2+n1*q13*q23*q33^2-2*n2*q13*q23*q33^2+n3*q13*q23*q33^2+q23^2*q33^2+n1*q23^2*q33^2-n2*q23^2*q33^2-3*q12*q33^3-n1*q12*q33^3+2*n2*q12*q33^3-n3*q12*q33^3,-8*M`j'^2*q12*q13^2+8*M`j'^2*n2*q12*q13^2+4*q12^2*q13^2-4*n2*q12^2*q13^2-8*M`j'^2*q13^3+8*M`j'^2*n2*q13^3+8*q12*q13^3-8*n2*q12*q13^3+4*q13^4-4*n2*q13^4-16*M`j'^2*q12*q13*q23+16*M`j'^2*n2*q12*q13*q23+8*q12^2*q13*q23-8*n2*q12^2*q13*q23-24*M`j'^2*q13^2*q23+24*M`j'^2*n2*q13^2*q23+24*q12*q13^2*q23-24*n2*q12*q13^2*q23+16*q13^3*q23-16*n2*q13^3*q23-8*M`j'^2*q12*q23^2+8*M`j'^2*n2*q12*q23^2+4*q12^2*q23^2-4*n2*q12^2*q23^2-24*M`j'^2*q13*q23^2+24*M`j'^2*n2*q13*q23^2+24*q12*q13*q23^2-24*n2*q12*q13*q23^2+24*q13^2*q23^2-24*n2*q13^2*q23^2-8*M`j'^2*q23^3+8*M`j'^2*n2*q23^3+8*q12*q23^3-8*n2*q12*q23^3+16*q13*q23^3-16*n2*q13*q23^3+4*q23^4-4*n2*q23^4+16*M`j'^2*q12^2*q33-16*M`j'^2*n2*q12^2*q33-8*q12^3*q33+8*n2*q12^3*q33+16*M`j'^2*q12*q13*q33-16*M`j'^2*n2*q12*q13*q33-16*q12^2*q13*q33+16*n2*q12^2*q13*q33-4*M`j'^2*q13^2*q33+4*M`j'^2*n2*q13^2*q33-4*q12*q13^2*q33+4*n2*q12*q13^2*q33+4*q13^3*q33-4*n2*q13^3*q33+16*M`j'^2*q12*q23*q33-16*M`j'^2*n2*q12*q23*q33-16*q12^2*q23*q33+16*n2*q12^2*q23*q33-8*M`j'^2*q13*q23*q33+8*M`j'^2*n2*q13*q23*q33-8*q12*q13*q23*q33+8*n2*q12*q13*q23*q33+12*q13^2*q23*q33-12*n2*q13^2*q23*q33-4*M`j'^2*q23^2*q33+4*M`j'^2*n2*q23^2*q33-4*q12*q23^2*q33+4*n2*q12*q23^2*q33+12*q13*q23^2*q33-12*n2*q13*q23^2*q33+4*q23^3*q33-4*n2*q23^3*q33+8*M`j'^2*q12*q33^2-8*M`j'^2*n2*q12*q33^2-8*q12^2*q33^2+8*n2*q12^2*q33^2-8*q12*q13*q33^2+8*n2*q12*q13*q33^2+q13^2*q33^2-n2*q13^2*q33^2-8*q12*q23*q33^2+8*n2*q12*q23*q33^2+2*q13*q23*q33^2-2*n2*q13*q23*q33^2+q23^2*q33^2-n2*q23^2*q33^2-2*q12*q33^3+2*n2*q12*q33^3))+mbox1l(n1,-2+n2,2+n3,n4)*prf(6*M`j'^2*q12*q13^2+6*M`j'^2*n3*q12*q13^2-2*q12^2*q13^2-2*n3*q12^2*q13^2+8*M`j'^2*q13^3+8*M`j'^2*n3*q13^3-6*q12*q13^3-6*n3*q12*q13^3-4*q13^4-4*n3*q13^4+8*M`j'^2*q12*q13*q23+8*M`j'^2*n3*q12*q13*q23-2*q12^2*q13*q23-2*n3*q12^2*q13*q23+14*M`j'^2*q13^2*q23+14*M`j'^2*n3*q13^2*q23-10*q12*q13^2*q23-10*n3*q12*q13^2*q23-10*q13^3*q23-10*n3*q13^3*q23+2*M`j'^2*q12*q23^2+2*M`j'^2*n3*q12*q23^2+8*M`j'^2*q13*q23^2+8*M`j'^2*n3*q13*q23^2-4*q12*q13*q23^2-4*n3*q12*q13*q23^2-8*q13^2*q23^2-8*n3*q13^2*q23^2+2*M`j'^2*q23^3+2*M`j'^2*n3*q23^3-2*q13*q23^3-2*n3*q13*q23^3-4*M`j'^2*q12^2*q33-4*M`j'^2*n3*q12^2*q33-8*M`j'^2*q12*q13*q33-8*M`j'^2*n3*q12*q13*q33+4*q12^2*q13*q33+4*n3*q12^2*q13*q33+4*M`j'^2*q13^2*q33+4*M`j'^2*n3*q13^2*q33+q12*q13^2*q33+n3*q12*q13^2*q33-4*q13^3*q33-4*n3*q13^3*q33-2*q12^2*q23*q33-2*n3*q12^2*q23*q33+4*M`j'^2*q13*q23*q33+4*M`j'^2*n3*q13*q23*q33-q12*q13*q23*q33-n3*q12*q13*q23*q33-7*q13^2*q23*q33-7*n3*q13^2*q23*q33+4*M`j'^2*q23^2*q33+4*M`j'^2*n3*q23^2*q33-4*q12*q23^2*q33-4*n3*q12*q23^2*q33-5*q13*q23^2*q33-5*n3*q13*q23^2*q33-2*q23^3*q33-2*n3*q23^3*q33-4*M`j'^2*q12*q33^2-4*M`j'^2*n3*q12*q33^2+2*q12^2*q33^2+2*n3*q12^2*q33^2+4*q12*q13*q33^2+4*n3*q12*q13*q33^2-q13^2*q33^2-n3*q13^2*q33^2+q12*q23*q33^2+n3*q12*q23*q33^2-q13*q23*q33^2-n3*q13*q23*q33^2-q23^2*q33^2-n3*q23^2*q33^2+q12*q33^3+n3*q12*q33^3,-8*M`j'^2*q12*q13^2+8*M`j'^2*n2*q12*q13^2+4*q12^2*q13^2-4*n2*q12^2*q13^2-8*M`j'^2*q13^3+8*M`j'^2*n2*q13^3+8*q12*q13^3-8*n2*q12*q13^3+4*q13^4-4*n2*q13^4-16*M`j'^2*q12*q13*q23+16*M`j'^2*n2*q12*q13*q23+8*q12^2*q13*q23-8*n2*q12^2*q13*q23-24*M`j'^2*q13^2*q23+24*M`j'^2*n2*q13^2*q23+24*q12*q13^2*q23-24*n2*q12*q13^2*q23+16*q13^3*q23-16*n2*q13^3*q23-8*M`j'^2*q12*q23^2+8*M`j'^2*n2*q12*q23^2+4*q12^2*q23^2-4*n2*q12^2*q23^2-24*M`j'^2*q13*q23^2+24*M`j'^2*n2*q13*q23^2+24*q12*q13*q23^2-24*n2*q12*q13*q23^2+24*q13^2*q23^2-24*n2*q13^2*q23^2-8*M`j'^2*q23^3+8*M`j'^2*n2*q23^3+8*q12*q23^3-8*n2*q12*q23^3+16*q13*q23^3-16*n2*q13*q23^3+4*q23^4-4*n2*q23^4+16*M`j'^2*q12^2*q33-16*M`j'^2*n2*q12^2*q33-8*q12^3*q33+8*n2*q12^3*q33+16*M`j'^2*q12*q13*q33-16*M`j'^2*n2*q12*q13*q33-16*q12^2*q13*q33+16*n2*q12^2*q13*q33-4*M`j'^2*q13^2*q33+4*M`j'^2*n2*q13^2*q33-4*q12*q13^2*q33+4*n2*q12*q13^2*q33+4*q13^3*q33-4*n2*q13^3*q33+16*M`j'^2*q12*q23*q33-16*M`j'^2*n2*q12*q23*q33-16*q12^2*q23*q33+16*n2*q12^2*q23*q33-8*M`j'^2*q13*q23*q33+8*M`j'^2*n2*q13*q23*q33-8*q12*q13*q23*q33+8*n2*q12*q13*q23*q33+12*q13^2*q23*q33-12*n2*q13^2*q23*q33-4*M`j'^2*q23^2*q33+4*M`j'^2*n2*q23^2*q33-4*q12*q23^2*q33+4*n2*q12*q23^2*q33+12*q13*q23^2*q33-12*n2*q13*q23^2*q33+4*q23^3*q33-4*n2*q23^3*q33+8*M`j'^2*q12*q33^2-8*M`j'^2*n2*q12*q33^2-8*q12^2*q33^2+8*n2*q12^2*q33^2-8*q12*q13*q33^2+8*n2*q12*q13*q33^2+q13^2*q33^2-n2*q13^2*q33^2-8*q12*q23*q33^2+8*n2*q12*q23*q33^2+2*q13*q23*q33^2-2*n2*q13*q23*q33^2+q23^2*q33^2-n2*q23^2*q33^2-2*q12*q33^3+2*n2*q12*q33^3)+mbox1l(1+n1,-1+n2,1+n3,n4)*prf(-4*M`j'^2*n1*q12*q13^3-12*M`j'^2*n1*q12*q13^2*q23-4*M`j'^2*n1*q13^3*q23-12*M`j'^2*n1*q12*q13*q23^2-12*M`j'^2*n1*q13^2*q23^2-4*M`j'^2*n1*q12*q23^3-12*M`j'^2*n1*q13*q23^3-4*M`j'^2*n1*q23^4+4*n1*q12^3*q13*q33-8*M`j'^2*n1*q12*q13^2*q33+8*n1*q12^2*q13^2*q33+4*n1*q12*q13^3*q33+16*M`j'^2*n1*q12^2*q23*q33-4*n1*q12^3*q23*q33+8*M`j'^2*n1*q12*q13*q23*q33+4*n1*q12*q13^2*q23*q33+16*M`j'^2*n1*q12*q23^2*q33-8*n1*q12^2*q23^2*q33-4*n1*q12*q13*q23^2*q33-4*n1*q12*q23^3*q33-4*M`j'^2*n1*q12*q13*q33^2+4*n1*q12^2*q13*q33^2+4*n1*q12*q13^2*q33^2+4*M`j'^2*n1*q12*q23*q33^2-4*n1*q12^2*q23*q33^2-4*n1*q12*q23^2*q33^2+n1*q12*q13*q33^3-n1*q12*q23*q33^3,-8*M`j'^2*q12*q13^2+8*M`j'^2*n2*q12*q13^2+4*q12^2*q13^2-4*n2*q12^2*q13^2-8*M`j'^2*q13^3+8*M`j'^2*n2*q13^3+8*q12*q13^3-8*n2*q12*q13^3+4*q13^4-4*n2*q13^4-16*M`j'^2*q12*q13*q23+16*M`j'^2*n2*q12*q13*q23+8*q12^2*q13*q23-8*n2*q12^2*q13*q23-24*M`j'^2*q13^2*q23+24*M`j'^2*n2*q13^2*q23+24*q12*q13^2*q23-24*n2*q12*q13^2*q23+16*q13^3*q23-16*n2*q13^3*q23-8*M`j'^2*q12*q23^2+8*M`j'^2*n2*q12*q23^2+4*q12^2*q23^2-4*n2*q12^2*q23^2-24*M`j'^2*q13*q23^2+24*M`j'^2*n2*q13*q23^2+24*q12*q13*q23^2-24*n2*q12*q13*q23^2+24*q13^2*q23^2-24*n2*q13^2*q23^2-8*M`j'^2*q23^3+8*M`j'^2*n2*q23^3+8*q12*q23^3-8*n2*q12*q23^3+16*q13*q23^3-16*n2*q13*q23^3+4*q23^4-4*n2*q23^4+16*M`j'^2*q12^2*q33-16*M`j'^2*n2*q12^2*q33-8*q12^3*q33+8*n2*q12^3*q33+16*M`j'^2*q12*q13*q33-16*M`j'^2*n2*q12*q13*q33-16*q12^2*q13*q33+16*n2*q12^2*q13*q33-4*M`j'^2*q13^2*q33+4*M`j'^2*n2*q13^2*q33-4*q12*q13^2*q33+4*n2*q12*q13^2*q33+4*q13^3*q33-4*n2*q13^3*q33+16*M`j'^2*q12*q23*q33-16*M`j'^2*n2*q12*q23*q33-16*q12^2*q23*q33+16*n2*q12^2*q23*q33-8*M`j'^2*q13*q23*q33+8*M`j'^2*n2*q13*q23*q33-8*q12*q13*q23*q33+8*n2*q12*q13*q23*q33+12*q13^2*q23*q33-12*n2*q13^2*q23*q33-4*M`j'^2*q23^2*q33+4*M`j'^2*n2*q23^2*q33-4*q12*q23^2*q33+4*n2*q12*q23^2*q33+12*q13*q23^2*q33-12*n2*q13*q23^2*q33+4*q23^3*q33-4*n2*q23^3*q33+8*M`j'^2*q12*q33^2-8*M`j'^2*n2*q12*q33^2-8*q12^2*q33^2+8*n2*q12^2*q33^2-8*q12*q13*q33^2+8*n2*q12*q13*q33^2+q13^2*q33^2-n2*q13^2*q33^2-8*q12*q23*q33^2+8*n2*q12*q23*q33^2+2*q13*q23*q33^2-2*n2*q13*q23*q33^2+q23^2*q33^2-n2*q23^2*q33^2-2*q12*q33^3+2*n2*q12*q33^3)+mbox1l(n1,-1+n2,2+n3,n4)*prf(4*M`j'^2*q12^2*q13^2+4*M`j'^2*n3*q12^2*q13^2-4*q12^3*q13^2-4*n3*q12^3*q13^2-4*q12^2*q13^3-4*n3*q12^2*q13^3-4*q12^3*q13*q23-4*n3*q12^3*q13*q23-12*q12^2*q13^2*q23-12*n3*q12^2*q13^2*q23-4*q12*q13^3*q23-4*n3*q12*q13^3*q23-4*M`j'^2*q12^2*q23^2-4*M`j'^2*n3*q12^2*q23^2-8*M`j'^2*q12*q13*q23^2-8*M`j'^2*n3*q12*q13*q23^2-8*q12^2*q13*q23^2-8*n3*q12^2*q13*q23^2-4*M`j'^2*q13^2*q23^2-4*M`j'^2*n3*q13^2*q23^2-8*q12*q13^2*q23^2-8*n3*q12*q13^2*q23^2-8*M`j'^2*q12*q23^3-8*M`j'^2*n3*q12*q23^3-8*M`j'^2*q13*q23^3-8*M`j'^2*n3*q13*q23^3-4*q12*q13*q23^3-4*n3*q12*q13*q23^3-4*M`j'^2*q23^4-4*M`j'^2*n3*q23^4+8*M`j'^2*q12^3*q33+8*M`j'^2*n3*q12^3*q33+12*M`j'^2*q12^2*q13*q33+12*M`j'^2*n3*q12^2*q13*q33-6*q12^3*q13*q33-6*n3*q12^3*q13*q33-8*q12^2*q13^2*q33-8*n3*q12^2*q13^2*q33+20*M`j'^2*q12^2*q23*q33+20*M`j'^2*n3*q12^2*q23*q33-2*q12^3*q23*q33-2*n3*q12^3*q23*q33+12*M`j'^2*q12*q13*q23*q33+12*M`j'^2*n3*q12*q13*q23*q33-16*q12^2*q13*q23*q33-16*n3*q12^2*q13*q23*q33-8*q12*q13^2*q23*q33-8*n3*q12*q13^2*q23*q33+12*M`j'^2*q12*q23^2*q33+12*M`j'^2*n3*q12*q23^2*q33-4*q12^2*q23^2*q33-4*n3*q12^2*q23^2*q33-10*q12*q13*q23^2*q33-10*n3*q12*q13*q23^2*q33-2*q12*q23^3*q33-2*n3*q12*q23^3*q33+4*M`j'^2*q12^2*q33^2+4*M`j'^2*n3*q12^2*q33^2-2*q12^3*q33^2-2*n3*q12^3*q33^2-5*q12^2*q13*q33^2-5*n3*q12^2*q13*q33^2+4*M`j'^2*q12*q23*q33^2+4*M`j'^2*n3*q12*q23*q33^2-5*q12^2*q23*q33^2-5*n3*q12^2*q23*q33^2-5*q12*q13*q23*q33^2-5*n3*q12*q13*q23*q33^2-3*q12*q23^2*q33^2-3*n3*q12*q23^2*q33^2-q12^2*q33^3-n3*q12^2*q33^3-q12*q23*q33^3-n3*q12*q23*q33^3,-8*M`j'^2*q12*q13^2+8*M`j'^2*n2*q12*q13^2+4*q12^2*q13^2-4*n2*q12^2*q13^2-8*M`j'^2*q13^3+8*M`j'^2*n2*q13^3+8*q12*q13^3-8*n2*q12*q13^3+4*q13^4-4*n2*q13^4-16*M`j'^2*q12*q13*q23+16*M`j'^2*n2*q12*q13*q23+8*q12^2*q13*q23-8*n2*q12^2*q13*q23-24*M`j'^2*q13^2*q23+24*M`j'^2*n2*q13^2*q23+24*q12*q13^2*q23-24*n2*q12*q13^2*q23+16*q13^3*q23-16*n2*q13^3*q23-8*M`j'^2*q12*q23^2+8*M`j'^2*n2*q12*q23^2+4*q12^2*q23^2-4*n2*q12^2*q23^2-24*M`j'^2*q13*q23^2+24*M`j'^2*n2*q13*q23^2+24*q12*q13*q23^2-24*n2*q12*q13*q23^2+24*q13^2*q23^2-24*n2*q13^2*q23^2-8*M`j'^2*q23^3+8*M`j'^2*n2*q23^3+8*q12*q23^3-8*n2*q12*q23^3+16*q13*q23^3-16*n2*q13*q23^3+4*q23^4-4*n2*q23^4+16*M`j'^2*q12^2*q33-16*M`j'^2*n2*q12^2*q33-8*q12^3*q33+8*n2*q12^3*q33+16*M`j'^2*q12*q13*q33-16*M`j'^2*n2*q12*q13*q33-16*q12^2*q13*q33+16*n2*q12^2*q13*q33-4*M`j'^2*q13^2*q33+4*M`j'^2*n2*q13^2*q33-4*q12*q13^2*q33+4*n2*q12*q13^2*q33+4*q13^3*q33-4*n2*q13^3*q33+16*M`j'^2*q12*q23*q33-16*M`j'^2*n2*q12*q23*q33-16*q12^2*q23*q33+16*n2*q12^2*q23*q33-8*M`j'^2*q13*q23*q33+8*M`j'^2*n2*q13*q23*q33-8*q12*q13*q23*q33+8*n2*q12*q13*q23*q33+12*q13^2*q23*q33-12*n2*q13^2*q23*q33-4*M`j'^2*q23^2*q33+4*M`j'^2*n2*q23^2*q33-4*q12*q23^2*q33+4*n2*q12*q23^2*q33+12*q13*q23^2*q33-12*n2*q13*q23^2*q33+4*q23^3*q33-4*n2*q23^3*q33+8*M`j'^2*q12*q33^2-8*M`j'^2*n2*q12*q33^2-8*q12^2*q33^2+8*n2*q12^2*q33^2-8*q12*q13*q33^2+8*n2*q12*q13*q33^2+q13^2*q33^2-n2*q13^2*q33^2-8*q12*q23*q33^2+8*n2*q12*q23*q33^2+2*q13*q23*q33^2-2*n2*q13*q23*q33^2+q23^2*q33^2-n2*q23^2*q33^2-2*q12*q33^3+2*n2*q12*q33^3);
	Identify,ifmatch->jump mbox1l(n1?neg_,n2?{,>1},n3?neg0_,n4?pos_) = mbox1l(2+n1,-1+n2,n3,-1+n4)*prf(2*M`j'^2*q13+2*M`j'^2*n1*q13+2*M`j'^2*q23+2*M`j'^2*n1*q23,-8*M`j'^2*q12+8*M`j'^2*n2*q12+4*q12^2-4*n2*q12^2-8*M`j'^2*q13+8*M`j'^2*n2*q13+8*q12*q13-8*n2*q12*q13+4*q13^2-4*n2*q13^2-8*M`j'^2*q23+8*M`j'^2*n2*q23+8*q12*q23-8*n2*q12*q23+8*q13*q23-8*n2*q13*q23+4*q23^2-4*n2*q23^2-4*M`j'^2*q33+4*M`j'^2*n2*q33+4*q12*q33-4*n2*q12*q33+4*q13*q33-4*n2*q13*q33+4*q23*q33-4*n2*q23*q33+q33^2-n2*q33^2)+mbox1l(1+n1,-2+n2,n3,1+n4)*prf(2*M`j'^2*n4*q13+2*M`j'^2*n4*q23,-8*M`j'^2*q12+8*M`j'^2*n2*q12+4*q12^2-4*n2*q12^2-8*M`j'^2*q13+8*M`j'^2*n2*q13+8*q12*q13-8*n2*q12*q13+4*q13^2-4*n2*q13^2-8*M`j'^2*q23+8*M`j'^2*n2*q23+8*q12*q23-8*n2*q12*q23+8*q13*q23-8*n2*q13*q23+4*q23^2-4*n2*q23^2-4*M`j'^2*q33+4*M`j'^2*n2*q33+4*q12*q33-4*n2*q12*q33+4*q13*q33-4*n2*q13*q33+4*q23*q33-4*n2*q23*q33+q33^2-n2*q33^2)+mbox1l(n1,-1+n2,1+n3,n4)*prf(-(n3*q12)-2*n3*q13-n3*q23-n3*q33,-2*q12+2*n2*q12-2*q13+2*n2*q13-2*q23+2*n2*q23-q33+n2*q33)+mbox1l(1+n1,n2,n3,-1+n4)*prf(-8*M`j'^2*q12+4*q12^2-2*M`j'^2*q13+4*q12*q13-2*M`j'^2*q23+4*q12*q23+2*q12*q33,-8*M`j'^2*q12+4*q12^2-8*M`j'^2*q13+8*q12*q13+4*q13^2-8*M`j'^2*q23+8*q12*q23+8*q13*q23+4*q23^2-4*M`j'^2*q33+4*q12*q33+4*q13*q33+4*q23*q33+q33^2)+mbox1l(1+n1,-1+n2,1+n3,-1+n4)*prf(-4*M`j'^2*n3*q12+2*n3*q12^2-2*M`j'^2*n3*q13+2*n3*q12*q13-2*M`j'^2*n3*q23+2*n3*q12*q23+n3*q12*q33,8*M`j'^2*q12-8*M`j'^2*n2*q12-4*q12^2+4*n2*q12^2+8*M`j'^2*q13-8*M`j'^2*n2*q13-8*q12*q13+8*n2*q12*q13-4*q13^2+4*n2*q13^2+8*M`j'^2*q23-8*M`j'^2*n2*q23-8*q12*q23+8*n2*q12*q23-8*q13*q23+8*n2*q13*q23-4*q23^2+4*n2*q23^2+4*M`j'^2*q33-4*M`j'^2*n2*q33-4*q12*q33+4*n2*q12*q33-4*q13*q33+4*n2*q13*q33-4*q23*q33+4*n2*q23*q33-q33^2+n2*q33^2)+mbox1l(2+n1,-2+n2,n3,n4)*prf(-2*M`j'^2*q13-2*M`j'^2*n1*q13-2*M`j'^2*q23-2*M`j'^2*n1*q23-4*M`j'^2*q33-4*M`j'^2*n1*q33+2*q12*q33+2*n1*q12*q33+2*q13*q33+2*n1*q13*q33+2*q23*q33+2*n1*q23*q33+q33^2+n1*q33^2,8*M`j'^2*q12-8*M`j'^2*n2*q12-4*q12^2+4*n2*q12^2+8*M`j'^2*q13-8*M`j'^2*n2*q13-8*q12*q13+8*n2*q12*q13-4*q13^2+4*n2*q13^2+8*M`j'^2*q23-8*M`j'^2*n2*q23-8*q12*q23+8*n2*q12*q23-8*q13*q23+8*n2*q13*q23-4*q23^2+4*n2*q23^2+4*M`j'^2*q33-4*M`j'^2*n2*q33-4*q12*q33+4*n2*q12*q33-4*q13*q33+4*n2*q13*q33-4*q23*q33+4*n2*q23*q33-q33^2+n2*q33^2)+mbox1l(1+n1,-1+n2,n3,n4)*(tmpprf(ep,1)*prf(-4*q12*q13-4*q13^2-4*q12*q23-8*q13*q23-4*q23^2-2*q13*q33-2*q23*q33,8*M`j'^2*q12-8*M`j'^2*n2*q12-4*q12^2+4*n2*q12^2+8*M`j'^2*q13-8*M`j'^2*n2*q13-8*q12*q13+8*n2*q12*q13-4*q13^2+4*n2*q13^2+8*M`j'^2*q23-8*M`j'^2*n2*q23-8*q12*q23+8*n2*q12*q23-8*q13*q23+8*n2*q13*q23-4*q23^2+4*n2*q23^2+4*M`j'^2*q33-4*M`j'^2*n2*q33-4*q12*q33+4*n2*q12*q33-4*q13*q33+4*n2*q13*q33-4*q23*q33+4*n2*q23*q33-q33^2+n2*q33^2)+prf(10*M`j'^2*q13+4*M`j'^2*n1*q13-6*M`j'^2*n2*q13+2*M`j'^2*n4*q13+4*q12*q13-4*n1*q12*q13-2*n3*q12*q13-4*n4*q12*q13+4*q13^2-4*n1*q13^2-2*n3*q13^2-4*n4*q13^2+10*M`j'^2*q23+4*M`j'^2*n1*q23-6*M`j'^2*n2*q23+2*M`j'^2*n4*q23+4*q12*q23-4*n1*q12*q23-2*n3*q12*q23-4*n4*q12*q23+8*q13*q23-8*n1*q13*q23-4*n3*q13*q23-8*n4*q13*q23+4*q23^2-4*n1*q23^2-2*n3*q23^2-4*n4*q23^2+8*M`j'^2*q33+4*M`j'^2*n1*q33-4*M`j'^2*n2*q33-4*q12*q33-2*n1*q12*q33+2*n2*q12*q33-2*q13*q33-4*n1*q13*q33+2*n2*q13*q33-n3*q13*q33-2*n4*q13*q33-2*q23*q33-4*n1*q23*q33+2*n2*q23*q33-n3*q23*q33-2*n4*q23*q33-2*q33^2-n1*q33^2+n2*q33^2,8*M`j'^2*q12-8*M`j'^2*n2*q12-4*q12^2+4*n2*q12^2+8*M`j'^2*q13-8*M`j'^2*n2*q13-8*q12*q13+8*n2*q12*q13-4*q13^2+4*n2*q13^2+8*M`j'^2*q23-8*M`j'^2*n2*q23-8*q12*q23+8*n2*q12*q23-8*q13*q23+8*n2*q13*q23-4*q23^2+4*n2*q23^2+4*M`j'^2*q33-4*M`j'^2*n2*q33-4*q12*q33+4*n2*q12*q33-4*q13*q33+4*n2*q13*q33-4*q23*q33+4*n2*q23*q33-q33^2+n2*q33^2))+mbox1l(1+n1,-2+n2,1+n3,n4)*prf(-6*M`j'^2*n3*q13+2*n3*q12*q13+2*n3*q13^2-2*M`j'^2*n3*q23+2*n3*q13*q23-4*M`j'^2*n3*q33+2*n3*q12*q33+3*n3*q13*q33+2*n3*q23*q33+n3*q33^2,8*M`j'^2*q12-8*M`j'^2*n2*q12-4*q12^2+4*n2*q12^2+8*M`j'^2*q13-8*M`j'^2*n2*q13-8*q12*q13+8*n2*q12*q13-4*q13^2+4*n2*q13^2+8*M`j'^2*q23-8*M`j'^2*n2*q23-8*q12*q23+8*n2*q12*q23-8*q13*q23+8*n2*q13*q23-4*q23^2+4*n2*q23^2+4*M`j'^2*q33-4*M`j'^2*n2*q33-4*q12*q33+4*n2*q12*q33-4*q13*q33+4*n2*q13*q33-4*q23*q33+4*n2*q23*q33-q33^2+n2*q33^2)+mbox1l(2+n1,-1+n2,n3,n4)*prf(4*M`j'^2*q13^2+4*M`j'^2*n1*q13^2+8*M`j'^2*q13*q23+8*M`j'^2*n1*q13*q23+4*M`j'^2*q23^2+4*M`j'^2*n1*q23^2-8*M`j'^2*q12*q33-8*M`j'^2*n1*q12*q33+4*q12^2*q33+4*n1*q12^2*q33+4*q12*q13*q33+4*n1*q12*q13*q33+4*q12*q23*q33+4*n1*q12*q23*q33+2*q12*q33^2+2*n1*q12*q33^2,8*M`j'^2*q12-8*M`j'^2*n2*q12-4*q12^2+4*n2*q12^2+8*M`j'^2*q13-8*M`j'^2*n2*q13-8*q12*q13+8*n2*q12*q13-4*q13^2+4*n2*q13^2+8*M`j'^2*q23-8*M`j'^2*n2*q23-8*q12*q23+8*n2*q12*q23-8*q13*q23+8*n2*q13*q23-4*q23^2+4*n2*q23^2+4*M`j'^2*q33-4*M`j'^2*n2*q33-4*q12*q33+4*n2*q12*q33-4*q13*q33+4*n2*q13*q33-4*q23*q33+4*n2*q23*q33-q33^2+n2*q33^2)+mbox1l(1+n1,-1+n2,1+n3,n4)*prf(-4*M`j'^2*n3*q12*q13+4*n3*q12^2*q13+4*n3*q12*q13^2+4*M`j'^2*n3*q12*q23+4*M`j'^2*n3*q13*q23+4*n3*q12*q13*q23+4*M`j'^2*n3*q23^2-4*M`j'^2*n3*q12*q33+2*n3*q12^2*q33+4*n3*q12*q13*q33+2*n3*q12*q23*q33+n3*q12*q33^2,8*M`j'^2*q12-8*M`j'^2*n2*q12-4*q12^2+4*n2*q12^2+8*M`j'^2*q13-8*M`j'^2*n2*q13-8*q12*q13+8*n2*q12*q13-4*q13^2+4*n2*q13^2+8*M`j'^2*q23-8*M`j'^2*n2*q23-8*q12*q23+8*n2*q12*q23-8*q13*q23+8*n2*q13*q23-4*q23^2+4*n2*q23^2+4*M`j'^2*q33-4*M`j'^2*n2*q33-4*q12*q33+4*n2*q12*q33-4*q13*q33+4*n2*q13*q33-4*q23*q33+4*n2*q23*q33-q33^2+n2*q33^2);
	Identify,ifmatch->jump mbox1l(n1?neg0_,n2?pos_,n3?neg0_,n4?{,>1}) = mbox1l(1+n1,n2,n3,-2+n4)*prf(2*M`j'^2*n1,-8*M`j'^2*q12+8*M`j'^2*n4*q12+4*q12^2-4*n4*q12^2-8*M`j'^2*q13+8*M`j'^2*n4*q13+8*q12*q13-8*n4*q12*q13+4*q13^2-4*n4*q13^2-8*M`j'^2*q23+8*M`j'^2*n4*q23+8*q12*q23-8*n4*q12*q23+8*q13*q23-8*n4*q13*q23+4*q23^2-4*n4*q23^2-4*M`j'^2*q33+4*M`j'^2*n4*q33+4*q12*q33-4*n4*q12*q33+4*q13*q33-4*n4*q13*q33+4*q23*q33-4*n4*q23*q33+q33^2-n4*q33^2)+mbox1l(n1,1+n2,n3,-2+n4)*prf(2*M`j'^2*n2,-8*M`j'^2*q12+8*M`j'^2*n4*q12+4*q12^2-4*n4*q12^2-8*M`j'^2*q13+8*M`j'^2*n4*q13+8*q12*q13-8*n4*q12*q13+4*q13^2-4*n4*q13^2-8*M`j'^2*q23+8*M`j'^2*n4*q23+8*q12*q23-8*n4*q12*q23+8*q13*q23-8*n4*q13*q23+4*q23^2-4*n4*q23^2-4*M`j'^2*q33+4*M`j'^2*n4*q33+4*q12*q33-4*n4*q12*q33+4*q13*q33-4*n4*q13*q33+4*q23*q33-4*n4*q23*q33+q33^2-n4*q33^2)+mbox1l(n1,n2,1+n3,-2+n4)*prf(2*M`j'^2*n3,-8*M`j'^2*q12+8*M`j'^2*n4*q12+4*q12^2-4*n4*q12^2-8*M`j'^2*q13+8*M`j'^2*n4*q13+8*q12*q13-8*n4*q12*q13+4*q13^2-4*n4*q13^2-8*M`j'^2*q23+8*M`j'^2*n4*q23+8*q12*q23-8*n4*q12*q23+8*q13*q23-8*n4*q13*q23+4*q23^2-4*n4*q23^2-4*M`j'^2*q33+4*M`j'^2*n4*q33+4*q12*q33-4*n4*q12*q33+4*q13*q33-4*n4*q13*q33+4*q23*q33-4*n4*q23*q33+q33^2-n4*q33^2)+mbox1l(n1,n2,1+n3,-1+n4)*prf(-4*M`j'^2*n3*q12-4*M`j'^2*n3*q23,-8*M`j'^2*q12+8*M`j'^2*n4*q12+4*q12^2-4*n4*q12^2-8*M`j'^2*q13+8*M`j'^2*n4*q13+8*q12*q13-8*n4*q12*q13+4*q13^2-4*n4*q13^2-8*M`j'^2*q23+8*M`j'^2*n4*q23+8*q12*q23-8*n4*q12*q23+8*q13*q23-8*n4*q13*q23+4*q23^2-4*n4*q23^2-4*M`j'^2*q33+4*M`j'^2*n4*q33+4*q12*q33-4*n4*q12*q33+4*q13*q33-4*n4*q13*q33+4*q23*q33-4*n4*q23*q33+q33^2-n4*q33^2)+mbox1l(n1,-1+n2,n3,n4)*prf(-2*M`j'^2+2*q12+2*q13+2*q23+q33,8*M`j'^2*q12-4*q12^2+8*M`j'^2*q13-8*q12*q13-4*q13^2+8*M`j'^2*q23-8*q12*q23-8*q13*q23-4*q23^2+4*M`j'^2*q33-4*q12*q33-4*q13*q33-4*q23*q33-q33^2)+mbox1l(1+n1,-1+n2,n3,-1+n4)*prf(-2*M`j'^2*n1+2*n1*q12+2*n1*q13+2*n1*q23+n1*q33,-8*M`j'^2*q12+8*M`j'^2*n4*q12+4*q12^2-4*n4*q12^2-8*M`j'^2*q13+8*M`j'^2*n4*q13+8*q12*q13-8*n4*q12*q13+4*q13^2-4*n4*q13^2-8*M`j'^2*q23+8*M`j'^2*n4*q23+8*q12*q23-8*n4*q12*q23+8*q13*q23-8*n4*q13*q23+4*q23^2-4*n4*q23^2-4*M`j'^2*q33+4*M`j'^2*n4*q33+4*q12*q33-4*n4*q12*q33+4*q13*q33-4*n4*q13*q33+4*q23*q33-4*n4*q23*q33+q33^2-n4*q33^2)+mbox1l(n1,-1+n2,1+n3,-1+n4)*prf(-2*M`j'^2*n3+2*n3*q12+2*n3*q13+2*n3*q23+n3*q33,-8*M`j'^2*q12+8*M`j'^2*n4*q12+4*q12^2-4*n4*q12^2-8*M`j'^2*q13+8*M`j'^2*n4*q13+8*q12*q13-8*n4*q12*q13+4*q13^2-4*n4*q13^2-8*M`j'^2*q23+8*M`j'^2*n4*q23+8*q12*q23-8*n4*q12*q23+8*q13*q23-8*n4*q13*q23+4*q23^2-4*n4*q23^2-4*M`j'^2*q33+4*M`j'^2*n4*q33+4*q12*q33-4*n4*q12*q33+4*q13*q33-4*n4*q13*q33+4*q23*q33-4*n4*q23*q33+q33^2-n4*q33^2)+mbox1l(n1,n2,n3,-1+n4)*(tmpprf(ep,1)*prf(4*q12+4*q13+4*q23+2*q33,-8*M`j'^2*q12+8*M`j'^2*n4*q12+4*q12^2-4*n4*q12^2-8*M`j'^2*q13+8*M`j'^2*n4*q13+8*q12*q13-8*n4*q12*q13+4*q13^2-4*n4*q13^2-8*M`j'^2*q23+8*M`j'^2*n4*q23+8*q12*q23-8*n4*q12*q23+8*q13*q23-8*n4*q13*q23+4*q23^2-4*n4*q23^2-4*M`j'^2*q33+4*M`j'^2*n4*q33+4*q12*q33-4*n4*q12*q33+4*q13*q33-4*n4*q13*q33+4*q23*q33-4*n4*q23*q33+q33^2-n4*q33^2)+prf(-2*M`j'^2-2*M`j'^2*n2+2*M`j'^2*n4-10*q12+2*n1*q12+4*n2*q12+2*n3*q12+2*n4*q12-10*q13+2*n1*q13+4*n2*q13+2*n3*q13+2*n4*q13-10*q23+2*n1*q23+4*n2*q23+2*n3*q23+2*n4*q23-5*q33+n1*q33+2*n2*q33+n3*q33+n4*q33,-8*M`j'^2*q12+8*M`j'^2*n4*q12+4*q12^2-4*n4*q12^2-8*M`j'^2*q13+8*M`j'^2*n4*q13+8*q12*q13-8*n4*q12*q13+4*q13^2-4*n4*q13^2-8*M`j'^2*q23+8*M`j'^2*n4*q23+8*q12*q23-8*n4*q12*q23+8*q13*q23-8*n4*q13*q23+4*q23^2-4*n4*q23^2-4*M`j'^2*q33+4*M`j'^2*n4*q33+4*q12*q33-4*n4*q12*q33+4*q13*q33-4*n4*q13*q33+4*q23*q33-4*n4*q23*q33+q33^2-n4*q33^2))+mbox1l(1+n1,n2,n3,-1+n4)*prf(-8*M`j'^2*n1*q12+4*n1*q12^2-4*M`j'^2*n1*q13+4*n1*q12*q13-4*M`j'^2*n1*q23+4*n1*q12*q23+2*n1*q12*q33,-8*M`j'^2*q12+8*M`j'^2*n4*q12+4*q12^2-4*n4*q12^2-8*M`j'^2*q13+8*M`j'^2*n4*q13+8*q12*q13-8*n4*q12*q13+4*q13^2-4*n4*q13^2-8*M`j'^2*q23+8*M`j'^2*n4*q23+8*q12*q23-8*n4*q12*q23+8*q13*q23-8*n4*q13*q23+4*q23^2-4*n4*q23^2-4*M`j'^2*q33+4*M`j'^2*n4*q33+4*q12*q33-4*n4*q12*q33+4*q13*q33-4*n4*q13*q33+4*q23*q33-4*n4*q23*q33+q33^2-n4*q33^2);
	Identify,ifmatch->jump mbox1l(n1?neg0_,n2?{,>1},n3?neg0_,n4?pos_) = mbox1l(1+n1,-2+n2,n3,n4)*prf(2*M`j'^2*n1,-8*M`j'^2*q12+8*M`j'^2*n2*q12+4*q12^2-4*n2*q12^2-8*M`j'^2*q13+8*M`j'^2*n2*q13+8*q12*q13-8*n2*q12*q13+4*q13^2-4*n2*q13^2-8*M`j'^2*q23+8*M`j'^2*n2*q23+8*q12*q23-8*n2*q12*q23+8*q13*q23-8*n2*q13*q23+4*q23^2-4*n2*q23^2-4*M`j'^2*q33+4*M`j'^2*n2*q33+4*q12*q33-4*n2*q12*q33+4*q13*q33-4*n2*q13*q33+4*q23*q33-4*n2*q23*q33+q33^2-n2*q33^2)+mbox1l(n1,-2+n2,1+n3,n4)*prf(2*M`j'^2*n3,-8*M`j'^2*q12+8*M`j'^2*n2*q12+4*q12^2-4*n2*q12^2-8*M`j'^2*q13+8*M`j'^2*n2*q13+8*q12*q13-8*n2*q12*q13+4*q13^2-4*n2*q13^2-8*M`j'^2*q23+8*M`j'^2*n2*q23+8*q12*q23-8*n2*q12*q23+8*q13*q23-8*n2*q13*q23+4*q23^2-4*n2*q23^2-4*M`j'^2*q33+4*M`j'^2*n2*q33+4*q12*q33-4*n2*q12*q33+4*q13*q33-4*n2*q13*q33+4*q23*q33-4*n2*q23*q33+q33^2-n2*q33^2)+mbox1l(n1,-2+n2,n3,1+n4)*prf(2*M`j'^2*n4,-8*M`j'^2*q12+8*M`j'^2*n2*q12+4*q12^2-4*n2*q12^2-8*M`j'^2*q13+8*M`j'^2*n2*q13+8*q12*q13-8*n2*q12*q13+4*q13^2-4*n2*q13^2-8*M`j'^2*q23+8*M`j'^2*n2*q23+8*q12*q23-8*n2*q12*q23+8*q13*q23-8*n2*q13*q23+4*q23^2-4*n2*q23^2-4*M`j'^2*q33+4*M`j'^2*n2*q33+4*q12*q33-4*n2*q12*q33+4*q13*q33-4*n2*q13*q33+4*q23*q33-4*n2*q23*q33+q33^2-n2*q33^2)+mbox1l(n1,n2,n3,-1+n4)*prf(-2*M`j'^2+2*q12+2*q13+2*q23+q33,8*M`j'^2*q12-4*q12^2+8*M`j'^2*q13-8*q12*q13-4*q13^2+8*M`j'^2*q23-8*q12*q23-8*q13*q23-4*q23^2+4*M`j'^2*q33-4*q12*q33-4*q13*q33-4*q23*q33-q33^2)+mbox1l(1+n1,-1+n2,n3,-1+n4)*prf(-2*M`j'^2*n1+2*n1*q12+2*n1*q13+2*n1*q23+n1*q33,-8*M`j'^2*q12+8*M`j'^2*n2*q12+4*q12^2-4*n2*q12^2-8*M`j'^2*q13+8*M`j'^2*n2*q13+8*q12*q13-8*n2*q12*q13+4*q13^2-4*n2*q13^2-8*M`j'^2*q23+8*M`j'^2*n2*q23+8*q12*q23-8*n2*q12*q23+8*q13*q23-8*n2*q13*q23+4*q23^2-4*n2*q23^2-4*M`j'^2*q33+4*M`j'^2*n2*q33+4*q12*q33-4*n2*q12*q33+4*q13*q33-4*n2*q13*q33+4*q23*q33-4*n2*q23*q33+q33^2-n2*q33^2)+mbox1l(n1,-1+n2,1+n3,-1+n4)*prf(-2*M`j'^2*n3+2*n3*q12+2*n3*q13+2*n3*q23+n3*q33,-8*M`j'^2*q12+8*M`j'^2*n2*q12+4*q12^2-4*n2*q12^2-8*M`j'^2*q13+8*M`j'^2*n2*q13+8*q12*q13-8*n2*q12*q13+4*q13^2-4*n2*q13^2-8*M`j'^2*q23+8*M`j'^2*n2*q23+8*q12*q23-8*n2*q12*q23+8*q13*q23-8*n2*q13*q23+4*q23^2-4*n2*q23^2-4*M`j'^2*q33+4*M`j'^2*n2*q33+4*q12*q33-4*n2*q12*q33+4*q13*q33-4*n2*q13*q33+4*q23*q33-4*n2*q23*q33+q33^2-n2*q33^2)+mbox1l(n1,-1+n2,n3,n4)*(tmpprf(ep,1)*prf(4*q12+4*q13+4*q23+2*q33,-8*M`j'^2*q12+8*M`j'^2*n2*q12+4*q12^2-4*n2*q12^2-8*M`j'^2*q13+8*M`j'^2*n2*q13+8*q12*q13-8*n2*q12*q13+4*q13^2-4*n2*q13^2-8*M`j'^2*q23+8*M`j'^2*n2*q23+8*q12*q23-8*n2*q12*q23+8*q13*q23-8*n2*q13*q23+4*q23^2-4*n2*q23^2-4*M`j'^2*q33+4*M`j'^2*n2*q33+4*q12*q33-4*n2*q12*q33+4*q13*q33-4*n2*q13*q33+4*q23*q33-4*n2*q23*q33+q33^2-n2*q33^2)+prf(-2*M`j'^2+2*M`j'^2*n2-2*M`j'^2*n4-10*q12+2*n1*q12+2*n2*q12+2*n3*q12+4*n4*q12-10*q13+2*n1*q13+2*n2*q13+2*n3*q13+4*n4*q13-10*q23+2*n1*q23+2*n2*q23+2*n3*q23+4*n4*q23-5*q33+n1*q33+n2*q33+n3*q33+2*n4*q33,-8*M`j'^2*q12+8*M`j'^2*n2*q12+4*q12^2-4*n2*q12^2-8*M`j'^2*q13+8*M`j'^2*n2*q13+8*q12*q13-8*n2*q12*q13+4*q13^2-4*n2*q13^2-8*M`j'^2*q23+8*M`j'^2*n2*q23+8*q12*q23-8*n2*q12*q23+8*q13*q23-8*n2*q13*q23+4*q23^2-4*n2*q23^2-4*M`j'^2*q33+4*M`j'^2*n2*q33+4*q12*q33-4*n2*q12*q33+4*q13*q33-4*n2*q13*q33+4*q23*q33-4*n2*q23*q33+q33^2-n2*q33^2))+mbox1l(1+n1,-1+n2,n3,n4)*prf(-4*M`j'^2*n1*q13-4*M`j'^2*n1*q23-4*M`j'^2*n1*q33+2*n1*q12*q33+2*n1*q13*q33+2*n1*q23*q33+n1*q33^2,-8*M`j'^2*q12+8*M`j'^2*n2*q12+4*q12^2-4*n2*q12^2-8*M`j'^2*q13+8*M`j'^2*n2*q13+8*q12*q13-8*n2*q12*q13+4*q13^2-4*n2*q13^2-8*M`j'^2*q23+8*M`j'^2*n2*q23+8*q12*q23-8*n2*q12*q23+8*q13*q23-8*n2*q13*q23+4*q23^2-4*n2*q23^2-4*M`j'^2*q33+4*M`j'^2*n2*q33+4*q12*q33-4*n2*q12*q33+4*q13*q33-4*n2*q13*q33+4*q23*q33-4*n2*q23*q33+q33^2-n2*q33^2)+mbox1l(n1,-1+n2,1+n3,n4)*prf(-4*M`j'^2*n3*q12-8*M`j'^2*n3*q13+4*n3*q12*q13+4*n3*q13^2-4*M`j'^2*n3*q23+4*n3*q13*q23-4*M`j'^2*n3*q33+2*n3*q12*q33+4*n3*q13*q33+2*n3*q23*q33+n3*q33^2,-8*M`j'^2*q12+8*M`j'^2*n2*q12+4*q12^2-4*n2*q12^2-8*M`j'^2*q13+8*M`j'^2*n2*q13+8*q12*q13-8*n2*q12*q13+4*q13^2-4*n2*q13^2-8*M`j'^2*q23+8*M`j'^2*n2*q23+8*q12*q23-8*n2*q12*q23+8*q13*q23-8*n2*q13*q23+4*q23^2-4*n2*q23^2-4*M`j'^2*q33+4*M`j'^2*n2*q33+4*q12*q33-4*n2*q12*q33+4*q13*q33-4*n2*q13*q33+4*q23*q33-4*n2*q23*q33+q33^2-n2*q33^2);
	Identify,ifmatch->jump mbox1l(n1?neg0_,n2?pos_,n3?neg_,n4?pos_) = mbox1l(n1,n2,1+n3,-1+n4)*prf(-(q12*q13)+q12*q23,-q13^2-2*q13*q23-q23^2+2*q12*q33)+mbox1l(-1+n1,n2,2+n3,-1+n4)*prf(-q12^2-n3*q12^2-q12*q23-n3*q12*q23,-q13^2+n1*q13^2-2*q13*q23+2*n1*q13*q23-q23^2+n1*q23^2+2*q12*q33-2*n1*q12*q33)+mbox1l(-2+n1,n2,2+n3,n4)*prf(q12^2+n3*q12^2+2*q12*q23+2*n3*q12*q23+q23^2+n3*q23^2,-q13^2+n1*q13^2-2*q13*q23+2*n1*q13*q23-q23^2+n1*q23^2+2*q12*q33-2*n1*q12*q33)+mbox1l(n1,-1+n2,1+n3,n4)*prf(q13^2+q13*q23-q12*q33,q13^2+2*q13*q23+q23^2-2*q12*q33)+mbox1l(-1+n1,-1+n2,2+n3,n4)*prf(-(q12*q13)-n3*q12*q13+q13*q23+n3*q13*q23-q12*q33-n3*q12*q33,-q13^2+n1*q13^2-2*q13*q23+2*n1*q13*q23-q23^2+n1*q23^2+2*q12*q33-2*n1*q12*q33)+mbox1l(-1+n1,n2,1+n3,n4)*prf(2*q12*q13-n1*q12*q13+n3*q12*q13-2*q12*q23+n1*q12*q23-n3*q12*q23-2*q13*q23+n1*q13*q23-n3*q13*q23-2*q23^2+n1*q23^2-n3*q23^2+2*q12*q33-n1*q12*q33+n3*q12*q33,-q13^2+n1*q13^2-2*q13*q23+2*n1*q13*q23-q23^2+n1*q23^2+2*q12*q33-2*n1*q12*q33)+mbox1l(n1,n2,1+n3,n4)*prf(-2*q12*q13^2-2*q12*q13*q23+2*q12^2*q33-q12*q13*q33+q12*q23*q33,-q13^2-2*q13*q23-q23^2+2*q12*q33)+mbox1l(-1+n1,n2,2+n3,n4)*prf(-2*q12^2*q13-2*n3*q12^2*q13-2*q12*q13*q23-2*n3*q12*q13*q23-q12^2*q33-n3*q12^2*q33-q12*q23*q33-n3*q12*q23*q33,-q13^2+n1*q13^2-2*q13*q23+2*n1*q13*q23-q23^2+n1*q23^2+2*q12*q33-2*n1*q12*q33);
	Identify,ifmatch->jump mbox1l(n1?neg_,1,0,1) = tmpprf(1,-1+2*ep+n1)*mbox1l(n1,0,0,2)*prf(-2*M`j'^2,2*q12+2*q13+2*q23+q33)+tmpprf(1,-1+2*ep+n1)*mbox1l(1+n1,0,0,1)*prf(-2*M`j'^2*n1,2*q12+2*q13+2*q23+q33)+tmpprf(1,-1+2*ep+n1)*mbox1l(1+n1,0,0,2)*prf(2*M`j'^2*q13+2*M`j'^2*q23,2*q12+2*q13+2*q23+q33)+mbox1l(1+n1,1,0,1)*(tmpprf(ep,-1+2*ep+n1)*prf(2*q13+2*q23,1)+tmpprf(1,-1+2*ep+n1)*prf(2*n1*q13+2*n1*q23,1))+tmpprf(1,-1+2*ep+n1)*mbox1l(2+n1,1,0,0)*prf(2*M`j'^2*q13+2*M`j'^2*n1*q13+2*M`j'^2*q23+2*M`j'^2*n1*q23,2*q12+2*q13+2*q23+q33)+tmpprf(1,-1+2*ep+n1)*mbox1l(n1,2,0,0)*prf(2*M`j'^2-2*q12-2*q13-2*q23-q33,2*q12+2*q13+2*q23+q33)+tmpprf(1,-1+2*ep+n1)*mbox1l(1+n1,1,0,0)*prf(2*M`j'^2*n1-2*n1*q12-2*n1*q13-2*n1*q23-n1*q33,2*q12+2*q13+2*q23+q33)+tmpprf(1,-1+2*ep+n1)*mbox1l(1+n1,2,0,0)*prf(8*M`j'^2*q12-4*q12^2+2*M`j'^2*q13-4*q12*q13+2*M`j'^2*q23-4*q12*q23-2*q12*q33,2*q12+2*q13+2*q23+q33)+tmpprf(1,-1+2*ep+n1)*mbox1l(2+n1,0,0,1)*prf(2*M`j'^2*q13+2*M`j'^2*n1*q13+2*M`j'^2*q23+2*M`j'^2*n1*q23+4*M`j'^2*q33+4*M`j'^2*n1*q33-2*q12*q33-2*n1*q12*q33-2*q13*q33-2*n1*q13*q33-2*q23*q33-2*n1*q23*q33-q33^2-n1*q33^2,2*q12+2*q13+2*q23+q33)+tmpprf(1,-1+2*ep+n1)*mbox1l(2+n1,1,0,1)*prf(-4*M`j'^2*q13^2-4*M`j'^2*n1*q13^2-8*M`j'^2*q13*q23-8*M`j'^2*n1*q13*q23-4*M`j'^2*q23^2-4*M`j'^2*n1*q23^2+8*M`j'^2*q12*q33+8*M`j'^2*n1*q12*q33-4*q12^2*q33-4*n1*q12^2*q33-4*q12*q13*q33-4*n1*q12*q13*q33-4*q12*q23*q33-4*n1*q12*q23*q33-2*q12*q33^2-2*n1*q12*q33^2,2*q12+2*q13+2*q23+q33);
	Identify,ifmatch->jump mbox1l(n1?neg0_,n2?pos_,n3?{,>1},n4?neg_) = mbox1l(1+n1,-1+n2,-1+n3,1+n4)*prf(n1*q13,-q12+n3*q12)+mbox1l(-1+n1,1+n2,-1+n3,1+n4)*prf(-(n2*q12)-n2*q23,-q12+n3*q12)+mbox1l(1+n1,n2,-1+n3,1+n4)*prf(4*n1*q13+n1*q33,-1+n3)+mbox1l(n1,1+n2,-1+n3,1+n4)*prf(-2*n2*q12+2*n2*q13-2*n2*q23+n2*q33,-1+n3)+mbox1l(n1,-1+n2,-1+n3,2+n4)*prf(q13+n4*q13+q33+n4*q33,-q12+n3*q12)+mbox1l(-1+n1,n2,-1+n3,2+n4)*prf(-q12-n4*q12+2*q13+2*n4*q13-q23-n4*q23+q33+n4*q33,-q12+n3*q12)+mbox1l(1+n1,n2,-2+n3,1+n4)*prf(2*M`j'^2*n1*q12-4*M`j'^2*n1*q13-2*n1*q12*q13-n1*q12*q33,-2*M`j'^2*q12+2*M`j'^2*n3*q12)+mbox1l(n1,1+n2,-2+n3,1+n4)*prf(2*M`j'^2*n2*q12-2*n2*q12*q13+4*M`j'^2*n2*q23-n2*q12*q33,-2*M`j'^2*q12+2*M`j'^2*n3*q12)+mbox1l(n1,n2,-2+n3,2+n4)*prf(2*M`j'^2*q12+2*M`j'^2*n4*q12-4*M`j'^2*q13-4*M`j'^2*n4*q13-2*q12*q13-2*n4*q12*q13-4*M`j'^2*q33-4*M`j'^2*n4*q33-q12*q33-n4*q12*q33,-2*M`j'^2*q12+2*M`j'^2*n3*q12)+mbox1l(n1,n2,-1+n3,1+n4)*(tmpprf(ep,1)*prf(-4*q12*q13-2*q12*q33,-2*M`j'^2*q12+2*M`j'^2*n3*q12)+prf(-2*M`j'^2*q12-2*M`j'^2*n1*q12+2*M`j'^2*n3*q12-2*M`j'^2*q13+2*M`j'^2*n1*q13-2*M`j'^2*n4*q13+10*q12*q13-2*n1*q12*q13-2*n2*q12*q13-4*n3*q12*q13-2*n4*q12*q13+2*M`j'^2*q23-2*M`j'^2*n2*q23+2*M`j'^2*n4*q23+5*q12*q33-n1*q12*q33-n2*q12*q33-2*n3*q12*q33-n4*q12*q33,-2*M`j'^2*q12+2*M`j'^2*n3*q12))+mbox1l(n1,n2,-1+n3,2+n4)*prf(12*M`j'^2*q12*q13+12*M`j'^2*n4*q12*q13-4*M`j'^2*q13^2-4*M`j'^2*n4*q13^2-4*q12*q13^2-4*n4*q12*q13^2+4*M`j'^2*q13*q23+4*M`j'^2*n4*q13*q23+6*M`j'^2*q12*q33+6*M`j'^2*n4*q12*q33-2*M`j'^2*q13*q33-2*M`j'^2*n4*q13*q33-4*q12*q13*q33-4*n4*q12*q13*q33+2*M`j'^2*q23*q33+2*M`j'^2*n4*q23*q33-q12*q33^2-n4*q12*q33^2,-2*M`j'^2*q12+2*M`j'^2*n3*q12);
	Identify,ifmatch->jump mbox1l(n1?neg_,n2?pos_,n3?{,>1},n4?neg0_) = mbox1l(2+n1,n2,-2+n3,n4)*prf(1+n1,-1+n3)+mbox1l(n1,1+n2,-1+n3,n4)*prf(-n2,-1+n3)+mbox1l(1+n1,1+n2,-2+n3,n4)*prf(n2,-1+n3)+mbox1l(1+n1,n2,-1+n3,n4)*prf(-2-n1+n3,-1+n3)+mbox1l(n1,n2,-1+n3,1+n4)*prf(-n4,-1+n3)+mbox1l(1+n1,n2,-2+n3,1+n4)*prf(n4,-1+n3)+mbox1l(1+n1,1+n2,-1+n3,n4)*prf(-2*n2*q12,-1+n3)+mbox1l(1+n1,n2,-1+n3,1+n4)*prf(2*n4*q13,-1+n3);
	Identify,ifmatch->jump mbox1l(n1?neg0_,n2?{,>1},n3?pos_,n4?neg_) = mbox1l(1+n1,-1+n2,-1+n3,1+n4)*prf(n1*q13,-q12+n2*q12)+mbox1l(n1,-1+n2,n3,1+n4)*prf(q13-n1*q13+n4*q13,-q12+n2*q12)+mbox1l(n1,n2,-1+n3,1+n4)*prf(-q23,q12)+mbox1l(-1+n1,n2,n3,1+n4)*prf(q12+q23,q12)+mbox1l(n1,n2,n3,1+n4)*prf(-2*q13-q33,1)+mbox1l(-1+n1,-1+n2,n3,2+n4)*prf(-2*q13-2*n4*q13-q33-n4*q33,-q12+n2*q12)+mbox1l(n1,-1+n2,-1+n3,2+n4)*prf(q13+n4*q13+q33+n4*q33,-q12+n2*q12)+mbox1l(n1,-1+n2,n3,2+n4)*prf(2*q13^2+2*n4*q13^2+q13*q33+n4*q13*q33,-q12+n2*q12);
	Identify,ifmatch->jump mbox1l(n1?neg0_,n2?pos_,n3?{,>1},n4?neg0_) = mbox1l(1+n1,n2,-1+n3,n4)*prf(-n1,-1+n3)+mbox1l(1+n1,n2,-2+n3,n4)*prf(n1,-2*M`j'^2+2*M`j'^2*n3)+mbox1l(n1,1+n2,-1+n3,n4)*prf(-n2,-1+n3)+mbox1l(n1,1+n2,-2+n3,n4)*prf(n2,-2*M`j'^2+2*M`j'^2*n3)+mbox1l(n1,n2,-2+n3,1+n4)*prf(n4,-2*M`j'^2+2*M`j'^2*n3)+mbox1l(n1,n2,-1+n3,n4)*(tmpprf(ep,1)*prf(1,-M`j'^2+M`j'^2*n3)+prf(-6+n1+n2+2*n3+n4,-2*M`j'^2+2*M`j'^2*n3))+mbox1l(n1,n2,-1+n3,1+n4)*prf(-2*M`j'^2*n4+2*n4*q13+n4*q33,-2*M`j'^2+2*M`j'^2*n3);
	Identify,ifmatch->jump mbox1l(n1?neg0_,n2?pos_,n3?{,>1},n4?neg0_) = mbox1l(1+n1,n2,-1+n3,n4)*prf(-n1,-1+n3)+mbox1l(1+n1,1+n2,-2+n3,n4)*prf(n1,-1+n3)+mbox1l(n1,2+n2,-2+n3,n4)*prf(1+n2,-1+n3)+mbox1l(n1,1+n2,-1+n3,n4)*prf(-2-n2+n3,-1+n3)+mbox1l(n1,n2,-1+n3,1+n4)*prf(-n4,-1+n3)+mbox1l(n1,1+n2,-2+n3,1+n4)*prf(n4,-1+n3)+mbox1l(1+n1,1+n2,-1+n3,n4)*prf(-2*n1*q12,-1+n3)+mbox1l(n1,1+n2,-1+n3,1+n4)*prf(-2*n4*q12-2*n4*q23,-1+n3);
	Identify,ifmatch->jump mbox1l(n1?neg0_,n2?pos_,n3?pos_,n4?neg_) = mbox1l(n1,-1+n2,n3,1+n4)*prf(-q13,q12)+mbox1l(n1,n2,-1+n3,1+n4)*prf(q13,q12)+mbox1l(-1+n1,1+n2,-1+n3,1+n4)*prf(-(n2*q23),-q12+n1*q12)+mbox1l(-1+n1,n2,n3,1+n4)*prf(-2*q12+n1*q12-n4*q12-q23+n2*q23-n4*q23,-q12+n1*q12)+mbox1l(-2+n1,n2,n3,2+n4)*prf(q12+n4*q12+q23+n4*q23,-q12+n1*q12)+mbox1l(n1,n2,n3,1+n4)*prf(-2*q13-q33,1)+mbox1l(-1+n1,-1+n2,n3,2+n4)*prf(-q13-n4*q13-q33-n4*q33,-q12+n1*q12)+mbox1l(-1+n1,n2,-1+n3,2+n4)*prf(q13+n4*q13+q33+n4*q33,-q12+n1*q12)+mbox1l(-1+n1,n2,n3,2+n4)*prf(-2*q12*q13-2*n4*q12*q13-2*q13*q23-2*n4*q13*q23-q12*q33-n4*q12*q33-q23*q33-n4*q23*q33,-q12+n1*q12);
	Identify,ifmatch->jump mbox1l(n1?neg0_,n2?pos_,n3?pos_,n4?neg0_) = mbox1l(1+n1,n2,-1+n3,n4)*prf(n1,n1-n2)+mbox1l(n1,1+n2,-1+n3,n4)*prf(-n2,n1-n2)+mbox1l(n1,-1+n2,n3,1+n4)*prf(-(n4*q13),n1*q12-n2*q12)+mbox1l(-1+n1,n2,n3,1+n4)*prf(-(n4*q12)-n4*q23,n1*q12-n2*q12)+mbox1l(n1,n2,-1+n3,1+n4)*prf(n4*q12+n4*q13+n4*q23,n1*q12-n2*q12);
	Identify,ifmatch->jump mbox1l(n1?pos_,n2?neg0_,n3?neg_,n4?{,>1}) = mbox1l(1+n1,n2,1+n3,-2+n4)*prf(-2*M`j'^2*n1*q13,-4*M`j'^2*q33+4*M`j'^2*n4*q33+q33^2-n4*q33^2)+mbox1l(n1,-1+n2,2+n3,-1+n4)*prf(-q13^3-n3*q13^3-q13^2*q23-n3*q13^2*q23,q13^2*q33-n4*q13^2*q33+2*q13*q23*q33-2*n4*q13*q23*q33+q23^2*q33-n4*q23^2*q33-2*q12*q33^2+2*n4*q12*q33^2)+mbox1l(n1,n2,2+n3,-2+n4)*prf(-4*M`j'^2*q12*q13^2-4*M`j'^2*n3*q12*q13^2+2*M`j'^2*q13^3+2*M`j'^2*n3*q13^3-4*M`j'^2*q12*q13*q23-4*M`j'^2*n3*q12*q13*q23+4*M`j'^2*q13^2*q23+4*M`j'^2*n3*q13^2*q23+2*M`j'^2*q13*q23^2+2*M`j'^2*n3*q13*q23^2-4*M`j'^2*q12*q13*q33-4*M`j'^2*n3*q12*q13*q33+q12*q13^2*q33+n3*q12*q13^2*q33+q12*q13*q23*q33+n3*q12*q13*q23*q33,4*M`j'^2*q13^2*q33-4*M`j'^2*n4*q13^2*q33+8*M`j'^2*q13*q23*q33-8*M`j'^2*n4*q13*q23*q33+4*M`j'^2*q23^2*q33-4*M`j'^2*n4*q23^2*q33-8*M`j'^2*q12*q33^2+8*M`j'^2*n4*q12*q33^2-q13^2*q33^2+n4*q13^2*q33^2-2*q13*q23*q33^2+2*n4*q13*q23*q33^2-q23^2*q33^2+n4*q23^2*q33^2+2*q12*q33^3-2*n4*q12*q33^3)+mbox1l(-1+n1,n2,1+n3,n4)*prf(6*M`j'^2*q13+4*M`j'^2*q33-2*q13*q33-q33^2,4*M`j'^2*q33-q33^2)+mbox1l(n1,1+n2,1+n3,-2+n4)*prf(-8*M`j'^2*n2*q12*q13^2+2*M`j'^2*n2*q13^3-8*M`j'^2*n2*q12*q13*q23+4*M`j'^2*n2*q13^2*q23+2*M`j'^2*n2*q13*q23^2+8*M`j'^2*n2*q12^2*q33-4*M`j'^2*n2*q12*q13*q33+2*n2*q12*q13^2*q33+2*n2*q12*q13*q23*q33-2*n2*q12^2*q33^2,4*M`j'^2*q13^2*q33-4*M`j'^2*n4*q13^2*q33+8*M`j'^2*q13*q23*q33-8*M`j'^2*n4*q13*q23*q33+4*M`j'^2*q23^2*q33-4*M`j'^2*n4*q23^2*q33-8*M`j'^2*q12*q33^2+8*M`j'^2*n4*q12*q33^2-q13^2*q33^2+n4*q13^2*q33^2-2*q13*q23*q33^2+2*n4*q13*q23*q33^2-q23^2*q33^2+n4*q23^2*q33^2+2*q12*q33^3-2*n4*q12*q33^3)+mbox1l(-1+n1,1+n2,1+n3,-1+n4)*prf(8*M`j'^2*n2*q12*q13^2+2*M`j'^2*n2*q13^3+8*M`j'^2*n2*q12*q13*q23+4*M`j'^2*n2*q13^2*q23+2*M`j'^2*n2*q13*q23^2-8*M`j'^2*n2*q12^2*q33-2*n2*q12*q13^2*q33-4*M`j'^2*n2*q12*q23*q33-2*n2*q12*q13*q23*q33+2*n2*q12^2*q33^2-n2*q12*q13*q33^2+n2*q12*q23*q33^2,4*M`j'^2*q13^2*q33-4*M`j'^2*n4*q13^2*q33+8*M`j'^2*q13*q23*q33-8*M`j'^2*n4*q13*q23*q33+4*M`j'^2*q23^2*q33-4*M`j'^2*n4*q23^2*q33-8*M`j'^2*q12*q33^2+8*M`j'^2*n4*q12*q33^2-q13^2*q33^2+n4*q13^2*q33^2-2*q13*q23*q33^2+2*n4*q13*q23*q33^2-q23^2*q33^2+n4*q23^2*q33^2+2*q12*q33^3-2*n4*q12*q33^3)+mbox1l(-1+n1,n2,2+n3,-1+n4)*prf(4*M`j'^2*q12*q13^2+4*M`j'^2*n3*q12*q13^2+2*M`j'^2*q13^3+2*M`j'^2*n3*q13^3+4*M`j'^2*q12*q13*q23+4*M`j'^2*n3*q12*q13*q23-2*M`j'^2*q13*q23^2-2*M`j'^2*n3*q13*q23^2-q12*q13^2*q33-n3*q12*q13^2*q33+4*M`j'^2*q12*q23*q33+4*M`j'^2*n3*q12*q23*q33-q12*q13*q23*q33-n3*q12*q13*q23*q33+q13^2*q23*q33+n3*q13^2*q23*q33+q13*q23^2*q33+n3*q13*q23^2*q33-q12*q13*q33^2-n3*q12*q13*q33^2-q12*q23*q33^2-n3*q12*q23*q33^2,4*M`j'^2*q13^2*q33-4*M`j'^2*n4*q13^2*q33+8*M`j'^2*q13*q23*q33-8*M`j'^2*n4*q13*q23*q33+4*M`j'^2*q23^2*q33-4*M`j'^2*n4*q23^2*q33-8*M`j'^2*q12*q33^2+8*M`j'^2*n4*q12*q33^2-q13^2*q33^2+n4*q13^2*q33^2-2*q13*q23*q33^2+2*n4*q13*q23*q33^2-q23^2*q33^2+n4*q23^2*q33^2+2*q12*q33^3-2*n4*q12*q33^3)+mbox1l(n1,n2,1+n3,-1+n4)*(tmpprf(ep,1)*prf(2*q13^3*q33+4*q13^2*q23*q33+2*q13*q23^2*q33-4*q12*q13*q33^2,4*M`j'^2*q13^2*q33-4*M`j'^2*n4*q13^2*q33+8*M`j'^2*q13*q23*q33-8*M`j'^2*n4*q13*q23*q33+4*M`j'^2*q23^2*q33-4*M`j'^2*n4*q23^2*q33-8*M`j'^2*q12*q33^2+8*M`j'^2*n4*q12*q33^2-q13^2*q33^2+n4*q13^2*q33^2-2*q13*q23*q33^2+2*n4*q13*q23*q33^2-q23^2*q33^2+n4*q23^2*q33^2+2*q12*q33^3-2*n4*q12*q33^3)+prf(-6*M`j'^2*q13^3-2*M`j'^2*n1*q13^3-4*M`j'^2*n2*q13^3+6*M`j'^2*n4*q13^3-12*M`j'^2*q13^2*q23-4*M`j'^2*n1*q13^2*q23-8*M`j'^2*n2*q13^2*q23+12*M`j'^2*n4*q13^2*q23-6*M`j'^2*q13*q23^2-2*M`j'^2*n1*q13*q23^2-4*M`j'^2*n2*q13*q23^2+6*M`j'^2*n4*q13*q23^2+16*M`j'^2*q12*q13*q33+4*M`j'^2*n1*q12*q13*q33+4*M`j'^2*n2*q12*q13*q33+4*M`j'^2*n3*q12*q13*q33-12*M`j'^2*n4*q12*q13*q33-3*q13^3*q33+2*n1*q13^3*q33+2*n2*q13^3*q33+n3*q13^3*q33-4*M`j'^2*q12*q23*q33+4*M`j'^2*n2*q12*q23*q33-4*M`j'^2*n3*q12*q23*q33-6*q13^2*q23*q33+4*n1*q13^2*q23*q33+4*n2*q13^2*q23*q33+2*n3*q13^2*q23*q33-3*q13*q23^2*q33+2*n1*q13*q23^2*q33+2*n2*q13*q23^2*q33+n3*q13*q23^2*q33+5*q12*q13*q33^2-4*n1*q12*q13*q33^2-3*n2*q12*q13*q33^2-3*n3*q12*q13*q33^2+q12*q23*q33^2-n2*q12*q23*q33^2+n3*q12*q23*q33^2,4*M`j'^2*q13^2*q33-4*M`j'^2*n4*q13^2*q33+8*M`j'^2*q13*q23*q33-8*M`j'^2*n4*q13*q23*q33+4*M`j'^2*q23^2*q33-4*M`j'^2*n4*q23^2*q33-8*M`j'^2*q12*q33^2+8*M`j'^2*n4*q12*q33^2-q13^2*q33^2+n4*q13^2*q33^2-2*q13*q23*q33^2+2*n4*q13*q23*q33^2-q23^2*q33^2+n4*q23^2*q33^2+2*q12*q33^3-2*n4*q12*q33^3))+mbox1l(n1,n2,2+n3,-1+n4)*prf(-8*M`j'^2*q12*q13^3-8*M`j'^2*n3*q12*q13^3+4*M`j'^2*q13^4+4*M`j'^2*n3*q13^4-8*M`j'^2*q12*q13^2*q23-8*M`j'^2*n3*q12*q13^2*q23+8*M`j'^2*q13^3*q23+8*M`j'^2*n3*q13^3*q23+4*M`j'^2*q13^2*q23^2+4*M`j'^2*n3*q13^2*q23^2-12*M`j'^2*q12*q13^2*q33-12*M`j'^2*n3*q12*q13^2*q33+2*q12*q13^3*q33+2*n3*q12*q13^3*q33-4*M`j'^2*q12*q13*q23*q33-4*M`j'^2*n3*q12*q13*q23*q33+2*q12*q13^2*q23*q33+2*n3*q12*q13^2*q23*q33+q12*q13^2*q33^2+n3*q12*q13^2*q33^2+q12*q13*q23*q33^2+n3*q12*q13*q23*q33^2,4*M`j'^2*q13^2*q33-4*M`j'^2*n4*q13^2*q33+8*M`j'^2*q13*q23*q33-8*M`j'^2*n4*q13*q23*q33+4*M`j'^2*q23^2*q33-4*M`j'^2*n4*q23^2*q33-8*M`j'^2*q12*q33^2+8*M`j'^2*n4*q12*q33^2-q13^2*q33^2+n4*q13^2*q33^2-2*q13*q23*q33^2+2*n4*q13*q23*q33^2-q23^2*q33^2+n4*q23^2*q33^2+2*q12*q33^3-2*n4*q12*q33^3)+mbox1l(n1,1+n2,1+n3,-1+n4)*prf(-8*M`j'^2*n2*q12*q13^3+4*M`j'^2*n2*q13^4-16*M`j'^2*n2*q12*q13^2*q23+12*M`j'^2*n2*q13^3*q23-8*M`j'^2*n2*q12*q13*q23^2+12*M`j'^2*n2*q13^2*q23^2+4*M`j'^2*n2*q13*q23^3+8*M`j'^2*n2*q12^2*q13*q33-16*M`j'^2*n2*q12*q13^2*q33+4*n2*q12*q13^3*q33+8*M`j'^2*n2*q12^2*q23*q33-16*M`j'^2*n2*q12*q13*q23*q33+8*n2*q12*q13^2*q23*q33+4*n2*q12*q13*q23^2*q33+8*M`j'^2*n2*q12^2*q33^2-6*n2*q12^2*q13*q33^2+2*n2*q12*q13^2*q33^2-2*n2*q12^2*q23*q33^2+2*n2*q12*q13*q23*q33^2-2*n2*q12^2*q33^3,4*M`j'^2*q13^2*q33-4*M`j'^2*n4*q13^2*q33+8*M`j'^2*q13*q23*q33-8*M`j'^2*n4*q13*q23*q33+4*M`j'^2*q23^2*q33-4*M`j'^2*n4*q23^2*q33-8*M`j'^2*q12*q33^2+8*M`j'^2*n4*q12*q33^2-q13^2*q33^2+n4*q13^2*q33^2-2*q13*q23*q33^2+2*n4*q13*q23*q33^2-q23^2*q33^2+n4*q23^2*q33^2+2*q12*q33^3-2*n4*q12*q33^3);
	Identify,ifmatch->jump mbox1l(n1?pos_,n2?neg_,n3?neg0_,n4?{,>1}) = mbox1l(n1,n2,1+n3,-1+n4)*prf(n3*q13,-q33+n4*q33)+mbox1l(1+n1,1+n2,n3,-2+n4)*prf(-4*M`j'^2*n1*q12-2*M`j'^2*n1*q13-2*M`j'^2*n1*q23,-4*M`j'^2*q33+4*M`j'^2*n4*q33+q33^2-n4*q33^2)+mbox1l(-1+n1,2+n2,n3,-1+n4)*prf(-4*M`j'^2*q12-4*M`j'^2*n2*q12-2*M`j'^2*q13-2*M`j'^2*n2*q13-2*M`j'^2*q23-2*M`j'^2*n2*q23,-4*M`j'^2*q33+4*M`j'^2*n4*q33+q33^2-n4*q33^2)+mbox1l(n1,2+n2,n3,-2+n4)*prf(4*M`j'^2*q12+4*M`j'^2*n2*q12-2*M`j'^2*q13-2*M`j'^2*n2*q13-2*M`j'^2*q23-2*M`j'^2*n2*q23-2*q12*q33-2*n2*q12*q33,-4*M`j'^2*q33+4*M`j'^2*n4*q33+q33^2-n4*q33^2)+mbox1l(n1,1+n2,1+n3,-2+n4)*prf(-2*M`j'^2*n3*q13-2*M`j'^2*n3*q23-n3*q12*q33,-4*M`j'^2*q33+4*M`j'^2*n4*q33+q33^2-n4*q33^2)+mbox1l(-1+n1,1+n2,1+n3,-1+n4)*prf(-2*M`j'^2*n3*q13+2*M`j'^2*n3*q23-n3*q12*q33-n3*q23*q33,-4*M`j'^2*q33+4*M`j'^2*n4*q33+q33^2-n4*q33^2)+mbox1l(n1,1+n2,n3,-1+n4)*(tmpprf(ep,1)*prf(-4*q12*q33-2*q13*q33-2*q23*q33,-4*M`j'^2*q33+4*M`j'^2*n4*q33+q33^2-n4*q33^2)+prf(4*M`j'^2*q12+4*M`j'^2*n1*q12-4*M`j'^2*n4*q12+10*M`j'^2*q13+2*M`j'^2*n1*q13+4*M`j'^2*n2*q13-6*M`j'^2*n4*q13+10*M`j'^2*q23+2*M`j'^2*n1*q23+4*M`j'^2*n2*q23-6*M`j'^2*n4*q23+8*q12*q33-4*n1*q12*q33-2*n2*q12*q33-2*n3*q12*q33-2*n4*q12*q33+2*q13*q33-2*n1*q13*q33-2*n2*q13*q33-n3*q13*q33+2*q23*q33-2*n1*q23*q33-2*n2*q23*q33-n3*q23*q33,-4*M`j'^2*q33+4*M`j'^2*n4*q33+q33^2-n4*q33^2))+mbox1l(-1+n1,1+n2,n3,n4)*prf(4*M`j'^2*q12+6*M`j'^2*q13+6*M`j'^2*q23+4*M`j'^2*q33-2*q12*q33-2*q13*q33-2*q23*q33-q33^2,4*M`j'^2*q33-q33^2)+mbox1l(n1,2+n2,n3,-1+n4)*prf(-4*M`j'^2*q13^2-4*M`j'^2*n2*q13^2-8*M`j'^2*q13*q23-8*M`j'^2*n2*q13*q23-4*M`j'^2*q23^2-4*M`j'^2*n2*q23^2+8*M`j'^2*q12*q33+8*M`j'^2*n2*q12*q33-4*q12^2*q33-4*n2*q12^2*q33-4*q12*q13*q33-4*n2*q12*q13*q33-4*q12*q23*q33-4*n2*q12*q23*q33-2*q12*q33^2-2*n2*q12*q33^2,-4*M`j'^2*q33+4*M`j'^2*n4*q33+q33^2-n4*q33^2)+mbox1l(n1,1+n2,1+n3,-1+n4)*prf(-4*M`j'^2*n3*q13^2-4*M`j'^2*n3*q13*q23+4*M`j'^2*n3*q12*q33-2*n3*q12*q13*q33-n3*q12*q33^2,-4*M`j'^2*q33+4*M`j'^2*n4*q33+q33^2-n4*q33^2);
	Identify,ifmatch->jump mbox1l(n1?{,>1},n2?neg0_,n3?neg_,n4?pos_) = mbox1l(n1,n2,1+n3,-1+n4)*prf(-2*M`j'^2*q13,4*M`j'^2*q33-q33^2)+mbox1l(-2+n1,n2,1+n3,1+n4)*prf(-2*M`j'^2*n4*q13,-4*M`j'^2*q33+4*M`j'^2*n1*q33+q33^2-n1*q33^2)+mbox1l(-1+n1,-1+n2,2+n3,n4)*prf(q13^3+n3*q13^3+q13^2*q23+n3*q13^2*q23+q13^2*q33+n3*q13^2*q33,q13^2*q33-n1*q13^2*q33+2*q13*q23*q33-2*n1*q13*q23*q33+q23^2*q33-n1*q23^2*q33-2*q12*q33^2+2*n1*q12*q33^2)+mbox1l(-1+n1,n2,2+n3,-1+n4)*prf(4*M`j'^2*q12*q13^2+4*M`j'^2*n3*q12*q13^2+2*M`j'^2*q13^3+2*M`j'^2*n3*q13^3+4*M`j'^2*q12*q13*q23+4*M`j'^2*n3*q12*q13*q23+4*M`j'^2*q13^2*q23+4*M`j'^2*n3*q13^2*q23+2*M`j'^2*q13*q23^2+2*M`j'^2*n3*q13*q23^2-q12*q13^2*q33-n3*q12*q13^2*q33-q12*q13*q23*q33-n3*q12*q13*q23*q33-q12*q13*q33^2-n3*q12*q13*q33^2,4*M`j'^2*q13^2*q33-4*M`j'^2*n1*q13^2*q33+8*M`j'^2*q13*q23*q33-8*M`j'^2*n1*q13*q23*q33+4*M`j'^2*q23^2*q33-4*M`j'^2*n1*q23^2*q33-8*M`j'^2*q12*q33^2+8*M`j'^2*n1*q12*q33^2-q13^2*q33^2+n1*q13^2*q33^2-2*q13*q23*q33^2+2*n1*q13*q23*q33^2-q23^2*q33^2+n1*q23^2*q33^2+2*q12*q33^3-2*n1*q12*q33^3)+mbox1l(-1+n1,1+n2,1+n3,-1+n4)*prf(8*M`j'^2*n2*q12*q13^2+2*M`j'^2*n2*q13^3+8*M`j'^2*n2*q12*q13*q23+4*M`j'^2*n2*q13^2*q23+2*M`j'^2*n2*q13*q23^2-8*M`j'^2*n2*q12^2*q33-2*n2*q12*q13^2*q33-4*M`j'^2*n2*q12*q23*q33-2*n2*q12*q13*q23*q33+2*n2*q12^2*q33^2-n2*q12*q13*q33^2+n2*q12*q23*q33^2,4*M`j'^2*q13^2*q33-4*M`j'^2*n1*q13^2*q33+8*M`j'^2*q13*q23*q33-8*M`j'^2*n1*q13*q23*q33+4*M`j'^2*q23^2*q33-4*M`j'^2*n1*q23^2*q33-8*M`j'^2*q12*q33^2+8*M`j'^2*n1*q12*q33^2-q13^2*q33^2+n1*q13^2*q33^2-2*q13*q23*q33^2+2*n1*q13*q23*q33^2-q23^2*q33^2+n1*q23^2*q33^2+2*q12*q33^3-2*n1*q12*q33^3)+mbox1l(-2+n1,1+n2,1+n3,n4)*prf(-8*M`j'^2*n2*q12*q13^2-6*M`j'^2*n2*q13^3-8*M`j'^2*n2*q12*q13*q23-12*M`j'^2*n2*q13^2*q23-6*M`j'^2*n2*q13*q23^2+8*M`j'^2*n2*q12^2*q33+4*M`j'^2*n2*q12*q13*q33-4*M`j'^2*n2*q13^2*q33+2*n2*q12*q13^2*q33+2*n2*q13^3*q33+8*M`j'^2*n2*q12*q23*q33-4*M`j'^2*n2*q13*q23*q33+2*n2*q12*q13*q23*q33+4*n2*q13^2*q23*q33+2*n2*q13*q23^2*q33+4*M`j'^2*n2*q12*q33^2-2*n2*q12^2*q33^2-2*n2*q12*q13*q33^2+n2*q13^2*q33^2-2*n2*q12*q23*q33^2+n2*q13*q23*q33^2-n2*q12*q33^3,4*M`j'^2*q13^2*q33-4*M`j'^2*n1*q13^2*q33+8*M`j'^2*q13*q23*q33-8*M`j'^2*n1*q13*q23*q33+4*M`j'^2*q23^2*q33-4*M`j'^2*n1*q23^2*q33-8*M`j'^2*q12*q33^2+8*M`j'^2*n1*q12*q33^2-q13^2*q33^2+n1*q13^2*q33^2-2*q13*q23*q33^2+2*n1*q13*q23*q33^2-q23^2*q33^2+n1*q23^2*q33^2+2*q12*q33^3-2*n1*q12*q33^3)+mbox1l(-2+n1,n2,2+n3,n4)*prf(-4*M`j'^2*q12*q13^2-4*M`j'^2*n3*q12*q13^2-6*M`j'^2*q13^3-6*M`j'^2*n3*q13^3-4*M`j'^2*q12*q13*q23-4*M`j'^2*n3*q12*q13*q23-8*M`j'^2*q13^2*q23-8*M`j'^2*n3*q13^2*q23-2*M`j'^2*q13*q23^2-2*M`j'^2*n3*q13*q23^2+4*M`j'^2*q12*q13*q33+4*M`j'^2*n3*q12*q13*q33-4*M`j'^2*q13^2*q33-4*M`j'^2*n3*q13^2*q33+q12*q13^2*q33+n3*q12*q13^2*q33+2*q13^3*q33+2*n3*q13^3*q33-4*M`j'^2*q12*q23*q33-4*M`j'^2*n3*q12*q23*q33-4*M`j'^2*q13*q23*q33-4*M`j'^2*n3*q13*q23*q33+q12*q13*q23*q33+n3*q12*q13*q23*q33+3*q13^2*q23*q33+3*n3*q13^2*q23*q33-4*M`j'^2*q23^2*q33-4*M`j'^2*n3*q23^2*q33+q13*q23^2*q33+n3*q13*q23^2*q33+4*M`j'^2*q12*q33^2+4*M`j'^2*n3*q12*q33^2-2*q12*q13*q33^2-2*n3*q12*q13*q33^2+q13^2*q33^2+n3*q13^2*q33^2+q12*q23*q33^2+n3*q12*q23*q33^2+q13*q23*q33^2+n3*q13*q23*q33^2+q23^2*q33^2+n3*q23^2*q33^2-q12*q33^3-n3*q12*q33^3,4*M`j'^2*q13^2*q33-4*M`j'^2*n1*q13^2*q33+8*M`j'^2*q13*q23*q33-8*M`j'^2*n1*q13*q23*q33+4*M`j'^2*q23^2*q33-4*M`j'^2*n1*q23^2*q33-8*M`j'^2*q12*q33^2+8*M`j'^2*n1*q12*q33^2-q13^2*q33^2+n1*q13^2*q33^2-2*q13*q23*q33^2+2*n1*q13*q23*q33^2-q23^2*q33^2+n1*q23^2*q33^2+2*q12*q33^3-2*n1*q12*q33^3)+mbox1l(-1+n1,n2,1+n3,n4)*(tmpprf(ep,1)*prf(2*q13^3*q33+4*q13^2*q23*q33+2*q13*q23^2*q33-4*q12*q13*q33^2,4*M`j'^2*q13^2*q33-4*M`j'^2*n1*q13^2*q33+8*M`j'^2*q13*q23*q33-8*M`j'^2*n1*q13*q23*q33+4*M`j'^2*q23^2*q33-4*M`j'^2*n1*q23^2*q33-8*M`j'^2*q12*q33^2+8*M`j'^2*n1*q12*q33^2-q13^2*q33^2+n1*q13^2*q33^2-2*q13*q23*q33^2+2*n1*q13*q23*q33^2-q23^2*q33^2+n1*q23^2*q33^2+2*q12*q33^3-2*n1*q12*q33^3)+prf(2*M`j'^2*q13^3-2*M`j'^2*n1*q13^3+4*M`j'^2*n2*q13^3-2*M`j'^2*n4*q13^3+4*M`j'^2*q13^2*q23-4*M`j'^2*n1*q13^2*q23+8*M`j'^2*n2*q13^2*q23-4*M`j'^2*n4*q13^2*q23+2*M`j'^2*q13*q23^2-2*M`j'^2*n1*q13*q23^2+4*M`j'^2*n2*q13*q23^2-2*M`j'^2*n4*q13*q23^2-8*M`j'^2*q12*q13*q33+4*M`j'^2*n1*q12*q13*q33-4*M`j'^2*n2*q12*q13*q33-4*M`j'^2*n3*q12*q13*q33+4*M`j'^2*n4*q12*q13*q33+4*M`j'^2*q13^2*q33-4*M`j'^2*n1*q13^2*q33+4*M`j'^2*n2*q13^2*q33-5*q13^3*q33+2*n1*q13^3*q33+n3*q13^3*q33+2*n4*q13^3*q33+4*M`j'^2*q12*q23*q33-4*M`j'^2*n2*q12*q23*q33+4*M`j'^2*n3*q12*q23*q33+12*M`j'^2*q13*q23*q33-8*M`j'^2*n1*q13*q23*q33+4*M`j'^2*n2*q13*q23*q33+4*M`j'^2*n3*q13*q23*q33-10*q13^2*q23*q33+4*n1*q13^2*q23*q33+2*n3*q13^2*q23*q33+4*n4*q13^2*q23*q33+8*M`j'^2*q23^2*q33-4*M`j'^2*n1*q23^2*q33+4*M`j'^2*n3*q23^2*q33-5*q13*q23^2*q33+2*n1*q13*q23^2*q33+n3*q13*q23^2*q33+2*n4*q13*q23^2*q33-12*M`j'^2*q12*q33^2+8*M`j'^2*n1*q12*q33^2-4*M`j'^2*n2*q12*q33^2-4*M`j'^2*n3*q12*q33^2+11*q12*q13*q33^2-4*n1*q12*q13*q33^2-n2*q12*q13*q33^2-n3*q12*q13*q33^2-4*n4*q12*q13*q33^2-q13^2*q33^2+n1*q13^2*q33^2-n2*q13^2*q33^2-q12*q23*q33^2+n2*q12*q23*q33^2-n3*q12*q23*q33^2-3*q13*q23*q33^2+2*n1*q13*q23*q33^2-n2*q13*q23*q33^2-n3*q13*q23*q33^2-2*q23^2*q33^2+n1*q23^2*q33^2-n3*q23^2*q33^2+3*q12*q33^3-2*n1*q12*q33^3+n2*q12*q33^3+n3*q12*q33^3,4*M`j'^2*q13^2*q33-4*M`j'^2*n1*q13^2*q33+8*M`j'^2*q13*q23*q33-8*M`j'^2*n1*q13*q23*q33+4*M`j'^2*q23^2*q33-4*M`j'^2*n1*q23^2*q33-8*M`j'^2*q12*q33^2+8*M`j'^2*n1*q12*q33^2-q13^2*q33^2+n1*q13^2*q33^2-2*q13*q23*q33^2+2*n1*q13*q23*q33^2-q23^2*q33^2+n1*q23^2*q33^2+2*q12*q33^3-2*n1*q12*q33^3))+mbox1l(-1+n1,n2,2+n3,n4)*prf(8*M`j'^2*q12*q13^3+8*M`j'^2*n3*q12*q13^3+4*M`j'^2*q13^4+4*M`j'^2*n3*q13^4+8*M`j'^2*q12*q13^2*q23+8*M`j'^2*n3*q12*q13^2*q23+8*M`j'^2*q13^3*q23+8*M`j'^2*n3*q13^3*q23+4*M`j'^2*q13^2*q23^2+4*M`j'^2*n3*q13^2*q23^2+4*M`j'^2*q12*q13^2*q33+4*M`j'^2*n3*q12*q13^2*q33-2*q12*q13^3*q33-2*n3*q12*q13^3*q33+4*M`j'^2*q12*q13*q23*q33+4*M`j'^2*n3*q12*q13*q23*q33-2*q12*q13^2*q23*q33-2*n3*q12*q13^2*q23*q33+4*M`j'^2*q12*q13*q33^2+4*M`j'^2*n3*q12*q13*q33^2-3*q12*q13^2*q33^2-3*n3*q12*q13^2*q33^2-q12*q13*q23*q33^2-n3*q12*q13*q23*q33^2-q12*q13*q33^3-n3*q12*q13*q33^3,4*M`j'^2*q13^2*q33-4*M`j'^2*n1*q13^2*q33+8*M`j'^2*q13*q23*q33-8*M`j'^2*n1*q13*q23*q33+4*M`j'^2*q23^2*q33-4*M`j'^2*n1*q23^2*q33-8*M`j'^2*q12*q33^2+8*M`j'^2*n1*q12*q33^2-q13^2*q33^2+n1*q13^2*q33^2-2*q13*q23*q33^2+2*n1*q13*q23*q33^2-q23^2*q33^2+n1*q23^2*q33^2+2*q12*q33^3-2*n1*q12*q33^3)+mbox1l(-1+n1,1+n2,1+n3,n4)*prf(8*M`j'^2*n2*q12*q13^3+4*M`j'^2*n2*q13^4+16*M`j'^2*n2*q12*q13^2*q23+12*M`j'^2*n2*q13^3*q23+8*M`j'^2*n2*q12*q13*q23^2+12*M`j'^2*n2*q13^2*q23^2+4*M`j'^2*n2*q13*q23^3-8*M`j'^2*n2*q12^2*q13*q33-8*M`j'^2*n2*q12^2*q23*q33-8*M`j'^2*n2*q12*q13*q23*q33-8*M`j'^2*n2*q12*q23^2*q33+4*M`j'^2*n2*q12*q13*q33^2-2*n2*q12^2*q13*q33^2-2*n2*q12*q13^2*q33^2-4*M`j'^2*n2*q12*q23*q33^2+2*n2*q12^2*q23*q33^2+2*n2*q12*q23^2*q33^2-n2*q12*q13*q33^3+n2*q12*q23*q33^3,4*M`j'^2*q13^2*q33-4*M`j'^2*n1*q13^2*q33+8*M`j'^2*q13*q23*q33-8*M`j'^2*n1*q13*q23*q33+4*M`j'^2*q23^2*q33-4*M`j'^2*n1*q23^2*q33-8*M`j'^2*q12*q33^2+8*M`j'^2*n1*q12*q33^2-q13^2*q33^2+n1*q13^2*q33^2-2*q13*q23*q33^2+2*n1*q13*q23*q33^2-q23^2*q33^2+n1*q23^2*q33^2+2*q12*q33^3-2*n1*q12*q33^3);
	Identify,ifmatch->jump mbox1l(n1?{,>1},n2?neg_,n3?neg0_,n4?pos_) = mbox1l(-1+n1,2+n2,n3,-1+n4)*prf(-4*M`j'^2*q12-4*M`j'^2*n2*q12-2*M`j'^2*q13-2*M`j'^2*n2*q13-2*M`j'^2*q23-2*M`j'^2*n2*q23,-4*M`j'^2*q33+4*M`j'^2*n1*q33+q33^2-n1*q33^2)+mbox1l(-2+n1,1+n2,n3,1+n4)*prf(-4*M`j'^2*n4*q12-2*M`j'^2*n4*q13-2*M`j'^2*n4*q23,-4*M`j'^2*q33+4*M`j'^2*n1*q33+q33^2-n1*q33^2)+mbox1l(-1+n1,n2,1+n3,n4)*prf(-(n3*q13)-n3*q33,-q33+n1*q33)+mbox1l(n1,1+n2,n3,-1+n4)*prf(4*M`j'^2*q12-2*M`j'^2*q13-2*M`j'^2*q23-2*q12*q33,4*M`j'^2*q33-q33^2)+mbox1l(-1+n1,1+n2,1+n3,-1+n4)*prf(-2*M`j'^2*n3*q13-2*M`j'^2*n3*q23-n3*q12*q33,-4*M`j'^2*q33+4*M`j'^2*n1*q33+q33^2-n1*q33^2)+mbox1l(-2+n1,2+n2,n3,n4)*prf(4*M`j'^2*q12+4*M`j'^2*n2*q12+6*M`j'^2*q13+6*M`j'^2*n2*q13+6*M`j'^2*q23+6*M`j'^2*n2*q23+4*M`j'^2*q33+4*M`j'^2*n2*q33-2*q12*q33-2*n2*q12*q33-2*q13*q33-2*n2*q13*q33-2*q23*q33-2*n2*q23*q33-q33^2-n2*q33^2,-4*M`j'^2*q33+4*M`j'^2*n1*q33+q33^2-n1*q33^2)+mbox1l(-1+n1,1+n2,n3,n4)*(tmpprf(ep,1)*prf(-4*q12*q33-2*q13*q33-2*q23*q33,-4*M`j'^2*q33+4*M`j'^2*n1*q33+q33^2-n1*q33^2)+prf(4*M`j'^2*q12-4*M`j'^2*n1*q12+4*M`j'^2*n4*q12-6*M`j'^2*q13+2*M`j'^2*n1*q13-4*M`j'^2*n2*q13+2*M`j'^2*n4*q13-6*M`j'^2*q23+2*M`j'^2*n1*q23-4*M`j'^2*n2*q23+2*M`j'^2*n4*q23-8*M`j'^2*q33+4*M`j'^2*n1*q33-4*M`j'^2*n2*q33+8*q12*q33-2*n1*q12*q33-2*n2*q12*q33-2*n3*q12*q33-4*n4*q12*q33+6*q13*q33-2*n1*q13*q33-n3*q13*q33-2*n4*q13*q33+6*q23*q33-2*n1*q23*q33-n3*q23*q33-2*n4*q23*q33+2*q33^2-n1*q33^2+n2*q33^2,-4*M`j'^2*q33+4*M`j'^2*n1*q33+q33^2-n1*q33^2))+mbox1l(-2+n1,1+n2,1+n3,n4)*prf(6*M`j'^2*n3*q13+2*M`j'^2*n3*q23+4*M`j'^2*n3*q33-n3*q12*q33-2*n3*q13*q33-n3*q23*q33-n3*q33^2,-4*M`j'^2*q33+4*M`j'^2*n1*q33+q33^2-n1*q33^2)+mbox1l(-1+n1,2+n2,n3,n4)*prf(-4*M`j'^2*q13^2-4*M`j'^2*n2*q13^2-8*M`j'^2*q13*q23-8*M`j'^2*n2*q13*q23-4*M`j'^2*q23^2-4*M`j'^2*n2*q23^2+8*M`j'^2*q12*q33+8*M`j'^2*n2*q12*q33-4*q12^2*q33-4*n2*q12^2*q33-4*q12*q13*q33-4*n2*q12*q13*q33-4*q12*q23*q33-4*n2*q12*q23*q33-2*q12*q33^2-2*n2*q12*q33^2,-4*M`j'^2*q33+4*M`j'^2*n1*q33+q33^2-n1*q33^2)+mbox1l(-1+n1,1+n2,1+n3,n4)*prf(-4*M`j'^2*n3*q13^2-4*M`j'^2*n3*q13*q23+4*M`j'^2*n3*q12*q33-2*n3*q12*q13*q33-n3*q12*q33^2,-4*M`j'^2*q33+4*M`j'^2*n1*q33+q33^2-n1*q33^2);
	Identify,ifmatch->jump mbox1l(n1?pos_,n2?neg0_,n3?neg0_,n4?{,>1}) = mbox1l(1+n1,n2,n3,-2+n4)*prf(2*M`j'^2*n1,-4*M`j'^2*q33+4*M`j'^2*n4*q33+q33^2-n4*q33^2)+mbox1l(n1,1+n2,n3,-2+n4)*prf(2*M`j'^2*n2,-4*M`j'^2*q33+4*M`j'^2*n4*q33+q33^2-n4*q33^2)+mbox1l(n1,n2,1+n3,-2+n4)*prf(2*M`j'^2*n3,-4*M`j'^2*q33+4*M`j'^2*n4*q33+q33^2-n4*q33^2)+mbox1l(n1,n2,1+n3,-1+n4)*prf(4*M`j'^2*n3*q13,-4*M`j'^2*q33+4*M`j'^2*n4*q33+q33^2-n4*q33^2)+mbox1l(-1+n1,n2,n3,n4)*prf(-2*M`j'^2+q33,4*M`j'^2*q33-q33^2)+mbox1l(-1+n1,1+n2,n3,-1+n4)*prf(-2*M`j'^2*n2+n2*q33,-4*M`j'^2*q33+4*M`j'^2*n4*q33+q33^2-n4*q33^2)+mbox1l(-1+n1,n2,1+n3,-1+n4)*prf(-2*M`j'^2*n3+n3*q33,-4*M`j'^2*q33+4*M`j'^2*n4*q33+q33^2-n4*q33^2)+mbox1l(n1,n2,n3,-1+n4)*(tmpprf(ep,1)*prf(2,-4*M`j'^2+4*M`j'^2*n4+q33-n4*q33)+prf(-2*M`j'^2-2*M`j'^2*n1+2*M`j'^2*n4-5*q33+2*n1*q33+n2*q33+n3*q33+n4*q33,-4*M`j'^2*q33+4*M`j'^2*n4*q33+q33^2-n4*q33^2))+mbox1l(n1,1+n2,n3,-1+n4)*prf(4*M`j'^2*n2*q13+4*M`j'^2*n2*q23+2*n2*q12*q33,-4*M`j'^2*q33+4*M`j'^2*n4*q33+q33^2-n4*q33^2);
	Identify,ifmatch->jump mbox1l(n1?{,>1},n2?neg0_,n3?neg0_,n4?pos_) = mbox1l(-2+n1,1+n2,n3,n4)*prf(2*M`j'^2*n2,-4*M`j'^2*q33+4*M`j'^2*n1*q33+q33^2-n1*q33^2)+mbox1l(-2+n1,n2,1+n3,n4)*prf(2*M`j'^2*n3,-4*M`j'^2*q33+4*M`j'^2*n1*q33+q33^2-n1*q33^2)+mbox1l(-2+n1,n2,n3,1+n4)*prf(2*M`j'^2*n4,-4*M`j'^2*q33+4*M`j'^2*n1*q33+q33^2-n1*q33^2)+mbox1l(n1,n2,n3,-1+n4)*prf(-2*M`j'^2+q33,4*M`j'^2*q33-q33^2)+mbox1l(-1+n1,1+n2,n3,-1+n4)*prf(-2*M`j'^2*n2+n2*q33,-4*M`j'^2*q33+4*M`j'^2*n1*q33+q33^2-n1*q33^2)+mbox1l(-1+n1,n2,1+n3,-1+n4)*prf(-2*M`j'^2*n3+n3*q33,-4*M`j'^2*q33+4*M`j'^2*n1*q33+q33^2-n1*q33^2)+mbox1l(-1+n1,n2,n3,n4)*(tmpprf(ep,1)*prf(2,-4*M`j'^2+4*M`j'^2*n1+q33-n1*q33)+prf(-2*M`j'^2+2*M`j'^2*n1-2*M`j'^2*n4-5*q33+n1*q33+n2*q33+n3*q33+2*n4*q33,-4*M`j'^2*q33+4*M`j'^2*n1*q33+q33^2-n1*q33^2))+mbox1l(-1+n1,1+n2,n3,n4)*prf(-4*M`j'^2*n2*q13-4*M`j'^2*n2*q23-4*M`j'^2*n2*q33+2*n2*q12*q33+2*n2*q13*q33+2*n2*q23*q33+n2*q33^2,-4*M`j'^2*q33+4*M`j'^2*n1*q33+q33^2-n1*q33^2)+mbox1l(-1+n1,n2,1+n3,n4)*prf(-4*M`j'^2*n3*q13-4*M`j'^2*n3*q33+2*n3*q13*q33+n3*q33^2,-4*M`j'^2*q33+4*M`j'^2*n1*q33+q33^2-n1*q33^2);
	Identify,ifmatch->jump mbox1l(n1?pos_,n2?neg0_,n3?neg_,n4?pos_) = mbox1l(n1,-1+n2,2+n3,-1+n4)*prf(q12*q13+n3*q12*q13,-q13^2+n2*q13^2-2*q13*q23+2*n2*q13*q23-q23^2+n2*q23^2+2*q12*q33-2*n2*q12*q33)+mbox1l(n1,-2+n2,2+n3,n4)*prf(q13^2+n3*q13^2,-q13^2+n2*q13^2-2*q13*q23+2*n2*q13*q23-q23^2+n2*q23^2+2*q12*q33-2*n2*q12*q33)+mbox1l(n1,n2,1+n3,-1+n4)*prf(-(q12*q13)+q12*q23,-q13^2-2*q13*q23-q23^2+2*q12*q33)+mbox1l(-1+n1,n2,1+n3,n4)*prf(-(q12*q13)+q12*q23+q13*q23+q23^2-q12*q33,q13^2+2*q13*q23+q23^2-2*q12*q33)+mbox1l(-1+n1,-1+n2,2+n3,n4)*prf(-(q12*q13)-n3*q12*q13+q13*q23+n3*q13*q23-q12*q33-n3*q12*q33,-q13^2+n2*q13^2-2*q13*q23+2*n2*q13*q23-q23^2+n2*q23^2+2*q12*q33-2*n2*q12*q33)+mbox1l(n1,-1+n2,1+n3,n4)*prf(-2*q13^2+n2*q13^2-n3*q13^2-2*q13*q23+n2*q13*q23-n3*q13*q23+2*q12*q33-n2*q12*q33+n3*q12*q33,-q13^2+n2*q13^2-2*q13*q23+2*n2*q13*q23-q23^2+n2*q23^2+2*q12*q33-2*n2*q12*q33)+mbox1l(n1,-1+n2,2+n3,n4)*prf(2*q12*q13^2+2*n3*q12*q13^2+q12*q13*q33+n3*q12*q13*q33,-q13^2+n2*q13^2-2*q13*q23+2*n2*q13*q23-q23^2+n2*q23^2+2*q12*q33-2*n2*q12*q33)+mbox1l(n1,n2,1+n3,n4)*prf(-2*q12*q13^2-2*q12*q13*q23+2*q12^2*q33-q12*q13*q33+q12*q23*q33,-q13^2-2*q13*q23-q23^2+2*q12*q33);
	Identify,ifmatch->jump mbox1l(1,n2?neg_,0,1) = tmpprf(1,-1+2*ep+n2)*mbox1l(0,n2,0,2)*prf(-2*M`j'^2,q33)+tmpprf(1,-1+2*ep+n2)*mbox1l(0,1+n2,0,1)*prf(-2*M`j'^2*n2,q33)+tmpprf(1,-1+2*ep+n2)*mbox1l(0,1+n2,0,2)*prf(-4*M`j'^2*q12-2*M`j'^2*q13-2*M`j'^2*q23,q33)+mbox1l(1,1+n2,0,1)*(tmpprf(ep,-1+2*ep+n2)*prf(-4*q12-2*q13-2*q23,1)+tmpprf(1,-1+2*ep+n2)*prf(-4*n2*q12-2*n2*q13-2*n2*q23,1))+tmpprf(1,-1+2*ep+n2)*mbox1l(1,2+n2,0,0)*prf(-4*M`j'^2*q12-4*M`j'^2*n2*q12-2*M`j'^2*q13-2*M`j'^2*n2*q13-2*M`j'^2*q23-2*M`j'^2*n2*q23,q33)+tmpprf(1,-1+2*ep+n2)*mbox1l(2,n2,0,0)*prf(2*M`j'^2-q33,q33)+tmpprf(1,-1+2*ep+n2)*mbox1l(1,1+n2,0,0)*prf(2*M`j'^2*n2-n2*q33,q33)+tmpprf(1,-1+2*ep+n2)*mbox1l(2,1+n2,0,0)*prf(4*M`j'^2*q12-2*M`j'^2*q13-2*M`j'^2*q23-2*q12*q33,q33)+tmpprf(1,-1+2*ep+n2)*mbox1l(0,2+n2,0,1)*prf(4*M`j'^2*q12+4*M`j'^2*n2*q12+6*M`j'^2*q13+6*M`j'^2*n2*q13+6*M`j'^2*q23+6*M`j'^2*n2*q23+4*M`j'^2*q33+4*M`j'^2*n2*q33-2*q12*q33-2*n2*q12*q33-2*q13*q33-2*n2*q13*q33-2*q23*q33-2*n2*q23*q33-q33^2-n2*q33^2,q33)+tmpprf(1,-1+2*ep+n2)*mbox1l(1,2+n2,0,1)*prf(-4*M`j'^2*q13^2-4*M`j'^2*n2*q13^2-8*M`j'^2*q13*q23-8*M`j'^2*n2*q13*q23-4*M`j'^2*q23^2-4*M`j'^2*n2*q23^2+8*M`j'^2*q12*q33+8*M`j'^2*n2*q12*q33-4*q12^2*q33-4*n2*q12^2*q33-4*q12*q13*q33-4*n2*q12*q13*q33-4*q12*q23*q33-4*n2*q12*q23*q33-2*q12*q33^2-2*n2*q12*q33^2,q33);
	Identify,ifmatch->jump mbox1l(n1?pos_,n2?neg0_,n3?{,>1},n4?neg_) = mbox1l(1+n1,-1+n2,-1+n3,1+n4)*prf(n1*q13,-q12+n3*q12)+mbox1l(-1+n1,1+n2,-1+n3,1+n4)*prf(-(n2*q12)-n2*q23,-q12+n3*q12)+mbox1l(1+n1,n2,-1+n3,1+n4)*prf(4*n1*q13+n1*q33,-1+n3)+mbox1l(n1,1+n2,-1+n3,1+n4)*prf(-2*n2*q12+2*n2*q13-2*n2*q23+n2*q33,-1+n3)+mbox1l(n1,-1+n2,-1+n3,2+n4)*prf(q13+n4*q13+q33+n4*q33,-q12+n3*q12)+mbox1l(-1+n1,n2,-1+n3,2+n4)*prf(-q12-n4*q12+2*q13+2*n4*q13-q23-n4*q23+q33+n4*q33,-q12+n3*q12)+mbox1l(1+n1,n2,-2+n3,1+n4)*prf(2*M`j'^2*n1*q12-4*M`j'^2*n1*q13-2*n1*q12*q13-n1*q12*q33,-2*M`j'^2*q12+2*M`j'^2*n3*q12)+mbox1l(n1,1+n2,-2+n3,1+n4)*prf(2*M`j'^2*n2*q12-2*n2*q12*q13+4*M`j'^2*n2*q23-n2*q12*q33,-2*M`j'^2*q12+2*M`j'^2*n3*q12)+mbox1l(n1,n2,-2+n3,2+n4)*prf(2*M`j'^2*q12+2*M`j'^2*n4*q12-4*M`j'^2*q13-4*M`j'^2*n4*q13-2*q12*q13-2*n4*q12*q13-4*M`j'^2*q33-4*M`j'^2*n4*q33-q12*q33-n4*q12*q33,-2*M`j'^2*q12+2*M`j'^2*n3*q12)+mbox1l(n1,n2,-1+n3,1+n4)*(tmpprf(ep,1)*prf(-4*q12*q13-2*q12*q33,-2*M`j'^2*q12+2*M`j'^2*n3*q12)+prf(-2*M`j'^2*q12-2*M`j'^2*n1*q12+2*M`j'^2*n3*q12-2*M`j'^2*q13+2*M`j'^2*n1*q13-2*M`j'^2*n4*q13+10*q12*q13-2*n1*q12*q13-2*n2*q12*q13-4*n3*q12*q13-2*n4*q12*q13+2*M`j'^2*q23-2*M`j'^2*n2*q23+2*M`j'^2*n4*q23+5*q12*q33-n1*q12*q33-n2*q12*q33-2*n3*q12*q33-n4*q12*q33,-2*M`j'^2*q12+2*M`j'^2*n3*q12))+mbox1l(n1,n2,-1+n3,2+n4)*prf(12*M`j'^2*q12*q13+12*M`j'^2*n4*q12*q13-4*M`j'^2*q13^2-4*M`j'^2*n4*q13^2-4*q12*q13^2-4*n4*q12*q13^2+4*M`j'^2*q13*q23+4*M`j'^2*n4*q13*q23+6*M`j'^2*q12*q33+6*M`j'^2*n4*q12*q33-2*M`j'^2*q13*q33-2*M`j'^2*n4*q13*q33-4*q12*q13*q33-4*n4*q12*q13*q33+2*M`j'^2*q23*q33+2*M`j'^2*n4*q23*q33-q12*q33^2-n4*q12*q33^2,-2*M`j'^2*q12+2*M`j'^2*n3*q12);
	Identify,ifmatch->jump mbox1l(n1?pos_,n2?neg_,n3?{,>1},n4?neg0_) = mbox1l(1+n1,n2,-1+n3,n4)*prf(-n1,-1+n3)+mbox1l(1+n1,1+n2,-2+n3,n4)*prf(n1,-1+n3)+mbox1l(n1,2+n2,-2+n3,n4)*prf(1+n2,-1+n3)+mbox1l(n1,1+n2,-1+n3,n4)*prf(-2-n2+n3,-1+n3)+mbox1l(n1,n2,-1+n3,1+n4)*prf(-n4,-1+n3)+mbox1l(n1,1+n2,-2+n3,1+n4)*prf(n4,-1+n3)+mbox1l(1+n1,1+n2,-1+n3,n4)*prf(-2*n1*q12,-1+n3)+mbox1l(n1,1+n2,-1+n3,1+n4)*prf(-2*n4*q12-2*n4*q23,-1+n3);
	Identify,ifmatch->jump mbox1l(n1?{,>1},n2?neg0_,n3?pos_,n4?neg_) = mbox1l(n1,-1+n2,n3,1+n4)*prf(-q13,q12)+mbox1l(n1,n2,-1+n3,1+n4)*prf(q13,q12)+mbox1l(-1+n1,1+n2,-1+n3,1+n4)*prf(-(n2*q23),-q12+n1*q12)+mbox1l(-1+n1,n2,n3,1+n4)*prf(-2*q12+n1*q12-n4*q12-q23+n2*q23-n4*q23,-q12+n1*q12)+mbox1l(-2+n1,n2,n3,2+n4)*prf(q12+n4*q12+q23+n4*q23,-q12+n1*q12)+mbox1l(n1,n2,n3,1+n4)*prf(-2*q13-q33,1)+mbox1l(-1+n1,-1+n2,n3,2+n4)*prf(-q13-n4*q13-q33-n4*q33,-q12+n1*q12)+mbox1l(-1+n1,n2,-1+n3,2+n4)*prf(q13+n4*q13+q33+n4*q33,-q12+n1*q12)+mbox1l(-1+n1,n2,n3,2+n4)*prf(-2*q12*q13-2*n4*q12*q13-2*q13*q23-2*n4*q13*q23-q12*q33-n4*q12*q33-q23*q33-n4*q23*q33,-q12+n1*q12);
	Identify,ifmatch->jump mbox1l(n1?pos_,n2?neg0_,n3?{,>1},n4?neg0_) = mbox1l(1+n1,n2,-1+n3,n4)*prf(-n1,-1+n3)+mbox1l(1+n1,n2,-2+n3,n4)*prf(n1,-2*M`j'^2+2*M`j'^2*n3)+mbox1l(n1,1+n2,-1+n3,n4)*prf(-n2,-1+n3)+mbox1l(n1,1+n2,-2+n3,n4)*prf(n2,-2*M`j'^2+2*M`j'^2*n3)+mbox1l(n1,n2,-2+n3,1+n4)*prf(n4,-2*M`j'^2+2*M`j'^2*n3)+mbox1l(n1,n2,-1+n3,n4)*(tmpprf(ep,1)*prf(1,-M`j'^2+M`j'^2*n3)+prf(-6+n1+n2+2*n3+n4,-2*M`j'^2+2*M`j'^2*n3))+mbox1l(n1,n2,-1+n3,1+n4)*prf(-2*M`j'^2*n4+2*n4*q13+n4*q33,-2*M`j'^2+2*M`j'^2*n3);
	Identify,ifmatch->jump mbox1l(n1?pos_,n2?neg0_,n3?{,>1},n4?neg0_) = mbox1l(2+n1,n2,-2+n3,n4)*prf(1+n1,-1+n3)+mbox1l(n1,1+n2,-1+n3,n4)*prf(-n2,-1+n3)+mbox1l(1+n1,1+n2,-2+n3,n4)*prf(n2,-1+n3)+mbox1l(1+n1,n2,-1+n3,n4)*prf(-2-n1+n3,-1+n3)+mbox1l(n1,n2,-1+n3,1+n4)*prf(-n4,-1+n3)+mbox1l(1+n1,n2,-2+n3,1+n4)*prf(n4,-1+n3)+mbox1l(1+n1,1+n2,-1+n3,n4)*prf(-2*n2*q12,-1+n3)+mbox1l(1+n1,n2,-1+n3,1+n4)*prf(2*n4*q13,-1+n3);
	Identify,ifmatch->jump mbox1l(n1?pos_,n2?neg0_,n3?pos_,n4?neg_) = mbox1l(1+n1,-1+n2,-1+n3,1+n4)*prf(n1*q13,-q12+n2*q12)+mbox1l(n1,-1+n2,n3,1+n4)*prf(q13-n1*q13+n4*q13,-q12+n2*q12)+mbox1l(n1,n2,-1+n3,1+n4)*prf(-q23,q12)+mbox1l(-1+n1,n2,n3,1+n4)*prf(q12+q23,q12)+mbox1l(n1,n2,n3,1+n4)*prf(-2*q13-q33,1)+mbox1l(-1+n1,-1+n2,n3,2+n4)*prf(-2*q13-2*n4*q13-q33-n4*q33,-q12+n2*q12)+mbox1l(n1,-1+n2,-1+n3,2+n4)*prf(q13+n4*q13+q33+n4*q33,-q12+n2*q12)+mbox1l(n1,-1+n2,n3,2+n4)*prf(2*q13^2+2*n4*q13^2+q13*q33+n4*q13*q33,-q12+n2*q12);
	Identify,ifmatch->jump mbox1l(n1?pos_,n2?neg0_,n3?pos_,n4?neg0_) = mbox1l(1+n1,n2,-1+n3,n4)*prf(n1,n1-n2)+mbox1l(n1,1+n2,-1+n3,n4)*prf(-n2,n1-n2)+mbox1l(n1,-1+n2,n3,1+n4)*prf(-(n4*q13),n1*q12-n2*q12)+mbox1l(-1+n1,n2,n3,1+n4)*prf(-(n4*q12)-n4*q23,n1*q12-n2*q12)+mbox1l(n1,n2,-1+n3,1+n4)*prf(n4*q12+n4*q13+n4*q23,n1*q12-n2*q12);
	Identify,ifmatch->jump mbox1l(n1?pos_,n2?{,>1},n3?neg0_,n4?neg_) = mbox1l(1+n1,-2+n2,n3,1+n4)*prf(-(M`j'^2*n1*q13)-M`j'^2*n1*q23-M`j'^2*n1*q33,-4*M`j'^2*q12+4*M`j'^2*n2*q12+2*q12^2-2*n2*q12^2)+mbox1l(n1,-2+n2,1+n3,1+n4)*prf(-(M`j'^2*n3*q13)-M`j'^2*n3*q23-M`j'^2*n3*q33,-4*M`j'^2*q12+4*M`j'^2*n2*q12+2*q12^2-2*n2*q12^2)+mbox1l(n1,-1+n2,1+n3,1+n4)*prf(M`j'^2*n3*q13+M`j'^2*n3*q23+M`j'^2*n3*q33,-2*M`j'^2+2*M`j'^2*n2+q12-n2*q12)+mbox1l(-1+n1,n2,n3,1+n4)*prf(4*M`j'^2*q12-2*q12^2+3*M`j'^2*q13-2*q12*q13+3*M`j'^2*q23-2*q12*q23+M`j'^2*q33-q12*q33,4*M`j'^2*q12-2*q12^2)+mbox1l(-1+n1,-1+n2,1+n3,1+n4)*prf(3*M`j'^2*n3*q13-2*n3*q12*q13-M`j'^2*n3*q23+M`j'^2*n3*q33-n3*q12*q33,-4*M`j'^2*q12+4*M`j'^2*n2*q12+2*q12^2-2*n2*q12^2)+mbox1l(n1,-1+n2,n3,1+n4)*(tmpprf(ep,1)*prf(-2*q12*q13-2*q12*q23-2*q12*q33,-4*M`j'^2*q12+4*M`j'^2*n2*q12+2*q12^2-2*n2*q12^2)+prf(7*M`j'^2*q13+M`j'^2*n1*q13-3*M`j'^2*n2*q13-2*M`j'^2*n3*q13+4*M`j'^2*n4*q13+q12*q13-2*n1*q12*q13-3*n4*q12*q13+3*M`j'^2*q23+M`j'^2*n1*q23-3*M`j'^2*n2*q23+2*M`j'^2*n3*q23+3*q12*q23-2*n1*q12*q23-2*n3*q12*q23-n4*q12*q23+M`j'^2*q33+M`j'^2*n1*q33-M`j'^2*n2*q33+4*q12*q33-2*n1*q12*q33-n2*q12*q33-n3*q12*q33-n4*q12*q33,-4*M`j'^2*q12+4*M`j'^2*n2*q12+2*q12^2-2*n2*q12^2))+mbox1l(n1,-1+n2,-1+n3,2+n4)*prf(-q13^2-n4*q13^2-2*q13*q23-2*n4*q13*q23-q23^2-n4*q23^2+2*q12*q33+2*n4*q12*q33,-2*q12^2+2*n2*q12^2)+mbox1l(n1,-2+n2,n3,2+n4)*prf(-(M`j'^2*q12*q13)-M`j'^2*n4*q12*q13+2*M`j'^2*q13^2+2*M`j'^2*n4*q13^2-q12*q13^2-n4*q12*q13^2-M`j'^2*q12*q23-M`j'^2*n4*q12*q23+2*M`j'^2*q13*q23+2*M`j'^2*n4*q13*q23-q12*q13*q23-n4*q12*q13*q23-M`j'^2*q12*q33-M`j'^2*n4*q12*q33,-4*M`j'^2*q12^2+4*M`j'^2*n2*q12^2+2*q12^3-2*n2*q12^3)+mbox1l(-1+n1,-1+n2,n3,2+n4)*prf(-3*M`j'^2*q12*q13-3*M`j'^2*n4*q12*q13+q12^2*q13+n4*q12^2*q13+M`j'^2*q12*q23+M`j'^2*n4*q12*q23-q12^2*q23-n4*q12^2*q23+2*M`j'^2*q13*q23+2*M`j'^2*n4*q13*q23-q12*q13*q23-n4*q12*q13*q23+2*M`j'^2*q23^2+2*M`j'^2*n4*q23^2-q12*q23^2-n4*q12*q23^2-3*M`j'^2*q12*q33-3*M`j'^2*n4*q12*q33+q12^2*q33+n4*q12^2*q33,-4*M`j'^2*q12^2+4*M`j'^2*n2*q12^2+2*q12^3-2*n2*q12^3)+mbox1l(n1,-1+n2,n3,2+n4)*prf(2*M`j'^2*q13^2+2*M`j'^2*n4*q13^2-2*q12*q13^2-2*n4*q12*q13^2-2*q12*q13*q23-2*n4*q12*q13*q23-2*M`j'^2*q23^2-2*M`j'^2*n4*q23^2+2*M`j'^2*q13*q33+2*M`j'^2*n4*q13*q33-3*q12*q13*q33-3*n4*q12*q13*q33-2*M`j'^2*q23*q33-2*M`j'^2*n4*q23*q33-q12*q23*q33-n4*q12*q23*q33-q12*q33^2-n4*q12*q33^2,-4*M`j'^2*q12+4*M`j'^2*n2*q12+2*q12^2-2*n2*q12^2);
	Identify,ifmatch->jump mbox1l(n1?pos_,n2?{,>1},n3?neg_,n4?neg0_) = mbox1l(-1+n1,n2,1+n3,n4)*prf(M`j'^2,4*M`j'^2-2*q12)+mbox1l(1+n1,-2+n2,1+n3,n4)*prf(M`j'^2*n1,-4*M`j'^2+4*M`j'^2*n2+2*q12-2*n2*q12)+mbox1l(-1+n1,-1+n2,2+n3,n4)*prf(M`j'^2+M`j'^2*n3,-4*M`j'^2+4*M`j'^2*n2+2*q12-2*n2*q12)+mbox1l(n1,-2+n2,2+n3,n4)*prf(M`j'^2+M`j'^2*n3,-4*M`j'^2+4*M`j'^2*n2+2*q12-2*n2*q12)+mbox1l(n1,-1+n2,2+n3,n4)*prf(-(M`j'^2*q12)-M`j'^2*n3*q12,-2*M`j'^2+2*M`j'^2*n2+q12-n2*q12)+mbox1l(n1,-1+n2,1+n3,n4)*(tmpprf(ep,1)*prf(q12,-2*M`j'^2+2*M`j'^2*n2+q12-n2*q12)+prf(-5*M`j'^2-M`j'^2*n1+3*M`j'^2*n2-2*M`j'^2*n3-2*q12+2*n1*q12+2*n3*q12+n4*q12,-4*M`j'^2+4*M`j'^2*n2+2*q12-2*n2*q12))+mbox1l(n1,-2+n2,1+n3,1+n4)*prf(M`j'^2*n4*q12-2*M`j'^2*n4*q13+n4*q12*q13,-4*M`j'^2*q12+4*M`j'^2*n2*q12+2*q12^2-2*n2*q12^2)+mbox1l(n1,-1+n2,n3,1+n4)*prf(n4*q13+n4*q23,-2*q12+2*n2*q12)+mbox1l(-1+n1,-1+n2,1+n3,1+n4)*prf(-(M`j'^2*n4*q12)+n4*q12^2-2*M`j'^2*n4*q23+n4*q12*q23,-4*M`j'^2*q12+4*M`j'^2*n2*q12+2*q12^2-2*n2*q12^2)+mbox1l(n1,-1+n2,1+n3,1+n4)*prf(-2*M`j'^2*n4*q13+2*n4*q12*q13+2*M`j'^2*n4*q23+n4*q12*q33,-4*M`j'^2+4*M`j'^2*n2+2*q12-2*n2*q12);
	Identify,ifmatch->jump mbox1l(n1?{,>1},n2?pos_,n3?neg0_,n4?neg_) = mbox1l(-2+n1,1+n2,n3,1+n4)*prf(-(M`j'^2*n2*q13)-M`j'^2*n2*q23-M`j'^2*n2*q33,-4*M`j'^2*q12+4*M`j'^2*n1*q12+2*q12^2-2*n1*q12^2)+mbox1l(-2+n1,n2,1+n3,1+n4)*prf(-(M`j'^2*n3*q13)-M`j'^2*n3*q23-M`j'^2*n3*q33,-4*M`j'^2*q12+4*M`j'^2*n1*q12+2*q12^2-2*n1*q12^2)+mbox1l(-1+n1,n2,1+n3,1+n4)*prf(M`j'^2*n3*q13+M`j'^2*n3*q23+M`j'^2*n3*q33,-2*M`j'^2+2*M`j'^2*n1+q12-n1*q12)+mbox1l(n1,-1+n2,n3,1+n4)*prf(-(M`j'^2*q13)-M`j'^2*q23+M`j'^2*q33-q12*q33,4*M`j'^2*q12-2*q12^2)+mbox1l(-1+n1,-1+n2,1+n3,1+n4)*prf(3*M`j'^2*n3*q13-2*n3*q12*q13-M`j'^2*n3*q23+M`j'^2*n3*q33-n3*q12*q33,-4*M`j'^2*q12+4*M`j'^2*n1*q12+2*q12^2-2*n1*q12^2)+mbox1l(-1+n1,n2,n3,1+n4)*(tmpprf(ep,1)*prf(-2*q12*q13-2*q12*q23-2*q12*q33,-4*M`j'^2*q12+4*M`j'^2*n1*q12+2*q12^2-2*n1*q12^2)+prf(-8*M`j'^2*q12+4*M`j'^2*n1*q12-4*M`j'^2*n4*q12+4*q12^2-2*n1*q12^2+2*n4*q12^2-M`j'^2*q13+M`j'^2*n1*q13+M`j'^2*n2*q13-2*M`j'^2*n3*q13+5*q12*q13-2*n1*q12*q13-2*n2*q12*q13-n4*q12*q13-5*M`j'^2*q23+M`j'^2*n1*q23+M`j'^2*n2*q23+2*M`j'^2*n3*q23-4*M`j'^2*n4*q23+7*q12*q23-2*n1*q12*q23-2*n2*q12*q23-2*n3*q12*q23+n4*q12*q23+M`j'^2*q33-M`j'^2*n1*q33+M`j'^2*n2*q33+4*q12*q33-n1*q12*q33-2*n2*q12*q33-n3*q12*q33-n4*q12*q33,-4*M`j'^2*q12+4*M`j'^2*n1*q12+2*q12^2-2*n1*q12^2))+mbox1l(-1+n1,n2,-1+n3,2+n4)*prf(-q13^2-n4*q13^2-2*q13*q23-2*n4*q13*q23-q23^2-n4*q23^2+2*q12*q33+2*n4*q12*q33,-2*q12^2+2*n1*q12^2)+mbox1l(-2+n1,n2,n3,2+n4)*prf(4*M`j'^2*q12^2+4*M`j'^2*n4*q12^2-2*q12^3-2*n4*q12^3+M`j'^2*q12*q13+M`j'^2*n4*q12*q13-q12^2*q13-n4*q12^2*q13+5*M`j'^2*q12*q23+5*M`j'^2*n4*q12*q23-3*q12^2*q23-3*n4*q12^2*q23+2*M`j'^2*q13*q23+2*M`j'^2*n4*q13*q23-q12*q13*q23-n4*q12*q13*q23+2*M`j'^2*q23^2+2*M`j'^2*n4*q23^2-q12*q23^2-n4*q12*q23^2-M`j'^2*q12*q33-M`j'^2*n4*q12*q33,-4*M`j'^2*q12^2+4*M`j'^2*n1*q12^2+2*q12^3-2*n1*q12^3)+mbox1l(-1+n1,-1+n2,n3,2+n4)*prf(-(M`j'^2*q12*q13)-M`j'^2*n4*q12*q13+2*M`j'^2*q13^2+2*M`j'^2*n4*q13^2-q12*q13^2-n4*q12*q13^2-M`j'^2*q12*q23-M`j'^2*n4*q12*q23+2*M`j'^2*q13*q23+2*M`j'^2*n4*q13*q23-q12*q13*q23-n4*q12*q13*q23-3*M`j'^2*q12*q33-3*M`j'^2*n4*q12*q33+q12^2*q33+n4*q12^2*q33,-4*M`j'^2*q12^2+4*M`j'^2*n1*q12^2+2*q12^3-2*n1*q12^3)+mbox1l(-1+n1,n2,n3,2+n4)*prf(2*M`j'^2*q13^2+2*M`j'^2*n4*q13^2-2*q12*q13^2-2*n4*q12*q13^2-2*q12*q13*q23-2*n4*q12*q13*q23-2*M`j'^2*q23^2-2*M`j'^2*n4*q23^2+2*M`j'^2*q13*q33+2*M`j'^2*n4*q13*q33-3*q12*q13*q33-3*n4*q12*q13*q33-2*M`j'^2*q23*q33-2*M`j'^2*n4*q23*q33-q12*q23*q33-n4*q12*q23*q33-q12*q33^2-n4*q12*q33^2,-4*M`j'^2*q12+4*M`j'^2*n1*q12+2*q12^2-2*n1*q12^2);
	Identify,ifmatch->jump mbox1l(n1?{,>1},n2?pos_,n3?neg_,n4?neg0_) = mbox1l(n1,-1+n2,1+n3,n4)*prf(M`j'^2,4*M`j'^2-2*q12)+mbox1l(-2+n1,1+n2,1+n3,n4)*prf(M`j'^2*n2,-4*M`j'^2+4*M`j'^2*n1+2*q12-2*n1*q12)+mbox1l(-2+n1,n2,2+n3,n4)*prf(M`j'^2+M`j'^2*n3,-4*M`j'^2+4*M`j'^2*n1+2*q12-2*n1*q12)+mbox1l(-1+n1,-1+n2,2+n3,n4)*prf(M`j'^2+M`j'^2*n3,-4*M`j'^2+4*M`j'^2*n1+2*q12-2*n1*q12)+mbox1l(-1+n1,n2,2+n3,n4)*prf(-(M`j'^2*q12)-M`j'^2*n3*q12,-2*M`j'^2+2*M`j'^2*n1+q12-n1*q12)+mbox1l(-1+n1,n2,1+n3,n4)*(tmpprf(ep,1)*prf(q12,-2*M`j'^2+2*M`j'^2*n1+q12-n1*q12)+prf(-5*M`j'^2+3*M`j'^2*n1-M`j'^2*n2-2*M`j'^2*n3-2*q12+2*n2*q12+2*n3*q12+n4*q12,-4*M`j'^2+4*M`j'^2*n1+2*q12-2*n1*q12))+mbox1l(-1+n1,-1+n2,1+n3,1+n4)*prf(-(M`j'^2*n4*q12)-2*M`j'^2*n4*q13+n4*q12*q13,4*M`j'^2*q12-4*M`j'^2*n1*q12-2*q12^2+2*n1*q12^2)+mbox1l(-1+n1,n2,n3,1+n4)*prf(-2*n4*q12-n4*q13-n4*q23,-2*q12+2*n1*q12)+mbox1l(-2+n1,n2,1+n3,1+n4)*prf(-3*M`j'^2*n4*q12+n4*q12^2-2*M`j'^2*n4*q23+n4*q12*q23,4*M`j'^2*q12-4*M`j'^2*n1*q12-2*q12^2+2*n1*q12^2)+mbox1l(-1+n1,n2,1+n3,1+n4)*prf(-2*M`j'^2*n4*q13+2*n4*q12*q13+2*M`j'^2*n4*q23+n4*q12*q33,-4*M`j'^2+4*M`j'^2*n1+2*q12-2*n1*q12);
	Identify,ifmatch->jump mbox1l(n1?pos_,n2?{,>1},n3?neg0_,n4?neg0_) = mbox1l(1+n1,-2+n2,n3,n4)*prf(M`j'^2*n1,-4*M`j'^2*q12+4*M`j'^2*n2*q12+2*q12^2-2*n2*q12^2)+mbox1l(n1,-1+n2,1+n3,n4)*prf(-(M`j'^2*n3),-2*M`j'^2+2*M`j'^2*n2+q12-n2*q12)+mbox1l(n1,-2+n2,1+n3,n4)*prf(M`j'^2*n3,-4*M`j'^2*q12+4*M`j'^2*n2*q12+2*q12^2-2*n2*q12^2)+mbox1l(n1,-2+n2,n3,1+n4)*prf(M`j'^2*n4,-4*M`j'^2*q12+4*M`j'^2*n2*q12+2*q12^2-2*n2*q12^2)+mbox1l(-1+n1,n2,n3,n4)*prf(-M`j'^2+q12,4*M`j'^2*q12-2*q12^2)+mbox1l(-1+n1,-1+n2,1+n3,n4)*prf(-(M`j'^2*n3)+n3*q12,-4*M`j'^2*q12+4*M`j'^2*n2*q12+2*q12^2-2*n2*q12^2)+mbox1l(-1+n1,-1+n2,n3,1+n4)*prf(-(M`j'^2*n4)+n4*q12,-4*M`j'^2*q12+4*M`j'^2*n2*q12+2*q12^2-2*n2*q12^2)+mbox1l(n1,-1+n2,n3,n4)*(tmpprf(ep,1)*prf(1,-2*M`j'^2+2*M`j'^2*n2+q12-n2*q12)+prf(-M`j'^2-M`j'^2*n1+M`j'^2*n2-5*q12+2*n1*q12+n2*q12+n3*q12+n4*q12,-4*M`j'^2*q12+4*M`j'^2*n2*q12+2*q12^2-2*n2*q12^2))+mbox1l(n1,-1+n2,n3,1+n4)*prf(2*M`j'^2*n4*q13+2*M`j'^2*n4*q23+n4*q12*q33,-4*M`j'^2*q12+4*M`j'^2*n2*q12+2*q12^2-2*n2*q12^2);
	Identify,ifmatch->jump mbox1l(n1?{,>1},n2?pos_,n3?neg0_,n4?neg0_) = mbox1l(-2+n1,1+n2,n3,n4)*prf(M`j'^2*n2,-4*M`j'^2*q12+4*M`j'^2*n1*q12+2*q12^2-2*n1*q12^2)+mbox1l(-1+n1,n2,1+n3,n4)*prf(-(M`j'^2*n3),-2*M`j'^2+2*M`j'^2*n1+q12-n1*q12)+mbox1l(-2+n1,n2,1+n3,n4)*prf(M`j'^2*n3,-4*M`j'^2*q12+4*M`j'^2*n1*q12+2*q12^2-2*n1*q12^2)+mbox1l(-2+n1,n2,n3,1+n4)*prf(M`j'^2*n4,-4*M`j'^2*q12+4*M`j'^2*n1*q12+2*q12^2-2*n1*q12^2)+mbox1l(n1,-1+n2,n3,n4)*prf(-M`j'^2+q12,4*M`j'^2*q12-2*q12^2)+mbox1l(-1+n1,-1+n2,1+n3,n4)*prf(-(M`j'^2*n3)+n3*q12,-4*M`j'^2*q12+4*M`j'^2*n1*q12+2*q12^2-2*n1*q12^2)+mbox1l(-1+n1,-1+n2,n3,1+n4)*prf(-(M`j'^2*n4)+n4*q12,-4*M`j'^2*q12+4*M`j'^2*n1*q12+2*q12^2-2*n1*q12^2)+mbox1l(-1+n1,n2,n3,n4)*(tmpprf(ep,1)*prf(1,-2*M`j'^2+2*M`j'^2*n1+q12-n1*q12)+prf(-M`j'^2+M`j'^2*n1-M`j'^2*n2-5*q12+n1*q12+2*n2*q12+n3*q12+n4*q12,-4*M`j'^2*q12+4*M`j'^2*n1*q12+2*q12^2-2*n1*q12^2))+mbox1l(-1+n1,n2,n3,1+n4)*prf(-4*M`j'^2*n4*q12+2*n4*q12^2-2*M`j'^2*n4*q13+2*n4*q12*q13-2*M`j'^2*n4*q23+2*n4*q12*q23+n4*q12*q33,-4*M`j'^2*q12+4*M`j'^2*n1*q12+2*q12^2-2*n1*q12^2);
	Identify,ifmatch->jump mbox1l(n1?pos_,n2?pos_,n3?neg0_,n4?neg_) = mbox1l(n1,-1+n2,n3,1+n4)*prf(-q13,q12)+mbox1l(-1+n1,n2,n3,1+n4)*prf(q12+q23,q12)+mbox1l(n1,n2,-1+n3,1+n4)*prf(-2*q13+n3*q13-n4*q13+2*q23-n3*q23+n4*q23,-q12+n3*q12)+mbox1l(n1,n2,n3,1+n4)*prf(-2*q13-q33,1)+mbox1l(n1,n2,-2+n3,2+n4)*prf(q13^2+n4*q13^2+2*q13*q23+2*n4*q13*q23+q23^2+n4*q23^2-2*q12*q33-2*n4*q12*q33,-q12^2+n3*q12^2)+mbox1l(n1,-1+n2,-1+n3,2+n4)*prf(-q13^2-n4*q13^2-q13*q23-n4*q13*q23+q12*q33+n4*q12*q33,-q12^2+n3*q12^2)+mbox1l(-1+n1,n2,-1+n3,2+n4)*prf(q12*q13+n4*q12*q13-q12*q23-n4*q12*q23-q13*q23-n4*q13*q23-q23^2-n4*q23^2+q12*q33+n4*q12*q33,-q12^2+n3*q12^2)+mbox1l(n1,n2,-1+n3,2+n4)*prf(-2*q13^2-2*n4*q13^2-2*q13*q23-2*n4*q13*q23+2*q12*q33+2*n4*q12*q33-q13*q33-n4*q13*q33+q23*q33+n4*q23*q33,-q12+n3*q12);
	Identify,ifmatch->jump mbox1l(1,1,n3?neg_,0) = tmpprf(1,-1+2*ep+n3)*mbox1l(0,2,n3,0)*prf(-M`j'^2,q12)+tmpprf(1,-1+2*ep+n3)*mbox1l(0,2,1+n3,0)*prf(M`j'^2,1)+tmpprf(1,-1+2*ep+n3)*mbox1l(2,0,1+n3,0)*prf(M`j'^2,1)+tmpprf(1,-1+2*ep+n3)*mbox1l(0,1,1+n3,0)*prf(-(M`j'^2*n3),q12)+tmpprf(1,-1+2*ep+n3)*mbox1l(0,1,2+n3,0)*prf(M`j'^2+M`j'^2*n3,1)+tmpprf(1,-1+2*ep+n3)*mbox1l(1,0,2+n3,0)*prf(M`j'^2+M`j'^2*n3,1)+tmpprf(1,-1+2*ep+n3)*mbox1l(2,0,n3,0)*prf(M`j'^2-q12,q12)+mbox1l(1,1,1+n3,0)*(tmpprf(ep,-1+2*ep+n3)*prf(2*q12,1)+tmpprf(1,-1+2*ep+n3)*prf(2*n3*q12,1))+tmpprf(1,-1+2*ep+n3)*mbox1l(1,0,1+n3,0)*prf(M`j'^2*n3-n3*q12,q12)+tmpprf(1,-1+2*ep+n3)*mbox1l(1,1,2+n3,0)*prf(-2*M`j'^2*q12-2*M`j'^2*n3*q12,1);
	Identify,ifmatch->jump mbox1l(n1?neg_,n2?pos_,n3?pos_,n4?{,>1}) = mbox1l(1+n1,-1+n2,1+n3,-1+n4)*prf(-(n3*q13),-q12+n4*q12-q23+n4*q23)+mbox1l(2+n1,n2,n3,-2+n4)*prf(2*q12*q13+2*n1*q12*q13,-2*q12*q13+2*n4*q12*q13-2*q13*q23+2*n4*q13*q23-q12*q33+n4*q12*q33-q23*q33+n4*q23*q33)+mbox1l(1+n1,n2,-1+n3,n4)*prf(q33,2*q13+q33)+mbox1l(2+n1,-1+n2,n3,-1+n4)*prf(-(q13*q33)-n1*q13*q33,-2*q12*q13+2*n4*q12*q13-2*q13*q23+2*n4*q13*q23-q12*q33+n4*q12*q33-q23*q33+n4*q23*q33)+mbox1l(2+n1,n2,-1+n3,-1+n4)*prf(q12*q33+n1*q12*q33+q13*q33+n1*q13*q33,-2*q12*q13+2*n4*q12*q13-2*q13*q23+2*n4*q13*q23-q12*q33+n4*q12*q33-q23*q33+n4*q23*q33)+mbox1l(1+n1,1+n2,-1+n3,-1+n4)*prf(2*n2*q13^2+2*n2*q13*q23-n2*q12*q33+n2*q13*q33,-2*q12*q13+2*n4*q12*q13-2*q13*q23+2*n4*q13*q23-q12*q33+n4*q12*q33-q23*q33+n4*q23*q33)+mbox1l(1+n1,n2,n3,-1+n4)*prf(-4*q12*q13-2*n1*q12*q13+2*n4*q12*q13-2*n2*q13^2+2*n3*q13^2-2*q13*q23-2*n2*q13*q23+2*n4*q13*q23-q12*q33-n1*q12*q33+n2*q12*q33-n2*q13*q33+n3*q13*q33,-2*q12*q13+2*n4*q12*q13-2*q13*q23+2*n4*q13*q23-q12*q33+n4*q12*q33-q23*q33+n4*q23*q33);
	Identify,ifmatch->jump mbox1l(n1?neg_,n2?pos_,n3?{,>1},n4?pos_) = mbox1l(1+n1,n2,n3,-1+n4)*prf(2*q12^2+2*q12*q13+2*q12*q23+q12*q33,2*q12^2+4*q12*q23+2*q23^2)+mbox1l(1+n1,1+n2,-1+n3,-1+n4)*prf(2*n2*q12*q13+n2*q12*q33,-2*q12^2+2*n3*q12^2-4*q12*q23+4*n3*q12*q23-2*q23^2+2*n3*q23^2)+mbox1l(1+n1,n2,-2+n3,1+n4)*prf(2*n4*q12^2+2*n4*q12*q13+2*n4*q12*q23+n4*q12*q33,-2*q12^2+2*n3*q12^2-4*q12*q23+4*n3*q12*q23-2*q23^2+2*n3*q23^2)+mbox1l(2+n1,n2,-1+n3,-1+n4)*prf(-4*M`j'^2*q12^3-4*M`j'^2*n1*q12^3-8*M`j'^2*q12^2*q13-8*M`j'^2*n1*q12^2*q13+4*q12^3*q13+4*n1*q12^3*q13+4*q12^2*q13^2+4*n1*q12^2*q13^2+4*q12^2*q13*q23+4*n1*q12^2*q13*q23+4*M`j'^2*q12*q23^2+4*M`j'^2*n1*q12*q23^2-2*M`j'^2*q12^2*q33-2*M`j'^2*n1*q12^2*q33+2*q12^3*q33+2*n1*q12^3*q33+4*q12^2*q13*q33+4*n1*q12^2*q13*q33+2*M`j'^2*q12*q23*q33+2*M`j'^2*n1*q12*q23*q33+2*q12^2*q23*q33+2*n1*q12^2*q23*q33+q12^2*q33^2+n1*q12^2*q33^2,-4*M`j'^2*q12^3+4*M`j'^2*n3*q12^3-12*M`j'^2*q12^2*q23+12*M`j'^2*n3*q12^2*q23-12*M`j'^2*q12*q23^2+12*M`j'^2*n3*q12*q23^2-4*M`j'^2*q23^3+4*M`j'^2*n3*q23^3)+mbox1l(1+n1,-1+n2,n3,n4)*prf(12*M`j'^2*q12^2*q13+16*M`j'^2*q12*q13^2-8*q12^2*q13^2-8*q12*q13^3+8*M`j'^2*q12*q13*q23-8*q12*q13^2*q23-4*M`j'^2*q13*q23^2+8*M`j'^2*q12^2*q33+16*M`j'^2*q12*q13*q33-8*q12^2*q13*q33-12*q12*q13^2*q33+8*M`j'^2*q12*q23*q33-8*q12*q13*q23*q33+4*M`j'^2*q12*q33^2-2*q12^2*q33^2-6*q12*q13*q33^2-2*q12*q23*q33^2-q12*q33^3,4*M`j'^2*q12^3+12*M`j'^2*q12^2*q23+12*M`j'^2*q12*q23^2+4*M`j'^2*q23^3)+mbox1l(2+n1,-1+n2,-1+n3,n4)*prf(4*M`j'^2*q12^2*q13+4*M`j'^2*n1*q12^2*q13+4*M`j'^2*q12*q13^2+4*M`j'^2*n1*q12*q13^2-4*q12^2*q13^2-4*n1*q12^2*q13^2-4*q12*q13^3-4*n1*q12*q13^3-4*M`j'^2*q13^2*q23-4*M`j'^2*n1*q13^2*q23-4*q12*q13^2*q23-4*n1*q12*q13^2*q23-4*M`j'^2*q13*q23^2-4*M`j'^2*n1*q13*q23^2+8*M`j'^2*q12^2*q33+8*M`j'^2*n1*q12^2*q33+12*M`j'^2*q12*q13*q33+12*M`j'^2*n1*q12*q13*q33-6*q12^2*q13*q33-6*n1*q12^2*q13*q33-8*q12*q13^2*q33-8*n1*q12*q13^2*q33+8*M`j'^2*q12*q23*q33+8*M`j'^2*n1*q12*q23*q33-6*q12*q13*q23*q33-6*n1*q12*q13*q23*q33+4*M`j'^2*q12*q33^2+4*M`j'^2*n1*q12*q33^2-2*q12^2*q33^2-2*n1*q12^2*q33^2-5*q12*q13*q33^2-5*n1*q12*q13*q33^2-2*q12*q23*q33^2-2*n1*q12*q23*q33^2-q12*q33^3-n1*q12*q33^3,-4*M`j'^2*q12^3+4*M`j'^2*n3*q12^3-12*M`j'^2*q12^2*q23+12*M`j'^2*n3*q12^2*q23-12*M`j'^2*q12*q23^2+12*M`j'^2*n3*q12*q23^2-4*M`j'^2*q23^3+4*M`j'^2*n3*q23^3)+mbox1l(2+n1,n2,-2+n3,n4)*prf(4*M`j'^2*q12^3+4*M`j'^2*n1*q12^3-4*M`j'^2*q12*q13^2-4*M`j'^2*n1*q12*q13^2+4*q12^2*q13^2+4*n1*q12^2*q13^2+4*q12*q13^3+4*n1*q12*q13^3+4*M`j'^2*q12^2*q23+4*M`j'^2*n1*q12^2*q23+4*q12^2*q13*q23+4*n1*q12^2*q13*q23+4*M`j'^2*q13^2*q23+4*M`j'^2*n1*q13^2*q23+8*q12*q13^2*q23+8*n1*q12*q13^2*q23+4*M`j'^2*q12*q23^2+4*M`j'^2*n1*q12*q23^2+8*M`j'^2*q13*q23^2+8*M`j'^2*n1*q13*q23^2+4*q12*q13*q23^2+4*n1*q12*q13*q23^2+4*M`j'^2*q23^3+4*M`j'^2*n1*q23^3-10*M`j'^2*q12^2*q33-10*M`j'^2*n1*q12^2*q33-12*M`j'^2*q12*q13*q33-12*M`j'^2*n1*q12*q13*q33+6*q12^2*q13*q33+6*n1*q12^2*q13*q33+8*q12*q13^2*q33+8*n1*q12*q13^2*q33-14*M`j'^2*q12*q23*q33-14*M`j'^2*n1*q12*q23*q33+2*q12^2*q23*q33+2*n1*q12^2*q23*q33+10*q12*q13*q23*q33+10*n1*q12*q13*q23*q33+2*q12*q23^2*q33+2*n1*q12*q23^2*q33-4*M`j'^2*q12*q33^2-4*M`j'^2*n1*q12*q33^2+2*q12^2*q33^2+2*n1*q12^2*q33^2+5*q12*q13*q33^2+5*n1*q12*q13*q33^2+3*q12*q23*q33^2+3*n1*q12*q23*q33^2+q12*q33^3+n1*q12*q33^3,-4*M`j'^2*q12^3+4*M`j'^2*n3*q12^3-12*M`j'^2*q12^2*q23+12*M`j'^2*n3*q12^2*q23-12*M`j'^2*q12*q23^2+12*M`j'^2*n3*q12*q23^2-4*M`j'^2*q23^3+4*M`j'^2*n3*q23^3)+mbox1l(1+n1,1+n2,-2+n3,n4)*prf(-4*M`j'^2*n2*q12^3-20*M`j'^2*n2*q12^2*q13+8*n2*q12^3*q13-16*M`j'^2*n2*q12*q13^2+16*n2*q12^2*q13^2+8*n2*q12*q13^3-8*M`j'^2*n2*q12^2*q23-20*M`j'^2*n2*q12*q13*q23+16*n2*q12^2*q13*q23+16*n2*q12*q13^2*q23-4*M`j'^2*n2*q12*q23^2+8*n2*q12*q13*q23^2-10*M`j'^2*n2*q12^2*q33+4*n2*q12^3*q33-16*M`j'^2*n2*q12*q13*q33+16*n2*q12^2*q13*q33+12*n2*q12*q13^2*q33-10*M`j'^2*n2*q12*q23*q33+8*n2*q12^2*q23*q33+16*n2*q12*q13*q23*q33+4*n2*q12*q23^2*q33-4*M`j'^2*n2*q12*q33^2+4*n2*q12^2*q33^2+6*n2*q12*q13*q33^2+4*n2*q12*q23*q33^2+n2*q12*q33^3,-4*M`j'^2*q12^3+4*M`j'^2*n3*q12^3-12*M`j'^2*q12^2*q23+12*M`j'^2*n3*q12^2*q23-12*M`j'^2*q12*q23^2+12*M`j'^2*n3*q12*q23^2-4*M`j'^2*q23^3+4*M`j'^2*n3*q23^3)+mbox1l(1+n1,n2,-1+n3,n4)*(tmpprf(ep,1)*prf(8*q12^3*q13+8*q12^2*q13^2+16*q12^2*q13*q23+8*q12*q13^2*q23+8*q12*q13*q23^2+4*q12^3*q33+8*q12^2*q13*q33+8*q12^2*q23*q33+8*q12*q13*q23*q33+4*q12*q23^2*q33+2*q12^2*q33^2+2*q12*q23*q33^2,-4*M`j'^2*q12^3+4*M`j'^2*n3*q12^3-12*M`j'^2*q12^2*q23+12*M`j'^2*n3*q12^2*q23-12*M`j'^2*q12*q23^2+12*M`j'^2*n3*q12*q23^2-4*M`j'^2*q23^3+4*M`j'^2*n3*q23^3)+prf(4*M`j'^2*n2*q12^3-4*M`j'^2*n4*q12^3+20*M`j'^2*q12^2*q13+4*M`j'^2*n1*q12^2*q13+16*M`j'^2*n2*q12^2*q13-16*M`j'^2*n3*q12^2*q13-4*M`j'^2*n4*q12^2*q13-20*q12^3*q13+4*n1*q12^3*q13+8*n3*q12^3*q13+8*n4*q12^3*q13+16*M`j'^2*q12*q13^2+16*M`j'^2*n2*q12*q13^2-16*M`j'^2*n3*q12*q13^2-28*q12^2*q13^2+4*n1*q12^2*q13^2-8*n2*q12^2*q13^2+16*n3*q12^2*q13^2+8*n4*q12^2*q13^2-8*q12*q13^3-8*n2*q12*q13^3+8*n3*q12*q13^3-8*M`j'^2*q12^2*q23-4*M`j'^2*n1*q12^2*q23+8*M`j'^2*n2*q12^2*q23+4*M`j'^2*n3*q12^2*q23-8*M`j'^2*n4*q12^2*q23+12*M`j'^2*q12*q13*q23+16*M`j'^2*n2*q12*q13*q23-12*M`j'^2*n3*q12*q13*q23-4*M`j'^2*n4*q12*q13*q23-40*q12^2*q13*q23+8*n1*q12^2*q13*q23+16*n3*q12^2*q13*q23+16*n4*q12^2*q13*q23-28*q12*q13^2*q23+4*n1*q12*q13^2*q23-8*n2*q12*q13^2*q23+16*n3*q12*q13^2*q23+8*n4*q12*q13^2*q23-16*M`j'^2*q12*q23^2-8*M`j'^2*n1*q12*q23^2+4*M`j'^2*n2*q12*q23^2+8*M`j'^2*n3*q12*q23^2-4*M`j'^2*n4*q12*q23^2-8*M`j'^2*q13*q23^2-4*M`j'^2*n1*q13*q23^2+4*M`j'^2*n3*q13*q23^2-20*q12*q13*q23^2+4*n1*q12*q13*q23^2+8*n3*q12*q13*q23^2+8*n4*q12*q13*q23^2-8*M`j'^2*q23^3-4*M`j'^2*n1*q23^3+4*M`j'^2*n3*q23^3+14*M`j'^2*q12^2*q33+4*M`j'^2*n1*q12^2*q33+8*M`j'^2*n2*q12^2*q33-10*M`j'^2*n3*q12^2*q33-2*M`j'^2*n4*q12^2*q33-10*q12^3*q33+2*n1*q12^3*q33+4*n3*q12^3*q33+4*n4*q12^3*q33+16*M`j'^2*q12*q13*q33+16*M`j'^2*n2*q12*q13*q33-16*M`j'^2*n3*q12*q13*q33-28*q12^2*q13*q33+4*n1*q12^2*q13*q33-8*n2*q12^2*q13*q33+16*n3*q12^2*q13*q33+8*n4*q12^2*q13*q33-12*q12*q13^2*q33-12*n2*q12*q13^2*q33+12*n3*q12*q13^2*q33+14*M`j'^2*q12*q23*q33+4*M`j'^2*n1*q12*q23*q33+8*M`j'^2*n2*q12*q23*q33-10*M`j'^2*n3*q12*q23*q33-2*M`j'^2*n4*q12*q23*q33-20*q12^2*q23*q33+4*n1*q12^2*q23*q33+8*n3*q12^2*q23*q33+8*n4*q12^2*q23*q33-28*q12*q13*q23*q33+4*n1*q12*q13*q23*q33-8*n2*q12*q13*q23*q33+16*n3*q12*q13*q23*q33+8*n4*q12*q13*q23*q33-10*q12*q23^2*q33+2*n1*q12*q23^2*q33+4*n3*q12*q23^2*q33+4*n4*q12*q23^2*q33+4*M`j'^2*q12*q33^2+4*M`j'^2*n2*q12*q33^2-4*M`j'^2*n3*q12*q33^2-7*q12^2*q33^2+n1*q12^2*q33^2-2*n2*q12^2*q33^2+4*n3*q12^2*q33^2+2*n4*q12^2*q33^2-6*q12*q13*q33^2-6*n2*q12*q13*q33^2+6*n3*q12*q13*q33^2-7*q12*q23*q33^2+n1*q12*q23*q33^2-2*n2*q12*q23*q33^2+4*n3*q12*q23*q33^2+2*n4*q12*q23*q33^2-q12*q33^3-n2*q12*q33^3+n3*q12*q33^3,-4*M`j'^2*q12^3+4*M`j'^2*n3*q12^3-12*M`j'^2*q12^2*q23+12*M`j'^2*n3*q12^2*q23-12*M`j'^2*q12*q23^2+12*M`j'^2*n3*q12*q23^2-4*M`j'^2*q23^3+4*M`j'^2*n3*q23^3))+mbox1l(2+n1,n2,-1+n3,n4)*prf(-8*q12^3*q13^2-8*n1*q12^3*q13^2-8*q12^2*q13^3-8*n1*q12^2*q13^3-16*M`j'^2*q12^2*q13*q23-16*M`j'^2*n1*q12^2*q13*q23-16*M`j'^2*q12*q13^2*q23-16*M`j'^2*n1*q12*q13^2*q23-8*q12^2*q13^2*q23-8*n1*q12^2*q13^2*q23-16*M`j'^2*q12*q13*q23^2-16*M`j'^2*n1*q12*q13*q23^2+8*M`j'^2*q12^3*q33+8*M`j'^2*n1*q12^3*q33+8*M`j'^2*q12^2*q13*q33+8*M`j'^2*n1*q12^2*q13*q33-8*q12^3*q13*q33-8*n1*q12^3*q13*q33-12*q12^2*q13^2*q33-12*n1*q12^2*q13^2*q33+8*M`j'^2*q12^2*q23*q33+8*M`j'^2*n1*q12^2*q23*q33-8*M`j'^2*q12*q13*q23*q33-8*M`j'^2*n1*q12*q13*q23*q33-8*q12^2*q13*q23*q33-8*n1*q12^2*q13*q23*q33+4*M`j'^2*q12^2*q33^2+4*M`j'^2*n1*q12^2*q33^2-2*q12^3*q33^2-2*n1*q12^3*q33^2-6*q12^2*q13*q33^2-6*n1*q12^2*q13*q33^2-2*q12^2*q23*q33^2-2*n1*q12^2*q23*q33^2-q12^2*q33^3-n1*q12^2*q33^3,-4*M`j'^2*q12^3+4*M`j'^2*n3*q12^3-12*M`j'^2*q12^2*q23+12*M`j'^2*n3*q12^2*q23-12*M`j'^2*q12*q23^2+12*M`j'^2*n3*q12*q23^2-4*M`j'^2*q23^3+4*M`j'^2*n3*q23^3);
	Identify,ifmatch->jump mbox1l(n1?neg_,n2?{,>1},n3?pos_,n4?pos_) = mbox1l(1+n1,n2,n3,-1+n4)*prf(2*q12^2-2*q12*q13+2*q12*q23-q12*q33,2*q12^2+4*q12*q23+2*q23^2)+mbox1l(1+n1,-1+n2,1+n3,-1+n4)*prf(-2*n3*q12*q13-n3*q12*q33,-2*q12^2+2*n2*q12^2-4*q12*q23+4*n2*q12*q23-2*q23^2+2*n2*q23^2)+mbox1l(1+n1,-1+n2,-1+n3,1+n4)*prf(-2*n4*q12*q13-n4*q12*q33,-2*q12^2+2*n2*q12^2-4*q12*q23+4*n2*q12*q23-2*q23^2+2*n2*q23^2)+mbox1l(2+n1,-1+n2,n3,-1+n4)*prf(8*M`j'^2*q12^2*q13+8*M`j'^2*n1*q12^2*q13-4*q12^2*q13^2-4*n1*q12^2*q13^2+2*M`j'^2*q12^2*q33+2*M`j'^2*n1*q12^2*q33-4*q12^2*q13*q33-4*n1*q12^2*q13*q33-2*M`j'^2*q12*q23*q33-2*M`j'^2*n1*q12*q23*q33-q12^2*q33^2-n1*q12^2*q33^2,-4*M`j'^2*q12^3+4*M`j'^2*n2*q12^3-12*M`j'^2*q12^2*q23+12*M`j'^2*n2*q12^2*q23-12*M`j'^2*q12*q23^2+12*M`j'^2*n2*q12*q23^2-4*M`j'^2*q23^3+4*M`j'^2*n2*q23^3)+mbox1l(1+n1,n2,-1+n3,n4)*prf(8*M`j'^2*q12^2*q13+16*M`j'^2*q12*q13^2-8*q12^2*q13^2-8*q12*q13^3+4*M`j'^2*q12^2*q23+12*M`j'^2*q12*q13*q23-8*q12*q13^2*q23+8*M`j'^2*q12*q23^2+4*M`j'^2*q13*q23^2+4*M`j'^2*q23^3+2*M`j'^2*q12^2*q33+16*M`j'^2*q12*q13*q33-8*q12^2*q13*q33-12*q12*q13^2*q33+2*M`j'^2*q12*q23*q33-8*q12*q13*q23*q33+4*M`j'^2*q12*q33^2-2*q12^2*q33^2-6*q12*q13*q33^2-2*q12*q23*q33^2-q12*q33^3,4*M`j'^2*q12^3+12*M`j'^2*q12^2*q23+12*M`j'^2*q12*q23^2+4*M`j'^2*q23^3)+mbox1l(2+n1,-1+n2,-1+n3,n4)*prf(-4*M`j'^2*q12^2*q13-4*M`j'^2*n1*q12^2*q13+4*M`j'^2*q12*q13^2+4*M`j'^2*n1*q12*q13^2-4*q12*q13^3-4*n1*q12*q13^3-4*M`j'^2*q13^2*q23-4*M`j'^2*n1*q13^2*q23-4*q12*q13^2*q23-4*n1*q12*q13^2*q23-4*M`j'^2*q13*q23^2-4*M`j'^2*n1*q13*q23^2+2*M`j'^2*q12^2*q33+2*M`j'^2*n1*q12^2*q33+12*M`j'^2*q12*q13*q33+12*M`j'^2*n1*q12*q13*q33-8*q12*q13^2*q33-8*n1*q12*q13^2*q33+6*M`j'^2*q12*q23*q33+6*M`j'^2*n1*q12*q23*q33-4*q12*q13*q23*q33-4*n1*q12*q13*q23*q33+4*M`j'^2*q12*q33^2+4*M`j'^2*n1*q12*q33^2-5*q12*q13*q33^2-5*n1*q12*q13*q33^2-q12*q23*q33^2-n1*q12*q23*q33^2-q12*q33^3-n1*q12*q33^3,-4*M`j'^2*q12^3+4*M`j'^2*n2*q12^3-12*M`j'^2*q12^2*q23+12*M`j'^2*n2*q12^2*q23-12*M`j'^2*q12*q23^2+12*M`j'^2*n2*q12*q23^2-4*M`j'^2*q23^3+4*M`j'^2*n2*q23^3)+mbox1l(2+n1,-2+n2,n3,n4)*prf(-4*M`j'^2*q12*q13^2-4*M`j'^2*n1*q12*q13^2+4*q12*q13^3+4*n1*q12*q13^3+4*M`j'^2*q13^2*q23+4*M`j'^2*n1*q13^2*q23-12*M`j'^2*q12*q13*q33-12*M`j'^2*n1*q12*q13*q33+8*q12*q13^2*q33+8*n1*q12*q13^2*q33-4*M`j'^2*q12*q33^2-4*M`j'^2*n1*q12*q33^2+5*q12*q13*q33^2+5*n1*q12*q13*q33^2+q12*q33^3+n1*q12*q33^3,-4*M`j'^2*q12^3+4*M`j'^2*n2*q12^3-12*M`j'^2*q12^2*q23+12*M`j'^2*n2*q12^2*q23-12*M`j'^2*q12*q23^2+12*M`j'^2*n2*q12*q23^2-4*M`j'^2*q23^3+4*M`j'^2*n2*q23^3)+mbox1l(1+n1,-1+n2,n3,n4)*(tmpprf(ep,1)*prf(-8*q12^2*q13^2-8*q12*q13^2*q23-8*q12^2*q13*q33-8*q12*q13*q23*q33-2*q12^2*q33^2-2*q12*q23*q33^2,-4*M`j'^2*q12^3+4*M`j'^2*n2*q12^3-12*M`j'^2*q12^2*q23+12*M`j'^2*n2*q12^2*q23-12*M`j'^2*q12*q23^2+12*M`j'^2*n2*q12*q23^2-4*M`j'^2*q23^3+4*M`j'^2*n2*q23^3)+prf(-4*M`j'^2*n1*q12^2*q13-4*M`j'^2*n2*q12^2*q13+4*M`j'^2*n3*q12^2*q13+4*M`j'^2*n4*q12^2*q13+16*M`j'^2*q12*q13^2-16*M`j'^2*n2*q12*q13^2+16*M`j'^2*n3*q12*q13^2+12*q12^2*q13^2-4*n1*q12^2*q13^2-8*n3*q12^2*q13^2-8*n4*q12^2*q13^2-8*q12*q13^3+8*n2*q12*q13^3-8*n3*q12*q13^3+8*M`j'^2*q12*q13*q23-8*M`j'^2*n2*q12*q13*q23+4*M`j'^2*n3*q12*q13*q23+4*M`j'^2*n4*q12*q13*q23+12*q12*q13^2*q23-4*n1*q12*q13^2*q23-8*n3*q12*q13^2*q23-8*n4*q12*q13^2*q23+8*M`j'^2*q13*q23^2+4*M`j'^2*n1*q13*q23^2-4*M`j'^2*n2*q13*q23^2-4*M`j'^2*q12^2*q33-4*M`j'^2*n1*q12^2*q33+2*M`j'^2*n3*q12^2*q33+2*M`j'^2*n4*q12^2*q33+16*M`j'^2*q12*q13*q33-16*M`j'^2*n2*q12*q13*q33+16*M`j'^2*n3*q12*q13*q33+12*q12^2*q13*q33-4*n1*q12^2*q13*q33-8*n3*q12^2*q13*q33-8*n4*q12^2*q13*q33-12*q12*q13^2*q33+12*n2*q12*q13^2*q33-12*n3*q12*q13^2*q33-4*M`j'^2*q12*q23*q33-4*M`j'^2*n1*q12*q23*q33+2*M`j'^2*n3*q12*q23*q33+2*M`j'^2*n4*q12*q23*q33+12*q12*q13*q23*q33-4*n1*q12*q13*q23*q33-8*n3*q12*q13*q23*q33-8*n4*q12*q13*q23*q33+4*M`j'^2*q12*q33^2-4*M`j'^2*n2*q12*q33^2+4*M`j'^2*n3*q12*q33^2+3*q12^2*q33^2-n1*q12^2*q33^2-2*n3*q12^2*q33^2-2*n4*q12^2*q33^2-6*q12*q13*q33^2+6*n2*q12*q13*q33^2-6*n3*q12*q13*q33^2+3*q12*q23*q33^2-n1*q12*q23*q33^2-2*n3*q12*q23*q33^2-2*n4*q12*q23*q33^2-q12*q33^3+n2*q12*q33^3-n3*q12*q33^3,-4*M`j'^2*q12^3+4*M`j'^2*n2*q12^3-12*M`j'^2*q12^2*q23+12*M`j'^2*n2*q12^2*q23-12*M`j'^2*q12*q23^2+12*M`j'^2*n2*q12*q23^2-4*M`j'^2*q23^3+4*M`j'^2*n2*q23^3))+mbox1l(1+n1,-2+n2,1+n3,n4)*prf(-16*M`j'^2*n3*q12*q13^2+8*n3*q12*q13^3-16*M`j'^2*n3*q12*q13*q33+12*n3*q12*q13^2*q33-4*M`j'^2*n3*q12*q33^2+6*n3*q12*q13*q33^2+n3*q12*q33^3,-4*M`j'^2*q12^3+4*M`j'^2*n2*q12^3-12*M`j'^2*q12^2*q23+12*M`j'^2*n2*q12^2*q23-12*M`j'^2*q12*q23^2+12*M`j'^2*n2*q12*q23^2-4*M`j'^2*q23^3+4*M`j'^2*n2*q23^3)+mbox1l(2+n1,-1+n2,n3,n4)*prf(8*q12^2*q13^3+8*n1*q12^2*q13^3+16*M`j'^2*q12*q13^2*q23+16*M`j'^2*n1*q12*q13^2*q23-8*M`j'^2*q12^2*q13*q33-8*M`j'^2*n1*q12^2*q13*q33+12*q12^2*q13^2*q33+12*n1*q12^2*q13^2*q33+8*M`j'^2*q12*q13*q23*q33+8*M`j'^2*n1*q12*q13*q23*q33-4*M`j'^2*q12^2*q33^2-4*M`j'^2*n1*q12^2*q33^2+6*q12^2*q13*q33^2+6*n1*q12^2*q13*q33^2+q12^2*q33^3+n1*q12^2*q33^3,-4*M`j'^2*q12^3+4*M`j'^2*n2*q12^3-12*M`j'^2*q12^2*q23+12*M`j'^2*n2*q12^2*q23-12*M`j'^2*q12*q23^2+12*M`j'^2*n2*q12*q23^2-4*M`j'^2*q23^3+4*M`j'^2*n2*q23^3);
	Identify,ifmatch->jump mbox1l(n1?neg0_,n2?pos_,n3?pos_,n4?{,>1}) = mbox1l(n1,n2,-1+n3,n4)*prf(1,-2*q13-q33)+mbox1l(n1,-1+n2,1+n3,-1+n4)*prf(-n3,-q12+n4*q12-q23+n4*q23)+mbox1l(1+n1,n2,n3,-1+n4)*prf(-(n1*q12),-q12+n4*q12-q23+n4*q23)+mbox1l(1+n1,n2,n3,-2+n4)*prf(n1*q12,-2*q12*q13+2*n4*q12*q13-2*q13*q23+2*n4*q13*q23-q12*q33+n4*q12*q33-q23*q33+n4*q23*q33)+mbox1l(1+n1,-1+n2,n3,-1+n4)*prf(-(n1*q13)-n1*q33,-2*q12*q13+2*n4*q12*q13-2*q13*q23+2*n4*q13*q23-q12*q33+n4*q12*q33-q23*q33+n4*q23*q33)+mbox1l(1+n1,n2,-1+n3,-1+n4)*prf(-(n1*q12)+n1*q13+n1*q33,-2*q12*q13+2*n4*q12*q13-2*q13*q23+2*n4*q13*q23-q12*q33+n4*q12*q33-q23*q33+n4*q23*q33)+mbox1l(n1,1+n2,-1+n3,-1+n4)*prf(n2*q12+2*n2*q13+n2*q23+n2*q33,-2*q12*q13+2*n4*q12*q13-2*q13*q23+2*n4*q13*q23-q12*q33+n4*q12*q33-q23*q33+n4*q23*q33)+mbox1l(n1,n2,n3,-1+n4)*prf(-q12-n2*q12+n4*q12-2*n2*q13+2*n3*q13-q23-n2*q23+n4*q23-n2*q33+n3*q33,-2*q12*q13+2*n4*q12*q13-2*q13*q23+2*n4*q13*q23-q12*q33+n4*q12*q33-q23*q33+n4*q23*q33);
	Identify,ifmatch->jump mbox1l(n1?neg0_,n2?pos_,n3?{,>1},n4?pos_) = mbox1l(n1,n2,n3,-1+n4)*prf(1,2*q12+2*q23)+mbox1l(n1,1+n2,-1+n3,-1+n4)*prf(n2,-2*q12+2*n3*q12-2*q23+2*n3*q23)+mbox1l(n1,n2,-2+n3,1+n4)*prf(2*n4*q12+2*n4*q13+2*n4*q23+n4*q33,-4*q12*q13+4*n3*q12*q13-4*q13*q23+4*n3*q13*q23-2*q12*q33+2*n3*q12*q33-2*q23*q33+2*n3*q23*q33)+mbox1l(n1,-1+n2,n3,n4)*prf(4*M`j'^2*q12+8*M`j'^2*q13-4*q12*q13-4*q13^2+4*M`j'^2*q23-4*q13*q23+4*M`j'^2*q33-2*q12*q33-4*q13*q33-2*q23*q33-q33^2,4*M`j'^2*q12^2+8*M`j'^2*q12*q23+4*M`j'^2*q23^2)+mbox1l(1+n1,n2,-1+n3,n4)*prf(4*M`j'^2*n1*q12*q13-4*n1*q12^2*q13-4*n1*q12*q13^2-4*M`j'^2*n1*q12*q23-4*M`j'^2*n1*q13*q23-4*n1*q12*q13*q23-4*M`j'^2*n1*q23^2+4*M`j'^2*n1*q12*q33-2*n1*q12^2*q33-4*n1*q12*q13*q33-2*n1*q12*q23*q33-n1*q12*q33^2,-4*M`j'^2*q12^2+4*M`j'^2*n3*q12^2-8*M`j'^2*q12*q23+8*M`j'^2*n3*q12*q23-4*M`j'^2*q23^2+4*M`j'^2*n3*q23^2)+mbox1l(1+n1,n2,-1+n3,-1+n4)*prf(-4*M`j'^2*n1*q12^2-4*M`j'^2*n1*q12*q13+4*n1*q12^2*q13+4*n1*q12*q13^2-4*M`j'^2*n1*q12*q23+4*M`j'^2*n1*q13*q23+4*n1*q12*q13*q23-2*M`j'^2*n1*q12*q33+2*n1*q12^2*q33+4*n1*q12*q13*q33+2*M`j'^2*n1*q23*q33+2*n1*q12*q23*q33+n1*q12*q33^2,-8*M`j'^2*q12^2*q13+8*M`j'^2*n3*q12^2*q13-16*M`j'^2*q12*q13*q23+16*M`j'^2*n3*q12*q13*q23-8*M`j'^2*q13*q23^2+8*M`j'^2*n3*q13*q23^2-4*M`j'^2*q12^2*q33+4*M`j'^2*n3*q12^2*q33-8*M`j'^2*q12*q23*q33+8*M`j'^2*n3*q12*q23*q33-4*M`j'^2*q23^2*q33+4*M`j'^2*n3*q23^2*q33)+mbox1l(1+n1,-1+n2,-1+n3,n4)*prf(4*M`j'^2*n1*q12*q13+8*M`j'^2*n1*q13^2-4*n1*q12*q13^2-4*n1*q13^3+4*M`j'^2*n1*q13*q23-4*n1*q13^2*q23+4*M`j'^2*n1*q12*q33+12*M`j'^2*n1*q13*q33-6*n1*q12*q13*q33-8*n1*q13^2*q33+4*M`j'^2*n1*q23*q33-6*n1*q13*q23*q33+4*M`j'^2*n1*q33^2-2*n1*q12*q33^2-5*n1*q13*q33^2-2*n1*q23*q33^2-n1*q33^3,-8*M`j'^2*q12^2*q13+8*M`j'^2*n3*q12^2*q13-16*M`j'^2*q12*q13*q23+16*M`j'^2*n3*q12*q13*q23-8*M`j'^2*q13*q23^2+8*M`j'^2*n3*q13*q23^2-4*M`j'^2*q12^2*q33+4*M`j'^2*n3*q12^2*q33-8*M`j'^2*q12*q23*q33+8*M`j'^2*n3*q12*q23*q33-4*M`j'^2*q23^2*q33+4*M`j'^2*n3*q23^2*q33)+mbox1l(1+n1,n2,-2+n3,n4)*prf(4*M`j'^2*n1*q12^2-8*M`j'^2*n1*q13^2+4*n1*q12*q13^2+4*n1*q13^3+4*M`j'^2*n1*q12*q23-8*M`j'^2*n1*q13*q23+4*n1*q12*q13*q23+8*n1*q13^2*q23+4*n1*q13*q23^2-2*M`j'^2*n1*q12*q33-12*M`j'^2*n1*q13*q33+6*n1*q12*q13*q33+8*n1*q13^2*q33-6*M`j'^2*n1*q23*q33+2*n1*q12*q23*q33+10*n1*q13*q23*q33+2*n1*q23^2*q33-4*M`j'^2*n1*q33^2+2*n1*q12*q33^2+5*n1*q13*q33^2+3*n1*q23*q33^2+n1*q33^3,-8*M`j'^2*q12^2*q13+8*M`j'^2*n3*q12^2*q13-16*M`j'^2*q12*q13*q23+16*M`j'^2*n3*q12*q13*q23-8*M`j'^2*q13*q23^2+8*M`j'^2*n3*q13*q23^2-4*M`j'^2*q12^2*q33+4*M`j'^2*n3*q12^2*q33-8*M`j'^2*q12*q23*q33+8*M`j'^2*n3*q12*q23*q33-4*M`j'^2*q23^2*q33+4*M`j'^2*n3*q23^2*q33)+mbox1l(n1,1+n2,-2+n3,n4)*prf(-4*M`j'^2*n2*q12^2-20*M`j'^2*n2*q12*q13+8*n2*q12^2*q13-16*M`j'^2*n2*q13^2+16*n2*q12*q13^2+8*n2*q13^3-8*M`j'^2*n2*q12*q23-20*M`j'^2*n2*q13*q23+16*n2*q12*q13*q23+16*n2*q13^2*q23-4*M`j'^2*n2*q23^2+8*n2*q13*q23^2-10*M`j'^2*n2*q12*q33+4*n2*q12^2*q33-16*M`j'^2*n2*q13*q33+16*n2*q12*q13*q33+12*n2*q13^2*q33-10*M`j'^2*n2*q23*q33+8*n2*q12*q23*q33+16*n2*q13*q23*q33+4*n2*q23^2*q33-4*M`j'^2*n2*q33^2+4*n2*q12*q33^2+6*n2*q13*q33^2+4*n2*q23*q33^2+n2*q33^3,-8*M`j'^2*q12^2*q13+8*M`j'^2*n3*q12^2*q13-16*M`j'^2*q12*q13*q23+16*M`j'^2*n3*q12*q13*q23-8*M`j'^2*q13*q23^2+8*M`j'^2*n3*q13*q23^2-4*M`j'^2*q12^2*q33+4*M`j'^2*n3*q12^2*q33-8*M`j'^2*q12*q23*q33+8*M`j'^2*n3*q12*q23*q33-4*M`j'^2*q23^2*q33+4*M`j'^2*n3*q23^2*q33)+mbox1l(n1,n2,-1+n3,n4)*(tmpprf(ep,1)*prf(8*q12^2*q13+8*q12*q13^2+16*q12*q13*q23+8*q13^2*q23+8*q13*q23^2+4*q12^2*q33+8*q12*q13*q33+8*q12*q23*q33+8*q13*q23*q33+4*q23^2*q33+2*q12*q33^2+2*q23*q33^2,-8*M`j'^2*q12^2*q13+8*M`j'^2*n3*q12^2*q13-16*M`j'^2*q12*q13*q23+16*M`j'^2*n3*q12*q13*q23-8*M`j'^2*q13*q23^2+8*M`j'^2*n3*q13*q23^2-4*M`j'^2*q12^2*q33+4*M`j'^2*n3*q12^2*q33-8*M`j'^2*q12*q23*q33+8*M`j'^2*n3*q12*q23*q33-4*M`j'^2*q23^2*q33+4*M`j'^2*n3*q23^2*q33)+prf(4*M`j'^2*n2*q12^2-4*M`j'^2*n4*q12^2+12*M`j'^2*q12*q13+16*M`j'^2*n2*q12*q13-12*M`j'^2*n3*q12*q13-4*M`j'^2*n4*q12*q13-24*q12^2*q13+4*n1*q12^2*q13+8*n3*q12^2*q13+8*n4*q12^2*q13+16*M`j'^2*q13^2+16*M`j'^2*n2*q13^2-16*M`j'^2*n3*q13^2-32*q12*q13^2+4*n1*q12*q13^2-8*n2*q12*q13^2+16*n3*q12*q13^2+8*n4*q12*q13^2-8*q13^3-8*n2*q13^3+8*n3*q13^3+8*M`j'^2*n2*q12*q23-8*M`j'^2*n4*q12*q23+12*M`j'^2*q13*q23+16*M`j'^2*n2*q13*q23-12*M`j'^2*n3*q13*q23-4*M`j'^2*n4*q13*q23-48*q12*q13*q23+8*n1*q12*q13*q23+16*n3*q12*q13*q23+16*n4*q12*q13*q23-32*q13^2*q23+4*n1*q13^2*q23-8*n2*q13^2*q23+16*n3*q13^2*q23+8*n4*q13^2*q23+4*M`j'^2*n2*q23^2-4*M`j'^2*n4*q23^2-24*q13*q23^2+4*n1*q13*q23^2+8*n3*q13*q23^2+8*n4*q13*q23^2+6*M`j'^2*q12*q33+8*M`j'^2*n2*q12*q33-6*M`j'^2*n3*q12*q33-2*M`j'^2*n4*q12*q33-12*q12^2*q33+2*n1*q12^2*q33+4*n3*q12^2*q33+4*n4*q12^2*q33+16*M`j'^2*q13*q33+16*M`j'^2*n2*q13*q33-16*M`j'^2*n3*q13*q33-32*q12*q13*q33+4*n1*q12*q13*q33-8*n2*q12*q13*q33+16*n3*q12*q13*q33+8*n4*q12*q13*q33-12*q13^2*q33-12*n2*q13^2*q33+12*n3*q13^2*q33+6*M`j'^2*q23*q33+8*M`j'^2*n2*q23*q33-6*M`j'^2*n3*q23*q33-2*M`j'^2*n4*q23*q33-24*q12*q23*q33+4*n1*q12*q23*q33+8*n3*q12*q23*q33+8*n4*q12*q23*q33-32*q13*q23*q33+4*n1*q13*q23*q33-8*n2*q13*q23*q33+16*n3*q13*q23*q33+8*n4*q13*q23*q33-12*q23^2*q33+2*n1*q23^2*q33+4*n3*q23^2*q33+4*n4*q23^2*q33+4*M`j'^2*q33^2+4*M`j'^2*n2*q33^2-4*M`j'^2*n3*q33^2-8*q12*q33^2+n1*q12*q33^2-2*n2*q12*q33^2+4*n3*q12*q33^2+2*n4*q12*q33^2-6*q13*q33^2-6*n2*q13*q33^2+6*n3*q13*q33^2-8*q23*q33^2+n1*q23*q33^2-2*n2*q23*q33^2+4*n3*q23*q33^2+2*n4*q23*q33^2-q33^3-n2*q33^3+n3*q33^3,-8*M`j'^2*q12^2*q13+8*M`j'^2*n3*q12^2*q13-16*M`j'^2*q12*q13*q23+16*M`j'^2*n3*q12*q13*q23-8*M`j'^2*q13*q23^2+8*M`j'^2*n3*q13*q23^2-4*M`j'^2*q12^2*q33+4*M`j'^2*n3*q12^2*q33-8*M`j'^2*q12*q23*q33+8*M`j'^2*n3*q12*q23*q33-4*M`j'^2*q23^2*q33+4*M`j'^2*n3*q23^2*q33));
	Identify,ifmatch->jump mbox1l(n1?neg0_,n2?{,>1},n3?pos_,n4?pos_) = mbox1l(n1,n2,n3,-1+n4)*prf(-1,2*q12+2*q23)+mbox1l(n1,-1+n2,1+n3,-1+n4)*prf(-n3,-2*q12+2*n2*q12-2*q23+2*n2*q23)+mbox1l(n1,-1+n2,-1+n3,1+n4)*prf(-n4,-2*q12+2*n2*q12-2*q23+2*n2*q23)+mbox1l(1+n1,-1+n2,n3,-1+n4)*prf(2*M`j'^2*n1*q12-2*n1*q12*q13-2*M`j'^2*n1*q23-n1*q12*q33,-4*M`j'^2*q12^2+4*M`j'^2*n2*q12^2-8*M`j'^2*q12*q23+8*M`j'^2*n2*q12*q23-4*M`j'^2*q23^2+4*M`j'^2*n2*q23^2)+mbox1l(n1,n2,-1+n3,n4)*prf(6*M`j'^2*q12+8*M`j'^2*q13-4*q12*q13-4*q13^2+6*M`j'^2*q23-4*q13*q23+4*M`j'^2*q33-2*q12*q33-4*q13*q33-2*q23*q33-q33^2,4*M`j'^2*q12^2+8*M`j'^2*q12*q23+4*M`j'^2*q23^2)+mbox1l(1+n1,-1+n2,-1+n3,n4)*prf(-2*M`j'^2*n1*q12+4*M`j'^2*n1*q13-2*n1*q13^2+2*M`j'^2*n1*q23-2*n1*q13*q23+4*M`j'^2*n1*q33-3*n1*q13*q33-n1*q23*q33-n1*q33^2,-4*M`j'^2*q12^2+4*M`j'^2*n2*q12^2-8*M`j'^2*q12*q23+8*M`j'^2*n2*q12*q23-4*M`j'^2*q23^2+4*M`j'^2*n2*q23^2)+mbox1l(1+n1,-2+n2,n3,n4)*prf(-4*M`j'^2*n1*q13+2*n1*q13^2-4*M`j'^2*n1*q33+3*n1*q13*q33+n1*q33^2,-4*M`j'^2*q12^2+4*M`j'^2*n2*q12^2-8*M`j'^2*q12*q23+8*M`j'^2*n2*q12*q23-4*M`j'^2*q23^2+4*M`j'^2*n2*q23^2)+mbox1l(n1,-1+n2,n3,n4)*(tmpprf(ep,1)*prf(-4*q12*q13-4*q13*q23-2*q12*q33-2*q23*q33,-4*M`j'^2*q12^2+4*M`j'^2*n2*q12^2-8*M`j'^2*q12*q23+8*M`j'^2*n2*q12*q23-4*M`j'^2*q23^2+4*M`j'^2*n2*q23^2)+prf(4*M`j'^2*q12-4*M`j'^2*n2*q12+2*M`j'^2*n3*q12+2*M`j'^2*n4*q12+8*M`j'^2*q13-8*M`j'^2*n2*q13+8*M`j'^2*n3*q13+8*q12*q13-2*n1*q12*q13-4*n3*q12*q13-4*n4*q12*q13-4*q13^2+4*n2*q13^2-4*n3*q13^2+4*M`j'^2*q23-4*M`j'^2*n2*q23+2*M`j'^2*n3*q23+2*M`j'^2*n4*q23+8*q13*q23-2*n1*q13*q23-4*n3*q13*q23-4*n4*q13*q23+4*M`j'^2*q33-4*M`j'^2*n2*q33+4*M`j'^2*n3*q33+4*q12*q33-n1*q12*q33-2*n3*q12*q33-2*n4*q12*q33-4*q13*q33+4*n2*q13*q33-4*n3*q13*q33+4*q23*q33-n1*q23*q33-2*n3*q23*q33-2*n4*q23*q33-q33^2+n2*q33^2-n3*q33^2,-4*M`j'^2*q12^2+4*M`j'^2*n2*q12^2-8*M`j'^2*q12*q23+8*M`j'^2*n2*q12*q23-4*M`j'^2*q23^2+4*M`j'^2*n2*q23^2))+mbox1l(n1,-2+n2,1+n3,n4)*prf(-8*M`j'^2*n3*q13+4*n3*q13^2-4*M`j'^2*n3*q33+4*n3*q13*q33+n3*q33^2,-4*M`j'^2*q12^2+4*M`j'^2*n2*q12^2-8*M`j'^2*q12*q23+8*M`j'^2*n2*q12*q23-4*M`j'^2*q23^2+4*M`j'^2*n2*q23^2)+mbox1l(1+n1,-1+n2,n3,n4)*prf(-4*M`j'^2*n1*q12*q13+4*n1*q12*q13^2+4*M`j'^2*n1*q13*q23-4*M`j'^2*n1*q12*q33+4*n1*q12*q13*q33+n1*q12*q33^2,-4*M`j'^2*q12^2+4*M`j'^2*n2*q12^2-8*M`j'^2*q12*q23+8*M`j'^2*n2*q12*q23-4*M`j'^2*q23^2+4*M`j'^2*n2*q23^2);
	Identify,ifmatch->jump mbox1l(n1?neg0_,n2?pos_,n3?pos_,n4?{,>1}) = mbox1l(n1,n2,1+n3,-1+n4)*prf(n3,-1+n4)+mbox1l(1+n1,1+n2,n3,-2+n4)*prf(-2*n1*q12,-2*q13+2*n4*q13-q33+n4*q33)+mbox1l(1+n1,n2,n3,-1+n4)*prf(n1*q33,-2*q13+2*n4*q13-q33+n4*q33)+mbox1l(n1,1+n2,-1+n3,n4)*prf(2*q12+2*q13+2*q23+q33,2*q13+q33)+mbox1l(1+n1,1+n2,-1+n3,-1+n4)*prf(2*n1*q12-n1*q33,-2*q13+2*n4*q13-q33+n4*q33)+mbox1l(n1,2+n2,-1+n3,-1+n4)*prf(-2*q12-2*n2*q12-2*q13-2*n2*q13-2*q23-2*n2*q23-q33-n2*q33,-2*q13+2*n4*q13-q33+n4*q33)+mbox1l(n1,1+n2,n3,-1+n4)*prf(4*q12+2*n2*q12-2*n4*q12+2*q13+2*n2*q13-2*n3*q13+4*q23+2*n2*q23-2*n4*q23+q33+n2*q33-n3*q33,-2*q13+2*n4*q13-q33+n4*q33);
	Identify,ifmatch->jump mbox1l(n1?neg_,1,1,1) = tmpprf(1,2*ep+n1)*mbox1l(n1,1,0,2)*prf(-2*M`j'^2,2*q13+q33)+tmpprf(1,2*ep+n1)*mbox1l(n1,1,2,0)*prf(-2*M`j'^2,2*q13+q33)+tmpprf(1,2*ep+n1)*mbox1l(n1,2,1,0)*prf(-2*M`j'^2,2*q13+q33)+tmpprf(1,2*ep+n1)*mbox1l(1+n1,1,0,2)*prf(2*M`j'^2*q12,q12+q23)+tmpprf(1,2*ep+n1)*mbox1l(1+n1,1,2,0)*prf(2*M`j'^2*q12,q12+q23)+tmpprf(1,2*ep+n1)*mbox1l(n1,0,2,1)*prf(-4*M`j'^2+2*q13+q33,q12+q23)+tmpprf(1,2*ep+n1)*mbox1l(1+n1,2,1,0)*prf(-4*M`j'^2*q12^2+4*M`j'^2*q12*q13-4*M`j'^2*q12*q23+2*M`j'^2*q12*q33,2*q12*q13+2*q13*q23+q12*q33+q23*q33)+tmpprf(1,2*ep+n1)*mbox1l(1+n1,1,1,0)*prf(2*M`j'^2*n1*q12-2*n1*q12*q13-2*M`j'^2*n1*q23-n1*q12*q33,2*q12*q13+2*q13*q23+q12*q33+q23*q33)+mbox1l(1+n1,1,1,1)*(tmpprf(ep,2*ep+n1)*prf(4*q12*q13+2*q12*q33,q12+q23)+tmpprf(1,2*ep+n1)*prf(2*q12*q13+4*n1*q12*q13+q12*q33+2*n1*q12*q33,q12+q23))+tmpprf(1,2*ep+n1)*mbox1l(n1,2,0,1)*prf(6*M`j'^2*q12+8*M`j'^2*q13-4*q12*q13-4*q13^2+6*M`j'^2*q23-4*q13*q23+4*M`j'^2*q33-2*q12*q33-4*q13*q33-2*q23*q33-q33^2,2*q12*q13+2*q13*q23+q12*q33+q23*q33)+tmpprf(1,2*ep+n1)*mbox1l(1+n1,1,0,1)*prf(-2*M`j'^2*n1*q12+4*M`j'^2*n1*q13-2*n1*q13^2+2*M`j'^2*n1*q23-2*n1*q13*q23+4*M`j'^2*n1*q33-3*n1*q13*q33-n1*q23*q33-n1*q33^2,2*q12*q13+2*q13*q23+q12*q33+q23*q33)+tmpprf(1,2*ep+n1)*mbox1l(1+n1,0,1,1)*prf(-4*M`j'^2*n1*q13+2*n1*q13^2-4*M`j'^2*n1*q33+3*n1*q13*q33+n1*q33^2,2*q12*q13+2*q13*q23+q12*q33+q23*q33)+tmpprf(1,2*ep+n1)*mbox1l(1+n1,0,2,1)*prf(8*M`j'^2*q12*q13-4*q12*q13^2+4*M`j'^2*q12*q33-4*q12*q13*q33-q12*q33^2,q12^2+2*q12*q23+q23^2)+tmpprf(1,2*ep+n1)*mbox1l(2+n1,1,1,1)*prf(-4*q12^2*q13^2-4*n1*q12^2*q13^2-8*M`j'^2*q12*q13*q23-8*M`j'^2*n1*q12*q13*q23+4*M`j'^2*q12^2*q33+4*M`j'^2*n1*q12^2*q33-4*q12^2*q13*q33-4*n1*q12^2*q13*q33-q12^2*q33^2-n1*q12^2*q33^2,q12^2+2*q12*q23+q23^2)+tmpprf(1,2*ep+n1)*mbox1l(2+n1,1,1,0)*prf(-8*M`j'^2*q12^2*q13-8*M`j'^2*n1*q12^2*q13+4*q12^2*q13^2+4*n1*q12^2*q13^2-2*M`j'^2*q12^2*q33-2*M`j'^2*n1*q12^2*q33+4*q12^2*q13*q33+4*n1*q12^2*q13*q33+2*M`j'^2*q12*q23*q33+2*M`j'^2*n1*q12*q23*q33+q12^2*q33^2+n1*q12^2*q33^2,2*q12^2*q13+4*q12*q13*q23+2*q13*q23^2+q12^2*q33+2*q12*q23*q33+q23^2*q33)+tmpprf(1,2*ep+n1)*mbox1l(1+n1,2,0,1)*prf(-8*M`j'^2*q12^2*q13-16*M`j'^2*q12*q13^2+8*q12^2*q13^2+8*q12*q13^3-4*M`j'^2*q12^2*q23-12*M`j'^2*q12*q13*q23+8*q12*q13^2*q23-8*M`j'^2*q12*q23^2-4*M`j'^2*q13*q23^2-4*M`j'^2*q23^3-2*M`j'^2*q12^2*q33-16*M`j'^2*q12*q13*q33+8*q12^2*q13*q33+12*q12*q13^2*q33-2*M`j'^2*q12*q23*q33+8*q12*q13*q23*q33-4*M`j'^2*q12*q33^2+2*q12^2*q33^2+6*q12*q13*q33^2+2*q12*q23*q33^2+q12*q33^3,2*q12^2*q13+4*q12*q13*q23+2*q13*q23^2+q12^2*q33+2*q12*q23*q33+q23^2*q33)+tmpprf(1,2*ep+n1)*mbox1l(2+n1,0,1,1)*prf(4*M`j'^2*q12*q13^2+4*M`j'^2*n1*q12*q13^2-4*q12*q13^3-4*n1*q12*q13^3-4*M`j'^2*q13^2*q23-4*M`j'^2*n1*q13^2*q23+12*M`j'^2*q12*q13*q33+12*M`j'^2*n1*q12*q13*q33-8*q12*q13^2*q33-8*n1*q12*q13^2*q33+4*M`j'^2*q12*q33^2+4*M`j'^2*n1*q12*q33^2-5*q12*q13*q33^2-5*n1*q12*q13*q33^2-q12*q33^3-n1*q12*q33^3,2*q12^2*q13+4*q12*q13*q23+2*q13*q23^2+q12^2*q33+2*q12*q23*q33+q23^2*q33)+tmpprf(1,2*ep+n1)*mbox1l(2+n1,1,0,1)*prf(4*M`j'^2*q12^2*q13+4*M`j'^2*n1*q12^2*q13-4*M`j'^2*q12*q13^2-4*M`j'^2*n1*q12*q13^2+4*q12*q13^3+4*n1*q12*q13^3+4*M`j'^2*q13^2*q23+4*M`j'^2*n1*q13^2*q23+4*q12*q13^2*q23+4*n1*q12*q13^2*q23+4*M`j'^2*q13*q23^2+4*M`j'^2*n1*q13*q23^2-2*M`j'^2*q12^2*q33-2*M`j'^2*n1*q12^2*q33-12*M`j'^2*q12*q13*q33-12*M`j'^2*n1*q12*q13*q33+8*q12*q13^2*q33+8*n1*q12*q13^2*q33-6*M`j'^2*q12*q23*q33-6*M`j'^2*n1*q12*q23*q33+4*q12*q13*q23*q33+4*n1*q12*q13*q23*q33-4*M`j'^2*q12*q33^2-4*M`j'^2*n1*q12*q33^2+5*q12*q13*q33^2+5*n1*q12*q13*q33^2+q12*q23*q33^2+n1*q12*q23*q33^2+q12*q33^3+n1*q12*q33^3,2*q12^2*q13+4*q12*q13*q23+2*q13*q23^2+q12^2*q33+2*q12*q23*q33+q23^2*q33);
	Identify,ifmatch->jump mbox1l(n1?pos_,n2?neg_,n3?pos_,n4?{,>1}) = mbox1l(-1+n1,1+n2,1+n3,-1+n4)*prf(-(n3*q12)-n3*q23,-q13+n4*q13)+mbox1l(n1,2+n2,n3,-2+n4)*prf(2*q12^2+2*n2*q12^2+2*q12*q23+2*n2*q12*q23,-2*q13^2+2*n4*q13^2-q13*q33+n4*q13*q33)+mbox1l(n1,1+n2,-1+n3,n4)*prf(2*q12+2*q13+2*q23+q33,2*q13+q33)+mbox1l(1+n1,1+n2,-1+n3,-1+n4)*prf(2*n1*q12*q13+2*n1*q12*q33+n1*q23*q33,-2*q13^2+2*n4*q13^2-q13*q33+n4*q13*q33)+mbox1l(-1+n1,2+n2,n3,-1+n4)*prf(-2*q12^2-2*n2*q12^2-2*q12*q13-2*n2*q12*q13-4*q12*q23-4*n2*q12*q23-2*q13*q23-2*n2*q13*q23-2*q23^2-2*n2*q23^2-q12*q33-n2*q12*q33-q23*q33-n2*q23*q33,-2*q13^2+2*n4*q13^2-q13*q33+n4*q13*q33)+mbox1l(n1,2+n2,-1+n3,-1+n4)*prf(2*q12*q23+2*n2*q12*q23+2*q13*q23+2*n2*q13*q23+2*q23^2+2*n2*q23^2+q23*q33+n2*q23*q33,-2*q13^2+2*n4*q13^2-q13*q33+n4*q13*q33)+mbox1l(n1,1+n2,n3,-1+n4)*prf(4*q12*q13-2*n1*q12*q13+2*n2*q12*q13+2*n3*q12*q13-2*n4*q12*q13+2*q13*q23+2*n3*q13*q23-2*n4*q13*q23+q12*q33-2*n1*q12*q33+n2*q12*q33+n3*q12*q33-n1*q23*q33+n3*q23*q33,-2*q13^2+2*n4*q13^2-q13*q33+n4*q13*q33);
	Identify,ifmatch->jump mbox1l(n1?pos_,n2?neg_,n3?{,>1},n4?pos_) = mbox1l(n1,1+n2,n3,-1+n4)*prf(q12*q33,2*q13^2)+mbox1l(n1,1+n2,-2+n3,1+n4)*prf(n4*q12*q33,-2*q13^2+2*n3*q13^2)+mbox1l(1+n1,1+n2,-1+n3,-1+n4)*prf(2*n1*q12*q13+n1*q12*q33,-2*q13^2+2*n3*q13^2)+mbox1l(n1,2+n2,-1+n3,-1+n4)*prf(4*M`j'^2*q12^2*q13+4*M`j'^2*n2*q12^2*q13+4*M`j'^2*q12*q13*q23+4*M`j'^2*n2*q12*q13*q23+4*M`j'^2*q12^2*q33+4*M`j'^2*n2*q12^2*q33+2*M`j'^2*q12*q13*q33+2*M`j'^2*n2*q12*q13*q33-2*q12^2*q13*q33-2*n2*q12^2*q13*q33-q12^2*q33^2-n2*q12^2*q33^2,-4*M`j'^2*q13^3+4*M`j'^2*n3*q13^3)+mbox1l(-1+n1,1+n2,n3,n4)*prf(-4*M`j'^2*q12*q13^2-4*M`j'^2*q13^2*q23-8*M`j'^2*q12*q13*q33+4*q12*q13^2*q33-4*M`j'^2*q12*q33^2+4*q12*q13*q33^2+q12*q33^3,4*M`j'^2*q13^3)+mbox1l(1+n1,1+n2,-2+n3,n4)*prf(6*M`j'^2*n1*q12*q13*q33+4*M`j'^2*n1*q12*q33^2-2*n1*q12*q13*q33^2-n1*q12*q33^3,-4*M`j'^2*q13^3+4*M`j'^2*n3*q13^3)+mbox1l(n1,2+n2,-2+n3,n4)*prf(4*M`j'^2*q12*q13^2+4*M`j'^2*n2*q12*q13^2+4*M`j'^2*q13^3+4*M`j'^2*n2*q13^3+4*M`j'^2*q12*q13*q23+4*M`j'^2*n2*q12*q13*q23+8*M`j'^2*q13^2*q23+8*M`j'^2*n2*q13^2*q23+4*M`j'^2*q13*q23^2+4*M`j'^2*n2*q13*q23^2+2*M`j'^2*q12*q13*q33+2*M`j'^2*n2*q12*q13*q33-2*q12*q13^2*q33-2*n2*q12*q13^2*q33+4*M`j'^2*q12*q23*q33+4*M`j'^2*n2*q12*q23*q33-2*q12*q13*q23*q33-2*n2*q12*q13*q23*q33+4*M`j'^2*q12*q33^2+4*M`j'^2*n2*q12*q33^2-3*q12*q13*q33^2-3*n2*q12*q13*q33^2-q12*q23*q33^2-n2*q12*q23*q33^2-q12*q33^3-n2*q12*q33^3,-4*M`j'^2*q13^3+4*M`j'^2*n3*q13^3)+mbox1l(-1+n1,2+n2,-1+n3,n4)*prf(-4*M`j'^2*q12^2*q13-4*M`j'^2*n2*q12^2*q13-4*M`j'^2*q12*q13^2-4*M`j'^2*n2*q12*q13^2-8*M`j'^2*q12*q13*q23-8*M`j'^2*n2*q12*q13*q23-4*M`j'^2*q13^2*q23-4*M`j'^2*n2*q13^2*q23-4*M`j'^2*q13*q23^2-4*M`j'^2*n2*q13*q23^2-4*M`j'^2*q12^2*q33-4*M`j'^2*n2*q12^2*q33-8*M`j'^2*q12*q13*q33-8*M`j'^2*n2*q12*q13*q33+2*q12^2*q13*q33+2*n2*q12^2*q13*q33+4*q12*q13^2*q33+4*n2*q12*q13^2*q33-4*M`j'^2*q12*q23*q33-4*M`j'^2*n2*q12*q23*q33+2*q12*q13*q23*q33+2*n2*q12*q13*q23*q33-4*M`j'^2*q12*q33^2-4*M`j'^2*n2*q12*q33^2+q12^2*q33^2+n2*q12^2*q33^2+4*q12*q13*q33^2+4*n2*q12*q13*q33^2+q12*q23*q33^2+n2*q12*q23*q33^2+q12*q33^3+n2*q12*q33^3,-4*M`j'^2*q13^3+4*M`j'^2*n3*q13^3)+mbox1l(n1,1+n2,-1+n3,n4)*(tmpprf(ep,1)*prf(4*q12*q13^2*q33+2*q12*q13*q33^2,-4*M`j'^2*q13^3+4*M`j'^2*n3*q13^3)+prf(-4*M`j'^2*q12*q13^2-4*M`j'^2*n1*q12*q13^2+4*M`j'^2*n3*q12*q13^2-8*M`j'^2*q13^3-4*M`j'^2*n2*q13^3+4*M`j'^2*n3*q13^3-8*M`j'^2*q13^2*q23-4*M`j'^2*n2*q13^2*q23+4*M`j'^2*n3*q13^2*q23-2*M`j'^2*q12*q13*q33-8*M`j'^2*n1*q12*q13*q33+4*M`j'^2*n2*q12*q13*q33+6*M`j'^2*n3*q12*q13*q33-2*M`j'^2*n4*q12*q13*q33-6*q12*q13^2*q33+4*n1*q12*q13^2*q33+2*n2*q12*q13^2*q33+4*n4*q12*q13^2*q33-4*M`j'^2*q12*q33^2-4*M`j'^2*n1*q12*q33^2+4*M`j'^2*n3*q12*q33^2-q12*q13*q33^2+4*n1*q12*q13*q33^2+n2*q12*q13*q33^2-2*n3*q12*q13*q33^2+2*n4*q12*q13*q33^2+q12*q33^3+n1*q12*q33^3-n3*q12*q33^3,-4*M`j'^2*q13^3+4*M`j'^2*n3*q13^3))+mbox1l(n1,2+n2,-1+n3,n4)*prf(4*q12^2*q13^2*q33+4*n2*q12^2*q13^2*q33+8*M`j'^2*q12*q13*q23*q33+8*M`j'^2*n2*q12*q13*q23*q33-4*M`j'^2*q12^2*q33^2-4*M`j'^2*n2*q12^2*q33^2+4*q12^2*q13*q33^2+4*n2*q12^2*q13*q33^2+q12^2*q33^3+n2*q12^2*q33^3,-4*M`j'^2*q13^3+4*M`j'^2*n3*q13^3);
	Identify,ifmatch->jump mbox1l(n1?{,>1},n2?neg_,n3?pos_,n4?pos_) = mbox1l(n1,1+n2,n3,-1+n4)*prf(-4*q12*q13-q12*q33,2*q13^2)+mbox1l(-1+n1,1+n2,1+n3,-1+n4)*prf(-2*n3*q12*q13-n3*q12*q33,-2*q13^2+2*n1*q13^2)+mbox1l(-1+n1,1+n2,-1+n3,1+n4)*prf(-2*n4*q12*q13-n4*q12*q33,-2*q13^2+2*n1*q13^2)+mbox1l(-1+n1,2+n2,n3,-1+n4)*prf(-12*M`j'^2*q12^2*q13-12*M`j'^2*n2*q12^2*q13-4*M`j'^2*q12*q13^2-4*M`j'^2*n2*q12*q13^2+4*q12^2*q13^2+4*n2*q12^2*q13^2-4*M`j'^2*q12*q13*q23-4*M`j'^2*n2*q12*q13*q23-4*M`j'^2*q12^2*q33-4*M`j'^2*n2*q12^2*q33-2*M`j'^2*q12*q13*q33-2*M`j'^2*n2*q12*q13*q33+4*q12^2*q13*q33+4*n2*q12^2*q13*q33+q12^2*q33^2+n2*q12^2*q33^2,-4*M`j'^2*q13^3+4*M`j'^2*n1*q13^3)+mbox1l(n1,1+n2,-1+n3,n4)*prf(-4*M`j'^2*q12*q13^2+4*M`j'^2*q13^3+4*M`j'^2*q13^2*q23-14*M`j'^2*q12*q13*q33+4*q12*q13^2*q33-4*M`j'^2*q12*q33^2+4*q12*q13*q33^2+q12*q33^3,4*M`j'^2*q13^3)+mbox1l(-2+n1,2+n2,n3,n4)*prf(12*M`j'^2*q12^2*q13+12*M`j'^2*n2*q12^2*q13+16*M`j'^2*q12*q13^2+16*M`j'^2*n2*q12*q13^2-4*q12^2*q13^2-4*n2*q12^2*q13^2-8*q12*q13^3-8*n2*q12*q13^3+16*M`j'^2*q12*q13*q23+16*M`j'^2*n2*q12*q13*q23-4*q12*q13^2*q23-4*n2*q12*q13^2*q23+4*M`j'^2*q13*q23^2+4*M`j'^2*n2*q13*q23^2+4*M`j'^2*q12^2*q33+4*M`j'^2*n2*q12^2*q33+16*M`j'^2*q12*q13*q33+16*M`j'^2*n2*q12*q13*q33-4*q12^2*q13*q33-4*n2*q12^2*q13*q33-12*q12*q13^2*q33-12*n2*q12*q13^2*q33+4*M`j'^2*q12*q23*q33+4*M`j'^2*n2*q12*q23*q33-4*q12*q13*q23*q33-4*n2*q12*q13*q23*q33+4*M`j'^2*q12*q33^2+4*M`j'^2*n2*q12*q33^2-q12^2*q33^2-n2*q12^2*q33^2-6*q12*q13*q33^2-6*n2*q12*q13*q33^2-q12*q23*q33^2-n2*q12*q23*q33^2-q12*q33^3-n2*q12*q33^3,-4*M`j'^2*q13^3+4*M`j'^2*n1*q13^3)+mbox1l(-1+n1,2+n2,-1+n3,n4)*prf(-8*M`j'^2*q12*q13^2-8*M`j'^2*n2*q12*q13^2+4*q12*q13^3+4*n2*q12*q13^3-12*M`j'^2*q12*q13*q23-12*M`j'^2*n2*q12*q13*q23-4*M`j'^2*q13^2*q23-4*M`j'^2*n2*q13^2*q23+4*q12*q13^2*q23+4*n2*q12*q13^2*q23-4*M`j'^2*q13*q23^2-4*M`j'^2*n2*q13*q23^2-10*M`j'^2*q12*q13*q33-10*M`j'^2*n2*q12*q13*q33+8*q12*q13^2*q33+8*n2*q12*q13^2*q33-4*M`j'^2*q12*q23*q33-4*M`j'^2*n2*q12*q23*q33+4*q12*q13*q23*q33+4*n2*q12*q13*q23*q33-4*M`j'^2*q12*q33^2-4*M`j'^2*n2*q12*q33^2+5*q12*q13*q33^2+5*n2*q12*q13*q33^2+q12*q23*q33^2+n2*q12*q23*q33^2+q12*q33^3+n2*q12*q33^3,-4*M`j'^2*q13^3+4*M`j'^2*n1*q13^3)+mbox1l(-2+n1,1+n2,1+n3,n4)*prf(16*M`j'^2*n3*q12*q13^2-8*n3*q12*q13^3+16*M`j'^2*n3*q12*q13*q33-12*n3*q12*q13^2*q33+4*M`j'^2*n3*q12*q33^2-6*n3*q12*q13*q33^2-n3*q12*q33^3,-4*M`j'^2*q13^3+4*M`j'^2*n1*q13^3)+mbox1l(-1+n1,1+n2,n3,n4)*(tmpprf(ep,1)*prf(-8*q12*q13^3-8*q12*q13^2*q33-2*q12*q13*q33^2,-4*M`j'^2*q13^3+4*M`j'^2*n1*q13^3)+prf(-16*M`j'^2*q12*q13^2+12*M`j'^2*n1*q12*q13^2-4*M`j'^2*n2*q12*q13^2-12*M`j'^2*n3*q12*q13^2+4*M`j'^2*n4*q12*q13^2+20*q12*q13^3-8*n1*q12*q13^3-4*n2*q12*q13^3-8*n4*q12*q13^3+8*M`j'^2*q13^2*q23-4*M`j'^2*n1*q13^2*q23+4*M`j'^2*n2*q13^2*q23-20*M`j'^2*q12*q13*q33+16*M`j'^2*n1*q12*q13*q33-4*M`j'^2*n2*q12*q13*q33-14*M`j'^2*n3*q12*q13*q33+2*M`j'^2*n4*q12*q13*q33+24*q12*q13^2*q33-12*n1*q12*q13^2*q33-4*n2*q12*q13^2*q33+4*n3*q12*q13^2*q33-8*n4*q12*q13^2*q33-4*M`j'^2*q12*q33^2+4*M`j'^2*n1*q12*q33^2-4*M`j'^2*n3*q12*q33^2+9*q12*q13*q33^2-6*n1*q12*q13*q33^2-n2*q12*q13*q33^2+4*n3*q12*q13*q33^2-2*n4*q12*q13*q33^2+q12*q33^3-n1*q12*q33^3+n3*q12*q33^3,-4*M`j'^2*q13^3+4*M`j'^2*n1*q13^3))+mbox1l(-1+n1,2+n2,n3,n4)*prf(-8*q12^2*q13^3-8*n2*q12^2*q13^3-16*M`j'^2*q12*q13^2*q23-16*M`j'^2*n2*q12*q13^2*q23+8*M`j'^2*q12^2*q13*q33+8*M`j'^2*n2*q12^2*q13*q33-12*q12^2*q13^2*q33-12*n2*q12^2*q13^2*q33-8*M`j'^2*q12*q13*q23*q33-8*M`j'^2*n2*q12*q13*q23*q33+4*M`j'^2*q12^2*q33^2+4*M`j'^2*n2*q12^2*q33^2-6*q12^2*q13*q33^2-6*n2*q12^2*q13*q33^2-q12^2*q33^3-n2*q12^2*q33^3,-4*M`j'^2*q13^3+4*M`j'^2*n1*q13^3);
	Identify,ifmatch->jump mbox1l(n1?pos_,n2?neg0_,n3?pos_,n4?{,>1}) = mbox1l(n1,n2,-1+n3,n4)*prf(1,-2*q13-q33)+mbox1l(-1+n1,n2,1+n3,-1+n4)*prf(n3,-q13+n4*q13)+mbox1l(n1,1+n2,n3,-2+n4)*prf(-(n2*q12),-2*q13^2+2*n4*q13^2-q13*q33+n4*q13*q33)+mbox1l(n1,1+n2,n3,-1+n4)*prf(n2*q12,-q13+n4*q13)+mbox1l(1+n1,n2,-1+n3,-1+n4)*prf(-(n1*q13)-n1*q33,-2*q13^2+2*n4*q13^2-q13*q33+n4*q13*q33)+mbox1l(n1,1+n2,-1+n3,-1+n4)*prf(-2*n2*q13-n2*q23-n2*q33,-2*q13^2+2*n4*q13^2-q13*q33+n4*q13*q33)+mbox1l(-1+n1,1+n2,n3,-1+n4)*prf(n2*q12+2*n2*q13+n2*q23+n2*q33,-2*q13^2+2*n4*q13^2-q13*q33+n4*q13*q33)+mbox1l(n1,n2,n3,-1+n4)*prf(-q13+n1*q13-2*n3*q13+n4*q13+n1*q33-n3*q33,-2*q13^2+2*n4*q13^2-q13*q33+n4*q13*q33);
	Identify,ifmatch->jump mbox1l(n1?pos_,n2?neg0_,n3?{,>1},n4?pos_) = mbox1l(n1,n2,n3,-1+n4)*prf(-1,2*q13)+mbox1l(1+n1,n2,-1+n3,-1+n4)*prf(-n1,-2*q13+2*n3*q13)+mbox1l(n1,n2,-2+n3,1+n4)*prf(-(n4*q33),-4*q13^2+4*n3*q13^2-2*q13*q33+2*n3*q13*q33)+mbox1l(-1+n1,n2,n3,n4)*prf(4*M`j'^2*q13+4*M`j'^2*q33-2*q13*q33-q33^2,4*M`j'^2*q13^2)+mbox1l(n1,1+n2,-1+n3,n4)*prf(-4*M`j'^2*n2*q13^2-4*M`j'^2*n2*q13*q23+4*M`j'^2*n2*q12*q33-2*n2*q12*q13*q33-n2*q12*q33^2,-4*M`j'^2*q13^2+4*M`j'^2*n3*q13^2)+mbox1l(n1,1+n2,-1+n3,-1+n4)*prf(-4*M`j'^2*n2*q12*q13-4*M`j'^2*n2*q13^2-4*M`j'^2*n2*q12*q33-2*M`j'^2*n2*q13*q33+2*n2*q12*q13*q33+n2*q12*q33^2,-8*M`j'^2*q13^3+8*M`j'^2*n3*q13^3-4*M`j'^2*q13^2*q33+4*M`j'^2*n3*q13^2*q33)+mbox1l(1+n1,n2,-2+n3,n4)*prf(-6*M`j'^2*n1*q13*q33-4*M`j'^2*n1*q33^2+2*n1*q13*q33^2+n1*q33^3,-8*M`j'^2*q13^3+8*M`j'^2*n3*q13^3-4*M`j'^2*q13^2*q33+4*M`j'^2*n3*q13^2*q33)+mbox1l(-1+n1,1+n2,-1+n3,n4)*prf(4*M`j'^2*n2*q12*q13+8*M`j'^2*n2*q13^2+4*M`j'^2*n2*q13*q23+4*M`j'^2*n2*q12*q33+12*M`j'^2*n2*q13*q33-2*n2*q12*q13*q33-4*n2*q13^2*q33+4*M`j'^2*n2*q23*q33-2*n2*q13*q23*q33+4*M`j'^2*n2*q33^2-n2*q12*q33^2-4*n2*q13*q33^2-n2*q23*q33^2-n2*q33^3,-8*M`j'^2*q13^3+8*M`j'^2*n3*q13^3-4*M`j'^2*q13^2*q33+4*M`j'^2*n3*q13^2*q33)+mbox1l(n1,1+n2,-2+n3,n4)*prf(-4*M`j'^2*n2*q13^2-4*M`j'^2*n2*q13*q23-10*M`j'^2*n2*q13*q33+2*n2*q13^2*q33-4*M`j'^2*n2*q23*q33+2*n2*q13*q23*q33-4*M`j'^2*n2*q33^2+3*n2*q13*q33^2+n2*q23*q33^2+n2*q33^3,-8*M`j'^2*q13^3+8*M`j'^2*n3*q13^3-4*M`j'^2*q13^2*q33+4*M`j'^2*n3*q13^2*q33)+mbox1l(n1,n2,-1+n3,n4)*(tmpprf(ep,1)*prf(-4*q13^2*q33-2*q13*q33^2,-8*M`j'^2*q13^3+8*M`j'^2*n3*q13^3-4*M`j'^2*q13^2*q33+4*M`j'^2*n3*q13^2*q33)+prf(4*M`j'^2*q13^2+4*M`j'^2*n1*q13^2-4*M`j'^2*n3*q13^2+10*M`j'^2*q13*q33+8*M`j'^2*n1*q13*q33-10*M`j'^2*n3*q13*q33+2*M`j'^2*n4*q13*q33+8*q13^2*q33-4*n1*q13^2*q33-2*n2*q13^2*q33-4*n4*q13^2*q33+4*M`j'^2*q33^2+4*M`j'^2*n1*q33^2-4*M`j'^2*n3*q33^2+2*q13*q33^2-4*n1*q13*q33^2-n2*q13*q33^2+2*n3*q13*q33^2-2*n4*q13*q33^2-q33^3-n1*q33^3+n3*q33^3,-8*M`j'^2*q13^3+8*M`j'^2*n3*q13^3-4*M`j'^2*q13^2*q33+4*M`j'^2*n3*q13^2*q33));
	Identify,ifmatch->jump mbox1l(n1?{,>1},n2?neg0_,n3?pos_,n4?pos_) = mbox1l(n1,n2,n3,-1+n4)*prf(1,2*q13)+mbox1l(-1+n1,n2,1+n3,-1+n4)*prf(n3,-2*q13+2*n1*q13)+mbox1l(-1+n1,n2,-1+n3,1+n4)*prf(n4,-2*q13+2*n1*q13)+mbox1l(-1+n1,1+n2,n3,-1+n4)*prf(4*M`j'^2*n2*q12+2*M`j'^2*n2*q13-2*n2*q12*q13-n2*q12*q33,-4*M`j'^2*q13^2+4*M`j'^2*n1*q13^2)+mbox1l(n1,n2,-1+n3,n4)*prf(2*M`j'^2*q13+4*M`j'^2*q33-2*q13*q33-q33^2,4*M`j'^2*q13^2)+mbox1l(-1+n1,1+n2,-1+n3,n4)*prf(6*M`j'^2*n2*q13-2*n2*q13^2+4*M`j'^2*n2*q23-2*n2*q13*q23+4*M`j'^2*n2*q33-3*n2*q13*q33-n2*q23*q33-n2*q33^2,-4*M`j'^2*q13^2+4*M`j'^2*n1*q13^2)+mbox1l(-2+n1,1+n2,n3,n4)*prf(-4*M`j'^2*n2*q12-8*M`j'^2*n2*q13+2*n2*q12*q13+4*n2*q13^2-4*M`j'^2*n2*q23+2*n2*q13*q23-4*M`j'^2*n2*q33+n2*q12*q33+4*n2*q13*q33+n2*q23*q33+n2*q33^2,-4*M`j'^2*q13^2+4*M`j'^2*n1*q13^2)+mbox1l(-1+n1,n2,n3,n4)*(tmpprf(ep,1)*prf(4*q13^2+2*q13*q33,-4*M`j'^2*q13^2+4*M`j'^2*n1*q13^2)+prf(4*M`j'^2*q13-4*M`j'^2*n1*q13+6*M`j'^2*n3*q13-2*M`j'^2*n4*q13-12*q13^2+4*n1*q13^2+2*n2*q13^2+4*n4*q13^2+4*M`j'^2*q33-4*M`j'^2*n1*q33+4*M`j'^2*n3*q33-8*q13*q33+4*n1*q13*q33+n2*q13*q33-2*n3*q13*q33+2*n4*q13*q33-q33^2+n1*q33^2-n3*q33^2,-4*M`j'^2*q13^2+4*M`j'^2*n1*q13^2))+mbox1l(-2+n1,n2,1+n3,n4)*prf(-8*M`j'^2*n3*q13+4*n3*q13^2-4*M`j'^2*n3*q33+4*n3*q13*q33+n3*q33^2,-4*M`j'^2*q13^2+4*M`j'^2*n1*q13^2)+mbox1l(-1+n1,1+n2,n3,n4)*prf(-4*M`j'^2*n2*q12*q13+4*n2*q12*q13^2+4*M`j'^2*n2*q13*q23-4*M`j'^2*n2*q12*q33+4*n2*q12*q13*q33+n2*q12*q33^2,-4*M`j'^2*q13^2+4*M`j'^2*n1*q13^2);
	Identify,ifmatch->jump mbox1l(n1?pos_,n2?neg0_,n3?pos_,n4?{,>1}) = mbox1l(n1,n2,1+n3,-1+n4)*prf(n3,-1+n4)+mbox1l(1+n1,1+n2,n3,-2+n4)*prf(-2*n2*q12,-2*q13+2*n4*q13-q33+n4*q33)+mbox1l(1+n1,n2,-1+n3,n4)*prf(q33,2*q13+q33)+mbox1l(2+n1,n2,-1+n3,-1+n4)*prf(-q33-n1*q33,-2*q13+2*n4*q13-q33+n4*q33)+mbox1l(1+n1,1+n2,-1+n3,-1+n4)*prf(-2*n2*q13-2*n2*q23-n2*q33,-2*q13+2*n4*q13-q33+n4*q33)+mbox1l(n1,1+n2,n3,-1+n4)*prf(2*n2*q12+2*n2*q13+2*n2*q23+n2*q33,-2*q13+2*n4*q13-q33+n4*q33)+mbox1l(1+n1,n2,n3,-1+n4)*prf(-2*q13-2*n3*q13+2*n4*q13+q33+n1*q33-n3*q33,-2*q13+2*n4*q13-q33+n4*q33);
	Identify,ifmatch->jump mbox1l(1,n2?neg_,1,1) = tmpprf(1,2*ep+n2)*mbox1l(1,n2,0,2)*prf(-2*M`j'^2,2*q13+q33)+tmpprf(1,2*ep+n2)*mbox1l(1,n2,2,0)*prf(-2*M`j'^2,2*q13+q33)+tmpprf(1,2*ep+n2)*mbox1l(2,n2,1,0)*prf(-2*M`j'^2,2*q13+q33)+tmpprf(1,2*ep+n2)*mbox1l(1,1+n2,0,2)*prf(-2*M`j'^2*q12,q13)+tmpprf(1,2*ep+n2)*mbox1l(1,1+n2,2,0)*prf(-2*M`j'^2*q12,q13)+tmpprf(1,2*ep+n2)*mbox1l(0,n2,2,1)*prf(4*M`j'^2-2*q13-q33,q13)+tmpprf(1,2*ep+n2)*mbox1l(2,1+n2,1,0)*prf(-8*M`j'^2*q12*q13-2*M`j'^2*q12*q33,2*q13^2+q13*q33)+mbox1l(1,1+n2,1,1)*(tmpprf(ep,2*ep+n2)*prf(-4*q12*q13-2*q12*q33,q13)+tmpprf(1,2*ep+n2)*prf(-2*q12*q13-4*n2*q12*q13-q12*q33-2*n2*q12*q33,q13))+tmpprf(1,2*ep+n2)*mbox1l(1,1+n2,1,0)*prf(-4*M`j'^2*n2*q12-2*M`j'^2*n2*q13+2*n2*q12*q13+n2*q12*q33,2*q13^2+q13*q33)+tmpprf(1,2*ep+n2)*mbox1l(2,n2,0,1)*prf(-2*M`j'^2*q13-4*M`j'^2*q33+2*q13*q33+q33^2,2*q13^2+q13*q33)+tmpprf(1,2*ep+n2)*mbox1l(0,1+n2,1,1)*prf(4*M`j'^2*n2*q12+8*M`j'^2*n2*q13-2*n2*q12*q13-4*n2*q13^2+4*M`j'^2*n2*q23-2*n2*q13*q23+4*M`j'^2*n2*q33-n2*q12*q33-4*n2*q13*q33-n2*q23*q33-n2*q33^2,2*q13^2+q13*q33)+tmpprf(1,2*ep+n2)*mbox1l(1,1+n2,0,1)*prf(-6*M`j'^2*n2*q13+2*n2*q13^2-4*M`j'^2*n2*q23+2*n2*q13*q23-4*M`j'^2*n2*q33+3*n2*q13*q33+n2*q23*q33+n2*q33^2,2*q13^2+q13*q33)+tmpprf(1,2*ep+n2)*mbox1l(0,1+n2,2,1)*prf(8*M`j'^2*q12*q13-4*q12*q13^2+4*M`j'^2*q12*q33-4*q12*q13*q33-q12*q33^2,q13^2)+tmpprf(1,2*ep+n2)*mbox1l(1,2+n2,1,1)*prf(-4*q12^2*q13^2-4*n2*q12^2*q13^2-8*M`j'^2*q12*q13*q23-8*M`j'^2*n2*q12*q13*q23+4*M`j'^2*q12^2*q33+4*M`j'^2*n2*q12^2*q33-4*q12^2*q13*q33-4*n2*q12^2*q13*q33-q12^2*q33^2-n2*q12^2*q33^2,q13^2)+tmpprf(1,2*ep+n2)*mbox1l(1,2+n2,1,0)*prf(-12*M`j'^2*q12^2*q13-12*M`j'^2*n2*q12^2*q13-4*M`j'^2*q12*q13^2-4*M`j'^2*n2*q12*q13^2+4*q12^2*q13^2+4*n2*q12^2*q13^2-4*M`j'^2*q12*q13*q23-4*M`j'^2*n2*q12*q13*q23-4*M`j'^2*q12^2*q33-4*M`j'^2*n2*q12^2*q33-2*M`j'^2*q12*q13*q33-2*M`j'^2*n2*q12*q13*q33+4*q12^2*q13*q33+4*n2*q12^2*q13*q33+q12^2*q33^2+n2*q12^2*q33^2,2*q13^3+q13^2*q33)+tmpprf(1,2*ep+n2)*mbox1l(2,1+n2,0,1)*prf(-4*M`j'^2*q12*q13^2+4*M`j'^2*q13^3+4*M`j'^2*q13^2*q23-14*M`j'^2*q12*q13*q33+4*q12*q13^2*q33-4*M`j'^2*q12*q33^2+4*q12*q13*q33^2+q12*q33^3,2*q13^3+q13^2*q33)+tmpprf(1,2*ep+n2)*mbox1l(0,2+n2,1,1)*prf(12*M`j'^2*q12^2*q13+12*M`j'^2*n2*q12^2*q13+16*M`j'^2*q12*q13^2+16*M`j'^2*n2*q12*q13^2-4*q12^2*q13^2-4*n2*q12^2*q13^2-8*q12*q13^3-8*n2*q12*q13^3+16*M`j'^2*q12*q13*q23+16*M`j'^2*n2*q12*q13*q23-4*q12*q13^2*q23-4*n2*q12*q13^2*q23+4*M`j'^2*q13*q23^2+4*M`j'^2*n2*q13*q23^2+4*M`j'^2*q12^2*q33+4*M`j'^2*n2*q12^2*q33+16*M`j'^2*q12*q13*q33+16*M`j'^2*n2*q12*q13*q33-4*q12^2*q13*q33-4*n2*q12^2*q13*q33-12*q12*q13^2*q33-12*n2*q12*q13^2*q33+4*M`j'^2*q12*q23*q33+4*M`j'^2*n2*q12*q23*q33-4*q12*q13*q23*q33-4*n2*q12*q13*q23*q33+4*M`j'^2*q12*q33^2+4*M`j'^2*n2*q12*q33^2-q12^2*q33^2-n2*q12^2*q33^2-6*q12*q13*q33^2-6*n2*q12*q13*q33^2-q12*q23*q33^2-n2*q12*q23*q33^2-q12*q33^3-n2*q12*q33^3,2*q13^3+q13^2*q33)+tmpprf(1,2*ep+n2)*mbox1l(1,2+n2,0,1)*prf(-8*M`j'^2*q12*q13^2-8*M`j'^2*n2*q12*q13^2+4*q12*q13^3+4*n2*q12*q13^3-12*M`j'^2*q12*q13*q23-12*M`j'^2*n2*q12*q13*q23-4*M`j'^2*q13^2*q23-4*M`j'^2*n2*q13^2*q23+4*q12*q13^2*q23+4*n2*q12*q13^2*q23-4*M`j'^2*q13*q23^2-4*M`j'^2*n2*q13*q23^2-10*M`j'^2*q12*q13*q33-10*M`j'^2*n2*q12*q13*q33+8*q12*q13^2*q33+8*n2*q12*q13^2*q33-4*M`j'^2*q12*q23*q33-4*M`j'^2*n2*q12*q23*q33+4*q12*q13*q23*q33+4*n2*q12*q13*q23*q33-4*M`j'^2*q12*q33^2-4*M`j'^2*n2*q12*q33^2+5*q12*q13*q33^2+5*n2*q12*q13*q33^2+q12*q23*q33^2+n2*q12*q23*q33^2+q12*q33^3+n2*q12*q33^3,2*q13^3+q13^2*q33);
	Identify,ifmatch->jump mbox1l(n1?pos_,n2?pos_,n3?neg_,n4?{,>1}) = mbox1l(n1,n2,2+n3,-2+n4)*prf(-2*M`j'^2*q12^2*q13^2-2*M`j'^2*n3*q12^2*q13^2+2*q12^3*q13^2+2*n3*q12^3*q13^2+2*q12^3*q13*q23+2*n3*q12^3*q13*q23+2*M`j'^2*q12^2*q23^2+2*M`j'^2*n3*q12^2*q23^2-2*M`j'^2*q12^2*q13*q33-2*M`j'^2*n3*q12^2*q13*q33+3*q12^3*q13*q33+3*n3*q12^3*q13*q33+2*M`j'^2*q12^2*q23*q33+2*M`j'^2*n3*q12^2*q23*q33+q12^3*q23*q33+n3*q12^3*q23*q33+q12^3*q33^2+n3*q12^3*q33^2,-2*M`j'^2*q13^4+2*M`j'^2*n4*q13^4-8*M`j'^2*q13^3*q23+8*M`j'^2*n4*q13^3*q23-12*M`j'^2*q13^2*q23^2+12*M`j'^2*n4*q13^2*q23^2-8*M`j'^2*q13*q23^3+8*M`j'^2*n4*q13*q23^3-2*M`j'^2*q23^4+2*M`j'^2*n4*q23^4+8*M`j'^2*q12*q13^2*q33-8*M`j'^2*n4*q12*q13^2*q33-2*q12^2*q13^2*q33+2*n4*q12^2*q13^2*q33-2*q12*q13^3*q33+2*n4*q12*q13^3*q33+16*M`j'^2*q12*q13*q23*q33-16*M`j'^2*n4*q12*q13*q23*q33-4*q12^2*q13*q23*q33+4*n4*q12^2*q13*q23*q33-6*q12*q13^2*q23*q33+6*n4*q12*q13^2*q23*q33+8*M`j'^2*q12*q23^2*q33-8*M`j'^2*n4*q12*q23^2*q33-2*q12^2*q23^2*q33+2*n4*q12^2*q23^2*q33-6*q12*q13*q23^2*q33+6*n4*q12*q13*q23^2*q33-2*q12*q23^3*q33+2*n4*q12*q23^3*q33-8*M`j'^2*q12^2*q33^2+8*M`j'^2*n4*q12^2*q33^2+4*q12^3*q33^2-4*n4*q12^3*q33^2+4*q12^2*q13*q33^2-4*n4*q12^2*q13*q33^2-q12*q13^2*q33^2+n4*q12*q13^2*q33^2+4*q12^2*q23*q33^2-4*n4*q12^2*q23*q33^2-2*q12*q13*q23*q33^2+2*n4*q12*q13*q23*q33^2-q12*q23^2*q33^2+n4*q12*q23^2*q33^2+2*q12^2*q33^3-2*n4*q12^2*q33^3)+mbox1l(-1+n1,1+n2,1+n3,-1+n4)*prf(8*M`j'^2*n2*q12^2*q13^2-4*n2*q12^3*q13^2+2*M`j'^2*n2*q12*q13^3-4*n2*q12^2*q13^3+8*M`j'^2*n2*q12^2*q13*q23-4*n2*q12^3*q13*q23+6*M`j'^2*n2*q12*q13^2*q23-8*n2*q12^2*q13^2*q23+2*M`j'^2*n2*q13^3*q23+6*M`j'^2*n2*q12*q13*q23^2-4*n2*q12^2*q13*q23^2+6*M`j'^2*n2*q13^2*q23^2+2*M`j'^2*n2*q12*q23^3+6*M`j'^2*n2*q13*q23^3+2*M`j'^2*n2*q23^4-8*M`j'^2*n2*q12^3*q33+4*n2*q12^4*q33+4*M`j'^2*n2*q12^2*q13*q33-6*n2*q12^2*q13^2*q33-12*M`j'^2*n2*q12^2*q23*q33+8*n2*q12^3*q23*q33-8*M`j'^2*n2*q12*q13*q23*q33+2*n2*q12*q13^2*q23*q33-8*M`j'^2*n2*q12*q23^2*q33+6*n2*q12^2*q23^2*q33+4*n2*q12*q13*q23^2*q33+2*n2*q12*q23^3*q33+4*M`j'^2*n2*q12^2*q33^2-4*n2*q12^2*q13*q33^2+n2*q12*q13*q23*q33^2+n2*q12*q23^2*q33^2-n2*q12^2*q33^3,-2*M`j'^2*q13^4+2*M`j'^2*n4*q13^4-8*M`j'^2*q13^3*q23+8*M`j'^2*n4*q13^3*q23-12*M`j'^2*q13^2*q23^2+12*M`j'^2*n4*q13^2*q23^2-8*M`j'^2*q13*q23^3+8*M`j'^2*n4*q13*q23^3-2*M`j'^2*q23^4+2*M`j'^2*n4*q23^4+8*M`j'^2*q12*q13^2*q33-8*M`j'^2*n4*q12*q13^2*q33-2*q12^2*q13^2*q33+2*n4*q12^2*q13^2*q33-2*q12*q13^3*q33+2*n4*q12*q13^3*q33+16*M`j'^2*q12*q13*q23*q33-16*M`j'^2*n4*q12*q13*q23*q33-4*q12^2*q13*q23*q33+4*n4*q12^2*q13*q23*q33-6*q12*q13^2*q23*q33+6*n4*q12*q13^2*q23*q33+8*M`j'^2*q12*q23^2*q33-8*M`j'^2*n4*q12*q23^2*q33-2*q12^2*q23^2*q33+2*n4*q12^2*q23^2*q33-6*q12*q13*q23^2*q33+6*n4*q12*q13*q23^2*q33-2*q12*q23^3*q33+2*n4*q12*q23^3*q33-8*M`j'^2*q12^2*q33^2+8*M`j'^2*n4*q12^2*q33^2+4*q12^3*q33^2-4*n4*q12^3*q33^2+4*q12^2*q13*q33^2-4*n4*q12^2*q13*q33^2-q12*q13^2*q33^2+n4*q12*q13^2*q33^2+4*q12^2*q23*q33^2-4*n4*q12^2*q23*q33^2-2*q12*q13*q23*q33^2+2*n4*q12*q13*q23*q33^2-q12*q23^2*q33^2+n4*q12*q23^2*q33^2+2*q12^2*q33^3-2*n4*q12^2*q33^3)+mbox1l(1+n1,n2,1+n3,-2+n4)*prf(8*M`j'^2*n1*q12^2*q13^3+12*M`j'^2*n1*q12^2*q13^2*q23-4*M`j'^2*n1*q12*q13^3*q23-12*M`j'^2*n1*q12*q13^2*q23^2-4*M`j'^2*n1*q12^2*q23^3-12*M`j'^2*n1*q12*q13*q23^3-4*M`j'^2*n1*q12*q23^4-12*M`j'^2*n1*q12^3*q13*q33+4*n1*q12^4*q13*q33+10*M`j'^2*n1*q12^2*q13^2*q33+4*n1*q12^3*q13^2*q33+4*M`j'^2*n1*q12^3*q23*q33-4*n1*q12^4*q23*q33+20*M`j'^2*n1*q12^2*q13*q23*q33-4*n1*q12^3*q13*q23*q33-4*n1*q12^2*q13^2*q23*q33+10*M`j'^2*n1*q12^2*q23^2*q33-8*n1*q12^3*q23^2*q33-8*n1*q12^2*q13*q23^2*q33-4*n1*q12^2*q23^3*q33-12*M`j'^2*n1*q12^3*q33^2+4*n1*q12^4*q33^2+2*M`j'^2*n1*q12^2*q13*q33^2+6*n1*q12^3*q13*q33^2-2*M`j'^2*n1*q12^2*q23*q33^2+2*n1*q12^3*q23*q33^2-2*n1*q12^2*q13*q23*q33^2-2*n1*q12^2*q23^2*q33^2+2*n1*q12^3*q33^3,4*M`j'^2*q12*q13^4-4*M`j'^2*n4*q12*q13^4+4*M`j'^2*q13^5-4*M`j'^2*n4*q13^5+16*M`j'^2*q12*q13^3*q23-16*M`j'^2*n4*q12*q13^3*q23+20*M`j'^2*q13^4*q23-20*M`j'^2*n4*q13^4*q23+24*M`j'^2*q12*q13^2*q23^2-24*M`j'^2*n4*q12*q13^2*q23^2+40*M`j'^2*q13^3*q23^2-40*M`j'^2*n4*q13^3*q23^2+16*M`j'^2*q12*q13*q23^3-16*M`j'^2*n4*q12*q13*q23^3+40*M`j'^2*q13^2*q23^3-40*M`j'^2*n4*q13^2*q23^3+4*M`j'^2*q12*q23^4-4*M`j'^2*n4*q12*q23^4+20*M`j'^2*q13*q23^4-20*M`j'^2*n4*q13*q23^4+4*M`j'^2*q23^5-4*M`j'^2*n4*q23^5-16*M`j'^2*q12^2*q13^2*q33+16*M`j'^2*n4*q12^2*q13^2*q33+4*q12^3*q13^2*q33-4*n4*q12^3*q13^2*q33-16*M`j'^2*q12*q13^3*q33+16*M`j'^2*n4*q12*q13^3*q33+8*q12^2*q13^3*q33-8*n4*q12^2*q13^3*q33+2*M`j'^2*q13^4*q33-2*M`j'^2*n4*q13^4*q33+4*q12*q13^4*q33-4*n4*q12*q13^4*q33-32*M`j'^2*q12^2*q13*q23*q33+32*M`j'^2*n4*q12^2*q13*q23*q33+8*q12^3*q13*q23*q33-8*n4*q12^3*q13*q23*q33-48*M`j'^2*q12*q13^2*q23*q33+48*M`j'^2*n4*q12*q13^2*q23*q33+24*q12^2*q13^2*q23*q33-24*n4*q12^2*q13^2*q23*q33+8*M`j'^2*q13^3*q23*q33-8*M`j'^2*n4*q13^3*q23*q33+16*q12*q13^3*q23*q33-16*n4*q12*q13^3*q23*q33-16*M`j'^2*q12^2*q23^2*q33+16*M`j'^2*n4*q12^2*q23^2*q33+4*q12^3*q23^2*q33-4*n4*q12^3*q23^2*q33-48*M`j'^2*q12*q13*q23^2*q33+48*M`j'^2*n4*q12*q13*q23^2*q33+24*q12^2*q13*q23^2*q33-24*n4*q12^2*q13*q23^2*q33+12*M`j'^2*q13^2*q23^2*q33-12*M`j'^2*n4*q13^2*q23^2*q33+24*q12*q13^2*q23^2*q33-24*n4*q12*q13^2*q23^2*q33-16*M`j'^2*q12*q23^3*q33+16*M`j'^2*n4*q12*q23^3*q33+8*q12^2*q23^3*q33-8*n4*q12^2*q23^3*q33+8*M`j'^2*q13*q23^3*q33-8*M`j'^2*n4*q13*q23^3*q33+16*q12*q13*q23^3*q33-16*n4*q12*q13*q23^3*q33+2*M`j'^2*q23^4*q33-2*M`j'^2*n4*q23^4*q33+4*q12*q23^4*q33-4*n4*q12*q23^4*q33+16*M`j'^2*q12^3*q33^2-16*M`j'^2*n4*q12^3*q33^2-8*q12^4*q33^2+8*n4*q12^4*q33^2+16*M`j'^2*q12^2*q13*q33^2-16*M`j'^2*n4*q12^2*q13*q33^2-16*q12^3*q13*q33^2+16*n4*q12^3*q13*q33^2-8*M`j'^2*q12*q13^2*q33^2+8*M`j'^2*n4*q12*q13^2*q33^2-4*q12^2*q13^2*q33^2+4*n4*q12^2*q13^2*q33^2+4*q12*q13^3*q33^2-4*n4*q12*q13^3*q33^2+16*M`j'^2*q12^2*q23*q33^2-16*M`j'^2*n4*q12^2*q23*q33^2-16*q12^3*q23*q33^2+16*n4*q12^3*q23*q33^2-16*M`j'^2*q12*q13*q23*q33^2+16*M`j'^2*n4*q12*q13*q23*q33^2-8*q12^2*q13*q23*q33^2+8*n4*q12^2*q13*q23*q33^2+12*q12*q13^2*q23*q33^2-12*n4*q12*q13^2*q23*q33^2-8*M`j'^2*q12*q23^2*q33^2+8*M`j'^2*n4*q12*q23^2*q33^2-4*q12^2*q23^2*q33^2+4*n4*q12^2*q23^2*q33^2+12*q12*q13*q23^2*q33^2-12*n4*q12*q13*q23^2*q33^2+4*q12*q23^3*q33^2-4*n4*q12*q23^3*q33^2+8*M`j'^2*q12^2*q33^3-8*M`j'^2*n4*q12^2*q33^3-8*q12^3*q33^3+8*n4*q12^3*q33^3-8*q12^2*q13*q33^3+8*n4*q12^2*q13*q33^3+q12*q13^2*q33^3-n4*q12*q13^2*q33^3-8*q12^2*q23*q33^3+8*n4*q12^2*q23*q33^3+2*q12*q13*q23*q33^3-2*n4*q12*q13*q23*q33^3+q12*q23^2*q33^3-n4*q12*q23^2*q33^3-2*q12^2*q33^4+2*n4*q12^2*q33^4)+mbox1l(n1,1+n2,1+n3,-2+n4)*prf(16*M`j'^2*n2*q12^3*q13^2-8*n2*q12^4*q13^2+8*M`j'^2*n2*q12^2*q13^3-8*n2*q12^3*q13^3+16*M`j'^2*n2*q12^3*q13*q23-8*n2*q12^4*q13*q23+20*M`j'^2*n2*q12^2*q13^2*q23-16*n2*q12^3*q13^2*q23+4*M`j'^2*n2*q12*q13^3*q23+16*M`j'^2*n2*q12^2*q13*q23^2-8*n2*q12^3*q13*q23^2+12*M`j'^2*n2*q12*q13^2*q23^2+4*M`j'^2*n2*q12^2*q23^3+12*M`j'^2*n2*q12*q13*q23^3+4*M`j'^2*n2*q12*q23^4-16*M`j'^2*n2*q12^4*q33+8*n2*q12^5*q33+4*M`j'^2*n2*q12^3*q13*q33+6*M`j'^2*n2*q12^2*q13^2*q33-12*n2*q12^3*q13^2*q33-28*M`j'^2*n2*q12^3*q23*q33+16*n2*q12^4*q23*q33-12*M`j'^2*n2*q12^2*q13*q23*q33+4*n2*q12^2*q13^2*q23*q33-18*M`j'^2*n2*q12^2*q23^2*q33+12*n2*q12^3*q23^2*q33+8*n2*q12^2*q13*q23^2*q33+4*n2*q12^2*q23^3*q33+4*M`j'^2*n2*q12^3*q33^2+2*M`j'^2*n2*q12^2*q13*q33^2-8*n2*q12^3*q13*q33^2-2*M`j'^2*n2*q12^2*q23*q33^2+2*n2*q12^2*q13*q23*q33^2+2*n2*q12^2*q23^2*q33^2-2*n2*q12^3*q33^3,4*M`j'^2*q12*q13^4-4*M`j'^2*n4*q12*q13^4+4*M`j'^2*q13^5-4*M`j'^2*n4*q13^5+16*M`j'^2*q12*q13^3*q23-16*M`j'^2*n4*q12*q13^3*q23+20*M`j'^2*q13^4*q23-20*M`j'^2*n4*q13^4*q23+24*M`j'^2*q12*q13^2*q23^2-24*M`j'^2*n4*q12*q13^2*q23^2+40*M`j'^2*q13^3*q23^2-40*M`j'^2*n4*q13^3*q23^2+16*M`j'^2*q12*q13*q23^3-16*M`j'^2*n4*q12*q13*q23^3+40*M`j'^2*q13^2*q23^3-40*M`j'^2*n4*q13^2*q23^3+4*M`j'^2*q12*q23^4-4*M`j'^2*n4*q12*q23^4+20*M`j'^2*q13*q23^4-20*M`j'^2*n4*q13*q23^4+4*M`j'^2*q23^5-4*M`j'^2*n4*q23^5-16*M`j'^2*q12^2*q13^2*q33+16*M`j'^2*n4*q12^2*q13^2*q33+4*q12^3*q13^2*q33-4*n4*q12^3*q13^2*q33-16*M`j'^2*q12*q13^3*q33+16*M`j'^2*n4*q12*q13^3*q33+8*q12^2*q13^3*q33-8*n4*q12^2*q13^3*q33+2*M`j'^2*q13^4*q33-2*M`j'^2*n4*q13^4*q33+4*q12*q13^4*q33-4*n4*q12*q13^4*q33-32*M`j'^2*q12^2*q13*q23*q33+32*M`j'^2*n4*q12^2*q13*q23*q33+8*q12^3*q13*q23*q33-8*n4*q12^3*q13*q23*q33-48*M`j'^2*q12*q13^2*q23*q33+48*M`j'^2*n4*q12*q13^2*q23*q33+24*q12^2*q13^2*q23*q33-24*n4*q12^2*q13^2*q23*q33+8*M`j'^2*q13^3*q23*q33-8*M`j'^2*n4*q13^3*q23*q33+16*q12*q13^3*q23*q33-16*n4*q12*q13^3*q23*q33-16*M`j'^2*q12^2*q23^2*q33+16*M`j'^2*n4*q12^2*q23^2*q33+4*q12^3*q23^2*q33-4*n4*q12^3*q23^2*q33-48*M`j'^2*q12*q13*q23^2*q33+48*M`j'^2*n4*q12*q13*q23^2*q33+24*q12^2*q13*q23^2*q33-24*n4*q12^2*q13*q23^2*q33+12*M`j'^2*q13^2*q23^2*q33-12*M`j'^2*n4*q13^2*q23^2*q33+24*q12*q13^2*q23^2*q33-24*n4*q12*q13^2*q23^2*q33-16*M`j'^2*q12*q23^3*q33+16*M`j'^2*n4*q12*q23^3*q33+8*q12^2*q23^3*q33-8*n4*q12^2*q23^3*q33+8*M`j'^2*q13*q23^3*q33-8*M`j'^2*n4*q13*q23^3*q33+16*q12*q13*q23^3*q33-16*n4*q12*q13*q23^3*q33+2*M`j'^2*q23^4*q33-2*M`j'^2*n4*q23^4*q33+4*q12*q23^4*q33-4*n4*q12*q23^4*q33+16*M`j'^2*q12^3*q33^2-16*M`j'^2*n4*q12^3*q33^2-8*q12^4*q33^2+8*n4*q12^4*q33^2+16*M`j'^2*q12^2*q13*q33^2-16*M`j'^2*n4*q12^2*q13*q33^2-16*q12^3*q13*q33^2+16*n4*q12^3*q13*q33^2-8*M`j'^2*q12*q13^2*q33^2+8*M`j'^2*n4*q12*q13^2*q33^2-4*q12^2*q13^2*q33^2+4*n4*q12^2*q13^2*q33^2+4*q12*q13^3*q33^2-4*n4*q12*q13^3*q33^2+16*M`j'^2*q12^2*q23*q33^2-16*M`j'^2*n4*q12^2*q23*q33^2-16*q12^3*q23*q33^2+16*n4*q12^3*q23*q33^2-16*M`j'^2*q12*q13*q23*q33^2+16*M`j'^2*n4*q12*q13*q23*q33^2-8*q12^2*q13*q23*q33^2+8*n4*q12^2*q13*q23*q33^2+12*q12*q13^2*q23*q33^2-12*n4*q12*q13^2*q23*q33^2-8*M`j'^2*q12*q23^2*q33^2+8*M`j'^2*n4*q12*q23^2*q33^2-4*q12^2*q23^2*q33^2+4*n4*q12^2*q23^2*q33^2+12*q12*q13*q23^2*q33^2-12*n4*q12*q13*q23^2*q33^2+4*q12*q23^3*q33^2-4*n4*q12*q23^3*q33^2+8*M`j'^2*q12^2*q33^3-8*M`j'^2*n4*q12^2*q33^3-8*q12^3*q33^3+8*n4*q12^3*q33^3-8*q12^2*q13*q33^3+8*n4*q12^2*q13*q33^3+q12*q13^2*q33^3-n4*q12*q13^2*q33^3-8*q12^2*q23*q33^3+8*n4*q12^2*q23*q33^3+2*q12*q13*q23*q33^3-2*n4*q12*q13*q23*q33^3+q12*q23^2*q33^3-n4*q12*q23^2*q33^3-2*q12^2*q33^4+2*n4*q12^2*q33^4)+mbox1l(n1,n2,2+n3,-1+n4)*prf(4*q12^3*q13^3+4*n3*q12^3*q13^3+8*M`j'^2*q12^2*q13^2*q23+8*M`j'^2*n3*q12^2*q13^2*q23+4*q12^3*q13^2*q23+4*n3*q12^3*q13^2*q23+8*M`j'^2*q12^2*q13*q23^2+8*M`j'^2*n3*q12^2*q13*q23^2-4*M`j'^2*q12^3*q13*q33-4*M`j'^2*n3*q12^3*q13*q33+8*q12^3*q13^2*q33+8*n3*q12^3*q13^2*q33-4*M`j'^2*q12^3*q23*q33-4*M`j'^2*n3*q12^3*q23*q33+8*M`j'^2*q12^2*q13*q23*q33+8*M`j'^2*n3*q12^2*q13*q23*q33+4*q12^3*q13*q23*q33+4*n3*q12^3*q13*q23*q33-4*M`j'^2*q12^3*q33^2-4*M`j'^2*n3*q12^3*q33^2+5*q12^3*q13*q33^2+5*n3*q12^3*q13*q33^2+q12^3*q23*q33^2+n3*q12^3*q23*q33^2+q12^3*q33^3+n3*q12^3*q33^3,-2*M`j'^2*q13^4+2*M`j'^2*n4*q13^4-8*M`j'^2*q13^3*q23+8*M`j'^2*n4*q13^3*q23-12*M`j'^2*q13^2*q23^2+12*M`j'^2*n4*q13^2*q23^2-8*M`j'^2*q13*q23^3+8*M`j'^2*n4*q13*q23^3-2*M`j'^2*q23^4+2*M`j'^2*n4*q23^4+8*M`j'^2*q12*q13^2*q33-8*M`j'^2*n4*q12*q13^2*q33-2*q12^2*q13^2*q33+2*n4*q12^2*q13^2*q33-2*q12*q13^3*q33+2*n4*q12*q13^3*q33+16*M`j'^2*q12*q13*q23*q33-16*M`j'^2*n4*q12*q13*q23*q33-4*q12^2*q13*q23*q33+4*n4*q12^2*q13*q23*q33-6*q12*q13^2*q23*q33+6*n4*q12*q13^2*q23*q33+8*M`j'^2*q12*q23^2*q33-8*M`j'^2*n4*q12*q23^2*q33-2*q12^2*q23^2*q33+2*n4*q12^2*q23^2*q33-6*q12*q13*q23^2*q33+6*n4*q12*q13*q23^2*q33-2*q12*q23^3*q33+2*n4*q12*q23^3*q33-8*M`j'^2*q12^2*q33^2+8*M`j'^2*n4*q12^2*q33^2+4*q12^3*q33^2-4*n4*q12^3*q33^2+4*q12^2*q13*q33^2-4*n4*q12^2*q13*q33^2-q12*q13^2*q33^2+n4*q12*q13^2*q33^2+4*q12^2*q23*q33^2-4*n4*q12^2*q23*q33^2-2*q12*q13*q23*q33^2+2*n4*q12*q13*q23*q33^2-q12*q23^2*q33^2+n4*q12*q23^2*q33^2+2*q12^2*q33^3-2*n4*q12^2*q33^3)+mbox1l(n1,-1+n2,1+n3,n4)*prf(4*M`j'^2*q12^2*q13^3-4*M`j'^2*q13^5+8*M`j'^2*q12^2*q13^2*q23-16*M`j'^2*q13^4*q23+4*M`j'^2*q12^2*q13*q23^2-24*M`j'^2*q13^3*q23^2-16*M`j'^2*q13^2*q23^3-4*M`j'^2*q13*q23^4-4*M`j'^2*q12^3*q13*q33+6*M`j'^2*q12^2*q13^2*q33+16*M`j'^2*q12*q13^3*q33-4*q12^2*q13^3*q33-2*M`j'^2*q13^4*q33-4*q12*q13^4*q33-4*M`j'^2*q12^3*q23*q33+4*M`j'^2*q12^2*q13*q23*q33+32*M`j'^2*q12*q13^2*q23*q33-8*q12^2*q13^2*q23*q33-8*M`j'^2*q13^3*q23*q33-12*q12*q13^3*q23*q33-2*M`j'^2*q12^2*q23^2*q33+16*M`j'^2*q12*q13*q23^2*q33-4*q12^2*q13*q23^2*q33-12*M`j'^2*q13^2*q23^2*q33-12*q12*q13^2*q23^2*q33-8*M`j'^2*q13*q23^3*q33-4*q12*q13*q23^3*q33-2*M`j'^2*q23^4*q33-4*M`j'^2*q12^3*q33^2-14*M`j'^2*q12^2*q13*q33^2+8*q12^3*q13*q33^2+8*M`j'^2*q12*q13^2*q33^2+6*q12^2*q13^2*q33^2-4*q12*q13^3*q33^2-2*M`j'^2*q12^2*q23*q33^2+16*M`j'^2*q12*q13*q23*q33^2+4*q12^2*q13*q23*q33^2-10*q12*q13^2*q23*q33^2+8*M`j'^2*q12*q23^2*q33^2-2*q12^2*q23^2*q33^2-8*q12*q13*q23^2*q33^2-2*q12*q23^3*q33^2-8*M`j'^2*q12^2*q33^3+4*q12^3*q33^3+8*q12^2*q13*q33^3-q12*q13^2*q33^3+4*q12^2*q23*q33^3-2*q12*q13*q23*q33^3-q12*q23^2*q33^3+2*q12^2*q33^4,-4*M`j'^2*q12*q13^4-4*M`j'^2*q13^5-16*M`j'^2*q12*q13^3*q23-20*M`j'^2*q13^4*q23-24*M`j'^2*q12*q13^2*q23^2-40*M`j'^2*q13^3*q23^2-16*M`j'^2*q12*q13*q23^3-40*M`j'^2*q13^2*q23^3-4*M`j'^2*q12*q23^4-20*M`j'^2*q13*q23^4-4*M`j'^2*q23^5+16*M`j'^2*q12^2*q13^2*q33-4*q12^3*q13^2*q33+16*M`j'^2*q12*q13^3*q33-8*q12^2*q13^3*q33-2*M`j'^2*q13^4*q33-4*q12*q13^4*q33+32*M`j'^2*q12^2*q13*q23*q33-8*q12^3*q13*q23*q33+48*M`j'^2*q12*q13^2*q23*q33-24*q12^2*q13^2*q23*q33-8*M`j'^2*q13^3*q23*q33-16*q12*q13^3*q23*q33+16*M`j'^2*q12^2*q23^2*q33-4*q12^3*q23^2*q33+48*M`j'^2*q12*q13*q23^2*q33-24*q12^2*q13*q23^2*q33-12*M`j'^2*q13^2*q23^2*q33-24*q12*q13^2*q23^2*q33+16*M`j'^2*q12*q23^3*q33-8*q12^2*q23^3*q33-8*M`j'^2*q13*q23^3*q33-16*q12*q13*q23^3*q33-2*M`j'^2*q23^4*q33-4*q12*q23^4*q33-16*M`j'^2*q12^3*q33^2+8*q12^4*q33^2-16*M`j'^2*q12^2*q13*q33^2+16*q12^3*q13*q33^2+8*M`j'^2*q12*q13^2*q33^2+4*q12^2*q13^2*q33^2-4*q12*q13^3*q33^2-16*M`j'^2*q12^2*q23*q33^2+16*q12^3*q23*q33^2+16*M`j'^2*q12*q13*q23*q33^2+8*q12^2*q13*q23*q33^2-12*q12*q13^2*q23*q33^2+8*M`j'^2*q12*q23^2*q33^2+4*q12^2*q23^2*q33^2-12*q12*q13*q23^2*q33^2-4*q12*q23^3*q33^2-8*M`j'^2*q12^2*q33^3+8*q12^3*q33^3+8*q12^2*q13*q33^3-q12*q13^2*q33^3+8*q12^2*q23*q33^3-2*q12*q13*q23*q33^3-q12*q23^2*q33^3+2*q12^2*q33^4)+mbox1l(1+n1,-1+n2,1+n3,-1+n4)*prf(4*M`j'^2*n1*q12^2*q13^3+4*M`j'^2*n1*q12*q13^4+8*M`j'^2*n1*q12^2*q13^2*q23+12*M`j'^2*n1*q12*q13^3*q23+4*M`j'^2*n1*q12^2*q13*q23^2+12*M`j'^2*n1*q12*q13^2*q23^2+4*M`j'^2*n1*q12*q13*q23^3-4*M`j'^2*n1*q12^3*q13*q33+2*M`j'^2*n1*q12^2*q13^2*q33+4*M`j'^2*n1*q12*q13^3*q33-4*M`j'^2*n1*q12^3*q23*q33-4*M`j'^2*n1*q12^2*q13*q23*q33+8*M`j'^2*n1*q12*q13^2*q23*q33+2*M`j'^2*n1*q13^3*q23*q33-6*M`j'^2*n1*q12^2*q23^2*q33+4*M`j'^2*n1*q12*q13*q23^2*q33+6*M`j'^2*n1*q13^2*q23^2*q33+6*M`j'^2*n1*q13*q23^3*q33+2*M`j'^2*n1*q23^4*q33-4*M`j'^2*n1*q12^3*q33^2+2*M`j'^2*n1*q12^2*q13*q33^2-2*n1*q12^3*q13*q33^2-2*n1*q12^2*q13^2*q33^2-10*M`j'^2*n1*q12^2*q23*q33^2+2*n1*q12^3*q23*q33^2-8*M`j'^2*n1*q12*q13*q23*q33^2+2*n1*q12^2*q13*q23*q33^2+2*n1*q12*q13^2*q23*q33^2-8*M`j'^2*n1*q12*q23^2*q33^2+4*n1*q12^2*q23^2*q33^2+4*n1*q12*q13*q23^2*q33^2+2*n1*q12*q23^3*q33^2+4*M`j'^2*n1*q12^2*q33^3-2*n1*q12^3*q33^3-3*n1*q12^2*q13*q33^3-n1*q12^2*q23*q33^3+n1*q12*q13*q23*q33^3+n1*q12*q23^2*q33^3-n1*q12^2*q33^4,4*M`j'^2*q12*q13^4-4*M`j'^2*n4*q12*q13^4+4*M`j'^2*q13^5-4*M`j'^2*n4*q13^5+16*M`j'^2*q12*q13^3*q23-16*M`j'^2*n4*q12*q13^3*q23+20*M`j'^2*q13^4*q23-20*M`j'^2*n4*q13^4*q23+24*M`j'^2*q12*q13^2*q23^2-24*M`j'^2*n4*q12*q13^2*q23^2+40*M`j'^2*q13^3*q23^2-40*M`j'^2*n4*q13^3*q23^2+16*M`j'^2*q12*q13*q23^3-16*M`j'^2*n4*q12*q13*q23^3+40*M`j'^2*q13^2*q23^3-40*M`j'^2*n4*q13^2*q23^3+4*M`j'^2*q12*q23^4-4*M`j'^2*n4*q12*q23^4+20*M`j'^2*q13*q23^4-20*M`j'^2*n4*q13*q23^4+4*M`j'^2*q23^5-4*M`j'^2*n4*q23^5-16*M`j'^2*q12^2*q13^2*q33+16*M`j'^2*n4*q12^2*q13^2*q33+4*q12^3*q13^2*q33-4*n4*q12^3*q13^2*q33-16*M`j'^2*q12*q13^3*q33+16*M`j'^2*n4*q12*q13^3*q33+8*q12^2*q13^3*q33-8*n4*q12^2*q13^3*q33+2*M`j'^2*q13^4*q33-2*M`j'^2*n4*q13^4*q33+4*q12*q13^4*q33-4*n4*q12*q13^4*q33-32*M`j'^2*q12^2*q13*q23*q33+32*M`j'^2*n4*q12^2*q13*q23*q33+8*q12^3*q13*q23*q33-8*n4*q12^3*q13*q23*q33-48*M`j'^2*q12*q13^2*q23*q33+48*M`j'^2*n4*q12*q13^2*q23*q33+24*q12^2*q13^2*q23*q33-24*n4*q12^2*q13^2*q23*q33+8*M`j'^2*q13^3*q23*q33-8*M`j'^2*n4*q13^3*q23*q33+16*q12*q13^3*q23*q33-16*n4*q12*q13^3*q23*q33-16*M`j'^2*q12^2*q23^2*q33+16*M`j'^2*n4*q12^2*q23^2*q33+4*q12^3*q23^2*q33-4*n4*q12^3*q23^2*q33-48*M`j'^2*q12*q13*q23^2*q33+48*M`j'^2*n4*q12*q13*q23^2*q33+24*q12^2*q13*q23^2*q33-24*n4*q12^2*q13*q23^2*q33+12*M`j'^2*q13^2*q23^2*q33-12*M`j'^2*n4*q13^2*q23^2*q33+24*q12*q13^2*q23^2*q33-24*n4*q12*q13^2*q23^2*q33-16*M`j'^2*q12*q23^3*q33+16*M`j'^2*n4*q12*q23^3*q33+8*q12^2*q23^3*q33-8*n4*q12^2*q23^3*q33+8*M`j'^2*q13*q23^3*q33-8*M`j'^2*n4*q13*q23^3*q33+16*q12*q13*q23^3*q33-16*n4*q12*q13*q23^3*q33+2*M`j'^2*q23^4*q33-2*M`j'^2*n4*q23^4*q33+4*q12*q23^4*q33-4*n4*q12*q23^4*q33+16*M`j'^2*q12^3*q33^2-16*M`j'^2*n4*q12^3*q33^2-8*q12^4*q33^2+8*n4*q12^4*q33^2+16*M`j'^2*q12^2*q13*q33^2-16*M`j'^2*n4*q12^2*q13*q33^2-16*q12^3*q13*q33^2+16*n4*q12^3*q13*q33^2-8*M`j'^2*q12*q13^2*q33^2+8*M`j'^2*n4*q12*q13^2*q33^2-4*q12^2*q13^2*q33^2+4*n4*q12^2*q13^2*q33^2+4*q12*q13^3*q33^2-4*n4*q12*q13^3*q33^2+16*M`j'^2*q12^2*q23*q33^2-16*M`j'^2*n4*q12^2*q23*q33^2-16*q12^3*q23*q33^2+16*n4*q12^3*q23*q33^2-16*M`j'^2*q12*q13*q23*q33^2+16*M`j'^2*n4*q12*q13*q23*q33^2-8*q12^2*q13*q23*q33^2+8*n4*q12^2*q13*q23*q33^2+12*q12*q13^2*q23*q33^2-12*n4*q12*q13^2*q23*q33^2-8*M`j'^2*q12*q23^2*q33^2+8*M`j'^2*n4*q12*q23^2*q33^2-4*q12^2*q23^2*q33^2+4*n4*q12^2*q23^2*q33^2+12*q12*q13*q23^2*q33^2-12*n4*q12*q13*q23^2*q33^2+4*q12*q23^3*q33^2-4*n4*q12*q23^3*q33^2+8*M`j'^2*q12^2*q33^3-8*M`j'^2*n4*q12^2*q33^3-8*q12^3*q33^3+8*n4*q12^3*q33^3-8*q12^2*q13*q33^3+8*n4*q12^2*q13*q33^3+q12*q13^2*q33^3-n4*q12*q13^2*q33^3-8*q12^2*q23*q33^3+8*n4*q12^2*q23*q33^3+2*q12*q13*q23*q33^3-2*n4*q12*q13*q23*q33^3+q12*q23^2*q33^3-n4*q12*q23^2*q33^3-2*q12^2*q33^4+2*n4*q12^2*q33^4)+mbox1l(n1,n2,1+n3,-1+n4)*(tmpprf(ep,1)*prf(8*q12^3*q13^3+8*q12^2*q13^4+16*q12^3*q13^2*q23+24*q12^2*q13^3*q23+8*q12^3*q13*q23^2+24*q12^2*q13^2*q23^2+8*q12^2*q13*q23^3-8*q12^4*q13*q33+4*q12^3*q13^2*q33+16*q12^2*q13^3*q33-8*q12^4*q23*q33-8*q12^3*q13*q23*q33+28*q12^2*q13^2*q23*q33-12*q12^3*q23^2*q33+8*q12^2*q13*q23^2*q33-4*q12^2*q23^3*q33-8*q12^4*q33^2-8*q12^3*q13*q33^2+10*q12^2*q13^2*q33^2-16*q12^3*q23*q33^2+4*q12^2*q13*q23*q33^2-6*q12^2*q23^2*q33^2-4*q12^3*q33^3+2*q12^2*q13*q33^3-2*q12^2*q23*q33^3,4*M`j'^2*q12*q13^4-4*M`j'^2*n4*q12*q13^4+4*M`j'^2*q13^5-4*M`j'^2*n4*q13^5+16*M`j'^2*q12*q13^3*q23-16*M`j'^2*n4*q12*q13^3*q23+20*M`j'^2*q13^4*q23-20*M`j'^2*n4*q13^4*q23+24*M`j'^2*q12*q13^2*q23^2-24*M`j'^2*n4*q12*q13^2*q23^2+40*M`j'^2*q13^3*q23^2-40*M`j'^2*n4*q13^3*q23^2+16*M`j'^2*q12*q13*q23^3-16*M`j'^2*n4*q12*q13*q23^3+40*M`j'^2*q13^2*q23^3-40*M`j'^2*n4*q13^2*q23^3+4*M`j'^2*q12*q23^4-4*M`j'^2*n4*q12*q23^4+20*M`j'^2*q13*q23^4-20*M`j'^2*n4*q13*q23^4+4*M`j'^2*q23^5-4*M`j'^2*n4*q23^5-16*M`j'^2*q12^2*q13^2*q33+16*M`j'^2*n4*q12^2*q13^2*q33+4*q12^3*q13^2*q33-4*n4*q12^3*q13^2*q33-16*M`j'^2*q12*q13^3*q33+16*M`j'^2*n4*q12*q13^3*q33+8*q12^2*q13^3*q33-8*n4*q12^2*q13^3*q33+2*M`j'^2*q13^4*q33-2*M`j'^2*n4*q13^4*q33+4*q12*q13^4*q33-4*n4*q12*q13^4*q33-32*M`j'^2*q12^2*q13*q23*q33+32*M`j'^2*n4*q12^2*q13*q23*q33+8*q12^3*q13*q23*q33-8*n4*q12^3*q13*q23*q33-48*M`j'^2*q12*q13^2*q23*q33+48*M`j'^2*n4*q12*q13^2*q23*q33+24*q12^2*q13^2*q23*q33-24*n4*q12^2*q13^2*q23*q33+8*M`j'^2*q13^3*q23*q33-8*M`j'^2*n4*q13^3*q23*q33+16*q12*q13^3*q23*q33-16*n4*q12*q13^3*q23*q33-16*M`j'^2*q12^2*q23^2*q33+16*M`j'^2*n4*q12^2*q23^2*q33+4*q12^3*q23^2*q33-4*n4*q12^3*q23^2*q33-48*M`j'^2*q12*q13*q23^2*q33+48*M`j'^2*n4*q12*q13*q23^2*q33+24*q12^2*q13*q23^2*q33-24*n4*q12^2*q13*q23^2*q33+12*M`j'^2*q13^2*q23^2*q33-12*M`j'^2*n4*q13^2*q23^2*q33+24*q12*q13^2*q23^2*q33-24*n4*q12*q13^2*q23^2*q33-16*M`j'^2*q12*q23^3*q33+16*M`j'^2*n4*q12*q23^3*q33+8*q12^2*q23^3*q33-8*n4*q12^2*q23^3*q33+8*M`j'^2*q13*q23^3*q33-8*M`j'^2*n4*q13*q23^3*q33+16*q12*q13*q23^3*q33-16*n4*q12*q13*q23^3*q33+2*M`j'^2*q23^4*q33-2*M`j'^2*n4*q23^4*q33+4*q12*q23^4*q33-4*n4*q12*q23^4*q33+16*M`j'^2*q12^3*q33^2-16*M`j'^2*n4*q12^3*q33^2-8*q12^4*q33^2+8*n4*q12^4*q33^2+16*M`j'^2*q12^2*q13*q33^2-16*M`j'^2*n4*q12^2*q13*q33^2-16*q12^3*q13*q33^2+16*n4*q12^3*q13*q33^2-8*M`j'^2*q12*q13^2*q33^2+8*M`j'^2*n4*q12*q13^2*q33^2-4*q12^2*q13^2*q33^2+4*n4*q12^2*q13^2*q33^2+4*q12*q13^3*q33^2-4*n4*q12*q13^3*q33^2+16*M`j'^2*q12^2*q23*q33^2-16*M`j'^2*n4*q12^2*q23*q33^2-16*q12^3*q23*q33^2+16*n4*q12^3*q23*q33^2-16*M`j'^2*q12*q13*q23*q33^2+16*M`j'^2*n4*q12*q13*q23*q33^2-8*q12^2*q13*q23*q33^2+8*n4*q12^2*q13*q23*q33^2+12*q12*q13^2*q23*q33^2-12*n4*q12*q13^2*q23*q33^2-8*M`j'^2*q12*q23^2*q33^2+8*M`j'^2*n4*q12*q23^2*q33^2-4*q12^2*q23^2*q33^2+4*n4*q12^2*q23^2*q33^2+12*q12*q13*q23^2*q33^2-12*n4*q12*q13*q23^2*q33^2+4*q12*q23^3*q33^2-4*n4*q12*q23^3*q33^2+8*M`j'^2*q12^2*q33^3-8*M`j'^2*n4*q12^2*q33^3-8*q12^3*q33^3+8*n4*q12^3*q33^3-8*q12^2*q13*q33^3+8*n4*q12^2*q13*q33^3+q12*q13^2*q33^3-n4*q12*q13^2*q33^3-8*q12^2*q23*q33^3+8*n4*q12^2*q23*q33^3+2*q12*q13*q23*q33^3-2*n4*q12*q13*q23*q33^3+q12*q23^2*q33^3-n4*q12*q23^2*q33^3-2*q12^2*q33^4+2*n4*q12^2*q33^4)+prf(8*M`j'^2*q12^2*q13^3-12*M`j'^2*n1*q12^2*q13^3+12*M`j'^2*n2*q12^2*q13^3+4*M`j'^2*n3*q12^2*q13^3-4*M`j'^2*n4*q12^2*q13^3-20*q12^3*q13^3+8*n1*q12^3*q13^3+4*n3*q12^3*q13^3+8*n4*q12^3*q13^3+8*M`j'^2*q12*q13^4-4*M`j'^2*n1*q12*q13^4+4*M`j'^2*n2*q12*q13^4+4*M`j'^2*n3*q12*q13^4-4*M`j'^2*n4*q12*q13^4-20*q12^2*q13^4+8*n1*q12^2*q13^4+4*n3*q12^2*q13^4+8*n4*q12^2*q13^4+12*M`j'^2*q12^2*q13^2*q23-20*M`j'^2*n1*q12^2*q13^2*q23+24*M`j'^2*n2*q12^2*q13^2*q23+4*M`j'^2*n3*q12^2*q13^2*q23-8*M`j'^2*n4*q12^2*q13^2*q23-40*q12^3*q13^2*q23+16*n1*q12^3*q13^2*q23+8*n3*q12^3*q13^2*q23+16*n4*q12^3*q13^2*q23+24*M`j'^2*q12*q13^3*q23-8*M`j'^2*n1*q12*q13^3*q23+16*M`j'^2*n2*q12*q13^3*q23+8*M`j'^2*n3*q12*q13^3*q23-16*M`j'^2*n4*q12*q13^3*q23-60*q12^2*q13^3*q23+24*n1*q12^2*q13^3*q23+12*n3*q12^2*q13^3*q23+24*n4*q12^2*q13^3*q23+4*M`j'^2*q13^4*q23+4*M`j'^2*n2*q13^4*q23-4*M`j'^2*n4*q13^4*q23-4*M`j'^2*n1*q12^2*q13*q23^2+12*M`j'^2*n2*q12^2*q13*q23^2-4*M`j'^2*n3*q12^2*q13*q23^2-4*M`j'^2*n4*q12^2*q13*q23^2-20*q12^3*q13*q23^2+8*n1*q12^3*q13*q23^2+4*n3*q12^3*q13*q23^2+8*n4*q12^3*q13*q23^2+24*M`j'^2*q12*q13^2*q23^2+24*M`j'^2*n2*q12*q13^2*q23^2-24*M`j'^2*n4*q12*q13^2*q23^2-60*q12^2*q13^2*q23^2+24*n1*q12^2*q13^2*q23^2+12*n3*q12^2*q13^2*q23^2+24*n4*q12^2*q13^2*q23^2+16*M`j'^2*q13^3*q23^2+16*M`j'^2*n2*q13^3*q23^2-16*M`j'^2*n4*q13^3*q23^2-4*M`j'^2*q12^2*q23^3+4*M`j'^2*n1*q12^2*q23^3-4*M`j'^2*n3*q12^2*q23^3+8*M`j'^2*q12*q13*q23^3+8*M`j'^2*n1*q12*q13*q23^3+16*M`j'^2*n2*q12*q13*q23^3-8*M`j'^2*n3*q12*q13*q23^3-16*M`j'^2*n4*q12*q13*q23^3-20*q12^2*q13*q23^3+8*n1*q12^2*q13*q23^3+4*n3*q12^2*q13*q23^3+8*n4*q12^2*q13*q23^3+24*M`j'^2*q13^2*q23^3+24*M`j'^2*n2*q13^2*q23^3-24*M`j'^2*n4*q13^2*q23^3+4*M`j'^2*n1*q12*q23^4+4*M`j'^2*n2*q12*q23^4-4*M`j'^2*n3*q12*q23^4-4*M`j'^2*n4*q12*q23^4+16*M`j'^2*q13*q23^4+16*M`j'^2*n2*q13*q23^4-16*M`j'^2*n4*q13*q23^4+4*M`j'^2*q23^5+4*M`j'^2*n2*q23^5-4*M`j'^2*n4*q23^5-12*M`j'^2*q12^3*q13*q33+16*M`j'^2*n1*q12^3*q13*q33-12*M`j'^2*n2*q12^3*q13*q33-8*M`j'^2*n3*q12^3*q13*q33+4*M`j'^2*n4*q12^3*q13*q33+24*q12^4*q13*q33-12*n1*q12^4*q13*q33-8*n4*q12^4*q13*q33-18*M`j'^2*q12^2*q13^2*q33-12*M`j'^2*n1*q12^2*q13^2*q33+10*M`j'^2*n2*q12^2*q13^2*q33-8*M`j'^2*n3*q12^2*q13^2*q33+10*M`j'^2*n4*q12^2*q13^2*q33+2*q12^3*q13^2*q33+10*n3*q12^3*q13^2*q33+2*M`j'^2*q12*q13^3*q33-4*M`j'^2*n1*q12*q13^3*q33+2*M`j'^2*n2*q12*q13^3*q33+2*M`j'^2*n3*q12*q13^3*q33-32*q12^2*q13^3*q33+16*n1*q12^2*q13^3*q33+12*n3*q12^2*q13^3*q33+12*n4*q12^2*q13^3*q33+4*M`j'^2*q12^3*q23*q33-12*M`j'^2*n2*q12^3*q23*q33+8*M`j'^2*n3*q12^3*q23*q33+4*M`j'^2*n4*q12^3*q23*q33+16*q12^4*q23*q33-4*n1*q12^4*q23*q33-8*n3*q12^4*q23*q33-8*n4*q12^4*q23*q33-28*M`j'^2*q12^2*q13*q23*q33-16*M`j'^2*n1*q12^2*q13*q23*q33-12*M`j'^2*n2*q12^2*q13*q23*q33+28*M`j'^2*n4*q12^2*q13*q23*q33+28*q12^3*q13*q23*q33-4*n1*q12^3*q13*q23*q33+4*n2*q12^3*q13*q23*q33-4*n3*q12^3*q13*q23*q33-16*n4*q12^3*q13*q23*q33-14*M`j'^2*q12*q13^2*q23*q33-8*M`j'^2*n1*q12*q13^2*q23*q33-10*M`j'^2*n2*q12*q13^2*q23*q33+2*M`j'^2*n3*q12*q13^2*q23*q33+16*M`j'^2*n4*q12*q13^2*q23*q33-50*q12^2*q13^2*q23*q33+32*n1*q12^2*q13^2*q23*q33+8*n2*q12^2*q13^2*q23*q33+18*n3*q12^2*q13^2*q23*q33+12*n4*q12^2*q13^2*q23*q33-2*M`j'^2*n1*q13^3*q23*q33+2*M`j'^2*n2*q13^3*q23*q33+4*q12*q13^3*q23*q33+4*n2*q12*q13^3*q23*q33-4*n4*q12*q13^3*q23*q33-10*M`j'^2*q12^2*q23^2*q33-4*M`j'^2*n1*q12^2*q23^2*q33-22*M`j'^2*n2*q12^2*q23^2*q33+8*M`j'^2*n3*q12^2*q23^2*q33+18*M`j'^2*n4*q12^2*q23^2*q33+26*q12^3*q23^2*q33-4*n1*q12^3*q23^2*q33+4*n2*q12^3*q23^2*q33-14*n3*q12^3*q23^2*q33-16*n4*q12^3*q23^2*q33-34*M`j'^2*q12*q13*q23^2*q33-4*M`j'^2*n1*q12*q13*q23^2*q33-26*M`j'^2*n2*q12*q13*q23^2*q33-2*M`j'^2*n3*q12*q13*q23^2*q33+32*M`j'^2*n4*q12*q13*q23^2*q33-4*q12^2*q13*q23^2*q33+16*n1*q12^2*q13*q23^2*q33+16*n2*q12^2*q13*q23^2*q33-12*n4*q12^2*q13*q23^2*q33-6*M`j'^2*n1*q13^2*q23^2*q33+6*M`j'^2*n2*q13^2*q23^2*q33+12*q12*q13^2*q23^2*q33+12*n2*q12*q13^2*q23^2*q33-12*n4*q12*q13^2*q23^2*q33-18*M`j'^2*q12*q23^3*q33-14*M`j'^2*n2*q12*q23^3*q33-2*M`j'^2*n3*q12*q23^3*q33+16*M`j'^2*n4*q12*q23^3*q33+14*q12^2*q23^3*q33+8*n2*q12^2*q23^3*q33-6*n3*q12^2*q23^3*q33-12*n4*q12^2*q23^3*q33-6*M`j'^2*n1*q13*q23^3*q33+6*M`j'^2*n2*q13*q23^3*q33+12*q12*q13*q23^3*q33+12*n2*q12*q13*q23^3*q33-12*n4*q12*q13*q23^3*q33-2*M`j'^2*n1*q23^4*q33+2*M`j'^2*n2*q23^4*q33+4*q12*q23^4*q33+4*n2*q12*q23^4*q33-4*n4*q12*q23^4*q33+12*M`j'^2*q12^3*q33^2+16*M`j'^2*n1*q12^3*q33^2-4*M`j'^2*n2*q12^3*q33^2-12*M`j'^2*n4*q12^3*q33^2+12*q12^4*q33^2-12*n1*q12^4*q33^2-4*n2*q12^4*q33^2-4*n3*q12^4*q33^2-2*M`j'^2*q12^2*q13*q33^2-4*M`j'^2*n1*q12^2*q13*q33^2+10*M`j'^2*n2*q12^2*q13*q33^2-4*M`j'^2*n3*q12^2*q13*q33^2-2*M`j'^2*n4*q12^2*q13*q33^2+16*q12^3*q13*q33^2-12*n1*q12^3*q13*q33^2-8*n2*q12^3*q13*q33^2-19*q12^2*q13^2*q33^2+12*n1*q12^2*q13^2*q33^2-4*n2*q12^2*q13^2*q33^2+9*n3*q12^2*q13^2*q33^2+8*n4*q12^2*q13^2*q33^2+18*M`j'^2*q12^2*q23*q33^2+12*M`j'^2*n1*q12^2*q23*q33^2-2*M`j'^2*n2*q12^2*q23*q33^2+4*M`j'^2*n3*q12^2*q23*q33^2-14*M`j'^2*n4*q12^2*q23*q33^2+20*q12^3*q23*q33^2-20*n1*q12^3*q23*q33^2-8*n2*q12^3*q23*q33^2-12*n3*q12^3*q23*q33^2+8*M`j'^2*n1*q12*q13*q23*q33^2-8*M`j'^2*n2*q12*q13*q23*q33^2-14*q12^2*q13*q23*q33^2+4*n1*q12^2*q13*q23*q33^2-4*n2*q12^2*q13*q23*q33^2+2*n3*q12^2*q13*q23*q33^2+8*n4*q12^2*q13*q23*q33^2+2*q12*q13^2*q23*q33^2-2*n1*q12*q13^2*q23*q33^2+4*n2*q12*q13^2*q23*q33^2-2*n4*q12*q13^2*q23*q33^2+8*M`j'^2*n1*q12*q23^2*q33^2-8*M`j'^2*n2*q12*q23^2*q33^2+5*q12^2*q23^2*q33^2-8*n1*q12^2*q23^2*q33^2-7*n3*q12^2*q23^2*q33^2+4*q12*q13*q23^2*q33^2-4*n1*q12*q13*q23^2*q33^2+8*n2*q12*q13*q23^2*q33^2-4*n4*q12*q13*q23^2*q33^2+2*q12*q23^3*q33^2-2*n1*q12*q23^3*q33^2+4*n2*q12*q23^3*q33^2-2*n4*q12*q23^3*q33^2-4*M`j'^2*n1*q12^2*q33^3+4*M`j'^2*n2*q12^2*q33^3+6*q12^3*q33^3-4*n1*q12^3*q33^3-4*n2*q12^3*q33^3-2*n3*q12^3*q33^3-4*q12^2*q13*q33^3+5*n1*q12^2*q13*q33^3-4*n2*q12^2*q13*q33^3+2*n3*q12^2*q13*q33^3+2*n4*q12^2*q13*q33^3-n1*q12^2*q23*q33^3-4*n2*q12^2*q23*q33^3-2*n3*q12^2*q23*q33^3+2*n4*q12^2*q23*q33^3-n1*q12*q13*q23*q33^3+n2*q12*q13*q23*q33^3-n1*q12*q23^2*q33^3+n2*q12*q23^2*q33^3+n1*q12^2*q33^4-n2*q12^2*q33^4,4*M`j'^2*q12*q13^4-4*M`j'^2*n4*q12*q13^4+4*M`j'^2*q13^5-4*M`j'^2*n4*q13^5+16*M`j'^2*q12*q13^3*q23-16*M`j'^2*n4*q12*q13^3*q23+20*M`j'^2*q13^4*q23-20*M`j'^2*n4*q13^4*q23+24*M`j'^2*q12*q13^2*q23^2-24*M`j'^2*n4*q12*q13^2*q23^2+40*M`j'^2*q13^3*q23^2-40*M`j'^2*n4*q13^3*q23^2+16*M`j'^2*q12*q13*q23^3-16*M`j'^2*n4*q12*q13*q23^3+40*M`j'^2*q13^2*q23^3-40*M`j'^2*n4*q13^2*q23^3+4*M`j'^2*q12*q23^4-4*M`j'^2*n4*q12*q23^4+20*M`j'^2*q13*q23^4-20*M`j'^2*n4*q13*q23^4+4*M`j'^2*q23^5-4*M`j'^2*n4*q23^5-16*M`j'^2*q12^2*q13^2*q33+16*M`j'^2*n4*q12^2*q13^2*q33+4*q12^3*q13^2*q33-4*n4*q12^3*q13^2*q33-16*M`j'^2*q12*q13^3*q33+16*M`j'^2*n4*q12*q13^3*q33+8*q12^2*q13^3*q33-8*n4*q12^2*q13^3*q33+2*M`j'^2*q13^4*q33-2*M`j'^2*n4*q13^4*q33+4*q12*q13^4*q33-4*n4*q12*q13^4*q33-32*M`j'^2*q12^2*q13*q23*q33+32*M`j'^2*n4*q12^2*q13*q23*q33+8*q12^3*q13*q23*q33-8*n4*q12^3*q13*q23*q33-48*M`j'^2*q12*q13^2*q23*q33+48*M`j'^2*n4*q12*q13^2*q23*q33+24*q12^2*q13^2*q23*q33-24*n4*q12^2*q13^2*q23*q33+8*M`j'^2*q13^3*q23*q33-8*M`j'^2*n4*q13^3*q23*q33+16*q12*q13^3*q23*q33-16*n4*q12*q13^3*q23*q33-16*M`j'^2*q12^2*q23^2*q33+16*M`j'^2*n4*q12^2*q23^2*q33+4*q12^3*q23^2*q33-4*n4*q12^3*q23^2*q33-48*M`j'^2*q12*q13*q23^2*q33+48*M`j'^2*n4*q12*q13*q23^2*q33+24*q12^2*q13*q23^2*q33-24*n4*q12^2*q13*q23^2*q33+12*M`j'^2*q13^2*q23^2*q33-12*M`j'^2*n4*q13^2*q23^2*q33+24*q12*q13^2*q23^2*q33-24*n4*q12*q13^2*q23^2*q33-16*M`j'^2*q12*q23^3*q33+16*M`j'^2*n4*q12*q23^3*q33+8*q12^2*q23^3*q33-8*n4*q12^2*q23^3*q33+8*M`j'^2*q13*q23^3*q33-8*M`j'^2*n4*q13*q23^3*q33+16*q12*q13*q23^3*q33-16*n4*q12*q13*q23^3*q33+2*M`j'^2*q23^4*q33-2*M`j'^2*n4*q23^4*q33+4*q12*q23^4*q33-4*n4*q12*q23^4*q33+16*M`j'^2*q12^3*q33^2-16*M`j'^2*n4*q12^3*q33^2-8*q12^4*q33^2+8*n4*q12^4*q33^2+16*M`j'^2*q12^2*q13*q33^2-16*M`j'^2*n4*q12^2*q13*q33^2-16*q12^3*q13*q33^2+16*n4*q12^3*q13*q33^2-8*M`j'^2*q12*q13^2*q33^2+8*M`j'^2*n4*q12*q13^2*q33^2-4*q12^2*q13^2*q33^2+4*n4*q12^2*q13^2*q33^2+4*q12*q13^3*q33^2-4*n4*q12*q13^3*q33^2+16*M`j'^2*q12^2*q23*q33^2-16*M`j'^2*n4*q12^2*q23*q33^2-16*q12^3*q23*q33^2+16*n4*q12^3*q23*q33^2-16*M`j'^2*q12*q13*q23*q33^2+16*M`j'^2*n4*q12*q13*q23*q33^2-8*q12^2*q13*q23*q33^2+8*n4*q12^2*q13*q23*q33^2+12*q12*q13^2*q23*q33^2-12*n4*q12*q13^2*q23*q33^2-8*M`j'^2*q12*q23^2*q33^2+8*M`j'^2*n4*q12*q23^2*q33^2-4*q12^2*q23^2*q33^2+4*n4*q12^2*q23^2*q33^2+12*q12*q13*q23^2*q33^2-12*n4*q12*q13*q23^2*q33^2+4*q12*q23^3*q33^2-4*n4*q12*q23^3*q33^2+8*M`j'^2*q12^2*q33^3-8*M`j'^2*n4*q12^2*q33^3-8*q12^3*q33^3+8*n4*q12^3*q33^3-8*q12^2*q13*q33^3+8*n4*q12^2*q13*q33^3+q12*q13^2*q33^3-n4*q12*q13^2*q33^3-8*q12^2*q23*q33^3+8*n4*q12^2*q23*q33^3+2*q12*q13*q23*q33^3-2*n4*q12*q13*q23*q33^3+q12*q23^2*q33^3-n4*q12*q23^2*q33^3-2*q12^2*q33^4+2*n4*q12^2*q33^4))+mbox1l(n1,-1+n2,2+n3,-1+n4)*prf(8*M`j'^2*q12^2*q13^3+8*M`j'^2*n3*q12^2*q13^3-4*q12^3*q13^3-4*n3*q12^3*q13^3-4*q12^2*q13^4-4*n3*q12^2*q13^4+8*M`j'^2*q12^2*q13^2*q23+8*M`j'^2*n3*q12^2*q13^2*q23-4*q12^3*q13^2*q23-4*n3*q12^3*q13^2*q23+4*M`j'^2*q12*q13^3*q23+4*M`j'^2*n3*q12*q13^3*q23-8*q12^2*q13^3*q23-8*n3*q12^2*q13^3*q23+4*M`j'^2*q13^4*q23+4*M`j'^2*n3*q13^4*q23+8*M`j'^2*q12*q13^2*q23^2+8*M`j'^2*n3*q12*q13^2*q23^2-4*q12^2*q13^2*q23^2-4*n3*q12^2*q13^2*q23^2+12*M`j'^2*q13^3*q23^2+12*M`j'^2*n3*q13^3*q23^2+4*M`j'^2*q12*q13*q23^3+4*M`j'^2*n3*q12*q13*q23^3+12*M`j'^2*q13^2*q23^3+12*M`j'^2*n3*q13^2*q23^3+4*M`j'^2*q13*q23^4+4*M`j'^2*n3*q13*q23^4-4*M`j'^2*q12^3*q13*q33-4*M`j'^2*n3*q12^3*q13*q33+18*M`j'^2*q12^2*q13^2*q33+18*M`j'^2*n3*q12^2*q13^2*q33-10*q12^3*q13^2*q33-10*n3*q12^3*q13^2*q33-12*q12^2*q13^3*q33-12*n3*q12^2*q13^3*q33-4*M`j'^2*q12^3*q23*q33-4*M`j'^2*n3*q12^3*q23*q33-12*M`j'^2*q12^2*q13*q23*q33-12*M`j'^2*n3*q12^2*q13*q23*q33+2*q12^3*q13*q23*q33+2*n3*q12^3*q13*q23*q33-12*M`j'^2*q12*q13^2*q23*q33-12*M`j'^2*n3*q12*q13^2*q23*q33-6*q12^2*q13^2*q23*q33-6*n3*q12^2*q13^2*q23*q33+2*M`j'^2*q13^3*q23*q33+2*M`j'^2*n3*q13^3*q23*q33+4*q12*q13^3*q23*q33+4*n3*q12*q13^3*q23*q33-6*M`j'^2*q12^2*q23^2*q33-6*M`j'^2*n3*q12^2*q23^2*q33-12*M`j'^2*q12*q13*q23^2*q33-12*M`j'^2*n3*q12*q13*q23^2*q33+6*q12^2*q13*q23^2*q33+6*n3*q12^2*q13*q23^2*q33+6*M`j'^2*q13^2*q23^2*q33+6*M`j'^2*n3*q13^2*q23^2*q33+8*q12*q13^2*q23^2*q33+8*n3*q12*q13^2*q23^2*q33+6*M`j'^2*q13*q23^3*q33+6*M`j'^2*n3*q13*q23^3*q33+4*q12*q13*q23^3*q33+4*n3*q12*q13*q23^3*q33+2*M`j'^2*q23^4*q33+2*M`j'^2*n3*q23^4*q33-4*M`j'^2*q12^3*q33^2-4*M`j'^2*n3*q12^3*q33^2+14*M`j'^2*q12^2*q13*q33^2+14*M`j'^2*n3*q12^2*q13*q33^2-8*q12^3*q13*q33^2-8*n3*q12^3*q13*q33^2-13*q12^2*q13^2*q33^2-13*n3*q12^2*q13^2*q33^2-10*M`j'^2*q12^2*q23*q33^2-10*M`j'^2*n3*q12^2*q23*q33^2+2*q12^3*q23*q33^2+2*n3*q12^3*q23*q33^2-8*M`j'^2*q12*q13*q23*q33^2-8*M`j'^2*n3*q12*q13*q23*q33^2-3*q12^2*q13*q23*q33^2-3*n3*q12^2*q13*q23*q33^2+4*q12*q13^2*q23*q33^2+4*n3*q12*q13^2*q23*q33^2-8*M`j'^2*q12*q23^2*q33^2-8*M`j'^2*n3*q12*q23^2*q33^2+4*q12^2*q23^2*q33^2+4*n3*q12^2*q23^2*q33^2+6*q12*q13*q23^2*q33^2+6*n3*q12*q13*q23^2*q33^2+2*q12*q23^3*q33^2+2*n3*q12*q23^3*q33^2+4*M`j'^2*q12^2*q33^3+4*M`j'^2*n3*q12^2*q33^3-2*q12^3*q33^3-2*n3*q12^3*q33^3-6*q12^2*q13*q33^3-6*n3*q12^2*q13*q33^3-q12^2*q23*q33^3-n3*q12^2*q23*q33^3+q12*q13*q23*q33^3+n3*q12*q13*q23*q33^3+q12*q23^2*q33^3+n3*q12*q23^2*q33^3-q12^2*q33^4-n3*q12^2*q33^4,4*M`j'^2*q12*q13^4-4*M`j'^2*n4*q12*q13^4+4*M`j'^2*q13^5-4*M`j'^2*n4*q13^5+16*M`j'^2*q12*q13^3*q23-16*M`j'^2*n4*q12*q13^3*q23+20*M`j'^2*q13^4*q23-20*M`j'^2*n4*q13^4*q23+24*M`j'^2*q12*q13^2*q23^2-24*M`j'^2*n4*q12*q13^2*q23^2+40*M`j'^2*q13^3*q23^2-40*M`j'^2*n4*q13^3*q23^2+16*M`j'^2*q12*q13*q23^3-16*M`j'^2*n4*q12*q13*q23^3+40*M`j'^2*q13^2*q23^3-40*M`j'^2*n4*q13^2*q23^3+4*M`j'^2*q12*q23^4-4*M`j'^2*n4*q12*q23^4+20*M`j'^2*q13*q23^4-20*M`j'^2*n4*q13*q23^4+4*M`j'^2*q23^5-4*M`j'^2*n4*q23^5-16*M`j'^2*q12^2*q13^2*q33+16*M`j'^2*n4*q12^2*q13^2*q33+4*q12^3*q13^2*q33-4*n4*q12^3*q13^2*q33-16*M`j'^2*q12*q13^3*q33+16*M`j'^2*n4*q12*q13^3*q33+8*q12^2*q13^3*q33-8*n4*q12^2*q13^3*q33+2*M`j'^2*q13^4*q33-2*M`j'^2*n4*q13^4*q33+4*q12*q13^4*q33-4*n4*q12*q13^4*q33-32*M`j'^2*q12^2*q13*q23*q33+32*M`j'^2*n4*q12^2*q13*q23*q33+8*q12^3*q13*q23*q33-8*n4*q12^3*q13*q23*q33-48*M`j'^2*q12*q13^2*q23*q33+48*M`j'^2*n4*q12*q13^2*q23*q33+24*q12^2*q13^2*q23*q33-24*n4*q12^2*q13^2*q23*q33+8*M`j'^2*q13^3*q23*q33-8*M`j'^2*n4*q13^3*q23*q33+16*q12*q13^3*q23*q33-16*n4*q12*q13^3*q23*q33-16*M`j'^2*q12^2*q23^2*q33+16*M`j'^2*n4*q12^2*q23^2*q33+4*q12^3*q23^2*q33-4*n4*q12^3*q23^2*q33-48*M`j'^2*q12*q13*q23^2*q33+48*M`j'^2*n4*q12*q13*q23^2*q33+24*q12^2*q13*q23^2*q33-24*n4*q12^2*q13*q23^2*q33+12*M`j'^2*q13^2*q23^2*q33-12*M`j'^2*n4*q13^2*q23^2*q33+24*q12*q13^2*q23^2*q33-24*n4*q12*q13^2*q23^2*q33-16*M`j'^2*q12*q23^3*q33+16*M`j'^2*n4*q12*q23^3*q33+8*q12^2*q23^3*q33-8*n4*q12^2*q23^3*q33+8*M`j'^2*q13*q23^3*q33-8*M`j'^2*n4*q13*q23^3*q33+16*q12*q13*q23^3*q33-16*n4*q12*q13*q23^3*q33+2*M`j'^2*q23^4*q33-2*M`j'^2*n4*q23^4*q33+4*q12*q23^4*q33-4*n4*q12*q23^4*q33+16*M`j'^2*q12^3*q33^2-16*M`j'^2*n4*q12^3*q33^2-8*q12^4*q33^2+8*n4*q12^4*q33^2+16*M`j'^2*q12^2*q13*q33^2-16*M`j'^2*n4*q12^2*q13*q33^2-16*q12^3*q13*q33^2+16*n4*q12^3*q13*q33^2-8*M`j'^2*q12*q13^2*q33^2+8*M`j'^2*n4*q12*q13^2*q33^2-4*q12^2*q13^2*q33^2+4*n4*q12^2*q13^2*q33^2+4*q12*q13^3*q33^2-4*n4*q12*q13^3*q33^2+16*M`j'^2*q12^2*q23*q33^2-16*M`j'^2*n4*q12^2*q23*q33^2-16*q12^3*q23*q33^2+16*n4*q12^3*q23*q33^2-16*M`j'^2*q12*q13*q23*q33^2+16*M`j'^2*n4*q12*q13*q23*q33^2-8*q12^2*q13*q23*q33^2+8*n4*q12^2*q13*q23*q33^2+12*q12*q13^2*q23*q33^2-12*n4*q12*q13^2*q23*q33^2-8*M`j'^2*q12*q23^2*q33^2+8*M`j'^2*n4*q12*q23^2*q33^2-4*q12^2*q23^2*q33^2+4*n4*q12^2*q23^2*q33^2+12*q12*q13*q23^2*q33^2-12*n4*q12*q13*q23^2*q33^2+4*q12*q23^3*q33^2-4*n4*q12*q23^3*q33^2+8*M`j'^2*q12^2*q33^3-8*M`j'^2*n4*q12^2*q33^3-8*q12^3*q33^3+8*n4*q12^3*q33^3-8*q12^2*q13*q33^3+8*n4*q12^2*q13*q33^3+q12*q13^2*q33^3-n4*q12*q13^2*q33^3-8*q12^2*q23*q33^3+8*n4*q12^2*q23*q33^3+2*q12*q13*q23*q33^3-2*n4*q12*q13*q23*q33^3+q12*q23^2*q33^3-n4*q12*q23^2*q33^3-2*q12^2*q33^4+2*n4*q12^2*q33^4)+mbox1l(-1+n1,n2,2+n3,-1+n4)*prf(-4*M`j'^2*q12^3*q13^2-4*M`j'^2*n3*q12^3*q13^2+4*q12^4*q13^2+4*n3*q12^4*q13^2-16*M`j'^2*q12^2*q13^3-16*M`j'^2*n3*q12^2*q13^3+12*q12^3*q13^3+12*n3*q12^3*q13^3-4*M`j'^2*q12*q13^4-4*M`j'^2*n3*q12*q13^4+8*q12^2*q13^4+8*n3*q12^2*q13^4+4*q12^4*q13*q23+4*n3*q12^4*q13*q23-16*M`j'^2*q12^2*q13^2*q23-16*M`j'^2*n3*q12^2*q13^2*q23+20*q12^3*q13^2*q23+20*n3*q12^3*q13^2*q23-12*M`j'^2*q12*q13^3*q23-12*M`j'^2*n3*q12*q13^3*q23+20*q12^2*q13^3*q23+20*n3*q12^2*q13^3*q23-4*M`j'^2*q13^4*q23-4*M`j'^2*n3*q13^4*q23+4*M`j'^2*q12^3*q23^2+4*M`j'^2*n3*q12^3*q23^2+8*M`j'^2*q12^2*q13*q23^2+8*M`j'^2*n3*q12^2*q13*q23^2+8*q12^3*q13*q23^2+8*n3*q12^3*q13*q23^2-8*M`j'^2*q12*q13^2*q23^2-8*M`j'^2*n3*q12*q13^2*q23^2+16*q12^2*q13^2*q23^2+16*n3*q12^2*q13^2*q23^2-12*M`j'^2*q13^3*q23^2-12*M`j'^2*n3*q13^3*q23^2+8*M`j'^2*q12^2*q23^3+8*M`j'^2*n3*q12^2*q23^3+4*M`j'^2*q12*q13*q23^3+4*M`j'^2*n3*q12*q13*q23^3+4*q12^2*q13*q23^3+4*n3*q12^2*q13*q23^3-12*M`j'^2*q13^2*q23^3-12*M`j'^2*n3*q13^2*q23^3+4*M`j'^2*q12*q23^4+4*M`j'^2*n3*q12*q23^4-4*M`j'^2*q13*q23^4-4*M`j'^2*n3*q13*q23^4+8*M`j'^2*q12^3*q13*q33+8*M`j'^2*n3*q12^3*q13*q33-2*q12^4*q13*q33-2*n3*q12^4*q13*q33-16*M`j'^2*q12^2*q13^2*q33-16*M`j'^2*n3*q12^2*q13^2*q33+12*q12^3*q13^2*q33+12*n3*q12^3*q13^2*q33-2*M`j'^2*q12*q13^3*q33-2*M`j'^2*n3*q12*q13^3*q33+16*q12^2*q13^3*q33+16*n3*q12^2*q13^3*q33+2*q12^4*q23*q33+2*n3*q12^4*q23*q33+12*M`j'^2*q12^2*q13*q23*q33+12*M`j'^2*n3*q12^2*q13*q23*q33+4*q12^3*q13*q23*q33+4*n3*q12^3*q13*q23*q33+10*M`j'^2*q12*q13^2*q23*q33+10*M`j'^2*n3*q12*q13^2*q23*q33+16*q12^2*q13^2*q23*q33+16*n3*q12^2*q13^2*q23*q33-2*M`j'^2*q13^3*q23*q33-2*M`j'^2*n3*q13^3*q23*q33-4*q12*q13^3*q23*q33-4*n3*q12*q13^3*q23*q33+4*M`j'^2*q12^2*q23^2*q33+4*M`j'^2*n3*q12^2*q23^2*q33+4*q12^3*q23^2*q33+4*n3*q12^3*q23^2*q33+14*M`j'^2*q12*q13*q23^2*q33+14*M`j'^2*n3*q12*q13*q23^2*q33+2*q12^2*q13*q23^2*q33+2*n3*q12^2*q13*q23^2*q33-6*M`j'^2*q13^2*q23^2*q33-6*M`j'^2*n3*q13^2*q23^2*q33-8*q12*q13^2*q23^2*q33-8*n3*q12*q13^2*q23^2*q33+2*M`j'^2*q12*q23^3*q33+2*M`j'^2*n3*q12*q23^3*q33+2*q12^2*q23^3*q33+2*n3*q12^2*q23^3*q33-6*M`j'^2*q13*q23^3*q33-6*M`j'^2*n3*q13*q23^3*q33-4*q12*q13*q23^3*q33-4*n3*q12*q13*q23^3*q33-2*M`j'^2*q23^4*q33-2*M`j'^2*n3*q23^4*q33+4*M`j'^2*q12^3*q33^2+4*M`j'^2*n3*q12^3*q33^2-2*q12^4*q33^2-2*n3*q12^4*q33^2-12*M`j'^2*q12^2*q13*q33^2-12*M`j'^2*n3*q12^2*q13*q33^2+5*q12^3*q13*q33^2+5*n3*q12^3*q13*q33^2+14*q12^2*q13^2*q33^2+14*n3*q12^2*q13^2*q33^2+8*M`j'^2*q12^2*q23*q33^2+8*M`j'^2*n3*q12^2*q23*q33^2-3*q12^3*q23*q33^2-3*n3*q12^3*q23*q33^2+8*M`j'^2*q12*q13*q23*q33^2+8*M`j'^2*n3*q12*q13*q23*q33^2+5*q12^2*q13*q23*q33^2+5*n3*q12^2*q13*q23*q33^2-4*q12*q13^2*q23*q33^2-4*n3*q12*q13^2*q23*q33^2+8*M`j'^2*q12*q23^2*q33^2+8*M`j'^2*n3*q12*q23^2*q33^2-3*q12^2*q23^2*q33^2-3*n3*q12^2*q23^2*q33^2-6*q12*q13*q23^2*q33^2-6*n3*q12*q13*q23^2*q33^2-2*q12*q23^3*q33^2-2*n3*q12*q23^3*q33^2-4*M`j'^2*q12^2*q33^3-4*M`j'^2*n3*q12^2*q33^3+q12^3*q33^3+n3*q12^3*q33^3+6*q12^2*q13*q33^3+6*n3*q12^2*q13*q33^3+q12^2*q23*q33^3+n3*q12^2*q23*q33^3-q12*q13*q23*q33^3-n3*q12*q13*q23*q33^3-q12*q23^2*q33^3-n3*q12*q23^2*q33^3+q12^2*q33^4+n3*q12^2*q33^4,4*M`j'^2*q12*q13^4-4*M`j'^2*n4*q12*q13^4+4*M`j'^2*q13^5-4*M`j'^2*n4*q13^5+16*M`j'^2*q12*q13^3*q23-16*M`j'^2*n4*q12*q13^3*q23+20*M`j'^2*q13^4*q23-20*M`j'^2*n4*q13^4*q23+24*M`j'^2*q12*q13^2*q23^2-24*M`j'^2*n4*q12*q13^2*q23^2+40*M`j'^2*q13^3*q23^2-40*M`j'^2*n4*q13^3*q23^2+16*M`j'^2*q12*q13*q23^3-16*M`j'^2*n4*q12*q13*q23^3+40*M`j'^2*q13^2*q23^3-40*M`j'^2*n4*q13^2*q23^3+4*M`j'^2*q12*q23^4-4*M`j'^2*n4*q12*q23^4+20*M`j'^2*q13*q23^4-20*M`j'^2*n4*q13*q23^4+4*M`j'^2*q23^5-4*M`j'^2*n4*q23^5-16*M`j'^2*q12^2*q13^2*q33+16*M`j'^2*n4*q12^2*q13^2*q33+4*q12^3*q13^2*q33-4*n4*q12^3*q13^2*q33-16*M`j'^2*q12*q13^3*q33+16*M`j'^2*n4*q12*q13^3*q33+8*q12^2*q13^3*q33-8*n4*q12^2*q13^3*q33+2*M`j'^2*q13^4*q33-2*M`j'^2*n4*q13^4*q33+4*q12*q13^4*q33-4*n4*q12*q13^4*q33-32*M`j'^2*q12^2*q13*q23*q33+32*M`j'^2*n4*q12^2*q13*q23*q33+8*q12^3*q13*q23*q33-8*n4*q12^3*q13*q23*q33-48*M`j'^2*q12*q13^2*q23*q33+48*M`j'^2*n4*q12*q13^2*q23*q33+24*q12^2*q13^2*q23*q33-24*n4*q12^2*q13^2*q23*q33+8*M`j'^2*q13^3*q23*q33-8*M`j'^2*n4*q13^3*q23*q33+16*q12*q13^3*q23*q33-16*n4*q12*q13^3*q23*q33-16*M`j'^2*q12^2*q23^2*q33+16*M`j'^2*n4*q12^2*q23^2*q33+4*q12^3*q23^2*q33-4*n4*q12^3*q23^2*q33-48*M`j'^2*q12*q13*q23^2*q33+48*M`j'^2*n4*q12*q13*q23^2*q33+24*q12^2*q13*q23^2*q33-24*n4*q12^2*q13*q23^2*q33+12*M`j'^2*q13^2*q23^2*q33-12*M`j'^2*n4*q13^2*q23^2*q33+24*q12*q13^2*q23^2*q33-24*n4*q12*q13^2*q23^2*q33-16*M`j'^2*q12*q23^3*q33+16*M`j'^2*n4*q12*q23^3*q33+8*q12^2*q23^3*q33-8*n4*q12^2*q23^3*q33+8*M`j'^2*q13*q23^3*q33-8*M`j'^2*n4*q13*q23^3*q33+16*q12*q13*q23^3*q33-16*n4*q12*q13*q23^3*q33+2*M`j'^2*q23^4*q33-2*M`j'^2*n4*q23^4*q33+4*q12*q23^4*q33-4*n4*q12*q23^4*q33+16*M`j'^2*q12^3*q33^2-16*M`j'^2*n4*q12^3*q33^2-8*q12^4*q33^2+8*n4*q12^4*q33^2+16*M`j'^2*q12^2*q13*q33^2-16*M`j'^2*n4*q12^2*q13*q33^2-16*q12^3*q13*q33^2+16*n4*q12^3*q13*q33^2-8*M`j'^2*q12*q13^2*q33^2+8*M`j'^2*n4*q12*q13^2*q33^2-4*q12^2*q13^2*q33^2+4*n4*q12^2*q13^2*q33^2+4*q12*q13^3*q33^2-4*n4*q12*q13^3*q33^2+16*M`j'^2*q12^2*q23*q33^2-16*M`j'^2*n4*q12^2*q23*q33^2-16*q12^3*q23*q33^2+16*n4*q12^3*q23*q33^2-16*M`j'^2*q12*q13*q23*q33^2+16*M`j'^2*n4*q12*q13*q23*q33^2-8*q12^2*q13*q23*q33^2+8*n4*q12^2*q13*q23*q33^2+12*q12*q13^2*q23*q33^2-12*n4*q12*q13^2*q23*q33^2-8*M`j'^2*q12*q23^2*q33^2+8*M`j'^2*n4*q12*q23^2*q33^2-4*q12^2*q23^2*q33^2+4*n4*q12^2*q23^2*q33^2+12*q12*q13*q23^2*q33^2-12*n4*q12*q13*q23^2*q33^2+4*q12*q23^3*q33^2-4*n4*q12*q23^3*q33^2+8*M`j'^2*q12^2*q33^3-8*M`j'^2*n4*q12^2*q33^3-8*q12^3*q33^3+8*n4*q12^3*q33^3-8*q12^2*q13*q33^3+8*n4*q12^2*q13*q33^3+q12*q13^2*q33^3-n4*q12*q13^2*q33^3-8*q12^2*q23*q33^3+8*n4*q12^2*q23*q33^3+2*q12*q13*q23*q33^3-2*n4*q12*q13*q23*q33^3+q12*q23^2*q33^3-n4*q12*q23^2*q33^3-2*q12^2*q33^4+2*n4*q12^2*q33^4);
	Identify,ifmatch->jump mbox1l(n1?pos_,n2?{,>1},n3?neg_,n4?pos_) = mbox1l(n1,-1+n2,2+n3,-1+n4)*prf(-4*M`j'^2*q12^2*q13*q33-4*M`j'^2*n3*q12^2*q13*q33+4*q12^3*q13*q33+4*n3*q12^3*q13*q33-2*M`j'^2*q12*q13^2*q33-2*M`j'^2*n3*q12*q13^2*q33+2*q12^2*q13^2*q33+2*n3*q12^2*q13^2*q33+4*M`j'^2*q12^2*q23*q33+4*M`j'^2*n3*q12^2*q23*q33+2*q12^2*q13*q23*q33+2*n3*q12^2*q13*q23*q33+2*M`j'^2*q12*q23^2*q33+2*M`j'^2*n3*q12*q23^2*q33+2*q12^3*q33^2+2*n3*q12^3*q33^2+q12^2*q13*q33^2+n3*q12^2*q13*q33^2+q12^2*q23*q33^2+n3*q12^2*q23*q33^2,-4*M`j'^2*q13^4+4*M`j'^2*n2*q13^4-16*M`j'^2*q13^3*q23+16*M`j'^2*n2*q13^3*q23-24*M`j'^2*q13^2*q23^2+24*M`j'^2*n2*q13^2*q23^2-16*M`j'^2*q13*q23^3+16*M`j'^2*n2*q13*q23^3-4*M`j'^2*q23^4+4*M`j'^2*n2*q23^4+16*M`j'^2*q12*q13^2*q33-16*M`j'^2*n2*q12*q13^2*q33-4*q12^2*q13^2*q33+4*n2*q12^2*q13^2*q33-4*q12*q13^3*q33+4*n2*q12*q13^3*q33+32*M`j'^2*q12*q13*q23*q33-32*M`j'^2*n2*q12*q13*q23*q33-8*q12^2*q13*q23*q33+8*n2*q12^2*q13*q23*q33-12*q12*q13^2*q23*q33+12*n2*q12*q13^2*q23*q33+16*M`j'^2*q12*q23^2*q33-16*M`j'^2*n2*q12*q23^2*q33-4*q12^2*q23^2*q33+4*n2*q12^2*q23^2*q33-12*q12*q13*q23^2*q33+12*n2*q12*q13*q23^2*q33-4*q12*q23^3*q33+4*n2*q12*q23^3*q33-16*M`j'^2*q12^2*q33^2+16*M`j'^2*n2*q12^2*q33^2+8*q12^3*q33^2-8*n2*q12^3*q33^2+8*q12^2*q13*q33^2-8*n2*q12^2*q13*q33^2-2*q12*q13^2*q33^2+2*n2*q12*q13^2*q33^2+8*q12^2*q23*q33^2-8*n2*q12^2*q23*q33^2-4*q12*q13*q23*q33^2+4*n2*q12*q13*q23*q33^2-2*q12*q23^2*q33^2+2*n2*q12*q23^2*q33^2+4*q12^2*q33^3-4*n2*q12^2*q33^3)+mbox1l(n1,-2+n2,1+n3,1+n4)*prf(4*M`j'^2*n4*q12^2*q13^2*q33+2*M`j'^2*n4*q12*q13^3*q33+4*M`j'^2*n4*q12^2*q13*q23*q33+4*M`j'^2*n4*q12*q13^2*q23*q33+2*M`j'^2*n4*q12*q13*q23^2*q33-4*M`j'^2*n4*q12^3*q33^2+M`j'^2*n4*q12*q13^2*q33^2-4*M`j'^2*n4*q12^2*q23*q33^2-M`j'^2*n4*q12*q23^2*q33^2,4*M`j'^2*q12*q13^4-4*M`j'^2*n2*q12*q13^4+4*M`j'^2*q13^5-4*M`j'^2*n2*q13^5+16*M`j'^2*q12*q13^3*q23-16*M`j'^2*n2*q12*q13^3*q23+20*M`j'^2*q13^4*q23-20*M`j'^2*n2*q13^4*q23+24*M`j'^2*q12*q13^2*q23^2-24*M`j'^2*n2*q12*q13^2*q23^2+40*M`j'^2*q13^3*q23^2-40*M`j'^2*n2*q13^3*q23^2+16*M`j'^2*q12*q13*q23^3-16*M`j'^2*n2*q12*q13*q23^3+40*M`j'^2*q13^2*q23^3-40*M`j'^2*n2*q13^2*q23^3+4*M`j'^2*q12*q23^4-4*M`j'^2*n2*q12*q23^4+20*M`j'^2*q13*q23^4-20*M`j'^2*n2*q13*q23^4+4*M`j'^2*q23^5-4*M`j'^2*n2*q23^5-16*M`j'^2*q12^2*q13^2*q33+16*M`j'^2*n2*q12^2*q13^2*q33+4*q12^3*q13^2*q33-4*n2*q12^3*q13^2*q33-16*M`j'^2*q12*q13^3*q33+16*M`j'^2*n2*q12*q13^3*q33+8*q12^2*q13^3*q33-8*n2*q12^2*q13^3*q33+2*M`j'^2*q13^4*q33-2*M`j'^2*n2*q13^4*q33+4*q12*q13^4*q33-4*n2*q12*q13^4*q33-32*M`j'^2*q12^2*q13*q23*q33+32*M`j'^2*n2*q12^2*q13*q23*q33+8*q12^3*q13*q23*q33-8*n2*q12^3*q13*q23*q33-48*M`j'^2*q12*q13^2*q23*q33+48*M`j'^2*n2*q12*q13^2*q23*q33+24*q12^2*q13^2*q23*q33-24*n2*q12^2*q13^2*q23*q33+8*M`j'^2*q13^3*q23*q33-8*M`j'^2*n2*q13^3*q23*q33+16*q12*q13^3*q23*q33-16*n2*q12*q13^3*q23*q33-16*M`j'^2*q12^2*q23^2*q33+16*M`j'^2*n2*q12^2*q23^2*q33+4*q12^3*q23^2*q33-4*n2*q12^3*q23^2*q33-48*M`j'^2*q12*q13*q23^2*q33+48*M`j'^2*n2*q12*q13*q23^2*q33+24*q12^2*q13*q23^2*q33-24*n2*q12^2*q13*q23^2*q33+12*M`j'^2*q13^2*q23^2*q33-12*M`j'^2*n2*q13^2*q23^2*q33+24*q12*q13^2*q23^2*q33-24*n2*q12*q13^2*q23^2*q33-16*M`j'^2*q12*q23^3*q33+16*M`j'^2*n2*q12*q23^3*q33+8*q12^2*q23^3*q33-8*n2*q12^2*q23^3*q33+8*M`j'^2*q13*q23^3*q33-8*M`j'^2*n2*q13*q23^3*q33+16*q12*q13*q23^3*q33-16*n2*q12*q13*q23^3*q33+2*M`j'^2*q23^4*q33-2*M`j'^2*n2*q23^4*q33+4*q12*q23^4*q33-4*n2*q12*q23^4*q33+16*M`j'^2*q12^3*q33^2-16*M`j'^2*n2*q12^3*q33^2-8*q12^4*q33^2+8*n2*q12^4*q33^2+16*M`j'^2*q12^2*q13*q33^2-16*M`j'^2*n2*q12^2*q13*q33^2-16*q12^3*q13*q33^2+16*n2*q12^3*q13*q33^2-8*M`j'^2*q12*q13^2*q33^2+8*M`j'^2*n2*q12*q13^2*q33^2-4*q12^2*q13^2*q33^2+4*n2*q12^2*q13^2*q33^2+4*q12*q13^3*q33^2-4*n2*q12*q13^3*q33^2+16*M`j'^2*q12^2*q23*q33^2-16*M`j'^2*n2*q12^2*q23*q33^2-16*q12^3*q23*q33^2+16*n2*q12^3*q23*q33^2-16*M`j'^2*q12*q13*q23*q33^2+16*M`j'^2*n2*q12*q13*q23*q33^2-8*q12^2*q13*q23*q33^2+8*n2*q12^2*q13*q23*q33^2+12*q12*q13^2*q23*q33^2-12*n2*q12*q13^2*q23*q33^2-8*M`j'^2*q12*q23^2*q33^2+8*M`j'^2*n2*q12*q23^2*q33^2-4*q12^2*q23^2*q33^2+4*n2*q12^2*q23^2*q33^2+12*q12*q13*q23^2*q33^2-12*n2*q12*q13*q23^2*q33^2+4*q12*q23^3*q33^2-4*n2*q12*q23^3*q33^2+8*M`j'^2*q12^2*q33^3-8*M`j'^2*n2*q12^2*q33^3-8*q12^3*q33^3+8*n2*q12^3*q33^3-8*q12^2*q13*q33^3+8*n2*q12^2*q13*q33^3+q12*q13^2*q33^3-n2*q12*q13^2*q33^3-8*q12^2*q23*q33^3+8*n2*q12^2*q23*q33^3+2*q12*q13*q23*q33^3-2*n2*q12*q13*q23*q33^3+q12*q23^2*q33^3-n2*q12*q23^2*q33^3-2*q12^2*q33^4+2*n2*q12^2*q33^4)+mbox1l(-1+n1,n2,1+n3,n4)*prf(4*M`j'^2*q12*q13^3+12*M`j'^2*q12*q13^2*q23+4*M`j'^2*q13^3*q23+12*M`j'^2*q12*q13*q23^2+12*M`j'^2*q13^2*q23^2+4*M`j'^2*q12*q23^3+12*M`j'^2*q13*q23^3+4*M`j'^2*q23^4-4*q12^3*q13*q33+8*M`j'^2*q12*q13^2*q33-8*q12^2*q13^2*q33-4*q12*q13^3*q33-16*M`j'^2*q12^2*q23*q33+4*q12^3*q23*q33-8*M`j'^2*q12*q13*q23*q33-4*q12*q13^2*q23*q33-16*M`j'^2*q12*q23^2*q33+8*q12^2*q23^2*q33+4*q12*q13*q23^2*q33+4*q12*q23^3*q33+4*M`j'^2*q12*q13*q33^2-4*q12^2*q13*q33^2-4*q12*q13^2*q33^2-4*M`j'^2*q12*q23*q33^2+4*q12^2*q23*q33^2+4*q12*q23^2*q33^2-q12*q13*q33^3+q12*q23*q33^3,4*M`j'^2*q13^4+16*M`j'^2*q13^3*q23+24*M`j'^2*q13^2*q23^2+16*M`j'^2*q13*q23^3+4*M`j'^2*q23^4-16*M`j'^2*q12*q13^2*q33+4*q12^2*q13^2*q33+4*q12*q13^3*q33-32*M`j'^2*q12*q13*q23*q33+8*q12^2*q13*q23*q33+12*q12*q13^2*q23*q33-16*M`j'^2*q12*q23^2*q33+4*q12^2*q23^2*q33+12*q12*q13*q23^2*q33+4*q12*q23^3*q33+16*M`j'^2*q12^2*q33^2-8*q12^3*q33^2-8*q12^2*q13*q33^2+2*q12*q13^2*q33^2-8*q12^2*q23*q33^2+4*q12*q13*q23*q33^2+2*q12*q23^2*q33^2-4*q12^2*q33^3)+mbox1l(n1,n2,1+n3,-1+n4)*prf(4*M`j'^2*q12^2*q13^3+12*M`j'^2*q12^2*q13^2*q23+4*M`j'^2*q12*q13^3*q23+12*M`j'^2*q12^2*q13*q23^2+12*M`j'^2*q12*q13^2*q23^2+4*M`j'^2*q12^2*q23^3+12*M`j'^2*q12*q13*q23^3+4*M`j'^2*q12*q23^4-4*q12^4*q13*q33+12*M`j'^2*q12^2*q13^2*q33-8*q12^3*q13^2*q33+2*M`j'^2*q12*q13^3*q33-4*q12^2*q13^3*q33-16*M`j'^2*q12^3*q23*q33+4*q12^4*q23*q33-4*M`j'^2*q12^2*q13*q23*q33+4*M`j'^2*q12*q13^2*q23*q33-4*q12^2*q13^2*q23*q33-16*M`j'^2*q12^2*q23^2*q33+8*q12^3*q23^2*q33+2*M`j'^2*q12*q13*q23^2*q33+4*q12^2*q13*q23^2*q33+4*q12^2*q23^3*q33-4*M`j'^2*q12^3*q33^2+4*M`j'^2*q12^2*q13*q33^2-4*q12^3*q13*q33^2+M`j'^2*q12*q13^2*q33^2-4*q12^2*q13^2*q33^2-8*M`j'^2*q12^2*q23*q33^2+4*q12^3*q23*q33^2-M`j'^2*q12*q23^2*q33^2+4*q12^2*q23^2*q33^2-q12^2*q13*q33^3+q12^2*q23*q33^3,-4*M`j'^2*q12*q13^4-4*M`j'^2*q13^5-16*M`j'^2*q12*q13^3*q23-20*M`j'^2*q13^4*q23-24*M`j'^2*q12*q13^2*q23^2-40*M`j'^2*q13^3*q23^2-16*M`j'^2*q12*q13*q23^3-40*M`j'^2*q13^2*q23^3-4*M`j'^2*q12*q23^4-20*M`j'^2*q13*q23^4-4*M`j'^2*q23^5+16*M`j'^2*q12^2*q13^2*q33-4*q12^3*q13^2*q33+16*M`j'^2*q12*q13^3*q33-8*q12^2*q13^3*q33-2*M`j'^2*q13^4*q33-4*q12*q13^4*q33+32*M`j'^2*q12^2*q13*q23*q33-8*q12^3*q13*q23*q33+48*M`j'^2*q12*q13^2*q23*q33-24*q12^2*q13^2*q23*q33-8*M`j'^2*q13^3*q23*q33-16*q12*q13^3*q23*q33+16*M`j'^2*q12^2*q23^2*q33-4*q12^3*q23^2*q33+48*M`j'^2*q12*q13*q23^2*q33-24*q12^2*q13*q23^2*q33-12*M`j'^2*q13^2*q23^2*q33-24*q12*q13^2*q23^2*q33+16*M`j'^2*q12*q23^3*q33-8*q12^2*q23^3*q33-8*M`j'^2*q13*q23^3*q33-16*q12*q13*q23^3*q33-2*M`j'^2*q23^4*q33-4*q12*q23^4*q33-16*M`j'^2*q12^3*q33^2+8*q12^4*q33^2-16*M`j'^2*q12^2*q13*q33^2+16*q12^3*q13*q33^2+8*M`j'^2*q12*q13^2*q33^2+4*q12^2*q13^2*q33^2-4*q12*q13^3*q33^2-16*M`j'^2*q12^2*q23*q33^2+16*q12^3*q23*q33^2+16*M`j'^2*q12*q13*q23*q33^2+8*q12^2*q13*q23*q33^2-12*q12*q13^2*q23*q33^2+8*M`j'^2*q12*q23^2*q33^2+4*q12^2*q23^2*q33^2-12*q12*q13*q23^2*q33^2-4*q12*q23^3*q33^2-8*M`j'^2*q12^2*q33^3+8*q12^3*q33^3+8*q12^2*q13*q33^3-q12*q13^2*q33^3+8*q12^2*q23*q33^3-2*q12*q13*q23*q33^3-q12*q23^2*q33^3+2*q12^2*q33^4)+mbox1l(1+n1,-1+n2,1+n3,-1+n4)*prf(4*M`j'^2*n1*q12*q13^4+12*M`j'^2*n1*q12*q13^3*q23+12*M`j'^2*n1*q12*q13^2*q23^2+4*M`j'^2*n1*q12*q13*q23^3-8*M`j'^2*n1*q12^2*q13^2*q33+4*n1*q12^3*q13^2*q33+4*M`j'^2*n1*q12*q13^3*q33+4*n1*q12^2*q13^3*q33-12*M`j'^2*n1*q12^2*q13*q23*q33+4*n1*q12^3*q13*q23*q33+6*M`j'^2*n1*q12*q13^2*q23*q33+8*n1*q12^2*q13^2*q23*q33-4*M`j'^2*n1*q12^2*q23^2*q33+4*n1*q12^2*q13*q23^2*q33-2*M`j'^2*n1*q12*q23^3*q33+4*M`j'^2*n1*q12^3*q33^2-4*n1*q12^4*q33^2-4*M`j'^2*n1*q12^2*q13*q33^2-2*n1*q12^3*q13*q33^2+M`j'^2*n1*q12*q13^2*q33^2+4*n1*q12^2*q13^2*q33^2-6*n1*q12^3*q23*q33^2+2*n1*q12^2*q13*q23*q33^2-M`j'^2*n1*q12*q23^2*q33^2-2*n1*q12^2*q23^2*q33^2-2*n1*q12^3*q33^3+n1*q12^2*q13*q33^3-n1*q12^2*q23*q33^3,4*M`j'^2*q12*q13^4-4*M`j'^2*n2*q12*q13^4+4*M`j'^2*q13^5-4*M`j'^2*n2*q13^5+16*M`j'^2*q12*q13^3*q23-16*M`j'^2*n2*q12*q13^3*q23+20*M`j'^2*q13^4*q23-20*M`j'^2*n2*q13^4*q23+24*M`j'^2*q12*q13^2*q23^2-24*M`j'^2*n2*q12*q13^2*q23^2+40*M`j'^2*q13^3*q23^2-40*M`j'^2*n2*q13^3*q23^2+16*M`j'^2*q12*q13*q23^3-16*M`j'^2*n2*q12*q13*q23^3+40*M`j'^2*q13^2*q23^3-40*M`j'^2*n2*q13^2*q23^3+4*M`j'^2*q12*q23^4-4*M`j'^2*n2*q12*q23^4+20*M`j'^2*q13*q23^4-20*M`j'^2*n2*q13*q23^4+4*M`j'^2*q23^5-4*M`j'^2*n2*q23^5-16*M`j'^2*q12^2*q13^2*q33+16*M`j'^2*n2*q12^2*q13^2*q33+4*q12^3*q13^2*q33-4*n2*q12^3*q13^2*q33-16*M`j'^2*q12*q13^3*q33+16*M`j'^2*n2*q12*q13^3*q33+8*q12^2*q13^3*q33-8*n2*q12^2*q13^3*q33+2*M`j'^2*q13^4*q33-2*M`j'^2*n2*q13^4*q33+4*q12*q13^4*q33-4*n2*q12*q13^4*q33-32*M`j'^2*q12^2*q13*q23*q33+32*M`j'^2*n2*q12^2*q13*q23*q33+8*q12^3*q13*q23*q33-8*n2*q12^3*q13*q23*q33-48*M`j'^2*q12*q13^2*q23*q33+48*M`j'^2*n2*q12*q13^2*q23*q33+24*q12^2*q13^2*q23*q33-24*n2*q12^2*q13^2*q23*q33+8*M`j'^2*q13^3*q23*q33-8*M`j'^2*n2*q13^3*q23*q33+16*q12*q13^3*q23*q33-16*n2*q12*q13^3*q23*q33-16*M`j'^2*q12^2*q23^2*q33+16*M`j'^2*n2*q12^2*q23^2*q33+4*q12^3*q23^2*q33-4*n2*q12^3*q23^2*q33-48*M`j'^2*q12*q13*q23^2*q33+48*M`j'^2*n2*q12*q13*q23^2*q33+24*q12^2*q13*q23^2*q33-24*n2*q12^2*q13*q23^2*q33+12*M`j'^2*q13^2*q23^2*q33-12*M`j'^2*n2*q13^2*q23^2*q33+24*q12*q13^2*q23^2*q33-24*n2*q12*q13^2*q23^2*q33-16*M`j'^2*q12*q23^3*q33+16*M`j'^2*n2*q12*q23^3*q33+8*q12^2*q23^3*q33-8*n2*q12^2*q23^3*q33+8*M`j'^2*q13*q23^3*q33-8*M`j'^2*n2*q13*q23^3*q33+16*q12*q13*q23^3*q33-16*n2*q12*q13*q23^3*q33+2*M`j'^2*q23^4*q33-2*M`j'^2*n2*q23^4*q33+4*q12*q23^4*q33-4*n2*q12*q23^4*q33+16*M`j'^2*q12^3*q33^2-16*M`j'^2*n2*q12^3*q33^2-8*q12^4*q33^2+8*n2*q12^4*q33^2+16*M`j'^2*q12^2*q13*q33^2-16*M`j'^2*n2*q12^2*q13*q33^2-16*q12^3*q13*q33^2+16*n2*q12^3*q13*q33^2-8*M`j'^2*q12*q13^2*q33^2+8*M`j'^2*n2*q12*q13^2*q33^2-4*q12^2*q13^2*q33^2+4*n2*q12^2*q13^2*q33^2+4*q12*q13^3*q33^2-4*n2*q12*q13^3*q33^2+16*M`j'^2*q12^2*q23*q33^2-16*M`j'^2*n2*q12^2*q23*q33^2-16*q12^3*q23*q33^2+16*n2*q12^3*q23*q33^2-16*M`j'^2*q12*q13*q23*q33^2+16*M`j'^2*n2*q12*q13*q23*q33^2-8*q12^2*q13*q23*q33^2+8*n2*q12^2*q13*q23*q33^2+12*q12*q13^2*q23*q33^2-12*n2*q12*q13^2*q23*q33^2-8*M`j'^2*q12*q23^2*q33^2+8*M`j'^2*n2*q12*q23^2*q33^2-4*q12^2*q23^2*q33^2+4*n2*q12^2*q23^2*q33^2+12*q12*q13*q23^2*q33^2-12*n2*q12*q13*q23^2*q33^2+4*q12*q23^3*q33^2-4*n2*q12*q23^3*q33^2+8*M`j'^2*q12^2*q33^3-8*M`j'^2*n2*q12^2*q33^3-8*q12^3*q33^3+8*n2*q12^3*q33^3-8*q12^2*q13*q33^3+8*n2*q12^2*q13*q33^3+q12*q13^2*q33^3-n2*q12*q13^2*q33^3-8*q12^2*q23*q33^3+8*n2*q12^2*q23*q33^3+2*q12*q13*q23*q33^3-2*n2*q12*q13*q23*q33^3+q12*q23^2*q33^3-n2*q12*q23^2*q33^3-2*q12^2*q33^4+2*n2*q12^2*q33^4)+mbox1l(n1,-1+n2,2+n3,n4)*prf(8*q12^3*q13^2*q33+8*n3*q12^3*q13^2*q33+4*q12^2*q13^3*q33+4*n3*q12^2*q13^3*q33+16*M`j'^2*q12^2*q13*q23*q33+16*M`j'^2*n3*q12^2*q13*q23*q33+8*M`j'^2*q12*q13^2*q23*q33+8*M`j'^2*n3*q12*q13^2*q23*q33+4*q12^2*q13^2*q23*q33+4*n3*q12^2*q13^2*q23*q33+8*M`j'^2*q12*q13*q23^2*q33+8*M`j'^2*n3*q12*q13*q23^2*q33-8*M`j'^2*q12^3*q33^2-8*M`j'^2*n3*q12^3*q33^2-4*M`j'^2*q12^2*q13*q33^2-4*M`j'^2*n3*q12^2*q13*q33^2+8*q12^3*q13*q33^2+8*n3*q12^3*q13*q33^2+4*q12^2*q13^2*q33^2+4*n3*q12^2*q13^2*q33^2-4*M`j'^2*q12^2*q23*q33^2-4*M`j'^2*n3*q12^2*q23*q33^2+4*q12^2*q13*q23*q33^2+4*n3*q12^2*q13*q23*q33^2+2*q12^3*q33^3+2*n3*q12^3*q33^3+q12^2*q13*q33^3+n3*q12^2*q13*q33^3+q12^2*q23*q33^3+n3*q12^2*q23*q33^3,-4*M`j'^2*q13^4+4*M`j'^2*n2*q13^4-16*M`j'^2*q13^3*q23+16*M`j'^2*n2*q13^3*q23-24*M`j'^2*q13^2*q23^2+24*M`j'^2*n2*q13^2*q23^2-16*M`j'^2*q13*q23^3+16*M`j'^2*n2*q13*q23^3-4*M`j'^2*q23^4+4*M`j'^2*n2*q23^4+16*M`j'^2*q12*q13^2*q33-16*M`j'^2*n2*q12*q13^2*q33-4*q12^2*q13^2*q33+4*n2*q12^2*q13^2*q33-4*q12*q13^3*q33+4*n2*q12*q13^3*q33+32*M`j'^2*q12*q13*q23*q33-32*M`j'^2*n2*q12*q13*q23*q33-8*q12^2*q13*q23*q33+8*n2*q12^2*q13*q23*q33-12*q12*q13^2*q23*q33+12*n2*q12*q13^2*q23*q33+16*M`j'^2*q12*q23^2*q33-16*M`j'^2*n2*q12*q23^2*q33-4*q12^2*q23^2*q33+4*n2*q12^2*q23^2*q33-12*q12*q13*q23^2*q33+12*n2*q12*q13*q23^2*q33-4*q12*q23^3*q33+4*n2*q12*q23^3*q33-16*M`j'^2*q12^2*q33^2+16*M`j'^2*n2*q12^2*q33^2+8*q12^3*q33^2-8*n2*q12^3*q33^2+8*q12^2*q13*q33^2-8*n2*q12^2*q13*q33^2-2*q12*q13^2*q33^2+2*n2*q12*q13^2*q33^2+8*q12^2*q23*q33^2-8*n2*q12^2*q23*q33^2-4*q12*q13*q23*q33^2+4*n2*q12*q13*q23*q33^2-2*q12*q23^2*q33^2+2*n2*q12*q23^2*q33^2+4*q12^2*q33^3-4*n2*q12^2*q33^3)+mbox1l(1+n1,-2+n2,1+n3,n4)*prf(8*M`j'^2*n1*q12^2*q13^2*q33+12*M`j'^2*n1*q12*q13^3*q33+8*M`j'^2*n1*q12^2*q13*q23*q33+24*M`j'^2*n1*q12*q13^2*q23*q33+12*M`j'^2*n1*q12*q13*q23^2*q33-8*M`j'^2*n1*q12^3*q33^2-8*M`j'^2*n1*q12^2*q13*q33^2+14*M`j'^2*n1*q12*q13^2*q33^2-4*n1*q12^2*q13^2*q33^2-4*n1*q12*q13^3*q33^2-16*M`j'^2*n1*q12^2*q23*q33^2+8*M`j'^2*n1*q12*q13*q23*q33^2-4*n1*q12^2*q13*q23*q33^2-8*n1*q12*q13^2*q23*q33^2-6*M`j'^2*n1*q12*q23^2*q33^2-4*n1*q12*q13*q23^2*q33^2-8*M`j'^2*n1*q12^2*q33^3+4*n1*q12^3*q33^3+4*M`j'^2*n1*q12*q13*q33^3+2*n1*q12^2*q13*q33^3-4*n1*q12*q13^2*q33^3-4*M`j'^2*n1*q12*q23*q33^3+6*n1*q12^2*q23*q33^3-2*n1*q12*q13*q23*q33^3+2*n1*q12*q23^2*q33^3+2*n1*q12^2*q33^4-n1*q12*q13*q33^4+n1*q12*q23*q33^4,8*M`j'^2*q12*q13^4-8*M`j'^2*n2*q12*q13^4+8*M`j'^2*q13^5-8*M`j'^2*n2*q13^5+32*M`j'^2*q12*q13^3*q23-32*M`j'^2*n2*q12*q13^3*q23+40*M`j'^2*q13^4*q23-40*M`j'^2*n2*q13^4*q23+48*M`j'^2*q12*q13^2*q23^2-48*M`j'^2*n2*q12*q13^2*q23^2+80*M`j'^2*q13^3*q23^2-80*M`j'^2*n2*q13^3*q23^2+32*M`j'^2*q12*q13*q23^3-32*M`j'^2*n2*q12*q13*q23^3+80*M`j'^2*q13^2*q23^3-80*M`j'^2*n2*q13^2*q23^3+8*M`j'^2*q12*q23^4-8*M`j'^2*n2*q12*q23^4+40*M`j'^2*q13*q23^4-40*M`j'^2*n2*q13*q23^4+8*M`j'^2*q23^5-8*M`j'^2*n2*q23^5-32*M`j'^2*q12^2*q13^2*q33+32*M`j'^2*n2*q12^2*q13^2*q33+8*q12^3*q13^2*q33-8*n2*q12^3*q13^2*q33-32*M`j'^2*q12*q13^3*q33+32*M`j'^2*n2*q12*q13^3*q33+16*q12^2*q13^3*q33-16*n2*q12^2*q13^3*q33+4*M`j'^2*q13^4*q33-4*M`j'^2*n2*q13^4*q33+8*q12*q13^4*q33-8*n2*q12*q13^4*q33-64*M`j'^2*q12^2*q13*q23*q33+64*M`j'^2*n2*q12^2*q13*q23*q33+16*q12^3*q13*q23*q33-16*n2*q12^3*q13*q23*q33-96*M`j'^2*q12*q13^2*q23*q33+96*M`j'^2*n2*q12*q13^2*q23*q33+48*q12^2*q13^2*q23*q33-48*n2*q12^2*q13^2*q23*q33+16*M`j'^2*q13^3*q23*q33-16*M`j'^2*n2*q13^3*q23*q33+32*q12*q13^3*q23*q33-32*n2*q12*q13^3*q23*q33-32*M`j'^2*q12^2*q23^2*q33+32*M`j'^2*n2*q12^2*q23^2*q33+8*q12^3*q23^2*q33-8*n2*q12^3*q23^2*q33-96*M`j'^2*q12*q13*q23^2*q33+96*M`j'^2*n2*q12*q13*q23^2*q33+48*q12^2*q13*q23^2*q33-48*n2*q12^2*q13*q23^2*q33+24*M`j'^2*q13^2*q23^2*q33-24*M`j'^2*n2*q13^2*q23^2*q33+48*q12*q13^2*q23^2*q33-48*n2*q12*q13^2*q23^2*q33-32*M`j'^2*q12*q23^3*q33+32*M`j'^2*n2*q12*q23^3*q33+16*q12^2*q23^3*q33-16*n2*q12^2*q23^3*q33+16*M`j'^2*q13*q23^3*q33-16*M`j'^2*n2*q13*q23^3*q33+32*q12*q13*q23^3*q33-32*n2*q12*q13*q23^3*q33+4*M`j'^2*q23^4*q33-4*M`j'^2*n2*q23^4*q33+8*q12*q23^4*q33-8*n2*q12*q23^4*q33+32*M`j'^2*q12^3*q33^2-32*M`j'^2*n2*q12^3*q33^2-16*q12^4*q33^2+16*n2*q12^4*q33^2+32*M`j'^2*q12^2*q13*q33^2-32*M`j'^2*n2*q12^2*q13*q33^2-32*q12^3*q13*q33^2+32*n2*q12^3*q13*q33^2-16*M`j'^2*q12*q13^2*q33^2+16*M`j'^2*n2*q12*q13^2*q33^2-8*q12^2*q13^2*q33^2+8*n2*q12^2*q13^2*q33^2+8*q12*q13^3*q33^2-8*n2*q12*q13^3*q33^2+32*M`j'^2*q12^2*q23*q33^2-32*M`j'^2*n2*q12^2*q23*q33^2-32*q12^3*q23*q33^2+32*n2*q12^3*q23*q33^2-32*M`j'^2*q12*q13*q23*q33^2+32*M`j'^2*n2*q12*q13*q23*q33^2-16*q12^2*q13*q23*q33^2+16*n2*q12^2*q13*q23*q33^2+24*q12*q13^2*q23*q33^2-24*n2*q12*q13^2*q23*q33^2-16*M`j'^2*q12*q23^2*q33^2+16*M`j'^2*n2*q12*q23^2*q33^2-8*q12^2*q23^2*q33^2+8*n2*q12^2*q23^2*q33^2+24*q12*q13*q23^2*q33^2-24*n2*q12*q13*q23^2*q33^2+8*q12*q23^3*q33^2-8*n2*q12*q23^3*q33^2+16*M`j'^2*q12^2*q33^3-16*M`j'^2*n2*q12^2*q33^3-16*q12^3*q33^3+16*n2*q12^3*q33^3-16*q12^2*q13*q33^3+16*n2*q12^2*q13*q33^3+2*q12*q13^2*q33^3-2*n2*q12*q13^2*q33^3-16*q12^2*q23*q33^3+16*n2*q12^2*q23*q33^3+4*q12*q13*q23*q33^3-4*n2*q12*q13*q23*q33^3+2*q12*q23^2*q33^3-2*n2*q12*q23^2*q33^3-4*q12^2*q33^4+4*n2*q12^2*q33^4)+mbox1l(n1,-1+n2,1+n3,n4)*(tmpprf(ep,1)*prf(16*q12^3*q13^2*q33+24*q12^2*q13^3*q33+8*q12*q13^4*q33+16*q12^3*q13*q23*q33+48*q12^2*q13^2*q23*q33+24*q12*q13^3*q23*q33+24*q12^2*q13*q23^2*q33+24*q12*q13^2*q23^2*q33+8*q12*q13*q23^3*q33-16*q12^4*q33^2-16*q12^3*q13*q33^2+12*q12^2*q13^2*q33^2+8*q12*q13^3*q33^2-32*q12^3*q23*q33^2-8*q12^2*q13*q23*q33^2+12*q12*q13^2*q23*q33^2-20*q12^2*q23^2*q33^2-4*q12*q23^3*q33^2-8*q12^3*q33^3+2*q12*q13^2*q33^3-8*q12^2*q23*q33^3-2*q12*q23^2*q33^3,8*M`j'^2*q12*q13^4-8*M`j'^2*n2*q12*q13^4+8*M`j'^2*q13^5-8*M`j'^2*n2*q13^5+32*M`j'^2*q12*q13^3*q23-32*M`j'^2*n2*q12*q13^3*q23+40*M`j'^2*q13^4*q23-40*M`j'^2*n2*q13^4*q23+48*M`j'^2*q12*q13^2*q23^2-48*M`j'^2*n2*q12*q13^2*q23^2+80*M`j'^2*q13^3*q23^2-80*M`j'^2*n2*q13^3*q23^2+32*M`j'^2*q12*q13*q23^3-32*M`j'^2*n2*q12*q13*q23^3+80*M`j'^2*q13^2*q23^3-80*M`j'^2*n2*q13^2*q23^3+8*M`j'^2*q12*q23^4-8*M`j'^2*n2*q12*q23^4+40*M`j'^2*q13*q23^4-40*M`j'^2*n2*q13*q23^4+8*M`j'^2*q23^5-8*M`j'^2*n2*q23^5-32*M`j'^2*q12^2*q13^2*q33+32*M`j'^2*n2*q12^2*q13^2*q33+8*q12^3*q13^2*q33-8*n2*q12^3*q13^2*q33-32*M`j'^2*q12*q13^3*q33+32*M`j'^2*n2*q12*q13^3*q33+16*q12^2*q13^3*q33-16*n2*q12^2*q13^3*q33+4*M`j'^2*q13^4*q33-4*M`j'^2*n2*q13^4*q33+8*q12*q13^4*q33-8*n2*q12*q13^4*q33-64*M`j'^2*q12^2*q13*q23*q33+64*M`j'^2*n2*q12^2*q13*q23*q33+16*q12^3*q13*q23*q33-16*n2*q12^3*q13*q23*q33-96*M`j'^2*q12*q13^2*q23*q33+96*M`j'^2*n2*q12*q13^2*q23*q33+48*q12^2*q13^2*q23*q33-48*n2*q12^2*q13^2*q23*q33+16*M`j'^2*q13^3*q23*q33-16*M`j'^2*n2*q13^3*q23*q33+32*q12*q13^3*q23*q33-32*n2*q12*q13^3*q23*q33-32*M`j'^2*q12^2*q23^2*q33+32*M`j'^2*n2*q12^2*q23^2*q33+8*q12^3*q23^2*q33-8*n2*q12^3*q23^2*q33-96*M`j'^2*q12*q13*q23^2*q33+96*M`j'^2*n2*q12*q13*q23^2*q33+48*q12^2*q13*q23^2*q33-48*n2*q12^2*q13*q23^2*q33+24*M`j'^2*q13^2*q23^2*q33-24*M`j'^2*n2*q13^2*q23^2*q33+48*q12*q13^2*q23^2*q33-48*n2*q12*q13^2*q23^2*q33-32*M`j'^2*q12*q23^3*q33+32*M`j'^2*n2*q12*q23^3*q33+16*q12^2*q23^3*q33-16*n2*q12^2*q23^3*q33+16*M`j'^2*q13*q23^3*q33-16*M`j'^2*n2*q13*q23^3*q33+32*q12*q13*q23^3*q33-32*n2*q12*q13*q23^3*q33+4*M`j'^2*q23^4*q33-4*M`j'^2*n2*q23^4*q33+8*q12*q23^4*q33-8*n2*q12*q23^4*q33+32*M`j'^2*q12^3*q33^2-32*M`j'^2*n2*q12^3*q33^2-16*q12^4*q33^2+16*n2*q12^4*q33^2+32*M`j'^2*q12^2*q13*q33^2-32*M`j'^2*n2*q12^2*q13*q33^2-32*q12^3*q13*q33^2+32*n2*q12^3*q13*q33^2-16*M`j'^2*q12*q13^2*q33^2+16*M`j'^2*n2*q12*q13^2*q33^2-8*q12^2*q13^2*q33^2+8*n2*q12^2*q13^2*q33^2+8*q12*q13^3*q33^2-8*n2*q12*q13^3*q33^2+32*M`j'^2*q12^2*q23*q33^2-32*M`j'^2*n2*q12^2*q23*q33^2-32*q12^3*q23*q33^2+32*n2*q12^3*q23*q33^2-32*M`j'^2*q12*q13*q23*q33^2+32*M`j'^2*n2*q12*q13*q23*q33^2-16*q12^2*q13*q23*q33^2+16*n2*q12^2*q13*q23*q33^2+24*q12*q13^2*q23*q33^2-24*n2*q12*q13^2*q23*q33^2-16*M`j'^2*q12*q23^2*q33^2+16*M`j'^2*n2*q12*q23^2*q33^2-8*q12^2*q23^2*q33^2+8*n2*q12^2*q23^2*q33^2+24*q12*q13*q23^2*q33^2-24*n2*q12*q13*q23^2*q33^2+8*q12*q23^3*q33^2-8*n2*q12*q23^3*q33^2+16*M`j'^2*q12^2*q33^3-16*M`j'^2*n2*q12^2*q33^3-16*q12^3*q33^3+16*n2*q12^3*q33^3-16*q12^2*q13*q33^3+16*n2*q12^2*q13*q33^3+2*q12*q13^2*q33^3-2*n2*q12*q13^2*q33^3-16*q12^2*q23*q33^3+16*n2*q12^2*q23*q33^3+4*q12*q13*q23*q33^3-4*n2*q12*q13*q23*q33^3+2*q12*q23^2*q33^3-2*n2*q12*q23^2*q33^3-4*q12^2*q33^4+4*n2*q12^2*q33^4)+prf(8*M`j'^2*q12*q13^4-8*M`j'^2*n1*q12*q13^4+8*M`j'^2*n3*q12*q13^4+16*M`j'^2*q13^5-8*M`j'^2*n2*q13^5+8*M`j'^2*n3*q13^5+24*M`j'^2*q12*q13^3*q23-24*M`j'^2*n1*q12*q13^3*q23+24*M`j'^2*n3*q12*q13^3*q23+64*M`j'^2*q13^4*q23-32*M`j'^2*n2*q13^4*q23+32*M`j'^2*n3*q13^4*q23+24*M`j'^2*q12*q13^2*q23^2-24*M`j'^2*n1*q12*q13^2*q23^2+24*M`j'^2*n3*q12*q13^2*q23^2+96*M`j'^2*q13^3*q23^2-48*M`j'^2*n2*q13^3*q23^2+48*M`j'^2*n3*q13^3*q23^2+8*M`j'^2*q12*q13*q23^3-8*M`j'^2*n1*q12*q13*q23^3+8*M`j'^2*n3*q12*q13*q23^3+64*M`j'^2*q13^2*q23^3-32*M`j'^2*n2*q13^2*q23^3+32*M`j'^2*n3*q13^2*q23^3+16*M`j'^2*q13*q23^4-8*M`j'^2*n2*q13*q23^4+8*M`j'^2*n3*q13*q23^4-48*M`j'^2*q12^2*q13^2*q33+8*M`j'^2*n1*q12^2*q13^2*q33+24*M`j'^2*n2*q12^2*q13^2*q33-24*M`j'^2*n3*q12^2*q13^2*q33-8*M`j'^2*n4*q12^2*q13^2*q33-16*q12^3*q13^2*q33+8*n1*q12^3*q13^2*q33+16*n3*q12^3*q13^2*q33+16*n4*q12^3*q13^2*q33-72*M`j'^2*q12*q13^3*q33-20*M`j'^2*n1*q12*q13^3*q33+48*M`j'^2*n2*q12*q13^3*q33-24*M`j'^2*n3*q12*q13^3*q33-4*M`j'^2*n4*q12*q13^3*q33-12*q12^2*q13^3*q33+16*n1*q12^2*q13^3*q33-8*n2*q12^2*q13^3*q33+28*n3*q12^2*q13^3*q33+24*n4*q12^2*q13^3*q33+8*M`j'^2*q13^4*q33-4*M`j'^2*n2*q13^4*q33+4*M`j'^2*n3*q13^4*q33+4*q12*q13^4*q33+8*n1*q12*q13^4*q33-8*n2*q12*q13^4*q33+12*n3*q12*q13^4*q33+8*n4*q12*q13^4*q33-56*M`j'^2*q12^2*q13*q23*q33+16*M`j'^2*n1*q12^2*q13*q23*q33+24*M`j'^2*n2*q12^2*q13*q23*q33-32*M`j'^2*n3*q12^2*q13*q23*q33-8*M`j'^2*n4*q12^2*q13*q23*q33-16*q12^3*q13*q23*q33+8*n1*q12^3*q13*q23*q33+16*n3*q12^3*q13*q23*q33+16*n4*q12^3*q13*q23*q33-156*M`j'^2*q12*q13^2*q23*q33-36*M`j'^2*n1*q12*q13^2*q23*q33+100*M`j'^2*n2*q12*q13^2*q23*q33-56*M`j'^2*n3*q12*q13^2*q23*q33-8*M`j'^2*n4*q12*q13^2*q23*q33-24*q12^2*q13^2*q23*q33+32*n1*q12^2*q13^2*q23*q33-16*n2*q12^2*q13^2*q23*q33+56*n3*q12^2*q13^2*q23*q33+48*n4*q12^2*q13^2*q23*q33+24*M`j'^2*q13^3*q23*q33-12*M`j'^2*n2*q13^3*q23*q33+12*M`j'^2*n3*q13^3*q23*q33+12*q12*q13^3*q23*q33+24*n1*q12*q13^3*q23*q33-24*n2*q12*q13^3*q23*q33+36*n3*q12*q13^3*q23*q33+24*n4*q12*q13^3*q23*q33-8*M`j'^2*q12^2*q23^2*q33+8*M`j'^2*n1*q12^2*q23^2*q33-8*M`j'^2*n3*q12^2*q23^2*q33-96*M`j'^2*q12*q13*q23^2*q33-12*M`j'^2*n1*q12*q13*q23^2*q33+56*M`j'^2*n2*q12*q13*q23^2*q33-40*M`j'^2*n3*q12*q13*q23^2*q33-4*M`j'^2*n4*q12*q13*q23^2*q33-12*q12^2*q13*q23^2*q33+16*n1*q12^2*q13*q23^2*q33-8*n2*q12^2*q13*q23^2*q33+28*n3*q12^2*q13*q23^2*q33+24*n4*q12^2*q13*q23^2*q33+24*M`j'^2*q13^2*q23^2*q33-12*M`j'^2*n2*q13^2*q23^2*q33+12*M`j'^2*n3*q13^2*q23^2*q33+12*q12*q13^2*q23^2*q33+24*n1*q12*q13^2*q23^2*q33-24*n2*q12*q13^2*q23^2*q33+36*n3*q12*q13^2*q23^2*q33+24*n4*q12*q13^2*q23^2*q33-12*M`j'^2*q12*q23^3*q33+4*M`j'^2*n1*q12*q23^3*q33+4*M`j'^2*n2*q12*q23^3*q33-8*M`j'^2*n3*q12*q23^3*q33+8*M`j'^2*q13*q23^3*q33-4*M`j'^2*n2*q13*q23^3*q33+4*M`j'^2*n3*q13*q23^3*q33+4*q12*q13*q23^3*q33+8*n1*q12*q13*q23^3*q33-8*n2*q12*q13*q23^3*q33+12*n3*q12*q13*q23^3*q33+8*n4*q12*q13*q23^3*q33+40*M`j'^2*q12^3*q33^2-24*M`j'^2*n2*q12^3*q33^2+16*M`j'^2*n3*q12^3*q33^2+8*M`j'^2*n4*q12^3*q33^2+16*q12^4*q33^2-8*n1*q12^4*q33^2-16*n3*q12^4*q33^2-16*n4*q12^4*q33^2+48*M`j'^2*q12^2*q13*q33^2+16*M`j'^2*n1*q12^2*q13*q33^2-32*M`j'^2*n2*q12^2*q13*q33^2+16*M`j'^2*n3*q12^2*q13*q33^2-4*q12^3*q13*q33^2-12*n1*q12^3*q13*q33^2+12*n2*q12^3*q13*q33^2-24*n3*q12^3*q13*q33^2-16*n4*q12^3*q13*q33^2-42*M`j'^2*q12*q13^2*q33^2-16*M`j'^2*n1*q12*q13^2*q33^2+30*M`j'^2*n2*q12*q13^2*q33^2-12*M`j'^2*n3*q12*q13^2*q33^2-2*M`j'^2*n4*q12*q13^2*q33^2-22*q12^2*q13^2*q33^2+8*n1*q12^2*q13^2*q33^2+4*n2*q12^2*q13^2*q33^2+6*n3*q12^2*q13^2*q33^2+12*n4*q12^2*q13^2*q33^2+8*q12*q13^3*q33^2+12*n1*q12*q13^3*q33^2-12*n2*q12*q13^3*q33^2+12*n3*q12*q13^3*q33^2+8*n4*q12*q13^3*q33^2+56*M`j'^2*q12^2*q23*q33^2+16*M`j'^2*n1*q12^2*q23*q33^2-40*M`j'^2*n2*q12^2*q23*q33^2+16*M`j'^2*n3*q12^2*q23*q33^2+8*M`j'^2*n4*q12^2*q23*q33^2+28*q12^3*q23*q33^2-20*n1*q12^3*q23*q33^2+4*n2*q12^3*q23*q33^2-32*n3*q12^3*q23*q33^2-32*n4*q12^3*q23*q33^2-40*M`j'^2*q12*q13*q23*q33^2-8*M`j'^2*n1*q12*q13*q23*q33^2+24*M`j'^2*n2*q12*q13*q23*q33^2-16*M`j'^2*n3*q12*q13*q23*q33^2-4*q12^2*q13*q23*q33^2-8*n1*q12^2*q13*q23*q33^2+8*n2*q12^2*q13*q23*q33^2-12*n3*q12^2*q13*q23*q33^2-8*n4*q12^2*q13*q23*q33^2+22*q12*q13^2*q23*q33^2+20*n1*q12*q13^2*q23*q33^2-24*n2*q12*q13^2*q23*q33^2+22*n3*q12*q13^2*q23*q33^2+12*n4*q12*q13^2*q23*q33^2+2*M`j'^2*q12*q23^2*q33^2+8*M`j'^2*n1*q12*q23^2*q33^2-6*M`j'^2*n2*q12*q23^2*q33^2-4*M`j'^2*n3*q12*q23^2*q33^2+2*M`j'^2*n4*q12*q23^2*q33^2+18*q12^2*q23^2*q33^2-16*n1*q12^2*q23^2*q33^2+4*n2*q12^2*q23^2*q33^2-18*n3*q12^2*q23^2*q33^2-20*n4*q12^2*q23^2*q33^2+20*q12*q13*q23^2*q33^2+4*n1*q12*q13*q23^2*q33^2-12*n2*q12*q13*q23^2*q33^2+8*n3*q12*q13*q23^2*q33^2+6*q12*q23^3*q33^2-4*n1*q12*q23^3*q33^2-2*n3*q12*q23^3*q33^2-4*n4*q12*q23^3*q33^2+24*M`j'^2*q12^2*q33^3+8*M`j'^2*n1*q12^2*q33^3-16*M`j'^2*n2*q12^2*q33^3+8*M`j'^2*n3*q12^2*q33^3-4*q12^3*q33^3-8*n1*q12^3*q33^3+8*n2*q12^3*q33^3-12*n3*q12^3*q33^3-8*n4*q12^3*q33^3-4*M`j'^2*q12*q13*q33^3-4*M`j'^2*n1*q12*q13*q33^3+4*M`j'^2*n2*q12*q13*q33^3-20*q12^2*q13*q33^3-4*n1*q12^2*q13*q33^3+12*n2*q12^2*q13*q33^3-8*n3*q12^2*q13*q33^3+5*q12*q13^2*q33^3+6*n1*q12*q13^2*q33^3-6*n2*q12*q13^2*q33^3+3*n3*q12*q13^2*q33^3+2*n4*q12*q13^2*q33^3+4*M`j'^2*q12*q23*q33^3+4*M`j'^2*n1*q12*q23*q33^3-4*M`j'^2*n2*q12*q23*q33^3-8*q12^2*q23*q33^3-12*n1*q12^2*q23*q33^3+12*n2*q12^2*q23*q33^3-12*n3*q12^2*q23*q33^3-8*n4*q12^2*q23*q33^3+6*q12*q13*q23*q33^3+2*n1*q12*q13*q23*q33^3-4*n2*q12*q13*q23*q33^3+2*n3*q12*q13*q23*q33^3+q12*q23^2*q33^3-4*n1*q12*q23^2*q33^3+2*n2*q12*q23^2*q33^3-n3*q12*q23^2*q33^3-2*n4*q12*q23^2*q33^3-6*q12^2*q33^4-2*n1*q12^2*q33^4+4*n2*q12^2*q33^4-2*n3*q12^2*q33^4+q12*q13*q33^4+n1*q12*q13*q33^4-n2*q12*q13*q33^4-q12*q23*q33^4-n1*q12*q23*q33^4+n2*q12*q23*q33^4,8*M`j'^2*q12*q13^4-8*M`j'^2*n2*q12*q13^4+8*M`j'^2*q13^5-8*M`j'^2*n2*q13^5+32*M`j'^2*q12*q13^3*q23-32*M`j'^2*n2*q12*q13^3*q23+40*M`j'^2*q13^4*q23-40*M`j'^2*n2*q13^4*q23+48*M`j'^2*q12*q13^2*q23^2-48*M`j'^2*n2*q12*q13^2*q23^2+80*M`j'^2*q13^3*q23^2-80*M`j'^2*n2*q13^3*q23^2+32*M`j'^2*q12*q13*q23^3-32*M`j'^2*n2*q12*q13*q23^3+80*M`j'^2*q13^2*q23^3-80*M`j'^2*n2*q13^2*q23^3+8*M`j'^2*q12*q23^4-8*M`j'^2*n2*q12*q23^4+40*M`j'^2*q13*q23^4-40*M`j'^2*n2*q13*q23^4+8*M`j'^2*q23^5-8*M`j'^2*n2*q23^5-32*M`j'^2*q12^2*q13^2*q33+32*M`j'^2*n2*q12^2*q13^2*q33+8*q12^3*q13^2*q33-8*n2*q12^3*q13^2*q33-32*M`j'^2*q12*q13^3*q33+32*M`j'^2*n2*q12*q13^3*q33+16*q12^2*q13^3*q33-16*n2*q12^2*q13^3*q33+4*M`j'^2*q13^4*q33-4*M`j'^2*n2*q13^4*q33+8*q12*q13^4*q33-8*n2*q12*q13^4*q33-64*M`j'^2*q12^2*q13*q23*q33+64*M`j'^2*n2*q12^2*q13*q23*q33+16*q12^3*q13*q23*q33-16*n2*q12^3*q13*q23*q33-96*M`j'^2*q12*q13^2*q23*q33+96*M`j'^2*n2*q12*q13^2*q23*q33+48*q12^2*q13^2*q23*q33-48*n2*q12^2*q13^2*q23*q33+16*M`j'^2*q13^3*q23*q33-16*M`j'^2*n2*q13^3*q23*q33+32*q12*q13^3*q23*q33-32*n2*q12*q13^3*q23*q33-32*M`j'^2*q12^2*q23^2*q33+32*M`j'^2*n2*q12^2*q23^2*q33+8*q12^3*q23^2*q33-8*n2*q12^3*q23^2*q33-96*M`j'^2*q12*q13*q23^2*q33+96*M`j'^2*n2*q12*q13*q23^2*q33+48*q12^2*q13*q23^2*q33-48*n2*q12^2*q13*q23^2*q33+24*M`j'^2*q13^2*q23^2*q33-24*M`j'^2*n2*q13^2*q23^2*q33+48*q12*q13^2*q23^2*q33-48*n2*q12*q13^2*q23^2*q33-32*M`j'^2*q12*q23^3*q33+32*M`j'^2*n2*q12*q23^3*q33+16*q12^2*q23^3*q33-16*n2*q12^2*q23^3*q33+16*M`j'^2*q13*q23^3*q33-16*M`j'^2*n2*q13*q23^3*q33+32*q12*q13*q23^3*q33-32*n2*q12*q13*q23^3*q33+4*M`j'^2*q23^4*q33-4*M`j'^2*n2*q23^4*q33+8*q12*q23^4*q33-8*n2*q12*q23^4*q33+32*M`j'^2*q12^3*q33^2-32*M`j'^2*n2*q12^3*q33^2-16*q12^4*q33^2+16*n2*q12^4*q33^2+32*M`j'^2*q12^2*q13*q33^2-32*M`j'^2*n2*q12^2*q13*q33^2-32*q12^3*q13*q33^2+32*n2*q12^3*q13*q33^2-16*M`j'^2*q12*q13^2*q33^2+16*M`j'^2*n2*q12*q13^2*q33^2-8*q12^2*q13^2*q33^2+8*n2*q12^2*q13^2*q33^2+8*q12*q13^3*q33^2-8*n2*q12*q13^3*q33^2+32*M`j'^2*q12^2*q23*q33^2-32*M`j'^2*n2*q12^2*q23*q33^2-32*q12^3*q23*q33^2+32*n2*q12^3*q23*q33^2-32*M`j'^2*q12*q13*q23*q33^2+32*M`j'^2*n2*q12*q13*q23*q33^2-16*q12^2*q13*q23*q33^2+16*n2*q12^2*q13*q23*q33^2+24*q12*q13^2*q23*q33^2-24*n2*q12*q13^2*q23*q33^2-16*M`j'^2*q12*q23^2*q33^2+16*M`j'^2*n2*q12*q23^2*q33^2-8*q12^2*q23^2*q33^2+8*n2*q12^2*q23^2*q33^2+24*q12*q13*q23^2*q33^2-24*n2*q12*q13*q23^2*q33^2+8*q12*q23^3*q33^2-8*n2*q12*q23^3*q33^2+16*M`j'^2*q12^2*q33^3-16*M`j'^2*n2*q12^2*q33^3-16*q12^3*q33^3+16*n2*q12^3*q33^3-16*q12^2*q13*q33^3+16*n2*q12^2*q13*q33^3+2*q12*q13^2*q33^3-2*n2*q12*q13^2*q33^3-16*q12^2*q23*q33^3+16*n2*q12^2*q23*q33^3+4*q12*q13*q23*q33^3-4*n2*q12*q13*q23*q33^3+2*q12*q23^2*q33^3-2*n2*q12*q23^2*q33^3-4*q12^2*q33^4+4*n2*q12^2*q33^4))+mbox1l(-1+n1,-1+n2,2+n3,n4)*prf(-8*M`j'^2*q12*q13^4-8*M`j'^2*n3*q12*q13^4-24*M`j'^2*q12*q13^3*q23-24*M`j'^2*n3*q12*q13^3*q23-8*M`j'^2*q13^4*q23-8*M`j'^2*n3*q13^4*q23-24*M`j'^2*q12*q13^2*q23^2-24*M`j'^2*n3*q12*q13^2*q23^2-24*M`j'^2*q13^3*q23^2-24*M`j'^2*n3*q13^3*q23^2-8*M`j'^2*q12*q13*q23^3-8*M`j'^2*n3*q12*q13*q23^3-24*M`j'^2*q13^2*q23^3-24*M`j'^2*n3*q13^2*q23^3-8*M`j'^2*q13*q23^4-8*M`j'^2*n3*q13*q23^4-8*M`j'^2*q12^3*q13*q33-8*M`j'^2*n3*q12^3*q13*q33+8*q12^4*q13*q33+8*n3*q12^4*q13*q33-4*M`j'^2*q12^2*q13^2*q33-4*M`j'^2*n3*q12^2*q13^2*q33+20*q12^3*q13^2*q33+20*n3*q12^3*q13^2*q33-20*M`j'^2*q12*q13^3*q33-20*M`j'^2*n3*q12*q13^3*q33+20*q12^2*q13^3*q33+20*n3*q12^2*q13^3*q33+8*q12*q13^4*q33+8*n3*q12*q13^4*q33+8*M`j'^2*q12^3*q23*q33+8*M`j'^2*n3*q12^3*q23*q33+32*M`j'^2*q12^2*q13*q23*q33+32*M`j'^2*n3*q12^2*q13*q23*q33+12*q12^3*q13*q23*q33+12*n3*q12^3*q13*q23*q33+4*M`j'^2*q12*q13^2*q23*q33+4*M`j'^2*n3*q12*q13^2*q23*q33+20*q12^2*q13^2*q23*q33+20*n3*q12^2*q13^2*q23*q33-4*M`j'^2*q13^3*q23*q33-4*M`j'^2*n3*q13^3*q23*q33+12*q12*q13^3*q23*q33+12*n3*q12*q13^3*q23*q33+20*M`j'^2*q12^2*q23^2*q33+20*M`j'^2*n3*q12^2*q23^2*q33+36*M`j'^2*q12*q13*q23^2*q33+36*M`j'^2*n3*q12*q13*q23^2*q33-8*M`j'^2*q13^2*q23^2*q33-8*M`j'^2*n3*q13^2*q23^2*q33+12*M`j'^2*q12*q23^3*q33+12*M`j'^2*n3*q12*q23^3*q33-4*M`j'^2*q13*q23^3*q33-4*M`j'^2*n3*q13*q23^3*q33-4*q12*q13*q23^3*q33-4*n3*q12*q13*q23^3*q33-8*M`j'^2*q12^3*q33^2-8*M`j'^2*n3*q12^3*q33^2+4*q12^4*q33^2+4*n3*q12^4*q33^2-4*M`j'^2*q12^2*q13*q33^2-4*M`j'^2*n3*q12^2*q13*q33^2+14*q12^3*q13*q33^2+14*n3*q12^3*q13*q33^2-16*M`j'^2*q12*q13^2*q33^2-16*M`j'^2*n3*q12*q13^2*q33^2+20*q12^2*q13^2*q33^2+20*n3*q12^2*q13^2*q33^2+12*q12*q13^3*q33^2+12*n3*q12*q13^3*q33^2+4*M`j'^2*q12^2*q23*q33^2+4*M`j'^2*n3*q12^2*q23*q33^2+6*q12^3*q23*q33^2+6*n3*q12^3*q23*q33^2+12*M`j'^2*q12*q13*q23*q33^2+12*M`j'^2*n3*q12*q13*q23*q33^2+8*q12^2*q13*q23*q33^2+8*n3*q12^2*q13*q23*q33^2+8*q12*q13^2*q23*q33^2+8*n3*q12*q13^2*q23*q33^2+12*M`j'^2*q12*q23^2*q33^2+12*M`j'^2*n3*q12*q23^2*q33^2-6*q12*q13*q23^2*q33^2-6*n3*q12*q13*q23^2*q33^2-2*q12*q23^3*q33^2-2*n3*q12*q23^3*q33^2+2*q12^3*q33^3+2*n3*q12^3*q33^3-4*M`j'^2*q12*q13*q33^3-4*M`j'^2*n3*q12*q13*q33^3+5*q12^2*q13*q33^3+5*n3*q12^2*q13*q33^3+6*q12*q13^2*q33^3+6*n3*q12*q13^2*q33^3+4*M`j'^2*q12*q23*q33^3+4*M`j'^2*n3*q12*q23*q33^3-q12^2*q23*q33^3-n3*q12^2*q23*q33^3-q12*q13*q23*q33^3-n3*q12*q13*q23*q33^3-3*q12*q23^2*q33^3-3*n3*q12*q23^2*q33^3+q12*q13*q33^4+n3*q12*q13*q33^4-q12*q23*q33^4-n3*q12*q23*q33^4,8*M`j'^2*q12*q13^4-8*M`j'^2*n2*q12*q13^4+8*M`j'^2*q13^5-8*M`j'^2*n2*q13^5+32*M`j'^2*q12*q13^3*q23-32*M`j'^2*n2*q12*q13^3*q23+40*M`j'^2*q13^4*q23-40*M`j'^2*n2*q13^4*q23+48*M`j'^2*q12*q13^2*q23^2-48*M`j'^2*n2*q12*q13^2*q23^2+80*M`j'^2*q13^3*q23^2-80*M`j'^2*n2*q13^3*q23^2+32*M`j'^2*q12*q13*q23^3-32*M`j'^2*n2*q12*q13*q23^3+80*M`j'^2*q13^2*q23^3-80*M`j'^2*n2*q13^2*q23^3+8*M`j'^2*q12*q23^4-8*M`j'^2*n2*q12*q23^4+40*M`j'^2*q13*q23^4-40*M`j'^2*n2*q13*q23^4+8*M`j'^2*q23^5-8*M`j'^2*n2*q23^5-32*M`j'^2*q12^2*q13^2*q33+32*M`j'^2*n2*q12^2*q13^2*q33+8*q12^3*q13^2*q33-8*n2*q12^3*q13^2*q33-32*M`j'^2*q12*q13^3*q33+32*M`j'^2*n2*q12*q13^3*q33+16*q12^2*q13^3*q33-16*n2*q12^2*q13^3*q33+4*M`j'^2*q13^4*q33-4*M`j'^2*n2*q13^4*q33+8*q12*q13^4*q33-8*n2*q12*q13^4*q33-64*M`j'^2*q12^2*q13*q23*q33+64*M`j'^2*n2*q12^2*q13*q23*q33+16*q12^3*q13*q23*q33-16*n2*q12^3*q13*q23*q33-96*M`j'^2*q12*q13^2*q23*q33+96*M`j'^2*n2*q12*q13^2*q23*q33+48*q12^2*q13^2*q23*q33-48*n2*q12^2*q13^2*q23*q33+16*M`j'^2*q13^3*q23*q33-16*M`j'^2*n2*q13^3*q23*q33+32*q12*q13^3*q23*q33-32*n2*q12*q13^3*q23*q33-32*M`j'^2*q12^2*q23^2*q33+32*M`j'^2*n2*q12^2*q23^2*q33+8*q12^3*q23^2*q33-8*n2*q12^3*q23^2*q33-96*M`j'^2*q12*q13*q23^2*q33+96*M`j'^2*n2*q12*q13*q23^2*q33+48*q12^2*q13*q23^2*q33-48*n2*q12^2*q13*q23^2*q33+24*M`j'^2*q13^2*q23^2*q33-24*M`j'^2*n2*q13^2*q23^2*q33+48*q12*q13^2*q23^2*q33-48*n2*q12*q13^2*q23^2*q33-32*M`j'^2*q12*q23^3*q33+32*M`j'^2*n2*q12*q23^3*q33+16*q12^2*q23^3*q33-16*n2*q12^2*q23^3*q33+16*M`j'^2*q13*q23^3*q33-16*M`j'^2*n2*q13*q23^3*q33+32*q12*q13*q23^3*q33-32*n2*q12*q13*q23^3*q33+4*M`j'^2*q23^4*q33-4*M`j'^2*n2*q23^4*q33+8*q12*q23^4*q33-8*n2*q12*q23^4*q33+32*M`j'^2*q12^3*q33^2-32*M`j'^2*n2*q12^3*q33^2-16*q12^4*q33^2+16*n2*q12^4*q33^2+32*M`j'^2*q12^2*q13*q33^2-32*M`j'^2*n2*q12^2*q13*q33^2-32*q12^3*q13*q33^2+32*n2*q12^3*q13*q33^2-16*M`j'^2*q12*q13^2*q33^2+16*M`j'^2*n2*q12*q13^2*q33^2-8*q12^2*q13^2*q33^2+8*n2*q12^2*q13^2*q33^2+8*q12*q13^3*q33^2-8*n2*q12*q13^3*q33^2+32*M`j'^2*q12^2*q23*q33^2-32*M`j'^2*n2*q12^2*q23*q33^2-32*q12^3*q23*q33^2+32*n2*q12^3*q23*q33^2-32*M`j'^2*q12*q13*q23*q33^2+32*M`j'^2*n2*q12*q13*q23*q33^2-16*q12^2*q13*q23*q33^2+16*n2*q12^2*q13*q23*q33^2+24*q12*q13^2*q23*q33^2-24*n2*q12*q13^2*q23*q33^2-16*M`j'^2*q12*q23^2*q33^2+16*M`j'^2*n2*q12*q23^2*q33^2-8*q12^2*q23^2*q33^2+8*n2*q12^2*q23^2*q33^2+24*q12*q13*q23^2*q33^2-24*n2*q12*q13*q23^2*q33^2+8*q12*q23^3*q33^2-8*n2*q12*q23^3*q33^2+16*M`j'^2*q12^2*q33^3-16*M`j'^2*n2*q12^2*q33^3-16*q12^3*q33^3+16*n2*q12^3*q33^3-16*q12^2*q13*q33^3+16*n2*q12^2*q13*q33^3+2*q12*q13^2*q33^3-2*n2*q12*q13^2*q33^3-16*q12^2*q23*q33^3+16*n2*q12^2*q23*q33^3+4*q12*q13*q23*q33^3-4*n2*q12*q13*q23*q33^3+2*q12*q23^2*q33^3-2*n2*q12*q23^2*q33^3-4*q12^2*q33^4+4*n2*q12^2*q33^4)+mbox1l(n1,-2+n2,2+n3,n4)*prf(-8*M`j'^2*q13^5-8*M`j'^2*n3*q13^5-24*M`j'^2*q13^4*q23-24*M`j'^2*n3*q13^4*q23-24*M`j'^2*q13^3*q23^2-24*M`j'^2*n3*q13^3*q23^2-8*M`j'^2*q13^2*q23^3-8*M`j'^2*n3*q13^2*q23^3+16*M`j'^2*q12^2*q13^2*q33+16*M`j'^2*n3*q12^2*q13^2*q33-8*q12^3*q13^2*q33-8*n3*q12^3*q13^2*q33+40*M`j'^2*q12*q13^3*q33+40*M`j'^2*n3*q12*q13^3*q33-20*q12^2*q13^3*q33-20*n3*q12^2*q13^3*q33-4*M`j'^2*q13^4*q33-4*M`j'^2*n3*q13^4*q33-12*q12*q13^4*q33-12*n3*q12*q13^4*q33+48*M`j'^2*q12*q13^2*q23*q33+48*M`j'^2*n3*q12*q13^2*q23*q33-20*q12^2*q13^2*q23*q33-20*n3*q12^2*q13^2*q23*q33-8*M`j'^2*q13^3*q23*q33-8*M`j'^2*n3*q13^3*q23*q33-24*q12*q13^3*q23*q33-24*n3*q12*q13^3*q23*q33+8*M`j'^2*q12*q13*q23^2*q33+8*M`j'^2*n3*q12*q13*q23^2*q33-4*M`j'^2*q13^2*q23^2*q33-4*M`j'^2*n3*q13^2*q23^2*q33-12*q12*q13^2*q23^2*q33-12*n3*q12*q13^2*q23^2*q33-8*M`j'^2*q12^3*q33^2-8*M`j'^2*n3*q12^3*q33^2-16*M`j'^2*q12^2*q13*q33^2-16*M`j'^2*n3*q12^2*q13*q33^2+4*q12^3*q13*q33^2+4*n3*q12^3*q13*q33^2+26*M`j'^2*q12*q13^2*q33^2+26*M`j'^2*n3*q12*q13^2*q33^2-10*q12^2*q13^2*q33^2-10*n3*q12^2*q13^2*q33^2-16*q12*q13^3*q33^2-16*n3*q12*q13^3*q33^2-16*M`j'^2*q12^2*q23*q33^2-16*M`j'^2*n3*q12^2*q23*q33^2+4*M`j'^2*q12*q13*q23*q33^2+4*M`j'^2*n3*q12*q13*q23*q33^2+2*q12^2*q13*q23*q33^2+2*n3*q12^2*q13*q23*q33^2-18*q12*q13^2*q23*q33^2-18*n3*q12*q13^2*q23*q33^2-6*M`j'^2*q12*q23^2*q33^2-6*M`j'^2*n3*q12*q23^2*q33^2-2*q12*q13*q23^2*q33^2-2*n3*q12*q13*q23^2*q33^2-8*M`j'^2*q12^2*q33^3-8*M`j'^2*n3*q12^2*q33^3+4*q12^3*q33^3+4*n3*q12^3*q33^3+4*M`j'^2*q12*q13*q33^3+4*M`j'^2*n3*q12*q13*q33^3+4*q12^2*q13*q33^3+4*n3*q12^2*q13*q33^3-7*q12*q13^2*q33^3-7*n3*q12*q13^2*q33^3-4*M`j'^2*q12*q23*q33^3-4*M`j'^2*n3*q12*q23*q33^3+6*q12^2*q23*q33^3+6*n3*q12^2*q23*q33^3-q12*q13*q23*q33^3-n3*q12*q13*q23*q33^3+2*q12*q23^2*q33^3+2*n3*q12*q23^2*q33^3+2*q12^2*q33^4+2*n3*q12^2*q33^4-q12*q13*q33^4-n3*q12*q13*q33^4+q12*q23*q33^4+n3*q12*q23*q33^4,8*M`j'^2*q12*q13^4-8*M`j'^2*n2*q12*q13^4+8*M`j'^2*q13^5-8*M`j'^2*n2*q13^5+32*M`j'^2*q12*q13^3*q23-32*M`j'^2*n2*q12*q13^3*q23+40*M`j'^2*q13^4*q23-40*M`j'^2*n2*q13^4*q23+48*M`j'^2*q12*q13^2*q23^2-48*M`j'^2*n2*q12*q13^2*q23^2+80*M`j'^2*q13^3*q23^2-80*M`j'^2*n2*q13^3*q23^2+32*M`j'^2*q12*q13*q23^3-32*M`j'^2*n2*q12*q13*q23^3+80*M`j'^2*q13^2*q23^3-80*M`j'^2*n2*q13^2*q23^3+8*M`j'^2*q12*q23^4-8*M`j'^2*n2*q12*q23^4+40*M`j'^2*q13*q23^4-40*M`j'^2*n2*q13*q23^4+8*M`j'^2*q23^5-8*M`j'^2*n2*q23^5-32*M`j'^2*q12^2*q13^2*q33+32*M`j'^2*n2*q12^2*q13^2*q33+8*q12^3*q13^2*q33-8*n2*q12^3*q13^2*q33-32*M`j'^2*q12*q13^3*q33+32*M`j'^2*n2*q12*q13^3*q33+16*q12^2*q13^3*q33-16*n2*q12^2*q13^3*q33+4*M`j'^2*q13^4*q33-4*M`j'^2*n2*q13^4*q33+8*q12*q13^4*q33-8*n2*q12*q13^4*q33-64*M`j'^2*q12^2*q13*q23*q33+64*M`j'^2*n2*q12^2*q13*q23*q33+16*q12^3*q13*q23*q33-16*n2*q12^3*q13*q23*q33-96*M`j'^2*q12*q13^2*q23*q33+96*M`j'^2*n2*q12*q13^2*q23*q33+48*q12^2*q13^2*q23*q33-48*n2*q12^2*q13^2*q23*q33+16*M`j'^2*q13^3*q23*q33-16*M`j'^2*n2*q13^3*q23*q33+32*q12*q13^3*q23*q33-32*n2*q12*q13^3*q23*q33-32*M`j'^2*q12^2*q23^2*q33+32*M`j'^2*n2*q12^2*q23^2*q33+8*q12^3*q23^2*q33-8*n2*q12^3*q23^2*q33-96*M`j'^2*q12*q13*q23^2*q33+96*M`j'^2*n2*q12*q13*q23^2*q33+48*q12^2*q13*q23^2*q33-48*n2*q12^2*q13*q23^2*q33+24*M`j'^2*q13^2*q23^2*q33-24*M`j'^2*n2*q13^2*q23^2*q33+48*q12*q13^2*q23^2*q33-48*n2*q12*q13^2*q23^2*q33-32*M`j'^2*q12*q23^3*q33+32*M`j'^2*n2*q12*q23^3*q33+16*q12^2*q23^3*q33-16*n2*q12^2*q23^3*q33+16*M`j'^2*q13*q23^3*q33-16*M`j'^2*n2*q13*q23^3*q33+32*q12*q13*q23^3*q33-32*n2*q12*q13*q23^3*q33+4*M`j'^2*q23^4*q33-4*M`j'^2*n2*q23^4*q33+8*q12*q23^4*q33-8*n2*q12*q23^4*q33+32*M`j'^2*q12^3*q33^2-32*M`j'^2*n2*q12^3*q33^2-16*q12^4*q33^2+16*n2*q12^4*q33^2+32*M`j'^2*q12^2*q13*q33^2-32*M`j'^2*n2*q12^2*q13*q33^2-32*q12^3*q13*q33^2+32*n2*q12^3*q13*q33^2-16*M`j'^2*q12*q13^2*q33^2+16*M`j'^2*n2*q12*q13^2*q33^2-8*q12^2*q13^2*q33^2+8*n2*q12^2*q13^2*q33^2+8*q12*q13^3*q33^2-8*n2*q12*q13^3*q33^2+32*M`j'^2*q12^2*q23*q33^2-32*M`j'^2*n2*q12^2*q23*q33^2-32*q12^3*q23*q33^2+32*n2*q12^3*q23*q33^2-32*M`j'^2*q12*q13*q23*q33^2+32*M`j'^2*n2*q12*q13*q23*q33^2-16*q12^2*q13*q23*q33^2+16*n2*q12^2*q13*q23*q33^2+24*q12*q13^2*q23*q33^2-24*n2*q12*q13^2*q23*q33^2-16*M`j'^2*q12*q23^2*q33^2+16*M`j'^2*n2*q12*q23^2*q33^2-8*q12^2*q23^2*q33^2+8*n2*q12^2*q23^2*q33^2+24*q12*q13*q23^2*q33^2-24*n2*q12*q13*q23^2*q33^2+8*q12*q23^3*q33^2-8*n2*q12*q23^3*q33^2+16*M`j'^2*q12^2*q33^3-16*M`j'^2*n2*q12^2*q33^3-16*q12^3*q33^3+16*n2*q12^3*q33^3-16*q12^2*q13*q33^3+16*n2*q12^2*q13*q33^3+2*q12*q13^2*q33^3-2*n2*q12*q13^2*q33^3-16*q12^2*q23*q33^3+16*n2*q12^2*q23*q33^3+4*q12*q13*q23*q33^3-4*n2*q12*q13*q23*q33^3+2*q12*q23^2*q33^3-2*n2*q12*q23^2*q33^3-4*q12^2*q33^4+4*n2*q12^2*q33^4);
	Identify,ifmatch->jump mbox1l(n1?{,>1},n2?pos_,n3?neg_,n4?pos_) = mbox1l(-1+n1,-1+n2,1+n3,1+n4)*prf(2*M`j'^2*n4*q12*q13^3+4*M`j'^2*n4*q12*q13^2*q23+2*M`j'^2*n4*q12*q13*q23^2-2*M`j'^2*n4*q12^2*q13*q33+M`j'^2*n4*q12*q13^2*q33-2*M`j'^2*n4*q12^2*q23*q33-M`j'^2*n4*q12*q23^2*q33,-2*M`j'^2*q13^4+2*M`j'^2*n1*q13^4-8*M`j'^2*q13^3*q23+8*M`j'^2*n1*q13^3*q23-12*M`j'^2*q13^2*q23^2+12*M`j'^2*n1*q13^2*q23^2-8*M`j'^2*q13*q23^3+8*M`j'^2*n1*q13*q23^3-2*M`j'^2*q23^4+2*M`j'^2*n1*q23^4+8*M`j'^2*q12*q13^2*q33-8*M`j'^2*n1*q12*q13^2*q33-2*q12^2*q13^2*q33+2*n1*q12^2*q13^2*q33-2*q12*q13^3*q33+2*n1*q12*q13^3*q33+16*M`j'^2*q12*q13*q23*q33-16*M`j'^2*n1*q12*q13*q23*q33-4*q12^2*q13*q23*q33+4*n1*q12^2*q13*q23*q33-6*q12*q13^2*q23*q33+6*n1*q12*q13^2*q23*q33+8*M`j'^2*q12*q23^2*q33-8*M`j'^2*n1*q12*q23^2*q33-2*q12^2*q23^2*q33+2*n1*q12^2*q23^2*q33-6*q12*q13*q23^2*q33+6*n1*q12*q13*q23^2*q33-2*q12*q23^3*q33+2*n1*q12*q23^3*q33-8*M`j'^2*q12^2*q33^2+8*M`j'^2*n1*q12^2*q33^2+4*q12^3*q33^2-4*n1*q12^3*q33^2+4*q12^2*q13*q33^2-4*n1*q12^2*q13*q33^2-q12*q13^2*q33^2+n1*q12*q13^2*q33^2+4*q12^2*q23*q33^2-4*n1*q12^2*q23*q33^2-2*q12*q13*q23*q33^2+2*n1*q12*q13*q23*q33^2-q12*q23^2*q33^2+n1*q12*q23^2*q33^2+2*q12^2*q33^3-2*n1*q12^2*q33^3)+mbox1l(n1,n2,1+n3,-1+n4)*prf(4*M`j'^2*q12*q13^3+6*M`j'^2*q12*q13^2*q23-2*M`j'^2*q12*q23^3-6*M`j'^2*q12^2*q13*q33+2*q12^3*q13*q33+M`j'^2*q12*q13^2*q33+2*q12^2*q13^2*q33+2*M`j'^2*q12^2*q23*q33-2*q12^3*q23*q33-M`j'^2*q12*q23^2*q33-2*q12^2*q23^2*q33+q12^2*q13*q33^2-q12^2*q23*q33^2,2*M`j'^2*q13^4+8*M`j'^2*q13^3*q23+12*M`j'^2*q13^2*q23^2+8*M`j'^2*q13*q23^3+2*M`j'^2*q23^4-8*M`j'^2*q12*q13^2*q33+2*q12^2*q13^2*q33+2*q12*q13^3*q33-16*M`j'^2*q12*q13*q23*q33+4*q12^2*q13*q23*q33+6*q12*q13^2*q23*q33-8*M`j'^2*q12*q23^2*q33+2*q12^2*q23^2*q33+6*q12*q13*q23^2*q33+2*q12*q23^3*q33+8*M`j'^2*q12^2*q33^2-4*q12^3*q33^2-4*q12^2*q13*q33^2+q12*q13^2*q33^2-4*q12^2*q23*q33^2+2*q12*q13*q23*q33^2+q12*q23^2*q33^2-2*q12^2*q33^3)+mbox1l(-1+n1,1+n2,1+n3,-1+n4)*prf(8*M`j'^2*n2*q12^2*q13^2-4*n2*q12^3*q13^2+2*M`j'^2*n2*q12*q13^3-4*n2*q12^2*q13^3+8*M`j'^2*n2*q12^2*q13*q23-4*n2*q12^3*q13*q23+4*M`j'^2*n2*q12*q13^2*q23-8*n2*q12^2*q13^2*q23+2*M`j'^2*n2*q12*q13*q23^2-4*n2*q12^2*q13*q23^2-8*M`j'^2*n2*q12^3*q33+4*n2*q12^4*q33+2*M`j'^2*n2*q12^2*q13*q33+2*n2*q12^3*q13*q33+M`j'^2*n2*q12*q13^2*q33-4*n2*q12^2*q13^2*q33-6*M`j'^2*n2*q12^2*q23*q33+6*n2*q12^3*q23*q33-2*n2*q12^2*q13*q23*q33-M`j'^2*n2*q12*q23^2*q33+2*n2*q12^2*q23^2*q33+2*n2*q12^3*q33^2-n2*q12^2*q13*q33^2+n2*q12^2*q23*q33^2,-2*M`j'^2*q13^4+2*M`j'^2*n1*q13^4-8*M`j'^2*q13^3*q23+8*M`j'^2*n1*q13^3*q23-12*M`j'^2*q13^2*q23^2+12*M`j'^2*n1*q13^2*q23^2-8*M`j'^2*q13*q23^3+8*M`j'^2*n1*q13*q23^3-2*M`j'^2*q23^4+2*M`j'^2*n1*q23^4+8*M`j'^2*q12*q13^2*q33-8*M`j'^2*n1*q12*q13^2*q33-2*q12^2*q13^2*q33+2*n1*q12^2*q13^2*q33-2*q12*q13^3*q33+2*n1*q12*q13^3*q33+16*M`j'^2*q12*q13*q23*q33-16*M`j'^2*n1*q12*q13*q23*q33-4*q12^2*q13*q23*q33+4*n1*q12^2*q13*q23*q33-6*q12*q13^2*q23*q33+6*n1*q12*q13^2*q23*q33+8*M`j'^2*q12*q23^2*q33-8*M`j'^2*n1*q12*q23^2*q33-2*q12^2*q23^2*q33+2*n1*q12^2*q23^2*q33-6*q12*q13*q23^2*q33+6*n1*q12*q13*q23^2*q33-2*q12*q23^3*q33+2*n1*q12*q23^3*q33-8*M`j'^2*q12^2*q33^2+8*M`j'^2*n1*q12^2*q33^2+4*q12^3*q33^2-4*n1*q12^3*q33^2+4*q12^2*q13*q33^2-4*n1*q12^2*q13*q33^2-q12*q13^2*q33^2+n1*q12*q13^2*q33^2+4*q12^2*q23*q33^2-4*n1*q12^2*q23*q33^2-2*q12*q13*q23*q33^2+2*n1*q12*q13*q23*q33^2-q12*q23^2*q33^2+n1*q12*q23^2*q33^2+2*q12^2*q33^3-2*n1*q12^2*q33^3)+mbox1l(-1+n1,n2,2+n3,-1+n4)*prf(4*M`j'^2*q12^2*q13^2+4*M`j'^2*n3*q12^2*q13^2-4*q12^3*q13^2-4*n3*q12^3*q13^2+4*M`j'^2*q12*q13^3+4*M`j'^2*n3*q12*q13^3-4*q12^2*q13^3-4*n3*q12^2*q13^3-4*q12^3*q13*q23-4*n3*q12^3*q13*q23+4*M`j'^2*q12*q13^2*q23+4*M`j'^2*n3*q12*q13^2*q23-8*q12^2*q13^2*q23-8*n3*q12^2*q13^2*q23-4*M`j'^2*q12^2*q23^2-4*M`j'^2*n3*q12^2*q23^2-4*M`j'^2*q12*q13*q23^2-4*M`j'^2*n3*q12*q13*q23^2-4*q12^2*q13*q23^2-4*n3*q12^2*q13*q23^2-4*M`j'^2*q12*q23^3-4*M`j'^2*n3*q12*q23^3-2*q12^3*q13*q33-2*n3*q12^3*q13*q33+2*M`j'^2*q12*q13^2*q33+2*M`j'^2*n3*q12*q13^2*q33-4*q12^2*q13^2*q33-4*n3*q12^2*q13^2*q33-2*q12^3*q23*q33-2*n3*q12^3*q23*q33-6*q12^2*q13*q23*q33-6*n3*q12^2*q13*q23*q33-2*M`j'^2*q12*q23^2*q33-2*M`j'^2*n3*q12*q23^2*q33-2*q12^2*q23^2*q33-2*n3*q12^2*q23^2*q33-q12^2*q13*q33^2-n3*q12^2*q13*q33^2-q12^2*q23*q33^2-n3*q12^2*q23*q33^2,-4*M`j'^2*q13^4+4*M`j'^2*n1*q13^4-16*M`j'^2*q13^3*q23+16*M`j'^2*n1*q13^3*q23-24*M`j'^2*q13^2*q23^2+24*M`j'^2*n1*q13^2*q23^2-16*M`j'^2*q13*q23^3+16*M`j'^2*n1*q13*q23^3-4*M`j'^2*q23^4+4*M`j'^2*n1*q23^4+16*M`j'^2*q12*q13^2*q33-16*M`j'^2*n1*q12*q13^2*q33-4*q12^2*q13^2*q33+4*n1*q12^2*q13^2*q33-4*q12*q13^3*q33+4*n1*q12*q13^3*q33+32*M`j'^2*q12*q13*q23*q33-32*M`j'^2*n1*q12*q13*q23*q33-8*q12^2*q13*q23*q33+8*n1*q12^2*q13*q23*q33-12*q12*q13^2*q23*q33+12*n1*q12*q13^2*q23*q33+16*M`j'^2*q12*q23^2*q33-16*M`j'^2*n1*q12*q23^2*q33-4*q12^2*q23^2*q33+4*n1*q12^2*q23^2*q33-12*q12*q13*q23^2*q33+12*n1*q12*q13*q23^2*q33-4*q12*q23^3*q33+4*n1*q12*q23^3*q33-16*M`j'^2*q12^2*q33^2+16*M`j'^2*n1*q12^2*q33^2+8*q12^3*q33^2-8*n1*q12^3*q33^2+8*q12^2*q13*q33^2-8*n1*q12^2*q13*q33^2-2*q12*q13^2*q33^2+2*n1*q12*q13^2*q33^2+8*q12^2*q23*q33^2-8*n1*q12^2*q23*q33^2-4*q12*q13*q23*q33^2+4*n1*q12*q13*q23*q33^2-2*q12*q23^2*q33^2+2*n1*q12*q23^2*q33^2+4*q12^2*q33^3-4*n1*q12^2*q33^3)+mbox1l(n1,-1+n2,1+n3,n4)*prf(4*M`j'^2*q12*q13^3+4*M`j'^2*q13^4+8*M`j'^2*q12*q13^2*q23+12*M`j'^2*q13^3*q23+4*M`j'^2*q12*q13*q23^2+12*M`j'^2*q13^2*q23^2+4*M`j'^2*q13*q23^3-4*M`j'^2*q12^2*q13*q33-2*M`j'^2*q12*q13^2*q33-4*M`j'^2*q12^2*q23*q33-8*M`j'^2*q12*q13*q23*q33-6*M`j'^2*q12*q23^2*q33+4*M`j'^2*q12*q13*q33^2-2*q12^2*q13*q33^2-2*q12*q13^2*q33^2-4*M`j'^2*q12*q23*q33^2+2*q12^2*q23*q33^2+2*q12*q23^2*q33^2-q12*q13*q33^3+q12*q23*q33^3,4*M`j'^2*q13^4+16*M`j'^2*q13^3*q23+24*M`j'^2*q13^2*q23^2+16*M`j'^2*q13*q23^3+4*M`j'^2*q23^4-16*M`j'^2*q12*q13^2*q33+4*q12^2*q13^2*q33+4*q12*q13^3*q33-32*M`j'^2*q12*q13*q23*q33+8*q12^2*q13*q23*q33+12*q12*q13^2*q23*q33-16*M`j'^2*q12*q23^2*q33+4*q12^2*q23^2*q33+12*q12*q13*q23^2*q33+4*q12*q23^3*q33+16*M`j'^2*q12^2*q33^2-8*q12^3*q33^2-8*q12^2*q13*q33^2+2*q12*q13^2*q33^2-8*q12^2*q23*q33^2+4*q12*q13*q23*q33^2+2*q12*q23^2*q33^2-4*q12^2*q33^3)+mbox1l(-2+n1,1+n2,1+n3,n4)*prf(-16*M`j'^2*n2*q12^2*q13^2+8*n2*q12^3*q13^2-16*M`j'^2*n2*q12*q13^3+16*n2*q12^2*q13^3+8*n2*q12*q13^4-16*M`j'^2*n2*q12^2*q13*q23+8*n2*q12^3*q13*q23-32*M`j'^2*n2*q12*q13^2*q23+32*n2*q12^2*q13^2*q23+24*n2*q12*q13^3*q23-16*M`j'^2*n2*q12*q13*q23^2+16*n2*q12^2*q13*q23^2+24*n2*q12*q13^2*q23^2+8*n2*q12*q13*q23^3+16*M`j'^2*n2*q12^3*q33-8*n2*q12^4*q33+8*M`j'^2*n2*q12^2*q13*q33-12*n2*q12^3*q13*q33-16*M`j'^2*n2*q12*q13^2*q33+8*n2*q12^2*q13^2*q33+12*n2*q12*q13^3*q33+24*M`j'^2*n2*q12^2*q23*q33-20*n2*q12^3*q23*q33-8*M`j'^2*n2*q12*q13*q23*q33-8*n2*q12^2*q13*q23*q33+20*n2*q12*q13^2*q23*q33+8*M`j'^2*n2*q12*q23^2*q33-16*n2*q12^2*q23^2*q33+4*n2*q12*q13*q23^2*q33-4*n2*q12*q23^3*q33+8*M`j'^2*n2*q12^2*q33^2-8*n2*q12^3*q33^2-4*M`j'^2*n2*q12*q13*q33^2-4*n2*q12^2*q13*q33^2+6*n2*q12*q13^2*q33^2+4*M`j'^2*n2*q12*q23*q33^2-12*n2*q12^2*q23*q33^2+2*n2*q12*q13*q23*q33^2-4*n2*q12*q23^2*q33^2-2*n2*q12^2*q33^3+n2*q12*q13*q33^3-n2*q12*q23*q33^3,-4*M`j'^2*q13^4+4*M`j'^2*n1*q13^4-16*M`j'^2*q13^3*q23+16*M`j'^2*n1*q13^3*q23-24*M`j'^2*q13^2*q23^2+24*M`j'^2*n1*q13^2*q23^2-16*M`j'^2*q13*q23^3+16*M`j'^2*n1*q13*q23^3-4*M`j'^2*q23^4+4*M`j'^2*n1*q23^4+16*M`j'^2*q12*q13^2*q33-16*M`j'^2*n1*q12*q13^2*q33-4*q12^2*q13^2*q33+4*n1*q12^2*q13^2*q33-4*q12*q13^3*q33+4*n1*q12*q13^3*q33+32*M`j'^2*q12*q13*q23*q33-32*M`j'^2*n1*q12*q13*q23*q33-8*q12^2*q13*q23*q33+8*n1*q12^2*q13*q23*q33-12*q12*q13^2*q23*q33+12*n1*q12*q13^2*q23*q33+16*M`j'^2*q12*q23^2*q33-16*M`j'^2*n1*q12*q23^2*q33-4*q12^2*q23^2*q33+4*n1*q12^2*q23^2*q33-12*q12*q13*q23^2*q33+12*n1*q12*q13*q23^2*q33-4*q12*q23^3*q33+4*n1*q12*q23^3*q33-16*M`j'^2*q12^2*q33^2+16*M`j'^2*n1*q12^2*q33^2+8*q12^3*q33^2-8*n1*q12^3*q33^2+8*q12^2*q13*q33^2-8*n1*q12^2*q13*q33^2-2*q12*q13^2*q33^2+2*n1*q12*q13^2*q33^2+8*q12^2*q23*q33^2-8*n1*q12^2*q23*q33^2-4*q12*q13*q23*q33^2+4*n1*q12*q13*q23*q33^2-2*q12*q23^2*q33^2+2*n1*q12*q23^2*q33^2+4*q12^2*q33^3-4*n1*q12^2*q33^3)+mbox1l(-1+n1,n2,1+n3,n4)*(tmpprf(ep,1)*prf(8*q12^2*q13^3+8*q12*q13^4+16*q12^2*q13^2*q23+24*q12*q13^3*q23+8*q12^2*q13*q23^2+24*q12*q13^2*q23^2+8*q12*q13*q23^3-8*q12^3*q13*q33-4*q12^2*q13^2*q33+8*q12*q13^3*q33-8*q12^3*q23*q33-16*q12^2*q13*q23*q33+12*q12*q13^2*q23*q33-12*q12^2*q23^2*q33-4*q12*q23^3*q33-4*q12^2*q13*q33^2+2*q12*q13^2*q33^2-4*q12^2*q23*q33^2-2*q12*q23^2*q33^2,-4*M`j'^2*q13^4+4*M`j'^2*n1*q13^4-16*M`j'^2*q13^3*q23+16*M`j'^2*n1*q13^3*q23-24*M`j'^2*q13^2*q23^2+24*M`j'^2*n1*q13^2*q23^2-16*M`j'^2*q13*q23^3+16*M`j'^2*n1*q13*q23^3-4*M`j'^2*q23^4+4*M`j'^2*n1*q23^4+16*M`j'^2*q12*q13^2*q33-16*M`j'^2*n1*q12*q13^2*q33-4*q12^2*q13^2*q33+4*n1*q12^2*q13^2*q33-4*q12*q13^3*q33+4*n1*q12*q13^3*q33+32*M`j'^2*q12*q13*q23*q33-32*M`j'^2*n1*q12*q13*q23*q33-8*q12^2*q13*q23*q33+8*n1*q12^2*q13*q23*q33-12*q12*q13^2*q23*q33+12*n1*q12*q13^2*q23*q33+16*M`j'^2*q12*q23^2*q33-16*M`j'^2*n1*q12*q23^2*q33-4*q12^2*q23^2*q33+4*n1*q12^2*q23^2*q33-12*q12*q13*q23^2*q33+12*n1*q12*q13*q23^2*q33-4*q12*q23^3*q33+4*n1*q12*q23^3*q33-16*M`j'^2*q12^2*q33^2+16*M`j'^2*n1*q12^2*q33^2+8*q12^3*q33^2-8*n1*q12^3*q33^2+8*q12^2*q13*q33^2-8*n1*q12^2*q13*q33^2-2*q12*q13^2*q33^2+2*n1*q12*q13^2*q33^2+8*q12^2*q23*q33^2-8*n1*q12^2*q23*q33^2-4*q12*q13*q23*q33^2+4*n1*q12*q13*q23*q33^2-2*q12*q23^2*q33^2+2*n1*q12*q23^2*q33^2+4*q12^2*q33^3-4*n1*q12^2*q33^3)+prf(16*M`j'^2*q12*q13^3-12*M`j'^2*n1*q12*q13^3+12*M`j'^2*n2*q12*q13^3+4*M`j'^2*n3*q12*q13^3-4*M`j'^2*n4*q12*q13^3-20*q12^2*q13^3+8*n1*q12^2*q13^3+4*n3*q12^2*q13^3+8*n4*q12^2*q13^3-20*q12*q13^4+8*n1*q12*q13^4+4*n3*q12*q13^4+8*n4*q12*q13^4+24*M`j'^2*q12*q13^2*q23-20*M`j'^2*n1*q12*q13^2*q23+24*M`j'^2*n2*q12*q13^2*q23+4*M`j'^2*n3*q12*q13^2*q23-8*M`j'^2*n4*q12*q13^2*q23-40*q12^2*q13^2*q23+16*n1*q12^2*q13^2*q23+8*n3*q12^2*q13^2*q23+16*n4*q12^2*q13^2*q23-8*M`j'^2*q13^3*q23+4*M`j'^2*n1*q13^3*q23-4*M`j'^2*n3*q13^3*q23-60*q12*q13^3*q23+24*n1*q12*q13^3*q23+12*n3*q12*q13^3*q23+24*n4*q12*q13^3*q23-4*M`j'^2*n1*q12*q13*q23^2+12*M`j'^2*n2*q12*q13*q23^2-4*M`j'^2*n3*q12*q13*q23^2-4*M`j'^2*n4*q12*q13*q23^2-20*q12^2*q13*q23^2+8*n1*q12^2*q13*q23^2+4*n3*q12^2*q13*q23^2+8*n4*q12^2*q13*q23^2-24*M`j'^2*q13^2*q23^2+12*M`j'^2*n1*q13^2*q23^2-12*M`j'^2*n3*q13^2*q23^2-60*q12*q13^2*q23^2+24*n1*q12*q13^2*q23^2+12*n3*q12*q13^2*q23^2+24*n4*q12*q13^2*q23^2-8*M`j'^2*q12*q23^3+4*M`j'^2*n1*q12*q23^3-4*M`j'^2*n3*q12*q23^3-24*M`j'^2*q13*q23^3+12*M`j'^2*n1*q13*q23^3-12*M`j'^2*n3*q13*q23^3-20*q12*q13*q23^3+8*n1*q12*q13*q23^3+4*n3*q12*q13*q23^3+8*n4*q12*q13*q23^3-8*M`j'^2*q23^4+4*M`j'^2*n1*q23^4-4*M`j'^2*n3*q23^4-24*M`j'^2*q12^2*q13*q33+16*M`j'^2*n1*q12^2*q13*q33-12*M`j'^2*n2*q12^2*q13*q33-8*M`j'^2*n3*q12^2*q13*q33+4*M`j'^2*n4*q12^2*q13*q33+28*q12^3*q13*q33-12*n1*q12^3*q13*q33-8*n4*q12^3*q13*q33+20*M`j'^2*q12*q13^2*q33-16*M`j'^2*n1*q12*q13^2*q33+14*M`j'^2*n2*q12*q13^2*q33+4*M`j'^2*n3*q12*q13^2*q33-2*M`j'^2*n4*q12*q13^2*q33+14*q12^2*q13^2*q33-4*n1*q12^2*q13^2*q33-4*n2*q12^2*q13^2*q33+2*n3*q12^2*q13^2*q33-4*n4*q12^2*q13^2*q33-24*q12*q13^3*q33+12*n1*q12*q13^3*q33-4*n2*q12*q13^3*q33+4*n3*q12*q13^3*q33+8*n4*q12*q13^3*q33+8*M`j'^2*q12^2*q23*q33-12*M`j'^2*n2*q12^2*q23*q33+8*M`j'^2*n3*q12^2*q23*q33+4*M`j'^2*n4*q12^2*q23*q33+12*q12^3*q23*q33-4*n1*q12^3*q23*q33-8*n3*q12^3*q23*q33-8*n4*q12^3*q23*q33+40*M`j'^2*q12*q13*q23*q33-24*M`j'^2*n1*q12*q13*q23*q33+8*M`j'^2*n2*q12*q13*q23*q33+16*M`j'^2*n3*q12*q13*q23*q33+28*q12^2*q13*q23*q33-8*n1*q12^2*q13*q23*q33-4*n2*q12^2*q13*q23*q33-12*n3*q12^2*q13*q23*q33-16*n4*q12^2*q13*q23*q33-46*q12*q13^2*q23*q33+24*n1*q12*q13^2*q23*q33-8*n2*q12*q13^2*q23*q33+2*n3*q12*q13^2*q23*q33+12*n4*q12*q13^2*q23*q33+20*M`j'^2*q12*q23^2*q33-8*M`j'^2*n1*q12*q23^2*q33-6*M`j'^2*n2*q12*q23^2*q33+12*M`j'^2*n3*q12*q23^2*q33+2*M`j'^2*n4*q12*q23^2*q33+14*q12^2*q23^2*q33-4*n1*q12^2*q23^2*q33-14*n3*q12^2*q23^2*q33-12*n4*q12^2*q23^2*q33-20*q12*q13*q23^2*q33+12*n1*q12*q13*q23^2*q33-4*n2*q12*q13*q23^2*q33-8*n3*q12*q13*q23^2*q33+2*q12*q23^3*q33-6*n3*q12*q23^3*q33-4*n4*q12*q23^3*q33-24*M`j'^2*q12^2*q33^2+16*M`j'^2*n1*q12^2*q33^2-8*M`j'^2*n2*q12^2*q33^2-8*M`j'^2*n3*q12^2*q33^2+12*q12^3*q33^2-8*n1*q12^3*q33^2+4*n2*q12^3*q33^2+4*n3*q12^3*q33^2+4*M`j'^2*q12*q13*q33^2-4*M`j'^2*n1*q12*q13*q33^2+4*M`j'^2*n2*q12*q13*q33^2+24*q12^2*q13*q33^2-12*n1*q12^2*q13*q33^2+2*n2*q12^2*q13*q33^2+4*n3*q12^2*q13*q33^2-4*n4*q12^2*q13*q33^2-9*q12*q13^2*q33^2+6*n1*q12*q13^2*q33^2-4*n2*q12*q13^2*q33^2+n3*q12*q13^2*q33^2+2*n4*q12*q13^2*q33^2-4*M`j'^2*q12*q23*q33^2+4*M`j'^2*n1*q12*q23*q33^2-4*M`j'^2*n2*q12*q23*q33^2+20*q12^2*q23*q33^2-12*n1*q12^2*q23*q33^2+6*n2*q12^2*q23*q33^2-4*n4*q12^2*q23*q33^2-6*q12*q13*q23*q33^2+4*n1*q12*q13*q23*q33^2-2*n2*q12*q13*q23*q33^2-2*n3*q12*q13*q23*q33^2+3*q12*q23^2*q33^2-2*n1*q12*q23^2*q33^2+2*n2*q12*q23^2*q33^2-3*n3*q12*q23^2*q33^2-2*n4*q12*q23^2*q33^2+6*q12^2*q33^3-4*n1*q12^2*q33^3+2*n2*q12^2*q33^3+2*n3*q12^2*q33^3-q12*q13*q33^3+n1*q12*q13*q33^3-n2*q12*q13*q33^3+q12*q23*q33^3-n1*q12*q23*q33^3+n2*q12*q23*q33^3,-4*M`j'^2*q13^4+4*M`j'^2*n1*q13^4-16*M`j'^2*q13^3*q23+16*M`j'^2*n1*q13^3*q23-24*M`j'^2*q13^2*q23^2+24*M`j'^2*n1*q13^2*q23^2-16*M`j'^2*q13*q23^3+16*M`j'^2*n1*q13*q23^3-4*M`j'^2*q23^4+4*M`j'^2*n1*q23^4+16*M`j'^2*q12*q13^2*q33-16*M`j'^2*n1*q12*q13^2*q33-4*q12^2*q13^2*q33+4*n1*q12^2*q13^2*q33-4*q12*q13^3*q33+4*n1*q12*q13^3*q33+32*M`j'^2*q12*q13*q23*q33-32*M`j'^2*n1*q12*q13*q23*q33-8*q12^2*q13*q23*q33+8*n1*q12^2*q13*q23*q33-12*q12*q13^2*q23*q33+12*n1*q12*q13^2*q23*q33+16*M`j'^2*q12*q23^2*q33-16*M`j'^2*n1*q12*q23^2*q33-4*q12^2*q23^2*q33+4*n1*q12^2*q23^2*q33-12*q12*q13*q23^2*q33+12*n1*q12*q13*q23^2*q33-4*q12*q23^3*q33+4*n1*q12*q23^3*q33-16*M`j'^2*q12^2*q33^2+16*M`j'^2*n1*q12^2*q33^2+8*q12^3*q33^2-8*n1*q12^3*q33^2+8*q12^2*q13*q33^2-8*n1*q12^2*q13*q33^2-2*q12*q13^2*q33^2+2*n1*q12*q13^2*q33^2+8*q12^2*q23*q33^2-8*n1*q12^2*q23*q33^2-4*q12*q13*q23*q33^2+4*n1*q12*q13*q23*q33^2-2*q12*q23^2*q33^2+2*n1*q12*q23^2*q33^2+4*q12^2*q33^3-4*n1*q12^2*q33^3))+mbox1l(-2+n1,n2,2+n3,n4)*prf(-4*M`j'^2*q12^2*q13^2-4*M`j'^2*n3*q12^2*q13^2+4*q12^3*q13^2+4*n3*q12^3*q13^2-16*M`j'^2*q12*q13^3-16*M`j'^2*n3*q12*q13^3+12*q12^2*q13^3+12*n3*q12^2*q13^3+8*q12*q13^4+8*n3*q12*q13^4+4*q12^3*q13*q23+4*n3*q12^3*q13*q23-16*M`j'^2*q12*q13^2*q23-16*M`j'^2*n3*q12*q13^2*q23+20*q12^2*q13^2*q23+20*n3*q12^2*q13^2*q23+20*q12*q13^3*q23+20*n3*q12*q13^3*q23+4*M`j'^2*q12^2*q23^2+4*M`j'^2*n3*q12^2*q23^2+8*M`j'^2*q12*q13*q23^2+8*M`j'^2*n3*q12*q13*q23^2+8*q12^2*q13*q23^2+8*n3*q12^2*q13*q23^2+4*M`j'^2*q13^2*q23^2+4*M`j'^2*n3*q13^2*q23^2+16*q12*q13^2*q23^2+16*n3*q12*q13^2*q23^2+8*M`j'^2*q12*q23^3+8*M`j'^2*n3*q12*q23^3+8*M`j'^2*q13*q23^3+8*M`j'^2*n3*q13*q23^3+4*q12*q13*q23^3+4*n3*q12*q13*q23^3+4*M`j'^2*q23^4+4*M`j'^2*n3*q23^4+12*M`j'^2*q12^2*q13*q33+12*M`j'^2*n3*q12^2*q13*q33-6*q12^3*q13*q33-6*n3*q12^3*q13*q33-16*M`j'^2*q12*q13^2*q33-16*M`j'^2*n3*q12*q13^2*q33+4*q12^2*q13^2*q33+4*n3*q12^2*q13^2*q33+12*q12*q13^3*q33+12*n3*q12*q13^3*q33-4*M`j'^2*q12^2*q23*q33-4*M`j'^2*n3*q12^2*q23*q33+2*q12^3*q23*q33+2*n3*q12^3*q23*q33-4*M`j'^2*q12*q13*q23*q33-4*M`j'^2*n3*q12*q13*q23*q33+16*q12*q13^2*q23*q33+16*n3*q12*q13^2*q23*q33-4*M`j'^2*q12*q23^2*q33-4*M`j'^2*n3*q12*q23^2*q33+4*q12^2*q23^2*q33+4*n3*q12^2*q23^2*q33+6*q12*q13*q23^2*q33+6*n3*q12*q13*q23^2*q33+2*q12*q23^3*q33+2*n3*q12*q23^3*q33+8*M`j'^2*q12^2*q33^2+8*M`j'^2*n3*q12^2*q33^2-4*q12^3*q33^2-4*n3*q12^3*q33^2-4*M`j'^2*q12*q13*q33^2-4*M`j'^2*n3*q12*q13*q33^2-5*q12^2*q13*q33^2-5*n3*q12^2*q13*q33^2+6*q12*q13^2*q33^2+6*n3*q12*q13^2*q33^2+4*M`j'^2*q12*q23*q33^2+4*M`j'^2*n3*q12*q23*q33^2-5*q12^2*q23*q33^2-5*n3*q12^2*q23*q33^2+q12*q13*q23*q33^2+n3*q12*q13*q23*q33^2-q12*q23^2*q33^2-n3*q12*q23^2*q33^2-2*q12^2*q33^3-2*n3*q12^2*q33^3+q12*q13*q33^3+n3*q12*q13*q33^3-q12*q23*q33^3-n3*q12*q23*q33^3,-4*M`j'^2*q13^4+4*M`j'^2*n1*q13^4-16*M`j'^2*q13^3*q23+16*M`j'^2*n1*q13^3*q23-24*M`j'^2*q13^2*q23^2+24*M`j'^2*n1*q13^2*q23^2-16*M`j'^2*q13*q23^3+16*M`j'^2*n1*q13*q23^3-4*M`j'^2*q23^4+4*M`j'^2*n1*q23^4+16*M`j'^2*q12*q13^2*q33-16*M`j'^2*n1*q12*q13^2*q33-4*q12^2*q13^2*q33+4*n1*q12^2*q13^2*q33-4*q12*q13^3*q33+4*n1*q12*q13^3*q33+32*M`j'^2*q12*q13*q23*q33-32*M`j'^2*n1*q12*q13*q23*q33-8*q12^2*q13*q23*q33+8*n1*q12^2*q13*q23*q33-12*q12*q13^2*q23*q33+12*n1*q12*q13^2*q23*q33+16*M`j'^2*q12*q23^2*q33-16*M`j'^2*n1*q12*q23^2*q33-4*q12^2*q23^2*q33+4*n1*q12^2*q23^2*q33-12*q12*q13*q23^2*q33+12*n1*q12*q13*q23^2*q33-4*q12*q23^3*q33+4*n1*q12*q23^3*q33-16*M`j'^2*q12^2*q33^2+16*M`j'^2*n1*q12^2*q33^2+8*q12^3*q33^2-8*n1*q12^3*q33^2+8*q12^2*q13*q33^2-8*n1*q12^2*q13*q33^2-2*q12*q13^2*q33^2+2*n1*q12*q13^2*q33^2+8*q12^2*q23*q33^2-8*n1*q12^2*q23*q33^2-4*q12*q13*q23*q33^2+4*n1*q12*q13*q23*q33^2-2*q12*q23^2*q33^2+2*n1*q12*q23^2*q33^2+4*q12^2*q33^3-4*n1*q12^2*q33^3)+mbox1l(-1+n1,-1+n2,2+n3,n4)*prf(8*M`j'^2*q12*q13^3+8*M`j'^2*n3*q12*q13^3-4*q12^2*q13^3-4*n3*q12^2*q13^3-4*q12*q13^4-4*n3*q12*q13^4+8*M`j'^2*q12*q13^2*q23+8*M`j'^2*n3*q12*q13^2*q23-4*q12^2*q13^2*q23-4*n3*q12^2*q13^2*q23+4*M`j'^2*q13^3*q23+4*M`j'^2*n3*q13^3*q23-8*q12*q13^3*q23-8*n3*q12*q13^3*q23+8*M`j'^2*q13^2*q23^2+8*M`j'^2*n3*q13^2*q23^2-4*q12*q13^2*q23^2-4*n3*q12*q13^2*q23^2+4*M`j'^2*q13*q23^3+4*M`j'^2*n3*q13*q23^3-4*M`j'^2*q12^2*q13*q33-4*M`j'^2*n3*q12^2*q13*q33+10*M`j'^2*q12*q13^2*q33+10*M`j'^2*n3*q12*q13^2*q33-6*q12^2*q13^2*q33-6*n3*q12^2*q13^2*q33-8*q12*q13^3*q33-8*n3*q12*q13^3*q33-4*M`j'^2*q12^2*q23*q33-4*M`j'^2*n3*q12^2*q23*q33-12*M`j'^2*q12*q13*q23*q33-12*M`j'^2*n3*q12*q13*q23*q33+2*q12^2*q13*q23*q33+2*n3*q12^2*q13*q23*q33-6*q12*q13^2*q23*q33-6*n3*q12*q13^2*q23*q33-6*M`j'^2*q12*q23^2*q33-6*M`j'^2*n3*q12*q23^2*q33+2*q12*q13*q23^2*q33+2*n3*q12*q13*q23^2*q33+4*M`j'^2*q12*q13*q33^2+4*M`j'^2*n3*q12*q13*q33^2-2*q12^2*q13*q33^2-2*n3*q12^2*q13*q33^2-5*q12*q13^2*q33^2-5*n3*q12*q13^2*q33^2-4*M`j'^2*q12*q23*q33^2-4*M`j'^2*n3*q12*q23*q33^2+2*q12^2*q23*q33^2+2*n3*q12^2*q23*q33^2+q12*q13*q23*q33^2+n3*q12*q13*q23*q33^2+2*q12*q23^2*q33^2+2*n3*q12*q23^2*q33^2-q12*q13*q33^3-n3*q12*q13*q33^3+q12*q23*q33^3+n3*q12*q23*q33^3,-4*M`j'^2*q13^4+4*M`j'^2*n1*q13^4-16*M`j'^2*q13^3*q23+16*M`j'^2*n1*q13^3*q23-24*M`j'^2*q13^2*q23^2+24*M`j'^2*n1*q13^2*q23^2-16*M`j'^2*q13*q23^3+16*M`j'^2*n1*q13*q23^3-4*M`j'^2*q23^4+4*M`j'^2*n1*q23^4+16*M`j'^2*q12*q13^2*q33-16*M`j'^2*n1*q12*q13^2*q33-4*q12^2*q13^2*q33+4*n1*q12^2*q13^2*q33-4*q12*q13^3*q33+4*n1*q12*q13^3*q33+32*M`j'^2*q12*q13*q23*q33-32*M`j'^2*n1*q12*q13*q23*q33-8*q12^2*q13*q23*q33+8*n1*q12^2*q13*q23*q33-12*q12*q13^2*q23*q33+12*n1*q12*q13^2*q23*q33+16*M`j'^2*q12*q23^2*q33-16*M`j'^2*n1*q12*q23^2*q33-4*q12^2*q23^2*q33+4*n1*q12^2*q23^2*q33-12*q12*q13*q23^2*q33+12*n1*q12*q13*q23^2*q33-4*q12*q23^3*q33+4*n1*q12*q23^3*q33-16*M`j'^2*q12^2*q33^2+16*M`j'^2*n1*q12^2*q33^2+8*q12^3*q33^2-8*n1*q12^3*q33^2+8*q12^2*q13*q33^2-8*n1*q12^2*q13*q33^2-2*q12*q13^2*q33^2+2*n1*q12*q13^2*q33^2+8*q12^2*q23*q33^2-8*n1*q12^2*q23*q33^2-4*q12*q13*q23*q33^2+4*n1*q12*q13*q23*q33^2-2*q12*q23^2*q33^2+2*n1*q12*q23^2*q33^2+4*q12^2*q33^3-4*n1*q12^2*q33^3)+mbox1l(-1+n1,n2,2+n3,n4)*prf(-8*q12^3*q13^3-8*n3*q12^3*q13^3-8*q12^2*q13^4-8*n3*q12^2*q13^4-16*M`j'^2*q12^2*q13^2*q23-16*M`j'^2*n3*q12^2*q13^2*q23-8*q12^3*q13^2*q23-8*n3*q12^3*q13^2*q23-16*M`j'^2*q12*q13^3*q23-16*M`j'^2*n3*q12*q13^3*q23-16*q12^2*q13^3*q23-16*n3*q12^2*q13^3*q23-16*M`j'^2*q12^2*q13*q23^2-16*M`j'^2*n3*q12^2*q13*q23^2-32*M`j'^2*q12*q13^2*q23^2-32*M`j'^2*n3*q12*q13^2*q23^2-8*q12^2*q13^2*q23^2-8*n3*q12^2*q13^2*q23^2-16*M`j'^2*q12*q13*q23^3-16*M`j'^2*n3*q12*q13*q23^3+8*M`j'^2*q12^3*q13*q33+8*M`j'^2*n3*q12^3*q13*q33+8*M`j'^2*q12^2*q13^2*q33+8*M`j'^2*n3*q12^2*q13^2*q33-8*q12^3*q13^2*q33-8*n3*q12^3*q13^2*q33-12*q12^2*q13^3*q33-12*n3*q12^2*q13^3*q33+8*M`j'^2*q12^3*q23*q33+8*M`j'^2*n3*q12^3*q23*q33+16*M`j'^2*q12^2*q13*q23*q33+16*M`j'^2*n3*q12^2*q13*q23*q33-8*q12^3*q13*q23*q33-8*n3*q12^3*q13*q23*q33-8*M`j'^2*q12*q13^2*q23*q33-8*M`j'^2*n3*q12*q13^2*q23*q33-20*q12^2*q13^2*q23*q33-20*n3*q12^2*q13^2*q23*q33+8*M`j'^2*q12^2*q23^2*q33+8*M`j'^2*n3*q12^2*q23^2*q33-8*M`j'^2*q12*q13*q23^2*q33-8*M`j'^2*n3*q12*q13*q23^2*q33-8*q12^2*q13*q23^2*q33-8*n3*q12^2*q13*q23^2*q33+4*M`j'^2*q12^2*q13*q33^2+4*M`j'^2*n3*q12^2*q13*q33^2-2*q12^3*q13*q33^2-2*n3*q12^3*q13*q33^2-6*q12^2*q13^2*q33^2-6*n3*q12^2*q13^2*q33^2+4*M`j'^2*q12^2*q23*q33^2+4*M`j'^2*n3*q12^2*q23*q33^2-2*q12^3*q23*q33^2-2*n3*q12^3*q23*q33^2-8*q12^2*q13*q23*q33^2-8*n3*q12^2*q13*q23*q33^2-2*q12^2*q23^2*q33^2-2*n3*q12^2*q23^2*q33^2-q12^2*q13*q33^3-n3*q12^2*q13*q33^3-q12^2*q23*q33^3-n3*q12^2*q23*q33^3,-4*M`j'^2*q13^4+4*M`j'^2*n1*q13^4-16*M`j'^2*q13^3*q23+16*M`j'^2*n1*q13^3*q23-24*M`j'^2*q13^2*q23^2+24*M`j'^2*n1*q13^2*q23^2-16*M`j'^2*q13*q23^3+16*M`j'^2*n1*q13*q23^3-4*M`j'^2*q23^4+4*M`j'^2*n1*q23^4+16*M`j'^2*q12*q13^2*q33-16*M`j'^2*n1*q12*q13^2*q33-4*q12^2*q13^2*q33+4*n1*q12^2*q13^2*q33-4*q12*q13^3*q33+4*n1*q12*q13^3*q33+32*M`j'^2*q12*q13*q23*q33-32*M`j'^2*n1*q12*q13*q23*q33-8*q12^2*q13*q23*q33+8*n1*q12^2*q13*q23*q33-12*q12*q13^2*q23*q33+12*n1*q12*q13^2*q23*q33+16*M`j'^2*q12*q23^2*q33-16*M`j'^2*n1*q12*q23^2*q33-4*q12^2*q23^2*q33+4*n1*q12^2*q23^2*q33-12*q12*q13*q23^2*q33+12*n1*q12*q13*q23^2*q33-4*q12*q23^3*q33+4*n1*q12*q23^3*q33-16*M`j'^2*q12^2*q33^2+16*M`j'^2*n1*q12^2*q33^2+8*q12^3*q33^2-8*n1*q12^3*q33^2+8*q12^2*q13*q33^2-8*n1*q12^2*q13*q33^2-2*q12*q13^2*q33^2+2*n1*q12*q13^2*q33^2+8*q12^2*q23*q33^2-8*n1*q12^2*q23*q33^2-4*q12*q13*q23*q33^2+4*n1*q12*q13*q23*q33^2-2*q12*q23^2*q33^2+2*n1*q12*q23^2*q33^2+4*q12^2*q33^3-4*n1*q12^2*q33^3);
	Identify,ifmatch->jump mbox1l(n1?pos_,n2?pos_,n3?neg0_,n4?{,>1}) = mbox1l(n1,n2,1+n3,-2+n4)*prf(-2*M`j'^2*n3*q12+n3*q12^2,-2*M`j'^2*q13^2+2*M`j'^2*n4*q13^2-4*M`j'^2*q13*q23+4*M`j'^2*n4*q13*q23-2*M`j'^2*q23^2+2*M`j'^2*n4*q23^2+4*M`j'^2*q12*q33-4*M`j'^2*n4*q12*q33-2*q12^2*q33+2*n4*q12^2*q33-2*q12*q13*q33+2*n4*q12*q13*q33-2*q12*q23*q33+2*n4*q12*q23*q33-q12*q33^2+n4*q12*q33^2)+mbox1l(1+n1,n2,n3,-2+n4)*prf(-2*M`j'^2*n1*q12*q13-2*M`j'^2*n1*q12*q23-2*M`j'^2*n1*q12*q33,-4*M`j'^2*q12*q13^2+4*M`j'^2*n4*q12*q13^2-4*M`j'^2*q13^3+4*M`j'^2*n4*q13^3-8*M`j'^2*q12*q13*q23+8*M`j'^2*n4*q12*q13*q23-12*M`j'^2*q13^2*q23+12*M`j'^2*n4*q13^2*q23-4*M`j'^2*q12*q23^2+4*M`j'^2*n4*q12*q23^2-12*M`j'^2*q13*q23^2+12*M`j'^2*n4*q13*q23^2-4*M`j'^2*q23^3+4*M`j'^2*n4*q23^3+8*M`j'^2*q12^2*q33-8*M`j'^2*n4*q12^2*q33-4*q12^3*q33+4*n4*q12^3*q33+8*M`j'^2*q12*q13*q33-8*M`j'^2*n4*q12*q13*q33-8*q12^2*q13*q33+8*n4*q12^2*q13*q33-2*M`j'^2*q13^2*q33+2*M`j'^2*n4*q13^2*q33-4*q12*q13^2*q33+4*n4*q12*q13^2*q33+8*M`j'^2*q12*q23*q33-8*M`j'^2*n4*q12*q23*q33-8*q12^2*q23*q33+8*n4*q12^2*q23*q33-4*M`j'^2*q13*q23*q33+4*M`j'^2*n4*q13*q23*q33-8*q12*q13*q23*q33+8*n4*q12*q13*q23*q33-2*M`j'^2*q23^2*q33+2*M`j'^2*n4*q23^2*q33-4*q12*q23^2*q33+4*n4*q12*q23^2*q33+4*M`j'^2*q12*q33^2-4*M`j'^2*n4*q12*q33^2-4*q12^2*q33^2+4*n4*q12^2*q33^2-4*q12*q13*q33^2+4*n4*q12*q13*q33^2-4*q12*q23*q33^2+4*n4*q12*q23*q33^2-q12*q33^3+n4*q12*q33^3)+mbox1l(-1+n1,1+n2,n3,-1+n4)*prf(4*M`j'^2*n2*q12-2*n2*q12^2+2*M`j'^2*n2*q13-2*n2*q12*q13+2*M`j'^2*n2*q23-2*n2*q12*q23-n2*q12*q33,-2*M`j'^2*q13^2+2*M`j'^2*n4*q13^2-4*M`j'^2*q13*q23+4*M`j'^2*n4*q13*q23-2*M`j'^2*q23^2+2*M`j'^2*n4*q23^2+4*M`j'^2*q12*q33-4*M`j'^2*n4*q12*q33-2*q12^2*q33+2*n4*q12^2*q33-2*q12*q13*q33+2*n4*q12*q13*q33-2*q12*q23*q33+2*n4*q12*q23*q33-q12*q33^2+n4*q12*q33^2)+mbox1l(n1,1+n2,n3,-2+n4)*prf(-8*M`j'^2*n2*q12^2+4*n2*q12^3-6*M`j'^2*n2*q12*q13+4*n2*q12^2*q13-6*M`j'^2*n2*q12*q23+4*n2*q12^2*q23-2*M`j'^2*n2*q12*q33+2*n2*q12^2*q33,-4*M`j'^2*q12*q13^2+4*M`j'^2*n4*q12*q13^2-4*M`j'^2*q13^3+4*M`j'^2*n4*q13^3-8*M`j'^2*q12*q13*q23+8*M`j'^2*n4*q12*q13*q23-12*M`j'^2*q13^2*q23+12*M`j'^2*n4*q13^2*q23-4*M`j'^2*q12*q23^2+4*M`j'^2*n4*q12*q23^2-12*M`j'^2*q13*q23^2+12*M`j'^2*n4*q13*q23^2-4*M`j'^2*q23^3+4*M`j'^2*n4*q23^3+8*M`j'^2*q12^2*q33-8*M`j'^2*n4*q12^2*q33-4*q12^3*q33+4*n4*q12^3*q33+8*M`j'^2*q12*q13*q33-8*M`j'^2*n4*q12*q13*q33-8*q12^2*q13*q33+8*n4*q12^2*q13*q33-2*M`j'^2*q13^2*q33+2*M`j'^2*n4*q13^2*q33-4*q12*q13^2*q33+4*n4*q12*q13^2*q33+8*M`j'^2*q12*q23*q33-8*M`j'^2*n4*q12*q23*q33-8*q12^2*q23*q33+8*n4*q12^2*q23*q33-4*M`j'^2*q13*q23*q33+4*M`j'^2*n4*q13*q23*q33-8*q12*q13*q23*q33+8*n4*q12*q13*q23*q33-2*M`j'^2*q23^2*q33+2*M`j'^2*n4*q23^2*q33-4*q12*q23^2*q33+4*n4*q12*q23^2*q33+4*M`j'^2*q12*q33^2-4*M`j'^2*n4*q12*q33^2-4*q12^2*q33^2+4*n4*q12^2*q33^2-4*q12*q13*q33^2+4*n4*q12*q13*q33^2-4*q12*q23*q33^2+4*n4*q12*q23*q33^2-q12*q33^3+n4*q12*q33^3)+mbox1l(n1,n2,1+n3,-1+n4)*prf(-2*M`j'^2*n3*q12*q13+2*n3*q12^2*q13+2*M`j'^2*n3*q12*q23+n3*q12^2*q33,-2*M`j'^2*q13^2+2*M`j'^2*n4*q13^2-4*M`j'^2*q13*q23+4*M`j'^2*n4*q13*q23-2*M`j'^2*q23^2+2*M`j'^2*n4*q23^2+4*M`j'^2*q12*q33-4*M`j'^2*n4*q12*q33-2*q12^2*q33+2*n4*q12^2*q33-2*q12*q13*q33+2*n4*q12*q13*q33-2*q12*q23*q33+2*n4*q12*q23*q33-q12*q33^2+n4*q12*q33^2)+mbox1l(1+n1,-1+n2,n3,-1+n4)*prf(-2*M`j'^2*n1*q12*q13-2*M`j'^2*n1*q13^2-2*M`j'^2*n1*q12*q23-4*M`j'^2*n1*q13*q23-2*M`j'^2*n1*q23^2-2*M`j'^2*n1*q12*q33-2*M`j'^2*n1*q13*q33-2*M`j'^2*n1*q23*q33,-4*M`j'^2*q12*q13^2+4*M`j'^2*n4*q12*q13^2-4*M`j'^2*q13^3+4*M`j'^2*n4*q13^3-8*M`j'^2*q12*q13*q23+8*M`j'^2*n4*q12*q13*q23-12*M`j'^2*q13^2*q23+12*M`j'^2*n4*q13^2*q23-4*M`j'^2*q12*q23^2+4*M`j'^2*n4*q12*q23^2-12*M`j'^2*q13*q23^2+12*M`j'^2*n4*q13*q23^2-4*M`j'^2*q23^3+4*M`j'^2*n4*q23^3+8*M`j'^2*q12^2*q33-8*M`j'^2*n4*q12^2*q33-4*q12^3*q33+4*n4*q12^3*q33+8*M`j'^2*q12*q13*q33-8*M`j'^2*n4*q12*q13*q33-8*q12^2*q13*q33+8*n4*q12^2*q13*q33-2*M`j'^2*q13^2*q33+2*M`j'^2*n4*q13^2*q33-4*q12*q13^2*q33+4*n4*q12*q13^2*q33+8*M`j'^2*q12*q23*q33-8*M`j'^2*n4*q12*q23*q33-8*q12^2*q23*q33+8*n4*q12^2*q23*q33-4*M`j'^2*q13*q23*q33+4*M`j'^2*n4*q13*q23*q33-8*q12*q13*q23*q33+8*n4*q12*q13*q23*q33-2*M`j'^2*q23^2*q33+2*M`j'^2*n4*q23^2*q33-4*q12*q23^2*q33+4*n4*q12*q23^2*q33+4*M`j'^2*q12*q33^2-4*M`j'^2*n4*q12*q33^2-4*q12^2*q33^2+4*n4*q12^2*q33^2-4*q12*q13*q33^2+4*n4*q12*q13*q33^2-4*q12*q23*q33^2+4*n4*q12*q23*q33^2-q12*q33^3+n4*q12*q33^3)+mbox1l(n1,-1+n2,1+n3,-1+n4)*prf(-6*M`j'^2*n3*q12*q13+2*n3*q12^2*q13-4*M`j'^2*n3*q13^2+2*n3*q12*q13^2-2*M`j'^2*n3*q12*q23-6*M`j'^2*n3*q13*q23+2*n3*q12*q13*q23-2*M`j'^2*n3*q23^2-2*M`j'^2*n3*q12*q33-2*M`j'^2*n3*q13*q33+n3*q12*q13*q33-2*M`j'^2*n3*q23*q33,-4*M`j'^2*q12*q13^2+4*M`j'^2*n4*q12*q13^2-4*M`j'^2*q13^3+4*M`j'^2*n4*q13^3-8*M`j'^2*q12*q13*q23+8*M`j'^2*n4*q12*q13*q23-12*M`j'^2*q13^2*q23+12*M`j'^2*n4*q13^2*q23-4*M`j'^2*q12*q23^2+4*M`j'^2*n4*q12*q23^2-12*M`j'^2*q13*q23^2+12*M`j'^2*n4*q13*q23^2-4*M`j'^2*q23^3+4*M`j'^2*n4*q23^3+8*M`j'^2*q12^2*q33-8*M`j'^2*n4*q12^2*q33-4*q12^3*q33+4*n4*q12^3*q33+8*M`j'^2*q12*q13*q33-8*M`j'^2*n4*q12*q13*q33-8*q12^2*q13*q33+8*n4*q12^2*q13*q33-2*M`j'^2*q13^2*q33+2*M`j'^2*n4*q13^2*q33-4*q12*q13^2*q33+4*n4*q12*q13^2*q33+8*M`j'^2*q12*q23*q33-8*M`j'^2*n4*q12*q23*q33-8*q12^2*q23*q33+8*n4*q12^2*q23*q33-4*M`j'^2*q13*q23*q33+4*M`j'^2*n4*q13*q23*q33-8*q12*q13*q23*q33+8*n4*q12*q13*q23*q33-2*M`j'^2*q23^2*q33+2*M`j'^2*n4*q23^2*q33-4*q12*q23^2*q33+4*n4*q12*q23^2*q33+4*M`j'^2*q12*q33^2-4*M`j'^2*n4*q12*q33^2-4*q12^2*q33^2+4*n4*q12^2*q33^2-4*q12*q13*q33^2+4*n4*q12*q13*q33^2-4*q12*q23*q33^2+4*n4*q12*q23*q33^2-q12*q33^3+n4*q12*q33^3)+mbox1l(n1,-1+n2,n3,n4)*prf(-2*M`j'^2*q12*q13-2*M`j'^2*q13^2-2*M`j'^2*q12*q23-4*M`j'^2*q13*q23-2*M`j'^2*q23^2+2*M`j'^2*q12*q33-2*q12^2*q33-2*q12*q13*q33-2*q12*q23*q33-q12*q33^2,4*M`j'^2*q12*q13^2+4*M`j'^2*q13^3+8*M`j'^2*q12*q13*q23+12*M`j'^2*q13^2*q23+4*M`j'^2*q12*q23^2+12*M`j'^2*q13*q23^2+4*M`j'^2*q23^3-8*M`j'^2*q12^2*q33+4*q12^3*q33-8*M`j'^2*q12*q13*q33+8*q12^2*q13*q33+2*M`j'^2*q13^2*q33+4*q12*q13^2*q33-8*M`j'^2*q12*q23*q33+8*q12^2*q23*q33+4*M`j'^2*q13*q23*q33+8*q12*q13*q23*q33+2*M`j'^2*q23^2*q33+4*q12*q23^2*q33-4*M`j'^2*q12*q33^2+4*q12^2*q33^2+4*q12*q13*q33^2+4*q12*q23*q33^2+q12*q33^3)+mbox1l(-1+n1,n2,1+n3,-1+n4)*prf(4*M`j'^2*n3*q12^2-2*n3*q12^3+10*M`j'^2*n3*q12*q13-6*n3*q12^2*q13+4*M`j'^2*n3*q13^2-4*n3*q12*q13^2+6*M`j'^2*n3*q12*q23-4*n3*q12^2*q23+6*M`j'^2*n3*q13*q23-6*n3*q12*q13*q23+2*M`j'^2*n3*q23^2-2*n3*q12*q23^2+4*M`j'^2*n3*q12*q33-3*n3*q12^2*q33+2*M`j'^2*n3*q13*q33-4*n3*q12*q13*q33+2*M`j'^2*n3*q23*q33-3*n3*q12*q23*q33-n3*q12*q33^2,-4*M`j'^2*q12*q13^2+4*M`j'^2*n4*q12*q13^2-4*M`j'^2*q13^3+4*M`j'^2*n4*q13^3-8*M`j'^2*q12*q13*q23+8*M`j'^2*n4*q12*q13*q23-12*M`j'^2*q13^2*q23+12*M`j'^2*n4*q13^2*q23-4*M`j'^2*q12*q23^2+4*M`j'^2*n4*q12*q23^2-12*M`j'^2*q13*q23^2+12*M`j'^2*n4*q13*q23^2-4*M`j'^2*q23^3+4*M`j'^2*n4*q23^3+8*M`j'^2*q12^2*q33-8*M`j'^2*n4*q12^2*q33-4*q12^3*q33+4*n4*q12^3*q33+8*M`j'^2*q12*q13*q33-8*M`j'^2*n4*q12*q13*q33-8*q12^2*q13*q33+8*n4*q12^2*q13*q33-2*M`j'^2*q13^2*q33+2*M`j'^2*n4*q13^2*q33-4*q12*q13^2*q33+4*n4*q12*q13^2*q33+8*M`j'^2*q12*q23*q33-8*M`j'^2*n4*q12*q23*q33-8*q12^2*q23*q33+8*n4*q12^2*q23*q33-4*M`j'^2*q13*q23*q33+4*M`j'^2*n4*q13*q23*q33-8*q12*q13*q23*q33+8*n4*q12*q13*q23*q33-2*M`j'^2*q23^2*q33+2*M`j'^2*n4*q23^2*q33-4*q12*q23^2*q33+4*n4*q12*q23^2*q33+4*M`j'^2*q12*q33^2-4*M`j'^2*n4*q12*q33^2-4*q12^2*q33^2+4*n4*q12^2*q33^2-4*q12*q13*q33^2+4*n4*q12*q13*q33^2-4*q12*q23*q33^2+4*n4*q12*q23*q33^2-q12*q33^3+n4*q12*q33^3)+mbox1l(n1,n2,n3,-1+n4)*(tmpprf(ep,1)*prf(-4*q12^2*q13-4*q12*q13^2-4*q12^2*q23-8*q12*q13*q23-4*q12*q23^2-4*q12^2*q33-6*q12*q13*q33-6*q12*q23*q33-2*q12*q33^2,-4*M`j'^2*q12*q13^2+4*M`j'^2*n4*q12*q13^2-4*M`j'^2*q13^3+4*M`j'^2*n4*q13^3-8*M`j'^2*q12*q13*q23+8*M`j'^2*n4*q12*q13*q23-12*M`j'^2*q13^2*q23+12*M`j'^2*n4*q13^2*q23-4*M`j'^2*q12*q23^2+4*M`j'^2*n4*q12*q23^2-12*M`j'^2*q13*q23^2+12*M`j'^2*n4*q13*q23^2-4*M`j'^2*q23^3+4*M`j'^2*n4*q23^3+8*M`j'^2*q12^2*q33-8*M`j'^2*n4*q12^2*q33-4*q12^3*q33+4*n4*q12^3*q33+8*M`j'^2*q12*q13*q33-8*M`j'^2*n4*q12*q13*q33-8*q12^2*q13*q33+8*n4*q12^2*q13*q33-2*M`j'^2*q13^2*q33+2*M`j'^2*n4*q13^2*q33-4*q12*q13^2*q33+4*n4*q12*q13^2*q33+8*M`j'^2*q12*q23*q33-8*M`j'^2*n4*q12*q23*q33-8*q12^2*q23*q33+8*n4*q12^2*q23*q33-4*M`j'^2*q13*q23*q33+4*M`j'^2*n4*q13*q23*q33-8*q12*q13*q23*q33+8*n4*q12*q13*q23*q33-2*M`j'^2*q23^2*q33+2*M`j'^2*n4*q23^2*q33-4*q12*q23^2*q33+4*n4*q12*q23^2*q33+4*M`j'^2*q12*q33^2-4*M`j'^2*n4*q12*q33^2-4*q12^2*q33^2+4*n4*q12^2*q33^2-4*q12*q13*q33^2+4*n4*q12*q13*q33^2-4*q12*q23*q33^2+4*n4*q12*q23*q33^2-q12*q33^3+n4*q12*q33^3)+prf(-2*M`j'^2*q12*q13+4*M`j'^2*n1*q12*q13-6*M`j'^2*n2*q12*q13+2*M`j'^2*n4*q12*q13+12*q12^2*q13-4*n1*q12^2*q13-2*n3*q12^2*q13-4*n4*q12^2*q13-2*M`j'^2*q13^2+2*M`j'^2*n1*q13^2-4*M`j'^2*n2*q13^2+2*M`j'^2*n4*q13^2+12*q12*q13^2-4*n1*q12*q13^2-2*n3*q12*q13^2-4*n4*q12*q13^2-2*M`j'^2*q12*q23+4*M`j'^2*n1*q12*q23-6*M`j'^2*n2*q12*q23+2*M`j'^2*n4*q12*q23+12*q12^2*q23-4*n1*q12^2*q23-2*n3*q12^2*q23-4*n4*q12^2*q23-4*M`j'^2*q13*q23+4*M`j'^2*n1*q13*q23-8*M`j'^2*n2*q13*q23+4*M`j'^2*n4*q13*q23+24*q12*q13*q23-8*n1*q12*q13*q23-4*n3*q12*q13*q23-8*n4*q12*q13*q23-2*M`j'^2*q23^2+2*M`j'^2*n1*q23^2-4*M`j'^2*n2*q23^2+2*M`j'^2*n4*q23^2+12*q12*q23^2-4*n1*q12*q23^2-2*n3*q12*q23^2-4*n4*q12*q23^2+2*M`j'^2*q12*q33+4*M`j'^2*n1*q12*q33-2*M`j'^2*n2*q12*q33-2*M`j'^2*n4*q12*q33+10*q12^2*q33-4*n1*q12^2*q33-2*n2*q12^2*q33-2*n3*q12^2*q33-2*n4*q12^2*q33+2*M`j'^2*n1*q13*q33-2*M`j'^2*n2*q13*q33+16*q12*q13*q33-6*n1*q12*q13*q33-2*n2*q12*q13*q33-3*n3*q12*q13*q33-4*n4*q12*q13*q33+2*M`j'^2*n1*q23*q33-2*M`j'^2*n2*q23*q33+16*q12*q23*q33-6*n1*q12*q23*q33-2*n2*q12*q23*q33-3*n3*q12*q23*q33-4*n4*q12*q23*q33+5*q12*q33^2-2*n1*q12*q33^2-n2*q12*q33^2-n3*q12*q33^2-n4*q12*q33^2,-4*M`j'^2*q12*q13^2+4*M`j'^2*n4*q12*q13^2-4*M`j'^2*q13^3+4*M`j'^2*n4*q13^3-8*M`j'^2*q12*q13*q23+8*M`j'^2*n4*q12*q13*q23-12*M`j'^2*q13^2*q23+12*M`j'^2*n4*q13^2*q23-4*M`j'^2*q12*q23^2+4*M`j'^2*n4*q12*q23^2-12*M`j'^2*q13*q23^2+12*M`j'^2*n4*q13*q23^2-4*M`j'^2*q23^3+4*M`j'^2*n4*q23^3+8*M`j'^2*q12^2*q33-8*M`j'^2*n4*q12^2*q33-4*q12^3*q33+4*n4*q12^3*q33+8*M`j'^2*q12*q13*q33-8*M`j'^2*n4*q12*q13*q33-8*q12^2*q13*q33+8*n4*q12^2*q13*q33-2*M`j'^2*q13^2*q33+2*M`j'^2*n4*q13^2*q33-4*q12*q13^2*q33+4*n4*q12*q13^2*q33+8*M`j'^2*q12*q23*q33-8*M`j'^2*n4*q12*q23*q33-8*q12^2*q23*q33+8*n4*q12^2*q23*q33-4*M`j'^2*q13*q23*q33+4*M`j'^2*n4*q13*q23*q33-8*q12*q13*q23*q33+8*n4*q12*q13*q23*q33-2*M`j'^2*q23^2*q33+2*M`j'^2*n4*q23^2*q33-4*q12*q23^2*q33+4*n4*q12*q23^2*q33+4*M`j'^2*q12*q33^2-4*M`j'^2*n4*q12*q33^2-4*q12^2*q33^2+4*n4*q12^2*q33^2-4*q12*q13*q33^2+4*n4*q12*q13*q33^2-4*q12*q23*q33^2+4*n4*q12*q23*q33^2-q12*q33^3+n4*q12*q33^3));
	Identify,ifmatch->jump mbox1l(n1?pos_,n2?{,>1},n3?neg0_,n4?pos_) = mbox1l(n1,-1+n2,1+n3,-1+n4)*prf(-2*M`j'^2*n3*q13-2*M`j'^2*n3*q23-n3*q12*q33,-4*M`j'^2*q13^2+4*M`j'^2*n2*q13^2-8*M`j'^2*q13*q23+8*M`j'^2*n2*q13*q23-4*M`j'^2*q23^2+4*M`j'^2*n2*q23^2+8*M`j'^2*q12*q33-8*M`j'^2*n2*q12*q33-4*q12^2*q33+4*n2*q12^2*q33-4*q12*q13*q33+4*n2*q12*q13*q33-4*q12*q23*q33+4*n2*q12*q23*q33-2*q12*q33^2+2*n2*q12*q33^2)+mbox1l(n1,n2,n3,-1+n4)*prf(-4*M`j'^2*q12*q13-2*M`j'^2*q13^2-4*M`j'^2*q12*q23-4*M`j'^2*q13*q23-2*M`j'^2*q23^2-2*M`j'^2*q12*q33-M`j'^2*q13*q33-M`j'^2*q23*q33,4*M`j'^2*q12*q13^2+4*M`j'^2*q13^3+8*M`j'^2*q12*q13*q23+12*M`j'^2*q13^2*q23+4*M`j'^2*q12*q23^2+12*M`j'^2*q13*q23^2+4*M`j'^2*q23^3-8*M`j'^2*q12^2*q33+4*q12^3*q33-8*M`j'^2*q12*q13*q33+8*q12^2*q13*q33+2*M`j'^2*q13^2*q33+4*q12*q13^2*q33-8*M`j'^2*q12*q23*q33+8*q12^2*q23*q33+4*M`j'^2*q13*q23*q33+8*q12*q13*q23*q33+2*M`j'^2*q23^2*q33+4*q12*q23^2*q33-4*M`j'^2*q12*q33^2+4*q12^2*q33^2+4*q12*q13*q33^2+4*q12*q23*q33^2+q12*q33^3)+mbox1l(n1,-2+n2,n3,1+n4)*prf(-2*M`j'^2*n4*q12*q33-M`j'^2*n4*q13*q33-M`j'^2*n4*q23*q33,-4*M`j'^2*q12*q13^2+4*M`j'^2*n2*q12*q13^2-4*M`j'^2*q13^3+4*M`j'^2*n2*q13^3-8*M`j'^2*q12*q13*q23+8*M`j'^2*n2*q12*q13*q23-12*M`j'^2*q13^2*q23+12*M`j'^2*n2*q13^2*q23-4*M`j'^2*q12*q23^2+4*M`j'^2*n2*q12*q23^2-12*M`j'^2*q13*q23^2+12*M`j'^2*n2*q13*q23^2-4*M`j'^2*q23^3+4*M`j'^2*n2*q23^3+8*M`j'^2*q12^2*q33-8*M`j'^2*n2*q12^2*q33-4*q12^3*q33+4*n2*q12^3*q33+8*M`j'^2*q12*q13*q33-8*M`j'^2*n2*q12*q13*q33-8*q12^2*q13*q33+8*n2*q12^2*q13*q33-2*M`j'^2*q13^2*q33+2*M`j'^2*n2*q13^2*q33-4*q12*q13^2*q33+4*n2*q12*q13^2*q33+8*M`j'^2*q12*q23*q33-8*M`j'^2*n2*q12*q23*q33-8*q12^2*q23*q33+8*n2*q12^2*q23*q33-4*M`j'^2*q13*q23*q33+4*M`j'^2*n2*q13*q23*q33-8*q12*q13*q23*q33+8*n2*q12*q13*q23*q33-2*M`j'^2*q23^2*q33+2*M`j'^2*n2*q23^2*q33-4*q12*q23^2*q33+4*n2*q12*q23^2*q33+4*M`j'^2*q12*q33^2-4*M`j'^2*n2*q12*q33^2-4*q12^2*q33^2+4*n2*q12^2*q33^2-4*q12*q13*q33^2+4*n2*q12*q13*q33^2-4*q12*q23*q33^2+4*n2*q12*q23*q33^2-q12*q33^3+n2*q12*q33^3)+mbox1l(-1+n1,n2,n3,n4)*prf(4*M`j'^2*q13+4*M`j'^2*q23+4*M`j'^2*q33-2*q12*q33-2*q13*q33-2*q23*q33-q33^2,4*M`j'^2*q13^2+8*M`j'^2*q13*q23+4*M`j'^2*q23^2-8*M`j'^2*q12*q33+4*q12^2*q33+4*q12*q13*q33+4*q12*q23*q33+2*q12*q33^2)+mbox1l(1+n1,-1+n2,n3,-1+n4)*prf(-2*M`j'^2*n1*q13^2-4*M`j'^2*n1*q13*q23-2*M`j'^2*n1*q23^2+2*M`j'^2*n1*q12*q33-2*n1*q12^2*q33-M`j'^2*n1*q13*q33-2*n1*q12*q13*q33-M`j'^2*n1*q23*q33-2*n1*q12*q23*q33-n1*q12*q33^2,-4*M`j'^2*q12*q13^2+4*M`j'^2*n2*q12*q13^2-4*M`j'^2*q13^3+4*M`j'^2*n2*q13^3-8*M`j'^2*q12*q13*q23+8*M`j'^2*n2*q12*q13*q23-12*M`j'^2*q13^2*q23+12*M`j'^2*n2*q13^2*q23-4*M`j'^2*q12*q23^2+4*M`j'^2*n2*q12*q23^2-12*M`j'^2*q13*q23^2+12*M`j'^2*n2*q13*q23^2-4*M`j'^2*q23^3+4*M`j'^2*n2*q23^3+8*M`j'^2*q12^2*q33-8*M`j'^2*n2*q12^2*q33-4*q12^3*q33+4*n2*q12^3*q33+8*M`j'^2*q12*q13*q33-8*M`j'^2*n2*q12*q13*q33-8*q12^2*q13*q33+8*n2*q12^2*q13*q33-2*M`j'^2*q13^2*q33+2*M`j'^2*n2*q13^2*q33-4*q12*q13^2*q33+4*n2*q12*q13^2*q33+8*M`j'^2*q12*q23*q33-8*M`j'^2*n2*q12*q23*q33-8*q12^2*q23*q33+8*n2*q12^2*q23*q33-4*M`j'^2*q13*q23*q33+4*M`j'^2*n2*q13*q23*q33-8*q12*q13*q23*q33+8*n2*q12*q13*q23*q33-2*M`j'^2*q23^2*q33+2*M`j'^2*n2*q23^2*q33-4*q12*q23^2*q33+4*n2*q12*q23^2*q33+4*M`j'^2*q12*q33^2-4*M`j'^2*n2*q12*q33^2-4*q12^2*q33^2+4*n2*q12^2*q33^2-4*q12*q13*q33^2+4*n2*q12*q13*q33^2-4*q12*q23*q33^2+4*n2*q12*q23*q33^2-q12*q33^3+n2*q12*q33^3)+mbox1l(n1,-1+n2,1+n3,n4)*prf(-4*M`j'^2*n3*q13^2-4*M`j'^2*n3*q13*q23+4*M`j'^2*n3*q12*q33-2*n3*q12*q13*q33-n3*q12*q33^2,-4*M`j'^2*q13^2+4*M`j'^2*n2*q13^2-8*M`j'^2*q13*q23+8*M`j'^2*n2*q13*q23-4*M`j'^2*q23^2+4*M`j'^2*n2*q23^2+8*M`j'^2*q12*q33-8*M`j'^2*n2*q12*q33-4*q12^2*q33+4*n2*q12^2*q33-4*q12*q13*q33+4*n2*q12*q13*q33-4*q12*q23*q33+4*n2*q12*q23*q33-2*q12*q33^2+2*n2*q12*q33^2)+mbox1l(1+n1,-2+n2,n3,n4)*prf(-4*M`j'^2*n1*q12*q33-6*M`j'^2*n1*q13*q33-6*M`j'^2*n1*q23*q33-4*M`j'^2*n1*q33^2+2*n1*q12*q33^2+2*n1*q13*q33^2+2*n1*q23*q33^2+n1*q33^3,-8*M`j'^2*q12*q13^2+8*M`j'^2*n2*q12*q13^2-8*M`j'^2*q13^3+8*M`j'^2*n2*q13^3-16*M`j'^2*q12*q13*q23+16*M`j'^2*n2*q12*q13*q23-24*M`j'^2*q13^2*q23+24*M`j'^2*n2*q13^2*q23-8*M`j'^2*q12*q23^2+8*M`j'^2*n2*q12*q23^2-24*M`j'^2*q13*q23^2+24*M`j'^2*n2*q13*q23^2-8*M`j'^2*q23^3+8*M`j'^2*n2*q23^3+16*M`j'^2*q12^2*q33-16*M`j'^2*n2*q12^2*q33-8*q12^3*q33+8*n2*q12^3*q33+16*M`j'^2*q12*q13*q33-16*M`j'^2*n2*q12*q13*q33-16*q12^2*q13*q33+16*n2*q12^2*q13*q33-4*M`j'^2*q13^2*q33+4*M`j'^2*n2*q13^2*q33-8*q12*q13^2*q33+8*n2*q12*q13^2*q33+16*M`j'^2*q12*q23*q33-16*M`j'^2*n2*q12*q23*q33-16*q12^2*q23*q33+16*n2*q12^2*q23*q33-8*M`j'^2*q13*q23*q33+8*M`j'^2*n2*q13*q23*q33-16*q12*q13*q23*q33+16*n2*q12*q13*q23*q33-4*M`j'^2*q23^2*q33+4*M`j'^2*n2*q23^2*q33-8*q12*q23^2*q33+8*n2*q12*q23^2*q33+8*M`j'^2*q12*q33^2-8*M`j'^2*n2*q12*q33^2-8*q12^2*q33^2+8*n2*q12^2*q33^2-8*q12*q13*q33^2+8*n2*q12*q13*q33^2-8*q12*q23*q33^2+8*n2*q12*q23*q33^2-2*q12*q33^3+2*n2*q12*q33^3)+mbox1l(n1,-1+n2,n3,n4)*(tmpprf(ep,1)*prf(-8*q12^2*q33-12*q12*q13*q33-4*q13^2*q33-12*q12*q23*q33-8*q13*q23*q33-4*q23^2*q33-4*q12*q33^2-2*q13*q33^2-2*q23*q33^2,-8*M`j'^2*q12*q13^2+8*M`j'^2*n2*q12*q13^2-8*M`j'^2*q13^3+8*M`j'^2*n2*q13^3-16*M`j'^2*q12*q13*q23+16*M`j'^2*n2*q12*q13*q23-24*M`j'^2*q13^2*q23+24*M`j'^2*n2*q13^2*q23-8*M`j'^2*q12*q23^2+8*M`j'^2*n2*q12*q23^2-24*M`j'^2*q13*q23^2+24*M`j'^2*n2*q13*q23^2-8*M`j'^2*q23^3+8*M`j'^2*n2*q23^3+16*M`j'^2*q12^2*q33-16*M`j'^2*n2*q12^2*q33-8*q12^3*q33+8*n2*q12^3*q33+16*M`j'^2*q12*q13*q33-16*M`j'^2*n2*q12*q13*q33-16*q12^2*q13*q33+16*n2*q12^2*q13*q33-4*M`j'^2*q13^2*q33+4*M`j'^2*n2*q13^2*q33-8*q12*q13^2*q33+8*n2*q12*q13^2*q33+16*M`j'^2*q12*q23*q33-16*M`j'^2*n2*q12*q23*q33-16*q12^2*q23*q33+16*n2*q12^2*q23*q33-8*M`j'^2*q13*q23*q33+8*M`j'^2*n2*q13*q23*q33-16*q12*q13*q23*q33+16*n2*q12*q13*q23*q33-4*M`j'^2*q23^2*q33+4*M`j'^2*n2*q23^2*q33-8*q12*q23^2*q33+8*n2*q12*q23^2*q33+8*M`j'^2*q12*q33^2-8*M`j'^2*n2*q12*q33^2-8*q12^2*q33^2+8*n2*q12^2*q33^2-8*q12*q13*q33^2+8*n2*q12*q13*q33^2-8*q12*q23*q33^2+8*n2*q12*q23*q33^2-2*q12*q33^3+2*n2*q12*q33^3)+prf(4*M`j'^2*q13^2+4*M`j'^2*n1*q13^2-4*M`j'^2*n2*q13^2+8*M`j'^2*q13*q23+8*M`j'^2*n1*q13*q23-8*M`j'^2*n2*q13*q23+4*M`j'^2*q23^2+4*M`j'^2*n1*q23^2-4*M`j'^2*n2*q23^2+4*M`j'^2*q12*q33-4*M`j'^2*n2*q12*q33+4*M`j'^2*n4*q12*q33+20*q12^2*q33-4*n1*q12^2*q33-4*n2*q12^2*q33-4*n3*q12^2*q33-8*n4*q12^2*q33+10*M`j'^2*q13*q33+8*M`j'^2*n1*q13*q33-10*M`j'^2*n2*q13*q33+2*M`j'^2*n4*q13*q33+28*q12*q13*q33-8*n1*q12*q13*q33-4*n2*q12*q13*q33-6*n3*q12*q13*q33-12*n4*q12*q13*q33+8*q13^2*q33-4*n1*q13^2*q33-2*n3*q13^2*q33-4*n4*q13^2*q33+10*M`j'^2*q23*q33+8*M`j'^2*n1*q23*q33-10*M`j'^2*n2*q23*q33+2*M`j'^2*n4*q23*q33+28*q12*q23*q33-8*n1*q12*q23*q33-4*n2*q12*q23*q33-6*n3*q12*q23*q33-12*n4*q12*q23*q33+16*q13*q23*q33-8*n1*q13*q23*q33-4*n3*q13*q23*q33-8*n4*q13*q23*q33+8*q23^2*q33-4*n1*q23^2*q33-2*n3*q23^2*q33-4*n4*q23^2*q33+4*M`j'^2*q33^2+4*M`j'^2*n1*q33^2-4*M`j'^2*n2*q33^2+8*q12*q33^2-4*n1*q12*q33^2-2*n3*q12*q33^2-4*n4*q12*q33^2+2*q13*q33^2-4*n1*q13*q33^2+2*n2*q13*q33^2-n3*q13*q33^2-2*n4*q13*q33^2+2*q23*q33^2-4*n1*q23*q33^2+2*n2*q23*q33^2-n3*q23*q33^2-2*n4*q23*q33^2-q33^3-n1*q33^3+n2*q33^3,-8*M`j'^2*q12*q13^2+8*M`j'^2*n2*q12*q13^2-8*M`j'^2*q13^3+8*M`j'^2*n2*q13^3-16*M`j'^2*q12*q13*q23+16*M`j'^2*n2*q12*q13*q23-24*M`j'^2*q13^2*q23+24*M`j'^2*n2*q13^2*q23-8*M`j'^2*q12*q23^2+8*M`j'^2*n2*q12*q23^2-24*M`j'^2*q13*q23^2+24*M`j'^2*n2*q13*q23^2-8*M`j'^2*q23^3+8*M`j'^2*n2*q23^3+16*M`j'^2*q12^2*q33-16*M`j'^2*n2*q12^2*q33-8*q12^3*q33+8*n2*q12^3*q33+16*M`j'^2*q12*q13*q33-16*M`j'^2*n2*q12*q13*q33-16*q12^2*q13*q33+16*n2*q12^2*q13*q33-4*M`j'^2*q13^2*q33+4*M`j'^2*n2*q13^2*q33-8*q12*q13^2*q33+8*n2*q12*q13^2*q33+16*M`j'^2*q12*q23*q33-16*M`j'^2*n2*q12*q23*q33-16*q12^2*q23*q33+16*n2*q12^2*q23*q33-8*M`j'^2*q13*q23*q33+8*M`j'^2*n2*q13*q23*q33-16*q12*q13*q23*q33+16*n2*q12*q13*q23*q33-4*M`j'^2*q23^2*q33+4*M`j'^2*n2*q23^2*q33-8*q12*q23^2*q33+8*n2*q12*q23^2*q33+8*M`j'^2*q12*q33^2-8*M`j'^2*n2*q12*q33^2-8*q12^2*q33^2+8*n2*q12^2*q33^2-8*q12*q13*q33^2+8*n2*q12*q13*q33^2-8*q12*q23*q33^2+8*n2*q12*q23*q33^2-2*q12*q33^3+2*n2*q12*q33^3))+mbox1l(-1+n1,-1+n2,1+n3,n4)*prf(4*M`j'^2*n3*q12*q13+8*M`j'^2*n3*q13^2+4*M`j'^2*n3*q12*q23+12*M`j'^2*n3*q13*q23+4*M`j'^2*n3*q23^2+4*M`j'^2*n3*q12*q33-2*n3*q12^2*q33+12*M`j'^2*n3*q13*q33-6*n3*q12*q13*q33-4*n3*q13^2*q33+8*M`j'^2*n3*q23*q33-4*n3*q12*q23*q33-6*n3*q13*q23*q33-2*n3*q23^2*q33+4*M`j'^2*n3*q33^2-3*n3*q12*q33^2-4*n3*q13*q33^2-3*n3*q23*q33^2-n3*q33^3,-8*M`j'^2*q12*q13^2+8*M`j'^2*n2*q12*q13^2-8*M`j'^2*q13^3+8*M`j'^2*n2*q13^3-16*M`j'^2*q12*q13*q23+16*M`j'^2*n2*q12*q13*q23-24*M`j'^2*q13^2*q23+24*M`j'^2*n2*q13^2*q23-8*M`j'^2*q12*q23^2+8*M`j'^2*n2*q12*q23^2-24*M`j'^2*q13*q23^2+24*M`j'^2*n2*q13*q23^2-8*M`j'^2*q23^3+8*M`j'^2*n2*q23^3+16*M`j'^2*q12^2*q33-16*M`j'^2*n2*q12^2*q33-8*q12^3*q33+8*n2*q12^3*q33+16*M`j'^2*q12*q13*q33-16*M`j'^2*n2*q12*q13*q33-16*q12^2*q13*q33+16*n2*q12^2*q13*q33-4*M`j'^2*q13^2*q33+4*M`j'^2*n2*q13^2*q33-8*q12*q13^2*q33+8*n2*q12*q13^2*q33+16*M`j'^2*q12*q23*q33-16*M`j'^2*n2*q12*q23*q33-16*q12^2*q23*q33+16*n2*q12^2*q23*q33-8*M`j'^2*q13*q23*q33+8*M`j'^2*n2*q13*q23*q33-16*q12*q13*q23*q33+16*n2*q12*q13*q23*q33-4*M`j'^2*q23^2*q33+4*M`j'^2*n2*q23^2*q33-8*q12*q23^2*q33+8*n2*q12*q23^2*q33+8*M`j'^2*q12*q33^2-8*M`j'^2*n2*q12*q33^2-8*q12^2*q33^2+8*n2*q12^2*q33^2-8*q12*q13*q33^2+8*n2*q12*q13*q33^2-8*q12*q23*q33^2+8*n2*q12*q23*q33^2-2*q12*q33^3+2*n2*q12*q33^3)+mbox1l(n1,-2+n2,1+n3,n4)*prf(-4*M`j'^2*n3*q13^2-4*M`j'^2*n3*q13*q23-4*M`j'^2*n3*q12*q33-10*M`j'^2*n3*q13*q33+2*n3*q12*q13*q33+2*n3*q13^2*q33-6*M`j'^2*n3*q23*q33+2*n3*q13*q23*q33-4*M`j'^2*n3*q33^2+2*n3*q12*q33^2+3*n3*q13*q33^2+2*n3*q23*q33^2+n3*q33^3,-8*M`j'^2*q12*q13^2+8*M`j'^2*n2*q12*q13^2-8*M`j'^2*q13^3+8*M`j'^2*n2*q13^3-16*M`j'^2*q12*q13*q23+16*M`j'^2*n2*q12*q13*q23-24*M`j'^2*q13^2*q23+24*M`j'^2*n2*q13^2*q23-8*M`j'^2*q12*q23^2+8*M`j'^2*n2*q12*q23^2-24*M`j'^2*q13*q23^2+24*M`j'^2*n2*q13*q23^2-8*M`j'^2*q23^3+8*M`j'^2*n2*q23^3+16*M`j'^2*q12^2*q33-16*M`j'^2*n2*q12^2*q33-8*q12^3*q33+8*n2*q12^3*q33+16*M`j'^2*q12*q13*q33-16*M`j'^2*n2*q12*q13*q33-16*q12^2*q13*q33+16*n2*q12^2*q13*q33-4*M`j'^2*q13^2*q33+4*M`j'^2*n2*q13^2*q33-8*q12*q13^2*q33+8*n2*q12*q13^2*q33+16*M`j'^2*q12*q23*q33-16*M`j'^2*n2*q12*q23*q33-16*q12^2*q23*q33+16*n2*q12^2*q23*q33-8*M`j'^2*q13*q23*q33+8*M`j'^2*n2*q13*q23*q33-16*q12*q13*q23*q33+16*n2*q12*q13*q23*q33-4*M`j'^2*q23^2*q33+4*M`j'^2*n2*q23^2*q33-8*q12*q23^2*q33+8*n2*q12*q23^2*q33+8*M`j'^2*q12*q33^2-8*M`j'^2*n2*q12*q33^2-8*q12^2*q33^2+8*n2*q12^2*q33^2-8*q12*q13*q33^2+8*n2*q12*q13*q33^2-8*q12*q23*q33^2+8*n2*q12*q23*q33^2-2*q12*q33^3+2*n2*q12*q33^3);
	Identify,ifmatch->jump mbox1l(n1?{,>1},n2?pos_,n3?neg0_,n4?pos_) = mbox1l(n1,n2,n3,-1+n4)*prf(M`j'^2*q13+M`j'^2*q23,2*M`j'^2*q13^2+4*M`j'^2*q13*q23+2*M`j'^2*q23^2-4*M`j'^2*q12*q33+2*q12^2*q33+2*q12*q13*q33+2*q12*q23*q33+q12*q33^2)+mbox1l(-1+n1,-1+n2,n3,1+n4)*prf(M`j'^2*n4*q13+M`j'^2*n4*q23,-2*M`j'^2*q13^2+2*M`j'^2*n1*q13^2-4*M`j'^2*q13*q23+4*M`j'^2*n1*q13*q23-2*M`j'^2*q23^2+2*M`j'^2*n1*q23^2+4*M`j'^2*q12*q33-4*M`j'^2*n1*q12*q33-2*q12^2*q33+2*n1*q12^2*q33-2*q12*q13*q33+2*n1*q12*q13*q33-2*q12*q23*q33+2*n1*q12*q23*q33-q12*q33^2+n1*q12*q33^2)+mbox1l(-1+n1,1+n2,n3,-1+n4)*prf(4*M`j'^2*n2*q12-2*n2*q12^2+M`j'^2*n2*q13-2*n2*q12*q13+M`j'^2*n2*q23-2*n2*q12*q23-n2*q12*q33,-2*M`j'^2*q13^2+2*M`j'^2*n1*q13^2-4*M`j'^2*q13*q23+4*M`j'^2*n1*q13*q23-2*M`j'^2*q23^2+2*M`j'^2*n1*q23^2+4*M`j'^2*q12*q33-4*M`j'^2*n1*q12*q33-2*q12^2*q33+2*n1*q12^2*q33-2*q12*q13*q33+2*n1*q12*q13*q33-2*q12*q23*q33+2*n1*q12*q23*q33-q12*q33^2+n1*q12*q33^2)+mbox1l(-1+n1,n2,1+n3,-1+n4)*prf(4*M`j'^2*n3*q12-2*n3*q12^2+2*M`j'^2*n3*q13-2*n3*q12*q13+2*M`j'^2*n3*q23-2*n3*q12*q23-n3*q12*q33,-4*M`j'^2*q13^2+4*M`j'^2*n1*q13^2-8*M`j'^2*q13*q23+8*M`j'^2*n1*q13*q23-4*M`j'^2*q23^2+4*M`j'^2*n1*q23^2+8*M`j'^2*q12*q33-8*M`j'^2*n1*q12*q33-4*q12^2*q33+4*n1*q12^2*q33-4*q12*q13*q33+4*n1*q12*q13*q33-4*q12*q23*q33+4*n1*q12*q23*q33-2*q12*q33^2+2*n1*q12*q33^2)+mbox1l(n1,-1+n2,n3,n4)*prf(2*M`j'^2*q13+2*M`j'^2*q23+4*M`j'^2*q33-2*q12*q33-2*q13*q33-2*q23*q33-q33^2,4*M`j'^2*q13^2+8*M`j'^2*q13*q23+4*M`j'^2*q23^2-8*M`j'^2*q12*q33+4*q12^2*q33+4*q12*q13*q33+4*q12*q23*q33+2*q12*q33^2)+mbox1l(-1+n1,n2,n3,n4)*(tmpprf(ep,1)*prf(4*q12*q13+4*q13^2+4*q12*q23+8*q13*q23+4*q23^2+2*q13*q33+2*q23*q33,-4*M`j'^2*q13^2+4*M`j'^2*n1*q13^2-8*M`j'^2*q13*q23+8*M`j'^2*n1*q13*q23-4*M`j'^2*q23^2+4*M`j'^2*n1*q23^2+8*M`j'^2*q12*q33-8*M`j'^2*n1*q12*q33-4*q12^2*q33+4*n1*q12^2*q33-4*q12*q13*q33+4*n1*q12*q13*q33-4*q12*q23*q33+4*n1*q12*q23*q33-2*q12*q33^2+2*n1*q12*q33^2)+prf(4*M`j'^2*q13-4*M`j'^2*n1*q13+6*M`j'^2*n2*q13-2*M`j'^2*n4*q13-12*q12*q13+4*n1*q12*q13+2*n3*q12*q13+4*n4*q12*q13-12*q13^2+4*n1*q13^2+2*n3*q13^2+4*n4*q13^2+4*M`j'^2*q23-4*M`j'^2*n1*q23+6*M`j'^2*n2*q23-2*M`j'^2*n4*q23-12*q12*q23+4*n1*q12*q23+2*n3*q12*q23+4*n4*q12*q23-24*q13*q23+8*n1*q13*q23+4*n3*q13*q23+8*n4*q13*q23-12*q23^2+4*n1*q23^2+2*n3*q23^2+4*n4*q23^2+4*M`j'^2*q33-4*M`j'^2*n1*q33+4*M`j'^2*n2*q33-2*q12*q33+2*n1*q12*q33-2*n2*q12*q33-8*q13*q33+4*n1*q13*q33-2*n2*q13*q33+n3*q13*q33+2*n4*q13*q33-8*q23*q33+4*n1*q23*q33-2*n2*q23*q33+n3*q23*q33+2*n4*q23*q33-q33^2+n1*q33^2-n2*q33^2,-4*M`j'^2*q13^2+4*M`j'^2*n1*q13^2-8*M`j'^2*q13*q23+8*M`j'^2*n1*q13*q23-4*M`j'^2*q23^2+4*M`j'^2*n1*q23^2+8*M`j'^2*q12*q33-8*M`j'^2*n1*q12*q33-4*q12^2*q33+4*n1*q12^2*q33-4*q12*q13*q33+4*n1*q12*q13*q33-4*q12*q23*q33+4*n1*q12*q23*q33-2*q12*q33^2+2*n1*q12*q33^2))+mbox1l(-2+n1,1+n2,n3,n4)*prf(-8*M`j'^2*n2*q12+4*n2*q12^2-8*M`j'^2*n2*q13+8*n2*q12*q13+4*n2*q13^2-8*M`j'^2*n2*q23+8*n2*q12*q23+8*n2*q13*q23+4*n2*q23^2-4*M`j'^2*n2*q33+4*n2*q12*q33+4*n2*q13*q33+4*n2*q23*q33+n2*q33^2,-4*M`j'^2*q13^2+4*M`j'^2*n1*q13^2-8*M`j'^2*q13*q23+8*M`j'^2*n1*q13*q23-4*M`j'^2*q23^2+4*M`j'^2*n1*q23^2+8*M`j'^2*q12*q33-8*M`j'^2*n1*q12*q33-4*q12^2*q33+4*n1*q12^2*q33-4*q12*q13*q33+4*n1*q12*q13*q33-4*q12*q23*q33+4*n1*q12*q23*q33-2*q12*q33^2+2*n1*q12*q33^2)+mbox1l(-1+n1,-1+n2,1+n3,n4)*prf(6*M`j'^2*n3*q13-2*n3*q12*q13-2*n3*q13^2+2*M`j'^2*n3*q23-2*n3*q13*q23+4*M`j'^2*n3*q33-2*n3*q12*q33-3*n3*q13*q33-2*n3*q23*q33-n3*q33^2,-4*M`j'^2*q13^2+4*M`j'^2*n1*q13^2-8*M`j'^2*q13*q23+8*M`j'^2*n1*q13*q23-4*M`j'^2*q23^2+4*M`j'^2*n1*q23^2+8*M`j'^2*q12*q33-8*M`j'^2*n1*q12*q33-4*q12^2*q33+4*n1*q12^2*q33-4*q12*q13*q33+4*n1*q12*q13*q33-4*q12*q23*q33+4*n1*q12*q23*q33-2*q12*q33^2+2*n1*q12*q33^2)+mbox1l(-2+n1,n2,1+n3,n4)*prf(-4*M`j'^2*n3*q12+2*n3*q12^2-8*M`j'^2*n3*q13+6*n3*q12*q13+4*n3*q13^2-4*M`j'^2*n3*q23+4*n3*q12*q23+6*n3*q13*q23+2*n3*q23^2-4*M`j'^2*n3*q33+3*n3*q12*q33+4*n3*q13*q33+3*n3*q23*q33+n3*q33^2,-4*M`j'^2*q13^2+4*M`j'^2*n1*q13^2-8*M`j'^2*q13*q23+8*M`j'^2*n1*q13*q23-4*M`j'^2*q23^2+4*M`j'^2*n1*q23^2+8*M`j'^2*q12*q33-8*M`j'^2*n1*q12*q33-4*q12^2*q33+4*n1*q12^2*q33-4*q12*q13*q33+4*n1*q12*q13*q33-4*q12*q23*q33+4*n1*q12*q23*q33-2*q12*q33^2+2*n1*q12*q33^2)+mbox1l(-1+n1,n2,1+n3,n4)*prf(4*M`j'^2*n3*q12*q13-4*n3*q12^2*q13-4*n3*q12*q13^2-4*M`j'^2*n3*q12*q23-4*M`j'^2*n3*q13*q23-4*n3*q12*q13*q23-4*M`j'^2*n3*q23^2+4*M`j'^2*n3*q12*q33-2*n3*q12^2*q33-4*n3*q12*q13*q33-2*n3*q12*q23*q33-n3*q12*q33^2,-4*M`j'^2*q13^2+4*M`j'^2*n1*q13^2-8*M`j'^2*q13*q23+8*M`j'^2*n1*q13*q23-4*M`j'^2*q23^2+4*M`j'^2*n1*q23^2+8*M`j'^2*q12*q33-8*M`j'^2*n1*q12*q33-4*q12^2*q33+4*n1*q12^2*q33-4*q12*q13*q33+4*n1*q12*q13*q33-4*q12*q23*q33+4*n1*q12*q23*q33-2*q12*q33^2+2*n1*q12*q33^2);
	Identify,ifmatch->jump mbox1l(n1?pos_,n2?pos_,n3?neg0_,n4?{,>1}) = mbox1l(n1,1+n2,n3,-1+n4)*prf(n2,-1+n4)+mbox1l(1+n1,1+n2,n3,-2+n4)*prf(-2*n2*q12,-2*q12+2*n4*q12-2*q13+2*n4*q13-2*q23+2*n4*q23-q33+n4*q33)+mbox1l(2+n1,n2,n3,-2+n4)*prf(2*q12+2*n1*q12,-2*q12+2*n4*q12-2*q13+2*n4*q13-2*q23+2*n4*q23-q33+n4*q33)+mbox1l(1+n1,-1+n2,n3,n4)*prf(q33,2*q12+2*q13+2*q23+q33)+mbox1l(2+n1,-1+n2,n3,-1+n4)*prf(-q33-n1*q33,-2*q12+2*n4*q12-2*q13+2*n4*q13-2*q23+2*n4*q23-q33+n4*q33)+mbox1l(1+n1,n2,n3,-1+n4)*prf(-4*q12-2*n1*q12+2*n4*q12-2*q13-2*n2*q13+2*n4*q13-2*q23-2*n2*q23+2*n4*q23+q33+n1*q33-n2*q33,-2*q12+2*n4*q12-2*q13+2*n4*q13-2*q23+2*n4*q23-q33+n4*q33)+mbox1l(1+n1,-1+n2,1+n3,-1+n4)*prf(-2*n3*q13-n3*q33,-2*q12+2*n4*q12-2*q13+2*n4*q13-2*q23+2*n4*q23-q33+n4*q33)+mbox1l(n1,n2,1+n3,-1+n4)*prf(2*n3*q13+n3*q33,-2*q12+2*n4*q12-2*q13+2*n4*q13-2*q23+2*n4*q23-q33+n4*q33);
	Identify,ifmatch->jump mbox1l(1,1,n3?neg_,1) = tmpprf(1,2*ep+n3)*mbox1l(1,0,n3,2)*prf(-2*M`j'^2,2*q12+2*q13+2*q23+q33)+tmpprf(1,2*ep+n3)*mbox1l(2,1,n3,0)*prf(-2*M`j'^2,2*q12+2*q13+2*q23+q33)+tmpprf(1,2*ep+n3)*mbox1l(0,2,n3,1)*prf(4*M`j'^2-2*q12-2*q13-2*q23-q33,q13+q23)+tmpprf(1,2*ep+n3)*mbox1l(1,2,n3,0)*prf(-8*M`j'^2*q12+4*q12^2-2*M`j'^2*q13+4*q12*q13-2*M`j'^2*q23+4*q12*q23+2*q12*q33,2*q12*q13+2*q13^2+2*q12*q23+4*q13*q23+2*q23^2+q13*q33+q23*q33)+tmpprf(1,2*ep+n3)*mbox1l(1,1,1+n3,0)*prf(-4*M`j'^2*n3*q12+2*n3*q12^2-2*M`j'^2*n3*q13+2*n3*q12*q13-2*M`j'^2*n3*q23+2*n3*q12*q23+n3*q12*q33,2*q12*q13+2*q13^2+2*q12*q23+4*q13*q23+2*q23^2+q13*q33+q23*q33)+tmpprf(1,2*ep+n3)*mbox1l(1,1,2+n3,0)*prf(2*M`j'^2*q12*q13+2*M`j'^2*n3*q12*q13-2*q12^2*q13-2*n3*q12^2*q13-2*M`j'^2*q12*q23-2*M`j'^2*n3*q12*q23-q12^2*q33-n3*q12^2*q33,q13^2+2*q13*q23+q23^2-2*q12*q33)+tmpprf(1,2*ep+n3)*mbox1l(1,0,1+n3,2)*prf(-4*M`j'^2*q12*q13^2-4*M`j'^2*q12*q13*q23+4*M`j'^2*q12^2*q33-2*M`j'^2*q12*q13*q33+2*M`j'^2*q12*q23*q33,-2*q12*q13^2-2*q13^3-4*q12*q13*q23-6*q13^2*q23-2*q12*q23^2-6*q13*q23^2-2*q23^3+4*q12^2*q33+4*q12*q13*q33-q13^2*q33+4*q12*q23*q33-2*q13*q23*q33-q23^2*q33+2*q12*q33^2)+mbox1l(1,1,1+n3,1)*(tmpprf(ep,2*ep+n3)*prf(4*q12*q13^2+4*q12*q13*q23-4*q12^2*q33+2*q12*q13*q33-2*q12*q23*q33,q13^2+2*q13*q23+q23^2-2*q12*q33)+tmpprf(1,2*ep+n3)*prf(2*q12*q13^2+4*n3*q12*q13^2+2*q12*q13*q23+4*n3*q12*q13*q23-2*q12^2*q33-4*n3*q12^2*q33+q12*q13*q33+2*n3*q12*q13*q33-q12*q23*q33-2*n3*q12*q23*q33,q13^2+2*q13*q23+q23^2-2*q12*q33))+tmpprf(1,2*ep+n3)*mbox1l(2,0,n3,1)*prf(-2*M`j'^2*q13-2*M`j'^2*q23-4*M`j'^2*q33+2*q12*q33+2*q13*q33+2*q23*q33+q33^2,2*q12*q13+2*q13^2+2*q12*q23+4*q13*q23+2*q23^2+q13*q33+q23*q33)+tmpprf(1,2*ep+n3)*mbox1l(0,1,1+n3,1)*prf(4*M`j'^2*n3*q12-2*n3*q12^2+8*M`j'^2*n3*q13-6*n3*q12*q13-4*n3*q13^2+4*M`j'^2*n3*q23-4*n3*q12*q23-6*n3*q13*q23-2*n3*q23^2+4*M`j'^2*n3*q33-3*n3*q12*q33-4*n3*q13*q33-3*n3*q23*q33-n3*q33^2,2*q12*q13+2*q13^2+2*q12*q23+4*q13*q23+2*q23^2+q13*q33+q23*q33)+tmpprf(1,2*ep+n3)*mbox1l(1,0,1+n3,1)*prf(-6*M`j'^2*n3*q13+2*n3*q12*q13+2*n3*q13^2-2*M`j'^2*n3*q23+2*n3*q13*q23-4*M`j'^2*n3*q33+2*n3*q12*q33+3*n3*q13*q33+2*n3*q23*q33+n3*q33^2,2*q12*q13+2*q13^2+2*q12*q23+4*q13*q23+2*q23^2+q13*q33+q23*q33)+tmpprf(1,2*ep+n3)*mbox1l(1,1,2+n3,1)*prf(-4*q12^2*q13^2-4*n3*q12^2*q13^2-8*M`j'^2*q12*q13*q23-8*M`j'^2*n3*q12*q13*q23+4*M`j'^2*q12^2*q33+4*M`j'^2*n3*q12^2*q33-4*q12^2*q13*q33-4*n3*q12^2*q13*q33-q12^2*q33^2-n3*q12^2*q33^2,q13^2+2*q13*q23+q23^2-2*q12*q33)+tmpprf(1,2*ep+n3)*mbox1l(0,2,1+n3,1)*prf(-8*M`j'^2*q12*q13^2+4*q12^2*q13^2+4*q12*q13^3-8*M`j'^2*q12*q13*q23+4*q12^2*q13*q23+8*q12*q13^2*q23+4*q12*q13*q23^2+8*M`j'^2*q12^2*q33-4*q12^3*q33-4*M`j'^2*q12*q13*q33-2*q12^2*q13*q33+4*q12*q13^2*q33+4*M`j'^2*q12*q23*q33-6*q12^2*q23*q33+2*q12*q13*q23*q33-2*q12*q23^2*q33-2*q12^2*q33^2+q12*q13*q33^2-q12*q23*q33^2,q13^3+3*q13^2*q23+3*q13*q23^2+q23^3-2*q12*q13*q33-2*q12*q23*q33)+tmpprf(1,2*ep+n3)*mbox1l(2,1,1+n3,0)*prf(8*M`j'^2*q12*q13^3+12*M`j'^2*q12*q13^2*q23-4*M`j'^2*q12*q23^3-12*M`j'^2*q12^2*q13*q33+4*q12^3*q13*q33+2*M`j'^2*q12*q13^2*q33+4*q12^2*q13^2*q33+4*M`j'^2*q12^2*q23*q33-4*q12^3*q23*q33-2*M`j'^2*q12*q23^2*q33-4*q12^2*q23^2*q33+2*q12^2*q13*q33^2-2*q12^2*q23*q33^2,2*q12*q13^3+2*q13^4+6*q12*q13^2*q23+8*q13^3*q23+6*q12*q13*q23^2+12*q13^2*q23^2+2*q12*q23^3+8*q13*q23^3+2*q23^4-4*q12^2*q13*q33-4*q12*q13^2*q33+q13^3*q33-4*q12^2*q23*q33-8*q12*q13*q23*q33+3*q13^2*q23*q33-4*q12*q23^2*q33+3*q13*q23^2*q33+q23^3*q33-2*q12*q13*q33^2-2*q12*q23*q33^2)+tmpprf(1,2*ep+n3)*mbox1l(1,2,1+n3,0)*prf(16*M`j'^2*q12^2*q13^2-8*q12^3*q13^2+4*M`j'^2*q12*q13^3-8*q12^2*q13^3+16*M`j'^2*q12^2*q13*q23-8*q12^3*q13*q23+8*M`j'^2*q12*q13^2*q23-16*q12^2*q13^2*q23+4*M`j'^2*q12*q13*q23^2-8*q12^2*q13*q23^2-16*M`j'^2*q12^3*q33+8*q12^4*q33+4*M`j'^2*q12^2*q13*q33+4*q12^3*q13*q33+2*M`j'^2*q12*q13^2*q33-8*q12^2*q13^2*q33-12*M`j'^2*q12^2*q23*q33+12*q12^3*q23*q33-4*q12^2*q13*q23*q33-2*M`j'^2*q12*q23^2*q33+4*q12^2*q23^2*q33+4*q12^3*q33^2-2*q12^2*q13*q33^2+2*q12^2*q23*q33^2,2*q12*q13^3+2*q13^4+6*q12*q13^2*q23+8*q13^3*q23+6*q12*q13*q23^2+12*q13^2*q23^2+2*q12*q23^3+8*q13*q23^3+2*q23^4-4*q12^2*q13*q33-4*q12*q13^2*q33+q13^3*q33-4*q12^2*q23*q33-8*q12*q13*q23*q33+3*q13^2*q23*q33-4*q12*q23^2*q33+3*q13*q23^2*q33+q23^3*q33-2*q12*q13*q33^2-2*q12*q23*q33^2)+tmpprf(1,2*ep+n3)*mbox1l(2,0,1+n3,1)*prf(4*M`j'^2*q12*q13^3+4*M`j'^2*q13^4+8*M`j'^2*q12*q13^2*q23+12*M`j'^2*q13^3*q23+4*M`j'^2*q12*q13*q23^2+12*M`j'^2*q13^2*q23^2+4*M`j'^2*q13*q23^3-4*M`j'^2*q12^2*q13*q33-2*M`j'^2*q12*q13^2*q33-4*M`j'^2*q12^2*q23*q33-8*M`j'^2*q12*q13*q23*q33-6*M`j'^2*q12*q23^2*q33+4*M`j'^2*q12*q13*q33^2-2*q12^2*q13*q33^2-2*q12*q13^2*q33^2-4*M`j'^2*q12*q23*q33^2+2*q12^2*q23*q33^2+2*q12*q23^2*q33^2-q12*q13*q33^3+q12*q23*q33^3,2*q12*q13^3+2*q13^4+6*q12*q13^2*q23+8*q13^3*q23+6*q12*q13*q23^2+12*q13^2*q23^2+2*q12*q23^3+8*q13*q23^3+2*q23^4-4*q12^2*q13*q33-4*q12*q13^2*q33+q13^3*q33-4*q12^2*q23*q33-8*q12*q13*q23*q33+3*q13^2*q23*q33-4*q12*q23^2*q33+3*q13*q23^2*q33+q23^3*q33-2*q12*q13*q33^2-2*q12*q23*q33^2)+tmpprf(1,2*ep+n3)*mbox1l(0,1,2+n3,1)*prf(-4*M`j'^2*q12^2*q13^2-4*M`j'^2*n3*q12^2*q13^2+4*q12^3*q13^2+4*n3*q12^3*q13^2-16*M`j'^2*q12*q13^3-16*M`j'^2*n3*q12*q13^3+12*q12^2*q13^3+12*n3*q12^2*q13^3+8*q12*q13^4+8*n3*q12*q13^4+4*q12^3*q13*q23+4*n3*q12^3*q13*q23-16*M`j'^2*q12*q13^2*q23-16*M`j'^2*n3*q12*q13^2*q23+20*q12^2*q13^2*q23+20*n3*q12^2*q13^2*q23+20*q12*q13^3*q23+20*n3*q12*q13^3*q23+4*M`j'^2*q12^2*q23^2+4*M`j'^2*n3*q12^2*q23^2+8*M`j'^2*q12*q13*q23^2+8*M`j'^2*n3*q12*q13*q23^2+8*q12^2*q13*q23^2+8*n3*q12^2*q13*q23^2+4*M`j'^2*q13^2*q23^2+4*M`j'^2*n3*q13^2*q23^2+16*q12*q13^2*q23^2+16*n3*q12*q13^2*q23^2+8*M`j'^2*q12*q23^3+8*M`j'^2*n3*q12*q23^3+8*M`j'^2*q13*q23^3+8*M`j'^2*n3*q13*q23^3+4*q12*q13*q23^3+4*n3*q12*q13*q23^3+4*M`j'^2*q23^4+4*M`j'^2*n3*q23^4+12*M`j'^2*q12^2*q13*q33+12*M`j'^2*n3*q12^2*q13*q33-6*q12^3*q13*q33-6*n3*q12^3*q13*q33-16*M`j'^2*q12*q13^2*q33-16*M`j'^2*n3*q12*q13^2*q33+4*q12^2*q13^2*q33+4*n3*q12^2*q13^2*q33+12*q12*q13^3*q33+12*n3*q12*q13^3*q33-4*M`j'^2*q12^2*q23*q33-4*M`j'^2*n3*q12^2*q23*q33+2*q12^3*q23*q33+2*n3*q12^3*q23*q33-4*M`j'^2*q12*q13*q23*q33-4*M`j'^2*n3*q12*q13*q23*q33+16*q12*q13^2*q23*q33+16*n3*q12*q13^2*q23*q33-4*M`j'^2*q12*q23^2*q33-4*M`j'^2*n3*q12*q23^2*q33+4*q12^2*q23^2*q33+4*n3*q12^2*q23^2*q33+6*q12*q13*q23^2*q33+6*n3*q12*q13*q23^2*q33+2*q12*q23^3*q33+2*n3*q12*q23^3*q33+8*M`j'^2*q12^2*q33^2+8*M`j'^2*n3*q12^2*q33^2-4*q12^3*q33^2-4*n3*q12^3*q33^2-4*M`j'^2*q12*q13*q33^2-4*M`j'^2*n3*q12*q13*q33^2-5*q12^2*q13*q33^2-5*n3*q12^2*q13*q33^2+6*q12*q13^2*q33^2+6*n3*q12*q13^2*q33^2+4*M`j'^2*q12*q23*q33^2+4*M`j'^2*n3*q12*q23*q33^2-5*q12^2*q23*q33^2-5*n3*q12^2*q23*q33^2+q12*q13*q23*q33^2+n3*q12*q13*q23*q33^2-q12*q23^2*q33^2-n3*q12*q23^2*q33^2-2*q12^2*q33^3-2*n3*q12^2*q33^3+q12*q13*q33^3+n3*q12*q13*q33^3-q12*q23*q33^3-n3*q12*q23*q33^3,2*q12*q13^3+2*q13^4+6*q12*q13^2*q23+8*q13^3*q23+6*q12*q13*q23^2+12*q13^2*q23^2+2*q12*q23^3+8*q13*q23^3+2*q23^4-4*q12^2*q13*q33-4*q12*q13^2*q33+q13^3*q33-4*q12^2*q23*q33-8*q12*q13*q23*q33+3*q13^2*q23*q33-4*q12*q23^2*q33+3*q13*q23^2*q33+q23^3*q33-2*q12*q13*q33^2-2*q12*q23*q33^2)+tmpprf(1,2*ep+n3)*mbox1l(1,0,2+n3,1)*prf(8*M`j'^2*q12*q13^3+8*M`j'^2*n3*q12*q13^3-4*q12^2*q13^3-4*n3*q12^2*q13^3-4*q12*q13^4-4*n3*q12*q13^4+8*M`j'^2*q12*q13^2*q23+8*M`j'^2*n3*q12*q13^2*q23-4*q12^2*q13^2*q23-4*n3*q12^2*q13^2*q23+4*M`j'^2*q13^3*q23+4*M`j'^2*n3*q13^3*q23-8*q12*q13^3*q23-8*n3*q12*q13^3*q23+8*M`j'^2*q13^2*q23^2+8*M`j'^2*n3*q13^2*q23^2-4*q12*q13^2*q23^2-4*n3*q12*q13^2*q23^2+4*M`j'^2*q13*q23^3+4*M`j'^2*n3*q13*q23^3-4*M`j'^2*q12^2*q13*q33-4*M`j'^2*n3*q12^2*q13*q33+10*M`j'^2*q12*q13^2*q33+10*M`j'^2*n3*q12*q13^2*q33-6*q12^2*q13^2*q33-6*n3*q12^2*q13^2*q33-8*q12*q13^3*q33-8*n3*q12*q13^3*q33-4*M`j'^2*q12^2*q23*q33-4*M`j'^2*n3*q12^2*q23*q33-12*M`j'^2*q12*q13*q23*q33-12*M`j'^2*n3*q12*q13*q23*q33+2*q12^2*q13*q23*q33+2*n3*q12^2*q13*q23*q33-6*q12*q13^2*q23*q33-6*n3*q12*q13^2*q23*q33-6*M`j'^2*q12*q23^2*q33-6*M`j'^2*n3*q12*q23^2*q33+2*q12*q13*q23^2*q33+2*n3*q12*q13*q23^2*q33+4*M`j'^2*q12*q13*q33^2+4*M`j'^2*n3*q12*q13*q33^2-2*q12^2*q13*q33^2-2*n3*q12^2*q13*q33^2-5*q12*q13^2*q33^2-5*n3*q12*q13^2*q33^2-4*M`j'^2*q12*q23*q33^2-4*M`j'^2*n3*q12*q23*q33^2+2*q12^2*q23*q33^2+2*n3*q12^2*q23*q33^2+q12*q13*q23*q33^2+n3*q12*q13*q23*q33^2+2*q12*q23^2*q33^2+2*n3*q12*q23^2*q33^2-q12*q13*q33^3-n3*q12*q13*q33^3+q12*q23*q33^3+n3*q12*q23*q33^3,2*q12*q13^3+2*q13^4+6*q12*q13^2*q23+8*q13^3*q23+6*q12*q13*q23^2+12*q13^2*q23^2+2*q12*q23^3+8*q13*q23^3+2*q23^4-4*q12^2*q13*q33-4*q12*q13^2*q33+q13^3*q33-4*q12^2*q23*q33-8*q12*q13*q23*q33+3*q13^2*q23*q33-4*q12*q23^2*q33+3*q13*q23^2*q33+q23^3*q33-2*q12*q13*q33^2-2*q12*q23*q33^2);
	Identify,ifmatch->jump mbox1l(n1?pos_,n2?pos_,n3?{,>1},n4?neg_) = mbox1l(n1,-1+n2,n3,1+n4)*prf(-4*q13-q33,2*q12)+mbox1l(-1+n1,n2,n3,1+n4)*prf(2*q12-2*q13+2*q23-q33,2*q12)+mbox1l(1+n1,-1+n2,-1+n3,1+n4)*prf(-2*n1*q13-n1*q33,-2*q12+2*n3*q12)+mbox1l(-1+n1,1+n2,-1+n3,1+n4)*prf(-2*n2*q13-n2*q33,-2*q12+2*n3*q12)+mbox1l(n1,-1+n2,-1+n3,2+n4)*prf(-2*q13-2*n4*q13+q33+n4*q33,-2*q12+2*n3*q12)+mbox1l(-1+n1,n2,-1+n3,2+n4)*prf(2*q13+2*n4*q13+q33+n4*q33,-2*q12+2*n3*q12)+mbox1l(1+n1,n2,-2+n3,1+n4)*prf(2*M`j'^2*n1*q13-2*n1*q12*q13-2*M`j'^2*n1*q23+2*M`j'^2*n1*q33-n1*q12*q33,-2*M`j'^2*q12+2*M`j'^2*n3*q12)+mbox1l(n1,1+n2,-2+n3,1+n4)*prf(6*M`j'^2*n2*q13-2*n2*q12*q13+2*M`j'^2*n2*q23+2*M`j'^2*n2*q33-n2*q12*q33,-2*M`j'^2*q12+2*M`j'^2*n3*q12)+mbox1l(n1,n2,-2+n3,2+n4)*prf(2*M`j'^2*q13+2*M`j'^2*n4*q13-2*q12*q13-2*n4*q12*q13-2*M`j'^2*q23-2*M`j'^2*n4*q23-2*M`j'^2*q33-2*M`j'^2*n4*q33-q12*q33-n4*q12*q33,-2*M`j'^2*q12+2*M`j'^2*n3*q12)+mbox1l(n1,n2,-1+n3,1+n4)*(tmpprf(ep,1)*prf(-4*q12*q13-2*q12*q33,-2*M`j'^2*q12+2*M`j'^2*n3*q12)+prf(-8*M`j'^2*q13-4*M`j'^2*n2*q13+6*M`j'^2*n3*q13-2*M`j'^2*n4*q13+10*q12*q13-2*n1*q12*q13-2*n2*q12*q13-4*n3*q12*q13-2*n4*q12*q13+4*M`j'^2*q23+2*M`j'^2*n1*q23-2*M`j'^2*n2*q23-2*M`j'^2*n3*q23+2*M`j'^2*n4*q23-2*M`j'^2*q33-M`j'^2*n1*q33-M`j'^2*n2*q33+2*M`j'^2*n3*q33+5*q12*q33-n1*q12*q33-n2*q12*q33-2*n3*q12*q33-n4*q12*q33,-2*M`j'^2*q12+2*M`j'^2*n3*q12))+mbox1l(n1,n2,-1+n3,2+n4)*prf(-4*q12*q13^2-4*n4*q12*q13^2-8*M`j'^2*q13*q23-8*M`j'^2*n4*q13*q23+4*M`j'^2*q12*q33+4*M`j'^2*n4*q12*q33-4*q12*q13*q33-4*n4*q12*q13*q33-q12*q33^2-n4*q12*q33^2,-2*M`j'^2*q12+2*M`j'^2*n3*q12);
	Identify,ifmatch->jump mbox1l(n1?pos_,n2?{,>1},n3?pos_,n4?neg_) = mbox1l(n1,n2,-1+n3,1+n4)*prf(-2*q13-2*q23-q33,2*q12)+mbox1l(1+n1,-1+n2,-1+n3,1+n4)*prf(-(n1*q33),-2*q12+2*n2*q12)+mbox1l(-1+n1,n2,n3,1+n4)*prf(2*q12+2*q13+2*q23+q33,2*q12)+mbox1l(n1,-1+n2,n3,1+n4)*prf(2*q13-2*n3*q13+2*n4*q13+n1*q33-n3*q33,-2*q12+2*n2*q12)+mbox1l(-1+n1,-1+n2,1+n3,1+n4)*prf(2*n3*q13+n3*q33,-2*q12+2*n2*q12)+mbox1l(-1+n1,-1+n2,n3,2+n4)*prf(-2*q13-2*n4*q13-q33-n4*q33,-2*q12+2*n2*q12)+mbox1l(n1,-1+n2,-1+n3,2+n4)*prf(q33+n4*q33,-2*q12+2*n2*q12);
	Identify,ifmatch->jump mbox1l(n1?{,>1},n2?pos_,n3?pos_,n4?neg_) = mbox1l(-2+n1,n2,n3,2+n4)*prf(q12+n4*q12+q23+n4*q23,-q12+n1*q12)+mbox1l(n1,n2,-1+n3,1+n4)*prf(-q33,2*q12)+mbox1l(n1,-1+n2,n3,1+n4)*prf(q33,2*q12)+mbox1l(-1+n1,1+n2,-1+n3,1+n4)*prf(-2*n2*q13-2*n2*q23-n2*q33,-2*q12+2*n1*q12)+mbox1l(-1+n1,n2,n3,1+n4)*prf(-4*q12+2*n1*q12-2*n4*q12+2*n2*q13-2*n3*q13-2*q23+2*n2*q23-2*n4*q23+n2*q33-n3*q33,-2*q12+2*n1*q12)+mbox1l(-1+n1,-1+n2,1+n3,1+n4)*prf(2*n3*q13+n3*q33,-2*q12+2*n1*q12)+mbox1l(-1+n1,-1+n2,n3,2+n4)*prf(-q33-n4*q33,-2*q12+2*n1*q12)+mbox1l(-1+n1,n2,-1+n3,2+n4)*prf(q33+n4*q33,-2*q12+2*n1*q12);
	Identify,ifmatch->jump mbox1l(n1?pos_,n2?pos_,n3?{,>1},n4?neg0_) = mbox1l(-1+n1,n2,n3,n4)*prf(1,2*q12)+mbox1l(n1,-1+n2,n3,n4)*prf(1,2*q12)+mbox1l(1+n1,-1+n2,-1+n3,n4)*prf(n1,-2*q12+2*n3*q12)+mbox1l(-1+n1,1+n2,-1+n3,n4)*prf(n2,-2*q12+2*n3*q12)+mbox1l(-1+n1,n2,-1+n3,1+n4)*prf(n4,-2*q12+2*n3*q12)+mbox1l(n1,-1+n2,-1+n3,1+n4)*prf(n4,-2*q12+2*n3*q12)+mbox1l(1+n1,n2,-2+n3,n4)*prf(-2*M`j'^2*n1+n1*q12,-2*M`j'^2*q12+2*M`j'^2*n3*q12)+mbox1l(n1,1+n2,-2+n3,n4)*prf(-2*M`j'^2*n2+n2*q12,-2*M`j'^2*q12+2*M`j'^2*n3*q12)+mbox1l(n1,n2,-2+n3,1+n4)*prf(-2*M`j'^2*n4+n4*q12,-2*M`j'^2*q12+2*M`j'^2*n3*q12)+mbox1l(n1,n2,-1+n3,n4)*(tmpprf(ep,1)*prf(1,-M`j'^2+M`j'^2*n3)+prf(2*M`j'^2+M`j'^2*n1+M`j'^2*n2-2*M`j'^2*n3-6*q12+n1*q12+n2*q12+2*n3*q12+n4*q12,-2*M`j'^2*q12+2*M`j'^2*n3*q12))+mbox1l(n1,n2,-1+n3,1+n4)*prf(-2*M`j'^2*n4*q13+2*n4*q12*q13+2*M`j'^2*n4*q23+n4*q12*q33,-2*M`j'^2*q12+2*M`j'^2*n3*q12);
	Identify,ifmatch->jump mbox1l(n1?pos_,n2?{,>1},n3?pos_,n4?neg0_) = mbox1l(-1+n1,n2,n3,n4)*prf(-1,2*q12)+mbox1l(n1,n2,-1+n3,n4)*prf(1,2*q12)+mbox1l(1+n1,-1+n2,-1+n3,n4)*prf(n1,-2*q12+2*n2*q12)+mbox1l(-1+n1,-1+n2,1+n3,n4)*prf(-n3,-2*q12+2*n2*q12)+mbox1l(n1,-1+n2,n3,n4)*prf(-n1+n3,-2*q12+2*n2*q12)+mbox1l(-1+n1,-1+n2,n3,1+n4)*prf(-n4,-2*q12+2*n2*q12)+mbox1l(n1,-1+n2,-1+n3,1+n4)*prf(n4,-2*q12+2*n2*q12)+mbox1l(n1,-1+n2,n3,1+n4)*prf(n4*q13,-q12+n2*q12);
	Identify,ifmatch->jump mbox1l(n1?{,>1},n2?pos_,n3?pos_,n4?neg0_) = mbox1l(n1,-1+n2,n3,n4)*prf(-1,2*q12)+mbox1l(n1,n2,-1+n3,n4)*prf(1,2*q12)+mbox1l(-1+n1,1+n2,-1+n3,n4)*prf(n2,-2*q12+2*n1*q12)+mbox1l(-1+n1,-1+n2,1+n3,n4)*prf(-n3,-2*q12+2*n1*q12)+mbox1l(-1+n1,n2,n3,n4)*prf(-n2+n3,-2*q12+2*n1*q12)+mbox1l(-1+n1,-1+n2,n3,1+n4)*prf(-n4,-2*q12+2*n1*q12)+mbox1l(-1+n1,n2,-1+n3,1+n4)*prf(n4,-2*q12+2*n1*q12)+mbox1l(-1+n1,n2,n3,1+n4)*prf(-(n4*q12)-n4*q23,-q12+n1*q12);
	If (Match(mbox1l(n1?!{n2?},n2?!{n1?},n3?,n4?)));
	Identify,ifmatch->jump mbox1l(n1?pos_,n2?pos_,n3?pos_,n4?neg0_) = mbox1l(1+n1,n2,-1+n3,n4)*prf(n1,n1-n2)+mbox1l(n1,1+n2,-1+n3,n4)*prf(-n2,n1-n2)+mbox1l(n1,-1+n2,n3,1+n4)*prf(-(n4*q13),n1*q12-n2*q12)+mbox1l(-1+n1,n2,n3,1+n4)*prf(-(n4*q12)-n4*q23,n1*q12-n2*q12)+mbox1l(n1,n2,-1+n3,1+n4)*prf(n4*q12+n4*q13+n4*q23,n1*q12-n2*q12);
	EndIf;
	Identify,ifmatch->jump mbox1l(1,1,1,n4?neg_) = tmpprf(1,2*ep+n4)*mbox1l(0,1,2,n4)*prf(-M`j'^2,q12)+tmpprf(1,2*ep+n4)*mbox1l(0,2,1,n4)*prf(-M`j'^2,q12)+tmpprf(1,2*ep+n4)*mbox1l(1,0,2,n4)*prf(-M`j'^2,q12)+tmpprf(1,2*ep+n4)*mbox1l(2,0,1,n4)*prf(-M`j'^2,q12)+tmpprf(1,2*ep+n4)*mbox1l(0,1,1,1+n4)*prf(-(M`j'^2*n4),q12)+tmpprf(1,2*ep+n4)*mbox1l(1,0,1,1+n4)*prf(-(M`j'^2*n4),q12)+tmpprf(1,2*ep+n4)*mbox1l(1,2,0,n4)*prf(2*M`j'^2-q12,q12)+tmpprf(1,2*ep+n4)*mbox1l(2,1,0,n4)*prf(2*M`j'^2-q12,q12)+tmpprf(1,2*ep+n4)*mbox1l(1,1,0,1+n4)*prf(2*M`j'^2*n4-n4*q12,q12)+tmpprf(1,2*ep+n4)*mbox1l(1,0,2,1+n4)*prf(-4*M`j'^2*q13-M`j'^2*q33,q12)+tmpprf(1,2*ep+n4)*mbox1l(0,2,1,1+n4)*prf(-2*M`j'^2*q13-M`j'^2*q33,q12)+tmpprf(1,2*ep+n4)*mbox1l(2,0,1,1+n4)*prf(-2*M`j'^2*q13-M`j'^2*q33,q12)+tmpprf(1,2*ep+n4)*mbox1l(0,1,2,1+n4)*prf(2*M`j'^2*q12-2*M`j'^2*q13+2*M`j'^2*q23-M`j'^2*q33,q12)+mbox1l(1,1,1,1+n4)*(tmpprf(ep,2*ep+n4)*prf(-4*q13-2*q33,1)+tmpprf(1,2*ep+n4)*prf(-2*q13-4*n4*q13-q33-2*n4*q33,1))+tmpprf(1,2*ep+n4)*mbox1l(1,0,1,2+n4)*prf(-2*M`j'^2*q13-2*M`j'^2*n4*q13+M`j'^2*q33+M`j'^2*n4*q33,q12)+tmpprf(1,2*ep+n4)*mbox1l(0,1,1,2+n4)*prf(2*M`j'^2*q13+2*M`j'^2*n4*q13+M`j'^2*q33+M`j'^2*n4*q33,q12)+tmpprf(1,2*ep+n4)*mbox1l(2,1,0,1+n4)*prf(2*M`j'^2*q13-2*q12*q13-2*M`j'^2*q23+2*M`j'^2*q33-q12*q33,q12)+tmpprf(1,2*ep+n4)*mbox1l(1,2,0,1+n4)*prf(6*M`j'^2*q13-2*q12*q13+2*M`j'^2*q23+2*M`j'^2*q33-q12*q33,q12)+tmpprf(1,2*ep+n4)*mbox1l(1,1,0,2+n4)*prf(2*M`j'^2*q13+2*M`j'^2*n4*q13-2*q12*q13-2*n4*q12*q13-2*M`j'^2*q23-2*M`j'^2*n4*q23-2*M`j'^2*q33-2*M`j'^2*n4*q33-q12*q33-n4*q12*q33,q12)+tmpprf(1,2*ep+n4)*mbox1l(1,1,1,2+n4)*prf(-4*q12*q13^2-4*n4*q12*q13^2-8*M`j'^2*q13*q23-8*M`j'^2*n4*q13*q23+4*M`j'^2*q12*q33+4*M`j'^2*n4*q12*q33-4*q12*q13*q33-4*n4*q12*q13*q33-q12*q33^2-n4*q12*q33^2,q12);
	Identify,ifmatch->jump mbox1l(n1?pos_,n2?pos_,n3?pos_,n4?{,>1}) = mbox1l(n1,n2,1+n3,-2+n4)*prf(-2*M`j'^2*n3*q12,-4*q12*q13^2+4*n4*q12*q13^2-8*M`j'^2*q13*q23+8*M`j'^2*n4*q13*q23+4*M`j'^2*q12*q33-4*M`j'^2*n4*q12*q33-4*q12*q13*q33+4*n4*q12*q13*q33-q12*q33^2+n4*q12*q33^2)+mbox1l(n1,-1+n2,1+n3,-1+n4)*prf(-8*M`j'^2*n3*q13,-4*q12*q13^2+4*n4*q12*q13^2-8*M`j'^2*q13*q23+8*M`j'^2*n4*q13*q23+4*M`j'^2*q12*q33-4*M`j'^2*n4*q12*q33-4*q12*q13*q33+4*n4*q12*q13*q33-q12*q33^2+n4*q12*q33^2)+mbox1l(-1+n1,1+n2,n3,-1+n4)*prf(-4*M`j'^2*n2*q12^2-8*M`j'^2*n2*q12*q23-4*M`j'^2*n2*q23^2,-8*q12*q13^3+8*n4*q12*q13^3-16*M`j'^2*q13^2*q23+16*M`j'^2*n4*q13^2*q23+8*M`j'^2*q12*q13*q33-8*M`j'^2*n4*q12*q13*q33-12*q12*q13^2*q33+12*n4*q12*q13^2*q33-8*M`j'^2*q13*q23*q33+8*M`j'^2*n4*q13*q23*q33+4*M`j'^2*q12*q33^2-4*M`j'^2*n4*q12*q33^2-6*q12*q13*q33^2+6*n4*q12*q13*q33^2-q12*q33^3+n4*q12*q33^3)+mbox1l(1+n1,n2,n3,-2+n4)*prf(8*M`j'^2*n1*q12*q13-2*M`j'^2*n1*q12*q33,-8*q12*q13^3+8*n4*q12*q13^3-16*M`j'^2*q13^2*q23+16*M`j'^2*n4*q13^2*q23+8*M`j'^2*q12*q13*q33-8*M`j'^2*n4*q12*q13*q33-12*q12*q13^2*q33+12*n4*q12*q13^2*q33-8*M`j'^2*q13*q23*q33+8*M`j'^2*n4*q13*q23*q33+4*M`j'^2*q12*q33^2-4*M`j'^2*n4*q12*q33^2-6*q12*q13*q33^2+6*n4*q12*q13*q33^2-q12*q33^3+n4*q12*q33^3)+mbox1l(n1,1+n2,n3,-2+n4)*prf(4*M`j'^2*n2*q12^2-4*M`j'^2*n2*q12*q13+4*M`j'^2*n2*q12*q23-2*M`j'^2*n2*q12*q33,-8*q12*q13^3+8*n4*q12*q13^3-16*M`j'^2*q13^2*q23+16*M`j'^2*n4*q13^2*q23+8*M`j'^2*q12*q13*q33-8*M`j'^2*n4*q12*q13*q33-12*q12*q13^2*q33+12*n4*q12*q13^2*q33-8*M`j'^2*q13*q23*q33+8*M`j'^2*n4*q13*q23*q33+4*M`j'^2*q12*q33^2-4*M`j'^2*n4*q12*q33^2-6*q12*q13*q33^2+6*n4*q12*q13*q33^2-q12*q33^3+n4*q12*q33^3)+mbox1l(1+n1,-1+n2,n3,-1+n4)*prf(-4*M`j'^2*n1*q13^2-8*M`j'^2*n1*q13*q33,-8*q12*q13^3+8*n4*q12*q13^3-16*M`j'^2*q13^2*q23+16*M`j'^2*n4*q13^2*q23+8*M`j'^2*q12*q13*q33-8*M`j'^2*n4*q12*q13*q33-12*q12*q13^2*q33+12*n4*q12*q13^2*q33-8*M`j'^2*q13*q23*q33+8*M`j'^2*n4*q13*q23*q33+4*M`j'^2*q12*q33^2-4*M`j'^2*n4*q12*q33^2-6*q12*q13*q33^2+6*n4*q12*q13*q33^2-q12*q33^3+n4*q12*q33^3)+mbox1l(n1,n2,-1+n3,n4)*prf(-4*M`j'^2*q12*q13-4*q12*q13^2-8*M`j'^2*q13*q23+2*M`j'^2*q12*q33-4*q12*q13*q33-q12*q33^2,8*q12*q13^3+16*M`j'^2*q13^2*q23-8*M`j'^2*q12*q13*q33+12*q12*q13^2*q33+8*M`j'^2*q13*q23*q33-4*M`j'^2*q12*q33^2+6*q12*q13*q33^2+q12*q33^3)+mbox1l(1+n1,n2,-1+n3,-1+n4)*prf(-4*M`j'^2*n1*q12*q13+4*M`j'^2*n1*q13^2-4*n1*q12*q13^2-4*M`j'^2*n1*q13*q23+6*M`j'^2*n1*q12*q33+8*M`j'^2*n1*q13*q33-4*n1*q12*q13*q33-n1*q12*q33^2,-8*q12*q13^3+8*n4*q12*q13^3-16*M`j'^2*q13^2*q23+16*M`j'^2*n4*q13^2*q23+8*M`j'^2*q12*q13*q33-8*M`j'^2*n4*q12*q13*q33-12*q12*q13^2*q33+12*n4*q12*q13^2*q33-8*M`j'^2*q13*q23*q33+8*M`j'^2*n4*q13*q23*q33+4*M`j'^2*q12*q33^2-4*M`j'^2*n4*q12*q33^2-6*q12*q13*q33^2+6*n4*q12*q13*q33^2-q12*q33^3+n4*q12*q33^3)+mbox1l(n1,1+n2,-1+n3,-1+n4)*prf(8*M`j'^2*n2*q12*q13+16*M`j'^2*n2*q13^2-4*n2*q12*q13^2+4*M`j'^2*n2*q12*q23+12*M`j'^2*n2*q13*q23+4*M`j'^2*n2*q23^2-2*M`j'^2*n2*q12*q33+8*M`j'^2*n2*q13*q33-4*n2*q12*q13*q33-n2*q12*q33^2,-8*q12*q13^3+8*n4*q12*q13^3-16*M`j'^2*q13^2*q23+16*M`j'^2*n4*q13^2*q23+8*M`j'^2*q12*q13*q33-8*M`j'^2*n4*q12*q13*q33-12*q12*q13^2*q33+12*n4*q12*q13^2*q33-8*M`j'^2*q13*q23*q33+8*M`j'^2*n4*q13*q23*q33+4*M`j'^2*q12*q33^2-4*M`j'^2*n4*q12*q33^2-6*q12*q13*q33^2+6*n4*q12*q13*q33^2-q12*q33^3+n4*q12*q33^3)+mbox1l(n1,n2,n3,-1+n4)*(tmpprf(ep,1)*prf(-8*q12*q13^2-8*q12*q13*q33-2*q12*q33^2,-8*q12*q13^3+8*n4*q12*q13^3-16*M`j'^2*q13^2*q23+16*M`j'^2*n4*q13^2*q23+8*M`j'^2*q12*q13*q33-8*M`j'^2*n4*q12*q13*q33-12*q12*q13^2*q33+12*n4*q12*q13^2*q33-8*M`j'^2*q13*q23*q33+8*M`j'^2*n4*q13*q23*q33+4*M`j'^2*q12*q33^2-4*M`j'^2*n4*q12*q33^2-6*q12*q13*q33^2+6*n4*q12*q13*q33^2-q12*q33^3+n4*q12*q33^3)+prf(-4*M`j'^2*q12*q13-4*M`j'^2*n1*q12*q13-4*M`j'^2*n2*q12*q13+4*M`j'^2*n3*q12*q13+4*M`j'^2*n4*q12*q13-16*M`j'^2*n2*q13^2+16*M`j'^2*n3*q13^2+20*q12*q13^2-4*n1*q12*q13^2-4*n2*q12*q13^2-8*n3*q12*q13^2-4*n4*q12*q13^2-8*M`j'^2*q13*q23+4*M`j'^2*n1*q13*q23-12*M`j'^2*n2*q13*q23+8*M`j'^2*n4*q13*q23+2*M`j'^2*q12*q33-4*M`j'^2*n1*q12*q33+4*M`j'^2*n2*q12*q33+2*M`j'^2*n3*q12*q33-2*M`j'^2*n4*q12*q33-8*M`j'^2*n2*q13*q33+8*M`j'^2*n3*q13*q33+20*q12*q13*q33-4*n1*q12*q13*q33-4*n2*q12*q13*q33-8*n3*q12*q13*q33-4*n4*q12*q13*q33+5*q12*q33^2-n1*q12*q33^2-n2*q12*q33^2-2*n3*q12*q33^2-n4*q12*q33^2,-8*q12*q13^3+8*n4*q12*q13^3-16*M`j'^2*q13^2*q23+16*M`j'^2*n4*q13^2*q23+8*M`j'^2*q12*q13*q33-8*M`j'^2*n4*q12*q13*q33-12*q12*q13^2*q33+12*n4*q12*q13^2*q33-8*M`j'^2*q13*q23*q33+8*M`j'^2*n4*q13*q23*q33+4*M`j'^2*q12*q33^2-4*M`j'^2*n4*q12*q33^2-6*q12*q13*q33^2+6*n4*q12*q13*q33^2-q12*q33^3+n4*q12*q33^3));
	Identify,ifmatch->jump mbox1l(n1?pos_,n2?pos_,n3?{,>1},n4?pos_) = mbox1l(n1,n2,n3,-1+n4)*prf(2*M`j'^2*q13-2*q12*q13-2*M`j'^2*q23-q12*q33,4*q12*q13^2+8*M`j'^2*q13*q23-4*M`j'^2*q12*q33+4*q12*q13*q33+q12*q33^2)+mbox1l(n1,n2,-2+n3,1+n4)*prf(4*M`j'^2*n4*q13^2+4*M`j'^2*n4*q13*q23-4*M`j'^2*n4*q12*q33+2*M`j'^2*n4*q13*q33-2*M`j'^2*n4*q23*q33,-8*q12*q13^3+8*n3*q12*q13^3-16*M`j'^2*q13^2*q23+16*M`j'^2*n3*q13^2*q23+8*M`j'^2*q12*q13*q33-8*M`j'^2*n3*q12*q13*q33-12*q12*q13^2*q33+12*n3*q12*q13^2*q33-8*M`j'^2*q13*q23*q33+8*M`j'^2*n3*q13*q23*q33+4*M`j'^2*q12*q33^2-4*M`j'^2*n3*q12*q33^2-6*q12*q13*q33^2+6*n3*q12*q13*q33^2-q12*q33^3+n3*q12*q33^3)+mbox1l(n1,1+n2,-1+n3,-1+n4)*prf(-4*M`j'^2*n2*q12*q13+4*n2*q12^2*q13+4*M`j'^2*n2*q13^2+4*M`j'^2*n2*q12*q23+4*n2*q12*q13*q23+4*M`j'^2*n2*q23^2-4*M`j'^2*n2*q12*q33+2*n2*q12^2*q33+2*M`j'^2*n2*q13*q33-2*M`j'^2*n2*q23*q33+2*n2*q12*q23*q33,-8*q12*q13^3+8*n3*q12*q13^3-16*M`j'^2*q13^2*q23+16*M`j'^2*n3*q13^2*q23+8*M`j'^2*q12*q13*q33-8*M`j'^2*n3*q12*q13*q33-12*q12*q13^2*q33+12*n3*q12*q13^2*q33-8*M`j'^2*q13*q23*q33+8*M`j'^2*n3*q13*q23*q33+4*M`j'^2*q12*q33^2-4*M`j'^2*n3*q12*q33^2-6*q12*q13*q33^2+6*n3*q12*q13*q33^2-q12*q33^3+n3*q12*q33^3)+mbox1l(n1,-1+n2,n3,n4)*prf(8*M`j'^2*q13^2-4*q12*q13^2-4*q13^3-4*q13^2*q23-4*M`j'^2*q12*q33+4*M`j'^2*q13*q33-4*q13^2*q33-4*M`j'^2*q23*q33+q12*q33^2-q13*q33^2+q23*q33^2,4*q12^2*q13^2+8*M`j'^2*q12*q13*q23+4*q12*q13^2*q23+8*M`j'^2*q13*q23^2-4*M`j'^2*q12^2*q33+4*q12^2*q13*q33-4*M`j'^2*q12*q23*q33+4*q12*q13*q23*q33+q12^2*q33^2+q12*q23*q33^2)+mbox1l(1+n1,n2,-1+n3,-1+n4)*prf(-8*M`j'^2*n1*q12*q13^2+4*n1*q12^2*q13^2+8*n1*q12*q13^3+8*M`j'^2*n1*q13^2*q23+4*n1*q12*q13^2*q23+4*M`j'^2*n1*q12^2*q33-6*M`j'^2*n1*q12*q13*q33-2*n1*q12^2*q13*q33+8*n1*q12*q13^2*q33+2*M`j'^2*n1*q12*q23*q33+2*M`j'^2*n1*q13*q23*q33-2*n1*q12*q13*q23*q33-2*M`j'^2*n1*q23^2*q33-2*n1*q12^2*q33^2+2*n1*q12*q13*q33^2-2*n1*q12*q23*q33^2,-8*q12^2*q13^3+8*n3*q12^2*q13^3-16*M`j'^2*q12*q13^2*q23+16*M`j'^2*n3*q12*q13^2*q23-8*q12*q13^3*q23+8*n3*q12*q13^3*q23-16*M`j'^2*q13^2*q23^2+16*M`j'^2*n3*q13^2*q23^2+8*M`j'^2*q12^2*q13*q33-8*M`j'^2*n3*q12^2*q13*q33-12*q12^2*q13^2*q33+12*n3*q12^2*q13^2*q33-12*q12*q13^2*q23*q33+12*n3*q12*q13^2*q23*q33-8*M`j'^2*q13*q23^2*q33+8*M`j'^2*n3*q13*q23^2*q33+4*M`j'^2*q12^2*q33^2-4*M`j'^2*n3*q12^2*q33^2-6*q12^2*q13*q33^2+6*n3*q12^2*q13*q33^2+4*M`j'^2*q12*q23*q33^2-4*M`j'^2*n3*q12*q23*q33^2-6*q12*q13*q23*q33^2+6*n3*q12*q13*q23*q33^2-q12^2*q33^3+n3*q12^2*q33^3-q12*q23*q33^3+n3*q12*q23*q33^3)+mbox1l(-1+n1,1+n2,-1+n3,n4)*prf(4*M`j'^2*n2*q12^2*q13-4*n2*q12^3*q13-4*n2*q12^2*q13^2-4*M`j'^2*n2*q12^2*q23-8*n2*q12^2*q13*q23-4*n2*q12*q13^2*q23-8*M`j'^2*n2*q12*q23^2-4*M`j'^2*n2*q13*q23^2-4*n2*q12*q13*q23^2-4*M`j'^2*n2*q23^3+4*M`j'^2*n2*q12^2*q33-2*n2*q12^3*q33-4*n2*q12^2*q13*q33+4*M`j'^2*n2*q12*q23*q33-4*n2*q12^2*q23*q33-4*n2*q12*q13*q23*q33-2*n2*q12*q23^2*q33-n2*q12^2*q33^2-n2*q12*q23*q33^2,-8*q12^2*q13^3+8*n3*q12^2*q13^3-16*M`j'^2*q12*q13^2*q23+16*M`j'^2*n3*q12*q13^2*q23+8*M`j'^2*q12^2*q13*q33-8*M`j'^2*n3*q12^2*q13*q33-12*q12^2*q13^2*q33+12*n3*q12^2*q13^2*q33-8*M`j'^2*q12*q13*q23*q33+8*M`j'^2*n3*q12*q13*q23*q33+4*M`j'^2*q12^2*q33^2-4*M`j'^2*n3*q12^2*q33^2-6*q12^2*q13*q33^2+6*n3*q12^2*q13*q33^2-q12^2*q33^3+n3*q12^2*q33^3)+mbox1l(1+n1,n2,-2+n3,n4)*prf(4*M`j'^2*n1*q12^2*q13^2-4*M`j'^2*n1*q12*q13^3+4*M`j'^2*n1*q12^2*q13*q23-4*M`j'^2*n1*q12*q13^2*q23-4*M`j'^2*n1*q13^3*q23-8*M`j'^2*n1*q13^2*q23^2-4*M`j'^2*n1*q13*q23^3-4*M`j'^2*n1*q12^3*q33+2*M`j'^2*n1*q12^2*q13*q33+4*n1*q12^3*q13*q33-8*M`j'^2*n1*q12*q13^2*q33+6*n1*q12^2*q13^2*q33+4*n1*q12*q13^3*q33+2*M`j'^2*n1*q12^2*q23*q33+10*M`j'^2*n1*q12*q13*q23*q33+2*n1*q12^2*q13*q23*q33+2*n1*q12*q13^2*q23*q33+6*M`j'^2*n1*q12*q23^2*q33-2*n1*q12*q13*q23^2*q33+2*n1*q12^3*q33^2-4*M`j'^2*n1*q12*q13*q33^2+3*n1*q12^2*q13*q33^2+4*n1*q12*q13^2*q33^2+4*M`j'^2*n1*q12*q23*q33^2+n1*q12^2*q23*q33^2-n1*q12*q13*q23*q33^2-n1*q12*q23^2*q33^2+n1*q12*q13*q33^3-n1*q12*q23*q33^3,-8*q12^3*q13^3+8*n3*q12^3*q13^3-16*M`j'^2*q12^2*q13^2*q23+16*M`j'^2*n3*q12^2*q13^2*q23-8*q12^2*q13^3*q23+8*n3*q12^2*q13^3*q23-16*M`j'^2*q12*q13^2*q23^2+16*M`j'^2*n3*q12*q13^2*q23^2+8*M`j'^2*q12^3*q13*q33-8*M`j'^2*n3*q12^3*q13*q33-12*q12^3*q13^2*q33+12*n3*q12^3*q13^2*q33-12*q12^2*q13^2*q23*q33+12*n3*q12^2*q13^2*q23*q33-8*M`j'^2*q12*q13*q23^2*q33+8*M`j'^2*n3*q12*q13*q23^2*q33+4*M`j'^2*q12^3*q33^2-4*M`j'^2*n3*q12^3*q33^2-6*q12^3*q13*q33^2+6*n3*q12^3*q13*q33^2+4*M`j'^2*q12^2*q23*q33^2-4*M`j'^2*n3*q12^2*q23*q33^2-6*q12^2*q13*q23*q33^2+6*n3*q12^2*q13*q23*q33^2-q12^3*q33^3+n3*q12^3*q33^3-q12^2*q23*q33^3+n3*q12^2*q23*q33^3)+mbox1l(1+n1,-1+n2,-1+n3,n4)*prf(4*M`j'^2*n1*q12*q13^3+4*M`j'^2*n1*q12*q13^2*q23+4*M`j'^2*n1*q13^3*q23+4*M`j'^2*n1*q13^2*q23^2-4*M`j'^2*n1*q12^2*q13*q33+8*M`j'^2*n1*q12*q13^2*q33-2*n1*q12^2*q13^2*q33-4*n1*q12*q13^3*q33-4*M`j'^2*n1*q12*q13*q23*q33-2*n1*q12*q13^2*q23*q33-4*M`j'^2*n1*q12^2*q33^2+4*M`j'^2*n1*q12*q13*q33^2+n1*q12^2*q13*q33^2-4*n1*q12*q13^2*q33^2-4*M`j'^2*n1*q12*q23*q33^2+n1*q12*q13*q23*q33^2+n1*q12^2*q33^3-n1*q12*q13*q33^3+n1*q12*q23*q33^3,-8*q12^3*q13^3+8*n3*q12^3*q13^3-16*M`j'^2*q12^2*q13^2*q23+16*M`j'^2*n3*q12^2*q13^2*q23-8*q12^2*q13^3*q23+8*n3*q12^2*q13^3*q23-16*M`j'^2*q12*q13^2*q23^2+16*M`j'^2*n3*q12*q13^2*q23^2+8*M`j'^2*q12^3*q13*q33-8*M`j'^2*n3*q12^3*q13*q33-12*q12^3*q13^2*q33+12*n3*q12^3*q13^2*q33-12*q12^2*q13^2*q23*q33+12*n3*q12^2*q13^2*q23*q33-8*M`j'^2*q12*q13*q23^2*q33+8*M`j'^2*n3*q12*q13*q23^2*q33+4*M`j'^2*q12^3*q33^2-4*M`j'^2*n3*q12^3*q33^2-6*q12^3*q13*q33^2+6*n3*q12^3*q13*q33^2+4*M`j'^2*q12^2*q23*q33^2-4*M`j'^2*n3*q12^2*q23*q33^2-6*q12^2*q13*q23*q33^2+6*n3*q12^2*q13*q23*q33^2-q12^3*q33^3+n3*q12^3*q33^3-q12^2*q23*q33^3+n3*q12^2*q23*q33^3)+mbox1l(n1,1+n2,-2+n3,n4)*prf(-8*M`j'^2*n2*q12^2*q13^2+4*n2*q12^3*q13^2-16*M`j'^2*n2*q12*q13^3+12*n2*q12^2*q13^3+8*n2*q12*q13^4-4*M`j'^2*n2*q12^2*q13*q23+4*n2*q12^3*q13*q23-20*M`j'^2*n2*q12*q13^2*q23+20*n2*q12^2*q13^2*q23+20*n2*q12*q13^3*q23+4*M`j'^2*n2*q12^2*q23^2+4*M`j'^2*n2*q12*q13*q23^2+8*n2*q12^2*q13*q23^2+4*M`j'^2*n2*q13^2*q23^2+16*n2*q12*q13^2*q23^2+8*M`j'^2*n2*q12*q23^3+8*M`j'^2*n2*q13*q23^3+4*n2*q12*q13*q23^3+4*M`j'^2*n2*q23^4+4*M`j'^2*n2*q12^3*q33+10*M`j'^2*n2*q12^2*q13*q33-6*n2*q12^3*q13*q33-16*M`j'^2*n2*q12*q13^2*q33+4*n2*q12^2*q13^2*q33+12*n2*q12*q13^3*q33+2*M`j'^2*n2*q12^2*q23*q33+2*n2*q12^3*q23*q33-6*M`j'^2*n2*q12*q13*q23*q33+16*n2*q12*q13^2*q23*q33-2*M`j'^2*n2*q12*q23^2*q33+4*n2*q12^2*q23^2*q33+6*n2*q12*q13*q23^2*q33+2*n2*q12*q23^3*q33+8*M`j'^2*n2*q12^2*q33^2-4*n2*q12^3*q33^2-4*M`j'^2*n2*q12*q13*q33^2-5*n2*q12^2*q13*q33^2+6*n2*q12*q13^2*q33^2+4*M`j'^2*n2*q12*q23*q33^2-5*n2*q12^2*q23*q33^2+n2*q12*q13*q23*q33^2-n2*q12*q23^2*q33^2-2*n2*q12^2*q33^3+n2*q12*q13*q33^3-n2*q12*q23*q33^3,-8*q12^3*q13^3+8*n3*q12^3*q13^3-16*M`j'^2*q12^2*q13^2*q23+16*M`j'^2*n3*q12^2*q13^2*q23-8*q12^2*q13^3*q23+8*n3*q12^2*q13^3*q23-16*M`j'^2*q12*q13^2*q23^2+16*M`j'^2*n3*q12*q13^2*q23^2+8*M`j'^2*q12^3*q13*q33-8*M`j'^2*n3*q12^3*q13*q33-12*q12^3*q13^2*q33+12*n3*q12^3*q13^2*q33-12*q12^2*q13^2*q23*q33+12*n3*q12^2*q13^2*q23*q33-8*M`j'^2*q12*q13*q23^2*q33+8*M`j'^2*n3*q12*q13*q23^2*q33+4*M`j'^2*q12^3*q33^2-4*M`j'^2*n3*q12^3*q33^2-6*q12^3*q13*q33^2+6*n3*q12^3*q13*q33^2+4*M`j'^2*q12^2*q23*q33^2-4*M`j'^2*n3*q12^2*q23*q33^2-6*q12^2*q13*q23*q33^2+6*n3*q12^2*q13*q23*q33^2-q12^3*q33^3+n3*q12^3*q33^3-q12^2*q23*q33^3+n3*q12^2*q23*q33^3)+mbox1l(n1,n2,-1+n3,n4)*(tmpprf(ep,1)*prf(8*q12^2*q13^3+8*q12^2*q13^2*q23+8*q12*q13^3*q23+8*q12*q13^2*q23^2-8*q12^3*q13*q33+8*q12^2*q13^2*q33-8*q12^2*q13*q23*q33+8*q12*q13^2*q23*q33-4*q12^3*q33^2+2*q12^2*q13*q33^2-6*q12^2*q23*q33^2+2*q12*q13*q23*q33^2-2*q12*q23^2*q33^2,-8*q12^3*q13^3+8*n3*q12^3*q13^3-16*M`j'^2*q12^2*q13^2*q23+16*M`j'^2*n3*q12^2*q13^2*q23-8*q12^2*q13^3*q23+8*n3*q12^2*q13^3*q23-16*M`j'^2*q12*q13^2*q23^2+16*M`j'^2*n3*q12*q13^2*q23^2+8*M`j'^2*q12^3*q13*q33-8*M`j'^2*n3*q12^3*q13*q33-12*q12^3*q13^2*q33+12*n3*q12^3*q13^2*q33-12*q12^2*q13^2*q23*q33+12*n3*q12^2*q13^2*q23*q33-8*M`j'^2*q12*q13*q23^2*q33+8*M`j'^2*n3*q12*q13*q23^2*q33+4*M`j'^2*q12^3*q33^2-4*M`j'^2*n3*q12^3*q33^2-6*q12^3*q13*q33^2+6*n3*q12^3*q13*q33^2+4*M`j'^2*q12^2*q23*q33^2-4*M`j'^2*n3*q12^2*q23*q33^2-6*q12^2*q13*q23*q33^2+6*n3*q12^2*q13*q23*q33^2-q12^3*q33^3+n3*q12^3*q33^3-q12^2*q23*q33^3+n3*q12^2*q23*q33^3)+prf(4*M`j'^2*q12^2*q13^2+4*M`j'^2*n1*q12^2*q13^2+4*M`j'^2*n2*q12^2*q13^2-4*M`j'^2*n3*q12^2*q13^2-4*M`j'^2*n4*q12^2*q13^2-4*q12^3*q13^2-4*n1*q12^3*q13^2+4*n3*q12^3*q13^2+16*M`j'^2*q12*q13^3+16*M`j'^2*n2*q12*q13^3-16*M`j'^2*n3*q12*q13^3-32*q12^2*q13^3-4*n2*q12^2*q13^3+16*n3*q12^2*q13^3+8*n4*q12^2*q13^3-8*q12*q13^4-8*n2*q12*q13^4+8*n3*q12*q13^4-4*M`j'^2*q12^2*q13*q23-4*M`j'^2*n1*q12^2*q13*q23+4*M`j'^2*n2*q12^2*q13*q23+4*M`j'^2*n3*q12^2*q13*q23-4*M`j'^2*n4*q12^2*q13*q23+4*M`j'^2*q12*q13^2*q23-8*M`j'^2*n1*q12*q13^2*q23+16*M`j'^2*n2*q12*q13^2*q23-4*M`j'^2*n3*q12*q13^2*q23-4*M`j'^2*n4*q12*q13^2*q23-28*q12^2*q13^2*q23+4*n1*q12^2*q13^2*q23-4*n2*q12^2*q13^2*q23+12*n3*q12^2*q13^2*q23+8*n4*q12^2*q13^2*q23-32*q12*q13^3*q23+8*n1*q12*q13^3*q23-12*n2*q12*q13^3*q23+16*n3*q12*q13^3*q23+8*n4*q12*q13^3*q23-4*M`j'^2*q12*q13*q23^2+4*M`j'^2*n3*q12*q13*q23^2-4*M`j'^2*n4*q12*q13*q23^2+4*M`j'^2*n1*q13^2*q23^2-4*M`j'^2*n2*q13^2*q23^2-24*q12*q13^2*q23^2+8*n1*q12*q13^2*q23^2-4*n2*q12*q13^2*q23^2+8*n3*q12*q13^2*q23^2+8*n4*q12*q13^2*q23^2+4*M`j'^2*n1*q13*q23^3-4*M`j'^2*n2*q13*q23^3-4*M`j'^2*n2*q12^3*q33+4*M`j'^2*n4*q12^3*q33-6*M`j'^2*q12^2*q13*q33+8*M`j'^2*n1*q12^2*q13*q33-12*M`j'^2*n2*q12^2*q13*q33+6*M`j'^2*n3*q12^2*q13*q33-2*M`j'^2*n4*q12^2*q13*q33+20*q12^3*q13*q33-10*n1*q12^3*q13*q33+2*n2*q12^3*q13*q33-4*n3*q12^3*q13*q33-8*n4*q12^3*q13*q33+16*M`j'^2*q12*q13^2*q33+16*M`j'^2*n2*q12*q13^2*q33-16*M`j'^2*n3*q12*q13^2*q33-28*q12^2*q13^2*q33-4*n1*q12^2*q13^2*q33+4*n2*q12^2*q13^2*q33+12*n3*q12^2*q13^2*q33+8*n4*q12^2*q13^2*q33-12*q12*q13^3*q33-12*n2*q12*q13^3*q33+12*n3*q12*q13^3*q33-2*M`j'^2*q12^2*q23*q33-4*M`j'^2*n1*q12^2*q23*q33-4*M`j'^2*n2*q12^2*q23*q33+2*M`j'^2*n3*q12^2*q23*q33+6*M`j'^2*n4*q12^2*q23*q33-6*M`j'^2*q12*q13*q23*q33-8*M`j'^2*n1*q12*q13*q23*q33+4*M`j'^2*n2*q12*q13*q23*q33+6*M`j'^2*n3*q12*q13*q23*q33-2*M`j'^2*n4*q12*q13*q23*q33+20*q12^2*q13*q23*q33-8*n1*q12^2*q13*q23*q33-4*n3*q12^2*q13*q23*q33-8*n4*q12^2*q13*q23*q33-28*q12*q13^2*q23*q33+8*n1*q12*q13^2*q23*q33-8*n2*q12*q13^2*q23*q33+12*n3*q12*q13^2*q23*q33+8*n4*q12*q13^2*q23*q33-2*M`j'^2*q12*q23^2*q33-4*M`j'^2*n1*q12*q23^2*q33+2*M`j'^2*n3*q12*q23^2*q33+2*M`j'^2*n4*q12*q23^2*q33+2*n1*q12*q13*q23^2*q33-2*n2*q12*q13*q23^2*q33-4*M`j'^2*q12^2*q33^2+4*M`j'^2*n1*q12^2*q33^2-8*M`j'^2*n2*q12^2*q33^2+4*M`j'^2*n3*q12^2*q33^2+11*q12^3*q33^2-4*n1*q12^3*q33^2+n2*q12^3*q33^2-3*n3*q12^3*q33^2-4*n4*q12^3*q33^2+4*M`j'^2*q12*q13*q33^2+4*M`j'^2*n2*q12*q13*q33^2-4*M`j'^2*n3*q12*q13*q33^2-4*q12^2*q13*q33^2-4*n1*q12^2*q13*q33^2+7*n2*q12^2*q13*q33^2+2*n4*q12^2*q13*q33^2-6*q12*q13^2*q33^2-6*n2*q12*q13^2*q33^2+6*n3*q12*q13^2*q33^2-4*M`j'^2*q12*q23*q33^2-4*M`j'^2*n2*q12*q23*q33^2+4*M`j'^2*n3*q12*q23*q33^2+17*q12^2*q23*q33^2-5*n1*q12^2*q23*q33^2+n2*q12^2*q23*q33^2-5*n3*q12^2*q23*q33^2-6*n4*q12^2*q23*q33^2-4*q12*q13*q23*q33^2+2*n1*q12*q13*q23*q33^2+n2*q12*q13*q23*q33^2+2*n4*q12*q13*q23*q33^2+6*q12*q23^2*q33^2-n1*q12*q23^2*q33^2-2*n3*q12*q23^2*q33^2-2*n4*q12*q23^2*q33^2+q12^2*q33^3-n1*q12^2*q33^3+2*n2*q12^2*q33^3-n3*q12^2*q33^3-q12*q13*q33^3-n2*q12*q13*q33^3+n3*q12*q13*q33^3+q12*q23*q33^3+n2*q12*q23*q33^3-n3*q12*q23*q33^3,-8*q12^3*q13^3+8*n3*q12^3*q13^3-16*M`j'^2*q12^2*q13^2*q23+16*M`j'^2*n3*q12^2*q13^2*q23-8*q12^2*q13^3*q23+8*n3*q12^2*q13^3*q23-16*M`j'^2*q12*q13^2*q23^2+16*M`j'^2*n3*q12*q13^2*q23^2+8*M`j'^2*q12^3*q13*q33-8*M`j'^2*n3*q12^3*q13*q33-12*q12^3*q13^2*q33+12*n3*q12^3*q13^2*q33-12*q12^2*q13^2*q23*q33+12*n3*q12^2*q13^2*q23*q33-8*M`j'^2*q12*q13*q23^2*q33+8*M`j'^2*n3*q12*q13*q23^2*q33+4*M`j'^2*q12^3*q33^2-4*M`j'^2*n3*q12^3*q33^2-6*q12^3*q13*q33^2+6*n3*q12^3*q13*q33^2+4*M`j'^2*q12^2*q23*q33^2-4*M`j'^2*n3*q12^2*q23*q33^2-6*q12^2*q13*q23*q33^2+6*n3*q12^2*q13*q23*q33^2-q12^3*q33^3+n3*q12^3*q33^3-q12^2*q23*q33^3+n3*q12^2*q23*q33^3));
	Identify,ifmatch->jump mbox1l(n1?pos_,n2?{,>1},n3?pos_,n4?pos_) = mbox1l(n1,-1+n2,1+n3,-1+n4)*prf(-2*M`j'^2*n3*q13,-4*q12*q13^2+4*n2*q12*q13^2-8*M`j'^2*q13*q23+8*M`j'^2*n2*q13*q23+4*M`j'^2*q12*q33-4*M`j'^2*n2*q12*q33-4*q12*q13*q33+4*n2*q12*q13*q33-q12*q33^2+n2*q12*q33^2)+mbox1l(n1,-1+n2,-1+n3,1+n4)*prf(-2*M`j'^2*n4*q13,-4*q12*q13^2+4*n2*q12*q13^2-8*M`j'^2*q13*q23+8*M`j'^2*n2*q13*q23+4*M`j'^2*q12*q33-4*M`j'^2*n2*q12*q33-4*q12*q13*q33+4*n2*q12*q13*q33-q12*q33^2+n2*q12*q33^2)+mbox1l(n1,n2,n3,-1+n4)*prf(4*M`j'^2*q12*q13-4*M`j'^2*q13^2-4*q12*q13^2-4*M`j'^2*q13*q23+4*M`j'^2*q12*q33-2*M`j'^2*q13*q33-4*q12*q13*q33-q12*q33^2,8*q12*q13^3+16*M`j'^2*q13^2*q23-8*M`j'^2*q12*q13*q33+12*q12*q13^2*q33+8*M`j'^2*q13*q23*q33-4*M`j'^2*q12*q33^2+6*q12*q13*q33^2+q12*q33^3)+mbox1l(n1,-2+n2,1+n3,n4)*prf(-8*M`j'^2*n3*q13^2+4*n3*q13^3-4*M`j'^2*n3*q13*q33+4*n3*q13^2*q33+n3*q13*q33^2,-4*q12^2*q13^2+4*n2*q12^2*q13^2-8*M`j'^2*q12*q13*q23+8*M`j'^2*n2*q12*q13*q23-4*q12*q13^2*q23+4*n2*q12*q13^2*q23-8*M`j'^2*q13*q23^2+8*M`j'^2*n2*q13*q23^2+4*M`j'^2*q12^2*q33-4*M`j'^2*n2*q12^2*q33-4*q12^2*q13*q33+4*n2*q12^2*q13*q33+4*M`j'^2*q12*q23*q33-4*M`j'^2*n2*q12*q23*q33-4*q12*q13*q23*q33+4*n2*q12*q13*q23*q33-q12^2*q33^2+n2*q12^2*q33^2-q12*q23*q33^2+n2*q12*q23*q33^2)+mbox1l(1+n1,-1+n2,n3,-1+n4)*prf(8*M`j'^2*n1*q12*q13^2-8*n1*q12*q13^3-8*M`j'^2*n1*q13^2*q23+6*M`j'^2*n1*q12*q13*q33-8*n1*q12*q13^2*q33-2*M`j'^2*n1*q13*q23*q33-2*n1*q12*q13*q33^2,-8*q12^2*q13^3+8*n2*q12^2*q13^3-16*M`j'^2*q12*q13^2*q23+16*M`j'^2*n2*q12*q13^2*q23-8*q12*q13^3*q23+8*n2*q12*q13^3*q23-16*M`j'^2*q13^2*q23^2+16*M`j'^2*n2*q13^2*q23^2+8*M`j'^2*q12^2*q13*q33-8*M`j'^2*n2*q12^2*q13*q33-12*q12^2*q13^2*q33+12*n2*q12^2*q13^2*q33-12*q12*q13^2*q23*q33+12*n2*q12*q13^2*q23*q33-8*M`j'^2*q13*q23^2*q33+8*M`j'^2*n2*q13*q23^2*q33+4*M`j'^2*q12^2*q33^2-4*M`j'^2*n2*q12^2*q33^2-6*q12^2*q13*q33^2+6*n2*q12^2*q13*q33^2+4*M`j'^2*q12*q23*q33^2-4*M`j'^2*n2*q12*q23*q33^2-6*q12*q13*q23*q33^2+6*n2*q12*q13*q23*q33^2-q12^2*q33^3+n2*q12^2*q33^3-q12*q23*q33^3+n2*q12*q23*q33^3)+mbox1l(-1+n1,n2,n3,n4)*prf(-4*M`j'^2*q12^2*q13+4*q12^2*q13^2+4*q12*q13^2*q23+4*M`j'^2*q13*q23^2-4*M`j'^2*q12^2*q33+4*q12^2*q13*q33-4*M`j'^2*q12*q23*q33+4*q12*q13*q23*q33+q12^2*q33^2+q12*q23*q33^2,8*q12^2*q13^3+16*M`j'^2*q12*q13^2*q23-8*M`j'^2*q12^2*q13*q33+12*q12^2*q13^2*q33+8*M`j'^2*q12*q13*q23*q33-4*M`j'^2*q12^2*q33^2+6*q12^2*q13*q33^2+q12^2*q33^3)+mbox1l(n1,n2,-1+n3,n4)*prf(8*M`j'^2*q12^2*q13^2+16*M`j'^2*q12*q13^3-4*q12^2*q13^3-8*q12*q13^4+4*M`j'^2*q12^2*q13*q23+20*M`j'^2*q12*q13^2*q23-4*q12^2*q13^2*q23-12*q12*q13^3*q23-4*M`j'^2*q13^2*q23^2-4*q12*q13^2*q23^2-4*M`j'^2*q13*q23^3-2*M`j'^2*q12^2*q13*q33+16*M`j'^2*q12*q13^2*q33-12*q12*q13^3*q33+4*M`j'^2*q12^2*q23*q33+14*M`j'^2*q12*q13*q23*q33-4*q12^2*q13*q23*q33-12*q12*q13^2*q23*q33+4*M`j'^2*q12*q23^2*q33-4*q12*q13*q23^2*q33-4*M`j'^2*q12^2*q33^2+4*M`j'^2*q12*q13*q33^2+3*q12^2*q13*q33^2-6*q12*q13^2*q33^2-q12^2*q23*q33^2-3*q12*q13*q23*q33^2-q12*q23^2*q33^2+q12^2*q33^3-q12*q13*q33^3,8*q12^3*q13^3+16*M`j'^2*q12^2*q13^2*q23+8*q12^2*q13^3*q23+16*M`j'^2*q12*q13^2*q23^2-8*M`j'^2*q12^3*q13*q33+12*q12^3*q13^2*q33+12*q12^2*q13^2*q23*q33+8*M`j'^2*q12*q13*q23^2*q33-4*M`j'^2*q12^3*q33^2+6*q12^3*q13*q33^2-4*M`j'^2*q12^2*q23*q33^2+6*q12^2*q13*q23*q33^2+q12^3*q33^3+q12^2*q23*q33^3)+mbox1l(1+n1,-1+n2,-1+n3,n4)*prf(-4*M`j'^2*n1*q12^2*q13^2+4*M`j'^2*n1*q12*q13^3+4*M`j'^2*n1*q13^3*q23+4*M`j'^2*n1*q13^2*q23^2+2*M`j'^2*n1*q12^2*q13*q33+8*M`j'^2*n1*q12*q13^2*q33-4*n1*q12^2*q13^2*q33-4*n1*q12*q13^3*q33-6*M`j'^2*n1*q12*q13*q23*q33+4*M`j'^2*n1*q12^2*q33^2+4*M`j'^2*n1*q12*q13*q33^2-4*n1*q12^2*q13*q33^2-4*n1*q12*q13^2*q33^2-n1*q12^2*q33^3-n1*q12*q13*q33^3,-8*q12^3*q13^3+8*n2*q12^3*q13^3-16*M`j'^2*q12^2*q13^2*q23+16*M`j'^2*n2*q12^2*q13^2*q23-8*q12^2*q13^3*q23+8*n2*q12^2*q13^3*q23-16*M`j'^2*q12*q13^2*q23^2+16*M`j'^2*n2*q12*q13^2*q23^2+8*M`j'^2*q12^3*q13*q33-8*M`j'^2*n2*q12^3*q13*q33-12*q12^3*q13^2*q33+12*n2*q12^3*q13^2*q33-12*q12^2*q13^2*q23*q33+12*n2*q12^2*q13^2*q23*q33-8*M`j'^2*q12*q13*q23^2*q33+8*M`j'^2*n2*q12*q13*q23^2*q33+4*M`j'^2*q12^3*q33^2-4*M`j'^2*n2*q12^3*q33^2-6*q12^3*q13*q33^2+6*n2*q12^3*q13*q33^2+4*M`j'^2*q12^2*q23*q33^2-4*M`j'^2*n2*q12^2*q23*q33^2-6*q12^2*q13*q23*q33^2+6*n2*q12^2*q13*q23*q33^2-q12^3*q33^3+n2*q12^3*q33^3-q12^2*q23*q33^3+n2*q12^2*q23*q33^3)+mbox1l(1+n1,-2+n2,n3,n4)*prf(-4*M`j'^2*n1*q12*q13^3-4*M`j'^2*n1*q13^3*q23-8*M`j'^2*n1*q12*q13^2*q33+4*n1*q12*q13^3*q33-4*M`j'^2*n1*q12*q13*q33^2+4*n1*q12*q13^2*q33^2+n1*q12*q13*q33^3,-8*q12^3*q13^3+8*n2*q12^3*q13^3-16*M`j'^2*q12^2*q13^2*q23+16*M`j'^2*n2*q12^2*q13^2*q23-8*q12^2*q13^3*q23+8*n2*q12^2*q13^3*q23-16*M`j'^2*q12*q13^2*q23^2+16*M`j'^2*n2*q12*q13^2*q23^2+8*M`j'^2*q12^3*q13*q33-8*M`j'^2*n2*q12^3*q13*q33-12*q12^3*q13^2*q33+12*n2*q12^3*q13^2*q33-12*q12^2*q13^2*q23*q33+12*n2*q12^2*q13^2*q23*q33-8*M`j'^2*q12*q13*q23^2*q33+8*M`j'^2*n2*q12*q13*q23^2*q33+4*M`j'^2*q12^3*q33^2-4*M`j'^2*n2*q12^3*q33^2-6*q12^3*q13*q33^2+6*n2*q12^3*q13*q33^2+4*M`j'^2*q12^2*q23*q33^2-4*M`j'^2*n2*q12^2*q23*q33^2-6*q12^2*q13*q23*q33^2+6*n2*q12^2*q13*q23*q33^2-q12^3*q33^3+n2*q12^3*q33^3-q12^2*q23*q33^3+n2*q12^2*q23*q33^3)+mbox1l(n1,-1+n2,n3,n4)*(tmpprf(ep,1)*prf(-8*q12^2*q13^3-8*q12*q13^3*q23-8*q12^2*q13^2*q33-8*q12*q13^2*q23*q33-2*q12^2*q13*q33^2-2*q12*q13*q23*q33^2,-8*q12^3*q13^3+8*n2*q12^3*q13^3-16*M`j'^2*q12^2*q13^2*q23+16*M`j'^2*n2*q12^2*q13^2*q23-8*q12^2*q13^3*q23+8*n2*q12^2*q13^3*q23-16*M`j'^2*q12*q13^2*q23^2+16*M`j'^2*n2*q12*q13^2*q23^2+8*M`j'^2*q12^3*q13*q33-8*M`j'^2*n2*q12^3*q13*q33-12*q12^3*q13^2*q33+12*n2*q12^3*q13^2*q33-12*q12^2*q13^2*q23*q33+12*n2*q12^2*q13^2*q23*q33-8*M`j'^2*q12*q13*q23^2*q33+8*M`j'^2*n2*q12*q13*q23^2*q33+4*M`j'^2*q12^3*q33^2-4*M`j'^2*n2*q12^3*q33^2-6*q12^3*q13*q33^2+6*n2*q12^3*q13*q33^2+4*M`j'^2*q12^2*q23*q33^2-4*M`j'^2*n2*q12^2*q23*q33^2-6*q12^2*q13*q23*q33^2+6*n2*q12^2*q13*q23*q33^2-q12^3*q33^3+n2*q12^3*q33^3-q12^2*q23*q33^3+n2*q12^2*q23*q33^3)+prf(4*M`j'^2*q12^2*q13^2-4*M`j'^2*n1*q12^2*q13^2-4*M`j'^2*n2*q12^2*q13^2+4*M`j'^2*n3*q12^2*q13^2+4*M`j'^2*n4*q12^2*q13^2+16*M`j'^2*q12*q13^3-16*M`j'^2*n2*q12*q13^3+16*M`j'^2*n3*q12*q13^3+20*q12^2*q13^3-4*n2*q12^2*q13^3-8*n3*q12^2*q13^3-8*n4*q12^2*q13^3-8*q12*q13^4+8*n2*q12*q13^4-8*n3*q12*q13^4+16*M`j'^2*q12*q13^2*q23+8*M`j'^2*n1*q12*q13^2*q23-16*M`j'^2*n2*q12*q13^2*q23+4*M`j'^2*n3*q12*q13^2*q23+4*M`j'^2*n4*q12*q13^2*q23+12*q12*q13^3*q23-8*n1*q12*q13^3*q23+4*n2*q12*q13^3*q23-8*n3*q12*q13^3*q23-8*n4*q12*q13^3*q23-4*M`j'^2*q13^2*q23^2-4*M`j'^2*n1*q13^2*q23^2+4*M`j'^2*n2*q13^2*q23^2-4*M`j'^2*q12^2*q13*q33-8*M`j'^2*n1*q12^2*q13*q33+4*M`j'^2*n2*q12^2*q13*q33+2*M`j'^2*n3*q12^2*q13*q33+2*M`j'^2*n4*q12^2*q13*q33+16*M`j'^2*q12*q13^2*q33-16*M`j'^2*n2*q12*q13^2*q33+16*M`j'^2*n3*q12*q13^2*q33+24*q12^2*q13^2*q33+4*n1*q12^2*q13^2*q33-8*n2*q12^2*q13^2*q33-8*n3*q12^2*q13^2*q33-8*n4*q12^2*q13^2*q33-12*q12*q13^3*q33+12*n2*q12*q13^3*q33-12*n3*q12*q13^3*q33+12*M`j'^2*q12*q13*q23*q33+8*M`j'^2*n1*q12*q13*q23*q33-12*M`j'^2*n2*q12*q13*q23*q33+2*M`j'^2*n3*q12*q13*q23*q33+2*M`j'^2*n4*q12*q13*q23*q33+12*q12*q13^2*q23*q33-8*n1*q12*q13^2*q23*q33+4*n2*q12*q13^2*q23*q33-8*n3*q12*q13^2*q23*q33-8*n4*q12*q13^2*q23*q33-4*M`j'^2*q12^2*q33^2-4*M`j'^2*n1*q12^2*q33^2+4*M`j'^2*n2*q12^2*q33^2+4*M`j'^2*q12*q13*q33^2-4*M`j'^2*n2*q12*q13*q33^2+4*M`j'^2*n3*q12*q13*q33^2+9*q12^2*q13*q33^2+4*n1*q12^2*q13*q33^2-5*n2*q12^2*q13*q33^2-2*n3*q12^2*q13*q33^2-2*n4*q12^2*q13*q33^2-6*q12*q13^2*q33^2+6*n2*q12*q13^2*q33^2-6*n3*q12*q13^2*q33^2+3*q12*q13*q23*q33^2-2*n1*q12*q13*q23*q33^2+n2*q12*q13*q23*q33^2-2*n3*q12*q13*q23*q33^2-2*n4*q12*q13*q23*q33^2+q12^2*q33^3+n1*q12^2*q33^3-n2*q12^2*q33^3-q12*q13*q33^3+n2*q12*q13*q33^3-n3*q12*q13*q33^3,-8*q12^3*q13^3+8*n2*q12^3*q13^3-16*M`j'^2*q12^2*q13^2*q23+16*M`j'^2*n2*q12^2*q13^2*q23-8*q12^2*q13^3*q23+8*n2*q12^2*q13^3*q23-16*M`j'^2*q12*q13^2*q23^2+16*M`j'^2*n2*q12*q13^2*q23^2+8*M`j'^2*q12^3*q13*q33-8*M`j'^2*n2*q12^3*q13*q33-12*q12^3*q13^2*q33+12*n2*q12^3*q13^2*q33-12*q12^2*q13^2*q23*q33+12*n2*q12^2*q13^2*q23*q33-8*M`j'^2*q12*q13*q23^2*q33+8*M`j'^2*n2*q12*q13*q23^2*q33+4*M`j'^2*q12^3*q33^2-4*M`j'^2*n2*q12^3*q33^2-6*q12^3*q13*q33^2+6*n2*q12^3*q13*q33^2+4*M`j'^2*q12^2*q23*q33^2-4*M`j'^2*n2*q12^2*q23*q33^2-6*q12^2*q13*q23*q33^2+6*n2*q12^2*q13*q23*q33^2-q12^3*q33^3+n2*q12^3*q33^3-q12^2*q23*q33^3+n2*q12^2*q23*q33^3));
	Identify,ifmatch->jump mbox1l(n1?{,>1},n2?pos_,n3?pos_,n4?pos_) = mbox1l(-1+n1,n2,1+n3,-1+n4)*prf(2*M`j'^2*n3*q12+2*M`j'^2*n3*q23,-4*q12*q13^2+4*n1*q12*q13^2-8*M`j'^2*q13*q23+8*M`j'^2*n1*q13*q23+4*M`j'^2*q12*q33-4*M`j'^2*n1*q12*q33-4*q12*q13*q33+4*n1*q12*q13*q33-q12*q33^2+n1*q12*q33^2)+mbox1l(-1+n1,n2,-1+n3,1+n4)*prf(2*M`j'^2*n4*q12+2*M`j'^2*n4*q23,-4*q12*q13^2+4*n1*q12*q13^2-8*M`j'^2*q13*q23+8*M`j'^2*n1*q13*q23+4*M`j'^2*q12*q33-4*M`j'^2*n1*q12*q33-4*q12*q13*q33+4*n1*q12*q13*q33-q12*q33^2+n1*q12*q33^2)+mbox1l(-2+n1,1+n2,n3,n4)*prf(4*M`j'^2*n2*q12^3+12*M`j'^2*n2*q12^2*q23+12*M`j'^2*n2*q12*q23^2+4*M`j'^2*n2*q23^3,-8*q12^2*q13^3+8*n1*q12^2*q13^3-16*M`j'^2*q12*q13^2*q23+16*M`j'^2*n1*q12*q13^2*q23+8*M`j'^2*q12^2*q13*q33-8*M`j'^2*n1*q12^2*q13*q33-12*q12^2*q13^2*q33+12*n1*q12^2*q13^2*q33-8*M`j'^2*q12*q13*q23*q33+8*M`j'^2*n1*q12*q13*q23*q33+4*M`j'^2*q12^2*q33^2-4*M`j'^2*n1*q12^2*q33^2-6*q12^2*q13*q33^2+6*n1*q12^2*q13*q33^2-q12^2*q33^3+n1*q12^2*q33^3)+mbox1l(-1+n1,1+n2,n3,-1+n4)*prf(-4*M`j'^2*n2*q12^2+4*M`j'^2*n2*q12*q13-8*M`j'^2*n2*q12*q23+4*M`j'^2*n2*q13*q23-4*M`j'^2*n2*q23^2+2*M`j'^2*n2*q12*q33+2*M`j'^2*n2*q23*q33,-8*q12*q13^3+8*n1*q12*q13^3-16*M`j'^2*q13^2*q23+16*M`j'^2*n1*q13^2*q23+8*M`j'^2*q12*q13*q33-8*M`j'^2*n1*q12*q13*q33-12*q12*q13^2*q33+12*n1*q12*q13^2*q33-8*M`j'^2*q13*q23*q33+8*M`j'^2*n1*q13*q23*q33+4*M`j'^2*q12*q33^2-4*M`j'^2*n1*q12*q33^2-6*q12*q13*q33^2+6*n1*q12*q13*q33^2-q12*q33^3+n1*q12*q33^3)+mbox1l(-1+n1,-1+n2,1+n3,n4)*prf(8*M`j'^2*n3*q13-4*n3*q13^2+4*M`j'^2*n3*q33-4*n3*q13*q33-n3*q33^2,-4*q12*q13^2+4*n1*q12*q13^2-8*M`j'^2*q13*q23+8*M`j'^2*n1*q13*q23+4*M`j'^2*q12*q33-4*M`j'^2*n1*q12*q33-4*q12*q13*q33+4*n1*q12*q13*q33-q12*q33^2+n1*q12*q33^2)+mbox1l(n1,n2,n3,-1+n4)*prf(-8*M`j'^2*q12*q13+4*q12*q13^2-2*M`j'^2*q12*q33+4*q12*q13*q33+2*M`j'^2*q23*q33+q12*q33^2,8*q12*q13^3+16*M`j'^2*q13^2*q23-8*M`j'^2*q12*q13*q33+12*q12*q13^2*q33+8*M`j'^2*q13*q23*q33-4*M`j'^2*q12*q33^2+6*q12*q13*q33^2+q12*q33^3)+mbox1l(n1,-1+n2,n3,n4)*prf(4*M`j'^2*q12*q13^2-4*q12*q13^3-4*M`j'^2*q13^2*q23+12*M`j'^2*q12*q13*q33-8*q12*q13^2*q33+4*M`j'^2*q12*q33^2-5*q12*q13*q33^2-q12*q33^3,8*q12^2*q13^3+16*M`j'^2*q12*q13^2*q23-8*M`j'^2*q12^2*q13*q33+12*q12^2*q13^2*q33+8*M`j'^2*q12*q13*q23*q33-4*M`j'^2*q12^2*q33^2+6*q12^2*q13*q33^2+q12^2*q33^3)+mbox1l(n1,n2,-1+n3,n4)*prf(4*M`j'^2*q12^2*q13-4*M`j'^2*q12*q13^2+4*q12*q13^3+4*M`j'^2*q13^2*q23+4*q12*q13^2*q23+4*M`j'^2*q13*q23^2-2*M`j'^2*q12^2*q33-12*M`j'^2*q12*q13*q33+8*q12*q13^2*q33-6*M`j'^2*q12*q23*q33+4*q12*q13*q23*q33-4*M`j'^2*q12*q33^2+5*q12*q13*q33^2+q12*q23*q33^2+q12*q33^3,8*q12^2*q13^3+16*M`j'^2*q12*q13^2*q23-8*M`j'^2*q12^2*q13*q33+12*q12^2*q13^2*q33+8*M`j'^2*q12*q13*q23*q33-4*M`j'^2*q12^2*q33^2+6*q12^2*q13*q33^2+q12^2*q33^3)+mbox1l(-1+n1,1+n2,-1+n3,n4)*prf(-8*M`j'^2*n2*q12^2*q13-16*M`j'^2*n2*q12*q13^2+8*n2*q12^2*q13^2+8*n2*q12*q13^3-4*M`j'^2*n2*q12^2*q23-12*M`j'^2*n2*q12*q13*q23+8*n2*q12*q13^2*q23-8*M`j'^2*n2*q12*q23^2-4*M`j'^2*n2*q13*q23^2-4*M`j'^2*n2*q23^3-2*M`j'^2*n2*q12^2*q33-16*M`j'^2*n2*q12*q13*q33+8*n2*q12^2*q13*q33+12*n2*q12*q13^2*q33-2*M`j'^2*n2*q12*q23*q33+8*n2*q12*q13*q23*q33-4*M`j'^2*n2*q12*q33^2+2*n2*q12^2*q33^2+6*n2*q12*q13*q33^2+2*n2*q12*q23*q33^2+n2*q12*q33^3,-8*q12^2*q13^3+8*n1*q12^2*q13^3-16*M`j'^2*q12*q13^2*q23+16*M`j'^2*n1*q12*q13^2*q23+8*M`j'^2*q12^2*q13*q33-8*M`j'^2*n1*q12^2*q13*q33-12*q12^2*q13^2*q33+12*n1*q12^2*q13^2*q33-8*M`j'^2*q12*q13*q23*q33+8*M`j'^2*n1*q12*q13*q23*q33+4*M`j'^2*q12^2*q33^2-4*M`j'^2*n1*q12^2*q33^2-6*q12^2*q13*q33^2+6*n1*q12^2*q13*q33^2-q12^2*q33^3+n1*q12^2*q33^3)+mbox1l(-1+n1,n2,n3,n4)*(tmpprf(ep,1)*prf(8*q12^2*q13^2+8*q12*q13^2*q23+8*q12^2*q13*q33+8*q12*q13*q23*q33+2*q12^2*q33^2+2*q12*q23*q33^2,-8*q12^2*q13^3+8*n1*q12^2*q13^3-16*M`j'^2*q12*q13^2*q23+16*M`j'^2*n1*q12*q13^2*q23+8*M`j'^2*q12^2*q13*q33-8*M`j'^2*n1*q12^2*q13*q33-12*q12^2*q13^2*q33+12*n1*q12^2*q13^2*q33-8*M`j'^2*q12*q13*q23*q33+8*M`j'^2*n1*q12*q13*q23*q33+4*M`j'^2*q12^2*q33^2-4*M`j'^2*n1*q12^2*q33^2-6*q12^2*q13*q33^2+6*n1*q12^2*q13*q33^2-q12^2*q33^3+n1*q12^2*q33^3)+prf(-4*M`j'^2*q12^2*q13+4*M`j'^2*n1*q12^2*q13+4*M`j'^2*n2*q12^2*q13-4*M`j'^2*n3*q12^2*q13-4*M`j'^2*n4*q12^2*q13+16*M`j'^2*n2*q12*q13^2-16*M`j'^2*n3*q12*q13^2-20*q12^2*q13^2+4*n1*q12^2*q13^2+8*n3*q12^2*q13^2+8*n4*q12^2*q13^2-8*n2*q12*q13^3+8*n3*q12*q13^3+8*M`j'^2*n2*q12*q13*q23-4*M`j'^2*n3*q12*q13*q23-4*M`j'^2*n4*q12*q13*q23-20*q12*q13^2*q23+4*n1*q12*q13^2*q23+8*n3*q12*q13^2*q23+8*n4*q12*q13^2*q23+4*M`j'^2*q13*q23^2-4*M`j'^2*n1*q13*q23^2+4*M`j'^2*n2*q13*q23^2-4*M`j'^2*q12^2*q33+4*M`j'^2*n1*q12^2*q33-2*M`j'^2*n3*q12^2*q33-2*M`j'^2*n4*q12^2*q33+16*M`j'^2*n2*q12*q13*q33-16*M`j'^2*n3*q12*q13*q33-20*q12^2*q13*q33+4*n1*q12^2*q13*q33+8*n3*q12^2*q13*q33+8*n4*q12^2*q13*q33-12*n2*q12*q13^2*q33+12*n3*q12*q13^2*q33-4*M`j'^2*q12*q23*q33+4*M`j'^2*n1*q12*q23*q33-2*M`j'^2*n3*q12*q23*q33-2*M`j'^2*n4*q12*q23*q33-20*q12*q13*q23*q33+4*n1*q12*q13*q23*q33+8*n3*q12*q13*q23*q33+8*n4*q12*q13*q23*q33+4*M`j'^2*n2*q12*q33^2-4*M`j'^2*n3*q12*q33^2-5*q12^2*q33^2+n1*q12^2*q33^2+2*n3*q12^2*q33^2+2*n4*q12^2*q33^2-6*n2*q12*q13*q33^2+6*n3*q12*q13*q33^2-5*q12*q23*q33^2+n1*q12*q23*q33^2+2*n3*q12*q23*q33^2+2*n4*q12*q23*q33^2-n2*q12*q33^3+n3*q12*q33^3,-8*q12^2*q13^3+8*n1*q12^2*q13^3-16*M`j'^2*q12*q13^2*q23+16*M`j'^2*n1*q12*q13^2*q23+8*M`j'^2*q12^2*q13*q33-8*M`j'^2*n1*q12^2*q13*q33-12*q12^2*q13^2*q33+12*n1*q12^2*q13^2*q33-8*M`j'^2*q12*q13*q23*q33+8*M`j'^2*n1*q12*q13*q23*q33+4*M`j'^2*q12^2*q33^2-4*M`j'^2*n1*q12^2*q33^2-6*q12^2*q13*q33^2+6*n1*q12^2*q13*q33^2-q12^2*q33^3+n1*q12^2*q33^3));
	Identify,ifmatch->jump mbox1l(n1?pos_,n2?pos_,n3?pos_,n4?{,>1}) = mbox1l(1+n1,-1+n2,1+n3,-1+n4)*prf(-(n3*q13),-q12+n4*q12-q23+n4*q23)+mbox1l(2+n1,n2,n3,-2+n4)*prf(2*q12*q13+2*n1*q12*q13,-2*q12*q13+2*n4*q12*q13-2*q13*q23+2*n4*q13*q23-q12*q33+n4*q12*q33-q23*q33+n4*q23*q33)+mbox1l(1+n1,n2,-1+n3,n4)*prf(q33,2*q13+q33)+mbox1l(2+n1,-1+n2,n3,-1+n4)*prf(-(q13*q33)-n1*q13*q33,-2*q12*q13+2*n4*q12*q13-2*q13*q23+2*n4*q13*q23-q12*q33+n4*q12*q33-q23*q33+n4*q23*q33)+mbox1l(2+n1,n2,-1+n3,-1+n4)*prf(q12*q33+n1*q12*q33+q13*q33+n1*q13*q33,-2*q12*q13+2*n4*q12*q13-2*q13*q23+2*n4*q13*q23-q12*q33+n4*q12*q33-q23*q33+n4*q23*q33)+mbox1l(1+n1,1+n2,-1+n3,-1+n4)*prf(2*n2*q13^2+2*n2*q13*q23-n2*q12*q33+n2*q13*q33,-2*q12*q13+2*n4*q12*q13-2*q13*q23+2*n4*q13*q23-q12*q33+n4*q12*q33-q23*q33+n4*q23*q33)+mbox1l(1+n1,n2,n3,-1+n4)*prf(-4*q12*q13-2*n1*q12*q13+2*n4*q12*q13-2*n2*q13^2+2*n3*q13^2-2*q13*q23-2*n2*q13*q23+2*n4*q13*q23-q12*q33-n1*q12*q33+n2*q12*q33-n2*q13*q33+n3*q13*q33,-2*q12*q13+2*n4*q12*q13-2*q13*q23+2*n4*q13*q23-q12*q33+n4*q12*q33-q23*q33+n4*q23*q33);
	Identify,ifmatch->jump mbox1l(n1?pos_,n2?pos_,n3?{,>1},n4?pos_) = mbox1l(1+n1,1+n2,-1+n3,-1+n4)*prf(2*n2*q12,-2*q13+2*n3*q13-q33+n3*q33)+mbox1l(1+n1,-1+n2,n3,n4)*prf(-q13,q12+q23)+mbox1l(2+n1,n2,-1+n3,-1+n4)*prf(2*q12*q13+2*n1*q12*q13,-2*q12*q13+2*n3*q12*q13-2*q13*q23+2*n3*q13*q23-q12*q33+n3*q12*q33-q23*q33+n3*q23*q33)+mbox1l(n1,1+n2,-1+n3,n4)*prf(-2*n2*q12-2*n2*q13-2*n2*q23-n2*q33,-2*q13+2*n3*q13-q33+n3*q33)+mbox1l(2+n1,-1+n2,-1+n3,n4)*prf(-(q13*q33)-n1*q13*q33,-2*q12*q13+2*n3*q12*q13-2*q13*q23+2*n3*q13*q23-q12*q33+n3*q12*q33-q23*q33+n3*q23*q33)+mbox1l(2+n1,n2,-2+n3,n4)*prf(2*q12*q33+2*n1*q12*q33+q13*q33+n1*q13*q33+q23*q33+n1*q23*q33,-2*q12*q13+2*n3*q12*q13-2*q13*q23+2*n3*q13*q23-q12*q33+n3*q12*q33-q23*q33+n3*q23*q33)+mbox1l(1+n1,1+n2,-2+n3,n4)*prf(2*n2*q12*q13+2*n2*q13^2+2*n2*q12*q23+4*n2*q13*q23+2*n2*q23^2+n2*q13*q33+n2*q23*q33,-2*q12*q13+2*n3*q12*q13-2*q13*q23+2*n3*q13*q23-q12*q33+n3*q12*q33-q23*q33+n3*q23*q33)+mbox1l(1+n1,n2,-1+n3,n4)*prf(-4*q12*q13-2*n1*q12*q13+2*n3*q12*q13-2*q13^2-2*n2*q13^2+2*n3*q13^2-2*q13*q23-2*n2*q13*q23+2*n3*q13*q23-3*q12*q33-2*n1*q12*q33+n2*q12*q33+n3*q12*q33-q13*q33-n2*q13*q33+n3*q13*q33-2*q23*q33-n1*q23*q33+n3*q23*q33,-2*q12*q13+2*n3*q12*q13-2*q13*q23+2*n3*q13*q23-q12*q33+n3*q12*q33-q23*q33+n3*q23*q33);
	Identify,ifmatch->jump mbox1l(n1?pos_,n2?pos_,n3?pos_,n4?{,>1}) = mbox1l(n1,n2,1+n3,-1+n4)*prf(n3,-1+n4)+mbox1l(1+n1,1+n2,n3,-2+n4)*prf(-2*n1*q12,-2*q13+2*n4*q13-q33+n4*q33)+mbox1l(1+n1,n2,n3,-1+n4)*prf(n1*q33,-2*q13+2*n4*q13-q33+n4*q33)+mbox1l(n1,1+n2,-1+n3,n4)*prf(2*q12+2*q13+2*q23+q33,2*q13+q33)+mbox1l(1+n1,1+n2,-1+n3,-1+n4)*prf(2*n1*q12-n1*q33,-2*q13+2*n4*q13-q33+n4*q33)+mbox1l(n1,2+n2,-1+n3,-1+n4)*prf(-2*q12-2*n2*q12-2*q13-2*n2*q13-2*q23-2*n2*q23-q33-n2*q33,-2*q13+2*n4*q13-q33+n4*q33)+mbox1l(n1,1+n2,n3,-1+n4)*prf(4*q12+2*n2*q12-2*n4*q12+2*q13+2*n2*q13-2*n3*q13+4*q23+2*n2*q23-2*n4*q23+q33+n2*q33-n3*q33,-2*q13+2*n4*q13-q33+n4*q33);
	Label jump;
	#call lrttMergeIndices(mbox1l)

*	Mapped Sectors:
	Identify mbox1l(n1?neg0_,n2?neg0_,n3?pos_,n4?neg0_) =
		mbox1l(0,0,n4,n3)*(-mbox1l(-1,0,0,0)+mbox1l(0,0,-1,0)+mbox1l(0,0,0,-1)+2*q13*mbox1l(0,0,0,0))^(-n1)*(-mbox1l(0,-1,0,0)+mbox1l(0,0,-1,0)+mbox1l(0,0,0,-1)-2*prf(q12+q23,1)*mbox1l(0,0,0,0))^(-n2);
	#call lrttMergeIndices(mbox1l)

	Identify mbox1l(n1?neg0_,n2?pos_,n3?neg0_,n4?neg0_) =
		mbox1l(0,n4,0,n2)*(mbox1l(0,-1,0,0)-mbox1l(0,0,-1,0)+mbox1l(0,0,0,-1)+2*prf(q12+q23,1)*mbox1l(0,0,0,0))^(-n3)*(-mbox1l(-1,0,0,0)+mbox1l(0,-1,0,0)+mbox1l(0,0,0,-1)+2*prf(q13+q23,1)*mbox1l(0,0,0,0))^(-n1);
	#call lrttMergeIndices(mbox1l)

	Identify mbox1l(n1?pos_,n2?neg0_,n3?neg0_,n4?neg0_) =
		mbox1l(n4,0,0,n1)*(mbox1l(-1,0,0,0)-mbox1l(0,0,-1,0)+mbox1l(0,0,0,-1)-2*q13*mbox1l(0,0,0,0))^(-n3)*(mbox1l(-1,0,0,0)-mbox1l(0,-1,0,0)+mbox1l(0,0,0,-1)-2*prf(2*q12+q13+q23,1)*mbox1l(0,0,0,0))^(-n2);
	#call lrttMergeIndices(mbox1l)


	#call lrttKin2Prf
	Identify M`j'^n1? = prf(M`j'^n1,1);
	#ifdef `MBOX1Lq33EQq44'
		Multiply replace_(q23,-q12-q13);
	#endif


*	Hide MIs:
	Identify mbox1l(0,0,0,1) = mbox1lm`j'm(0,0,0,1);
	Identify mbox1l(0,0,1,1) = mbox1lm`j'm(0,0,1,1);
	Identify mbox1l(0,1,0,1) = mbox1lm`j'm(0,1,0,1);
	Identify mbox1l(1,0,0,1) = mbox1lm`j'm(1,0,0,1);
	Identify mbox1l(1,1,0,0) = mbox1lm`j'm(1,1,0,0);
	Identify mbox1l(0,1,1,1) = mbox1lm`j'm(0,1,1,1);
	Identify mbox1l(1,0,1,1) = mbox1lm`j'm(1,0,1,1);
	Identify mbox1l(1,1,0,1) = mbox1lm`j'm(1,1,0,1);
	Identify mbox1l(1,1,1,0) = mbox1lm`j'm(1,1,1,0);
	Identify mbox1l(1,1,1,1) = mbox1lm`j'm(1,1,1,1);

*	Zero Sectors:
	Identify mbox1l(n1?neg0_,n2?neg0_,n3?neg0_,n4?neg0_) = 0;

	If (Count(mbox1l,1) > 0) Redefine red "0";
	.sort
#enddo


* Merge the extra ep-dependent rational polys into the rest, now that
* the reduction is done.
#message Merge tmpprf into prf...
Identify tmpprf(n1?,n2?) = prf(n1,n2);
.sort

* Check:
Drop;
Local check = test - (
       + mbox1lm1m(0,0,0,1) * (
          + prf(4*q33^3*M1^2 - q33^4 + 20*q13*q33^2*M1^2 - 4*q13*q33^3 - 16*
         q12*q33^2*M1^2 + 3*q12*q33^3 - 40*q12*q13*q33*M1^2 + 6*q12*q13*q33^2
          + 8*q12^2*q33*M1^2 + 16*q12^2*q13*M1^2 - 4*ep*q33^3*M1^2 + ep*q33^4
          - 20*ep*q13*q33^2*M1^2 + 4*ep*q13*q33^3 + 16*ep*q12*q33^2*M1^2 - 3*
         ep*q12*q33^3 + 40*ep*q12*q13*q33*M1^2 - 6*ep*q12*q13*q33^2 - 8*ep*
         q12^2*q33*M1^2 - 16*ep*q12^2*q13*M1^2,512*q13^2*q33*M1^10 - 256*q13^2
         *q33^2*M1^8 + 32*q13^2*q33^3*M1^6 + 256*q12*q33^2*M1^10 - 192*q12*
         q33^3*M1^8 + 48*q12*q33^4*M1^6 - 4*q12*q33^5*M1^4 + 512*q12*q13*q33*
         M1^10 - 512*q12*q13*q33^2*M1^8 + 160*q12*q13*q33^3*M1^6 - 16*q12*q13*
         q33^4*M1^4 - 256*q12*q13^2*M1^10 - 448*q12*q13^2*q33*M1^8 + 256*q12*
         q13^2*q33^2*M1^6 - 32*q12*q13^2*q33^3*M1^4 - 128*q12^2*q33*M1^10 - 64
         *q12^2*q33^2*M1^8 + 88*q12^2*q33^3*M1^6 - 24*q12^2*q33^4*M1^4 + 2*
         q12^2*q33^5*M1^2 - 256*q12^2*q13*M1^10 - 64*q12^2*q13*q33*M1^8 + 224*
         q12^2*q13*q33^2*M1^6 - 80*q12^2*q13*q33^3*M1^4 + 8*q12^2*q13*q33^4*
         M1^2 + 256*q12^2*q13^2*M1^8 + 64*q12^2*q13^2*q33*M1^6 - 64*q12^2*
         q13^2*q33^2*M1^4 + 8*q12^2*q13^2*q33^3*M1^2 + 64*q12^3*q33*M1^8 - 32*
         q12^3*q33^2*M1^6 + 4*q12^3*q33^3*M1^4 + 128*q12^3*q13*M1^8 - 96*q12^3
         *q13*q33*M1^6 + 16*q12^3*q13*q33^2*M1^4 - 64*q12^3*q13^2*M1^6 + 16*
         q12^3*q13^2*q33*M1^4)
          )

       + mbox1lm1m(0,0,1,1) * (
          + prf(q33^2 + 4*q13*q33 + 4*q13^2 - 2*ep*q33^2 - 8*ep*q13*q33 - 8*ep
         *q13^2,32*q13^3*M1^4 + 16*q12*q13*q33*M1^4 - 4*q12*q13*q33^2*M1^2 +
         32*q12*q13^2*M1^4 - 16*q12*q13^2*q33*M1^2 - 16*q12*q13^3*M1^2)
          )

       + mbox1lm1m(0,1,0,1) * (
          + prf(2*q13*q33^2 - q12*q33^2 - 2*q12*q13*q33 - 4*ep*q13*q33^2 + 2*
         ep*q12*q33^2 + 4*ep*q12*q13*q33,64*q12*q13^2*q33*M1^4 - 16*q12*q13^2*
         q33^2*M1^2 + 32*q12^2*q33^2*M1^4 - 16*q12^2*q33^3*M1^2 + 2*q12^2*
         q33^4 + 64*q12^2*q13*q33*M1^4 - 48*q12^2*q13*q33^2*M1^2 + 8*q12^2*q13
         *q33^3 - 32*q12^2*q13^2*M1^4 - 32*q12^2*q13^2*q33*M1^2 + 8*q12^2*
         q13^2*q33^2 - 16*q12^3*q33*M1^4 + 4*q12^3*q33^2*M1^2 - 32*q12^3*q13*
         M1^4 + 16*q12^3*q13*q33*M1^2 + 16*q12^3*q13^2*M1^2)
          )

       + mbox1lm1m(0,1,1,1) * (
          + prf( - 2*ep*q13^2,4*q12^2*q13^2 + 4*q12^2*q13*q33 - 8*q12^2*q13*
         M1^2 + q12^2*q33^2 - 4*q12^2*q33*M1^2 - 8*q12*q13^2*M1^2)
          )

       + mbox1lm1m(1,0,0,1) * (
          + prf( - 16*q13^2*q33^2*M1^4 + 4*q13^2*q33^3*M1^2 - 16*q12*q33^3*
         M1^4 + 8*q12*q33^4*M1^2 - q12*q33^5 - 40*q12*q13*q33^2*M1^4 + 26*q12*
         q13*q33^3*M1^2 - 4*q12*q13*q33^4 + 20*q12*q13^2*q33^2*M1^2 - 4*q12*
         q13^2*q33^3 + 8*q12^2*q33^2*M1^4 - 2*q12^2*q33^3*M1^2 + 16*q12^2*q13*
         q33*M1^4 - 8*q12^2*q13*q33^2*M1^2 - 8*q12^2*q13^2*q33*M1^2 + 32*ep*
         q13^2*q33^2*M1^4 - 8*ep*q13^2*q33^3*M1^2 + 32*ep*q12*q33^3*M1^4 - 16*
         ep*q12*q33^4*M1^2 + 2*ep*q12*q33^5 + 80*ep*q12*q13*q33^2*M1^4 - 52*ep
         *q12*q13*q33^3*M1^2 + 8*ep*q12*q13*q33^4 - 40*ep*q12*q13^2*q33^2*M1^2
          + 8*ep*q12*q13^2*q33^3 - 16*ep*q12^2*q33^2*M1^4 + 4*ep*q12^2*q33^3*
         M1^2 - 32*ep*q12^2*q13*q33*M1^4 + 16*ep*q12^2*q13*q33^2*M1^2 + 16*ep*
         q12^2*q13^2*q33*M1^2,512*q12*q13^3*q33*M1^8 - 256*q12*q13^3*q33^2*
         M1^6 + 32*q12*q13^3*q33^3*M1^4 + 256*q12^2*q13*q33^2*M1^8 - 192*q12^2
         *q13*q33^3*M1^6 + 48*q12^2*q13*q33^4*M1^4 - 4*q12^2*q13*q33^5*M1^2 +
         512*q12^2*q13^2*q33*M1^8 - 512*q12^2*q13^2*q33^2*M1^6 + 160*q12^2*
         q13^2*q33^3*M1^4 - 16*q12^2*q13^2*q33^4*M1^2 - 256*q12^2*q13^3*M1^8
          - 192*q12^2*q13^3*q33*M1^6 + 128*q12^2*q13^3*q33^2*M1^4 - 16*q12^2*
         q13^3*q33^3*M1^2 - 128*q12^3*q13*q33*M1^8 + 64*q12^3*q13*q33^2*M1^6
          - 8*q12^3*q13*q33^3*M1^4 - 256*q12^3*q13^2*M1^8 + 192*q12^3*q13^2*
         q33*M1^6 - 32*q12^3*q13^2*q33^2*M1^4 + 128*q12^3*q13^3*M1^6 - 32*
         q12^3*q13^3*q33*M1^4)
          )

       + mbox1lm1m(1,0,1,1) * (
          + prf(4*ep*q12*q13^2 + 4*ep*q12*q13*q33 - 8*ep*q12*q13*M1^2 + ep*q12
         *q33^2 - 4*ep*q12*q33*M1^2 - 4*ep*q13^2*M1^2, - 8*q12^2*q13^2*M1^2 -
         8*q12^2*q13*q33*M1^2 + 16*q12^2*q13*M1^4 - 2*q12^2*q33^2*M1^2 + 8*
         q12^2*q33*M1^4 + 16*q12*q13^2*M1^4)
          )

      + mbox1lm1m(1,1,0,0) * (
         + prf( - 4*q33^2*M1^2 + q33^3 - 12*q13*q33*M1^2 + 4*q13*q33^2 + 4*
        q12*q33*M1^2 - q12*q33^2 + 8*q12*q13*M1^2 - 2*q12*q13*q33 + 8*ep*
        q33^2*M1^2 - 2*ep*q33^3 + 24*ep*q13*q33*M1^2 - 8*ep*q13*q33^2 - 8*ep*
        q12*q33*M1^2 + 2*ep*q12*q33^2 - 16*ep*q12*q13*M1^2 + 4*ep*q12*q13*q33
        ,128*q13^2*q33*M1^6 - 32*q13^2*q33^2*M1^4 + 64*q12*q33^2*M1^6 - 32*
        q12*q33^3*M1^4 + 4*q12*q33^4*M1^2 + 128*q12*q13*q33*M1^6 - 96*q12*q13
        *q33^2*M1^4 + 16*q12*q13*q33^3*M1^2 - 64*q12*q13^2*M1^6 - 128*q12*
        q13^2*q33*M1^4 + 32*q12*q13^2*q33^2*M1^2 - 32*q12^2*q33*M1^6 - 24*
        q12^2*q33^2*M1^4 + 16*q12^2*q33^3*M1^2 - 2*q12^2*q33^4 - 64*q12^2*q13
        *M1^6 - 32*q12^2*q13*q33*M1^4 + 48*q12^2*q13*q33^2*M1^2 - 8*q12^2*q13
        *q33^3 + 64*q12^2*q13^2*M1^4 + 32*q12^2*q13^2*q33*M1^2 - 8*q12^2*
        q13^2*q33^2 + 16*q12^3*q33*M1^4 - 4*q12^3*q33^2*M1^2 + 32*q12^3*q13*
        M1^4 - 16*q12^3*q13*q33*M1^2 - 16*q12^3*q13^2*M1^2)
         )

      + mbox1lm1m(1,1,0,1) * (
         + prf(2*ep*q12*q13*q33 - 4*ep*q12*q13*M1^2 + ep*q12*q33^2 - 4*ep*q12
        *q33*M1^2 - 4*ep*q13*q33^2 + 8*ep*q13*q33*M1^2 - 2*ep*q33^3 + 8*ep*
        q33^2*M1^2,8*q12^2*q13^2*M1^2 + 8*q12^2*q13*q33*M1^2 - 16*q12^2*q13*
        M1^4 + 2*q12^2*q33^2*M1^2 - 8*q12^2*q33*M1^4 + 4*q12*q13^2*q33^2 - 16
        *q12*q13^2*q33*M1^2 - 16*q12*q13^2*M1^4 + 4*q12*q13*q33^3 - 24*q12*
        q13*q33^2*M1^2 + 32*q12*q13*q33*M1^4 + q12*q33^4 - 8*q12*q33^3*M1^2
         + 16*q12*q33^2*M1^4 - 8*q13^2*q33^2*M1^2 + 32*q13^2*q33*M1^4)
         )

      + mbox1lm1m(1,1,1,0) * (
         + prf(2*ep*q13, - 4*q12*q13^2 - 4*q12*q13*q33 + 8*q12*q13*M1^2 - q12
        *q33^2 + 4*q12*q33*M1^2 + 8*q13^2*M1^2)
         )

      + mbox1lm1m(1,1,1,1) * (
         + prf(q13*q33 + 2*q13^2 + 2*ep*q13*q33 + 4*ep*q13^2,8*q13^2*M1^2 + 4
        *q12*q33*M1^2 - q12*q33^2 + 8*q12*q13*M1^2 - 4*q12*q13*q33 - 4*q12*
        q13^2)
         )
	);

Print check;
.end
assert result("check") =~ expr("0")
*--#] jodavies_prf_1 :
*--#[ tueda_prf_1 :
#-
Off Statistics;

S ep,n1,...,n5;
CF Z,rat;
PolyRatFun rat;

#define N "10"

L F = Z(`N',`N',`N',`N',`N');

term;
  #do i=1,{`N'*3-2}
    id ifmatch->`i',Z(n1?pos_,n2?pos_,n3?pos_,n4?pos_,n5?pos_) =
      +Z(n1-1,n2,n3,n4,n5)*rat(-7+2*n5+n4+n3+n2+n1+3*ep,-3+n5+n2+n1+ep)
      +Z(n1,n2,n3,n4-1,n5)*rat(-7+2*n5+n4+n3+n2+n1+3*ep,-3+n5+n4+n3+ep)
      +Z(n1,n2,n3,n4,n5-1)*rat(3-n5-n3-n2-ep,-3+n5+n2+n1+ep)*rat(-4+n5+n3+n2+2*ep,-3+n5+n4+n3+ep);
    id Z(n1?pos_,n2?pos_,n3?pos_,n4?pos_,n5?pos_) =
      +Z(n1,n2-1,n3,n4,n5)*rat(-7+2*n5+n4+n3+n2+n1+3*ep,-3+n5+n2+n1+ep)
      +Z(n1,n2,n3-1,n4,n5)*rat(-7+2*n5+n4+n3+n2+n1+3*ep,-3+n5+n4+n3+ep)
      +Z(n1,n2,n3,n4,n5-1)*rat(3-n5-n4-n1-ep,-3+n5+n2+n1+ep)*rat(-4+n5+n4+n1+2*ep,-3+n5+n4+n3+ep);
 label `i';
    sort;
  #enddo
endterm;

#ifndef `EXACT'
.sort
PolyRatFun;
id Z(?a,0,?b) = replace_(ep,1/2);
id rat(n1?,n2?) = n1/n2;
#endif

P +s;
.end
assert result("F") =~ expr("+ 14680089444100552191986912125917036600599334564/4011728794505561362873666565")
*--#] tueda_prf_1 :
