+++
title = "Mesocrystal"
weight = 80
+++

## Mesocrystal particle

Mesocrystal is a crystal-like grain, defined by internal crystall
lattice and the outer shape.

The `Mesocrystal` object is created via

```python
# create mesocrystal
meso = ba.Mesocrystal(crystal, outer_shape)
```

and requires the objects `crystal` and `outer_shape` to be defined.

`outer_shape` is formfactor, describing shape and size of the mesocrystal, for example

```python 
outer_shape = ba.Cylinder(20*nm, 50*nm)
```

`crystal` is built from the node and lattice:

```python  
# Basis node
node = ba.Particle(material_node, formfactor)

# 3D lattice
lattice = ba.Lattice3D(lattice_vec_1, lattice_vec_2, lattice_vec_3)

# Crystal
crystal = ba.Crystal(node, lattice)   
```

Alternatively, `node` can be not just simple particle, but also another compositon:

```python  
node = ba.Compound()
```
or
```python  
node = ba.CoreAndShell(core, shell)
```
or even
```python  
node = ba.Mesocrystal(crystal_node, outer_shape_node)
```

[Example](/ref/sample/particle/ex/mesocrystal-particle)
