The `Default` trait was derived on an enum without specifying the default
variant.

Erroneous code example:

```compile_fail,E0665
#[derive(Default)]
enum Food {
    Sweet,
    Salty,
}
```

The `Default` cannot be derived on an enum for the simple reason that the
compiler doesn't know which value to pick by default whereas it can for a
struct as long as all its fields implement the `Default` trait as well.

For the case where the desired default variant has no payload, you can
annotate it with `#[default]` to derive it:

```
#[derive(Default)]
enum Food {
    #[default]
    Sweet,
    Salty,
}
```

In the case where the default variant does have a payload, you will have to
implement `Default` on your enum manually:

```
enum Food {
    Sweet(i32),
    Salty,
}

impl Default for Food {
    fn default() -> Food {
        Food::Sweet(1)
    }
}
```
