#cryptsetup 2.2.2

#variables
set -l seen __fish_seen_subcommand_from
set -l actions benchmark close config convert erase isLuks luksAddKey luksChangeKey luksConvertKey luksDump luksFormat luksHeaderBackup luksHeaderRestore luksKillSlot luksRemoveKey luksResume luksSuspend luksUUID open reencrypt repair resize status tcryptDump token

#actions
complete -c cryptsetup -x -n "not $seen $actions" -a "$actions"

#options
complete -c cryptsetup -l active-name -d "Override device autodetection of dm device to be reencrypted"
complete -c cryptsetup -l align-payload -d "Align payload at <n> sector boundaries - for luksFormat"
complete -c cryptsetup -l allow-discards -d "Allow discards (aka TRIM) requests for device"
complete -c cryptsetup -l batch-mode -s q -d "Do not ask for confirmation"
complete -c cryptsetup -l cipher -s c -d "The cipher used to encrypt the disk (see /proc/crypto)"
complete -c cryptsetup -l debug -d "Show debug messages"
complete -c cryptsetup -l debug-json -d "Show debug messages including JSON metadata"
complete -c cryptsetup -l decrypt -d "Decrypt LUKS2 device (remove encryption)"
complete -c cryptsetup -l deferred -d "Device removal is deferred until the last user closes it"
complete -c cryptsetup -l device-size -d "Use only specified device size (ignore rest of device). DANGEROUS!"
complete -c cryptsetup -l disable-keyring -d "Disable loading volume keys via kernel keyring"
complete -c cryptsetup -l disable-locks -d "Disable locking of on-disk metadata"
complete -c cryptsetup -l dump-master-key -d "Dump volume (master) key instead of keyslots info"
complete -c cryptsetup -l encrypt -d "Encrypt LUKS2 device (in-place encryption)"
complete -c cryptsetup -l force-password -d "Disable password quality check (if enabled)"
complete -c cryptsetup -l hash -s h -d "The hash used to create the encryption key from the passphrase"
complete -c cryptsetup -l header -d "Device or file with separated LUKS header"
complete -c cryptsetup -l header-backup-file -d "File with LUKS header and keyslots backup"
complete -c cryptsetup -l help -s '?' -d "Show help message"
complete -c cryptsetup -l hotzone-size -d "Maximal reencryption hotzone size"
complete -c cryptsetup -l init-only -d "Initialize LUKS2 reencryption in metadata only"
complete -c cryptsetup -l integrity -s I -d "Data integrity algorithm (LUKS2 only)"
complete -c cryptsetup -l integrity-no-journal -d "Disable journal for integrity device"
complete -c cryptsetup -l integrity-no-wipe -d "Do not wipe device after format"
complete -c cryptsetup -l iter-time -s i -d "PBKDF iteration time for LUKS (in ms)"
complete -c cryptsetup -l json-file -d "Read or write the json from or to a file"
complete -c cryptsetup -l key-description -d "Key description"
complete -c cryptsetup -l key-file -s d -d "Read the key from a file"
complete -c cryptsetup -l key-size -s s -d "The size of the encryption key"
complete -c cryptsetup -l key-slot -s S -d "Slot number for new key (default is first free)"
complete -c cryptsetup -l keyfile-offset -d "Number of bytes to skip in keyfile"
complete -c cryptsetup -l keyfile-size -s l -d "Limits the read from keyfile"
complete -c cryptsetup -l keyslot-cipher -d "LUKS2 keyslot: The cipher used for keyslot encryption"
complete -c cryptsetup -l keyslot-key-size -d "LUKS2 keyslot: The size of the encryption key"
complete -c cryptsetup -l label -d "Set label for the LUKS2 device"
complete -c cryptsetup -l luks2-keyslots-size -d "LUKS2 header keyslots area size"
complete -c cryptsetup -l luks2-metadata-size -d "LUKS2 header metadata area size"
complete -c cryptsetup -l master-key-file -d "Read the volume (master) key from file"
complete -c cryptsetup -l new-keyfile-offset -d "Number of bytes to skip in newly added keyfile"
complete -c cryptsetup -l new-keyfile-size -d "Limits the read from newly added keyfile"
complete -c cryptsetup -l offset -s o -d "The start offset in the backend device"
complete -c cryptsetup -l pbkdf -d "PBKDF algorithm (for LUKS2): argon2i, argon2id, pbkdf2"
complete -c cryptsetup -l pbkdf-force-iterations -d "PBKDF iterations cost (forced, disables benchmark)"
complete -c cryptsetup -l pbkdf-memory -d "PBKDF memory cost limit"
complete -c cryptsetup -l pbkdf-parallel -d "PBKDF parallel cost"
complete -c cryptsetup -l perf-same_cpu_crypt -d "Use dm-crypt same_cpu_crypt performance compatibility option"
complete -c cryptsetup -l perf-submit_from_crypt_cpus -d "Use dm-crypt submit_from_crypt_cpus performance compatibility option"
complete -c cryptsetup -l persistent -d "Set activation flags persistent for device"
complete -c cryptsetup -l priority -d "Keyslot priority: ignore, normal, prefer"
complete -c cryptsetup -l progress-frequency -d "Progress line update (in seconds)"
complete -c cryptsetup -l readonly -s r -d "Create a readonly mapping"
complete -c cryptsetup -l reduce-device-size -d "Reduce data device size (move data offset). DANGEROUS!"
complete -c cryptsetup -l refresh -d "Refresh (reactivate) device with new parameters"
complete -c cryptsetup -l resilience -d "Reencryption hotzone resilience type (checksum,journal,none)"
complete -c cryptsetup -l resilience-hash -d "Reencryption hotzone checksums hash"
complete -c cryptsetup -l resume-only -d "Resume initialized LUKS2 reencryption only"
complete -c cryptsetup -l sector-size -d "Encryption sector size (default: 512 bytes)"
complete -c cryptsetup -l serialize-memory-hard-pbkdf -d "Use global lock to serialize memory hard PBKDF (OOM workaround)"
complete -c cryptsetup -l shared -d "Share device with another non-overlapping crypt segment"
complete -c cryptsetup -l size -s b -d "The size of the device"
complete -c cryptsetup -l skip -s p -d "How many sectors of the encrypted data to skip at the beginning"
complete -c cryptsetup -l subsystem -d "Set subsystem label for the LUKS2 device"
complete -c cryptsetup -l tcrypt-backup -d "Use backup (secondary) TCRYPT header"
complete -c cryptsetup -l tcrypt-hidden -d "Use hidden header (hidden TCRYPT device)"
complete -c cryptsetup -l tcrypt-system -d "Device is system TCRYPT drive (with bootloader)"
complete -c cryptsetup -l test-passphrase -d "Do not activate device, just check passphrase"
complete -c cryptsetup -l timeout -s t -d "Timeout for interactive passphrase prompt (in seconds)"
complete -c cryptsetup -l token-id -d "Token number (default: any)"
complete -c cryptsetup -l token-only -d "Do not ask for passphrase if activation by token fails"
complete -c cryptsetup -l tries -s T -d "How often the input of the passphrase can be retried"
complete -c cryptsetup -l type -s M -d "Type of device metadata: luks, luks1, luks2, plain, loopaes, tcrypt"
complete -c cryptsetup -l unbound -d "Create unbound (no assigned data segment) LUKS2 keyslot"
complete -c cryptsetup -l usage -d "Display brief usage"
complete -c cryptsetup -l use-random -d "Use /dev/random for generating volume key"
complete -c cryptsetup -l use-urandom -d "Use /dev/urandom for generating volume key"
complete -c cryptsetup -l uuid -d "UUID for device to use"
complete -c cryptsetup -l veracrypt -d "Scan also for VeraCrypt compatible device"
complete -c cryptsetup -l veracrypt-pim -d "Personal Iteration Multiplier for VeraCrypt compatible device"
complete -c cryptsetup -l veracrypt-query-pim -d "Query Personal Iteration Multiplier for VeraCrypt compatible device"
complete -c cryptsetup -l verbose -s v -d "Shows more detailed error messages"
complete -c cryptsetup -l verify-passphrase -s y -d "Verifies the passphrase by asking for it twice"
complete -c cryptsetup -l version -s V -d "Print package version"
